import unittest
import smart_match

class TestLongestCommonSubstring(unittest.TestCase):
    
    def setUp(self):
        smart_match.use('Longest Common Substring')

    def test_similarity(self):
        self.assertEqual(smart_match.similarity('hello', 'low'), 0.4)
        self.assertEqual(smart_match.similarity('test string1', 'test string2'), 0.9166666666666666)
        self.assertEqual(smart_match.similarity('test', 'test string2'),  0.3333333333333333)
        self.assertEqual(smart_match.similarity('', 'test string2'),  0.0)
        self.assertEqual(smart_match.similarity('aaa bbb ccc ddd', 'aaa bbb ccc eee'),  0.8)
        self.assertEqual(smart_match.similarity('aaa bbb', 'aaa aaa'),   0.5714285714285714)
        self.assertEqual(smart_match.similarity('aaa', 'aaa aaa'),   0.42857142857142855)
        self.assertEqual(smart_match.similarity('a b c d', 'a b c e'),   0.8571428571428571)
        self.assertEqual(smart_match.similarity('uxyw', 'uyxw'),   0.25)
        self.assertEqual(smart_match.similarity('uxaayw', 'uyxw'),    0.16666666666666666)
        self.assertEqual(smart_match.similarity('transpose', 'tranpsose'),    0.4444444444444444)
        self.assertEqual(smart_match.similarity('Healed', 'Sealed'),    0.8333333333333334)
        self.assertEqual(smart_match.similarity('Healed', 'Healthy'),    0.5714285714285714)
        self.assertEqual(smart_match.similarity('Healed', 'Heard'),    0.5)
        self.assertEqual(smart_match.similarity('Healed', 'Help'),    0.3333333333333333)
        self.assertEqual(smart_match.similarity('Healed', 'Sold'),    0.16666666666666666)
        self.assertEqual(smart_match.similarity('Sam J Chapman', 'Samuel John Chapman'),    0.42105263157894735)
        self.assertEqual(smart_match.similarity('Sam Chapman', 'S Chapman'),    0.7272727272727273)
        self.assertEqual(smart_match.similarity('John Smith', 'Samuel John Chapman'),    0.2631578947368421)
        self.assertEqual(smart_match.similarity('John Smith', 'Sam Chapman'),    0.09090909090909091)
        self.assertEqual(smart_match.similarity('John Smith', 'Sam J Chapman'),    0.07692307692307693)
        self.assertEqual(smart_match.similarity('John Smith', 'S Chapman'),    0.1)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Web Database Applications with PHP & MySQL'),    0.5952380952380952)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Creating Database Web Applications with PHP and ASP'),    0.2549019607843137)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Building Database Applications on the Web Using PHP3'),    0.4230769230769231)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Building Web Database Applications with Visual Studio 6'),    0.45454545454545453)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Web Application Development With PHP'),    0.3333333333333333)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection'),    0.25287356321839083)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),    0.031746031746031744)
        self.assertEqual(smart_match.similarity('Web Database Applications', 'How to Find a Scholarship Online'),    0.0625)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Web Database Applications with PHP & MySQL'),   0.23809523809523808)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Creating Database Web Applications with PHP and ASP'),    0.19607843137254902)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Building Database Applications on the Web Using PHP3'),    0.19230769230769232)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Building Web Database Applications with Visual Studio 6'),    0.18181818181818182)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Web Application Development With PHP'),    0.25)
        self.assertEqual(smart_match.similarity('Web Aplications', 'WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection'),    0.11494252873563218)
        self.assertEqual(smart_match.similarity('Web Aplications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),     0.031746031746031744)
        self.assertEqual(smart_match.similarity('Web Aplications', 'How to Find a Scholarship Online'),     0.0625)

    def test_dissimilarity(self):
        self.assertEqual(smart_match.dissimilarity('hello', 'low'), 0.6)
        self.assertEqual(smart_match.dissimilarity('test string1', 'test string2'), 0.08333333333333337)
        self.assertEqual(smart_match.dissimilarity('test', 'test string2'), 0.6666666666666667)
        self.assertEqual(smart_match.dissimilarity('', 'test string2'), 1.0)
        self.assertEqual(smart_match.dissimilarity('aaa bbb ccc ddd', 'aaa bbb ccc eee'), 0.19999999999999996)
        self.assertEqual(smart_match.dissimilarity('aaa bbb', 'aaa aaa'), 0.4285714285714286)
        self.assertEqual(smart_match.dissimilarity('aaa', 'aaa aaa'), 0.5714285714285714)
        self.assertEqual(smart_match.dissimilarity('a b c d', 'a b c e'), 0.1428571428571429)
        self.assertEqual(smart_match.dissimilarity('uxyw', 'uyxw'), 0.75)
        self.assertEqual(smart_match.dissimilarity('uxaayw', 'uyxw'), 0.8333333333333334)
        self.assertEqual(smart_match.dissimilarity('transpose', 'tranpsose'), 0.5555555555555556)
        self.assertEqual(smart_match.dissimilarity('Healed', 'Sealed'), 0.16666666666666663)
        self.assertEqual(smart_match.dissimilarity('Healed', 'Healthy'), 0.4285714285714286)
        self.assertEqual(smart_match.dissimilarity('Healed', 'Heard'), 0.5)
        self.assertEqual(smart_match.dissimilarity('Healed', 'Help'), 0.6666666666666667)
        self.assertEqual(smart_match.dissimilarity('Healed', 'Sold'), 0.8333333333333334)
        self.assertEqual(smart_match.dissimilarity('Sam J Chapman', 'Samuel John Chapman'), 0.5789473684210527)
        self.assertEqual(smart_match.dissimilarity('Sam Chapman', 'S Chapman'), 0.2727272727272727)
        self.assertEqual(smart_match.dissimilarity('John Smith', 'Samuel John Chapman'), 0.736842105263158)
        self.assertEqual(smart_match.dissimilarity('John Smith', 'Sam Chapman'), 0.9090909090909091)
        self.assertEqual(smart_match.dissimilarity('John Smith', 'Sam J Chapman'), 0.9230769230769231)
        self.assertEqual(smart_match.dissimilarity('John Smith', 'S Chapman'),  0.9)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Web Database Applications with PHP & MySQL'),  0.40476190476190477)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Creating Database Web Applications with PHP and ASP'),  0.7450980392156863)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Building Database Applications on the Web Using PHP3'),  0.5769230769230769)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Building Web Database Applications with Visual Studio 6'),  0.5454545454545454)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Web Application Development With PHP'),  0.6666666666666667)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection'),  0.7471264367816092)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),  0.9682539682539683)
        self.assertEqual(smart_match.dissimilarity('Web Database Applications', 'How to Find a Scholarship Online'),  0.9375)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Web Database Applications with PHP & MySQL'),  0.7619047619047619)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Creating Database Web Applications with PHP and ASP'),  0.803921568627451)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Building Database Applications on the Web Using PHP3'),  0.8076923076923077)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Building Web Database Applications with Visual Studio 6'),  0.8181818181818181)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Web Application Development With PHP'),   0.75)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),    0.9682539682539683)
        self.assertEqual(smart_match.dissimilarity('Web Aplications', 'How to Find a Scholarship Online'),    0.9375)

    def test_distance(self):
        self.assertEqual(smart_match.distance('hello', 'low'), 4)
        self.assertEqual(smart_match.distance('test string1', 'test string2'), 2)
        self.assertEqual(smart_match.distance('test', 'test string2'), 8)
        self.assertEqual(smart_match.distance('', 'test string2'), 12)
        self.assertEqual(smart_match.distance('aaa bbb ccc ddd', 'aaa bbb ccc eee'),  6)
        self.assertEqual(smart_match.distance('aaa bbb', 'aaa aaa'),  6)
        self.assertEqual(smart_match.distance('aaa', 'aaa aaa'),  4)
        self.assertEqual(smart_match.distance('a b c d', 'a b c e'),  2)
        self.assertEqual(smart_match.distance('uxyw', 'uyxw'),  6)
        self.assertEqual(smart_match.distance('uxaayw', 'uyxw'),  8)
        self.assertEqual(smart_match.distance('transpose', 'tranpsose'),  10)
        self.assertEqual(smart_match.distance('Healed', 'Sealed'),  2)
        self.assertEqual(smart_match.distance('Healed', 'Healthy'),  5)
        self.assertEqual(smart_match.distance('Healed', 'Heard'),  5)
        self.assertEqual(smart_match.distance('Healed', 'Help'),  6)
        self.assertEqual(smart_match.distance('Healed', 'Sold'), 8)
        self.assertEqual(smart_match.distance('Sam J Chapman', 'Samuel John Chapman'), 16)
        self.assertEqual(smart_match.distance('Sam Chapman', 'S Chapman'), 4)
        self.assertEqual(smart_match.distance('John Smith', 'Samuel John Chapman'), 19)
        self.assertEqual(smart_match.distance('John Smith', 'Sam Chapman'), 19)
        self.assertEqual(smart_match.distance('John Smith', 'Sam J Chapman'), 21)
        self.assertEqual(smart_match.distance('John Smith', 'S Chapman'), 17)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Web Database Applications with PHP & MySQL'), 17)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Creating Database Web Applications with PHP and ASP'), 50)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Building Database Applications on the Web Using PHP3'), 33)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Building Web Database Applications with Visual Studio 6'), 30)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Web Application Development With PHP'), 37)
        self.assertEqual(smart_match.distance('Web Database Applications', 'WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection'), 68)
        self.assertEqual(smart_match.distance('Web Database Applications', 'Structural Assessment: The Role of Large and Full-Scale Testing'), 84)
        self.assertEqual(smart_match.distance('Web Database Applications', 'How to Find a Scholarship Online'), 53)
        self.assertEqual(smart_match.distance('Web Aplications', 'Web Database Applications with PHP & MySQL'),  37)
        self.assertEqual(smart_match.distance('Web Aplications', 'Creating Database Web Applications with PHP and ASP'),  46)
        self.assertEqual(smart_match.distance('Web Aplications', 'Building Database Applications on the Web Using PHP3'),  47)
        self.assertEqual(smart_match.distance('Web Aplications', 'Building Web Database Applications with Visual Studio 6'),  50)
        self.assertEqual(smart_match.distance('Web Aplications', 'Web Application Development With PHP'),   33)
        self.assertEqual(smart_match.distance('Web Aplications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),   74)
        self.assertEqual(smart_match.distance('Web Aplications', 'How to Find a Scholarship Online'),   43)

    def test_score(self):
        self.assertEqual(smart_match.score('hello', 'low'), 2)
        self.assertEqual(smart_match.score('test string1', 'test string2'), 11)
        self.assertEqual(smart_match.score('test', 'test string2'), 4)
        self.assertEqual(smart_match.score('', 'test string2'), 0)
        self.assertEqual(smart_match.score('aaa bbb ccc ddd', 'aaa bbb ccc eee'), 12)
        self.assertEqual(smart_match.score('aaa bbb', 'aaa aaa'), 4)
        self.assertEqual(smart_match.score('aaa', 'aaa aaa'), 3)
        self.assertEqual(smart_match.score('a b c d', 'a b c e'), 6)
        self.assertEqual(smart_match.score('uxyw', 'uyxw'), 1)
        self.assertEqual(smart_match.score('uxaayw', 'uyxw'), 1)
        self.assertEqual(smart_match.score('transpose', 'tranpsose'), 4)
        self.assertEqual(smart_match.score('Healed', 'Sealed'), 5)
        self.assertEqual(smart_match.score('Healed', 'Healthy'), 4)
        self.assertEqual(smart_match.score('Healed', 'Heard'), 3)
        self.assertEqual(smart_match.score('Healed', 'Help'), 2)
        self.assertEqual(smart_match.score('Healed', 'Sold'), 1)
        self.assertEqual(smart_match.score('Sam J Chapman', 'Samuel John Chapman'), 8)
        self.assertEqual(smart_match.score('Sam Chapman', 'S Chapman'), 8)
        self.assertEqual(smart_match.score('John Smith', 'Samuel John Chapman'), 5)
        self.assertEqual(smart_match.score('John Smith', 'Sam Chapman'), 1)
        self.assertEqual(smart_match.score('John Smith', 'Sam J Chapman'), 1)
        self.assertEqual(smart_match.score('John Smith', 'S Chapman'), 1)
        self.assertEqual(smart_match.score('Web Database Applications', 'Web Database Applications with PHP & MySQL'),  25)
        self.assertEqual(smart_match.score('Web Database Applications', 'Creating Database Web Applications with PHP and ASP'),  13)
        self.assertEqual(smart_match.score('Web Database Applications', 'Building Database Applications on the Web Using PHP3'),  22)
        self.assertEqual(smart_match.score('Web Database Applications', 'Building Web Database Applications with Visual Studio 6'),  25)
        self.assertEqual(smart_match.score('Web Database Applications', 'Web Application Development With PHP'),  12)
        self.assertEqual(smart_match.score('Web Database Applications', 'WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection'),  22)
        self.assertEqual(smart_match.score('Web Database Applications', 'Structural Assessment: The Role of Large and Full-Scale Testing'),  2)
        self.assertEqual(smart_match.score('Web Database Applications', 'How to Find a Scholarship Online'),  2)
        self.assertEqual(smart_match.score('Web Aplications', 'Web Database Applications with PHP & MySQL'),  10)
        self.assertEqual(smart_match.score('Web Aplications', 'Creating Database Web Applications with PHP and ASP'),  10)
        self.assertEqual(smart_match.score('Web Aplications', 'Building Database Applications on the Web Using PHP3'),  10)
        self.assertEqual(smart_match.score('Web Aplications', 'Building Web Database Applications with Visual Studio 6'),  10)
        self.assertEqual(smart_match.score('Web Aplications', 'Web Application Development With PHP'), 9)
        self.assertEqual(smart_match.score('Web Aplications', 'Structural Assessment: The Role of Large and Full-Scale Testing'), 2)
        self.assertEqual(smart_match.score('Web Aplications', 'How to Find a Scholarship Online'), 2)

if __name__ == '__main__':
    unittest.main()
