# Contributing

Thank you for your interest in contributing to ipoly! There are many ways to contribute, from reporting bugs, suggesting new features, or contributing code changes.

## Reporting bugs

If you find a bug in ipoly, please report it by [opening an issue](https://github.com/Danguilhen/ipoly/issues) on GitHub. When reporting a bug, please include the following information:

* A clear and descriptive title for the issue.
* A description of the problem, including any error messages you received.
* Steps to reproduce the problem, including any relevant code or configuration files.
* If possible, include a screenshot or video demonstrating the problem.

## Suggesting new features

If you have a suggestion for a new feature in ipoly, please [open an issue](https://github.com/Danguilhen/ipoly/issues) on GitHub. When making a suggestion, please include the following information:

* A clear and descriptive title for the issue.
* A description of the problem you're trying to solve or the use case you're trying to support.
* A description of your proposed solution, including any relevant code or configuration files.

## Contributing code changes

If you'd like to contribute code changes to ipoly, please follow these steps:

1. Fork the repository to your personal GitHub account.
2. Clone the repository to your local machine.
3. Create a new branch for your changes.
4. Make your changes, committing them to your branch as you go.
5. Push your branch to your personal GitHub account.
6. Open a pull request on the original repository.

Please note that before making a pull request, your code should pass the automated tests and adhere to the coding style enforced by pre-commit.

## Coding style

ipoly uses [pre-commit](https://pre-commit.com/) to enforce a consistent coding style. Before making a pull request, please run the pre-commit checks to ensure your code adheres to the style guide.

## Automated tests

ipoly uses [pytest](https://docs.pytest.org/en/latest/) and [doctest](https://docs.python.org/3/library/doctest.html) for automated testing. Before making a pull request, please make sure all tests pass. You can run the tests by running the following command:

```shell
pytest
```

## Documentation

ipoly uses [Sphinx](https://www.sphinx-doc.org/en/master/) for documentation. If you're making changes that affect the documentation, please make sure to update the documentation accordingly.
