# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-20 16:32
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Charge",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("card_last_4", models.CharField(blank=True, max_length=4)),
                ("card_kind", models.CharField(blank=True, max_length=50)),
                ("currency", models.CharField(default="usd", max_length=10)),
                (
                    "amount",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                (
                    "amount_refunded",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                ("description", models.TextField(blank=True)),
                ("paid", models.NullBooleanField()),
                ("disputed", models.NullBooleanField()),
                ("refunded", models.NullBooleanField()),
                ("captured", models.NullBooleanField()),
                ("fee", models.DecimalField(decimal_places=2, max_digits=9, null=True)),
                ("receipt_sent", models.BooleanField(default=False)),
                ("charge_created", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CurrentSubscription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("plan", models.CharField(max_length=100)),
                ("quantity", models.IntegerField()),
                ("start", models.DateTimeField()),
                ("status", models.CharField(max_length=25)),
                ("cancel_at_period_end", models.BooleanField(default=False)),
                ("canceled_at", models.DateTimeField(blank=True, null=True)),
                ("current_period_end", models.DateTimeField(blank=True, null=True)),
                ("current_period_start", models.DateTimeField(blank=True, null=True)),
                ("ended_at", models.DateTimeField(blank=True, null=True)),
                ("trial_end", models.DateTimeField(blank=True, null=True)),
                ("trial_start", models.DateTimeField(blank=True, null=True)),
                ("amount", models.DecimalField(decimal_places=2, max_digits=9)),
                ("currency", models.CharField(default="usd", max_length=10)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name="Customer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("card_fingerprint", models.CharField(blank=True, max_length=200)),
                ("card_last_4", models.CharField(blank=True, max_length=4)),
                ("card_kind", models.CharField(blank=True, max_length=50)),
                ("date_purged", models.DateTimeField(editable=False, null=True)),
                (
                    "user",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("kind", models.CharField(max_length=250)),
                ("livemode", models.BooleanField(default=False)),
                ("webhook_message", jsonfield.fields.JSONField()),
                ("validated_message", jsonfield.fields.JSONField(null=True)),
                ("valid", models.NullBooleanField()),
                ("processed", models.BooleanField(default=False)),
                (
                    "customer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="payments.Customer",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EventProcessingException",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.TextField()),
                ("message", models.CharField(max_length=500)),
                ("traceback", models.TextField()),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "event",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="payments.Event",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255)),
                ("attempted", models.NullBooleanField()),
                ("attempts", models.PositiveIntegerField(null=True)),
                ("closed", models.BooleanField(default=False)),
                ("paid", models.BooleanField(default=False)),
                ("period_end", models.DateTimeField()),
                ("period_start", models.DateTimeField()),
                ("subtotal", models.DecimalField(decimal_places=2, max_digits=9)),
                ("total", models.DecimalField(decimal_places=2, max_digits=9)),
                ("currency", models.CharField(default="usd", max_length=10)),
                ("date", models.DateTimeField()),
                ("charge", models.CharField(blank=True, max_length=50)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoices",
                        to="payments.Customer",
                    ),
                ),
            ],
            options={
                "ordering": ["-date"],
            },
        ),
        migrations.CreateModel(
            name="InvoiceItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("amount", models.DecimalField(decimal_places=2, max_digits=9)),
                ("currency", models.CharField(default="usd", max_length=10)),
                ("period_start", models.DateTimeField()),
                ("period_end", models.DateTimeField()),
                ("proration", models.BooleanField(default=False)),
                ("line_type", models.CharField(max_length=50)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("plan", models.CharField(blank=True, max_length=100)),
                ("quantity", models.IntegerField(null=True)),
                (
                    "invoice",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="items",
                        to="payments.Invoice",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Transfer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("stripe_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("amount", models.DecimalField(decimal_places=2, max_digits=9)),
                ("currency", models.CharField(default="usd", max_length=25)),
                ("status", models.CharField(max_length=25)),
                ("date", models.DateTimeField()),
                ("description", models.TextField(blank=True, null=True)),
                ("adjustment_count", models.IntegerField(null=True)),
                (
                    "adjustment_fees",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                (
                    "adjustment_gross",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                ("charge_count", models.IntegerField(null=True)),
                (
                    "charge_fees",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                (
                    "charge_gross",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                ("collected_fee_count", models.IntegerField(null=True)),
                (
                    "collected_fee_gross",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                ("net", models.DecimalField(decimal_places=2, max_digits=9, null=True)),
                ("refund_count", models.IntegerField(null=True)),
                (
                    "refund_fees",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                (
                    "refund_gross",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                ("validation_count", models.IntegerField(null=True)),
                (
                    "validation_fees",
                    models.DecimalField(decimal_places=2, max_digits=9, null=True),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="transfers",
                        to="payments.Event",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransferChargeFee",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.DecimalField(decimal_places=2, max_digits=9)),
                ("currency", models.CharField(default="usd", max_length=10)),
                ("application", models.TextField(blank=True, null=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("kind", models.CharField(max_length=150)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "transfer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="charge_fee_details",
                        to="payments.Transfer",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="currentsubscription",
            name="customer",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="current_subscription",
                to="payments.Customer",
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="customer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="charges",
                to="payments.Customer",
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="invoice",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="charges",
                to="payments.Invoice",
            ),
        ),
    ]
