"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6 } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        const cfDist = this.distribution.node.findChild('CFDistribution');
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: assosiation.lambdaFunction.functionArn,
        })));
    }
}
exports.StaticWebsite = StaticWebsite;
//# sourceMappingURL=data:application/json;base64,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