from ckan.plugins.interfaces import Interface


class IEmailAsUsername(Interface):

    def generate_username(email, autogenerated_username):
        """
        When implemented, this function can be used to override the
        logic that autogenerates usernames from emails.  The default
        logic for autogenerating usernames is taken from CKAN core:
           ckan.logic.action.create._get_random_username_from_email

        WARNING: This CKAN core logic reveals part of the user's email
        as their username.  In some cases this maybe considered a
        security threat.

        The user's email is provided as well as the autogenerated_username
        in the function arguments.  By altering the autogenerated_username
        arg you can chain logic across multiple plugins implementing this
        interface. Alternatively you can ignore the autogenerated_username
        arg, thereby overriding any existing logic entirely.

        """
        return autogenerated_username
