import os
import threading
import subprocess

from datetime import datetime

from ffmpeg_sdk import log


class FfmpegRecordThread(threading.Thread):

    def __init__(self, name, stream_url, out_file_path, video_duration=300, timeout=5000000, **kwargs):
        """
        :param name:
        :param stream_url: 流地址
        :param out_file_path:
        :param video_duration: 视频持续时间，默认持续 5 * 60 秒
        :param timeout: 超时断开连接，设定时间，默认5s,单位为微妙级
        :param kwargs:
        """
        super(FfmpegRecordThread, self).__init__(**kwargs)

        self.create_time = datetime.now()
        self.name = name
        self.stream_url = stream_url
        self.out_file_path = out_file_path
        self.video_duration = video_duration
        self.file_name_out_list = os.path.join(os.path.split(out_file_path)[0], name + '.txt')
        self.shell_cmd_mp4 = (
            'ffmpeg '
            '-y '                                     # 覆盖输出文件
            '-v info '
            '-rtbufsize 1m '
            '-rw_timeout {timeout} '                  # 超时断开连接，设定是5s
            '-i {stream_url} '                        # 输入视频文件或流等其他
            '-movflags faststart+frag_keyframe '      # 使mp4支持渐进式下载
            '-vcodec copy '                           # 原始编解码数据必须被拷贝
            '-acodec copy '                           # 设定声音编码，降低CPU使用
            '-f segment '                             # 输出流切片
            '-segment_format mp4 '                    # 流输出格式
            '-strftime 1 '                            # 设置切片名为生成切片的时间点
            '-segment_time {segment_time} '           # 流切分时长
            '-reset_timestamps 1 '                    # 每个切片都重新初始化时间戳
            '-segment_list {file_name_out_list} '     # 切片列表主文件名，输入是在文件写入完成之后
            '-segment_list_size 10 '                  # 列表文件长度
            '-segment_list_entry_prefix {out_path} '  # 写文件列表时写入每个切片路径的前置路径

            '{out_file} '                             # 输出文件名
        ).format(timeout=timeout,
                 stream_url=self.stream_url,
                 segment_time=video_duration,
                 file_name_out_list=self.file_name_out_list,
                 out_path=os.path.split(self.out_file_path)[0] + '/',
                 out_file=self.out_file_path)

        self.ffmpeg_proc = None

    def run(self):
        log.info(self.shell_cmd_mp4)
        self.ffmpeg_proc = subprocess.Popen(
            self.shell_cmd_mp4, shell=True,
            stdin=subprocess.PIPE,
            stdout=subprocess.PIPE, stderr=subprocess.PIPE, bufsize=1)

        # 实时打印ffmpeg日志
        return_code = self.ffmpeg_proc.poll()
        while return_code is None:
            # 这里会阻塞,所以不用获取所有的日志才返回，获取81个字节就可以返回了！
            line = self.ffmpeg_proc.stdout.readline(81).strip()

            log.debug('%s:%s', self.name, line)
            if 'Packet mismatch' in str(line):
                try:  # 发送退出信号，等待1s中
                    self.ffmpeg_proc.communicate(input='q'.encode(), timeout=1)
                except Exception as e:
                    break
            return_code = self.ffmpeg_proc.poll()

        self.ffmpeg_proc.kill()
        log.info('{}的ffmpeg exit.'.format(self.name))
