"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const cdk8s_plus_21_1 = require("cdk8s-plus-21");
const ts_deepmerge_1 = require("ts-deepmerge");
const deployment_1 = require("./deployment");
class MetaflowService extends cdk8s_1.Chart {
    constructor(scope, name, props) {
        super(scope, name);
        const defaultEnvVars = {
            MF_METADATA_DB_NAME: 'metaflow',
            MF_METADATA_DB_PORT: '5432',
            MF_METADATA_DB_PSWD: 'metaflow',
            MF_METADATA_DB_USER: 'metaflow',
            MF_METADATA_DB_HOST: 'release-name-postgresql',
        };
        const envVars = ts_deepmerge_1.default(defaultEnvVars, props.envVars ?? {});
        this.serviceAccount = props.serviceAccount || undefined;
        const apiObject = new deployment_1.MetaflowDeployment(this, 'metaflow-service-deployment', {
            namespace: props.namespace,
            serviceAccount: this.serviceAccount,
            initContainer: {
                name: 'migrate',
                port: 8082,
                image: `${props.initImage}:${props.initImageTag}`,
                command: ['/opt/latest/bin/python3', '/root/run_goose.py', '--only-if-empty-db'],
                imagePullPolicy: cdk8s_plus_21_1.ImagePullPolicy.IF_NOT_PRESENT,
            },
            container: {
                name: 'metaflow-service',
                port: 8080,
                image: `${props.image}:${props.imageTag}`,
                command: ['/opt/latest/bin/python3', '-m', 'services.metadata_service.server'],
                imagePullPolicy: cdk8s_plus_21_1.ImagePullPolicy.IF_NOT_PRESENT,
                liveness: cdk8s_plus_21_1.Probe.fromHttpGet('/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
                readiness: cdk8s_plus_21_1.Probe.fromHttpGet('/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
            },
            envVars: envVars,
        });
        apiObject.deployment.exposeViaService({ ...props.servicePort });
    }
}
exports.MetaflowService = MetaflowService;
_a = JSII_RTTI_SYMBOL_1;
MetaflowService[_a] = { fqn: "cdk8s-metaflow.MetaflowService", version: "0.0.10" };
//# sourceMappingURL=data:application/json;base64,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