"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowDeployment = void 0;
const cdk8s_plus_21_1 = require("cdk8s-plus-21");
const constructs_1 = require("constructs");
class MetaflowDeployment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.namespace = props.namespace || 'default';
        const serviceAccount = props.serviceAccount || undefined;
        this.deployment = new cdk8s_plus_21_1.Deployment(this, 'metaflow-deployment', {
            serviceAccount: serviceAccount,
            metadata: {
                namespace: this.namespace,
            },
            containers: [props.container],
            initContainers: props.initContainer ? [props.initContainer] : undefined,
        });
        if (props.envVars) {
            this.addEnvironmentVariables('container-env', this.deployment.containers[0], props.envVars);
        }
        if (props.initContainer && props.envVars) {
            this.addEnvironmentVariables('init-container-env', this.deployment.initContainers[0], props.envVars);
        }
    }
    addEnvironmentVariables(id, container, envVar) {
        const configMap = new cdk8s_plus_21_1.ConfigMap(this, id, {
            metadata: {
                name: id,
                namespace: this.namespace,
            },
            data: envVar,
        });
        for (const key in envVar) {
            container.env.addVariable(key, cdk8s_plus_21_1.EnvValue.fromConfigMap(configMap, key));
        }
    }
}
exports.MetaflowDeployment = MetaflowDeployment;
//# sourceMappingURL=data:application/json;base64,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