import { Container, ContainerProps, Deployment, IServiceAccount } from 'cdk8s-plus-21';
import { Construct } from 'constructs';
export interface MetaflowDeploymentProps {
    readonly namespace: string;
    readonly serviceAccount?: IServiceAccount;
    readonly container: ContainerProps;
    readonly initContainer?: ContainerProps;
    readonly envVars?: Record<string, string>;
}
export declare class MetaflowDeployment extends Construct {
    readonly deployment: Deployment;
    readonly namespace: string;
    constructor(scope: Construct, id: string, props: MetaflowDeploymentProps);
    addEnvironmentVariables(id: string, container: Container, envVar: Record<string, string>): void;
}
