"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmPostgresAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const ts_deepmerge_1 = require("ts-deepmerge");
class HelmPostgresAddon {
    constructor(props) {
        this.props = props;
    }
    get name() {
        return HelmPostgresAddon.NAME;
    }
    install(scope) {
        const defaultChartValues = {
            auth: {
                database: 'metaflow',
                password: 'metaflow',
                username: 'metaflow',
            },
        };
        const chartValues = ts_deepmerge_1.default(defaultChartValues, this.props.chartValues ?? {});
        new cdk8s_1.Helm(scope, 'postgres', {
            chart: 'bitnami/postgresql',
            releaseName: 'release-name-postgresql',
            helmFlags: ['--version', this.props.chartVersion, '-n', this.props.namespaceName],
            values: chartValues,
        });
        return scope;
    }
}
exports.HelmPostgresAddon = HelmPostgresAddon;
_a = JSII_RTTI_SYMBOL_1;
HelmPostgresAddon[_a] = { fqn: "cdk8s-metaflow.HelmPostgresAddon", version: "0.0.10" };
HelmPostgresAddon.NAME = 'helm-postgres';
//# sourceMappingURL=data:application/json;base64,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