"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalPostgresAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_plus_21_1 = require("cdk8s-plus-21");
const k8s_1 = require("../../imports/k8s");
class LocalPostgresAddon {
    constructor(props) {
        this.props = props;
    }
    get name() {
        return LocalPostgresAddon.NAME;
    }
    install(scope) {
        const namespace = this.props.namespaceName ?? 'default';
        const service = new cdk8s_plus_21_1.Service(scope, 'postgres-service', {
            metadata: {
                namespace: namespace,
                name: 'release-name-postgresql',
            },
            ports: [
                {
                    port: 5432,
                    targetPort: 5432,
                    protocol: cdk8s_plus_21_1.Protocol.TCP,
                },
            ],
            clusterIP: 'None',
        });
        new k8s_1.Endpoints(scope, 'postgres-local-endpoints', {
            metadata: {
                name: service.name,
                namespace: namespace,
            },
            subsets: [
                {
                    addresses: [
                        {
                            ip: this.props.endpointIp,
                        },
                    ],
                    ports: [
                        {
                            name: 'postgresql',
                            port: 5432,
                            protocol: 'TCP',
                        },
                    ],
                },
            ],
        });
        return scope;
    }
}
exports.LocalPostgresAddon = LocalPostgresAddon;
_a = JSII_RTTI_SYMBOL_1;
LocalPostgresAddon[_a] = { fqn: "cdk8s-metaflow.LocalPostgresAddon", version: "0.0.10" };
LocalPostgresAddon.NAME = 'postgres';
//# sourceMappingURL=data:application/json;base64,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