import * as ecr from 'aws-cdk-lib/aws-ecr';
import * as assets from 'aws-cdk-lib/aws-ecr-assets';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) The image repository types.
 *
 * @experimental
 */
export declare enum ImageRepositoryType {
    /**
     * (experimental) Amazon ECR Public.
     *
     * @experimental
     */
    ECR_PUBLIC = "ECR_PUBLIC",
    /**
     * (experimental) Amazon ECR.
     *
     * @experimental
     */
    ECR = "ECR"
}
/**
 * (experimental) The number of CPU units reserved for each instance of your App Runner service.
 *
 * @experimental
 */
export declare class Cpu {
    readonly unit: string;
    /**
     * (experimental) 1 vCPU.
     *
     * @experimental
     */
    static readonly ONE_VCPU: Cpu;
    /**
     * (experimental) 2 vCPU.
     *
     * @experimental
     */
    static readonly TWO_VCPU: Cpu;
    /**
     * (experimental) Custom CPU unit.
     *
     * @param unit custom CPU unit.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     * @experimental
     */
    static of(unit: string): Cpu;
    /**
     *
     * @param unit The unit of CPU.
     */
    private constructor();
}
/**
 * (experimental) The amount of memory reserved for each instance of your App Runner service.
 *
 * @experimental
 */
export declare class Memory {
    readonly unit: string;
    /**
     * (experimental) 2 GB(for 1 vCPU).
     *
     * @experimental
     */
    static readonly TWO_GB: Memory;
    /**
     * (experimental) 3 GB(for 1 vCPU).
     *
     * @experimental
     */
    static readonly THREE_GB: Memory;
    /**
     * (experimental) 4 GB(for 1 or 2 vCPU).
     *
     * @experimental
     */
    static readonly FOUR_GB: Memory;
    /**
     * (experimental) Custom Memory unit.
     *
     * @param unit custom Memory unit.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     * @experimental
     */
    static of(unit: string): Memory;
    /**
     *
     * @param unit The unit of memory.
     */
    private constructor();
}
/**
 * (experimental) The code runtimes.
 *
 * @experimental
 */
export declare class Runtime {
    readonly name: string;
    /**
     * (experimental) NodeJS 12.
     *
     * @experimental
     */
    static readonly NODEJS_12: Runtime;
    /**
     * (experimental) Python 3.
     *
     * @experimental
     */
    static readonly PYTHON_3: Runtime;
    /**
     * (experimental) Other runtimes.
     *
     * @param name runtime name.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     * @experimental
     */
    static of(name: string): Runtime;
    /**
     *
     * @param name The runtime name.
     */
    private constructor();
}
/**
 * (experimental) Result of binding `Source` into a `Service`.
 *
 * @experimental
 */
export interface SourceConfig {
    /**
     * (experimental) The image repository configuration (mutually exclusive  with `codeRepository`).
     *
     * @default - no image repository.
     * @experimental
     */
    readonly imageRepository?: ImageRepository;
    /**
     * (experimental) The ECR repository (required to grant the pull privileges for the iam role).
     *
     * @default - no ECR repository.
     * @experimental
     */
    readonly ecrRepository?: ecr.IRepository;
    /**
     * (experimental) The code repository configuration (mutually exclusive  with `imageRepository`).
     *
     * @default - no code repository.
     * @experimental
     */
    readonly codeRepository?: CodeRepositoryProps;
}
/**
 * (experimental) Properties of the Github repository for `Source.fromGitHub()`.
 *
 * @experimental
 */
export interface GithubRepositoryProps {
    /**
     * (experimental) The code configuration values.
     *
     * Will be ignored if configurationSource is `REPOSITORY`.
     *
     * @default - no values will be passed. The `apprunner.yaml` from the github reopsitory will be used instead.
     * @experimental
     */
    readonly codeConfigurationValues?: CodeConfigurationValues;
    /**
     * (experimental) The source of the App Runner configuration.
     *
     * @experimental
     */
    readonly configurationSource: ConfigurationSourceType;
    /**
     * (experimental) The location of the repository that contains the source code.
     *
     * @experimental
     */
    readonly repositoryUrl: string;
    /**
     * (experimental) The branch name that represents a specific version for the repository.
     *
     * @default main
     * @experimental
     */
    readonly branch?: string;
    /**
     * (experimental) ARN of the connection to Github.
     *
     * Only required for Github source.
     *
     * @experimental
     */
    readonly connection: GitHubConnection;
}
/**
 * (experimental) Properties of the image repository for `Source.fromEcrPublic()`.
 *
 * @experimental
 */
export interface EcrPublicProps {
    /**
     * (experimental) The image configuration for the image from ECR Public.
     *
     * @default - no image configuration will be passed. The default `port` will be 8080.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
     * @experimental
     */
    readonly imageConfiguration?: ImageConfiguration;
    /**
     * (experimental) The ECR Public image URI.
     *
     * @experimental
     */
    readonly imageIdentifier: string;
}
/**
 * (experimental) Properties of the image repository for `Source.fromEcr()`.
 *
 * @experimental
 */
export interface EcrProps {
    /**
     * (experimental) The image configuration for the image from ECR.
     *
     * @default - no image configuration will be passed. The default `port` will be 8080.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
     * @experimental
     */
    readonly imageConfiguration?: ImageConfiguration;
    /**
     * (experimental) Represents the ECR repository.
     *
     * @experimental
     */
    readonly repository: ecr.IRepository;
    /**
     * (experimental) Image tag.
     *
     * @default - 'latest'
     * @experimental
     */
    readonly tag?: string;
}
/**
 * (experimental) Properties of the image repository for `Source.fromAsset()`.
 *
 * @experimental
 */
export interface AssetProps {
    /**
     * (experimental) The image configuration for the image built from the asset.
     *
     * @default - no image configuration will be passed. The default `port` will be 8080.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
     * @experimental
     */
    readonly imageConfiguration?: ImageConfiguration;
    /**
     * (experimental) Represents the docker image asset.
     *
     * @experimental
     */
    readonly asset: assets.DockerImageAsset;
}
/**
 * (experimental) Represents the App Runner service source.
 *
 * @experimental
 */
export declare abstract class Source {
    /**
     * (experimental) Source from the GitHub repository.
     *
     * @experimental
     */
    static fromGitHub(props: GithubRepositoryProps): GithubSource;
    /**
     * (experimental) Source from the ECR repository.
     *
     * @experimental
     */
    static fromEcr(props: EcrProps): EcrSource;
    /**
     * (experimental) Source from the ECR Public repository.
     *
     * @experimental
     */
    static fromEcrPublic(props: EcrPublicProps): EcrPublicSource;
    /**
     * (experimental) Source from local assets.
     *
     * @experimental
     */
    static fromAsset(props: AssetProps): AssetSource;
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    abstract bind(scope: Construct): SourceConfig;
}
/**
 * (experimental) Represents the service source from a Github repository.
 *
 * @experimental
 */
export declare class GithubSource extends Source {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: GithubRepositoryProps);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope: Construct): SourceConfig;
}
/**
 * (experimental) Represents the service source from ECR.
 *
 * @experimental
 */
export declare class EcrSource extends Source {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: EcrProps);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope: Construct): SourceConfig;
}
/**
 * (experimental) Represents the service source from ECR Public.
 *
 * @experimental
 */
export declare class EcrPublicSource extends Source {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: EcrPublicProps);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope: Construct): SourceConfig;
}
/**
 * (experimental) Represents the source from local assets.
 *
 * @experimental
 */
export declare class AssetSource extends Source {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: AssetProps);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope: Construct): SourceConfig;
}
/**
 * (experimental) Describes the configuration that AWS App Runner uses to run an App Runner service using an image pulled from a source image repository.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html
 * @experimental
 */
export interface ImageConfiguration {
    /**
     * (experimental) The port that your application listens to in the container.
     *
     * @default 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) Environment variables that are available to your running App Runner service.
     *
     * @default - no environment variables
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) An optional command that App Runner runs to start the application in the source image.
     *
     * If specified, this command overrides the Docker image’s default start command.
     *
     * @default - no start command
     * @experimental
     */
    readonly startCommand?: string;
}
/**
 * (experimental) Describes a source image repository.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html
 * @experimental
 */
export interface ImageRepository {
    /**
     * (experimental) The identifier of the image.
     *
     * For `ECR_PUBLIC` imageRepositoryType, the identifier domain should
     * always be `public.ecr.aws`. For `ECR`, the pattern should be
     * `([0-9]{12}.dkr.ecr.[a-z\-]+-[0-9]{1}.amazonaws.com\/.*)`.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html for more details.
     * @experimental
     */
    readonly imageIdentifier: string;
    /**
     * (experimental) The type of the image repository.
     *
     * This reflects the repository provider and whether
     * the repository is private or public.
     *
     * @experimental
     */
    readonly imageRepositoryType: ImageRepositoryType;
    /**
     * (experimental) Configuration for running the identified image.
     *
     * @default - no image configuration will be passed. The default `port` will be 8080.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
     * @experimental
     */
    readonly imageConfiguration?: ImageConfiguration;
}
/**
 * (experimental) Identifies a version of code that AWS App Runner refers to within a source code repository.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html
 * @experimental
 */
export interface SourceCodeVersion {
    /**
     * (experimental) The type of version identifier.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) A source code version.
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) Properties of the CodeRepository.
 *
 * @experimental
 */
export interface CodeRepositoryProps {
    /**
     * (experimental) Configuration for building and running the service from a source code repository.
     *
     * @experimental
     */
    readonly codeConfiguration: CodeConfiguration;
    /**
     * (experimental) The location of the repository that contains the source code.
     *
     * @experimental
     */
    readonly repositoryUrl: string;
    /**
     * (experimental) The version that should be used within the source code repository.
     *
     * @experimental
     */
    readonly sourceCodeVersion: SourceCodeVersion;
    /**
     * (experimental) The App Runner connection for GitHub.
     *
     * @experimental
     */
    readonly connection: GitHubConnection;
}
/**
 * (experimental) Properties of the AppRunner Service.
 *
 * @experimental
 */
export interface ServiceProps {
    /**
     * (experimental) The source of the repository for the service.
     *
     * @experimental
     */
    readonly source: Source;
    /**
     * (experimental) The number of CPU units reserved for each instance of your App Runner service.
     *
     * @default Cpu.ONE_VCPU
     * @experimental
     */
    readonly cpu?: Cpu;
    /**
     * (experimental) The amount of memory reserved for each instance of your App Runner service.
     *
     * @default Memory.TWO_GB
     * @experimental
     */
    readonly memory?: Memory;
    /**
     * (experimental) The IAM role that grants the App Runner service access to a source repository.
     *
     * It's required for ECR image repositories (but not for ECR Public repositories).
     *
     * @default - generate a new access role.
     * @experimental
     */
    readonly accessRole?: iam.IRole;
    /**
     * (experimental) The IAM role that provides permissions to your App Runner service.
     *
     * These are permissions that your code needs when it calls any AWS APIs.
     *
     * @default - no instance role attached.
     * @experimental
     */
    readonly instanceRole?: iam.IRole;
    /**
     * (experimental) Name of the service.
     *
     * @default - auto-generated if undefined.
     * @experimental
     */
    readonly serviceName?: string;
}
/**
 * (experimental) The source of the App Runner configuration.
 *
 * @experimental
 */
export declare enum ConfigurationSourceType {
    /**
     * (experimental) App Runner reads configuration values from `the apprunner.yaml` file in the source code repository and ignores `configurationValues`.
     *
     * @experimental
     */
    REPOSITORY = "REPOSITORY",
    /**
     * (experimental) App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml` file in the source code repository.
     *
     * @experimental
     */
    API = "API"
}
/**
 * (experimental) Describes the configuration that AWS App Runner uses to build and run an App Runner service from a source code repository.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html
 * @experimental
 */
export interface CodeConfiguration {
    /**
     * (experimental) The basic configuration for building and running the App Runner service.
     *
     * Use it to quickly launch an App Runner service without providing a apprunner.yaml file in the
     * source code repository (or ignoring the file if it exists).
     *
     * @default - not specified. Use `apprunner.yaml` instead.
     * @experimental
     */
    readonly configurationValues?: CodeConfigurationValues;
    /**
     * (experimental) The source of the App Runner configuration.
     *
     * @experimental
     */
    readonly configurationSource: ConfigurationSourceType;
}
/**
 * (experimental) Describes the basic configuration needed for building and running an AWS App Runner service.
 *
 * This type doesn't support the full set of possible configuration options. Fur full configuration capabilities,
 * use a `apprunner.yaml` file in the source code repository.
 *
 * @experimental
 */
export interface CodeConfigurationValues {
    /**
     * (experimental) The command App Runner runs to build your application.
     *
     * @default - no build command.
     * @experimental
     */
    readonly buildCommand?: string;
    /**
     * (experimental) The port that your application listens to in the container.
     *
     * @default 8080
     * @experimental
     */
    readonly port?: string;
    /**
     * (experimental) A runtime environment type for building and running an App Runner service.
     *
     * It represents
     * a programming language runtime.
     *
     * @experimental
     */
    readonly runtime: Runtime;
    /**
     * (experimental) The environment variables that are available to your running App Runner service.
     *
     * @default - no environment variables.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The command App Runner runs to start your application.
     *
     * @default - no start command.
     * @experimental
     */
    readonly startCommand?: string;
}
/**
 * (experimental) Represents the App Runner connection that enables the App Runner service to connect to a source repository.
 *
 * It's required for GitHub code repositories.
 *
 * @experimental
 */
export declare class GitHubConnection {
    /**
     * (experimental) Using existing App Runner connection by specifying the connection ARN.
     *
     * @param arn connection ARN.
     * @returns Connection
     * @experimental
     */
    static fromConnectionArn(arn: string): GitHubConnection;
    /**
     * (experimental) The ARN of the Connection for App Runner service to connect to the repository.
     *
     * @experimental
     */
    readonly connectionArn: string;
    /**
     * @experimental
     */
    constructor(arn: string);
}
/**
 * (experimental) Attributes for the App Runner Service.
 *
 * @experimental
 */
export interface ServiceAttributes {
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly serviceName: string;
    /**
     * (experimental) The ARN of the service.
     *
     * @experimental
     */
    readonly serviceArn: string;
    /**
     * (experimental) The URL of the service.
     *
     * @experimental
     */
    readonly serviceUrl: string;
    /**
     * (experimental) The status of the service.
     *
     * @experimental
     */
    readonly serviceStatus: string;
}
/**
 * (experimental) Represents the App Runner Service.
 *
 * @experimental
 */
export interface IService extends cdk.IResource {
    /**
     * (experimental) The Name of the service.
     *
     * @experimental
     */
    readonly serviceName: string;
    /**
     * (experimental) The ARN of the service.
     *
     * @experimental
     */
    readonly serviceArn: string;
}
/**
 * (experimental) The App Runner Service.
 *
 * @experimental
 */
export declare class Service extends cdk.Resource {
    /**
     * (experimental) Import from service name.
     *
     * @experimental
     */
    static fromServiceName(scope: Construct, id: string, serviceName: string): IService;
    /**
     * (experimental) Import from service attributes.
     *
     * @experimental
     */
    static fromServiceAttributes(scope: Construct, id: string, attrs: ServiceAttributes): IService;
    private readonly props;
    private accessRole?;
    private source;
    /**
     * (experimental) The ARN of the Service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceArn: string;
    /**
     * (experimental) The ID of the Service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceId: string;
    /**
     * (experimental) The URL of the Service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceUrl: string;
    /**
     * (experimental) The status of the Service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceStatus: string;
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ServiceProps);
    private renderAuthenticationConfiguration;
    private renderCodeConfiguration;
    private renderCodeConfigurationValues;
    private renderImageRepository;
    private generateDefaultRole;
}
