from dynamicforms import fields, serializers
from dynamicforms.viewsets import ModelViewSet
from examples.enum_field import EnumField
from examples.models import CalendarReminder


class RemindersSerializer(serializers.ModelSerializer):
    template_context = dict(url_reverse="calendar-reminder")
    form_titles = {
        "table": "Reminders",
        "new": "New reminder",
        "edit": "Editing reminder",
    }

    id = fields.AutoGeneratedField(read_only=False, required=False)
    event = fields.AutoGeneratedField(display=serializers.DisplayMode.SUPPRESS, required=False, write_only=True)
    type = EnumField(CalendarReminder.RType)
    unit = EnumField(CalendarReminder.Unit)

    class Meta:
        model = CalendarReminder
        fields = ("id", "event", "type", "quantity", "unit")


class CalendarRemindersViewSet(ModelViewSet):
    queryset = CalendarReminder.objects.all()
    serializer_class = RemindersSerializer
