# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TeamMemberArgs', 'TeamMember']

@pulumi.input_type
class TeamMemberArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[str],
                 team_id: pulumi.Input[str],
                 user_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a TeamMember resource.
        :param pulumi.Input[str] role: Either MEMBER or MAINTAINER.
        :param pulumi.Input[str] team_id: The GraphQL ID of the team to add to/remove from.
        :param pulumi.Input[str] user_id: The GraphQL ID of the user to add/remove.
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "team_id", team_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        Either MEMBER or MAINTAINER.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[str]:
        """
        The GraphQL ID of the team to add to/remove from.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        The GraphQL ID of the user to add/remove.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _TeamMemberState:
    def __init__(__self__, *,
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TeamMember resources.
        :param pulumi.Input[str] role: Either MEMBER or MAINTAINER.
        :param pulumi.Input[str] team_id: The GraphQL ID of the team to add to/remove from.
        :param pulumi.Input[str] user_id: The GraphQL ID of the user to add/remove.
        :param pulumi.Input[str] uuid: The UUID for the team membership.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Either MEMBER or MAINTAINER.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GraphQL ID of the team to add to/remove from.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GraphQL ID of the user to add/remove.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID for the team membership.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


class TeamMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: team_member

        This resource allows manage team membership for existing organization users.

        The user must already be part of the organization to which you are managing team membership. This will not invite a new user to the organization.

        Buildkite Documentation: https://buildkite.com/docs/pipelines/permissions

        Note: You must first enable Teams on your organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        team = buildkite.Team("team",
            privacy="VISIBLE",
            default_team=True,
            default_member_role="MEMBER")
        a_smith = buildkite.TeamMember("aSmith",
            role="MEMBER",
            team_id=team.id,
            user_id="VXNlci0tLWRlOTdmMjBiLWJkZmMtNGNjOC1hOTcwLTY1ODNiZTk2ZGEyYQ==")
        ```

        ## Import

        Team members can be imported using the GraphQL ID of the membership. Note this is different to the ID of the user.

        ```sh
         $ pulumi import buildkite:index/teamMember:TeamMember a_smith VGVhbU1lbWJlci0tLTVlZDEyMmY2LTM2NjQtNDI1MS04YzMwLTc4NjRiMDdiZDQ4Zg==
        ```

         To find the ID of a team member you are trying to import you can use the GraphQL snippet below. A link to this snippet can also be found at https://buildkite.com/user/graphql/console/c6a2cc65-dc59-49df-95c6-7167b68dbd5d. You will need fo fill in the organization slug and search terms for teams and members. Both search terms work on the name of the associated object. graphql query {

         organization(slug"") {

         teams(first2, search"") {

         edges {

         node {

         members(first2, search"") {

         edges {

         node {

         id

         }

         }

         }

         }

         }

         }

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: Either MEMBER or MAINTAINER.
        :param pulumi.Input[str] team_id: The GraphQL ID of the team to add to/remove from.
        :param pulumi.Input[str] user_id: The GraphQL ID of the user to add/remove.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: team_member

        This resource allows manage team membership for existing organization users.

        The user must already be part of the organization to which you are managing team membership. This will not invite a new user to the organization.

        Buildkite Documentation: https://buildkite.com/docs/pipelines/permissions

        Note: You must first enable Teams on your organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        team = buildkite.Team("team",
            privacy="VISIBLE",
            default_team=True,
            default_member_role="MEMBER")
        a_smith = buildkite.TeamMember("aSmith",
            role="MEMBER",
            team_id=team.id,
            user_id="VXNlci0tLWRlOTdmMjBiLWJkZmMtNGNjOC1hOTcwLTY1ODNiZTk2ZGEyYQ==")
        ```

        ## Import

        Team members can be imported using the GraphQL ID of the membership. Note this is different to the ID of the user.

        ```sh
         $ pulumi import buildkite:index/teamMember:TeamMember a_smith VGVhbU1lbWJlci0tLTVlZDEyMmY2LTM2NjQtNDI1MS04YzMwLTc4NjRiMDdiZDQ4Zg==
        ```

         To find the ID of a team member you are trying to import you can use the GraphQL snippet below. A link to this snippet can also be found at https://buildkite.com/user/graphql/console/c6a2cc65-dc59-49df-95c6-7167b68dbd5d. You will need fo fill in the organization slug and search terms for teams and members. Both search terms work on the name of the associated object. graphql query {

         organization(slug"") {

         teams(first2, search"") {

         edges {

         node {

         members(first2, search"") {

         edges {

         node {

         id

         }

         }

         }

         }

         }

         }

         } }

        :param str resource_name: The name of the resource.
        :param TeamMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamMemberArgs.__new__(TeamMemberArgs)

            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["uuid"] = None
        super(TeamMember, __self__).__init__(
            'buildkite:index/teamMember:TeamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None) -> 'TeamMember':
        """
        Get an existing TeamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: Either MEMBER or MAINTAINER.
        :param pulumi.Input[str] team_id: The GraphQL ID of the team to add to/remove from.
        :param pulumi.Input[str] user_id: The GraphQL ID of the user to add/remove.
        :param pulumi.Input[str] uuid: The UUID for the team membership.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamMemberState.__new__(_TeamMemberState)

        __props__.__dict__["role"] = role
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["uuid"] = uuid
        return TeamMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Either MEMBER or MAINTAINER.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The GraphQL ID of the team to add to/remove from.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The GraphQL ID of the user to add/remove.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        The UUID for the team membership.
        """
        return pulumi.get(self, "uuid")

