# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'PipelineProviderSettings',
    'PipelineTeam',
]

@pulumi.output_type
class PipelineProviderSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildBranches":
            suggest = "build_branches"
        elif key == "buildPullRequestForks":
            suggest = "build_pull_request_forks"
        elif key == "buildPullRequestLabelsChanged":
            suggest = "build_pull_request_labels_changed"
        elif key == "buildPullRequestReadyForReview":
            suggest = "build_pull_request_ready_for_review"
        elif key == "buildPullRequests":
            suggest = "build_pull_requests"
        elif key == "buildTags":
            suggest = "build_tags"
        elif key == "cancelDeletedBranchBuilds":
            suggest = "cancel_deleted_branch_builds"
        elif key == "filterCondition":
            suggest = "filter_condition"
        elif key == "filterEnabled":
            suggest = "filter_enabled"
        elif key == "prefixPullRequestForkBranchNames":
            suggest = "prefix_pull_request_fork_branch_names"
        elif key == "publishBlockedAsPending":
            suggest = "publish_blocked_as_pending"
        elif key == "publishCommitStatus":
            suggest = "publish_commit_status"
        elif key == "publishCommitStatusPerStep":
            suggest = "publish_commit_status_per_step"
        elif key == "pullRequestBranchFilterConfiguration":
            suggest = "pull_request_branch_filter_configuration"
        elif key == "pullRequestBranchFilterEnabled":
            suggest = "pull_request_branch_filter_enabled"
        elif key == "separatePullRequestStatuses":
            suggest = "separate_pull_request_statuses"
        elif key == "skipPullRequestBuildsForExistingCommits":
            suggest = "skip_pull_request_builds_for_existing_commits"
        elif key == "triggerMode":
            suggest = "trigger_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineProviderSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineProviderSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineProviderSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_branches: Optional[bool] = None,
                 build_pull_request_forks: Optional[bool] = None,
                 build_pull_request_labels_changed: Optional[bool] = None,
                 build_pull_request_ready_for_review: Optional[bool] = None,
                 build_pull_requests: Optional[bool] = None,
                 build_tags: Optional[bool] = None,
                 cancel_deleted_branch_builds: Optional[bool] = None,
                 filter_condition: Optional[str] = None,
                 filter_enabled: Optional[bool] = None,
                 prefix_pull_request_fork_branch_names: Optional[bool] = None,
                 publish_blocked_as_pending: Optional[bool] = None,
                 publish_commit_status: Optional[bool] = None,
                 publish_commit_status_per_step: Optional[bool] = None,
                 pull_request_branch_filter_configuration: Optional[str] = None,
                 pull_request_branch_filter_enabled: Optional[bool] = None,
                 separate_pull_request_statuses: Optional[bool] = None,
                 skip_pull_request_builds_for_existing_commits: Optional[bool] = None,
                 trigger_mode: Optional[str] = None):
        """
        :param bool build_branches: Whether to create builds when branches are pushed.
        :param bool build_pull_request_forks: Whether to create builds for pull requests from third-party forks.
        :param bool build_pull_request_labels_changed: Whether to create builds for pull requests when labels are added or removed.
        :param bool build_pull_requests: Whether to create builds for commits that are part of a Pull Request.
        :param bool build_tags: Whether to create builds when tags are pushed.
        :param bool cancel_deleted_branch_builds: A boolean to enable automatically cancelling any running builds for a branch if the branch is deleted.
        :param str filter_condition: The condition to evaluate when deciding if a build should run. More details available in [the documentation](https://buildkite.com/docs/pipelines/conditionals#conditionals-in-pipelines)
        :param bool filter_enabled: [true/false] Whether to filter builds to only run when the condition in `filter_condition` is true
        :param bool prefix_pull_request_fork_branch_names: Prefix branch names for third-party fork builds to ensure they don't trigger branch conditions. For example, the `master` branch from `some-user` will become `some-user:master`.
        :param bool publish_blocked_as_pending: The status to use for blocked builds. Pending can be used with [required status checks](https://help.github.com/en/articles/enabling-required-status-checks) to prevent merging pull requests with blocked builds.
        :param bool publish_commit_status: Whether to update the status of commits in Bitbucket or GitHub.
        :param bool publish_commit_status_per_step: Whether to create a separate status for each job in a build, allowing you to see the status of each job directly in Bitbucket or GitHub.
        :param str pull_request_branch_filter_configuration: The branch filtering pattern. Only pull requests on branches matching this pattern will cause builds to be created.
        :param bool pull_request_branch_filter_enabled: Whether to limit the creation of builds to specific branches or patterns.
        :param bool separate_pull_request_statuses: Whether to create a separate status for pull request builds, allowing you to require a passing pull request build in your [required status checks](https://help.github.com/en/articles/enabling-required-status-checks) in GitHub.
        :param bool skip_pull_request_builds_for_existing_commits: Whether to skip creating a new build for a pull request if an existing build for the commit and branch already exists.
        :param str trigger_mode: What type of event to trigger builds on. Must be one of:
        """
        if build_branches is not None:
            pulumi.set(__self__, "build_branches", build_branches)
        if build_pull_request_forks is not None:
            pulumi.set(__self__, "build_pull_request_forks", build_pull_request_forks)
        if build_pull_request_labels_changed is not None:
            pulumi.set(__self__, "build_pull_request_labels_changed", build_pull_request_labels_changed)
        if build_pull_request_ready_for_review is not None:
            pulumi.set(__self__, "build_pull_request_ready_for_review", build_pull_request_ready_for_review)
        if build_pull_requests is not None:
            pulumi.set(__self__, "build_pull_requests", build_pull_requests)
        if build_tags is not None:
            pulumi.set(__self__, "build_tags", build_tags)
        if cancel_deleted_branch_builds is not None:
            pulumi.set(__self__, "cancel_deleted_branch_builds", cancel_deleted_branch_builds)
        if filter_condition is not None:
            pulumi.set(__self__, "filter_condition", filter_condition)
        if filter_enabled is not None:
            pulumi.set(__self__, "filter_enabled", filter_enabled)
        if prefix_pull_request_fork_branch_names is not None:
            pulumi.set(__self__, "prefix_pull_request_fork_branch_names", prefix_pull_request_fork_branch_names)
        if publish_blocked_as_pending is not None:
            pulumi.set(__self__, "publish_blocked_as_pending", publish_blocked_as_pending)
        if publish_commit_status is not None:
            pulumi.set(__self__, "publish_commit_status", publish_commit_status)
        if publish_commit_status_per_step is not None:
            pulumi.set(__self__, "publish_commit_status_per_step", publish_commit_status_per_step)
        if pull_request_branch_filter_configuration is not None:
            pulumi.set(__self__, "pull_request_branch_filter_configuration", pull_request_branch_filter_configuration)
        if pull_request_branch_filter_enabled is not None:
            pulumi.set(__self__, "pull_request_branch_filter_enabled", pull_request_branch_filter_enabled)
        if separate_pull_request_statuses is not None:
            pulumi.set(__self__, "separate_pull_request_statuses", separate_pull_request_statuses)
        if skip_pull_request_builds_for_existing_commits is not None:
            pulumi.set(__self__, "skip_pull_request_builds_for_existing_commits", skip_pull_request_builds_for_existing_commits)
        if trigger_mode is not None:
            pulumi.set(__self__, "trigger_mode", trigger_mode)

    @property
    @pulumi.getter(name="buildBranches")
    def build_branches(self) -> Optional[bool]:
        """
        Whether to create builds when branches are pushed.
        """
        return pulumi.get(self, "build_branches")

    @property
    @pulumi.getter(name="buildPullRequestForks")
    def build_pull_request_forks(self) -> Optional[bool]:
        """
        Whether to create builds for pull requests from third-party forks.
        """
        return pulumi.get(self, "build_pull_request_forks")

    @property
    @pulumi.getter(name="buildPullRequestLabelsChanged")
    def build_pull_request_labels_changed(self) -> Optional[bool]:
        """
        Whether to create builds for pull requests when labels are added or removed.
        """
        return pulumi.get(self, "build_pull_request_labels_changed")

    @property
    @pulumi.getter(name="buildPullRequestReadyForReview")
    def build_pull_request_ready_for_review(self) -> Optional[bool]:
        return pulumi.get(self, "build_pull_request_ready_for_review")

    @property
    @pulumi.getter(name="buildPullRequests")
    def build_pull_requests(self) -> Optional[bool]:
        """
        Whether to create builds for commits that are part of a Pull Request.
        """
        return pulumi.get(self, "build_pull_requests")

    @property
    @pulumi.getter(name="buildTags")
    def build_tags(self) -> Optional[bool]:
        """
        Whether to create builds when tags are pushed.
        """
        return pulumi.get(self, "build_tags")

    @property
    @pulumi.getter(name="cancelDeletedBranchBuilds")
    def cancel_deleted_branch_builds(self) -> Optional[bool]:
        """
        A boolean to enable automatically cancelling any running builds for a branch if the branch is deleted.
        """
        return pulumi.get(self, "cancel_deleted_branch_builds")

    @property
    @pulumi.getter(name="filterCondition")
    def filter_condition(self) -> Optional[str]:
        """
        The condition to evaluate when deciding if a build should run. More details available in [the documentation](https://buildkite.com/docs/pipelines/conditionals#conditionals-in-pipelines)
        """
        return pulumi.get(self, "filter_condition")

    @property
    @pulumi.getter(name="filterEnabled")
    def filter_enabled(self) -> Optional[bool]:
        """
        [true/false] Whether to filter builds to only run when the condition in `filter_condition` is true
        """
        return pulumi.get(self, "filter_enabled")

    @property
    @pulumi.getter(name="prefixPullRequestForkBranchNames")
    def prefix_pull_request_fork_branch_names(self) -> Optional[bool]:
        """
        Prefix branch names for third-party fork builds to ensure they don't trigger branch conditions. For example, the `master` branch from `some-user` will become `some-user:master`.
        """
        return pulumi.get(self, "prefix_pull_request_fork_branch_names")

    @property
    @pulumi.getter(name="publishBlockedAsPending")
    def publish_blocked_as_pending(self) -> Optional[bool]:
        """
        The status to use for blocked builds. Pending can be used with [required status checks](https://help.github.com/en/articles/enabling-required-status-checks) to prevent merging pull requests with blocked builds.
        """
        return pulumi.get(self, "publish_blocked_as_pending")

    @property
    @pulumi.getter(name="publishCommitStatus")
    def publish_commit_status(self) -> Optional[bool]:
        """
        Whether to update the status of commits in Bitbucket or GitHub.
        """
        return pulumi.get(self, "publish_commit_status")

    @property
    @pulumi.getter(name="publishCommitStatusPerStep")
    def publish_commit_status_per_step(self) -> Optional[bool]:
        """
        Whether to create a separate status for each job in a build, allowing you to see the status of each job directly in Bitbucket or GitHub.
        """
        return pulumi.get(self, "publish_commit_status_per_step")

    @property
    @pulumi.getter(name="pullRequestBranchFilterConfiguration")
    def pull_request_branch_filter_configuration(self) -> Optional[str]:
        """
        The branch filtering pattern. Only pull requests on branches matching this pattern will cause builds to be created.
        """
        return pulumi.get(self, "pull_request_branch_filter_configuration")

    @property
    @pulumi.getter(name="pullRequestBranchFilterEnabled")
    def pull_request_branch_filter_enabled(self) -> Optional[bool]:
        """
        Whether to limit the creation of builds to specific branches or patterns.
        """
        return pulumi.get(self, "pull_request_branch_filter_enabled")

    @property
    @pulumi.getter(name="separatePullRequestStatuses")
    def separate_pull_request_statuses(self) -> Optional[bool]:
        """
        Whether to create a separate status for pull request builds, allowing you to require a passing pull request build in your [required status checks](https://help.github.com/en/articles/enabling-required-status-checks) in GitHub.
        """
        return pulumi.get(self, "separate_pull_request_statuses")

    @property
    @pulumi.getter(name="skipPullRequestBuildsForExistingCommits")
    def skip_pull_request_builds_for_existing_commits(self) -> Optional[bool]:
        """
        Whether to skip creating a new build for a pull request if an existing build for the commit and branch already exists.
        """
        return pulumi.get(self, "skip_pull_request_builds_for_existing_commits")

    @property
    @pulumi.getter(name="triggerMode")
    def trigger_mode(self) -> Optional[str]:
        """
        What type of event to trigger builds on. Must be one of:
        """
        return pulumi.get(self, "trigger_mode")


@pulumi.output_type
class PipelineTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: str,
                 slug: str):
        """
        :param str access_level: The level of access to grant. Must be one of `READ_ONLY`, `BUILD_AND_READ` or `MANAGE_BUILD_AND_READ`.
        :param str slug: The buildkite slug of the team.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        The level of access to grant. Must be one of `READ_ONLY`, `BUILD_AND_READ` or `MANAGE_BUILD_AND_READ`.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        The buildkite slug of the team.
        """
        return pulumi.get(self, "slug")


