import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Creates a Project Access Token in GitLab
 *
 * @schema CfnAccessTokenProps
 */
export interface CfnAccessTokenProps {
    /**
     * The name of the Project Access Token to create.
     *
     * @schema CfnAccessTokenProps#Name
     */
    readonly name: string;
    /**
     * The ID (numeric) of the project for which this Access Token is created. The project should exist and the user creating the Access Token should have rights to do this on this project.
     *
     * @schema CfnAccessTokenProps#ProjectId
     */
    readonly projectId: number;
    /**
     * A valid access level. Default value is 40 (Maintainer). Other allowed values are 10 (Guest), 20 (Reporter), and 30 (Developer).
     *
     * @schema CfnAccessTokenProps#AccessLevel
     */
    readonly accessLevel?: number;
    /**
     * The scopes this Project Access Token will be used for. The list of supported scopes is in the official GitLab documentation here: https://docs.gitlab.com/ee/user/project/settings/project_access_tokens.html#scopes-for-a-project-access-token .
     *
     * @schema CfnAccessTokenProps#Scopes
     */
    readonly scopes: string[];
}
/**
 * Converts an object of type 'CfnAccessTokenProps' to JSON representation.
 */
export declare function toJson_CfnAccessTokenProps(obj: CfnAccessTokenProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `GitLab::Projects::AccessToken`
 *
 * @cloudformationResource GitLab::Projects::AccessToken
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnAccessToken extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::AccessToken";
    /**
     * Resource props.
     */
    readonly props: CfnAccessTokenProps;
    /**
     * Attribute `GitLab::Projects::AccessToken.Id`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Create a new `GitLab::Projects::AccessToken`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAccessTokenProps);
}
