import * as codebuild from '@aws-cdk/aws-codebuild';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for CodeBuildStartBuild.
 *
 * @stability stable
 */
export interface CodeBuildStartBuildProps extends sfn.TaskStateBaseProps {
    /**
     * CodeBuild project to start.
     *
     * @stability stable
     */
    readonly project: codebuild.IProject;
    /**
     * A set of environment variables to be used for this build only.
     *
     * @default - the latest environment variables already defined in the build project.
     * @stability stable
     */
    readonly environmentVariablesOverride?: {
        [name: string]: codebuild.BuildEnvironmentVariable;
    };
}
/**
 * Start a CodeBuild Build as a task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-codebuild.html
 * @stability stable
 */
export declare class CodeBuildStartBuild extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CodeBuildStartBuildProps);
    private configurePolicyStatements;
    /**
     * Provides the CodeBuild StartBuild service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
    private serializeEnvVariables;
}
