# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *
from ._inputs import *
import pulumi_aws

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 public: pulumi.Input[bool],
                 encryption: Optional[pulumi.Input['BucketEncryptionArgsArgs']] = None,
                 replication: Optional[pulumi.Input['BucketReplicationArgsArgs']] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningStateArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgsArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[bool] public: Set to true to allow policies that may provide access to anyone.
        :param pulumi.Input['BucketEncryptionArgsArgs'] encryption: Configures encryption parameters for the bucket
        :param pulumi.Input['BucketReplicationArgsArgs'] replication: Configures replication parameters for the bucket
        :param pulumi.Input['BucketVersioningStateArgs'] versioning: Set a certain versioning mode for bucket objects
        :param pulumi.Input['BucketWebsiteArgsArgs'] website: Configures a static webpage using bucket files
        """
        pulumi.set(__self__, "public", public)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def public(self) -> pulumi.Input[bool]:
        """
        Set to true to allow policies that may provide access to anyone.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: pulumi.Input[bool]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['BucketEncryptionArgsArgs']]:
        """
        Configures encryption parameters for the bucket
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['BucketEncryptionArgsArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input['BucketReplicationArgsArgs']]:
        """
        Configures replication parameters for the bucket
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input['BucketReplicationArgsArgs']]):
        pulumi.set(self, "replication", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningStateArgs']]:
        """
        Set a certain versioning mode for bucket objects
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningStateArgs']]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgsArgs']]:
        """
        Configures a static webpage using bucket files
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgsArgs']]):
        pulumi.set(self, "website", value)


class Bucket(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgsArgs']]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 replication: Optional[pulumi.Input[pulumi.InputType['BucketReplicationArgsArgs']]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningStateArgs']] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgsArgs']]] = None,
                 __props__=None):
        """
        Cloud Toolkit component for Bcukets. Creates a Simple Bucket for object storage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BucketEncryptionArgsArgs']] encryption: Configures encryption parameters for the bucket
        :param pulumi.Input[bool] public: Set to true to allow policies that may provide access to anyone.
        :param pulumi.Input[pulumi.InputType['BucketReplicationArgsArgs']] replication: Configures replication parameters for the bucket
        :param pulumi.Input['BucketVersioningStateArgs'] versioning: Set a certain versioning mode for bucket objects
        :param pulumi.Input[pulumi.InputType['BucketWebsiteArgsArgs']] website: Configures a static webpage using bucket files
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloud Toolkit component for Bcukets. Creates a Simple Bucket for object storage

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgsArgs']]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 replication: Optional[pulumi.Input[pulumi.InputType['BucketReplicationArgsArgs']]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningStateArgs']] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["encryption"] = encryption
            if public is None and not opts.urn:
                raise TypeError("Missing required property 'public'")
            __props__.__dict__["public"] = public
            __props__.__dict__["replication"] = replication
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["bucket"] = None
            __props__.__dict__["bucket_encryption"] = None
            __props__.__dict__["bucket_ownership"] = None
            __props__.__dict__["bucket_public_access"] = None
            __props__.__dict__["bucket_public_access_policy"] = None
            __props__.__dict__["bucket_versioning"] = None
            __props__.__dict__["read_only_bucket_policy"] = None
            __props__.__dict__["replication_config"] = None
            __props__.__dict__["replication_policy_attachment"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["write_bucket_policy"] = None
        super(Bucket, __self__).__init__(
            'cloud-toolkit-aws:storage:Bucket',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output['pulumi_aws.s3.BucketV2']:
        """
        Instance of our Bucket
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketEncryption")
    def bucket_encryption(self) -> pulumi.Output[Optional['pulumi_aws.s3.BucketServerSideEncryptionConfigurationV2']]:
        """
        Configuration for controlling bucket encryption
        """
        return pulumi.get(self, "bucket_encryption")

    @property
    @pulumi.getter(name="bucketOwnership")
    def bucket_ownership(self) -> pulumi.Output['pulumi_aws.s3.BucketOwnershipControls']:
        """
        Enforce that bucket owner is all bucket objects
        """
        return pulumi.get(self, "bucket_ownership")

    @property
    @pulumi.getter(name="bucketPublicAccess")
    def bucket_public_access(self) -> pulumi.Output['pulumi_aws.s3.BucketPublicAccessBlock']:
        """
        Controls that IAM policies complies with bucket visibility (public or private)
        """
        return pulumi.get(self, "bucket_public_access")

    @property
    @pulumi.getter(name="bucketPublicAccessPolicy")
    def bucket_public_access_policy(self) -> pulumi.Output[Optional['pulumi_aws.s3.BucketPolicy']]:
        """
        Policy to make public all objects if bucket visibility is public
        """
        return pulumi.get(self, "bucket_public_access_policy")

    @property
    @pulumi.getter(name="bucketVersioning")
    def bucket_versioning(self) -> pulumi.Output['pulumi_aws.s3.BucketVersioningV2']:
        """
        Configuration for controlling bucket versioning
        """
        return pulumi.get(self, "bucket_versioning")

    @property
    @pulumi.getter(name="readOnlyBucketPolicy")
    def read_only_bucket_policy(self) -> pulumi.Output['pulumi_aws.iam.Policy']:
        """
        Policy for read-only users
        """
        return pulumi.get(self, "read_only_bucket_policy")

    @property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> pulumi.Output[Optional['pulumi_aws.s3.BucketReplicationConfig']]:
        """
        Configuration to perform bucket replication
        """
        return pulumi.get(self, "replication_config")

    @property
    @pulumi.getter(name="replicationPolicyAttachment")
    def replication_policy_attachment(self) -> pulumi.Output[Optional['pulumi_aws.iam.RolePolicyAttachment']]:
        """
        Policy attachments to perform bucket replication
        """
        return pulumi.get(self, "replication_policy_attachment")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output['pulumi_aws.iam.Role']:
        """
        Required role for managing bucket
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional['pulumi_aws.s3.BucketWebsiteConfigurationV2']]:
        """
        Configuration to setup a website
        """
        return pulumi.get(self, "website")

    @property
    @pulumi.getter(name="writeBucketPolicy")
    def write_bucket_policy(self) -> pulumi.Output['pulumi_aws.iam.Policy']:
        """
        Policy for write users
        """
        return pulumi.get(self, "write_bucket_policy")

