# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *
import pulumi_aws

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgsArgs']]]] = None,
                 enabled_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input['OrganizationPoliciesArgsArgs']] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgsArgs']]] accounts: The list of AWS Account to be configured in the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_policies: The list of enabled Organizations Policies in the organization.
        :param pulumi.Input[str] feature_set: The FeatureSet in the Organization..
        :param pulumi.Input[str] organization_id: The organization ID to import the Organization in the stack. If not set a new AWS Organization will be created. Defaults to undefined.
        :param pulumi.Input['OrganizationPoliciesArgsArgs'] policies: The Organization policies to be applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] services: The list of AWS Service Access Principals enabled in the organization.
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if enabled_policies is not None:
            pulumi.set(__self__, "enabled_policies", enabled_policies)
        if feature_set is not None:
            pulumi.set(__self__, "feature_set", feature_set)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgsArgs']]]]:
        """
        The list of AWS Account to be configured in the Organization.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgsArgs']]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="enabledPolicies")
    def enabled_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of enabled Organizations Policies in the organization.
        """
        return pulumi.get(self, "enabled_policies")

    @enabled_policies.setter
    def enabled_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_policies", value)

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[pulumi.Input[str]]:
        """
        The FeatureSet in the Organization..
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_set", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID to import the Organization in the stack. If not set a new AWS Organization will be created. Defaults to undefined.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['OrganizationPoliciesArgsArgs']]:
        """
        The Organization policies to be applied.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['OrganizationPoliciesArgsArgs']]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AWS Service Access Principals enabled in the organization.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "services", value)


class Organization(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationAccountArgsArgs']]]]] = None,
                 enabled_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[pulumi.InputType['OrganizationPoliciesArgsArgs']]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Organization is the component that configure the AWS Orgazination, AWS Accounts and AWS Organization Policies.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationAccountArgsArgs']]]] accounts: The list of AWS Account to be configured in the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_policies: The list of enabled Organizations Policies in the organization.
        :param pulumi.Input[str] feature_set: The FeatureSet in the Organization..
        :param pulumi.Input[str] organization_id: The organization ID to import the Organization in the stack. If not set a new AWS Organization will be created. Defaults to undefined.
        :param pulumi.Input[pulumi.InputType['OrganizationPoliciesArgsArgs']] policies: The Organization policies to be applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] services: The list of AWS Service Access Principals enabled in the organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrganizationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Organization is the component that configure the AWS Orgazination, AWS Accounts and AWS Organization Policies.

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OrganizationAccountArgsArgs']]]]] = None,
                 enabled_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[pulumi.InputType['OrganizationPoliciesArgsArgs']]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["accounts"] = accounts
            __props__.__dict__["enabled_policies"] = enabled_policies
            __props__.__dict__["feature_set"] = feature_set
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["policies"] = policies
            __props__.__dict__["services"] = services
            __props__.__dict__["account_ids"] = None
            __props__.__dict__["account_providers"] = None
            __props__.__dict__["organization"] = None
            __props__.__dict__["organizational_units"] = None
            __props__.__dict__["policy_attachments"] = None
        super(Organization, __self__).__init__(
            'cloud-toolkit-aws:landingzone:Organization',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of AWS Accounts inside the Organization.
        """
        return pulumi.get(self, "account_ids")

    @property
    @pulumi.getter(name="accountProviders")
    def account_providers(self) -> pulumi.Output[Sequence['outputs.OrganizationAccountProviderMapping']]:
        """
        The list of AWS Provider for the managed accounts by this component.
        """
        return pulumi.get(self, "account_providers")

    @property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Sequence['outputs.AccountMappingArgs']]:
        """
        The list of Accounts.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output['pulumi_aws.organizations.Organization']:
        """
        The AWS Organization.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> pulumi.Output[Sequence['outputs.OrganizationalUnitMapping']]:
        """
        The list Organizatoinal Units.
        """
        return pulumi.get(self, "organizational_units")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['pulumi_aws.organizations.Policy']]:
        """
        The list of Policies used in the Organization.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="policyAttachments")
    def policy_attachments(self) -> pulumi.Output[Sequence['pulumi_aws.organizations.PolicyAttachment']]:
        """
        The list of Policy Attachments used in the Organization.
        """
        return pulumi.get(self, "policy_attachments")

