# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *
import pulumi_aws

__all__ = ['IamTrustedAccountArgs', 'IamTrustedAccount']

@pulumi.input_type
class IamTrustedAccountArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input['IamTrustedAccountRoleArgsArgs']]],
                 trusting_account_id: pulumi.Input[str],
                 trusting_account_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a IamTrustedAccount resource.
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "trusting_account_id", trusting_account_id)
        pulumi.set(__self__, "trusting_account_name", trusting_account_name)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input['IamTrustedAccountRoleArgsArgs']]]:
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input['IamTrustedAccountRoleArgsArgs']]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="trustingAccountId")
    def trusting_account_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "trusting_account_id")

    @trusting_account_id.setter
    def trusting_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "trusting_account_id", value)

    @property
    @pulumi.getter(name="trustingAccountName")
    def trusting_account_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "trusting_account_name")

    @trusting_account_name.setter
    def trusting_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "trusting_account_name", value)


class IamTrustedAccount(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IamTrustedAccountRoleArgsArgs']]]]] = None,
                 trusting_account_id: Optional[pulumi.Input[str]] = None,
                 trusting_account_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IamTrustedAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamTrustedAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamTrustedAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamTrustedAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamTrustedAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IamTrustedAccountRoleArgsArgs']]]]] = None,
                 trusting_account_id: Optional[pulumi.Input[str]] = None,
                 trusting_account_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamTrustedAccountArgs.__new__(IamTrustedAccountArgs)

            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if trusting_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'trusting_account_id'")
            __props__.__dict__["trusting_account_id"] = trusting_account_id
            if trusting_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'trusting_account_name'")
            __props__.__dict__["trusting_account_name"] = trusting_account_name
            __props__.__dict__["role_group_policies"] = None
            __props__.__dict__["role_groups"] = None
        super(IamTrustedAccount, __self__).__init__(
            'cloud-toolkit-aws:landingzone:IamTrustedAccount',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="roleGroupPolicies")
    def role_group_policies(self) -> pulumi.Output[Sequence['outputs.IamTrustedAccountRoleGroupPolicyMapping']]:
        return pulumi.get(self, "role_group_policies")

    @property
    @pulumi.getter(name="roleGroups")
    def role_groups(self) -> pulumi.Output[Sequence['outputs.IamTrustedAccountRoleGroupMapping']]:
        return pulumi.get(self, "role_groups")

