# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
import pulumi_kubernetes

__all__ = ['ApplicationAddonArgs', 'ApplicationAddon']

@pulumi.input_type
class ApplicationAddonArgs:
    def __init__(__self__, *,
                 k8s_provider: pulumi.Input['pulumi_kubernetes.Provider'],
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 create_namespace: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ApplicationAddon resource.
        :param pulumi.Input['pulumi_kubernetes.Provider'] k8s_provider: Kubernetes provider used by Pulumi.
        :param pulumi.Input[str] name: The name of the instanced component.
        :param pulumi.Input[str] namespace: The Namespace name where the addon will be installed.
        :param pulumi.Input[bool] create_namespace: Create a new Namespace using the given name.
        """
        pulumi.set(__self__, "k8s_provider", k8s_provider)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if create_namespace is not None:
            pulumi.set(__self__, "create_namespace", create_namespace)

    @property
    @pulumi.getter(name="k8sProvider")
    def k8s_provider(self) -> pulumi.Input['pulumi_kubernetes.Provider']:
        """
        Kubernetes provider used by Pulumi.
        """
        return pulumi.get(self, "k8s_provider")

    @k8s_provider.setter
    def k8s_provider(self, value: pulumi.Input['pulumi_kubernetes.Provider']):
        pulumi.set(self, "k8s_provider", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the instanced component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Namespace name where the addon will be installed.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="createNamespace")
    def create_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        Create a new Namespace using the given name.
        """
        return pulumi.get(self, "create_namespace")

    @create_namespace.setter
    def create_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_namespace", value)


class ApplicationAddon(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 k8s_provider: Optional[pulumi.Input['pulumi_kubernetes.Provider']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        IRSAAddon is a component that deploy an HelmChart as ArgoCD Application.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] create_namespace: Create a new Namespace using the given name.
        :param pulumi.Input['pulumi_kubernetes.Provider'] k8s_provider: Kubernetes provider used by Pulumi.
        :param pulumi.Input[str] name: The name of the instanced component.
        :param pulumi.Input[str] namespace: The Namespace name where the addon will be installed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationAddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IRSAAddon is a component that deploy an HelmChart as ArgoCD Application.

        :param str resource_name: The name of the resource.
        :param ApplicationAddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationAddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 k8s_provider: Optional[pulumi.Input['pulumi_kubernetes.Provider']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationAddonArgs.__new__(ApplicationAddonArgs)

            __props__.__dict__["create_namespace"] = create_namespace
            if k8s_provider is None and not opts.urn:
                raise TypeError("Missing required property 'k8s_provider'")
            __props__.__dict__["k8s_provider"] = k8s_provider
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
        super(ApplicationAddon, __self__).__init__(
            'cloud-toolkit-aws:kubernetes:ApplicationAddon',
            resource_name,
            __props__,
            opts,
            remote=True)

