# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *
from ._inputs import *
import pulumi_aws
import pulumi_random

__all__ = ['MysqlArgs', 'Mysql']

@pulumi.input_type
class MysqlArgs:
    def __init__(__self__, *,
                 database: pulumi.Input['MysqlDatabaseArgsArgs'],
                 version: pulumi.Input['MysqlVersion'],
                 backup: Optional[pulumi.Input['MysqlBackupArgsArgs']] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input['MysqlNetworkingArgsArgs']] = None,
                 storage: Optional[pulumi.Input['MysqlStorageArgsArgs']] = None):
        """
        The set of arguments for constructing a Mysql resource.
        :param pulumi.Input['MysqlDatabaseArgsArgs'] database: Configuration parameters for the database instance
        :param pulumi.Input['MysqlVersion'] version: Version for database instance
        :param pulumi.Input['MysqlBackupArgsArgs'] backup: Backup configuration parameters for the database instance
        :param pulumi.Input[str] instance: Instance type to run the database instance
        :param pulumi.Input['MysqlNetworkingArgsArgs'] networking: Network configuration parameters for the database instance
        :param pulumi.Input['MysqlStorageArgsArgs'] storage: Storage configuration parameters for the database instance
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "version", version)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input['MysqlDatabaseArgsArgs']:
        """
        Configuration parameters for the database instance
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input['MysqlDatabaseArgsArgs']):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input['MysqlVersion']:
        """
        Version for database instance
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input['MysqlVersion']):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['MysqlBackupArgsArgs']]:
        """
        Backup configuration parameters for the database instance
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['MysqlBackupArgsArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type to run the database instance
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['MysqlNetworkingArgsArgs']]:
        """
        Network configuration parameters for the database instance
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['MysqlNetworkingArgsArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['MysqlStorageArgsArgs']]:
        """
        Storage configuration parameters for the database instance
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['MysqlStorageArgsArgs']]):
        pulumi.set(self, "storage", value)


class Mysql(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['MysqlBackupArgsArgs']]] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['MysqlDatabaseArgsArgs']]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['MysqlNetworkingArgsArgs']]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['MysqlStorageArgsArgs']]] = None,
                 version: Optional[pulumi.Input['MysqlVersion']] = None,
                 __props__=None):
        """
        Cloud Toolkit component for Mysql instances.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MysqlBackupArgsArgs']] backup: Backup configuration parameters for the database instance
        :param pulumi.Input[pulumi.InputType['MysqlDatabaseArgsArgs']] database: Configuration parameters for the database instance
        :param pulumi.Input[str] instance: Instance type to run the database instance
        :param pulumi.Input[pulumi.InputType['MysqlNetworkingArgsArgs']] networking: Network configuration parameters for the database instance
        :param pulumi.Input[pulumi.InputType['MysqlStorageArgsArgs']] storage: Storage configuration parameters for the database instance
        :param pulumi.Input['MysqlVersion'] version: Version for database instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloud Toolkit component for Mysql instances.

        :param str resource_name: The name of the resource.
        :param MysqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['MysqlBackupArgsArgs']]] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['MysqlDatabaseArgsArgs']]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['MysqlNetworkingArgsArgs']]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['MysqlStorageArgsArgs']]] = None,
                 version: Optional[pulumi.Input['MysqlVersion']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlArgs.__new__(MysqlArgs)

            __props__.__dict__["backup"] = backup
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["instance"] = instance
            __props__.__dict__["networking"] = networking
            __props__.__dict__["storage"] = storage
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["ingress_security_group_rules"] = None
            __props__.__dict__["instance_password"] = None
            __props__.__dict__["secret"] = None
            __props__.__dict__["secret_version"] = None
            __props__.__dict__["security_group"] = None
            __props__.__dict__["subnet_group"] = None
        super(Mysql, __self__).__init__(
            'cloud-toolkit-aws:databases:Mysql',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="ingressSecurityGroupRules")
    def ingress_security_group_rules(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.SecurityGroupRule']]:
        """
        Security rules to allow connections to this databse instance
        """
        return pulumi.get(self, "ingress_security_group_rules")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output['pulumi_aws.rds.Instance']:
        """
        Underlying database instance for this component
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="instancePassword")
    def instance_password(self) -> pulumi.Output['pulumi_random.RandomPassword']:
        """
        Random password generated for admin user
        """
        return pulumi.get(self, "instance_password")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output['pulumi_aws.secretsmanager.Secret']:
        """
        Component that protects and stores admin password in AWS
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Output['pulumi_aws.secretsmanager.SecretVersion']:
        """

        Component that updates secrets in AWS
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroup']:
        """
        Security Group attached to this database instance
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter(name="subnetGroup")
    def subnet_group(self) -> pulumi.Output[Optional['pulumi_aws.rds.SubnetGroup']]:
        """
        Set of subnets in which database instance will be deployed
        """
        return pulumi.get(self, "subnet_group")

