# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'MysqlBackupArgsArgs',
    'MysqlDatabaseArgsArgs',
    'MysqlNetworkingArgsArgs',
    'MysqlStorageArgsArgs',
]

@pulumi.input_type
class MysqlBackupArgsArgs:
    def __init__(__self__, *,
                 preferred_window: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] preferred_window: Time window in which backups should be taken
        :param pulumi.Input[float] retention_days: Retention days for backups
        """
        if preferred_window is not None:
            pulumi.set(__self__, "preferred_window", preferred_window)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="preferredWindow")
    def preferred_window(self) -> Optional[pulumi.Input[str]]:
        """
        Time window in which backups should be taken
        """
        return pulumi.get(self, "preferred_window")

    @preferred_window.setter
    def preferred_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_window", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[float]]:
        """
        Retention days for backups
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class MysqlDatabaseArgsArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 username: pulumi.Input[str],
                 password_length: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] name: The name of the database to create when the DB instance is created
        :param pulumi.Input[str] username: Username for database admin user
        :param pulumi.Input[float] password_length: Password length to login in the database instance
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "username", username)
        if password_length is not None:
            pulumi.set(__self__, "password_length", password_length)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the database to create when the DB instance is created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for database admin user
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="passwordLength")
    def password_length(self) -> Optional[pulumi.Input[float]]:
        """
        Password length to login in the database instance
        """
        return pulumi.get(self, "password_length")

    @password_length.setter
    def password_length(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "password_length", value)


@pulumi.input_type
class MysqlNetworkingArgsArgs:
    def __init__(__self__, *,
                 allowed_cidr: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_cidr: Allowed CIDRs that connect to the database instance
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Subnets belonging to a Virtual Private Cloud where database instance must be deployed
        :param pulumi.Input[str] vpc: Virtual Private Cloud where database instance must be deployed
        """
        if allowed_cidr is not None:
            pulumi.set(__self__, "allowed_cidr", allowed_cidr)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="allowedCidr")
    def allowed_cidr(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed CIDRs that connect to the database instance
        """
        return pulumi.get(self, "allowed_cidr")

    @allowed_cidr.setter
    def allowed_cidr(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_cidr", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Subnets belonging to a Virtual Private Cloud where database instance must be deployed
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Private Cloud where database instance must be deployed
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class MysqlStorageArgsArgs:
    def __init__(__self__, *,
                 size: Optional[pulumi.Input[float]] = None,
                 type: Optional[pulumi.Input['MysqlStorageTypeArgs']] = None):
        """
        :param pulumi.Input[float] size: Storage size allocated for database instance
        :param pulumi.Input['MysqlStorageTypeArgs'] type: Storage type class for database instance
        """
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[float]]:
        """
        Storage size allocated for database instance
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['MysqlStorageTypeArgs']]:
        """
        Storage type class for database instance
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['MysqlStorageTypeArgs']]):
        pulumi.set(self, "type", value)


