# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsHttpEventCollector']


class InputsHttpEventCollector(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsHttpEventCollectorAclArgs']]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 sourcetype: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 use_ack: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsHttpEventCollector

        Create or update HTTP Event Collector input configuration tokens.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsHttpEventCollectorAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] disabled: Input disabled indicator
        :param pulumi.Input[str] host: Default host value for events with this token
        :param pulumi.Input[str] index: Index to store generated events
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indexes: Set of indexes allowed for events with this token
        :param pulumi.Input[str] name: Token name (inputs.conf key)
        :param pulumi.Input[str] source: Default source for events with this token
        :param pulumi.Input[str] sourcetype: Default source type for events with this token
        :param pulumi.Input[str] token: Token value for sending data to collector/event endpoint
        :param pulumi.Input[int] use_ack: Indexer acknowledgement for this token
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['disabled'] = disabled
            __props__['host'] = host
            __props__['index'] = index
            __props__['indexes'] = indexes
            __props__['name'] = name
            __props__['source'] = source
            __props__['sourcetype'] = sourcetype
            __props__['token'] = token
            __props__['use_ack'] = use_ack
        super(InputsHttpEventCollector, __self__).__init__(
            'splunk:index/inputsHttpEventCollector:InputsHttpEventCollector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsHttpEventCollectorAclArgs']]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            indexes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            sourcetype: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            use_ack: Optional[pulumi.Input[int]] = None) -> 'InputsHttpEventCollector':
        """
        Get an existing InputsHttpEventCollector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsHttpEventCollectorAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] disabled: Input disabled indicator
        :param pulumi.Input[str] host: Default host value for events with this token
        :param pulumi.Input[str] index: Index to store generated events
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indexes: Set of indexes allowed for events with this token
        :param pulumi.Input[str] name: Token name (inputs.conf key)
        :param pulumi.Input[str] source: Default source for events with this token
        :param pulumi.Input[str] sourcetype: Default source type for events with this token
        :param pulumi.Input[str] token: Token value for sending data to collector/event endpoint
        :param pulumi.Input[int] use_ack: Indexer acknowledgement for this token
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["disabled"] = disabled
        __props__["host"] = host
        __props__["index"] = index
        __props__["indexes"] = indexes
        __props__["name"] = name
        __props__["source"] = source
        __props__["sourcetype"] = sourcetype
        __props__["token"] = token
        __props__["use_ack"] = use_ack
        return InputsHttpEventCollector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsHttpEventCollectorAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Input disabled indicator
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Default host value for events with this token
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        Index to store generated events
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def indexes(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of indexes allowed for events with this token
        """
        return pulumi.get(self, "indexes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Token name (inputs.conf key)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Default source for events with this token
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[str]:
        """
        Default source type for events with this token
        """
        return pulumi.get(self, "sourcetype")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Token value for sending data to collector/event endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useAck")
    def use_ack(self) -> pulumi.Output[int]:
        """
        Indexer acknowledgement for this token
        """
        return pulumi.get(self, "use_ack")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

