import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::SSM::Association`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
export interface CfnAssociationProps {
    /**
     * `AWS::SSM::Association.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name
     */
    readonly name: string;
    /**
     * `AWS::SSM::Association.ApplyOnlyAtCronInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval
     */
    readonly applyOnlyAtCronInterval?: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.AssociationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname
     */
    readonly associationName?: string;
    /**
     * `AWS::SSM::Association.AutomationTargetParameterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername
     */
    readonly automationTargetParameterName?: string;
    /**
     * `AWS::SSM::Association.ComplianceSeverity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity
     */
    readonly complianceSeverity?: string;
    /**
     * `AWS::SSM::Association.DocumentVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion
     */
    readonly documentVersion?: string;
    /**
     * `AWS::SSM::Association.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::SSM::Association.MaxConcurrency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency
     */
    readonly maxConcurrency?: string;
    /**
     * `AWS::SSM::Association.MaxErrors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors
     */
    readonly maxErrors?: string;
    /**
     * `AWS::SSM::Association.OutputLocation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation
     */
    readonly outputLocation?: CfnAssociation.InstanceAssociationOutputLocationProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters
     */
    readonly parameters?: {
        [key: string]: (string[]);
    } | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.ScheduleExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression
     */
    readonly scheduleExpression?: string;
    /**
     * `AWS::SSM::Association.SyncCompliance`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance
     */
    readonly syncCompliance?: string;
    /**
     * `AWS::SSM::Association.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets
     */
    readonly targets?: Array<CfnAssociation.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.WaitForSuccessTimeoutSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds
     */
    readonly waitForSuccessTimeoutSeconds?: number;
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Association
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
export declare class CfnAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Association";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::SSM::Association.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name
     */
    name: string;
    /**
     * `AWS::SSM::Association.ApplyOnlyAtCronInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval
     */
    applyOnlyAtCronInterval: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.AssociationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname
     */
    associationName: string | undefined;
    /**
     * `AWS::SSM::Association.AutomationTargetParameterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername
     */
    automationTargetParameterName: string | undefined;
    /**
     * `AWS::SSM::Association.ComplianceSeverity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity
     */
    complianceSeverity: string | undefined;
    /**
     * `AWS::SSM::Association.DocumentVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion
     */
    documentVersion: string | undefined;
    /**
     * `AWS::SSM::Association.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::SSM::Association.MaxConcurrency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency
     */
    maxConcurrency: string | undefined;
    /**
     * `AWS::SSM::Association.MaxErrors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors
     */
    maxErrors: string | undefined;
    /**
     * `AWS::SSM::Association.OutputLocation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation
     */
    outputLocation: CfnAssociation.InstanceAssociationOutputLocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters
     */
    parameters: {
        [key: string]: (string[]);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.ScheduleExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression
     */
    scheduleExpression: string | undefined;
    /**
     * `AWS::SSM::Association.SyncCompliance`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance
     */
    syncCompliance: string | undefined;
    /**
     * `AWS::SSM::Association.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets
     */
    targets: Array<CfnAssociation.TargetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.WaitForSuccessTimeoutSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds
     */
    waitForSuccessTimeoutSeconds: number | undefined;
    /**
     * Create a new `AWS::SSM::Association`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Association
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
export declare namespace CfnAssociation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html
     */
    interface InstanceAssociationOutputLocationProperty {
        /**
         * `CfnAssociation.InstanceAssociationOutputLocationProperty.S3Location`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html#cfn-ssm-association-instanceassociationoutputlocation-s3location
         */
        readonly s3Location?: CfnAssociation.S3OutputLocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Association
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
export declare namespace CfnAssociation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html
     */
    interface S3OutputLocationProperty {
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3bucketname
         */
        readonly outputS3BucketName?: string;
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3keyprefix
         */
        readonly outputS3KeyPrefix?: string;
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3region
         */
        readonly outputS3Region?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Association
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
export declare namespace CfnAssociation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html
     */
    interface TargetProperty {
        /**
         * `CfnAssociation.TargetProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-key
         */
        readonly key: string;
        /**
         * `CfnAssociation.TargetProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::SSM::Document`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
export interface CfnDocumentProps {
    /**
     * `AWS::SSM::Document.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content
     */
    readonly content: any | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.Attachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-attachments
     */
    readonly attachments?: Array<CfnDocument.AttachmentsSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.DocumentFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documentformat
     */
    readonly documentFormat?: string;
    /**
     * `AWS::SSM::Document.DocumentType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype
     */
    readonly documentType?: string;
    /**
     * `AWS::SSM::Document.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name
     */
    readonly name?: string;
    /**
     * `AWS::SSM::Document.Requires`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-requires
     */
    readonly requires?: Array<CfnDocument.DocumentRequiresProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SSM::Document.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-targettype
     */
    readonly targetType?: string;
    /**
     * `AWS::SSM::Document.VersionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-versionname
     */
    readonly versionName?: string;
}
/**
 * A CloudFormation `AWS::SSM::Document`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Document
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
export declare class CfnDocument extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Document";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDocument;
    /**
     * `AWS::SSM::Document.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content
     */
    content: any | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.Attachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-attachments
     */
    attachments: Array<CfnDocument.AttachmentsSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Document.DocumentFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documentformat
     */
    documentFormat: string | undefined;
    /**
     * `AWS::SSM::Document.DocumentType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype
     */
    documentType: string | undefined;
    /**
     * `AWS::SSM::Document.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name
     */
    name: string | undefined;
    /**
     * `AWS::SSM::Document.Requires`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-requires
     */
    requires: Array<CfnDocument.DocumentRequiresProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Document.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SSM::Document.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-targettype
     */
    targetType: string | undefined;
    /**
     * `AWS::SSM::Document.VersionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-versionname
     */
    versionName: string | undefined;
    /**
     * Create a new `AWS::SSM::Document`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDocumentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::Document`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Document
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
export declare namespace CfnDocument {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-attachmentssource.html
     */
    interface AttachmentsSourceProperty {
        /**
         * `CfnDocument.AttachmentsSourceProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-attachmentssource.html#cfn-ssm-document-attachmentssource-key
         */
        readonly key?: string;
        /**
         * `CfnDocument.AttachmentsSourceProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-attachmentssource.html#cfn-ssm-document-attachmentssource-name
         */
        readonly name?: string;
        /**
         * `CfnDocument.AttachmentsSourceProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-attachmentssource.html#cfn-ssm-document-attachmentssource-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::Document`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Document
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
export declare namespace CfnDocument {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-documentrequires.html
     */
    interface DocumentRequiresProperty {
        /**
         * `CfnDocument.DocumentRequiresProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-documentrequires.html#cfn-ssm-document-documentrequires-name
         */
        readonly name?: string;
        /**
         * `CfnDocument.DocumentRequiresProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-document-documentrequires.html#cfn-ssm-document-documentrequires-version
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindow`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 */
export interface CfnMaintenanceWindowProps {
    /**
     * `AWS::SSM::MaintenanceWindow.AllowUnassociatedTargets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-allowunassociatedtargets
     */
    readonly allowUnassociatedTargets: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindow.Cutoff`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-cutoff
     */
    readonly cutoff: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Duration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-duration
     */
    readonly duration: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-name
     */
    readonly name: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-schedule
     */
    readonly schedule: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-description
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-enddate
     */
    readonly endDate?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleOffset`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduleoffset
     */
    readonly scheduleOffset?: number;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleTimezone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduletimezone
     */
    readonly scheduleTimezone?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.StartDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-startdate
     */
    readonly startDate?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindow`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 */
export declare class CfnMaintenanceWindow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindow;
    /**
     * `AWS::SSM::MaintenanceWindow.AllowUnassociatedTargets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-allowunassociatedtargets
     */
    allowUnassociatedTargets: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindow.Cutoff`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-cutoff
     */
    cutoff: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Duration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-duration
     */
    duration: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-name
     */
    name: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-schedule
     */
    schedule: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-description
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-enddate
     */
    endDate: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleOffset`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduleoffset
     */
    scheduleOffset: number | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleTimezone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduletimezone
     */
    scheduleTimezone: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.StartDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-startdate
     */
    startDate: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SSM::MaintenanceWindow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 */
export interface CfnMaintenanceWindowTargetProps {
    /**
     * `AWS::SSM::MaintenanceWindowTarget.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-resourcetype
     */
    readonly resourceType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-targets
     */
    readonly targets: Array<CfnMaintenanceWindowTarget.TargetsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.WindowId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-windowid
     */
    readonly windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-description
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-name
     */
    readonly name?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.OwnerInformation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-ownerinformation
     */
    readonly ownerInformation?: string;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 */
export declare class CfnMaintenanceWindowTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindowTarget;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-resourcetype
     */
    resourceType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-targets
     */
    targets: Array<CfnMaintenanceWindowTarget.TargetsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.WindowId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-windowid
     */
    windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-description
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-name
     */
    name: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.OwnerInformation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-ownerinformation
     */
    ownerInformation: string | undefined;
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowTargetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 */
export declare namespace CfnMaintenanceWindowTarget {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html
     */
    interface TargetsProperty {
        /**
         * `CfnMaintenanceWindowTarget.TargetsProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html#cfn-ssm-maintenancewindowtarget-targets-key
         */
        readonly key: string;
        /**
         * `CfnMaintenanceWindowTarget.TargetsProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html#cfn-ssm-maintenancewindowtarget-targets-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export interface CfnMaintenanceWindowTaskProps {
    /**
     * `AWS::SSM::MaintenanceWindowTask.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority
     */
    readonly priority: number;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn
     */
    readonly taskArn: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype
     */
    readonly taskType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.WindowId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid
     */
    readonly windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.LoggingInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo
     */
    readonly loggingInfo?: CfnMaintenanceWindowTask.LoggingInfoProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxConcurrency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency
     */
    readonly maxConcurrency?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxErrors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors
     */
    readonly maxErrors?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name
     */
    readonly name?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.ServiceRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn
     */
    readonly serviceRoleArn?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets
     */
    readonly targets?: Array<CfnMaintenanceWindowTask.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters
     */
    readonly taskInvocationParameters?: CfnMaintenanceWindowTask.TaskInvocationParametersProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters
     */
    readonly taskParameters?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare class CfnMaintenanceWindowTask extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTask";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindowTask;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority
     */
    priority: number;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn
     */
    taskArn: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype
     */
    taskType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.WindowId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid
     */
    windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.LoggingInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo
     */
    loggingInfo: CfnMaintenanceWindowTask.LoggingInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxConcurrency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency
     */
    maxConcurrency: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxErrors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors
     */
    maxErrors: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name
     */
    name: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.ServiceRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn
     */
    serviceRoleArn: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets
     */
    targets: Array<CfnMaintenanceWindowTask.TargetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters
     */
    taskInvocationParameters: CfnMaintenanceWindowTask.TaskInvocationParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters
     */
    taskParameters: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTask`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowTaskProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html
     */
    interface LoggingInfoProperty {
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-region
         */
        readonly region: string;
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.S3Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.S3Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3prefix
         */
        readonly s3Prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html
     */
    interface MaintenanceWindowAutomationParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty.DocumentVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-documentversion
         */
        readonly documentVersion?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html
     */
    interface MaintenanceWindowLambdaParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.ClientContext`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-clientcontext
         */
        readonly clientContext?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-payload
         */
        readonly payload?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.Qualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-qualifier
         */
        readonly qualifier?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html
     */
    interface MaintenanceWindowRunCommandParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-comment
         */
        readonly comment?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.DocumentHash`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthash
         */
        readonly documentHash?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.DocumentHashType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthashtype
         */
        readonly documentHashType?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.NotificationConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-notificationconfig
         */
        readonly notificationConfig?: CfnMaintenanceWindowTask.NotificationConfigProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.OutputS3BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3bucketname
         */
        readonly outputS3BucketName?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.OutputS3KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3keyprefix
         */
        readonly outputS3KeyPrefix?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.ServiceRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-servicerolearn
         */
        readonly serviceRoleArn?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.TimeoutSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-timeoutseconds
         */
        readonly timeoutSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html
     */
    interface MaintenanceWindowStepFunctionsParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty.Input`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-input
         */
        readonly input?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html
     */
    interface NotificationConfigProperty {
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationarn
         */
        readonly notificationArn: string;
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationevents
         */
        readonly notificationEvents?: string[];
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationtype
         */
        readonly notificationType?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html
     */
    interface TargetProperty {
        /**
         * `CfnMaintenanceWindowTask.TargetProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-key
         */
        readonly key: string;
        /**
         * `CfnMaintenanceWindowTask.TargetProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html
     */
    interface TaskInvocationParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowAutomationParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowautomationparameters
         */
        readonly maintenanceWindowAutomationParameters?: CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowLambdaParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowlambdaparameters
         */
        readonly maintenanceWindowLambdaParameters?: CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowRunCommandParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowruncommandparameters
         */
        readonly maintenanceWindowRunCommandParameters?: CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowStepFunctionsParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowstepfunctionsparameters
         */
        readonly maintenanceWindowStepFunctionsParameters?: CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SSM::Parameter`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 */
export interface CfnParameterProps {
    /**
     * `AWS::SSM::Parameter.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-type
     */
    readonly type: string;
    /**
     * `AWS::SSM::Parameter.Value`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-value
     */
    readonly value: string;
    /**
     * `AWS::SSM::Parameter.AllowedPattern`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-allowedpattern
     */
    readonly allowedPattern?: string;
    /**
     * `AWS::SSM::Parameter.DataType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-datatype
     */
    readonly dataType?: string;
    /**
     * `AWS::SSM::Parameter.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-description
     */
    readonly description?: string;
    /**
     * `AWS::SSM::Parameter.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-name
     */
    readonly name?: string;
    /**
     * `AWS::SSM::Parameter.Policies`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-policies
     */
    readonly policies?: string;
    /**
     * `AWS::SSM::Parameter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tags
     */
    readonly tags?: any;
    /**
     * `AWS::SSM::Parameter.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tier
     */
    readonly tier?: string;
}
/**
 * A CloudFormation `AWS::SSM::Parameter`.
 *
 * @external
 * @cloudformationResource AWS::SSM::Parameter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 */
export declare class CfnParameter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Parameter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnParameter;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * @external
     * @cloudformationAttribute Value
     */
    readonly attrValue: string;
    /**
     * `AWS::SSM::Parameter.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-type
     */
    type: string;
    /**
     * `AWS::SSM::Parameter.Value`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-value
     */
    value: string;
    /**
     * `AWS::SSM::Parameter.AllowedPattern`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-allowedpattern
     */
    allowedPattern: string | undefined;
    /**
     * `AWS::SSM::Parameter.DataType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-datatype
     */
    dataType: string | undefined;
    /**
     * `AWS::SSM::Parameter.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-description
     */
    description: string | undefined;
    /**
     * `AWS::SSM::Parameter.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-name
     */
    name: string | undefined;
    /**
     * `AWS::SSM::Parameter.Policies`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-policies
     */
    policies: string | undefined;
    /**
     * `AWS::SSM::Parameter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SSM::Parameter.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tier
     */
    tier: string | undefined;
    /**
     * Create a new `AWS::SSM::Parameter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnParameterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export interface CfnPatchBaselineProps {
    /**
     * `AWS::SSM::PatchBaseline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name
     */
    readonly name: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovalRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules
     */
    readonly approvalRules?: CfnPatchBaseline.RuleGroupProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatches`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches
     */
    readonly approvedPatches?: string[];
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesComplianceLevel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel
     */
    readonly approvedPatchesComplianceLevel?: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesEnableNonSecurity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity
     */
    readonly approvedPatchesEnableNonSecurity?: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description
     */
    readonly description?: string;
    /**
     * `AWS::SSM::PatchBaseline.GlobalFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters
     */
    readonly globalFilters?: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.OperatingSystem`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem
     */
    readonly operatingSystem?: string;
    /**
     * `AWS::SSM::PatchBaseline.PatchGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups
     */
    readonly patchGroups?: string[];
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatches`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches
     */
    readonly rejectedPatches?: string[];
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatchesAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction
     */
    readonly rejectedPatchesAction?: string;
    /**
     * `AWS::SSM::PatchBaseline.Sources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources
     */
    readonly sources?: Array<CfnPatchBaseline.PatchSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare class CfnPatchBaseline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::PatchBaseline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPatchBaseline;
    /**
     * `AWS::SSM::PatchBaseline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name
     */
    name: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovalRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules
     */
    approvalRules: CfnPatchBaseline.RuleGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatches`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches
     */
    approvedPatches: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesComplianceLevel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel
     */
    approvedPatchesComplianceLevel: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesEnableNonSecurity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity
     */
    approvedPatchesEnableNonSecurity: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description
     */
    description: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.GlobalFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters
     */
    globalFilters: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.OperatingSystem`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem
     */
    operatingSystem: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.PatchGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups
     */
    patchGroups: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatches`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches
     */
    rejectedPatches: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatchesAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction
     */
    rejectedPatchesAction: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Sources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources
     */
    sources: Array<CfnPatchBaseline.PatchSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SSM::PatchBaseline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPatchBaselineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare namespace CfnPatchBaseline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html
     */
    interface PatchFilterProperty {
        /**
         * `CfnPatchBaseline.PatchFilterProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-key
         */
        readonly key?: string;
        /**
         * `CfnPatchBaseline.PatchFilterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare namespace CfnPatchBaseline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html
     */
    interface PatchFilterGroupProperty {
        /**
         * `CfnPatchBaseline.PatchFilterGroupProperty.PatchFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html#cfn-ssm-patchbaseline-patchfiltergroup-patchfilters
         */
        readonly patchFilters?: Array<CfnPatchBaseline.PatchFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare namespace CfnPatchBaseline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html
     */
    interface PatchSourceProperty {
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-configuration
         */
        readonly configuration?: string;
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-name
         */
        readonly name?: string;
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Products`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-products
         */
        readonly products?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare namespace CfnPatchBaseline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html
     */
    interface RuleProperty {
        /**
         * `CfnPatchBaseline.RuleProperty.ApproveAfterDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveafterdays
         */
        readonly approveAfterDays?: number;
        /**
         * `CfnPatchBaseline.RuleProperty.ApproveUntilDate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveuntildate
         */
        readonly approveUntilDate?: string;
        /**
         * `CfnPatchBaseline.RuleProperty.ComplianceLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-compliancelevel
         */
        readonly complianceLevel?: string;
        /**
         * `CfnPatchBaseline.RuleProperty.EnableNonSecurity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-enablenonsecurity
         */
        readonly enableNonSecurity?: boolean | cdk.IResolvable;
        /**
         * `CfnPatchBaseline.RuleProperty.PatchFilterGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-patchfiltergroup
         */
        readonly patchFilterGroup?: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
export declare namespace CfnPatchBaseline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html
     */
    interface RuleGroupProperty {
        /**
         * `CfnPatchBaseline.RuleGroupProperty.PatchRules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html#cfn-ssm-patchbaseline-rulegroup-patchrules
         */
        readonly patchRules?: Array<CfnPatchBaseline.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SSM::ResourceDataSync`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
export interface CfnResourceDataSyncProps {
    /**
     * `AWS::SSM::ResourceDataSync.SyncName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname
     */
    readonly syncName: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname
     */
    readonly bucketName?: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix
     */
    readonly bucketPrefix?: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion
     */
    readonly bucketRegion?: string;
    /**
     * `AWS::SSM::ResourceDataSync.KMSKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::SSM::ResourceDataSync.S3Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination
     */
    readonly s3Destination?: CfnResourceDataSync.S3DestinationProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::ResourceDataSync.SyncFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat
     */
    readonly syncFormat?: string;
    /**
     * `AWS::SSM::ResourceDataSync.SyncSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource
     */
    readonly syncSource?: CfnResourceDataSync.SyncSourceProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::ResourceDataSync.SyncType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype
     */
    readonly syncType?: string;
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
export declare class CfnResourceDataSync extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::ResourceDataSync";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceDataSync;
    /**
     * @external
     * @cloudformationAttribute SyncName
     */
    readonly attrSyncName: string;
    /**
     * `AWS::SSM::ResourceDataSync.SyncName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname
     */
    syncName: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname
     */
    bucketName: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.BucketPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix
     */
    bucketPrefix: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.BucketRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion
     */
    bucketRegion: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.KMSKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.S3Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination
     */
    s3Destination: CfnResourceDataSync.S3DestinationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat
     */
    syncFormat: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource
     */
    syncSource: CfnResourceDataSync.SyncSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype
     */
    syncType: string | undefined;
    /**
     * Create a new `AWS::SSM::ResourceDataSync`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDataSyncProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
export declare namespace CfnResourceDataSync {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html
     */
    interface AwsOrganizationsSourceProperty {
        /**
         * `CfnResourceDataSync.AwsOrganizationsSourceProperty.OrganizationSourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html#cfn-ssm-resourcedatasync-awsorganizationssource-organizationsourcetype
         */
        readonly organizationSourceType: string;
        /**
         * `CfnResourceDataSync.AwsOrganizationsSourceProperty.OrganizationalUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html#cfn-ssm-resourcedatasync-awsorganizationssource-organizationalunits
         */
        readonly organizationalUnits?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
export declare namespace CfnResourceDataSync {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html
     */
    interface S3DestinationProperty {
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketname
         */
        readonly bucketName: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketprefix
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketregion
         */
        readonly bucketRegion: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.KMSKeyArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-kmskeyarn
         */
        readonly kmsKeyArn?: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.SyncFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-syncformat
         */
        readonly syncFormat: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
export declare namespace CfnResourceDataSync {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html
     */
    interface SyncSourceProperty {
        /**
         * `CfnResourceDataSync.SyncSourceProperty.AwsOrganizationsSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-awsorganizationssource
         */
        readonly awsOrganizationsSource?: CfnResourceDataSync.AwsOrganizationsSourceProperty | cdk.IResolvable;
        /**
         * `CfnResourceDataSync.SyncSourceProperty.IncludeFutureRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-includefutureregions
         */
        readonly includeFutureRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDataSync.SyncSourceProperty.SourceRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-sourceregions
         */
        readonly sourceRegions: string[];
        /**
         * `CfnResourceDataSync.SyncSourceProperty.SourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-sourcetype
         */
        readonly sourceType: string;
    }
}
