# Copyright 2020 The gRPC Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Setup module for the gRPC Health Checking package."""

import sys

import setuptools

CLASSIFIERS = [
    'Development Status :: 7 - Inactive',
    'Programming Language :: Python',
    'Programming Language :: Python :: 2',
    'Programming Language :: Python :: 3',
    'License :: OSI Approved :: Apache Software License',
]


HINT = 'Please install the official package with: pip install grpcio-health-checking'


if 'sdist' not in sys.argv:
    raise RuntimeError(HINT)


setuptools.setup(
    name='grpc-health-checking',
    version='1.0.0',
    description=HINT,
    author='The gRPC Authors',
    author_email='grpc-io@googlegroups.com',
    url='https://grpc.io',
    license='Apache License 2.0',
    classifiers=CLASSIFIERS
)