from roche_datachapter_team_lib.db_config import DB_CONFIG

query = """SELECT 
     FISCAL_PERIOD
    ,DATE AS CALENDAR_DATE
    ,ONERING_DATA_TYPE
    ,PROCESS_INDICATOR
    ,ACCOUNT_NAME
    ,ACCOUNT_NBR
    ,ACCOUNT_CHANNEL
    ,ACCOUNT_INDUSTRY_GROUP
    ,COMPANY_CODE
    ,COMPANY_CURRENCY
    ,COMPANY_NAME
    ,COMPANY_NAME_LEGAL
    ,CURRENCY_CONVERSION_CMPYCRCY_TO_CHFCER_CY AS CER
    ,CURRENCY_CONVERSION_CMPYCRCY_TO_CHFCER_PY AS CER_PY
    ,MARKET_NAME
    ,MATERIAL
    ,MATERIAL_NAME
    ,MATERIAL_NBR
    ,MATERIAL_CATEGORY
    ,SALES_DOCUMENT_NBR
    ,SALES_DOCUMENT_TYPE
    ,PROD_PL1 AS PL1
    ,PROD_PL2 AS PL2
    ,PROD_PL2A AS PL2A
    ,PROD_PL3 AS PL3
    ,PROD_PL4 AS PL4
    ,PROD_POSTED_PL4
    ,PROD_PL4_KEY AS PL4_CODE
    ,_PROD_PL4_LONG AS PL4_NAME
    ,PROD_PL5 AS PL5
    ,PROD_PL6_PROFIT_CENTER_NAME AS PL6
    ,RECEIVER
    ,TERRITORY_HIER_FOLDED_L2 AS SQUAD
    ,IFNULL(QUANTITY,0) AS QUANTITY
    ,IFNULL(QUANTITY_NBRTEST,0) AS QUANTITY_TESTS
    ,SALES_CHFCER
    ,SALES_CHFCER_PY
    ,SALES_CMPYCRCY
    ,SALES_TARGET_CHFCER AS TARGET_CHF
    ,SALES_TARGET_CMPYCRCY AS TARGET_CMPY
    ,SALES_TARGET_T3_CHFCER AS TARGET_CHF_T3
    ,SALES_TARGET_T3_CMPYCRCY AS TARGET_CMPY_T3
FROM PROD_DIA.DP_FINANCE_ONERING.DST_ONERING_SALES 
WHERE COMPANY_CODE IN (6932,6241,6261,6256) 
    AND FISCAL_PERIOD >=  DATEADD(YEAR, -1, CURRENT_DATE)
"""

df = DB_CONFIG.execute_custom_select_query(
    query=query,
    p_bind='snowflake_default',
    snowflake_ctx={
        "db": "AR_PRICELIST_DEV",
        "schema": "BUSINESS_DV_AR_PRICELIST",
        "warehouse": "WH_AR_PRICELIST_01"
    }
)

print(len(df))
print(df.head(10))