<h1 align="center">ClimateLearn</h1>

[![Documentation Status](https://readthedocs.org/projects/climatelearn/badge/?version=latest)](https://climatelearn.readthedocs.io/en/latest/?badge=latest)
[![CI Build Status](https://github.com/aditya-grover/climate-learn/actions/workflows/ci.yaml/badge.svg)](https://github.com/aditya-grover/climate-learn/actions/workflows/ci.yaml)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1WiNEK1BHsiGzo_bT9Fcm8lea2H_ghNfa)

**ClimateLearn** is a Python library for accessing state-of-the-art climate data and machine learning models in a standardized, straightforward way. This library provides access to multiple datasets, a zoo of baseline approaches, and a suite of metrics and visualizations for large-scale benchmarking of statistical downscaling and temporal forecasting methods. For further context on our past motivation and future plans, check out our announcement [blog post](https://aditya-grover.github.io/blog/2023/climate-learn/).

## Usage

[**Python3**](https://www.python.org/) is required.
```
pip install climate-learn
```

### Quickstart
Please refer to this [Google Colab](https://colab.research.google.com/drive/1WiNEK1BHsiGzo_bT9Fcm8lea2H_ghNfa) for a tutorial-style exposition into developing your first models for forecasting and downscaling in ClimateLearn.

We previewed some key features of ClimateLearn at a spotlight tutorial in the "Tackling Climate Change with Machine Learning" Workshop at the Neural Information Processing Systems 2022 Conference. The slides and recorded talk can be found on [Climate Change AI's website](https://www.climatechange.ai/papers/neurips2022/114). 

### Documentation
Find us on [ReadTheDocs](https://climatelearn.readthedocs.io/).

### Integrations
- [Weights & Biases](https://wandb.ai/site)

## About Us
ClimateLearn is managed by the Machine Intelligence Group at UCLA, headed by [Professor Aditya Grover](https://aditya-grover.github.io).

## Contributing
Contributions are welcome! See our [contributing guide](https://github.com/aditya-grover/climate-learn/blob/main/CONTRIBUTING.md).

## Citing ClimateLearn
If you use ClimateLearn, please see the [`CITATION.cff`](https://github.com/aditya-grover/climate-learn/blob/main/CITATION.cff) file or use the citation prompt provided by GitHub in the sidebar.
