# Ninja Snake Lib

Biblioteca escrita em python para ser utilizada nos projetos que utilizam o 
Django framework.  

### Motivação

Devido aos projetos CRM-Dispatcher, Payment-Report e Portal-Admin compatilharem 
do mesmo trecho de código nas configurações dos sistemas, chegamos a um 
consenso de criar uma biblioteca para melhorar a reutilização e a manutenção 
do código.

### Dependências

Está biblioteca possui a dependência do Django Framework **>= 3.1.6**.

### Funcionalidades

- ReadDotenv
- JSONFormatter  
- validate_external_api_key
- validate_sns_subscription

### Instalação

`pip install ninja-snake-lib`

### Read Dotenv

O módulo **ReadDotenv** tem a função de ler as variáveis de ambiente contidas 
no arquivo **.env** e criá-las no sistema operacional.

**Como Utilizar**

No início do arquivo settings.py de ser feito o import do módulo.

`from ninja-snake-lib.read_dotenv import ReadDotenv`

Deve ser passado como parâmetro o path onde se encontra o arquivo **.env**.

`ReadDotenv.read_dotenv(Path(__file__).resolve().parent)`

### JSONFormatter

O módulo **JSONFormatter** tem a função de formatar a saída do log.  

**Como Utilizar**

Para utilizar o módulo, basta fazer a chamada na config do LOG como no exemplo 
abaixo:

##### Config do log no settings.py
```
 LOGGING = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'json': {
                '()': 'ninja_snake_lib.json_formatter.JSONFormatter'
            }
        },
        ...
```

## Decorators

### validate_external_api_key

O decorator **validate_external_api_key** tem a função de validar o parâmetro 
**HTTP_AUTHORIZATION** no header das requisições recebidas.

**Como Utilizar**

No início do arquivo da view que irá utilizar o decorator, de ser feito o 
import do mesmo.

`from ninja_snake_lib.decorators import validate_external_api_key`

Com o decorator importado podemos fazer uso dele como no exemplo abaixo:

```
@validate_external_api_key
def teste_decorator(x):
    return x * 3
```

### validate_sns_subscription

O decorator **validate_sns_subscription** tem a função de validar o parâmetro 
**HTTP_X_AMZ_SNS_MESSAGE_TYPE** no header das requisições recebidas.

**Como Utilizar**

No início do arquivo da view que irá utilizar o decorator, de ser feito o 
import do mesmo.

`from ninja_snake_lib.decorators import validate_sns_subscription`

Com o decorator importado podemos fazer uso dele como no exemplo abaixo:

```
@validate_sns_subscription
def teste_decorator(x):
    return x * 3
```

## Testes

Para rodar os testes devemos instalar as dependências para o teste unitário 
com o comando abaixo:

`pip install -r requirements.txt`

Para rodar os testes devemos estar no diretório root do projeto e executar o 
comando abaixo:

`python -m unittest`

> Podemos também utilizar o parâmetro -v (verbose) para exibir os nomes nos testes 
> que rodaram.

##### Exemplo

`python -m unittest -v`
s
