"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const invoke_activity_1 = require("../../lib/stepfunctions/invoke-activity");
test('Activity can be used in a Task', () => {
    // GIVEN
    const stack = new core_1.Stack();
    // WHEN
    const activity = new sfn.Activity(stack, 'Activity');
    const task = new invoke_activity_1.StepFunctionsInvokeActivity(stack, 'Task', { activity });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': ['', [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Type":"Task","Resource":"',
                    { Ref: 'Activity04690B0A' },
                    '"}}}',
                ]],
        },
    });
});
test('Activity Task metrics and Activity metrics are the same', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const activity = new sfn.Activity(stack, 'Activity');
    const task = new invoke_activity_1.StepFunctionsInvokeActivity(stack, 'Invoke', { activity });
    // WHEN
    const activityMetrics = [
        activity.metricFailed(),
        activity.metricHeartbeatTimedOut(),
        activity.metricRunTime(),
        activity.metricScheduled(),
        activity.metricScheduleTime(),
        activity.metricStarted(),
        activity.metricSucceeded(),
        activity.metricTime(),
        activity.metricTimedOut(),
    ];
    const taskMetrics = [
        task.metricFailed(),
        task.metricHeartbeatTimedOut(),
        task.metricRunTime(),
        task.metricScheduled(),
        task.metricScheduleTime(),
        task.metricStarted(),
        task.metricSucceeded(),
        task.metricTime(),
        task.metricTimedOut(),
    ];
    // THEN
    for (let i = 0; i < activityMetrics.length; i++) {
        expect(activityMetrics[i]).toEqual(taskMetrics[i]);
    }
});
//# sourceMappingURL=data:application/json;base64,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