"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
test('Activity can be used in a Task', () => {
    // GIVEN
    const stack = new core_1.Stack();
    // WHEN
    const activity = new sfn.Activity(stack, 'Activity');
    const task = new sfn.Task(stack, 'Task', { task: new tasks.InvokeActivity(activity) });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': ['', [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Type":"Task","Resource":"',
                    { Ref: 'Activity04690B0A' },
                    '"}}}',
                ]],
        },
    });
});
test('Activity Task metrics and Activity metrics are the same', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const activity = new sfn.Activity(stack, 'Activity');
    const task = new sfn.Task(stack, 'Invoke', { task: new tasks.InvokeActivity(activity) });
    // WHEN
    const activityMetrics = [
        activity.metricFailed(),
        activity.metricHeartbeatTimedOut(),
        activity.metricRunTime(),
        activity.metricScheduled(),
        activity.metricScheduleTime(),
        activity.metricStarted(),
        activity.metricSucceeded(),
        activity.metricTime(),
        activity.metricTimedOut(),
    ];
    const taskMetrics = [
        task.metricFailed(),
        task.metricHeartbeatTimedOut(),
        task.metricRunTime(),
        task.metricScheduled(),
        task.metricScheduleTime(),
        task.metricStarted(),
        task.metricSucceeded(),
        task.metricTime(),
        task.metricTimedOut(),
    ];
    // THEN
    for (let i = 0; i < activityMetrics.length; i++) {
        expect(activityMetrics[i]).toEqual(taskMetrics[i]);
    }
});
//# sourceMappingURL=data:application/json;base64,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