"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
/*
 * Stack verification steps:
 * * aws stepfunctions start-execution --input '{"hello": "world"}' --state-machine-arn <StateMachineARN>
 * * aws stepfunctions describe-execution --execution-arn <execution-arn>
 * * The output here should contain `status: "SUCCEEDED"` and `output:"{...\"Output\":\"{\\\"hello\\\":\\\"world\\\"}\"...}"`
 */
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const child = new sfn.StateMachine(this, 'Child', {
            definition: new sfn.Pass(this, 'Pass'),
        });
        const parent = new sfn.StateMachine(this, 'Parent', {
            definition: new sfn.Task(this, 'Task', {
                task: new tasks.StartExecution(child, {
                    input: {
                        hello: sfn.JsonPath.stringAt('$.hello'),
                    },
                    integrationPattern: sfn.ServiceIntegrationPattern.SYNC,
                }),
            }),
        });
        new core_1.CfnOutput(this, 'StateMachineARN', {
            value: parent.stateMachineArn,
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'integ-sfn-start-execution');
app.synth();
//# sourceMappingURL=data:application/json;base64,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