"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../lib");
/*
 * Stack verification steps:
 * * aws stepfunctions start-execution --input '{"a": 3, "b": 4}' --state-machine-arn <StateMachineARN>
 * * aws stepfunctions describe-execution --execution-arn <execution-arn>
 * * The output here should contain `status: "SUCCEEDED"` and `output: "{ a: 3, b: 4, c: 7, d: 14, now: <current date> }"
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-stepfunctions-integ');
const sum = new tasks.EvaluateExpression(stack, 'Sum', {
    expression: '$.a + $.b',
    resultPath: '$.c',
});
const multiply = new tasks.EvaluateExpression(stack, 'Multiply', {
    expression: '$.c * 2',
    resultPath: '$.d',
});
const now = new tasks.EvaluateExpression(stack, 'Now', {
    expression: '(new Date()).toUTCString()',
    resultPath: '$.now',
});
const statemachine = new sfn.StateMachine(stack, 'StateMachine', {
    definition: sum
        .next(multiply)
        .next(new sfn.Wait(stack, 'Wait', {
        time: sfn.WaitTime.secondsPath('$.d'),
    }))
        .next(now),
});
new cdk.CfnOutput(stack, 'StateMachineARN', {
    value: statemachine.stateMachineArn,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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