"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
let stack;
beforeEach(() => {
    stack = new core_1.Stack();
});
test('Eval with Node.js', () => {
    // WHEN
    const task = new tasks.EvaluateExpression(stack, 'Task', {
        expression: '$.a + $.b',
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': ['Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1', 'Arn'],
                    },
                    '","Parameters":{"expression":"$.a + $.b","expressionAttributeValues":{"$.a.$":"$.a","$.b.$":"$.b"}}}}}',
                ],
            ],
        },
    });
    expect(stack).toHaveResource('AWS::Lambda::Function', {
        Runtime: 'nodejs10.x',
    });
});
test('expression does not contain paths', () => {
    // WHEN
    const task = new tasks.EvaluateExpression(stack, 'Task', {
        expression: '2 + 2',
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': ['Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1', 'Arn'],
                    },
                    '","Parameters":{"expression":"2 + 2","expressionAttributeValues":{}}}}}',
                ],
            ],
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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