"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('DeleteItem task', () => {
    // WHEN
    const task = new tasks.DynamoDeleteItem(stack, 'DeleteItem', {
        key: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.JsonPath.stringAt('$.Item.TotalCount.N')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:deleteItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Key: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: { ':val': { 'N.$': '$.Item.TotalCount.N' } },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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