from setuptools import setup

name = "types-pywin32"
description = "Typing stubs for pywin32"
long_description = '''
## Typing stubs for pywin32

This is a PEP 561 type stub package for the `pywin32` package.
It can be used by type-checking tools like mypy, PyCharm, pytype etc. to check code
that uses `pywin32`. The source for this package can be found at
https://github.com/python/typeshed/tree/master/stubs/pywin32. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/master/README.md for more details.
This package was generated from typeshed commit `96af812c071677f3394d876e1f77eb7798dd7538`.
'''.lstrip()

setup(name=name,
      version="304.0.0.2",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/pywin32.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=[],
      packages=['win32profile-stubs', 'win32ts-stubs', 'mmsystem-stubs', 'win32console-stubs', 'win32job-stubs', 'perfmon-stubs', 'win32help-stubs', 'win32netcon-stubs', 'win32service-stubs', 'win32transaction-stubs', 'pythonwin-stubs', 'win32cred-stubs', 'winxpgui-stubs', 'win32pipe-stubs', 'win32cryptcon-stubs', 'win32ras-stubs', 'pythoncom-stubs', 'win32trace-stubs', 'win32timezone-stubs', 'sspicon-stubs', 'win32con-stubs', 'servicemanager-stubs', 'win32ui-stubs', 'winerror-stubs', 'win32process-stubs', 'winxptheme-stubs', 'win32inet-stubs', 'win32net-stubs', 'win32uiole-stubs', 'win32lz-stubs', 'win32security-stubs', 'winioctlcon-stubs', 'win32pdh-stubs', 'afxres-stubs', 'ntsecuritycon-stubs', 'win32file-stubs', 'isapi-stubs', 'win32inetcon-stubs', 'odbc-stubs', 'win32gui-stubs', 'win32pdhquery-stubs', 'regutil-stubs', 'win32evtlog-stubs', 'winnt-stubs', 'win32crypt-stubs', 'win32wnet-stubs', 'win32com-stubs', 'winperf-stubs', 'mmapfile-stubs', 'win32-stubs', 'commctrl-stubs', 'win32comext-stubs', '_win32typing-stubs', 'win2kras-stubs', 'win32api-stubs', 'timer-stubs', 'win32clipboard-stubs', 'win32print-stubs', 'win32event-stubs', 'pywintypes-stubs', 'win32evtlogutil-stubs', 'dde-stubs'],
      package_data={'win32profile-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32ts-stubs': ['__init__.pyi', 'METADATA.toml'], 'mmsystem-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32console-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32job-stubs': ['__init__.pyi', 'METADATA.toml'], 'perfmon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32help-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32netcon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32service-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32transaction-stubs': ['__init__.pyi', 'METADATA.toml'], 'pythonwin-stubs': ['__init__.pyi', 'dde.pyi', 'win32ui.pyi', 'win32uiole.pyi', 'METADATA.toml'], 'win32cred-stubs': ['__init__.pyi', 'METADATA.toml'], 'winxpgui-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32pipe-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32cryptcon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32ras-stubs': ['__init__.pyi', 'METADATA.toml'], 'pythoncom-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32trace-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32timezone-stubs': ['__init__.pyi', 'METADATA.toml'], 'sspicon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32con-stubs': ['__init__.pyi', 'METADATA.toml'], 'servicemanager-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32ui-stubs': ['__init__.pyi', 'METADATA.toml'], 'winerror-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32process-stubs': ['__init__.pyi', 'METADATA.toml'], 'winxptheme-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32inet-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32net-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32uiole-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32lz-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32security-stubs': ['__init__.pyi', 'METADATA.toml'], 'winioctlcon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32pdh-stubs': ['__init__.pyi', 'METADATA.toml'], 'afxres-stubs': ['__init__.pyi', 'METADATA.toml'], 'ntsecuritycon-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32file-stubs': ['__init__.pyi', 'METADATA.toml'], 'isapi-stubs': ['__init__.pyi', 'isapicon.pyi', 'simple.pyi', 'threaded_extension.pyi', 'METADATA.toml'], 'win32inetcon-stubs': ['__init__.pyi', 'METADATA.toml'], 'odbc-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32gui-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32pdhquery-stubs': ['__init__.pyi', 'METADATA.toml'], 'regutil-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32evtlog-stubs': ['__init__.pyi', 'METADATA.toml'], 'winnt-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32crypt-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32wnet-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32com-stubs': ['__init__.pyi', 'adsi/__init__.pyi', 'adsi/adsi.pyi', 'adsi/adsicon.pyi', 'authorization/__init__.pyi', 'authorization/authorization.pyi', 'axcontrol/__init__.pyi', 'axcontrol/axcontrol.pyi', 'axdebug/__init__.pyi', 'axdebug/adb.pyi', 'axdebug/axdebug.pyi', 'axdebug/codecontainer.pyi', 'axdebug/contexts.pyi', 'axdebug/debugger.pyi', 'axdebug/documents.pyi', 'axdebug/expressions.pyi', 'axdebug/gateways.pyi', 'axdebug/stackframe.pyi', 'axdebug/util.pyi', 'axscript/__init__.pyi', 'axscript/asputil.pyi', 'axscript/axscript.pyi', 'axscript/client/__init__.pyi', 'axscript/client/error.pyi', 'axscript/server/__init__.pyi', 'axscript/server/axsite.pyi', 'axscript/server/error.pyi', 'bits/__init__.pyi', 'bits/bits.pyi', 'client/__init__.pyi', 'client/dynamic.pyi', 'directsound/__init__.pyi', 'directsound/directsound.pyi', 'ifilter/__init__.pyi', 'ifilter/ifilter.pyi', 'ifilter/ifiltercon.pyi', 'internet/__init__.pyi', 'internet/inetcon.pyi', 'internet/internet.pyi', 'mapi/__init__.pyi', 'mapi/_exchdapi.pyi', 'mapi/emsabtags.pyi', 'mapi/exchange.pyi', 'mapi/mapi.pyi', 'mapi/mapitags.pyi', 'mapi/mapiutil.pyi', 'olectl.pyi', 'propsys/__init__.pyi', 'propsys/propsys.pyi', 'propsys/pscon.pyi', 'server/__init__.pyi', 'server/connect.pyi', 'server/dispatcher.pyi', 'server/exception.pyi', 'server/policy.pyi', 'server/util.pyi', 'shell/__init__.pyi', 'shell/shell.pyi', 'shell/shellcon.pyi', 'storagecon.pyi', 'taskscheduler/__init__.pyi', 'taskscheduler/taskscheduler.pyi', 'universal.pyi', 'util.pyi', 'METADATA.toml'], 'winperf-stubs': ['__init__.pyi', 'METADATA.toml'], 'mmapfile-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32-stubs': ['__init__.pyi', '_wincerapi.pyi', 'lib/__init__.pyi', 'lib/afxres.pyi', 'lib/commctrl.pyi', 'lib/mmsystem.pyi', 'lib/ntsecuritycon.pyi', 'lib/pywintypes.pyi', 'lib/regutil.pyi', 'lib/sspicon.pyi', 'lib/win2kras.pyi', 'lib/win32con.pyi', 'lib/win32cryptcon.pyi', 'lib/win32evtlogutil.pyi', 'lib/win32inetcon.pyi', 'lib/win32netcon.pyi', 'lib/win32pdhquery.pyi', 'lib/win32timezone.pyi', 'lib/winerror.pyi', 'lib/winioctlcon.pyi', 'lib/winnt.pyi', 'lib/winperf.pyi', 'lib/winxptheme.pyi', 'mmapfile.pyi', 'odbc.pyi', 'perfmon.pyi', 'servicemanager.pyi', 'timer.pyi', 'win32api.pyi', 'win32clipboard.pyi', 'win32console.pyi', 'win32cred.pyi', 'win32crypt.pyi', 'win32event.pyi', 'win32evtlog.pyi', 'win32file.pyi', 'win32gui.pyi', 'win32help.pyi', 'win32inet.pyi', 'win32job.pyi', 'win32lz.pyi', 'win32net.pyi', 'win32pdh.pyi', 'win32pipe.pyi', 'win32print.pyi', 'win32process.pyi', 'win32profile.pyi', 'win32ras.pyi', 'win32security.pyi', 'win32service.pyi', 'win32trace.pyi', 'win32transaction.pyi', 'win32ts.pyi', 'win32wnet.pyi', 'winxpgui.pyi', 'METADATA.toml'], 'commctrl-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32comext-stubs': ['__init__.pyi', 'adsi/__init__.pyi', 'adsi/adsi.pyi', 'adsi/adsicon.pyi', 'authorization/__init__.pyi', 'authorization/authorization.pyi', 'axcontrol/__init__.pyi', 'axcontrol/axcontrol.pyi', 'axdebug/__init__.pyi', 'axdebug/adb.pyi', 'axdebug/axdebug.pyi', 'axdebug/codecontainer.pyi', 'axdebug/contexts.pyi', 'axdebug/debugger.pyi', 'axdebug/documents.pyi', 'axdebug/expressions.pyi', 'axdebug/gateways.pyi', 'axdebug/stackframe.pyi', 'axdebug/util.pyi', 'axscript/__init__.pyi', 'axscript/asputil.pyi', 'axscript/axscript.pyi', 'axscript/client/__init__.pyi', 'axscript/client/error.pyi', 'axscript/client/pyscript.pyi', 'axscript/server/__init__.pyi', 'axscript/server/axsite.pyi', 'axscript/server/error.pyi', 'bits/__init__.pyi', 'bits/bits.pyi', 'directsound/__init__.pyi', 'directsound/directsound.pyi', 'ifilter/__init__.pyi', 'ifilter/ifilter.pyi', 'ifilter/ifiltercon.pyi', 'internet/__init__.pyi', 'internet/inetcon.pyi', 'internet/internet.pyi', 'mapi/__init__.pyi', 'mapi/_exchdapi.pyi', 'mapi/emsabtags.pyi', 'mapi/exchange.pyi', 'mapi/mapi.pyi', 'mapi/mapitags.pyi', 'mapi/mapiutil.pyi', 'propsys/__init__.pyi', 'propsys/propsys.pyi', 'propsys/pscon.pyi', 'shell/__init__.pyi', 'shell/shell.pyi', 'shell/shellcon.pyi', 'taskscheduler/__init__.pyi', 'taskscheduler/taskscheduler.pyi', 'METADATA.toml'], '_win32typing-stubs': ['__init__.pyi', 'METADATA.toml'], 'win2kras-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32api-stubs': ['__init__.pyi', 'METADATA.toml'], 'timer-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32clipboard-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32print-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32event-stubs': ['__init__.pyi', 'METADATA.toml'], 'pywintypes-stubs': ['__init__.pyi', 'METADATA.toml'], 'win32evtlogutil-stubs': ['__init__.pyi', 'METADATA.toml'], 'dde-stubs': ['__init__.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Programming Language :: Python :: 3",
          "Typing :: Stubs Only",
      ]
)
