"""Examples of graph data used by the Flask app."""

JGF1 = """{"graph": {
    "directed": true,
    "metadata": {"node_size": 20},
    "nodes": [
        {"id": "s0", "metadata": {"x": -50, "y": 0, "size": 0}},
        {"id": "s1", "metadata": {"x": 0, "y": 0, "color": "red", "label_color": "red"}},
        {"id": "s2", "metadata": {"x": 100, "y": 0, "color": "green", "label_color": "green"}},
        {"id": "s3", "metadata": {"x": 200, "y": 0, "color": "blue", "label_color": "blue"}}
    ],
    "edges": [
        {"source": "s0", "target": "s1"},
        {"source": "s1", "target": "s2", "label": "a"},
        {"source": "s1", "target": "s2", "label": "b"},
        {"source": "s2", "target": "s2", "label": "a"},
        {"source": "s2", "target": "s2", "label": "b"},
        {"source": "s2", "target": "s1", "label": "c"},
        {"source": "s2", "target": "s1", "label": "d"},
        {"source": "s2", "target": "s1", "label": "e"},
        {"source": "s2", "target": "s3", "label": "f"},
        {"source": "s3", "target": "s3", "label": "a"},
        {"source": "s3", "target": "s3", "label": "b"},
        {"source": "s3", "target": "s2", "label": "f"}
    ]
}}""".replace('\n', '\\n')

JGF2 = """{"graph": {
    "directed": false,
    "metadata": {"node_border_size": 2, "node_border_color": "white", "edge_color": "black", "edge_opacity": 0.9},
    "nodes": [
        {"id": "Napoleon", "metadata": {"size": 5.5, "color": "blue", "x": -60, "y": -300, "z": 0}},
        {"id": "Myriel", "metadata": {"size": 10.0, "color": "blue", "x": 135, "y": -300, "z": 0}},
        {"id": "MlleBaptistine", "metadata": {"size": 6.5, "color": "blue", "x": 70, "y": -300, "z": 0}},
        {"id": "MmeMagloire", "metadata": {"size": 6.5, "color": "blue", "x": 5, "y": -300, "z": 0}},
        {"id": "CountessDeLo", "metadata": {"size": 5.5, "color": "blue", "x": -125, "y": -300, "z": 0}},
        {"id": "Geborand", "metadata": {"size": 5.5, "color": "blue", "x": -385, "y": -300, "z": 0}},
        {"id": "Champtercier", "metadata": {"size": 5.5, "color": "blue", "x": -255, "y": -300, "z": 0}},
        {"id": "Cravatte", "metadata": {"size": 5.5, "color": "blue", "x": -450, "y": -300, "z": 0}},
        {"id": "Count", "metadata": {"size": 5.5, "color": "blue", "x": -190, "y": -300, "z": 0}},
        {"id": "OldMan", "metadata": {"size": 5.5, "color": "blue", "x": -320, "y": -300, "z": 0}},
        {"id": "Valjean", "metadata": {"size": 23.0, "color": "orange", "x": 395, "y": -235, "z": 0}},
        {"id": "Labarre", "metadata": {"size": 5.5, "color": "orange", "x": -450, "y": -235, "z": 0}},
        {"id": "Marguerite", "metadata": {"size": 6.0, "color": "green", "x": -385, "y": -170, "z": 0}},
        {"id": "MmeDeR", "metadata": {"size": 5.5, "color": "orange", "x": -190, "y": -235, "z": 0}},
        {"id": "Isabeau", "metadata": {"size": 5.5, "color": "orange", "x": -255, "y": -235, "z": 0}},
        {"id": "Gervais", "metadata": {"size": 5.5, "color": "orange", "x": -320, "y": -235, "z": 0}},
        {"id": "Listolier", "metadata": {"size": 8.5, "color": "green", "x": -255, "y": -170, "z": 0}},
        {"id": "Tholomyes", "metadata": {"size": 9.5, "color": "green", "x": 70, "y": -170, "z": 0}},
        {"id": "Fameuil", "metadata": {"size": 8.5, "color": "green", "x": 5, "y": -170, "z": 0}},
        {"id": "Blacheville", "metadata": {"size": 8.5, "color": "green", "x": -320, "y": -170, "z": 0}},
        {"id": "Favourite", "metadata": {"size": 8.5, "color": "green", "x": -190, "y": -170, "z": 0}},
        {"id": "Dahlia", "metadata": {"size": 8.5, "color": "green", "x": -125, "y": -170, "z": 0}},
        {"id": "Zephine", "metadata": {"size": 8.5, "color": "green", "x": -60, "y": -170, "z": 0}},
        {"id": "Fantine", "metadata": {"size": 12.5, "color": "green", "x": 135, "y": -170, "z": 0}},
        {"id": "MmeThenardier", "metadata": {"size": 10.5, "color": "red", "x": 5, "y": -105, "z": 0}},
        {"id": "Thenardier", "metadata": {"size": 13.0, "color": "red", "x": 135, "y": -105, "z": 0}},
        {"id": "Cosette", "metadata": {"size": 10.5, "color": "darkviolet", "x": 135, "y": -40, "z": 0}},
        {"id": "Javert", "metadata": {"size": 13.5, "color": "red", "x": 200, "y": -105, "z": 0}},
        {"id": "Fauchelevent", "metadata": {"size": 7.0, "color": "brown", "x": -320, "y": 25, "z": 0}},
        {"id": "Bamatabois", "metadata": {"size": 9.0, "color": "orange", "x": 330, "y": -235, "z": 0}},
        {"id": "Perpetue", "metadata": {"size": 6.0, "color": "green", "x": -450, "y": -170, "z": 0}},
        {"id": "Simplice", "metadata": {"size": 7.0, "color": "orange", "x": -60, "y": -235, "z": 0}},
        {"id": "Scaufflaire", "metadata": {"size": 5.5, "color": "orange", "x": -385, "y": -235, "z": 0}},
        {"id": "Woman1", "metadata": {"size": 6.0, "color": "orange", "x": -125, "y": -235, "z": 0}},
        {"id": "Judge", "metadata": {"size": 8.0, "color": "orange", "x": 135, "y": -235, "z": 0}},
        {"id": "Champmathieu", "metadata": {"size": 8.0, "color": "orange", "x": 265, "y": -235, "z": 0}},
        {"id": "Brevet", "metadata": {"size": 8.0, "color": "orange", "x": 200, "y": -235, "z": 0}},
        {"id": "Chenildieu", "metadata": {"size": 8.0, "color": "orange", "x": 5, "y": -235, "z": 0}},
        {"id": "Cochepaille", "metadata": {"size": 8.0, "color": "orange", "x": 70, "y": -235, "z": 0}},
        {"id": "Pontmercy", "metadata": {"size": 6.5, "color": "red", "x": -385, "y": -105, "z": 0}},
        {"id": "Boulatruelle", "metadata": {"size": 5.5, "color": "pink", "x": -450, "y": 90, "z": 0}},
        {"id": "Eponine", "metadata": {"size": 10.5, "color": "red", "x": 70, "y": -105, "z": 0}},
        {"id": "Anzelma", "metadata": {"size": 6.5, "color": "red", "x": -450, "y": -105, "z": 0}},
        {"id": "Woman2", "metadata": {"size": 6.5, "color": "darkviolet", "x": -125, "y": -40, "z": 0}},
        {"id": "MotherInnocent", "metadata": {"size": 6.0, "color": "brown", "x": -385, "y": 25, "z": 0}},
        {"id": "Gribier", "metadata": {"size": 5.5, "color": "brown", "x": -450, "y": 25, "z": 0}},
        {"id": "MmeBurgon", "metadata": {"size": 6.0, "color": "gray", "x": -385, "y": 155, "z": 0}},
        {"id": "Jondrette", "metadata": {"size": 5.5, "color": "gray", "x": -450, "y": 155, "z": 0}},
        {"id": "Gavroche", "metadata": {"size": 16.0, "color": "yellowgreen", "x": 330, "y": 220, "z": 0}},
        {"id": "Gillenormand", "metadata": {"size": 8.5, "color": "darkviolet", "x": 70, "y": -40, "z": 0}},
        {"id": "Magnon", "metadata": {"size": 6.0, "color": "darkviolet", "x": -255, "y": -40, "z": 0}},
        {"id": "MlleGillenormand", "metadata": {"size": 8.5, "color": "darkviolet", "x": 5, "y": -40, "z": 0}},
        {"id": "MmePontmercy", "metadata": {"size": 6.0, "color": "darkviolet", "x": -320, "y": -40, "z": 0}},
        {"id": "MlleVaubois", "metadata": {"size": 5.5, "color": "darkviolet", "x": -450, "y": -40, "z": 0}},
        {"id": "LtGillenormand", "metadata": {"size": 7.0, "color": "darkviolet", "x": -60, "y": -40, "z": 0}},
        {"id": "Marius", "metadata": {"size": 14.5, "color": "yellowgreen", "x": 265, "y": 220, "z": 0}},
        {"id": "BaronessT", "metadata": {"size": 6.0, "color": "darkviolet", "x": -385, "y": -40, "z": 0}},
        {"id": "Mabeuf", "metadata": {"size": 10.5, "color": "yellowgreen", "x": -125, "y": 220, "z": 0}},
        {"id": "Enjolras", "metadata": {"size": 12.5, "color": "yellowgreen", "x": 200, "y": 220, "z": 0}},
        {"id": "Combeferre", "metadata": {"size": 10.5, "color": "yellowgreen", "x": -190, "y": 220, "z": 0}},
        {"id": "Prouvaire", "metadata": {"size": 9.5, "color": "yellowgreen", "x": -385, "y": 220, "z": 0}},
        {"id": "Feuilly", "metadata": {"size": 10.5, "color": "yellowgreen", "x": -255, "y": 220, "z": 0}},
        {"id": "Courfeyrac", "metadata": {"size": 11.5, "color": "yellowgreen", "x": 70, "y": 220, "z": 0}},
        {"id": "Bahorel", "metadata": {"size": 11.0, "color": "yellowgreen", "x": -60, "y": 220, "z": 0}},
        {"id": "Bossuet", "metadata": {"size": 11.5, "color": "yellowgreen", "x": 135, "y": 220, "z": 0}},
        {"id": "Joly", "metadata": {"size": 11.0, "color": "yellowgreen", "x": 5, "y": 220, "z": 0}},
        {"id": "Grantaire", "metadata": {"size": 10.0, "color": "yellowgreen", "x": -320, "y": 220, "z": 0}},
        {"id": "MotherPlutarch", "metadata": {"size": 5.5, "color": "lightblue", "x": -450, "y": 285, "z": 0}},
        {"id": "Gueulemer", "metadata": {"size": 10.0, "color": "red", "x": -125, "y": -105, "z": 0}},
        {"id": "Babet", "metadata": {"size": 10.0, "color": "red", "x": -190, "y": -105, "z": 0}},
        {"id": "Claquesous", "metadata": {"size": 10.0, "color": "red", "x": -60, "y": -105, "z": 0}},
        {"id": "Montparnasse", "metadata": {"size": 9.5, "color": "red", "x": -255, "y": -105, "z": 0}},
        {"id": "Toussaint", "metadata": {"size": 6.5, "color": "darkviolet", "x": -190, "y": -40, "z": 0}},
        {"id": "Child1", "metadata": {"size": 6.0, "color": "blue", "x": -450, "y": 350, "z": 0}},
        {"id": "Child2", "metadata": {"size": 6.0, "color": "blue", "x": -385, "y": 350, "z": 0}},
        {"id": "Brujon", "metadata": {"size": 8.5, "color": "red", "x": -320, "y": -105, "z": 0}},
        {"id": "MmeHucheloup", "metadata": {"size": 8.5, "color": "yellowgreen", "x": -450, "y": 220, "z": 0}}
    ],
    "edges": [
        {"source": "Napoleon", "target": "Myriel", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "MlleBaptistine", "metadata": {"weight": 8, "size": 0.3867053998632946, "color": "blue"}},
        {"source": "Myriel", "target": "MmeMagloire", "metadata": {"weight": 10, "size": 0.3867053998632946, "color": "blue"}},
        {"source": "Myriel", "target": "CountessDeLo", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "Geborand", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "Champtercier", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "Cravatte", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "Count", "metadata": {"weight": 2, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "OldMan", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "blue"}},
        {"source": "Myriel", "target": "Valjean", "metadata": {"weight": 5, "size": 9.40926179084074, "color": "gray"}},
        {"source": "MlleBaptistine", "target": "MmeMagloire", "metadata": {"weight": 6, "size": 0.2670881749829118, "color": "blue"}},
        {"source": "MlleBaptistine", "target": "Valjean", "metadata": {"weight": 3, "size": 1.3949077238550924, "color": "gray"}},
        {"source": "MmeMagloire", "target": "Valjean", "metadata": {"weight": 3, "size": 1.3949077238550924, "color": "gray"}},
        {"source": "Valjean", "target": "Labarre", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "orange"}},
        {"source": "Valjean", "target": "Marguerite", "metadata": {"weight": 1, "size": 1.3174684546864999, "color": "gray"}},
        {"source": "Valjean", "target": "MmeDeR", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "orange"}},
        {"source": "Valjean", "target": "Isabeau", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "orange"}},
        {"source": "Valjean", "target": "Gervais", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "orange"}},
        {"source": "Valjean", "target": "Fantine", "metadata": {"weight": 9, "size": 4.060213660641871, "color": "gray"}},
        {"source": "Valjean", "target": "MmeThenardier", "metadata": {"weight": 7, "size": 1.3460398371359983, "color": "gray"}},
        {"source": "Valjean", "target": "Thenardier", "metadata": {"weight": 12, "size": 1.766507197898175, "color": "gray"}},
        {"source": "Valjean", "target": "Cosette", "metadata": {"weight": 31, "size": 1.020541071292951, "color": "gray"}},
        {"source": "Valjean", "target": "Javert", "metadata": {"weight": 17, "size": 0.6285437620024088, "color": "gray"}},
        {"source": "Valjean", "target": "Fauchelevent", "metadata": {"weight": 8, "size": 2.069496293180504, "color": "gray"}},
        {"source": "Valjean", "target": "Bamatabois", "metadata": {"weight": 2, "size": 0.9909695567590308, "color": "orange"}},
        {"source": "Valjean", "target": "Simplice", "metadata": {"weight": 3, "size": 1.405931757385257, "color": "orange"}},
        {"source": "Valjean", "target": "Scaufflaire", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "orange"}},
        {"source": "Valjean", "target": "Woman1", "metadata": {"weight": 2, "size": 1.1853804090646198, "color": "orange"}},
        {"source": "Valjean", "target": "Judge", "metadata": {"weight": 3, "size": 1.3849396217817274, "color": "orange"}},
        {"source": "Valjean", "target": "Champmathieu", "metadata": {"weight": 3, "size": 1.3849396217817274, "color": "orange"}},
        {"source": "Valjean", "target": "Brevet", "metadata": {"weight": 2, "size": 1.3849396217817274, "color": "orange"}},
        {"source": "Valjean", "target": "Chenildieu", "metadata": {"weight": 2, "size": 1.3849396217817274, "color": "orange"}},
        {"source": "Valjean", "target": "Cochepaille", "metadata": {"weight": 2, "size": 1.3849396217817274, "color": "orange"}},
        {"source": "Valjean", "target": "Woman2", "metadata": {"weight": 3, "size": 1.0474317349317348, "color": "gray"}},
        {"source": "Valjean", "target": "MotherInnocent", "metadata": {"weight": 1, "size": 1.5059808612440193, "color": "gray"}},
        {"source": "Valjean", "target": "Gavroche", "metadata": {"weight": 1, "size": 4.399123642265492, "color": "gray"}},
        {"source": "Valjean", "target": "Gillenormand", "metadata": {"weight": 2, "size": 1.6576820852956768, "color": "gray"}},
        {"source": "Valjean", "target": "MlleGillenormand", "metadata": {"weight": 2, "size": 2.502042382126114, "color": "gray"}},
        {"source": "Valjean", "target": "Marius", "metadata": {"weight": 19, "size": 2.4653681210162643, "color": "gray"}},
        {"source": "Valjean", "target": "Enjolras", "metadata": {"weight": 4, "size": 2.217462884476914, "color": "gray"}},
        {"source": "Valjean", "target": "Bossuet", "metadata": {"weight": 1, "size": 2.3638922696281037, "color": "gray"}},
        {"source": "Valjean", "target": "Gueulemer", "metadata": {"weight": 1, "size": 0.9812648713024654, "color": "gray"}},
        {"source": "Valjean", "target": "Babet", "metadata": {"weight": 1, "size": 0.9812648713024654, "color": "gray"}},
        {"source": "Valjean", "target": "Claquesous", "metadata": {"weight": 1, "size": 0.9876729369210574, "color": "gray"}},
        {"source": "Valjean", "target": "Montparnasse", "metadata": {"weight": 1, "size": 1.0021232944165277, "color": "gray"}},
        {"source": "Valjean", "target": "Toussaint", "metadata": {"weight": 1, "size": 1.0474317349317348, "color": "gray"}},
        {"source": "Marguerite", "target": "Fantine", "metadata": {"weight": 2, "size": 0.48123284401479893, "color": "green"}},
        {"source": "Listolier", "target": "Tholomyes", "metadata": {"weight": 4, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Listolier", "target": "Fameuil", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Listolier", "target": "Blacheville", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Listolier", "target": "Favourite", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Listolier", "target": "Dahlia", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Listolier", "target": "Zephine", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Listolier", "target": "Fantine", "metadata": {"weight": 3, "size": 1.124467011685057, "color": "green"}},
        {"source": "Tholomyes", "target": "Fameuil", "metadata": {"weight": 4, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Tholomyes", "target": "Blacheville", "metadata": {"weight": 4, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Tholomyes", "target": "Favourite", "metadata": {"weight": 3, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Tholomyes", "target": "Dahlia", "metadata": {"weight": 3, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Tholomyes", "target": "Zephine", "metadata": {"weight": 3, "size": 0.5887934121016828, "color": "green"}},
        {"source": "Tholomyes", "target": "Fantine", "metadata": {"weight": 3, "size": 0.6080513690179566, "color": "green"}},
        {"source": "Tholomyes", "target": "Cosette", "metadata": {"weight": 1, "size": 0.9020766201217328, "color": "gray"}},
        {"source": "Tholomyes", "target": "Marius", "metadata": {"weight": 1, "size": 2.4632168801985057, "color": "gray"}},
        {"source": "Fameuil", "target": "Blacheville", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Fameuil", "target": "Favourite", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Fameuil", "target": "Dahlia", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Fameuil", "target": "Zephine", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Fameuil", "target": "Fantine", "metadata": {"weight": 3, "size": 1.124467011685057, "color": "green"}},
        {"source": "Blacheville", "target": "Favourite", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Blacheville", "target": "Dahlia", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Blacheville", "target": "Zephine", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Blacheville", "target": "Fantine", "metadata": {"weight": 3, "size": 1.124467011685057, "color": "green"}},
        {"source": "Favourite", "target": "Dahlia", "metadata": {"weight": 5, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Favourite", "target": "Zephine", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Favourite", "target": "Fantine", "metadata": {"weight": 4, "size": 1.124467011685057, "color": "green"}},
        {"source": "Dahlia", "target": "Zephine", "metadata": {"weight": 4, "size": 0.2670881749829118, "color": "green"}},
        {"source": "Dahlia", "target": "Fantine", "metadata": {"weight": 4, "size": 1.124467011685057, "color": "green"}},
        {"source": "Zephine", "target": "Fantine", "metadata": {"weight": 4, "size": 1.124467011685057, "color": "green"}},
        {"source": "Fantine", "target": "MmeThenardier", "metadata": {"weight": 2, "size": 0.8259256000500825, "color": "gray"}},
        {"source": "Fantine", "target": "Thenardier", "metadata": {"weight": 1, "size": 1.4245333359361743, "color": "gray"}},
        {"source": "Fantine", "target": "Javert", "metadata": {"weight": 5, "size": 1.1811326386433942, "color": "gray"}},
        {"source": "Fantine", "target": "Bamatabois", "metadata": {"weight": 1, "size": 0.8018385123648283, "color": "gray"}},
        {"source": "Fantine", "target": "Perpetue", "metadata": {"weight": 1, "size": 1.1108195344253404, "color": "green"}},
        {"source": "Fantine", "target": "Simplice", "metadata": {"weight": 2, "size": 0.4358667648141332, "color": "gray"}},
        {"source": "MmeThenardier", "target": "Thenardier", "metadata": {"weight": 13, "size": 0.4138676749974731, "color": "red"}},
        {"source": "MmeThenardier", "target": "Cosette", "metadata": {"weight": 4, "size": 0.4342064577026983, "color": "gray"}},
        {"source": "MmeThenardier", "target": "Javert", "metadata": {"weight": 1, "size": 0.47784776890435765, "color": "red"}},
        {"source": "MmeThenardier", "target": "Eponine", "metadata": {"weight": 2, "size": 0.5466404587744385, "color": "red"}},
        {"source": "MmeThenardier", "target": "Anzelma", "metadata": {"weight": 1, "size": 0.6784249585001466, "color": "red"}},
        {"source": "MmeThenardier", "target": "Magnon", "metadata": {"weight": 1, "size": 1.016305074031627, "color": "gray"}},
        {"source": "MmeThenardier", "target": "Gueulemer", "metadata": {"weight": 1, "size": 0.3843702300864944, "color": "red"}},
        {"source": "MmeThenardier", "target": "Babet", "metadata": {"weight": 1, "size": 0.3843702300864944, "color": "red"}},
        {"source": "MmeThenardier", "target": "Claquesous", "metadata": {"weight": 1, "size": 0.3656139237362031, "color": "red"}},
        {"source": "Thenardier", "target": "Cosette", "metadata": {"weight": 1, "size": 0.5203097862872299, "color": "gray"}},
        {"source": "Thenardier", "target": "Javert", "metadata": {"weight": 5, "size": 0.5067154023920941, "color": "red"}},
        {"source": "Thenardier", "target": "Pontmercy", "metadata": {"weight": 1, "size": 1.0390905564777746, "color": "red"}},
        {"source": "Thenardier", "target": "Boulatruelle", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "gray"}},
        {"source": "Thenardier", "target": "Eponine", "metadata": {"weight": 3, "size": 0.48939078983106155, "color": "red"}},
        {"source": "Thenardier", "target": "Anzelma", "metadata": {"weight": 2, "size": 0.9057383719037855, "color": "red"}},
        {"source": "Thenardier", "target": "Gavroche", "metadata": {"weight": 1, "size": 1.1639148121646496, "color": "gray"}},
        {"source": "Thenardier", "target": "Marius", "metadata": {"weight": 2, "size": 0.6765125652987016, "color": "gray"}},
        {"source": "Thenardier", "target": "Gueulemer", "metadata": {"weight": 5, "size": 0.36790840738209163, "color": "red"}},
        {"source": "Thenardier", "target": "Babet", "metadata": {"weight": 6, "size": 0.36790840738209163, "color": "red"}},
        {"source": "Thenardier", "target": "Claquesous", "metadata": {"weight": 4, "size": 0.38684780132148555, "color": "red"}},
        {"source": "Thenardier", "target": "Montparnasse", "metadata": {"weight": 1, "size": 0.38852949473250226, "color": "red"}},
        {"source": "Thenardier", "target": "Brujon", "metadata": {"weight": 3, "size": 0.6277988928364868, "color": "red"}},
        {"source": "Cosette", "target": "Javert", "metadata": {"weight": 1, "size": 0.48100228927296595, "color": "gray"}},
        {"source": "Cosette", "target": "Woman2", "metadata": {"weight": 1, "size": 0.45046291427870366, "color": "darkviolet"}},
        {"source": "Cosette", "target": "Gillenormand", "metadata": {"weight": 3, "size": 0.40074211502782936, "color": "darkviolet"}},
        {"source": "Cosette", "target": "MlleGillenormand", "metadata": {"weight": 2, "size": 0.5473342447026659, "color": "darkviolet"}},
        {"source": "Cosette", "target": "LtGillenormand", "metadata": {"weight": 1, "size": 0.6003075871496925, "color": "darkviolet"}},
        {"source": "Cosette", "target": "Marius", "metadata": {"weight": 21, "size": 0.5590721934706897, "color": "gray"}},
        {"source": "Cosette", "target": "Toussaint", "metadata": {"weight": 2, "size": 0.4504629142787038, "color": "darkviolet"}},
        {"source": "Javert", "target": "Fauchelevent", "metadata": {"weight": 1, "size": 0.9680976917819026, "color": "gray"}},
        {"source": "Javert", "target": "Bamatabois", "metadata": {"weight": 1, "size": 0.5620563646879435, "color": "gray"}},
        {"source": "Javert", "target": "Simplice", "metadata": {"weight": 1, "size": 0.6106081908120427, "color": "gray"}},
        {"source": "Javert", "target": "Woman1", "metadata": {"weight": 1, "size": 0.6133208896366793, "color": "gray"}},
        {"source": "Javert", "target": "Woman2", "metadata": {"weight": 1, "size": 0.5508066494908599, "color": "gray"}},
        {"source": "Javert", "target": "Gavroche", "metadata": {"weight": 1, "size": 1.2861689270582843, "color": "gray"}},
        {"source": "Javert", "target": "Enjolras", "metadata": {"weight": 6, "size": 0.8026252151311141, "color": "gray"}},
        {"source": "Javert", "target": "Gueulemer", "metadata": {"weight": 1, "size": 0.3991819583924847, "color": "red"}},
        {"source": "Javert", "target": "Babet", "metadata": {"weight": 2, "size": 0.3991819583924847, "color": "red"}},
        {"source": "Javert", "target": "Claquesous", "metadata": {"weight": 1, "size": 0.40559002401107663, "color": "red"}},
        {"source": "Javert", "target": "Montparnasse", "metadata": {"weight": 1, "size": 0.41704995088453733, "color": "red"}},
        {"source": "Javert", "target": "Toussaint", "metadata": {"weight": 1, "size": 0.5508066494908601, "color": "gray"}},
        {"source": "Fauchelevent", "target": "MotherInnocent", "metadata": {"weight": 3, "size": 0.29272043745727955, "color": "brown"}},
        {"source": "Fauchelevent", "target": "Gribier", "metadata": {"weight": 2, "size": 1.5487012987012987, "color": "brown"}},
        {"source": "Bamatabois", "target": "Judge", "metadata": {"weight": 2, "size": 0.3454089769879244, "color": "orange"}},
        {"source": "Bamatabois", "target": "Champmathieu", "metadata": {"weight": 2, "size": 0.3454089769879244, "color": "orange"}},
        {"source": "Bamatabois", "target": "Brevet", "metadata": {"weight": 1, "size": 0.3454089769879244, "color": "orange"}},
        {"source": "Bamatabois", "target": "Chenildieu", "metadata": {"weight": 1, "size": 0.3454089769879244, "color": "orange"}},
        {"source": "Bamatabois", "target": "Cochepaille", "metadata": {"weight": 1, "size": 0.3454089769879244, "color": "orange"}},
        {"source": "Perpetue", "target": "Simplice", "metadata": {"weight": 2, "size": 0.6878817642759585, "color": "gray"}},
        {"source": "Judge", "target": "Champmathieu", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Judge", "target": "Brevet", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Judge", "target": "Chenildieu", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Judge", "target": "Cochepaille", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Champmathieu", "target": "Brevet", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Champmathieu", "target": "Chenildieu", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Champmathieu", "target": "Cochepaille", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Brevet", "target": "Chenildieu", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Brevet", "target": "Cochepaille", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Chenildieu", "target": "Cochepaille", "metadata": {"weight": 2, "size": 0.2670881749829118, "color": "orange"}},
        {"source": "Pontmercy", "target": "MmePontmercy", "metadata": {"weight": 1, "size": 0.621454203691046, "color": "gray"}},
        {"source": "Pontmercy", "target": "Marius", "metadata": {"weight": 1, "size": 1.0627122459829228, "color": "gray"}},
        {"source": "Eponine", "target": "Anzelma", "metadata": {"weight": 2, "size": 0.4645379682973668, "color": "red"}},
        {"source": "Eponine", "target": "Marius", "metadata": {"weight": 5, "size": 0.6680807705243796, "color": "gray"}},
        {"source": "Eponine", "target": "Mabeuf", "metadata": {"weight": 1, "size": 0.5536019758055463, "color": "gray"}},
        {"source": "Eponine", "target": "Courfeyrac", "metadata": {"weight": 1, "size": 0.5191135576045396, "color": "gray"}},
        {"source": "Eponine", "target": "Gueulemer", "metadata": {"weight": 1, "size": 0.39508726444816666, "color": "red"}},
        {"source": "Eponine", "target": "Babet", "metadata": {"weight": 1, "size": 0.39508726444816666, "color": "red"}},
        {"source": "Eponine", "target": "Claquesous", "metadata": {"weight": 1, "size": 0.3901032134114841, "color": "red"}},
        {"source": "Eponine", "target": "Montparnasse", "metadata": {"weight": 1, "size": 0.4029871548668541, "color": "red"}},
        {"source": "Eponine", "target": "Brujon", "metadata": {"weight": 1, "size": 0.3429881521986785, "color": "red"}},
        {"source": "MmeBurgon", "target": "Jondrette", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "gray"}},
        {"source": "MmeBurgon", "target": "Gavroche", "metadata": {"weight": 2, "size": 2.813226247436774, "color": "gray"}},
        {"source": "Gavroche", "target": "Marius", "metadata": {"weight": 4, "size": 1.1256548909712922, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Mabeuf", "metadata": {"weight": 1, "size": 0.8464037420100707, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Enjolras", "metadata": {"weight": 7, "size": 0.3757404875825929, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Combeferre", "metadata": {"weight": 6, "size": 0.5888747843635063, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Prouvaire", "metadata": {"weight": 1, "size": 0.7304353958489298, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Feuilly", "metadata": {"weight": 2, "size": 0.5888747843635063, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Courfeyrac", "metadata": {"weight": 7, "size": 0.5464218527776488, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Bahorel", "metadata": {"weight": 5, "size": 0.5864336165088044, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Bossuet", "metadata": {"weight": 5, "size": 0.39769065520945224, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Joly", "metadata": {"weight": 3, "size": 0.5864336165088044, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Grantaire", "metadata": {"weight": 1, "size": 0.7279942279942281, "color": "yellowgreen"}},
        {"source": "Gavroche", "target": "Gueulemer", "metadata": {"weight": 1, "size": 0.5671933593381951, "color": "gray"}},
        {"source": "Gavroche", "target": "Babet", "metadata": {"weight": 1, "size": 0.5671933593381951, "color": "gray"}},
        {"source": "Gavroche", "target": "Montparnasse", "metadata": {"weight": 1, "size": 0.5261638945849472, "color": "gray"}},
        {"source": "Gavroche", "target": "Child1", "metadata": {"weight": 2, "size": 1.531613123718387, "color": "gray"}},
        {"source": "Gavroche", "target": "Child2", "metadata": {"weight": 2, "size": 1.531613123718387, "color": "gray"}},
        {"source": "Gavroche", "target": "Brujon", "metadata": {"weight": 1, "size": 0.6440232699631196, "color": "gray"}},
        {"source": "Gavroche", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.7498960848962648, "color": "yellowgreen"}},
        {"source": "Gillenormand", "target": "Magnon", "metadata": {"weight": 1, "size": 0.8035530127437529, "color": "darkviolet"}},
        {"source": "Gillenormand", "target": "MlleGillenormand", "metadata": {"weight": 9, "size": 0.37531328320802004, "color": "darkviolet"}},
        {"source": "Gillenormand", "target": "LtGillenormand", "metadata": {"weight": 1, "size": 0.4190779980253665, "color": "darkviolet"}},
        {"source": "Gillenormand", "target": "Marius", "metadata": {"weight": 12, "size": 0.7446839773889455, "color": "gray"}},
        {"source": "Gillenormand", "target": "BaronessT", "metadata": {"weight": 1, "size": 0.6162158643361652, "color": "darkviolet"}},
        {"source": "MlleGillenormand", "target": "MmePontmercy", "metadata": {"weight": 1, "size": 1.211423444976077, "color": "darkviolet"}},
        {"source": "MlleGillenormand", "target": "MlleVaubois", "metadata": {"weight": 1, "size": 1.5487012987012987, "color": "darkviolet"}},
        {"source": "MlleGillenormand", "target": "LtGillenormand", "metadata": {"weight": 2, "size": 0.42762208551682246, "color": "darkviolet"}},
        {"source": "MlleGillenormand", "target": "Marius", "metadata": {"weight": 6, "size": 1.0725237680979307, "color": "gray"}},
        {"source": "LtGillenormand", "target": "Marius", "metadata": {"weight": 1, "size": 0.8516936280094176, "color": "gray"}},
        {"source": "Marius", "target": "BaronessT", "metadata": {"weight": 1, "size": 1.1824854343651334, "color": "gray"}},
        {"source": "Marius", "target": "Mabeuf", "metadata": {"weight": 1, "size": 1.0985799713534827, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Enjolras", "metadata": {"weight": 7, "size": 0.5312644234605238, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Combeferre", "metadata": {"weight": 5, "size": 0.7595296781899653, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Feuilly", "metadata": {"weight": 1, "size": 0.7595296781899653, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Courfeyrac", "metadata": {"weight": 9, "size": 0.7591624552265143, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Bahorel", "metadata": {"weight": 1, "size": 0.7920625226044876, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Bossuet", "metadata": {"weight": 5, "size": 0.5448129050541182, "color": "yellowgreen"}},
        {"source": "Marius", "target": "Joly", "metadata": {"weight": 2, "size": 0.7920625226044876, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Enjolras", "metadata": {"weight": 1, "size": 0.6255482184174235, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Combeferre", "metadata": {"weight": 2, "size": 0.3029733424470267, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Feuilly", "metadata": {"weight": 1, "size": 0.3029733424470267, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Courfeyrac", "metadata": {"weight": 2, "size": 0.29841649578491686, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Bahorel", "metadata": {"weight": 2, "size": 0.3086694007746639, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Bossuet", "metadata": {"weight": 1, "size": 0.5484403852885218, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "Joly", "metadata": {"weight": 1, "size": 0.3086694007746639, "color": "yellowgreen"}},
        {"source": "Mabeuf", "target": "MotherPlutarch", "metadata": {"weight": 3, "size": 1.5487012987012987, "color": "gray"}},
        {"source": "Enjolras", "target": "Combeferre", "metadata": {"weight": 15, "size": 0.44343542839783445, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Prouvaire", "metadata": {"weight": 4, "size": 0.5473539713115927, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Feuilly", "metadata": {"weight": 6, "size": 0.44343542839783445, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Courfeyrac", "metadata": {"weight": 17, "size": 0.43350206546298387, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Bahorel", "metadata": {"weight": 4, "size": 0.44099426054313273, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Bossuet", "metadata": {"weight": 10, "size": 0.28132832080200504, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Joly", "metadata": {"weight": 5, "size": 0.44099426054313273, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Grantaire", "metadata": {"weight": 3, "size": 0.544912803456891, "color": "yellowgreen"}},
        {"source": "Enjolras", "target": "Claquesous", "metadata": {"weight": 1, "size": 0.5004477615775598, "color": "gray"}},
        {"source": "Enjolras", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.5644632518193514, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Prouvaire", "metadata": {"weight": 2, "size": 0.29753003129626504, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Feuilly", "metadata": {"weight": 5, "size": 0.2670881749829118, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Courfeyrac", "metadata": {"weight": 13, "size": 0.2797822478273606, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Bahorel", "metadata": {"weight": 5, "size": 0.26952934283761354, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Bossuet", "metadata": {"weight": 9, "size": 0.3922251516236479, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Joly", "metadata": {"weight": 5, "size": 0.26952934283761354, "color": "yellowgreen"}},
        {"source": "Combeferre", "target": "Grantaire", "metadata": {"weight": 1, "size": 0.29997119915096676, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Feuilly", "metadata": {"weight": 2, "size": 0.29753003129626504, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Courfeyrac", "metadata": {"weight": 3, "size": 0.3281260017418596, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Bahorel", "metadata": {"weight": 2, "size": 0.29997119915096676, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Bossuet", "metadata": {"weight": 2, "size": 0.4782541260668397, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Joly", "metadata": {"weight": 2, "size": 0.29997119915096676, "color": "yellowgreen"}},
        {"source": "Prouvaire", "target": "Grantaire", "metadata": {"weight": 1, "size": 0.26952934283761354, "color": "yellowgreen"}},
        {"source": "Feuilly", "target": "Courfeyrac", "metadata": {"weight": 6, "size": 0.2797822478273606, "color": "yellowgreen"}},
        {"source": "Feuilly", "target": "Bahorel", "metadata": {"weight": 3, "size": 0.26952934283761354, "color": "yellowgreen"}},
        {"source": "Feuilly", "target": "Bossuet", "metadata": {"weight": 6, "size": 0.3922251516236479, "color": "yellowgreen"}},
        {"source": "Feuilly", "target": "Joly", "metadata": {"weight": 5, "size": 0.26952934283761354, "color": "yellowgreen"}},
        {"source": "Feuilly", "target": "Grantaire", "metadata": {"weight": 1, "size": 0.29997119915096676, "color": "yellowgreen"}},
        {"source": "Courfeyrac", "target": "Bahorel", "metadata": {"weight": 6, "size": 0.27734107997265894, "color": "yellowgreen"}},
        {"source": "Courfeyrac", "target": "Bossuet", "metadata": {"weight": 12, "size": 0.3961687328258837, "color": "yellowgreen"}},
        {"source": "Courfeyrac", "target": "Joly", "metadata": {"weight": 5, "size": 0.27734107997265894, "color": "yellowgreen"}},
        {"source": "Courfeyrac", "target": "Grantaire", "metadata": {"weight": 2, "size": 0.32568483388715785, "color": "yellowgreen"}},
        {"source": "Courfeyrac", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.340881038892515, "color": "yellowgreen"}},
        {"source": "Bahorel", "target": "Bossuet", "metadata": {"weight": 4, "size": 0.3897839837689462, "color": "yellowgreen"}},
        {"source": "Bahorel", "target": "Joly", "metadata": {"weight": 5, "size": 0.2670881749829118, "color": "yellowgreen"}},
        {"source": "Bahorel", "target": "Grantaire", "metadata": {"weight": 1, "size": 0.29753003129626504, "color": "yellowgreen"}},
        {"source": "Bahorel", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.3126405812891765, "color": "yellowgreen"}},
        {"source": "Bossuet", "target": "Joly", "metadata": {"weight": 7, "size": 0.3897839837689462, "color": "yellowgreen"}},
        {"source": "Bossuet", "target": "Grantaire", "metadata": {"weight": 3, "size": 0.475812958212138, "color": "yellowgreen"}},
        {"source": "Bossuet", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.49376808196779776, "color": "yellowgreen"}},
        {"source": "Joly", "target": "Grantaire", "metadata": {"weight": 2, "size": 0.29753003129626504, "color": "yellowgreen"}},
        {"source": "Joly", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.3126405812891765, "color": "yellowgreen"}},
        {"source": "Grantaire", "target": "MmeHucheloup", "metadata": {"weight": 1, "size": 0.27441167854701687, "color": "yellowgreen"}},
        {"source": "Gueulemer", "target": "Babet", "metadata": {"weight": 6, "size": 0.2670881749829118, "color": "red"}},
        {"source": "Gueulemer", "target": "Claquesous", "metadata": {"weight": 4, "size": 0.28204032809295965, "color": "red"}},
        {"source": "Gueulemer", "target": "Montparnasse", "metadata": {"weight": 2, "size": 0.2716653647104775, "color": "red"}},
        {"source": "Gueulemer", "target": "Brujon", "metadata": {"weight": 3, "size": 0.36605562357442056, "color": "red"}},
        {"source": "Babet", "target": "Claquesous", "metadata": {"weight": 4, "size": 0.28204032809295965, "color": "red"}},
        {"source": "Babet", "target": "Montparnasse", "metadata": {"weight": 2, "size": 0.2716653647104775, "color": "red"}},
        {"source": "Babet", "target": "Brujon", "metadata": {"weight": 3, "size": 0.36605562357442056, "color": "red"}},
        {"source": "Claquesous", "target": "Montparnasse", "metadata": {"weight": 2, "size": 0.28661751782052536, "color": "red"}},
        {"source": "Claquesous", "target": "Brujon", "metadata": {"weight": 1, "size": 0.3852798204301964, "color": "red"}},
        {"source": "Montparnasse", "target": "Brujon", "metadata": {"weight": 1, "size": 0.35922035358125587, "color": "red"}},
        {"source": "Child1", "target": "Child2", "metadata": {"weight": 3, "size": 0.2670881749829118, "color": "blue"}}
    ]
}}""".replace('\n', '\\n')
