// Project site:     https://github.com/vasturiano/3d-force-graph
// Code source:      https://unpkg.com/3d-force-graph@1.56.5/dist/3d-force-graph.min.js - accessed on 31.12.2019
// Original license: MIT
// Code changes:     Commented out outermost functions
//                   Wrapped all into a require define function

if(!require.defined("up-3d-force-graph")){
  define("up-3d-force-graph", ["exports"],

// Version 1.56.5 3d-force-graph - https://github.com/vasturiano/3d-force-graph
// !function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():
// "function"==typeof define&&define.amd?define(t):(e=e||self).ForceGraph3D=t()}(this,(
function(){"use strict";function e(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function t(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function n(n){for(var r=1;r<arguments.length;r++){var i=null!=arguments[r]?arguments[r]:{};r%2?t(Object(i),!0).forEach((function(t){e(n,t,i[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(i)):t(Object(i)).forEach((function(e){Object.defineProperty(n,e,Object.getOwnPropertyDescriptor(i,e))}))}return n}function r(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var r=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===n&&r.firstChild?r.insertBefore(i,r.firstChild):r.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}(".graph-info-msg {\n  top: 50%;\n  width: 100%;\n  text-align: center;\n  color: lavender;\n  opacity: 0.7;\n  font-size: 22px;\n  position: absolute;\n  font-family: Sans-serif;\n}\n\n.grabbable {\n  cursor: move;\n  cursor: grab;\n  cursor: -moz-grab;\n  cursor: -webkit-grab;\n}\n\n.grabbable:active {\n  cursor: grabbing;\n  cursor: -moz-grabbing;\n  cursor: -webkit-grabbing;\n}"),void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Number.isInteger&&(Number.isInteger=function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e}),void 0===Math.sign&&(Math.sign=function(e){return e<0?-1:e>0?1:+e}),"name"in Function.prototype==!1&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*([^\(\s]*)/)[1]}}),void 0===Object.assign&&(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),n=1;n<arguments.length;n++){var r=arguments[n];if(null!=r)for(var i in r)Object.prototype.hasOwnProperty.call(r,i)&&(t[i]=r[i])}return t});var i={LEFT:0,MIDDLE:1,RIGHT:2,ROTATE:0,DOLLY:1,PAN:2},o=0,a=1,s=2,c=1,l=2,h=3,u=0,p=1,d=2,f=0,m=1,g=2,v=0,y=1,x=2,b=3,w=4,_=5,M=100,E=101,S=102,T=103,A=104,L=200,P=201,C=202,R=203,O=204,D=205,N=206,I=207,z=208,k=209,F=210,U=0,B=1,j=2,H=3,G=4,V=5,W=6,q=7,X=0,Y=1,Z=2,J=0,Q=1,K=2,$=3,ee=4,te=5,ne=301,re=302,ie=303,oe=304,ae=305,se=306,ce=307,le=1e3,he=1001,ue=1002,pe=1003,de=1004,fe=1005,me=1006,ge=1007,ve=1008,ye=1009,xe=1010,be=1011,we=1012,_e=1013,Me=1014,Ee=1015,Se=1016,Te=1017,Ae=1018,Le=1019,Pe=1020,Ce=1021,Re=1022,Oe=1023,De=1024,Ne=1025,Ie=Oe,ze=1026,ke=1027,Fe=1028,Ue=33776,Be=33777,je=33778,He=33779,Ge=35840,Ve=35841,We=35842,qe=35843,Xe=36196,Ye=37808,Ze=37809,Je=37810,Qe=37811,Ke=37812,$e=37813,et=37814,tt=37815,nt=37816,rt=37817,it=37818,ot=37819,at=37820,st=37821,ct=2201,lt=2400,ht=0,ut=1,pt=2,dt=3e3,ft=3001,mt=3007,gt=3002,vt=3003,yt=3004,xt=3005,bt=3006,wt=3200,_t=3201,Mt=0,Et=1,St=7680,Tt=519,At=35044;function Lt(){}Object.assign(Lt.prototype,{addEventListener:function(e,t){void 0===this._listeners&&(this._listeners={});var n=this._listeners;void 0===n[e]&&(n[e]=[]),-1===n[e].indexOf(t)&&n[e].push(t)},hasEventListener:function(e,t){if(void 0===this._listeners)return!1;var n=this._listeners;return void 0!==n[e]&&-1!==n[e].indexOf(t)},removeEventListener:function(e,t){if(void 0!==this._listeners){var n=this._listeners[e];if(void 0!==n){var r=n.indexOf(t);-1!==r&&n.splice(r,1)}}},dispatchEvent:function(e){if(void 0!==this._listeners){var t=this._listeners[e.type];if(void 0!==t){e.target=this;for(var n=t.slice(0),r=0,i=n.length;r<i;r++)n[r].call(this,e)}}}});for(var Pt=[],Ct=0;Ct<256;Ct++)Pt[Ct]=(Ct<16?"0":"")+Ct.toString(16);var Rt={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var e=4294967295*Math.random()|0,t=4294967295*Math.random()|0,n=4294967295*Math.random()|0,r=4294967295*Math.random()|0;return(Pt[255&e]+Pt[e>>8&255]+Pt[e>>16&255]+Pt[e>>24&255]+"-"+Pt[255&t]+Pt[t>>8&255]+"-"+Pt[t>>16&15|64]+Pt[t>>24&255]+"-"+Pt[63&n|128]+Pt[n>>8&255]+"-"+Pt[n>>16&255]+Pt[n>>24&255]+Pt[255&r]+Pt[r>>8&255]+Pt[r>>16&255]+Pt[r>>24&255]).toUpperCase()},clamp:function(e,t,n){return Math.max(t,Math.min(n,e))},euclideanModulo:function(e,t){return(e%t+t)%t},mapLinear:function(e,t,n,r,i){return r+(e-t)*(i-r)/(n-t)},lerp:function(e,t,n){return(1-n)*e+n*t},smoothstep:function(e,t,n){return e<=t?0:e>=n?1:(e=(e-t)/(n-t))*e*(3-2*e)},smootherstep:function(e,t,n){return e<=t?0:e>=n?1:(e=(e-t)/(n-t))*e*e*(e*(6*e-15)+10)},randInt:function(e,t){return e+Math.floor(Math.random()*(t-e+1))},randFloat:function(e,t){return e+Math.random()*(t-e)},randFloatSpread:function(e){return e*(.5-Math.random())},degToRad:function(e){return e*Rt.DEG2RAD},radToDeg:function(e){return e*Rt.RAD2DEG},isPowerOfTwo:function(e){return 0==(e&e-1)&&0!==e},ceilPowerOfTwo:function(e){return Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))},floorPowerOfTwo:function(e){return Math.pow(2,Math.floor(Math.log(e)/Math.LN2))}};function Ot(e,t){this.x=e||0,this.y=t||0}function Dt(e,t,n,r){this._x=e||0,this._y=t||0,this._z=n||0,this._w=void 0!==r?r:1}Object.defineProperties(Ot.prototype,{width:{get:function(){return this.x},set:function(e){this.x=e}},height:{get:function(){return this.y},set:function(e){this.y=e}}}),Object.assign(Ot.prototype,{isVector2:!0,set:function(e,t){return this.x=e,this.y=t,this},setScalar:function(e){return this.x=e,this.y=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;default:throw new Error("index is out of range: "+e)}return this},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(e){return this.x=e.x,this.y=e.y,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this)},addScalar:function(e){return this.x+=e,this.y+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this)},subScalar:function(e){return this.x-=e,this.y-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this},multiply:function(e){return this.x*=e.x,this.y*=e.y,this},multiplyScalar:function(e){return this.x*=e,this.y*=e,this},divide:function(e){return this.x/=e.x,this.y/=e.y,this},divideScalar:function(e){return this.multiplyScalar(1/e)},applyMatrix3:function(e){var t=this.x,n=this.y,r=e.elements;return this.x=r[0]*t+r[3]*n+r[6],this.y=r[1]*t+r[4]*n+r[7],this},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this},clampScalar:function(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this},clampLength:function(e,t){var n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(e){return this.x*e.x+this.y*e.y},cross:function(e){return this.x*e.y-this.y*e.x},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length()||1)},angle:function(){var e=Math.atan2(this.y,this.x);return e<0&&(e+=2*Math.PI),e},distanceTo:function(e){return Math.sqrt(this.distanceToSquared(e))},distanceToSquared:function(e){var t=this.x-e.x,n=this.y-e.y;return t*t+n*n},manhattanDistanceTo:function(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)},setLength:function(e){return this.normalize().multiplyScalar(e)},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this},lerpVectors:function(e,t,n){return this.subVectors(t,e).multiplyScalar(n).add(e)},equals:function(e){return e.x===this.x&&e.y===this.y},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e},fromBufferAttribute:function(e,t,n){return void 0!==n&&console.warn("THREE.Vector2: offset has been removed from .fromBufferAttribute()."),this.x=e.getX(t),this.y=e.getY(t),this},rotateAround:function(e,t){var n=Math.cos(t),r=Math.sin(t),i=this.x-e.x,o=this.y-e.y;return this.x=i*n-o*r+e.x,this.y=i*r+o*n+e.y,this}}),Object.assign(Dt,{slerp:function(e,t,n,r){return n.copy(e).slerp(t,r)},slerpFlat:function(e,t,n,r,i,o,a){var s=n[r+0],c=n[r+1],l=n[r+2],h=n[r+3],u=i[o+0],p=i[o+1],d=i[o+2],f=i[o+3];if(h!==f||s!==u||c!==p||l!==d){var m=1-a,g=s*u+c*p+l*d+h*f,v=g>=0?1:-1,y=1-g*g;if(y>Number.EPSILON){var x=Math.sqrt(y),b=Math.atan2(x,g*v);m=Math.sin(m*b)/x,a=Math.sin(a*b)/x}var w=a*v;if(s=s*m+u*w,c=c*m+p*w,l=l*m+d*w,h=h*m+f*w,m===1-a){var _=1/Math.sqrt(s*s+c*c+l*l+h*h);s*=_,c*=_,l*=_,h*=_}}e[t]=s,e[t+1]=c,e[t+2]=l,e[t+3]=h}}),Object.defineProperties(Dt.prototype,{x:{get:function(){return this._x},set:function(e){this._x=e,this._onChangeCallback()}},y:{get:function(){return this._y},set:function(e){this._y=e,this._onChangeCallback()}},z:{get:function(){return this._z},set:function(e){this._z=e,this._onChangeCallback()}},w:{get:function(){return this._w},set:function(e){this._w=e,this._onChangeCallback()}}}),Object.assign(Dt.prototype,{isQuaternion:!0,set:function(e,t,n,r){return this._x=e,this._y=t,this._z=n,this._w=r,this._onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(e){return this._x=e.x,this._y=e.y,this._z=e.z,this._w=e.w,this._onChangeCallback(),this},setFromEuler:function(e,t){if(!e||!e.isEuler)throw new Error("THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.");var n=e._x,r=e._y,i=e._z,o=e.order,a=Math.cos,s=Math.sin,c=a(n/2),l=a(r/2),h=a(i/2),u=s(n/2),p=s(r/2),d=s(i/2);return"XYZ"===o?(this._x=u*l*h+c*p*d,this._y=c*p*h-u*l*d,this._z=c*l*d+u*p*h,this._w=c*l*h-u*p*d):"YXZ"===o?(this._x=u*l*h+c*p*d,this._y=c*p*h-u*l*d,this._z=c*l*d-u*p*h,this._w=c*l*h+u*p*d):"ZXY"===o?(this._x=u*l*h-c*p*d,this._y=c*p*h+u*l*d,this._z=c*l*d+u*p*h,this._w=c*l*h-u*p*d):"ZYX"===o?(this._x=u*l*h-c*p*d,this._y=c*p*h+u*l*d,this._z=c*l*d-u*p*h,this._w=c*l*h+u*p*d):"YZX"===o?(this._x=u*l*h+c*p*d,this._y=c*p*h+u*l*d,this._z=c*l*d-u*p*h,this._w=c*l*h-u*p*d):"XZY"===o&&(this._x=u*l*h-c*p*d,this._y=c*p*h-u*l*d,this._z=c*l*d+u*p*h,this._w=c*l*h+u*p*d),!1!==t&&this._onChangeCallback(),this},setFromAxisAngle:function(e,t){var n=t/2,r=Math.sin(n);return this._x=e.x*r,this._y=e.y*r,this._z=e.z*r,this._w=Math.cos(n),this._onChangeCallback(),this},setFromRotationMatrix:function(e){var t,n=e.elements,r=n[0],i=n[4],o=n[8],a=n[1],s=n[5],c=n[9],l=n[2],h=n[6],u=n[10],p=r+s+u;return p>0?(t=.5/Math.sqrt(p+1),this._w=.25/t,this._x=(h-c)*t,this._y=(o-l)*t,this._z=(a-i)*t):r>s&&r>u?(t=2*Math.sqrt(1+r-s-u),this._w=(h-c)/t,this._x=.25*t,this._y=(i+a)/t,this._z=(o+l)/t):s>u?(t=2*Math.sqrt(1+s-r-u),this._w=(o-l)/t,this._x=(i+a)/t,this._y=.25*t,this._z=(c+h)/t):(t=2*Math.sqrt(1+u-r-s),this._w=(a-i)/t,this._x=(o+l)/t,this._y=(c+h)/t,this._z=.25*t),this._onChangeCallback(),this},setFromUnitVectors:function(e,t){var n=e.dot(t)+1;return n<1e-6?(n=0,Math.abs(e.x)>Math.abs(e.z)?(this._x=-e.y,this._y=e.x,this._z=0,this._w=n):(this._x=0,this._y=-e.z,this._z=e.y,this._w=n)):(this._x=e.y*t.z-e.z*t.y,this._y=e.z*t.x-e.x*t.z,this._z=e.x*t.y-e.y*t.x,this._w=n),this.normalize()},angleTo:function(e){return 2*Math.acos(Math.abs(Rt.clamp(this.dot(e),-1,1)))},rotateTowards:function(e,t){var n=this.angleTo(e);if(0===n)return this;var r=Math.min(1,t/n);return this.slerp(e,r),this},inverse:function(){return this.conjugate()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this},dot:function(e){return this._x*e._x+this._y*e._y+this._z*e._z+this._w*e._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var e=this.length();return 0===e?(this._x=0,this._y=0,this._z=0,this._w=1):(e=1/e,this._x=this._x*e,this._y=this._y*e,this._z=this._z*e,this._w=this._w*e),this._onChangeCallback(),this},multiply:function(e,t){return void 0!==t?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(e,t)):this.multiplyQuaternions(this,e)},premultiply:function(e){return this.multiplyQuaternions(e,this)},multiplyQuaternions:function(e,t){var n=e._x,r=e._y,i=e._z,o=e._w,a=t._x,s=t._y,c=t._z,l=t._w;return this._x=n*l+o*a+r*c-i*s,this._y=r*l+o*s+i*a-n*c,this._z=i*l+o*c+n*s-r*a,this._w=o*l-n*a-r*s-i*c,this._onChangeCallback(),this},slerp:function(e,t){if(0===t)return this;if(1===t)return this.copy(e);var n=this._x,r=this._y,i=this._z,o=this._w,a=o*e._w+n*e._x+r*e._y+i*e._z;if(a<0?(this._w=-e._w,this._x=-e._x,this._y=-e._y,this._z=-e._z,a=-a):this.copy(e),a>=1)return this._w=o,this._x=n,this._y=r,this._z=i,this;var s=1-a*a;if(s<=Number.EPSILON){var c=1-t;return this._w=c*o+t*this._w,this._x=c*n+t*this._x,this._y=c*r+t*this._y,this._z=c*i+t*this._z,this.normalize(),this._onChangeCallback(),this}var l=Math.sqrt(s),h=Math.atan2(l,a),u=Math.sin((1-t)*h)/l,p=Math.sin(t*h)/l;return this._w=o*u+this._w*p,this._x=n*u+this._x*p,this._y=r*u+this._y*p,this._z=i*u+this._z*p,this._onChangeCallback(),this},equals:function(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._w===this._w},fromArray:function(e,t){return void 0===t&&(t=0),this._x=e[t],this._y=e[t+1],this._z=e[t+2],this._w=e[t+3],this._onChangeCallback(),this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._w,e},_onChange:function(e){return this._onChangeCallback=e,this},_onChangeCallback:function(){}});var Nt=new zt,It=new Dt;function zt(e,t,n){this.x=e||0,this.y=t||0,this.z=n||0}Object.assign(zt.prototype,{isVector3:!0,set:function(e,t,n){return this.x=e,this.y=t,this.z=n,this},setScalar:function(e){return this.x=e,this.y=e,this.z=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setZ:function(e){return this.z=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;default:throw new Error("index is out of range: "+e)}return this},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this.z+=e.z,this)},addScalar:function(e){return this.x+=e,this.y+=e,this.z+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this.z-=e.z,this)},subScalar:function(e){return this.x-=e,this.y-=e,this.z-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this},multiply:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(e,t)):(this.x*=e.x,this.y*=e.y,this.z*=e.z,this)},multiplyScalar:function(e){return this.x*=e,this.y*=e,this.z*=e,this},multiplyVectors:function(e,t){return this.x=e.x*t.x,this.y=e.y*t.y,this.z=e.z*t.z,this},applyEuler:function(e){return e&&e.isEuler||console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),this.applyQuaternion(It.setFromEuler(e))},applyAxisAngle:function(e,t){return this.applyQuaternion(It.setFromAxisAngle(e,t))},applyMatrix3:function(e){var t=this.x,n=this.y,r=this.z,i=e.elements;return this.x=i[0]*t+i[3]*n+i[6]*r,this.y=i[1]*t+i[4]*n+i[7]*r,this.z=i[2]*t+i[5]*n+i[8]*r,this},applyMatrix4:function(e){var t=this.x,n=this.y,r=this.z,i=e.elements,o=1/(i[3]*t+i[7]*n+i[11]*r+i[15]);return this.x=(i[0]*t+i[4]*n+i[8]*r+i[12])*o,this.y=(i[1]*t+i[5]*n+i[9]*r+i[13])*o,this.z=(i[2]*t+i[6]*n+i[10]*r+i[14])*o,this},applyQuaternion:function(e){var t=this.x,n=this.y,r=this.z,i=e.x,o=e.y,a=e.z,s=e.w,c=s*t+o*r-a*n,l=s*n+a*t-i*r,h=s*r+i*n-o*t,u=-i*t-o*n-a*r;return this.x=c*s+u*-i+l*-a-h*-o,this.y=l*s+u*-o+h*-i-c*-a,this.z=h*s+u*-a+c*-o-l*-i,this},project:function(e){return this.applyMatrix4(e.matrixWorldInverse).applyMatrix4(e.projectionMatrix)},unproject:function(e){return this.applyMatrix4(e.projectionMatrixInverse).applyMatrix4(e.matrixWorld)},transformDirection:function(e){var t=this.x,n=this.y,r=this.z,i=e.elements;return this.x=i[0]*t+i[4]*n+i[8]*r,this.y=i[1]*t+i[5]*n+i[9]*r,this.z=i[2]*t+i[6]*n+i[10]*r,this.normalize()},divide:function(e){return this.x/=e.x,this.y/=e.y,this.z/=e.z,this},divideScalar:function(e){return this.multiplyScalar(1/e)},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this},clampScalar:function(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this.z=Math.max(e,Math.min(t,this.z)),this},clampLength:function(e,t){var n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(e){return this.x*e.x+this.y*e.y+this.z*e.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(e){return this.normalize().multiplyScalar(e)},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this},lerpVectors:function(e,t,n){return this.subVectors(t,e).multiplyScalar(n).add(e)},cross:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(e,t)):this.crossVectors(this,e)},crossVectors:function(e,t){var n=e.x,r=e.y,i=e.z,o=t.x,a=t.y,s=t.z;return this.x=r*s-i*a,this.y=i*o-n*s,this.z=n*a-r*o,this},projectOnVector:function(e){var t=e.dot(this)/e.lengthSq();return this.copy(e).multiplyScalar(t)},projectOnPlane:function(e){return Nt.copy(this).projectOnVector(e),this.sub(Nt)},reflect:function(e){return this.sub(Nt.copy(e).multiplyScalar(2*this.dot(e)))},angleTo:function(e){var t=Math.sqrt(this.lengthSq()*e.lengthSq());0===t&&console.error("THREE.Vector3: angleTo() can't handle zero length vectors.");var n=this.dot(e)/t;return Math.acos(Rt.clamp(n,-1,1))},distanceTo:function(e){return Math.sqrt(this.distanceToSquared(e))},distanceToSquared:function(e){var t=this.x-e.x,n=this.y-e.y,r=this.z-e.z;return t*t+n*n+r*r},manhattanDistanceTo:function(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)+Math.abs(this.z-e.z)},setFromSpherical:function(e){return this.setFromSphericalCoords(e.radius,e.phi,e.theta)},setFromSphericalCoords:function(e,t,n){var r=Math.sin(t)*e;return this.x=r*Math.sin(n),this.y=Math.cos(t)*e,this.z=r*Math.cos(n),this},setFromCylindrical:function(e){return this.setFromCylindricalCoords(e.radius,e.theta,e.y)},setFromCylindricalCoords:function(e,t,n){return this.x=e*Math.sin(t),this.y=n,this.z=e*Math.cos(t),this},setFromMatrixPosition:function(e){var t=e.elements;return this.x=t[12],this.y=t[13],this.z=t[14],this},setFromMatrixScale:function(e){var t=this.setFromMatrixColumn(e,0).length(),n=this.setFromMatrixColumn(e,1).length(),r=this.setFromMatrixColumn(e,2).length();return this.x=t,this.y=n,this.z=r,this},setFromMatrixColumn:function(e,t){return this.fromArray(e.elements,4*t)},equals:function(e){return e.x===this.x&&e.y===this.y&&e.z===this.z},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this.z=e[t+2],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e},fromBufferAttribute:function(e,t,n){return void 0!==n&&console.warn("THREE.Vector3: offset has been removed from .fromBufferAttribute()."),this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this}});var kt,Ft=new zt;function Ut(){this.elements=[1,0,0,0,1,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}Object.assign(Ut.prototype,{isMatrix3:!0,set:function(e,t,n,r,i,o,a,s,c){var l=this.elements;return l[0]=e,l[1]=r,l[2]=a,l[3]=t,l[4]=i,l[5]=s,l[6]=n,l[7]=o,l[8]=c,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(e){var t=this.elements,n=e.elements;return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t[6]=n[6],t[7]=n[7],t[8]=n[8],this},setFromMatrix4:function(e){var t=e.elements;return this.set(t[0],t[4],t[8],t[1],t[5],t[9],t[2],t[6],t[10]),this},applyToBufferAttribute:function(e){for(var t=0,n=e.count;t<n;t++)Ft.x=e.getX(t),Ft.y=e.getY(t),Ft.z=e.getZ(t),Ft.applyMatrix3(this),e.setXYZ(t,Ft.x,Ft.y,Ft.z);return e},multiply:function(e){return this.multiplyMatrices(this,e)},premultiply:function(e){return this.multiplyMatrices(e,this)},multiplyMatrices:function(e,t){var n=e.elements,r=t.elements,i=this.elements,o=n[0],a=n[3],s=n[6],c=n[1],l=n[4],h=n[7],u=n[2],p=n[5],d=n[8],f=r[0],m=r[3],g=r[6],v=r[1],y=r[4],x=r[7],b=r[2],w=r[5],_=r[8];return i[0]=o*f+a*v+s*b,i[3]=o*m+a*y+s*w,i[6]=o*g+a*x+s*_,i[1]=c*f+l*v+h*b,i[4]=c*m+l*y+h*w,i[7]=c*g+l*x+h*_,i[2]=u*f+p*v+d*b,i[5]=u*m+p*y+d*w,i[8]=u*g+p*x+d*_,this},multiplyScalar:function(e){var t=this.elements;return t[0]*=e,t[3]*=e,t[6]*=e,t[1]*=e,t[4]*=e,t[7]*=e,t[2]*=e,t[5]*=e,t[8]*=e,this},determinant:function(){var e=this.elements,t=e[0],n=e[1],r=e[2],i=e[3],o=e[4],a=e[5],s=e[6],c=e[7],l=e[8];return t*o*l-t*a*c-n*i*l+n*a*s+r*i*c-r*o*s},getInverse:function(e,t){e&&e.isMatrix4&&console.error("THREE.Matrix3: .getInverse() no longer takes a Matrix4 argument.");var n=e.elements,r=this.elements,i=n[0],o=n[1],a=n[2],s=n[3],c=n[4],l=n[5],h=n[6],u=n[7],p=n[8],d=p*c-l*u,f=l*h-p*s,m=u*s-c*h,g=i*d+o*f+a*m;if(0===g){var v="THREE.Matrix3: .getInverse() can't invert matrix, determinant is 0";if(!0===t)throw new Error(v);return console.warn(v),this.identity()}var y=1/g;return r[0]=d*y,r[1]=(a*u-p*o)*y,r[2]=(l*o-a*c)*y,r[3]=f*y,r[4]=(p*i-a*h)*y,r[5]=(a*s-l*i)*y,r[6]=m*y,r[7]=(o*h-u*i)*y,r[8]=(c*i-o*s)*y,this},transpose:function(){var e,t=this.elements;return e=t[1],t[1]=t[3],t[3]=e,e=t[2],t[2]=t[6],t[6]=e,e=t[5],t[5]=t[7],t[7]=e,this},getNormalMatrix:function(e){return this.setFromMatrix4(e).getInverse(this).transpose()},transposeIntoArray:function(e){var t=this.elements;return e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],this},setUvTransform:function(e,t,n,r,i,o,a){var s=Math.cos(i),c=Math.sin(i);this.set(n*s,n*c,-n*(s*o+c*a)+o+e,-r*c,r*s,-r*(-c*o+s*a)+a+t,0,0,1)},scale:function(e,t){var n=this.elements;return n[0]*=e,n[3]*=e,n[6]*=e,n[1]*=t,n[4]*=t,n[7]*=t,this},rotate:function(e){var t=Math.cos(e),n=Math.sin(e),r=this.elements,i=r[0],o=r[3],a=r[6],s=r[1],c=r[4],l=r[7];return r[0]=t*i+n*s,r[3]=t*o+n*c,r[6]=t*a+n*l,r[1]=-n*i+t*s,r[4]=-n*o+t*c,r[7]=-n*a+t*l,this},translate:function(e,t){var n=this.elements;return n[0]+=e*n[2],n[3]+=e*n[5],n[6]+=e*n[8],n[1]+=t*n[2],n[4]+=t*n[5],n[7]+=t*n[8],this},equals:function(e){for(var t=this.elements,n=e.elements,r=0;r<9;r++)if(t[r]!==n[r])return!1;return!0},fromArray:function(e,t){void 0===t&&(t=0);for(var n=0;n<9;n++)this.elements[n]=e[n+t];return this},toArray:function(e,t){void 0===e&&(e=[]),void 0===t&&(t=0);var n=this.elements;return e[t]=n[0],e[t+1]=n[1],e[t+2]=n[2],e[t+3]=n[3],e[t+4]=n[4],e[t+5]=n[5],e[t+6]=n[6],e[t+7]=n[7],e[t+8]=n[8],e}});var Bt={getDataURL:function(e){var t;if("undefined"==typeof HTMLCanvasElement)return e.src;if(e instanceof HTMLCanvasElement)t=e;else{void 0===kt&&(kt=document.createElementNS("http://www.w3.org/1999/xhtml","canvas")),kt.width=e.width,kt.height=e.height;var n=kt.getContext("2d");e instanceof ImageData?n.putImageData(e,0,0):n.drawImage(e,0,0,e.width,e.height),t=kt}return t.width>2048||t.height>2048?t.toDataURL("image/jpeg",.6):t.toDataURL("image/png")}},jt=0;function Ht(e,t,n,r,i,o,a,s,c,l){Object.defineProperty(this,"id",{value:jt++}),this.uuid=Rt.generateUUID(),this.name="",this.image=void 0!==e?e:Ht.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==t?t:Ht.DEFAULT_MAPPING,this.wrapS=void 0!==n?n:he,this.wrapT=void 0!==r?r:he,this.magFilter=void 0!==i?i:me,this.minFilter=void 0!==o?o:ve,this.anisotropy=void 0!==c?c:1,this.format=void 0!==a?a:Oe,this.type=void 0!==s?s:ye,this.offset=new Ot(0,0),this.repeat=new Ot(1,1),this.center=new Ot(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Ut,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==l?l:dt,this.version=0,this.onUpdate=null}function Gt(e,t,n,r){this.x=e||0,this.y=t||0,this.z=n||0,this.w=void 0!==r?r:1}function Vt(e,t,n){this.width=e,this.height=t,this.scissor=new Gt(0,0,e,t),this.scissorTest=!1,this.viewport=new Gt(0,0,e,t),n=n||{},this.texture=new Ht(void 0,void 0,n.wrapS,n.wrapT,n.magFilter,n.minFilter,n.format,n.type,n.anisotropy,n.encoding),this.texture.image={},this.texture.image.width=e,this.texture.image.height=t,this.texture.generateMipmaps=void 0!==n.generateMipmaps&&n.generateMipmaps,this.texture.minFilter=void 0!==n.minFilter?n.minFilter:me,this.depthBuffer=void 0===n.depthBuffer||n.depthBuffer,this.stencilBuffer=void 0===n.stencilBuffer||n.stencilBuffer,this.depthTexture=void 0!==n.depthTexture?n.depthTexture:null}function Wt(e,t,n){Vt.call(this,e,t,n),this.samples=4}Ht.DEFAULT_IMAGE=void 0,Ht.DEFAULT_MAPPING=300,Ht.prototype=Object.assign(Object.create(Lt.prototype),{constructor:Ht,isTexture:!0,updateMatrix:function(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.name=e.name,this.image=e.image,this.mipmaps=e.mipmaps.slice(0),this.mapping=e.mapping,this.wrapS=e.wrapS,this.wrapT=e.wrapT,this.magFilter=e.magFilter,this.minFilter=e.minFilter,this.anisotropy=e.anisotropy,this.format=e.format,this.type=e.type,this.offset.copy(e.offset),this.repeat.copy(e.repeat),this.center.copy(e.center),this.rotation=e.rotation,this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrix.copy(e.matrix),this.generateMipmaps=e.generateMipmaps,this.premultiplyAlpha=e.premultiplyAlpha,this.flipY=e.flipY,this.unpackAlignment=e.unpackAlignment,this.encoding=e.encoding,this},toJSON:function(e){var t=void 0===e||"string"==typeof e;if(!t&&void 0!==e.textures[this.uuid])return e.textures[this.uuid];var n={metadata:{version:4.5,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,type:this.type,encoding:this.encoding,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};if(void 0!==this.image){var r=this.image;if(void 0===r.uuid&&(r.uuid=Rt.generateUUID()),!t&&void 0===e.images[r.uuid]){var i;if(Array.isArray(r)){i=[];for(var o=0,a=r.length;o<a;o++)i.push(Bt.getDataURL(r[o]))}else i=Bt.getDataURL(r);e.images[r.uuid]={uuid:r.uuid,url:i}}n.image=r.uuid}return t||(e.textures[this.uuid]=n),n},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(e){if(300!==this.mapping)return e;if(e.applyMatrix3(this.matrix),e.x<0||e.x>1)switch(this.wrapS){case le:e.x=e.x-Math.floor(e.x);break;case he:e.x=e.x<0?0:1;break;case ue:1===Math.abs(Math.floor(e.x)%2)?e.x=Math.ceil(e.x)-e.x:e.x=e.x-Math.floor(e.x)}if(e.y<0||e.y>1)switch(this.wrapT){case le:e.y=e.y-Math.floor(e.y);break;case he:e.y=e.y<0?0:1;break;case ue:1===Math.abs(Math.floor(e.y)%2)?e.y=Math.ceil(e.y)-e.y:e.y=e.y-Math.floor(e.y)}return this.flipY&&(e.y=1-e.y),e}}),Object.defineProperty(Ht.prototype,"needsUpdate",{set:function(e){!0===e&&this.version++}}),Object.defineProperties(Gt.prototype,{width:{get:function(){return this.z},set:function(e){this.z=e}},height:{get:function(){return this.w},set:function(e){this.w=e}}}),Object.assign(Gt.prototype,{isVector4:!0,set:function(e,t,n,r){return this.x=e,this.y=t,this.z=n,this.w=r,this},setScalar:function(e){return this.x=e,this.y=e,this.z=e,this.w=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setZ:function(e){return this.z=e,this},setW:function(e){return this.w=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;case 3:this.w=t;break;default:throw new Error("index is out of range: "+e)}return this},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=void 0!==e.w?e.w:1,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this)},addScalar:function(e){return this.x+=e,this.y+=e,this.z+=e,this.w+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this.w=e.w+t.w,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this.w+=e.w*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this.z-=e.z,this.w-=e.w,this)},subScalar:function(e){return this.x-=e,this.y-=e,this.z-=e,this.w-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this.w=e.w-t.w,this},multiplyScalar:function(e){return this.x*=e,this.y*=e,this.z*=e,this.w*=e,this},applyMatrix4:function(e){var t=this.x,n=this.y,r=this.z,i=this.w,o=e.elements;return this.x=o[0]*t+o[4]*n+o[8]*r+o[12]*i,this.y=o[1]*t+o[5]*n+o[9]*r+o[13]*i,this.z=o[2]*t+o[6]*n+o[10]*r+o[14]*i,this.w=o[3]*t+o[7]*n+o[11]*r+o[15]*i,this},divideScalar:function(e){return this.multiplyScalar(1/e)},setAxisAngleFromQuaternion:function(e){this.w=2*Math.acos(e.w);var t=Math.sqrt(1-e.w*e.w);return t<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=e.x/t,this.y=e.y/t,this.z=e.z/t),this},setAxisAngleFromRotationMatrix:function(e){var t,n,r,i,o=e.elements,a=o[0],s=o[4],c=o[8],l=o[1],h=o[5],u=o[9],p=o[2],d=o[6],f=o[10];if(Math.abs(s-l)<.01&&Math.abs(c-p)<.01&&Math.abs(u-d)<.01){if(Math.abs(s+l)<.1&&Math.abs(c+p)<.1&&Math.abs(u+d)<.1&&Math.abs(a+h+f-3)<.1)return this.set(1,0,0,0),this;t=Math.PI;var m=(a+1)/2,g=(h+1)/2,v=(f+1)/2,y=(s+l)/4,x=(c+p)/4,b=(u+d)/4;return m>g&&m>v?m<.01?(n=0,r=.707106781,i=.707106781):(r=y/(n=Math.sqrt(m)),i=x/n):g>v?g<.01?(n=.707106781,r=0,i=.707106781):(n=y/(r=Math.sqrt(g)),i=b/r):v<.01?(n=.707106781,r=.707106781,i=0):(n=x/(i=Math.sqrt(v)),r=b/i),this.set(n,r,i,t),this}var w=Math.sqrt((d-u)*(d-u)+(c-p)*(c-p)+(l-s)*(l-s));return Math.abs(w)<.001&&(w=1),this.x=(d-u)/w,this.y=(c-p)/w,this.z=(l-s)/w,this.w=Math.acos((a+h+f-1)/2),this},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this.w=Math.min(this.w,e.w),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this.w=Math.max(this.w,e.w),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this.w=Math.max(e.w,Math.min(t.w,this.w)),this},clampScalar:function(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this.z=Math.max(e,Math.min(t,this.z)),this.w=Math.max(e,Math.min(t,this.w)),this},clampLength:function(e,t){var n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(e){return this.x*e.x+this.y*e.y+this.z*e.z+this.w*e.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(e){return this.normalize().multiplyScalar(e)},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this.w+=(e.w-this.w)*t,this},lerpVectors:function(e,t,n){return this.subVectors(t,e).multiplyScalar(n).add(e)},equals:function(e){return e.x===this.x&&e.y===this.y&&e.z===this.z&&e.w===this.w},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this.z=e[t+2],this.w=e[t+3],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e[t+3]=this.w,e},fromBufferAttribute:function(e,t,n){return void 0!==n&&console.warn("THREE.Vector4: offset has been removed from .fromBufferAttribute()."),this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this.w=e.getW(t),this}}),Vt.prototype=Object.assign(Object.create(Lt.prototype),{constructor:Vt,isWebGLRenderTarget:!0,setSize:function(e,t){this.width===e&&this.height===t||(this.width=e,this.height=t,this.texture.image.width=e,this.texture.image.height=t,this.dispose()),this.viewport.set(0,0,e,t),this.scissor.set(0,0,e,t)},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.width=e.width,this.height=e.height,this.viewport.copy(e.viewport),this.texture=e.texture.clone(),this.depthBuffer=e.depthBuffer,this.stencilBuffer=e.stencilBuffer,this.depthTexture=e.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Wt.prototype=Object.assign(Object.create(Vt.prototype),{constructor:Wt,isWebGLMultisampleRenderTarget:!0,copy:function(e){return Vt.prototype.copy.call(this,e),this.samples=e.samples,this}});var qt=new zt,Xt=new $t,Yt=new zt(0,0,0),Zt=new zt(1,1,1),Jt=new zt,Qt=new zt,Kt=new zt;function $t(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}Object.assign($t.prototype,{isMatrix4:!0,set:function(e,t,n,r,i,o,a,s,c,l,h,u,p,d,f,m){var g=this.elements;return g[0]=e,g[4]=t,g[8]=n,g[12]=r,g[1]=i,g[5]=o,g[9]=a,g[13]=s,g[2]=c,g[6]=l,g[10]=h,g[14]=u,g[3]=p,g[7]=d,g[11]=f,g[15]=m,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new $t).fromArray(this.elements)},copy:function(e){var t=this.elements,n=e.elements;return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t[6]=n[6],t[7]=n[7],t[8]=n[8],t[9]=n[9],t[10]=n[10],t[11]=n[11],t[12]=n[12],t[13]=n[13],t[14]=n[14],t[15]=n[15],this},copyPosition:function(e){var t=this.elements,n=e.elements;return t[12]=n[12],t[13]=n[13],t[14]=n[14],this},extractBasis:function(e,t,n){return e.setFromMatrixColumn(this,0),t.setFromMatrixColumn(this,1),n.setFromMatrixColumn(this,2),this},makeBasis:function(e,t,n){return this.set(e.x,t.x,n.x,0,e.y,t.y,n.y,0,e.z,t.z,n.z,0,0,0,0,1),this},extractRotation:function(e){var t=this.elements,n=e.elements,r=1/qt.setFromMatrixColumn(e,0).length(),i=1/qt.setFromMatrixColumn(e,1).length(),o=1/qt.setFromMatrixColumn(e,2).length();return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=0,t[4]=n[4]*i,t[5]=n[5]*i,t[6]=n[6]*i,t[7]=0,t[8]=n[8]*o,t[9]=n[9]*o,t[10]=n[10]*o,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this},makeRotationFromEuler:function(e){e&&e.isEuler||console.error("THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var t=this.elements,n=e.x,r=e.y,i=e.z,o=Math.cos(n),a=Math.sin(n),s=Math.cos(r),c=Math.sin(r),l=Math.cos(i),h=Math.sin(i);if("XYZ"===e.order){var u=o*l,p=o*h,d=a*l,f=a*h;t[0]=s*l,t[4]=-s*h,t[8]=c,t[1]=p+d*c,t[5]=u-f*c,t[9]=-a*s,t[2]=f-u*c,t[6]=d+p*c,t[10]=o*s}else if("YXZ"===e.order){var m=s*l,g=s*h,v=c*l,y=c*h;t[0]=m+y*a,t[4]=v*a-g,t[8]=o*c,t[1]=o*h,t[5]=o*l,t[9]=-a,t[2]=g*a-v,t[6]=y+m*a,t[10]=o*s}else if("ZXY"===e.order){m=s*l,g=s*h,v=c*l,y=c*h;t[0]=m-y*a,t[4]=-o*h,t[8]=v+g*a,t[1]=g+v*a,t[5]=o*l,t[9]=y-m*a,t[2]=-o*c,t[6]=a,t[10]=o*s}else if("ZYX"===e.order){u=o*l,p=o*h,d=a*l,f=a*h;t[0]=s*l,t[4]=d*c-p,t[8]=u*c+f,t[1]=s*h,t[5]=f*c+u,t[9]=p*c-d,t[2]=-c,t[6]=a*s,t[10]=o*s}else if("YZX"===e.order){var x=o*s,b=o*c,w=a*s,_=a*c;t[0]=s*l,t[4]=_-x*h,t[8]=w*h+b,t[1]=h,t[5]=o*l,t[9]=-a*l,t[2]=-c*l,t[6]=b*h+w,t[10]=x-_*h}else if("XZY"===e.order){x=o*s,b=o*c,w=a*s,_=a*c;t[0]=s*l,t[4]=-h,t[8]=c*l,t[1]=x*h+_,t[5]=o*l,t[9]=b*h-w,t[2]=w*h-b,t[6]=a*l,t[10]=_*h+x}return t[3]=0,t[7]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this},makeRotationFromQuaternion:function(e){return this.compose(Yt,e,Zt)},lookAt:function(e,t,n){var r=this.elements;return Kt.subVectors(e,t),0===Kt.lengthSq()&&(Kt.z=1),Kt.normalize(),Jt.crossVectors(n,Kt),0===Jt.lengthSq()&&(1===Math.abs(n.z)?Kt.x+=1e-4:Kt.z+=1e-4,Kt.normalize(),Jt.crossVectors(n,Kt)),Jt.normalize(),Qt.crossVectors(Kt,Jt),r[0]=Jt.x,r[4]=Qt.x,r[8]=Kt.x,r[1]=Jt.y,r[5]=Qt.y,r[9]=Kt.y,r[2]=Jt.z,r[6]=Qt.z,r[10]=Kt.z,this},multiply:function(e,t){return void 0!==t?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(e,t)):this.multiplyMatrices(this,e)},premultiply:function(e){return this.multiplyMatrices(e,this)},multiplyMatrices:function(e,t){var n=e.elements,r=t.elements,i=this.elements,o=n[0],a=n[4],s=n[8],c=n[12],l=n[1],h=n[5],u=n[9],p=n[13],d=n[2],f=n[6],m=n[10],g=n[14],v=n[3],y=n[7],x=n[11],b=n[15],w=r[0],_=r[4],M=r[8],E=r[12],S=r[1],T=r[5],A=r[9],L=r[13],P=r[2],C=r[6],R=r[10],O=r[14],D=r[3],N=r[7],I=r[11],z=r[15];return i[0]=o*w+a*S+s*P+c*D,i[4]=o*_+a*T+s*C+c*N,i[8]=o*M+a*A+s*R+c*I,i[12]=o*E+a*L+s*O+c*z,i[1]=l*w+h*S+u*P+p*D,i[5]=l*_+h*T+u*C+p*N,i[9]=l*M+h*A+u*R+p*I,i[13]=l*E+h*L+u*O+p*z,i[2]=d*w+f*S+m*P+g*D,i[6]=d*_+f*T+m*C+g*N,i[10]=d*M+f*A+m*R+g*I,i[14]=d*E+f*L+m*O+g*z,i[3]=v*w+y*S+x*P+b*D,i[7]=v*_+y*T+x*C+b*N,i[11]=v*M+y*A+x*R+b*I,i[15]=v*E+y*L+x*O+b*z,this},multiplyScalar:function(e){var t=this.elements;return t[0]*=e,t[4]*=e,t[8]*=e,t[12]*=e,t[1]*=e,t[5]*=e,t[9]*=e,t[13]*=e,t[2]*=e,t[6]*=e,t[10]*=e,t[14]*=e,t[3]*=e,t[7]*=e,t[11]*=e,t[15]*=e,this},applyToBufferAttribute:function(e){for(var t=0,n=e.count;t<n;t++)qt.x=e.getX(t),qt.y=e.getY(t),qt.z=e.getZ(t),qt.applyMatrix4(this),e.setXYZ(t,qt.x,qt.y,qt.z);return e},determinant:function(){var e=this.elements,t=e[0],n=e[4],r=e[8],i=e[12],o=e[1],a=e[5],s=e[9],c=e[13],l=e[2],h=e[6],u=e[10],p=e[14];return e[3]*(+i*s*h-r*c*h-i*a*u+n*c*u+r*a*p-n*s*p)+e[7]*(+t*s*p-t*c*u+i*o*u-r*o*p+r*c*l-i*s*l)+e[11]*(+t*c*h-t*a*p-i*o*h+n*o*p+i*a*l-n*c*l)+e[15]*(-r*a*l-t*s*h+t*a*u+r*o*h-n*o*u+n*s*l)},transpose:function(){var e,t=this.elements;return e=t[1],t[1]=t[4],t[4]=e,e=t[2],t[2]=t[8],t[8]=e,e=t[6],t[6]=t[9],t[9]=e,e=t[3],t[3]=t[12],t[12]=e,e=t[7],t[7]=t[13],t[13]=e,e=t[11],t[11]=t[14],t[14]=e,this},setPosition:function(e,t,n){var r=this.elements;return e.isVector3?(r[12]=e.x,r[13]=e.y,r[14]=e.z):(r[12]=e,r[13]=t,r[14]=n),this},getInverse:function(e,t){var n=this.elements,r=e.elements,i=r[0],o=r[1],a=r[2],s=r[3],c=r[4],l=r[5],h=r[6],u=r[7],p=r[8],d=r[9],f=r[10],m=r[11],g=r[12],v=r[13],y=r[14],x=r[15],b=d*y*u-v*f*u+v*h*m-l*y*m-d*h*x+l*f*x,w=g*f*u-p*y*u-g*h*m+c*y*m+p*h*x-c*f*x,_=p*v*u-g*d*u+g*l*m-c*v*m-p*l*x+c*d*x,M=g*d*h-p*v*h-g*l*f+c*v*f+p*l*y-c*d*y,E=i*b+o*w+a*_+s*M;if(0===E){var S="THREE.Matrix4: .getInverse() can't invert matrix, determinant is 0";if(!0===t)throw new Error(S);return console.warn(S),this.identity()}var T=1/E;return n[0]=b*T,n[1]=(v*f*s-d*y*s-v*a*m+o*y*m+d*a*x-o*f*x)*T,n[2]=(l*y*s-v*h*s+v*a*u-o*y*u-l*a*x+o*h*x)*T,n[3]=(d*h*s-l*f*s-d*a*u+o*f*u+l*a*m-o*h*m)*T,n[4]=w*T,n[5]=(p*y*s-g*f*s+g*a*m-i*y*m-p*a*x+i*f*x)*T,n[6]=(g*h*s-c*y*s-g*a*u+i*y*u+c*a*x-i*h*x)*T,n[7]=(c*f*s-p*h*s+p*a*u-i*f*u-c*a*m+i*h*m)*T,n[8]=_*T,n[9]=(g*d*s-p*v*s-g*o*m+i*v*m+p*o*x-i*d*x)*T,n[10]=(c*v*s-g*l*s+g*o*u-i*v*u-c*o*x+i*l*x)*T,n[11]=(p*l*s-c*d*s-p*o*u+i*d*u+c*o*m-i*l*m)*T,n[12]=M*T,n[13]=(p*v*a-g*d*a+g*o*f-i*v*f-p*o*y+i*d*y)*T,n[14]=(g*l*a-c*v*a-g*o*h+i*v*h+c*o*y-i*l*y)*T,n[15]=(c*d*a-p*l*a+p*o*h-i*d*h-c*o*f+i*l*f)*T,this},scale:function(e){var t=this.elements,n=e.x,r=e.y,i=e.z;return t[0]*=n,t[4]*=r,t[8]*=i,t[1]*=n,t[5]*=r,t[9]*=i,t[2]*=n,t[6]*=r,t[10]*=i,t[3]*=n,t[7]*=r,t[11]*=i,this},getMaxScaleOnAxis:function(){var e=this.elements,t=e[0]*e[0]+e[1]*e[1]+e[2]*e[2],n=e[4]*e[4]+e[5]*e[5]+e[6]*e[6],r=e[8]*e[8]+e[9]*e[9]+e[10]*e[10];return Math.sqrt(Math.max(t,n,r))},makeTranslation:function(e,t,n){return this.set(1,0,0,e,0,1,0,t,0,0,1,n,0,0,0,1),this},makeRotationX:function(e){var t=Math.cos(e),n=Math.sin(e);return this.set(1,0,0,0,0,t,-n,0,0,n,t,0,0,0,0,1),this},makeRotationY:function(e){var t=Math.cos(e),n=Math.sin(e);return this.set(t,0,n,0,0,1,0,0,-n,0,t,0,0,0,0,1),this},makeRotationZ:function(e){var t=Math.cos(e),n=Math.sin(e);return this.set(t,-n,0,0,n,t,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(e,t){var n=Math.cos(t),r=Math.sin(t),i=1-n,o=e.x,a=e.y,s=e.z,c=i*o,l=i*a;return this.set(c*o+n,c*a-r*s,c*s+r*a,0,c*a+r*s,l*a+n,l*s-r*o,0,c*s-r*a,l*s+r*o,i*s*s+n,0,0,0,0,1),this},makeScale:function(e,t,n){return this.set(e,0,0,0,0,t,0,0,0,0,n,0,0,0,0,1),this},makeShear:function(e,t,n){return this.set(1,t,n,0,e,1,n,0,e,t,1,0,0,0,0,1),this},compose:function(e,t,n){var r=this.elements,i=t._x,o=t._y,a=t._z,s=t._w,c=i+i,l=o+o,h=a+a,u=i*c,p=i*l,d=i*h,f=o*l,m=o*h,g=a*h,v=s*c,y=s*l,x=s*h,b=n.x,w=n.y,_=n.z;return r[0]=(1-(f+g))*b,r[1]=(p+x)*b,r[2]=(d-y)*b,r[3]=0,r[4]=(p-x)*w,r[5]=(1-(u+g))*w,r[6]=(m+v)*w,r[7]=0,r[8]=(d+y)*_,r[9]=(m-v)*_,r[10]=(1-(u+f))*_,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,this},decompose:function(e,t,n){var r=this.elements,i=qt.set(r[0],r[1],r[2]).length(),o=qt.set(r[4],r[5],r[6]).length(),a=qt.set(r[8],r[9],r[10]).length();this.determinant()<0&&(i=-i),e.x=r[12],e.y=r[13],e.z=r[14],Xt.copy(this);var s=1/i,c=1/o,l=1/a;return Xt.elements[0]*=s,Xt.elements[1]*=s,Xt.elements[2]*=s,Xt.elements[4]*=c,Xt.elements[5]*=c,Xt.elements[6]*=c,Xt.elements[8]*=l,Xt.elements[9]*=l,Xt.elements[10]*=l,t.setFromRotationMatrix(Xt),n.x=i,n.y=o,n.z=a,this},makePerspective:function(e,t,n,r,i,o){void 0===o&&console.warn("THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.");var a=this.elements,s=2*i/(t-e),c=2*i/(n-r),l=(t+e)/(t-e),h=(n+r)/(n-r),u=-(o+i)/(o-i),p=-2*o*i/(o-i);return a[0]=s,a[4]=0,a[8]=l,a[12]=0,a[1]=0,a[5]=c,a[9]=h,a[13]=0,a[2]=0,a[6]=0,a[10]=u,a[14]=p,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this},makeOrthographic:function(e,t,n,r,i,o){var a=this.elements,s=1/(t-e),c=1/(n-r),l=1/(o-i),h=(t+e)*s,u=(n+r)*c,p=(o+i)*l;return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-h,a[1]=0,a[5]=2*c,a[9]=0,a[13]=-u,a[2]=0,a[6]=0,a[10]=-2*l,a[14]=-p,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this},equals:function(e){for(var t=this.elements,n=e.elements,r=0;r<16;r++)if(t[r]!==n[r])return!1;return!0},fromArray:function(e,t){void 0===t&&(t=0);for(var n=0;n<16;n++)this.elements[n]=e[n+t];return this},toArray:function(e,t){void 0===e&&(e=[]),void 0===t&&(t=0);var n=this.elements;return e[t]=n[0],e[t+1]=n[1],e[t+2]=n[2],e[t+3]=n[3],e[t+4]=n[4],e[t+5]=n[5],e[t+6]=n[6],e[t+7]=n[7],e[t+8]=n[8],e[t+9]=n[9],e[t+10]=n[10],e[t+11]=n[11],e[t+12]=n[12],e[t+13]=n[13],e[t+14]=n[14],e[t+15]=n[15],e}});var en=new $t,tn=new Dt;function nn(e,t,n,r){this._x=e||0,this._y=t||0,this._z=n||0,this._order=r||nn.DefaultOrder}function rn(){this.mask=1}nn.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],nn.DefaultOrder="XYZ",Object.defineProperties(nn.prototype,{x:{get:function(){return this._x},set:function(e){this._x=e,this._onChangeCallback()}},y:{get:function(){return this._y},set:function(e){this._y=e,this._onChangeCallback()}},z:{get:function(){return this._z},set:function(e){this._z=e,this._onChangeCallback()}},order:{get:function(){return this._order},set:function(e){this._order=e,this._onChangeCallback()}}}),Object.assign(nn.prototype,{isEuler:!0,set:function(e,t,n,r){return this._x=e,this._y=t,this._z=n,this._order=r||this._order,this._onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(e){return this._x=e._x,this._y=e._y,this._z=e._z,this._order=e._order,this._onChangeCallback(),this},setFromRotationMatrix:function(e,t,n){var r=Rt.clamp,i=e.elements,o=i[0],a=i[4],s=i[8],c=i[1],l=i[5],h=i[9],u=i[2],p=i[6],d=i[10];return"XYZ"===(t=t||this._order)?(this._y=Math.asin(r(s,-1,1)),Math.abs(s)<.9999999?(this._x=Math.atan2(-h,d),this._z=Math.atan2(-a,o)):(this._x=Math.atan2(p,l),this._z=0)):"YXZ"===t?(this._x=Math.asin(-r(h,-1,1)),Math.abs(h)<.9999999?(this._y=Math.atan2(s,d),this._z=Math.atan2(c,l)):(this._y=Math.atan2(-u,o),this._z=0)):"ZXY"===t?(this._x=Math.asin(r(p,-1,1)),Math.abs(p)<.9999999?(this._y=Math.atan2(-u,d),this._z=Math.atan2(-a,l)):(this._y=0,this._z=Math.atan2(c,o))):"ZYX"===t?(this._y=Math.asin(-r(u,-1,1)),Math.abs(u)<.9999999?(this._x=Math.atan2(p,d),this._z=Math.atan2(c,o)):(this._x=0,this._z=Math.atan2(-a,l))):"YZX"===t?(this._z=Math.asin(r(c,-1,1)),Math.abs(c)<.9999999?(this._x=Math.atan2(-h,l),this._y=Math.atan2(-u,o)):(this._x=0,this._y=Math.atan2(s,d))):"XZY"===t?(this._z=Math.asin(-r(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(p,l),this._y=Math.atan2(s,o)):(this._x=Math.atan2(-h,d),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+t),this._order=t,!1!==n&&this._onChangeCallback(),this},setFromQuaternion:function(e,t,n){return en.makeRotationFromQuaternion(e),this.setFromRotationMatrix(en,t,n)},setFromVector3:function(e,t){return this.set(e.x,e.y,e.z,t||this._order)},reorder:function(e){return tn.setFromEuler(this),this.setFromQuaternion(tn,e)},equals:function(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._order===this._order},fromArray:function(e){return this._x=e[0],this._y=e[1],this._z=e[2],void 0!==e[3]&&(this._order=e[3]),this._onChangeCallback(),this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._order,e},toVector3:function(e){return e?e.set(this._x,this._y,this._z):new zt(this._x,this._y,this._z)},_onChange:function(e){return this._onChangeCallback=e,this},_onChangeCallback:function(){}}),Object.assign(rn.prototype,{set:function(e){this.mask=1<<e|0},enable:function(e){this.mask|=1<<e|0},enableAll:function(){this.mask=-1},toggle:function(e){this.mask^=1<<e|0},disable:function(e){this.mask&=~(1<<e|0)},disableAll:function(){this.mask=0},test:function(e){return 0!=(this.mask&e.mask)}});var on=0,an=new zt,sn=new Dt,cn=new $t,ln=new zt,hn=new zt,un=new zt,pn=new Dt,dn=new zt(1,0,0),fn=new zt(0,1,0),mn=new zt(0,0,1),gn={type:"added"},vn={type:"removed"};function yn(){Object.defineProperty(this,"id",{value:on++}),this.uuid=Rt.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=yn.DefaultUp.clone();var e=new zt,t=new nn,n=new Dt,r=new zt(1,1,1);t._onChange((function(){n.setFromEuler(t,!1)})),n._onChange((function(){t.setFromQuaternion(n,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:e},rotation:{configurable:!0,enumerable:!0,value:t},quaternion:{configurable:!0,enumerable:!0,value:n},scale:{configurable:!0,enumerable:!0,value:r},modelViewMatrix:{value:new $t},normalMatrix:{value:new Ut}}),this.matrix=new $t,this.matrixWorld=new $t,this.matrixAutoUpdate=yn.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new rn,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}}function xn(){yn.call(this),this.type="Scene",this.background=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}yn.DefaultUp=new zt(0,1,0),yn.DefaultMatrixAutoUpdate=!0,yn.prototype=Object.assign(Object.create(Lt.prototype),{constructor:yn,isObject3D:!0,onBeforeRender:function(){},onAfterRender:function(){},applyMatrix:function(e){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(e),this.matrix.decompose(this.position,this.quaternion,this.scale)},applyQuaternion:function(e){return this.quaternion.premultiply(e),this},setRotationFromAxisAngle:function(e,t){this.quaternion.setFromAxisAngle(e,t)},setRotationFromEuler:function(e){this.quaternion.setFromEuler(e,!0)},setRotationFromMatrix:function(e){this.quaternion.setFromRotationMatrix(e)},setRotationFromQuaternion:function(e){this.quaternion.copy(e)},rotateOnAxis:function(e,t){return sn.setFromAxisAngle(e,t),this.quaternion.multiply(sn),this},rotateOnWorldAxis:function(e,t){return sn.setFromAxisAngle(e,t),this.quaternion.premultiply(sn),this},rotateX:function(e){return this.rotateOnAxis(dn,e)},rotateY:function(e){return this.rotateOnAxis(fn,e)},rotateZ:function(e){return this.rotateOnAxis(mn,e)},translateOnAxis:function(e,t){return an.copy(e).applyQuaternion(this.quaternion),this.position.add(an.multiplyScalar(t)),this},translateX:function(e){return this.translateOnAxis(dn,e)},translateY:function(e){return this.translateOnAxis(fn,e)},translateZ:function(e){return this.translateOnAxis(mn,e)},localToWorld:function(e){return e.applyMatrix4(this.matrixWorld)},worldToLocal:function(e){return e.applyMatrix4(cn.getInverse(this.matrixWorld))},lookAt:function(e,t,n){e.isVector3?ln.copy(e):ln.set(e,t,n);var r=this.parent;this.updateWorldMatrix(!0,!1),hn.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?cn.lookAt(hn,ln,this.up):cn.lookAt(ln,hn,this.up),this.quaternion.setFromRotationMatrix(cn),r&&(cn.extractRotation(r.matrixWorld),sn.setFromRotationMatrix(cn),this.quaternion.premultiply(sn.inverse()))},add:function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return e===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",e),this):(e&&e.isObject3D?(null!==e.parent&&e.parent.remove(e),e.parent=this,this.children.push(e),e.dispatchEvent(gn)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",e),this)},remove:function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.remove(arguments[t]);return this}var n=this.children.indexOf(e);return-1!==n&&(e.parent=null,this.children.splice(n,1),e.dispatchEvent(vn)),this},attach:function(e){return this.updateWorldMatrix(!0,!1),cn.getInverse(this.matrixWorld),null!==e.parent&&(e.parent.updateWorldMatrix(!0,!1),cn.multiply(e.parent.matrixWorld)),e.applyMatrix(cn),e.updateWorldMatrix(!1,!1),this.add(e),this},getObjectById:function(e){return this.getObjectByProperty("id",e)},getObjectByName:function(e){return this.getObjectByProperty("name",e)},getObjectByProperty:function(e,t){if(this[e]===t)return this;for(var n=0,r=this.children.length;n<r;n++){var i=this.children[n].getObjectByProperty(e,t);if(void 0!==i)return i}},getWorldPosition:function(e){return void 0===e&&(console.warn("THREE.Object3D: .getWorldPosition() target is now required"),e=new zt),this.updateMatrixWorld(!0),e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(e){return void 0===e&&(console.warn("THREE.Object3D: .getWorldQuaternion() target is now required"),e=new Dt),this.updateMatrixWorld(!0),this.matrixWorld.decompose(hn,e,un),e},getWorldScale:function(e){return void 0===e&&(console.warn("THREE.Object3D: .getWorldScale() target is now required"),e=new zt),this.updateMatrixWorld(!0),this.matrixWorld.decompose(hn,pn,e),e},getWorldDirection:function(e){void 0===e&&(console.warn("THREE.Object3D: .getWorldDirection() target is now required"),e=new zt),this.updateMatrixWorld(!0);var t=this.matrixWorld.elements;return e.set(t[8],t[9],t[10]).normalize()},raycast:function(){},traverse:function(e){e(this);for(var t=this.children,n=0,r=t.length;n<r;n++)t[n].traverse(e)},traverseVisible:function(e){if(!1!==this.visible){e(this);for(var t=this.children,n=0,r=t.length;n<r;n++)t[n].traverseVisible(e)}},traverseAncestors:function(e){var t=this.parent;null!==t&&(e(t),t.traverseAncestors(e))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(e){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||e)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,e=!0);for(var t=this.children,n=0,r=t.length;n<r;n++)t[n].updateMatrixWorld(e)},updateWorldMatrix:function(e,t){var n=this.parent;if(!0===e&&null!==n&&n.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),!0===t)for(var r=this.children,i=0,o=r.length;i<o;i++)r[i].updateWorldMatrix(!1,!0)},toJSON:function(e){var t=void 0===e||"string"==typeof e,n={};t&&(e={geometries:{},materials:{},textures:{},images:{},shapes:{}},n.metadata={version:4.5,type:"Object",generator:"Object3D.toJSON"});var r={};function i(t,n){return void 0===t[n.uuid]&&(t[n.uuid]=n.toJSON(e)),n.uuid}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),!0===this.castShadow&&(r.castShadow=!0),!0===this.receiveShadow&&(r.receiveShadow=!0),!1===this.visible&&(r.visible=!1),!1===this.frustumCulled&&(r.frustumCulled=!1),0!==this.renderOrder&&(r.renderOrder=this.renderOrder),"{}"!==JSON.stringify(this.userData)&&(r.userData=this.userData),r.layers=this.layers.mask,r.matrix=this.matrix.toArray(),!1===this.matrixAutoUpdate&&(r.matrixAutoUpdate=!1),this.isMesh&&this.drawMode!==ht&&(r.drawMode=this.drawMode),this.isInstancedMesh&&(r.type="InstancedMesh",r.count=this.count,r.instanceMatrix=this.instanceMatrix.toJSON()),this.isMesh||this.isLine||this.isPoints){r.geometry=i(e.geometries,this.geometry);var o=this.geometry.parameters;if(void 0!==o&&void 0!==o.shapes){var a=o.shapes;if(Array.isArray(a))for(var s=0,c=a.length;s<c;s++){var l=a[s];i(e.shapes,l)}else i(e.shapes,a)}}if(void 0!==this.material)if(Array.isArray(this.material)){var h=[];for(s=0,c=this.material.length;s<c;s++)h.push(i(e.materials,this.material[s]));r.material=h}else r.material=i(e.materials,this.material);if(this.children.length>0){r.children=[];for(s=0;s<this.children.length;s++)r.children.push(this.children[s].toJSON(e).object)}if(t){var u=m(e.geometries),p=m(e.materials),d=m(e.textures),f=m(e.images);a=m(e.shapes);u.length>0&&(n.geometries=u),p.length>0&&(n.materials=p),d.length>0&&(n.textures=d),f.length>0&&(n.images=f),a.length>0&&(n.shapes=a)}return n.object=r,n;function m(e){var t=[];for(var n in e){var r=e[n];delete r.metadata,t.push(r)}return t}},clone:function(e){return(new this.constructor).copy(this,e)},copy:function(e,t){if(void 0===t&&(t=!0),this.name=e.name,this.up.copy(e.up),this.position.copy(e.position),this.quaternion.copy(e.quaternion),this.scale.copy(e.scale),this.matrix.copy(e.matrix),this.matrixWorld.copy(e.matrixWorld),this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrixWorldNeedsUpdate=e.matrixWorldNeedsUpdate,this.layers.mask=e.layers.mask,this.visible=e.visible,this.castShadow=e.castShadow,this.receiveShadow=e.receiveShadow,this.frustumCulled=e.frustumCulled,this.renderOrder=e.renderOrder,this.userData=JSON.parse(JSON.stringify(e.userData)),!0===t)for(var n=0;n<e.children.length;n++){var r=e.children[n];this.add(r.clone())}return this}}),xn.prototype=Object.assign(Object.create(yn.prototype),{constructor:xn,isScene:!0,copy:function(e,t){return yn.prototype.copy.call(this,e,t),null!==e.background&&(this.background=e.background.clone()),null!==e.fog&&(this.fog=e.fog.clone()),null!==e.overrideMaterial&&(this.overrideMaterial=e.overrideMaterial.clone()),this.autoUpdate=e.autoUpdate,this.matrixAutoUpdate=e.matrixAutoUpdate,this},toJSON:function(e){var t=yn.prototype.toJSON.call(this,e);return null!==this.background&&(t.object.background=this.background.toJSON(e)),null!==this.fog&&(t.object.fog=this.fog.toJSON()),t},dispose:function(){this.dispatchEvent({type:"dispose"})}});var bn=[new zt,new zt,new zt,new zt,new zt,new zt,new zt,new zt],wn=new zt,_n=new zt,Mn=new zt,En=new zt,Sn=new zt,Tn=new zt,An=new zt,Ln=new zt,Pn=new zt,Cn=new zt,Rn=new zt;function On(e,t){this.min=void 0!==e?e:new zt(1/0,1/0,1/0),this.max=void 0!==t?t:new zt(-1/0,-1/0,-1/0)}function Dn(e,t,n,r,i){var o,a;for(o=0,a=e.length-3;o<=a;o+=3){Rn.fromArray(e,o);var s=i.x*Math.abs(Rn.x)+i.y*Math.abs(Rn.y)+i.z*Math.abs(Rn.z),c=t.dot(Rn),l=n.dot(Rn),h=r.dot(Rn);if(Math.max(-Math.max(c,l,h),Math.min(c,l,h))>s)return!1}return!0}Object.assign(On.prototype,{isBox3:!0,set:function(e,t){return this.min.copy(e),this.max.copy(t),this},setFromArray:function(e){for(var t=1/0,n=1/0,r=1/0,i=-1/0,o=-1/0,a=-1/0,s=0,c=e.length;s<c;s+=3){var l=e[s],h=e[s+1],u=e[s+2];l<t&&(t=l),h<n&&(n=h),u<r&&(r=u),l>i&&(i=l),h>o&&(o=h),u>a&&(a=u)}return this.min.set(t,n,r),this.max.set(i,o,a),this},setFromBufferAttribute:function(e){for(var t=1/0,n=1/0,r=1/0,i=-1/0,o=-1/0,a=-1/0,s=0,c=e.count;s<c;s++){var l=e.getX(s),h=e.getY(s),u=e.getZ(s);l<t&&(t=l),h<n&&(n=h),u<r&&(r=u),l>i&&(i=l),h>o&&(o=h),u>a&&(a=u)}return this.min.set(t,n,r),this.max.set(i,o,a),this},setFromPoints:function(e){this.makeEmpty();for(var t=0,n=e.length;t<n;t++)this.expandByPoint(e[t]);return this},setFromCenterAndSize:function(e,t){var n=wn.copy(t).multiplyScalar(.5);return this.min.copy(e).sub(n),this.max.copy(e).add(n),this},setFromObject:function(e){return this.makeEmpty(),this.expandByObject(e)},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.min.copy(e.min),this.max.copy(e.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},getCenter:function(e){return void 0===e&&(console.warn("THREE.Box3: .getCenter() target is now required"),e=new zt),this.isEmpty()?e.set(0,0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(e){return void 0===e&&(console.warn("THREE.Box3: .getSize() target is now required"),e=new zt),this.isEmpty()?e.set(0,0,0):e.subVectors(this.max,this.min)},expandByPoint:function(e){return this.min.min(e),this.max.max(e),this},expandByVector:function(e){return this.min.sub(e),this.max.add(e),this},expandByScalar:function(e){return this.min.addScalar(-e),this.max.addScalar(e),this},expandByObject:function(e){var t,n;e.updateWorldMatrix(!1,!1);var r=e.geometry;if(void 0!==r)if(r.isGeometry){var i=r.vertices;for(t=0,n=i.length;t<n;t++)wn.copy(i[t]),wn.applyMatrix4(e.matrixWorld),this.expandByPoint(wn)}else if(r.isBufferGeometry){var o=r.attributes.position;if(void 0!==o)for(t=0,n=o.count;t<n;t++)wn.fromBufferAttribute(o,t).applyMatrix4(e.matrixWorld),this.expandByPoint(wn)}var a=e.children;for(t=0,n=a.length;t<n;t++)this.expandByObject(a[t]);return this},containsPoint:function(e){return!(e.x<this.min.x||e.x>this.max.x||e.y<this.min.y||e.y>this.max.y||e.z<this.min.z||e.z>this.max.z)},containsBox:function(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y&&this.min.z<=e.min.z&&e.max.z<=this.max.z},getParameter:function(e,t){return void 0===t&&(console.warn("THREE.Box3: .getParameter() target is now required"),t=new zt),t.set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y),(e.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(e){return!(e.max.x<this.min.x||e.min.x>this.max.x||e.max.y<this.min.y||e.min.y>this.max.y||e.max.z<this.min.z||e.min.z>this.max.z)},intersectsSphere:function(e){return this.clampPoint(e.center,wn),wn.distanceToSquared(e.center)<=e.radius*e.radius},intersectsPlane:function(e){var t,n;return e.normal.x>0?(t=e.normal.x*this.min.x,n=e.normal.x*this.max.x):(t=e.normal.x*this.max.x,n=e.normal.x*this.min.x),e.normal.y>0?(t+=e.normal.y*this.min.y,n+=e.normal.y*this.max.y):(t+=e.normal.y*this.max.y,n+=e.normal.y*this.min.y),e.normal.z>0?(t+=e.normal.z*this.min.z,n+=e.normal.z*this.max.z):(t+=e.normal.z*this.max.z,n+=e.normal.z*this.min.z),t<=-e.constant&&n>=-e.constant},intersectsTriangle:function(e){if(this.isEmpty())return!1;this.getCenter(Ln),Pn.subVectors(this.max,Ln),_n.subVectors(e.a,Ln),Mn.subVectors(e.b,Ln),En.subVectors(e.c,Ln),Sn.subVectors(Mn,_n),Tn.subVectors(En,Mn),An.subVectors(_n,En);var t=[0,-Sn.z,Sn.y,0,-Tn.z,Tn.y,0,-An.z,An.y,Sn.z,0,-Sn.x,Tn.z,0,-Tn.x,An.z,0,-An.x,-Sn.y,Sn.x,0,-Tn.y,Tn.x,0,-An.y,An.x,0];return!!Dn(t,_n,Mn,En,Pn)&&(!!Dn(t=[1,0,0,0,1,0,0,0,1],_n,Mn,En,Pn)&&(Cn.crossVectors(Sn,Tn),Dn(t=[Cn.x,Cn.y,Cn.z],_n,Mn,En,Pn)))},clampPoint:function(e,t){return void 0===t&&(console.warn("THREE.Box3: .clampPoint() target is now required"),t=new zt),t.copy(e).clamp(this.min,this.max)},distanceToPoint:function(e){return wn.copy(e).clamp(this.min,this.max).sub(e).length()},getBoundingSphere:function(e){return void 0===e&&console.error("THREE.Box3: .getBoundingSphere() target is now required"),this.getCenter(e.center),e.radius=.5*this.getSize(wn).length(),e},intersect:function(e){return this.min.max(e.min),this.max.min(e.max),this.isEmpty()&&this.makeEmpty(),this},union:function(e){return this.min.min(e.min),this.max.max(e.max),this},applyMatrix4:function(e){return this.isEmpty()?this:(bn[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e),bn[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e),bn[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e),bn[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e),bn[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e),bn[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e),bn[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e),bn[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e),this.setFromPoints(bn),this)},translate:function(e){return this.min.add(e),this.max.add(e),this},equals:function(e){return e.min.equals(this.min)&&e.max.equals(this.max)}});var Nn=new On;function In(e,t){this.center=void 0!==e?e:new zt,this.radius=void 0!==t?t:0}Object.assign(In.prototype,{set:function(e,t){return this.center.copy(e),this.radius=t,this},setFromPoints:function(e,t){var n=this.center;void 0!==t?n.copy(t):Nn.setFromPoints(e).getCenter(n);for(var r=0,i=0,o=e.length;i<o;i++)r=Math.max(r,n.distanceToSquared(e[i]));return this.radius=Math.sqrt(r),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.center.copy(e.center),this.radius=e.radius,this},empty:function(){return this.radius<=0},containsPoint:function(e){return e.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(e){return e.distanceTo(this.center)-this.radius},intersectsSphere:function(e){var t=this.radius+e.radius;return e.center.distanceToSquared(this.center)<=t*t},intersectsBox:function(e){return e.intersectsSphere(this)},intersectsPlane:function(e){return Math.abs(e.distanceToPoint(this.center))<=this.radius},clampPoint:function(e,t){var n=this.center.distanceToSquared(e);return void 0===t&&(console.warn("THREE.Sphere: .clampPoint() target is now required"),t=new zt),t.copy(e),n>this.radius*this.radius&&(t.sub(this.center).normalize(),t.multiplyScalar(this.radius).add(this.center)),t},getBoundingBox:function(e){return void 0===e&&(console.warn("THREE.Sphere: .getBoundingBox() target is now required"),e=new On),e.set(this.center,this.center),e.expandByScalar(this.radius),e},applyMatrix4:function(e){return this.center.applyMatrix4(e),this.radius=this.radius*e.getMaxScaleOnAxis(),this},translate:function(e){return this.center.add(e),this},equals:function(e){return e.center.equals(this.center)&&e.radius===this.radius}});var zn=new zt,kn=new zt,Fn=new zt,Un=new zt,Bn=new zt,jn=new zt,Hn=new zt;function Gn(e,t){this.origin=void 0!==e?e:new zt,this.direction=void 0!==t?t:new zt}Object.assign(Gn.prototype,{set:function(e,t){return this.origin.copy(e),this.direction.copy(t),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.origin.copy(e.origin),this.direction.copy(e.direction),this},at:function(e,t){return void 0===t&&(console.warn("THREE.Ray: .at() target is now required"),t=new zt),t.copy(this.direction).multiplyScalar(e).add(this.origin)},lookAt:function(e){return this.direction.copy(e).sub(this.origin).normalize(),this},recast:function(e){return this.origin.copy(this.at(e,zn)),this},closestPointToPoint:function(e,t){void 0===t&&(console.warn("THREE.Ray: .closestPointToPoint() target is now required"),t=new zt),t.subVectors(e,this.origin);var n=t.dot(this.direction);return n<0?t.copy(this.origin):t.copy(this.direction).multiplyScalar(n).add(this.origin)},distanceToPoint:function(e){return Math.sqrt(this.distanceSqToPoint(e))},distanceSqToPoint:function(e){var t=zn.subVectors(e,this.origin).dot(this.direction);return t<0?this.origin.distanceToSquared(e):(zn.copy(this.direction).multiplyScalar(t).add(this.origin),zn.distanceToSquared(e))},distanceSqToSegment:function(e,t,n,r){kn.copy(e).add(t).multiplyScalar(.5),Fn.copy(t).sub(e).normalize(),Un.copy(this.origin).sub(kn);var i,o,a,s,c=.5*e.distanceTo(t),l=-this.direction.dot(Fn),h=Un.dot(this.direction),u=-Un.dot(Fn),p=Un.lengthSq(),d=Math.abs(1-l*l);if(d>0)if(o=l*h-u,s=c*d,(i=l*u-h)>=0)if(o>=-s)if(o<=s){var f=1/d;a=(i*=f)*(i+l*(o*=f)+2*h)+o*(l*i+o+2*u)+p}else o=c,a=-(i=Math.max(0,-(l*o+h)))*i+o*(o+2*u)+p;else o=-c,a=-(i=Math.max(0,-(l*o+h)))*i+o*(o+2*u)+p;else o<=-s?a=-(i=Math.max(0,-(-l*c+h)))*i+(o=i>0?-c:Math.min(Math.max(-c,-u),c))*(o+2*u)+p:o<=s?(i=0,a=(o=Math.min(Math.max(-c,-u),c))*(o+2*u)+p):a=-(i=Math.max(0,-(l*c+h)))*i+(o=i>0?c:Math.min(Math.max(-c,-u),c))*(o+2*u)+p;else o=l>0?-c:c,a=-(i=Math.max(0,-(l*o+h)))*i+o*(o+2*u)+p;return n&&n.copy(this.direction).multiplyScalar(i).add(this.origin),r&&r.copy(Fn).multiplyScalar(o).add(kn),a},intersectSphere:function(e,t){zn.subVectors(e.center,this.origin);var n=zn.dot(this.direction),r=zn.dot(zn)-n*n,i=e.radius*e.radius;if(r>i)return null;var o=Math.sqrt(i-r),a=n-o,s=n+o;return a<0&&s<0?null:a<0?this.at(s,t):this.at(a,t)},intersectsSphere:function(e){return this.distanceSqToPoint(e.center)<=e.radius*e.radius},distanceToPlane:function(e){var t=e.normal.dot(this.direction);if(0===t)return 0===e.distanceToPoint(this.origin)?0:null;var n=-(this.origin.dot(e.normal)+e.constant)/t;return n>=0?n:null},intersectPlane:function(e,t){var n=this.distanceToPlane(e);return null===n?null:this.at(n,t)},intersectsPlane:function(e){var t=e.distanceToPoint(this.origin);return 0===t||e.normal.dot(this.direction)*t<0},intersectBox:function(e,t){var n,r,i,o,a,s,c=1/this.direction.x,l=1/this.direction.y,h=1/this.direction.z,u=this.origin;return c>=0?(n=(e.min.x-u.x)*c,r=(e.max.x-u.x)*c):(n=(e.max.x-u.x)*c,r=(e.min.x-u.x)*c),l>=0?(i=(e.min.y-u.y)*l,o=(e.max.y-u.y)*l):(i=(e.max.y-u.y)*l,o=(e.min.y-u.y)*l),n>o||i>r?null:((i>n||n!=n)&&(n=i),(o<r||r!=r)&&(r=o),h>=0?(a=(e.min.z-u.z)*h,s=(e.max.z-u.z)*h):(a=(e.max.z-u.z)*h,s=(e.min.z-u.z)*h),n>s||a>r?null:((a>n||n!=n)&&(n=a),(s<r||r!=r)&&(r=s),r<0?null:this.at(n>=0?n:r,t)))},intersectsBox:function(e){return null!==this.intersectBox(e,zn)},intersectTriangle:function(e,t,n,r,i){Bn.subVectors(t,e),jn.subVectors(n,e),Hn.crossVectors(Bn,jn);var o,a=this.direction.dot(Hn);if(a>0){if(r)return null;o=1}else{if(!(a<0))return null;o=-1,a=-a}Un.subVectors(this.origin,e);var s=o*this.direction.dot(jn.crossVectors(Un,jn));if(s<0)return null;var c=o*this.direction.dot(Bn.cross(Un));if(c<0)return null;if(s+c>a)return null;var l=-o*Un.dot(Hn);return l<0?null:this.at(l/a,i)},applyMatrix4:function(e){return this.origin.applyMatrix4(e),this.direction.transformDirection(e),this},equals:function(e){return e.origin.equals(this.origin)&&e.direction.equals(this.direction)}});var Vn=new zt,Wn=new zt,qn=new Ut;function Xn(e,t){this.normal=void 0!==e?e:new zt(1,0,0),this.constant=void 0!==t?t:0}Object.assign(Xn.prototype,{isPlane:!0,set:function(e,t){return this.normal.copy(e),this.constant=t,this},setComponents:function(e,t,n,r){return this.normal.set(e,t,n),this.constant=r,this},setFromNormalAndCoplanarPoint:function(e,t){return this.normal.copy(e),this.constant=-t.dot(this.normal),this},setFromCoplanarPoints:function(e,t,n){var r=Vn.subVectors(n,t).cross(Wn.subVectors(e,t)).normalize();return this.setFromNormalAndCoplanarPoint(r,e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.normal.copy(e.normal),this.constant=e.constant,this},normalize:function(){var e=1/this.normal.length();return this.normal.multiplyScalar(e),this.constant*=e,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(e){return this.normal.dot(e)+this.constant},distanceToSphere:function(e){return this.distanceToPoint(e.center)-e.radius},projectPoint:function(e,t){return void 0===t&&(console.warn("THREE.Plane: .projectPoint() target is now required"),t=new zt),t.copy(this.normal).multiplyScalar(-this.distanceToPoint(e)).add(e)},intersectLine:function(e,t){void 0===t&&(console.warn("THREE.Plane: .intersectLine() target is now required"),t=new zt);var n=e.delta(Vn),r=this.normal.dot(n);if(0===r)return 0===this.distanceToPoint(e.start)?t.copy(e.start):void 0;var i=-(e.start.dot(this.normal)+this.constant)/r;return i<0||i>1?void 0:t.copy(n).multiplyScalar(i).add(e.start)},intersectsLine:function(e){var t=this.distanceToPoint(e.start),n=this.distanceToPoint(e.end);return t<0&&n>0||n<0&&t>0},intersectsBox:function(e){return e.intersectsPlane(this)},intersectsSphere:function(e){return e.intersectsPlane(this)},coplanarPoint:function(e){return void 0===e&&(console.warn("THREE.Plane: .coplanarPoint() target is now required"),e=new zt),e.copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(e,t){var n=t||qn.getNormalMatrix(e),r=this.coplanarPoint(Vn).applyMatrix4(e),i=this.normal.applyMatrix3(n).normalize();return this.constant=-r.dot(i),this},translate:function(e){return this.constant-=e.dot(this.normal),this},equals:function(e){return e.normal.equals(this.normal)&&e.constant===this.constant}});var Yn=new zt,Zn=new zt,Jn=new zt,Qn=new zt,Kn=new zt,$n=new zt,er=new zt,tr=new zt,nr=new zt,rr=new zt;function ir(e,t,n){this.a=void 0!==e?e:new zt,this.b=void 0!==t?t:new zt,this.c=void 0!==n?n:new zt}Object.assign(ir,{getNormal:function(e,t,n,r){void 0===r&&(console.warn("THREE.Triangle: .getNormal() target is now required"),r=new zt),r.subVectors(n,t),Yn.subVectors(e,t),r.cross(Yn);var i=r.lengthSq();return i>0?r.multiplyScalar(1/Math.sqrt(i)):r.set(0,0,0)},getBarycoord:function(e,t,n,r,i){Yn.subVectors(r,t),Zn.subVectors(n,t),Jn.subVectors(e,t);var o=Yn.dot(Yn),a=Yn.dot(Zn),s=Yn.dot(Jn),c=Zn.dot(Zn),l=Zn.dot(Jn),h=o*c-a*a;if(void 0===i&&(console.warn("THREE.Triangle: .getBarycoord() target is now required"),i=new zt),0===h)return i.set(-2,-1,-1);var u=1/h,p=(c*s-a*l)*u,d=(o*l-a*s)*u;return i.set(1-p-d,d,p)},containsPoint:function(e,t,n,r){return ir.getBarycoord(e,t,n,r,Qn),Qn.x>=0&&Qn.y>=0&&Qn.x+Qn.y<=1},getUV:function(e,t,n,r,i,o,a,s){return this.getBarycoord(e,t,n,r,Qn),s.set(0,0),s.addScaledVector(i,Qn.x),s.addScaledVector(o,Qn.y),s.addScaledVector(a,Qn.z),s},isFrontFacing:function(e,t,n,r){return Yn.subVectors(n,t),Zn.subVectors(e,t),Yn.cross(Zn).dot(r)<0}}),Object.assign(ir.prototype,{set:function(e,t,n){return this.a.copy(e),this.b.copy(t),this.c.copy(n),this},setFromPointsAndIndices:function(e,t,n,r){return this.a.copy(e[t]),this.b.copy(e[n]),this.c.copy(e[r]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.a.copy(e.a),this.b.copy(e.b),this.c.copy(e.c),this},getArea:function(){return Yn.subVectors(this.c,this.b),Zn.subVectors(this.a,this.b),.5*Yn.cross(Zn).length()},getMidpoint:function(e){return void 0===e&&(console.warn("THREE.Triangle: .getMidpoint() target is now required"),e=new zt),e.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},getNormal:function(e){return ir.getNormal(this.a,this.b,this.c,e)},getPlane:function(e){return void 0===e&&(console.warn("THREE.Triangle: .getPlane() target is now required"),e=new Xn),e.setFromCoplanarPoints(this.a,this.b,this.c)},getBarycoord:function(e,t){return ir.getBarycoord(e,this.a,this.b,this.c,t)},getUV:function(e,t,n,r,i){return ir.getUV(e,this.a,this.b,this.c,t,n,r,i)},containsPoint:function(e){return ir.containsPoint(e,this.a,this.b,this.c)},isFrontFacing:function(e){return ir.isFrontFacing(this.a,this.b,this.c,e)},intersectsBox:function(e){return e.intersectsTriangle(this)},closestPointToPoint:function(e,t){void 0===t&&(console.warn("THREE.Triangle: .closestPointToPoint() target is now required"),t=new zt);var n,r,i=this.a,o=this.b,a=this.c;Kn.subVectors(o,i),$n.subVectors(a,i),tr.subVectors(e,i);var s=Kn.dot(tr),c=$n.dot(tr);if(s<=0&&c<=0)return t.copy(i);nr.subVectors(e,o);var l=Kn.dot(nr),h=$n.dot(nr);if(l>=0&&h<=l)return t.copy(o);var u=s*h-l*c;if(u<=0&&s>=0&&l<=0)return n=s/(s-l),t.copy(i).addScaledVector(Kn,n);rr.subVectors(e,a);var p=Kn.dot(rr),d=$n.dot(rr);if(d>=0&&p<=d)return t.copy(a);var f=p*c-s*d;if(f<=0&&c>=0&&d<=0)return r=c/(c-d),t.copy(i).addScaledVector($n,r);var m=l*d-p*h;if(m<=0&&h-l>=0&&p-d>=0)return er.subVectors(a,o),r=(h-l)/(h-l+(p-d)),t.copy(o).addScaledVector(er,r);var g=1/(m+f+u);return n=f*g,r=u*g,t.copy(i).addScaledVector(Kn,n).addScaledVector($n,r)},equals:function(e){return e.a.equals(this.a)&&e.b.equals(this.b)&&e.c.equals(this.c)}});var or={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},ar={h:0,s:0,l:0},sr={h:0,s:0,l:0};function cr(e,t,n){return void 0===t&&void 0===n?this.set(e):this.setRGB(e,t,n)}function lr(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+6*(t-e)*(2/3-n):e}function hr(e){return e<.04045?.0773993808*e:Math.pow(.9478672986*e+.0521327014,2.4)}function ur(e){return e<.0031308?12.92*e:1.055*Math.pow(e,.41666)-.055}function pr(e,t,n,r,i,o){this.a=e,this.b=t,this.c=n,this.normal=r&&r.isVector3?r:new zt,this.vertexNormals=Array.isArray(r)?r:[],this.color=i&&i.isColor?i:new cr,this.vertexColors=Array.isArray(i)?i:[],this.materialIndex=void 0!==o?o:0}Object.assign(cr.prototype,{isColor:!0,r:1,g:1,b:1,set:function(e){return e&&e.isColor?this.copy(e):"number"==typeof e?this.setHex(e):"string"==typeof e&&this.setStyle(e),this},setScalar:function(e){return this.r=e,this.g=e,this.b=e,this},setHex:function(e){return e=Math.floor(e),this.r=(e>>16&255)/255,this.g=(e>>8&255)/255,this.b=(255&e)/255,this},setRGB:function(e,t,n){return this.r=e,this.g=t,this.b=n,this},setHSL:function(e,t,n){if(e=Rt.euclideanModulo(e,1),t=Rt.clamp(t,0,1),n=Rt.clamp(n,0,1),0===t)this.r=this.g=this.b=n;else{var r=n<=.5?n*(1+t):n+t-n*t,i=2*n-r;this.r=lr(i,r,e+1/3),this.g=lr(i,r,e),this.b=lr(i,r,e-1/3)}return this},setStyle:function(e){function t(t){void 0!==t&&parseFloat(t)<1&&console.warn("THREE.Color: Alpha component of "+e+" will be ignored.")}var n;if(n=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(e)){var r,i=n[1],o=n[2];switch(i){case"rgb":case"rgba":if(r=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(255,parseInt(r[1],10))/255,this.g=Math.min(255,parseInt(r[2],10))/255,this.b=Math.min(255,parseInt(r[3],10))/255,t(r[5]),this;if(r=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(100,parseInt(r[1],10))/100,this.g=Math.min(100,parseInt(r[2],10))/100,this.b=Math.min(100,parseInt(r[3],10))/100,t(r[5]),this;break;case"hsl":case"hsla":if(r=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o)){var a=parseFloat(r[1])/360,s=parseInt(r[2],10)/100,c=parseInt(r[3],10)/100;return t(r[5]),this.setHSL(a,s,c)}}}else if(n=/^\#([A-Fa-f0-9]+)$/.exec(e)){var l=n[1],h=l.length;if(3===h)return this.r=parseInt(l.charAt(0)+l.charAt(0),16)/255,this.g=parseInt(l.charAt(1)+l.charAt(1),16)/255,this.b=parseInt(l.charAt(2)+l.charAt(2),16)/255,this;if(6===h)return this.r=parseInt(l.charAt(0)+l.charAt(1),16)/255,this.g=parseInt(l.charAt(2)+l.charAt(3),16)/255,this.b=parseInt(l.charAt(4)+l.charAt(5),16)/255,this}return e&&e.length>0?this.setColorName(e):this},setColorName:function(e){var t=or[e];return void 0!==t?this.setHex(t):console.warn("THREE.Color: Unknown color "+e),this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(e){return this.r=e.r,this.g=e.g,this.b=e.b,this},copyGammaToLinear:function(e,t){return void 0===t&&(t=2),this.r=Math.pow(e.r,t),this.g=Math.pow(e.g,t),this.b=Math.pow(e.b,t),this},copyLinearToGamma:function(e,t){void 0===t&&(t=2);var n=t>0?1/t:1;return this.r=Math.pow(e.r,n),this.g=Math.pow(e.g,n),this.b=Math.pow(e.b,n),this},convertGammaToLinear:function(e){return this.copyGammaToLinear(this,e),this},convertLinearToGamma:function(e){return this.copyLinearToGamma(this,e),this},copySRGBToLinear:function(e){return this.r=hr(e.r),this.g=hr(e.g),this.b=hr(e.b),this},copyLinearToSRGB:function(e){return this.r=ur(e.r),this.g=ur(e.g),this.b=ur(e.b),this},convertSRGBToLinear:function(){return this.copySRGBToLinear(this),this},convertLinearToSRGB:function(){return this.copyLinearToSRGB(this),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(e){void 0===e&&(console.warn("THREE.Color: .getHSL() target is now required"),e={h:0,s:0,l:0});var t,n,r=this.r,i=this.g,o=this.b,a=Math.max(r,i,o),s=Math.min(r,i,o),c=(s+a)/2;if(s===a)t=0,n=0;else{var l=a-s;switch(n=c<=.5?l/(a+s):l/(2-a-s),a){case r:t=(i-o)/l+(i<o?6:0);break;case i:t=(o-r)/l+2;break;case o:t=(r-i)/l+4}t/=6}return e.h=t,e.s=n,e.l=c,e},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(e,t,n){return this.getHSL(ar),ar.h+=e,ar.s+=t,ar.l+=n,this.setHSL(ar.h,ar.s,ar.l),this},add:function(e){return this.r+=e.r,this.g+=e.g,this.b+=e.b,this},addColors:function(e,t){return this.r=e.r+t.r,this.g=e.g+t.g,this.b=e.b+t.b,this},addScalar:function(e){return this.r+=e,this.g+=e,this.b+=e,this},sub:function(e){return this.r=Math.max(0,this.r-e.r),this.g=Math.max(0,this.g-e.g),this.b=Math.max(0,this.b-e.b),this},multiply:function(e){return this.r*=e.r,this.g*=e.g,this.b*=e.b,this},multiplyScalar:function(e){return this.r*=e,this.g*=e,this.b*=e,this},lerp:function(e,t){return this.r+=(e.r-this.r)*t,this.g+=(e.g-this.g)*t,this.b+=(e.b-this.b)*t,this},lerpHSL:function(e,t){this.getHSL(ar),e.getHSL(sr);var n=Rt.lerp(ar.h,sr.h,t),r=Rt.lerp(ar.s,sr.s,t),i=Rt.lerp(ar.l,sr.l,t);return this.setHSL(n,r,i),this},equals:function(e){return e.r===this.r&&e.g===this.g&&e.b===this.b},fromArray:function(e,t){return void 0===t&&(t=0),this.r=e[t],this.g=e[t+1],this.b=e[t+2],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,e},toJSON:function(){return this.getHex()}}),cr.NAMES=or,Object.assign(pr.prototype,{clone:function(){return(new this.constructor).copy(this)},copy:function(e){this.a=e.a,this.b=e.b,this.c=e.c,this.normal.copy(e.normal),this.color.copy(e.color),this.materialIndex=e.materialIndex;for(var t=0,n=e.vertexNormals.length;t<n;t++)this.vertexNormals[t]=e.vertexNormals[t].clone();for(t=0,n=e.vertexColors.length;t<n;t++)this.vertexColors[t]=e.vertexColors[t].clone();return this}});var dr=0;function fr(){Object.defineProperty(this,"id",{value:dr++}),this.uuid=Rt.generateUUID(),this.name="",this.type="Material",this.fog=!0,this.blending=y,this.side=u,this.flatShading=!1,this.vertexTangents=!1,this.vertexColors=f,this.opacity=1,this.transparent=!1,this.blendSrc=O,this.blendDst=D,this.blendEquation=M,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=H,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=Tt,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=St,this.stencilZFail=St,this.stencilZPass=St,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaTest=0,this.premultipliedAlpha=!1,this.visible=!0,this.toneMapped=!0,this.userData={},this.needsUpdate=!0}function mr(e){fr.call(this),this.type="MeshBasicMaterial",this.color=new cr(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=X,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.setValues(e)}function gr(e,t,n){if(Array.isArray(e))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.name="",this.array=e,this.itemSize=t,this.count=void 0!==e?e.length/t:0,this.normalized=!0===n,this.usage=At,this.updateRange={offset:0,count:-1},this.version=0}function vr(e,t,n){gr.call(this,new Int8Array(e),t,n)}function yr(e,t,n){gr.call(this,new Uint8Array(e),t,n)}function xr(e,t,n){gr.call(this,new Uint8ClampedArray(e),t,n)}function br(e,t,n){gr.call(this,new Int16Array(e),t,n)}function wr(e,t,n){gr.call(this,new Uint16Array(e),t,n)}function _r(e,t,n){gr.call(this,new Int32Array(e),t,n)}function Mr(e,t,n){gr.call(this,new Uint32Array(e),t,n)}function Er(e,t,n){gr.call(this,new Float32Array(e),t,n)}function Sr(e,t,n){gr.call(this,new Float64Array(e),t,n)}function Tr(){this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}function Ar(e){if(0===e.length)return-1/0;for(var t=e[0],n=1,r=e.length;n<r;++n)e[n]>t&&(t=e[n]);return t}fr.prototype=Object.assign(Object.create(Lt.prototype),{constructor:fr,isMaterial:!0,onBeforeCompile:function(){},setValues:function(e){if(void 0!==e)for(var t in e){var n=e[t];if(void 0!==n)if("shading"!==t){var r=this[t];void 0!==r?r&&r.isColor?r.set(n):r&&r.isVector3&&n&&n.isVector3?r.copy(n):this[t]=n:console.warn("THREE."+this.type+": '"+t+"' is not a property of this material.")}else console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===n;else console.warn("THREE.Material: '"+t+"' parameter is undefined.")}},toJSON:function(e){var t=void 0===e||"string"==typeof e;t&&(e={textures:{},images:{}});var n={metadata:{version:4.5,type:"Material",generator:"Material.toJSON"}};function r(e){var t=[];for(var n in e){var r=e[n];delete r.metadata,t.push(r)}return t}if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),this.color&&this.color.isColor&&(n.color=this.color.getHex()),void 0!==this.roughness&&(n.roughness=this.roughness),void 0!==this.metalness&&(n.metalness=this.metalness),this.sheen&&this.sheen.isColor&&(n.sheen=this.sheen.getHex()),this.emissive&&this.emissive.isColor&&(n.emissive=this.emissive.getHex()),this.emissiveIntensity&&1!==this.emissiveIntensity&&(n.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(n.specular=this.specular.getHex()),void 0!==this.shininess&&(n.shininess=this.shininess),void 0!==this.clearcoat&&(n.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(n.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(n.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(e).uuid,n.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),this.map&&this.map.isTexture&&(n.map=this.map.toJSON(e).uuid),this.matcap&&this.matcap.isTexture&&(n.matcap=this.matcap.toJSON(e).uuid),this.alphaMap&&this.alphaMap.isTexture&&(n.alphaMap=this.alphaMap.toJSON(e).uuid),this.lightMap&&this.lightMap.isTexture&&(n.lightMap=this.lightMap.toJSON(e).uuid),this.aoMap&&this.aoMap.isTexture&&(n.aoMap=this.aoMap.toJSON(e).uuid,n.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(n.bumpMap=this.bumpMap.toJSON(e).uuid,n.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(n.normalMap=this.normalMap.toJSON(e).uuid,n.normalMapType=this.normalMapType,n.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(n.displacementMap=this.displacementMap.toJSON(e).uuid,n.displacementScale=this.displacementScale,n.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(n.roughnessMap=this.roughnessMap.toJSON(e).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(n.metalnessMap=this.metalnessMap.toJSON(e).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(n.emissiveMap=this.emissiveMap.toJSON(e).uuid),this.specularMap&&this.specularMap.isTexture&&(n.specularMap=this.specularMap.toJSON(e).uuid),this.envMap&&this.envMap.isTexture&&(n.envMap=this.envMap.toJSON(e).uuid,n.reflectivity=this.reflectivity,n.refractionRatio=this.refractionRatio,void 0!==this.combine&&(n.combine=this.combine),void 0!==this.envMapIntensity&&(n.envMapIntensity=this.envMapIntensity)),this.gradientMap&&this.gradientMap.isTexture&&(n.gradientMap=this.gradientMap.toJSON(e).uuid),void 0!==this.size&&(n.size=this.size),void 0!==this.sizeAttenuation&&(n.sizeAttenuation=this.sizeAttenuation),this.blending!==y&&(n.blending=this.blending),!0===this.flatShading&&(n.flatShading=this.flatShading),this.side!==u&&(n.side=this.side),this.vertexColors!==f&&(n.vertexColors=this.vertexColors),this.opacity<1&&(n.opacity=this.opacity),!0===this.transparent&&(n.transparent=this.transparent),n.depthFunc=this.depthFunc,n.depthTest=this.depthTest,n.depthWrite=this.depthWrite,n.stencilWrite=this.stencilWrite,n.stencilWriteMask=this.stencilWriteMask,n.stencilFunc=this.stencilFunc,n.stencilRef=this.stencilRef,n.stencilFuncMask=this.stencilFuncMask,n.stencilFail=this.stencilFail,n.stencilZFail=this.stencilZFail,n.stencilZPass=this.stencilZPass,this.rotation&&0!==this.rotation&&(n.rotation=this.rotation),!0===this.polygonOffset&&(n.polygonOffset=!0),0!==this.polygonOffsetFactor&&(n.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(n.polygonOffsetUnits=this.polygonOffsetUnits),this.linewidth&&1!==this.linewidth&&(n.linewidth=this.linewidth),void 0!==this.dashSize&&(n.dashSize=this.dashSize),void 0!==this.gapSize&&(n.gapSize=this.gapSize),void 0!==this.scale&&(n.scale=this.scale),!0===this.dithering&&(n.dithering=!0),this.alphaTest>0&&(n.alphaTest=this.alphaTest),!0===this.premultipliedAlpha&&(n.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(n.wireframe=this.wireframe),this.wireframeLinewidth>1&&(n.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(n.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(n.wireframeLinejoin=this.wireframeLinejoin),!0===this.morphTargets&&(n.morphTargets=!0),!0===this.morphNormals&&(n.morphNormals=!0),!0===this.skinning&&(n.skinning=!0),!1===this.visible&&(n.visible=!1),!1===this.toneMapped&&(n.toneMapped=!1),"{}"!==JSON.stringify(this.userData)&&(n.userData=this.userData),t){var i=r(e.textures),o=r(e.images);i.length>0&&(n.textures=i),o.length>0&&(n.images=o)}return n},clone:function(){return(new this.constructor).copy(this)},copy:function(e){this.name=e.name,this.fog=e.fog,this.blending=e.blending,this.side=e.side,this.flatShading=e.flatShading,this.vertexTangents=e.vertexTangents,this.vertexColors=e.vertexColors,this.opacity=e.opacity,this.transparent=e.transparent,this.blendSrc=e.blendSrc,this.blendDst=e.blendDst,this.blendEquation=e.blendEquation,this.blendSrcAlpha=e.blendSrcAlpha,this.blendDstAlpha=e.blendDstAlpha,this.blendEquationAlpha=e.blendEquationAlpha,this.depthFunc=e.depthFunc,this.depthTest=e.depthTest,this.depthWrite=e.depthWrite,this.stencilWriteMask=e.stencilWriteMask,this.stencilFunc=e.stencilFunc,this.stencilRef=e.stencilRef,this.stencilFuncMask=e.stencilFuncMask,this.stencilFail=e.stencilFail,this.stencilZFail=e.stencilZFail,this.stencilZPass=e.stencilZPass,this.stencilWrite=e.stencilWrite;var t=e.clippingPlanes,n=null;if(null!==t){var r=t.length;n=new Array(r);for(var i=0;i!==r;++i)n[i]=t[i].clone()}return this.clippingPlanes=n,this.clipIntersection=e.clipIntersection,this.clipShadows=e.clipShadows,this.shadowSide=e.shadowSide,this.colorWrite=e.colorWrite,this.precision=e.precision,this.polygonOffset=e.polygonOffset,this.polygonOffsetFactor=e.polygonOffsetFactor,this.polygonOffsetUnits=e.polygonOffsetUnits,this.dithering=e.dithering,this.alphaTest=e.alphaTest,this.premultipliedAlpha=e.premultipliedAlpha,this.visible=e.visible,this.toneMapped=e.toneMapped,this.userData=JSON.parse(JSON.stringify(e.userData)),this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),mr.prototype=Object.create(fr.prototype),mr.prototype.constructor=mr,mr.prototype.isMeshBasicMaterial=!0,mr.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this},Object.defineProperty(gr.prototype,"needsUpdate",{set:function(e){!0===e&&this.version++}}),Object.assign(gr.prototype,{isBufferAttribute:!0,onUploadCallback:function(){},setUsage:function(e){return this.usage=e,this},copy:function(e){return this.name=e.name,this.array=new e.array.constructor(e.array),this.itemSize=e.itemSize,this.count=e.count,this.normalized=e.normalized,this.usage=e.usage,this},copyAt:function(e,t,n){e*=this.itemSize,n*=t.itemSize;for(var r=0,i=this.itemSize;r<i;r++)this.array[e+r]=t.array[n+r];return this},copyArray:function(e){return this.array.set(e),this},copyColorsArray:function(e){for(var t=this.array,n=0,r=0,i=e.length;r<i;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",r),o=new cr),t[n++]=o.r,t[n++]=o.g,t[n++]=o.b}return this},copyVector2sArray:function(e){for(var t=this.array,n=0,r=0,i=e.length;r<i;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",r),o=new Ot),t[n++]=o.x,t[n++]=o.y}return this},copyVector3sArray:function(e){for(var t=this.array,n=0,r=0,i=e.length;r<i;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",r),o=new zt),t[n++]=o.x,t[n++]=o.y,t[n++]=o.z}return this},copyVector4sArray:function(e){for(var t=this.array,n=0,r=0,i=e.length;r<i;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",r),o=new Gt),t[n++]=o.x,t[n++]=o.y,t[n++]=o.z,t[n++]=o.w}return this},set:function(e,t){return void 0===t&&(t=0),this.array.set(e,t),this},getX:function(e){return this.array[e*this.itemSize]},setX:function(e,t){return this.array[e*this.itemSize]=t,this},getY:function(e){return this.array[e*this.itemSize+1]},setY:function(e,t){return this.array[e*this.itemSize+1]=t,this},getZ:function(e){return this.array[e*this.itemSize+2]},setZ:function(e,t){return this.array[e*this.itemSize+2]=t,this},getW:function(e){return this.array[e*this.itemSize+3]},setW:function(e,t){return this.array[e*this.itemSize+3]=t,this},setXY:function(e,t,n){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=n,this},setXYZ:function(e,t,n,r){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=n,this.array[e+2]=r,this},setXYZW:function(e,t,n,r,i){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=n,this.array[e+2]=r,this.array[e+3]=i,this},onUpload:function(e){return this.onUploadCallback=e,this},clone:function(){return new this.constructor(this.array,this.itemSize).copy(this)},toJSON:function(){return{itemSize:this.itemSize,type:this.array.constructor.name,array:Array.prototype.slice.call(this.array),normalized:this.normalized}}}),vr.prototype=Object.create(gr.prototype),vr.prototype.constructor=vr,yr.prototype=Object.create(gr.prototype),yr.prototype.constructor=yr,xr.prototype=Object.create(gr.prototype),xr.prototype.constructor=xr,br.prototype=Object.create(gr.prototype),br.prototype.constructor=br,wr.prototype=Object.create(gr.prototype),wr.prototype.constructor=wr,_r.prototype=Object.create(gr.prototype),_r.prototype.constructor=_r,Mr.prototype=Object.create(gr.prototype),Mr.prototype.constructor=Mr,Er.prototype=Object.create(gr.prototype),Er.prototype.constructor=Er,Sr.prototype=Object.create(gr.prototype),Sr.prototype.constructor=Sr,Object.assign(Tr.prototype,{computeGroups:function(e){for(var t,n=[],r=void 0,i=e.faces,o=0;o<i.length;o++){var a=i[o];a.materialIndex!==r&&(r=a.materialIndex,void 0!==t&&(t.count=3*o-t.start,n.push(t)),t={start:3*o,materialIndex:r})}void 0!==t&&(t.count=3*o-t.start,n.push(t)),this.groups=n},fromGeometry:function(e){var t,n=e.faces,r=e.vertices,i=e.faceVertexUvs,o=i[0]&&i[0].length>0,a=i[1]&&i[1].length>0,s=e.morphTargets,c=s.length;if(c>0){t=[];for(var l=0;l<c;l++)t[l]={name:s[l].name,data:[]};this.morphTargets.position=t}var h,u=e.morphNormals,p=u.length;if(p>0){h=[];for(l=0;l<p;l++)h[l]={name:u[l].name,data:[]};this.morphTargets.normal=h}var d=e.skinIndices,f=e.skinWeights,m=d.length===r.length,g=f.length===r.length;r.length>0&&0===n.length&&console.error("THREE.DirectGeometry: Faceless geometries are not supported.");for(l=0;l<n.length;l++){var v=n[l];this.vertices.push(r[v.a],r[v.b],r[v.c]);var y=v.vertexNormals;if(3===y.length)this.normals.push(y[0],y[1],y[2]);else{var x=v.normal;this.normals.push(x,x,x)}var b,w=v.vertexColors;if(3===w.length)this.colors.push(w[0],w[1],w[2]);else{var _=v.color;this.colors.push(_,_,_)}if(!0===o)void 0!==(b=i[0][l])?this.uvs.push(b[0],b[1],b[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",l),this.uvs.push(new Ot,new Ot,new Ot));if(!0===a)void 0!==(b=i[1][l])?this.uvs2.push(b[0],b[1],b[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",l),this.uvs2.push(new Ot,new Ot,new Ot));for(var M=0;M<c;M++){var E=s[M].vertices;t[M].data.push(E[v.a],E[v.b],E[v.c])}for(M=0;M<p;M++){var S=u[M].vertexNormals[l];h[M].data.push(S.a,S.b,S.c)}m&&this.skinIndices.push(d[v.a],d[v.b],d[v.c]),g&&this.skinWeights.push(f[v.a],f[v.b],f[v.c])}return this.computeGroups(e),this.verticesNeedUpdate=e.verticesNeedUpdate,this.normalsNeedUpdate=e.normalsNeedUpdate,this.colorsNeedUpdate=e.colorsNeedUpdate,this.uvsNeedUpdate=e.uvsNeedUpdate,this.groupsNeedUpdate=e.groupsNeedUpdate,null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),this}});var Lr=1,Pr=new $t,Cr=new yn,Rr=new zt,Or=new On,Dr=new On,Nr=new zt;function Ir(){Object.defineProperty(this,"id",{value:Lr+=2}),this.uuid=Rt.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}Ir.prototype=Object.assign(Object.create(Lt.prototype),{constructor:Ir,isBufferGeometry:!0,getIndex:function(){return this.index},setIndex:function(e){Array.isArray(e)?this.index=new(Ar(e)>65535?Mr:wr)(e,1):this.index=e},getAttribute:function(e){return this.attributes[e]},setAttribute:function(e,t){return this.attributes[e]=t,this},deleteAttribute:function(e){return delete this.attributes[e],this},addGroup:function(e,t,n){this.groups.push({start:e,count:t,materialIndex:void 0!==n?n:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(e,t){this.drawRange.start=e,this.drawRange.count=t},applyMatrix:function(e){var t=this.attributes.position;void 0!==t&&(e.applyToBufferAttribute(t),t.needsUpdate=!0);var n=this.attributes.normal;void 0!==n&&((new Ut).getNormalMatrix(e).applyToBufferAttribute(n),n.needsUpdate=!0);var r=this.attributes.tangent;void 0!==r&&((new Ut).getNormalMatrix(e).applyToBufferAttribute(r),r.needsUpdate=!0);return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(e){return Pr.makeRotationX(e),this.applyMatrix(Pr),this},rotateY:function(e){return Pr.makeRotationY(e),this.applyMatrix(Pr),this},rotateZ:function(e){return Pr.makeRotationZ(e),this.applyMatrix(Pr),this},translate:function(e,t,n){return Pr.makeTranslation(e,t,n),this.applyMatrix(Pr),this},scale:function(e,t,n){return Pr.makeScale(e,t,n),this.applyMatrix(Pr),this},lookAt:function(e){return Cr.lookAt(e),Cr.updateMatrix(),this.applyMatrix(Cr.matrix),this},center:function(){return this.computeBoundingBox(),this.boundingBox.getCenter(Rr).negate(),this.translate(Rr.x,Rr.y,Rr.z),this},setFromObject:function(e){var t=e.geometry;if(e.isPoints||e.isLine){var n=new Er(3*t.vertices.length,3),r=new Er(3*t.colors.length,3);if(this.setAttribute("position",n.copyVector3sArray(t.vertices)),this.setAttribute("color",r.copyColorsArray(t.colors)),t.lineDistances&&t.lineDistances.length===t.vertices.length){var i=new Er(t.lineDistances.length,1);this.setAttribute("lineDistance",i.copyArray(t.lineDistances))}null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone())}else e.isMesh&&t&&t.isGeometry&&this.fromGeometry(t);return this},setFromPoints:function(e){for(var t=[],n=0,r=e.length;n<r;n++){var i=e[n];t.push(i.x,i.y,i.z||0)}return this.setAttribute("position",new Er(t,3)),this},updateFromObject:function(e){var t,n=e.geometry;if(e.isMesh){var r=n.__directGeometry;if(!0===n.elementsNeedUpdate&&(r=void 0,n.elementsNeedUpdate=!1),void 0===r)return this.fromGeometry(n);r.verticesNeedUpdate=n.verticesNeedUpdate,r.normalsNeedUpdate=n.normalsNeedUpdate,r.colorsNeedUpdate=n.colorsNeedUpdate,r.uvsNeedUpdate=n.uvsNeedUpdate,r.groupsNeedUpdate=n.groupsNeedUpdate,n.verticesNeedUpdate=!1,n.normalsNeedUpdate=!1,n.colorsNeedUpdate=!1,n.uvsNeedUpdate=!1,n.groupsNeedUpdate=!1,n=r}return!0===n.verticesNeedUpdate&&(void 0!==(t=this.attributes.position)&&(t.copyVector3sArray(n.vertices),t.needsUpdate=!0),n.verticesNeedUpdate=!1),!0===n.normalsNeedUpdate&&(void 0!==(t=this.attributes.normal)&&(t.copyVector3sArray(n.normals),t.needsUpdate=!0),n.normalsNeedUpdate=!1),!0===n.colorsNeedUpdate&&(void 0!==(t=this.attributes.color)&&(t.copyColorsArray(n.colors),t.needsUpdate=!0),n.colorsNeedUpdate=!1),n.uvsNeedUpdate&&(void 0!==(t=this.attributes.uv)&&(t.copyVector2sArray(n.uvs),t.needsUpdate=!0),n.uvsNeedUpdate=!1),n.lineDistancesNeedUpdate&&(void 0!==(t=this.attributes.lineDistance)&&(t.copyArray(n.lineDistances),t.needsUpdate=!0),n.lineDistancesNeedUpdate=!1),n.groupsNeedUpdate&&(n.computeGroups(e.geometry),this.groups=n.groups,n.groupsNeedUpdate=!1),this},fromGeometry:function(e){return e.__directGeometry=(new Tr).fromGeometry(e),this.fromDirectGeometry(e.__directGeometry)},fromDirectGeometry:function(e){var t=new Float32Array(3*e.vertices.length);if(this.setAttribute("position",new gr(t,3).copyVector3sArray(e.vertices)),e.normals.length>0){var n=new Float32Array(3*e.normals.length);this.setAttribute("normal",new gr(n,3).copyVector3sArray(e.normals))}if(e.colors.length>0){var r=new Float32Array(3*e.colors.length);this.setAttribute("color",new gr(r,3).copyColorsArray(e.colors))}if(e.uvs.length>0){var i=new Float32Array(2*e.uvs.length);this.setAttribute("uv",new gr(i,2).copyVector2sArray(e.uvs))}if(e.uvs2.length>0){var o=new Float32Array(2*e.uvs2.length);this.setAttribute("uv2",new gr(o,2).copyVector2sArray(e.uvs2))}for(var a in this.groups=e.groups,e.morphTargets){for(var s=[],c=e.morphTargets[a],l=0,h=c.length;l<h;l++){var u=c[l],p=new Er(3*u.data.length,3);p.name=u.name,s.push(p.copyVector3sArray(u.data))}this.morphAttributes[a]=s}if(e.skinIndices.length>0){var d=new Er(4*e.skinIndices.length,4);this.setAttribute("skinIndex",d.copyVector4sArray(e.skinIndices))}if(e.skinWeights.length>0){var f=new Er(4*e.skinWeights.length,4);this.setAttribute("skinWeight",f.copyVector4sArray(e.skinWeights))}return null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new On);var e=this.attributes.position,t=this.morphAttributes.position;if(void 0!==e){if(this.boundingBox.setFromBufferAttribute(e),t)for(var n=0,r=t.length;n<r;n++){var i=t[n];Or.setFromBufferAttribute(i),this.boundingBox.expandByPoint(Or.min),this.boundingBox.expandByPoint(Or.max)}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new In);var e=this.attributes.position,t=this.morphAttributes.position;if(e){var n=this.boundingSphere.center;if(Or.setFromBufferAttribute(e),t)for(var r=0,i=t.length;r<i;r++){var o=t[r];Dr.setFromBufferAttribute(o),Or.expandByPoint(Dr.min),Or.expandByPoint(Dr.max)}Or.getCenter(n);var a=0;for(r=0,i=e.count;r<i;r++)Nr.fromBufferAttribute(e,r),a=Math.max(a,n.distanceToSquared(Nr));if(t)for(r=0,i=t.length;r<i;r++)for(var s=0,c=(o=t[r]).count;s<c;s++)Nr.fromBufferAttribute(o,s),a=Math.max(a,n.distanceToSquared(Nr));this.boundingSphere.radius=Math.sqrt(a),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}},computeFaceNormals:function(){},computeVertexNormals:function(){var e=this.index,t=this.attributes;if(t.position){var n=t.position.array;if(void 0===t.normal)this.setAttribute("normal",new gr(new Float32Array(n.length),3));else for(var r=t.normal.array,i=0,o=r.length;i<o;i++)r[i]=0;var a,s,c,l=t.normal.array,h=new zt,u=new zt,p=new zt,d=new zt,f=new zt;if(e){var m=e.array;for(i=0,o=e.count;i<o;i+=3)a=3*m[i+0],s=3*m[i+1],c=3*m[i+2],h.fromArray(n,a),u.fromArray(n,s),p.fromArray(n,c),d.subVectors(p,u),f.subVectors(h,u),d.cross(f),l[a]+=d.x,l[a+1]+=d.y,l[a+2]+=d.z,l[s]+=d.x,l[s+1]+=d.y,l[s+2]+=d.z,l[c]+=d.x,l[c+1]+=d.y,l[c+2]+=d.z}else for(i=0,o=n.length;i<o;i+=9)h.fromArray(n,i),u.fromArray(n,i+3),p.fromArray(n,i+6),d.subVectors(p,u),f.subVectors(h,u),d.cross(f),l[i]=d.x,l[i+1]=d.y,l[i+2]=d.z,l[i+3]=d.x,l[i+4]=d.y,l[i+5]=d.z,l[i+6]=d.x,l[i+7]=d.y,l[i+8]=d.z;this.normalizeNormals(),t.normal.needsUpdate=!0}},merge:function(e,t){if(e&&e.isBufferGeometry){void 0===t&&(t=0,console.warn("THREE.BufferGeometry.merge(): Overwriting original geometry, starting at offset=0. Use BufferGeometryUtils.mergeBufferGeometries() for lossless merge."));var n=this.attributes;for(var r in n)if(void 0!==e.attributes[r])for(var i=n[r].array,o=e.attributes[r],a=o.array,s=o.itemSize*t,c=Math.min(a.length,i.length-s),l=0,h=s;l<c;l++,h++)i[h]=a[l];return this}console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",e)},normalizeNormals:function(){for(var e=this.attributes.normal,t=0,n=e.count;t<n;t++)Nr.x=e.getX(t),Nr.y=e.getY(t),Nr.z=e.getZ(t),Nr.normalize(),e.setXYZ(t,Nr.x,Nr.y,Nr.z)},toNonIndexed:function(){function e(e,t){for(var n=e.array,r=e.itemSize,i=new n.constructor(t.length*r),o=0,a=0,s=0,c=t.length;s<c;s++){o=t[s]*r;for(var l=0;l<r;l++)i[a++]=n[o++]}return new gr(i,r)}if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var t=new Ir,n=this.index.array,r=this.attributes;for(var i in r){var o=e(r[i],n);t.setAttribute(i,o)}var a=this.morphAttributes;for(i in a){for(var s=[],c=a[i],l=0,h=c.length;l<h;l++){o=e(c[l],n);s.push(o)}t.morphAttributes[i]=s}for(var u=this.groups,p=(l=0,u.length);l<p;l++){var d=u[l];t.addGroup(d.start,d.count,d.materialIndex)}return t},toJSON:function(){var e={metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(e.uuid=this.uuid,e.type=this.type,""!==this.name&&(e.name=this.name),Object.keys(this.userData).length>0&&(e.userData=this.userData),void 0!==this.parameters){var t=this.parameters;for(var n in t)void 0!==t[n]&&(e[n]=t[n]);return e}e.data={attributes:{}};var r=this.index;null!==r&&(e.data.index={type:r.array.constructor.name,array:Array.prototype.slice.call(r.array)});var i=this.attributes;for(var n in i){var o=(p=i[n]).toJSON();""!==p.name&&(o.name=p.name),e.data.attributes[n]=o}var a={},s=!1;for(var n in this.morphAttributes){for(var c=this.morphAttributes[n],l=[],h=0,u=c.length;h<u;h++){var p;o=(p=c[h]).toJSON();""!==p.name&&(o.name=p.name),l.push(o)}l.length>0&&(a[n]=l,s=!0)}s&&(e.data.morphAttributes=a);var d=this.groups;d.length>0&&(e.data.groups=JSON.parse(JSON.stringify(d)));var f=this.boundingSphere;return null!==f&&(e.data.boundingSphere={center:f.center.toArray(),radius:f.radius}),e},clone:function(){return(new Ir).copy(this)},copy:function(e){var t,n,r;this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.name=e.name;var i=e.index;null!==i&&this.setIndex(i.clone());var o=e.attributes;for(t in o){var a=o[t];this.setAttribute(t,a.clone())}var s=e.morphAttributes;for(t in s){var c=[],l=s[t];for(n=0,r=l.length;n<r;n++)c.push(l[n].clone());this.morphAttributes[t]=c}var h=e.groups;for(n=0,r=h.length;n<r;n++){var u=h[n];this.addGroup(u.start,u.count,u.materialIndex)}var p=e.boundingBox;null!==p&&(this.boundingBox=p.clone());var d=e.boundingSphere;return null!==d&&(this.boundingSphere=d.clone()),this.drawRange.start=e.drawRange.start,this.drawRange.count=e.drawRange.count,this.userData=e.userData,this},dispose:function(){this.dispatchEvent({type:"dispose"})}});var zr=new $t,kr=new Gn,Fr=new In,Ur=new zt,Br=new zt,jr=new zt,Hr=new zt,Gr=new zt,Vr=new zt,Wr=new zt,qr=new zt,Xr=new zt,Yr=new Ot,Zr=new Ot,Jr=new Ot,Qr=new zt,Kr=new zt;function $r(e,t){yn.call(this),this.type="Mesh",this.geometry=void 0!==e?e:new Ir,this.material=void 0!==t?t:new mr({color:16777215*Math.random()}),this.drawMode=ht,this.updateMorphTargets()}function ei(e,t,n,r,i,o,a,s){if(null===(t.side===p?r.intersectTriangle(a,o,i,!0,s):r.intersectTriangle(i,o,a,t.side!==d,s)))return null;Kr.copy(s),Kr.applyMatrix4(e.matrixWorld);var c=n.ray.origin.distanceTo(Kr);return c<n.near||c>n.far?null:{distance:c,point:Kr.clone(),object:e}}function ti(e,t,n,r,i,o,a,s,c,l,h){Ur.fromBufferAttribute(i,c),Br.fromBufferAttribute(i,l),jr.fromBufferAttribute(i,h);var u=e.morphTargetInfluences;if(t.morphTargets&&o&&u){Wr.set(0,0,0),qr.set(0,0,0),Xr.set(0,0,0);for(var p=0,d=o.length;p<d;p++){var f=u[p],m=o[p];0!==f&&(Hr.fromBufferAttribute(m,c),Gr.fromBufferAttribute(m,l),Vr.fromBufferAttribute(m,h),Wr.addScaledVector(Hr.sub(Ur),f),qr.addScaledVector(Gr.sub(Br),f),Xr.addScaledVector(Vr.sub(jr),f))}Ur.add(Wr),Br.add(qr),jr.add(Xr)}var g=ei(e,t,n,r,Ur,Br,jr,Qr);if(g){a&&(Yr.fromBufferAttribute(a,c),Zr.fromBufferAttribute(a,l),Jr.fromBufferAttribute(a,h),g.uv=ir.getUV(Qr,Ur,Br,jr,Yr,Zr,Jr,new Ot)),s&&(Yr.fromBufferAttribute(s,c),Zr.fromBufferAttribute(s,l),Jr.fromBufferAttribute(s,h),g.uv2=ir.getUV(Qr,Ur,Br,jr,Yr,Zr,Jr,new Ot));var v=new pr(c,l,h);ir.getNormal(Ur,Br,jr,v.normal),g.face=v}return g}$r.prototype=Object.assign(Object.create(yn.prototype),{constructor:$r,isMesh:!0,setDrawMode:function(e){this.drawMode=e},copy:function(e){return yn.prototype.copy.call(this,e),this.drawMode=e.drawMode,void 0!==e.morphTargetInfluences&&(this.morphTargetInfluences=e.morphTargetInfluences.slice()),void 0!==e.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},e.morphTargetDictionary)),this},updateMorphTargets:function(){var e,t,n,r=this.geometry;if(r.isBufferGeometry){var i=r.morphAttributes,o=Object.keys(i);if(o.length>0){var a=i[o[0]];if(void 0!==a)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},e=0,t=a.length;e<t;e++)n=a[e].name||String(e),this.morphTargetInfluences.push(0),this.morphTargetDictionary[n]=e}}else{var s=r.morphTargets;void 0!==s&&s.length>0&&console.error("THREE.Mesh.updateMorphTargets() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.")}},raycast:function(e,t){var n,r=this.geometry,i=this.material,o=this.matrixWorld;if(void 0!==i&&(null===r.boundingSphere&&r.computeBoundingSphere(),Fr.copy(r.boundingSphere),Fr.applyMatrix4(o),!1!==e.ray.intersectsSphere(Fr)&&(zr.getInverse(o),kr.copy(e.ray).applyMatrix4(zr),null===r.boundingBox||!1!==kr.intersectsBox(r.boundingBox))))if(this.drawMode===ht){if(r.isBufferGeometry){var a,s,c,l,h,u,p,d,f,m=r.index,g=r.attributes.position,v=r.morphAttributes.position,y=r.attributes.uv,x=r.attributes.uv2,b=r.groups,w=r.drawRange;if(null!==m)if(Array.isArray(i))for(l=0,u=b.length;l<u;l++)for(f=i[(d=b[l]).materialIndex],h=Math.max(d.start,w.start),p=Math.min(d.start+d.count,w.start+w.count);h<p;h+=3)a=m.getX(h),s=m.getX(h+1),c=m.getX(h+2),(n=ti(this,f,e,kr,g,v,y,x,a,s,c))&&(n.faceIndex=Math.floor(h/3),n.face.materialIndex=d.materialIndex,t.push(n));else for(l=Math.max(0,w.start),u=Math.min(m.count,w.start+w.count);l<u;l+=3)a=m.getX(l),s=m.getX(l+1),c=m.getX(l+2),(n=ti(this,i,e,kr,g,v,y,x,a,s,c))&&(n.faceIndex=Math.floor(l/3),t.push(n));else if(void 0!==g)if(Array.isArray(i))for(l=0,u=b.length;l<u;l++)for(f=i[(d=b[l]).materialIndex],h=Math.max(d.start,w.start),p=Math.min(d.start+d.count,w.start+w.count);h<p;h+=3)(n=ti(this,f,e,kr,g,v,y,x,a=h,s=h+1,c=h+2))&&(n.faceIndex=Math.floor(h/3),n.face.materialIndex=d.materialIndex,t.push(n));else for(l=Math.max(0,w.start),u=Math.min(g.count,w.start+w.count);l<u;l+=3)(n=ti(this,i,e,kr,g,v,y,x,a=l,s=l+1,c=l+2))&&(n.faceIndex=Math.floor(l/3),t.push(n))}else if(r.isGeometry){var _,M,E,S,T=Array.isArray(i),A=r.vertices,L=r.faces,P=r.faceVertexUvs[0];P.length>0&&(S=P);for(var C=0,R=L.length;C<R;C++){var O=L[C],D=T?i[O.materialIndex]:i;if(void 0!==D&&(_=A[O.a],M=A[O.b],E=A[O.c],n=ei(this,D,e,kr,_,M,E,Qr))){if(S&&S[C]){var N=S[C];Yr.copy(N[0]),Zr.copy(N[1]),Jr.copy(N[2]),n.uv=ir.getUV(Qr,_,M,E,Yr,Zr,Jr,new Ot)}n.face=O,n.faceIndex=C,t.push(n)}}}}else console.warn("THREE.Mesh: TriangleStripDrawMode and TriangleFanDrawMode are not supported by .raycast().")},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}});var ni=0,ri=new $t,ii=new yn,oi=new zt;function ai(){Object.defineProperty(this,"id",{value:ni+=2}),this.uuid=Rt.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1}ai.prototype=Object.assign(Object.create(Lt.prototype),{constructor:ai,isGeometry:!0,applyMatrix:function(e){for(var t=(new Ut).getNormalMatrix(e),n=0,r=this.vertices.length;n<r;n++){this.vertices[n].applyMatrix4(e)}for(n=0,r=this.faces.length;n<r;n++){var i=this.faces[n];i.normal.applyMatrix3(t).normalize();for(var o=0,a=i.vertexNormals.length;o<a;o++)i.vertexNormals[o].applyMatrix3(t).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function(e){return ri.makeRotationX(e),this.applyMatrix(ri),this},rotateY:function(e){return ri.makeRotationY(e),this.applyMatrix(ri),this},rotateZ:function(e){return ri.makeRotationZ(e),this.applyMatrix(ri),this},translate:function(e,t,n){return ri.makeTranslation(e,t,n),this.applyMatrix(ri),this},scale:function(e,t,n){return ri.makeScale(e,t,n),this.applyMatrix(ri),this},lookAt:function(e){return ii.lookAt(e),ii.updateMatrix(),this.applyMatrix(ii.matrix),this},fromBufferGeometry:function(e){var t=this,n=null!==e.index?e.index.array:void 0,r=e.attributes;if(void 0===r.position)return console.error("THREE.Geometry.fromBufferGeometry(): Position attribute required for conversion."),this;var i=r.position.array,o=void 0!==r.normal?r.normal.array:void 0,a=void 0!==r.color?r.color.array:void 0,s=void 0!==r.uv?r.uv.array:void 0,c=void 0!==r.uv2?r.uv2.array:void 0;void 0!==c&&(this.faceVertexUvs[1]=[]);for(var l=0;l<i.length;l+=3)t.vertices.push((new zt).fromArray(i,l)),void 0!==a&&t.colors.push((new cr).fromArray(a,l));function h(e,n,r,i){var l=void 0===a?[]:[t.colors[e].clone(),t.colors[n].clone(),t.colors[r].clone()],h=new pr(e,n,r,void 0===o?[]:[(new zt).fromArray(o,3*e),(new zt).fromArray(o,3*n),(new zt).fromArray(o,3*r)],l,i);t.faces.push(h),void 0!==s&&t.faceVertexUvs[0].push([(new Ot).fromArray(s,2*e),(new Ot).fromArray(s,2*n),(new Ot).fromArray(s,2*r)]),void 0!==c&&t.faceVertexUvs[1].push([(new Ot).fromArray(c,2*e),(new Ot).fromArray(c,2*n),(new Ot).fromArray(c,2*r)])}var u=e.groups;if(u.length>0)for(l=0;l<u.length;l++)for(var p=u[l],d=p.start,f=d,m=d+p.count;f<m;f+=3)void 0!==n?h(n[f],n[f+1],n[f+2],p.materialIndex):h(f,f+1,f+2,p.materialIndex);else if(void 0!==n)for(l=0;l<n.length;l+=3)h(n[l],n[l+1],n[l+2]);else for(l=0;l<i.length/3;l+=3)h(l,l+1,l+2);return this.computeFaceNormals(),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),this},center:function(){return this.computeBoundingBox(),this.boundingBox.getCenter(oi).negate(),this.translate(oi.x,oi.y,oi.z),this},normalize:function(){this.computeBoundingSphere();var e=this.boundingSphere.center,t=this.boundingSphere.radius,n=0===t?1:1/t,r=new $t;return r.set(n,0,0,-n*e.x,0,n,0,-n*e.y,0,0,n,-n*e.z,0,0,0,1),this.applyMatrix(r),this},computeFaceNormals:function(){for(var e=new zt,t=new zt,n=0,r=this.faces.length;n<r;n++){var i=this.faces[n],o=this.vertices[i.a],a=this.vertices[i.b],s=this.vertices[i.c];e.subVectors(s,a),t.subVectors(o,a),e.cross(t),e.normalize(),i.normal.copy(e)}},computeVertexNormals:function(e){var t,n,r,i,o,a;for(void 0===e&&(e=!0),a=new Array(this.vertices.length),t=0,n=this.vertices.length;t<n;t++)a[t]=new zt;if(e){var s,c,l,h=new zt,u=new zt;for(r=0,i=this.faces.length;r<i;r++)o=this.faces[r],s=this.vertices[o.a],c=this.vertices[o.b],l=this.vertices[o.c],h.subVectors(l,c),u.subVectors(s,c),h.cross(u),a[o.a].add(h),a[o.b].add(h),a[o.c].add(h)}else for(this.computeFaceNormals(),r=0,i=this.faces.length;r<i;r++)a[(o=this.faces[r]).a].add(o.normal),a[o.b].add(o.normal),a[o.c].add(o.normal);for(t=0,n=this.vertices.length;t<n;t++)a[t].normalize();for(r=0,i=this.faces.length;r<i;r++){var p=(o=this.faces[r]).vertexNormals;3===p.length?(p[0].copy(a[o.a]),p[1].copy(a[o.b]),p[2].copy(a[o.c])):(p[0]=a[o.a].clone(),p[1]=a[o.b].clone(),p[2]=a[o.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeFlatVertexNormals:function(){var e,t,n;for(this.computeFaceNormals(),e=0,t=this.faces.length;e<t;e++){var r=(n=this.faces[e]).vertexNormals;3===r.length?(r[0].copy(n.normal),r[1].copy(n.normal),r[2].copy(n.normal)):(r[0]=n.normal.clone(),r[1]=n.normal.clone(),r[2]=n.normal.clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var e,t,n,r,i;for(n=0,r=this.faces.length;n<r;n++)for((i=this.faces[n]).__originalFaceNormal?i.__originalFaceNormal.copy(i.normal):i.__originalFaceNormal=i.normal.clone(),i.__originalVertexNormals||(i.__originalVertexNormals=[]),e=0,t=i.vertexNormals.length;e<t;e++)i.__originalVertexNormals[e]?i.__originalVertexNormals[e].copy(i.vertexNormals[e]):i.__originalVertexNormals[e]=i.vertexNormals[e].clone();var o=new ai;for(o.faces=this.faces,e=0,t=this.morphTargets.length;e<t;e++){if(!this.morphNormals[e]){this.morphNormals[e]={},this.morphNormals[e].faceNormals=[],this.morphNormals[e].vertexNormals=[];var a=this.morphNormals[e].faceNormals,s=this.morphNormals[e].vertexNormals;for(n=0,r=this.faces.length;n<r;n++)c=new zt,l={a:new zt,b:new zt,c:new zt},a.push(c),s.push(l)}var c,l,h=this.morphNormals[e];for(o.vertices=this.morphTargets[e].vertices,o.computeFaceNormals(),o.computeVertexNormals(),n=0,r=this.faces.length;n<r;n++)i=this.faces[n],c=h.faceNormals[n],l=h.vertexNormals[n],c.copy(i.normal),l.a.copy(i.vertexNormals[0]),l.b.copy(i.vertexNormals[1]),l.c.copy(i.vertexNormals[2])}for(n=0,r=this.faces.length;n<r;n++)(i=this.faces[n]).normal=i.__originalFaceNormal,i.vertexNormals=i.__originalVertexNormals},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new On),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new In),this.boundingSphere.setFromPoints(this.vertices)},merge:function(e,t,n){if(e&&e.isGeometry){var r,i=this.vertices.length,o=this.vertices,a=e.vertices,s=this.faces,c=e.faces,l=this.colors,h=e.colors;void 0===n&&(n=0),void 0!==t&&(r=(new Ut).getNormalMatrix(t));for(var u=0,p=a.length;u<p;u++){var d=a[u].clone();void 0!==t&&d.applyMatrix4(t),o.push(d)}for(u=0,p=h.length;u<p;u++)l.push(h[u].clone());for(u=0,p=c.length;u<p;u++){var f,m,g,v=c[u],y=v.vertexNormals,x=v.vertexColors;(f=new pr(v.a+i,v.b+i,v.c+i)).normal.copy(v.normal),void 0!==r&&f.normal.applyMatrix3(r).normalize();for(var b=0,w=y.length;b<w;b++)m=y[b].clone(),void 0!==r&&m.applyMatrix3(r).normalize(),f.vertexNormals.push(m);f.color.copy(v.color);for(b=0,w=x.length;b<w;b++)g=x[b],f.vertexColors.push(g.clone());f.materialIndex=v.materialIndex+n,s.push(f)}for(u=0,p=e.faceVertexUvs.length;u<p;u++){var _=e.faceVertexUvs[u];void 0===this.faceVertexUvs[u]&&(this.faceVertexUvs[u]=[]);for(b=0,w=_.length;b<w;b++){for(var M=_[b],E=[],S=0,T=M.length;S<T;S++)E.push(M[S].clone());this.faceVertexUvs[u].push(E)}}}else console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",e)},mergeMesh:function(e){e&&e.isMesh?(e.matrixAutoUpdate&&e.updateMatrix(),this.merge(e.geometry,e.matrix)):console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",e)},mergeVertices:function(){var e,t,n,r,i,o,a,s,c={},l=[],h=[],u=Math.pow(10,4);for(n=0,r=this.vertices.length;n<r;n++)e=this.vertices[n],void 0===c[t=Math.round(e.x*u)+"_"+Math.round(e.y*u)+"_"+Math.round(e.z*u)]?(c[t]=n,l.push(this.vertices[n]),h[n]=l.length-1):h[n]=h[c[t]];var p=[];for(n=0,r=this.faces.length;n<r;n++){(i=this.faces[n]).a=h[i.a],i.b=h[i.b],i.c=h[i.c],o=[i.a,i.b,i.c];for(var d=0;d<3;d++)if(o[d]===o[(d+1)%3]){p.push(n);break}}for(n=p.length-1;n>=0;n--){var f=p[n];for(this.faces.splice(f,1),a=0,s=this.faceVertexUvs.length;a<s;a++)this.faceVertexUvs[a].splice(f,1)}var m=this.vertices.length-l.length;return this.vertices=l,m},setFromPoints:function(e){this.vertices=[];for(var t=0,n=e.length;t<n;t++){var r=e[t];this.vertices.push(new zt(r.x,r.y,r.z||0))}return this},sortFacesByMaterialIndex:function(){for(var e=this.faces,t=e.length,n=0;n<t;n++)e[n]._id=n;e.sort((function(e,t){return e.materialIndex-t.materialIndex}));var r,i,o=this.faceVertexUvs[0],a=this.faceVertexUvs[1];o&&o.length===t&&(r=[]),a&&a.length===t&&(i=[]);for(n=0;n<t;n++){var s=e[n]._id;r&&r.push(o[s]),i&&i.push(a[s])}r&&(this.faceVertexUvs[0]=r),i&&(this.faceVertexUvs[1]=i)},toJSON:function(){var e={metadata:{version:4.5,type:"Geometry",generator:"Geometry.toJSON"}};if(e.uuid=this.uuid,e.type=this.type,""!==this.name&&(e.name=this.name),void 0!==this.parameters){var t=this.parameters;for(var n in t)void 0!==t[n]&&(e[n]=t[n]);return e}for(var r=[],i=0;i<this.vertices.length;i++){var o=this.vertices[i];r.push(o.x,o.y,o.z)}var a=[],s=[],c={},l=[],h={},u=[],p={};for(i=0;i<this.faces.length;i++){var d=this.faces[i],f=void 0!==this.faceVertexUvs[0][i],m=d.normal.length()>0,g=d.vertexNormals.length>0,v=1!==d.color.r||1!==d.color.g||1!==d.color.b,y=d.vertexColors.length>0,x=0;if(x=M(x,0,0),x=M(x,1,!0),x=M(x,2,!1),x=M(x,3,f),x=M(x,4,m),x=M(x,5,g),x=M(x,6,v),x=M(x,7,y),a.push(x),a.push(d.a,d.b,d.c),a.push(d.materialIndex),f){var b=this.faceVertexUvs[0][i];a.push(T(b[0]),T(b[1]),T(b[2]))}if(m&&a.push(E(d.normal)),g){var w=d.vertexNormals;a.push(E(w[0]),E(w[1]),E(w[2]))}if(v&&a.push(S(d.color)),y){var _=d.vertexColors;a.push(S(_[0]),S(_[1]),S(_[2]))}}function M(e,t,n){return n?e|1<<t:e&~(1<<t)}function E(e){var t=e.x.toString()+e.y.toString()+e.z.toString();return void 0!==c[t]?c[t]:(c[t]=s.length/3,s.push(e.x,e.y,e.z),c[t])}function S(e){var t=e.r.toString()+e.g.toString()+e.b.toString();return void 0!==h[t]?h[t]:(h[t]=l.length,l.push(e.getHex()),h[t])}function T(e){var t=e.x.toString()+e.y.toString();return void 0!==p[t]?p[t]:(p[t]=u.length/2,u.push(e.x,e.y),p[t])}return e.data={},e.data.vertices=r,e.data.normals=s,l.length>0&&(e.data.colors=l),u.length>0&&(e.data.uvs=[u]),e.data.faces=a,e},clone:function(){return(new ai).copy(this)},copy:function(e){var t,n,r,i,o,a;this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.name=e.name;var s=e.vertices;for(t=0,n=s.length;t<n;t++)this.vertices.push(s[t].clone());var c=e.colors;for(t=0,n=c.length;t<n;t++)this.colors.push(c[t].clone());var l=e.faces;for(t=0,n=l.length;t<n;t++)this.faces.push(l[t].clone());for(t=0,n=e.faceVertexUvs.length;t<n;t++){var h=e.faceVertexUvs[t];for(void 0===this.faceVertexUvs[t]&&(this.faceVertexUvs[t]=[]),r=0,i=h.length;r<i;r++){var u=h[r],p=[];for(o=0,a=u.length;o<a;o++){var d=u[o];p.push(d.clone())}this.faceVertexUvs[t].push(p)}}var f=e.morphTargets;for(t=0,n=f.length;t<n;t++){var m={};if(m.name=f[t].name,void 0!==f[t].vertices)for(m.vertices=[],r=0,i=f[t].vertices.length;r<i;r++)m.vertices.push(f[t].vertices[r].clone());if(void 0!==f[t].normals)for(m.normals=[],r=0,i=f[t].normals.length;r<i;r++)m.normals.push(f[t].normals[r].clone());this.morphTargets.push(m)}var g=e.morphNormals;for(t=0,n=g.length;t<n;t++){var v={};if(void 0!==g[t].vertexNormals)for(v.vertexNormals=[],r=0,i=g[t].vertexNormals.length;r<i;r++){var y=g[t].vertexNormals[r],x={};x.a=y.a.clone(),x.b=y.b.clone(),x.c=y.c.clone(),v.vertexNormals.push(x)}if(void 0!==g[t].faceNormals)for(v.faceNormals=[],r=0,i=g[t].faceNormals.length;r<i;r++)v.faceNormals.push(g[t].faceNormals[r].clone());this.morphNormals.push(v)}var b=e.skinWeights;for(t=0,n=b.length;t<n;t++)this.skinWeights.push(b[t].clone());var w=e.skinIndices;for(t=0,n=w.length;t<n;t++)this.skinIndices.push(w[t].clone());var _=e.lineDistances;for(t=0,n=_.length;t<n;t++)this.lineDistances.push(_[t]);var M=e.boundingBox;null!==M&&(this.boundingBox=M.clone());var E=e.boundingSphere;return null!==E&&(this.boundingSphere=E.clone()),this.elementsNeedUpdate=e.elementsNeedUpdate,this.verticesNeedUpdate=e.verticesNeedUpdate,this.uvsNeedUpdate=e.uvsNeedUpdate,this.normalsNeedUpdate=e.normalsNeedUpdate,this.colorsNeedUpdate=e.colorsNeedUpdate,this.lineDistancesNeedUpdate=e.lineDistancesNeedUpdate,this.groupsNeedUpdate=e.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}});class si extends ai{constructor(e,t,n,r,i,o){super(),this.type="BoxGeometry",this.parameters={width:e,height:t,depth:n,widthSegments:r,heightSegments:i,depthSegments:o},this.fromBufferGeometry(new ci(e,t,n,r,i,o)),this.mergeVertices()}}class ci extends Ir{constructor(e,t,n,r,i,o){super(),this.type="BoxBufferGeometry",this.parameters={width:e,height:t,depth:n,widthSegments:r,heightSegments:i,depthSegments:o};var a=this;e=e||1,t=t||1,n=n||1,r=Math.floor(r)||1,i=Math.floor(i)||1,o=Math.floor(o)||1;var s=[],c=[],l=[],h=[],u=0,p=0;function d(e,t,n,r,i,o,d,f,m,g,v){var y,x,b=o/m,w=d/g,_=o/2,M=d/2,E=f/2,S=m+1,T=g+1,A=0,L=0,P=new zt;for(x=0;x<T;x++){var C=x*w-M;for(y=0;y<S;y++){var R=y*b-_;P[e]=R*r,P[t]=C*i,P[n]=E,c.push(P.x,P.y,P.z),P[e]=0,P[t]=0,P[n]=f>0?1:-1,l.push(P.x,P.y,P.z),h.push(y/m),h.push(1-x/g),A+=1}}for(x=0;x<g;x++)for(y=0;y<m;y++){var O=u+y+S*x,D=u+y+S*(x+1),N=u+(y+1)+S*(x+1),I=u+(y+1)+S*x;s.push(O,D,I),s.push(D,N,I),L+=6}a.addGroup(p,L,v),p+=L,u+=A}d("z","y","x",-1,-1,n,t,e,o,i,0),d("z","y","x",1,-1,n,t,-e,o,i,1),d("x","z","y",1,1,e,n,t,r,o,2),d("x","z","y",1,-1,e,n,-t,r,o,3),d("x","y","z",1,-1,e,t,n,r,i,4),d("x","y","z",-1,-1,e,t,-n,r,i,5),this.setIndex(s),this.setAttribute("position",new Er(c,3)),this.setAttribute("normal",new Er(l,3)),this.setAttribute("uv",new Er(h,2))}}function li(e){var t={};for(var n in e)for(var r in t[n]={},e[n]){var i=e[n][r];i&&(i.isColor||i.isMatrix3||i.isMatrix4||i.isVector2||i.isVector3||i.isVector4||i.isTexture)?t[n][r]=i.clone():Array.isArray(i)?t[n][r]=i.slice():t[n][r]=i}return t}function hi(e){for(var t={},n=0;n<e.length;n++){var r=li(e[n]);for(var i in r)t[i]=r[i]}return t}var ui={clone:li,merge:hi},pi="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",di="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";function fi(e){fr.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader=pi,this.fragmentShader=di,this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,void 0!==e&&(void 0!==e.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(e))}function mi(){yn.call(this),this.type="Camera",this.matrixWorldInverse=new $t,this.projectionMatrix=new $t,this.projectionMatrixInverse=new $t}function gi(e,t,n,r){mi.call(this),this.type="PerspectiveCamera",this.fov=void 0!==e?e:50,this.zoom=1,this.near=void 0!==n?n:.1,this.far=void 0!==r?r:2e3,this.focus=10,this.aspect=void 0!==t?t:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}fi.prototype=Object.create(fr.prototype),fi.prototype.constructor=fi,fi.prototype.isShaderMaterial=!0,fi.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.fragmentShader=e.fragmentShader,this.vertexShader=e.vertexShader,this.uniforms=li(e.uniforms),this.defines=Object.assign({},e.defines),this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.lights=e.lights,this.clipping=e.clipping,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this.extensions=e.extensions,this},fi.prototype.toJSON=function(e){var t=fr.prototype.toJSON.call(this,e);for(var n in t.uniforms={},this.uniforms){var r=this.uniforms[n].value;r&&r.isTexture?t.uniforms[n]={type:"t",value:r.toJSON(e).uuid}:r&&r.isColor?t.uniforms[n]={type:"c",value:r.getHex()}:r&&r.isVector2?t.uniforms[n]={type:"v2",value:r.toArray()}:r&&r.isVector3?t.uniforms[n]={type:"v3",value:r.toArray()}:r&&r.isVector4?t.uniforms[n]={type:"v4",value:r.toArray()}:r&&r.isMatrix3?t.uniforms[n]={type:"m3",value:r.toArray()}:r&&r.isMatrix4?t.uniforms[n]={type:"m4",value:r.toArray()}:t.uniforms[n]={value:r}}Object.keys(this.defines).length>0&&(t.defines=this.defines),t.vertexShader=this.vertexShader,t.fragmentShader=this.fragmentShader;var i={};for(var o in this.extensions)!0===this.extensions[o]&&(i[o]=!0);return Object.keys(i).length>0&&(t.extensions=i),t},mi.prototype=Object.assign(Object.create(yn.prototype),{constructor:mi,isCamera:!0,copy:function(e,t){return yn.prototype.copy.call(this,e,t),this.matrixWorldInverse.copy(e.matrixWorldInverse),this.projectionMatrix.copy(e.projectionMatrix),this.projectionMatrixInverse.copy(e.projectionMatrixInverse),this},getWorldDirection:function(e){void 0===e&&(console.warn("THREE.Camera: .getWorldDirection() target is now required"),e=new zt),this.updateMatrixWorld(!0);var t=this.matrixWorld.elements;return e.set(-t[8],-t[9],-t[10]).normalize()},updateMatrixWorld:function(e){yn.prototype.updateMatrixWorld.call(this,e),this.matrixWorldInverse.getInverse(this.matrixWorld)},clone:function(){return(new this.constructor).copy(this)}}),gi.prototype=Object.assign(Object.create(mi.prototype),{constructor:gi,isPerspectiveCamera:!0,copy:function(e,t){return mi.prototype.copy.call(this,e,t),this.fov=e.fov,this.zoom=e.zoom,this.near=e.near,this.far=e.far,this.focus=e.focus,this.aspect=e.aspect,this.view=null===e.view?null:Object.assign({},e.view),this.filmGauge=e.filmGauge,this.filmOffset=e.filmOffset,this},setFocalLength:function(e){var t=.5*this.getFilmHeight()/e;this.fov=2*Rt.RAD2DEG*Math.atan(t),this.updateProjectionMatrix()},getFocalLength:function(){var e=Math.tan(.5*Rt.DEG2RAD*this.fov);return.5*this.getFilmHeight()/e},getEffectiveFOV:function(){return 2*Rt.RAD2DEG*Math.atan(Math.tan(.5*Rt.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(e,t,n,r,i,o){this.aspect=e/t,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=n,this.view.offsetY=r,this.view.width=i,this.view.height=o,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){var e=this.near,t=e*Math.tan(.5*Rt.DEG2RAD*this.fov)/this.zoom,n=2*t,r=this.aspect*n,i=-.5*r,o=this.view;if(null!==this.view&&this.view.enabled){var a=o.fullWidth,s=o.fullHeight;i+=o.offsetX*r/a,t-=o.offsetY*n/s,r*=o.width/a,n*=o.height/s}var c=this.filmOffset;0!==c&&(i+=e*c/this.getFilmWidth()),this.projectionMatrix.makePerspective(i,i+r,t,t-n,e,this.far),this.projectionMatrixInverse.getInverse(this.projectionMatrix)},toJSON:function(e){var t=yn.prototype.toJSON.call(this,e);return t.object.fov=this.fov,t.object.zoom=this.zoom,t.object.near=this.near,t.object.far=this.far,t.object.focus=this.focus,t.object.aspect=this.aspect,null!==this.view&&(t.object.view=Object.assign({},this.view)),t.object.filmGauge=this.filmGauge,t.object.filmOffset=this.filmOffset,t}});var vi=90,yi=1;function xi(e,t,n,r){yn.call(this),this.type="CubeCamera";var i=new gi(vi,yi,e,t);i.up.set(0,-1,0),i.lookAt(new zt(1,0,0)),this.add(i);var o=new gi(vi,yi,e,t);o.up.set(0,-1,0),o.lookAt(new zt(-1,0,0)),this.add(o);var a=new gi(vi,yi,e,t);a.up.set(0,0,1),a.lookAt(new zt(0,1,0)),this.add(a);var s=new gi(vi,yi,e,t);s.up.set(0,0,-1),s.lookAt(new zt(0,-1,0)),this.add(s);var c=new gi(vi,yi,e,t);c.up.set(0,-1,0),c.lookAt(new zt(0,0,1)),this.add(c);var l=new gi(vi,yi,e,t);l.up.set(0,-1,0),l.lookAt(new zt(0,0,-1)),this.add(l),r=r||{format:Re,magFilter:me,minFilter:me},this.renderTarget=new bi(n,n,r),this.renderTarget.texture.name="CubeCamera",this.update=function(e,t){null===this.parent&&this.updateMatrixWorld();var n=e.getRenderTarget(),r=this.renderTarget,h=r.texture.generateMipmaps;r.texture.generateMipmaps=!1,e.setRenderTarget(r,0),e.render(t,i),e.setRenderTarget(r,1),e.render(t,o),e.setRenderTarget(r,2),e.render(t,a),e.setRenderTarget(r,3),e.render(t,s),e.setRenderTarget(r,4),e.render(t,c),r.texture.generateMipmaps=h,e.setRenderTarget(r,5),e.render(t,l),e.setRenderTarget(n)},this.clear=function(e,t,n,r){for(var i=e.getRenderTarget(),o=this.renderTarget,a=0;a<6;a++)e.setRenderTarget(o,a),e.clear(t,n,r);e.setRenderTarget(i)}}function bi(e,t,n){Vt.call(this,e,t,n)}function wi(e,t,n,r,i,o,a,s,c,l,h,u){Ht.call(this,null,o,a,s,c,l,r,i,h,u),this.image={data:e||null,width:t||1,height:n||1},this.magFilter=void 0!==c?c:pe,this.minFilter=void 0!==l?l:pe,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1,this.needsUpdate=!0}xi.prototype=Object.create(yn.prototype),xi.prototype.constructor=xi,bi.prototype=Object.create(Vt.prototype),bi.prototype.constructor=bi,bi.prototype.isWebGLRenderTargetCube=!0,bi.prototype.fromEquirectangularTexture=function(e,t){this.texture.type=t.type,this.texture.format=t.format,this.texture.encoding=t.encoding;var n=new xn,r={uniforms:{tEquirect:{value:null}},vertexShader:["varying vec3 vWorldDirection;","vec3 transformDirection( in vec3 dir, in mat4 matrix ) {","\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );","}","void main() {","\tvWorldDirection = transformDirection( position, modelMatrix );","\t#include <begin_vertex>","\t#include <project_vertex>","}"].join("\n"),fragmentShader:["uniform sampler2D tEquirect;","varying vec3 vWorldDirection;","#define RECIPROCAL_PI 0.31830988618","#define RECIPROCAL_PI2 0.15915494","void main() {","\tvec3 direction = normalize( vWorldDirection );","\tvec2 sampleUV;","\tsampleUV.y = asin( clamp( direction.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;","\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;","\tgl_FragColor = texture2D( tEquirect, sampleUV );","}"].join("\n")},i=new fi({type:"CubemapFromEquirect",uniforms:li(r.uniforms),vertexShader:r.vertexShader,fragmentShader:r.fragmentShader,side:p,blending:v});i.uniforms.tEquirect.value=t;var o=new $r(new ci(5,5,5),i);n.add(o);var a=new xi(1,10,1);return a.renderTarget=this,a.renderTarget.texture.name="CubeCameraTexture",a.update(e,n),o.geometry.dispose(),o.material.dispose(),this},wi.prototype=Object.create(Ht.prototype),wi.prototype.constructor=wi,wi.prototype.isDataTexture=!0;var _i=new In,Mi=new zt;function Ei(e,t,n,r,i,o){this.planes=[void 0!==e?e:new Xn,void 0!==t?t:new Xn,void 0!==n?n:new Xn,void 0!==r?r:new Xn,void 0!==i?i:new Xn,void 0!==o?o:new Xn]}Object.assign(Ei.prototype,{set:function(e,t,n,r,i,o){var a=this.planes;return a[0].copy(e),a[1].copy(t),a[2].copy(n),a[3].copy(r),a[4].copy(i),a[5].copy(o),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){for(var t=this.planes,n=0;n<6;n++)t[n].copy(e.planes[n]);return this},setFromMatrix:function(e){var t=this.planes,n=e.elements,r=n[0],i=n[1],o=n[2],a=n[3],s=n[4],c=n[5],l=n[6],h=n[7],u=n[8],p=n[9],d=n[10],f=n[11],m=n[12],g=n[13],v=n[14],y=n[15];return t[0].setComponents(a-r,h-s,f-u,y-m).normalize(),t[1].setComponents(a+r,h+s,f+u,y+m).normalize(),t[2].setComponents(a+i,h+c,f+p,y+g).normalize(),t[3].setComponents(a-i,h-c,f-p,y-g).normalize(),t[4].setComponents(a-o,h-l,f-d,y-v).normalize(),t[5].setComponents(a+o,h+l,f+d,y+v).normalize(),this},intersectsObject:function(e){var t=e.geometry;return null===t.boundingSphere&&t.computeBoundingSphere(),_i.copy(t.boundingSphere).applyMatrix4(e.matrixWorld),this.intersectsSphere(_i)},intersectsSprite:function(e){return _i.center.set(0,0,0),_i.radius=.7071067811865476,_i.applyMatrix4(e.matrixWorld),this.intersectsSphere(_i)},intersectsSphere:function(e){for(var t=this.planes,n=e.center,r=-e.radius,i=0;i<6;i++){if(t[i].distanceToPoint(n)<r)return!1}return!0},intersectsBox:function(e){for(var t=this.planes,n=0;n<6;n++){var r=t[n];if(Mi.x=r.normal.x>0?e.max.x:e.min.x,Mi.y=r.normal.y>0?e.max.y:e.min.y,Mi.z=r.normal.z>0?e.max.z:e.min.z,r.distanceToPoint(Mi)<0)return!1}return!0},containsPoint:function(e){for(var t=this.planes,n=0;n<6;n++)if(t[n].distanceToPoint(e)<0)return!1;return!0}});var Si={alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment:"#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",begin_vertex:"vec3 transformed = vec3( position );",beginnormal_vertex:"vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs:"vec2 integrateSpecularBRDF( const in float dotNV, const in float roughness ) {\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\treturn vec2( -1.04, 1.04 ) * a004 + r.zw;\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n#else\n\tif( cutoffDistance > 0.0 && decayExponent > 0.0 ) {\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n\t}\n\treturn 1.0;\n#endif\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nvec3 F_Schlick_RoughnessDependent( const in vec3 F0, const in float dotNV, const in float roughness ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotNV - 6.98316 ) * dotNV );\n\tvec3 Fr = max( vec3( 1.0 - roughness ), F0 ) - F0;\n\treturn Fr * fresnel + F0;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + viewDir );\n\tfloat dotNL = saturate( dot( normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE  = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS  = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\nvec3 BRDF_Specular_GGX_Environment( const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\treturn specularColor * brdf.x + brdf.y;\n}\nvoid BRDF_Specular_Multiscattering_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tvec3 F = F_Schlick_RoughnessDependent( specularColor, dotNV, roughness );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\tvec3 FssEss = F * brdf.x + brdf.y;\n\tfloat Ess = brdf.x + brdf.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = specularColor + ( 1.0 - specularColor ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie(float roughness, float NoH) {\n\tfloat invAlpha  = 1.0 / roughness;\n\tfloat cos2h = NoH * NoH;\n\tfloat sin2h = max(1.0 - cos2h, 0.0078125);\treturn (2.0 + invAlpha) * pow(sin2h, invAlpha * 0.5) / (2.0 * PI);\n}\nfloat V_Neubelt(float NoV, float NoL) {\n\treturn saturate(1.0 / (4.0 * (NoL + NoV - NoL * NoV)));\n}\nvec3 BRDF_Specular_Sheen( const in float roughness, const in vec3 L, const in GeometricContext geometry, vec3 specularColor ) {\n\tvec3 N = geometry.normal;\n\tvec3 V = geometry.viewDir;\n\tvec3 H = normalize( V + L );\n\tfloat dotNH = saturate( dot( N, H ) );\n\treturn specularColor * D_Charlie( roughness, dotNH ) * V_Neubelt( dot(N, V), dot(N, L) );\n}\n#endif",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tfDet *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\tplane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\t#pragma unroll_loop\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vViewPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\tif ( clipped ) discard;\n\t#endif\n#endif",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( STANDARD ) && ! defined( PHONG ) && ! defined( MATCAP )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( STANDARD ) && ! defined( PHONG ) && ! defined( MATCAP )\n\tvarying vec3 vViewPosition;\n#endif",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( STANDARD ) && ! defined( PHONG ) && ! defined( MATCAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif",color_fragment:"#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_pars_vertex:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif",common:"#define PI 3.14159265359\n#define PI2 6.28318530718\n#define PI_HALF 1.5707963267949\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat max3( vec3 v ) { return max( max( v.x, v.y ), v.z ); }\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n#ifdef CLEARCOAT\n\tvec3 clearcoatNormal;\n#endif\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nfloat linearToRelativeLuminance( const in vec3 color ) {\n\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\n\treturn dot( weights, color.rgb );\n}\nbool isPerspectiveMatrix( mat4 m ) {\n  return m[ 2 ][ 3 ] == - 1.0;\n}",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV( sampler2D envMap, vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif",defaultnormal_vertex:"vec3 transformedNormal = objectNormal;\n#ifdef USE_INSTANCING\n\ttransformedNormal = mat3( instanceMatrix ) * transformedNormal;\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = normalMatrix * objectTangent;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",encodings_fragment:"gl_FragColor = linearToOutputTexel( gl_FragColor );",encodings_pars_fragment:"\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( gammaFactor ) ), value.a );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( 1.0 / gammaFactor ) ), value.a );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * value.a * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat M = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat D = max( maxRange / maxRGB, 1.0 );\n\tD = min( floor( D ) / 255.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n\tvec3 Xp_Y_XYZp = cLogLuvM * value.rgb;\n\tXp_Y_XYZp = max( Xp_Y_XYZp, vec3( 1e-6, 1e-6, 1e-6 ) );\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract( Le );\n\tvResult.z = ( Le - ( floor( vResult.w * 255.0 ) ) / 255.0 ) / 255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2( ( Le - 127.0 ) / 2.0 );\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = cLogLuvInverseM * Xp_Y_XYZp.rgb;\n\treturn vec4( max( vRGB, 0.0 ), 1.0 );\n}",envmap_fragment:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\t\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t}  else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\treflectVec = normalize( reflectVec );\n\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\treflectVec = normalize( reflectVec );\n\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0, 0.0, 1.0 ) );\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform int maxMipLevel;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) ||defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_physical_pars_fragment:"#if defined( USE_ENVMAP )\n\t#ifdef ENVMAP_MODE_REFRACTION\n\t\tuniform float refractionRatio;\n\t#endif\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float roughness, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat sigma = PI * roughness * roughness / ( 1.0 + roughness );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar + log2( sigma );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t  vec3 reflectVec = reflect( -viewDir, normal );\n\t\t  reflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t#else\n\t\t  vec3 reflectVec = refract( -viewDir, normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( roughness, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, queryReflectVec, roughness );\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0,0.0,1.0 ) );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) { \n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex:"#ifdef USE_FOG\n\tfogDepth = -mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n\tvarying float fogDepth;\n#endif",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * fogDepth * fogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment:"#ifdef TOON\n\tuniform sampler2D gradientMap;\n\tvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\t\tfloat dotNL = dot( normal, lightDirection );\n\t\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t\t#ifdef USE_GRADIENTMAP\n\t\t\treturn texture2D( gradientMap, coord ).rgb;\n\t\t#else\n\t\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t\t#endif\n\t}\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_vertex:"vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\nvIndirectFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n\tvIndirectBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvIndirectFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvIndirectBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif",lights_pars_begin:"uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\nuniform vec3 lightProbe[ 9 ];\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in GeometricContext geometry ) {\n\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t\tfloat shadowCameraNear;\n\t\tfloat shadowCameraFar;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment:"varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifdef TOON\n\t\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#else\n\t\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\t\tvec3 irradiance = dotNL * directLight.color;\n\t#endif\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef REFLECTIVITY\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#endif\n#ifdef CLEARCOAT\n\tmaterial.clearcoat = saturate( clearcoat );\tmaterial.clearcoatRoughness = clamp( clearcoatRoughness, 0.04, 1.0 );\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheen;\n#endif",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n#ifdef CLEARCOAT\n\tfloat clearcoat;\n\tfloat clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tvec3 sheenColor;\n#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearcoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNL = saturate( dot( geometry.clearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = ccDotNL * directLight.color;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tccIrradiance *= PI;\n\t\t#endif\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t\treflectedLight.directSpecular += ccIrradiance * material.clearcoat * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_Sheen(\n\t\t\tmaterial.specularRoughness,\n\t\t\tdirectLight.direction,\n\t\t\tgeometry,\n\t\t\tmaterial.sheenColor\n\t\t);\n\t#else\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.normal, material.specularColor, material.specularRoughness);\n\t#endif\n\treflectedLight.directDiffuse += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNV = saturate( dot( geometry.clearcoatNormal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular += clearcoatRadiance * material.clearcoat * BRDF_Specular_GGX_Environment( geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t\tfloat ccDotNL = ccDotNV;\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\tfloat clearcoatInv = 1.0 - clearcoatDHR;\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\tBRDF_Specular_Multiscattering_Environment( geometry, material.specularColor, material.specularRoughness, singleScattering, multiScattering );\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - ( singleScattering + multiScattering ) );\n\treflectedLight.indirectSpecular += clearcoatInv * radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin:"\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\n#ifdef CLEARCOAT\n\tgeometry.clearcoatNormal = clearcoatNormal;\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tdirectLight.color *= all( bvec3( pointLight.shadow, directLight.visible, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tdirectLight.color *= all( bvec3( spotLight.shadow, directLight.visible, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectLight.color *= all( bvec3( directionalLight.shadow, directLight.visible, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\tirradiance += getLightProbeIrradiance( lightProbe, geometry );\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps:"#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getLightProbeIndirectIrradiance( geometry, maxMipLevel );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tradiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.normal, material.specularRoughness, maxMipLevel );\n\t#ifdef CLEARCOAT\n\t\tclearcoatRadiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.clearcoatNormal, material.clearcoatRoughness, maxMipLevel );\n\t#endif\n#endif",lights_fragment_end:"#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometry, material, reflectedLight );\n#endif",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tgl_FragDepthEXT = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t\tvarying float vIsPerspective;\n\t#else\n\t\tuniform float logDepthBufFC;\n\t#endif\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n\t#else\n\t\tif ( isPerspectiveMatrix( projectionMatrix ) ) {\n\t\t\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\n\t\t\tgl_Position.z *= gl_Position.w;\n\t\t}\n\t#endif\n#endif",map_fragment:"#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n#endif\n#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, uv );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tuniform mat3 uvTransform;\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif",normal_fragment_begin:"#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\t#ifdef USE_TANGENT\n\t\tvec3 tangent = normalize( vTangent );\n\t\tvec3 bitangent = normalize( vBitangent );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\ttangent = tangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t\tbitangent = bitangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#endif\n\t#endif\n#endif\nvec3 geometryNormal = normal;",normal_fragment_maps:"#ifdef OBJECTSPACE_NORMALMAP\n\tnormal = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( TANGENTSPACE_NORMALMAP )\n\t#ifdef USE_TANGENT\n\t\tmat3 vTBN = mat3( tangent, bitangent, normal );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tnormal = normalize( vTBN * mapN );\n\t#else\n\t\tnormal = perturbNormal2Arb( -vViewPosition, normal, normalScale, normalMap );\n\t#endif\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef OBJECTSPACE_NORMALMAP\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( TANGENTSPACE_NORMALMAP ) || defined ( USE_CLEARCOAT_NORMALMAP ) )\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec2 normalScale, in sampler2D normalMap ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tfloat scale = sign( st1.t * st0.s - st0.t * st1.s );\n\t\tvec3 S = normalize( ( q0 * st1.t - q1 * st0.t ) * scale );\n\t\tvec3 T = normalize( ( - q0 * st1.s + q1 * st0.s ) * scale );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy *= normalScale;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tbool frontFacing = dot( cross( S, T ), N ) > 0.0;\n\t\t\tmapN.xy *= ( float( frontFacing ) * 2.0 - 1.0 );\n\t\t#else\n\t\t\tmapN.xy *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#endif\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif",clearcoat_normal_fragment_begin:"#ifdef CLEARCOAT\n\tvec3 clearcoatNormal = geometryNormal;\n#endif",clearcoat_normal_fragment_maps:"#ifdef USE_CLEARCOAT_NORMALMAP\n\t#ifdef USE_TANGENT\n\t\tmat3 vTBN = mat3( tangent, bitangent, clearcoatNormal );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = clearcoatNormalScale * mapN.xy;\n\t\tclearcoatNormal = normalize( vTBN * mapN );\n\t#else\n\t\tclearcoatNormal = perturbNormal2Arb( - vViewPosition, clearcoatNormal, clearcoatNormalScale, clearcoatNormalMap );\n\t#endif\n#endif",clearcoat_normalmap_pars_fragment:"#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nvec4 encodeHalfRGBA ( vec2 v ) {\n\tvec4 encoded = vec4( 0.0 );\n\tconst vec2 offset = vec2( 1.0 / 255.0, 0.0 );\n\tencoded.xy = vec2( v.x, fract( v.x * 255.0 ) );\n\tencoded.xy = encoded.xy - ( encoded.yy * offset );\n\tencoded.zw = vec2( v.y, fract( v.y * 255.0 ) );\n\tencoded.zw = encoded.zw - ( encoded.ww * offset );\n\treturn encoded;\n}\nvec2 decodeHalfRGBA( vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex:"vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment:"#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment:"#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn decodeHalfRGBA( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = ( floor( uv * size - 0.5 ) + 0.5 ) * texelSize;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif",shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLight directionalLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= all( bvec2( directionalLight.shadow, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLight spotLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= all( bvec2( spotLight.shadow, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLight pointLight;\n\t#pragma unroll_loop\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= all( bvec2( pointLight.shadow, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform highp sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment:"#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( ( color * ( 2.51 * color + 0.03 ) ) / ( color * ( 2.43 * color + 0.59 ) + 0.14 ) );\n}",uv_pars_fragment:"#if ( defined( USE_UV ) && ! defined( UVS_VERTEX_ONLY ) )\n\tvarying vec2 vUv;\n#endif",uv_pars_vertex:"#ifdef USE_UV\n\t#ifdef UVS_VERTEX_ONLY\n\t\tvec2 vUv;\n\t#else\n\t\tvarying vec2 vUv;\n\t#endif\n\tuniform mat3 uvTransform;\n#endif",uv_vertex:"#ifdef USE_UV\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n#endif",uv2_pars_fragment:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",uv2_pars_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif",uv2_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif",background_frag:"uniform sampler2D t2D;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",background_vert:"varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",cube_frag:"uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main() {\n\tvec4 texColor = textureCube( tCube, vec3( tFlip * vWorldDirection.x, vWorldDirection.yz ) );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",cube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}",depth_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV;\n\tsampleUV.y = asin( clamp( direction.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tvec4 texColor = texture2D( tEquirect, sampleUV );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",equirect_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\treflectedLight.indirectDiffuse += texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",meshbasic_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",meshlambert_frag:"uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.indirectDiffuse += ( gl_FrontFacing ) ? vIndirectFront : vIndirectBack;\n\t#else\n\t\treflectedLight.indirectDiffuse += vIndirectFront;\n\t#endif\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshlambert_vert:"#define LAMBERT\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshmatcap_frag:"#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t\tmatcapColor = matcapTexelToLinear( matcapColor );\n\t#else\n\t\tvec4 matcapColor = vec4( 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",meshmatcap_vert:"#define MATCAP\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#ifndef FLAT_SHADED\n\t\tvNormal = normalize( transformedNormal );\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphysical_frag:"#define STANDARD\n#ifdef PHYSICAL\n\t#define REFLECTIVITY\n\t#define CLEARCOAT\n\t#define TRANSPARENCY\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef TRANSPARENCY\n\tuniform float transparency;\n#endif\n#ifdef REFLECTIVITY\n\tuniform float reflectivity;\n#endif\n#ifdef CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheen;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#ifdef TRANSPARENCY\n\t\tdiffuseColor.a *= saturate( 1. - transparency + linearToRelativeLuminance( reflectedLight.directSpecular + reflectedLight.indirectSpecular ) );\n\t#endif\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphysical_vert:"#define STANDARD\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",normal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}",normal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <fog_fragment>\n}",shadow_vert:"#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",sprite_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",sprite_vert:"uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\n\tvec2 scale;\n\tscale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );\n\tscale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}"},Ti={common:{diffuse:{value:new cr(15658734)},opacity:{value:1},map:{value:null},uvTransform:{value:new Ut},alphaMap:{value:null}},specularmap:{specularMap:{value:null}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98},maxMipLevel:{value:0}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new Ot(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new cr(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}}},points:{diffuse:{value:new cr(15658734)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},uvTransform:{value:new Ut}},sprite:{diffuse:{value:new cr(15658734)},opacity:{value:1},center:{value:new Ot(.5,.5)},rotation:{value:0},map:{value:null},alphaMap:{value:null},uvTransform:{value:new Ut}}},Ai={basic:{uniforms:hi([Ti.common,Ti.specularmap,Ti.envmap,Ti.aomap,Ti.lightmap,Ti.fog]),vertexShader:Si.meshbasic_vert,fragmentShader:Si.meshbasic_frag},lambert:{uniforms:hi([Ti.common,Ti.specularmap,Ti.envmap,Ti.aomap,Ti.lightmap,Ti.emissivemap,Ti.fog,Ti.lights,{emissive:{value:new cr(0)}}]),vertexShader:Si.meshlambert_vert,fragmentShader:Si.meshlambert_frag},phong:{uniforms:hi([Ti.common,Ti.specularmap,Ti.envmap,Ti.aomap,Ti.lightmap,Ti.emissivemap,Ti.bumpmap,Ti.normalmap,Ti.displacementmap,Ti.gradientmap,Ti.fog,Ti.lights,{emissive:{value:new cr(0)},specular:{value:new cr(1118481)},shininess:{value:30}}]),vertexShader:Si.meshphong_vert,fragmentShader:Si.meshphong_frag},standard:{uniforms:hi([Ti.common,Ti.envmap,Ti.aomap,Ti.lightmap,Ti.emissivemap,Ti.bumpmap,Ti.normalmap,Ti.displacementmap,Ti.roughnessmap,Ti.metalnessmap,Ti.fog,Ti.lights,{emissive:{value:new cr(0)},roughness:{value:.5},metalness:{value:.5},envMapIntensity:{value:1}}]),vertexShader:Si.meshphysical_vert,fragmentShader:Si.meshphysical_frag},matcap:{uniforms:hi([Ti.common,Ti.bumpmap,Ti.normalmap,Ti.displacementmap,Ti.fog,{matcap:{value:null}}]),vertexShader:Si.meshmatcap_vert,fragmentShader:Si.meshmatcap_frag},points:{uniforms:hi([Ti.points,Ti.fog]),vertexShader:Si.points_vert,fragmentShader:Si.points_frag},dashed:{uniforms:hi([Ti.common,Ti.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:Si.linedashed_vert,fragmentShader:Si.linedashed_frag},depth:{uniforms:hi([Ti.common,Ti.displacementmap]),vertexShader:Si.depth_vert,fragmentShader:Si.depth_frag},normal:{uniforms:hi([Ti.common,Ti.bumpmap,Ti.normalmap,Ti.displacementmap,{opacity:{value:1}}]),vertexShader:Si.normal_vert,fragmentShader:Si.normal_frag},sprite:{uniforms:hi([Ti.sprite,Ti.fog]),vertexShader:Si.sprite_vert,fragmentShader:Si.sprite_frag},background:{uniforms:{uvTransform:{value:new Ut},t2D:{value:null}},vertexShader:Si.background_vert,fragmentShader:Si.background_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:Si.cube_vert,fragmentShader:Si.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:Si.equirect_vert,fragmentShader:Si.equirect_frag},distanceRGBA:{uniforms:hi([Ti.common,Ti.displacementmap,{referencePosition:{value:new zt},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:Si.distanceRGBA_vert,fragmentShader:Si.distanceRGBA_frag},shadow:{uniforms:hi([Ti.lights,Ti.fog,{color:{value:new cr(0)},opacity:{value:1}}]),vertexShader:Si.shadow_vert,fragmentShader:Si.shadow_frag}};function Li(){var e=null,t=!1,n=null;function r(i,o){!1!==t&&(n(i,o),e.requestAnimationFrame(r))}return{start:function(){!0!==t&&null!==n&&(e.requestAnimationFrame(r),t=!0)},stop:function(){t=!1},setAnimationLoop:function(e){n=e},setContext:function(t){e=t}}}function Pi(e){var t=new WeakMap;return{get:function(e){return e.isInterleavedBufferAttribute&&(e=e.data),t.get(e)},remove:function(n){n.isInterleavedBufferAttribute&&(n=n.data);var r=t.get(n);r&&(e.deleteBuffer(r.buffer),t.delete(n))},update:function(n,r){n.isInterleavedBufferAttribute&&(n=n.data);var i=t.get(n);void 0===i?t.set(n,function(t,n){var r=t.array,i=t.usage,o=e.createBuffer();e.bindBuffer(n,o),e.bufferData(n,r,i),t.onUploadCallback();var a=5126;return r instanceof Float32Array?a=5126:r instanceof Float64Array?console.warn("THREE.WebGLAttributes: Unsupported data buffer format: Float64Array."):r instanceof Uint16Array?a=5123:r instanceof Int16Array?a=5122:r instanceof Uint32Array?a=5125:r instanceof Int32Array?a=5124:r instanceof Int8Array?a=5120:r instanceof Uint8Array&&(a=5121),{buffer:o,type:a,bytesPerElement:r.BYTES_PER_ELEMENT,version:t.version}}(n,r)):i.version<n.version&&(!function(t,n,r){var i=n.array,o=n.updateRange;e.bindBuffer(r,t),-1===o.count?e.bufferSubData(r,0,i):(e.bufferSubData(r,o.offset*i.BYTES_PER_ELEMENT,i.subarray(o.offset,o.offset+o.count)),o.count=-1)}(i.buffer,n,r),i.version=n.version)}}}function Ci(e,t,n,r){ai.call(this),this.type="PlaneGeometry",this.parameters={width:e,height:t,widthSegments:n,heightSegments:r},this.fromBufferGeometry(new Ri(e,t,n,r)),this.mergeVertices()}function Ri(e,t,n,r){Ir.call(this),this.type="PlaneBufferGeometry",this.parameters={width:e,height:t,widthSegments:n,heightSegments:r};var i,o,a=(e=e||1)/2,s=(t=t||1)/2,c=Math.floor(n)||1,l=Math.floor(r)||1,h=c+1,u=l+1,p=e/c,d=t/l,f=[],m=[],g=[],v=[];for(o=0;o<u;o++){var y=o*d-s;for(i=0;i<h;i++){var x=i*p-a;m.push(x,-y,0),g.push(0,0,1),v.push(i/c),v.push(1-o/l)}}for(o=0;o<l;o++)for(i=0;i<c;i++){var b=i+h*o,w=i+h*(o+1),_=i+1+h*(o+1),M=i+1+h*o;f.push(b,w,M),f.push(w,_,M)}this.setIndex(f),this.setAttribute("position",new Er(m,3)),this.setAttribute("normal",new Er(g,3)),this.setAttribute("uv",new Er(v,2))}function Oi(e,t,n,r){var i,o,a=new cr(0),s=0,c=null,l=0;function h(e,n){t.buffers.color.setClear(e.r,e.g,e.b,n,r)}return{getClearColor:function(){return a},setClearColor:function(e,t){a.set(e),h(a,s=void 0!==t?t:1)},getClearAlpha:function(){return s},setClearAlpha:function(e){h(a,s=e)},render:function(t,r,d,f){var m=r.background,g=e.vr,v=g.getSession&&g.getSession();if(v&&"additive"===v.environmentBlendMode&&(m=null),null===m?(h(a,s),c=null,l=0):m&&m.isColor&&(h(m,1),f=!0,c=null,l=0),(e.autoClear||f)&&e.clear(e.autoClearColor,e.autoClearDepth,e.autoClearStencil),m&&(m.isCubeTexture||m.isWebGLRenderTargetCube)){void 0===o&&((o=new $r(new ci(1,1,1),new fi({type:"BackgroundCubeMaterial",uniforms:li(Ai.cube.uniforms),vertexShader:Ai.cube.vertexShader,fragmentShader:Ai.cube.fragmentShader,side:p,depthTest:!1,depthWrite:!1,fog:!1}))).geometry.deleteAttribute("normal"),o.geometry.deleteAttribute("uv"),o.onBeforeRender=function(e,t,n){this.matrixWorld.copyPosition(n.matrixWorld)},Object.defineProperty(o.material,"map",{get:function(){return this.uniforms.tCube.value}}),n.update(o));var y=m.isWebGLRenderTargetCube?m.texture:m;o.material.uniforms.tCube.value=y,o.material.uniforms.tFlip.value=m.isWebGLRenderTargetCube?1:-1,c===m&&l===y.version||(o.material.needsUpdate=!0,c=m,l=y.version),t.unshift(o,o.geometry,o.material,0,0,null)}else m&&m.isTexture&&(void 0===i&&((i=new $r(new Ri(2,2),new fi({type:"BackgroundMaterial",uniforms:li(Ai.background.uniforms),vertexShader:Ai.background.vertexShader,fragmentShader:Ai.background.fragmentShader,side:u,depthTest:!1,depthWrite:!1,fog:!1}))).geometry.deleteAttribute("normal"),Object.defineProperty(i.material,"map",{get:function(){return this.uniforms.t2D.value}}),n.update(i)),i.material.uniforms.t2D.value=m,!0===m.matrixAutoUpdate&&m.updateMatrix(),i.material.uniforms.uvTransform.value.copy(m.matrix),c===m&&l===m.version||(i.material.needsUpdate=!0,c=m,l=m.version),t.unshift(i,i.geometry,i.material,0,0,null))}}}function Di(e,t,n,r){var i,o=r.isWebGL2;this.setMode=function(e){i=e},this.render=function(t,r){e.drawArrays(i,t,r),n.update(r,i)},this.renderInstances=function(r,a,s,c){if(0!==c){var l,h;if(o)l=e,h="drawArraysInstanced";else if(h="drawArraysInstancedANGLE",null===(l=t.get("ANGLE_instanced_arrays")))return void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");l[h](i,a,s,c),n.update(s,i,c)}}}function Ni(e,t,n){var r;function i(t){if("highp"===t){if(e.getShaderPrecisionFormat(35633,36338).precision>0&&e.getShaderPrecisionFormat(35632,36338).precision>0)return"highp";t="mediump"}return"mediump"===t&&e.getShaderPrecisionFormat(35633,36337).precision>0&&e.getShaderPrecisionFormat(35632,36337).precision>0?"mediump":"lowp"}var o="undefined"!=typeof WebGL2RenderingContext&&e instanceof WebGL2RenderingContext||"undefined"!=typeof WebGL2ComputeRenderingContext&&e instanceof WebGL2ComputeRenderingContext,a=void 0!==n.precision?n.precision:"highp",s=i(a);s!==a&&(console.warn("THREE.WebGLRenderer:",a,"not supported, using",s,"instead."),a=s);var c=!0===n.logarithmicDepthBuffer,l=e.getParameter(34930),h=e.getParameter(35660),u=e.getParameter(3379),p=e.getParameter(34076),d=e.getParameter(34921),f=e.getParameter(36347),m=e.getParameter(36348),g=e.getParameter(36349),v=h>0,y=o||!!t.get("OES_texture_float");return{isWebGL2:o,getMaxAnisotropy:function(){if(void 0!==r)return r;var n=t.get("EXT_texture_filter_anisotropic");return r=null!==n?e.getParameter(n.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0},getMaxPrecision:i,precision:a,logarithmicDepthBuffer:c,maxTextures:l,maxVertexTextures:h,maxTextureSize:u,maxCubemapSize:p,maxAttributes:d,maxVertexUniforms:f,maxVaryings:m,maxFragmentUniforms:g,vertexTextures:v,floatFragmentTextures:y,floatVertexTextures:v&&y,maxSamples:o?e.getParameter(36183):0}}function Ii(){var e=this,t=null,n=0,r=!1,i=!1,o=new Xn,a=new Ut,s={value:null,needsUpdate:!1};function c(){s.value!==t&&(s.value=t,s.needsUpdate=n>0),e.numPlanes=n,e.numIntersection=0}function l(t,n,r,i){var c=null!==t?t.length:0,l=null;if(0!==c){if(l=s.value,!0!==i||null===l){var h=r+4*c,u=n.matrixWorldInverse;a.getNormalMatrix(u),(null===l||l.length<h)&&(l=new Float32Array(h));for(var p=0,d=r;p!==c;++p,d+=4)o.copy(t[p]).applyMatrix4(u,a),o.normal.toArray(l,d),l[d+3]=o.constant}s.value=l,s.needsUpdate=!0}return e.numPlanes=c,l}this.uniform=s,this.numPlanes=0,this.numIntersection=0,this.init=function(e,i,o){var a=0!==e.length||i||0!==n||r;return r=i,t=l(e,o,0),n=e.length,a},this.beginShadows=function(){i=!0,l(null)},this.endShadows=function(){i=!1,c()},this.setState=function(e,o,a,h,u,p){if(!r||null===e||0===e.length||i&&!a)i?l(null):c();else{var d=i?0:n,f=4*d,m=u.clippingState||null;s.value=m,m=l(e,h,f,p);for(var g=0;g!==f;++g)m[g]=t[g];u.clippingState=m,this.numIntersection=o?this.numPlanes:0,this.numPlanes+=d}}}function zi(e){var t={};return{get:function(n){if(void 0!==t[n])return t[n];var r;switch(n){case"WEBGL_depth_texture":r=e.getExtension("WEBGL_depth_texture")||e.getExtension("MOZ_WEBGL_depth_texture")||e.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":r=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":r=e.getExtension("WEBGL_compressed_texture_s3tc")||e.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":r=e.getExtension("WEBGL_compressed_texture_pvrtc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:r=e.getExtension(n)}return null===r&&console.warn("THREE.WebGLRenderer: "+n+" extension not supported."),t[n]=r,r}}}function ki(e,t,n){var r=new WeakMap,i=new WeakMap;function o(e){var a=e.target,s=r.get(a);for(var c in null!==s.index&&t.remove(s.index),s.attributes)t.remove(s.attributes[c]);a.removeEventListener("dispose",o),r.delete(a);var l=i.get(s);l&&(t.remove(l),i.delete(s)),n.memory.geometries--}function a(e){var n=[],r=e.index,o=e.attributes.position,a=0;if(null!==r){var s=r.array;a=r.version;for(var c=0,l=s.length;c<l;c+=3){var h=s[c+0],u=s[c+1],p=s[c+2];n.push(h,u,u,p,p,h)}}else{s=o.array;a=o.version;for(c=0,l=s.length/3-1;c<l;c+=3){h=c+0,u=c+1,p=c+2;n.push(h,u,u,p,p,h)}}var d=new(Ar(n)>65535?Mr:wr)(n,1);d.version=a,t.update(d,34963);var f=i.get(e);f&&t.remove(f),i.set(e,d)}return{get:function(e,t){var i=r.get(t);return i||(t.addEventListener("dispose",o),t.isBufferGeometry?i=t:t.isGeometry&&(void 0===t._bufferGeometry&&(t._bufferGeometry=(new Ir).setFromObject(e)),i=t._bufferGeometry),r.set(t,i),n.memory.geometries++,i)},update:function(e){var n=e.index,r=e.attributes;for(var i in null!==n&&t.update(n,34963),r)t.update(r[i],34962);var o=e.morphAttributes;for(var i in o)for(var a=o[i],s=0,c=a.length;s<c;s++)t.update(a[s],34962)},getWireframeAttribute:function(e){var t=i.get(e);if(t){var n=e.index;null!==n&&t.version<n.version&&a(e)}else a(e);return i.get(e)}}}function Fi(e,t,n,r){var i,o,a,s=r.isWebGL2;this.setMode=function(e){i=e},this.setIndex=function(e){o=e.type,a=e.bytesPerElement},this.render=function(t,r){e.drawElements(i,r,o,t*a),n.update(r,i)},this.renderInstances=function(r,c,l,h){if(0!==h){var u,p;if(s)u=e,p="drawElementsInstanced";else if(p="drawElementsInstancedANGLE",null===(u=t.get("ANGLE_instanced_arrays")))return void console.error("THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");u[p](i,l,o,c*a,h),n.update(l,i,h)}}}function Ui(e){var t={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render:t,programs:null,autoReset:!0,reset:function(){t.frame++,t.calls=0,t.triangles=0,t.points=0,t.lines=0},update:function(e,n,r){switch(r=r||1,t.calls++,n){case 4:t.triangles+=r*(e/3);break;case 5:case 6:t.triangles+=r*(e-2);break;case 1:t.lines+=r*(e/2);break;case 3:t.lines+=r*(e-1);break;case 2:t.lines+=r*e;break;case 0:t.points+=r*e;break;default:console.error("THREE.WebGLInfo: Unknown draw mode:",n)}}}}function Bi(e,t){return Math.abs(t[1])-Math.abs(e[1])}function ji(e){var t={},n=new Float32Array(8);return{update:function(r,i,o,a){var s=r.morphTargetInfluences,c=s.length,l=t[i.id];if(void 0===l){l=[];for(var h=0;h<c;h++)l[h]=[h,0];t[i.id]=l}var u=o.morphTargets&&i.morphAttributes.position,p=o.morphNormals&&i.morphAttributes.normal;for(h=0;h<c;h++){0!==(d=l[h])[1]&&(u&&i.deleteAttribute("morphTarget"+h),p&&i.deleteAttribute("morphNormal"+h))}for(h=0;h<c;h++){(d=l[h])[0]=h,d[1]=s[h]}for(l.sort(Bi),h=0;h<8;h++){var d;if(d=l[h]){var f=d[0],m=d[1];if(m){u&&i.setAttribute("morphTarget"+h,u[f]),p&&i.setAttribute("morphNormal"+h,p[f]),n[h]=m;continue}}n[h]=0}a.getUniforms().setValue(e,"morphTargetInfluences",n)}}}function Hi(e,t,n,r){var i={};return{update:function(e){var o=r.render.frame,a=e.geometry,s=t.get(e,a);return i[s.id]!==o&&(a.isGeometry&&s.updateFromObject(e),t.update(s),i[s.id]=o),e.isInstancedMesh&&n.update(e.instanceMatrix,34962),s},dispose:function(){i={}}}}function Gi(e,t,n,r,i,o,a,s,c,l){e=void 0!==e?e:[],t=void 0!==t?t:ne,a=void 0!==a?a:Re,Ht.call(this,e,t,n,r,i,o,a,s,c,l),this.flipY=!1}function Vi(e,t,n,r){Ht.call(this,null),this.image={data:e||null,width:t||1,height:n||1,depth:r||1},this.magFilter=pe,this.minFilter=pe,this.wrapR=he,this.generateMipmaps=!1,this.flipY=!1,this.needsUpdate=!0}function Wi(e,t,n,r){Ht.call(this,null),this.image={data:e||null,width:t||1,height:n||1,depth:r||1},this.magFilter=pe,this.minFilter=pe,this.wrapR=he,this.generateMipmaps=!1,this.flipY=!1,this.needsUpdate=!0}Ai.physical={uniforms:hi([Ai.standard.uniforms,{transparency:{value:0},clearcoat:{value:0},clearcoatRoughness:{value:0},sheen:{value:new cr(0)},clearcoatNormalScale:{value:new Ot(1,1)},clearcoatNormalMap:{value:null}}]),vertexShader:Si.meshphysical_vert,fragmentShader:Si.meshphysical_frag},Ci.prototype=Object.create(ai.prototype),Ci.prototype.constructor=Ci,Ri.prototype=Object.create(Ir.prototype),Ri.prototype.constructor=Ri,Gi.prototype=Object.create(Ht.prototype),Gi.prototype.constructor=Gi,Gi.prototype.isCubeTexture=!0,Object.defineProperty(Gi.prototype,"images",{get:function(){return this.image},set:function(e){this.image=e}}),Vi.prototype=Object.create(Ht.prototype),Vi.prototype.constructor=Vi,Vi.prototype.isDataTexture2DArray=!0,Wi.prototype=Object.create(Ht.prototype),Wi.prototype.constructor=Wi,Wi.prototype.isDataTexture3D=!0;var qi=new Ht,Xi=new Vi,Yi=new Wi,Zi=new Gi,Ji=[],Qi=[],Ki=new Float32Array(16),$i=new Float32Array(9),eo=new Float32Array(4);function to(e,t,n){var r=e[0];if(r<=0||r>0)return e;var i=t*n,o=Ji[i];if(void 0===o&&(o=new Float32Array(i),Ji[i]=o),0!==t){r.toArray(o,0);for(var a=1,s=0;a!==t;++a)s+=n,e[a].toArray(o,s)}return o}function no(e,t){if(e.length!==t.length)return!1;for(var n=0,r=e.length;n<r;n++)if(e[n]!==t[n])return!1;return!0}function ro(e,t){for(var n=0,r=t.length;n<r;n++)e[n]=t[n]}function io(e,t){var n=Qi[t];void 0===n&&(n=new Int32Array(t),Qi[t]=n);for(var r=0;r!==t;++r)n[r]=e.allocateTextureUnit();return n}function oo(e,t){var n=this.cache;n[0]!==t&&(e.uniform1f(this.addr,t),n[0]=t)}function ao(e,t){var n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y||(e.uniform2f(this.addr,t.x,t.y),n[0]=t.x,n[1]=t.y);else{if(no(n,t))return;e.uniform2fv(this.addr,t),ro(n,t)}}function so(e,t){var n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z||(e.uniform3f(this.addr,t.x,t.y,t.z),n[0]=t.x,n[1]=t.y,n[2]=t.z);else if(void 0!==t.r)n[0]===t.r&&n[1]===t.g&&n[2]===t.b||(e.uniform3f(this.addr,t.r,t.g,t.b),n[0]=t.r,n[1]=t.g,n[2]=t.b);else{if(no(n,t))return;e.uniform3fv(this.addr,t),ro(n,t)}}function co(e,t){var n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z&&n[3]===t.w||(e.uniform4f(this.addr,t.x,t.y,t.z,t.w),n[0]=t.x,n[1]=t.y,n[2]=t.z,n[3]=t.w);else{if(no(n,t))return;e.uniform4fv(this.addr,t),ro(n,t)}}function lo(e,t){var n=this.cache,r=t.elements;if(void 0===r){if(no(n,t))return;e.uniformMatrix2fv(this.addr,!1,t),ro(n,t)}else{if(no(n,r))return;eo.set(r),e.uniformMatrix2fv(this.addr,!1,eo),ro(n,r)}}function ho(e,t){var n=this.cache,r=t.elements;if(void 0===r){if(no(n,t))return;e.uniformMatrix3fv(this.addr,!1,t),ro(n,t)}else{if(no(n,r))return;$i.set(r),e.uniformMatrix3fv(this.addr,!1,$i),ro(n,r)}}function uo(e,t){var n=this.cache,r=t.elements;if(void 0===r){if(no(n,t))return;e.uniformMatrix4fv(this.addr,!1,t),ro(n,t)}else{if(no(n,r))return;Ki.set(r),e.uniformMatrix4fv(this.addr,!1,Ki),ro(n,r)}}function po(e,t,n){var r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(e.uniform1i(this.addr,i),r[0]=i),n.safeSetTexture2D(t||qi,i)}function fo(e,t,n){var r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(e.uniform1i(this.addr,i),r[0]=i),n.setTexture2DArray(t||Xi,i)}function mo(e,t,n){var r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(e.uniform1i(this.addr,i),r[0]=i),n.setTexture3D(t||Yi,i)}function go(e,t,n){var r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(e.uniform1i(this.addr,i),r[0]=i),n.safeSetTextureCube(t||Zi,i)}function vo(e,t){var n=this.cache;n[0]!==t&&(e.uniform1i(this.addr,t),n[0]=t)}function yo(e,t){var n=this.cache;no(n,t)||(e.uniform2iv(this.addr,t),ro(n,t))}function xo(e,t){var n=this.cache;no(n,t)||(e.uniform3iv(this.addr,t),ro(n,t))}function bo(e,t){var n=this.cache;no(n,t)||(e.uniform4iv(this.addr,t),ro(n,t))}function wo(e,t){e.uniform1fv(this.addr,t)}function _o(e,t){e.uniform1iv(this.addr,t)}function Mo(e,t){e.uniform2iv(this.addr,t)}function Eo(e,t){e.uniform3iv(this.addr,t)}function So(e,t){e.uniform4iv(this.addr,t)}function To(e,t){var n=to(t,this.size,2);e.uniform2fv(this.addr,n)}function Ao(e,t){var n=to(t,this.size,3);e.uniform3fv(this.addr,n)}function Lo(e,t){var n=to(t,this.size,4);e.uniform4fv(this.addr,n)}function Po(e,t){var n=to(t,this.size,4);e.uniformMatrix2fv(this.addr,!1,n)}function Co(e,t){var n=to(t,this.size,9);e.uniformMatrix3fv(this.addr,!1,n)}function Ro(e,t){var n=to(t,this.size,16);e.uniformMatrix4fv(this.addr,!1,n)}function Oo(e,t,n){var r=t.length,i=io(n,r);e.uniform1iv(this.addr,i);for(var o=0;o!==r;++o)n.safeSetTexture2D(t[o]||qi,i[o])}function Do(e,t,n){var r=t.length,i=io(n,r);e.uniform1iv(this.addr,i);for(var o=0;o!==r;++o)n.safeSetTextureCube(t[o]||Zi,i[o])}function No(e,t,n){this.id=e,this.addr=n,this.cache=[],this.setValue=function(e){switch(e){case 5126:return oo;case 35664:return ao;case 35665:return so;case 35666:return co;case 35674:return lo;case 35675:return ho;case 35676:return uo;case 35678:case 36198:return po;case 35679:return mo;case 35680:return go;case 36289:return fo;case 5124:case 35670:return vo;case 35667:case 35671:return yo;case 35668:case 35672:return xo;case 35669:case 35673:return bo}}(t.type)}function Io(e,t,n){this.id=e,this.addr=n,this.cache=[],this.size=t.size,this.setValue=function(e){switch(e){case 5126:return wo;case 35664:return To;case 35665:return Ao;case 35666:return Lo;case 35674:return Po;case 35675:return Co;case 35676:return Ro;case 35678:return Oo;case 35680:return Do;case 5124:case 35670:return _o;case 35667:case 35671:return Mo;case 35668:case 35672:return Eo;case 35669:case 35673:return So}}(t.type)}function zo(e){this.id=e,this.seq=[],this.map={}}Io.prototype.updateCache=function(e){var t=this.cache;e instanceof Float32Array&&t.length!==e.length&&(this.cache=new Float32Array(e.length)),ro(t,e)},zo.prototype.setValue=function(e,t,n){for(var r=this.seq,i=0,o=r.length;i!==o;++i){var a=r[i];a.setValue(e,t[a.id],n)}};var ko=/([\w\d_]+)(\])?(\[|\.)?/g;function Fo(e,t){e.seq.push(t),e.map[t.id]=t}function Uo(e,t,n){var r=e.name,i=r.length;for(ko.lastIndex=0;;){var o=ko.exec(r),a=ko.lastIndex,s=o[1],c="]"===o[2],l=o[3];if(c&&(s|=0),void 0===l||"["===l&&a+2===i){Fo(n,void 0===l?new No(s,e,t):new Io(s,e,t));break}var h=n.map[s];void 0===h&&Fo(n,h=new zo(s)),n=h}}function Bo(e,t){this.seq=[],this.map={};for(var n=e.getProgramParameter(t,35718),r=0;r<n;++r){var i=e.getActiveUniform(t,r);Uo(i,e.getUniformLocation(t,i.name),this)}}function jo(e,t,n){var r=e.createShader(t);return e.shaderSource(r,n),e.compileShader(r),r}Bo.prototype.setValue=function(e,t,n,r){var i=this.map[t];void 0!==i&&i.setValue(e,n,r)},Bo.prototype.setOptional=function(e,t,n){var r=t[n];void 0!==r&&this.setValue(e,n,r)},Bo.upload=function(e,t,n,r){for(var i=0,o=t.length;i!==o;++i){var a=t[i],s=n[a.id];!1!==s.needsUpdate&&a.setValue(e,s.value,r)}},Bo.seqWithValue=function(e,t){for(var n=[],r=0,i=e.length;r!==i;++r){var o=e[r];o.id in t&&n.push(o)}return n};var Ho=0;function Go(e){switch(e){case dt:return["Linear","( value )"];case ft:return["sRGB","( value )"];case gt:return["RGBE","( value )"];case yt:return["RGBM","( value, 7.0 )"];case xt:return["RGBM","( value, 16.0 )"];case bt:return["RGBD","( value, 256.0 )"];case mt:return["Gamma","( value, float( GAMMA_FACTOR ) )"];case vt:return["LogLuv","( value )"];default:throw new Error("unsupported encoding: "+e)}}function Vo(e,t,n){var r=e.getShaderParameter(t,35713),i=e.getShaderInfoLog(t).trim();return r&&""===i?"":"THREE.WebGLShader: gl.getShaderInfoLog() "+n+"\n"+i+function(e){for(var t=e.split("\n"),n=0;n<t.length;n++)t[n]=n+1+": "+t[n];return t.join("\n")}(e.getShaderSource(t))}function Wo(e,t){var n=Go(t);return"vec4 "+e+"( vec4 value ) { return "+n[0]+"ToLinear"+n[1]+"; }"}function qo(e,t){var n;switch(t){case Q:n="Linear";break;case K:n="Reinhard";break;case $:n="Uncharted2";break;case ee:n="OptimizedCineon";break;case te:n="ACESFilmic";break;default:throw new Error("unsupported toneMapping: "+t)}return"vec3 "+e+"( vec3 color ) { return "+n+"ToneMapping( color ); }"}function Xo(e){return""!==e}function Yo(e,t){return e.replace(/NUM_DIR_LIGHTS/g,t.numDirLights).replace(/NUM_SPOT_LIGHTS/g,t.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,t.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,t.numPointLights).replace(/NUM_HEMI_LIGHTS/g,t.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,t.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS/g,t.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,t.numPointLightShadows)}function Zo(e,t){return e.replace(/NUM_CLIPPING_PLANES/g,t.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,t.numClippingPlanes-t.numClipIntersection)}var Jo=/^[ \t]*#include +<([\w\d./]+)>/gm;function Qo(e){return e.replace(Jo,Ko)}function Ko(e,t){var n=Si[t];if(void 0===n)throw new Error("Can not resolve #include <"+t+">");return Qo(n)}var $o=/#pragma unroll_loop[\s]+?for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g;function ea(e){return e.replace($o,ta)}function ta(e,t,n,r){for(var i="",o=parseInt(t);o<parseInt(n);o++)i+=r.replace(/\[ i \]/g,"[ "+o+" ]").replace(/UNROLLED_LOOP_INDEX/g,o);return i}function na(e){var t="precision "+e.precision+" float;\nprecision "+e.precision+" int;";return"highp"===e.precision?t+="\n#define HIGH_PRECISION":"mediump"===e.precision?t+="\n#define MEDIUM_PRECISION":"lowp"===e.precision&&(t+="\n#define LOW_PRECISION"),t}function ra(e,t,n,r,i,o){var a,s,u,p,d,f=e.getContext(),m=r.defines,g=i.vertexShader,v=i.fragmentShader,y=function(e){var t="SHADOWMAP_TYPE_BASIC";return e.shadowMapType===c?t="SHADOWMAP_TYPE_PCF":e.shadowMapType===l?t="SHADOWMAP_TYPE_PCF_SOFT":e.shadowMapType===h&&(t="SHADOWMAP_TYPE_VSM"),t}(o),x=function(e){var t="ENVMAP_TYPE_CUBE";if(e.envMap)switch(e.envMapMode){case ne:case re:t="ENVMAP_TYPE_CUBE";break;case se:case ce:t="ENVMAP_TYPE_CUBE_UV";break;case ie:case oe:t="ENVMAP_TYPE_EQUIREC";break;case ae:t="ENVMAP_TYPE_SPHERE"}return t}(o),b=function(e){var t="ENVMAP_MODE_REFLECTION";if(e.envMap)switch(e.envMapMode){case re:case oe:t="ENVMAP_MODE_REFRACTION"}return t}(o),w=function(e){var t="ENVMAP_BLENDING_MULTIPLY";if(e.envMap)switch(e.combine){case X:t="ENVMAP_BLENDING_MULTIPLY";break;case Y:t="ENVMAP_BLENDING_MIX";break;case Z:t="ENVMAP_BLENDING_ADD"}return t}(o),_=e.gammaFactor>0?e.gammaFactor:1,M=o.isWebGL2?"":function(e,t,n){return[(e=e||{}).derivatives||t.envMapCubeUV||t.bumpMap||t.tangentSpaceNormalMap||t.clearcoatNormalMap||t.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(e.fragDepth||t.logarithmicDepthBuffer)&&n.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",e.drawBuffers&&n.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(e.shaderTextureLOD||t.envMap)&&n.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""].filter(Xo).join("\n")}(r.extensions,o,t),E=function(e){var t=[];for(var n in e){var r=e[n];!1!==r&&t.push("#define "+n+" "+r)}return t.join("\n")}(m),S=f.createProgram(),T=o.numMultiviewViews;if(r.isRawShaderMaterial?((a=[E].filter(Xo).join("\n")).length>0&&(a+="\n"),(s=[M,E].filter(Xo).join("\n")).length>0&&(s+="\n")):(a=[na(o),"#define SHADER_NAME "+i.name,E,o.instancing?"#define USE_INSTANCING":"",o.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+_,"#define MAX_BONES "+o.maxBones,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp2?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+b:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.normalMap&&o.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",o.normalMap&&o.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",o.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",o.displacementMap&&o.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.vertexTangents?"#define USE_TANGENT":"",o.vertexColors?"#define USE_COLOR":"",o.vertexUvs?"#define USE_UV":"",o.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",o.flatShading?"#define FLAT_SHADED":"",o.skinning?"#define USE_SKINNING":"",o.useVertexTexture?"#define BONE_TEXTURE":"",o.morphTargets?"#define USE_MORPHTARGETS":"",o.morphNormals&&!1===o.flatShading?"#define USE_MORPHNORMALS":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"",o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+y:"",o.sizeAttenuation?"#define USE_SIZEATTENUATION":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&(o.isWebGL2||t.get("EXT_frag_depth"))?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING"," attribute mat4 instanceMatrix;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#ifdef USE_COLOR","\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(Xo).join("\n"),s=[M,na(o),"#define SHADER_NAME "+i.name,E,o.alphaTest?"#define ALPHATEST "+o.alphaTest+(o.alphaTest%1?"":".0"):"","#define GAMMA_FACTOR "+_,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp2?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.matcap?"#define USE_MATCAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+x:"",o.envMap?"#define "+b:"",o.envMap?"#define "+w:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.normalMap&&o.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",o.normalMap&&o.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",o.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.sheen?"#define USE_SHEEN":"",o.vertexTangents?"#define USE_TANGENT":"",o.vertexColors?"#define USE_COLOR":"",o.vertexUvs?"#define USE_UV":"",o.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",o.gradientMap?"#define USE_GRADIENTMAP":"",o.flatShading?"#define FLAT_SHADED":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"",o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+y:"",o.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",o.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&(o.isWebGL2||t.get("EXT_frag_depth"))?"#define USE_LOGDEPTHBUF_EXT":"",(r.extensions&&r.extensions.shaderTextureLOD||o.envMap)&&(o.isWebGL2||t.get("EXT_shader_texture_lod"))?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",o.toneMapping!==J?"#define TONE_MAPPING":"",o.toneMapping!==J?Si.tonemapping_pars_fragment:"",o.toneMapping!==J?qo("toneMapping",o.toneMapping):"",o.dithering?"#define DITHERING":"",o.outputEncoding||o.mapEncoding||o.matcapEncoding||o.envMapEncoding||o.emissiveMapEncoding?Si.encodings_pars_fragment:"",o.mapEncoding?Wo("mapTexelToLinear",o.mapEncoding):"",o.matcapEncoding?Wo("matcapTexelToLinear",o.matcapEncoding):"",o.envMapEncoding?Wo("envMapTexelToLinear",o.envMapEncoding):"",o.emissiveMapEncoding?Wo("emissiveMapTexelToLinear",o.emissiveMapEncoding):"",o.outputEncoding?(u="linearToOutputTexel",p=o.outputEncoding,d=Go(p),"vec4 "+u+"( vec4 value ) { return LinearTo"+d[0]+d[1]+"; }"):"",o.depthPacking?"#define DEPTH_PACKING "+r.depthPacking:"","\n"].filter(Xo).join("\n")),g=Zo(g=Yo(g=Qo(g),o),o),v=Zo(v=Yo(v=Qo(v),o),o),g=ea(g),v=ea(v),o.isWebGL2&&!r.isRawShaderMaterial){var A=!1,L=/^\s*#version\s+300\s+es\s*\n/;r.isShaderMaterial&&null!==g.match(L)&&null!==v.match(L)&&(A=!0,g=g.replace(L,""),v=v.replace(L,"")),a=["#version 300 es\n","#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+a,s=["#version 300 es\n","#define varying in",A?"":"out highp vec4 pc_fragColor;",A?"":"#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+s,T>0&&(a=(a=a.replace("#version 300 es\n",["#version 300 es\n","#extension GL_OVR_multiview2 : require","layout(num_views = "+T+") in;","#define VIEW_ID gl_ViewID_OVR"].join("\n"))).replace(["uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;"].join("\n"),["uniform mat4 modelViewMatrices["+T+"];","uniform mat4 projectionMatrices["+T+"];","uniform mat4 viewMatrices["+T+"];","uniform mat3 normalMatrices["+T+"];","#define modelViewMatrix modelViewMatrices[VIEW_ID]","#define projectionMatrix projectionMatrices[VIEW_ID]","#define viewMatrix viewMatrices[VIEW_ID]","#define normalMatrix normalMatrices[VIEW_ID]"].join("\n")),s=(s=s.replace("#version 300 es\n",["#version 300 es\n","#extension GL_OVR_multiview2 : require","#define VIEW_ID gl_ViewID_OVR"].join("\n"))).replace("uniform mat4 viewMatrix;",["uniform mat4 viewMatrices["+T+"];","#define viewMatrix viewMatrices[VIEW_ID]"].join("\n")))}var P,C,R=s+v,O=jo(f,35633,a+g),D=jo(f,35632,R);if(f.attachShader(S,O),f.attachShader(S,D),void 0!==r.index0AttributeName?f.bindAttribLocation(S,0,r.index0AttributeName):!0===o.morphTargets&&f.bindAttribLocation(S,0,"position"),f.linkProgram(S),e.debug.checkShaderErrors){var N=f.getProgramInfoLog(S).trim(),I=f.getShaderInfoLog(O).trim(),z=f.getShaderInfoLog(D).trim(),k=!0,F=!0;if(!1===f.getProgramParameter(S,35714)){k=!1;var U=Vo(f,O,"vertex"),B=Vo(f,D,"fragment");console.error("THREE.WebGLProgram: shader error: ",f.getError(),"35715",f.getProgramParameter(S,35715),"gl.getProgramInfoLog",N,U,B)}else""!==N?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",N):""!==I&&""!==z||(F=!1);F&&(this.diagnostics={runnable:k,material:r,programLog:N,vertexShader:{log:I,prefix:a},fragmentShader:{log:z,prefix:s}})}return f.deleteShader(O),f.deleteShader(D),this.getUniforms=function(){return void 0===P&&(P=new Bo(f,S)),P},this.getAttributes=function(){return void 0===C&&(C=function(e,t){for(var n={},r=e.getProgramParameter(t,35721),i=0;i<r;i++){var o=e.getActiveAttrib(t,i).name;n[o]=e.getAttribLocation(t,o)}return n}(f,S)),C},this.destroy=function(){f.deleteProgram(S),this.program=void 0},this.name=i.name,this.id=Ho++,this.cacheKey=n,this.usedTimes=1,this.program=S,this.vertexShader=O,this.fragmentShader=D,this.numMultiviewViews=T,this}function ia(e,t,n){var r=[],i=n.isWebGL2,o=n.logarithmicDepthBuffer,a=n.floatVertexTextures,s=n.precision,c=n.maxVertexUniforms,l=n.vertexTextures,h={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"},u=["precision","isWebGL2","supportsVertexTextures","outputEncoding","instancing","numMultiviewViews","map","mapEncoding","matcap","matcapEncoding","envMap","envMapMode","envMapEncoding","envMapCubeUV","lightMap","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","objectSpaceNormalMap","tangentSpaceNormalMap","clearcoatNormalMap","displacementMap","specularMap","roughnessMap","metalnessMap","gradientMap","alphaMap","combine","vertexColors","vertexTangents","vertexUvs","uvsVertexOnly","fog","useFog","fogExp2","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","numRectAreaLights","numDirLightShadows","numPointLightShadows","numSpotLightShadows","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","numClipIntersection","depthPacking","dithering","sheen"];function f(e,t){var n;return e?e.isTexture?n=e.encoding:e.isWebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),n=e.texture.encoding):n=dt,n===dt&&t&&(n=mt),n}this.getParameters=function(t,r,u,m,g,v,y){var x=h[t.type],b=y.isSkinnedMesh?function(e){var t=e.skeleton.bones;if(a)return 1024;var n=c,r=Math.floor((n-20)/4),i=Math.min(r,t.length);return i<t.length?(console.warn("THREE.WebGLRenderer: Skeleton has "+t.length+" bones. This GPU supports "+i+"."),0):i}(y):0;null!==t.precision&&(s=n.getMaxPrecision(t.precision))!==t.precision&&console.warn("THREE.WebGLProgram.getParameters:",t.precision,"not supported, using",s,"instead.");var w=e.getRenderTarget(),_=w&&w.isWebGLMultiviewRenderTarget?w.numViews:0;return{isWebGL2:i,shaderID:x,precision:s,instancing:!0===y.isInstancedMesh,supportsVertexTextures:l,numMultiviewViews:_,outputEncoding:f(w?w.texture:null,e.gammaOutput),map:!!t.map,mapEncoding:f(t.map,e.gammaInput),matcap:!!t.matcap,matcapEncoding:f(t.matcap,e.gammaInput),envMap:!!t.envMap,envMapMode:t.envMap&&t.envMap.mapping,envMapEncoding:f(t.envMap,e.gammaInput),envMapCubeUV:!!t.envMap&&(t.envMap.mapping===se||t.envMap.mapping===ce),lightMap:!!t.lightMap,aoMap:!!t.aoMap,emissiveMap:!!t.emissiveMap,emissiveMapEncoding:f(t.emissiveMap,e.gammaInput),bumpMap:!!t.bumpMap,normalMap:!!t.normalMap,objectSpaceNormalMap:t.normalMapType===Et,tangentSpaceNormalMap:t.normalMapType===Mt,clearcoatNormalMap:!!t.clearcoatNormalMap,displacementMap:!!t.displacementMap,roughnessMap:!!t.roughnessMap,metalnessMap:!!t.metalnessMap,specularMap:!!t.specularMap,alphaMap:!!t.alphaMap,gradientMap:!!t.gradientMap,sheen:!!t.sheen,combine:t.combine,vertexTangents:t.normalMap&&t.vertexTangents,vertexColors:t.vertexColors,vertexUvs:!!(t.map||t.bumpMap||t.normalMap||t.specularMap||t.alphaMap||t.emissiveMap||t.roughnessMap||t.metalnessMap||t.clearcoatNormalMap||t.displacementMap),uvsVertexOnly:!(t.map||t.bumpMap||t.normalMap||t.specularMap||t.alphaMap||t.emissiveMap||t.roughnessMap||t.metalnessMap||t.clearcoatNormalMap||!t.displacementMap),fog:!!m,useFog:t.fog,fogExp2:m&&m.isFogExp2,flatShading:t.flatShading,sizeAttenuation:t.sizeAttenuation,logarithmicDepthBuffer:o,skinning:t.skinning&&b>0,maxBones:b,useVertexTexture:a,morphTargets:t.morphTargets,morphNormals:t.morphNormals,maxMorphTargets:e.maxMorphTargets,maxMorphNormals:e.maxMorphNormals,numDirLights:r.directional.length,numPointLights:r.point.length,numSpotLights:r.spot.length,numRectAreaLights:r.rectArea.length,numHemiLights:r.hemi.length,numDirLightShadows:r.directionalShadowMap.length,numPointLightShadows:r.pointShadowMap.length,numSpotLightShadows:r.spotShadowMap.length,numClippingPlanes:g,numClipIntersection:v,dithering:t.dithering,shadowMapEnabled:e.shadowMap.enabled&&u.length>0,shadowMapType:e.shadowMap.type,toneMapping:t.toneMapped?e.toneMapping:J,physicallyCorrectLights:e.physicallyCorrectLights,premultipliedAlpha:t.premultipliedAlpha,alphaTest:t.alphaTest,doubleSided:t.side===d,flipSided:t.side===p,depthPacking:void 0!==t.depthPacking&&t.depthPacking}},this.getProgramCacheKey=function(t,n){var r=[];if(n.shaderID?r.push(n.shaderID):(r.push(t.fragmentShader),r.push(t.vertexShader)),void 0!==t.defines)for(var i in t.defines)r.push(i),r.push(t.defines[i]);for(var o=0;o<u.length;o++)r.push(n[u[o]]);return r.push(t.onBeforeCompile.toString()),r.push(e.gammaOutput),r.push(e.gammaFactor),r.join()},this.acquireProgram=function(n,i,o,a){for(var s,c=0,l=r.length;c<l;c++){var h=r[c];if(h.cacheKey===a){++(s=h).usedTimes;break}}return void 0===s&&(s=new ra(e,t,a,n,i,o),r.push(s)),s},this.releaseProgram=function(e){if(0==--e.usedTimes){var t=r.indexOf(e);r[t]=r[r.length-1],r.pop(),e.destroy()}},this.programs=r}function oa(){var e=new WeakMap;return{get:function(t){var n=e.get(t);return void 0===n&&(n={},e.set(t,n)),n},remove:function(t){e.delete(t)},update:function(t,n,r){e.get(t)[n]=r},dispose:function(){e=new WeakMap}}}function aa(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.program!==t.program?e.program.id-t.program.id:e.material.id!==t.material.id?e.material.id-t.material.id:e.z!==t.z?e.z-t.z:e.id-t.id}function sa(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.z!==t.z?t.z-e.z:e.id-t.id}function ca(){var e=[],t=0,n=[],r=[],i={id:-1};function o(n,r,o,a,s,c){var l=e[t];return void 0===l?(l={id:n.id,object:n,geometry:r,material:o,program:o.program||i,groupOrder:a,renderOrder:n.renderOrder,z:s,group:c},e[t]=l):(l.id=n.id,l.object=n,l.geometry=r,l.material=o,l.program=o.program||i,l.groupOrder=a,l.renderOrder=n.renderOrder,l.z=s,l.group=c),t++,l}return{opaque:n,transparent:r,init:function(){t=0,n.length=0,r.length=0},push:function(e,t,i,a,s,c){var l=o(e,t,i,a,s,c);(!0===i.transparent?r:n).push(l)},unshift:function(e,t,i,a,s,c){var l=o(e,t,i,a,s,c);(!0===i.transparent?r:n).unshift(l)},sort:function(){n.length>1&&n.sort(aa),r.length>1&&r.sort(sa)}}}function la(){var e=new WeakMap;function t(n){var r=n.target;r.removeEventListener("dispose",t),e.delete(r)}return{get:function(n,r){var i,o=e.get(n);return void 0===o?(i=new ca,e.set(n,new WeakMap),e.get(n).set(r,i),n.addEventListener("dispose",t)):void 0===(i=o.get(r))&&(i=new ca,o.set(r,i)),i},dispose:function(){e=new WeakMap}}}function ha(){var e={};return{get:function(t){if(void 0!==e[t.id])return e[t.id];var n;switch(t.type){case"DirectionalLight":n={direction:new zt,color:new cr,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ot};break;case"SpotLight":n={position:new zt,direction:new zt,color:new cr,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ot};break;case"PointLight":n={position:new zt,color:new cr,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ot,shadowCameraNear:1,shadowCameraFar:1e3};break;case"HemisphereLight":n={direction:new zt,skyColor:new cr,groundColor:new cr};break;case"RectAreaLight":n={color:new cr,position:new zt,halfWidth:new zt,halfHeight:new zt}}return e[t.id]=n,n}}}var ua=0;function pa(e,t){return(t.castShadow?1:0)-(e.castShadow?1:0)}function da(){for(var e=new ha,t={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1},n=0;n<9;n++)t.probe.push(new zt);var r=new zt,i=new $t,o=new $t;return{setup:function(n,a,s){for(var c=0,l=0,h=0,u=0;u<9;u++)t.probe[u].set(0,0,0);var p=0,d=0,f=0,m=0,g=0,v=0,y=0,x=0,b=s.matrixWorldInverse;n.sort(pa),u=0;for(var w=n.length;u<w;u++){var _=n[u],M=_.color,E=_.intensity,S=_.distance,T=_.shadow&&_.shadow.map?_.shadow.map.texture:null;if(_.isAmbientLight)c+=M.r*E,l+=M.g*E,h+=M.b*E;else if(_.isLightProbe)for(var A=0;A<9;A++)t.probe[A].addScaledVector(_.sh.coefficients[A],E);else if(_.isDirectionalLight){if((P=e.get(_)).color.copy(_.color).multiplyScalar(_.intensity),P.direction.setFromMatrixPosition(_.matrixWorld),r.setFromMatrixPosition(_.target.matrixWorld),P.direction.sub(r),P.direction.transformDirection(b),P.shadow=_.castShadow,_.castShadow){var L=_.shadow;P.shadowBias=L.bias,P.shadowRadius=L.radius,P.shadowMapSize=L.mapSize,t.directionalShadowMap[p]=T,t.directionalShadowMatrix[p]=_.shadow.matrix,v++}t.directional[p]=P,p++}else if(_.isSpotLight){if((P=e.get(_)).position.setFromMatrixPosition(_.matrixWorld),P.position.applyMatrix4(b),P.color.copy(M).multiplyScalar(E),P.distance=S,P.direction.setFromMatrixPosition(_.matrixWorld),r.setFromMatrixPosition(_.target.matrixWorld),P.direction.sub(r),P.direction.transformDirection(b),P.coneCos=Math.cos(_.angle),P.penumbraCos=Math.cos(_.angle*(1-_.penumbra)),P.decay=_.decay,P.shadow=_.castShadow,_.castShadow){L=_.shadow;P.shadowBias=L.bias,P.shadowRadius=L.radius,P.shadowMapSize=L.mapSize,t.spotShadowMap[f]=T,t.spotShadowMatrix[f]=_.shadow.matrix,x++}t.spot[f]=P,f++}else if(_.isRectAreaLight){(P=e.get(_)).color.copy(M).multiplyScalar(E),P.position.setFromMatrixPosition(_.matrixWorld),P.position.applyMatrix4(b),o.identity(),i.copy(_.matrixWorld),i.premultiply(b),o.extractRotation(i),P.halfWidth.set(.5*_.width,0,0),P.halfHeight.set(0,.5*_.height,0),P.halfWidth.applyMatrix4(o),P.halfHeight.applyMatrix4(o),t.rectArea[m]=P,m++}else if(_.isPointLight){if((P=e.get(_)).position.setFromMatrixPosition(_.matrixWorld),P.position.applyMatrix4(b),P.color.copy(_.color).multiplyScalar(_.intensity),P.distance=_.distance,P.decay=_.decay,P.shadow=_.castShadow,_.castShadow){L=_.shadow;P.shadowBias=L.bias,P.shadowRadius=L.radius,P.shadowMapSize=L.mapSize,P.shadowCameraNear=L.camera.near,P.shadowCameraFar=L.camera.far,t.pointShadowMap[d]=T,t.pointShadowMatrix[d]=_.shadow.matrix,y++}t.point[d]=P,d++}else if(_.isHemisphereLight){var P;(P=e.get(_)).direction.setFromMatrixPosition(_.matrixWorld),P.direction.transformDirection(b),P.direction.normalize(),P.skyColor.copy(_.color).multiplyScalar(E),P.groundColor.copy(_.groundColor).multiplyScalar(E),t.hemi[g]=P,g++}}t.ambient[0]=c,t.ambient[1]=l,t.ambient[2]=h;var C=t.hash;C.directionalLength===p&&C.pointLength===d&&C.spotLength===f&&C.rectAreaLength===m&&C.hemiLength===g&&C.numDirectionalShadows===v&&C.numPointShadows===y&&C.numSpotShadows===x||(t.directional.length=p,t.spot.length=f,t.rectArea.length=m,t.point.length=d,t.hemi.length=g,t.directionalShadowMap.length=v,t.pointShadowMap.length=y,t.spotShadowMap.length=x,t.directionalShadowMatrix.length=v,t.pointShadowMatrix.length=y,t.spotShadowMatrix.length=x,C.directionalLength=p,C.pointLength=d,C.spotLength=f,C.rectAreaLength=m,C.hemiLength=g,C.numDirectionalShadows=v,C.numPointShadows=y,C.numSpotShadows=x,t.version=ua++)},state:t}}function fa(){var e=new da,t=[],n=[];return{init:function(){t.length=0,n.length=0},state:{lightsArray:t,shadowsArray:n,lights:e},setupLights:function(r){e.setup(t,n,r)},pushLight:function(e){t.push(e)},pushShadow:function(e){n.push(e)}}}function ma(){var e=new WeakMap;function t(n){var r=n.target;r.removeEventListener("dispose",t),e.delete(r)}return{get:function(n,r){var i;return!1===e.has(n)?(i=new fa,e.set(n,new WeakMap),e.get(n).set(r,i),n.addEventListener("dispose",t)):!1===e.get(n).has(r)?(i=new fa,e.get(n).set(r,i)):i=e.get(n).get(r),i},dispose:function(){e=new WeakMap}}}function ga(e){fr.call(this),this.type="MeshDepthMaterial",this.depthPacking=wt,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.setValues(e)}function va(e){fr.call(this),this.type="MeshDistanceMaterial",this.referencePosition=new zt,this.nearDistance=1,this.farDistance=1e3,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.fog=!1,this.setValues(e)}ga.prototype=Object.create(fr.prototype),ga.prototype.constructor=ga,ga.prototype.isMeshDepthMaterial=!0,ga.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.depthPacking=e.depthPacking,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this},va.prototype=Object.create(fr.prototype),va.prototype.constructor=va,va.prototype.isMeshDistanceMaterial=!0,va.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.referencePosition.copy(e.referencePosition),this.nearDistance=e.nearDistance,this.farDistance=e.farDistance,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this};var ya="uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n  float mean = 0.0;\n  float squared_mean = 0.0;\n  \n\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy  ) / resolution ) );\n  for ( float i = -1.0; i < 1.0 ; i += SAMPLE_RATE) {\n    #ifdef HORIZONAL_PASS\n      vec2 distribution = decodeHalfRGBA ( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( i, 0.0 ) * radius ) / resolution ) );\n      mean += distribution.x;\n      squared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n    #else\n      float depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0,  i )  * radius ) / resolution ) );\n      mean += depth;\n      squared_mean += depth * depth;\n    #endif\n  }\n  mean = mean * HALF_SAMPLE_RATE;\n  squared_mean = squared_mean * HALF_SAMPLE_RATE;\n  float std_dev = pow( squared_mean - mean * mean, 0.5 );\n  gl_FragColor = encodeHalfRGBA( vec2( mean, std_dev ) );\n}",xa="void main() {\n\tgl_Position = vec4( position, 1.0 );\n}";function ba(e,t,n){var r=new Ei,i=new Ot,o=new Ot,a=new Gt,s=[],l=[],f={},m={0:p,1:u,2:d},g=new fi({defines:{SAMPLE_RATE:.25,HALF_SAMPLE_RATE:1/8},uniforms:{shadow_pass:{value:null},resolution:{value:new Ot},radius:{value:4}},vertexShader:xa,fragmentShader:ya}),y=g.clone();y.defines.HORIZONAL_PASS=1;var x=new Ir;x.setAttribute("position",new gr(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));var b=new $r(x,g),w=this;function _(n,r){var i=t.update(b);g.uniforms.shadow_pass.value=n.map.texture,g.uniforms.resolution.value=n.mapSize,g.uniforms.radius.value=n.radius,e.setRenderTarget(n.mapPass),e.clear(),e.renderBufferDirect(r,null,i,g,b,null),y.uniforms.shadow_pass.value=n.mapPass.texture,y.uniforms.resolution.value=n.mapSize,y.uniforms.radius.value=n.radius,e.setRenderTarget(n.map),e.clear(),e.renderBufferDirect(r,null,i,y,b,null)}function M(e,t,n){var r=e<<0|t<<1|n<<2,i=s[r];return void 0===i&&(i=new ga({depthPacking:_t,morphTargets:e,skinning:t}),s[r]=i),i}function E(e,t,n){var r=e<<0|t<<1|n<<2,i=l[r];return void 0===i&&(i=new va({morphTargets:e,skinning:t}),l[r]=i),i}function S(t,n,r,i,o,a){var s=t.geometry,c=null,l=M,u=t.customDepthMaterial;if(!0===r.isPointLight&&(l=E,u=t.customDistanceMaterial),void 0===u){var p=!1;!0===n.morphTargets&&(!0===s.isBufferGeometry?p=s.morphAttributes&&s.morphAttributes.position&&s.morphAttributes.position.length>0:!0===s.isGeometry&&(p=s.morphTargets&&s.morphTargets.length>0));var d=!1;!0===t.isSkinnedMesh&&(!0===n.skinning?d=!0:console.warn("THREE.WebGLShadowMap: THREE.SkinnedMesh with material.skinning set to false:",t)),c=l(p,d,!0===t.isInstancedMesh)}else c=u;if(e.localClippingEnabled&&!0===n.clipShadows&&0!==n.clippingPlanes.length){var g=c.uuid,v=n.uuid,y=f[g];void 0===y&&(y={},f[g]=y);var x=y[v];void 0===x&&(x=c.clone(),y[v]=x),c=x}return c.visible=n.visible,c.wireframe=n.wireframe,c.side=a===h?null!==n.shadowSide?n.shadowSide:n.side:null!==n.shadowSide?n.shadowSide:m[n.side],c.clipShadows=n.clipShadows,c.clippingPlanes=n.clippingPlanes,c.clipIntersection=n.clipIntersection,c.wireframeLinewidth=n.wireframeLinewidth,c.linewidth=n.linewidth,!0===r.isPointLight&&!0===c.isMeshDistanceMaterial&&(c.referencePosition.setFromMatrixPosition(r.matrixWorld),c.nearDistance=i,c.farDistance=o),c}function T(n,i,o,a,s){if(!1!==n.visible){if(n.layers.test(i.layers)&&(n.isMesh||n.isLine||n.isPoints)&&(n.castShadow||n.receiveShadow&&s===h)&&(!n.frustumCulled||r.intersectsObject(n))){n.modelViewMatrix.multiplyMatrices(o.matrixWorldInverse,n.matrixWorld);var c=t.update(n),l=n.material;if(Array.isArray(l))for(var u=c.groups,p=0,d=u.length;p<d;p++){var f=u[p],m=l[f.materialIndex];if(m&&m.visible){var g=S(n,m,a,o.near,o.far,s);e.renderBufferDirect(o,null,c,g,n,f)}}else if(l.visible){g=S(n,l,a,o.near,o.far,s);e.renderBufferDirect(o,null,c,g,n,null)}}for(var v=n.children,y=0,x=v.length;y<x;y++)T(v[y],i,o,a,s)}}this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=c,this.render=function(t,s,c){if(!1!==w.enabled&&(!1!==w.autoUpdate||!1!==w.needsUpdate)&&0!==t.length){var l=e.getRenderTarget(),u=e.getActiveCubeFace(),p=e.getActiveMipmapLevel(),d=e.state;d.setBlending(v),d.buffers.color.setClear(1,1,1,1),d.buffers.depth.setTest(!0),d.setScissorTest(!1);for(var f=0,m=t.length;f<m;f++){var g=t[f],y=g.shadow;if(void 0!==y){i.copy(y.mapSize);var x=y.getFrameExtents();if(i.multiply(x),o.copy(y.mapSize),(i.x>n||i.y>n)&&(console.warn("THREE.WebGLShadowMap:",g,"has shadow exceeding max texture size, reducing"),i.x>n&&(o.x=Math.floor(n/x.x),i.x=o.x*x.x,y.mapSize.x=o.x),i.y>n&&(o.y=Math.floor(n/x.y),i.y=o.y*x.y,y.mapSize.y=o.y)),null===y.map&&!y.isPointLightShadow&&this.type===h){var b={minFilter:me,magFilter:me,format:Oe};y.map=new Vt(i.x,i.y,b),y.map.texture.name=g.name+".shadowMap",y.mapPass=new Vt(i.x,i.y,b),y.camera.updateProjectionMatrix()}if(null===y.map){b={minFilter:pe,magFilter:pe,format:Oe};y.map=new Vt(i.x,i.y,b),y.map.texture.name=g.name+".shadowMap",y.camera.updateProjectionMatrix()}e.setRenderTarget(y.map),e.clear();for(var M=y.getViewportCount(),E=0;E<M;E++){var S=y.getViewport(E);a.set(o.x*S.x,o.y*S.y,o.x*S.z,o.y*S.w),d.viewport(a),y.updateMatrices(g,E),r=y.getFrustum(),T(s,c,y.camera,g,this.type)}y.isPointLightShadow||this.type!==h||_(y,c)}else console.warn("THREE.WebGLShadowMap:",g,"has no shadow.")}w.needsUpdate=!1,e.setRenderTarget(l,u,p)}}}function wa(e,t,n){var r=n.isWebGL2;var i=new function(){var t=!1,n=new Gt,r=null,i=new Gt(0,0,0,0);return{setMask:function(n){r===n||t||(e.colorMask(n,n,n,n),r=n)},setLocked:function(e){t=e},setClear:function(t,r,o,a,s){!0===s&&(t*=a,r*=a,o*=a),n.set(t,r,o,a),!1===i.equals(n)&&(e.clearColor(t,r,o,a),i.copy(n))},reset:function(){t=!1,r=null,i.set(-1,0,0,0)}}},c=new function(){var t=!1,n=null,r=null,i=null;return{setTest:function(e){e?xe(2929):be(2929)},setMask:function(r){n===r||t||(e.depthMask(r),n=r)},setFunc:function(t){if(r!==t){if(t)switch(t){case U:e.depthFunc(512);break;case B:e.depthFunc(519);break;case j:e.depthFunc(513);break;case H:e.depthFunc(515);break;case G:e.depthFunc(514);break;case V:e.depthFunc(518);break;case W:e.depthFunc(516);break;case q:e.depthFunc(517);break;default:e.depthFunc(515)}else e.depthFunc(515);r=t}},setLocked:function(e){t=e},setClear:function(t){i!==t&&(e.clearDepth(t),i=t)},reset:function(){t=!1,n=null,r=null,i=null}}},l=new function(){var t=!1,n=null,r=null,i=null,o=null,a=null,s=null,c=null,l=null;return{setTest:function(e){t||(e?xe(2960):be(2960))},setMask:function(r){n===r||t||(e.stencilMask(r),n=r)},setFunc:function(t,n,a){r===t&&i===n&&o===a||(e.stencilFunc(t,n,a),r=t,i=n,o=a)},setOp:function(t,n,r){a===t&&s===n&&c===r||(e.stencilOp(t,n,r),a=t,s=n,c=r)},setLocked:function(e){t=e},setClear:function(t){l!==t&&(e.clearStencil(t),l=t)},reset:function(){t=!1,n=null,r=null,i=null,o=null,a=null,s=null,c=null,l=null}}},h=e.getParameter(34921),u=new Uint8Array(h),f=new Uint8Array(h),m=new Uint8Array(h),g={},X=null,Y=null,Z=null,J=null,Q=null,K=null,$=null,ee=null,te=null,ne=!1,re=null,ie=null,oe=null,ae=null,se=null,ce=e.getParameter(35661),le=!1,he=0,ue=e.getParameter(7938);-1!==ue.indexOf("WebGL")?(he=parseFloat(/^WebGL\ ([0-9])/.exec(ue)[1]),le=he>=1):-1!==ue.indexOf("OpenGL ES")&&(he=parseFloat(/^OpenGL\ ES\ ([0-9])/.exec(ue)[1]),le=he>=2);var pe=null,de={},fe=new Gt,me=new Gt;function ge(t,n,r){var i=new Uint8Array(4),o=e.createTexture();e.bindTexture(t,o),e.texParameteri(t,10241,9728),e.texParameteri(t,10240,9728);for(var a=0;a<r;a++)e.texImage2D(n+a,0,6408,1,1,0,6408,5121,i);return o}var ve={};function ye(n,i){(u[n]=1,0===f[n]&&(e.enableVertexAttribArray(n),f[n]=1),m[n]!==i)&&((r?e:t.get("ANGLE_instanced_arrays"))[r?"vertexAttribDivisor":"vertexAttribDivisorANGLE"](n,i),m[n]=i)}function xe(t){!0!==g[t]&&(e.enable(t),g[t]=!0)}function be(t){!1!==g[t]&&(e.disable(t),g[t]=!1)}ve[3553]=ge(3553,3553,1),ve[34067]=ge(34067,34069,6),i.setClear(0,0,0,1),c.setClear(1),l.setClear(0),xe(2929),c.setFunc(H),Se(!1),Te(a),xe(2884),Ee(v);var we={[M]:32774,[E]:32778,[S]:32779};if(r)we[T]=32775,we[A]=32776;else{var _e=t.get("EXT_blend_minmax");null!==_e&&(we[T]=_e.MIN_EXT,we[A]=_e.MIN_EXT)}var Me={[L]:0,[P]:1,[C]:768,[O]:770,[F]:776,[z]:774,[N]:772,[R]:769,[D]:771,[k]:775,[I]:773};function Ee(t,n,r,i,o,a,s,c){if(t!==v){if(Y||(xe(3042),Y=!0),t===_)o=o||n,a=a||r,s=s||i,n===J&&o===$||(e.blendEquationSeparate(we[n],we[o]),J=n,$=o),r===Q&&i===K&&a===ee&&s===te||(e.blendFuncSeparate(Me[r],Me[i],Me[a],Me[s]),Q=r,K=i,ee=a,te=s),Z=t,ne=null;else if(t!==Z||c!==ne){if(J===M&&$===M||(e.blendEquation(32774),J=M,$=M),c)switch(t){case y:e.blendFuncSeparate(1,771,1,771);break;case x:e.blendFunc(1,1);break;case b:e.blendFuncSeparate(0,0,769,771);break;case w:e.blendFuncSeparate(0,768,0,770);break;default:console.error("THREE.WebGLState: Invalid blending: ",t)}else switch(t){case y:e.blendFuncSeparate(770,771,1,771);break;case x:e.blendFunc(770,1);break;case b:e.blendFunc(0,769);break;case w:e.blendFunc(0,768);break;default:console.error("THREE.WebGLState: Invalid blending: ",t)}Q=null,K=null,ee=null,te=null,Z=t,ne=c}}else Y&&(be(3042),Y=!1)}function Se(t){re!==t&&(t?e.frontFace(2304):e.frontFace(2305),re=t)}function Te(t){t!==o?(xe(2884),t!==ie&&(t===a?e.cullFace(1029):t===s?e.cullFace(1028):e.cullFace(1032))):be(2884),ie=t}function Ae(t,n,r){t?(xe(32823),ae===n&&se===r||(e.polygonOffset(n,r),ae=n,se=r)):be(32823)}function Le(t){void 0===t&&(t=33984+ce-1),pe!==t&&(e.activeTexture(t),pe=t)}return{buffers:{color:i,depth:c,stencil:l},initAttributes:function(){for(var e=0,t=u.length;e<t;e++)u[e]=0},enableAttribute:function(e){ye(e,0)},enableAttributeAndDivisor:ye,disableUnusedAttributes:function(){for(var t=0,n=f.length;t!==n;++t)f[t]!==u[t]&&(e.disableVertexAttribArray(t),f[t]=0)},enable:xe,disable:be,useProgram:function(t){return X!==t&&(e.useProgram(t),X=t,!0)},setBlending:Ee,setMaterial:function(e,t){e.side===d?be(2884):xe(2884);var n=e.side===p;t&&(n=!n),Se(n),e.blending===y&&!1===e.transparent?Ee(v):Ee(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha),c.setFunc(e.depthFunc),c.setTest(e.depthTest),c.setMask(e.depthWrite),i.setMask(e.colorWrite);var r=e.stencilWrite;l.setTest(r),r&&(l.setMask(e.stencilWriteMask),l.setFunc(e.stencilFunc,e.stencilRef,e.stencilFuncMask),l.setOp(e.stencilFail,e.stencilZFail,e.stencilZPass)),Ae(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits)},setFlipSided:Se,setCullFace:Te,setLineWidth:function(t){t!==oe&&(le&&e.lineWidth(t),oe=t)},setPolygonOffset:Ae,setScissorTest:function(e){e?xe(3089):be(3089)},activeTexture:Le,bindTexture:function(t,n){null===pe&&Le();var r=de[pe];void 0===r&&(r={type:void 0,texture:void 0},de[pe]=r),r.type===t&&r.texture===n||(e.bindTexture(t,n||ve[t]),r.type=t,r.texture=n)},unbindTexture:function(){var t=de[pe];void 0!==t&&void 0!==t.type&&(e.bindTexture(t.type,null),t.type=void 0,t.texture=void 0)},compressedTexImage2D:function(){try{e.compressedTexImage2D.apply(e,arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texImage2D:function(){try{e.texImage2D.apply(e,arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texImage3D:function(){try{e.texImage3D.apply(e,arguments)}catch(e){console.error("THREE.WebGLState:",e)}},scissor:function(t){!1===fe.equals(t)&&(e.scissor(t.x,t.y,t.z,t.w),fe.copy(t))},viewport:function(t){!1===me.equals(t)&&(e.viewport(t.x,t.y,t.z,t.w),me.copy(t))},reset:function(){for(var t=0;t<f.length;t++)1===f[t]&&(e.disableVertexAttribArray(t),f[t]=0);g={},pe=null,de={},X=null,Z=null,re=null,ie=null,i.reset(),c.reset(),l.reset()}}}function _a(e,t,n,r,i,o,a){var s,c=i.isWebGL2,l=i.maxTextures,h=i.maxCubemapSize,u=i.maxTextureSize,p=i.maxSamples,d=new WeakMap,f="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d");function m(e,t){return f?new OffscreenCanvas(e,t):document.createElementNS("http://www.w3.org/1999/xhtml","canvas")}function g(e,t,n,r){var i=1;if((e.width>r||e.height>r)&&(i=r/Math.max(e.width,e.height)),i<1||!0===t){if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap){var o=t?Rt.floorPowerOfTwo:Math.floor,a=o(i*e.width),c=o(i*e.height);void 0===s&&(s=m(a,c));var l=n?m(a,c):s;return l.width=a,l.height=c,l.getContext("2d").drawImage(e,0,0,a,c),console.warn("THREE.WebGLRenderer: Texture has been resized from ("+e.width+"x"+e.height+") to ("+a+"x"+c+")."),l}return"data"in e&&console.warn("THREE.WebGLRenderer: Image in DataTexture is too big ("+e.width+"x"+e.height+")."),e}return e}function v(e){return Rt.isPowerOfTwo(e.width)&&Rt.isPowerOfTwo(e.height)}function y(e,t){return e.generateMipmaps&&t&&e.minFilter!==pe&&e.minFilter!==me}function x(t,n,i,o){e.generateMipmap(t),r.get(n).__maxMipLevel=Math.log(Math.max(i,o))*Math.LOG2E}function b(e,n){if(!1===c)return e;var r=e;return 6403===e&&(5126===n&&(r=33326),5131===n&&(r=33325),5121===n&&(r=33321)),6407===e&&(5126===n&&(r=34837),5131===n&&(r=34843),5121===n&&(r=32849)),6408===e&&(5126===n&&(r=34836),5131===n&&(r=34842),5121===n&&(r=32856)),33325===r||33326===r||34842===r||34836===r?t.get("EXT_color_buffer_float"):34843!==r&&34837!==r||console.warn("THREE.WebGLRenderer: Floating point textures with RGB format not supported. Please use RGBA instead."),r}function w(e){return e===pe||e===de||e===fe?9728:9729}function _(t){var n=t.target;n.removeEventListener("dispose",_),function(t){var n=r.get(t);if(void 0===n.__webglInit)return;e.deleteTexture(n.__webglTexture),r.remove(t)}(n),n.isVideoTexture&&d.delete(n),a.memory.textures--}function M(t){var n=t.target;n.removeEventListener("dispose",M),function(t){var n=r.get(t),i=r.get(t.texture);if(!t)return;void 0!==i.__webglTexture&&e.deleteTexture(i.__webglTexture);t.depthTexture&&t.depthTexture.dispose();if(t.isWebGLRenderTargetCube)for(var o=0;o<6;o++)e.deleteFramebuffer(n.__webglFramebuffer[o]),n.__webglDepthbuffer&&e.deleteRenderbuffer(n.__webglDepthbuffer[o]);else e.deleteFramebuffer(n.__webglFramebuffer),n.__webglDepthbuffer&&e.deleteRenderbuffer(n.__webglDepthbuffer);if(t.isWebGLMultiviewRenderTarget){e.deleteTexture(n.__webglColorTexture),e.deleteTexture(n.__webglDepthStencilTexture),a.memory.textures-=2;o=0;for(var s=n.__webglViewFramebuffers.length;o<s;o++)e.deleteFramebuffer(n.__webglViewFramebuffers[o])}r.remove(t.texture),r.remove(t)}(n),a.memory.textures--}var E=0;function S(e,t){var i=r.get(e);if(e.isVideoTexture&&function(e){var t=a.render.frame;d.get(e)!==t&&(d.set(e,t),e.update())}(e),e.version>0&&i.__version!==e.version){var o=e.image;if(void 0===o)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined");else{if(!1!==o.complete)return void O(i,e,t);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete")}}n.activeTexture(33984+t),n.bindTexture(3553,i.__webglTexture)}function T(t,i){if(6===t.image.length){var a=r.get(t);if(t.version>0&&a.__version!==t.version){R(a,t),n.activeTexture(33984+i),n.bindTexture(34067,a.__webglTexture),e.pixelStorei(37440,t.flipY);for(var s=t&&t.isCompressedTexture,l=t.image[0]&&t.image[0].isDataTexture,u=[],p=0;p<6;p++)u[p]=s||l?l?t.image[p].image:t.image[p]:g(t.image[p],!1,!0,h);var d,f=u[0],m=v(f)||c,w=o.convert(t.format),_=o.convert(t.type),M=b(w,_);if(C(34067,t,m),s){for(p=0;p<6;p++){d=u[p].mipmaps;for(var E=0;E<d.length;E++){var S=d[E];t.format!==Oe&&t.format!==Re?null!==w?n.compressedTexImage2D(34069+p,E,M,S.width,S.height,0,S.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):n.texImage2D(34069+p,E,M,S.width,S.height,0,w,_,S.data)}}a.__maxMipLevel=d.length-1}else{d=t.mipmaps;for(p=0;p<6;p++)if(l){n.texImage2D(34069+p,0,M,u[p].width,u[p].height,0,w,_,u[p].data);for(E=0;E<d.length;E++){var T=(S=d[E]).image[p].image;n.texImage2D(34069+p,E+1,M,T.width,T.height,0,w,_,T.data)}}else{n.texImage2D(34069+p,0,M,w,_,u[p]);for(E=0;E<d.length;E++){S=d[E];n.texImage2D(34069+p,E+1,M,w,_,S.image[p])}}a.__maxMipLevel=d.length}y(t,m)&&x(34067,t,f.width,f.height),a.__version=t.version,t.onUpdate&&t.onUpdate(t)}else n.activeTexture(33984+i),n.bindTexture(34067,a.__webglTexture)}}function A(e,t){n.activeTexture(33984+t),n.bindTexture(34067,r.get(e).__webglTexture)}var L={[le]:10497,[he]:33071,[ue]:33648},P={[pe]:9728,[de]:9984,[fe]:9986,[me]:9729,[ge]:9985,[ve]:9987};function C(n,o,a){a?(e.texParameteri(n,10242,L[o.wrapS]),e.texParameteri(n,10243,L[o.wrapT]),32879!==n&&35866!==n||e.texParameteri(n,32882,L[o.wrapR]),e.texParameteri(n,10240,P[o.magFilter]),e.texParameteri(n,10241,P[o.minFilter])):(e.texParameteri(n,10242,33071),e.texParameteri(n,10243,33071),32879!==n&&35866!==n||e.texParameteri(n,32882,33071),o.wrapS===he&&o.wrapT===he||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping."),e.texParameteri(n,10240,w(o.magFilter)),e.texParameteri(n,10241,w(o.minFilter)),o.minFilter!==pe&&o.minFilter!==me&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter."));var s=t.get("EXT_texture_filter_anisotropic");if(s){if(o.type===Ee&&null===t.get("OES_texture_float_linear"))return;if(o.type===Se&&null===(c||t.get("OES_texture_half_float_linear")))return;(o.anisotropy>1||r.get(o).__currentAnisotropy)&&(e.texParameterf(n,s.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(o.anisotropy,i.getMaxAnisotropy())),r.get(o).__currentAnisotropy=o.anisotropy)}}function R(t,n){void 0===t.__webglInit&&(t.__webglInit=!0,n.addEventListener("dispose",_),t.__webglTexture=e.createTexture(),a.memory.textures++)}function O(t,r,i){var a=3553;r.isDataTexture2DArray&&(a=35866),r.isDataTexture3D&&(a=32879),R(t,r),n.activeTexture(33984+i),n.bindTexture(a,t.__webglTexture),e.pixelStorei(37440,r.flipY),e.pixelStorei(37441,r.premultiplyAlpha),e.pixelStorei(3317,r.unpackAlignment);var s=function(e){return!c&&(e.wrapS!==he||e.wrapT!==he||e.minFilter!==pe&&e.minFilter!==me)}(r)&&!1===v(r.image),l=g(r.image,s,!1,u),h=v(l)||c,p=o.convert(r.format),d=o.convert(r.type),f=b(p,d);C(a,r,h);var m,w=r.mipmaps;if(r.isDepthTexture){if(f=6402,r.type===Ee){if(!1===c)throw new Error("Float Depth Texture only supported in WebGL2.0");f=36012}else c&&(f=33189);r.format===ze&&6402===f&&r.type!==we&&r.type!==Me&&(console.warn("THREE.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),r.type=we,d=o.convert(r.type)),r.format===ke&&(f=34041,r.type!==Pe&&(console.warn("THREE.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),r.type=Pe,d=o.convert(r.type))),n.texImage2D(3553,0,f,l.width,l.height,0,p,d,null)}else if(r.isDataTexture)if(w.length>0&&h){for(var _=0,M=w.length;_<M;_++)m=w[_],n.texImage2D(3553,_,f,m.width,m.height,0,p,d,m.data);r.generateMipmaps=!1,t.__maxMipLevel=w.length-1}else n.texImage2D(3553,0,f,l.width,l.height,0,p,d,l.data),t.__maxMipLevel=0;else if(r.isCompressedTexture){for(_=0,M=w.length;_<M;_++)m=w[_],r.format!==Oe&&r.format!==Re?null!==p?n.compressedTexImage2D(3553,_,f,m.width,m.height,0,m.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):n.texImage2D(3553,_,f,m.width,m.height,0,p,d,m.data);t.__maxMipLevel=w.length-1}else if(r.isDataTexture2DArray)n.texImage3D(35866,0,f,l.width,l.height,l.depth,0,p,d,l.data),t.__maxMipLevel=0;else if(r.isDataTexture3D)n.texImage3D(32879,0,f,l.width,l.height,l.depth,0,p,d,l.data),t.__maxMipLevel=0;else if(w.length>0&&h){for(_=0,M=w.length;_<M;_++)m=w[_],n.texImage2D(3553,_,f,p,d,m);r.generateMipmaps=!1,t.__maxMipLevel=w.length-1}else n.texImage2D(3553,0,f,p,d,l),t.__maxMipLevel=0;y(r,h)&&x(3553,r,l.width,l.height),t.__version=r.version,r.onUpdate&&r.onUpdate(r)}function D(t,i,a,s){var c=o.convert(i.texture.format),l=o.convert(i.texture.type),h=b(c,l);n.texImage2D(s,0,h,i.width,i.height,0,c,l,null),e.bindFramebuffer(36160,t),e.framebufferTexture2D(36160,a,s,r.get(i.texture).__webglTexture,0),e.bindFramebuffer(36160,null)}function N(t,n,r){if(e.bindRenderbuffer(36161,t),n.depthBuffer&&!n.stencilBuffer){if(r){var i=z(n);e.renderbufferStorageMultisample(36161,i,33189,n.width,n.height)}else e.renderbufferStorage(36161,33189,n.width,n.height);e.framebufferRenderbuffer(36160,36096,36161,t)}else if(n.depthBuffer&&n.stencilBuffer){if(r){i=z(n);e.renderbufferStorageMultisample(36161,i,35056,n.width,n.height)}else e.renderbufferStorage(36161,34041,n.width,n.height);e.framebufferRenderbuffer(36160,33306,36161,t)}else{var a=b(o.convert(n.texture.format),o.convert(n.texture.type));if(r){i=z(n);e.renderbufferStorageMultisample(36161,i,a,n.width,n.height)}else e.renderbufferStorage(36161,a,n.width,n.height)}e.bindRenderbuffer(36161,null)}function I(t){var n=r.get(t),i=!0===t.isWebGLRenderTargetCube;if(t.depthTexture){if(i)throw new Error("target.depthTexture not supported in Cube render targets");!function(t,n){if(n&&n.isWebGLRenderTargetCube)throw new Error("Depth Texture with cube render targets is not supported");if(e.bindFramebuffer(36160,t),!n.depthTexture||!n.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");r.get(n.depthTexture).__webglTexture&&n.depthTexture.image.width===n.width&&n.depthTexture.image.height===n.height||(n.depthTexture.image.width=n.width,n.depthTexture.image.height=n.height,n.depthTexture.needsUpdate=!0),S(n.depthTexture,0);var i=r.get(n.depthTexture).__webglTexture;if(n.depthTexture.format===ze)e.framebufferTexture2D(36160,36096,3553,i,0);else{if(n.depthTexture.format!==ke)throw new Error("Unknown depthTexture format");e.framebufferTexture2D(36160,33306,3553,i,0)}}(n.__webglFramebuffer,t)}else if(i){n.__webglDepthbuffer=[];for(var o=0;o<6;o++)e.bindFramebuffer(36160,n.__webglFramebuffer[o]),n.__webglDepthbuffer[o]=e.createRenderbuffer(),N(n.__webglDepthbuffer[o],t)}else e.bindFramebuffer(36160,n.__webglFramebuffer),n.__webglDepthbuffer=e.createRenderbuffer(),N(n.__webglDepthbuffer,t);e.bindFramebuffer(36160,null)}function z(e){return c&&e.isWebGLMultisampleRenderTarget?Math.min(p,e.samples):0}var k=!1,F=!1;this.allocateTextureUnit=function(){var e=E;return e>=l&&console.warn("THREE.WebGLTextures: Trying to use "+e+" texture units while this GPU supports only "+l),E+=1,e},this.resetTextureUnits=function(){E=0},this.setTexture2D=S,this.setTexture2DArray=function(e,t){var i=r.get(e);e.version>0&&i.__version!==e.version?O(i,e,t):(n.activeTexture(33984+t),n.bindTexture(35866,i.__webglTexture))},this.setTexture3D=function(e,t){var i=r.get(e);e.version>0&&i.__version!==e.version?O(i,e,t):(n.activeTexture(33984+t),n.bindTexture(32879,i.__webglTexture))},this.setTextureCube=T,this.setTextureCubeDynamic=A,this.setupRenderTarget=function(i){var s=r.get(i),l=r.get(i.texture);i.addEventListener("dispose",M),l.__webglTexture=e.createTexture(),a.memory.textures++;var h=!0===i.isWebGLRenderTargetCube,u=!0===i.isWebGLMultisampleRenderTarget,p=!0===i.isWebGLMultiviewRenderTarget,d=v(i)||c;if(h){s.__webglFramebuffer=[];for(var f=0;f<6;f++)s.__webglFramebuffer[f]=e.createFramebuffer()}else if(s.__webglFramebuffer=e.createFramebuffer(),u)if(c){s.__webglMultisampledFramebuffer=e.createFramebuffer(),s.__webglColorRenderbuffer=e.createRenderbuffer(),e.bindRenderbuffer(36161,s.__webglColorRenderbuffer);var m=b(o.convert(i.texture.format),o.convert(i.texture.type)),g=z(i);e.renderbufferStorageMultisample(36161,g,m,i.width,i.height),e.bindFramebuffer(36160,s.__webglMultisampledFramebuffer),e.framebufferRenderbuffer(36160,36064,36161,s.__webglColorRenderbuffer),e.bindRenderbuffer(36161,null),i.depthBuffer&&(s.__webglDepthRenderbuffer=e.createRenderbuffer(),N(s.__webglDepthRenderbuffer,i,!0)),e.bindFramebuffer(36160,null)}else console.warn("THREE.WebGLRenderer: WebGLMultisampleRenderTarget can only be used with WebGL2.");else if(p){var w=i.width,_=i.height,E=i.numViews;e.bindFramebuffer(36160,s.__webglFramebuffer);var S=t.get("OVR_multiview2");a.memory.textures+=2;var T=e.createTexture();e.bindTexture(35866,T),e.texParameteri(35866,10240,9728),e.texParameteri(35866,10241,9728),e.texImage3D(35866,0,32856,w,_,E,0,6408,5121,null),S.framebufferTextureMultiviewOVR(36160,36064,T,0,0,E);var A=e.createTexture();e.bindTexture(35866,A),e.texParameteri(35866,10240,9728),e.texParameteri(35866,10241,9728),e.texImage3D(35866,0,35056,w,_,E,0,34041,34042,null),S.framebufferTextureMultiviewOVR(36160,33306,A,0,0,E);var L=new Array(E);for(f=0;f<E;++f)L[f]=e.createFramebuffer(),e.bindFramebuffer(36160,L[f]),e.framebufferTextureLayer(36160,36064,T,0,f);s.__webglColorTexture=T,s.__webglDepthStencilTexture=A,s.__webglViewFramebuffers=L,e.bindFramebuffer(36160,null),e.bindTexture(35866,null)}if(h){n.bindTexture(34067,l.__webglTexture),C(34067,i.texture,d);for(f=0;f<6;f++)D(s.__webglFramebuffer[f],i,36064,34069+f);y(i.texture,d)&&x(34067,i.texture,i.width,i.height),n.bindTexture(34067,null)}else p||(n.bindTexture(3553,l.__webglTexture),C(3553,i.texture,d),D(s.__webglFramebuffer,i,36064,3553),y(i.texture,d)&&x(3553,i.texture,i.width,i.height),n.bindTexture(3553,null));i.depthBuffer&&I(i)},this.updateRenderTargetMipmap=function(e){var t=e.texture;if(y(t,v(e)||c)){var i=e.isWebGLRenderTargetCube?34067:3553,o=r.get(t).__webglTexture;n.bindTexture(i,o),x(i,t,e.width,e.height),n.bindTexture(i,null)}},this.updateMultisampleRenderTarget=function(t){if(t.isWebGLMultisampleRenderTarget)if(c){var n=r.get(t);e.bindFramebuffer(36008,n.__webglMultisampledFramebuffer),e.bindFramebuffer(36009,n.__webglFramebuffer);var i=t.width,o=t.height,a=16384;t.depthBuffer&&(a|=256),t.stencilBuffer&&(a|=1024),e.blitFramebuffer(0,0,i,o,0,0,i,o,a,9728)}else console.warn("THREE.WebGLRenderer: WebGLMultisampleRenderTarget can only be used with WebGL2.")},this.safeSetTexture2D=function(e,t){e&&e.isWebGLRenderTarget&&(!1===k&&(console.warn("THREE.WebGLTextures.safeSetTexture2D: don't use render targets as textures. Use their .texture property instead."),k=!0),e=e.texture),S(e,t)},this.safeSetTextureCube=function(e,t){e&&e.isWebGLRenderTargetCube&&(!1===F&&(console.warn("THREE.WebGLTextures.safeSetTextureCube: don't use cube render targets as textures. Use their .texture property instead."),F=!0),e=e.texture),e&&e.isCubeTexture||Array.isArray(e.image)&&6===e.image.length?T(e,t):A(e,t)}}function Ma(e,t,n){var r=n.isWebGL2;return{convert:function(e){var n;if(e===ye)return 5121;if(e===Te)return 32819;if(e===Ae)return 32820;if(e===Le)return 33635;if(e===xe)return 5120;if(e===be)return 5122;if(e===we)return 5123;if(e===_e)return 5124;if(e===Me)return 5125;if(e===Ee)return 5126;if(e===Se)return r?5131:null!==(n=t.get("OES_texture_half_float"))?n.HALF_FLOAT_OES:null;if(e===Ce)return 6406;if(e===Re)return 6407;if(e===Oe)return 6408;if(e===De)return 6409;if(e===Ne)return 6410;if(e===ze)return 6402;if(e===ke)return 34041;if(e===Fe)return 6403;if(e===Ue||e===Be||e===je||e===He){if(null===(n=t.get("WEBGL_compressed_texture_s3tc")))return null;if(e===Ue)return n.COMPRESSED_RGB_S3TC_DXT1_EXT;if(e===Be)return n.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(e===je)return n.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(e===He)return n.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(e===Ge||e===Ve||e===We||e===qe){if(null===(n=t.get("WEBGL_compressed_texture_pvrtc")))return null;if(e===Ge)return n.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(e===Ve)return n.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(e===We)return n.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(e===qe)return n.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}return e===Xe?null!==(n=t.get("WEBGL_compressed_texture_etc1"))?n.COMPRESSED_RGB_ETC1_WEBGL:null:e===Ye||e===Ze||e===Je||e===Qe||e===Ke||e===$e||e===et||e===tt||e===nt||e===rt||e===it||e===ot||e===at||e===st?null!==(n=t.get("WEBGL_compressed_texture_astc"))?e:null:e===Pe?r?34042:null!==(n=t.get("WEBGL_depth_texture"))?n.UNSIGNED_INT_24_8_WEBGL:null:void 0}}}function Ea(e,t,n,r){Vt.call(this,e,t,r),this.depthBuffer=!1,this.stencilBuffer=!1,this.numViews=n}function Sa(e,t){var n,r,i,o,a,s,c,l=2,h=e.extensions,u=e.properties,p=0;function d(e){return e.isArrayCamera?e.cameras:(a[0]=e,a)}this.isAvailable=function(){if(void 0===c){var e=h.get("OVR_multiview2");if(c=null!==e&&!1===t.getContextAttributes().antialias){p=t.getParameter(e.MAX_VIEWS_OVR),n=new Ea(0,0,l),s=new Ot,o=[],i=[],a=[];for(var r=0;r<p;r++)o[r]=new $t,i[r]=new Ut}}return c},this.attachCamera=function(t){!1!==function(e){if(void 0===e.isArrayCamera)return!0;var t=e.cameras;if(t.length>p)return!1;for(var n=1,r=t.length;n<r;n++)if(t[0].viewport.z!==t[n].viewport.z||t[0].viewport.w!==t[n].viewport.w)return!1;return!0}(t)&&(r=e.getRenderTarget(),function(t){if(r?s.set(r.width,r.height):e.getDrawingBufferSize(s),t.isArrayCamera){var i=t.cameras[0].viewport;n.setSize(i.z,i.w),n.setNumViews(t.cameras.length)}else n.setSize(s.x,s.y),n.setNumViews(l)}(t),e.setRenderTarget(n))},this.detachCamera=function(i){n===e.getRenderTarget()&&(e.setRenderTarget(r),function(e){var r=n,i=r.numViews,o=u.get(r).__webglViewFramebuffers,a=r.width,c=r.height;if(e.isArrayCamera)for(var l=0;l<i;l++){var h=e.cameras[l].viewport,p=h.x,d=h.y,f=p+h.z,m=d+h.w;t.bindFramebuffer(36008,o[l]),t.blitFramebuffer(0,0,a,c,p,d,f,m,16384,9728)}else t.bindFramebuffer(36008,o[0]),t.blitFramebuffer(0,0,a,c,0,0,s.x,s.y,16384,9728)}(i))},this.updateCameraProjectionMatricesUniform=function(e,n){for(var r=d(e),i=0;i<r.length;i++)o[i].copy(r[i].projectionMatrix);n.setValue(t,"projectionMatrices",o)},this.updateCameraViewMatricesUniform=function(e,n){for(var r=d(e),i=0;i<r.length;i++)o[i].copy(r[i].matrixWorldInverse);n.setValue(t,"viewMatrices",o)},this.updateObjectMatricesUniforms=function(e,n,r){for(var a=d(n),s=0;s<a.length;s++)o[s].multiplyMatrices(a[s].matrixWorldInverse,e.matrixWorld),i[s].getNormalMatrix(o[s]);r.setValue(t,"modelViewMatrices",o),r.setValue(t,"normalMatrices",i)}}function Ta(){yn.call(this),this.type="Group"}function Aa(e){gi.call(this),this.cameras=e||[]}Ea.prototype=Object.assign(Object.create(Vt.prototype),{constructor:Ea,isWebGLMultiviewRenderTarget:!0,copy:function(e){return Vt.prototype.copy.call(this,e),this.numViews=e.numViews,this},setNumViews:function(e){return this.numViews!==e&&(this.numViews=e,this.dispose()),this}}),Ta.prototype=Object.assign(Object.create(yn.prototype),{constructor:Ta,isGroup:!0}),Aa.prototype=Object.assign(Object.create(gi.prototype),{constructor:Aa,isArrayCamera:!0});var La,Pa=new zt,Ca=new zt;function Ra(e,t,n){Pa.setFromMatrixPosition(t.matrixWorld),Ca.setFromMatrixPosition(n.matrixWorld);var r=Pa.distanceTo(Ca),i=t.projectionMatrix.elements,o=n.projectionMatrix.elements,a=i[14]/(i[10]-1),s=i[14]/(i[10]+1),c=(i[9]+1)/i[5],l=(i[9]-1)/i[5],h=(i[8]-1)/i[0],u=(o[8]+1)/o[0],p=a*h,d=a*u,f=r/(-h+u),m=f*-h;t.matrixWorld.decompose(e.position,e.quaternion,e.scale),e.translateX(m),e.translateZ(f),e.matrixWorld.compose(e.position,e.quaternion,e.scale),e.matrixWorldInverse.getInverse(e.matrixWorld);var g=a+f,v=s+f,y=p-m,x=d+(r-m),b=c*s/v*g,w=l*s/v*g;e.projectionMatrix.makePerspective(y,x,b,w,g,v)}function Oa(e){var t,n,r=this,i=null,o=null,a=null,s=[],c=new $t,l=new $t,h=1,u="local-floor";"undefined"!=typeof window&&"VRFrameData"in window&&(o=new window.VRFrameData,window.addEventListener("vrdisplaypresentchange",w,!1));var p=new $t,d=new Dt,f=new zt,m=new gi;m.viewport=new Gt,m.layers.enable(1);var g=new gi;g.viewport=new Gt,g.layers.enable(2);var v=new Aa([m,g]);function y(){return null!==i&&!0===i.isPresenting}v.layers.enable(1),v.layers.enable(2);var x,b=new Ot;function w(){if(y()){var o=i.getEyeParameters("left");t=2*o.renderWidth*h,n=o.renderHeight*h,x=e.getPixelRatio(),e.getSize(b),e.setDrawingBufferSize(t,n,1),m.viewport.set(0,0,t/2,n),g.viewport.set(t/2,0,t/2,n),S.start(),r.dispatchEvent({type:"sessionstart"})}else r.enabled&&e.setDrawingBufferSize(b.width,b.height,x),S.stop(),r.dispatchEvent({type:"sessionend"})}var _=[];function M(e){for(var t=navigator.getGamepads&&navigator.getGamepads(),n=0,r=t.length;n<r;n++){var i=t[n];if(i&&("Daydream Controller"===i.id||"Gear VR Controller"===i.id||"Oculus Go Controller"===i.id||"OpenVR Gamepad"===i.id||i.id.startsWith("Oculus Touch")||i.id.startsWith("HTC Vive Focus")||i.id.startsWith("Spatial Controller"))){var o=i.hand;if(0===e&&(""===o||"right"===o))return i;if(1===e&&"left"===o)return i}}}function E(e,r){null!==r&&4===r.length&&e.set(r[0]*t,r[1]*n,r[2]*t,r[3]*n)}this.enabled=!1,this.getController=function(e){var t=s[e];return void 0===t&&((t=new Ta).matrixAutoUpdate=!1,t.visible=!1,s[e]=t),t},this.getDevice=function(){return i},this.setDevice=function(e){void 0!==e&&(i=e),S.setContext(e)},this.setFramebufferScaleFactor=function(e){h=e},this.setReferenceSpaceType=function(e){u=e},this.setPoseTarget=function(e){void 0!==e&&(a=e)},this.getCamera=function(e){var t="local-floor"===u?1.6:0;if(!1===y())return e.position.set(0,t,0),e.rotation.set(0,0,0),e;if(i.depthNear=e.near,i.depthFar=e.far,i.getFrameData(o),"local-floor"===u){var n=i.stageParameters;n?c.fromArray(n.sittingToStandingTransform):c.makeTranslation(0,t,0)}var r=o.pose,h=null!==a?a:e;h.matrix.copy(c),h.matrix.decompose(h.position,h.quaternion,h.scale),null!==r.orientation&&(d.fromArray(r.orientation),h.quaternion.multiply(d)),null!==r.position&&(d.setFromRotationMatrix(c),f.fromArray(r.position),f.applyQuaternion(d),h.position.add(f)),h.updateMatrixWorld(),m.near=e.near,g.near=e.near,m.far=e.far,g.far=e.far,m.matrixWorldInverse.fromArray(o.leftViewMatrix),g.matrixWorldInverse.fromArray(o.rightViewMatrix),l.getInverse(c),"local-floor"===u&&(m.matrixWorldInverse.multiply(l),g.matrixWorldInverse.multiply(l));var x=h.parent;null!==x&&(p.getInverse(x.matrixWorld),m.matrixWorldInverse.multiply(p),g.matrixWorldInverse.multiply(p)),m.matrixWorld.getInverse(m.matrixWorldInverse),g.matrixWorld.getInverse(g.matrixWorldInverse),m.projectionMatrix.fromArray(o.leftProjectionMatrix),g.projectionMatrix.fromArray(o.rightProjectionMatrix),Ra(v,m,g);var b=i.getLayers();if(b.length){var w=b[0];E(m.viewport,w.leftBounds),E(g.viewport,w.rightBounds)}return function(){for(var e=0;e<s.length;e++){var t=s[e],n=M(e);if(void 0!==n&&void 0!==n.pose){if(null===n.pose)return;var r=n.pose;!1===r.hasPosition&&t.position.set(.2,-.6,-.05),null!==r.position&&t.position.fromArray(r.position),null!==r.orientation&&t.quaternion.fromArray(r.orientation),t.matrix.compose(t.position,t.quaternion,t.scale),t.matrix.premultiply(c),t.matrix.decompose(t.position,t.quaternion,t.scale),t.matrixWorldNeedsUpdate=!0,t.visible=!0;var i="Daydream Controller"===n.id?0:1;void 0===_[e]&&(_[e]=!1),_[e]!==n.buttons[i].pressed&&(_[e]=n.buttons[i].pressed,!0===_[e]?t.dispatchEvent({type:"selectstart"}):(t.dispatchEvent({type:"selectend"}),t.dispatchEvent({type:"select"})))}else t.visible=!1}}(),v},this.getStandingMatrix=function(){return c},this.isPresenting=y;var S=new Li;this.setAnimationLoop=function(e){S.setAnimationLoop(e),y()&&S.start()},this.submitFrame=function(){y()&&i.submitFrame()},this.dispose=function(){"undefined"!=typeof window&&window.removeEventListener("vrdisplaypresentchange",w)},this.setFrameOfReferenceType=function(){console.warn("THREE.WebVRManager: setFrameOfReferenceType() has been deprecated.")}}function Da(e,t){var n=this,r=null,i=null,o="local-floor",a=null,s=[],c=[];function l(){return null!==r&&null!==i}var h=new gi;h.layers.enable(1),h.viewport=new Gt;var u=new gi;u.layers.enable(2),u.viewport=new Gt;var p=new Aa([h,u]);function d(e){for(var t=0;t<s.length;t++)c[t]===e.inputSource&&s[t].dispatchEvent({type:e.type})}function f(){e.setFramebuffer(null),e.setRenderTarget(e.getRenderTarget()),b.stop(),n.dispatchEvent({type:"sessionend"})}function m(e){i=e,b.setContext(r),b.start(),n.dispatchEvent({type:"sessionstart"})}function g(){for(var e=0;e<s.length;e++)c[e]=v(e)}function v(e){for(var t=r.inputSources,n=0;n<t.length;n++){var i=t[n],o=i.handedness;if(0===e&&("none"===o||"right"===o))return i;if(1===e&&"left"===o)return i}}function y(e,t){null===t?e.matrixWorld.copy(e.matrix):e.matrixWorld.multiplyMatrices(t.matrixWorld,e.matrix),e.matrixWorldInverse.getInverse(e.matrixWorld)}p.layers.enable(1),p.layers.enable(2),this.enabled=!1,this.getController=function(e){var t=s[e];return void 0===t&&((t=new Ta).matrixAutoUpdate=!1,t.visible=!1,s[e]=t),t},this.setFramebufferScaleFactor=function(){},this.setReferenceSpaceType=function(e){o=e},this.getSession=function(){return r},this.setSession=function(e){null!==(r=e)&&(r.addEventListener("select",d),r.addEventListener("selectstart",d),r.addEventListener("selectend",d),r.addEventListener("end",f),r.updateRenderState({baseLayer:new XRWebGLLayer(r,t)}),r.requestReferenceSpace(o).then(m),r.addEventListener("inputsourceschange",g),g())},this.getCamera=function(e){if(l()){var t=e.parent,n=p.cameras;y(p,t);for(var r=0;r<n.length;r++)y(n[r],t);e.matrixWorld.copy(p.matrixWorld);for(var i=e.children,o=(r=0,i.length);r<o;r++)i[r].updateMatrixWorld(!0);return Ra(p,h,u),p}return e},this.isPresenting=l;var x=null;var b=new Li;b.setAnimationLoop((function(t,n){if(null!==(a=n.getViewerPose(i))){var o=a.views,l=r.renderState.baseLayer;e.setFramebuffer(l.framebuffer);for(var h=0;h<o.length;h++){var u=o[h],d=l.getViewport(u),f=u.transform.inverse.matrix,m=p.cameras[h];m.matrix.fromArray(f).getInverse(m.matrix),m.projectionMatrix.fromArray(u.projectionMatrix),m.viewport.set(d.x,d.y,d.width,d.height),0===h&&p.matrix.copy(m.matrix)}}for(h=0;h<s.length;h++){var g=s[h],v=c[h];if(v){var y=n.getPose(v.targetRaySpace,i);if(null!==y){g.matrix.fromArray(y.transform.matrix),g.matrix.decompose(g.position,g.rotation,g.scale),g.visible=!0;continue}}g.visible=!1}x&&x(t)})),this.setAnimationLoop=function(e){x=e},this.dispose=function(){},this.getStandingMatrix=function(){return console.warn("THREE.WebXRManager: getStandingMatrix() is no longer needed."),new $t},this.getDevice=function(){console.warn("THREE.WebXRManager: getDevice() has been deprecated.")},this.setDevice=function(){console.warn("THREE.WebXRManager: setDevice() has been deprecated.")},this.setFrameOfReferenceType=function(){console.warn("THREE.WebXRManager: setFrameOfReferenceType() has been deprecated.")},this.submitFrame=function(){}}function Na(e){var t=void 0!==(e=e||{}).canvas?e.canvas:document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),n=void 0!==e.context?e.context:null,r=void 0!==e.alpha&&e.alpha,i=void 0===e.depth||e.depth,o=void 0===e.stencil||e.stencil,a=void 0!==e.antialias&&e.antialias,s=void 0===e.premultipliedAlpha||e.premultipliedAlpha,c=void 0!==e.preserveDrawingBuffer&&e.preserveDrawingBuffer,l=void 0!==e.powerPreference?e.powerPreference:"default",h=void 0!==e.failIfMajorPerformanceCaveat&&e.failIfMajorPerformanceCaveat,u=null,d=null;this.domElement=t,this.debug={checkShaderErrors:!0},this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.gammaInput=!1,this.gammaOutput=!1,this.physicallyCorrectLights=!1,this.toneMapping=Q,this.toneMappingExposure=1,this.toneMappingWhitePoint=1,this.maxMorphTargets=8,this.maxMorphNormals=4;var f,m,g,v,y,x,b,w,_,M,E,S,T,A,L,P,C,R,O=this,D=!1,N=null,I=0,z=0,k=null,F=null,U=-1,B={geometry:null,program:null,wireframe:!1},j=null,H=null,G=new Gt,V=new Gt,W=null,q=t.width,X=t.height,Y=1,Z=new Gt(0,0,q,X),J=new Gt(0,0,q,X),K=!1,$=new Ei,ee=new Ii,te=!1,ne=!1,re=new $t,ie=new zt;function oe(){return null===k?Y:1}try{var ae={alpha:r,depth:i,stencil:o,antialias:a,premultipliedAlpha:s,preserveDrawingBuffer:c,powerPreference:l,failIfMajorPerformanceCaveat:h,xrCompatible:!0};if(t.addEventListener("webglcontextlost",ue,!1),t.addEventListener("webglcontextrestored",pe,!1),null===(f=n||t.getContext("webgl",ae)||t.getContext("experimental-webgl",ae)))throw null!==t.getContext("webgl")?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.");void 0===f.getShaderPrecisionFormat&&(f.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}})}catch(e){throw console.error("THREE.WebGLRenderer: "+e.message),e}function se(){m=new zi(f),!1===(g=new Ni(f,m,e)).isWebGL2&&(m.get("WEBGL_depth_texture"),m.get("OES_texture_float"),m.get("OES_texture_half_float"),m.get("OES_texture_half_float_linear"),m.get("OES_standard_derivatives"),m.get("OES_element_index_uint"),m.get("ANGLE_instanced_arrays")),m.get("OES_texture_float_linear"),R=new Ma(f,m,g),(v=new wa(f,m,g)).scissor(V.copy(J).multiplyScalar(Y).floor()),v.viewport(G.copy(Z).multiplyScalar(Y).floor()),y=new Ui(f),x=new oa,b=new _a(f,m,v,x,g,R,y),w=new Pi(f),_=new ki(f,w,y),M=new Hi(f,_,w,y),L=new ji(f),E=new ia(O,m,g),S=new la,T=new ma,A=new Oi(O,v,M,s),P=new Di(f,m,y,g),C=new Fi(f,m,y,g),y.programs=E.programs,O.capabilities=g,O.extensions=m,O.properties=x,O.renderLists=S,O.state=v,O.info=y}se();var ce="undefined"!=typeof navigator&&"xr"in navigator&&"isSessionSupported"in navigator.xr?new Da(O,f):new Oa(O);this.vr=ce;var le=new Sa(O,f),he=new ba(O,M,g.maxTextureSize);function ue(e){e.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),D=!0}function pe(){console.log("THREE.WebGLRenderer: Context Restored."),D=!1,se()}function de(e){var t=e.target;t.removeEventListener("dispose",de),function(e){fe(e),x.remove(e)}(t)}function fe(e){var t=x.get(e).program;e.program=void 0,void 0!==t&&E.releaseProgram(t)}this.shadowMap=he,this.getContext=function(){return f},this.getContextAttributes=function(){return f.getContextAttributes()},this.forceContextLoss=function(){var e=m.get("WEBGL_lose_context");e&&e.loseContext()},this.forceContextRestore=function(){var e=m.get("WEBGL_lose_context");e&&e.restoreContext()},this.getPixelRatio=function(){return Y},this.setPixelRatio=function(e){void 0!==e&&(Y=e,this.setSize(q,X,!1))},this.getSize=function(e){return void 0===e&&(console.warn("WebGLRenderer: .getsize() now requires a Vector2 as an argument"),e=new Ot),e.set(q,X)},this.setSize=function(e,n,r){ce.isPresenting()?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(q=e,X=n,t.width=Math.floor(e*Y),t.height=Math.floor(n*Y),!1!==r&&(t.style.width=e+"px",t.style.height=n+"px"),this.setViewport(0,0,e,n))},this.getDrawingBufferSize=function(e){return void 0===e&&(console.warn("WebGLRenderer: .getdrawingBufferSize() now requires a Vector2 as an argument"),e=new Ot),e.set(q*Y,X*Y).floor()},this.setDrawingBufferSize=function(e,n,r){q=e,X=n,Y=r,t.width=Math.floor(e*r),t.height=Math.floor(n*r),this.setViewport(0,0,e,n)},this.getCurrentViewport=function(e){return void 0===e&&(console.warn("WebGLRenderer: .getCurrentViewport() now requires a Vector4 as an argument"),e=new Gt),e.copy(G)},this.getViewport=function(e){return e.copy(Z)},this.setViewport=function(e,t,n,r){e.isVector4?Z.set(e.x,e.y,e.z,e.w):Z.set(e,t,n,r),v.viewport(G.copy(Z).multiplyScalar(Y).floor())},this.getScissor=function(e){return e.copy(J)},this.setScissor=function(e,t,n,r){e.isVector4?J.set(e.x,e.y,e.z,e.w):J.set(e,t,n,r),v.scissor(V.copy(J).multiplyScalar(Y).floor())},this.getScissorTest=function(){return K},this.setScissorTest=function(e){v.setScissorTest(K=e)},this.getClearColor=function(){return A.getClearColor()},this.setClearColor=function(){A.setClearColor.apply(A,arguments)},this.getClearAlpha=function(){return A.getClearAlpha()},this.setClearAlpha=function(){A.setClearAlpha.apply(A,arguments)},this.clear=function(e,t,n){var r=0;(void 0===e||e)&&(r|=16384),(void 0===t||t)&&(r|=256),(void 0===n||n)&&(r|=1024),f.clear(r)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.dispose=function(){t.removeEventListener("webglcontextlost",ue,!1),t.removeEventListener("webglcontextrestored",pe,!1),S.dispose(),T.dispose(),x.dispose(),M.dispose(),ce.dispose(),ge.stop()},this.renderBufferImmediate=function(e,t){v.initAttributes();var n=x.get(e);e.hasPositions&&!n.position&&(n.position=f.createBuffer()),e.hasNormals&&!n.normal&&(n.normal=f.createBuffer()),e.hasUvs&&!n.uv&&(n.uv=f.createBuffer()),e.hasColors&&!n.color&&(n.color=f.createBuffer());var r=t.getAttributes();e.hasPositions&&(f.bindBuffer(34962,n.position),f.bufferData(34962,e.positionArray,35048),v.enableAttribute(r.position),f.vertexAttribPointer(r.position,3,5126,!1,0,0)),e.hasNormals&&(f.bindBuffer(34962,n.normal),f.bufferData(34962,e.normalArray,35048),v.enableAttribute(r.normal),f.vertexAttribPointer(r.normal,3,5126,!1,0,0)),e.hasUvs&&(f.bindBuffer(34962,n.uv),f.bufferData(34962,e.uvArray,35048),v.enableAttribute(r.uv),f.vertexAttribPointer(r.uv,2,5126,!1,0,0)),e.hasColors&&(f.bindBuffer(34962,n.color),f.bufferData(34962,e.colorArray,35048),v.enableAttribute(r.color),f.vertexAttribPointer(r.color,3,5126,!1,0,0)),v.disableUnusedAttributes(),f.drawArrays(4,0,e.count),e.count=0},this.renderBufferDirect=function(e,t,n,r,i,o){var a=i.isMesh&&i.matrixWorld.determinant()<0;v.setMaterial(r,a);var s=_e(e,t,r,i),c=!1;B.geometry===n.id&&B.program===s.id&&B.wireframe===(!0===r.wireframe)||(B.geometry=n.id,B.program=s.id,B.wireframe=!0===r.wireframe,c=!0),i.morphTargetInfluences&&(L.update(i,n,r,s),c=!0);var l,h=n.index,u=n.attributes.position,p=1;!0===r.wireframe&&(h=_.getWireframeAttribute(n),p=2);var d=P;null!==h&&(l=w.get(h),(d=C).setIndex(l)),c&&(!function(e,t,n,r){if(!1===g.isWebGL2&&(e.isInstancedMesh||t.isInstancedBufferGeometry)&&null===m.get("ANGLE_instanced_arrays"))return;v.initAttributes();var i=t.attributes,o=r.getAttributes(),a=n.defaultAttributeValues;for(var s in o){var c=o[s];if(c>=0){var l=i[s];if(void 0!==l){var h=l.normalized,u=l.itemSize;if(void 0===(M=w.get(l)))continue;var p=M.buffer,d=M.type,y=M.bytesPerElement;if(l.isInterleavedBufferAttribute){var x=l.data,b=x.stride,_=l.offset;x&&x.isInstancedInterleavedBuffer?(v.enableAttributeAndDivisor(c,x.meshPerAttribute),void 0===t.maxInstancedCount&&(t.maxInstancedCount=x.meshPerAttribute*x.count)):v.enableAttribute(c),f.bindBuffer(34962,p),f.vertexAttribPointer(c,u,d,h,b*y,_*y)}else l.isInstancedBufferAttribute?(v.enableAttributeAndDivisor(c,l.meshPerAttribute),void 0===t.maxInstancedCount&&(t.maxInstancedCount=l.meshPerAttribute*l.count)):v.enableAttribute(c),f.bindBuffer(34962,p),f.vertexAttribPointer(c,u,d,h,0,0)}else if("instanceMatrix"===s){var M;if(void 0===(M=w.get(e.instanceMatrix)))continue;p=M.buffer,d=M.type;v.enableAttributeAndDivisor(c+0,1),v.enableAttributeAndDivisor(c+1,1),v.enableAttributeAndDivisor(c+2,1),v.enableAttributeAndDivisor(c+3,1),f.bindBuffer(34962,p),f.vertexAttribPointer(c+0,4,d,!1,64,0),f.vertexAttribPointer(c+1,4,d,!1,64,16),f.vertexAttribPointer(c+2,4,d,!1,64,32),f.vertexAttribPointer(c+3,4,d,!1,64,48)}else if(void 0!==a){var E=a[s];if(void 0!==E)switch(E.length){case 2:f.vertexAttrib2fv(c,E);break;case 3:f.vertexAttrib3fv(c,E);break;case 4:f.vertexAttrib4fv(c,E);break;default:f.vertexAttrib1fv(c,E)}}}}v.disableUnusedAttributes()}(i,n,r,s),null!==h&&f.bindBuffer(34963,l.buffer));var y=1/0;null!==h?y=h.count:void 0!==u&&(y=u.count);var x=n.drawRange.start*p,b=n.drawRange.count*p,M=null!==o?o.start*p:0,E=null!==o?o.count*p:1/0,S=Math.max(x,M),T=Math.min(y,x+b,M+E)-1,A=Math.max(0,T-S+1);if(0!==A){if(i.isMesh)if(!0===r.wireframe)v.setLineWidth(r.wireframeLinewidth*oe()),d.setMode(1);else switch(i.drawMode){case ht:d.setMode(4);break;case ut:d.setMode(5);break;case pt:d.setMode(6)}else if(i.isLine){var R=r.linewidth;void 0===R&&(R=1),v.setLineWidth(R*oe()),i.isLineSegments?d.setMode(1):i.isLineLoop?d.setMode(2):d.setMode(3)}else i.isPoints?d.setMode(0):i.isSprite&&d.setMode(4);i.isInstancedMesh?d.renderInstances(n,S,A,i.count):n.isInstancedBufferGeometry?d.renderInstances(n,S,A,n.maxInstancedCount):d.render(S,A)}},this.compile=function(e,t){(d=T.get(e,t)).init(),e.traverse((function(e){e.isLight&&(d.pushLight(e),e.castShadow&&d.pushShadow(e))})),d.setupLights(t),e.traverse((function(t){if(t.material)if(Array.isArray(t.material))for(var n=0;n<t.material.length;n++)we(t.material[n],e.fog,t);else we(t.material,e.fog,t)}))};var me=null;var ge=new Li;function ve(e,t,n,r){if(!1!==e.visible){if(e.layers.test(t.layers))if(e.isGroup)n=e.renderOrder;else if(e.isLOD)!0===e.autoUpdate&&e.update(t);else if(e.isLight)d.pushLight(e),e.castShadow&&d.pushShadow(e);else if(e.isSprite){if(!e.frustumCulled||$.intersectsSprite(e)){r&&ie.setFromMatrixPosition(e.matrixWorld).applyMatrix4(re);var i=M.update(e);(o=e.material).visible&&u.push(e,i,o,n,ie.z,null)}}else if(e.isImmediateRenderObject)r&&ie.setFromMatrixPosition(e.matrixWorld).applyMatrix4(re),u.push(e,null,e.material,n,ie.z,null);else if((e.isMesh||e.isLine||e.isPoints)&&(e.isSkinnedMesh&&e.skeleton.frame!==y.render.frame&&(e.skeleton.update(),e.skeleton.frame=y.render.frame),!e.frustumCulled||$.intersectsObject(e))){r&&ie.setFromMatrixPosition(e.matrixWorld).applyMatrix4(re);i=M.update(e);var o=e.material;if(Array.isArray(o))for(var a=i.groups,s=0,c=a.length;s<c;s++){var l=a[s],h=o[l.materialIndex];h&&h.visible&&u.push(e,i,h,n,ie.z,l)}else o.visible&&u.push(e,i,o,n,ie.z,null)}var p=e.children;for(s=0,c=p.length;s<c;s++)ve(p[s],t,n,r)}}function xe(e,t,n,r){for(var i=0,o=e.length;i<o;i++){var a=e[i],s=a.object,c=a.geometry,l=void 0===r?a.material:r,h=a.group;if(n.isArrayCamera)if(H=n,ce.enabled&&le.isAvailable())be(s,t,n,c,l,h);else for(var u=n.cameras,p=0,f=u.length;p<f;p++){var m=u[p];s.layers.test(m.layers)&&(v.viewport(G.copy(m.viewport)),d.setupLights(m),be(s,t,m,c,l,h))}else H=null,be(s,t,n,c,l,h)}}function be(e,t,n,r,i,o){if(e.onBeforeRender(O,t,n,r,i,o),d=T.get(t,H||n),e.modelViewMatrix.multiplyMatrices(n.matrixWorldInverse,e.matrixWorld),e.normalMatrix.getNormalMatrix(e.modelViewMatrix),e.isImmediateRenderObject){v.setMaterial(i);var a=_e(n,t.fog,i,e);B.geometry=null,B.program=null,B.wireframe=!1,function(e,t){e.render((function(e){O.renderBufferImmediate(e,t)}))}(e,a)}else O.renderBufferDirect(n,t.fog,r,i,e,o);e.onAfterRender(O,t,n,r,i,o),d=T.get(t,H||n)}function we(e,t,n){var r=x.get(e),i=d.state.lights,o=d.state.shadowsArray,a=i.state.version,s=E.getParameters(e,i.state,o,t,ee.numPlanes,ee.numIntersection,n),c=E.getProgramCacheKey(e,s),l=r.program,h=!0;if(void 0===l)e.addEventListener("dispose",de);else if(l.cacheKey!==c)fe(e);else if(r.lightsStateVersion!==a)r.lightsStateVersion=a,h=!1;else{if(void 0!==s.shaderID)return;h=!1}if(h){if(s.shaderID){var u=Ai[s.shaderID];r.shader={name:e.type,uniforms:li(u.uniforms),vertexShader:u.vertexShader,fragmentShader:u.fragmentShader}}else r.shader={name:e.type,uniforms:e.uniforms,vertexShader:e.vertexShader,fragmentShader:e.fragmentShader};e.onBeforeCompile(r.shader,O),c=E.getProgramCacheKey(e,s),l=E.acquireProgram(e,r.shader,s,c),r.program=l,e.program=l}var p=l.getAttributes();if(e.morphTargets){e.numSupportedMorphTargets=0;for(var f=0;f<O.maxMorphTargets;f++)p["morphTarget"+f]>=0&&e.numSupportedMorphTargets++}if(e.morphNormals){e.numSupportedMorphNormals=0;for(f=0;f<O.maxMorphNormals;f++)p["morphNormal"+f]>=0&&e.numSupportedMorphNormals++}var m=r.shader.uniforms;(e.isShaderMaterial||e.isRawShaderMaterial)&&!0!==e.clipping||(r.numClippingPlanes=ee.numPlanes,r.numIntersection=ee.numIntersection,m.clippingPlanes=ee.uniform),r.fog=t,r.needsLights=function(e){return e.isMeshLambertMaterial||e.isMeshPhongMaterial||e.isMeshStandardMaterial||e.isShadowMaterial||e.isShaderMaterial&&!0===e.lights}(e),r.lightsStateVersion=a,r.needsLights&&(m.ambientLightColor.value=i.state.ambient,m.lightProbe.value=i.state.probe,m.directionalLights.value=i.state.directional,m.spotLights.value=i.state.spot,m.rectAreaLights.value=i.state.rectArea,m.pointLights.value=i.state.point,m.hemisphereLights.value=i.state.hemi,m.directionalShadowMap.value=i.state.directionalShadowMap,m.directionalShadowMatrix.value=i.state.directionalShadowMatrix,m.spotShadowMap.value=i.state.spotShadowMap,m.spotShadowMatrix.value=i.state.spotShadowMatrix,m.pointShadowMap.value=i.state.pointShadowMap,m.pointShadowMatrix.value=i.state.pointShadowMatrix);var g=r.program.getUniforms(),v=Bo.seqWithValue(g.seq,m);r.uniformsList=v}function _e(e,t,n,r){b.resetTextureUnits();var i=x.get(n),o=d.state.lights;if(te&&(ne||e!==j)){var a=e===j&&n.id===U;ee.setState(n.clippingPlanes,n.clipIntersection,n.clipShadows,e,i,a)}!1===n.needsUpdate&&(void 0===i.program?n.needsUpdate=!0:n.fog&&i.fog!==t?n.needsUpdate=!0:i.needsLights&&i.lightsStateVersion!==o.state.version?n.needsUpdate=!0:void 0===i.numClippingPlanes||i.numClippingPlanes===ee.numPlanes&&i.numIntersection===ee.numIntersection||(n.needsUpdate=!0)),n.needsUpdate&&(we(n,t,r),n.needsUpdate=!1);var s,c,l=!1,h=!1,u=!1,m=i.program,y=m.getUniforms(),w=i.shader.uniforms;if(v.useProgram(m.program)&&(l=!0,h=!0,u=!0),n.id!==U&&(U=n.id,h=!0),l||j!==e){if(m.numMultiviewViews>0?le.updateCameraProjectionMatricesUniform(e,y):y.setValue(f,"projectionMatrix",e.projectionMatrix),g.logarithmicDepthBuffer&&y.setValue(f,"logDepthBufFC",2/(Math.log(e.far+1)/Math.LN2)),j!==e&&(j=e,h=!0,u=!0),n.isShaderMaterial||n.isMeshPhongMaterial||n.isMeshStandardMaterial||n.envMap){var _=y.map.cameraPosition;void 0!==_&&_.setValue(f,ie.setFromMatrixPosition(e.matrixWorld))}(n.isMeshPhongMaterial||n.isMeshLambertMaterial||n.isMeshBasicMaterial||n.isMeshStandardMaterial||n.isShaderMaterial)&&y.setValue(f,"isOrthographic",!0===e.isOrthographicCamera),(n.isMeshPhongMaterial||n.isMeshLambertMaterial||n.isMeshBasicMaterial||n.isMeshStandardMaterial||n.isShaderMaterial||n.skinning)&&(m.numMultiviewViews>0?le.updateCameraViewMatricesUniform(e,y):y.setValue(f,"viewMatrix",e.matrixWorldInverse))}if(n.skinning){y.setOptional(f,r,"bindMatrix"),y.setOptional(f,r,"bindMatrixInverse");var M=r.skeleton;if(M){var E=M.bones;if(g.floatVertexTextures){if(void 0===M.boneTexture){var S=Math.sqrt(4*E.length);S=Rt.ceilPowerOfTwo(S),S=Math.max(S,4);var T=new Float32Array(S*S*4);T.set(M.boneMatrices);var A=new wi(T,S,S,Oe,Ee);M.boneMatrices=T,M.boneTexture=A,M.boneTextureSize=S}y.setValue(f,"boneTexture",M.boneTexture,b),y.setValue(f,"boneTextureSize",M.boneTextureSize)}else y.setOptional(f,M,"boneMatrices")}}return(h||i.receiveShadow!==r.receiveShadow)&&(i.receiveShadow=r.receiveShadow,y.setValue(f,"receiveShadow",r.receiveShadow)),h&&(y.setValue(f,"toneMappingExposure",O.toneMappingExposure),y.setValue(f,"toneMappingWhitePoint",O.toneMappingWhitePoint),i.needsLights&&(c=u,(s=w).ambientLightColor.needsUpdate=c,s.lightProbe.needsUpdate=c,s.directionalLights.needsUpdate=c,s.pointLights.needsUpdate=c,s.spotLights.needsUpdate=c,s.rectAreaLights.needsUpdate=c,s.hemisphereLights.needsUpdate=c),t&&n.fog&&function(e,t){e.fogColor.value.copy(t.color),t.isFog?(e.fogNear.value=t.near,e.fogFar.value=t.far):t.isFogExp2&&(e.fogDensity.value=t.density)}(w,t),n.isMeshBasicMaterial?Me(w,n):n.isMeshLambertMaterial?(Me(w,n),function(e,t){t.emissiveMap&&(e.emissiveMap.value=t.emissiveMap)}(w,n)):n.isMeshPhongMaterial?(Me(w,n),n.isMeshToonMaterial?function(e,t){Te(e,t),t.gradientMap&&(e.gradientMap.value=t.gradientMap)}(w,n):Te(w,n)):n.isMeshStandardMaterial?(Me(w,n),n.isMeshPhysicalMaterial?function(e,t){Ae(e,t),e.reflectivity.value=t.reflectivity,e.clearcoat.value=t.clearcoat,e.clearcoatRoughness.value=t.clearcoatRoughness,t.sheen&&e.sheen.value.copy(t.sheen);t.clearcoatNormalMap&&(e.clearcoatNormalScale.value.copy(t.clearcoatNormalScale),e.clearcoatNormalMap.value=t.clearcoatNormalMap,t.side===p&&e.clearcoatNormalScale.value.negate());e.transparency.value=t.transparency}(w,n):Ae(w,n)):n.isMeshMatcapMaterial?(Me(w,n),function(e,t){t.matcap&&(e.matcap.value=t.matcap);t.bumpMap&&(e.bumpMap.value=t.bumpMap,e.bumpScale.value=t.bumpScale,t.side===p&&(e.bumpScale.value*=-1));t.normalMap&&(e.normalMap.value=t.normalMap,e.normalScale.value.copy(t.normalScale),t.side===p&&e.normalScale.value.negate());t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias)}(w,n)):n.isMeshDepthMaterial?(Me(w,n),function(e,t){t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias)}(w,n)):n.isMeshDistanceMaterial?(Me(w,n),function(e,t){t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias);e.referencePosition.value.copy(t.referencePosition),e.nearDistance.value=t.nearDistance,e.farDistance.value=t.farDistance}(w,n)):n.isMeshNormalMaterial?(Me(w,n),function(e,t){t.bumpMap&&(e.bumpMap.value=t.bumpMap,e.bumpScale.value=t.bumpScale,t.side===p&&(e.bumpScale.value*=-1));t.normalMap&&(e.normalMap.value=t.normalMap,e.normalScale.value.copy(t.normalScale),t.side===p&&e.normalScale.value.negate());t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias)}(w,n)):n.isLineBasicMaterial?(function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity}(w,n),n.isLineDashedMaterial&&function(e,t){e.dashSize.value=t.dashSize,e.totalSize.value=t.dashSize+t.gapSize,e.scale.value=t.scale}(w,n)):n.isPointsMaterial?function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.size.value=t.size*Y,e.scale.value=.5*X,t.map&&(e.map.value=t.map);t.alphaMap&&(e.alphaMap.value=t.alphaMap);var n;t.map?n=t.map:t.alphaMap&&(n=t.alphaMap);void 0!==n&&(!0===n.matrixAutoUpdate&&n.updateMatrix(),e.uvTransform.value.copy(n.matrix))}(w,n):n.isSpriteMaterial?function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.rotation.value=t.rotation,t.map&&(e.map.value=t.map);t.alphaMap&&(e.alphaMap.value=t.alphaMap);var n;t.map?n=t.map:t.alphaMap&&(n=t.alphaMap);void 0!==n&&(!0===n.matrixAutoUpdate&&n.updateMatrix(),e.uvTransform.value.copy(n.matrix))}(w,n):n.isShadowMaterial&&(w.color.value.copy(n.color),w.opacity.value=n.opacity),void 0!==w.ltc_1&&(w.ltc_1.value=Ti.LTC_1),void 0!==w.ltc_2&&(w.ltc_2.value=Ti.LTC_2),Bo.upload(f,i.uniformsList,w,b),n.isShaderMaterial&&(n.uniformsNeedUpdate=!1)),n.isShaderMaterial&&!0===n.uniformsNeedUpdate&&(Bo.upload(f,i.uniformsList,w,b),n.uniformsNeedUpdate=!1),n.isSpriteMaterial&&y.setValue(f,"center",r.center),m.numMultiviewViews>0?le.updateObjectMatricesUniforms(r,e,y):(y.setValue(f,"modelViewMatrix",r.modelViewMatrix),y.setValue(f,"normalMatrix",r.normalMatrix)),y.setValue(f,"modelMatrix",r.matrixWorld),m}function Me(e,t){var n;e.opacity.value=t.opacity,t.color&&e.diffuse.value.copy(t.color),t.emissive&&e.emissive.value.copy(t.emissive).multiplyScalar(t.emissiveIntensity),t.map&&(e.map.value=t.map),t.alphaMap&&(e.alphaMap.value=t.alphaMap),t.specularMap&&(e.specularMap.value=t.specularMap),t.envMap&&(e.envMap.value=t.envMap,e.flipEnvMap.value=t.envMap.isCubeTexture?-1:1,e.reflectivity.value=t.reflectivity,e.refractionRatio.value=t.refractionRatio,e.maxMipLevel.value=x.get(t.envMap).__maxMipLevel),t.lightMap&&(e.lightMap.value=t.lightMap,e.lightMapIntensity.value=t.lightMapIntensity),t.aoMap&&(e.aoMap.value=t.aoMap,e.aoMapIntensity.value=t.aoMapIntensity),t.map?n=t.map:t.specularMap?n=t.specularMap:t.displacementMap?n=t.displacementMap:t.normalMap?n=t.normalMap:t.bumpMap?n=t.bumpMap:t.roughnessMap?n=t.roughnessMap:t.metalnessMap?n=t.metalnessMap:t.alphaMap?n=t.alphaMap:t.emissiveMap&&(n=t.emissiveMap),void 0!==n&&(n.isWebGLRenderTarget&&(n=n.texture),!0===n.matrixAutoUpdate&&n.updateMatrix(),e.uvTransform.value.copy(n.matrix))}function Te(e,t){e.specular.value.copy(t.specular),e.shininess.value=Math.max(t.shininess,1e-4),t.emissiveMap&&(e.emissiveMap.value=t.emissiveMap),t.bumpMap&&(e.bumpMap.value=t.bumpMap,e.bumpScale.value=t.bumpScale,t.side===p&&(e.bumpScale.value*=-1)),t.normalMap&&(e.normalMap.value=t.normalMap,e.normalScale.value.copy(t.normalScale),t.side===p&&e.normalScale.value.negate()),t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias)}function Ae(e,t){e.roughness.value=t.roughness,e.metalness.value=t.metalness,t.roughnessMap&&(e.roughnessMap.value=t.roughnessMap),t.metalnessMap&&(e.metalnessMap.value=t.metalnessMap),t.emissiveMap&&(e.emissiveMap.value=t.emissiveMap),t.bumpMap&&(e.bumpMap.value=t.bumpMap,e.bumpScale.value=t.bumpScale,t.side===p&&(e.bumpScale.value*=-1)),t.normalMap&&(e.normalMap.value=t.normalMap,e.normalScale.value.copy(t.normalScale),t.side===p&&e.normalScale.value.negate()),t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias),t.envMap&&(e.envMapIntensity.value=t.envMapIntensity)}ge.setAnimationLoop((function(e){ce.isPresenting()||me&&me(e)})),"undefined"!=typeof window&&ge.setContext(window),this.setAnimationLoop=function(e){me=e,ce.setAnimationLoop(e),ge.start()},this.render=function(e,t){var n,r;if(void 0!==arguments[2]&&(console.warn("THREE.WebGLRenderer.render(): the renderTarget argument has been removed. Use .setRenderTarget() instead."),n=arguments[2]),void 0!==arguments[3]&&(console.warn("THREE.WebGLRenderer.render(): the forceClear argument has been removed. Use .clear() instead."),r=arguments[3]),t&&t.isCamera){if(!D){B.geometry=null,B.program=null,B.wireframe=!1,U=-1,j=null,!0===e.autoUpdate&&e.updateMatrixWorld(),null===t.parent&&t.updateMatrixWorld(),ce.enabled&&(t=ce.getCamera(t)),(d=T.get(e,t)).init(),e.onBeforeRender(O,e,t,n||k),re.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),$.setFromMatrix(re),ne=this.localClippingEnabled,te=ee.init(this.clippingPlanes,ne,t),(u=S.get(e,t)).init(),ve(e,t,0,O.sortObjects),!0===O.sortObjects&&u.sort(),te&&ee.beginShadows();var i=d.state.shadowsArray;he.render(i,e,t),d.setupLights(t),te&&ee.endShadows(),this.info.autoReset&&this.info.reset(),void 0!==n&&this.setRenderTarget(n),ce.enabled&&le.isAvailable()&&le.attachCamera(t),A.render(u,e,t,r);var o=u.opaque,a=u.transparent;if(e.overrideMaterial){var s=e.overrideMaterial;o.length&&xe(o,e,t,s),a.length&&xe(a,e,t,s)}else o.length&&xe(o,e,t),a.length&&xe(a,e,t);e.onAfterRender(O,e,t),null!==k&&(b.updateRenderTargetMipmap(k),b.updateMultisampleRenderTarget(k)),v.buffers.depth.setTest(!0),v.buffers.depth.setMask(!0),v.buffers.color.setMask(!0),v.setPolygonOffset(!1),ce.enabled&&(le.isAvailable()&&le.detachCamera(t),ce.submitFrame()),u=null,d=null}}else console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.")},this.setFramebuffer=function(e){N!==e&&null===k&&f.bindFramebuffer(36160,e),N=e},this.getActiveCubeFace=function(){return I},this.getActiveMipmapLevel=function(){return z},this.getRenderTarget=function(){return k},this.setRenderTarget=function(e,t,n){k=e,I=t,z=n,e&&void 0===x.get(e).__webglFramebuffer&&b.setupRenderTarget(e);var r=N,i=!1;if(e){var o=x.get(e).__webglFramebuffer;e.isWebGLRenderTargetCube?(r=o[t||0],i=!0):r=e.isWebGLMultisampleRenderTarget?x.get(e).__webglMultisampledFramebuffer:o,G.copy(e.viewport),V.copy(e.scissor),W=e.scissorTest}else G.copy(Z).multiplyScalar(Y).floor(),V.copy(J).multiplyScalar(Y).floor(),W=K;if(F!==r&&(f.bindFramebuffer(36160,r),F=r),v.viewport(G),v.scissor(V),v.setScissorTest(W),i){var a=x.get(e.texture);f.framebufferTexture2D(36160,36064,34069+(t||0),a.__webglTexture,n||0)}},this.readRenderTargetPixels=function(e,t,n,r,i,o,a){if(e&&e.isWebGLRenderTarget){var s=x.get(e).__webglFramebuffer;if(e.isWebGLRenderTargetCube&&void 0!==a&&(s=s[a]),s){var c=!1;s!==F&&(f.bindFramebuffer(36160,s),c=!0);try{var l=e.texture,h=l.format,u=l.type;if(h!==Oe&&R.convert(h)!==f.getParameter(35739))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(u===ye||R.convert(u)===f.getParameter(35738)||u===Ee&&(g.isWebGL2||m.get("OES_texture_float")||m.get("WEBGL_color_buffer_float"))||u===Se&&(g.isWebGL2?m.get("EXT_color_buffer_float"):m.get("EXT_color_buffer_half_float"))))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");36053===f.checkFramebufferStatus(36160)?t>=0&&t<=e.width-r&&n>=0&&n<=e.height-i&&f.readPixels(t,n,r,i,R.convert(h),R.convert(u),o):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{c&&f.bindFramebuffer(36160,F)}}}else console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.")},this.copyFramebufferToTexture=function(e,t,n){void 0===n&&(n=0);var r=Math.pow(2,-n),i=Math.floor(t.image.width*r),o=Math.floor(t.image.height*r),a=R.convert(t.format);b.setTexture2D(t,0),f.copyTexImage2D(3553,n,a,e.x,e.y,i,o,0),v.unbindTexture()},this.copyTextureToTexture=function(e,t,n,r){var i=t.image.width,o=t.image.height,a=R.convert(n.format),s=R.convert(n.type);b.setTexture2D(n,0),t.isDataTexture?f.texSubImage2D(3553,r||0,e.x,e.y,i,o,a,s,t.image.data):f.texSubImage2D(3553,r||0,e.x,e.y,a,s,t.image),v.unbindTexture()},this.initTexture=function(e){b.setTexture2D(e,0),v.unbindTexture()},"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}function Ia(e,t){this.name="",this.color=new cr(e),this.density=void 0!==t?t:25e-5}function za(e,t,n){this.name="",this.color=new cr(e),this.near=void 0!==t?t:1,this.far=void 0!==n?n:1e3}function ka(e,t){this.array=e,this.stride=t,this.count=void 0!==e?e.length/t:0,this.usage=At,this.updateRange={offset:0,count:-1},this.version=0}function Fa(e,t,n,r){this.data=e,this.itemSize=t,this.offset=n,this.normalized=!0===r}function Ua(e){fr.call(this),this.type="SpriteMaterial",this.color=new cr(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.setValues(e)}Object.assign(Oa.prototype,Lt.prototype),Object.assign(Da.prototype,Lt.prototype),Object.assign(Ia.prototype,{isFogExp2:!0,clone:function(){return new Ia(this.color,this.density)},toJSON:function(){return{type:"FogExp2",color:this.color.getHex(),density:this.density}}}),Object.assign(za.prototype,{isFog:!0,clone:function(){return new za(this.color,this.near,this.far)},toJSON:function(){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}}}),Object.defineProperty(ka.prototype,"needsUpdate",{set:function(e){!0===e&&this.version++}}),Object.assign(ka.prototype,{isInterleavedBuffer:!0,onUploadCallback:function(){},setUsage:function(e){return this.usage=e,this},copy:function(e){return this.array=new e.array.constructor(e.array),this.count=e.count,this.stride=e.stride,this.usage=e.usage,this},copyAt:function(e,t,n){e*=this.stride,n*=t.stride;for(var r=0,i=this.stride;r<i;r++)this.array[e+r]=t.array[n+r];return this},set:function(e,t){return void 0===t&&(t=0),this.array.set(e,t),this},clone:function(){return(new this.constructor).copy(this)},onUpload:function(e){return this.onUploadCallback=e,this}}),Object.defineProperties(Fa.prototype,{count:{get:function(){return this.data.count}},array:{get:function(){return this.data.array}}}),Object.assign(Fa.prototype,{isInterleavedBufferAttribute:!0,setX:function(e,t){return this.data.array[e*this.data.stride+this.offset]=t,this},setY:function(e,t){return this.data.array[e*this.data.stride+this.offset+1]=t,this},setZ:function(e,t){return this.data.array[e*this.data.stride+this.offset+2]=t,this},setW:function(e,t){return this.data.array[e*this.data.stride+this.offset+3]=t,this},getX:function(e){return this.data.array[e*this.data.stride+this.offset]},getY:function(e){return this.data.array[e*this.data.stride+this.offset+1]},getZ:function(e){return this.data.array[e*this.data.stride+this.offset+2]},getW:function(e){return this.data.array[e*this.data.stride+this.offset+3]},setXY:function(e,t,n){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=n,this},setXYZ:function(e,t,n,r){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=n,this.data.array[e+2]=r,this},setXYZW:function(e,t,n,r,i){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=n,this.data.array[e+2]=r,this.data.array[e+3]=i,this}}),Ua.prototype=Object.create(fr.prototype),Ua.prototype.constructor=Ua,Ua.prototype.isSpriteMaterial=!0,Ua.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.rotation=e.rotation,this.sizeAttenuation=e.sizeAttenuation,this};var Ba=new zt,ja=new zt,Ha=new zt,Ga=new Ot,Va=new Ot,Wa=new $t,qa=new zt,Xa=new zt,Ya=new zt,Za=new Ot,Ja=new Ot,Qa=new Ot;function Ka(e){if(yn.call(this),this.type="Sprite",void 0===La){La=new Ir;var t=new ka(new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),5);La.setIndex([0,1,2,0,2,3]),La.setAttribute("position",new Fa(t,3,0,!1)),La.setAttribute("uv",new Fa(t,2,3,!1))}this.geometry=La,this.material=void 0!==e?e:new Ua,this.center=new Ot(.5,.5)}function $a(e,t,n,r,i,o){Ga.subVectors(e,n).addScalar(.5).multiply(r),void 0!==i?(Va.x=o*Ga.x-i*Ga.y,Va.y=i*Ga.x+o*Ga.y):Va.copy(Ga),e.copy(t),e.x+=Va.x,e.y+=Va.y,e.applyMatrix4(Wa)}Ka.prototype=Object.assign(Object.create(yn.prototype),{constructor:Ka,isSprite:!0,raycast:function(e,t){null===e.camera&&console.error('THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.'),ja.setFromMatrixScale(this.matrixWorld),Wa.copy(e.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(e.camera.matrixWorldInverse,this.matrixWorld),Ha.setFromMatrixPosition(this.modelViewMatrix),e.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&ja.multiplyScalar(-Ha.z);var n,r,i=this.material.rotation;0!==i&&(r=Math.cos(i),n=Math.sin(i));var o=this.center;$a(qa.set(-.5,-.5,0),Ha,o,ja,n,r),$a(Xa.set(.5,-.5,0),Ha,o,ja,n,r),$a(Ya.set(.5,.5,0),Ha,o,ja,n,r),Za.set(0,0),Ja.set(1,0),Qa.set(1,1);var a=e.ray.intersectTriangle(qa,Xa,Ya,!1,Ba);if(null!==a||($a(Xa.set(-.5,.5,0),Ha,o,ja,n,r),Ja.set(0,1),null!==(a=e.ray.intersectTriangle(qa,Ya,Xa,!1,Ba)))){var s=e.ray.origin.distanceTo(Ba);s<e.near||s>e.far||t.push({distance:s,point:Ba.clone(),uv:ir.getUV(Ba,qa,Xa,Ya,Za,Ja,Qa,new Ot),face:null,object:this})}},clone:function(){return new this.constructor(this.material).copy(this)},copy:function(e){return yn.prototype.copy.call(this,e),void 0!==e.center&&this.center.copy(e.center),this}});var es=new zt,ts=new zt;function ns(){yn.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}}),this.autoUpdate=!0}function rs(e,t){e&&e.isGeometry&&console.error("THREE.SkinnedMesh no longer supports THREE.Geometry. Use THREE.BufferGeometry instead."),$r.call(this,e,t),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new $t,this.bindMatrixInverse=new $t}ns.prototype=Object.assign(Object.create(yn.prototype),{constructor:ns,isLOD:!0,copy:function(e){yn.prototype.copy.call(this,e,!1);for(var t=e.levels,n=0,r=t.length;n<r;n++){var i=t[n];this.addLevel(i.object.clone(),i.distance)}return this},addLevel:function(e,t){void 0===t&&(t=0),t=Math.abs(t);for(var n=this.levels,r=0;r<n.length&&!(t<n[r].distance);r++);return n.splice(r,0,{distance:t,object:e}),this.add(e),this},getObjectForDistance:function(e){for(var t=this.levels,n=1,r=t.length;n<r&&!(e<t[n].distance);n++);return t[n-1].object},raycast:function(e,t){es.setFromMatrixPosition(this.matrixWorld);var n=e.ray.origin.distanceTo(es);this.getObjectForDistance(n).raycast(e,t)},update:function(e){var t=this.levels;if(t.length>1){es.setFromMatrixPosition(e.matrixWorld),ts.setFromMatrixPosition(this.matrixWorld);var n=es.distanceTo(ts);t[0].object.visible=!0;for(var r=1,i=t.length;r<i&&n>=t[r].distance;r++)t[r-1].object.visible=!1,t[r].object.visible=!0;for(;r<i;r++)t[r].object.visible=!1}},toJSON:function(e){var t=yn.prototype.toJSON.call(this,e);t.object.levels=[];for(var n=this.levels,r=0,i=n.length;r<i;r++){var o=n[r];t.object.levels.push({object:o.object.uuid,distance:o.distance})}return t}}),rs.prototype=Object.assign(Object.create($r.prototype),{constructor:rs,isSkinnedMesh:!0,bind:function(e,t){this.skeleton=e,void 0===t&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),t=this.matrixWorld),this.bindMatrix.copy(t),this.bindMatrixInverse.getInverse(t)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){for(var e=new Gt,t=this.geometry.attributes.skinWeight,n=0,r=t.count;n<r;n++){e.x=t.getX(n),e.y=t.getY(n),e.z=t.getZ(n),e.w=t.getW(n);var i=1/e.manhattanLength();i!==1/0?e.multiplyScalar(i):e.set(1,0,0,0),t.setXYZW(n,e.x,e.y,e.z,e.w)}},updateMatrixWorld:function(e){$r.prototype.updateMatrixWorld.call(this,e),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}});var is=new $t,os=new $t;function as(e,t){if(e=e||[],this.bones=e.slice(0),this.boneMatrices=new Float32Array(16*this.bones.length),this.frame=-1,void 0===t)this.calculateInverses();else if(this.bones.length===t.length)this.boneInverses=t.slice(0);else{console.warn("THREE.Skeleton boneInverses is the wrong length."),this.boneInverses=[];for(var n=0,r=this.bones.length;n<r;n++)this.boneInverses.push(new $t)}}function ss(){yn.call(this),this.type="Bone"}function cs(e,t,n){$r.call(this,e,t),this.instanceMatrix=new gr(new Float32Array(16*n),16),this.count=n}function ls(e){fr.call(this),this.type="LineBasicMaterial",this.color=new cr(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.setValues(e)}Object.assign(as.prototype,{calculateInverses:function(){this.boneInverses=[];for(var e=0,t=this.bones.length;e<t;e++){var n=new $t;this.bones[e]&&n.getInverse(this.bones[e].matrixWorld),this.boneInverses.push(n)}},pose:function(){var e,t,n;for(t=0,n=this.bones.length;t<n;t++)(e=this.bones[t])&&e.matrixWorld.getInverse(this.boneInverses[t]);for(t=0,n=this.bones.length;t<n;t++)(e=this.bones[t])&&(e.parent&&e.parent.isBone?(e.matrix.getInverse(e.parent.matrixWorld),e.matrix.multiply(e.matrixWorld)):e.matrix.copy(e.matrixWorld),e.matrix.decompose(e.position,e.quaternion,e.scale))},update:function(){for(var e=this.bones,t=this.boneInverses,n=this.boneMatrices,r=this.boneTexture,i=0,o=e.length;i<o;i++){var a=e[i]?e[i].matrixWorld:os;is.multiplyMatrices(a,t[i]),is.toArray(n,16*i)}void 0!==r&&(r.needsUpdate=!0)},clone:function(){return new as(this.bones,this.boneInverses)},getBoneByName:function(e){for(var t=0,n=this.bones.length;t<n;t++){var r=this.bones[t];if(r.name===e)return r}}}),ss.prototype=Object.assign(Object.create(yn.prototype),{constructor:ss,isBone:!0}),cs.prototype=Object.assign(Object.create($r.prototype),{constructor:cs,isInstancedMesh:!0,raycast:function(){},setMatrixAt:function(e,t){t.toArray(this.instanceMatrix.array,16*e)},updateMorphTargets:function(){}}),ls.prototype=Object.create(fr.prototype),ls.prototype.constructor=ls,ls.prototype.isLineBasicMaterial=!0,ls.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.linewidth=e.linewidth,this.linecap=e.linecap,this.linejoin=e.linejoin,this};var hs=new zt,us=new zt,ps=new $t,ds=new Gn,fs=new In;function ms(e,t,n){1===n&&console.error("THREE.Line: parameter THREE.LinePieces no longer supported. Use THREE.LineSegments instead."),yn.call(this),this.type="Line",this.geometry=void 0!==e?e:new Ir,this.material=void 0!==t?t:new ls({color:16777215*Math.random()})}ms.prototype=Object.assign(Object.create(yn.prototype),{constructor:ms,isLine:!0,computeLineDistances:function(){var e=this.geometry;if(e.isBufferGeometry)if(null===e.index){for(var t=e.attributes.position,n=[0],r=1,i=t.count;r<i;r++)hs.fromBufferAttribute(t,r-1),us.fromBufferAttribute(t,r),n[r]=n[r-1],n[r]+=hs.distanceTo(us);e.setAttribute("lineDistance",new Er(n,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");else if(e.isGeometry){var o=e.vertices;(n=e.lineDistances)[0]=0;for(r=1,i=o.length;r<i;r++)n[r]=n[r-1],n[r]+=o[r-1].distanceTo(o[r])}return this},raycast:function(e,t){var n=e.linePrecision,r=this.geometry,i=this.matrixWorld;if(null===r.boundingSphere&&r.computeBoundingSphere(),fs.copy(r.boundingSphere),fs.applyMatrix4(i),fs.radius+=n,!1!==e.ray.intersectsSphere(fs)){ps.getInverse(i),ds.copy(e.ray).applyMatrix4(ps);var o=n/((this.scale.x+this.scale.y+this.scale.z)/3),a=o*o,s=new zt,c=new zt,l=new zt,h=new zt,u=this&&this.isLineSegments?2:1;if(r.isBufferGeometry){var p=r.index,d=r.attributes.position.array;if(null!==p)for(var f=p.array,m=0,g=f.length-1;m<g;m+=u){var v=f[m],y=f[m+1];if(s.fromArray(d,3*v),c.fromArray(d,3*y),!(ds.distanceSqToSegment(s,c,h,l)>a))h.applyMatrix4(this.matrixWorld),(w=e.ray.origin.distanceTo(h))<e.near||w>e.far||t.push({distance:w,point:l.clone().applyMatrix4(this.matrixWorld),index:m,face:null,faceIndex:null,object:this})}else for(m=0,g=d.length/3-1;m<g;m+=u){if(s.fromArray(d,3*m),c.fromArray(d,3*m+3),!(ds.distanceSqToSegment(s,c,h,l)>a))h.applyMatrix4(this.matrixWorld),(w=e.ray.origin.distanceTo(h))<e.near||w>e.far||t.push({distance:w,point:l.clone().applyMatrix4(this.matrixWorld),index:m,face:null,faceIndex:null,object:this})}}else if(r.isGeometry){var x=r.vertices,b=x.length;for(m=0;m<b-1;m+=u){var w;if(!(ds.distanceSqToSegment(x[m],x[m+1],h,l)>a))h.applyMatrix4(this.matrixWorld),(w=e.ray.origin.distanceTo(h))<e.near||w>e.far||t.push({distance:w,point:l.clone().applyMatrix4(this.matrixWorld),index:m,face:null,faceIndex:null,object:this})}}}},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}});var gs=new zt,vs=new zt;function ys(e,t){ms.call(this,e,t),this.type="LineSegments"}function xs(e,t){ms.call(this,e,t),this.type="LineLoop"}function bs(e){fr.call(this),this.type="PointsMaterial",this.color=new cr(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.morphTargets=!1,this.setValues(e)}ys.prototype=Object.assign(Object.create(ms.prototype),{constructor:ys,isLineSegments:!0,computeLineDistances:function(){var e=this.geometry;if(e.isBufferGeometry)if(null===e.index){for(var t=e.attributes.position,n=[],r=0,i=t.count;r<i;r+=2)gs.fromBufferAttribute(t,r),vs.fromBufferAttribute(t,r+1),n[r]=0===r?0:n[r-1],n[r+1]=n[r]+gs.distanceTo(vs);e.setAttribute("lineDistance",new Er(n,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");else if(e.isGeometry){var o=e.vertices;for(n=e.lineDistances,r=0,i=o.length;r<i;r+=2)gs.copy(o[r]),vs.copy(o[r+1]),n[r]=0===r?0:n[r-1],n[r+1]=n[r]+gs.distanceTo(vs)}return this}}),xs.prototype=Object.assign(Object.create(ms.prototype),{constructor:xs,isLineLoop:!0}),bs.prototype=Object.create(fr.prototype),bs.prototype.constructor=bs,bs.prototype.isPointsMaterial=!0,bs.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.size=e.size,this.sizeAttenuation=e.sizeAttenuation,this.morphTargets=e.morphTargets,this};var ws=new $t,_s=new Gn,Ms=new In,Es=new zt;function Ss(e,t){yn.call(this),this.type="Points",this.geometry=void 0!==e?e:new Ir,this.material=void 0!==t?t:new bs({color:16777215*Math.random()}),this.updateMorphTargets()}function Ts(e,t,n,r,i,o,a){var s=_s.distanceSqToPoint(e);if(s<n){var c=new zt;_s.closestPointToPoint(e,c),c.applyMatrix4(r);var l=i.ray.origin.distanceTo(c);if(l<i.near||l>i.far)return;o.push({distance:l,distanceToRay:Math.sqrt(s),point:c,index:t,face:null,object:a})}}function As(e,t,n,r,i,o,a,s,c){Ht.call(this,e,t,n,r,i,o,a,s,c),this.format=void 0!==a?a:Re,this.minFilter=void 0!==o?o:me,this.magFilter=void 0!==i?i:me,this.generateMipmaps=!1}function Ls(e,t,n,r,i,o,a,s,c,l,h,u){Ht.call(this,null,o,a,s,c,l,r,i,h,u),this.image={width:t,height:n},this.mipmaps=e,this.flipY=!1,this.generateMipmaps=!1}function Ps(e,t,n,r,i,o,a,s,c){Ht.call(this,e,t,n,r,i,o,a,s,c),this.needsUpdate=!0}function Cs(e,t,n,r,i,o,a,s,c,l){if((l=void 0!==l?l:ze)!==ze&&l!==ke)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===n&&l===ze&&(n=we),void 0===n&&l===ke&&(n=Pe),Ht.call(this,null,r,i,o,a,s,l,n,c),this.image={width:e,height:t},this.magFilter=void 0!==a?a:pe,this.minFilter=void 0!==s?s:pe,this.flipY=!1,this.generateMipmaps=!1}function Rs(e){Ir.call(this),this.type="WireframeGeometry";var t,n,r,i,o,a,s,c,l,h,u=[],p=[0,0],d={},f=["a","b","c"];if(e&&e.isGeometry){var m=e.faces;for(t=0,r=m.length;t<r;t++){var g=m[t];for(n=0;n<3;n++)s=g[f[n]],c=g[f[(n+1)%3]],p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[l=p[0]+","+p[1]]&&(d[l]={index1:p[0],index2:p[1]})}for(l in d)a=d[l],h=e.vertices[a.index1],u.push(h.x,h.y,h.z),h=e.vertices[a.index2],u.push(h.x,h.y,h.z)}else if(e&&e.isBufferGeometry){var v,y,x,b,w,_,M;if(h=new zt,null!==e.index){for(v=e.attributes.position,y=e.index,0===(x=e.groups).length&&(x=[{start:0,count:y.count,materialIndex:0}]),i=0,o=x.length;i<o;++i)for(t=w=(b=x[i]).start,r=w+b.count;t<r;t+=3)for(n=0;n<3;n++)s=y.getX(t+n),c=y.getX(t+(n+1)%3),p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[l=p[0]+","+p[1]]&&(d[l]={index1:p[0],index2:p[1]});for(l in d)a=d[l],h.fromBufferAttribute(v,a.index1),u.push(h.x,h.y,h.z),h.fromBufferAttribute(v,a.index2),u.push(h.x,h.y,h.z)}else for(t=0,r=(v=e.attributes.position).count/3;t<r;t++)for(n=0;n<3;n++)_=3*t+n,h.fromBufferAttribute(v,_),u.push(h.x,h.y,h.z),M=3*t+(n+1)%3,h.fromBufferAttribute(v,M),u.push(h.x,h.y,h.z)}this.setAttribute("position",new Er(u,3))}function Os(e,t,n){ai.call(this),this.type="ParametricGeometry",this.parameters={func:e,slices:t,stacks:n},this.fromBufferGeometry(new Ds(e,t,n)),this.mergeVertices()}function Ds(e,t,n){Ir.call(this),this.type="ParametricBufferGeometry",this.parameters={func:e,slices:t,stacks:n};var r,i,o=[],a=[],s=[],c=[],l=new zt,h=new zt,u=new zt,p=new zt,d=new zt;e.length<3&&console.error("THREE.ParametricGeometry: Function must now modify a Vector3 as third parameter.");var f=t+1;for(r=0;r<=n;r++){var m=r/n;for(i=0;i<=t;i++){var g=i/t;e(g,m,h),a.push(h.x,h.y,h.z),g-1e-5>=0?(e(g-1e-5,m,u),p.subVectors(h,u)):(e(g+1e-5,m,u),p.subVectors(u,h)),m-1e-5>=0?(e(g,m-1e-5,u),d.subVectors(h,u)):(e(g,m+1e-5,u),d.subVectors(u,h)),l.crossVectors(p,d).normalize(),s.push(l.x,l.y,l.z),c.push(g,m)}}for(r=0;r<n;r++)for(i=0;i<t;i++){var v=r*f+i,y=r*f+i+1,x=(r+1)*f+i+1,b=(r+1)*f+i;o.push(v,y,b),o.push(y,x,b)}this.setIndex(o),this.setAttribute("position",new Er(a,3)),this.setAttribute("normal",new Er(s,3)),this.setAttribute("uv",new Er(c,2))}function Ns(e,t,n,r){ai.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:e,indices:t,radius:n,detail:r},this.fromBufferGeometry(new Is(e,t,n,r)),this.mergeVertices()}function Is(e,t,n,r){Ir.call(this),this.type="PolyhedronBufferGeometry",this.parameters={vertices:e,indices:t,radius:n,detail:r},n=n||1;var i=[],o=[];function a(e,t,n,r){var i,o,a=Math.pow(2,r),c=[];for(i=0;i<=a;i++){c[i]=[];var l=e.clone().lerp(n,i/a),h=t.clone().lerp(n,i/a),u=a-i;for(o=0;o<=u;o++)c[i][o]=0===o&&i===a?l:l.clone().lerp(h,o/u)}for(i=0;i<a;i++)for(o=0;o<2*(a-i)-1;o++){var p=Math.floor(o/2);o%2==0?(s(c[i][p+1]),s(c[i+1][p]),s(c[i][p])):(s(c[i][p+1]),s(c[i+1][p+1]),s(c[i+1][p]))}}function s(e){i.push(e.x,e.y,e.z)}function c(t,n){var r=3*t;n.x=e[r+0],n.y=e[r+1],n.z=e[r+2]}function l(e,t,n,r){r<0&&1===e.x&&(o[t]=e.x-1),0===n.x&&0===n.z&&(o[t]=r/2/Math.PI+.5)}function h(e){return Math.atan2(e.z,-e.x)}!function(e){for(var n=new zt,r=new zt,i=new zt,o=0;o<t.length;o+=3)c(t[o+0],n),c(t[o+1],r),c(t[o+2],i),a(n,r,i,e)}(r=r||0),function(e){for(var t=new zt,n=0;n<i.length;n+=3)t.x=i[n+0],t.y=i[n+1],t.z=i[n+2],t.normalize().multiplyScalar(e),i[n+0]=t.x,i[n+1]=t.y,i[n+2]=t.z}(n),function(){for(var e=new zt,t=0;t<i.length;t+=3){e.x=i[t+0],e.y=i[t+1],e.z=i[t+2];var n=h(e)/2/Math.PI+.5,r=(a=e,Math.atan2(-a.y,Math.sqrt(a.x*a.x+a.z*a.z))/Math.PI+.5);o.push(n,1-r)}var a;(function(){for(var e=new zt,t=new zt,n=new zt,r=new zt,a=new Ot,s=new Ot,c=new Ot,u=0,p=0;u<i.length;u+=9,p+=6){e.set(i[u+0],i[u+1],i[u+2]),t.set(i[u+3],i[u+4],i[u+5]),n.set(i[u+6],i[u+7],i[u+8]),a.set(o[p+0],o[p+1]),s.set(o[p+2],o[p+3]),c.set(o[p+4],o[p+5]),r.copy(e).add(t).add(n).divideScalar(3);var d=h(r);l(a,p+0,e,d),l(s,p+2,t,d),l(c,p+4,n,d)}})(),function(){for(var e=0;e<o.length;e+=6){var t=o[e+0],n=o[e+2],r=o[e+4],i=Math.max(t,n,r),a=Math.min(t,n,r);i>.9&&a<.1&&(t<.2&&(o[e+0]+=1),n<.2&&(o[e+2]+=1),r<.2&&(o[e+4]+=1))}}()}(),this.setAttribute("position",new Er(i,3)),this.setAttribute("normal",new Er(i.slice(),3)),this.setAttribute("uv",new Er(o,2)),0===r?this.computeVertexNormals():this.normalizeNormals()}function zs(e,t){ai.call(this),this.type="TetrahedronGeometry",this.parameters={radius:e,detail:t},this.fromBufferGeometry(new ks(e,t)),this.mergeVertices()}function ks(e,t){Is.call(this,[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],e,t),this.type="TetrahedronBufferGeometry",this.parameters={radius:e,detail:t}}function Fs(e,t){ai.call(this),this.type="OctahedronGeometry",this.parameters={radius:e,detail:t},this.fromBufferGeometry(new Us(e,t)),this.mergeVertices()}function Us(e,t){Is.call(this,[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],e,t),this.type="OctahedronBufferGeometry",this.parameters={radius:e,detail:t}}function Bs(e,t){ai.call(this),this.type="IcosahedronGeometry",this.parameters={radius:e,detail:t},this.fromBufferGeometry(new js(e,t)),this.mergeVertices()}function js(e,t){var n=(1+Math.sqrt(5))/2,r=[-1,n,0,1,n,0,-1,-n,0,1,-n,0,0,-1,n,0,1,n,0,-1,-n,0,1,-n,n,0,-1,n,0,1,-n,0,-1,-n,0,1];Is.call(this,r,[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],e,t),this.type="IcosahedronBufferGeometry",this.parameters={radius:e,detail:t}}function Hs(e,t){ai.call(this),this.type="DodecahedronGeometry",this.parameters={radius:e,detail:t},this.fromBufferGeometry(new Gs(e,t)),this.mergeVertices()}function Gs(e,t){var n=(1+Math.sqrt(5))/2,r=1/n,i=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-n,0,-r,n,0,r,-n,0,r,n,-r,-n,0,-r,n,0,r,-n,0,r,n,0,-n,0,-r,n,0,-r,-n,0,r,n,0,r];Is.call(this,i,[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],e,t),this.type="DodecahedronBufferGeometry",this.parameters={radius:e,detail:t}}function Vs(e,t,n,r,i,o){ai.call(this),this.type="TubeGeometry",this.parameters={path:e,tubularSegments:t,radius:n,radialSegments:r,closed:i},void 0!==o&&console.warn("THREE.TubeGeometry: taper has been removed.");var a=new Ws(e,t,n,r,i);this.tangents=a.tangents,this.normals=a.normals,this.binormals=a.binormals,this.fromBufferGeometry(a),this.mergeVertices()}function Ws(e,t,n,r,i){Ir.call(this),this.type="TubeBufferGeometry",this.parameters={path:e,tubularSegments:t,radius:n,radialSegments:r,closed:i},t=t||64,n=n||1,r=r||8,i=i||!1;var o=e.computeFrenetFrames(t,i);this.tangents=o.tangents,this.normals=o.normals,this.binormals=o.binormals;var a,s,c=new zt,l=new zt,h=new Ot,u=new zt,p=[],d=[],f=[],m=[];function g(i){u=e.getPointAt(i/t,u);var a=o.normals[i],h=o.binormals[i];for(s=0;s<=r;s++){var f=s/r*Math.PI*2,m=Math.sin(f),g=-Math.cos(f);l.x=g*a.x+m*h.x,l.y=g*a.y+m*h.y,l.z=g*a.z+m*h.z,l.normalize(),d.push(l.x,l.y,l.z),c.x=u.x+n*l.x,c.y=u.y+n*l.y,c.z=u.z+n*l.z,p.push(c.x,c.y,c.z)}}!function(){for(a=0;a<t;a++)g(a);g(!1===i?t:0),function(){for(a=0;a<=t;a++)for(s=0;s<=r;s++)h.x=a/t,h.y=s/r,f.push(h.x,h.y)}(),function(){for(s=1;s<=t;s++)for(a=1;a<=r;a++){var e=(r+1)*(s-1)+(a-1),n=(r+1)*s+(a-1),i=(r+1)*s+a,o=(r+1)*(s-1)+a;m.push(e,n,o),m.push(n,i,o)}}()}(),this.setIndex(m),this.setAttribute("position",new Er(p,3)),this.setAttribute("normal",new Er(d,3)),this.setAttribute("uv",new Er(f,2))}function qs(e,t,n,r,i,o,a){ai.call(this),this.type="TorusKnotGeometry",this.parameters={radius:e,tube:t,tubularSegments:n,radialSegments:r,p:i,q:o},void 0!==a&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new Xs(e,t,n,r,i,o)),this.mergeVertices()}function Xs(e,t,n,r,i,o){Ir.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius:e,tube:t,tubularSegments:n,radialSegments:r,p:i,q:o},e=e||1,t=t||.4,n=Math.floor(n)||64,r=Math.floor(r)||8,i=i||2,o=o||3;var a,s,c=[],l=[],h=[],u=[],p=new zt,d=new zt,f=new zt,m=new zt,g=new zt,v=new zt,y=new zt;for(a=0;a<=n;++a){var x=a/n*i*Math.PI*2;for(A(x,i,o,e,f),A(x+.01,i,o,e,m),v.subVectors(m,f),y.addVectors(m,f),g.crossVectors(v,y),y.crossVectors(g,v),g.normalize(),y.normalize(),s=0;s<=r;++s){var b=s/r*Math.PI*2,w=-t*Math.cos(b),_=t*Math.sin(b);p.x=f.x+(w*y.x+_*g.x),p.y=f.y+(w*y.y+_*g.y),p.z=f.z+(w*y.z+_*g.z),l.push(p.x,p.y,p.z),d.subVectors(p,f).normalize(),h.push(d.x,d.y,d.z),u.push(a/n),u.push(s/r)}}for(s=1;s<=n;s++)for(a=1;a<=r;a++){var M=(r+1)*(s-1)+(a-1),E=(r+1)*s+(a-1),S=(r+1)*s+a,T=(r+1)*(s-1)+a;c.push(M,E,T),c.push(E,S,T)}function A(e,t,n,r,i){var o=Math.cos(e),a=Math.sin(e),s=n/t*e,c=Math.cos(s);i.x=r*(2+c)*.5*o,i.y=r*(2+c)*a*.5,i.z=r*Math.sin(s)*.5}this.setIndex(c),this.setAttribute("position",new Er(l,3)),this.setAttribute("normal",new Er(h,3)),this.setAttribute("uv",new Er(u,2))}function Ys(e,t,n,r,i){ai.call(this),this.type="TorusGeometry",this.parameters={radius:e,tube:t,radialSegments:n,tubularSegments:r,arc:i},this.fromBufferGeometry(new Zs(e,t,n,r,i)),this.mergeVertices()}function Zs(e,t,n,r,i){Ir.call(this),this.type="TorusBufferGeometry",this.parameters={radius:e,tube:t,radialSegments:n,tubularSegments:r,arc:i},e=e||1,t=t||.4,n=Math.floor(n)||8,r=Math.floor(r)||6,i=i||2*Math.PI;var o,a,s=[],c=[],l=[],h=[],u=new zt,p=new zt,d=new zt;for(o=0;o<=n;o++)for(a=0;a<=r;a++){var f=a/r*i,m=o/n*Math.PI*2;p.x=(e+t*Math.cos(m))*Math.cos(f),p.y=(e+t*Math.cos(m))*Math.sin(f),p.z=t*Math.sin(m),c.push(p.x,p.y,p.z),u.x=e*Math.cos(f),u.y=e*Math.sin(f),d.subVectors(p,u).normalize(),l.push(d.x,d.y,d.z),h.push(a/r),h.push(o/n)}for(o=1;o<=n;o++)for(a=1;a<=r;a++){var g=(r+1)*o+a-1,v=(r+1)*(o-1)+a-1,y=(r+1)*(o-1)+a,x=(r+1)*o+a;s.push(g,v,x),s.push(v,y,x)}this.setIndex(s),this.setAttribute("position",new Er(c,3)),this.setAttribute("normal",new Er(l,3)),this.setAttribute("uv",new Er(h,2))}Ss.prototype=Object.assign(Object.create(yn.prototype),{constructor:Ss,isPoints:!0,raycast:function(e,t){var n=this.geometry,r=this.matrixWorld,i=e.params.Points.threshold;if(null===n.boundingSphere&&n.computeBoundingSphere(),Ms.copy(n.boundingSphere),Ms.applyMatrix4(r),Ms.radius+=i,!1!==e.ray.intersectsSphere(Ms)){ws.getInverse(r),_s.copy(e.ray).applyMatrix4(ws);var o=i/((this.scale.x+this.scale.y+this.scale.z)/3),a=o*o;if(n.isBufferGeometry){var s=n.index,c=n.attributes.position.array;if(null!==s)for(var l=s.array,h=0,u=l.length;h<u;h++){var p=l[h];Es.fromArray(c,3*p),Ts(Es,p,a,r,e,t,this)}else{h=0;for(var d=c.length/3;h<d;h++)Es.fromArray(c,3*h),Ts(Es,h,a,r,e,t,this)}}else{var f=n.vertices;for(h=0,d=f.length;h<d;h++)Ts(f[h],h,a,r,e,t,this)}}},updateMorphTargets:function(){var e,t,n,r=this.geometry;if(r.isBufferGeometry){var i=r.morphAttributes,o=Object.keys(i);if(o.length>0){var a=i[o[0]];if(void 0!==a)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},e=0,t=a.length;e<t;e++)n=a[e].name||String(e),this.morphTargetInfluences.push(0),this.morphTargetDictionary[n]=e}}else{var s=r.morphTargets;void 0!==s&&s.length>0&&console.error("THREE.Points.updateMorphTargets() does not support THREE.Geometry. Use THREE.BufferGeometry instead.")}},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),As.prototype=Object.assign(Object.create(Ht.prototype),{constructor:As,isVideoTexture:!0,update:function(){var e=this.image;e.readyState>=e.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}),Ls.prototype=Object.create(Ht.prototype),Ls.prototype.constructor=Ls,Ls.prototype.isCompressedTexture=!0,Ps.prototype=Object.create(Ht.prototype),Ps.prototype.constructor=Ps,Ps.prototype.isCanvasTexture=!0,Cs.prototype=Object.create(Ht.prototype),Cs.prototype.constructor=Cs,Cs.prototype.isDepthTexture=!0,Rs.prototype=Object.create(Ir.prototype),Rs.prototype.constructor=Rs,Os.prototype=Object.create(ai.prototype),Os.prototype.constructor=Os,Ds.prototype=Object.create(Ir.prototype),Ds.prototype.constructor=Ds,Ns.prototype=Object.create(ai.prototype),Ns.prototype.constructor=Ns,Is.prototype=Object.create(Ir.prototype),Is.prototype.constructor=Is,zs.prototype=Object.create(ai.prototype),zs.prototype.constructor=zs,ks.prototype=Object.create(Is.prototype),ks.prototype.constructor=ks,Fs.prototype=Object.create(ai.prototype),Fs.prototype.constructor=Fs,Us.prototype=Object.create(Is.prototype),Us.prototype.constructor=Us,Bs.prototype=Object.create(ai.prototype),Bs.prototype.constructor=Bs,js.prototype=Object.create(Is.prototype),js.prototype.constructor=js,Hs.prototype=Object.create(ai.prototype),Hs.prototype.constructor=Hs,Gs.prototype=Object.create(Is.prototype),Gs.prototype.constructor=Gs,Vs.prototype=Object.create(ai.prototype),Vs.prototype.constructor=Vs,Ws.prototype=Object.create(Ir.prototype),Ws.prototype.constructor=Ws,Ws.prototype.toJSON=function(){var e=Ir.prototype.toJSON.call(this);return e.path=this.parameters.path.toJSON(),e},qs.prototype=Object.create(ai.prototype),qs.prototype.constructor=qs,Xs.prototype=Object.create(Ir.prototype),Xs.prototype.constructor=Xs,Ys.prototype=Object.create(ai.prototype),Ys.prototype.constructor=Ys,Zs.prototype=Object.create(Ir.prototype),Zs.prototype.constructor=Zs;var Js=function(e,t,n){n=n||2;var r,i,o,a,s,c,l,h=t&&t.length,u=h?t[0]*n:e.length,p=Qs(e,0,u,n,!0),d=[];if(!p||p.next===p.prev)return d;if(h&&(p=function(e,t,n,r){var i,o,a,s,c,l=[];for(i=0,o=t.length;i<o;i++)a=t[i]*r,s=i<o-1?t[i+1]*r:e.length,(c=Qs(e,a,s,r,!1))===c.next&&(c.steiner=!0),l.push(sc(c));for(l.sort(ic),i=0;i<l.length;i++)oc(l[i],n),n=Ks(n,n.next);return n}(e,t,p,n)),e.length>80*n){r=o=e[0],i=a=e[1];for(var f=n;f<u;f+=n)(s=e[f])<r&&(r=s),(c=e[f+1])<i&&(i=c),s>o&&(o=s),c>a&&(a=c);l=0!==(l=Math.max(o-r,a-i))?1/l:0}return $s(p,d,n,r,i,l),d};function Qs(e,t,n,r,i){var o,a;if(i===function(e,t,n,r){for(var i=0,o=t,a=n-r;o<n;o+=r)i+=(e[a]-e[o])*(e[o+1]+e[a+1]),a=o;return i}(e,t,n,r)>0)for(o=t;o<n;o+=r)a=mc(o,e[o],e[o+1],a);else for(o=n-r;o>=t;o-=r)a=mc(o,e[o],e[o+1],a);return a&&uc(a,a.next)&&(gc(a),a=a.next),a}function Ks(e,t){if(!e)return e;t||(t=e);var n,r=e;do{if(n=!1,r.steiner||!uc(r,r.next)&&0!==hc(r.prev,r,r.next))r=r.next;else{if(gc(r),(r=t=r.prev)===r.next)break;n=!0}}while(n||r!==t);return t}function $s(e,t,n,r,i,o,a){if(e){!a&&o&&function(e,t,n,r){var i=e;do{null===i.z&&(i.z=ac(i.x,i.y,t,n,r)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,function(e){var t,n,r,i,o,a,s,c,l=1;do{for(n=e,e=null,o=null,a=0;n;){for(a++,r=n,s=0,t=0;t<l&&(s++,r=r.nextZ);t++);for(c=l;s>0||c>0&&r;)0!==s&&(0===c||!r||n.z<=r.z)?(i=n,n=n.nextZ,s--):(i=r,r=r.nextZ,c--),o?o.nextZ=i:e=i,i.prevZ=o,o=i;n=r}o.nextZ=null,l*=2}while(a>1)}(i)}(e,r,i,o);for(var s,c,l=e;e.prev!==e.next;)if(s=e.prev,c=e.next,o?tc(e,r,i,o):ec(e))t.push(s.i/n),t.push(e.i/n),t.push(c.i/n),gc(e),e=c.next,l=c.next;else if((e=c)===l){a?1===a?$s(e=nc(e,t,n),t,n,r,i,o,2):2===a&&rc(e,t,n,r,i,o):$s(Ks(e),t,n,r,i,o,1);break}}}function ec(e){var t=e.prev,n=e,r=e.next;if(hc(t,n,r)>=0)return!1;for(var i=e.next.next;i!==e.prev;){if(cc(t.x,t.y,n.x,n.y,r.x,r.y,i.x,i.y)&&hc(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function tc(e,t,n,r){var i=e.prev,o=e,a=e.next;if(hc(i,o,a)>=0)return!1;for(var s=i.x<o.x?i.x<a.x?i.x:a.x:o.x<a.x?o.x:a.x,c=i.y<o.y?i.y<a.y?i.y:a.y:o.y<a.y?o.y:a.y,l=i.x>o.x?i.x>a.x?i.x:a.x:o.x>a.x?o.x:a.x,h=i.y>o.y?i.y>a.y?i.y:a.y:o.y>a.y?o.y:a.y,u=ac(s,c,t,n,r),p=ac(l,h,t,n,r),d=e.prevZ,f=e.nextZ;d&&d.z>=u&&f&&f.z<=p;){if(d!==e.prev&&d!==e.next&&cc(i.x,i.y,o.x,o.y,a.x,a.y,d.x,d.y)&&hc(d.prev,d,d.next)>=0)return!1;if(d=d.prevZ,f!==e.prev&&f!==e.next&&cc(i.x,i.y,o.x,o.y,a.x,a.y,f.x,f.y)&&hc(f.prev,f,f.next)>=0)return!1;f=f.nextZ}for(;d&&d.z>=u;){if(d!==e.prev&&d!==e.next&&cc(i.x,i.y,o.x,o.y,a.x,a.y,d.x,d.y)&&hc(d.prev,d,d.next)>=0)return!1;d=d.prevZ}for(;f&&f.z<=p;){if(f!==e.prev&&f!==e.next&&cc(i.x,i.y,o.x,o.y,a.x,a.y,f.x,f.y)&&hc(f.prev,f,f.next)>=0)return!1;f=f.nextZ}return!0}function nc(e,t,n){var r=e;do{var i=r.prev,o=r.next.next;!uc(i,o)&&pc(i,r,r.next,o)&&dc(i,o)&&dc(o,i)&&(t.push(i.i/n),t.push(r.i/n),t.push(o.i/n),gc(r),gc(r.next),r=e=o),r=r.next}while(r!==e);return r}function rc(e,t,n,r,i,o){var a=e;do{for(var s=a.next.next;s!==a.prev;){if(a.i!==s.i&&lc(a,s)){var c=fc(a,s);return a=Ks(a,a.next),c=Ks(c,c.next),$s(a,t,n,r,i,o),void $s(c,t,n,r,i,o)}s=s.next}a=a.next}while(a!==e)}function ic(e,t){return e.x-t.x}function oc(e,t){if(t=function(e,t){var n,r=t,i=e.x,o=e.y,a=-1/0;do{if(o<=r.y&&o>=r.next.y&&r.next.y!==r.y){var s=r.x+(o-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=i&&s>a){if(a=s,s===i){if(o===r.y)return r;if(o===r.next.y)return r.next}n=r.x<r.next.x?r:r.next}}r=r.next}while(r!==t);if(!n)return null;if(i===a)return n.prev;var c,l=n,h=n.x,u=n.y,p=1/0;r=n.next;for(;r!==l;)i>=r.x&&r.x>=h&&i!==r.x&&cc(o<u?i:a,o,h,u,o<u?a:i,o,r.x,r.y)&&((c=Math.abs(o-r.y)/(i-r.x))<p||c===p&&r.x>n.x)&&dc(r,e)&&(n=r,p=c),r=r.next;return n}(e,t)){var n=fc(t,e);Ks(n,n.next)}}function ac(e,t,n,r,i){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-n)*i)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*i)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function sc(e){var t=e,n=e;do{(t.x<n.x||t.x===n.x&&t.y<n.y)&&(n=t),t=t.next}while(t!==e);return n}function cc(e,t,n,r,i,o,a,s){return(i-a)*(t-s)-(e-a)*(o-s)>=0&&(e-a)*(r-s)-(n-a)*(t-s)>=0&&(n-a)*(o-s)-(i-a)*(r-s)>=0}function lc(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){var n=e;do{if(n.i!==e.i&&n.next.i!==e.i&&n.i!==t.i&&n.next.i!==t.i&&pc(n,n.next,e,t))return!0;n=n.next}while(n!==e);return!1}(e,t)&&dc(e,t)&&dc(t,e)&&function(e,t){var n=e,r=!1,i=(e.x+t.x)/2,o=(e.y+t.y)/2;do{n.y>o!=n.next.y>o&&n.next.y!==n.y&&i<(n.next.x-n.x)*(o-n.y)/(n.next.y-n.y)+n.x&&(r=!r),n=n.next}while(n!==e);return r}(e,t)}function hc(e,t,n){return(t.y-e.y)*(n.x-t.x)-(t.x-e.x)*(n.y-t.y)}function uc(e,t){return e.x===t.x&&e.y===t.y}function pc(e,t,n,r){return!!(uc(e,n)&&uc(t,r)||uc(e,r)&&uc(n,t))||hc(e,t,n)>0!=hc(e,t,r)>0&&hc(n,r,e)>0!=hc(n,r,t)>0}function dc(e,t){return hc(e.prev,e,e.next)<0?hc(e,t,e.next)>=0&&hc(e,e.prev,t)>=0:hc(e,t,e.prev)<0||hc(e,e.next,t)<0}function fc(e,t){var n=new vc(e.i,e.x,e.y),r=new vc(t.i,t.x,t.y),i=e.next,o=t.prev;return e.next=t,t.prev=e,n.next=i,i.prev=n,r.next=n,n.prev=r,o.next=r,r.prev=o,r}function mc(e,t,n,r){var i=new vc(e,t,n);return r?(i.next=r.next,i.prev=r,r.next.prev=i,r.next=i):(i.prev=i,i.next=i),i}function gc(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function vc(e,t,n){this.i=e,this.x=t,this.y=n,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}var yc={area:function(e){for(var t=e.length,n=0,r=t-1,i=0;i<t;r=i++)n+=e[r].x*e[i].y-e[i].x*e[r].y;return.5*n},isClockWise:function(e){return yc.area(e)<0},triangulateShape:function(e,t){var n=[],r=[],i=[];xc(e),bc(n,e);var o=e.length;t.forEach(xc);for(var a=0;a<t.length;a++)r.push(o),o+=t[a].length,bc(n,t[a]);var s=Js(n,r);for(a=0;a<s.length;a+=3)i.push(s.slice(a,a+3));return i}};function xc(e){var t=e.length;t>2&&e[t-1].equals(e[0])&&e.pop()}function bc(e,t){for(var n=0;n<t.length;n++)e.push(t[n].x),e.push(t[n].y)}function wc(e,t){ai.call(this),this.type="ExtrudeGeometry",this.parameters={shapes:e,options:t},this.fromBufferGeometry(new _c(e,t)),this.mergeVertices()}function _c(e,t){Ir.call(this),this.type="ExtrudeBufferGeometry",this.parameters={shapes:e,options:t},e=Array.isArray(e)?e:[e];for(var n=this,r=[],i=[],o=0,a=e.length;o<a;o++){s(e[o])}function s(e){var o=[],a=void 0!==t.curveSegments?t.curveSegments:12,s=void 0!==t.steps?t.steps:1,c=void 0!==t.depth?t.depth:100,l=void 0===t.bevelEnabled||t.bevelEnabled,h=void 0!==t.bevelThickness?t.bevelThickness:6,u=void 0!==t.bevelSize?t.bevelSize:h-2,p=void 0!==t.bevelOffset?t.bevelOffset:0,d=void 0!==t.bevelSegments?t.bevelSegments:3,f=t.extrudePath,m=void 0!==t.UVGenerator?t.UVGenerator:Mc;void 0!==t.amount&&(console.warn("THREE.ExtrudeBufferGeometry: amount has been renamed to depth."),c=t.amount);var g,v,y,x,b,w,_,M,E=!1;f&&(g=f.getSpacedPoints(s),E=!0,l=!1,v=f.computeFrenetFrames(s,!1),y=new zt,x=new zt,b=new zt),l||(d=0,h=0,u=0,p=0);var S=e.extractPoints(a),T=S.shape,A=S.holes;if(!yc.isClockWise(T))for(T=T.reverse(),_=0,M=A.length;_<M;_++)w=A[_],yc.isClockWise(w)&&(A[_]=w.reverse());var L=yc.triangulateShape(T,A),P=T;for(_=0,M=A.length;_<M;_++)w=A[_],T=T.concat(w);function C(e,t,n){return t||console.error("THREE.ExtrudeGeometry: vec does not exist"),t.clone().multiplyScalar(n).add(e)}var R,O,D,N,I,z,k=T.length,F=L.length;function U(e,t,n){var r,i,o,a=e.x-t.x,s=e.y-t.y,c=n.x-e.x,l=n.y-e.y,h=a*a+s*s,u=a*l-s*c;if(Math.abs(u)>Number.EPSILON){var p=Math.sqrt(h),d=Math.sqrt(c*c+l*l),f=t.x-s/p,m=t.y+a/p,g=((n.x-l/d-f)*l-(n.y+c/d-m)*c)/(a*l-s*c),v=(r=f+a*g-e.x)*r+(i=m+s*g-e.y)*i;if(v<=2)return new Ot(r,i);o=Math.sqrt(v/2)}else{var y=!1;a>Number.EPSILON?c>Number.EPSILON&&(y=!0):a<-Number.EPSILON?c<-Number.EPSILON&&(y=!0):Math.sign(s)===Math.sign(l)&&(y=!0),y?(r=-s,i=a,o=Math.sqrt(h)):(r=a,i=s,o=Math.sqrt(h/2))}return new Ot(r/o,i/o)}for(var B=[],j=0,H=P.length,G=H-1,V=j+1;j<H;j++,G++,V++)G===H&&(G=0),V===H&&(V=0),B[j]=U(P[j],P[G],P[V]);var W,q,X=[],Y=B.concat();for(_=0,M=A.length;_<M;_++){for(w=A[_],W=[],j=0,G=(H=w.length)-1,V=j+1;j<H;j++,G++,V++)G===H&&(G=0),V===H&&(V=0),W[j]=U(w[j],w[G],w[V]);X.push(W),Y=Y.concat(W)}for(R=0;R<d;R++){for(D=R/d,N=h*Math.cos(D*Math.PI/2),O=u*Math.sin(D*Math.PI/2)+p,j=0,H=P.length;j<H;j++)J((I=C(P[j],B[j],O)).x,I.y,-N);for(_=0,M=A.length;_<M;_++)for(w=A[_],W=X[_],j=0,H=w.length;j<H;j++)J((I=C(w[j],W[j],O)).x,I.y,-N)}for(O=u+p,j=0;j<k;j++)I=l?C(T[j],Y[j],O):T[j],E?(x.copy(v.normals[0]).multiplyScalar(I.x),y.copy(v.binormals[0]).multiplyScalar(I.y),b.copy(g[0]).add(x).add(y),J(b.x,b.y,b.z)):J(I.x,I.y,0);for(q=1;q<=s;q++)for(j=0;j<k;j++)I=l?C(T[j],Y[j],O):T[j],E?(x.copy(v.normals[q]).multiplyScalar(I.x),y.copy(v.binormals[q]).multiplyScalar(I.y),b.copy(g[q]).add(x).add(y),J(b.x,b.y,b.z)):J(I.x,I.y,c/s*q);for(R=d-1;R>=0;R--){for(D=R/d,N=h*Math.cos(D*Math.PI/2),O=u*Math.sin(D*Math.PI/2)+p,j=0,H=P.length;j<H;j++)J((I=C(P[j],B[j],O)).x,I.y,c+N);for(_=0,M=A.length;_<M;_++)for(w=A[_],W=X[_],j=0,H=w.length;j<H;j++)I=C(w[j],W[j],O),E?J(I.x,I.y+g[s-1].y,g[s-1].x+N):J(I.x,I.y,c+N)}function Z(e,t){var n,r;for(j=e.length;--j>=0;){n=j,(r=j-1)<0&&(r=e.length-1);var i=0,o=s+2*d;for(i=0;i<o;i++){var a=k*i,c=k*(i+1);K(t+n+a,t+r+a,t+r+c,t+n+c)}}}function J(e,t,n){o.push(e),o.push(t),o.push(n)}function Q(e,t,i){$(e),$(t),$(i);var o=r.length/3,a=m.generateTopUV(n,r,o-3,o-2,o-1);ee(a[0]),ee(a[1]),ee(a[2])}function K(e,t,i,o){$(e),$(t),$(o),$(t),$(i),$(o);var a=r.length/3,s=m.generateSideWallUV(n,r,a-6,a-3,a-2,a-1);ee(s[0]),ee(s[1]),ee(s[3]),ee(s[1]),ee(s[2]),ee(s[3])}function $(e){r.push(o[3*e+0]),r.push(o[3*e+1]),r.push(o[3*e+2])}function ee(e){i.push(e.x),i.push(e.y)}!function(){var e=r.length/3;if(l){var t=0,i=k*t;for(j=0;j<F;j++)Q((z=L[j])[2]+i,z[1]+i,z[0]+i);for(i=k*(t=s+2*d),j=0;j<F;j++)Q((z=L[j])[0]+i,z[1]+i,z[2]+i)}else{for(j=0;j<F;j++)Q((z=L[j])[2],z[1],z[0]);for(j=0;j<F;j++)Q((z=L[j])[0]+k*s,z[1]+k*s,z[2]+k*s)}n.addGroup(e,r.length/3-e,0)}(),function(){var e=r.length/3,t=0;for(Z(P,t),t+=P.length,_=0,M=A.length;_<M;_++)Z(w=A[_],t),t+=w.length;n.addGroup(e,r.length/3-e,1)}()}this.setAttribute("position",new Er(r,3)),this.setAttribute("uv",new Er(i,2)),this.computeVertexNormals()}wc.prototype=Object.create(ai.prototype),wc.prototype.constructor=wc,wc.prototype.toJSON=function(){var e=ai.prototype.toJSON.call(this);return Ec(this.parameters.shapes,this.parameters.options,e)},_c.prototype=Object.create(Ir.prototype),_c.prototype.constructor=_c,_c.prototype.toJSON=function(){var e=Ir.prototype.toJSON.call(this);return Ec(this.parameters.shapes,this.parameters.options,e)};var Mc={generateTopUV:function(e,t,n,r,i){var o=t[3*n],a=t[3*n+1],s=t[3*r],c=t[3*r+1],l=t[3*i],h=t[3*i+1];return[new Ot(o,a),new Ot(s,c),new Ot(l,h)]},generateSideWallUV:function(e,t,n,r,i,o){var a=t[3*n],s=t[3*n+1],c=t[3*n+2],l=t[3*r],h=t[3*r+1],u=t[3*r+2],p=t[3*i],d=t[3*i+1],f=t[3*i+2],m=t[3*o],g=t[3*o+1],v=t[3*o+2];return Math.abs(s-h)<.01?[new Ot(a,1-c),new Ot(l,1-u),new Ot(p,1-f),new Ot(m,1-v)]:[new Ot(s,1-c),new Ot(h,1-u),new Ot(d,1-f),new Ot(g,1-v)]}};function Ec(e,t,n){if(n.shapes=[],Array.isArray(e))for(var r=0,i=e.length;r<i;r++){var o=e[r];n.shapes.push(o.uuid)}else n.shapes.push(e.uuid);return void 0!==t.extrudePath&&(n.options.extrudePath=t.extrudePath.toJSON()),n}function Sc(e,t){ai.call(this),this.type="TextGeometry",this.parameters={text:e,parameters:t},this.fromBufferGeometry(new Tc(e,t)),this.mergeVertices()}function Tc(e,t){var n=(t=t||{}).font;if(!n||!n.isFont)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new ai;var r=n.generateShapes(e,t.size);t.depth=void 0!==t.height?t.height:50,void 0===t.bevelThickness&&(t.bevelThickness=10),void 0===t.bevelSize&&(t.bevelSize=8),void 0===t.bevelEnabled&&(t.bevelEnabled=!1),_c.call(this,r,t),this.type="TextBufferGeometry"}function Ac(e,t,n,r,i,o,a){ai.call(this),this.type="SphereGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:n,phiStart:r,phiLength:i,thetaStart:o,thetaLength:a},this.fromBufferGeometry(new Lc(e,t,n,r,i,o,a)),this.mergeVertices()}function Lc(e,t,n,r,i,o,a){Ir.call(this),this.type="SphereBufferGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:n,phiStart:r,phiLength:i,thetaStart:o,thetaLength:a},e=e||1,t=Math.max(3,Math.floor(t)||8),n=Math.max(2,Math.floor(n)||6),r=void 0!==r?r:0,i=void 0!==i?i:2*Math.PI,o=void 0!==o?o:0,a=void 0!==a?a:Math.PI;var s,c,l=Math.min(o+a,Math.PI),h=0,u=[],p=new zt,d=new zt,f=[],m=[],g=[],v=[];for(c=0;c<=n;c++){var y=[],x=c/n,b=0;for(0==c&&0==o?b=.5/t:c==n&&l==Math.PI&&(b=-.5/t),s=0;s<=t;s++){var w=s/t;p.x=-e*Math.cos(r+w*i)*Math.sin(o+x*a),p.y=e*Math.cos(o+x*a),p.z=e*Math.sin(r+w*i)*Math.sin(o+x*a),m.push(p.x,p.y,p.z),d.copy(p).normalize(),g.push(d.x,d.y,d.z),v.push(w+b,1-x),y.push(h++)}u.push(y)}for(c=0;c<n;c++)for(s=0;s<t;s++){var _=u[c][s+1],M=u[c][s],E=u[c+1][s],S=u[c+1][s+1];(0!==c||o>0)&&f.push(_,M,S),(c!==n-1||l<Math.PI)&&f.push(M,E,S)}this.setIndex(f),this.setAttribute("position",new Er(m,3)),this.setAttribute("normal",new Er(g,3)),this.setAttribute("uv",new Er(v,2))}function Pc(e,t,n,r,i,o){ai.call(this),this.type="RingGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:n,phiSegments:r,thetaStart:i,thetaLength:o},this.fromBufferGeometry(new Cc(e,t,n,r,i,o)),this.mergeVertices()}function Cc(e,t,n,r,i,o){Ir.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:n,phiSegments:r,thetaStart:i,thetaLength:o},e=e||.5,t=t||1,i=void 0!==i?i:0,o=void 0!==o?o:2*Math.PI,n=void 0!==n?Math.max(3,n):8;var a,s,c,l=[],h=[],u=[],p=[],d=e,f=(t-e)/(r=void 0!==r?Math.max(1,r):1),m=new zt,g=new Ot;for(s=0;s<=r;s++){for(c=0;c<=n;c++)a=i+c/n*o,m.x=d*Math.cos(a),m.y=d*Math.sin(a),h.push(m.x,m.y,m.z),u.push(0,0,1),g.x=(m.x/t+1)/2,g.y=(m.y/t+1)/2,p.push(g.x,g.y);d+=f}for(s=0;s<r;s++){var v=s*(n+1);for(c=0;c<n;c++){var y=a=c+v,x=a+n+1,b=a+n+2,w=a+1;l.push(y,x,w),l.push(x,b,w)}}this.setIndex(l),this.setAttribute("position",new Er(h,3)),this.setAttribute("normal",new Er(u,3)),this.setAttribute("uv",new Er(p,2))}function Rc(e,t,n,r){ai.call(this),this.type="LatheGeometry",this.parameters={points:e,segments:t,phiStart:n,phiLength:r},this.fromBufferGeometry(new Oc(e,t,n,r)),this.mergeVertices()}function Oc(e,t,n,r){Ir.call(this),this.type="LatheBufferGeometry",this.parameters={points:e,segments:t,phiStart:n,phiLength:r},t=Math.floor(t)||12,n=n||0,r=r||2*Math.PI,r=Rt.clamp(r,0,2*Math.PI);var i,o,a,s=[],c=[],l=[],h=1/t,u=new zt,p=new Ot;for(o=0;o<=t;o++){var d=n+o*h*r,f=Math.sin(d),m=Math.cos(d);for(a=0;a<=e.length-1;a++)u.x=e[a].x*f,u.y=e[a].y,u.z=e[a].x*m,c.push(u.x,u.y,u.z),p.x=o/t,p.y=a/(e.length-1),l.push(p.x,p.y)}for(o=0;o<t;o++)for(a=0;a<e.length-1;a++){var g=i=a+o*e.length,v=i+e.length,y=i+e.length+1,x=i+1;s.push(g,v,x),s.push(v,y,x)}if(this.setIndex(s),this.setAttribute("position",new Er(c,3)),this.setAttribute("uv",new Er(l,2)),this.computeVertexNormals(),r===2*Math.PI){var b=this.attributes.normal.array,w=new zt,_=new zt,M=new zt;for(i=t*e.length*3,o=0,a=0;o<e.length;o++,a+=3)w.x=b[a+0],w.y=b[a+1],w.z=b[a+2],_.x=b[i+a+0],_.y=b[i+a+1],_.z=b[i+a+2],M.addVectors(w,_).normalize(),b[a+0]=b[i+a+0]=M.x,b[a+1]=b[i+a+1]=M.y,b[a+2]=b[i+a+2]=M.z}}function Dc(e,t){ai.call(this),this.type="ShapeGeometry","object"==typeof t&&(console.warn("THREE.ShapeGeometry: Options parameter has been removed."),t=t.curveSegments),this.parameters={shapes:e,curveSegments:t},this.fromBufferGeometry(new Nc(e,t)),this.mergeVertices()}function Nc(e,t){Ir.call(this),this.type="ShapeBufferGeometry",this.parameters={shapes:e,curveSegments:t},t=t||12;var n=[],r=[],i=[],o=[],a=0,s=0;if(!1===Array.isArray(e))l(e);else for(var c=0;c<e.length;c++)l(e[c]),this.addGroup(a,s,c),a+=s,s=0;function l(e){var a,c,l,h=r.length/3,u=e.extractPoints(t),p=u.shape,d=u.holes;for(!1===yc.isClockWise(p)&&(p=p.reverse()),a=0,c=d.length;a<c;a++)l=d[a],!0===yc.isClockWise(l)&&(d[a]=l.reverse());var f=yc.triangulateShape(p,d);for(a=0,c=d.length;a<c;a++)l=d[a],p=p.concat(l);for(a=0,c=p.length;a<c;a++){var m=p[a];r.push(m.x,m.y,0),i.push(0,0,1),o.push(m.x,m.y)}for(a=0,c=f.length;a<c;a++){var g=f[a],v=g[0]+h,y=g[1]+h,x=g[2]+h;n.push(v,y,x),s+=3}}this.setIndex(n),this.setAttribute("position",new Er(r,3)),this.setAttribute("normal",new Er(i,3)),this.setAttribute("uv",new Er(o,2))}function Ic(e,t){if(t.shapes=[],Array.isArray(e))for(var n=0,r=e.length;n<r;n++){var i=e[n];t.shapes.push(i.uuid)}else t.shapes.push(e.uuid);return t}function zc(e,t){Ir.call(this),this.type="EdgesGeometry",this.parameters={thresholdAngle:t},t=void 0!==t?t:1;var n,r,i,o,a=[],s=Math.cos(Rt.DEG2RAD*t),c=[0,0],l={},h=["a","b","c"];e.isBufferGeometry?(o=new ai).fromBufferGeometry(e):o=e.clone(),o.mergeVertices(),o.computeFaceNormals();for(var u=o.vertices,p=o.faces,d=0,f=p.length;d<f;d++)for(var m=p[d],g=0;g<3;g++)n=m[h[g]],r=m[h[(g+1)%3]],c[0]=Math.min(n,r),c[1]=Math.max(n,r),void 0===l[i=c[0]+","+c[1]]?l[i]={index1:c[0],index2:c[1],face1:d,face2:void 0}:l[i].face2=d;for(i in l){var v=l[i];if(void 0===v.face2||p[v.face1].normal.dot(p[v.face2].normal)<=s){var y=u[v.index1];a.push(y.x,y.y,y.z),y=u[v.index2],a.push(y.x,y.y,y.z)}}this.setAttribute("position",new Er(a,3))}function kc(e,t,n,r,i,o,a,s){ai.call(this),this.type="CylinderGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:n,radialSegments:r,heightSegments:i,openEnded:o,thetaStart:a,thetaLength:s},this.fromBufferGeometry(new Fc(e,t,n,r,i,o,a,s)),this.mergeVertices()}function Fc(e,t,n,r,i,o,a,s){Ir.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:n,radialSegments:r,heightSegments:i,openEnded:o,thetaStart:a,thetaLength:s};var c=this;e=void 0!==e?e:1,t=void 0!==t?t:1,n=n||1,r=Math.floor(r)||8,i=Math.floor(i)||1,o=void 0!==o&&o,a=void 0!==a?a:0,s=void 0!==s?s:2*Math.PI;var l=[],h=[],u=[],p=[],d=0,f=[],m=n/2,g=0;function v(n){var i,o,f,v=new Ot,y=new zt,x=0,b=!0===n?e:t,w=!0===n?1:-1;for(o=d,i=1;i<=r;i++)h.push(0,m*w,0),u.push(0,w,0),p.push(.5,.5),d++;for(f=d,i=0;i<=r;i++){var _=i/r*s+a,M=Math.cos(_),E=Math.sin(_);y.x=b*E,y.y=m*w,y.z=b*M,h.push(y.x,y.y,y.z),u.push(0,w,0),v.x=.5*M+.5,v.y=.5*E*w+.5,p.push(v.x,v.y),d++}for(i=0;i<r;i++){var S=o+i,T=f+i;!0===n?l.push(T,T+1,S):l.push(T+1,T,S),x+=3}c.addGroup(g,x,!0===n?1:2),g+=x}!function(){var o,v,y=new zt,x=new zt,b=0,w=(t-e)/n;for(v=0;v<=i;v++){var _=[],M=v/i,E=M*(t-e)+e;for(o=0;o<=r;o++){var S=o/r,T=S*s+a,A=Math.sin(T),L=Math.cos(T);x.x=E*A,x.y=-M*n+m,x.z=E*L,h.push(x.x,x.y,x.z),y.set(A,w,L).normalize(),u.push(y.x,y.y,y.z),p.push(S,1-M),_.push(d++)}f.push(_)}for(o=0;o<r;o++)for(v=0;v<i;v++){var P=f[v][o],C=f[v+1][o],R=f[v+1][o+1],O=f[v][o+1];l.push(P,C,O),l.push(C,R,O),b+=6}c.addGroup(g,b,0),g+=b}(),!1===o&&(e>0&&v(!0),t>0&&v(!1)),this.setIndex(l),this.setAttribute("position",new Er(h,3)),this.setAttribute("normal",new Er(u,3)),this.setAttribute("uv",new Er(p,2))}function Uc(e,t,n,r,i,o,a){kc.call(this,0,e,t,n,r,i,o,a),this.type="ConeGeometry",this.parameters={radius:e,height:t,radialSegments:n,heightSegments:r,openEnded:i,thetaStart:o,thetaLength:a}}function Bc(e,t,n,r,i,o,a){Fc.call(this,0,e,t,n,r,i,o,a),this.type="ConeBufferGeometry",this.parameters={radius:e,height:t,radialSegments:n,heightSegments:r,openEnded:i,thetaStart:o,thetaLength:a}}function jc(e,t,n,r){ai.call(this),this.type="CircleGeometry",this.parameters={radius:e,segments:t,thetaStart:n,thetaLength:r},this.fromBufferGeometry(new Hc(e,t,n,r)),this.mergeVertices()}function Hc(e,t,n,r){Ir.call(this),this.type="CircleBufferGeometry",this.parameters={radius:e,segments:t,thetaStart:n,thetaLength:r},e=e||1,t=void 0!==t?Math.max(3,t):8,n=void 0!==n?n:0,r=void 0!==r?r:2*Math.PI;var i,o,a=[],s=[],c=[],l=[],h=new zt,u=new Ot;for(s.push(0,0,0),c.push(0,0,1),l.push(.5,.5),o=0,i=3;o<=t;o++,i+=3){var p=n+o/t*r;h.x=e*Math.cos(p),h.y=e*Math.sin(p),s.push(h.x,h.y,h.z),c.push(0,0,1),u.x=(s[i]/e+1)/2,u.y=(s[i+1]/e+1)/2,l.push(u.x,u.y)}for(i=1;i<=t;i++)a.push(i,i+1,0);this.setIndex(a),this.setAttribute("position",new Er(s,3)),this.setAttribute("normal",new Er(c,3)),this.setAttribute("uv",new Er(l,2))}Sc.prototype=Object.create(ai.prototype),Sc.prototype.constructor=Sc,Tc.prototype=Object.create(_c.prototype),Tc.prototype.constructor=Tc,Ac.prototype=Object.create(ai.prototype),Ac.prototype.constructor=Ac,Lc.prototype=Object.create(Ir.prototype),Lc.prototype.constructor=Lc,Pc.prototype=Object.create(ai.prototype),Pc.prototype.constructor=Pc,Cc.prototype=Object.create(Ir.prototype),Cc.prototype.constructor=Cc,Rc.prototype=Object.create(ai.prototype),Rc.prototype.constructor=Rc,Oc.prototype=Object.create(Ir.prototype),Oc.prototype.constructor=Oc,Dc.prototype=Object.create(ai.prototype),Dc.prototype.constructor=Dc,Dc.prototype.toJSON=function(){var e=ai.prototype.toJSON.call(this);return Ic(this.parameters.shapes,e)},Nc.prototype=Object.create(Ir.prototype),Nc.prototype.constructor=Nc,Nc.prototype.toJSON=function(){var e=Ir.prototype.toJSON.call(this);return Ic(this.parameters.shapes,e)},zc.prototype=Object.create(Ir.prototype),zc.prototype.constructor=zc,kc.prototype=Object.create(ai.prototype),kc.prototype.constructor=kc,Fc.prototype=Object.create(Ir.prototype),Fc.prototype.constructor=Fc,Uc.prototype=Object.create(kc.prototype),Uc.prototype.constructor=Uc,Bc.prototype=Object.create(Fc.prototype),Bc.prototype.constructor=Bc,jc.prototype=Object.create(ai.prototype),jc.prototype.constructor=jc,Hc.prototype=Object.create(Ir.prototype),Hc.prototype.constructor=Hc;var Gc=Object.freeze({__proto__:null,WireframeGeometry:Rs,ParametricGeometry:Os,ParametricBufferGeometry:Ds,TetrahedronGeometry:zs,TetrahedronBufferGeometry:ks,OctahedronGeometry:Fs,OctahedronBufferGeometry:Us,IcosahedronGeometry:Bs,IcosahedronBufferGeometry:js,DodecahedronGeometry:Hs,DodecahedronBufferGeometry:Gs,PolyhedronGeometry:Ns,PolyhedronBufferGeometry:Is,TubeGeometry:Vs,TubeBufferGeometry:Ws,TorusKnotGeometry:qs,TorusKnotBufferGeometry:Xs,TorusGeometry:Ys,TorusBufferGeometry:Zs,TextGeometry:Sc,TextBufferGeometry:Tc,SphereGeometry:Ac,SphereBufferGeometry:Lc,RingGeometry:Pc,RingBufferGeometry:Cc,PlaneGeometry:Ci,PlaneBufferGeometry:Ri,LatheGeometry:Rc,LatheBufferGeometry:Oc,ShapeGeometry:Dc,ShapeBufferGeometry:Nc,ExtrudeGeometry:wc,ExtrudeBufferGeometry:_c,EdgesGeometry:zc,ConeGeometry:Uc,ConeBufferGeometry:Bc,CylinderGeometry:kc,CylinderBufferGeometry:Fc,CircleGeometry:jc,CircleBufferGeometry:Hc,BoxGeometry:si,BoxBufferGeometry:ci});function Vc(e){fr.call(this),this.type="ShadowMaterial",this.color=new cr(0),this.transparent=!0,this.setValues(e)}function Wc(e){fi.call(this,e),this.type="RawShaderMaterial"}function qc(e){fr.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new cr(16777215),this.roughness=.5,this.metalness=.5,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new cr(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=Mt,this.normalScale=new Ot(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(e)}function Xc(e){qc.call(this),this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.reflectivity=.5,this.clearcoat=0,this.clearcoatRoughness=0,this.sheen=null,this.clearcoatNormalScale=new Ot(1,1),this.clearcoatNormalMap=null,this.transparency=0,this.setValues(e)}function Yc(e){fr.call(this),this.type="MeshPhongMaterial",this.color=new cr(16777215),this.specular=new cr(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new cr(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=Mt,this.normalScale=new Ot(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=X,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(e)}function Zc(e){Yc.call(this),this.defines={TOON:""},this.type="MeshToonMaterial",this.gradientMap=null,this.setValues(e)}function Jc(e){fr.call(this),this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=Mt,this.normalScale=new Ot(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(e)}function Qc(e){fr.call(this),this.type="MeshLambertMaterial",this.color=new cr(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new cr(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=X,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(e)}function Kc(e){fr.call(this),this.defines={MATCAP:""},this.type="MeshMatcapMaterial",this.color=new cr(16777215),this.matcap=null,this.map=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=Mt,this.normalScale=new Ot(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(e)}function $c(e){ls.call(this),this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(e)}Vc.prototype=Object.create(fr.prototype),Vc.prototype.constructor=Vc,Vc.prototype.isShadowMaterial=!0,Vc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this},Wc.prototype=Object.create(fi.prototype),Wc.prototype.constructor=Wc,Wc.prototype.isRawShaderMaterial=!0,qc.prototype=Object.create(fr.prototype),qc.prototype.constructor=qc,qc.prototype.isMeshStandardMaterial=!0,qc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.defines={STANDARD:""},this.color.copy(e.color),this.roughness=e.roughness,this.metalness=e.metalness,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.roughnessMap=e.roughnessMap,this.metalnessMap=e.metalnessMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapIntensity=e.envMapIntensity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},Xc.prototype=Object.create(qc.prototype),Xc.prototype.constructor=Xc,Xc.prototype.isMeshPhysicalMaterial=!0,Xc.prototype.copy=function(e){return qc.prototype.copy.call(this,e),this.defines={STANDARD:"",PHYSICAL:""},this.reflectivity=e.reflectivity,this.clearcoat=e.clearcoat,this.clearcoatRoughness=e.clearcoatRoughness,e.sheen?this.sheen=(this.sheen||new cr).copy(e.sheen):this.sheen=null,this.clearcoatNormalMap=e.clearcoatNormalMap,this.clearcoatNormalScale.copy(e.clearcoatNormalScale),this.transparency=e.transparency,this},Yc.prototype=Object.create(fr.prototype),Yc.prototype.constructor=Yc,Yc.prototype.isMeshPhongMaterial=!0,Yc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.specular.copy(e.specular),this.shininess=e.shininess,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},Zc.prototype=Object.create(Yc.prototype),Zc.prototype.constructor=Zc,Zc.prototype.isMeshToonMaterial=!0,Zc.prototype.copy=function(e){return Yc.prototype.copy.call(this,e),this.gradientMap=e.gradientMap,this},Jc.prototype=Object.create(fr.prototype),Jc.prototype.constructor=Jc,Jc.prototype.isMeshNormalMaterial=!0,Jc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},Qc.prototype=Object.create(fr.prototype),Qc.prototype.constructor=Qc,Qc.prototype.isMeshLambertMaterial=!0,Qc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},Kc.prototype=Object.create(fr.prototype),Kc.prototype.constructor=Kc,Kc.prototype.isMeshMatcapMaterial=!0,Kc.prototype.copy=function(e){return fr.prototype.copy.call(this,e),this.defines={MATCAP:""},this.color.copy(e.color),this.matcap=e.matcap,this.map=e.map,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.alphaMap=e.alphaMap,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},$c.prototype=Object.create(ls.prototype),$c.prototype.constructor=$c,$c.prototype.isLineDashedMaterial=!0,$c.prototype.copy=function(e){return ls.prototype.copy.call(this,e),this.scale=e.scale,this.dashSize=e.dashSize,this.gapSize=e.gapSize,this};var el=Object.freeze({__proto__:null,ShadowMaterial:Vc,SpriteMaterial:Ua,RawShaderMaterial:Wc,ShaderMaterial:fi,PointsMaterial:bs,MeshPhysicalMaterial:Xc,MeshStandardMaterial:qc,MeshPhongMaterial:Yc,MeshToonMaterial:Zc,MeshNormalMaterial:Jc,MeshLambertMaterial:Qc,MeshDepthMaterial:ga,MeshDistanceMaterial:va,MeshBasicMaterial:mr,MeshMatcapMaterial:Kc,LineDashedMaterial:$c,LineBasicMaterial:ls,Material:fr}),tl={arraySlice:function(e,t,n){return tl.isTypedArray(e)?new e.constructor(e.subarray(t,void 0!==n?n:e.length)):e.slice(t,n)},convertArray:function(e,t,n){return!e||!n&&e.constructor===t?e:"number"==typeof t.BYTES_PER_ELEMENT?new t(e):Array.prototype.slice.call(e)},isTypedArray:function(e){return ArrayBuffer.isView(e)&&!(e instanceof DataView)},getKeyframeOrder:function(e){for(var t=e.length,n=new Array(t),r=0;r!==t;++r)n[r]=r;return n.sort((function(t,n){return e[t]-e[n]})),n},sortedArray:function(e,t,n){for(var r=e.length,i=new e.constructor(r),o=0,a=0;a!==r;++o)for(var s=n[o]*t,c=0;c!==t;++c)i[a++]=e[s+c];return i},flattenJSON:function(e,t,n,r){for(var i=1,o=e[0];void 0!==o&&void 0===o[r];)o=e[i++];if(void 0!==o){var a=o[r];if(void 0!==a)if(Array.isArray(a))do{void 0!==(a=o[r])&&(t.push(o.time),n.push.apply(n,a)),o=e[i++]}while(void 0!==o);else if(void 0!==a.toArray)do{void 0!==(a=o[r])&&(t.push(o.time),a.toArray(n,n.length)),o=e[i++]}while(void 0!==o);else do{void 0!==(a=o[r])&&(t.push(o.time),n.push(a)),o=e[i++]}while(void 0!==o)}},subclip:function(e,t,n,r,i){i=i||30;var o=e.clone();o.name=t;for(var a=[],s=0;s<o.tracks.length;++s){for(var c=o.tracks[s],l=c.getValueSize(),h=[],u=[],p=0;p<c.times.length;++p){var d=c.times[p]*i;if(!(d<n||d>=r)){h.push(c.times[p]);for(var f=0;f<l;++f)u.push(c.values[p*l+f])}}0!==h.length&&(c.times=tl.convertArray(h,c.times.constructor),c.values=tl.convertArray(u,c.values.constructor),a.push(c))}o.tracks=a;var m=1/0;for(s=0;s<o.tracks.length;++s)m>o.tracks[s].times[0]&&(m=o.tracks[s].times[0]);for(s=0;s<o.tracks.length;++s)o.tracks[s].shift(-1*m);return o.resetDuration(),o}};function nl(e,t,n,r){this.parameterPositions=e,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new t.constructor(n),this.sampleValues=t,this.valueSize=n}function rl(e,t,n,r){nl.call(this,e,t,n,r),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0}function il(e,t,n,r){nl.call(this,e,t,n,r)}function ol(e,t,n,r){nl.call(this,e,t,n,r)}function al(e,t,n,r){if(void 0===e)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===t||0===t.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+e);this.name=e,this.times=tl.convertArray(t,this.TimeBufferType),this.values=tl.convertArray(n,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation)}function sl(e,t,n){al.call(this,e,t,n)}function cl(e,t,n,r){al.call(this,e,t,n,r)}function ll(e,t,n,r){al.call(this,e,t,n,r)}function hl(e,t,n,r){nl.call(this,e,t,n,r)}function ul(e,t,n,r){al.call(this,e,t,n,r)}function pl(e,t,n,r){al.call(this,e,t,n,r)}function dl(e,t,n,r){al.call(this,e,t,n,r)}function fl(e,t,n){this.name=e,this.tracks=n,this.duration=void 0!==t?t:-1,this.uuid=Rt.generateUUID(),this.duration<0&&this.resetDuration()}function ml(e){if(void 0===e.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");var t=function(e){switch(e.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return ll;case"vector":case"vector2":case"vector3":case"vector4":return dl;case"color":return cl;case"quaternion":return ul;case"bool":case"boolean":return sl;case"string":return pl}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+e)}(e.type);if(void 0===e.times){var n=[],r=[];tl.flattenJSON(e.keys,n,r,"value"),e.times=n,e.values=r}return void 0!==t.parse?t.parse(e):new t(e.name,e.times,e.values,e.interpolation)}Object.assign(nl.prototype,{evaluate:function(e){var t=this.parameterPositions,n=this._cachedIndex,r=t[n],i=t[n-1];e:{t:{var o;n:{r:if(!(e<r)){for(var a=n+2;;){if(void 0===r){if(e<i)break r;return n=t.length,this._cachedIndex=n,this.afterEnd_(n-1,e,i)}if(n===a)break;if(i=r,e<(r=t[++n]))break t}o=t.length;break n}if(e>=i)break e;var s=t[1];e<s&&(n=2,i=s);for(a=n-2;;){if(void 0===i)return this._cachedIndex=0,this.beforeStart_(0,e,r);if(n===a)break;if(r=i,e>=(i=t[--n-1]))break t}o=n,n=0}for(;n<o;){var c=n+o>>>1;e<t[c]?o=c:n=c+1}if(r=t[n],void 0===(i=t[n-1]))return this._cachedIndex=0,this.beforeStart_(0,e,r);if(void 0===r)return n=t.length,this._cachedIndex=n,this.afterEnd_(n-1,i,e)}this._cachedIndex=n,this.intervalChanged_(n,i,r)}return this.interpolate_(n,i,e,r)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(e){for(var t=this.resultBuffer,n=this.sampleValues,r=this.valueSize,i=e*r,o=0;o!==r;++o)t[o]=n[i+o];return t},interpolate_:function(){throw new Error("call to abstract method")},intervalChanged_:function(){}}),Object.assign(nl.prototype,{beforeStart_:nl.prototype.copySampleValue_,afterEnd_:nl.prototype.copySampleValue_}),rl.prototype=Object.assign(Object.create(nl.prototype),{constructor:rl,DefaultSettings_:{endingStart:lt,endingEnd:lt},intervalChanged_:function(e,t,n){var r=this.parameterPositions,i=e-2,o=e+1,a=r[i],s=r[o];if(void 0===a)switch(this.getSettings_().endingStart){case 2401:i=e,a=2*t-n;break;case 2402:a=t+r[i=r.length-2]-r[i+1];break;default:i=e,a=n}if(void 0===s)switch(this.getSettings_().endingEnd){case 2401:o=e,s=2*n-t;break;case 2402:o=1,s=n+r[1]-r[0];break;default:o=e-1,s=t}var c=.5*(n-t),l=this.valueSize;this._weightPrev=c/(t-a),this._weightNext=c/(s-n),this._offsetPrev=i*l,this._offsetNext=o*l},interpolate_:function(e,t,n,r){for(var i=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=e*a,c=s-a,l=this._offsetPrev,h=this._offsetNext,u=this._weightPrev,p=this._weightNext,d=(n-t)/(r-t),f=d*d,m=f*d,g=-u*m+2*u*f-u*d,v=(1+u)*m+(-1.5-2*u)*f+(-.5+u)*d+1,y=(-1-p)*m+(1.5+p)*f+.5*d,x=p*m-p*f,b=0;b!==a;++b)i[b]=g*o[l+b]+v*o[c+b]+y*o[s+b]+x*o[h+b];return i}}),il.prototype=Object.assign(Object.create(nl.prototype),{constructor:il,interpolate_:function(e,t,n,r){for(var i=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=e*a,c=s-a,l=(n-t)/(r-t),h=1-l,u=0;u!==a;++u)i[u]=o[c+u]*h+o[s+u]*l;return i}}),ol.prototype=Object.assign(Object.create(nl.prototype),{constructor:ol,interpolate_:function(e){return this.copySampleValue_(e-1)}}),Object.assign(al,{toJSON:function(e){var t,n=e.constructor;if(void 0!==n.toJSON)t=n.toJSON(e);else{t={name:e.name,times:tl.convertArray(e.times,Array),values:tl.convertArray(e.values,Array)};var r=e.getInterpolation();r!==e.DefaultInterpolation&&(t.interpolation=r)}return t.type=e.ValueTypeName,t}}),Object.assign(al.prototype,{constructor:al,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:2301,InterpolantFactoryMethodDiscrete:function(e){return new ol(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodLinear:function(e){return new il(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodSmooth:function(e){return new rl(this.times,this.values,this.getValueSize(),e)},setInterpolation:function(e){var t;switch(e){case 2300:t=this.InterpolantFactoryMethodDiscrete;break;case 2301:t=this.InterpolantFactoryMethodLinear;break;case 2302:t=this.InterpolantFactoryMethodSmooth}if(void 0===t){var n="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(e===this.DefaultInterpolation)throw new Error(n);this.setInterpolation(this.DefaultInterpolation)}return console.warn("THREE.KeyframeTrack:",n),this}return this.createInterpolant=t,this},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}},getValueSize:function(){return this.values.length/this.times.length},shift:function(e){if(0!==e)for(var t=this.times,n=0,r=t.length;n!==r;++n)t[n]+=e;return this},scale:function(e){if(1!==e)for(var t=this.times,n=0,r=t.length;n!==r;++n)t[n]*=e;return this},trim:function(e,t){for(var n=this.times,r=n.length,i=0,o=r-1;i!==r&&n[i]<e;)++i;for(;-1!==o&&n[o]>t;)--o;if(++o,0!==i||o!==r){i>=o&&(i=(o=Math.max(o,1))-1);var a=this.getValueSize();this.times=tl.arraySlice(n,i,o),this.values=tl.arraySlice(this.values,i*a,o*a)}return this},validate:function(){var e=!0,t=this.getValueSize();t-Math.floor(t)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),e=!1);var n=this.times,r=this.values,i=n.length;0===i&&(console.error("THREE.KeyframeTrack: Track is empty.",this),e=!1);for(var o=null,a=0;a!==i;a++){var s=n[a];if("number"==typeof s&&isNaN(s)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,a,s),e=!1;break}if(null!==o&&o>s){console.error("THREE.KeyframeTrack: Out of order keys.",this,a,s,o),e=!1;break}o=s}if(void 0!==r&&tl.isTypedArray(r)){a=0;for(var c=r.length;a!==c;++a){var l=r[a];if(isNaN(l)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,a,l),e=!1;break}}}return e},optimize:function(){for(var e=this.times,t=this.values,n=this.getValueSize(),r=2302===this.getInterpolation(),i=1,o=e.length-1,a=1;a<o;++a){var s=!1,c=e[a];if(c!==e[a+1]&&(1!==a||c!==c[0]))if(r)s=!0;else for(var l=a*n,h=l-n,u=l+n,p=0;p!==n;++p){var d=t[l+p];if(d!==t[h+p]||d!==t[u+p]){s=!0;break}}if(s){if(a!==i){e[i]=e[a];var f=a*n,m=i*n;for(p=0;p!==n;++p)t[m+p]=t[f+p]}++i}}if(o>0){e[i]=e[o];for(f=o*n,m=i*n,p=0;p!==n;++p)t[m+p]=t[f+p];++i}return i!==e.length&&(this.times=tl.arraySlice(e,0,i),this.values=tl.arraySlice(t,0,i*n)),this},clone:function(){var e=tl.arraySlice(this.times,0),t=tl.arraySlice(this.values,0),n=new(0,this.constructor)(this.name,e,t);return n.createInterpolant=this.createInterpolant,n}}),sl.prototype=Object.assign(Object.create(al.prototype),{constructor:sl,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),cl.prototype=Object.assign(Object.create(al.prototype),{constructor:cl,ValueTypeName:"color"}),ll.prototype=Object.assign(Object.create(al.prototype),{constructor:ll,ValueTypeName:"number"}),hl.prototype=Object.assign(Object.create(nl.prototype),{constructor:hl,interpolate_:function(e,t,n,r){for(var i=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=e*a,c=(n-t)/(r-t),l=s+a;s!==l;s+=4)Dt.slerpFlat(i,0,o,s-a,o,s,c);return i}}),ul.prototype=Object.assign(Object.create(al.prototype),{constructor:ul,ValueTypeName:"quaternion",DefaultInterpolation:2301,InterpolantFactoryMethodLinear:function(e){return new hl(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodSmooth:void 0}),pl.prototype=Object.assign(Object.create(al.prototype),{constructor:pl,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),dl.prototype=Object.assign(Object.create(al.prototype),{constructor:dl,ValueTypeName:"vector"}),Object.assign(fl,{parse:function(e){for(var t=[],n=e.tracks,r=1/(e.fps||1),i=0,o=n.length;i!==o;++i)t.push(ml(n[i]).scale(r));return new fl(e.name,e.duration,t)},toJSON:function(e){for(var t=[],n=e.tracks,r={name:e.name,duration:e.duration,tracks:t,uuid:e.uuid},i=0,o=n.length;i!==o;++i)t.push(al.toJSON(n[i]));return r},CreateFromMorphTargetSequence:function(e,t,n,r){for(var i=t.length,o=[],a=0;a<i;a++){var s=[],c=[];s.push((a+i-1)%i,a,(a+1)%i),c.push(0,1,0);var l=tl.getKeyframeOrder(s);s=tl.sortedArray(s,1,l),c=tl.sortedArray(c,1,l),r||0!==s[0]||(s.push(i),c.push(c[0])),o.push(new ll(".morphTargetInfluences["+t[a].name+"]",s,c).scale(1/n))}return new fl(e,-1,o)},findByName:function(e,t){var n=e;if(!Array.isArray(e)){var r=e;n=r.geometry&&r.geometry.animations||r.animations}for(var i=0;i<n.length;i++)if(n[i].name===t)return n[i];return null},CreateClipsFromMorphTargetSequences:function(e,t,n){for(var r={},i=/^([\w-]*?)([\d]+)$/,o=0,a=e.length;o<a;o++){var s=e[o],c=s.name.match(i);if(c&&c.length>1){var l=r[u=c[1]];l||(r[u]=l=[]),l.push(s)}}var h=[];for(var u in r)h.push(fl.CreateFromMorphTargetSequence(u,r[u],t,n));return h},parseAnimation:function(e,t){if(!e)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;for(var n=function(e,t,n,r,i){if(0!==n.length){var o=[],a=[];tl.flattenJSON(n,o,a,r),0!==o.length&&i.push(new e(t,o,a))}},r=[],i=e.name||"default",o=e.length||-1,a=e.fps||30,s=e.hierarchy||[],c=0;c<s.length;c++){var l=s[c].keys;if(l&&0!==l.length)if(l[0].morphTargets){for(var h={},u=0;u<l.length;u++)if(l[u].morphTargets)for(var p=0;p<l[u].morphTargets.length;p++)h[l[u].morphTargets[p]]=-1;for(var d in h){var f=[],m=[];for(p=0;p!==l[u].morphTargets.length;++p){var g=l[u];f.push(g.time),m.push(g.morphTarget===d?1:0)}r.push(new ll(".morphTargetInfluence["+d+"]",f,m))}o=h.length*(a||1)}else{var v=".bones["+t[c].name+"]";n(dl,v+".position",l,"pos",r),n(ul,v+".quaternion",l,"rot",r),n(dl,v+".scale",l,"scl",r)}}return 0===r.length?null:new fl(i,o,r)}}),Object.assign(fl.prototype,{resetDuration:function(){for(var e=0,t=0,n=this.tracks.length;t!==n;++t){var r=this.tracks[t];e=Math.max(e,r.times[r.times.length-1])}return this.duration=e,this},trim:function(){for(var e=0;e<this.tracks.length;e++)this.tracks[e].trim(0,this.duration);return this},validate:function(){for(var e=!0,t=0;t<this.tracks.length;t++)e=e&&this.tracks[t].validate();return e},optimize:function(){for(var e=0;e<this.tracks.length;e++)this.tracks[e].optimize();return this},clone:function(){for(var e=[],t=0;t<this.tracks.length;t++)e.push(this.tracks[t].clone());return new fl(this.name,this.duration,e)}});var gl={enabled:!1,files:{},add:function(e,t){!1!==this.enabled&&(this.files[e]=t)},get:function(e){if(!1!==this.enabled)return this.files[e]},remove:function(e){delete this.files[e]},clear:function(){this.files={}}};function vl(e,t,n){var r=this,i=!1,o=0,a=0,s=void 0,c=[];this.onStart=void 0,this.onLoad=e,this.onProgress=t,this.onError=n,this.itemStart=function(e){a++,!1===i&&void 0!==r.onStart&&r.onStart(e,o,a),i=!0},this.itemEnd=function(e){o++,void 0!==r.onProgress&&r.onProgress(e,o,a),o===a&&(i=!1,void 0!==r.onLoad&&r.onLoad())},this.itemError=function(e){void 0!==r.onError&&r.onError(e)},this.resolveURL=function(e){return s?s(e):e},this.setURLModifier=function(e){return s=e,this},this.addHandler=function(e,t){return c.push(e,t),this},this.removeHandler=function(e){var t=c.indexOf(e);return-1!==t&&c.splice(t,2),this},this.getHandler=function(e){for(var t=0,n=c.length;t<n;t+=2){var r=c[t],i=c[t+1];if(r.test(e))return i}return null}}var yl=new vl;function xl(e){this.manager=void 0!==e?e:yl,this.crossOrigin="anonymous",this.path="",this.resourcePath=""}Object.assign(xl.prototype,{load:function(){},parse:function(){},setCrossOrigin:function(e){return this.crossOrigin=e,this},setPath:function(e){return this.path=e,this},setResourcePath:function(e){return this.resourcePath=e,this}});var bl={};function wl(e){xl.call(this,e)}function _l(e){xl.call(this,e)}function Ml(e){xl.call(this,e)}function El(e){xl.call(this,e)}function Sl(e){xl.call(this,e)}function Tl(e){xl.call(this,e)}function Al(e){xl.call(this,e)}function Ll(){this.type="Curve",this.arcLengthDivisions=200}function Pl(e,t,n,r,i,o,a,s){Ll.call(this),this.type="EllipseCurve",this.aX=e||0,this.aY=t||0,this.xRadius=n||1,this.yRadius=r||1,this.aStartAngle=i||0,this.aEndAngle=o||2*Math.PI,this.aClockwise=a||!1,this.aRotation=s||0}function Cl(e,t,n,r,i,o){Pl.call(this,e,t,n,n,r,i,o),this.type="ArcCurve"}function Rl(){var e=0,t=0,n=0,r=0;function i(i,o,a,s){e=i,t=a,n=-3*i+3*o-2*a-s,r=2*i-2*o+a+s}return{initCatmullRom:function(e,t,n,r,o){i(t,n,o*(n-e),o*(r-t))},initNonuniformCatmullRom:function(e,t,n,r,o,a,s){var c=(t-e)/o-(n-e)/(o+a)+(n-t)/a,l=(n-t)/a-(r-t)/(a+s)+(r-n)/s;i(t,n,c*=a,l*=a)},calc:function(i){var o=i*i;return e+t*i+n*o+r*(o*i)}}}wl.prototype=Object.assign(Object.create(xl.prototype),{constructor:wl,load:function(e,t,n,r){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);var i=this,o=gl.get(e);if(void 0!==o)return i.manager.itemStart(e),setTimeout((function(){t&&t(o),i.manager.itemEnd(e)}),0),o;if(void 0===bl[e]){var a=e.match(/^data:(.*?)(;base64)?,(.*)$/);if(a){var s=a[1],c=!!a[2],l=a[3];l=decodeURIComponent(l),c&&(l=atob(l));try{var h,u=(this.responseType||"").toLowerCase();switch(u){case"arraybuffer":case"blob":for(var p=new Uint8Array(l.length),d=0;d<l.length;d++)p[d]=l.charCodeAt(d);h="blob"===u?new Blob([p.buffer],{type:s}):p.buffer;break;case"document":var f=new DOMParser;h=f.parseFromString(l,s);break;case"json":h=JSON.parse(l);break;default:h=l}setTimeout((function(){t&&t(h),i.manager.itemEnd(e)}),0)}catch(t){setTimeout((function(){r&&r(t),i.manager.itemError(e),i.manager.itemEnd(e)}),0)}}else{bl[e]=[],bl[e].push({onLoad:t,onProgress:n,onError:r});var m=new XMLHttpRequest;for(var g in m.open("GET",e,!0),m.addEventListener("load",(function(t){var n=this.response,r=bl[e];if(delete bl[e],200===this.status||0===this.status){0===this.status&&console.warn("THREE.FileLoader: HTTP Status 0 received."),gl.add(e,n);for(var o=0,a=r.length;o<a;o++){(s=r[o]).onLoad&&s.onLoad(n)}i.manager.itemEnd(e)}else{for(o=0,a=r.length;o<a;o++){var s;(s=r[o]).onError&&s.onError(t)}i.manager.itemError(e),i.manager.itemEnd(e)}}),!1),m.addEventListener("progress",(function(t){for(var n=bl[e],r=0,i=n.length;r<i;r++){var o=n[r];o.onProgress&&o.onProgress(t)}}),!1),m.addEventListener("error",(function(t){var n=bl[e];delete bl[e];for(var r=0,o=n.length;r<o;r++){var a=n[r];a.onError&&a.onError(t)}i.manager.itemError(e),i.manager.itemEnd(e)}),!1),m.addEventListener("abort",(function(t){var n=bl[e];delete bl[e];for(var r=0,o=n.length;r<o;r++){var a=n[r];a.onError&&a.onError(t)}i.manager.itemError(e),i.manager.itemEnd(e)}),!1),void 0!==this.responseType&&(m.responseType=this.responseType),void 0!==this.withCredentials&&(m.withCredentials=this.withCredentials),m.overrideMimeType&&m.overrideMimeType(void 0!==this.mimeType?this.mimeType:"text/plain"),this.requestHeader)m.setRequestHeader(g,this.requestHeader[g]);m.send(null)}return i.manager.itemStart(e),m}bl[e].push({onLoad:t,onProgress:n,onError:r})},setResponseType:function(e){return this.responseType=e,this},setWithCredentials:function(e){return this.withCredentials=e,this},setMimeType:function(e){return this.mimeType=e,this},setRequestHeader:function(e){return this.requestHeader=e,this}}),_l.prototype=Object.assign(Object.create(xl.prototype),{constructor:_l,load:function(e,t,n,r){var i=this,o=new wl(i.manager);o.setPath(i.path),o.load(e,(function(e){t(i.parse(JSON.parse(e)))}),n,r)},parse:function(e){for(var t=[],n=0;n<e.length;n++){var r=fl.parse(e[n]);t.push(r)}return t}}),Ml.prototype=Object.assign(Object.create(xl.prototype),{constructor:Ml,load:function(e,t,n,r){var i=this,o=[],a=new Ls;a.image=o;var s=new wl(this.manager);function c(c){s.load(e[c],(function(e){var n=i.parse(e,!0);o[c]={width:n.width,height:n.height,format:n.format,mipmaps:n.mipmaps},6===(l+=1)&&(1===n.mipmapCount&&(a.minFilter=me),a.format=n.format,a.needsUpdate=!0,t&&t(a))}),n,r)}if(s.setPath(this.path),s.setResponseType("arraybuffer"),Array.isArray(e))for(var l=0,h=0,u=e.length;h<u;++h)c(h);else s.load(e,(function(e){var n=i.parse(e,!0);if(n.isCubemap)for(var r=n.mipmaps.length/n.mipmapCount,s=0;s<r;s++){o[s]={mipmaps:[]};for(var c=0;c<n.mipmapCount;c++)o[s].mipmaps.push(n.mipmaps[s*n.mipmapCount+c]),o[s].format=n.format,o[s].width=n.width,o[s].height=n.height}else a.image.width=n.width,a.image.height=n.height,a.mipmaps=n.mipmaps;1===n.mipmapCount&&(a.minFilter=me),a.format=n.format,a.needsUpdate=!0,t&&t(a)}),n,r);return a}}),El.prototype=Object.assign(Object.create(xl.prototype),{constructor:El,load:function(e,t,n,r){var i=this,o=new wi,a=new wl(this.manager);return a.setResponseType("arraybuffer"),a.setPath(this.path),a.load(e,(function(e){var n=i.parse(e);n&&(void 0!==n.image?o.image=n.image:void 0!==n.data&&(o.image.width=n.width,o.image.height=n.height,o.image.data=n.data),o.wrapS=void 0!==n.wrapS?n.wrapS:he,o.wrapT=void 0!==n.wrapT?n.wrapT:he,o.magFilter=void 0!==n.magFilter?n.magFilter:me,o.minFilter=void 0!==n.minFilter?n.minFilter:me,o.anisotropy=void 0!==n.anisotropy?n.anisotropy:1,void 0!==n.format&&(o.format=n.format),void 0!==n.type&&(o.type=n.type),void 0!==n.mipmaps&&(o.mipmaps=n.mipmaps,o.minFilter=ve),1===n.mipmapCount&&(o.minFilter=me),o.needsUpdate=!0,t&&t(o,n))}),n,r),o}}),Sl.prototype=Object.assign(Object.create(xl.prototype),{constructor:Sl,load:function(e,t,n,r){void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);var i=this,o=gl.get(e);if(void 0!==o)return i.manager.itemStart(e),setTimeout((function(){t&&t(o),i.manager.itemEnd(e)}),0),o;var a=document.createElementNS("http://www.w3.org/1999/xhtml","img");function s(){a.removeEventListener("load",s,!1),a.removeEventListener("error",c,!1),gl.add(e,this),t&&t(this),i.manager.itemEnd(e)}function c(t){a.removeEventListener("load",s,!1),a.removeEventListener("error",c,!1),r&&r(t),i.manager.itemError(e),i.manager.itemEnd(e)}return a.addEventListener("load",s,!1),a.addEventListener("error",c,!1),"data:"!==e.substr(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),i.manager.itemStart(e),a.src=e,a}}),Tl.prototype=Object.assign(Object.create(xl.prototype),{constructor:Tl,load:function(e,t,n,r){var i=new Gi,o=new Sl(this.manager);o.setCrossOrigin(this.crossOrigin),o.setPath(this.path);var a=0;function s(n){o.load(e[n],(function(e){i.images[n]=e,6===++a&&(i.needsUpdate=!0,t&&t(i))}),void 0,r)}for(var c=0;c<e.length;++c)s(c);return i}}),Al.prototype=Object.assign(Object.create(xl.prototype),{constructor:Al,load:function(e,t,n,r){var i=new Ht,o=new Sl(this.manager);return o.setCrossOrigin(this.crossOrigin),o.setPath(this.path),o.load(e,(function(n){i.image=n;var r=e.search(/\.jpe?g($|\?)/i)>0||0===e.search(/^data\:image\/jpeg/);i.format=r?Re:Oe,i.needsUpdate=!0,void 0!==t&&t(i)}),n,r),i}}),Object.assign(Ll.prototype,{getPoint:function(){return console.warn("THREE.Curve: .getPoint() not implemented."),null},getPointAt:function(e,t){var n=this.getUtoTmapping(e);return this.getPoint(n,t)},getPoints:function(e){void 0===e&&(e=5);for(var t=[],n=0;n<=e;n++)t.push(this.getPoint(n/e));return t},getSpacedPoints:function(e){void 0===e&&(e=5);for(var t=[],n=0;n<=e;n++)t.push(this.getPointAt(n/e));return t},getLength:function(){var e=this.getLengths();return e[e.length-1]},getLengths:function(e){if(void 0===e&&(e=this.arcLengthDivisions),this.cacheArcLengths&&this.cacheArcLengths.length===e+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var t,n,r=[],i=this.getPoint(0),o=0;for(r.push(0),n=1;n<=e;n++)o+=(t=this.getPoint(n/e)).distanceTo(i),r.push(o),i=t;return this.cacheArcLengths=r,r},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(e,t){var n,r=this.getLengths(),i=0,o=r.length;n=t||e*r[o-1];for(var a,s=0,c=o-1;s<=c;)if((a=r[i=Math.floor(s+(c-s)/2)]-n)<0)s=i+1;else{if(!(a>0)){c=i;break}c=i-1}if(r[i=c]===n)return i/(o-1);var l=r[i];return(i+(n-l)/(r[i+1]-l))/(o-1)},getTangent:function(e){var t=e-1e-4,n=e+1e-4;t<0&&(t=0),n>1&&(n=1);var r=this.getPoint(t);return this.getPoint(n).clone().sub(r).normalize()},getTangentAt:function(e){var t=this.getUtoTmapping(e);return this.getTangent(t)},computeFrenetFrames:function(e,t){var n,r,i,o=new zt,a=[],s=[],c=[],l=new zt,h=new $t;for(n=0;n<=e;n++)r=n/e,a[n]=this.getTangentAt(r),a[n].normalize();s[0]=new zt,c[0]=new zt;var u=Number.MAX_VALUE,p=Math.abs(a[0].x),d=Math.abs(a[0].y),f=Math.abs(a[0].z);for(p<=u&&(u=p,o.set(1,0,0)),d<=u&&(u=d,o.set(0,1,0)),f<=u&&o.set(0,0,1),l.crossVectors(a[0],o).normalize(),s[0].crossVectors(a[0],l),c[0].crossVectors(a[0],s[0]),n=1;n<=e;n++)s[n]=s[n-1].clone(),c[n]=c[n-1].clone(),l.crossVectors(a[n-1],a[n]),l.length()>Number.EPSILON&&(l.normalize(),i=Math.acos(Rt.clamp(a[n-1].dot(a[n]),-1,1)),s[n].applyMatrix4(h.makeRotationAxis(l,i))),c[n].crossVectors(a[n],s[n]);if(!0===t)for(i=Math.acos(Rt.clamp(s[0].dot(s[e]),-1,1)),i/=e,a[0].dot(l.crossVectors(s[0],s[e]))>0&&(i=-i),n=1;n<=e;n++)s[n].applyMatrix4(h.makeRotationAxis(a[n],i*n)),c[n].crossVectors(a[n],s[n]);return{tangents:a,normals:s,binormals:c}},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.arcLengthDivisions=e.arcLengthDivisions,this},toJSON:function(){var e={metadata:{version:4.5,type:"Curve",generator:"Curve.toJSON"}};return e.arcLengthDivisions=this.arcLengthDivisions,e.type=this.type,e},fromJSON:function(e){return this.arcLengthDivisions=e.arcLengthDivisions,this}}),Pl.prototype=Object.create(Ll.prototype),Pl.prototype.constructor=Pl,Pl.prototype.isEllipseCurve=!0,Pl.prototype.getPoint=function(e,t){for(var n=t||new Ot,r=2*Math.PI,i=this.aEndAngle-this.aStartAngle,o=Math.abs(i)<Number.EPSILON;i<0;)i+=r;for(;i>r;)i-=r;i<Number.EPSILON&&(i=o?0:r),!0!==this.aClockwise||o||(i===r?i=-r:i-=r);var a=this.aStartAngle+e*i,s=this.aX+this.xRadius*Math.cos(a),c=this.aY+this.yRadius*Math.sin(a);if(0!==this.aRotation){var l=Math.cos(this.aRotation),h=Math.sin(this.aRotation),u=s-this.aX,p=c-this.aY;s=u*l-p*h+this.aX,c=u*h+p*l+this.aY}return n.set(s,c)},Pl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.aX=e.aX,this.aY=e.aY,this.xRadius=e.xRadius,this.yRadius=e.yRadius,this.aStartAngle=e.aStartAngle,this.aEndAngle=e.aEndAngle,this.aClockwise=e.aClockwise,this.aRotation=e.aRotation,this},Pl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.aX=this.aX,e.aY=this.aY,e.xRadius=this.xRadius,e.yRadius=this.yRadius,e.aStartAngle=this.aStartAngle,e.aEndAngle=this.aEndAngle,e.aClockwise=this.aClockwise,e.aRotation=this.aRotation,e},Pl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.aX=e.aX,this.aY=e.aY,this.xRadius=e.xRadius,this.yRadius=e.yRadius,this.aStartAngle=e.aStartAngle,this.aEndAngle=e.aEndAngle,this.aClockwise=e.aClockwise,this.aRotation=e.aRotation,this},Cl.prototype=Object.create(Pl.prototype),Cl.prototype.constructor=Cl,Cl.prototype.isArcCurve=!0;var Ol=new zt,Dl=new Rl,Nl=new Rl,Il=new Rl;function zl(e,t,n,r){Ll.call(this),this.type="CatmullRomCurve3",this.points=e||[],this.closed=t||!1,this.curveType=n||"centripetal",this.tension=r||.5}function kl(e,t,n,r,i){var o=.5*(r-t),a=.5*(i-n),s=e*e;return(2*n-2*r+o+a)*(e*s)+(-3*n+3*r-2*o-a)*s+o*e+n}function Fl(e,t,n,r){return function(e,t){var n=1-e;return n*n*t}(e,t)+function(e,t){return 2*(1-e)*e*t}(e,n)+function(e,t){return e*e*t}(e,r)}function Ul(e,t,n,r,i){return function(e,t){var n=1-e;return n*n*n*t}(e,t)+function(e,t){var n=1-e;return 3*n*n*e*t}(e,n)+function(e,t){return 3*(1-e)*e*e*t}(e,r)+function(e,t){return e*e*e*t}(e,i)}function Bl(e,t,n,r){Ll.call(this),this.type="CubicBezierCurve",this.v0=e||new Ot,this.v1=t||new Ot,this.v2=n||new Ot,this.v3=r||new Ot}function jl(e,t,n,r){Ll.call(this),this.type="CubicBezierCurve3",this.v0=e||new zt,this.v1=t||new zt,this.v2=n||new zt,this.v3=r||new zt}function Hl(e,t){Ll.call(this),this.type="LineCurve",this.v1=e||new Ot,this.v2=t||new Ot}function Gl(e,t){Ll.call(this),this.type="LineCurve3",this.v1=e||new zt,this.v2=t||new zt}function Vl(e,t,n){Ll.call(this),this.type="QuadraticBezierCurve",this.v0=e||new Ot,this.v1=t||new Ot,this.v2=n||new Ot}function Wl(e,t,n){Ll.call(this),this.type="QuadraticBezierCurve3",this.v0=e||new zt,this.v1=t||new zt,this.v2=n||new zt}function ql(e){Ll.call(this),this.type="SplineCurve",this.points=e||[]}zl.prototype=Object.create(Ll.prototype),zl.prototype.constructor=zl,zl.prototype.isCatmullRomCurve3=!0,zl.prototype.getPoint=function(e,t){var n,r,i,o,a=t||new zt,s=this.points,c=s.length,l=(c-(this.closed?0:1))*e,h=Math.floor(l),u=l-h;if(this.closed?h+=h>0?0:(Math.floor(Math.abs(h)/c)+1)*c:0===u&&h===c-1&&(h=c-2,u=1),this.closed||h>0?n=s[(h-1)%c]:(Ol.subVectors(s[0],s[1]).add(s[0]),n=Ol),r=s[h%c],i=s[(h+1)%c],this.closed||h+2<c?o=s[(h+2)%c]:(Ol.subVectors(s[c-1],s[c-2]).add(s[c-1]),o=Ol),"centripetal"===this.curveType||"chordal"===this.curveType){var p="chordal"===this.curveType?.5:.25,d=Math.pow(n.distanceToSquared(r),p),f=Math.pow(r.distanceToSquared(i),p),m=Math.pow(i.distanceToSquared(o),p);f<1e-4&&(f=1),d<1e-4&&(d=f),m<1e-4&&(m=f),Dl.initNonuniformCatmullRom(n.x,r.x,i.x,o.x,d,f,m),Nl.initNonuniformCatmullRom(n.y,r.y,i.y,o.y,d,f,m),Il.initNonuniformCatmullRom(n.z,r.z,i.z,o.z,d,f,m)}else"catmullrom"===this.curveType&&(Dl.initCatmullRom(n.x,r.x,i.x,o.x,this.tension),Nl.initCatmullRom(n.y,r.y,i.y,o.y,this.tension),Il.initCatmullRom(n.z,r.z,i.z,o.z,this.tension));return a.set(Dl.calc(u),Nl.calc(u),Il.calc(u)),a},zl.prototype.copy=function(e){Ll.prototype.copy.call(this,e),this.points=[];for(var t=0,n=e.points.length;t<n;t++){var r=e.points[t];this.points.push(r.clone())}return this.closed=e.closed,this.curveType=e.curveType,this.tension=e.tension,this},zl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);e.points=[];for(var t=0,n=this.points.length;t<n;t++){var r=this.points[t];e.points.push(r.toArray())}return e.closed=this.closed,e.curveType=this.curveType,e.tension=this.tension,e},zl.prototype.fromJSON=function(e){Ll.prototype.fromJSON.call(this,e),this.points=[];for(var t=0,n=e.points.length;t<n;t++){var r=e.points[t];this.points.push((new zt).fromArray(r))}return this.closed=e.closed,this.curveType=e.curveType,this.tension=e.tension,this},Bl.prototype=Object.create(Ll.prototype),Bl.prototype.constructor=Bl,Bl.prototype.isCubicBezierCurve=!0,Bl.prototype.getPoint=function(e,t){var n=t||new Ot,r=this.v0,i=this.v1,o=this.v2,a=this.v3;return n.set(Ul(e,r.x,i.x,o.x,a.x),Ul(e,r.y,i.y,o.y,a.y)),n},Bl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this},Bl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e.v3=this.v3.toArray(),e},Bl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this.v3.fromArray(e.v3),this},jl.prototype=Object.create(Ll.prototype),jl.prototype.constructor=jl,jl.prototype.isCubicBezierCurve3=!0,jl.prototype.getPoint=function(e,t){var n=t||new zt,r=this.v0,i=this.v1,o=this.v2,a=this.v3;return n.set(Ul(e,r.x,i.x,o.x,a.x),Ul(e,r.y,i.y,o.y,a.y),Ul(e,r.z,i.z,o.z,a.z)),n},jl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this},jl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e.v3=this.v3.toArray(),e},jl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this.v3.fromArray(e.v3),this},Hl.prototype=Object.create(Ll.prototype),Hl.prototype.constructor=Hl,Hl.prototype.isLineCurve=!0,Hl.prototype.getPoint=function(e,t){var n=t||new Ot;return 1===e?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(e).add(this.v1)),n},Hl.prototype.getPointAt=function(e,t){return this.getPoint(e,t)},Hl.prototype.getTangent=function(){return this.v2.clone().sub(this.v1).normalize()},Hl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v1.copy(e.v1),this.v2.copy(e.v2),this},Hl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e},Hl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this},Gl.prototype=Object.create(Ll.prototype),Gl.prototype.constructor=Gl,Gl.prototype.isLineCurve3=!0,Gl.prototype.getPoint=function(e,t){var n=t||new zt;return 1===e?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(e).add(this.v1)),n},Gl.prototype.getPointAt=function(e,t){return this.getPoint(e,t)},Gl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v1.copy(e.v1),this.v2.copy(e.v2),this},Gl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e},Gl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this},Vl.prototype=Object.create(Ll.prototype),Vl.prototype.constructor=Vl,Vl.prototype.isQuadraticBezierCurve=!0,Vl.prototype.getPoint=function(e,t){var n=t||new Ot,r=this.v0,i=this.v1,o=this.v2;return n.set(Fl(e,r.x,i.x,o.x),Fl(e,r.y,i.y,o.y)),n},Vl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this},Vl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e},Vl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this},Wl.prototype=Object.create(Ll.prototype),Wl.prototype.constructor=Wl,Wl.prototype.isQuadraticBezierCurve3=!0,Wl.prototype.getPoint=function(e,t){var n=t||new zt,r=this.v0,i=this.v1,o=this.v2;return n.set(Fl(e,r.x,i.x,o.x),Fl(e,r.y,i.y,o.y),Fl(e,r.z,i.z,o.z)),n},Wl.prototype.copy=function(e){return Ll.prototype.copy.call(this,e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this},Wl.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e},Wl.prototype.fromJSON=function(e){return Ll.prototype.fromJSON.call(this,e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this},ql.prototype=Object.create(Ll.prototype),ql.prototype.constructor=ql,ql.prototype.isSplineCurve=!0,ql.prototype.getPoint=function(e,t){var n=t||new Ot,r=this.points,i=(r.length-1)*e,o=Math.floor(i),a=i-o,s=r[0===o?o:o-1],c=r[o],l=r[o>r.length-2?r.length-1:o+1],h=r[o>r.length-3?r.length-1:o+2];return n.set(kl(a,s.x,c.x,l.x,h.x),kl(a,s.y,c.y,l.y,h.y)),n},ql.prototype.copy=function(e){Ll.prototype.copy.call(this,e),this.points=[];for(var t=0,n=e.points.length;t<n;t++){var r=e.points[t];this.points.push(r.clone())}return this},ql.prototype.toJSON=function(){var e=Ll.prototype.toJSON.call(this);e.points=[];for(var t=0,n=this.points.length;t<n;t++){var r=this.points[t];e.points.push(r.toArray())}return e},ql.prototype.fromJSON=function(e){Ll.prototype.fromJSON.call(this,e),this.points=[];for(var t=0,n=e.points.length;t<n;t++){var r=e.points[t];this.points.push((new Ot).fromArray(r))}return this};var Xl=Object.freeze({__proto__:null,ArcCurve:Cl,CatmullRomCurve3:zl,CubicBezierCurve:Bl,CubicBezierCurve3:jl,EllipseCurve:Pl,LineCurve:Hl,LineCurve3:Gl,QuadraticBezierCurve:Vl,QuadraticBezierCurve3:Wl,SplineCurve:ql});function Yl(){Ll.call(this),this.type="CurvePath",this.curves=[],this.autoClose=!1}function Zl(e){Yl.call(this),this.type="Path",this.currentPoint=new Ot,e&&this.setFromPoints(e)}function Jl(e){Zl.call(this,e),this.uuid=Rt.generateUUID(),this.type="Shape",this.holes=[]}function Ql(e,t){yn.call(this),this.type="Light",this.color=new cr(e),this.intensity=void 0!==t?t:1,this.receiveShadow=void 0}function Kl(e,t,n){Ql.call(this,e,n),this.type="HemisphereLight",this.castShadow=void 0,this.position.copy(yn.DefaultUp),this.updateMatrix(),this.groundColor=new cr(t)}function $l(e){this.camera=e,this.bias=0,this.radius=1,this.mapSize=new Ot(512,512),this.map=null,this.mapPass=null,this.matrix=new $t,this._frustum=new Ei,this._frameExtents=new Ot(1,1),this._viewportCount=1,this._viewports=[new Gt(0,0,1,1)]}function eh(){$l.call(this,new gi(50,1,.5,500))}function th(e,t,n,r,i,o){Ql.call(this,e,t),this.type="SpotLight",this.position.copy(yn.DefaultUp),this.updateMatrix(),this.target=new yn,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(e){this.intensity=e/Math.PI}}),this.distance=void 0!==n?n:0,this.angle=void 0!==r?r:Math.PI/3,this.penumbra=void 0!==i?i:0,this.decay=void 0!==o?o:1,this.shadow=new eh}function nh(){$l.call(this,new gi(90,1,.5,500)),this._frameExtents=new Ot(4,2),this._viewportCount=6,this._viewports=[new Gt(2,1,1,1),new Gt(0,1,1,1),new Gt(3,1,1,1),new Gt(1,1,1,1),new Gt(3,0,1,1),new Gt(1,0,1,1)],this._cubeDirections=[new zt(1,0,0),new zt(-1,0,0),new zt(0,0,1),new zt(0,0,-1),new zt(0,1,0),new zt(0,-1,0)],this._cubeUps=[new zt(0,1,0),new zt(0,1,0),new zt(0,1,0),new zt(0,1,0),new zt(0,0,1),new zt(0,0,-1)]}function rh(e,t,n,r){Ql.call(this,e,t),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(e){this.intensity=e/(4*Math.PI)}}),this.distance=void 0!==n?n:0,this.decay=void 0!==r?r:1,this.shadow=new nh}function ih(e,t,n,r,i,o){mi.call(this),this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=void 0!==e?e:-1,this.right=void 0!==t?t:1,this.top=void 0!==n?n:1,this.bottom=void 0!==r?r:-1,this.near=void 0!==i?i:.1,this.far=void 0!==o?o:2e3,this.updateProjectionMatrix()}function oh(){$l.call(this,new ih(-5,5,5,-5,.5,500))}function ah(e,t){Ql.call(this,e,t),this.type="DirectionalLight",this.position.copy(yn.DefaultUp),this.updateMatrix(),this.target=new yn,this.shadow=new oh}function sh(e,t){Ql.call(this,e,t),this.type="AmbientLight",this.castShadow=void 0}function ch(e,t,n,r){Ql.call(this,e,t),this.type="RectAreaLight",this.width=void 0!==n?n:10,this.height=void 0!==r?r:10}function lh(e){xl.call(this,e),this.textures={}}Yl.prototype=Object.assign(Object.create(Ll.prototype),{constructor:Yl,add:function(e){this.curves.push(e)},closePath:function(){var e=this.curves[0].getPoint(0),t=this.curves[this.curves.length-1].getPoint(1);e.equals(t)||this.curves.push(new Hl(t,e))},getPoint:function(e){for(var t=e*this.getLength(),n=this.getCurveLengths(),r=0;r<n.length;){if(n[r]>=t){var i=n[r]-t,o=this.curves[r],a=o.getLength(),s=0===a?0:1-i/a;return o.getPointAt(s)}r++}return null},getLength:function(){var e=this.getCurveLengths();return e[e.length-1]},updateArcLengths:function(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()},getCurveLengths:function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var e=[],t=0,n=0,r=this.curves.length;n<r;n++)t+=this.curves[n].getLength(),e.push(t);return this.cacheLengths=e,e},getSpacedPoints:function(e){void 0===e&&(e=40);for(var t=[],n=0;n<=e;n++)t.push(this.getPoint(n/e));return this.autoClose&&t.push(t[0]),t},getPoints:function(e){e=e||12;for(var t,n=[],r=0,i=this.curves;r<i.length;r++)for(var o=i[r],a=o&&o.isEllipseCurve?2*e:o&&(o.isLineCurve||o.isLineCurve3)?1:o&&o.isSplineCurve?e*o.points.length:e,s=o.getPoints(a),c=0;c<s.length;c++){var l=s[c];t&&t.equals(l)||(n.push(l),t=l)}return this.autoClose&&n.length>1&&!n[n.length-1].equals(n[0])&&n.push(n[0]),n},copy:function(e){Ll.prototype.copy.call(this,e),this.curves=[];for(var t=0,n=e.curves.length;t<n;t++){var r=e.curves[t];this.curves.push(r.clone())}return this.autoClose=e.autoClose,this},toJSON:function(){var e=Ll.prototype.toJSON.call(this);e.autoClose=this.autoClose,e.curves=[];for(var t=0,n=this.curves.length;t<n;t++){var r=this.curves[t];e.curves.push(r.toJSON())}return e},fromJSON:function(e){Ll.prototype.fromJSON.call(this,e),this.autoClose=e.autoClose,this.curves=[];for(var t=0,n=e.curves.length;t<n;t++){var r=e.curves[t];this.curves.push((new Xl[r.type]).fromJSON(r))}return this}}),Zl.prototype=Object.assign(Object.create(Yl.prototype),{constructor:Zl,setFromPoints:function(e){this.moveTo(e[0].x,e[0].y);for(var t=1,n=e.length;t<n;t++)this.lineTo(e[t].x,e[t].y);return this},moveTo:function(e,t){return this.currentPoint.set(e,t),this},lineTo:function(e,t){var n=new Hl(this.currentPoint.clone(),new Ot(e,t));return this.curves.push(n),this.currentPoint.set(e,t),this},quadraticCurveTo:function(e,t,n,r){var i=new Vl(this.currentPoint.clone(),new Ot(e,t),new Ot(n,r));return this.curves.push(i),this.currentPoint.set(n,r),this},bezierCurveTo:function(e,t,n,r,i,o){var a=new Bl(this.currentPoint.clone(),new Ot(e,t),new Ot(n,r),new Ot(i,o));return this.curves.push(a),this.currentPoint.set(i,o),this},splineThru:function(e){var t=new ql([this.currentPoint.clone()].concat(e));return this.curves.push(t),this.currentPoint.copy(e[e.length-1]),this},arc:function(e,t,n,r,i,o){var a=this.currentPoint.x,s=this.currentPoint.y;return this.absarc(e+a,t+s,n,r,i,o),this},absarc:function(e,t,n,r,i,o){return this.absellipse(e,t,n,n,r,i,o),this},ellipse:function(e,t,n,r,i,o,a,s){var c=this.currentPoint.x,l=this.currentPoint.y;return this.absellipse(e+c,t+l,n,r,i,o,a,s),this},absellipse:function(e,t,n,r,i,o,a,s){var c=new Pl(e,t,n,r,i,o,a,s);if(this.curves.length>0){var l=c.getPoint(0);l.equals(this.currentPoint)||this.lineTo(l.x,l.y)}this.curves.push(c);var h=c.getPoint(1);return this.currentPoint.copy(h),this},copy:function(e){return Yl.prototype.copy.call(this,e),this.currentPoint.copy(e.currentPoint),this},toJSON:function(){var e=Yl.prototype.toJSON.call(this);return e.currentPoint=this.currentPoint.toArray(),e},fromJSON:function(e){return Yl.prototype.fromJSON.call(this,e),this.currentPoint.fromArray(e.currentPoint),this}}),Jl.prototype=Object.assign(Object.create(Zl.prototype),{constructor:Jl,getPointsHoles:function(e){for(var t=[],n=0,r=this.holes.length;n<r;n++)t[n]=this.holes[n].getPoints(e);return t},extractPoints:function(e){return{shape:this.getPoints(e),holes:this.getPointsHoles(e)}},copy:function(e){Zl.prototype.copy.call(this,e),this.holes=[];for(var t=0,n=e.holes.length;t<n;t++){var r=e.holes[t];this.holes.push(r.clone())}return this},toJSON:function(){var e=Zl.prototype.toJSON.call(this);e.uuid=this.uuid,e.holes=[];for(var t=0,n=this.holes.length;t<n;t++){var r=this.holes[t];e.holes.push(r.toJSON())}return e},fromJSON:function(e){Zl.prototype.fromJSON.call(this,e),this.uuid=e.uuid,this.holes=[];for(var t=0,n=e.holes.length;t<n;t++){var r=e.holes[t];this.holes.push((new Zl).fromJSON(r))}return this}}),Ql.prototype=Object.assign(Object.create(yn.prototype),{constructor:Ql,isLight:!0,copy:function(e){return yn.prototype.copy.call(this,e),this.color.copy(e.color),this.intensity=e.intensity,this},toJSON:function(e){var t=yn.prototype.toJSON.call(this,e);return t.object.color=this.color.getHex(),t.object.intensity=this.intensity,void 0!==this.groundColor&&(t.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(t.object.distance=this.distance),void 0!==this.angle&&(t.object.angle=this.angle),void 0!==this.decay&&(t.object.decay=this.decay),void 0!==this.penumbra&&(t.object.penumbra=this.penumbra),void 0!==this.shadow&&(t.object.shadow=this.shadow.toJSON()),t}}),Kl.prototype=Object.assign(Object.create(Ql.prototype),{constructor:Kl,isHemisphereLight:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.groundColor.copy(e.groundColor),this}}),Object.assign($l.prototype,{_projScreenMatrix:new $t,_lightPositionWorld:new zt,_lookTarget:new zt,getViewportCount:function(){return this._viewportCount},getFrustum:function(){return this._frustum},updateMatrices:function(e){var t=this.camera,n=this.matrix,r=this._projScreenMatrix,i=this._lookTarget,o=this._lightPositionWorld;o.setFromMatrixPosition(e.matrixWorld),t.position.copy(o),i.setFromMatrixPosition(e.target.matrixWorld),t.lookAt(i),t.updateMatrixWorld(),r.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),this._frustum.setFromMatrix(r),n.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),n.multiply(t.projectionMatrix),n.multiply(t.matrixWorldInverse)},getViewport:function(e){return this._viewports[e]},getFrameExtents:function(){return this._frameExtents},copy:function(e){return this.camera=e.camera.clone(),this.bias=e.bias,this.radius=e.radius,this.mapSize.copy(e.mapSize),this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){var e={};return 0!==this.bias&&(e.bias=this.bias),1!==this.radius&&(e.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(e.mapSize=this.mapSize.toArray()),e.camera=this.camera.toJSON(!1).object,delete e.camera.matrix,e}}),eh.prototype=Object.assign(Object.create($l.prototype),{constructor:eh,isSpotLightShadow:!0,updateMatrices:function(e){var t=this.camera,n=2*Rt.RAD2DEG*e.angle,r=this.mapSize.width/this.mapSize.height,i=e.distance||t.far;n===t.fov&&r===t.aspect&&i===t.far||(t.fov=n,t.aspect=r,t.far=i,t.updateProjectionMatrix()),$l.prototype.updateMatrices.call(this,e)}}),th.prototype=Object.assign(Object.create(Ql.prototype),{constructor:th,isSpotLight:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.distance=e.distance,this.angle=e.angle,this.penumbra=e.penumbra,this.decay=e.decay,this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}),nh.prototype=Object.assign(Object.create($l.prototype),{constructor:nh,isPointLightShadow:!0,updateMatrices:function(e,t){void 0===t&&(t=0);var n=this.camera,r=this.matrix,i=this._lightPositionWorld,o=this._lookTarget,a=this._projScreenMatrix;i.setFromMatrixPosition(e.matrixWorld),n.position.copy(i),o.copy(n.position),o.add(this._cubeDirections[t]),n.up.copy(this._cubeUps[t]),n.lookAt(o),n.updateMatrixWorld(),r.makeTranslation(-i.x,-i.y,-i.z),a.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),this._frustum.setFromMatrix(a)}}),rh.prototype=Object.assign(Object.create(Ql.prototype),{constructor:rh,isPointLight:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.distance=e.distance,this.decay=e.decay,this.shadow=e.shadow.clone(),this}}),ih.prototype=Object.assign(Object.create(mi.prototype),{constructor:ih,isOrthographicCamera:!0,copy:function(e,t){return mi.prototype.copy.call(this,e,t),this.left=e.left,this.right=e.right,this.top=e.top,this.bottom=e.bottom,this.near=e.near,this.far=e.far,this.zoom=e.zoom,this.view=null===e.view?null:Object.assign({},e.view),this},setViewOffset:function(e,t,n,r,i,o){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=n,this.view.offsetY=r,this.view.width=i,this.view.height=o,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){var e=(this.right-this.left)/(2*this.zoom),t=(this.top-this.bottom)/(2*this.zoom),n=(this.right+this.left)/2,r=(this.top+this.bottom)/2,i=n-e,o=n+e,a=r+t,s=r-t;if(null!==this.view&&this.view.enabled){var c=this.zoom/(this.view.width/this.view.fullWidth),l=this.zoom/(this.view.height/this.view.fullHeight),h=(this.right-this.left)/this.view.width,u=(this.top-this.bottom)/this.view.height;o=(i+=h*(this.view.offsetX/c))+h*(this.view.width/c),s=(a-=u*(this.view.offsetY/l))-u*(this.view.height/l)}this.projectionMatrix.makeOrthographic(i,o,a,s,this.near,this.far),this.projectionMatrixInverse.getInverse(this.projectionMatrix)},toJSON:function(e){var t=yn.prototype.toJSON.call(this,e);return t.object.zoom=this.zoom,t.object.left=this.left,t.object.right=this.right,t.object.top=this.top,t.object.bottom=this.bottom,t.object.near=this.near,t.object.far=this.far,null!==this.view&&(t.object.view=Object.assign({},this.view)),t}}),oh.prototype=Object.assign(Object.create($l.prototype),{constructor:oh,isDirectionalLightShadow:!0,updateMatrices:function(e){$l.prototype.updateMatrices.call(this,e)}}),ah.prototype=Object.assign(Object.create(Ql.prototype),{constructor:ah,isDirectionalLight:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}),sh.prototype=Object.assign(Object.create(Ql.prototype),{constructor:sh,isAmbientLight:!0}),ch.prototype=Object.assign(Object.create(Ql.prototype),{constructor:ch,isRectAreaLight:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.width=e.width,this.height=e.height,this},toJSON:function(e){var t=Ql.prototype.toJSON.call(this,e);return t.object.width=this.width,t.object.height=this.height,t}}),lh.prototype=Object.assign(Object.create(xl.prototype),{constructor:lh,load:function(e,t,n,r){var i=this,o=new wl(i.manager);o.setPath(i.path),o.load(e,(function(e){t(i.parse(JSON.parse(e)))}),n,r)},parse:function(e){var t=this.textures;function n(e){return void 0===t[e]&&console.warn("THREE.MaterialLoader: Undefined texture",e),t[e]}var r=new el[e.type];if(void 0!==e.uuid&&(r.uuid=e.uuid),void 0!==e.name&&(r.name=e.name),void 0!==e.color&&r.color.setHex(e.color),void 0!==e.roughness&&(r.roughness=e.roughness),void 0!==e.metalness&&(r.metalness=e.metalness),void 0!==e.sheen&&(r.sheen=(new cr).setHex(e.sheen)),void 0!==e.emissive&&r.emissive.setHex(e.emissive),void 0!==e.specular&&r.specular.setHex(e.specular),void 0!==e.shininess&&(r.shininess=e.shininess),void 0!==e.clearcoat&&(r.clearcoat=e.clearcoat),void 0!==e.clearcoatRoughness&&(r.clearcoatRoughness=e.clearcoatRoughness),void 0!==e.vertexColors&&(r.vertexColors=e.vertexColors),void 0!==e.fog&&(r.fog=e.fog),void 0!==e.flatShading&&(r.flatShading=e.flatShading),void 0!==e.blending&&(r.blending=e.blending),void 0!==e.combine&&(r.combine=e.combine),void 0!==e.side&&(r.side=e.side),void 0!==e.opacity&&(r.opacity=e.opacity),void 0!==e.transparent&&(r.transparent=e.transparent),void 0!==e.alphaTest&&(r.alphaTest=e.alphaTest),void 0!==e.depthTest&&(r.depthTest=e.depthTest),void 0!==e.depthWrite&&(r.depthWrite=e.depthWrite),void 0!==e.colorWrite&&(r.colorWrite=e.colorWrite),void 0!==e.stencilWrite&&(r.stencilWrite=e.stencilWrite),void 0!==e.stencilWriteMask&&(r.stencilWriteMask=e.stencilWriteMask),void 0!==e.stencilFunc&&(r.stencilFunc=e.stencilFunc),void 0!==e.stencilRef&&(r.stencilRef=e.stencilRef),void 0!==e.stencilFuncMask&&(r.stencilFuncMask=e.stencilFuncMask),void 0!==e.stencilFail&&(r.stencilFail=e.stencilFail),void 0!==e.stencilZFail&&(r.stencilZFail=e.stencilZFail),void 0!==e.stencilZPass&&(r.stencilZPass=e.stencilZPass),void 0!==e.wireframe&&(r.wireframe=e.wireframe),void 0!==e.wireframeLinewidth&&(r.wireframeLinewidth=e.wireframeLinewidth),void 0!==e.wireframeLinecap&&(r.wireframeLinecap=e.wireframeLinecap),void 0!==e.wireframeLinejoin&&(r.wireframeLinejoin=e.wireframeLinejoin),void 0!==e.rotation&&(r.rotation=e.rotation),1!==e.linewidth&&(r.linewidth=e.linewidth),void 0!==e.dashSize&&(r.dashSize=e.dashSize),void 0!==e.gapSize&&(r.gapSize=e.gapSize),void 0!==e.scale&&(r.scale=e.scale),void 0!==e.polygonOffset&&(r.polygonOffset=e.polygonOffset),void 0!==e.polygonOffsetFactor&&(r.polygonOffsetFactor=e.polygonOffsetFactor),void 0!==e.polygonOffsetUnits&&(r.polygonOffsetUnits=e.polygonOffsetUnits),void 0!==e.skinning&&(r.skinning=e.skinning),void 0!==e.morphTargets&&(r.morphTargets=e.morphTargets),void 0!==e.morphNormals&&(r.morphNormals=e.morphNormals),void 0!==e.dithering&&(r.dithering=e.dithering),void 0!==e.visible&&(r.visible=e.visible),void 0!==e.toneMapped&&(r.toneMapped=e.toneMapped),void 0!==e.userData&&(r.userData=e.userData),void 0!==e.uniforms)for(var i in e.uniforms){var o=e.uniforms[i];switch(r.uniforms[i]={},o.type){case"t":r.uniforms[i].value=n(o.value);break;case"c":r.uniforms[i].value=(new cr).setHex(o.value);break;case"v2":r.uniforms[i].value=(new Ot).fromArray(o.value);break;case"v3":r.uniforms[i].value=(new zt).fromArray(o.value);break;case"v4":r.uniforms[i].value=(new Gt).fromArray(o.value);break;case"m3":r.uniforms[i].value=(new Ut).fromArray(o.value);case"m4":r.uniforms[i].value=(new $t).fromArray(o.value);break;default:r.uniforms[i].value=o.value}}if(void 0!==e.defines&&(r.defines=e.defines),void 0!==e.vertexShader&&(r.vertexShader=e.vertexShader),void 0!==e.fragmentShader&&(r.fragmentShader=e.fragmentShader),void 0!==e.extensions)for(var a in e.extensions)r.extensions[a]=e.extensions[a];if(void 0!==e.shading&&(r.flatShading=1===e.shading),void 0!==e.size&&(r.size=e.size),void 0!==e.sizeAttenuation&&(r.sizeAttenuation=e.sizeAttenuation),void 0!==e.map&&(r.map=n(e.map)),void 0!==e.matcap&&(r.matcap=n(e.matcap)),void 0!==e.alphaMap&&(r.alphaMap=n(e.alphaMap),r.transparent=!0),void 0!==e.bumpMap&&(r.bumpMap=n(e.bumpMap)),void 0!==e.bumpScale&&(r.bumpScale=e.bumpScale),void 0!==e.normalMap&&(r.normalMap=n(e.normalMap)),void 0!==e.normalMapType&&(r.normalMapType=e.normalMapType),void 0!==e.normalScale){var s=e.normalScale;!1===Array.isArray(s)&&(s=[s,s]),r.normalScale=(new Ot).fromArray(s)}return void 0!==e.displacementMap&&(r.displacementMap=n(e.displacementMap)),void 0!==e.displacementScale&&(r.displacementScale=e.displacementScale),void 0!==e.displacementBias&&(r.displacementBias=e.displacementBias),void 0!==e.roughnessMap&&(r.roughnessMap=n(e.roughnessMap)),void 0!==e.metalnessMap&&(r.metalnessMap=n(e.metalnessMap)),void 0!==e.emissiveMap&&(r.emissiveMap=n(e.emissiveMap)),void 0!==e.emissiveIntensity&&(r.emissiveIntensity=e.emissiveIntensity),void 0!==e.specularMap&&(r.specularMap=n(e.specularMap)),void 0!==e.envMap&&(r.envMap=n(e.envMap)),void 0!==e.envMapIntensity&&(r.envMapIntensity=e.envMapIntensity),void 0!==e.reflectivity&&(r.reflectivity=e.reflectivity),void 0!==e.refractionRatio&&(r.refractionRatio=e.refractionRatio),void 0!==e.lightMap&&(r.lightMap=n(e.lightMap)),void 0!==e.lightMapIntensity&&(r.lightMapIntensity=e.lightMapIntensity),void 0!==e.aoMap&&(r.aoMap=n(e.aoMap)),void 0!==e.aoMapIntensity&&(r.aoMapIntensity=e.aoMapIntensity),void 0!==e.gradientMap&&(r.gradientMap=n(e.gradientMap)),void 0!==e.clearcoatNormalMap&&(r.clearcoatNormalMap=n(e.clearcoatNormalMap)),void 0!==e.clearcoatNormalScale&&(r.clearcoatNormalScale=(new Ot).fromArray(e.clearcoatNormalScale)),r},setTextures:function(e){return this.textures=e,this}});var hh={decodeText:function(e){if("undefined"!=typeof TextDecoder)return(new TextDecoder).decode(e);for(var t="",n=0,r=e.length;n<r;n++)t+=String.fromCharCode(e[n]);try{return decodeURIComponent(escape(t))}catch(e){return t}},extractUrlBase:function(e){var t=e.lastIndexOf("/");return-1===t?"./":e.substr(0,t+1)}};function uh(){Ir.call(this),this.type="InstancedBufferGeometry",this.maxInstancedCount=void 0}function ph(e,t,n,r){"number"==typeof n&&(r=n,n=!1,console.error("THREE.InstancedBufferAttribute: The constructor now expects normalized as the third argument.")),gr.call(this,e,t,n),this.meshPerAttribute=r||1}function dh(e){xl.call(this,e)}uh.prototype=Object.assign(Object.create(Ir.prototype),{constructor:uh,isInstancedBufferGeometry:!0,copy:function(e){return Ir.prototype.copy.call(this,e),this.maxInstancedCount=e.maxInstancedCount,this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){var e=Ir.prototype.toJSON.call(this);return e.maxInstancedCount=this.maxInstancedCount,e.isInstancedBufferGeometry=!0,e}}),ph.prototype=Object.assign(Object.create(gr.prototype),{constructor:ph,isInstancedBufferAttribute:!0,copy:function(e){return gr.prototype.copy.call(this,e),this.meshPerAttribute=e.meshPerAttribute,this},toJSON:function(){var e=gr.prototype.toJSON.call(this);return e.meshPerAttribute=this.meshPerAttribute,e.isInstancedBufferAttribute=!0,e}}),dh.prototype=Object.assign(Object.create(xl.prototype),{constructor:dh,load:function(e,t,n,r){var i=this,o=new wl(i.manager);o.setPath(i.path),o.load(e,(function(e){t(i.parse(JSON.parse(e)))}),n,r)},parse:function(e){var t=e.isInstancedBufferGeometry?new uh:new Ir,n=e.data.index;if(void 0!==n){var r=new fh[n.type](n.array);t.setIndex(new gr(r,1))}var i=e.data.attributes;for(var o in i){var a=i[o],s=(r=new fh[a.type](a.array),new(a.isInstancedBufferAttribute?ph:gr)(r,a.itemSize,a.normalized));void 0!==a.name&&(s.name=a.name),t.setAttribute(o,s)}var c=e.data.morphAttributes;if(c)for(var o in c){for(var l=c[o],h=[],u=0,p=l.length;u<p;u++){a=l[u],s=new gr(r=new fh[a.type](a.array),a.itemSize,a.normalized);void 0!==a.name&&(s.name=a.name),h.push(s)}t.morphAttributes[o]=h}var d=e.data.groups||e.data.drawcalls||e.data.offsets;if(void 0!==d){u=0;for(var f=d.length;u!==f;++u){var m=d[u];t.addGroup(m.start,m.count,m.materialIndex)}}var g=e.data.boundingSphere;if(void 0!==g){var v=new zt;void 0!==g.center&&v.fromArray(g.center),t.boundingSphere=new In(v,g.radius)}return e.name&&(t.name=e.name),e.userData&&(t.userData=e.userData),t}});var fh={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:"undefined"!=typeof Uint8ClampedArray?Uint8ClampedArray:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};function mh(e){xl.call(this,e)}mh.prototype=Object.assign(Object.create(xl.prototype),{constructor:mh,load:function(e,t,n,r){var i=this,o=""===this.path?hh.extractUrlBase(e):this.path;this.resourcePath=this.resourcePath||o;var a=new wl(i.manager);a.setPath(this.path),a.load(e,(function(n){var o=null;try{o=JSON.parse(n)}catch(t){return void 0!==r&&r(t),void console.error("THREE:ObjectLoader: Can't parse "+e+".",t.message)}var a=o.metadata;void 0!==a&&void 0!==a.type&&"geometry"!==a.type.toLowerCase()?i.parse(o,t):console.error("THREE.ObjectLoader: Can't load "+e)}),n,r)},parse:function(e,t){var n=this.parseShape(e.shapes),r=this.parseGeometries(e.geometries,n),i=this.parseImages(e.images,(function(){void 0!==t&&t(s)})),o=this.parseTextures(e.textures,i),a=this.parseMaterials(e.materials,o),s=this.parseObject(e.object,r,a);return e.animations&&(s.animations=this.parseAnimations(e.animations)),void 0!==e.images&&0!==e.images.length||void 0!==t&&t(s),s},parseShape:function(e){var t={};if(void 0!==e)for(var n=0,r=e.length;n<r;n++){var i=(new Jl).fromJSON(e[n]);t[i.uuid]=i}return t},parseGeometries:function(e,t){var n={};if(void 0!==e)for(var r=new dh,i=0,o=e.length;i<o;i++){var a,s=e[i];switch(s.type){case"PlaneGeometry":case"PlaneBufferGeometry":a=new Gc[s.type](s.width,s.height,s.widthSegments,s.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":a=new Gc[s.type](s.width,s.height,s.depth,s.widthSegments,s.heightSegments,s.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":a=new Gc[s.type](s.radius,s.segments,s.thetaStart,s.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":a=new Gc[s.type](s.radiusTop,s.radiusBottom,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":a=new Gc[s.type](s.radius,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":a=new Gc[s.type](s.radius,s.widthSegments,s.heightSegments,s.phiStart,s.phiLength,s.thetaStart,s.thetaLength);break;case"DodecahedronGeometry":case"DodecahedronBufferGeometry":case"IcosahedronGeometry":case"IcosahedronBufferGeometry":case"OctahedronGeometry":case"OctahedronBufferGeometry":case"TetrahedronGeometry":case"TetrahedronBufferGeometry":a=new Gc[s.type](s.radius,s.detail);break;case"RingGeometry":case"RingBufferGeometry":a=new Gc[s.type](s.innerRadius,s.outerRadius,s.thetaSegments,s.phiSegments,s.thetaStart,s.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":a=new Gc[s.type](s.radius,s.tube,s.radialSegments,s.tubularSegments,s.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":a=new Gc[s.type](s.radius,s.tube,s.tubularSegments,s.radialSegments,s.p,s.q);break;case"TubeGeometry":case"TubeBufferGeometry":a=new Gc[s.type]((new Xl[s.path.type]).fromJSON(s.path),s.tubularSegments,s.radius,s.radialSegments,s.closed);break;case"LatheGeometry":case"LatheBufferGeometry":a=new Gc[s.type](s.points,s.segments,s.phiStart,s.phiLength);break;case"PolyhedronGeometry":case"PolyhedronBufferGeometry":a=new Gc[s.type](s.vertices,s.indices,s.radius,s.details);break;case"ShapeGeometry":case"ShapeBufferGeometry":for(var c=[],l=0,h=s.shapes.length;l<h;l++){var u=t[s.shapes[l]];c.push(u)}a=new Gc[s.type](c,s.curveSegments);break;case"ExtrudeGeometry":case"ExtrudeBufferGeometry":for(c=[],l=0,h=s.shapes.length;l<h;l++){u=t[s.shapes[l]];c.push(u)}var p=s.options.extrudePath;void 0!==p&&(s.options.extrudePath=(new Xl[p.type]).fromJSON(p)),a=new Gc[s.type](c,s.options);break;case"BufferGeometry":case"InstancedBufferGeometry":a=r.parse(s);break;case"Geometry":if("THREE"in window&&"LegacyJSONLoader"in THREE)a=(new THREE.LegacyJSONLoader).parse(s,this.resourcePath).geometry;else console.error('THREE.ObjectLoader: You have to import LegacyJSONLoader in order load geometry data of type "Geometry".');break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+s.type+'"');continue}a.uuid=s.uuid,void 0!==s.name&&(a.name=s.name),!0===a.isBufferGeometry&&void 0!==s.userData&&(a.userData=s.userData),n[s.uuid]=a}return n},parseMaterials:function(e,t){var n={},r={};if(void 0!==e){var i=new lh;i.setTextures(t);for(var o=0,a=e.length;o<a;o++){var s=e[o];if("MultiMaterial"===s.type){for(var c=[],l=0;l<s.materials.length;l++){var h=s.materials[l];void 0===n[h.uuid]&&(n[h.uuid]=i.parse(h)),c.push(n[h.uuid])}r[s.uuid]=c}else void 0===n[s.uuid]&&(n[s.uuid]=i.parse(s)),r[s.uuid]=n[s.uuid]}}return r},parseAnimations:function(e){for(var t=[],n=0;n<e.length;n++){var r=e[n],i=fl.parse(r);void 0!==r.uuid&&(i.uuid=r.uuid),t.push(i)}return t},parseImages:function(e,t){var n=this,r={};function i(e){return n.manager.itemStart(e),o.load(e,(function(){n.manager.itemEnd(e)}),void 0,(function(){n.manager.itemError(e),n.manager.itemEnd(e)}))}if(void 0!==e&&e.length>0){var o=new Sl(new vl(t));o.setCrossOrigin(this.crossOrigin);for(var a=0,s=e.length;a<s;a++){var c=e[a],l=c.url;if(Array.isArray(l)){r[c.uuid]=[];for(var h=0,u=l.length;h<u;h++){var p=l[h],d=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(p)?p:n.resourcePath+p;r[c.uuid].push(i(d))}}else{d=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(c.url)?c.url:n.resourcePath+c.url;r[c.uuid]=i(d)}}}return r},parseTextures:function(e,t){function n(e,t){return"number"==typeof e?e:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",e),t[e])}var r={};if(void 0!==e)for(var i=0,o=e.length;i<o;i++){var a,s=e[i];void 0===s.image&&console.warn('THREE.ObjectLoader: No "image" specified for',s.uuid),void 0===t[s.image]&&console.warn("THREE.ObjectLoader: Undefined image",s.image),(a=Array.isArray(t[s.image])?new Gi(t[s.image]):new Ht(t[s.image])).needsUpdate=!0,a.uuid=s.uuid,void 0!==s.name&&(a.name=s.name),void 0!==s.mapping&&(a.mapping=n(s.mapping,vh)),void 0!==s.offset&&a.offset.fromArray(s.offset),void 0!==s.repeat&&a.repeat.fromArray(s.repeat),void 0!==s.center&&a.center.fromArray(s.center),void 0!==s.rotation&&(a.rotation=s.rotation),void 0!==s.wrap&&(a.wrapS=n(s.wrap[0],yh),a.wrapT=n(s.wrap[1],yh)),void 0!==s.format&&(a.format=s.format),void 0!==s.type&&(a.type=s.type),void 0!==s.encoding&&(a.encoding=s.encoding),void 0!==s.minFilter&&(a.minFilter=n(s.minFilter,xh)),void 0!==s.magFilter&&(a.magFilter=n(s.magFilter,xh)),void 0!==s.anisotropy&&(a.anisotropy=s.anisotropy),void 0!==s.flipY&&(a.flipY=s.flipY),void 0!==s.premultiplyAlpha&&(a.premultiplyAlpha=s.premultiplyAlpha),void 0!==s.unpackAlignment&&(a.unpackAlignment=s.unpackAlignment),r[s.uuid]=a}return r},parseObject:function(e,t,n){var r;function i(e){return void 0===t[e]&&console.warn("THREE.ObjectLoader: Undefined geometry",e),t[e]}function o(e){if(void 0!==e){if(Array.isArray(e)){for(var t=[],r=0,i=e.length;r<i;r++){var o=e[r];void 0===n[o]&&console.warn("THREE.ObjectLoader: Undefined material",o),t.push(n[o])}return t}return void 0===n[e]&&console.warn("THREE.ObjectLoader: Undefined material",e),n[e]}}switch(e.type){case"Scene":r=new xn,void 0!==e.background&&Number.isInteger(e.background)&&(r.background=new cr(e.background)),void 0!==e.fog&&("Fog"===e.fog.type?r.fog=new za(e.fog.color,e.fog.near,e.fog.far):"FogExp2"===e.fog.type&&(r.fog=new Ia(e.fog.color,e.fog.density)));break;case"PerspectiveCamera":r=new gi(e.fov,e.aspect,e.near,e.far),void 0!==e.focus&&(r.focus=e.focus),void 0!==e.zoom&&(r.zoom=e.zoom),void 0!==e.filmGauge&&(r.filmGauge=e.filmGauge),void 0!==e.filmOffset&&(r.filmOffset=e.filmOffset),void 0!==e.view&&(r.view=Object.assign({},e.view));break;case"OrthographicCamera":r=new ih(e.left,e.right,e.top,e.bottom,e.near,e.far),void 0!==e.zoom&&(r.zoom=e.zoom),void 0!==e.view&&(r.view=Object.assign({},e.view));break;case"AmbientLight":r=new sh(e.color,e.intensity);break;case"DirectionalLight":r=new ah(e.color,e.intensity);break;case"PointLight":r=new rh(e.color,e.intensity,e.distance,e.decay);break;case"RectAreaLight":r=new ch(e.color,e.intensity,e.width,e.height);break;case"SpotLight":r=new th(e.color,e.intensity,e.distance,e.angle,e.penumbra,e.decay);break;case"HemisphereLight":r=new Kl(e.color,e.groundColor,e.intensity);break;case"SkinnedMesh":console.warn("THREE.ObjectLoader.parseObject() does not support SkinnedMesh yet.");case"Mesh":var a=i(e.geometry),s=o(e.material);r=a.bones&&a.bones.length>0?new rs(a,s):new $r(a,s);break;case"InstancedMesh":a=i(e.geometry),s=o(e.material);var c=e.count,l=e.instanceMatrix;(r=new cs(a,s,c)).instanceMatrix=new gr(new Float32Array(l.array),16);break;case"LOD":r=new ns;break;case"Line":r=new ms(i(e.geometry),o(e.material),e.mode);break;case"LineLoop":r=new xs(i(e.geometry),o(e.material));break;case"LineSegments":r=new ys(i(e.geometry),o(e.material));break;case"PointCloud":case"Points":r=new Ss(i(e.geometry),o(e.material));break;case"Sprite":r=new Ka(o(e.material));break;case"Group":r=new Ta;break;default:r=new yn}if(r.uuid=e.uuid,void 0!==e.name&&(r.name=e.name),void 0!==e.matrix?(r.matrix.fromArray(e.matrix),void 0!==e.matrixAutoUpdate&&(r.matrixAutoUpdate=e.matrixAutoUpdate),r.matrixAutoUpdate&&r.matrix.decompose(r.position,r.quaternion,r.scale)):(void 0!==e.position&&r.position.fromArray(e.position),void 0!==e.rotation&&r.rotation.fromArray(e.rotation),void 0!==e.quaternion&&r.quaternion.fromArray(e.quaternion),void 0!==e.scale&&r.scale.fromArray(e.scale)),void 0!==e.castShadow&&(r.castShadow=e.castShadow),void 0!==e.receiveShadow&&(r.receiveShadow=e.receiveShadow),e.shadow&&(void 0!==e.shadow.bias&&(r.shadow.bias=e.shadow.bias),void 0!==e.shadow.radius&&(r.shadow.radius=e.shadow.radius),void 0!==e.shadow.mapSize&&r.shadow.mapSize.fromArray(e.shadow.mapSize),void 0!==e.shadow.camera&&(r.shadow.camera=this.parseObject(e.shadow.camera))),void 0!==e.visible&&(r.visible=e.visible),void 0!==e.frustumCulled&&(r.frustumCulled=e.frustumCulled),void 0!==e.renderOrder&&(r.renderOrder=e.renderOrder),void 0!==e.userData&&(r.userData=e.userData),void 0!==e.layers&&(r.layers.mask=e.layers),void 0!==e.drawMode&&r.setDrawMode(e.drawMode),void 0!==e.children)for(var h=e.children,u=0;u<h.length;u++)r.add(this.parseObject(h[u],t,n));if("LOD"===e.type)for(var p=e.levels,d=0;d<p.length;d++){var f=p[d],m=r.getObjectByProperty("uuid",f.object);void 0!==m&&r.addLevel(m,f.distance)}return r}});var gh,vh={UVMapping:300,CubeReflectionMapping:ne,CubeRefractionMapping:re,EquirectangularReflectionMapping:ie,EquirectangularRefractionMapping:oe,SphericalReflectionMapping:ae,CubeUVReflectionMapping:se,CubeUVRefractionMapping:ce},yh={RepeatWrapping:le,ClampToEdgeWrapping:he,MirroredRepeatWrapping:ue},xh={NearestFilter:pe,NearestMipmapNearestFilter:de,NearestMipmapLinearFilter:fe,LinearFilter:me,LinearMipmapNearestFilter:ge,LinearMipmapLinearFilter:ve};function bh(e){"undefined"==typeof createImageBitmap&&console.warn("THREE.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("THREE.ImageBitmapLoader: fetch() not supported."),xl.call(this,e),this.options=void 0}function wh(){this.type="ShapePath",this.color=new cr,this.subPaths=[],this.currentPath=null}function _h(e){this.type="Font",this.data=e}function Mh(e,t,n,r,i){var o=i.glyphs[e]||i.glyphs["?"];if(o){var a,s,c,l,h,u,p,d,f=new wh;if(o.o)for(var m=o._cachedOutline||(o._cachedOutline=o.o.split(" ")),g=0,v=m.length;g<v;){switch(m[g++]){case"m":a=m[g++]*t+n,s=m[g++]*t+r,f.moveTo(a,s);break;case"l":a=m[g++]*t+n,s=m[g++]*t+r,f.lineTo(a,s);break;case"q":c=m[g++]*t+n,l=m[g++]*t+r,h=m[g++]*t+n,u=m[g++]*t+r,f.quadraticCurveTo(h,u,c,l);break;case"b":c=m[g++]*t+n,l=m[g++]*t+r,h=m[g++]*t+n,u=m[g++]*t+r,p=m[g++]*t+n,d=m[g++]*t+r,f.bezierCurveTo(h,u,p,d,c,l)}}return{offsetX:o.ha*t,path:f}}console.error('THREE.Font: character "'+e+'" does not exists in font family '+i.familyName+".")}function Eh(e){xl.call(this,e)}bh.prototype=Object.assign(Object.create(xl.prototype),{constructor:bh,setOptions:function(e){return this.options=e,this},load:function(e,t,n,r){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);var i=this,o=gl.get(e);if(void 0!==o)return i.manager.itemStart(e),setTimeout((function(){t&&t(o),i.manager.itemEnd(e)}),0),o;fetch(e).then((function(e){return e.blob()})).then((function(e){return void 0===i.options?createImageBitmap(e):createImageBitmap(e,i.options)})).then((function(n){gl.add(e,n),t&&t(n),i.manager.itemEnd(e)})).catch((function(t){r&&r(t),i.manager.itemError(e),i.manager.itemEnd(e)})),i.manager.itemStart(e)}}),Object.assign(wh.prototype,{moveTo:function(e,t){return this.currentPath=new Zl,this.subPaths.push(this.currentPath),this.currentPath.moveTo(e,t),this},lineTo:function(e,t){return this.currentPath.lineTo(e,t),this},quadraticCurveTo:function(e,t,n,r){return this.currentPath.quadraticCurveTo(e,t,n,r),this},bezierCurveTo:function(e,t,n,r,i,o){return this.currentPath.bezierCurveTo(e,t,n,r,i,o),this},splineThru:function(e){return this.currentPath.splineThru(e),this},toShapes:function(e,t){function n(e){for(var t=[],n=0,r=e.length;n<r;n++){var i=e[n],o=new Jl;o.curves=i.curves,t.push(o)}return t}function r(e,t){for(var n=t.length,r=!1,i=n-1,o=0;o<n;i=o++){var a=t[i],s=t[o],c=s.x-a.x,l=s.y-a.y;if(Math.abs(l)>Number.EPSILON){if(l<0&&(a=t[o],c=-c,s=t[i],l=-l),e.y<a.y||e.y>s.y)continue;if(e.y===a.y){if(e.x===a.x)return!0}else{var h=l*(e.x-a.x)-c*(e.y-a.y);if(0===h)return!0;if(h<0)continue;r=!r}}else{if(e.y!==a.y)continue;if(s.x<=e.x&&e.x<=a.x||a.x<=e.x&&e.x<=s.x)return!0}}return r}var i=yc.isClockWise,o=this.subPaths;if(0===o.length)return[];if(!0===t)return n(o);var a,s,c,l=[];if(1===o.length)return s=o[0],(c=new Jl).curves=s.curves,l.push(c),l;var h=!i(o[0].getPoints());h=e?!h:h;var u,p,d=[],f=[],m=[],g=0;f[g]=void 0,m[g]=[];for(var v=0,y=o.length;v<y;v++)a=i(u=(s=o[v]).getPoints()),(a=e?!a:a)?(!h&&f[g]&&g++,f[g]={s:new Jl,p:u},f[g].s.curves=s.curves,h&&g++,m[g]=[]):m[g].push({h:s,p:u[0]});if(!f[0])return n(o);if(f.length>1){for(var x=!1,b=[],w=0,_=f.length;w<_;w++)d[w]=[];for(w=0,_=f.length;w<_;w++)for(var M=m[w],E=0;E<M.length;E++){for(var S=M[E],T=!0,A=0;A<f.length;A++)r(S.p,f[A].p)&&(w!==A&&b.push({froms:w,tos:A,hole:E}),T?(T=!1,d[A].push(S)):x=!0);T&&d[w].push(S)}b.length>0&&(x||(m=d))}v=0;for(var L=f.length;v<L;v++){c=f[v].s,l.push(c);for(var P=0,C=(p=m[v]).length;P<C;P++)c.holes.push(p[P].h)}return l}}),Object.assign(_h.prototype,{isFont:!0,generateShapes:function(e,t){void 0===t&&(t=100);for(var n=[],r=function(e,t,n){for(var r=Array.from?Array.from(e):String(e).split(""),i=t/n.resolution,o=(n.boundingBox.yMax-n.boundingBox.yMin+n.underlineThickness)*i,a=[],s=0,c=0,l=0;l<r.length;l++){var h=r[l];if("\n"===h)s=0,c-=o;else{var u=Mh(h,i,s,c,n);s+=u.offsetX,a.push(u.path)}}return a}(e,t,this.data),i=0,o=r.length;i<o;i++)Array.prototype.push.apply(n,r[i].toShapes());return n}}),Eh.prototype=Object.assign(Object.create(xl.prototype),{constructor:Eh,load:function(e,t,n,r){var i=this,o=new wl(this.manager);o.setPath(this.path),o.load(e,(function(e){var n;try{n=JSON.parse(e)}catch(t){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),n=JSON.parse(e.substring(65,e.length-2))}var r=i.parse(n);t&&t(r)}),n,r)},parse:function(e){return new _h(e)}});var Sh={getContext:function(){return void 0===gh&&(gh=new(window.AudioContext||window.webkitAudioContext)),gh},setContext:function(e){gh=e}};function Th(e){xl.call(this,e)}function Ah(){this.coefficients=[];for(var e=0;e<9;e++)this.coefficients.push(new zt)}function Lh(e,t){Ql.call(this,void 0,t),this.sh=void 0!==e?e:new Ah}function Ph(e,t,n){Lh.call(this,void 0,n);var r=(new cr).set(e),i=(new cr).set(t),o=new zt(r.r,r.g,r.b),a=new zt(i.r,i.g,i.b),s=Math.sqrt(Math.PI),c=s*Math.sqrt(.75);this.sh.coefficients[0].copy(o).add(a).multiplyScalar(s),this.sh.coefficients[1].copy(o).sub(a).multiplyScalar(c)}function Ch(e,t){Lh.call(this,void 0,t);var n=(new cr).set(e);this.sh.coefficients[0].set(n.r,n.g,n.b).multiplyScalar(2*Math.sqrt(Math.PI))}Th.prototype=Object.assign(Object.create(xl.prototype),{constructor:Th,load:function(e,t,n,r){var i=new wl(this.manager);i.setResponseType("arraybuffer"),i.setPath(this.path),i.load(e,(function(e){var n=e.slice(0);Sh.getContext().decodeAudioData(n,(function(e){t(e)}))}),n,r)}}),Object.assign(Ah.prototype,{isSphericalHarmonics3:!0,set:function(e){for(var t=0;t<9;t++)this.coefficients[t].copy(e[t]);return this},zero:function(){for(var e=0;e<9;e++)this.coefficients[e].set(0,0,0);return this},getAt:function(e,t){var n=e.x,r=e.y,i=e.z,o=this.coefficients;return t.copy(o[0]).multiplyScalar(.282095),t.addScale(o[1],.488603*r),t.addScale(o[2],.488603*i),t.addScale(o[3],.488603*n),t.addScale(o[4],n*r*1.092548),t.addScale(o[5],r*i*1.092548),t.addScale(o[6],.315392*(3*i*i-1)),t.addScale(o[7],n*i*1.092548),t.addScale(o[8],.546274*(n*n-r*r)),t},getIrradianceAt:function(e,t){var n=e.x,r=e.y,i=e.z,o=this.coefficients;return t.copy(o[0]).multiplyScalar(.886227),t.addScale(o[1],1.023328*r),t.addScale(o[2],1.023328*i),t.addScale(o[3],1.023328*n),t.addScale(o[4],.858086*n*r),t.addScale(o[5],.858086*r*i),t.addScale(o[6],.743125*i*i-.247708),t.addScale(o[7],.858086*n*i),t.addScale(o[8],.429043*(n*n-r*r)),t},add:function(e){for(var t=0;t<9;t++)this.coefficients[t].add(e.coefficients[t]);return this},scale:function(e){for(var t=0;t<9;t++)this.coefficients[t].multiplyScalar(e);return this},lerp:function(e,t){for(var n=0;n<9;n++)this.coefficients[n].lerp(e.coefficients[n],t);return this},equals:function(e){for(var t=0;t<9;t++)if(!this.coefficients[t].equals(e.coefficients[t]))return!1;return!0},copy:function(e){return this.set(e.coefficients)},clone:function(){return(new this.constructor).copy(this)},fromArray:function(e,t){void 0===t&&(t=0);for(var n=this.coefficients,r=0;r<9;r++)n[r].fromArray(e,t+3*r);return this},toArray:function(e,t){void 0===e&&(e=[]),void 0===t&&(t=0);for(var n=this.coefficients,r=0;r<9;r++)n[r].toArray(e,t+3*r);return e}}),Object.assign(Ah,{getBasisAt:function(e,t){var n=e.x,r=e.y,i=e.z;t[0]=.282095,t[1]=.488603*r,t[2]=.488603*i,t[3]=.488603*n,t[4]=1.092548*n*r,t[5]=1.092548*r*i,t[6]=.315392*(3*i*i-1),t[7]=1.092548*n*i,t[8]=.546274*(n*n-r*r)}}),Lh.prototype=Object.assign(Object.create(Ql.prototype),{constructor:Lh,isLightProbe:!0,copy:function(e){return Ql.prototype.copy.call(this,e),this.sh.copy(e.sh),this.intensity=e.intensity,this},toJSON:function(e){return Ql.prototype.toJSON.call(this,e)}}),Ph.prototype=Object.assign(Object.create(Lh.prototype),{constructor:Ph,isHemisphereLightProbe:!0,copy:function(e){return Lh.prototype.copy.call(this,e),this},toJSON:function(e){return Lh.prototype.toJSON.call(this,e)}}),Ch.prototype=Object.assign(Object.create(Lh.prototype),{constructor:Ch,isAmbientLightProbe:!0,copy:function(e){return Lh.prototype.copy.call(this,e),this},toJSON:function(e){return Lh.prototype.toJSON.call(this,e)}});var Rh=new $t,Oh=new $t;function Dh(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new gi,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new gi,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1,this._cache={focus:null,fov:null,aspect:null,near:null,far:null,zoom:null,eyeSep:null}}function Nh(e){this.autoStart=void 0===e||e,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}Object.assign(Dh.prototype,{update:function(e){var t=this._cache;if(t.focus!==e.focus||t.fov!==e.fov||t.aspect!==e.aspect*this.aspect||t.near!==e.near||t.far!==e.far||t.zoom!==e.zoom||t.eyeSep!==this.eyeSep){t.focus=e.focus,t.fov=e.fov,t.aspect=e.aspect*this.aspect,t.near=e.near,t.far=e.far,t.zoom=e.zoom,t.eyeSep=this.eyeSep;var n,r,i=e.projectionMatrix.clone(),o=t.eyeSep/2,a=o*t.near/t.focus,s=t.near*Math.tan(Rt.DEG2RAD*t.fov*.5)/t.zoom;Oh.elements[12]=-o,Rh.elements[12]=o,n=-s*t.aspect+a,r=s*t.aspect+a,i.elements[0]=2*t.near/(r-n),i.elements[8]=(r+n)/(r-n),this.cameraL.projectionMatrix.copy(i),n=-s*t.aspect-a,r=s*t.aspect-a,i.elements[0]=2*t.near/(r-n),i.elements[8]=(r+n)/(r-n),this.cameraR.projectionMatrix.copy(i)}this.cameraL.matrixWorld.copy(e.matrixWorld).multiply(Oh),this.cameraR.matrixWorld.copy(e.matrixWorld).multiply(Rh)}}),Object.assign(Nh.prototype,{start:function(){this.startTime=("undefined"==typeof performance?Date:performance).now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0},stop:function(){this.getElapsedTime(),this.running=!1,this.autoStart=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){var e=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){var t=("undefined"==typeof performance?Date:performance).now();e=(t-this.oldTime)/1e3,this.oldTime=t,this.elapsedTime+=e}return e}});var Ih=new zt,zh=new Dt,kh=new zt,Fh=new zt;function Uh(){yn.call(this),this.type="AudioListener",this.context=Sh.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Nh}function Bh(e){yn.call(this),this.type="Audio",this.listener=e,this.context=e.context,this.gain=this.context.createGain(),this.gain.connect(e.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this._startedAt=0,this._pausedAt=0,this.filters=[]}Uh.prototype=Object.assign(Object.create(yn.prototype),{constructor:Uh,getInput:function(){return this.gain},removeFilter:function(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this},getFilter:function(){return this.filter},setFilter:function(e){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=e,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this},updateMatrixWorld:function(e){yn.prototype.updateMatrixWorld.call(this,e);var t=this.context.listener,n=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(Ih,zh,kh),Fh.set(0,0,-1).applyQuaternion(zh),t.positionX){var r=this.context.currentTime+this.timeDelta;t.positionX.linearRampToValueAtTime(Ih.x,r),t.positionY.linearRampToValueAtTime(Ih.y,r),t.positionZ.linearRampToValueAtTime(Ih.z,r),t.forwardX.linearRampToValueAtTime(Fh.x,r),t.forwardY.linearRampToValueAtTime(Fh.y,r),t.forwardZ.linearRampToValueAtTime(Fh.z,r),t.upX.linearRampToValueAtTime(n.x,r),t.upY.linearRampToValueAtTime(n.y,r),t.upZ.linearRampToValueAtTime(n.z,r)}else t.setPosition(Ih.x,Ih.y,Ih.z),t.setOrientation(Fh.x,Fh.y,Fh.z,n.x,n.y,n.z)}}),Bh.prototype=Object.assign(Object.create(yn.prototype),{constructor:Bh,getOutput:function(){return this.gain},setNodeSource:function(e){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=e,this.connect(),this},setMediaElementSource:function(e){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(e),this.connect(),this},setMediaStreamSource:function(e){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(e),this.connect(),this},setBuffer:function(e){return this.buffer=e,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(e){if(void 0===e&&(e=0),!0!==this.isPlaying){if(!1!==this.hasPlaybackControl){this._startedAt=this.context.currentTime+e;var t=this.context.createBufferSource();return t.buffer=this.buffer,t.loop=this.loop,t.loopStart=this.loopStart,t.loopEnd=this.loopEnd,t.onended=this.onEnded.bind(this),t.start(this._startedAt,this._pausedAt+this.offset,this.duration),this.isPlaying=!0,this.source=t,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()}console.warn("THREE.Audio: this Audio has no playback control.")}else console.warn("THREE.Audio: Audio is already playing.")},pause:function(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._pausedAt=(this.context.currentTime-this._startedAt)*this.playbackRate,this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")},stop:function(){if(!1!==this.hasPlaybackControl)return this._pausedAt=0,this.source.stop(),this.source.onended=null,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")},connect:function(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(var e=1,t=this.filters.length;e<t;e++)this.filters[e-1].connect(this.filters[e]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(var e=1,t=this.filters.length;e<t;e++)this.filters[e-1].disconnect(this.filters[e]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(e){return e||(e=[]),!0===this.isPlaying?(this.disconnect(),this.filters=e,this.connect()):this.filters=e,this},setDetune:function(e){if(this.detune=e,void 0!==this.source.detune)return!0===this.isPlaying&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this},getDetune:function(){return this.detune},getFilter:function(){return this.getFilters()[0]},setFilter:function(e){return this.setFilters(e?[e]:[])},setPlaybackRate:function(e){if(!1!==this.hasPlaybackControl)return this.playbackRate=e,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("THREE.Audio: this Audio has no playback control.")},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop},setLoop:function(e){if(!1!==this.hasPlaybackControl)return this.loop=e,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")},setLoopStart:function(e){return this.loopStart=e,this},setLoopEnd:function(e){return this.loopEnd=e,this},getVolume:function(){return this.gain.gain.value},setVolume:function(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this}});var jh=new zt,Hh=new Dt,Gh=new zt,Vh=new zt;function Wh(e){Bh.call(this,e),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}function qh(e,t){this.analyser=e.context.createAnalyser(),this.analyser.fftSize=void 0!==t?t:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),e.getOutput().connect(this.analyser)}function Xh(e,t,n){this.binding=e,this.valueSize=n;var r,i=Float64Array;switch(t){case"quaternion":r=this._slerp;break;case"string":case"bool":i=Array,r=this._select;break;default:r=this._lerp}this.buffer=new i(4*n),this._mixBufferRegion=r,this.cumulativeWeight=0,this.useCount=0,this.referenceCount=0}Wh.prototype=Object.assign(Object.create(Bh.prototype),{constructor:Wh,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(e){return this.panner.refDistance=e,this},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(e){return this.panner.rolloffFactor=e,this},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(e){return this.panner.distanceModel=e,this},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(e){return this.panner.maxDistance=e,this},setDirectionalCone:function(e,t,n){return this.panner.coneInnerAngle=e,this.panner.coneOuterAngle=t,this.panner.coneOuterGain=n,this},updateMatrixWorld:function(e){if(yn.prototype.updateMatrixWorld.call(this,e),!0!==this.hasPlaybackControl||!1!==this.isPlaying){this.matrixWorld.decompose(jh,Hh,Gh),Vh.set(0,0,1).applyQuaternion(Hh);var t=this.panner;if(t.positionX){var n=this.context.currentTime+this.listener.timeDelta;t.positionX.linearRampToValueAtTime(jh.x,n),t.positionY.linearRampToValueAtTime(jh.y,n),t.positionZ.linearRampToValueAtTime(jh.z,n),t.orientationX.linearRampToValueAtTime(Vh.x,n),t.orientationY.linearRampToValueAtTime(Vh.y,n),t.orientationZ.linearRampToValueAtTime(Vh.z,n)}else t.setPosition(jh.x,jh.y,jh.z),t.setOrientation(Vh.x,Vh.y,Vh.z)}}}),Object.assign(qh.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){for(var e=0,t=this.getFrequencyData(),n=0;n<t.length;n++)e+=t[n];return e/t.length}}),Object.assign(Xh.prototype,{accumulate:function(e,t){var n=this.buffer,r=this.valueSize,i=e*r+r,o=this.cumulativeWeight;if(0===o){for(var a=0;a!==r;++a)n[i+a]=n[a];o=t}else{var s=t/(o+=t);this._mixBufferRegion(n,i,0,s,r)}this.cumulativeWeight=o},apply:function(e){var t=this.valueSize,n=this.buffer,r=e*t+t,i=this.cumulativeWeight,o=this.binding;if(this.cumulativeWeight=0,i<1){var a=3*t;this._mixBufferRegion(n,r,a,1-i,t)}for(var s=t,c=t+t;s!==c;++s)if(n[s]!==n[s+t]){o.setValue(n,r);break}},saveOriginalState:function(){var e=this.binding,t=this.buffer,n=this.valueSize,r=3*n;e.getValue(t,r);for(var i=n,o=r;i!==o;++i)t[i]=t[r+i%n];this.cumulativeWeight=0},restoreOriginalState:function(){var e=3*this.valueSize;this.binding.setValue(this.buffer,e)},_select:function(e,t,n,r,i){if(r>=.5)for(var o=0;o!==i;++o)e[t+o]=e[n+o]},_slerp:function(e,t,n,r){Dt.slerpFlat(e,t,e,t,e,n,r)},_lerp:function(e,t,n,r,i){for(var o=1-r,a=0;a!==i;++a){var s=t+a;e[s]=e[s]*o+e[n+a]*r}}});var Yh=new RegExp("[\\[\\]\\.:\\/]","g"),Zh="[^"+"\\[\\]\\.:\\/".replace("\\.","")+"]",Jh=/((?:WC+[\/:])*)/.source.replace("WC","[^\\[\\]\\.:\\/]"),Qh=/(WCOD+)?/.source.replace("WCOD",Zh),Kh=/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC","[^\\[\\]\\.:\\/]"),$h=/\.(WC+)(?:\[(.+)\])?/.source.replace("WC","[^\\[\\]\\.:\\/]"),eu=new RegExp("^"+Jh+Qh+Kh+$h+"$"),tu=["material","materials","bones"];function nu(e,t,n){var r=n||ru.parseTrackName(t);this._targetGroup=e,this._bindings=e.subscribe_(t,r)}function ru(e,t,n){this.path=t,this.parsedPath=n||ru.parseTrackName(t),this.node=ru.findNode(e,this.parsedPath.nodeName)||e,this.rootNode=e}function iu(){this.uuid=Rt.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;var e={};this._indicesByUUID=e;for(var t=0,n=arguments.length;t!==n;++t)e[arguments[t].uuid]=t;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};var r=this;this.stats={objects:{get total(){return r._objects.length},get inUse(){return this.total-r.nCachedObjects_}},get bindingsPerObject(){return r._bindings.length}}}function ou(e,t,n){this._mixer=e,this._clip=t,this._localRoot=n||null;for(var r=t.tracks,i=r.length,o=new Array(i),a={endingStart:lt,endingEnd:lt},s=0;s!==i;++s){var c=r[s].createInterpolant(null);o[s]=c,c.settings=a}this._interpolantSettings=a,this._interpolants=o,this._propertyBindings=new Array(i),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=ct,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}function au(e){this._root=e,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}function su(e){"string"==typeof e&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),e=arguments[1]),this.value=e}function cu(e,t,n){ka.call(this,e,t),this.meshPerAttribute=n||1}function lu(e,t,n,r){this.ray=new Gn(e,t),this.near=n||0,this.far=r||1/0,this.camera=null,this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})}function hu(e,t){return e.distance-t.distance}function uu(e,t,n,r){if(!1!==e.visible&&(e.raycast(t,n),!0===r))for(var i=e.children,o=0,a=i.length;o<a;o++)uu(i[o],t,n,!0)}function pu(e,t,n){return this.radius=void 0!==e?e:1,this.phi=void 0!==t?t:0,this.theta=void 0!==n?n:0,this}function du(e,t,n){return this.radius=void 0!==e?e:1,this.theta=void 0!==t?t:0,this.y=void 0!==n?n:0,this}Object.assign(nu.prototype,{getValue:function(e,t){this.bind();var n=this._targetGroup.nCachedObjects_,r=this._bindings[n];void 0!==r&&r.getValue(e,t)},setValue:function(e,t){for(var n=this._bindings,r=this._targetGroup.nCachedObjects_,i=n.length;r!==i;++r)n[r].setValue(e,t)},bind:function(){for(var e=this._bindings,t=this._targetGroup.nCachedObjects_,n=e.length;t!==n;++t)e[t].bind()},unbind:function(){for(var e=this._bindings,t=this._targetGroup.nCachedObjects_,n=e.length;t!==n;++t)e[t].unbind()}}),Object.assign(ru,{Composite:nu,create:function(e,t,n){return e&&e.isAnimationObjectGroup?new ru.Composite(e,t,n):new ru(e,t,n)},sanitizeNodeName:function(e){return e.replace(/\s/g,"_").replace(Yh,"")},parseTrackName:function(e){var t=eu.exec(e);if(!t)throw new Error("PropertyBinding: Cannot parse trackName: "+e);var n={nodeName:t[2],objectName:t[3],objectIndex:t[4],propertyName:t[5],propertyIndex:t[6]},r=n.nodeName&&n.nodeName.lastIndexOf(".");if(void 0!==r&&-1!==r){var i=n.nodeName.substring(r+1);-1!==tu.indexOf(i)&&(n.nodeName=n.nodeName.substring(0,r),n.objectName=i)}if(null===n.propertyName||0===n.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+e);return n},findNode:function(e,t){if(!t||""===t||"root"===t||"."===t||-1===t||t===e.name||t===e.uuid)return e;if(e.skeleton){var n=e.skeleton.getBoneByName(t);if(void 0!==n)return n}if(e.children){var r=function(e){for(var n=0;n<e.length;n++){var i=e[n];if(i.name===t||i.uuid===t)return i;var o=r(i.children);if(o)return o}return null},i=r(e.children);if(i)return i}return null}}),Object.assign(ru.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(e,t){e[t]=this.node[this.propertyName]},function(e,t){for(var n=this.resolvedProperty,r=0,i=n.length;r!==i;++r)e[t++]=n[r]},function(e,t){e[t]=this.resolvedProperty[this.propertyIndex]},function(e,t){this.resolvedProperty.toArray(e,t)}],SetterByBindingTypeAndVersioning:[[function(e,t){this.targetObject[this.propertyName]=e[t]},function(e,t){this.targetObject[this.propertyName]=e[t],this.targetObject.needsUpdate=!0},function(e,t){this.targetObject[this.propertyName]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){for(var n=this.resolvedProperty,r=0,i=n.length;r!==i;++r)n[r]=e[t++]},function(e,t){for(var n=this.resolvedProperty,r=0,i=n.length;r!==i;++r)n[r]=e[t++];this.targetObject.needsUpdate=!0},function(e,t){for(var n=this.resolvedProperty,r=0,i=n.length;r!==i;++r)n[r]=e[t++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){this.resolvedProperty[this.propertyIndex]=e[t]},function(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.needsUpdate=!0},function(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){this.resolvedProperty.fromArray(e,t)},function(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.needsUpdate=!0},function(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.matrixWorldNeedsUpdate=!0}]],getValue:function(e,t){this.bind(),this.getValue(e,t)},setValue:function(e,t){this.bind(),this.setValue(e,t)},bind:function(){var e=this.node,t=this.parsedPath,n=t.objectName,r=t.propertyName,i=t.propertyIndex;if(e||(e=ru.findNode(this.rootNode,t.nodeName)||this.rootNode,this.node=e),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,e){if(n){var o=t.objectIndex;switch(n){case"materials":if(!e.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!e.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);e=e.material.materials;break;case"bones":if(!e.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);e=e.skeleton.bones;for(var a=0;a<e.length;a++)if(e[a].name===o){o=a;break}break;default:if(void 0===e[n])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);e=e[n]}if(void 0!==o){if(void 0===e[o])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,e);e=e[o]}}var s=e[r];if(void 0!==s){var c=this.Versioning.None;this.targetObject=e,void 0!==e.needsUpdate?c=this.Versioning.NeedsUpdate:void 0!==e.matrixWorldNeedsUpdate&&(c=this.Versioning.MatrixWorldNeedsUpdate);var l=this.BindingType.Direct;if(void 0!==i){if("morphTargetInfluences"===r){if(!e.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(e.geometry.isBufferGeometry){if(!e.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);for(a=0;a<this.node.geometry.morphAttributes.position.length;a++)if(e.geometry.morphAttributes.position[a].name===i){i=a;break}}else{if(!e.geometry.morphTargets)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphTargets.",this);for(a=0;a<this.node.geometry.morphTargets.length;a++)if(e.geometry.morphTargets[a].name===i){i=a;break}}}l=this.BindingType.ArrayElement,this.resolvedProperty=s,this.propertyIndex=i}else void 0!==s.fromArray&&void 0!==s.toArray?(l=this.BindingType.HasFromToArray,this.resolvedProperty=s):Array.isArray(s)?(l=this.BindingType.EntireArray,this.resolvedProperty=s):this.propertyName=r;this.getValue=this.GetterByBindingType[l],this.setValue=this.SetterByBindingTypeAndVersioning[l][c]}else{var h=t.nodeName;console.error("THREE.PropertyBinding: Trying to update property for track: "+h+"."+r+" but it wasn't found.",e)}}else console.error("THREE.PropertyBinding: Trying to update node for track: "+this.path+" but it wasn't found.")},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}),Object.assign(ru.prototype,{_getValue_unbound:ru.prototype.getValue,_setValue_unbound:ru.prototype.setValue}),Object.assign(iu.prototype,{isAnimationObjectGroup:!0,add:function(){for(var e=this._objects,t=e.length,n=this.nCachedObjects_,r=this._indicesByUUID,i=this._paths,o=this._parsedPaths,a=this._bindings,s=a.length,c=void 0,l=0,h=arguments.length;l!==h;++l){var u=arguments[l],p=u.uuid,d=r[p];if(void 0===d){d=t++,r[p]=d,e.push(u);for(var f=0,m=s;f!==m;++f)a[f].push(new ru(u,i[f],o[f]))}else if(d<n){c=e[d];var g=--n,v=e[g];r[v.uuid]=d,e[d]=v,r[p]=g,e[g]=u;for(f=0,m=s;f!==m;++f){var y=a[f],x=y[g],b=y[d];y[d]=x,void 0===b&&(b=new ru(u,i[f],o[f])),y[g]=b}}else e[d]!==c&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=n},remove:function(){for(var e=this._objects,t=this.nCachedObjects_,n=this._indicesByUUID,r=this._bindings,i=r.length,o=0,a=arguments.length;o!==a;++o){var s=arguments[o],c=s.uuid,l=n[c];if(void 0!==l&&l>=t){var h=t++,u=e[h];n[u.uuid]=l,e[l]=u,n[c]=h,e[h]=s;for(var p=0,d=i;p!==d;++p){var f=r[p],m=f[h],g=f[l];f[l]=m,f[h]=g}}}this.nCachedObjects_=t},uncache:function(){for(var e=this._objects,t=e.length,n=this.nCachedObjects_,r=this._indicesByUUID,i=this._bindings,o=i.length,a=0,s=arguments.length;a!==s;++a){var c=arguments[a],l=c.uuid,h=r[l];if(void 0!==h)if(delete r[l],h<n){var u=--n,p=e[u],d=e[y=--t];r[p.uuid]=h,e[h]=p,r[d.uuid]=u,e[u]=d,e.pop();for(var f=0,m=o;f!==m;++f){var g=(x=i[f])[u],v=x[y];x[h]=g,x[u]=v,x.pop()}}else{var y;r[(d=e[y=--t]).uuid]=h,e[h]=d,e.pop();for(f=0,m=o;f!==m;++f){var x;(x=i[f])[h]=x[y],x.pop()}}}this.nCachedObjects_=n},subscribe_:function(e,t){var n=this._bindingsIndicesByPath,r=n[e],i=this._bindings;if(void 0!==r)return i[r];var o=this._paths,a=this._parsedPaths,s=this._objects,c=s.length,l=this.nCachedObjects_,h=new Array(c);r=i.length,n[e]=r,o.push(e),a.push(t),i.push(h);for(var u=l,p=s.length;u!==p;++u){var d=s[u];h[u]=new ru(d,e,t)}return h},unsubscribe_:function(e){var t=this._bindingsIndicesByPath,n=t[e];if(void 0!==n){var r=this._paths,i=this._parsedPaths,o=this._bindings,a=o.length-1,s=o[a];t[e[a]]=n,o[n]=s,o.pop(),i[n]=i[a],i.pop(),r[n]=r[a],r.pop()}}}),Object.assign(ou.prototype,{play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(e){return this._startTime=e,this},setLoop:function(e,t){return this.loop=e,this.repetitions=t,this},setEffectiveWeight:function(e){return this.weight=e,this._effectiveWeight=this.enabled?e:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(e){return this._scheduleFading(e,0,1)},fadeOut:function(e){return this._scheduleFading(e,1,0)},crossFadeFrom:function(e,t,n){if(e.fadeOut(t),this.fadeIn(t),n){var r=this._clip.duration,i=e._clip.duration,o=i/r,a=r/i;e.warp(1,o,t),this.warp(a,1,t)}return this},crossFadeTo:function(e,t,n){return e.crossFadeFrom(this,t,n)},stopFading:function(){var e=this._weightInterpolant;return null!==e&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this},setEffectiveTimeScale:function(e){return this.timeScale=e,this._effectiveTimeScale=this.paused?0:e,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(e){return this.timeScale=this._clip.duration/e,this.stopWarping()},syncWith:function(e){return this.time=e.time,this.timeScale=e.timeScale,this.stopWarping()},halt:function(e){return this.warp(this._effectiveTimeScale,0,e)},warp:function(e,t,n){var r=this._mixer,i=r.time,o=this._timeScaleInterpolant,a=this.timeScale;null===o&&(o=r._lendControlInterpolant(),this._timeScaleInterpolant=o);var s=o.parameterPositions,c=o.sampleValues;return s[0]=i,s[1]=i+n,c[0]=e/a,c[1]=t/a,this},stopWarping:function(){var e=this._timeScaleInterpolant;return null!==e&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(e,t,n,r){if(this.enabled){var i=this._startTime;if(null!==i){var o=(e-i)*n;if(o<0||0===n)return;this._startTime=null,t=n*o}t*=this._updateTimeScale(e);var a=this._updateTime(t),s=this._updateWeight(e);if(s>0)for(var c=this._interpolants,l=this._propertyBindings,h=0,u=c.length;h!==u;++h)c[h].evaluate(a),l[h].accumulate(r,s)}else this._updateWeight(e)},_updateWeight:function(e){var t=0;if(this.enabled){t=this.weight;var n=this._weightInterpolant;if(null!==n){var r=n.evaluate(e)[0];t*=r,e>n.parameterPositions[1]&&(this.stopFading(),0===r&&(this.enabled=!1))}}return this._effectiveWeight=t,t},_updateTimeScale:function(e){var t=0;if(!this.paused){t=this.timeScale;var n=this._timeScaleInterpolant;if(null!==n)t*=n.evaluate(e)[0],e>n.parameterPositions[1]&&(this.stopWarping(),0===t?this.paused=!0:this.timeScale=t)}return this._effectiveTimeScale=t,t},_updateTime:function(e){var t=this.time+e,n=this._clip.duration,r=this.loop,i=this._loopCount,o=2202===r;if(0===e)return-1===i?t:o&&1==(1&i)?n-t:t;if(2200===r){-1===i&&(this._loopCount=0,this._setEndings(!0,!0,!1));e:{if(t>=n)t=n;else{if(!(t<0)){this.time=t;break e}t=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=t,this._mixer.dispatchEvent({type:"finished",action:this,direction:e<0?-1:1})}}else{if(-1===i&&(e>=0?(i=0,this._setEndings(!0,0===this.repetitions,o)):this._setEndings(0===this.repetitions,!0,o)),t>=n||t<0){var a=Math.floor(t/n);t-=n*a,i+=Math.abs(a);var s=this.repetitions-i;if(s<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,t=e>0?n:0,this.time=t,this._mixer.dispatchEvent({type:"finished",action:this,direction:e>0?1:-1});else{if(1===s){var c=e<0;this._setEndings(c,!c,o)}else this._setEndings(!1,!1,o);this._loopCount=i,this.time=t,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:a})}}else this.time=t;if(o&&1==(1&i))return n-t}return t},_setEndings:function(e,t,n){var r=this._interpolantSettings;n?(r.endingStart=2401,r.endingEnd=2401):(r.endingStart=e?this.zeroSlopeAtStart?2401:lt:2402,r.endingEnd=t?this.zeroSlopeAtEnd?2401:lt:2402)},_scheduleFading:function(e,t,n){var r=this._mixer,i=r.time,o=this._weightInterpolant;null===o&&(o=r._lendControlInterpolant(),this._weightInterpolant=o);var a=o.parameterPositions,s=o.sampleValues;return a[0]=i,s[0]=t,a[1]=i+e,s[1]=n,this}}),au.prototype=Object.assign(Object.create(Lt.prototype),{constructor:au,_bindAction:function(e,t){var n=e._localRoot||this._root,r=e._clip.tracks,i=r.length,o=e._propertyBindings,a=e._interpolants,s=n.uuid,c=this._bindingsByRootAndName,l=c[s];void 0===l&&(l={},c[s]=l);for(var h=0;h!==i;++h){var u=r[h],p=u.name,d=l[p];if(void 0!==d)o[h]=d;else{if(void 0!==(d=o[h])){null===d._cacheIndex&&(++d.referenceCount,this._addInactiveBinding(d,s,p));continue}var f=t&&t._propertyBindings[h].binding.parsedPath;++(d=new Xh(ru.create(n,p,f),u.ValueTypeName,u.getValueSize())).referenceCount,this._addInactiveBinding(d,s,p),o[h]=d}a[h].resultBuffer=d.buffer}},_activateAction:function(e){if(!this._isActiveAction(e)){if(null===e._cacheIndex){var t=(e._localRoot||this._root).uuid,n=e._clip.uuid,r=this._actionsByClip[n];this._bindAction(e,r&&r.knownActions[0]),this._addInactiveAction(e,n,t)}for(var i=e._propertyBindings,o=0,a=i.length;o!==a;++o){var s=i[o];0==s.useCount++&&(this._lendBinding(s),s.saveOriginalState())}this._lendAction(e)}},_deactivateAction:function(e){if(this._isActiveAction(e)){for(var t=e._propertyBindings,n=0,r=t.length;n!==r;++n){var i=t[n];0==--i.useCount&&(i.restoreOriginalState(),this._takeBackBinding(i))}this._takeBackAction(e)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var e=this;this.stats={actions:{get total(){return e._actions.length},get inUse(){return e._nActiveActions}},bindings:{get total(){return e._bindings.length},get inUse(){return e._nActiveBindings}},controlInterpolants:{get total(){return e._controlInterpolants.length},get inUse(){return e._nActiveControlInterpolants}}}},_isActiveAction:function(e){var t=e._cacheIndex;return null!==t&&t<this._nActiveActions},_addInactiveAction:function(e,t,n){var r=this._actions,i=this._actionsByClip,o=i[t];if(void 0===o)o={knownActions:[e],actionByRoot:{}},e._byClipCacheIndex=0,i[t]=o;else{var a=o.knownActions;e._byClipCacheIndex=a.length,a.push(e)}e._cacheIndex=r.length,r.push(e),o.actionByRoot[n]=e},_removeInactiveAction:function(e){var t=this._actions,n=t[t.length-1],r=e._cacheIndex;n._cacheIndex=r,t[r]=n,t.pop(),e._cacheIndex=null;var i=e._clip.uuid,o=this._actionsByClip,a=o[i],s=a.knownActions,c=s[s.length-1],l=e._byClipCacheIndex;c._byClipCacheIndex=l,s[l]=c,s.pop(),e._byClipCacheIndex=null,delete a.actionByRoot[(e._localRoot||this._root).uuid],0===s.length&&delete o[i],this._removeInactiveBindingsForAction(e)},_removeInactiveBindingsForAction:function(e){for(var t=e._propertyBindings,n=0,r=t.length;n!==r;++n){var i=t[n];0==--i.referenceCount&&this._removeInactiveBinding(i)}},_lendAction:function(e){var t=this._actions,n=e._cacheIndex,r=this._nActiveActions++,i=t[r];e._cacheIndex=r,t[r]=e,i._cacheIndex=n,t[n]=i},_takeBackAction:function(e){var t=this._actions,n=e._cacheIndex,r=--this._nActiveActions,i=t[r];e._cacheIndex=r,t[r]=e,i._cacheIndex=n,t[n]=i},_addInactiveBinding:function(e,t,n){var r=this._bindingsByRootAndName,i=r[t],o=this._bindings;void 0===i&&(i={},r[t]=i),i[n]=e,e._cacheIndex=o.length,o.push(e)},_removeInactiveBinding:function(e){var t=this._bindings,n=e.binding,r=n.rootNode.uuid,i=n.path,o=this._bindingsByRootAndName,a=o[r],s=t[t.length-1],c=e._cacheIndex;s._cacheIndex=c,t[c]=s,t.pop(),delete a[i],0===Object.keys(a).length&&delete o[r]},_lendBinding:function(e){var t=this._bindings,n=e._cacheIndex,r=this._nActiveBindings++,i=t[r];e._cacheIndex=r,t[r]=e,i._cacheIndex=n,t[n]=i},_takeBackBinding:function(e){var t=this._bindings,n=e._cacheIndex,r=--this._nActiveBindings,i=t[r];e._cacheIndex=r,t[r]=e,i._cacheIndex=n,t[n]=i},_lendControlInterpolant:function(){var e=this._controlInterpolants,t=this._nActiveControlInterpolants++,n=e[t];return void 0===n&&((n=new il(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer)).__cacheIndex=t,e[t]=n),n},_takeBackControlInterpolant:function(e){var t=this._controlInterpolants,n=e.__cacheIndex,r=--this._nActiveControlInterpolants,i=t[r];e.__cacheIndex=r,t[r]=e,i.__cacheIndex=n,t[n]=i},_controlInterpolantsResultBuffer:new Float32Array(1),clipAction:function(e,t){var n=t||this._root,r=n.uuid,i="string"==typeof e?fl.findByName(n,e):e,o=null!==i?i.uuid:e,a=this._actionsByClip[o],s=null;if(void 0!==a){var c=a.actionByRoot[r];if(void 0!==c)return c;s=a.knownActions[0],null===i&&(i=s._clip)}if(null===i)return null;var l=new ou(this,i,t);return this._bindAction(l,s),this._addInactiveAction(l,o,r),l},existingAction:function(e,t){var n=t||this._root,r=n.uuid,i="string"==typeof e?fl.findByName(n,e):e,o=i?i.uuid:e,a=this._actionsByClip[o];return void 0!==a&&a.actionByRoot[r]||null},stopAllAction:function(){var e=this._actions,t=this._nActiveActions,n=this._bindings,r=this._nActiveBindings;this._nActiveActions=0,this._nActiveBindings=0;for(var i=0;i!==t;++i)e[i].reset();for(i=0;i!==r;++i)n[i].useCount=0;return this},update:function(e){e*=this.timeScale;for(var t=this._actions,n=this._nActiveActions,r=this.time+=e,i=Math.sign(e),o=this._accuIndex^=1,a=0;a!==n;++a){t[a]._update(r,e,i,o)}var s=this._bindings,c=this._nActiveBindings;for(a=0;a!==c;++a)s[a].apply(o);return this},setTime:function(e){this.time=0;for(var t=0;t<this._actions.length;t++)this._actions[t].time=0;return this.update(e)},getRoot:function(){return this._root},uncacheClip:function(e){var t=this._actions,n=e.uuid,r=this._actionsByClip,i=r[n];if(void 0!==i){for(var o=i.knownActions,a=0,s=o.length;a!==s;++a){var c=o[a];this._deactivateAction(c);var l=c._cacheIndex,h=t[t.length-1];c._cacheIndex=null,c._byClipCacheIndex=null,h._cacheIndex=l,t[l]=h,t.pop(),this._removeInactiveBindingsForAction(c)}delete r[n]}},uncacheRoot:function(e){var t=e.uuid,n=this._actionsByClip;for(var r in n){var i=n[r].actionByRoot[t];void 0!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}var o=this._bindingsByRootAndName[t];if(void 0!==o)for(var a in o){var s=o[a];s.restoreOriginalState(),this._removeInactiveBinding(s)}},uncacheAction:function(e,t){var n=this.existingAction(e,t);null!==n&&(this._deactivateAction(n),this._removeInactiveAction(n))}}),su.prototype.clone=function(){return new su(void 0===this.value.clone?this.value:this.value.clone())},cu.prototype=Object.assign(Object.create(ka.prototype),{constructor:cu,isInstancedInterleavedBuffer:!0,copy:function(e){return ka.prototype.copy.call(this,e),this.meshPerAttribute=e.meshPerAttribute,this}}),Object.assign(lu.prototype,{linePrecision:1,set:function(e,t){this.ray.set(e,t)},setFromCamera:function(e,t){t&&t.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(t.matrixWorld),this.ray.direction.set(e.x,e.y,.5).unproject(t).sub(this.ray.origin).normalize(),this.camera=t):t&&t.isOrthographicCamera?(this.ray.origin.set(e.x,e.y,(t.near+t.far)/(t.near-t.far)).unproject(t),this.ray.direction.set(0,0,-1).transformDirection(t.matrixWorld),this.camera=t):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(e,t,n){var r=n||[];return uu(e,this,r,t),r.sort(hu),r},intersectObjects:function(e,t,n){var r=n||[];if(!1===Array.isArray(e))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),r;for(var i=0,o=e.length;i<o;i++)uu(e[i],this,r,t);return r.sort(hu),r}}),Object.assign(pu.prototype,{set:function(e,t,n){return this.radius=e,this.phi=t,this.theta=n,this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.radius=e.radius,this.phi=e.phi,this.theta=e.theta,this},makeSafe:function(){return this.phi=Math.max(1e-6,Math.min(Math.PI-1e-6,this.phi)),this},setFromVector3:function(e){return this.setFromCartesianCoords(e.x,e.y,e.z)},setFromCartesianCoords:function(e,t,n){return this.radius=Math.sqrt(e*e+t*t+n*n),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(e,n),this.phi=Math.acos(Rt.clamp(t/this.radius,-1,1))),this}}),Object.assign(du.prototype,{set:function(e,t,n){return this.radius=e,this.theta=t,this.y=n,this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.radius=e.radius,this.theta=e.theta,this.y=e.y,this},setFromVector3:function(e){return this.setFromCartesianCoords(e.x,e.y,e.z)},setFromCartesianCoords:function(e,t,n){return this.radius=Math.sqrt(e*e+n*n),this.theta=Math.atan2(e,n),this.y=t,this}});var fu=new Ot;function mu(e,t){this.min=void 0!==e?e:new Ot(1/0,1/0),this.max=void 0!==t?t:new Ot(-1/0,-1/0)}Object.assign(mu.prototype,{set:function(e,t){return this.min.copy(e),this.max.copy(t),this},setFromPoints:function(e){this.makeEmpty();for(var t=0,n=e.length;t<n;t++)this.expandByPoint(e[t]);return this},setFromCenterAndSize:function(e,t){var n=fu.copy(t).multiplyScalar(.5);return this.min.copy(e).sub(n),this.max.copy(e).add(n),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.min.copy(e.min),this.max.copy(e.max),this},makeEmpty:function(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},getCenter:function(e){return void 0===e&&(console.warn("THREE.Box2: .getCenter() target is now required"),e=new Ot),this.isEmpty()?e.set(0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(e){return void 0===e&&(console.warn("THREE.Box2: .getSize() target is now required"),e=new Ot),this.isEmpty()?e.set(0,0):e.subVectors(this.max,this.min)},expandByPoint:function(e){return this.min.min(e),this.max.max(e),this},expandByVector:function(e){return this.min.sub(e),this.max.add(e),this},expandByScalar:function(e){return this.min.addScalar(-e),this.max.addScalar(e),this},containsPoint:function(e){return!(e.x<this.min.x||e.x>this.max.x||e.y<this.min.y||e.y>this.max.y)},containsBox:function(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y},getParameter:function(e,t){return void 0===t&&(console.warn("THREE.Box2: .getParameter() target is now required"),t=new Ot),t.set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(e){return!(e.max.x<this.min.x||e.min.x>this.max.x||e.max.y<this.min.y||e.min.y>this.max.y)},clampPoint:function(e,t){return void 0===t&&(console.warn("THREE.Box2: .clampPoint() target is now required"),t=new Ot),t.copy(e).clamp(this.min,this.max)},distanceToPoint:function(e){return fu.copy(e).clamp(this.min,this.max).sub(e).length()},intersect:function(e){return this.min.max(e.min),this.max.min(e.max),this},union:function(e){return this.min.min(e.min),this.max.max(e.max),this},translate:function(e){return this.min.add(e),this.max.add(e),this},equals:function(e){return e.min.equals(this.min)&&e.max.equals(this.max)}});var gu=new zt,vu=new zt;function yu(e,t){this.start=void 0!==e?e:new zt,this.end=void 0!==t?t:new zt}function xu(e){yn.call(this),this.material=e,this.render=function(){}}Object.assign(yu.prototype,{set:function(e,t){return this.start.copy(e),this.end.copy(t),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.start.copy(e.start),this.end.copy(e.end),this},getCenter:function(e){return void 0===e&&(console.warn("THREE.Line3: .getCenter() target is now required"),e=new zt),e.addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(e){return void 0===e&&(console.warn("THREE.Line3: .delta() target is now required"),e=new zt),e.subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(e,t){return void 0===t&&(console.warn("THREE.Line3: .at() target is now required"),t=new zt),this.delta(t).multiplyScalar(e).add(this.start)},closestPointToPointParameter:function(e,t){gu.subVectors(e,this.start),vu.subVectors(this.end,this.start);var n=vu.dot(vu),r=vu.dot(gu)/n;return t&&(r=Rt.clamp(r,0,1)),r},closestPointToPoint:function(e,t,n){var r=this.closestPointToPointParameter(e,t);return void 0===n&&(console.warn("THREE.Line3: .closestPointToPoint() target is now required"),n=new zt),this.delta(n).multiplyScalar(r).add(this.start)},applyMatrix4:function(e){return this.start.applyMatrix4(e),this.end.applyMatrix4(e),this},equals:function(e){return e.start.equals(this.start)&&e.end.equals(this.end)}}),xu.prototype=Object.create(yn.prototype),xu.prototype.constructor=xu,xu.prototype.isImmediateRenderObject=!0;var bu=new zt,wu=new zt,_u=new Ut,Mu=["a","b","c"];function Eu(e,t,n,r){this.object=e,this.size=void 0!==t?t:1;var i=void 0!==n?n:16711680,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=3*s.faces.length:s&&s.isBufferGeometry&&(a=s.attributes.normal.count);var c=new Ir,l=new Er(2*a*3,3);c.setAttribute("position",l),ys.call(this,c,new ls({color:i,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}Eu.prototype=Object.create(ys.prototype),Eu.prototype.constructor=Eu,Eu.prototype.update=function(){this.object.updateMatrixWorld(!0),_u.getNormalMatrix(this.object.matrixWorld);var e=this.object.matrixWorld,t=this.geometry.attributes.position,n=this.object.geometry;if(n&&n.isGeometry)for(var r=n.vertices,i=n.faces,o=0,a=0,s=i.length;a<s;a++)for(var c=i[a],l=0,h=c.vertexNormals.length;l<h;l++){var u=r[c[Mu[l]]],p=c.vertexNormals[l];bu.copy(u).applyMatrix4(e),wu.copy(p).applyMatrix3(_u).normalize().multiplyScalar(this.size).add(bu),t.setXYZ(o,bu.x,bu.y,bu.z),o+=1,t.setXYZ(o,wu.x,wu.y,wu.z),o+=1}else if(n&&n.isBufferGeometry){var d=n.attributes.position,f=n.attributes.normal;for(o=0,l=0,h=d.count;l<h;l++)bu.set(d.getX(l),d.getY(l),d.getZ(l)).applyMatrix4(e),wu.set(f.getX(l),f.getY(l),f.getZ(l)),wu.applyMatrix3(_u).normalize().multiplyScalar(this.size).add(bu),t.setXYZ(o,bu.x,bu.y,bu.z),o+=1,t.setXYZ(o,wu.x,wu.y,wu.z),o+=1}t.needsUpdate=!0};var Su=new zt;function Tu(e,t){yn.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.color=t;for(var n=new Ir,r=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],i=0,o=1;i<32;i++,o++){var a=i/32*Math.PI*2,s=o/32*Math.PI*2;r.push(Math.cos(a),Math.sin(a),1,Math.cos(s),Math.sin(s),1)}n.setAttribute("position",new Er(r,3));var c=new ls({fog:!1});this.cone=new ys(n,c),this.add(this.cone),this.update()}Tu.prototype=Object.create(yn.prototype),Tu.prototype.constructor=Tu,Tu.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},Tu.prototype.update=function(){this.light.updateMatrixWorld();var e=this.light.distance?this.light.distance:1e3,t=e*Math.tan(this.light.angle);this.cone.scale.set(t,t,e),Su.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(Su),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)};var Au=new zt,Lu=new $t,Pu=new $t;function Cu(e){for(var t=function e(t){var n=[];t&&t.isBone&&n.push(t);for(var r=0;r<t.children.length;r++)n.push.apply(n,e(t.children[r]));return n}(e),n=new Ir,r=[],i=[],o=new cr(0,0,1),a=new cr(0,1,0),s=0;s<t.length;s++){var c=t[s];c.parent&&c.parent.isBone&&(r.push(0,0,0),r.push(0,0,0),i.push(o.r,o.g,o.b),i.push(a.r,a.g,a.b))}n.setAttribute("position",new Er(r,3)),n.setAttribute("color",new Er(i,3));var l=new ls({vertexColors:g,depthTest:!1,depthWrite:!1,transparent:!0});ys.call(this,n,l),this.root=e,this.bones=t,this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1}function Ru(e,t,n){this.light=e,this.light.updateMatrixWorld(),this.color=n;var r=new Lc(t,4,2),i=new mr({wireframe:!0,fog:!1});$r.call(this,r,i),this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}function Ou(e,t){this.type="RectAreaLightHelper",this.light=e,this.color=t;var n=new Ir;n.setAttribute("position",new Er([1,1,0,-1,1,0,-1,-1,0,1,-1,0,1,1,0],3)),n.computeBoundingSphere();var r=new ls({fog:!1});ms.call(this,n,r);var i=new Ir;i.setAttribute("position",new Er([1,1,0,-1,1,0,-1,-1,0,1,1,0,-1,-1,0,1,-1,0],3)),i.computeBoundingSphere(),this.add(new $r(i,new mr({side:p,fog:!1}))),this.update()}Cu.prototype=Object.create(ys.prototype),Cu.prototype.constructor=Cu,Cu.prototype.updateMatrixWorld=function(e){var t=this.bones,n=this.geometry,r=n.getAttribute("position");Pu.getInverse(this.root.matrixWorld);for(var i=0,o=0;i<t.length;i++){var a=t[i];a.parent&&a.parent.isBone&&(Lu.multiplyMatrices(Pu,a.matrixWorld),Au.setFromMatrixPosition(Lu),r.setXYZ(o,Au.x,Au.y,Au.z),Lu.multiplyMatrices(Pu,a.parent.matrixWorld),Au.setFromMatrixPosition(Lu),r.setXYZ(o+1,Au.x,Au.y,Au.z),o+=2)}n.getAttribute("position").needsUpdate=!0,yn.prototype.updateMatrixWorld.call(this,e)},Ru.prototype=Object.create($r.prototype),Ru.prototype.constructor=Ru,Ru.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},Ru.prototype.update=function(){void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)},Ou.prototype=Object.create(ms.prototype),Ou.prototype.constructor=Ou,Ou.prototype.update=function(){if(this.scale.set(.5*this.light.width,.5*this.light.height,1),void 0!==this.color)this.material.color.set(this.color),this.children[0].material.color.set(this.color);else{this.material.color.copy(this.light.color).multiplyScalar(this.light.intensity);var e=this.material.color,t=Math.max(e.r,e.g,e.b);t>1&&e.multiplyScalar(1/t),this.children[0].material.color.copy(this.material.color)}},Ou.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose(),this.children[0].geometry.dispose(),this.children[0].material.dispose()};var Du=new zt,Nu=new cr,Iu=new cr;function zu(e,t,n){yn.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.color=n;var r=new Us(t);r.rotateY(.5*Math.PI),this.material=new mr({wireframe:!0,fog:!1}),void 0===this.color&&(this.material.vertexColors=g);var i=r.getAttribute("position"),o=new Float32Array(3*i.count);r.setAttribute("color",new gr(o,3)),this.add(new $r(r,this.material)),this.update()}function ku(e,t){this.lightProbe=e,this.size=t;var n={GAMMA_OUTPUT:""},r=new fi({defines:n,uniforms:{sh:{value:this.lightProbe.sh.coefficients},intensity:{value:this.lightProbe.intensity}},vertexShader:["varying vec3 vNormal;","void main() {","\tvNormal = normalize( normalMatrix * normal );","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"),fragmentShader:["#define RECIPROCAL_PI 0.318309886","vec3 inverseTransformDirection( in vec3 normal, in mat4 matrix ) {","\t// matrix is assumed to be orthogonal","\treturn normalize( ( vec4( normal, 0.0 ) * matrix ).xyz );","}","vec3 linearToOutput( in vec3 a ) {","\t#ifdef GAMMA_OUTPUT","\t\treturn pow( a, vec3( 1.0 / float( GAMMA_FACTOR ) ) );","\t#else","\t\treturn a;","\t#endif","}","// source: https://graphics.stanford.edu/papers/envmap/envmap.pdf","vec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {","\t// normal is assumed to have unit length","\tfloat x = normal.x, y = normal.y, z = normal.z;","\t// band 0","\tvec3 result = shCoefficients[ 0 ] * 0.886227;","\t// band 1","\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;","\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;","\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;","\t// band 2","\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;","\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;","\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );","\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;","\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );","\treturn result;","}","uniform vec3 sh[ 9 ]; // sh coefficients","uniform float intensity; // light probe intensity","varying vec3 vNormal;","void main() {","\tvec3 normal = normalize( vNormal );","\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );","\tvec3 irradiance = shGetIrradianceAt( worldNormal, sh );","\tvec3 outgoingLight = RECIPROCAL_PI * irradiance * intensity;","\toutgoingLight = linearToOutput( outgoingLight );","\tgl_FragColor = vec4( outgoingLight, 1.0 );","}"].join("\n")}),i=new Lc(1,32,16);$r.call(this,i,r),this.onBeforeRender()}function Fu(e,t,n,r){e=e||10,t=t||10,n=new cr(void 0!==n?n:4473924),r=new cr(void 0!==r?r:8947848);for(var i=t/2,o=e/t,a=e/2,s=[],c=[],l=0,h=0,u=-a;l<=t;l++,u+=o){s.push(-a,0,u,a,0,u),s.push(u,0,-a,u,0,a);var p=l===i?n:r;p.toArray(c,h),h+=3,p.toArray(c,h),h+=3,p.toArray(c,h),h+=3,p.toArray(c,h),h+=3}var d=new Ir;d.setAttribute("position",new Er(s,3)),d.setAttribute("color",new Er(c,3));var f=new ls({vertexColors:g});ys.call(this,d,f)}function Uu(e,t,n,r,i,o){e=e||10,t=t||16,n=n||8,r=r||64,i=new cr(void 0!==i?i:4473924),o=new cr(void 0!==o?o:8947848);var a,s,c,l,h,u,p,d=[],f=[];for(l=0;l<=t;l++)c=l/t*(2*Math.PI),a=Math.sin(c)*e,s=Math.cos(c)*e,d.push(0,0,0),d.push(a,0,s),p=1&l?i:o,f.push(p.r,p.g,p.b),f.push(p.r,p.g,p.b);for(l=0;l<=n;l++)for(p=1&l?i:o,u=e-e/n*l,h=0;h<r;h++)c=h/r*(2*Math.PI),a=Math.sin(c)*u,s=Math.cos(c)*u,d.push(a,0,s),f.push(p.r,p.g,p.b),c=(h+1)/r*(2*Math.PI),a=Math.sin(c)*u,s=Math.cos(c)*u,d.push(a,0,s),f.push(p.r,p.g,p.b);var m=new Ir;m.setAttribute("position",new Er(d,3)),m.setAttribute("color",new Er(f,3));var v=new ls({vertexColors:g});ys.call(this,m,v)}function Bu(e,t,n,r){this.audio=e,this.range=t||1,this.divisionsInnerAngle=n||16,this.divisionsOuterAngle=r||2;var i=new Ir,o=this.divisionsInnerAngle+2*this.divisionsOuterAngle,a=new Float32Array(3*(3*o+3));i.setAttribute("position",new gr(a,3));var s=new ls({color:65280}),c=new ls({color:16776960});ms.call(this,i,[c,s]),this.update()}zu.prototype=Object.create(yn.prototype),zu.prototype.constructor=zu,zu.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},zu.prototype.update=function(){var e=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{var t=e.geometry.getAttribute("color");Nu.copy(this.light.color),Iu.copy(this.light.groundColor);for(var n=0,r=t.count;n<r;n++){var i=n<r/2?Nu:Iu;t.setXYZ(n,i.r,i.g,i.b)}t.needsUpdate=!0}e.lookAt(Du.setFromMatrixPosition(this.light.matrixWorld).negate())},ku.prototype=Object.create($r.prototype),ku.prototype.constructor=ku,ku.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},ku.prototype.onBeforeRender=function(){this.position.copy(this.lightProbe.position),this.scale.set(1,1,1).multiplyScalar(this.size),this.material.uniforms.intensity.value=this.lightProbe.intensity},Fu.prototype=Object.assign(Object.create(ys.prototype),{constructor:Fu,copy:function(e){return ys.prototype.copy.call(this,e),this.geometry.copy(e.geometry),this.material.copy(e.material),this},clone:function(){return(new this.constructor).copy(this)}}),Uu.prototype=Object.create(ys.prototype),Uu.prototype.constructor=Uu,Bu.prototype=Object.create(ms.prototype),Bu.prototype.constructor=Bu,Bu.prototype.update=function(){var e,t,n=this.audio,r=this.range,i=this.divisionsInnerAngle,o=this.divisionsOuterAngle,a=Rt.degToRad(n.panner.coneInnerAngle),s=Rt.degToRad(n.panner.coneOuterAngle),c=a/2,l=s/2,h=0,u=0,p=this.geometry,d=p.attributes.position;function f(n,i,o,a){var s=(i-n)/o;for(d.setXYZ(h,0,0,0),u++,e=n;e<i;e+=s)t=h+u,d.setXYZ(t,Math.sin(e)*r,0,Math.cos(e)*r),d.setXYZ(t+1,Math.sin(Math.min(e+s,i))*r,0,Math.cos(Math.min(e+s,i))*r),d.setXYZ(t+2,0,0,0),u+=3;p.addGroup(h,u,a),h+=u,u=0}p.clearGroups(),f(-l,-c,o,0),f(-c,c,i,1),f(c,l,o,0),d.needsUpdate=!0,a===s&&(this.material[0].visible=!1)},Bu.prototype.dispose=function(){this.geometry.dispose(),this.material[0].dispose(),this.material[1].dispose()};var ju=new zt,Hu=new zt,Gu=new Ut;function Vu(e,t,n,r){this.object=e,this.size=void 0!==t?t:1;var i=void 0!==n?n:16776960,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=s.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");var c=new Ir,l=new Er(2*a*3,3);c.setAttribute("position",l),ys.call(this,c,new ls({color:i,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}Vu.prototype=Object.create(ys.prototype),Vu.prototype.constructor=Vu,Vu.prototype.update=function(){this.object.updateMatrixWorld(!0),Gu.getNormalMatrix(this.object.matrixWorld);for(var e=this.object.matrixWorld,t=this.geometry.attributes.position,n=this.object.geometry,r=n.vertices,i=n.faces,o=0,a=0,s=i.length;a<s;a++){var c=i[a],l=c.normal;ju.copy(r[c.a]).add(r[c.b]).add(r[c.c]).divideScalar(3).applyMatrix4(e),Hu.copy(l).applyMatrix3(Gu).normalize().multiplyScalar(this.size).add(ju),t.setXYZ(o,ju.x,ju.y,ju.z),o+=1,t.setXYZ(o,Hu.x,Hu.y,Hu.z),o+=1}t.needsUpdate=!0};var Wu=new zt,qu=new zt,Xu=new zt;function Yu(e,t,n){yn.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.color=n,void 0===t&&(t=1);var r=new Ir;r.setAttribute("position",new Er([-t,t,0,t,t,0,t,-t,0,-t,-t,0,-t,t,0],3));var i=new ls({fog:!1});this.lightPlane=new ms(r,i),this.add(this.lightPlane),(r=new Ir).setAttribute("position",new Er([0,0,0,0,0,1],3)),this.targetLine=new ms(r,i),this.add(this.targetLine),this.update()}Yu.prototype=Object.create(yn.prototype),Yu.prototype.constructor=Yu,Yu.prototype.dispose=function(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()},Yu.prototype.update=function(){Wu.setFromMatrixPosition(this.light.matrixWorld),qu.setFromMatrixPosition(this.light.target.matrixWorld),Xu.subVectors(qu,Wu),this.lightPlane.lookAt(qu),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(qu),this.targetLine.scale.z=Xu.length()};var Zu=new zt,Ju=new mi;function Qu(e){var t=new Ir,n=new ls({color:16777215,vertexColors:m}),r=[],i=[],o={},a=new cr(16755200),s=new cr(16711680),c=new cr(43775),l=new cr(16777215),h=new cr(3355443);function u(e,t,n){p(e,n),p(t,n)}function p(e,t){r.push(0,0,0),i.push(t.r,t.g,t.b),void 0===o[e]&&(o[e]=[]),o[e].push(r.length/3-1)}u("n1","n2",a),u("n2","n4",a),u("n4","n3",a),u("n3","n1",a),u("f1","f2",a),u("f2","f4",a),u("f4","f3",a),u("f3","f1",a),u("n1","f1",a),u("n2","f2",a),u("n3","f3",a),u("n4","f4",a),u("p","n1",s),u("p","n2",s),u("p","n3",s),u("p","n4",s),u("u1","u2",c),u("u2","u3",c),u("u3","u1",c),u("c","t",l),u("p","c",h),u("cn1","cn2",h),u("cn3","cn4",h),u("cf1","cf2",h),u("cf3","cf4",h),t.setAttribute("position",new Er(r,3)),t.setAttribute("color",new Er(i,3)),ys.call(this,t,n),this.camera=e,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=o,this.update()}function Ku(e,t,n,r,i,o,a){Zu.set(i,o,a).unproject(r);var s=t[e];if(void 0!==s)for(var c=n.getAttribute("position"),l=0,h=s.length;l<h;l++)c.setXYZ(s[l],Zu.x,Zu.y,Zu.z)}Qu.prototype=Object.create(ys.prototype),Qu.prototype.constructor=Qu,Qu.prototype.update=function(){var e=this.geometry,t=this.pointMap;Ju.projectionMatrixInverse.copy(this.camera.projectionMatrixInverse),Ku("c",t,e,Ju,0,0,-1),Ku("t",t,e,Ju,0,0,1),Ku("n1",t,e,Ju,-1,-1,-1),Ku("n2",t,e,Ju,1,-1,-1),Ku("n3",t,e,Ju,-1,1,-1),Ku("n4",t,e,Ju,1,1,-1),Ku("f1",t,e,Ju,-1,-1,1),Ku("f2",t,e,Ju,1,-1,1),Ku("f3",t,e,Ju,-1,1,1),Ku("f4",t,e,Ju,1,1,1),Ku("u1",t,e,Ju,.7,1.1,-1),Ku("u2",t,e,Ju,-.7,1.1,-1),Ku("u3",t,e,Ju,0,2,-1),Ku("cf1",t,e,Ju,-1,0,1),Ku("cf2",t,e,Ju,1,0,1),Ku("cf3",t,e,Ju,0,-1,1),Ku("cf4",t,e,Ju,0,1,1),Ku("cn1",t,e,Ju,-1,0,-1),Ku("cn2",t,e,Ju,1,0,-1),Ku("cn3",t,e,Ju,0,-1,-1),Ku("cn4",t,e,Ju,0,1,-1),e.getAttribute("position").needsUpdate=!0};var $u=new On;function ep(e,t){this.object=e,void 0===t&&(t=16776960);var n=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new Float32Array(24),i=new Ir;i.setIndex(new gr(n,1)),i.setAttribute("position",new gr(r,3)),ys.call(this,i,new ls({color:t})),this.matrixAutoUpdate=!1,this.update()}function tp(e,t){this.type="Box3Helper",this.box=e,t=t||16776960;var n=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new Ir;r.setIndex(new gr(n,1)),r.setAttribute("position",new Er([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),ys.call(this,r,new ls({color:t})),this.geometry.computeBoundingSphere()}function np(e,t,n){this.type="PlaneHelper",this.plane=e,this.size=void 0===t?1:t;var r=void 0!==n?n:16776960,i=new Ir;i.setAttribute("position",new Er([1,-1,1,-1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,0,0,1,0,0,0],3)),i.computeBoundingSphere(),ms.call(this,i,new ls({color:r}));var o=new Ir;o.setAttribute("position",new Er([1,1,1,-1,1,1,-1,-1,1,1,1,1,-1,-1,1,1,-1,1],3)),o.computeBoundingSphere(),this.add(new $r(o,new mr({color:r,opacity:.2,transparent:!0,depthWrite:!1})))}ep.prototype=Object.create(ys.prototype),ep.prototype.constructor=ep,ep.prototype.update=function(e){if(void 0!==e&&console.warn("THREE.BoxHelper: .update() has no longer arguments."),void 0!==this.object&&$u.setFromObject(this.object),!$u.isEmpty()){var t=$u.min,n=$u.max,r=this.geometry.attributes.position,i=r.array;i[0]=n.x,i[1]=n.y,i[2]=n.z,i[3]=t.x,i[4]=n.y,i[5]=n.z,i[6]=t.x,i[7]=t.y,i[8]=n.z,i[9]=n.x,i[10]=t.y,i[11]=n.z,i[12]=n.x,i[13]=n.y,i[14]=t.z,i[15]=t.x,i[16]=n.y,i[17]=t.z,i[18]=t.x,i[19]=t.y,i[20]=t.z,i[21]=n.x,i[22]=t.y,i[23]=t.z,r.needsUpdate=!0,this.geometry.computeBoundingSphere()}},ep.prototype.setFromObject=function(e){return this.object=e,this.update(),this},ep.prototype.copy=function(e){return ys.prototype.copy.call(this,e),this.object=e.object,this},ep.prototype.clone=function(){return(new this.constructor).copy(this)},tp.prototype=Object.create(ys.prototype),tp.prototype.constructor=tp,tp.prototype.updateMatrixWorld=function(e){var t=this.box;t.isEmpty()||(t.getCenter(this.position),t.getSize(this.scale),this.scale.multiplyScalar(.5),yn.prototype.updateMatrixWorld.call(this,e))},np.prototype=Object.create(ms.prototype),np.prototype.constructor=np,np.prototype.updateMatrixWorld=function(e){var t=-this.plane.constant;Math.abs(t)<1e-8&&(t=1e-8),this.scale.set(.5*this.size,.5*this.size,t),this.children[0].material.side=t<0?p:u,this.lookAt(this.plane.normal),yn.prototype.updateMatrixWorld.call(this,e)};var rp,ip,op=new zt;function ap(e,t,n,r,i,o){yn.call(this),void 0===e&&(e=new zt(0,0,1)),void 0===t&&(t=new zt(0,0,0)),void 0===n&&(n=1),void 0===r&&(r=16776960),void 0===i&&(i=.2*n),void 0===o&&(o=.2*i),void 0===rp&&((rp=new Ir).setAttribute("position",new Er([0,0,0,0,1,0],3)),(ip=new Fc(0,.5,1,5,1)).translate(0,-.5,0)),this.position.copy(t),this.line=new ms(rp,new ls({color:r})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new $r(ip,new mr({color:r})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(e),this.setLength(n,i,o)}function sp(e){var t=[0,0,0,e=e||1,0,0,0,0,0,0,e,0,0,0,0,0,0,e],n=new Ir;n.setAttribute("position",new Er(t,3)),n.setAttribute("color",new Er([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3));var r=new ls({vertexColors:g});ys.call(this,n,r)}ap.prototype=Object.create(yn.prototype),ap.prototype.constructor=ap,ap.prototype.setDirection=function(e){if(e.y>.99999)this.quaternion.set(0,0,0,1);else if(e.y<-.99999)this.quaternion.set(1,0,0,0);else{op.set(e.z,0,-e.x).normalize();var t=Math.acos(e.y);this.quaternion.setFromAxisAngle(op,t)}},ap.prototype.setLength=function(e,t,n){void 0===t&&(t=.2*e),void 0===n&&(n=.2*t),this.line.scale.set(1,Math.max(1e-4,e-t),1),this.line.updateMatrix(),this.cone.scale.set(n,t,n),this.cone.position.y=e,this.cone.updateMatrix()},ap.prototype.setColor=function(e){this.line.material.color.set(e),this.cone.material.color.set(e)},ap.prototype.copy=function(e){return yn.prototype.copy.call(this,e,!1),this.line.copy(e.line),this.cone.copy(e.cone),this},ap.prototype.clone=function(){return(new this.constructor).copy(this)},sp.prototype=Object.create(ys.prototype),sp.prototype.constructor=sp;function cp(e){console.warn("THREE.ClosedSplineCurve3 has been deprecated. Use THREE.CatmullRomCurve3 instead."),zl.call(this,e),this.type="catmullrom",this.closed=!0}function lp(e){console.warn("THREE.SplineCurve3 has been deprecated. Use THREE.CatmullRomCurve3 instead."),zl.call(this,e),this.type="catmullrom"}function hp(e){console.warn("THREE.Spline has been removed. Use THREE.CatmullRomCurve3 instead."),zl.call(this,e),this.type="catmullrom"}Ll.create=function(e,t){return console.log("THREE.Curve.create() has been deprecated"),e.prototype=Object.create(Ll.prototype),e.prototype.constructor=e,e.prototype.getPoint=t,e},Object.assign(Yl.prototype,{createPointsGeometry:function(e){console.warn("THREE.CurvePath: .createPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");var t=this.getPoints(e);return this.createGeometry(t)},createSpacedPointsGeometry:function(e){console.warn("THREE.CurvePath: .createSpacedPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");var t=this.getSpacedPoints(e);return this.createGeometry(t)},createGeometry:function(e){console.warn("THREE.CurvePath: .createGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");for(var t=new ai,n=0,r=e.length;n<r;n++){var i=e[n];t.vertices.push(new zt(i.x,i.y,i.z||0))}return t}}),Object.assign(Zl.prototype,{fromPoints:function(e){return console.warn("THREE.Path: .fromPoints() has been renamed to .setFromPoints()."),this.setFromPoints(e)}}),cp.prototype=Object.create(zl.prototype),lp.prototype=Object.create(zl.prototype),hp.prototype=Object.create(zl.prototype),Object.assign(hp.prototype,{initFromArray:function(){console.error("THREE.Spline: .initFromArray() has been removed.")},getControlPointsArray:function(){console.error("THREE.Spline: .getControlPointsArray() has been removed.")},reparametrizeByArcLength:function(){console.error("THREE.Spline: .reparametrizeByArcLength() has been removed.")}}),Fu.prototype.setColors=function(){console.error("THREE.GridHelper: setColors() has been deprecated, pass them in the constructor instead.")},Cu.prototype.update=function(){console.error("THREE.SkeletonHelper: update() no longer needs to be called.")},Object.assign(xl.prototype,{extractUrlBase:function(e){return console.warn("THREE.Loader: .extractUrlBase() has been deprecated. Use THREE.LoaderUtils.extractUrlBase() instead."),hh.extractUrlBase(e)}}),xl.Handlers={add:function(){console.error("THREE.Loader: Handlers.add() has been removed. Use LoadingManager.addHandler() instead.")},get:function(){console.error("THREE.Loader: Handlers.get() has been removed. Use LoadingManager.getHandler() instead.")}},Object.assign(mh.prototype,{setTexturePath:function(e){return console.warn("THREE.ObjectLoader: .setTexturePath() has been renamed to .setResourcePath()."),this.setResourcePath(e)}}),Object.assign(mu.prototype,{center:function(e){return console.warn("THREE.Box2: .center() has been renamed to .getCenter()."),this.getCenter(e)},empty:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(e){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)},size:function(e){return console.warn("THREE.Box2: .size() has been renamed to .getSize()."),this.getSize(e)}}),Object.assign(On.prototype,{center:function(e){return console.warn("THREE.Box3: .center() has been renamed to .getCenter()."),this.getCenter(e)},empty:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(e){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)},isIntersectionSphere:function(e){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(e)},size:function(e){return console.warn("THREE.Box3: .size() has been renamed to .getSize()."),this.getSize(e)}}),yu.prototype.center=function(e){return console.warn("THREE.Line3: .center() has been renamed to .getCenter()."),this.getCenter(e)},Object.assign(Rt,{random16:function(){return console.warn("THREE.Math: .random16() has been deprecated. Use Math.random() instead."),Math.random()},nearestPowerOfTwo:function(e){return console.warn("THREE.Math: .nearestPowerOfTwo() has been renamed to .floorPowerOfTwo()."),Rt.floorPowerOfTwo(e)},nextPowerOfTwo:function(e){return console.warn("THREE.Math: .nextPowerOfTwo() has been renamed to .ceilPowerOfTwo()."),Rt.ceilPowerOfTwo(e)}}),Object.assign(Ut.prototype,{flattenToArrayOffset:function(e,t){return console.warn("THREE.Matrix3: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(e,t)},multiplyVector3:function(e){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),e.applyMatrix3(this)},multiplyVector3Array:function(){console.error("THREE.Matrix3: .multiplyVector3Array() has been removed.")},applyToBuffer:function(e){return console.warn("THREE.Matrix3: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(e)},applyToVector3Array:function(){console.error("THREE.Matrix3: .applyToVector3Array() has been removed.")}}),Object.assign($t.prototype,{extractPosition:function(e){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(e)},flattenToArrayOffset:function(e,t){return console.warn("THREE.Matrix4: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(e,t)},getPosition:function(){return console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),(new zt).setFromMatrixColumn(this,3)},setRotationFromQuaternion:function(e){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(e)},multiplyToArray:function(){console.warn("THREE.Matrix4: .multiplyToArray() has been removed.")},multiplyVector3:function(e){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) instead."),e.applyMatrix4(this)},multiplyVector4:function(e){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),e.applyMatrix4(this)},multiplyVector3Array:function(){console.error("THREE.Matrix4: .multiplyVector3Array() has been removed.")},rotateAxis:function(e){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),e.transformDirection(this)},crossVector:function(e){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),e.applyMatrix4(this)},translate:function(){console.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(){console.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(){console.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(){console.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")},applyToBuffer:function(e){return console.warn("THREE.Matrix4: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(e)},applyToVector3Array:function(){console.error("THREE.Matrix4: .applyToVector3Array() has been removed.")},makeFrustum:function(e,t,n,r,i,o){return console.warn("THREE.Matrix4: .makeFrustum() has been removed. Use .makePerspective( left, right, top, bottom, near, far ) instead."),this.makePerspective(e,t,r,n,i,o)}}),Xn.prototype.isIntersectionLine=function(e){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(e)},Dt.prototype.multiplyVector3=function(e){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),e.applyQuaternion(this)},Object.assign(Gn.prototype,{isIntersectionBox:function(e){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)},isIntersectionPlane:function(e){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(e)},isIntersectionSphere:function(e){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(e)}}),Object.assign(ir.prototype,{area:function(){return console.warn("THREE.Triangle: .area() has been renamed to .getArea()."),this.getArea()},barycoordFromPoint:function(e,t){return console.warn("THREE.Triangle: .barycoordFromPoint() has been renamed to .getBarycoord()."),this.getBarycoord(e,t)},midpoint:function(e){return console.warn("THREE.Triangle: .midpoint() has been renamed to .getMidpoint()."),this.getMidpoint(e)},normal:function(e){return console.warn("THREE.Triangle: .normal() has been renamed to .getNormal()."),this.getNormal(e)},plane:function(e){return console.warn("THREE.Triangle: .plane() has been renamed to .getPlane()."),this.getPlane(e)}}),Object.assign(ir,{barycoordFromPoint:function(e,t,n,r,i){return console.warn("THREE.Triangle: .barycoordFromPoint() has been renamed to .getBarycoord()."),ir.getBarycoord(e,t,n,r,i)},normal:function(e,t,n,r){return console.warn("THREE.Triangle: .normal() has been renamed to .getNormal()."),ir.getNormal(e,t,n,r)}}),Object.assign(Jl.prototype,{extractAllPoints:function(e){return console.warn("THREE.Shape: .extractAllPoints() has been removed. Use .extractPoints() instead."),this.extractPoints(e)},extrude:function(e){return console.warn("THREE.Shape: .extrude() has been removed. Use ExtrudeGeometry() instead."),new wc(this,e)},makeGeometry:function(e){return console.warn("THREE.Shape: .makeGeometry() has been removed. Use ShapeGeometry() instead."),new Dc(this,e)}}),Object.assign(Ot.prototype,{fromAttribute:function(e,t,n){return console.warn("THREE.Vector2: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(e,t,n)},distanceToManhattan:function(e){return console.warn("THREE.Vector2: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(e)},lengthManhattan:function(){return console.warn("THREE.Vector2: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(zt.prototype,{setEulerFromRotationMatrix:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(e){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(e)},getScaleFromMatrix:function(e){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(e)},getColumnFromMatrix:function(e,t){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),this.setFromMatrixColumn(t,e)},applyProjection:function(e){return console.warn("THREE.Vector3: .applyProjection() has been removed. Use .applyMatrix4( m ) instead."),this.applyMatrix4(e)},fromAttribute:function(e,t,n){return console.warn("THREE.Vector3: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(e,t,n)},distanceToManhattan:function(e){return console.warn("THREE.Vector3: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(e)},lengthManhattan:function(){return console.warn("THREE.Vector3: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(Gt.prototype,{fromAttribute:function(e,t,n){return console.warn("THREE.Vector4: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(e,t,n)},lengthManhattan:function(){return console.warn("THREE.Vector4: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(ai.prototype,{computeTangents:function(){console.error("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function(){console.error("THREE.Geometry: .computeLineDistances() has been removed. Use THREE.Line.computeLineDistances() instead.")}}),Object.assign(yn.prototype,{getChildByName:function(e){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(e)},renderDepth:function(){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")},translate:function(e,t){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(t,e)},getWorldRotation:function(){console.error("THREE.Object3D: .getWorldRotation() has been removed. Use THREE.Object3D.getWorldQuaternion( target ) instead.")}}),Object.defineProperties(yn.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(e){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=e}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.defineProperties(ns.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),Object.defineProperty(as.prototype,"useVertexTexture",{get:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")},set:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")}}),rs.prototype.initBones=function(){console.error("THREE.SkinnedMesh: initBones() has been removed.")},Object.defineProperty(Ll.prototype,"__arcLengthDivisions",{get:function(){return console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions},set:function(e){console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions=e}}),gi.prototype.setLens=function(e,t){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==t&&(this.filmGauge=t),this.setFocalLength(e)},Object.defineProperties(Ql.prototype,{onlyShadow:{set:function(){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(e){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=e}},shadowCameraLeft:{set:function(e){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=e}},shadowCameraRight:{set:function(e){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=e}},shadowCameraTop:{set:function(e){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=e}},shadowCameraBottom:{set:function(e){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=e}},shadowCameraNear:{set:function(e){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=e}},shadowCameraFar:{set:function(e){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=e}},shadowCameraVisible:{set:function(){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(e){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=e}},shadowDarkness:{set:function(){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(e){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=e}},shadowMapHeight:{set:function(e){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=e}}}),Object.defineProperties(gr.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Use .count instead."),this.array.length}},dynamic:{get:function(){return console.warn("THREE.BufferAttribute: .dynamic has been deprecated. Use .usage instead."),35048===this.usage},set:function(){console.warn("THREE.BufferAttribute: .dynamic has been deprecated. Use .usage instead."),this.setUsage(35048)}}}),Object.assign(gr.prototype,{setDynamic:function(e){return console.warn("THREE.BufferAttribute: .setDynamic() has been deprecated. Use .setUsage() instead."),this.setUsage(!0===e?35048:At),this},copyIndicesArray:function(){console.error("THREE.BufferAttribute: .copyIndicesArray() has been removed.")},setArray:function(){console.error("THREE.BufferAttribute: .setArray has been removed. Use BufferGeometry .setAttribute to replace/resize attribute buffers")}}),Object.assign(Ir.prototype,{addIndex:function(e){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(e)},addAttribute:function(e,t){return console.warn("THREE.BufferGeometry: .addAttribute() has been renamed to .setAttribute()."),t&&t.isBufferAttribute||t&&t.isInterleavedBufferAttribute?"index"===e?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),this.setIndex(t),this):this.setAttribute(e,t):(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),this.setAttribute(e,new gr(arguments[1],arguments[2])))},addDrawCall:function(e,t,n){void 0!==n&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(e,t)},clearDrawCalls:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()},computeTangents:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")},computeOffsets:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")},removeAttribute:function(e){return console.warn("THREE.BufferGeometry: .removeAttribute() has been renamed to .deleteAttribute()."),this.deleteAttribute(e)}}),Object.defineProperties(Ir.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}}}),Object.defineProperties(ka.prototype,{dynamic:{get:function(){return console.warn("THREE.InterleavedBuffer: .length has been deprecated. Use .usage instead."),35048===this.usage},set:function(e){console.warn("THREE.InterleavedBuffer: .length has been deprecated. Use .usage instead."),this.setUsage(e)}}}),Object.assign(ka.prototype,{setDynamic:function(e){return console.warn("THREE.InterleavedBuffer: .setDynamic() has been deprecated. Use .setUsage() instead."),this.setUsage(!0===e?35048:At),this},setArray:function(){console.error("THREE.InterleavedBuffer: .setArray has been removed. Use BufferGeometry .setAttribute to replace/resize attribute buffers")}}),Object.assign(_c.prototype,{getArrays:function(){console.error("THREE.ExtrudeBufferGeometry: .getArrays() has been removed.")},addShapeList:function(){console.error("THREE.ExtrudeBufferGeometry: .addShapeList() has been removed.")},addShape:function(){console.error("THREE.ExtrudeBufferGeometry: .addShape() has been removed.")}}),Object.defineProperties(su.prototype,{dynamic:{set:function(){console.warn("THREE.Uniform: .dynamic has been removed. Use object.onBeforeRender() instead.")}},onUpdate:{value:function(){return console.warn("THREE.Uniform: .onUpdate() has been removed. Use object.onBeforeRender() instead."),this}}}),Object.defineProperties(fr.prototype,{wrapAround:{get:function(){console.warn("THREE.Material: .wrapAround has been removed.")},set:function(){console.warn("THREE.Material: .wrapAround has been removed.")}},overdraw:{get:function(){console.warn("THREE.Material: .overdraw has been removed.")},set:function(){console.warn("THREE.Material: .overdraw has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE.Material: .wrapRGB has been removed."),new cr}},shading:{get:function(){console.error("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead.")},set:function(e){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===e}},stencilMask:{get:function(){return console.warn("THREE."+this.type+": .stencilMask has been removed. Use .stencilFuncMask instead."),this.stencilFuncMask},set:function(e){console.warn("THREE."+this.type+": .stencilMask has been removed. Use .stencilFuncMask instead."),this.stencilFuncMask=e}}}),Object.defineProperties(Yc.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(fi.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(e){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=e}}}),Object.assign(Na.prototype,{clearTarget:function(e,t,n,r){console.warn("THREE.WebGLRenderer: .clearTarget() has been deprecated. Use .setRenderTarget() and .clear() instead."),this.setRenderTarget(e),this.clear(t,n,r)},animate:function(e){console.warn("THREE.WebGLRenderer: .animate() is now .setAnimationLoop()."),this.setAnimationLoop(e)},getCurrentRenderTarget:function(){return console.warn("THREE.WebGLRenderer: .getCurrentRenderTarget() is now .getRenderTarget()."),this.getRenderTarget()},getMaxAnisotropy:function(){return console.warn("THREE.WebGLRenderer: .getMaxAnisotropy() is now .capabilities.getMaxAnisotropy()."),this.capabilities.getMaxAnisotropy()},getPrecision:function(){return console.warn("THREE.WebGLRenderer: .getPrecision() is now .capabilities.precision."),this.capabilities.precision},resetGLState:function(){return console.warn("THREE.WebGLRenderer: .resetGLState() is now .state.reset()."),this.state.reset()},supportsFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")},supportsHalfFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")},supportsStandardDerivatives:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")},supportsCompressedTextureS3TC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")},supportsCompressedTexturePVRTC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")},supportsBlendMinMax:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")},supportsVertexTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsVertexTextures() is now .capabilities.vertexTextures."),this.capabilities.vertexTextures},supportsInstancedArrays:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")},enableScissorTest:function(e){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(e)},initMaterial:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")},addPrePlugin:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")},addPostPlugin:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")},updateShadowMap:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")},setFaceCulling:function(){console.warn("THREE.WebGLRenderer: .setFaceCulling() has been removed.")},allocTextureUnit:function(){console.warn("THREE.WebGLRenderer: .allocTextureUnit() has been removed.")},setTexture:function(){console.warn("THREE.WebGLRenderer: .setTexture() has been removed.")},setTexture2D:function(){console.warn("THREE.WebGLRenderer: .setTexture2D() has been removed.")},setTextureCube:function(){console.warn("THREE.WebGLRenderer: .setTextureCube() has been removed.")},getActiveMipMapLevel:function(){return console.warn("THREE.WebGLRenderer: .getActiveMipMapLevel() is now .getActiveMipmapLevel()."),this.getActiveMipmapLevel()}}),Object.defineProperties(Na.prototype,{shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(e){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=e}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(e){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=e}},shadowMapCullFace:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMapCullFace has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMapCullFace has been removed. Set Material.shadowSide instead.")}},context:{get:function(){return console.warn("THREE.WebGLRenderer: .context has been removed. Use .getContext() instead."),this.getContext()}}}),Object.defineProperties(ba.prototype,{cullFace:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.cullFace has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.cullFace has been removed. Set Material.shadowSide instead.")}},renderReverseSided:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderReverseSided has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderReverseSided has been removed. Set Material.shadowSide instead.")}},renderSingleSided:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderSingleSided has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderSingleSided has been removed. Set Material.shadowSide instead.")}}}),Object.defineProperties(bi.prototype,{activeCubeFace:{set:function(){console.warn("THREE.WebGLRenderTargetCube: .activeCubeFace has been removed. It is now the second parameter of WebGLRenderer.setRenderTarget().")}},activeMipMapLevel:{set:function(){console.warn("THREE.WebGLRenderTargetCube: .activeMipMapLevel has been removed. It is now the third parameter of WebGLRenderer.setRenderTarget().")}}}),Object.defineProperties(Vt.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(e){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=e}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(e){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=e}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(e){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=e}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(e){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=e}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(e){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=e}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(e){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=e}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(e){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=e}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(e){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=e}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(e){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=e}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(e){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=e}}}),Object.defineProperties(Oa.prototype,{standing:{set:function(){console.warn("THREE.WebVRManager: .standing has been removed.")}},userHeight:{set:function(){console.warn("THREE.WebVRManager: .userHeight has been removed.")}}}),Object.defineProperties(Bh.prototype,{load:{value:function(e){console.warn("THREE.Audio: .load has been deprecated. Use THREE.AudioLoader instead.");var t=this;return(new Th).load(e,(function(e){t.setBuffer(e)})),this}},startTime:{set:function(){console.warn("THREE.Audio: .startTime is now .play( delay ).")}}}),qh.prototype.getData=function(){return console.warn("THREE.AudioAnalyser: .getData() is now .getFrequencyData()."),this.getFrequencyData()},xi.prototype.updateCubeMap=function(e,t){return console.warn("THREE.CubeCamera: .updateCubeMap() is now .update()."),this.update(e,t)};var up={merge:function(e,t,n){var r;console.warn("THREE.GeometryUtils: .merge() has been moved to Geometry. Use geometry.merge( geometry2, matrix, materialIndexOffset ) instead."),t.isMesh&&(t.matrixAutoUpdate&&t.updateMatrix(),r=t.matrix,t=t.geometry),e.merge(t,r,n)},center:function(e){return console.warn("THREE.GeometryUtils: .center() has been moved to Geometry. Use geometry.center() instead."),e.center()}};Bt.crossOrigin=void 0,Bt.loadTexture=function(e,t,n,r){console.warn("THREE.ImageUtils.loadTexture has been deprecated. Use THREE.TextureLoader() instead.");var i=new Al;i.setCrossOrigin(this.crossOrigin);var o=i.load(e,n,void 0,r);return t&&(o.mapping=t),o},Bt.loadTextureCube=function(e,t,n,r){console.warn("THREE.ImageUtils.loadTextureCube has been deprecated. Use THREE.CubeTextureLoader() instead.");var i=new Tl;i.setCrossOrigin(this.crossOrigin);var o=i.load(e,n,void 0,r);return t&&(o.mapping=t),o},Bt.loadCompressedTexture=function(){console.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},Bt.loadCompressedTextureCube=function(){console.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")};var pp={createMultiMaterialObject:function(){console.error("THREE.SceneUtils has been moved to /examples/js/utils/SceneUtils.js")},detach:function(){console.error("THREE.SceneUtils has been moved to /examples/js/utils/SceneUtils.js")},attach:function(){console.error("THREE.SceneUtils has been moved to /examples/js/utils/SceneUtils.js")}};"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:"110"}}));var dp=Object.freeze({__proto__:null,ACESFilmicToneMapping:te,AddEquation:M,AddOperation:Z,AdditiveBlending:x,AlphaFormat:Ce,AlwaysDepth:B,AlwaysStencilFunc:Tt,AmbientLight:sh,AmbientLightProbe:Ch,AnimationClip:fl,AnimationLoader:_l,AnimationMixer:au,AnimationObjectGroup:iu,AnimationUtils:tl,ArcCurve:Cl,ArrayCamera:Aa,ArrowHelper:ap,Audio:Bh,AudioAnalyser:qh,AudioContext:Sh,AudioListener:Uh,AudioLoader:Th,AxesHelper:sp,AxisHelper:function(e){return console.warn("THREE.AxisHelper has been renamed to THREE.AxesHelper."),new sp(e)},BackSide:p,BasicDepthPacking:wt,BasicShadowMap:0,BinaryTextureLoader:function(e){return console.warn("THREE.BinaryTextureLoader has been renamed to THREE.DataTextureLoader."),new El(e)},Bone:ss,BooleanKeyframeTrack:sl,BoundingBoxHelper:function(e,t){return console.warn("THREE.BoundingBoxHelper has been deprecated. Creating a THREE.BoxHelper instead."),new ep(e,t)},Box2:mu,Box3:On,Box3Helper:tp,BoxBufferGeometry:ci,BoxGeometry:si,BoxHelper:ep,BufferAttribute:gr,BufferGeometry:Ir,BufferGeometryLoader:dh,ByteType:xe,Cache:gl,Camera:mi,CameraHelper:Qu,CanvasRenderer:function(){console.error("THREE.CanvasRenderer has been removed")},CanvasTexture:Ps,CatmullRomCurve3:zl,CineonToneMapping:ee,CircleBufferGeometry:Hc,CircleGeometry:jc,ClampToEdgeWrapping:he,Clock:Nh,ClosedSplineCurve3:cp,Color:cr,ColorKeyframeTrack:cl,CompressedTexture:Ls,CompressedTextureLoader:Ml,ConeBufferGeometry:Bc,ConeGeometry:Uc,CubeCamera:xi,CubeGeometry:si,CubeReflectionMapping:ne,CubeRefractionMapping:re,CubeTexture:Gi,CubeTextureLoader:Tl,CubeUVReflectionMapping:se,CubeUVRefractionMapping:ce,CubicBezierCurve:Bl,CubicBezierCurve3:jl,CubicInterpolant:rl,CullFaceBack:a,CullFaceFront:s,CullFaceFrontBack:3,CullFaceNone:o,Curve:Ll,CurvePath:Yl,CustomBlending:_,CylinderBufferGeometry:Fc,CylinderGeometry:kc,Cylindrical:du,DataTexture:wi,DataTexture2DArray:Vi,DataTexture3D:Wi,DataTextureLoader:El,DecrementStencilOp:7683,DecrementWrapStencilOp:34056,DefaultLoadingManager:yl,DepthFormat:ze,DepthStencilFormat:ke,DepthTexture:Cs,DirectionalLight:ah,DirectionalLightHelper:Yu,DirectionalLightShadow:oh,DiscreteInterpolant:ol,DodecahedronBufferGeometry:Gs,DodecahedronGeometry:Hs,DoubleSide:d,DstAlphaFactor:N,DstColorFactor:z,DynamicBufferAttribute:function(e,t){return console.warn("THREE.DynamicBufferAttribute has been removed. Use new THREE.BufferAttribute().setDynamic( true ) instead."),new gr(e,t).setDynamic(!0)},DynamicCopyUsage:35050,DynamicDrawUsage:35048,DynamicReadUsage:35049,EdgesGeometry:zc,EdgesHelper:function(e,t){return console.warn("THREE.EdgesHelper has been removed. Use THREE.EdgesGeometry instead."),new ys(new zc(e.geometry),new ls({color:void 0!==t?t:16777215}))},EllipseCurve:Pl,EqualDepth:G,EqualStencilFunc:514,EquirectangularReflectionMapping:ie,EquirectangularRefractionMapping:oe,Euler:nn,EventDispatcher:Lt,ExtrudeBufferGeometry:_c,ExtrudeGeometry:wc,Face3:pr,Face4:function(e,t,n,r,i,o,a){return console.warn("THREE.Face4 has been removed. A THREE.Face3 will be created instead."),new pr(e,t,n,i,o,a)},FaceColors:m,FaceNormalsHelper:Vu,FileLoader:wl,FlatShading:1,Float32Attribute:function(e,t){return console.warn("THREE.Float32Attribute has been removed. Use new THREE.Float32BufferAttribute() instead."),new Er(e,t)},Float32BufferAttribute:Er,Float64Attribute:function(e,t){return console.warn("THREE.Float64Attribute has been removed. Use new THREE.Float64BufferAttribute() instead."),new Sr(e,t)},Float64BufferAttribute:Sr,FloatType:Ee,Fog:za,FogExp2:Ia,Font:_h,FontLoader:Eh,FrontFaceDirectionCCW:1,FrontFaceDirectionCW:0,FrontSide:u,Frustum:Ei,GammaEncoding:mt,Geometry:ai,GeometryUtils:up,GreaterDepth:W,GreaterEqualDepth:V,GreaterEqualStencilFunc:518,GreaterStencilFunc:516,GridHelper:Fu,Group:Ta,HalfFloatType:Se,HemisphereLight:Kl,HemisphereLightHelper:zu,HemisphereLightProbe:Ph,IcosahedronBufferGeometry:js,IcosahedronGeometry:Bs,ImageBitmapLoader:bh,ImageLoader:Sl,ImageUtils:Bt,ImmediateRenderObject:xu,IncrementStencilOp:7682,IncrementWrapStencilOp:34055,InstancedBufferAttribute:ph,InstancedBufferGeometry:uh,InstancedInterleavedBuffer:cu,InstancedMesh:cs,Int16Attribute:function(e,t){return console.warn("THREE.Int16Attribute has been removed. Use new THREE.Int16BufferAttribute() instead."),new br(e,t)},Int16BufferAttribute:br,Int32Attribute:function(e,t){return console.warn("THREE.Int32Attribute has been removed. Use new THREE.Int32BufferAttribute() instead."),new _r(e,t)},Int32BufferAttribute:_r,Int8Attribute:function(e,t){return console.warn("THREE.Int8Attribute has been removed. Use new THREE.Int8BufferAttribute() instead."),new vr(e,t)},Int8BufferAttribute:vr,IntType:_e,InterleavedBuffer:ka,InterleavedBufferAttribute:Fa,Interpolant:nl,InterpolateDiscrete:2300,InterpolateLinear:2301,InterpolateSmooth:2302,InvertStencilOp:5386,JSONLoader:function(){console.error("THREE.JSONLoader has been removed.")},KeepStencilOp:St,KeyframeTrack:al,LOD:ns,LatheBufferGeometry:Oc,LatheGeometry:Rc,Layers:rn,LensFlare:function(){console.error("THREE.LensFlare has been moved to /examples/js/objects/Lensflare.js")},LessDepth:j,LessEqualDepth:H,LessEqualStencilFunc:515,LessStencilFunc:513,Light:Ql,LightProbe:Lh,LightProbeHelper:ku,LightShadow:$l,Line:ms,Line3:yu,LineBasicMaterial:ls,LineCurve:Hl,LineCurve3:Gl,LineDashedMaterial:$c,LineLoop:xs,LinePieces:1,LineSegments:ys,LineStrip:0,LinearEncoding:dt,LinearFilter:me,LinearInterpolant:il,LinearMipMapLinearFilter:1008,LinearMipMapNearestFilter:1007,LinearMipmapLinearFilter:ve,LinearMipmapNearestFilter:ge,LinearToneMapping:Q,Loader:xl,LoaderUtils:hh,LoadingManager:vl,LogLuvEncoding:vt,LoopOnce:2200,LoopPingPong:2202,LoopRepeat:ct,LuminanceAlphaFormat:Ne,LuminanceFormat:De,MOUSE:i,Material:fr,MaterialLoader:lh,Math:Rt,Matrix3:Ut,Matrix4:$t,MaxEquation:A,Mesh:$r,MeshBasicMaterial:mr,MeshDepthMaterial:ga,MeshDistanceMaterial:va,MeshFaceMaterial:function(e){return console.warn("THREE.MeshFaceMaterial has been removed. Use an Array instead."),e},MeshLambertMaterial:Qc,MeshMatcapMaterial:Kc,MeshNormalMaterial:Jc,MeshPhongMaterial:Yc,MeshPhysicalMaterial:Xc,MeshStandardMaterial:qc,MeshToonMaterial:Zc,MinEquation:T,MirroredRepeatWrapping:ue,MixOperation:Y,MultiMaterial:function(e){return void 0===e&&(e=[]),console.warn("THREE.MultiMaterial has been removed. Use an Array instead."),e.isMultiMaterial=!0,e.materials=e,e.clone=function(){return e.slice()},e},MultiplyBlending:w,MultiplyOperation:X,NearestFilter:pe,NearestMipMapLinearFilter:1005,NearestMipMapNearestFilter:1004,NearestMipmapLinearFilter:fe,NearestMipmapNearestFilter:de,NeverDepth:U,NeverStencilFunc:512,NoBlending:v,NoColors:f,NoToneMapping:J,NormalBlending:y,NotEqualDepth:q,NotEqualStencilFunc:517,NumberKeyframeTrack:ll,Object3D:yn,ObjectLoader:mh,ObjectSpaceNormalMap:Et,OctahedronBufferGeometry:Us,OctahedronGeometry:Fs,OneFactor:P,OneMinusDstAlphaFactor:I,OneMinusDstColorFactor:k,OneMinusSrcAlphaFactor:D,OneMinusSrcColorFactor:R,OrthographicCamera:ih,PCFShadowMap:c,PCFSoftShadowMap:l,ParametricBufferGeometry:Ds,ParametricGeometry:Os,Particle:function(e){return console.warn("THREE.Particle has been renamed to THREE.Sprite."),new Ka(e)},ParticleBasicMaterial:function(e){return console.warn("THREE.ParticleBasicMaterial has been renamed to THREE.PointsMaterial."),new bs(e)},ParticleSystem:function(e,t){return console.warn("THREE.ParticleSystem has been renamed to THREE.Points."),new Ss(e,t)},ParticleSystemMaterial:function(e){return console.warn("THREE.ParticleSystemMaterial has been renamed to THREE.PointsMaterial."),new bs(e)},Path:Zl,PerspectiveCamera:gi,Plane:Xn,PlaneBufferGeometry:Ri,PlaneGeometry:Ci,PlaneHelper:np,PointCloud:function(e,t){return console.warn("THREE.PointCloud has been renamed to THREE.Points."),new Ss(e,t)},PointCloudMaterial:function(e){return console.warn("THREE.PointCloudMaterial has been renamed to THREE.PointsMaterial."),new bs(e)},PointLight:rh,PointLightHelper:Ru,Points:Ss,PointsMaterial:bs,PolarGridHelper:Uu,PolyhedronBufferGeometry:Is,PolyhedronGeometry:Ns,PositionalAudio:Wh,PositionalAudioHelper:Bu,PropertyBinding:ru,PropertyMixer:Xh,QuadraticBezierCurve:Vl,QuadraticBezierCurve3:Wl,Quaternion:Dt,QuaternionKeyframeTrack:ul,QuaternionLinearInterpolant:hl,REVISION:"110",RGBADepthPacking:_t,RGBAFormat:Oe,RGBA_ASTC_10x10_Format:ot,RGBA_ASTC_10x5_Format:nt,RGBA_ASTC_10x6_Format:rt,RGBA_ASTC_10x8_Format:it,RGBA_ASTC_12x10_Format:at,RGBA_ASTC_12x12_Format:st,RGBA_ASTC_4x4_Format:Ye,RGBA_ASTC_5x4_Format:Ze,RGBA_ASTC_5x5_Format:Je,RGBA_ASTC_6x5_Format:Qe,RGBA_ASTC_6x6_Format:Ke,RGBA_ASTC_8x5_Format:$e,RGBA_ASTC_8x6_Format:et,RGBA_ASTC_8x8_Format:tt,RGBA_PVRTC_2BPPV1_Format:qe,RGBA_PVRTC_4BPPV1_Format:We,RGBA_S3TC_DXT1_Format:Be,RGBA_S3TC_DXT3_Format:je,RGBA_S3TC_DXT5_Format:He,RGBDEncoding:bt,RGBEEncoding:gt,RGBEFormat:Ie,RGBFormat:Re,RGBM16Encoding:xt,RGBM7Encoding:yt,RGB_ETC1_Format:Xe,RGB_PVRTC_2BPPV1_Format:Ve,RGB_PVRTC_4BPPV1_Format:Ge,RGB_S3TC_DXT1_Format:Ue,RawShaderMaterial:Wc,Ray:Gn,Raycaster:lu,RectAreaLight:ch,RectAreaLightHelper:Ou,RedFormat:Fe,ReinhardToneMapping:K,RepeatWrapping:le,ReplaceStencilOp:7681,ReverseSubtractEquation:S,RingBufferGeometry:Cc,RingGeometry:Pc,Scene:xn,SceneUtils:pp,ShaderChunk:Si,ShaderLib:Ai,ShaderMaterial:fi,ShadowMaterial:Vc,Shape:Jl,ShapeBufferGeometry:Nc,ShapeGeometry:Dc,ShapePath:wh,ShapeUtils:yc,ShortType:be,Skeleton:as,SkeletonHelper:Cu,SkinnedMesh:rs,SmoothShading:2,Sphere:In,SphereBufferGeometry:Lc,SphereGeometry:Ac,Spherical:pu,SphericalHarmonics3:Ah,SphericalReflectionMapping:ae,Spline:hp,SplineCurve:ql,SplineCurve3:lp,SpotLight:th,SpotLightHelper:Tu,SpotLightShadow:eh,Sprite:Ka,SpriteMaterial:Ua,SrcAlphaFactor:O,SrcAlphaSaturateFactor:F,SrcColorFactor:C,StaticCopyUsage:35046,StaticDrawUsage:At,StaticReadUsage:35045,StereoCamera:Dh,StreamCopyUsage:35042,StreamDrawUsage:35040,StreamReadUsage:35041,StringKeyframeTrack:pl,SubtractEquation:E,SubtractiveBlending:b,TOUCH:{ROTATE:0,PAN:1,DOLLY_PAN:2,DOLLY_ROTATE:3},TangentSpaceNormalMap:Mt,TetrahedronBufferGeometry:ks,TetrahedronGeometry:zs,TextBufferGeometry:Tc,TextGeometry:Sc,Texture:Ht,TextureLoader:Al,TorusBufferGeometry:Zs,TorusGeometry:Ys,TorusKnotBufferGeometry:Xs,TorusKnotGeometry:qs,Triangle:ir,TriangleFanDrawMode:pt,TriangleStripDrawMode:ut,TrianglesDrawMode:ht,TubeBufferGeometry:Ws,TubeGeometry:Vs,UVMapping:300,Uint16Attribute:function(e,t){return console.warn("THREE.Uint16Attribute has been removed. Use new THREE.Uint16BufferAttribute() instead."),new wr(e,t)},Uint16BufferAttribute:wr,Uint32Attribute:function(e,t){return console.warn("THREE.Uint32Attribute has been removed. Use new THREE.Uint32BufferAttribute() instead."),new Mr(e,t)},Uint32BufferAttribute:Mr,Uint8Attribute:function(e,t){return console.warn("THREE.Uint8Attribute has been removed. Use new THREE.Uint8BufferAttribute() instead."),new yr(e,t)},Uint8BufferAttribute:yr,Uint8ClampedAttribute:function(e,t){return console.warn("THREE.Uint8ClampedAttribute has been removed. Use new THREE.Uint8ClampedBufferAttribute() instead."),new xr(e,t)},Uint8ClampedBufferAttribute:xr,Uncharted2ToneMapping:$,Uniform:su,UniformsLib:Ti,UniformsUtils:ui,UnsignedByteType:ye,UnsignedInt248Type:Pe,UnsignedIntType:Me,UnsignedShort4444Type:Te,UnsignedShort5551Type:Ae,UnsignedShort565Type:Le,UnsignedShortType:we,VSMShadowMap:h,Vector2:Ot,Vector3:zt,Vector4:Gt,VectorKeyframeTrack:dl,Vertex:function(e,t,n){return console.warn("THREE.Vertex has been removed. Use THREE.Vector3 instead."),new zt(e,t,n)},VertexColors:g,VertexNormalsHelper:Eu,VideoTexture:As,WebGLMultisampleRenderTarget:Wt,WebGLRenderTarget:Vt,WebGLRenderTargetCube:bi,WebGLRenderer:Na,WebGLUtils:Ma,WireframeGeometry:Rs,WireframeHelper:function(e,t){return console.warn("THREE.WireframeHelper has been removed. Use THREE.WireframeGeometry instead."),new ys(new Rs(e.geometry),new ls({color:void 0!==t?t:16777215}))},WrapAroundEnding:2402,XHRLoader:function(e){return console.warn("THREE.XHRLoader has been renamed to THREE.FileLoader."),new wl(e)},ZeroCurvatureEnding:lt,ZeroFactor:L,ZeroSlopeEnding:2401,ZeroStencilOp:0,sRGBEncoding:ft});function fp(e,t,n){if(e.isCamera){console.warn("THREE.DragControls: Constructor now expects ( objects, camera, domElement )");var r=e;e=t,t=r}var i=new Xn,o=new lu,a=new Ot,s=new zt,c=new zt,l=null,h=null,u=this;function p(){n.addEventListener("mousemove",f,!1),n.addEventListener("mousedown",m,!1),n.addEventListener("mouseup",g,!1),n.addEventListener("mouseleave",g,!1),n.addEventListener("touchmove",v,!1),n.addEventListener("touchstart",y,!1),n.addEventListener("touchend",x,!1)}function d(){n.removeEventListener("mousemove",f,!1),n.removeEventListener("mousedown",m,!1),n.removeEventListener("mouseup",g,!1),n.removeEventListener("mouseleave",g,!1),n.removeEventListener("touchmove",v,!1),n.removeEventListener("touchstart",y,!1),n.removeEventListener("touchend",x,!1)}function f(r){r.preventDefault();var p=n.getBoundingClientRect();if(a.x=(r.clientX-p.left)/p.width*2-1,a.y=-(r.clientY-p.top)/p.height*2+1,o.setFromCamera(a,t),l&&u.enabled)return o.ray.intersectPlane(i,c)&&l.position.copy(c.sub(s)),void u.dispatchEvent({type:"drag",object:l});o.setFromCamera(a,t);var d=o.intersectObjects(e);if(d.length>0){var f=d[0].object;i.setFromNormalAndCoplanarPoint(t.getWorldDirection(i.normal),f.position),h!==f&&(u.dispatchEvent({type:"hoveron",object:f}),n.style.cursor="pointer",h=f)}else null!==h&&(u.dispatchEvent({type:"hoveroff",object:h}),n.style.cursor="auto",h=null)}function m(r){r.preventDefault(),o.setFromCamera(a,t);var h=o.intersectObjects(e);h.length>0&&(l=h[0].object,o.ray.intersectPlane(i,c)&&s.copy(c).sub(l.position),n.style.cursor="move",u.dispatchEvent({type:"dragstart",object:l}))}function g(e){e.preventDefault(),l&&(u.dispatchEvent({type:"dragend",object:l}),l=null),n.style.cursor="auto"}function v(e){e.preventDefault(),e=e.changedTouches[0];var r=n.getBoundingClientRect();if(a.x=(e.clientX-r.left)/r.width*2-1,a.y=-(e.clientY-r.top)/r.height*2+1,o.setFromCamera(a,t),l&&u.enabled)return o.ray.intersectPlane(i,c)&&l.position.copy(c.sub(s)),void u.dispatchEvent({type:"drag",object:l})}function y(r){r.preventDefault(),r=r.changedTouches[0];var h=n.getBoundingClientRect();a.x=(r.clientX-h.left)/h.width*2-1,a.y=-(r.clientY-h.top)/h.height*2+1,o.setFromCamera(a,t);var p=o.intersectObjects(e);p.length>0&&(l=p[0].object,i.setFromNormalAndCoplanarPoint(t.getWorldDirection(i.normal),l.position),o.ray.intersectPlane(i,c)&&s.copy(c).sub(l.position),n.style.cursor="move",u.dispatchEvent({type:"dragstart",object:l}))}function x(e){e.preventDefault(),l&&(u.dispatchEvent({type:"dragend",object:l}),l=null),n.style.cursor="auto"}p(),this.enabled=!0,this.activate=p,this.deactivate=d,this.dispose=function(){d()},this.setObjects=function(){console.error("THREE.DragControls: setObjects() has been removed.")},this.on=function(e,t){console.warn("THREE.DragControls: on() has been deprecated. Use addEventListener() instead."),u.addEventListener(e,t)},this.off=function(e,t){console.warn("THREE.DragControls: off() has been deprecated. Use removeEventListener() instead."),u.removeEventListener(e,t)},this.notify=function(e){console.error("THREE.DragControls: notify() has been deprecated. Use dispatchEvent() instead."),u.dispatchEvent({type:e})}}function mp(e,t,n){var r;function i(){var i,o,a=r.length,s=0,c=0,l=0;for(i=0;i<a;++i)s+=(o=r[i]).x||0,c+=o.y||0,l+=o.z||0;for(s=s/a-e,c=c/a-t,l=l/a-n,i=0;i<a;++i)o=r[i],s&&(o.x-=s),c&&(o.y-=c),l&&(o.z-=l)}return null==e&&(e=0),null==t&&(t=0),null==n&&(n=0),i.initialize=function(e){r=e},i.x=function(t){return arguments.length?(e=+t,i):e},i.y=function(e){return arguments.length?(t=+e,i):t},i.z=function(e){return arguments.length?(n=+e,i):n},i}function gp(e,t,n){if(isNaN(t))return e;var r,i,o,a,s,c,l=e._root,h={data:n},u=e._x0,p=e._x1;if(!l)return e._root=h,e;for(;l.length;)if((a=t>=(i=(u+p)/2))?u=i:p=i,r=l,!(l=l[s=+a]))return r[s]=h,e;if(t===(o=+e._x.call(null,l.data)))return h.next=l,r?r[s]=h:e._root=h,e;do{r=r?r[s]=new Array(2):e._root=new Array(2),(a=t>=(i=(u+p)/2))?u=i:p=i}while((s=+a)==(c=+(o>=i)));return r[c]=l,r[s]=h,e}function vp(e,t,n){this.node=e,this.x0=t,this.x1=n}function yp(e){return e[0]}function xp(e,t){var n=new bp(null==t?yp:t,NaN,NaN);return null==e?n:n.addAll(e)}function bp(e,t,n){this._x=e,this._x0=t,this._x1=n,this._root=void 0}function wp(e){for(var t={data:e.data},n=t;e=e.next;)n=n.next={data:e.data};return t}fp.prototype=Object.create(Lt.prototype),fp.prototype.constructor=fp;var _p=xp.prototype=bp.prototype;function Mp(e,t,n,r){if(isNaN(t)||isNaN(n))return e;var i,o,a,s,c,l,h,u,p,d=e._root,f={data:r},m=e._x0,g=e._y0,v=e._x1,y=e._y1;if(!d)return e._root=f,e;for(;d.length;)if((l=t>=(o=(m+v)/2))?m=o:v=o,(h=n>=(a=(g+y)/2))?g=a:y=a,i=d,!(d=d[u=h<<1|l]))return i[u]=f,e;if(s=+e._x.call(null,d.data),c=+e._y.call(null,d.data),t===s&&n===c)return f.next=d,i?i[u]=f:e._root=f,e;do{i=i?i[u]=new Array(4):e._root=new Array(4),(l=t>=(o=(m+v)/2))?m=o:v=o,(h=n>=(a=(g+y)/2))?g=a:y=a}while((u=h<<1|l)==(p=(c>=a)<<1|s>=o));return i[p]=d,i[u]=f,e}function Ep(e,t,n,r,i){this.node=e,this.x0=t,this.y0=n,this.x1=r,this.y1=i}function Sp(e){return e[0]}function Tp(e){return e[1]}function Ap(e,t,n){var r=new Lp(null==t?Sp:t,null==n?Tp:n,NaN,NaN,NaN,NaN);return null==e?r:r.addAll(e)}function Lp(e,t,n,r,i,o){this._x=e,this._y=t,this._x0=n,this._y0=r,this._x1=i,this._y1=o,this._root=void 0}function Pp(e){for(var t={data:e.data},n=t;e=e.next;)n=n.next={data:e.data};return t}_p.copy=function(){var e,t,n=new bp(this._x,this._x0,this._x1),r=this._root;if(!r)return n;if(!r.length)return n._root=wp(r),n;for(e=[{source:r,target:n._root=new Array(2)}];r=e.pop();)for(var i=0;i<2;++i)(t=r.source[i])&&(t.length?e.push({source:t,target:r.target[i]=new Array(2)}):r.target[i]=wp(t));return n},_p.add=function(e){var t=+this._x.call(null,e);return gp(this.cover(t),t,e)},_p.addAll=function(e){var t,n,r=e.length,i=new Array(r),o=1/0,a=-1/0;for(t=0;t<r;++t)isNaN(n=+this._x.call(null,e[t]))||(i[t]=n,n<o&&(o=n),n>a&&(a=n));for(a<o&&(o=this._x0,a=this._x1),this.cover(o).cover(a),t=0;t<r;++t)gp(this,i[t],e[t]);return this},_p.cover=function(e){if(isNaN(e=+e))return this;var t=this._x0,n=this._x1;if(isNaN(t))n=(t=Math.floor(e))+1;else{if(!(t>e||e>n))return this;var r,i,o=n-t,a=this._root;switch(i=+(e<(t+n)/2)){case 0:do{(r=new Array(2))[i]=a,a=r}while(e>(n=t+(o*=2)));break;case 1:do{(r=new Array(2))[i]=a,a=r}while((t=n-(o*=2))>e)}this._root&&this._root.length&&(this._root=a)}return this._x0=t,this._x1=n,this},_p.data=function(){var e=[];return this.visit((function(t){if(!t.length)do{e.push(t.data)}while(t=t.next)})),e},_p.extent=function(e){return arguments.length?this.cover(+e[0][0]).cover(+e[1][0]):isNaN(this._x0)?void 0:[[this._x0],[this._x1]]},_p.find=function(e,t){var n,r,i,o,a,s=this._x0,c=this._x1,l=[],h=this._root;for(h&&l.push(new vp(h,s,c)),null==t?t=1/0:(s=e-t,c=e+t);o=l.pop();)if(!(!(h=o.node)||(r=o.x0)>c||(i=o.x1)<s))if(h.length){var u=(r+i)/2;l.push(new vp(h[1],u,i),new vp(h[0],r,u)),(a=+(e>=u))&&(o=l[l.length-1],l[l.length-1]=l[l.length-1-a],l[l.length-1-a]=o)}else{var p=Math.abs(e-+this._x.call(null,h.data));p<t&&(t=p,s=e-p,c=e+p,n=h.data)}return n},_p.remove=function(e){if(isNaN(o=+this._x.call(null,e)))return this;var t,n,r,i,o,a,s,c,l,h=this._root,u=this._x0,p=this._x1;if(!h)return this;if(h.length)for(;;){if((s=o>=(a=(u+p)/2))?u=a:p=a,t=h,!(h=h[c=+s]))return this;if(!h.length)break;t[c+1&1]&&(n=t,l=c)}for(;h.data!==e;)if(r=h,!(h=h.next))return this;return(i=h.next)&&delete h.next,r?(i?r.next=i:delete r.next,this):t?(i?t[c]=i:delete t[c],(h=t[0]||t[1])&&h===(t[1]||t[0])&&!h.length&&(n?n[l]=h:this._root=h),this):(this._root=i,this)},_p.removeAll=function(e){for(var t=0,n=e.length;t<n;++t)this.remove(e[t]);return this},_p.root=function(){return this._root},_p.size=function(){var e=0;return this.visit((function(t){if(!t.length)do{++e}while(t=t.next)})),e},_p.visit=function(e){var t,n,r,i,o=[],a=this._root;for(a&&o.push(new vp(a,this._x0,this._x1));t=o.pop();)if(!e(a=t.node,r=t.x0,i=t.x1)&&a.length){var s=(r+i)/2;(n=a[1])&&o.push(new vp(n,s,i)),(n=a[0])&&o.push(new vp(n,r,s))}return this},_p.visitAfter=function(e){var t,n=[],r=[];for(this._root&&n.push(new vp(this._root,this._x0,this._x1));t=n.pop();){var i=t.node;if(i.length){var o,a=t.x0,s=t.x1,c=(a+s)/2;(o=i[0])&&n.push(new vp(o,a,c)),(o=i[1])&&n.push(new vp(o,c,s))}r.push(t)}for(;t=r.pop();)e(t.node,t.x0,t.x1);return this},_p.x=function(e){return arguments.length?(this._x=e,this):this._x};var Cp=Ap.prototype=Lp.prototype;function Rp(e,t,n,r,i){if(isNaN(t)||isNaN(n)||isNaN(r))return e;var o,a,s,c,l,h,u,p,d,f,m,g,v=e._root,y={data:i},x=e._x0,b=e._y0,w=e._z0,_=e._x1,M=e._y1,E=e._z1;if(!v)return e._root=y,e;for(;v.length;)if((p=t>=(a=(x+_)/2))?x=a:_=a,(d=n>=(s=(b+M)/2))?b=s:M=s,(f=r>=(c=(w+E)/2))?w=c:E=c,o=v,!(v=v[m=f<<2|d<<1|p]))return o[m]=y,e;if(l=+e._x.call(null,v.data),h=+e._y.call(null,v.data),u=+e._z.call(null,v.data),t===l&&n===h&&r===u)return y.next=v,o?o[m]=y:e._root=y,e;do{o=o?o[m]=new Array(8):e._root=new Array(8),(p=t>=(a=(x+_)/2))?x=a:_=a,(d=n>=(s=(b+M)/2))?b=s:M=s,(f=r>=(c=(w+E)/2))?w=c:E=c}while((m=f<<2|d<<1|p)==(g=(u>=c)<<2|(h>=s)<<1|l>=a));return o[g]=v,o[m]=y,e}function Op(e,t,n,r,i,o,a){this.node=e,this.x0=t,this.y0=n,this.z0=r,this.x1=i,this.y1=o,this.z1=a}function Dp(e){return e[0]}function Np(e){return e[1]}function Ip(e){return e[2]}function zp(e,t,n,r){var i=new kp(null==t?Dp:t,null==n?Np:n,null==r?Ip:r,NaN,NaN,NaN,NaN,NaN,NaN);return null==e?i:i.addAll(e)}function kp(e,t,n,r,i,o,a,s,c){this._x=e,this._y=t,this._z=n,this._x0=r,this._y0=i,this._z0=o,this._x1=a,this._y1=s,this._z1=c,this._root=void 0}function Fp(e){for(var t={data:e.data},n=t;e=e.next;)n=n.next={data:e.data};return t}Cp.copy=function(){var e,t,n=new Lp(this._x,this._y,this._x0,this._y0,this._x1,this._y1),r=this._root;if(!r)return n;if(!r.length)return n._root=Pp(r),n;for(e=[{source:r,target:n._root=new Array(4)}];r=e.pop();)for(var i=0;i<4;++i)(t=r.source[i])&&(t.length?e.push({source:t,target:r.target[i]=new Array(4)}):r.target[i]=Pp(t));return n},Cp.add=function(e){var t=+this._x.call(null,e),n=+this._y.call(null,e);return Mp(this.cover(t,n),t,n,e)},Cp.addAll=function(e){var t,n,r,i,o=e.length,a=new Array(o),s=new Array(o),c=1/0,l=1/0,h=-1/0,u=-1/0;for(n=0;n<o;++n)isNaN(r=+this._x.call(null,t=e[n]))||isNaN(i=+this._y.call(null,t))||(a[n]=r,s[n]=i,r<c&&(c=r),r>h&&(h=r),i<l&&(l=i),i>u&&(u=i));if(c>h||l>u)return this;for(this.cover(c,l).cover(h,u),n=0;n<o;++n)Mp(this,a[n],s[n],e[n]);return this},Cp.cover=function(e,t){if(isNaN(e=+e)||isNaN(t=+t))return this;var n=this._x0,r=this._y0,i=this._x1,o=this._y1;if(isNaN(n))i=(n=Math.floor(e))+1,o=(r=Math.floor(t))+1;else{for(var a,s,c=i-n,l=this._root;n>e||e>=i||r>t||t>=o;)switch(s=(t<r)<<1|e<n,(a=new Array(4))[s]=l,l=a,c*=2,s){case 0:i=n+c,o=r+c;break;case 1:n=i-c,o=r+c;break;case 2:i=n+c,r=o-c;break;case 3:n=i-c,r=o-c}this._root&&this._root.length&&(this._root=l)}return this._x0=n,this._y0=r,this._x1=i,this._y1=o,this},Cp.data=function(){var e=[];return this.visit((function(t){if(!t.length)do{e.push(t.data)}while(t=t.next)})),e},Cp.extent=function(e){return arguments.length?this.cover(+e[0][0],+e[0][1]).cover(+e[1][0],+e[1][1]):isNaN(this._x0)?void 0:[[this._x0,this._y0],[this._x1,this._y1]]},Cp.find=function(e,t,n){var r,i,o,a,s,c,l,h=this._x0,u=this._y0,p=this._x1,d=this._y1,f=[],m=this._root;for(m&&f.push(new Ep(m,h,u,p,d)),null==n?n=1/0:(h=e-n,u=t-n,p=e+n,d=t+n,n*=n);c=f.pop();)if(!(!(m=c.node)||(i=c.x0)>p||(o=c.y0)>d||(a=c.x1)<h||(s=c.y1)<u))if(m.length){var g=(i+a)/2,v=(o+s)/2;f.push(new Ep(m[3],g,v,a,s),new Ep(m[2],i,v,g,s),new Ep(m[1],g,o,a,v),new Ep(m[0],i,o,g,v)),(l=(t>=v)<<1|e>=g)&&(c=f[f.length-1],f[f.length-1]=f[f.length-1-l],f[f.length-1-l]=c)}else{var y=e-+this._x.call(null,m.data),x=t-+this._y.call(null,m.data),b=y*y+x*x;if(b<n){var w=Math.sqrt(n=b);h=e-w,u=t-w,p=e+w,d=t+w,r=m.data}}return r},Cp.remove=function(e){if(isNaN(o=+this._x.call(null,e))||isNaN(a=+this._y.call(null,e)))return this;var t,n,r,i,o,a,s,c,l,h,u,p,d=this._root,f=this._x0,m=this._y0,g=this._x1,v=this._y1;if(!d)return this;if(d.length)for(;;){if((l=o>=(s=(f+g)/2))?f=s:g=s,(h=a>=(c=(m+v)/2))?m=c:v=c,t=d,!(d=d[u=h<<1|l]))return this;if(!d.length)break;(t[u+1&3]||t[u+2&3]||t[u+3&3])&&(n=t,p=u)}for(;d.data!==e;)if(r=d,!(d=d.next))return this;return(i=d.next)&&delete d.next,r?(i?r.next=i:delete r.next,this):t?(i?t[u]=i:delete t[u],(d=t[0]||t[1]||t[2]||t[3])&&d===(t[3]||t[2]||t[1]||t[0])&&!d.length&&(n?n[p]=d:this._root=d),this):(this._root=i,this)},Cp.removeAll=function(e){for(var t=0,n=e.length;t<n;++t)this.remove(e[t]);return this},Cp.root=function(){return this._root},Cp.size=function(){var e=0;return this.visit((function(t){if(!t.length)do{++e}while(t=t.next)})),e},Cp.visit=function(e){var t,n,r,i,o,a,s=[],c=this._root;for(c&&s.push(new Ep(c,this._x0,this._y0,this._x1,this._y1));t=s.pop();)if(!e(c=t.node,r=t.x0,i=t.y0,o=t.x1,a=t.y1)&&c.length){var l=(r+o)/2,h=(i+a)/2;(n=c[3])&&s.push(new Ep(n,l,h,o,a)),(n=c[2])&&s.push(new Ep(n,r,h,l,a)),(n=c[1])&&s.push(new Ep(n,l,i,o,h)),(n=c[0])&&s.push(new Ep(n,r,i,l,h))}return this},Cp.visitAfter=function(e){var t,n=[],r=[];for(this._root&&n.push(new Ep(this._root,this._x0,this._y0,this._x1,this._y1));t=n.pop();){var i=t.node;if(i.length){var o,a=t.x0,s=t.y0,c=t.x1,l=t.y1,h=(a+c)/2,u=(s+l)/2;(o=i[0])&&n.push(new Ep(o,a,s,h,u)),(o=i[1])&&n.push(new Ep(o,h,s,c,u)),(o=i[2])&&n.push(new Ep(o,a,u,h,l)),(o=i[3])&&n.push(new Ep(o,h,u,c,l))}r.push(t)}for(;t=r.pop();)e(t.node,t.x0,t.y0,t.x1,t.y1);return this},Cp.x=function(e){return arguments.length?(this._x=e,this):this._x},Cp.y=function(e){return arguments.length?(this._y=e,this):this._y};var Up=zp.prototype=kp.prototype;function Bp(e){return function(){return e}}function jp(){return 1e-6*(Math.random()-.5)}function Hp(e){return e.index}function Gp(e,t){var n=e.get(t);if(!n)throw new Error("node not found: "+t);return n}function Vp(e){var t,n,r,i,o,a,s=Hp,c=function(e){return 1/Math.min(o[e.source.index],o[e.target.index])},l=Bp(30),h=1;function u(r){for(var o=0,s=e.length;o<h;++o)for(var c,l,u,p,d,f=0,m=0,g=0,v=0;f<s;++f)l=(c=e[f]).source,m=(u=c.target).x+u.vx-l.x-l.vx||jp(),i>1&&(g=u.y+u.vy-l.y-l.vy||jp()),i>2&&(v=u.z+u.vz-l.z-l.vz||jp()),m*=p=((p=Math.sqrt(m*m+g*g+v*v))-n[f])/p*r*t[f],g*=p,v*=p,u.vx-=m*(d=a[f]),i>1&&(u.vy-=g*d),i>2&&(u.vz-=v*d),l.vx+=m*(d=1-d),i>1&&(l.vy+=g*d),i>2&&(l.vz+=v*d)}function p(){if(r){var i,c,l=r.length,h=e.length,u=new Map(r.map((e,t)=>[s(e,t,r),e]));for(i=0,o=new Array(l);i<h;++i)(c=e[i]).index=i,"object"!=typeof c.source&&(c.source=Gp(u,c.source)),"object"!=typeof c.target&&(c.target=Gp(u,c.target)),o[c.source.index]=(o[c.source.index]||0)+1,o[c.target.index]=(o[c.target.index]||0)+1;for(i=0,a=new Array(h);i<h;++i)c=e[i],a[i]=o[c.source.index]/(o[c.source.index]+o[c.target.index]);t=new Array(h),d(),n=new Array(h),f()}}function d(){if(r)for(var n=0,i=e.length;n<i;++n)t[n]=+c(e[n],n,e)}function f(){if(r)for(var t=0,i=e.length;t<i;++t)n[t]=+l(e[t],t,e)}return null==e&&(e=[]),u.initialize=function(e,t){r=e,i=t,p()},u.links=function(t){return arguments.length?(e=t,p(),u):e},u.id=function(e){return arguments.length?(s=e,u):s},u.iterations=function(e){return arguments.length?(h=+e,u):h},u.strength=function(e){return arguments.length?(c="function"==typeof e?e:Bp(+e),d(),u):c},u.distance=function(e){return arguments.length?(l="function"==typeof e?e:Bp(+e),f(),u):l},u}Up.copy=function(){var e,t,n=new kp(this._x,this._y,this._z,this._x0,this._y0,this._z0,this._x1,this._y1,this._z1),r=this._root;if(!r)return n;if(!r.length)return n._root=Fp(r),n;for(e=[{source:r,target:n._root=new Array(8)}];r=e.pop();)for(var i=0;i<8;++i)(t=r.source[i])&&(t.length?e.push({source:t,target:r.target[i]=new Array(8)}):r.target[i]=Fp(t));return n},Up.add=function(e){var t=+this._x.call(null,e),n=+this._y.call(null,e),r=+this._z.call(null,e);return Rp(this.cover(t,n,r),t,n,r,e)},Up.addAll=function(e){var t,n,r,i,o,a=e.length,s=new Array(a),c=new Array(a),l=new Array(a),h=1/0,u=1/0,p=1/0,d=-1/0,f=-1/0,m=-1/0;for(n=0;n<a;++n)isNaN(r=+this._x.call(null,t=e[n]))||isNaN(i=+this._y.call(null,t))||isNaN(o=+this._z.call(null,t))||(s[n]=r,c[n]=i,l[n]=o,r<h&&(h=r),r>d&&(d=r),i<u&&(u=i),i>f&&(f=i),o<p&&(p=o),o>m&&(m=o));for(d<h&&(h=this._x0,d=this._x1),f<u&&(u=this._y0,f=this._y1),m<p&&(p=this._z0,m=this._z1),this.cover(h,u,p).cover(d,f,m),n=0;n<a;++n)Rp(this,s[n],c[n],l[n],e[n]);return this},Up.cover=function(e,t,n){if(isNaN(e=+e)||isNaN(t=+t)||isNaN(n=+n))return this;var r=this._x0,i=this._y0,o=this._z0,a=this._x1,s=this._y1,c=this._z1;if(isNaN(r))a=(r=Math.floor(e))+1,s=(i=Math.floor(t))+1,c=(o=Math.floor(n))+1;else{if(!(r>e||e>a||i>t||t>s||o>n||n>c))return this;var l,h,u=a-r,p=this._root;switch(h=(n<(o+c)/2)<<2|(t<(i+s)/2)<<1|e<(r+a)/2){case 0:do{(l=new Array(8))[h]=p,p=l}while(s=i+(u*=2),c=o+u,e>(a=r+u)||t>s||n>c);break;case 1:do{(l=new Array(8))[h]=p,p=l}while(s=i+(u*=2),c=o+u,(r=a-u)>e||t>s||n>c);break;case 2:do{(l=new Array(8))[h]=p,p=l}while(i=s-(u*=2),c=o+u,e>(a=r+u)||i>t||n>c);break;case 3:do{(l=new Array(8))[h]=p,p=l}while(i=s-(u*=2),c=o+u,(r=a-u)>e||i>t||n>c);break;case 4:do{(l=new Array(8))[h]=p,p=l}while(s=i+(u*=2),o=c-u,e>(a=r+u)||t>s||o>n);break;case 5:do{(l=new Array(8))[h]=p,p=l}while(s=i+(u*=2),o=c-u,(r=a-u)>e||t>s||o>n);break;case 6:do{(l=new Array(8))[h]=p,p=l}while(i=s-(u*=2),o=c-u,e>(a=r+u)||i>t||o>n);break;case 7:do{(l=new Array(8))[h]=p,p=l}while(i=s-(u*=2),o=c-u,(r=a-u)>e||i>t||o>n)}this._root&&this._root.length&&(this._root=p)}return this._x0=r,this._y0=i,this._z0=o,this._x1=a,this._y1=s,this._z1=c,this},Up.data=function(){var e=[];return this.visit((function(t){if(!t.length)do{e.push(t.data)}while(t=t.next)})),e},Up.extent=function(e){return arguments.length?this.cover(+e[0][0],+e[0][1],+e[0][2]).cover(+e[1][0],+e[1][1],+e[1][2]):isNaN(this._x0)?void 0:[[this._x0,this._y0,this._z0],[this._x1,this._y1,this._z1]]},Up.find=function(e,t,n,r){var i,o,a,s,c,l,h,u,p,d=this._x0,f=this._y0,m=this._z0,g=this._x1,v=this._y1,y=this._z1,x=[],b=this._root;for(b&&x.push(new Op(b,d,f,m,g,v,y)),null==r?r=1/0:(d=e-r,f=t-r,m=n-r,g=e+r,v=t+r,y=n+r,r*=r);u=x.pop();)if(!(!(b=u.node)||(o=u.x0)>g||(a=u.y0)>v||(s=u.z0)>y||(c=u.x1)<d||(l=u.y1)<f||(h=u.z1)<m))if(b.length){var w=(o+c)/2,_=(a+l)/2,M=(s+h)/2;x.push(new Op(b[7],w,_,M,c,l,h),new Op(b[6],o,_,M,w,l,h),new Op(b[5],w,a,M,c,_,h),new Op(b[4],o,a,M,w,_,h),new Op(b[3],w,_,s,c,l,M),new Op(b[2],o,_,s,w,l,M),new Op(b[1],w,a,s,c,_,M),new Op(b[0],o,a,s,w,_,M)),(p=(n>=M)<<2|(t>=_)<<1|e>=w)&&(u=x[x.length-1],x[x.length-1]=x[x.length-1-p],x[x.length-1-p]=u)}else{var E=e-+this._x.call(null,b.data),S=t-+this._y.call(null,b.data),T=n-+this._z.call(null,b.data),A=E*E+S*S+T*T;if(A<r){var L=Math.sqrt(r=A);d=e-L,f=t-L,m=n-L,g=e+L,v=t+L,y=n+L,i=b.data}}return i},Up.remove=function(e){if(isNaN(o=+this._x.call(null,e))||isNaN(a=+this._y.call(null,e))||isNaN(s=+this._z.call(null,e)))return this;var t,n,r,i,o,a,s,c,l,h,u,p,d,f,m,g=this._root,v=this._x0,y=this._y0,x=this._z0,b=this._x1,w=this._y1,_=this._z1;if(!g)return this;if(g.length)for(;;){if((u=o>=(c=(v+b)/2))?v=c:b=c,(p=a>=(l=(y+w)/2))?y=l:w=l,(d=s>=(h=(x+_)/2))?x=h:_=h,t=g,!(g=g[f=d<<2|p<<1|u]))return this;if(!g.length)break;(t[f+1&7]||t[f+2&7]||t[f+3&7]||t[f+4&7]||t[f+5&7]||t[f+6&7]||t[f+7&7])&&(n=t,m=f)}for(;g.data!==e;)if(r=g,!(g=g.next))return this;return(i=g.next)&&delete g.next,r?(i?r.next=i:delete r.next,this):t?(i?t[f]=i:delete t[f],(g=t[0]||t[1]||t[2]||t[3]||t[4]||t[5]||t[6]||t[7])&&g===(t[7]||t[6]||t[5]||t[4]||t[3]||t[2]||t[1]||t[0])&&!g.length&&(n?n[m]=g:this._root=g),this):(this._root=i,this)},Up.removeAll=function(e){for(var t=0,n=e.length;t<n;++t)this.remove(e[t]);return this},Up.root=function(){return this._root},Up.size=function(){var e=0;return this.visit((function(t){if(!t.length)do{++e}while(t=t.next)})),e},Up.visit=function(e){var t,n,r,i,o,a,s,c,l=[],h=this._root;for(h&&l.push(new Op(h,this._x0,this._y0,this._z0,this._x1,this._y1,this._z1));t=l.pop();)if(!e(h=t.node,r=t.x0,i=t.y0,o=t.z0,a=t.x1,s=t.y1,c=t.z1)&&h.length){var u=(r+a)/2,p=(i+s)/2,d=(o+c)/2;(n=h[7])&&l.push(new Op(n,u,p,d,a,s,c)),(n=h[6])&&l.push(new Op(n,r,p,d,u,s,c)),(n=h[5])&&l.push(new Op(n,u,i,d,a,p,c)),(n=h[4])&&l.push(new Op(n,r,i,d,u,p,c)),(n=h[3])&&l.push(new Op(n,u,p,o,a,s,d)),(n=h[2])&&l.push(new Op(n,r,p,o,u,s,d)),(n=h[1])&&l.push(new Op(n,u,i,o,a,p,d)),(n=h[0])&&l.push(new Op(n,r,i,o,u,p,d))}return this},Up.visitAfter=function(e){var t,n=[],r=[];for(this._root&&n.push(new Op(this._root,this._x0,this._y0,this._z0,this._x1,this._y1,this._z1));t=n.pop();){var i=t.node;if(i.length){var o,a=t.x0,s=t.y0,c=t.z0,l=t.x1,h=t.y1,u=t.z1,p=(a+l)/2,d=(s+h)/2,f=(c+u)/2;(o=i[0])&&n.push(new Op(o,a,s,c,p,d,f)),(o=i[1])&&n.push(new Op(o,p,s,c,l,d,f)),(o=i[2])&&n.push(new Op(o,a,d,c,p,h,f)),(o=i[3])&&n.push(new Op(o,p,d,c,l,h,f)),(o=i[4])&&n.push(new Op(o,a,s,f,p,d,u)),(o=i[5])&&n.push(new Op(o,p,s,f,l,d,u)),(o=i[6])&&n.push(new Op(o,a,d,f,p,h,u)),(o=i[7])&&n.push(new Op(o,p,d,f,l,h,u))}r.push(t)}for(;t=r.pop();)e(t.node,t.x0,t.y0,t.z0,t.x1,t.y1,t.z1);return this},Up.x=function(e){return arguments.length?(this._x=e,this):this._x},Up.y=function(e){return arguments.length?(this._y=e,this):this._y},Up.z=function(e){return arguments.length?(this._z=e,this):this._z};var Wp={value:function(){}};function qp(){for(var e,t=0,n=arguments.length,r={};t<n;++t){if(!(e=arguments[t]+"")||e in r||/[\s.]/.test(e))throw new Error("illegal type: "+e);r[e]=[]}return new Xp(r)}function Xp(e){this._=e}function Yp(e,t){return e.trim().split(/^|\s+/).map((function(e){var n="",r=e.indexOf(".");if(r>=0&&(n=e.slice(r+1),e=e.slice(0,r)),e&&!t.hasOwnProperty(e))throw new Error("unknown type: "+e);return{type:e,name:n}}))}function Zp(e,t){for(var n,r=0,i=e.length;r<i;++r)if((n=e[r]).name===t)return n.value}function Jp(e,t,n){for(var r=0,i=e.length;r<i;++r)if(e[r].name===t){e[r]=Wp,e=e.slice(0,r).concat(e.slice(r+1));break}return null!=n&&e.push({name:t,value:n}),e}Xp.prototype=qp.prototype={constructor:Xp,on:function(e,t){var n,r=this._,i=Yp(e+"",r),o=-1,a=i.length;if(!(arguments.length<2)){if(null!=t&&"function"!=typeof t)throw new Error("invalid callback: "+t);for(;++o<a;)if(n=(e=i[o]).type)r[n]=Jp(r[n],e.name,t);else if(null==t)for(n in r)r[n]=Jp(r[n],e.name,null);return this}for(;++o<a;)if((n=(e=i[o]).type)&&(n=Zp(r[n],e.name)))return n},copy:function(){var e={},t=this._;for(var n in t)e[n]=t[n].slice();return new Xp(e)},call:function(e,t){if((n=arguments.length-2)>0)for(var n,r,i=new Array(n),o=0;o<n;++o)i[o]=arguments[o+2];if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(o=0,n=(r=this._[e]).length;o<n;++o)r[o].value.apply(t,i)},apply:function(e,t,n){if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(var r=this._[e],i=0,o=r.length;i<o;++i)r[i].value.apply(t,n)}};var Qp,Kp,$p=0,ed=0,td=0,nd=1e3,rd=0,id=0,od=0,ad="object"==typeof performance&&performance.now?performance:Date,sd="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(e){setTimeout(e,17)};function cd(){return id||(sd(ld),id=ad.now()+od)}function ld(){id=0}function hd(){this._call=this._time=this._next=null}function ud(e,t,n){var r=new hd;return r.restart(e,t,n),r}function pd(){id=(rd=ad.now())+od,$p=ed=0;try{!function(){cd(),++$p;for(var e,t=Qp;t;)(e=id-t._time)>=0&&t._call.call(null,e),t=t._next;--$p}()}finally{$p=0,function(){var e,t,n=Qp,r=1/0;for(;n;)n._call?(r>n._time&&(r=n._time),e=n,n=n._next):(t=n._next,n._next=null,n=e?e._next=t:Qp=t);Kp=e,fd(r)}(),id=0}}function dd(){var e=ad.now(),t=e-rd;t>nd&&(od-=t,rd=e)}function fd(e){$p||(ed&&(ed=clearTimeout(ed)),e-id>24?(e<1/0&&(ed=setTimeout(pd,e-ad.now()-od)),td&&(td=clearInterval(td))):(td||(rd=ad.now(),td=setInterval(dd,nd)),$p=1,sd(pd)))}hd.prototype=ud.prototype={constructor:hd,restart:function(e,t,n){if("function"!=typeof e)throw new TypeError("callback is not a function");n=(null==n?cd():+n)+(null==t?0:+t),this._next||Kp===this||(Kp?Kp._next=this:Qp=this,Kp=this),this._call=e,this._time=n,fd()},stop:function(){this._call&&(this._call=null,this._time=1/0,fd())}};var md=3;function gd(e){return e.x}function vd(e){return e.y}function yd(e){return e.z}var xd=10,bd=Math.PI*(3-Math.sqrt(5)),wd=Math.PI/24;function _d(e,t){t=t||2;var n,r=Math.min(md,Math.max(1,Math.round(t))),i=1,o=.001,a=1-Math.pow(o,1/300),s=0,c=.6,l=new Map,h=ud(p),u=qp("tick","end");function p(){d(),u.call("tick",n),i<o&&(h.stop(),u.call("end",n))}function d(t){var o,h,u=e.length;void 0===t&&(t=1);for(var p=0;p<t;++p)for(i+=(s-i)*a,l.forEach((function(e){e(i)})),o=0;o<u;++o)null==(h=e[o]).fx?h.x+=h.vx*=c:(h.x=h.fx,h.vx=0),r>1&&(null==h.fy?h.y+=h.vy*=c:(h.y=h.fy,h.vy=0)),r>2&&(null==h.fz?h.z+=h.vz*=c:(h.z=h.fz,h.vz=0));return n}function f(){for(var t,n=0,i=e.length;n<i;++n){if((t=e[n]).index=n,null!=t.fx&&(t.x=t.fx),null!=t.fy&&(t.y=t.fy),null!=t.fz&&(t.z=t.fz),isNaN(t.x)||r>1&&isNaN(t.y)||r>2&&isNaN(t.z)){var o=xd*(r>2?Math.cbrt(n):r>1?Math.sqrt(n):n),a=n*bd,s=n*wd;t.x=o*(r>1?Math.cos(a):1),r>1&&(t.y=o*Math.sin(a)),r>2&&(t.z=o*Math.sin(s))}(isNaN(t.vx)||r>1&&isNaN(t.vy)||r>2&&isNaN(t.vz))&&(t.vx=0,r>1&&(t.vy=0),r>2&&(t.vz=0))}}function m(t){return t.initialize&&t.initialize(e,r),t}return null==e&&(e=[]),f(),n={tick:d,restart:function(){return h.restart(p),n},stop:function(){return h.stop(),n},numDimensions:function(e){return arguments.length?(r=Math.min(md,Math.max(1,Math.round(e))),l.forEach(m),n):r},nodes:function(t){return arguments.length?(e=t,f(),l.forEach(m),n):e},alpha:function(e){return arguments.length?(i=+e,n):i},alphaMin:function(e){return arguments.length?(o=+e,n):o},alphaDecay:function(e){return arguments.length?(a=+e,n):+a},alphaTarget:function(e){return arguments.length?(s=+e,n):s},velocityDecay:function(e){return arguments.length?(c=1-e,n):1-c},force:function(e,t){return arguments.length>1?(null==t?l.delete(e):l.set(e,m(t)),n):l.get(e)},find:function(){var t,n,i,o,a,s,c=Array.prototype.slice.call(arguments),l=c.shift()||0,h=(r>1?c.shift():null)||0,u=(r>2?c.shift():null)||0,p=c.shift()||1/0,d=0,f=e.length;for(p*=p,d=0;d<f;++d)(o=(t=l-(a=e[d]).x)*t+(n=h-(a.y||0))*n+(i=u-(a.z||0))*i)<p&&(s=a,p=o);return s},on:function(e,t){return arguments.length>1?(u.on(e,t),n):u.on(e)}}}function Md(){var e,t,n,r,i,o=Bp(-30),a=1,s=1/0,c=.81;function l(i){var o,a=e.length,s=(1===t?xp(e,gd):2===t?Ap(e,gd,vd):3===t?zp(e,gd,vd,yd):null).visitAfter(u);for(r=i,o=0;o<a;++o)n=e[o],s.visit(p)}function h(){if(e){var t,n,r=e.length;for(i=new Array(r),t=0;t<r;++t)n=e[t],i[n.index]=+o(n,t,e)}}function u(e){var n,r,o,a,s,c,l=0,h=0,u=e.length;if(u){for(o=a=s=c=0;c<u;++c)(n=e[c])&&(r=Math.abs(n.value))&&(l+=n.value,h+=r,o+=r*(n.x||0),a+=r*(n.y||0),s+=r*(n.z||0));l*=Math.sqrt(4/u),e.x=o/h,t>1&&(e.y=a/h),t>2&&(e.z=s/h)}else{(n=e).x=n.data.x,t>1&&(n.y=n.data.y),t>2&&(n.z=n.data.z);do{l+=i[n.data.index]}while(n=n.next)}e.value=l}function p(e,o,l,h,u){if(!e.value)return!0;var p=[l,h,u][t-1],d=e.x-n.x,f=t>1?e.y-n.y:0,m=t>2?e.z-n.z:0,g=p-o,v=d*d+f*f+m*m;if(g*g/c<v)return v<s&&(0===d&&(v+=(d=jp())*d),t>1&&0===f&&(v+=(f=jp())*f),t>2&&0===m&&(v+=(m=jp())*m),v<a&&(v=Math.sqrt(a*v)),n.vx+=d*e.value*r/v,t>1&&(n.vy+=f*e.value*r/v),t>2&&(n.vz+=m*e.value*r/v)),!0;if(!(e.length||v>=s)){(e.data!==n||e.next)&&(0===d&&(v+=(d=jp())*d),t>1&&0===f&&(v+=(f=jp())*f),t>2&&0===m&&(v+=(m=jp())*m),v<a&&(v=Math.sqrt(a*v)));do{e.data!==n&&(g=i[e.data.index]*r/v,n.vx+=d*g,t>1&&(n.vy+=f*g),t>2&&(n.vz+=m*g))}while(e=e.next)}}return l.initialize=function(n,r){e=n,t=r,h()},l.strength=function(e){return arguments.length?(o="function"==typeof e?e:Bp(+e),h(),l):o},l.distanceMin=function(e){return arguments.length?(a=e*e,l):Math.sqrt(a)},l.distanceMax=function(e){return arguments.length?(s=e*e,l):Math.sqrt(s)},l.theta=function(e){return arguments.length?(c=e*e,l):Math.sqrt(c)},l}var Ed=function(e){!function(e){if(!e)throw new Error("Eventify cannot use falsy object as events subject");for(var t=["on","fire","off"],n=0;n<t.length;++n)if(e.hasOwnProperty(t[n]))throw new Error("Subject cannot be eventified, since it already has property '"+t[n]+"'")}(e);var t=function(e){var t=Object.create(null);return{on:function(n,r,i){if("function"!=typeof r)throw new Error("callback is expected to be a function");var o=t[n];return o||(o=t[n]=[]),o.push({callback:r,ctx:i}),e},off:function(n,r){if(void 0===n)return t=Object.create(null),e;if(t[n])if("function"!=typeof r)delete t[n];else for(var i=t[n],o=0;o<i.length;++o)i[o].callback===r&&i.splice(o,1);return e},fire:function(n){var r,i=t[n];if(!i)return e;arguments.length>1&&(r=Array.prototype.splice.call(arguments,1));for(var o=0;o<i.length;++o){var a=i[o];a.callback.apply(a.ctx,r)}return e}}}(e);return e.on=t.on,e.off=t.off,e.fire=t.fire,e};var Sd=function(e){"uniqueLinkId"in(e=e||{})&&(console.warn("ngraph.graph: Starting from version 0.14 `uniqueLinkId` is deprecated.\nUse `multigraph` option instead\n","\n","Note: there is also change in default behavior: From now on each graph\nis considered to be not a multigraph by default (each edge is unique)."),e.multigraph=e.uniqueLinkId);void 0===e.multigraph&&(e.multigraph=!1);if("function"!=typeof Map)throw new Error("ngraph.graph requires `Map` to be defined. Please polyfill it before using ngraph");var t=new Map,n=[],r={},i=0,o=e.multigraph?function(e,t,n){var i=Cd(e,t),o=r.hasOwnProperty(i);if(o||y(e,t)){o||(r[i]=0);var a="@"+ ++r[i];i=Cd(e+a,t+a)}return new Pd(e,t,n,i)}:function(e,t,n){var r=Cd(e,t);return new Pd(e,t,n,r)},a=[],s=x,c=x,l=x,h=x,u={addNode:f,addLink:function(e,t,r){l();var i=m(e)||f(e),a=m(t)||f(t),c=o(e,t,r);n.push(c),Ld(i,c),e!==t&&Ld(a,c);return s(c,"add"),h(),c},removeLink:v,removeNode:g,getNode:m,getNodesCount:function(){return t.size},getLinksCount:function(){return n.length},getLinks:function(e){var t=m(e);return t?t.links:null},forEachNode:_,forEachLinkedNode:function(e,n,r){var i=m(e);if(i&&i.links&&"function"==typeof n)return r?function(e,n,r){for(var i=0;i<e.length;++i){var o=e[i];if(o.fromId===n&&r(t.get(o.toId),o))return!0}}(i.links,e,n):function(e,n,r){for(var i=0;i<e.length;++i){var o=e[i],a=o.fromId===n?o.toId:o.fromId;if(r(t.get(a),o))return!0}}(i.links,e,n)},forEachLink:function(e){var t,r;if("function"==typeof e)for(t=0,r=n.length;t<r;++t)e(n[t])},beginUpdate:l,endUpdate:h,clear:function(){l(),_((function(e){g(e.id)})),h()},hasLink:y,hasNode:m,getLink:y};return Ed(u),function(){var e=u.on;u.on=function(){return u.beginUpdate=l=b,u.endUpdate=h=w,s=p,c=d,u.on=e,e.apply(u,arguments)}}(),u;function p(e,t){a.push({link:e,changeType:t})}function d(e,t){a.push({node:e,changeType:t})}function f(e,n){if(void 0===e)throw new Error("Invalid node identifier");l();var r=m(e);return r?(r.data=n,c(r,"update")):(r=new Ad(e,n),c(r,"add")),t.set(e,r),h(),r}function m(e){return t.get(e)}function g(e){var n=m(e);if(!n)return!1;l();var r=n.links;if(r){n.links=null;for(var i=0;i<r.length;++i)v(r[i])}return t.delete(e),c(n,"remove"),h(),!0}function v(e){if(!e)return!1;var t=Td(e,n);if(t<0)return!1;l(),n.splice(t,1);var r=m(e.fromId),i=m(e.toId);return r&&(t=Td(e,r.links))>=0&&r.links.splice(t,1),i&&(t=Td(e,i.links))>=0&&i.links.splice(t,1),s(e,"remove"),h(),!0}function y(e,t){var n,r=m(e);if(!r||!r.links)return null;for(n=0;n<r.links.length;++n){var i=r.links[n];if(i.fromId===e&&i.toId===t)return i}return null}function x(){}function b(){i+=1}function w(){0===(i-=1)&&a.length>0&&(u.fire("changed",a),a.length=0)}function _(e){if("function"!=typeof e)throw new Error("Function is expected to iterate over graph nodes. You passed "+e);for(var n=t.values(),r=n.next();!r.done;){if(e(r.value))return!0;r=n.next()}}};function Td(e,t){if(!t)return-1;if(t.indexOf)return t.indexOf(e);var n,r=t.length;for(n=0;n<r;n+=1)if(t[n]===e)return n;return-1}function Ad(e,t){this.id=e,this.links=null,this.data=t}function Ld(e,t){e.links?e.links.push(t):e.links=[t]}function Pd(e,t,n,r){this.fromId=e,this.toId=t,this.data=n,this.id=r}function Cd(e,t){return e.toString()+"👉 "+t.toString()}var Rd=function(e,t,n,r,i){this.from=e,this.to=t,this.length=n,this.coeff=r,this.weight="number"==typeof i?i:1};var Od=function(e,t,n){if("[object Array]"===Object.prototype.toString.call(n))for(var r=0;r<n.length;++r)Dd(e,t,n[r]);else for(var i in e)Dd(e,t,i)};function Dd(e,t,n){if(e.hasOwnProperty(n)){if("function"==typeof t[n])return;t[n]=function(r){return void 0!==r?(e[n]=r,t):e[n]}}}var Nd=function e(t,n){var r;t||(t={});if(n)for(r in n)if(n.hasOwnProperty(r)){var i=t.hasOwnProperty(r),o=typeof n[r];!i||typeof t[r]!==o?t[r]=n[r]:"object"===o&&(t[r]=e(t[r],n[r]))}return t};"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function Id(e,t){return e(t={exports:{}},t.exports),t.exports}var zd=Id((function(e){function t(e){return new n("number"==typeof e?e:+new Date)}function n(e){this.seed=e}function r(){var e=this.seed;return e=4294967295&(3042594569^(e=(e=4294967295&((e=(e=4294967295&(3345072700^(e=e+2127912214+(e<<12)&4294967295)^e>>>19))+374761393+(e<<5)&4294967295)+3550635116^e<<9))+4251993797+(e<<3)&4294967295)^e>>>16),this.seed=e,(268435455&e)/268435456}e.exports=t,e.exports.random=t,e.exports.randomIterator=function(e,n){var r=n||t();if("function"!=typeof r.next)throw new Error("customRandom does not match expected API: next() function is missing");return{forEach:function(t){var n,i,o;for(n=e.length-1;n>0;--n)i=r.next(n+1),o=e[i],e[i]=e[n],e[n]=o,t(o);e.length&&t(e[0])},shuffle:function(){var t,n,i;for(t=e.length-1;t>0;--t)n=r.next(t+1),i=e[n],e[n]=e[t],e[t]=i;return e}}},n.prototype.next=function(e){return Math.floor(this.nextDouble()*e)},n.prototype.nextDouble=r,n.prototype.uniform=r,n.prototype.gaussian=function(){var e,t,n;do{t=2*this.nextDouble()-1,n=2*this.nextDouble()-1,e=t*t+n*n}while(e>=1||0===e);return t*Math.sqrt(-2*Math.log(e)/e)}})),kd=(zd.random,zd.randomIterator,function(){this.body=null,this.quad0=null,this.quad1=null,this.quad2=null,this.quad3=null,this.mass=0,this.massX=0,this.massY=0,this.left=0,this.top=0,this.bottom=0,this.right=0}),Fd=Ud;function Ud(){this.stack=[],this.popIdx=0}function Bd(e,t){this.node=e,this.body=t}Ud.prototype={isEmpty:function(){return 0===this.popIdx},push:function(e,t){var n=this.stack[this.popIdx];n?(n.node=e,n.body=t):this.stack[this.popIdx]=new Bd(e,t),++this.popIdx},pop:function(){if(this.popIdx>0)return this.stack[--this.popIdx]},reset:function(){this.popIdx=0}};var jd=function(e,t){var n=Math.abs(e.x-t.x),r=Math.abs(e.y-t.y);return n<1e-8&&r<1e-8},Hd=function(e){(e=e||{}).gravity="number"==typeof e.gravity?e.gravity:-1,e.theta="number"==typeof e.theta?e.theta:.8;var t=zd.random(1984),n=kd,r=Fd,i=jd,o=e.gravity,a=[],s=new r,c=e.theta,l=[],h=0,u=p();return{insertBodies:function(e){var t,n=Number.MAX_VALUE,r=Number.MAX_VALUE,i=Number.MIN_VALUE,o=Number.MIN_VALUE,a=e.length;t=a;for(;t--;){var s=e[t].pos.x,c=e[t].pos.y;s<n&&(n=s),s>i&&(i=s),c<r&&(r=c),c>o&&(o=c)}var l=i-n,f=o-r;l>f?o=r+l:i=n+f;h=0,(u=p()).left=n,u.right=i,u.top=r,u.bottom=o,(t=a-1)>=0&&(u.body=e[t]);for(;t--;)d(e[t])},getRoot:function(){return u},updateBodyForce:function(e){var n,r,i,s,l=a,h=0,p=0,d=1,f=0,m=1;l[0]=u;for(;d;){var g=l[f],v=g.body;d-=1,f+=1;var y=v!==e;v&&y?(r=v.pos.x-e.pos.x,i=v.pos.y-e.pos.y,0===(s=Math.sqrt(r*r+i*i))&&(r=(t.nextDouble()-.5)/50,i=(t.nextDouble()-.5)/50,s=Math.sqrt(r*r+i*i)),n=o*v.mass*e.mass/(s*s*s),h+=n*r,p+=n*i):y&&(r=g.massX/g.mass-e.pos.x,i=g.massY/g.mass-e.pos.y,0===(s=Math.sqrt(r*r+i*i))&&(r=(t.nextDouble()-.5)/50,i=(t.nextDouble()-.5)/50,s=Math.sqrt(r*r+i*i)),(g.right-g.left)/s<c?(n=o*g.mass*e.mass/(s*s*s),h+=n*r,p+=n*i):(g.quad0&&(l[m]=g.quad0,d+=1,m+=1),g.quad1&&(l[m]=g.quad1,d+=1,m+=1),g.quad2&&(l[m]=g.quad2,d+=1,m+=1),g.quad3&&(l[m]=g.quad3,d+=1,m+=1)))}e.force.x+=h,e.force.y+=p},options:function(e){return e?("number"==typeof e.gravity&&(o=e.gravity),"number"==typeof e.theta&&(c=e.theta),this):{gravity:o,theta:c}}};function p(){var e=l[h];return e?(e.quad0=null,e.quad1=null,e.quad2=null,e.quad3=null,e.body=null,e.mass=e.massX=e.massY=0,e.left=e.right=e.top=e.bottom=0):(e=new n,l[h]=e),++h,e}function d(e){for(s.reset(),s.push(u,e);!s.isEmpty();){var n=s.pop(),r=n.node,o=n.body;if(r.body){var a=r.body;if(r.body=null,i(a.pos,o.pos)){var c=3;do{var l=t.nextDouble(),h=(r.right-r.left)*l,d=(r.bottom-r.top)*l;a.pos.x=r.left+h,a.pos.y=r.top+d,c-=1}while(c>0&&i(a.pos,o.pos));if(0===c&&i(a.pos,o.pos))return}s.push(r,a),s.push(r,o)}else{var f=o.pos.x,m=o.pos.y;r.mass=r.mass+o.mass,r.massX=r.massX+o.mass*f,r.massY=r.massY+o.mass*m;var g=0,v=r.left,y=(r.right+v)/2,x=r.top,b=(r.bottom+x)/2;f>y&&(g+=1,v=y,y=r.right),m>b&&(g+=2,x=b,b=r.bottom);var w=Gd(r,g);w?s.push(w,o):((w=p()).left=v,w.top=x,w.right=y,w.bottom=b,w.body=o,Vd(r,g,w))}}}};function Gd(e,t){return 0===t?e.quad0:1===t?e.quad1:2===t?e.quad2:3===t?e.quad3:null}function Vd(e,t,n){0===t?e.quad0=n:1===t?e.quad1=n:2===t?e.quad2=n:3===t&&(e.quad3=n)}var Wd=function(e,t){var n=zd.random(42),r={x1:0,y1:0,x2:0,y2:0};return{box:r,update:function(){var t=e.length;if(0===t)return;var n=Number.MAX_VALUE,i=Number.MAX_VALUE,o=Number.MIN_VALUE,a=Number.MIN_VALUE;for(;t--;){var s=e[t];s.isPinned?(s.pos.x=s.prevPos.x,s.pos.y=s.prevPos.y):(s.prevPos.x=s.pos.x,s.prevPos.y=s.pos.y),s.pos.x<n&&(n=s.pos.x),s.pos.x>o&&(o=s.pos.x),s.pos.y<i&&(i=s.pos.y),s.pos.y>a&&(a=s.pos.y)}r.x1=n,r.x2=o,r.y1=i,r.y2=a},reset:function(){r.x1=r.y1=0,r.x2=r.y2=0},getBestNewPosition:function(e){var i=r,o=0,a=0;if(e.length){for(var s=0;s<e.length;++s)o+=e[s].pos.x,a+=e[s].pos.y;o/=e.length,a/=e.length}else o=(i.x1+i.x2)/2,a=(i.y1+i.y2)/2;var c=t.springLength;return{x:o+n.next(c)-c/2,y:a+n.next(c)-c/2}}}},qd=function(e){var t={update:function(t){t.force.x-=e.dragCoeff*t.velocity.x,t.force.y-=e.dragCoeff*t.velocity.y}};return Od(e=Nd(e,{dragCoeff:.02}),t,["dragCoeff"]),t},Xd=function(e){var t=Nd,n=zd.random(42),r={update:function(t){var r=t.from,i=t.to,o=t.length<0?e.springLength:t.length,a=i.pos.x-r.pos.x,s=i.pos.y-r.pos.y,c=Math.sqrt(a*a+s*s);0===c&&(a=(n.nextDouble()-.5)/50,s=(n.nextDouble()-.5)/50,c=Math.sqrt(a*a+s*s));var l=c-o,h=(!t.coeff||t.coeff<0?e.springCoeff:t.coeff)*l/c*t.weight;r.force.x+=h*a,r.force.y+=h*s,i.force.x-=h*a,i.force.y-=h*s}};return Od(e=t(e,{springCoeff:2e-4,springLength:80}),r,["springCoeff","springLength"]),r},Yd=function(e,t){var n,r=0,i=0,o=0,a=0,s=e.length;if(0===s)return 0;for(n=0;n<s;++n){var c=e[n],l=t/c.mass;c.velocity.x+=l*c.force.x,c.velocity.y+=l*c.force.y;var h=c.velocity.x,u=c.velocity.y,p=Math.sqrt(h*h+u*u);p>1&&(c.velocity.x=h/p,c.velocity.y=u/p),r=t*c.velocity.x,o=t*c.velocity.y,c.pos.x+=r,c.pos.y+=o,i+=Math.abs(r),a+=Math.abs(o)}return(i*i+a*a)/s};var Zd={Body:Jd,Vector2d:Qd,Body3d:Kd,Vector3d:$d};function Jd(e,t){this.pos=new Qd(e,t),this.prevPos=new Qd(e,t),this.force=new Qd,this.velocity=new Qd,this.mass=1}function Qd(e,t){e&&"number"!=typeof e?(this.x="number"==typeof e.x?e.x:0,this.y="number"==typeof e.y?e.y:0):(this.x="number"==typeof e?e:0,this.y="number"==typeof t?t:0)}function Kd(e,t,n){this.pos=new $d(e,t,n),this.prevPos=new $d(e,t,n),this.force=new $d,this.velocity=new $d,this.mass=1}function $d(e,t,n){e&&"number"!=typeof e?(this.x="number"==typeof e.x?e.x:0,this.y="number"==typeof e.y?e.y:0,this.z="number"==typeof e.z?e.z:0):(this.x="number"==typeof e?e:0,this.y="number"==typeof t?t:0,this.z="number"==typeof n?n:0)}Jd.prototype.setPosition=function(e,t){this.prevPos.x=this.pos.x=e,this.prevPos.y=this.pos.y=t},Qd.prototype.reset=function(){this.x=this.y=0},Kd.prototype.setPosition=function(e,t,n){this.prevPos.x=this.pos.x=e,this.prevPos.y=this.pos.y=t,this.prevPos.z=this.pos.z=n},$d.prototype.reset=function(){this.x=this.y=this.z=0};var ef=function(e){return new Zd.Body(e)},tf=function(e){var t=Rd,n=Od,r=Ed,i=(e=Nd(e,{springLength:30,springCoeff:8e-4,gravity:-1.2,theta:.8,dragCoeff:.02,timeStep:20})).createQuadTree||Hd,o=e.createBounds||Wd,a=e.createDragForce||qd,s=e.createSpringForce||Xd,c=e.integrator||Yd,l=e.createBody||ef,h=[],u=[],p=i(e),d=o(h,e),f=s(e),m=a(e),g=!0,v={bodies:h,quadTree:p,springs:u,settings:e,step:function(){!function(){var e,t=h.length;if(t)for(p.insertBodies(h);t--;)(e=h[t]).isPinned||(e.force.reset(),p.updateBodyForce(e),m.update(e));t=u.length;for(;t--;)f.update(u[t])}();var t=c(h,e.timeStep);return d.update(),t},addBody:function(e){if(!e)throw new Error("Body is required");return h.push(e),e},addBodyAt:function(e){if(!e)throw new Error("Body position is required");var t=l(e);return h.push(t),t},removeBody:function(e){if(e){var t=h.indexOf(e);if(!(t<0))return h.splice(t,1),0===h.length&&d.reset(),!0}},addSpring:function(e,n,r,i,o){if(!e||!n)throw new Error("Cannot add null spring to force simulator");"number"!=typeof r&&(r=-1);var a=new t(e,n,r,o>=0?o:-1,i);return u.push(a),a},getTotalMovement:function(){return 0},removeSpring:function(e){if(e){var t=u.indexOf(e);return t>-1?(u.splice(t,1),!0):void 0}},getBestNewBodyPosition:function(e){return d.getBestNewPosition(e)},getBBox:function(){return g&&(d.update(),g=!1),d.box},invalidateBBox:function(){g=!0},gravity:function(t){return void 0!==t?(e.gravity=t,p.options({gravity:t}),this):e.gravity},theta:function(t){return void 0!==t?(e.theta=t,p.options({theta:t}),this):e.theta}};return n(e,v),r(v),v};var nf=function(e,t){if(!e)throw new Error("Graph structure cannot be undefined");var n=tf(t),r=function(t){var n=e.getLinks(t);return n?1+n.length/3:1};t&&"function"==typeof t.nodeMass&&(r=t.nodeMass);var i=Object.create(null),o={},a=0,s=n.settings.springTransform||of;a=0,e.forEachNode((function(e){u(e.id),a+=1})),e.forEachLink(d),e.on("changed",h);var c=!1,l={step:function(){if(0===a)return!0;var e=n.step();l.lastMove=e,l.fire("step");var t,r=e/a<=.01;return c!==r&&(c=r,t=r,l.fire("stable",t)),r},getNodePosition:function(e){return g(e).pos},setNodePosition:function(e){var t=g(e);t.setPosition.apply(t,Array.prototype.slice.call(arguments,1)),n.invalidateBBox()},getLinkPosition:function(e){var t=o[e];if(t)return{from:t.from.pos,to:t.to.pos}},getGraphRect:function(){return n.getBBox()},forEachBody:function(e){Object.keys(i).forEach((function(t){e(i[t],t)}))},pinNode:function(e,t){g(e.id).isPinned=!!t},isNodePinned:function(e){return g(e.id).isPinned},dispose:function(){e.off("changed",h),l.fire("disposed")},getBody:function(e){return i[e]},getSpring:function(t,n){var r;if(void 0===n)r="object"!=typeof t?t:t.id;else{var i=e.hasLink(t,n);if(!i)return;r=i.id}return o[r]},simulator:n,graph:e,lastMove:0};return Ed(l),l;function h(t){for(var n=0;n<t.length;++n){var r=t[n];"add"===r.changeType?(r.node&&u(r.node.id),r.link&&d(r.link)):"remove"===r.changeType&&(r.node&&p(r.node),r.link&&f(r.link))}a=e.getNodesCount()}function u(t){var r=i[t];if(!r){var o=e.getNode(t);if(!o)throw new Error("initBody() was called with unknown node id");var a=o.position;if(!a){var s=function(e){var t=[];if(!e.links)return t;for(var n=Math.min(e.links.length,2),r=0;r<n;++r){var o=e.links[r],a=o.fromId!==e.id?i[o.fromId]:i[o.toId];a&&a.pos&&t.push(a)}return t}(o);a=n.getBestNewBodyPosition(s)}(r=n.addBodyAt(a)).id=t,i[t]=r,m(t),function(e){return e&&(e.isPinned||e.data&&e.data.isPinned)}(o)&&(r.isPinned=!0)}}function p(e){var t=e.id,r=i[t];r&&(i[t]=null,delete i[t],n.removeBody(r))}function d(e){m(e.fromId),m(e.toId);var t=i[e.fromId],r=i[e.toId],a=n.addSpring(t,r,e.length);s(e,a),o[e.id]=a}function f(t){var r=o[t.id];if(r){var i=e.getNode(t.fromId),a=e.getNode(t.toId);i&&m(i.id),a&&m(a.id),delete o[t.id],n.removeSpring(r)}}function m(e){var t=i[e];if(t.mass=r(e),Number.isNaN(t.mass))throw new Error("Node mass should be a number")}function g(e){var t=i[e];return t||(u(e),t=i[e]),t}},rf=tf;function of(){}nf.simulator=rf;var af=function(){this.body=null,this.quad0=null,this.quad1=null,this.quad2=null,this.quad3=null,this.quad4=null,this.quad5=null,this.quad6=null,this.quad7=null,this.mass=0,this.massX=0,this.massY=0,this.massZ=0,this.left=0,this.top=0,this.bottom=0,this.right=0,this.front=0,this.back=0},sf=cf;function cf(){this.stack=[],this.popIdx=0}function lf(e,t){this.node=e,this.body=t}cf.prototype={isEmpty:function(){return 0===this.popIdx},push:function(e,t){var n=this.stack[this.popIdx];n?(n.node=e,n.body=t):this.stack[this.popIdx]=new lf(e,t),++this.popIdx},pop:function(){if(this.popIdx>0)return this.stack[--this.popIdx]},reset:function(){this.popIdx=0}};var hf=function(e,t){var n=Math.abs(e.x-t.x),r=Math.abs(e.y-t.y),i=Math.abs(e.z-t.z);return n<1e-8&&r<1e-8&&i<1e-8},uf=function(e){(e=e||{}).gravity="number"==typeof e.gravity?e.gravity:-1,e.theta="number"==typeof e.theta?e.theta:.8;var t=zd.random(1984),n=af,r=sf,i=hf,o=e.gravity,a=[],s=new r,c=e.theta,l=[],h=0,u=function(){var e=l[h];return e?(e.quad0=null,e.quad4=null,e.quad1=null,e.quad5=null,e.quad2=null,e.quad6=null,e.quad3=null,e.quad7=null,e.body=null,e.mass=e.massX=e.massY=e.massZ=0,e.left=e.right=e.top=e.bottom=e.front=e.back=0):(e=new n,l[h]=e),++h,e},p=u(),d=function(e){for(s.reset(),s.push(p,e);!s.isEmpty();){var n=s.pop(),r=n.node,o=n.body;if(r.body){var a=r.body;if(r.body=null,i(a.pos,o.pos)){var c=3;do{var l=t.nextDouble(),h=(r.right-r.left)*l,d=(r.bottom-r.top)*l,f=(r.front-r.back)*l;a.pos.x=r.left+h,a.pos.y=r.top+d,a.pos.z=r.back+f,c-=1}while(c>0&&i(a.pos,o.pos));if(0===c&&i(a.pos,o.pos))return}s.push(r,a),s.push(r,o)}else{var m=o.pos.x,g=o.pos.y,v=o.pos.z;r.mass+=o.mass,r.massX+=o.mass*m,r.massY+=o.mass*g,r.massZ+=o.mass*v;var y=0,x=r.left,b=(r.right+x)/2,w=r.top,_=(r.bottom+w)/2,M=r.back,E=(r.front+M)/2;if(m>b){y+=1;var S=x;x=b,b+=b-S}if(g>_){y+=2;var T=w;w=_,_+=_-T}if(v>E){y+=4;var A=M;E=(M=E)+(M-A)}var L=pf(r,y);L?s.push(L,o):((L=u()).left=x,L.top=w,L.right=b,L.bottom=_,L.back=M,L.front=E,L.body=o,df(r,y,L))}}};return{insertBodies:function(e){var t,n=Number.MAX_VALUE,r=Number.MAX_VALUE,i=Number.MAX_VALUE,o=Number.MIN_VALUE,a=Number.MIN_VALUE,s=Number.MIN_VALUE,c=e.length;for(t=c;t--;){var l=e[t].pos,f=l.x,m=l.y,g=l.z;f<n&&(n=f),f>o&&(o=f),m<r&&(r=m),m>a&&(a=m),g<i&&(i=g),g>s&&(s=g)}var v=Math.max(o-n,Math.max(a-r,s-i));for(o=n+v,a=r+v,s=i+v,h=0,(p=u()).left=n,p.right=o,p.top=r,p.bottom=a,p.back=i,p.front=s,(t=c-1)>0&&(p.body=e[t]);t--;)d(e[t])},updateBodyForce:function(e){var n,r,i,s,l,h=a,u=0,d=0,f=0,m=1,g=0,v=1;for(h[0]=p;m;){var y=h[g],x=y.body;m-=1,g+=1;var b=x!==e;x&&b?(r=x.pos.x-e.pos.x,i=x.pos.y-e.pos.y,s=x.pos.z-e.pos.z,0===(l=Math.sqrt(r*r+i*i+s*s))&&(r=(t.nextDouble()-.5)/50,i=(t.nextDouble()-.5)/50,s=(t.nextDouble()-.5)/50,l=Math.sqrt(r*r+i*i+s*s)),u+=(n=o*x.mass*e.mass/(l*l*l))*r,d+=n*i,f+=n*s):b&&(r=y.massX/y.mass-e.pos.x,i=y.massY/y.mass-e.pos.y,s=y.massZ/y.mass-e.pos.z,0===(l=Math.sqrt(r*r+i*i+s*s))&&(r=(t.nextDouble()-.5)/50,i=(t.nextDouble()-.5)/50,s=(t.nextDouble()-.5)/50,l=Math.sqrt(r*r+i*i+s*s)),(y.right-y.left)/l<c?(u+=(n=o*y.mass*e.mass/(l*l*l))*r,d+=n*i,f+=n*s):(y.quad0&&(h[v]=y.quad0,m+=1,v+=1),y.quad1&&(h[v]=y.quad1,m+=1,v+=1),y.quad2&&(h[v]=y.quad2,m+=1,v+=1),y.quad3&&(h[v]=y.quad3,m+=1,v+=1),y.quad4&&(h[v]=y.quad4,m+=1,v+=1),y.quad5&&(h[v]=y.quad5,m+=1,v+=1),y.quad6&&(h[v]=y.quad6,m+=1,v+=1),y.quad7&&(h[v]=y.quad7,m+=1,v+=1)))}e.force.x+=u,e.force.y+=d,e.force.z+=f},options:function(e){return e?("number"==typeof e.gravity&&(o=e.gravity),"number"==typeof e.theta&&(c=e.theta),this):{gravity:o,theta:c}}}};function pf(e,t){return 0===t?e.quad0:1===t?e.quad1:2===t?e.quad2:3===t?e.quad3:4===t?e.quad4:5===t?e.quad5:6===t?e.quad6:7===t?e.quad7:null}function df(e,t,n){0===t?e.quad0=n:1===t?e.quad1=n:2===t?e.quad2=n:3===t?e.quad3=n:4===t?e.quad4=n:5===t?e.quad5=n:6===t?e.quad6=n:7===t&&(e.quad7=n)}var ff=function(e,t){var n=zd.random(42),r={x1:0,y1:0,z1:0,x2:0,y2:0,z2:0};return{box:r,update:function(){var t=e.length;if(0===t)return;var n=Number.MAX_VALUE,i=Number.MAX_VALUE,o=Number.MAX_VALUE,a=Number.MIN_VALUE,s=Number.MIN_VALUE,c=Number.MIN_VALUE;for(;t--;){var l=e[t];l.isPinned?(l.pos.x=l.prevPos.x,l.pos.y=l.prevPos.y,l.pos.z=l.prevPos.z):(l.prevPos.x=l.pos.x,l.prevPos.y=l.pos.y,l.prevPos.z=l.pos.z),l.pos.x<n&&(n=l.pos.x),l.pos.x>a&&(a=l.pos.x),l.pos.y<i&&(i=l.pos.y),l.pos.y>s&&(s=l.pos.y),l.pos.z<o&&(o=l.pos.z),l.pos.z>c&&(c=l.pos.z)}r.x1=n,r.x2=a,r.y1=i,r.y2=s,r.z1=o,r.z2=c},reset:function(){r.x1=r.y1=0,r.x2=r.y2=0,r.z1=r.z2=0},getBestNewPosition:function(e){var i=r,o=0,a=0,s=0;if(e.length){for(var c=0;c<e.length;++c)o+=e[c].pos.x,a+=e[c].pos.y,s+=e[c].pos.z;o/=e.length,a/=e.length,s/=e.length}else o=(i.x1+i.x2)/2,a=(i.y1+i.y2)/2,s=(i.z1+i.z2)/2;var l=t.springLength;return{x:o+n.next(l)-l/2,y:a+n.next(l)-l/2,z:s+n.next(l)-l/2}}}},mf=function(e){var t={update:function(t){t.force.x-=e.dragCoeff*t.velocity.x,t.force.y-=e.dragCoeff*t.velocity.y,t.force.z-=e.dragCoeff*t.velocity.z}};return Od(e=Nd(e,{dragCoeff:.02}),t,["dragCoeff"]),t},gf=function(e){var t=Nd,n=zd.random(42),r={update:function(t){var r=t.from,i=t.to,o=t.length<0?e.springLength:t.length,a=i.pos.x-r.pos.x,s=i.pos.y-r.pos.y,c=i.pos.z-r.pos.z,l=Math.sqrt(a*a+s*s+c*c);0===l&&(a=(n.nextDouble()-.5)/50,s=(n.nextDouble()-.5)/50,c=(n.nextDouble()-.5)/50,l=Math.sqrt(a*a+s*s+c*c));var h=l-o,u=(!t.coeff||t.coeff<0?e.springCoeff:t.coeff)*h/l*t.weight;r.force.x+=u*a,r.force.y+=u*s,r.force.z+=u*c,i.force.x-=u*a,i.force.y-=u*s,i.force.z-=u*c}};return Od(e=t(e,{springCoeff:2e-4,springLength:80}),r,["springCoeff","springLength"]),r},vf=function(e){return new Zd.Body3d(e)},yf=function(e,t){var n,r=0,i=0,o=0,a=e.length;for(n=0;n<a;++n){var s=e[n],c=t*t/s.mass;s.pos.x=2*s.pos.x-s.prevPos.x+s.force.x*c,s.pos.y=2*s.pos.y-s.prevPos.y+s.force.y*c,s.pos.z=2*s.pos.z-s.prevPos.z+s.force.z*c,r+=Math.abs(s.pos.x-s.prevPos.x),i+=Math.abs(s.pos.y-s.prevPos.y),o+=Math.abs(s.pos.z-s.prevPos.z)}return(r*r+i*i+o*o)/e.length};var xf=function(e,t){var n,r=0,i=0,o=0,a=0,s=0,c=0,l=e.length;for(n=0;n<l;++n){var h=e[n],u=t/h.mass;h.velocity.x+=u*h.force.x,h.velocity.y+=u*h.force.y,h.velocity.z+=u*h.force.z;var p=h.velocity.x,d=h.velocity.y,f=h.velocity.z,m=Math.sqrt(p*p+d*d+f*f);m>1&&(h.velocity.x=p/m,h.velocity.y=d/m,h.velocity.z=f/m),r=t*h.velocity.x,o=t*h.velocity.y,s=t*h.velocity.z,h.pos.x+=r,h.pos.y+=o,h.pos.z+=s,i+=Math.abs(r),a+=Math.abs(o),c+=Math.abs(s)}return(i*i+a*a+c*c)/e.length};var bf=wf;function wf(e,t){return t=Nd(t,{createQuadTree:uf,createBounds:ff,createDragForce:mf,createSpringForce:gf,integrator:_f(t),createBody:vf}),wf.get2dLayout(e,t)}function _f(e){return e&&"verlet"===e.integrator?yf:xf}function Mf(e,t,n){var r,i,o,a,s;function c(){var l=Date.now()-a;l<t&&l>=0?r=setTimeout(c,t-l):(r=null,n||(s=e.apply(o,i),o=i=null))}null==t&&(t=100);var l=function(){o=this,i=arguments,a=Date.now();var l=n&&!r;return r||(r=setTimeout(c,t)),l&&(s=e.apply(o,i),o=i=null),s};return l.clear=function(){r&&(clearTimeout(r),r=null)},l.flush=function(){r&&(s=e.apply(o,i),o=i=null,clearTimeout(r),r=null)},l}wf.get2dLayout=nf,Mf.debounce=Mf;var Ef=Mf;function Sf(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(!(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)))return;var n=[],r=!0,i=!1,o=void 0;try{for(var a,s=e[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw o}}return n}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}var Tf=function e(t,n){var r=n.default,i=void 0===r?null:r,o=n.triggerUpdate,a=void 0===o||o,s=n.onChange,c=void 0===s?function(e,t){}:s;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.name=t,this.defaultVal=i,this.triggerUpdate=a,this.onChange=c};function Af(e){var t=e.stateInit,n=void 0===t?function(){return{}}:t,r=e.props,i=void 0===r?{}:r,o=e.methods,a=void 0===o?{}:o,s=e.aliases,c=void 0===s?{}:s,l=e.init,h=void 0===l?function(){}:l,u=e.update,p=void 0===u?function(){}:u,d=Object.keys(i).map((function(e){return new Tf(e,i[e])}));return function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=Object.assign({},n instanceof Function?n(e):n,{initialised:!1}),r={};function i(t){return o(t,e),s(),i}var o=function(e,n){h.call(i,e,t,n),t.initialised=!0},s=Ef((function(){t.initialised&&(p.call(i,t,r),r={})}),1);return d.forEach((function(e){i[e.name]=function(e){var n=e.name,o=e.triggerUpdate,a=void 0!==o&&o,c=e.onChange,l=void 0===c?function(e,t){}:c,h=e.defaultVal,u=void 0===h?null:h;return function(e){var o=t[n];if(!arguments.length)return o;var c=void 0===e?u:e;return t[n]=c,l.call(i,c,t,o),!r.hasOwnProperty(n)&&(r[n]=o),a&&s(),i}}(e)})),Object.keys(a).forEach((function(e){i[e]=function(){for(var n,r=arguments.length,o=new Array(r),s=0;s<r;s++)o[s]=arguments[s];return(n=a[e]).call.apply(n,[i,t].concat(o))}})),Object.entries(c).forEach((function(e){var t=Sf(e,2),n=t[0],r=t[1];return i[n]=i[r]})),i.resetProps=function(){return d.forEach((function(e){i[e.name](e.defaultVal)})),i},i.resetProps(),t._rerender=s,i}}var Lf=Id((function(e,t){e.exports=function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){var r,i,o;i=[e,t],void 0!==(o="function"==typeof(r=function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return e instanceof Function?e:"string"==typeof e?function(t){return t[e]}:function(t){return e}},e.exports=t.default})?r.apply(t,i):r)&&(e.exports=o)}])})),Pf=function(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}(Lf);Lf.accessorFn;function Cf(e,t){if(null==e)return{};var n,r,i=function(e,t){if(null==e)return{};var n,r,i={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||(i[n]=e[n]);return i}(e,t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(i[n]=e[n])}return i}function Rf(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(!(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)))return;var n=[],r=!0,i=!1,o=void 0;try{for(var a,s=e[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw o}}return n}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}function Of(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function Df(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var Nf=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],i=(t instanceof Array?t.length?t:[void 0]:[t]).map((function(e){return{keyAccessor:e,isProp:!(e instanceof Function)}})),o=e.reduce((function(e,t){var r=e,o=t;return i.forEach((function(e,t){var a,s=e.keyAccessor;if(e.isProp){var c=o,l=c[s],h=Cf(c,[s].map(Df));a=l,o=h}else a=s(o,t);t+1<i.length?(r.hasOwnProperty(a)||(r[a]={}),r=r[a]):n?(r.hasOwnProperty(a)||(r[a]=[]),r[a].push(o)):r[a]=o})),e}),{});n instanceof Function&&function e(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;r===i.length?Object.keys(t).forEach((function(e){return t[e]=n(t[e])})):Object.values(t).forEach((function(t){return e(t,r+1)}))}(o);var a=o;return r&&(a=[],function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];n.length===i.length?a.push({keys:n,vals:t}):Object.entries(t).forEach((function(t){var r=Rf(t,2),i=r[0],o=r[1];return e(o,[].concat(Of(n),[i]))}))}(o),t instanceof Array&&0===t.length&&1===a.length&&(a[0].keys=[])),a};function If(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function zf(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function kf(e,t){if(null==e)return{};var n,r,i=function(e,t){if(null==e)return{};var n,r,i={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||(i[n]=e[n]);return i}(e,t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(i[n]=e[n])}return i}function Ff(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(!(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)))return;var n=[],r=!0,i=!1,o=void 0;try{for(var a,s=e[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw o}}return n}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}function Uf(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function Bf(e,t,n){var r=n.objBindAttr,i=void 0===r?"__obj":r,o=n.dataBindAttr,a=void 0===o?"__data":o,s=n.idAccessor,c=n.purge,l=void 0!==c&&c,h=function(e){return e.hasOwnProperty(a)},u=t.filter((function(e){return!h(e)})),p=t.filter(h).map((function(e){return e[a]})),d=l?{enter:e,exit:p,update:[]}:function(e,t,n){var r={enter:[],update:[],exit:[]};if(n){var i=Nf(e,n,!1),o=Nf(t,n,!1),a=Object.assign({},i,o);Object.entries(a).forEach((function(e){var t=Ff(e,2),n=t[0],a=t[1],s=i.hasOwnProperty(n)?o.hasOwnProperty(n)?"update":"exit":"enter";r[s].push("update"===s?[i[n],o[n]]:a)}))}else{var s=new Set(e),c=new Set(t);new Set([].concat(Uf(s),Uf(c))).forEach((function(e){var t=s.has(e)?c.has(e)?"update":"exit":"enter";r[t].push("update"===t?[e,e]:e)}))}return r}(p,e,s);return d.update=d.update.map((function(e){var t=Ff(e,2),n=t[0],r=t[1];return n!==r&&(r[i]=n[i],r[i][a]=r),r})),d.exit=d.exit.concat(u.map((function(e){return If({},i,e)}))),d}function jf(e,t,n,r,i){var o=i.createObj,a=void 0===o?function(e){return{}}:o,s=i.updateObj,c=void 0===s?function(e,t){}:s,l=i.exitObj,h=void 0===l?function(e){}:l,u=i.objBindAttr,p=void 0===u?"__obj":u,d=i.dataBindAttr,f=void 0===d?"__data":d,m=kf(i,["createObj","updateObj","exitObj","objBindAttr","dataBindAttr"]),g=Bf(e,t,function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?zf(n,!0).forEach((function(t){If(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):zf(n).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}({objBindAttr:p,dataBindAttr:f},m)),v=g.enter,y=g.update;g.exit.forEach((function(e){var t=e[p];delete e[p],h(t),r(t)}));var x=function(e){var t=[];return e.forEach((function(e){var n=a(e);n&&(n[f]=e,e[p]=n,t.push(n))})),t}(v);!function(e){e.forEach((function(e){var t=e[p];t&&(t[f]=e,c(t,e))}))}([].concat(Uf(v),Uf(y))),x.forEach(n)}function Hf(e,t){switch(arguments.length){case 0:break;case 1:this.range(e);break;default:this.range(t).domain(e)}return this}const Gf=Symbol("implicit");var Vf=function(e){for(var t=e.length/6|0,n=new Array(t),r=0;r<t;)n[r]="#"+e.slice(6*r,6*++r);return n}("a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"),Wf=Id((function(e){!function(t){var n=/^\s+/,r=/\s+$/,i=0,o=t.round,a=t.min,s=t.max,c=t.random;function l(e,c){if(c=c||{},(e=e||"")instanceof l)return e;if(!(this instanceof l))return new l(e,c);var h=function(e){var i={r:0,g:0,b:0},o=1,c=null,l=null,h=null,u=!1,p=!1;"string"==typeof e&&(e=function(e){e=e.replace(n,"").replace(r,"").toLowerCase();var t,i=!1;if(A[e])e=A[e],i=!0;else if("transparent"==e)return{r:0,g:0,b:0,a:0,format:"name"};if(t=B.rgb.exec(e))return{r:t[1],g:t[2],b:t[3]};if(t=B.rgba.exec(e))return{r:t[1],g:t[2],b:t[3],a:t[4]};if(t=B.hsl.exec(e))return{h:t[1],s:t[2],l:t[3]};if(t=B.hsla.exec(e))return{h:t[1],s:t[2],l:t[3],a:t[4]};if(t=B.hsv.exec(e))return{h:t[1],s:t[2],v:t[3]};if(t=B.hsva.exec(e))return{h:t[1],s:t[2],v:t[3],a:t[4]};if(t=B.hex8.exec(e))return{r:O(t[1]),g:O(t[2]),b:O(t[3]),a:z(t[4]),format:i?"name":"hex8"};if(t=B.hex6.exec(e))return{r:O(t[1]),g:O(t[2]),b:O(t[3]),format:i?"name":"hex"};if(t=B.hex4.exec(e))return{r:O(t[1]+""+t[1]),g:O(t[2]+""+t[2]),b:O(t[3]+""+t[3]),a:z(t[4]+""+t[4]),format:i?"name":"hex8"};if(t=B.hex3.exec(e))return{r:O(t[1]+""+t[1]),g:O(t[2]+""+t[2]),b:O(t[3]+""+t[3]),format:i?"name":"hex"};return!1}(e));"object"==typeof e&&(j(e.r)&&j(e.g)&&j(e.b)?(d=e.r,f=e.g,m=e.b,i={r:255*C(d,255),g:255*C(f,255),b:255*C(m,255)},u=!0,p="%"===String(e.r).substr(-1)?"prgb":"rgb"):j(e.h)&&j(e.s)&&j(e.v)?(c=N(e.s),l=N(e.v),i=function(e,n,r){e=6*C(e,360),n=C(n,100),r=C(r,100);var i=t.floor(e),o=e-i,a=r*(1-n),s=r*(1-o*n),c=r*(1-(1-o)*n),l=i%6;return{r:255*[r,s,a,a,c,r][l],g:255*[c,r,r,s,a,a][l],b:255*[a,a,c,r,r,s][l]}}(e.h,c,l),u=!0,p="hsv"):j(e.h)&&j(e.s)&&j(e.l)&&(c=N(e.s),h=N(e.l),i=function(e,t,n){var r,i,o;function a(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}if(e=C(e,360),t=C(t,100),n=C(n,100),0===t)r=i=o=n;else{var s=n<.5?n*(1+t):n+t-n*t,c=2*n-s;r=a(c,s,e+1/3),i=a(c,s,e),o=a(c,s,e-1/3)}return{r:255*r,g:255*i,b:255*o}}(e.h,c,h),u=!0,p="hsl"),e.hasOwnProperty("a")&&(o=e.a));var d,f,m;return o=P(o),{ok:u,format:e.format||p,r:a(255,s(i.r,0)),g:a(255,s(i.g,0)),b:a(255,s(i.b,0)),a:o}}(e);this._originalInput=e,this._r=h.r,this._g=h.g,this._b=h.b,this._a=h.a,this._roundA=o(100*this._a)/100,this._format=c.format||h.format,this._gradientType=c.gradientType,this._r<1&&(this._r=o(this._r)),this._g<1&&(this._g=o(this._g)),this._b<1&&(this._b=o(this._b)),this._ok=h.ok,this._tc_id=i++}function h(e,t,n){e=C(e,255),t=C(t,255),n=C(n,255);var r,i,o=s(e,t,n),c=a(e,t,n),l=(o+c)/2;if(o==c)r=i=0;else{var h=o-c;switch(i=l>.5?h/(2-o-c):h/(o+c),o){case e:r=(t-n)/h+(t<n?6:0);break;case t:r=(n-e)/h+2;break;case n:r=(e-t)/h+4}r/=6}return{h:r,s:i,l:l}}function u(e,t,n){e=C(e,255),t=C(t,255),n=C(n,255);var r,i,o=s(e,t,n),c=a(e,t,n),l=o,h=o-c;if(i=0===o?0:h/o,o==c)r=0;else{switch(o){case e:r=(t-n)/h+(t<n?6:0);break;case t:r=(n-e)/h+2;break;case n:r=(e-t)/h+4}r/=6}return{h:r,s:i,v:l}}function p(e,t,n,r){var i=[D(o(e).toString(16)),D(o(t).toString(16)),D(o(n).toString(16))];return r&&i[0].charAt(0)==i[0].charAt(1)&&i[1].charAt(0)==i[1].charAt(1)&&i[2].charAt(0)==i[2].charAt(1)?i[0].charAt(0)+i[1].charAt(0)+i[2].charAt(0):i.join("")}function d(e,t,n,r){return[D(I(r)),D(o(e).toString(16)),D(o(t).toString(16)),D(o(n).toString(16))].join("")}function f(e,t){t=0===t?0:t||10;var n=l(e).toHsl();return n.s-=t/100,n.s=R(n.s),l(n)}function m(e,t){t=0===t?0:t||10;var n=l(e).toHsl();return n.s+=t/100,n.s=R(n.s),l(n)}function g(e){return l(e).desaturate(100)}function v(e,t){t=0===t?0:t||10;var n=l(e).toHsl();return n.l+=t/100,n.l=R(n.l),l(n)}function y(e,t){t=0===t?0:t||10;var n=l(e).toRgb();return n.r=s(0,a(255,n.r-o(-t/100*255))),n.g=s(0,a(255,n.g-o(-t/100*255))),n.b=s(0,a(255,n.b-o(-t/100*255))),l(n)}function x(e,t){t=0===t?0:t||10;var n=l(e).toHsl();return n.l-=t/100,n.l=R(n.l),l(n)}function b(e,t){var n=l(e).toHsl(),r=(n.h+t)%360;return n.h=r<0?360+r:r,l(n)}function w(e){var t=l(e).toHsl();return t.h=(t.h+180)%360,l(t)}function _(e){var t=l(e).toHsl(),n=t.h;return[l(e),l({h:(n+120)%360,s:t.s,l:t.l}),l({h:(n+240)%360,s:t.s,l:t.l})]}function M(e){var t=l(e).toHsl(),n=t.h;return[l(e),l({h:(n+90)%360,s:t.s,l:t.l}),l({h:(n+180)%360,s:t.s,l:t.l}),l({h:(n+270)%360,s:t.s,l:t.l})]}function E(e){var t=l(e).toHsl(),n=t.h;return[l(e),l({h:(n+72)%360,s:t.s,l:t.l}),l({h:(n+216)%360,s:t.s,l:t.l})]}function S(e,t,n){t=t||6,n=n||30;var r=l(e).toHsl(),i=360/n,o=[l(e)];for(r.h=(r.h-(i*t>>1)+720)%360;--t;)r.h=(r.h+i)%360,o.push(l(r));return o}function T(e,t){t=t||6;for(var n=l(e).toHsv(),r=n.h,i=n.s,o=n.v,a=[],s=1/t;t--;)a.push(l({h:r,s:i,v:o})),o=(o+s)%1;return a}l.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var e=this.toRgb();return(299*e.r+587*e.g+114*e.b)/1e3},getLuminance:function(){var e,n,r,i=this.toRgb();return e=i.r/255,n=i.g/255,r=i.b/255,.2126*(e<=.03928?e/12.92:t.pow((e+.055)/1.055,2.4))+.7152*(n<=.03928?n/12.92:t.pow((n+.055)/1.055,2.4))+.0722*(r<=.03928?r/12.92:t.pow((r+.055)/1.055,2.4))},setAlpha:function(e){return this._a=P(e),this._roundA=o(100*this._a)/100,this},toHsv:function(){var e=u(this._r,this._g,this._b);return{h:360*e.h,s:e.s,v:e.v,a:this._a}},toHsvString:function(){var e=u(this._r,this._g,this._b),t=o(360*e.h),n=o(100*e.s),r=o(100*e.v);return 1==this._a?"hsv("+t+", "+n+"%, "+r+"%)":"hsva("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHsl:function(){var e=h(this._r,this._g,this._b);return{h:360*e.h,s:e.s,l:e.l,a:this._a}},toHslString:function(){var e=h(this._r,this._g,this._b),t=o(360*e.h),n=o(100*e.s),r=o(100*e.l);return 1==this._a?"hsl("+t+", "+n+"%, "+r+"%)":"hsla("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHex:function(e){return p(this._r,this._g,this._b,e)},toHexString:function(e){return"#"+this.toHex(e)},toHex8:function(e){return function(e,t,n,r,i){var a=[D(o(e).toString(16)),D(o(t).toString(16)),D(o(n).toString(16)),D(I(r))];if(i&&a[0].charAt(0)==a[0].charAt(1)&&a[1].charAt(0)==a[1].charAt(1)&&a[2].charAt(0)==a[2].charAt(1)&&a[3].charAt(0)==a[3].charAt(1))return a[0].charAt(0)+a[1].charAt(0)+a[2].charAt(0)+a[3].charAt(0);return a.join("")}(this._r,this._g,this._b,this._a,e)},toHex8String:function(e){return"#"+this.toHex8(e)},toRgb:function(){return{r:o(this._r),g:o(this._g),b:o(this._b),a:this._a}},toRgbString:function(){return 1==this._a?"rgb("+o(this._r)+", "+o(this._g)+", "+o(this._b)+")":"rgba("+o(this._r)+", "+o(this._g)+", "+o(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:o(100*C(this._r,255))+"%",g:o(100*C(this._g,255))+"%",b:o(100*C(this._b,255))+"%",a:this._a}},toPercentageRgbString:function(){return 1==this._a?"rgb("+o(100*C(this._r,255))+"%, "+o(100*C(this._g,255))+"%, "+o(100*C(this._b,255))+"%)":"rgba("+o(100*C(this._r,255))+"%, "+o(100*C(this._g,255))+"%, "+o(100*C(this._b,255))+"%, "+this._roundA+")"},toName:function(){return 0===this._a?"transparent":!(this._a<1)&&(L[p(this._r,this._g,this._b,!0)]||!1)},toFilter:function(e){var t="#"+d(this._r,this._g,this._b,this._a),n=t,r=this._gradientType?"GradientType = 1, ":"";if(e){var i=l(e);n="#"+d(i._r,i._g,i._b,i._a)}return"progid:DXImageTransform.Microsoft.gradient("+r+"startColorstr="+t+",endColorstr="+n+")"},toString:function(e){var t=!!e;e=e||this._format;var n=!1,r=this._a<1&&this._a>=0;return t||!r||"hex"!==e&&"hex6"!==e&&"hex3"!==e&&"hex4"!==e&&"hex8"!==e&&"name"!==e?("rgb"===e&&(n=this.toRgbString()),"prgb"===e&&(n=this.toPercentageRgbString()),"hex"!==e&&"hex6"!==e||(n=this.toHexString()),"hex3"===e&&(n=this.toHexString(!0)),"hex4"===e&&(n=this.toHex8String(!0)),"hex8"===e&&(n=this.toHex8String()),"name"===e&&(n=this.toName()),"hsl"===e&&(n=this.toHslString()),"hsv"===e&&(n=this.toHsvString()),n||this.toHexString()):"name"===e&&0===this._a?this.toName():this.toRgbString()},clone:function(){return l(this.toString())},_applyModification:function(e,t){var n=e.apply(null,[this].concat([].slice.call(t)));return this._r=n._r,this._g=n._g,this._b=n._b,this.setAlpha(n._a),this},lighten:function(){return this._applyModification(v,arguments)},brighten:function(){return this._applyModification(y,arguments)},darken:function(){return this._applyModification(x,arguments)},desaturate:function(){return this._applyModification(f,arguments)},saturate:function(){return this._applyModification(m,arguments)},greyscale:function(){return this._applyModification(g,arguments)},spin:function(){return this._applyModification(b,arguments)},_applyCombination:function(e,t){return e.apply(null,[this].concat([].slice.call(t)))},analogous:function(){return this._applyCombination(S,arguments)},complement:function(){return this._applyCombination(w,arguments)},monochromatic:function(){return this._applyCombination(T,arguments)},splitcomplement:function(){return this._applyCombination(E,arguments)},triad:function(){return this._applyCombination(_,arguments)},tetrad:function(){return this._applyCombination(M,arguments)}},l.fromRatio=function(e,t){if("object"==typeof e){var n={};for(var r in e)e.hasOwnProperty(r)&&(n[r]="a"===r?e[r]:N(e[r]));e=n}return l(e,t)},l.equals=function(e,t){return!(!e||!t)&&l(e).toRgbString()==l(t).toRgbString()},l.random=function(){return l.fromRatio({r:c(),g:c(),b:c()})},l.mix=function(e,t,n){n=0===n?0:n||50;var r=l(e).toRgb(),i=l(t).toRgb(),o=n/100;return l({r:(i.r-r.r)*o+r.r,g:(i.g-r.g)*o+r.g,b:(i.b-r.b)*o+r.b,a:(i.a-r.a)*o+r.a})},
// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)
// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)
l.readability=function(e,n){var r=l(e),i=l(n);return(t.max(r.getLuminance(),i.getLuminance())+.05)/(t.min(r.getLuminance(),i.getLuminance())+.05)},l.isReadable=function(e,t,n){var r,i,o=l.readability(e,t);switch(i=!1,(r=function(e){var t,n;t=((e=e||{level:"AA",size:"small"}).level||"AA").toUpperCase(),n=(e.size||"small").toLowerCase(),"AA"!==t&&"AAA"!==t&&(t="AA");"small"!==n&&"large"!==n&&(n="small");return{level:t,size:n}}(n)).level+r.size){case"AAsmall":case"AAAlarge":i=o>=4.5;break;case"AAlarge":i=o>=3;break;case"AAAsmall":i=o>=7}return i},l.mostReadable=function(e,t,n){var r,i,o,a,s=null,c=0;i=(n=n||{}).includeFallbackColors,o=n.level,a=n.size;for(var h=0;h<t.length;h++)(r=l.readability(e,t[h]))>c&&(c=r,s=l(t[h]));return l.isReadable(e,s,{level:o,size:a})||!i?s:(n.includeFallbackColors=!1,l.mostReadable(e,["#fff","#000"],n))};var A=l.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"},L=l.hexNames=function(e){var t={};for(var n in e)e.hasOwnProperty(n)&&(t[e[n]]=n);return t}(A);function P(e){return e=parseFloat(e),(isNaN(e)||e<0||e>1)&&(e=1),e}function C(e,n){(function(e){return"string"==typeof e&&-1!=e.indexOf(".")&&1===parseFloat(e)})(e)&&(e="100%");var r=function(e){return"string"==typeof e&&-1!=e.indexOf("%")}(e);return e=a(n,s(0,parseFloat(e))),r&&(e=parseInt(e*n,10)/100),t.abs(e-n)<1e-6?1:e%n/parseFloat(n)}function R(e){return a(1,s(0,e))}function O(e){return parseInt(e,16)}function D(e){return 1==e.length?"0"+e:""+e}function N(e){return e<=1&&(e=100*e+"%"),e}function I(e){return t.round(255*parseFloat(e)).toString(16)}function z(e){return O(e)/255}var k,F,U,B=(F="[\\s|\\(]+("+(k="(?:[-\\+]?\\d*\\.\\d+%?)|(?:[-\\+]?\\d+%?)")+")[,|\\s]+("+k+")[,|\\s]+("+k+")\\s*\\)?",U="[\\s|\\(]+("+k+")[,|\\s]+("+k+")[,|\\s]+("+k+")[,|\\s]+("+k+")\\s*\\)?",{CSS_UNIT:new RegExp(k),rgb:new RegExp("rgb"+F),rgba:new RegExp("rgba"+U),hsl:new RegExp("hsl"+F),hsla:new RegExp("hsla"+U),hsv:new RegExp("hsv"+F),hsva:new RegExp("hsva"+U),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex4:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex8:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/});function j(e){return!!B.CSS_UNIT.exec(e)}e.exports?e.exports=l:window.tinycolor=l}(Math)}));function qf(e){return(qf="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function Xf(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function Yf(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function Zf(e){return(Zf=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function Jf(e,t){return(Jf=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function Qf(e,t,n){return(Qf=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(e){return!1}}()?Reflect.construct:function(e,t,n){var r=[null];r.push.apply(r,t);var i=new(Function.bind.apply(e,r));return n&&Jf(i,n.prototype),i}).apply(null,arguments)}function Kf(e,t){if(null==e)return{};var n,r,i=function(e,t){if(null==e)return{};var n,r,i={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||(i[n]=e[n]);return i}(e,t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(i[n]=e[n])}return i}function $f(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function em(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}var tm=function e(t){t.geometry&&t.geometry.dispose(),t.material&&function e(t){t instanceof Array?t.forEach(e):(t.map&&t.map.dispose(),t.dispose())}(t.material),t.texture&&t.texture.dispose(),t.children&&t.children.forEach(e)},nm=function(e){for(;e.children.length;){var t=e.children[0];e.remove(t),tm(t)}};function rm(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.objFilter,i=void 0===r?function(){return!0}:r,o=Kf(n,["objFilter"]);return jf(e,t.children.filter(i),(function(e){return t.add(e)}),(function(e){t.remove(e),nm(e)}),function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?Yf(Object(n),!0).forEach((function(t){Xf(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):Yf(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}({objBindAttr:"__threeObj"},o))}var im=function(e){return isNaN(e)?parseInt(Wf(e).toHex(),16):e},om=function(e){return isNaN(e)?Wf(e).getAlpha():1},am=function e(){var t=new Map,n=[],r=[],i=Gf;function o(e){var o=e+"",a=t.get(o);if(!a){if(i!==Gf)return i;t.set(o,a=n.push(e))}return r[(a-1)%r.length]}return o.domain=function(e){if(!arguments.length)return n.slice();n=[],t=new Map;for(const r of e){const e=r+"";t.has(e)||t.set(e,n.push(r))}return o},o.range=function(e){return arguments.length?(r=Array.from(e),o):r.slice()},o.unknown=function(e){return arguments.length?(i=e,o):i},o.copy=function(){return e(n,r).unknown(i)},Hf.apply(o,arguments),o}(Vf);function sm(e,t,n){t&&"string"==typeof n&&e.filter((function(e){return!e[n]})).forEach((function(e){e[n]=am(t(e))}))}var cm=window.THREE?window.THREE:{Group:Ta,Mesh:$r,MeshLambertMaterial:Qc,Color:cr,BufferGeometry:Ir,BufferAttribute:gr,Matrix4:$t,Vector3:zt,SphereBufferGeometry:Lc,CylinderBufferGeometry:Fc,TubeBufferGeometry:Ws,ConeBufferGeometry:Bc,Line:ms,LineBasicMaterial:ls,QuadraticBezierCurve3:Wl,CubicBezierCurve3:jl},lm={graph:Sd,forcelayout:nf,forcelayout3d:bf},hm=(new cm.BufferGeometry).setAttribute?"setAttribute":"addAttribute";var um,pm=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:Object,n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=function(t){function r(){var t,i;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,r);for(var o=arguments.length,a=new Array(o),s=0;s<o;s++)a[s]=arguments[s];return(i=function(e,t){return!t||"object"!=typeof t&&"function"!=typeof t?$f(e):t}(this,(t=Zf(r)).call.apply(t,[this].concat(a)))).__kapsuleInstance=e().apply(void 0,[].concat(em(n?[$f(i)]:[]),a)),i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Jf(e,t)}(r,t),r}(t);return Object.keys(e()).forEach((function(e){return r.prototype[e]=function(){var t,n=(t=this.__kapsuleInstance)[e].apply(t,arguments);return n===this.__kapsuleInstance?this:n}})),r}(Af({props:{jsonUrl:{onChange:function(e,t){var n=this;e&&!t.fetchingJson&&(t.fetchingJson=!0,t.onLoading(),fetch(e).then((function(e){return e.json()})).then((function(e){t.fetchingJson=!1,t.onFinishLoading(e),n.graphData(e)})))},triggerUpdate:!1},graphData:{default:{nodes:[],links:[]},onChange:function(e,t){(e.nodes.length||e.links.length)&&console.info("force-graph loading",e.nodes.length+" nodes",e.links.length+" links"),t.engineRunning=!1}},numDimensions:{default:3,onChange:function(e,t){var n=t.d3ForceLayout.force("charge");function r(e,t){e.forEach((function(e){delete e[t],delete e["v".concat(t)]}))}n&&n.strength(e>2?-60:-30),e<3&&r(t.graphData.nodes,"z"),e<2&&r(t.graphData.nodes,"y")}},dagMode:{onChange:function(e,t){!e&&"d3"===t.forceEngine&&(t.graphData.nodes||[]).forEach((function(e){return e.fx=e.fy=e.fz=void 0}))}},dagLevelDistance:{},nodeRelSize:{default:4},nodeId:{default:"id"},nodeVal:{default:"val"},nodeResolution:{default:8},nodeColor:{default:"color"},nodeAutoColorBy:{},nodeOpacity:{default:.75},nodeVisibility:{default:!0},nodeThreeObject:{},nodeThreeObjectExtend:{default:!1},linkSource:{default:"source"},linkTarget:{default:"target"},linkVisibility:{default:!0},linkColor:{default:"color"},linkAutoColorBy:{},linkOpacity:{default:.2},linkWidth:{},linkResolution:{default:6},linkCurvature:{default:0,triggerUpdate:!1},linkCurveRotation:{default:0,triggerUpdate:!1},linkMaterial:{},linkThreeObject:{},linkThreeObjectExtend:{default:!1},linkPositionUpdate:{triggerUpdate:!1},linkDirectionalArrowLength:{default:0},linkDirectionalArrowColor:{},linkDirectionalArrowRelPos:{default:.5,triggerUpdate:!1},linkDirectionalArrowResolution:{default:8},linkDirectionalParticles:{default:0},linkDirectionalParticleSpeed:{default:.01,triggerUpdate:!1},linkDirectionalParticleWidth:{default:.5},linkDirectionalParticleColor:{},linkDirectionalParticleResolution:{default:4},forceEngine:{default:"d3"},d3AlphaDecay:{default:.0228,triggerUpdate:!1,onChange:function(e,t){t.d3ForceLayout.alphaDecay(e)}},d3AlphaTarget:{default:0,triggerUpdate:!1,onChange:function(e,t){t.d3ForceLayout.alphaTarget(e)}},d3VelocityDecay:{default:.4,triggerUpdate:!1,onChange:function(e,t){t.d3ForceLayout.velocityDecay(e)}},warmupTicks:{default:0,triggerUpdate:!1},cooldownTicks:{default:1/0,triggerUpdate:!1},cooldownTime:{default:15e3,triggerUpdate:!1},onLoading:{default:function(){},triggerUpdate:!1},onFinishLoading:{default:function(){},triggerUpdate:!1},onUpdate:{default:function(){},triggerUpdate:!1},onFinishUpdate:{default:function(){},triggerUpdate:!1},onEngineTick:{default:function(){},triggerUpdate:!1},onEngineStop:{default:function(){},triggerUpdate:!1}},methods:{refresh:function(e){return e._flushObjects=!0,e._rerender(),this},d3Force:function(e,t,n){return void 0===n?e.d3ForceLayout.force(t):(e.d3ForceLayout.force(t,n),this)},d3ReheatSimulation:function(e){return e.d3ForceLayout.alpha(1),this.resetCountdown(),this},resetCountdown:function(e){return e.cntTicks=0,e.startTickTime=new Date,e.engineRunning=!0,this},tickFrame:function(e){var t,n,r,i,o="ngraph"!==e.forceEngine;return e.engineRunning&&function(){++e.cntTicks>e.cooldownTicks||new Date-e.startTickTime>e.cooldownTime?(e.engineRunning=!1,e.onEngineStop()):(e.layout[o?"tick":"step"](),e.onEngineTick());e.graphData.nodes.forEach((function(t){var n=t.__threeObj;if(n){var r=o?t:e.layout.getNodePosition(t[e.nodeId]);n.position.x=r.x,n.position.y=r.y||0,n.position.z=r.z||0}}));var t=Pf(e.linkWidth),n=Pf(e.linkCurvature),r=Pf(e.linkCurveRotation),i=Pf(e.linkThreeObjectExtend);e.graphData.links.forEach((function(a){var s=a.__lineObj;if(s){var c=o?a:e.layout.getLinkPosition(e.layout.graph.getLink(a.source,a.target).id),l=c[o?"source":"from"],h=c[o?"target":"to"];if(l.hasOwnProperty("x")&&h.hasOwnProperty("x")){!function(t){var i=o?t:e.layout.getLinkPosition(e.layout.graph.getLink(t.source,t.target).id),a=i[o?"source":"from"],s=i[o?"target":"to"];if(a.hasOwnProperty("x")&&s.hasOwnProperty("x")){var c=n(t);if(c){var l,h=new cm.Vector3(a.x,a.y||0,a.z||0),u=new cm.Vector3(s.x,s.y||0,s.z||0),p=h.distanceTo(u),d=r(t);if(p>0){var f=s.x-a.x,m=s.y-a.y||0,g=(new cm.Vector3).subVectors(u,h),v=g.clone().multiplyScalar(c).cross(0!==f||0!==m?new cm.Vector3(0,0,1):new cm.Vector3(0,1,0)).applyAxisAngle(g.normalize(),d).add((new cm.Vector3).addVectors(h,u).divideScalar(2));l=new cm.QuadraticBezierCurve3(h,v,u)}else{var y=70*c,x=-d,b=x+Math.PI/2;l=new cm.CubicBezierCurve3(h,new cm.Vector3(y*Math.cos(b),y*Math.sin(b),0).add(h),new cm.Vector3(y*Math.cos(x),y*Math.sin(x),0).add(h),u)}t.__curve=l}else t.__curve=null}}(a);var u=i(a);if(!e.linkPositionUpdate||!e.linkPositionUpdate(u?s.children[1]:s,{start:{x:l.x,y:l.y,z:l.z},end:{x:h.x,y:h.y,z:h.z}},a)||u){var p=a.__curve,d=s.children.length?s.children[0]:s;if("Line"===d.type){if(p)d.geometry.setFromPoints(p.getPoints(30));else{var f=d.geometry.getAttribute("position");f&&f.array&&6===f.array.length||d.geometry[hm]("position",f=new cm.BufferAttribute(new Float32Array(6),3)),f.array[0]=l.x,f.array[1]=l.y||0,f.array[2]=l.z||0,f.array[3]=h.x,f.array[4]=h.y||0,f.array[5]=h.z||0,f.needsUpdate=!0}d.geometry.computeBoundingSphere()}else if("Mesh"===d.type)if(p){"TubeBufferGeometry"!==d.geometry.type&&(d.position.set(0,0,0),d.rotation.set(0,0,0),d.scale.set(1,1,1));var m=Math.ceil(10*t(a))/10/2,g=new cm.TubeBufferGeometry(p,30,m,e.linkResolution,!1);d.geometry.dispose(),d.geometry=g}else{if("CylinderBufferGeometry"!==d.geometry.type){var v=Math.ceil(10*t(a))/10/2,y=new cm.CylinderBufferGeometry(v,v,1,e.linkResolution,1,!1);y.applyMatrix((new cm.Matrix4).makeTranslation(0,.5,0)),y.applyMatrix((new cm.Matrix4).makeRotationX(Math.PI/2)),d.geometry.dispose(),d.geometry=y}var x=new cm.Vector3(l.x,l.y||0,l.z||0),b=new cm.Vector3(h.x,h.y||0,h.z||0),w=x.distanceTo(b);d.position.x=x.x,d.position.y=x.y,d.position.z=x.z,d.scale.z=w,d.parent.localToWorld(b),d.lookAt(b)}}}}}))}(),t=Pf(e.linkDirectionalArrowRelPos),n=Pf(e.linkDirectionalArrowLength),r=Pf(e.nodeVal),e.graphData.links.forEach((function(i){var a=i.__arrowObj;if(a){var s=o?i:e.layout.getLinkPosition(e.layout.graph.getLink(i.source,i.target).id),c=s[o?"source":"from"],l=s[o?"target":"to"];if(c.hasOwnProperty("x")&&l.hasOwnProperty("x")){var h=Math.sqrt(Math.max(0,r(c)||1))*e.nodeRelSize,u=Math.sqrt(Math.max(0,r(l)||1))*e.nodeRelSize,p=n(i),d=t(i),f=i.__curve?function(e){return i.__curve.getPoint(e)}:function(e){var t=function(e,t,n,r){return t[e]+(n[e]-t[e])*r||0};return{x:t("x",c,l,e),y:t("y",c,l,e),z:t("z",c,l,e)}},m=i.__curve?i.__curve.getLength():Math.sqrt(["x","y","z"].map((function(e){return Math.pow((l[e]||0)-(c[e]||0),2)})).reduce((function(e,t){return e+t}),0)),g=h+p+(m-h-u-p)*d,v=f(g/m),y=f((g-p)/m);["x","y","z"].forEach((function(e){return a.position[e]=y[e]}));var x=Qf(cm.Vector3,em(["x","y","z"].map((function(e){return v[e]}))));a.parent.localToWorld(x),a.lookAt(x)}}})),i=Pf(e.linkDirectionalParticleSpeed),e.graphData.links.forEach((function(t){var n=t.__photonsObj&&t.__photonsObj.children,r=t.__singleHopPhotonsObj&&t.__singleHopPhotonsObj.children;if(r&&r.length||n&&n.length){var a=o?t:e.layout.getLinkPosition(e.layout.graph.getLink(t.source,t.target).id),s=a[o?"source":"from"],c=a[o?"target":"to"];if(s.hasOwnProperty("x")&&c.hasOwnProperty("x")){var l=i(t),h=t.__curve?function(e){return t.__curve.getPoint(e)}:function(e){var t=function(e,t,n,r){return t[e]+(n[e]-t[e])*r||0};return{x:t("x",s,c,e),y:t("y",s,c,e),z:t("z",s,c,e)}};[].concat(em(n||[]),em(r||[])).forEach((function(e,t){var r="singleHopPhotons"===e.parent.__linkThreeObjType;if(e.hasOwnProperty("__progressRatio")||(e.__progressRatio=r?0:t/n.length),e.__progressRatio+=l,e.__progressRatio>=1){if(r)return e.parent.remove(e),void nm(e);e.__progressRatio=e.__progressRatio%1}var i=e.__progressRatio,o=h(i);["x","y","z"].forEach((function(t){return e.position[t]=o[t]}))}))}}})),this},emitParticle:function(e,t){if(t){if(!t.__singleHopPhotonsObj){var n=new cm.Group;n.__linkThreeObjType="singleHopPhotons",t.__singleHopPhotonsObj=n,e.graphScene.add(n)}var r=Pf(e.linkDirectionalParticleWidth),i=Math.ceil(10*r(t))/10/2,o=e.linkDirectionalParticleResolution,a=new cm.SphereBufferGeometry(i,o,o),s=Pf(e.linkColor),c=Pf(e.linkDirectionalParticleColor)(t)||s(t)||"#f0f0f0",l=new cm.Color(im(c)),h=3*e.linkOpacity,u=new cm.MeshLambertMaterial({color:l,transparent:!0,opacity:h});t.__singleHopPhotonsObj.add(new cm.Mesh(a,u))}return this}},stateInit:function(){return{d3ForceLayout:_d().force("link",Vp()).force("charge",Md()).force("center",mp()).force("dagRadial",null).stop(),engineRunning:!1}},init:function(e,t){t.graphScene=e},update:function(e,t){var n,r,i,o,a,s=function(e){return e.some((function(e){return t.hasOwnProperty(e)}))};if(e.engineRunning=!1,e.onUpdate(),null!==e.nodeAutoColorBy&&s(["nodeAutoColorBy","graphData","nodeColor"])&&sm(e.graphData.nodes,Pf(e.nodeAutoColorBy),e.nodeColor),null!==e.linkAutoColorBy&&s(["linkAutoColorBy","graphData","linkColor"])&&sm(e.graphData.links,Pf(e.linkAutoColorBy),e.linkColor),e._flushObjects||s(["graphData","nodeThreeObject","nodeThreeObjectExtend","nodeVal","nodeColor","nodeVisibility","nodeRelSize","nodeResolution","nodeOpacity"])){var c=Pf(e.nodeThreeObject),l=Pf(e.nodeThreeObjectExtend),h=Pf(e.nodeVal),u=Pf(e.nodeColor),p=Pf(e.nodeVisibility),d={},f={},m=new Set;rm(e.graphData.nodes.filter(p),e.graphScene,{purge:e._flushObjects||s(["nodeThreeObject","nodeThreeObjectExtend"]),objFilter:function(e){return"node"===e.__graphObjType},createObj:function(t){var n,r=c(t),i=l(t);return r&&e.nodeThreeObject===r&&(r=r.clone()),r&&!i?(n=r,m.add(n)):(n=new cm.Mesh,r&&i&&n.add(r)),n.__graphObjType="node",n},updateObj:function(t,n){if(!m.has(t)){var r=h(n)||1,i=Math.cbrt(r)*e.nodeRelSize,o=e.nodeResolution;"SphereBufferGeometry"===t.geometry.type&&t.geometry.parameters.radius===i&&t.geometry.parameters.widthSegments===o||(d.hasOwnProperty(r)||(d[r]=new cm.SphereBufferGeometry(i,o,o)),t.geometry.dispose(),t.geometry=d[r]);var a=u(n),s=new cm.Color(im(a||"#ffffaa")),c=e.nodeOpacity*om(a);"MeshLambertMaterial"===t.material.type&&t.material.color.equals(s)&&t.material.opacity===c||(f.hasOwnProperty(a)||(f[a]=new cm.MeshLambertMaterial({color:s,transparent:!0,opacity:c})),t.material.dispose(),t.material=f[a])}}})}if(e._flushObjects||s(["graphData","linkThreeObject","linkThreeObjectExtend","linkMaterial","linkColor","linkWidth","linkVisibility","linkResolution","linkOpacity","linkDirectionalArrowLength","linkDirectionalArrowColor","linkDirectionalArrowResolution","linkDirectionalParticles","linkDirectionalParticleWidth","linkDirectionalParticleColor","linkDirectionalParticleResolution"])){var g=Pf(e.linkThreeObject),v=Pf(e.linkThreeObjectExtend),y=Pf(e.linkMaterial),x=Pf(e.linkVisibility),b=Pf(e.linkColor),w=Pf(e.linkWidth),_={},M={},E=e.graphData.links.filter(x),S=new Set;if(rm(E,e.graphScene,{objBindAttr:"__lineObj",purge:e._flushObjects||s(["linkThreeObject","linkThreeObjectExtend","linkWidth"]),objFilter:function(e){return"link"===e.__graphObjType},createObj:function(t){var n,r,i=g(t),o=v(t);if(i&&e.linkThreeObject===i&&(i=i.clone()),!i||o)if(!!w(t))n=new cm.Mesh;else{var a=new cm.BufferGeometry;a[hm]("position",new cm.BufferAttribute(new Float32Array(6),3)),n=new cm.Line(a)}return i?o?((r=new cm.Group).add(n),r.add(i)):(r=i,S.add(r)):r=n,r.renderOrder=10,r.__graphObjType="link",r},updateObj:function(t,n){if(!S.has(t)){var r=t.children.length?t.children[0]:t,i=Math.ceil(10*w(n))/10;if(!!i){var o=i/2,a=e.linkResolution;if("CylinderBufferGeometry"!==r.geometry.type||r.geometry.parameters.radiusTop!==o||r.geometry.parameters.radialSegments!==a){if(!M.hasOwnProperty(i)){var s=new cm.CylinderBufferGeometry(o,o,1,a,1,!1);s.applyMatrix((new cm.Matrix4).makeTranslation(0,.5,0)),s.applyMatrix((new cm.Matrix4).makeRotationX(Math.PI/2)),M[i]=s}r.geometry.dispose(),r.geometry=M[i]}}var c=y(n);if(c)r.material=c;else{var l=b(n),h=new cm.Color(im(l||"#f0f0f0")),u=e.linkOpacity*om(l);"MeshLambertMaterial"===r.material.type&&r.material.color.equals(h)&&r.material.opacity===u||(_.hasOwnProperty(l)||(_[l]=new cm.MeshLambertMaterial({color:h,transparent:u<1,opacity:u,depthWrite:u>=1})),r.material.dispose(),r.material=_[l])}}}}),e.linkDirectionalArrowLength||t.hasOwnProperty("linkDirectionalArrowLength")){var T=Pf(e.linkDirectionalArrowLength),A=Pf(e.linkDirectionalArrowColor);rm(E.filter(T),e.graphScene,{objBindAttr:"__arrowObj",objFilter:function(e){return"arrow"===e.__linkThreeObjType},createObj:function(){var e=new cm.Mesh(void 0,new cm.MeshLambertMaterial({transparent:!0}));return e.__linkThreeObjType="arrow",e},updateObj:function(t,n){var r=T(n),i=e.linkDirectionalArrowResolution;if("ConeBufferGeometry"!==t.geometry.type||t.geometry.parameters.height!==r||t.geometry.parameters.radialSegments!==i){var o=new cm.ConeBufferGeometry(.25*r,r,i);o.translate(0,r/2,0),o.rotateX(Math.PI/2),t.geometry.dispose(),t.geometry=o}t.material.color=new cm.Color(A(n)||b(n)||"#f0f0f0"),t.material.opacity=3*e.linkOpacity}})}if(e.linkDirectionalParticles||t.hasOwnProperty("linkDirectionalParticles")){var L=Pf(e.linkDirectionalParticles),P=Pf(e.linkDirectionalParticleWidth),C=Pf(e.linkDirectionalParticleColor),R={},O={};rm(E.filter(L),e.graphScene,{objBindAttr:"__photonsObj",objFilter:function(e){return"photons"===e.__linkThreeObjType},createObj:function(){var e=new cm.Group;return e.__linkThreeObjType="photons",e},updateObj:function(t,n){var r,i=Math.round(Math.abs(L(n))),o=!!t.children.length&&t.children[0],a=Math.ceil(10*P(n))/10/2,s=e.linkDirectionalParticleResolution;o&&o.geometry.parameters.radius===a&&o.geometry.parameters.widthSegments===s?r=o.geometry:(O.hasOwnProperty(a)||(O[a]=new cm.SphereBufferGeometry(a,s,s)),r=O[a],o&&o.geometry.dispose());var c,l=C(n)||b(n)||"#f0f0f0",h=new cm.Color(im(l)),u=3*e.linkOpacity;o&&o.material.color.equals(h)&&o.material.opacity===u?c=o.material:(R.hasOwnProperty(l)||(R[l]=new cm.MeshLambertMaterial({color:h,transparent:!0,opacity:u})),c=R[l],o&&o.material.dispose()),rm(em(new Array(i)).map((function(e,t){return{idx:t}})),t,{idAccessor:function(e){return e.idx},createObj:function(){return new cm.Mesh(r,c)},updateObj:function(e){e.geometry=r,e.material=c}})}})}}if(e._flushObjects=!1,s(["graphData","nodeId","linkSource","linkTarget","numDimensions","forceEngine","dagMode","dagLevelDistance"])){e.engineRunning=!1,e.graphData.links.forEach((function(t){t.source=t[e.linkSource],t.target=t[e.linkTarget]}));var D,N="ngraph"!==e.forceEngine;if(N){(D=e.d3ForceLayout).stop().alpha(1).numDimensions(e.numDimensions).nodes(e.graphData.nodes);var I=e.d3ForceLayout.force("link");I&&I.id((function(t){return t[e.nodeId]})).links(e.graphData.links);var z=e.dagMode&&(n=e.graphData,r=function(t){return t[e.nodeId]},i=n.nodes,o=n.links,a={},i.forEach((function(e){return a[r(e)]={data:e,out:[],depth:-1}})),o.forEach((function(e){var t=e.source,n=e.target,i=l(t),o=l(n);if(!a.hasOwnProperty(i))throw"Missing source node with id: ".concat(i);if(!a.hasOwnProperty(o))throw"Missing target node with id: ".concat(o);var s=a[i],c=a[o];function l(e){return"object"===qf(e)?r(e):e}s.out.push(c)})),function e(t){for(var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],i=n.length,o=0,a=t.length;o<a;o++){var s=t[o];if(-1!==n.indexOf(s)){var c=[].concat(em(n.slice(n.indexOf(s))),[s]).map((function(e){return r(e.data)}));throw"Invalid DAG structure! Found cycle in node path: ".concat(c.join(" -> "),".")}i>s.depth&&(s.depth=i,e(s.out,[].concat(em(n),[s])))}}(Object.values(a)),Object.keys(a).forEach((function(e){return a[e]=a[e].depth})),a),k=Math.max.apply(Math,em(Object.values(z||[]))),F=e.dagLevelDistance||e.graphData.nodes.length/(k||1)*2*(-1!==["radialin","radialout"].indexOf(e.dagMode)?.7:1);if(e.dagMode){var U=function(t,n){return function(r){return t?(z[r[e.nodeId]]-k/2)*F*(n?-1:1):void 0}},B=U(-1!==["lr","rl"].indexOf(e.dagMode),"rl"===e.dagMode),j=U(-1!==["td","bu"].indexOf(e.dagMode),"td"===e.dagMode),H=U(-1!==["zin","zout"].indexOf(e.dagMode),"zout"===e.dagMode);e.graphData.nodes.forEach((function(e){e.fx=B(e),e.fy=j(e),e.fz=H(e)}))}e.d3ForceLayout.force("dagRadial",-1!==["radialin","radialout"].indexOf(e.dagMode)?function(e,t,n,r){var i,o,a,s,c=Bp(.1);function l(e){for(var c=0,l=i.length;c<l;++c){var h=i[c],u=h.x-t||1e-6,p=(h.y||0)-n||1e-6,d=(h.z||0)-r||1e-6,f=Math.sqrt(u*u+p*p+d*d),m=(s[c]-f)*a[c]*e/f;h.vx+=u*m,o>1&&(h.vy+=p*m),o>2&&(h.vz+=d*m)}}function h(){if(i){var t,n=i.length;for(a=new Array(n),s=new Array(n),t=0;t<n;++t)s[t]=+e(i[t],t,i),a[t]=isNaN(s[t])?0:+c(i[t],t,i)}}return"function"!=typeof e&&(e=Bp(+e)),null==t&&(t=0),null==n&&(n=0),null==r&&(r=0),l.initialize=function(e,t){i=e,o=t,h()},l.strength=function(e){return arguments.length?(c="function"==typeof e?e:Bp(+e),h(),l):c},l.radius=function(t){return arguments.length?(e="function"==typeof t?t:Bp(+t),h(),l):e},l.x=function(e){return arguments.length?(t=+e,l):t},l.y=function(e){return arguments.length?(n=+e,l):n},l.z=function(e){return arguments.length?(r=+e,l):r},l}((function(t){var n=z[t[e.nodeId]];return("radialin"===e.dagMode?k-n:n)*F})).strength(1):null)}else{var G=lm.graph();e.graphData.nodes.forEach((function(t){G.addNode(t[e.nodeId])})),e.graphData.links.forEach((function(e){G.addLink(e.source,e.target)})),(D=lm["forcelayout"+(2===e.numDimensions?"":"3d")](G)).graph=G}for(var V=0;V<e.warmupTicks;V++)D[N?"tick":"step"]();e.layout=D,this.resetCountdown()}e.engineRunning=!0,e.onFinishUpdate()}}),(window.THREE?window.THREE:{Group:Ta}).Group,!0),dm=window.THREE||dp,fm=um=function(e,t){var n=this,r={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4};this.object=e,this.domElement=void 0!==t?t:document,this.enabled=!0,this.screen={left:0,top:0,width:0,height:0},this.rotateSpeed=1,this.zoomSpeed=1.2,this.panSpeed=.3,this.noRotate=!1,this.noZoom=!1,this.noPan=!1,this.staticMoving=!1,this.dynamicDampingFactor=.2,this.minDistance=0,this.maxDistance=1/0,this.keys=[65,83,68],this.target=new dm.Vector3;var i=new dm.Vector3,o=r.NONE,a=r.NONE,s=new dm.Vector3,c=new dm.Vector2,l=new dm.Vector2,h=new dm.Vector3,u=0,p=new dm.Vector2,d=new dm.Vector2,f=0,m=0,g=new dm.Vector2,v=new dm.Vector2;this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.up0=this.object.up.clone();var y={type:"change"},x={type:"start"},b={type:"end"};this.handleResize=function(){if(this.domElement===document)this.screen.left=0,this.screen.top=0,this.screen.width=window.innerWidth,this.screen.height=window.innerHeight;else{var e=this.domElement.getBoundingClientRect(),t=this.domElement.ownerDocument.documentElement;this.screen.left=e.left+window.pageXOffset-t.clientLeft,this.screen.top=e.top+window.pageYOffset-t.clientTop,this.screen.width=e.width,this.screen.height=e.height}},this.handleEvent=function(e){"function"==typeof this[e.type]&&this[e.type](e)};var w,_,M,E,S,T,A,L,P,C,R,O=(w=new dm.Vector2,function(e,t){return w.set((e-n.screen.left)/n.screen.width,(t-n.screen.top)/n.screen.height),w}),D=function(){var e=new dm.Vector2;return function(t,r){return e.set((t-.5*n.screen.width-n.screen.left)/(.5*n.screen.width),(n.screen.height+2*(n.screen.top-r))/n.screen.width),e}}();function N(e,t){return Array.isArray(e)?-1!==e.indexOf(t):e===t}function I(e){!1!==n.enabled&&(window.removeEventListener("keydown",I),a=o,o===r.NONE&&(N(n.keys[r.ROTATE],e.keyCode)&&!n.noRotate?o=r.ROTATE:N(n.keys[r.ZOOM],e.keyCode)&&!n.noZoom?o=r.ZOOM:N(n.keys[r.PAN],e.keyCode)&&!n.noPan&&(o=r.PAN)))}function z(e){!1!==n.enabled&&(o=a,window.addEventListener("keydown",I,!1))}function k(e){!1!==n.enabled&&(e.preventDefault(),e.stopPropagation(),o===r.NONE&&(o=e.button),o!==r.ROTATE||n.noRotate?o!==r.ZOOM||n.noZoom?o!==r.PAN||n.noPan||(g.copy(O(e.pageX,e.pageY)),v.copy(g)):(p.copy(O(e.pageX,e.pageY)),d.copy(p)):(l.copy(D(e.pageX,e.pageY)),c.copy(l)),document.addEventListener("mousemove",F,!1),document.addEventListener("mouseup",U,!1),n.dispatchEvent(x))}function F(e){!1!==n.enabled&&(e.preventDefault(),e.stopPropagation(),o!==r.ROTATE||n.noRotate?o!==r.ZOOM||n.noZoom?o!==r.PAN||n.noPan||v.copy(O(e.pageX,e.pageY)):d.copy(O(e.pageX,e.pageY)):(c.copy(l),l.copy(D(e.pageX,e.pageY))))}function U(e){!1!==n.enabled&&(e.preventDefault(),e.stopPropagation(),o=r.NONE,document.removeEventListener("mousemove",F),document.removeEventListener("mouseup",U),n.dispatchEvent(b))}function B(e){if(!1!==n.enabled){switch(e.preventDefault(),e.stopPropagation(),e.deltaMode){case 2:p.y-=.025*e.deltaY;break;case 1:p.y-=.01*e.deltaY;break;default:p.y-=25e-5*e.deltaY}n.dispatchEvent(x),n.dispatchEvent(b)}}function j(e){if(!1!==n.enabled){switch(e.touches.length){case 1:o=r.TOUCH_ROTATE,l.copy(D(e.touches[0].pageX,e.touches[0].pageY)),c.copy(l);break;default:o=r.TOUCH_ZOOM_PAN;var t=e.touches[0].pageX-e.touches[1].pageX,i=e.touches[0].pageY-e.touches[1].pageY;m=f=Math.sqrt(t*t+i*i);var a=(e.touches[0].pageX+e.touches[1].pageX)/2,s=(e.touches[0].pageY+e.touches[1].pageY)/2;g.copy(O(a,s)),v.copy(g)}n.dispatchEvent(x)}}function H(e){if(!1!==n.enabled)switch(e.preventDefault(),e.stopPropagation(),e.touches.length){case 1:c.copy(l),l.copy(D(e.touches[0].pageX,e.touches[0].pageY));break;default:var t=e.touches[0].pageX-e.touches[1].pageX,r=e.touches[0].pageY-e.touches[1].pageY;m=Math.sqrt(t*t+r*r);var i=(e.touches[0].pageX+e.touches[1].pageX)/2,o=(e.touches[0].pageY+e.touches[1].pageY)/2;v.copy(O(i,o))}}function G(e){if(!1!==n.enabled){switch(e.touches.length){case 0:o=r.NONE;break;case 1:o=r.TOUCH_ROTATE,l.copy(D(e.touches[0].pageX,e.touches[0].pageY)),c.copy(l)}n.dispatchEvent(b)}}function V(e){!1!==n.enabled&&e.preventDefault()}this.rotateCamera=(M=new dm.Vector3,E=new dm.Quaternion,S=new dm.Vector3,T=new dm.Vector3,A=new dm.Vector3,L=new dm.Vector3,function(){L.set(l.x-c.x,l.y-c.y,0),(_=L.length())?(s.copy(n.object.position).sub(n.target),S.copy(s).normalize(),T.copy(n.object.up).normalize(),A.crossVectors(T,S).normalize(),T.setLength(l.y-c.y),A.setLength(l.x-c.x),L.copy(T.add(A)),M.crossVectors(L,s).normalize(),_*=n.rotateSpeed,E.setFromAxisAngle(M,_),s.applyQuaternion(E),n.object.up.applyQuaternion(E),h.copy(M),u=_):!n.staticMoving&&u&&(u*=Math.sqrt(1-n.dynamicDampingFactor),s.copy(n.object.position).sub(n.target),E.setFromAxisAngle(h,u),s.applyQuaternion(E),n.object.up.applyQuaternion(E)),c.copy(l)}),this.zoomCamera=function(){var e;o===r.TOUCH_ZOOM_PAN?(e=f/m,f=m,s.multiplyScalar(e)):(1!==(e=1+(d.y-p.y)*n.zoomSpeed)&&e>0&&s.multiplyScalar(e),n.staticMoving?p.copy(d):p.y+=(d.y-p.y)*this.dynamicDampingFactor)},this.panCamera=(P=new dm.Vector2,C=new dm.Vector3,R=new dm.Vector3,function(){P.copy(v).sub(g),P.lengthSq()&&(P.multiplyScalar(s.length()*n.panSpeed),R.copy(s).cross(n.object.up).setLength(P.x),R.add(C.copy(n.object.up).setLength(P.y)),n.object.position.add(R),n.target.add(R),n.staticMoving?g.copy(v):g.add(P.subVectors(v,g).multiplyScalar(n.dynamicDampingFactor)))}),this.checkDistances=function(){n.noZoom&&n.noPan||(s.lengthSq()>n.maxDistance*n.maxDistance&&(n.object.position.addVectors(n.target,s.setLength(n.maxDistance)),p.copy(d)),s.lengthSq()<n.minDistance*n.minDistance&&(n.object.position.addVectors(n.target,s.setLength(n.minDistance)),p.copy(d)))},this.update=function(){s.subVectors(n.object.position,n.target),n.noRotate||n.rotateCamera(),n.noZoom||n.zoomCamera(),n.noPan||n.panCamera(),n.object.position.addVectors(n.target,s),n.checkDistances(),n.object.lookAt(n.target),i.distanceToSquared(n.object.position)>1e-6&&(n.dispatchEvent(y),i.copy(n.object.position))},this.reset=function(){o=r.NONE,a=r.NONE,n.target.copy(n.target0),n.object.position.copy(n.position0),n.object.up.copy(n.up0),s.subVectors(n.object.position,n.target),n.object.lookAt(n.target),n.dispatchEvent(y),i.copy(n.object.position)},this.dispose=function(){this.domElement.removeEventListener("contextmenu",V,!1),this.domElement.removeEventListener("mousedown",k,!1),this.domElement.removeEventListener("wheel",B,!1),this.domElement.removeEventListener("touchstart",j,!1),this.domElement.removeEventListener("touchend",G,!1),this.domElement.removeEventListener("touchmove",H,!1),document.removeEventListener("mousemove",F,!1),document.removeEventListener("mouseup",U,!1),window.removeEventListener("keydown",I,!1),window.removeEventListener("keyup",z,!1)},this.domElement.addEventListener("contextmenu",V,!1),this.domElement.addEventListener("mousedown",k,!1),this.domElement.addEventListener("wheel",B,!1),this.domElement.addEventListener("touchstart",j,!1),this.domElement.addEventListener("touchend",G,!1),this.domElement.addEventListener("touchmove",H,!1),window.addEventListener("keydown",I,!1),window.addEventListener("keyup",z,!1),this.handleResize(),this.update()};um.prototype=Object.create(dm.EventDispatcher.prototype);function mm(){return(mm=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}function gm(e){return(gm=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function vm(e,t){return(vm=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function ym(e,t,n){return(ym=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(e){return!1}}()?Reflect.construct:function(e,t,n){var r=[null];r.push.apply(r,t);var i=new(Function.bind.apply(e,r));return n&&vm(i,n.prototype),i}).apply(null,arguments)}function xm(e){var t="function"==typeof Map?new Map:void 0;return(xm=function(e){if(null===e||(n=e,-1===Function.toString.call(n).indexOf("[native code]")))return e;var n;if("function"!=typeof e)throw new TypeError("Super expression must either be null or a function");if(void 0!==t){if(t.has(e))return t.get(e);t.set(e,r)}function r(){return ym(e,arguments,gm(this).constructor)}return r.prototype=Object.create(e.prototype,{constructor:{value:r,enumerable:!1,writable:!0,configurable:!0}}),vm(r,e)})(e)}var bm={1:"Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).\n\n",2:"Passed invalid arguments to hsla, please pass multiple numbers e.g. hsla(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).\n\n",3:"Passed an incorrect argument to a color function, please pass a string representation of a color.\n\n",4:"Couldn't generate valid rgb string from %s, it returned %s.\n\n",5:"Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.\n\n",6:"Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).\n\n",7:"Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).\n\n",8:"Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.\n\n",9:"Please provide a number of steps to the modularScale helper.\n\n",10:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",11:'Invalid value passed as base to modularScale, expected number or em string but got "%s"\n\n',12:'Expected a string ending in "px" or a number passed as the first argument to %s(), got "%s" instead.\n\n',13:'Expected a string ending in "px" or a number passed as the second argument to %s(), got "%s" instead.\n\n',14:'Passed invalid pixel value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',15:'Passed invalid base value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',16:"You must provide a template to this method.\n\n",17:"You passed an unsupported selector state to this method.\n\n",18:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",19:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",20:"expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",21:"expects the objects in the first argument array to have the properties `prop`, `fromSize`, and `toSize`.\n\n",22:"expects the first argument object to have the properties `prop`, `fromSize`, and `toSize`.\n\n",23:"fontFace expects a name of a font-family.\n\n",24:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",25:"fontFace expects localFonts to be an array.\n\n",26:"fontFace expects fileFormats to be an array.\n\n",27:"radialGradient requries at least 2 color-stops to properly render.\n\n",28:"Please supply a filename to retinaImage() as the first argument.\n\n",29:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",30:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",31:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation\n\n",32:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')\n\n",33:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation\n\n",34:"borderRadius expects a radius value as a string or number as the second argument.\n\n",35:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',36:"Property must be a string value.\n\n",37:"Syntax Error at %s.\n\n",38:"Formula contains a function that needs parentheses at %s.\n\n",39:"Formula is missing closing parenthesis at %s.\n\n",40:"Formula has too many closing parentheses at %s.\n\n",41:"All values in a formula must have the same unit or be unitless.\n\n",42:"Please provide a number of steps to the modularScale helper.\n\n",43:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",44:"Invalid value passed as base to modularScale, expected number or em/rem string but got %s.\n\n",45:"Passed invalid argument to hslToColorString, please pass a HslColor or HslaColor object.\n\n",46:"Passed invalid argument to rgbToColorString, please pass a RgbColor or RgbaColor object.\n\n",47:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",48:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",49:"Expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",50:"Expects the objects in the first argument array to have the properties prop, fromSize, and toSize.\n\n",51:"Expects the first argument object to have the properties prop, fromSize, and toSize.\n\n",52:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",53:"fontFace expects localFonts to be an array.\n\n",54:"fontFace expects fileFormats to be an array.\n\n",55:"fontFace expects a name of a font-family.\n\n",56:"linearGradient requries at least 2 color-stops to properly render.\n\n",57:"radialGradient requries at least 2 color-stops to properly render.\n\n",58:"Please supply a filename to retinaImage() as the first argument.\n\n",59:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",60:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",61:"Property must be a string value.\n\n",62:"borderRadius expects a radius value as a string or number as the second argument.\n\n",63:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',64:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation.\n\n",65:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s').\n\n",66:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation.\n\n",67:"You must provide a template to this method.\n\n",68:"You passed an unsupported selector state to this method.\n\n",69:'Expected a string ending in "px" or a number passed as the first argument to %s(), got %s instead.\n\n',70:'Expected a string ending in "px" or a number passed as the second argument to %s(), got %s instead.\n\n',71:'Passed invalid pixel value %s to %s(), please pass a value like "12px" or 12.\n\n',72:'Passed invalid base value %s to %s(), please pass a value like "12px" or 12.\n'};function wm(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];var r,i=t[0],o=[];for(r=1;r<t.length;r+=1)o.push(t[r]);return o.forEach((function(e){i=i.replace(/%[a-z]/,e)})),i}var _m=function(e){var t,n;function r(t){var n;if("production"===process.env.NODE_ENV)n=e.call(this,"An error occurred. See https://github.com/styled-components/polished/blob/master/src/internalHelpers/errors.md#"+t+" for more information.")||this;else{for(var r=arguments.length,i=new Array(r>1?r-1:0),o=1;o<r;o++)i[o-1]=arguments[o];n=e.call(this,wm.apply(void 0,[bm[t]].concat(i)))||this}return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(n)}return n=e,(t=r).prototype=Object.create(n.prototype),t.prototype.constructor=t,t.__proto__=n,r}(xm(Error));function Mm(e){return Math.round(255*e)}function Em(e,t,n){return Mm(e)+","+Mm(t)+","+Mm(n)}function Sm(e,t,n,r){if(void 0===r&&(r=Em),0===t)return r(n,n,n);var i=(e%360+360)%360/60,o=(1-Math.abs(2*n-1))*t,a=o*(1-Math.abs(i%2-1)),s=0,c=0,l=0;i>=0&&i<1?(s=o,c=a):i>=1&&i<2?(s=a,c=o):i>=2&&i<3?(c=o,l=a):i>=3&&i<4?(c=a,l=o):i>=4&&i<5?(s=a,l=o):i>=5&&i<6&&(s=o,l=a);var h=n-o/2;return r(s+h,c+h,l+h)}var Tm={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};var Am=/^#[a-fA-F0-9]{6}$/,Lm=/^#[a-fA-F0-9]{8}$/,Pm=/^#[a-fA-F0-9]{3}$/,Cm=/^#[a-fA-F0-9]{4}$/,Rm=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i,Om=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i,Dm=/^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i,Nm=/^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;function Im(e){if("string"!=typeof e)throw new _m(3);var t=function(e){if("string"!=typeof e)return e;var t=e.toLowerCase();return Tm[t]?"#"+Tm[t]:e}(e);if(t.match(Am))return{red:parseInt(""+t[1]+t[2],16),green:parseInt(""+t[3]+t[4],16),blue:parseInt(""+t[5]+t[6],16)};if(t.match(Lm)){var n=parseFloat((parseInt(""+t[7]+t[8],16)/255).toFixed(2));return{red:parseInt(""+t[1]+t[2],16),green:parseInt(""+t[3]+t[4],16),blue:parseInt(""+t[5]+t[6],16),alpha:n}}if(t.match(Pm))return{red:parseInt(""+t[1]+t[1],16),green:parseInt(""+t[2]+t[2],16),blue:parseInt(""+t[3]+t[3],16)};if(t.match(Cm)){var r=parseFloat((parseInt(""+t[4]+t[4],16)/255).toFixed(2));return{red:parseInt(""+t[1]+t[1],16),green:parseInt(""+t[2]+t[2],16),blue:parseInt(""+t[3]+t[3],16),alpha:r}}var i=Rm.exec(t);if(i)return{red:parseInt(""+i[1],10),green:parseInt(""+i[2],10),blue:parseInt(""+i[3],10)};var o=Om.exec(t);if(o)return{red:parseInt(""+o[1],10),green:parseInt(""+o[2],10),blue:parseInt(""+o[3],10),alpha:parseFloat(""+o[4])};var a=Dm.exec(t);if(a){var s="rgb("+Sm(parseInt(""+a[1],10),parseInt(""+a[2],10)/100,parseInt(""+a[3],10)/100)+")",c=Rm.exec(s);if(!c)throw new _m(4,t,s);return{red:parseInt(""+c[1],10),green:parseInt(""+c[2],10),blue:parseInt(""+c[3],10)}}var l=Nm.exec(t);if(l){var h="rgb("+Sm(parseInt(""+l[1],10),parseInt(""+l[2],10)/100,parseInt(""+l[3],10)/100)+")",u=Rm.exec(h);if(!u)throw new _m(4,t,h);return{red:parseInt(""+u[1],10),green:parseInt(""+u[2],10),blue:parseInt(""+u[3],10),alpha:parseFloat(""+l[4])}}throw new _m(5)}var zm=function(e){return 7===e.length&&e[1]===e[2]&&e[3]===e[4]&&e[5]===e[6]?"#"+e[1]+e[3]+e[5]:e};function km(e){var t=e.toString(16);return 1===t.length?"0"+t:t}function Fm(e,t,n){if("number"==typeof e&&"number"==typeof t&&"number"==typeof n)return zm("#"+km(e)+km(t)+km(n));if("object"==typeof e&&void 0===t&&void 0===n)return zm("#"+km(e.red)+km(e.green)+km(e.blue));throw new _m(6)}function Um(e){return function e(t,n,r){return function(){var i=r.concat(Array.prototype.slice.call(arguments));return i.length>=n?t.apply(this,i):e(t,n,i)}}(e,e.length,[])}function Bm(e,t){if("transparent"===t)return t;var n,r,i,o=Im(t),a="number"==typeof o.alpha?o.alpha:1;return function(e,t,n,r){if("string"==typeof e&&"number"==typeof t){var i=Im(e);return"rgba("+i.red+","+i.green+","+i.blue+","+t+")"}if("number"==typeof e&&"number"==typeof t&&"number"==typeof n&&"number"==typeof r)return r>=1?Fm(e,t,n):"rgba("+e+","+t+","+n+","+r+")";if("object"==typeof e&&void 0===t&&void 0===n&&void 0===r)return e.alpha>=1?Fm(e.red,e.green,e.blue):"rgba("+e.red+","+e.green+","+e.blue+","+e.alpha+")";throw new _m(7)}(mm({},o,{alpha:(n=0,r=1,i=(100*a+100*parseFloat(e))/100,Math.max(n,Math.min(r,i)))}))}var jm=Um(Bm);var Hm=function(){this._tweens={},this._tweensAddedDuringUpdate={}};Hm.prototype={getAll:function(){return Object.keys(this._tweens).map(function(e){return this._tweens[e]}.bind(this))},removeAll:function(){this._tweens={}},add:function(e){this._tweens[e.getId()]=e,this._tweensAddedDuringUpdate[e.getId()]=e},remove:function(e){delete this._tweens[e.getId()],delete this._tweensAddedDuringUpdate[e.getId()]},update:function(e,t){var n=Object.keys(this._tweens);if(0===n.length)return!1;for(e=void 0!==e?e:Vm.now();n.length>0;){this._tweensAddedDuringUpdate={};for(var r=0;r<n.length;r++){var i=this._tweens[n[r]];i&&!1===i.update(e)&&(i._isPlaying=!1,t||delete this._tweens[n[r]])}n=Object.keys(this._tweensAddedDuringUpdate)}return!0}};var Gm,Vm=new Hm;Vm.Group=Hm,Vm._nextId=0,Vm.nextId=function(){return Vm._nextId++},"undefined"==typeof self&&"undefined"!=typeof process&&process.hrtime?Vm.now=function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:"undefined"!=typeof self&&void 0!==self.performance&&void 0!==self.performance.now?Vm.now=self.performance.now.bind(self.performance):void 0!==Date.now?Vm.now=Date.now:Vm.now=function(){return(new Date).getTime()},Vm.Tween=function(e,t){this._isPaused=!1,this._pauseStart=null,this._object=e,this._valuesStart={},this._valuesEnd={},this._valuesStartRepeat={},this._duration=1e3,this._repeat=0,this._repeatDelayTime=void 0,this._yoyo=!1,this._isPlaying=!1,this._reversed=!1,this._delayTime=0,this._startTime=null,this._easingFunction=Vm.Easing.Linear.None,this._interpolationFunction=Vm.Interpolation.Linear,this._chainedTweens=[],this._onStartCallback=null,this._onStartCallbackFired=!1,this._onUpdateCallback=null,this._onRepeatCallback=null,this._onCompleteCallback=null,this._onStopCallback=null,this._group=t||Vm,this._id=Vm.nextId()},Vm.Tween.prototype={getId:function(){return this._id},isPlaying:function(){return this._isPlaying},isPaused:function(){return this._isPaused},to:function(e,t){return this._valuesEnd=Object.create(e),void 0!==t&&(this._duration=t),this},duration:function(e){return this._duration=e,this},start:function(e){for(var t in this._group.add(this),this._isPlaying=!0,this._isPaused=!1,this._onStartCallbackFired=!1,this._startTime=void 0!==e?"string"==typeof e?Vm.now()+parseFloat(e):e:Vm.now(),this._startTime+=this._delayTime,this._valuesEnd){if(this._valuesEnd[t]instanceof Array){if(0===this._valuesEnd[t].length)continue;this._valuesEnd[t]=[this._object[t]].concat(this._valuesEnd[t])}void 0!==this._object[t]&&(void 0===this._valuesStart[t]&&(this._valuesStart[t]=this._object[t]),this._valuesStart[t]instanceof Array==!1&&(this._valuesStart[t]*=1),this._valuesStartRepeat[t]=this._valuesStart[t]||0)}return this},stop:function(){return this._isPlaying?(this._group.remove(this),this._isPlaying=!1,this._isPaused=!1,null!==this._onStopCallback&&this._onStopCallback(this._object),this.stopChainedTweens(),this):this},end:function(){return this.update(1/0),this},pause:function(e){return this._isPaused||!this._isPlaying?this:(this._isPaused=!0,this._pauseStart=void 0===e?Vm.now():e,this._group.remove(this),this)},resume:function(e){return this._isPaused&&this._isPlaying?(this._isPaused=!1,this._startTime+=(void 0===e?Vm.now():e)-this._pauseStart,this._pauseStart=0,this._group.add(this),this):this},stopChainedTweens:function(){for(var e=0,t=this._chainedTweens.length;e<t;e++)this._chainedTweens[e].stop()},group:function(e){return this._group=e,this},delay:function(e){return this._delayTime=e,this},repeat:function(e){return this._repeat=e,this},repeatDelay:function(e){return this._repeatDelayTime=e,this},yoyo:function(e){return this._yoyo=e,this},easing:function(e){return this._easingFunction=e,this},interpolation:function(e){return this._interpolationFunction=e,this},chain:function(){return this._chainedTweens=arguments,this},onStart:function(e){return this._onStartCallback=e,this},onUpdate:function(e){return this._onUpdateCallback=e,this},onRepeat:function(e){return this._onRepeatCallback=e,this},onComplete:function(e){return this._onCompleteCallback=e,this},onStop:function(e){return this._onStopCallback=e,this},update:function(e){var t,n,r;if(e<this._startTime)return!0;for(t in!1===this._onStartCallbackFired&&(null!==this._onStartCallback&&this._onStartCallback(this._object),this._onStartCallbackFired=!0),n=(e-this._startTime)/this._duration,n=0===this._duration||n>1?1:n,r=this._easingFunction(n),this._valuesEnd)if(void 0!==this._valuesStart[t]){var i=this._valuesStart[t]||0,o=this._valuesEnd[t];o instanceof Array?this._object[t]=this._interpolationFunction(o,r):("string"==typeof o&&(o="+"===o.charAt(0)||"-"===o.charAt(0)?i+parseFloat(o):parseFloat(o)),"number"==typeof o&&(this._object[t]=i+(o-i)*r))}if(null!==this._onUpdateCallback&&this._onUpdateCallback(this._object,n),1===n){if(this._repeat>0){for(t in isFinite(this._repeat)&&this._repeat--,this._valuesStartRepeat){if("string"==typeof this._valuesEnd[t]&&(this._valuesStartRepeat[t]=this._valuesStartRepeat[t]+parseFloat(this._valuesEnd[t])),this._yoyo){var a=this._valuesStartRepeat[t];this._valuesStartRepeat[t]=this._valuesEnd[t],this._valuesEnd[t]=a}this._valuesStart[t]=this._valuesStartRepeat[t]}return this._yoyo&&(this._reversed=!this._reversed),void 0!==this._repeatDelayTime?this._startTime=e+this._repeatDelayTime:this._startTime=e+this._delayTime,null!==this._onRepeatCallback&&this._onRepeatCallback(this._object),!0}null!==this._onCompleteCallback&&this._onCompleteCallback(this._object);for(var s=0,c=this._chainedTweens.length;s<c;s++)this._chainedTweens[s].start(this._startTime+this._duration);return!1}return!0}},Vm.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){return 0===e?0:1===e?1:-Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)},Out:function(e){return 0===e?0:1===e?1:Math.pow(2,-10*e)*Math.sin(5*(e-.1)*Math.PI)+1},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?-.5*Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI):.5*Math.pow(2,-10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)+1}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((t+1)*e-t)*.5:.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(e){return 1-Vm.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*Vm.Easing.Bounce.In(2*e):.5*Vm.Easing.Bounce.Out(2*e-1)+.5}}},Vm.Interpolation={Linear:function(e,t){var n=e.length-1,r=n*t,i=Math.floor(r),o=Vm.Interpolation.Utils.Linear;return t<0?o(e[0],e[1],r):t>1?o(e[n],e[n-1],n-r):o(e[i],e[i+1>n?n:i+1],r-i)},Bezier:function(e,t){for(var n=0,r=e.length-1,i=Math.pow,o=Vm.Interpolation.Utils.Bernstein,a=0;a<=r;a++)n+=i(1-t,r-a)*i(t,a)*e[a]*o(r,a);return n},CatmullRom:function(e,t){var n=e.length-1,r=n*t,i=Math.floor(r),o=Vm.Interpolation.Utils.CatmullRom;return e[0]===e[n]?(t<0&&(i=Math.floor(r=n*(1+t))),o(e[(i-1+n)%n],e[i],e[(i+1)%n],e[(i+2)%n],r-i)):t<0?e[0]-(o(e[0],e[0],e[1],e[1],-r)-e[0]):t>1?e[n]-(o(e[n],e[n],e[n-1],e[n-1],r-n)-e[n]):o(e[i?i-1:0],e[i],e[n<i+1?n:i+1],e[n<i+2?n:i+2],r-i)},Utils:{Linear:function(e,t,n){return(t-e)*n+e},Bernstein:function(e,t){var n=Vm.Interpolation.Utils.Factorial;return n(e)/n(t)/n(e-t)},Factorial:(Gm=[1],function(e){var t=1;if(Gm[e])return Gm[e];for(var n=e;n>1;n--)t*=n;return Gm[e]=t,t}),CatmullRom:function(e,t,n,r,i){var o=.5*(n-e),a=.5*(r-t),s=i*i;return(2*t-2*n+o+a)*(i*s)+(-3*t+3*n-2*o-a)*s+o*i+t}}},Vm.version="18.4.2";!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var r=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===n&&r.firstChild?r.insertBefore(i,r.firstChild):r.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}(".scene-nav-info {\n  bottom: 5px;\n  width: 100%;\n  text-align: center;\n  color: slategrey;\n  opacity: 0.7;\n  font-size: 10px;\n}\n\n.scene-tooltip {\n  color: lavender;\n  font-size: 15px;\n}\n\n.scene-nav-info, .scene-tooltip {\n  position: absolute;\n  font-family: sans-serif;\n  pointer-events: none;\n}");var Wm=window.THREE?window.THREE:{WebGLRenderer:Na,Scene:xn,PerspectiveCamera:gi,Raycaster:lu,Vector2:Ot,Vector3:zt,Color:cr,EventDispatcher:Lt,MOUSE:i,Quaternion:Dt,Spherical:pu},qm=function(e){function t(t,n){var r,i,o,a,s;this.object=t,this.domElement=void 0!==n?n:document,this.enabled=!0,this.target=new e.Vector3,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.enableDamping=!1,this.dampingFactor=.25,this.enableZoom=!0,this.zoomSpeed=1,this.enableRotate=!0,this.rotateSpeed=1,this.enablePan=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.enableKeys=!0,this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40},this.mouseButtons={ORBIT:e.MOUSE.LEFT,ZOOM:e.MOUSE.MIDDLE,PAN:e.MOUSE.RIGHT},this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom,this.getPolarAngle=function(){return m.phi},this.getAzimuthalAngle=function(){return m.theta},this.reset=function(){c.target.copy(c.target0),c.object.position.copy(c.position0),c.object.zoom=c.zoom0,c.object.updateProjectionMatrix(),c.dispatchEvent(l),c.update(),d=p.NONE},this.update=(r=new e.Vector3,i=(new e.Quaternion).setFromUnitVectors(t.up,new e.Vector3(0,1,0)),o=i.clone().inverse(),a=new e.Vector3,s=new e.Quaternion,function(){var e=c.object.position;return r.copy(e).sub(c.target),r.applyQuaternion(i),m.setFromVector3(r),c.autoRotate&&d===p.NONE&&C(2*Math.PI/60/60*c.autoRotateSpeed),m.theta+=g.theta,m.phi+=g.phi,m.theta=Math.max(c.minAzimuthAngle,Math.min(c.maxAzimuthAngle,m.theta)),m.phi=Math.max(c.minPolarAngle,Math.min(c.maxPolarAngle,m.phi)),m.makeSafe(),m.radius*=v,m.radius=Math.max(c.minDistance,Math.min(c.maxDistance,m.radius)),c.target.add(y),r.setFromSpherical(m),r.applyQuaternion(o),e.copy(c.target).add(r),c.object.lookAt(c.target),!0===c.enableDamping?(g.theta*=1-c.dampingFactor,g.phi*=1-c.dampingFactor):g.set(0,0,0),v=1,y.set(0,0,0),!!(x||a.distanceToSquared(c.object.position)>f||8*(1-s.dot(c.object.quaternion))>f)&&(c.dispatchEvent(l),a.copy(c.object.position),s.copy(c.object.quaternion),x=!1,!0)}),this.dispose=function(){c.domElement.removeEventListener("contextmenu",q,!1),c.domElement.removeEventListener("mousedown",F,!1),c.domElement.removeEventListener("wheel",j,!1),c.domElement.removeEventListener("touchstart",G,!1),c.domElement.removeEventListener("touchend",W,!1),c.domElement.removeEventListener("touchmove",V,!1),document.removeEventListener("mousemove",U,!1),document.removeEventListener("mouseup",B,!1),window.removeEventListener("keydown",H,!1)};var c=this,l={type:"change"},h={type:"start"},u={type:"end"},p={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5},d=p.NONE,f=1e-6,m=new e.Spherical,g=new e.Spherical,v=1,y=new e.Vector3,x=!1,b=new e.Vector2,w=new e.Vector2,_=new e.Vector2,M=new e.Vector2,E=new e.Vector2,S=new e.Vector2,T=new e.Vector2,A=new e.Vector2,L=new e.Vector2;function P(){return Math.pow(.95,c.zoomSpeed)}function C(e){g.theta-=e}function R(e){g.phi-=e}var O,D=(O=new e.Vector3,function(e,t){O.setFromMatrixColumn(t,0),O.multiplyScalar(-e),y.add(O)}),N=function(){var t=new e.Vector3;return function(e,n){t.setFromMatrixColumn(n,1),t.multiplyScalar(e),y.add(t)}}(),I=function(){var t=new e.Vector3;return function(n,r){var i=c.domElement===document?c.domElement.body:c.domElement;if(c.object instanceof e.PerspectiveCamera){var o=c.object.position;t.copy(o).sub(c.target);var a=t.length();a*=Math.tan(c.object.fov/2*Math.PI/180),D(2*n*a/i.clientHeight,c.object.matrix),N(2*r*a/i.clientHeight,c.object.matrix)}else c.object instanceof e.OrthographicCamera?(D(n*(c.object.right-c.object.left)/c.object.zoom/i.clientWidth,c.object.matrix),N(r*(c.object.top-c.object.bottom)/c.object.zoom/i.clientHeight,c.object.matrix)):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled."),c.enablePan=!1)}}();function z(t){c.object instanceof e.PerspectiveCamera?v/=t:c.object instanceof e.OrthographicCamera?(c.object.zoom=Math.max(c.minZoom,Math.min(c.maxZoom,c.object.zoom*t)),c.object.updateProjectionMatrix(),x=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),c.enableZoom=!1)}function k(t){c.object instanceof e.PerspectiveCamera?v*=t:c.object instanceof e.OrthographicCamera?(c.object.zoom=Math.max(c.minZoom,Math.min(c.maxZoom,c.object.zoom/t)),c.object.updateProjectionMatrix(),x=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),c.enableZoom=!1)}function F(e){if(!1!==c.enabled){if(e.preventDefault(),e.button===c.mouseButtons.ORBIT){if(!1===c.enableRotate)return;!function(e){b.set(e.clientX,e.clientY)}(e),d=p.ROTATE}else if(e.button===c.mouseButtons.ZOOM){if(!1===c.enableZoom)return;!function(e){T.set(e.clientX,e.clientY)}(e),d=p.DOLLY}else if(e.button===c.mouseButtons.PAN){if(!1===c.enablePan)return;!function(e){M.set(e.clientX,e.clientY)}(e),d=p.PAN}d!==p.NONE&&(document.addEventListener("mousemove",U,!1),document.addEventListener("mouseup",B,!1),c.dispatchEvent(h))}}function U(e){if(!1!==c.enabled)if(e.preventDefault(),d===p.ROTATE){if(!1===c.enableRotate)return;!function(e){w.set(e.clientX,e.clientY),_.subVectors(w,b);var t=c.domElement===document?c.domElement.body:c.domElement;C(2*Math.PI*_.x/t.clientWidth*c.rotateSpeed),R(2*Math.PI*_.y/t.clientHeight*c.rotateSpeed),b.copy(w),c.update()}(e)}else if(d===p.DOLLY){if(!1===c.enableZoom)return;!function(e){A.set(e.clientX,e.clientY),L.subVectors(A,T),L.y>0?z(P()):L.y<0&&k(P()),T.copy(A),c.update()}(e)}else if(d===p.PAN){if(!1===c.enablePan)return;!function(e){E.set(e.clientX,e.clientY),S.subVectors(E,M),I(S.x,S.y),M.copy(E),c.update()}(e)}}function B(e){!1!==c.enabled&&(document.removeEventListener("mousemove",U,!1),document.removeEventListener("mouseup",B,!1),c.dispatchEvent(u),d=p.NONE)}function j(e){!1===c.enabled||!1===c.enableZoom||d!==p.NONE&&d!==p.ROTATE||(e.preventDefault(),e.stopPropagation(),function(e){e.deltaY<0?k(P()):e.deltaY>0&&z(P()),c.update()}(e),c.dispatchEvent(h),c.dispatchEvent(u))}function H(e){!1!==c.enabled&&!1!==c.enableKeys&&!1!==c.enablePan&&function(e){switch(e.keyCode){case c.keys.UP:I(0,c.keyPanSpeed),c.update();break;case c.keys.BOTTOM:I(0,-c.keyPanSpeed),c.update();break;case c.keys.LEFT:I(c.keyPanSpeed,0),c.update();break;case c.keys.RIGHT:I(-c.keyPanSpeed,0),c.update()}}(e)}function G(e){if(!1!==c.enabled){switch(e.touches.length){case 1:if(!1===c.enableRotate)return;!function(e){b.set(e.touches[0].pageX,e.touches[0].pageY)}(e),d=p.TOUCH_ROTATE;break;case 2:if(!1===c.enableZoom)return;!function(e){var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY,r=Math.sqrt(t*t+n*n);T.set(0,r)}(e),d=p.TOUCH_DOLLY;break;case 3:if(!1===c.enablePan)return;!function(e){M.set(e.touches[0].pageX,e.touches[0].pageY)}(e),d=p.TOUCH_PAN;break;default:d=p.NONE}d!==p.NONE&&c.dispatchEvent(h)}}function V(e){if(!1!==c.enabled)switch(e.preventDefault(),e.stopPropagation(),e.touches.length){case 1:if(!1===c.enableRotate)return;if(d!==p.TOUCH_ROTATE)return;!function(e){w.set(e.touches[0].pageX,e.touches[0].pageY),_.subVectors(w,b);var t=c.domElement===document?c.domElement.body:c.domElement;C(2*Math.PI*_.x/t.clientWidth*c.rotateSpeed),R(2*Math.PI*_.y/t.clientHeight*c.rotateSpeed),b.copy(w),c.update()}(e);break;case 2:if(!1===c.enableZoom)return;if(d!==p.TOUCH_DOLLY)return;!function(e){var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY,r=Math.sqrt(t*t+n*n);A.set(0,r),L.subVectors(A,T),L.y>0?k(P()):L.y<0&&z(P()),T.copy(A),c.update()}(e);break;case 3:if(!1===c.enablePan)return;if(d!==p.TOUCH_PAN)return;!function(e){E.set(e.touches[0].pageX,e.touches[0].pageY),S.subVectors(E,M),I(S.x,S.y),M.copy(E),c.update()}(e);break;default:d=p.NONE}}function W(e){!1!==c.enabled&&(c.dispatchEvent(u),d=p.NONE)}function q(e){e.preventDefault()}c.domElement.addEventListener("contextmenu",q,!1),c.domElement.addEventListener("mousedown",F,!1),c.domElement.addEventListener("wheel",j,!1),c.domElement.addEventListener("touchstart",G,!1),c.domElement.addEventListener("touchend",W,!1),c.domElement.addEventListener("touchmove",V,!1),window.addEventListener("keydown",H,!1),this.update()}return t.prototype=Object.create(e.EventDispatcher.prototype),t.prototype.constructor=t,Object.defineProperties(t.prototype,{center:{get:function(){return console.warn("THREE.OrbitControls: .center has been renamed to .target"),this.target}},noZoom:{get:function(){return console.warn("THREE.OrbitControls: .noZoom has been deprecated. Use .enableZoom instead."),!this.enableZoom},set:function(e){console.warn("THREE.OrbitControls: .noZoom has been deprecated. Use .enableZoom instead."),this.enableZoom=!e}},noRotate:{get:function(){return console.warn("THREE.OrbitControls: .noRotate has been deprecated. Use .enableRotate instead."),!this.enableRotate},set:function(e){console.warn("THREE.OrbitControls: .noRotate has been deprecated. Use .enableRotate instead."),this.enableRotate=!e}},noPan:{get:function(){return console.warn("THREE.OrbitControls: .noPan has been deprecated. Use .enablePan instead."),!this.enablePan},set:function(e){console.warn("THREE.OrbitControls: .noPan has been deprecated. Use .enablePan instead."),this.enablePan=!e}},noKeys:{get:function(){return console.warn("THREE.OrbitControls: .noKeys has been deprecated. Use .enableKeys instead."),!this.enableKeys},set:function(e){console.warn("THREE.OrbitControls: .noKeys has been deprecated. Use .enableKeys instead."),this.enableKeys=!e}},staticMoving:{get:function(){return console.warn("THREE.OrbitControls: .staticMoving has been deprecated. Use .enableDamping instead."),!this.enableDamping},set:function(e){console.warn("THREE.OrbitControls: .staticMoving has been deprecated. Use .enableDamping instead."),this.enableDamping=!e}},dynamicDampingFactor:{get:function(){return console.warn("THREE.OrbitControls: .dynamicDampingFactor has been renamed. Use .dampingFactor instead."),this.dampingFactor},set:function(e){console.warn("THREE.OrbitControls: .dynamicDampingFactor has been renamed. Use .dampingFactor instead."),this.dampingFactor=e}}}),t}(Wm),Xm=(function(e){e.FlyControls=function(t,n,r){this.object=t,r=r||{},this.domElement=void 0!==n?n:document,n&&this.domElement.setAttribute("tabindex",-1),this.movementSpeed=void 0===r.movementSpeed?1:r.movementSpeed,this.rollSpeed=void 0===r.rollSpeed?.005:r.rollSpeed,this.dragToLook=!0,this.autoForward=!1,this.tmpQuaternion=new e.Quaternion,this.mouseStatus=0,this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0},this.moveVector=new e.Vector3(0,0,0),this.rotationVector=new e.Vector3(0,0,0);var i=Date.now();function o(e,t){return function(){t.apply(e,arguments)}}this.handleEvent=function(e){"function"==typeof this[e.type]&&this[e.type](e)},this.keydown=function(e){if(!e.altKey){switch(e.keyCode){case 16:this.movementSpeedMultiplier=.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}[38,40,37,39].indexOf(e.keyCode)>-1&&e.preventDefault(),this.updateMovementVector(),this.updateRotationVector()}},this.keyup=function(e){switch(e.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;case 69:this.moveState.rollRight=0}this.updateMovementVector(),this.updateRotationVector()},this.mousedown=function(e){if(this.domElement!==document&&this.domElement.focus(),e.preventDefault(),e.stopPropagation(),this.dragToLook)this.mouseStatus++;else{switch(e.button){case 0:this.moveState.forward=1;break;case 2:this.moveState.back=1}this.updateMovementVector()}},this.mousemove=function(e){if(!this.dragToLook||this.mouseStatus>0){var t=this.getContainerDimensions(),n=t.size[0]/2,r=t.size[1]/2;this.moveState.yawLeft=-(e.pageX-t.offset[0]-n)/n,this.moveState.pitchDown=(e.pageY-t.offset[1]-r)/r,this.updateRotationVector()}},this.mouseout=function(e){e.preventDefault(),e.stopPropagation(),this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0},this.updateRotationVector(),this.updateMovementVector()},this.mouseup=function(e){if(e.preventDefault(),e.stopPropagation(),this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else{switch(e.button){case 0:this.moveState.forward=0;break;case 2:this.moveState.back=0}this.updateMovementVector()}this.updateRotationVector()},this.update=function(e){var t=Date.now(),n=(e=(t-i)/10)*this.movementSpeed,r=e*this.rollSpeed;this.object.translateX(this.moveVector.x*n),this.object.translateY(this.moveVector.y*n),this.object.translateZ(this.moveVector.z*n),this.tmpQuaternion.set(this.rotationVector.x*r,this.rotationVector.y*r,this.rotationVector.z*r,1).normalize(),this.object.quaternion.multiply(this.tmpQuaternion),this.object.rotation.setFromQuaternion(this.object.quaternion,this.object.rotation.order),i=t},this.updateMovementVector=function(){var e=this.moveState.forward||this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right,this.moveVector.y=-this.moveState.down+this.moveState.up,this.moveVector.z=-e+this.moveState.back},this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp,this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft,this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft},this.getContainerDimensions=function(){return this.domElement!=document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}},this.domElement.addEventListener("contextmenu",(function(e){e.preventDefault()}),!1),this.domElement.addEventListener("mousemove",o(this,this.mousemove),!1),this.domElement.addEventListener("mousedown",o(this,this.mousedown),!1),this.domElement.addEventListener("mouseup",o(this,this.mouseup),!1),this.domElement.addEventListener("mouseout",o(this,this.mouseout),!1),this.domElement.addEventListener("keydown",o(this,this.keydown),!1),this.domElement.addEventListener("keyup",o(this,this.keyup),!1),this.updateMovementVector(),this.updateRotationVector()}}(Wm),Wm.FlyControls),Ym=Af({props:{width:{default:window.innerWidth,onChange:function(e,t,n){isNaN(e)&&(t.width=n)}},height:{default:window.innerHeight,onChange:function(e,t,n){isNaN(e)&&(t.height=n)}},backgroundColor:{default:"#000011",onChange:function(e,t){if(t.renderer){var n=Im(e).alpha;void 0===n&&(n=1),t.renderer.setClearColor(new Wm.Color(jm(1,e)),n)}},triggerUpdate:!1},showNavInfo:{default:!0},objects:{default:[],onChange:function(e,t){(t.prevObjs||[]).forEach((function(e){return t.scene.remove(e)})),t.prevObjs=e,e.forEach((function(e){return t.scene.add(e)}))},triggerUpdate:!1},postProcessingComposer:{triggerUpdate:!1},enablePointerInteraction:{default:!0,onChange:function(e,t){t.hoverObj=null,t.toolTipElem&&(t.toolTipElem.innerHTML="")},triggerUpdate:!1},lineHoverPrecision:{default:1,triggerUpdate:!1},hoverOrderComparator:{default:function(){return-1},triggerUpdate:!1},tooltipContent:{triggerUpdate:!1},hoverDuringDrag:{default:!1,triggerUpdate:!1},onHover:{default:function(){},triggerUpdate:!1},onClick:{default:function(){},triggerUpdate:!1},onRightClick:{triggerUpdate:!1}},methods:{tick:function(e){if(e.initialised){if(e.controls.update&&e.controls.update(),e.postProcessingComposer?e.postProcessingComposer.render():e.renderer.render(e.scene,e.camera),e.enablePointerInteraction){var t=null;if(e.hoverDuringDrag||!e.controlsDragging){var n=new Wm.Raycaster;n.linePrecision=e.lineHoverPrecision,n.setFromCamera(e.mousePos,e.camera);var r=n.intersectObjects(e.objects,!0).map((function(e){return e.object})).sort(e.hoverOrderComparator);t=r.length?r[0]:null}t!==e.hoverObj&&(e.onHover(t,e.hoverObj),e.toolTipElem.innerHTML=t&&Pf(e.tooltipContent)(t)||"",e.hoverObj=t)}Vm.update()}return this},cameraPosition:function(e,t,n,r){var i=e.camera;if(t&&e.initialised){var o=t,a=n||{x:0,y:0,z:0};if(r){var s=Object.assign({},i.position),c=u();new Vm.Tween(s).to(o,r).easing(Vm.Easing.Quadratic.Out).onUpdate(l).start(),new Vm.Tween(c).to(a,r/3).easing(Vm.Easing.Quadratic.Out).onUpdate(h).start()}else l(o),h(a);return this}return Object.assign({},i.position,{lookAt:u()});function l(e){var t=e.x,n=e.y,r=e.z;void 0!==t&&(i.position.x=t),void 0!==n&&(i.position.y=n),void 0!==r&&(i.position.z=r)}function h(t){e.controls.target=new Wm.Vector3(t.x,t.y,t.z)}function u(){return Object.assign(new Wm.Vector3(0,0,-1e3).applyQuaternion(i.quaternion).add(i.position))}},renderer:function(e){return e.renderer},scene:function(e){return e.scene},camera:function(e){return e.camera},controls:function(e){return e.controls},tbControls:function(e){return e.controls}},stateInit:function(){return{scene:new Wm.Scene,camera:new Wm.PerspectiveCamera}},init:function(e,t,n){var r=n.controlType,i=void 0===r?"trackball":r,o=n.rendererConfig,a=void 0===o?{}:o;e.innerHTML="",e.appendChild(t.container=document.createElement("div")),t.container.style.position="relative",t.container.appendChild(t.navInfo=document.createElement("div")),t.navInfo.className="scene-nav-info",t.navInfo.textContent={orbit:"Left-click: rotate, Mouse-wheel/middle-click: zoom, Right-click: pan",trackball:"Left-click: rotate, Mouse-wheel/middle-click: zoom, Right-click: pan",fly:"WASD: move, R|F: up | down, Q|E: roll, up|down: pitch, left|right: yaw"}[i]||"",t.navInfo.style.display=t.showNavInfo?null:"none",t.toolTipElem=document.createElement("div"),t.toolTipElem.classList.add("scene-tooltip"),t.container.appendChild(t.toolTipElem),t.mousePos=new Wm.Vector2,t.mousePos.x=-2,t.mousePos.y=-2,t.container.addEventListener("mousemove",(function(e){if(t.enablePointerInteraction){var n=(i=t.container,o=i.getBoundingClientRect(),a=window.pageXOffset||document.documentElement.scrollLeft,s=window.pageYOffset||document.documentElement.scrollTop,{top:o.top+s,left:o.left+a}),r={x:e.pageX-n.left,y:e.pageY-n.top};t.mousePos.x=r.x/t.width*2-1,t.mousePos.y=-r.y/t.height*2+1,t.toolTipElem.style.top="".concat(r.y,"px"),t.toolTipElem.style.left="".concat(r.x,"px"),t.toolTipElem.style.transform="translate(-".concat(r.x/t.width*100,"%, 21px)")}var i,o,a,s}),!1),t.container.addEventListener("click",(function(e){t.ignoreOneClick?t.ignoreOneClick=!1:t.onClick(t.hoverObj||null,e)}),!1),t.container.addEventListener("mouseup",(function(e){if(2===e.button&&t.onRightClick){if(t.ignoreOneClick)return void(t.ignoreOneClick=!1);t.onRightClick(t.hoverObj||null,e)}}),!1),t.renderer=new Wm.WebGLRenderer(Object.assign({antialias:!0,alpha:!0},a)),t.renderer.setPixelRatio(window.devicePixelRatio);var s=Im(t.backgroundColor).alpha;void 0===s&&(s=1),t.renderer.setClearColor(new Wm.Color(jm(1,t.backgroundColor)),s),t.container.appendChild(t.renderer.domElement),t.controls=new{trackball:fm,orbit:qm,fly:Xm}[i](t.camera,t.renderer.domElement),"fly"===i&&(t.controls.movementSpeed=2.5),"trackball"!==i&&"orbit"!==i||(t.controls.minDistance=.1,t.controls.maxDistance=5e4,t.controls.addEventListener("start",(function(){return t.controlsEngaged=!0})),t.controls.addEventListener("change",(function(){t.controlsEngaged&&(t.controlsDragging=!0,t.ignoreOneClick=!0)})),t.controls.addEventListener("end",(function(){t.controlsEngaged=!1,t.controlsDragging=!1}))),t.renderer.setSize(t.width,t.height),t.camera.aspect=t.width/t.height,t.camera.updateProjectionMatrix(),t.camera.position.z=1e3,t.camera.far=5e4,window.scene=t.scene},update:function(e){e.width&&e.height&&(e.container.style.width=e.width,e.container.style.height=e.height,e.renderer.setSize(e.width,e.height),e.camera.aspect=e.width/e.height,e.camera.updateProjectionMatrix()),e.navInfo.style.display=e.showNavInfo?null:"none"}});function Zm(e,t){var n=new t;return{linkProp:function(t){return{default:n[t](),onChange:function(n,r){r[e][t](n)},triggerUpdate:!1}},linkMethod:function(t){return function(n){for(var r=n[e],i=arguments.length,o=new Array(i>1?i-1:0),a=1;a<i;a++)o[a-1]=arguments[a];var s=r[t].apply(r,o);return s===r?this:s}}}}var Jm=window.THREE?window.THREE:{AmbientLight:sh,DirectionalLight:ah},Qm=Zm("forceGraph",pm),Km=Object.assign.apply(Object,r(["jsonUrl","graphData","numDimensions","dagMode","dagLevelDistance","nodeRelSize","nodeId","nodeVal","nodeResolution","nodeColor","nodeAutoColorBy","nodeOpacity","nodeVisibility","nodeThreeObject","nodeThreeObjectExtend","linkSource","linkTarget","linkVisibility","linkColor","linkAutoColorBy","linkOpacity","linkWidth","linkResolution","linkCurvature","linkCurveRotation","linkMaterial","linkThreeObject","linkThreeObjectExtend","linkPositionUpdate","linkDirectionalArrowLength","linkDirectionalArrowColor","linkDirectionalArrowRelPos","linkDirectionalArrowResolution","linkDirectionalParticles","linkDirectionalParticleSpeed","linkDirectionalParticleWidth","linkDirectionalParticleColor","linkDirectionalParticleResolution","forceEngine","d3AlphaDecay","d3VelocityDecay","warmupTicks","cooldownTicks","cooldownTime","onEngineTick","onEngineStop"].map((function(t){return e({},t,Qm.linkProp(t))})))),$m=Object.assign.apply(Object,r(["refresh","d3Force","d3ReheatSimulation","emitParticle"].map((function(t){return e({},t,Qm.linkMethod(t))})))),eg=Zm("renderObjs",Ym),tg=Object.assign.apply(Object,r(["width","height","backgroundColor","showNavInfo","enablePointerInteraction"].map((function(t){return e({},t,eg.linkProp(t))})))),ng=Object.assign.apply(Object,r(["cameraPosition"].map((function(t){return e({},t,eg.linkMethod(t))}))));return Af({props:n({nodeLabel:{default:"name",triggerUpdate:!1},linkLabel:{default:"name",triggerUpdate:!1},linkHoverPrecision:{default:1,onChange:function(e,t){return t.renderObjs.lineHoverPrecision(e)},triggerUpdate:!1},enableNavigationControls:{default:!0,onChange:function(e,t){var n=t.renderObjs.controls();n&&(n.enabled=e)},triggerUpdate:!1},enableNodeDrag:{default:!0,triggerUpdate:!1},onNodeDrag:{default:function(){},triggerUpdate:!1},onNodeDragEnd:{default:function(){},triggerUpdate:!1},onNodeClick:{default:function(){},triggerUpdate:!1},onNodeRightClick:{default:function(){},triggerUpdate:!1},onNodeHover:{default:function(){},triggerUpdate:!1},onLinkClick:{default:function(){},triggerUpdate:!1},onLinkRightClick:{default:function(){},triggerUpdate:!1},onLinkHover:{default:function(){},triggerUpdate:!1},onBackgroundClick:{default:function(){},triggerUpdate:!1},onBackgroundRightClick:{default:function(){},triggerUpdate:!1}},Km,{},tg),methods:n({pauseAnimation:function(e){return null!==e.animationFrameRequestId&&(cancelAnimationFrame(e.animationFrameRequestId),e.animationFrameRequestId=null),this},resumeAnimation:function(e){return null===e.animationFrameRequestId&&this._animationCycle(),this},_animationCycle:function(e){e.enablePointerInteraction&&(this.renderer().domElement.style.cursor=null),e.forceGraph.tickFrame(),e.renderObjs.tick(),e.animationFrameRequestId=requestAnimationFrame(this._animationCycle)},scene:function(e){return e.renderObjs.scene()},camera:function(e){return e.renderObjs.camera()},renderer:function(e){return e.renderObjs.renderer()},controls:function(e){return e.renderObjs.controls()},tbControls:function(e){return e.renderObjs.tbControls()},_destructor:function(){this.pauseAnimation(),this.graphData({nodes:[],links:[]})}},$m,{},ng),stateInit:function(e){var t=e.controlType,n=e.rendererConfig;return{forceGraph:new pm,renderObjs:Ym({controlType:t,rendererConfig:n})}},init:function(e,t){e.innerHTML="",e.appendChild(t.container=document.createElement("div")),t.container.style.position="relative";var n=document.createElement("div");t.container.appendChild(n),t.renderObjs(n);var r,i=t.renderObjs.camera(),o=t.renderObjs.renderer(),a=t.renderObjs.controls();a.enabled=!!t.enableNavigationControls,t.lastSetCameraZ=i.position.z,t.container.appendChild(r=document.createElement("div")),r.className="graph-info-msg",r.textContent="",t.forceGraph.onLoading((function(){r.textContent="Loading..."})).onFinishLoading((function(){r.textContent=""})).onUpdate((function(){t.graphData=t.forceGraph.graphData(),0===i.position.x&&0===i.position.y&&i.position.z===t.lastSetCameraZ&&t.graphData.nodes.length&&(i.lookAt(t.forceGraph.position),t.lastSetCameraZ=i.position.z=170*Math.cbrt(t.graphData.nodes.length))})).onFinishUpdate((function(){if(t._dragControls){var e=t.graphData.nodes.find((function(e){return e.__initialFixedPos&&!e.__disposeControlsAfterDrag}));e?e.__disposeControlsAfterDrag=!0:t._dragControls.dispose(),t._dragControls=void 0}if(t.enableNodeDrag&&t.enablePointerInteraction&&"d3"===t.forceEngine){var n=t._dragControls=new fp(t.graphData.nodes.map((function(e){return e.__threeObj})).filter((function(e){return e})),i,o.domElement);n.addEventListener("dragstart",(function(e){a.enabled=!1;var t=e.object.__data;!t.__initialFixedPos&&(t.__initialFixedPos={fx:t.fx,fy:t.fy,fz:t.fz}),["x","y","z"].forEach((function(e){return t["f".concat(e)]=t[e]})),o.domElement.classList.add("grabbable")})),n.addEventListener("drag",(function(e){t.ignoreOneClick=!0;var n=e.object.__data;["x","y","z"].forEach((function(t){return n["f".concat(t)]=n[t]=e.object.position[t]})),t.forceGraph.d3AlphaTarget(.3).resetCountdown(),n.__dragged=!0,t.onNodeDrag(n)})),n.addEventListener("dragend",(function(e){var r=e.object.__data;r.__disposeControlsAfterDrag&&(n.dispose(),delete r.__disposeControlsAfterDrag);var i=r.__initialFixedPos;i&&(["x","y","z"].forEach((function(e){var t="f".concat(e);void 0===i[t]&&delete r[t]})),delete r.__initialFixedPos,r.__dragged&&(delete r.__dragged,t.onNodeDragEnd(r))),t.forceGraph.d3AlphaTarget(0).resetCountdown(),t.enableNavigationControls&&(a.enabled=!0),o.domElement.classList.remove("grabbable")}))}}));var s=function(e){for(var t=e;t&&!t.hasOwnProperty("__graphObjType");)t=t.parent;return t};t.renderObjs.objects([new Jm.AmbientLight(12303291),new Jm.DirectionalLight(16777215,.6),t.forceGraph]).hoverOrderComparator((function(e,t){var n=s(e);if(!n)return 1;var r=s(t);if(!r)return-1;var i=function(e){return"node"===e.__graphObjType};return i(r)-i(n)})).tooltipContent((function(e){var n=s(e);return n&&Pf(t["".concat(n.__graphObjType,"Label")])(n.__data)||""})).onHover((function(e){var n=s(e);if(n!==t.hoverObj){var r=t.hoverObj?t.hoverObj.__graphObjType:null,i=t.hoverObj?t.hoverObj.__data:null,o=n?n.__graphObjType:null,a=n?n.__data:null;r&&r!==o&&t["on".concat("node"===r?"Node":"Link","Hover")](null,i),o&&t["on".concat("node"===o?"Node":"Link","Hover")](a,r===o?i:null),t.hoverObj=n}})).onClick((function(e,n){if(t.ignoreOneClick)t.ignoreOneClick=!1;else{var r=s(e);r?t["on".concat("node"===r.__graphObjType?"Node":"Link","Click")](r.__data,n):t.onBackgroundClick(n)}})).onRightClick((function(e,n){var r=s(e);r?t["on".concat("node"===r.__graphObjType?"Node":"Link","RightClick")](r.__data,n):t.onBackgroundRightClick(n)})),this._animationCycle()}})}
// ));

  );
}
