"""Color definitions for different plotting libraries."""

COLORS = {
    "b": "#0000FF",
    "c": "#00BFBF",
    "g": "#008000",
    "k": "#000000",
    "m": "#BF00BF",
    "r": "#FF0000",
    "w": "#FFFFFF",
    "y": "#BFBF00",
    "aliceblue": "#F0F8FF",
    "antiquewhite": "#FAEBD7",
    "aqua": "#00FFFF",
    "aquamarine": "#7FFFD4",
    "azure": "#F0FFFF",
    "beige": "#F5F5DC",
    "bisque": "#FFE4C4",
    "black": "#000000",
    "blanchedalmond": "#FFEBCD",
    "blue": "#0000FF",
    "blueviolet": "#8A2BE2",
    "brown": "#A52A2A",
    "burlywood": "#DEB887",
    "cadetblue": "#5F9EA0",
    "chartreuse": "#7FFF00",
    "chocolate": "#D2691E",
    "coral": "#FF7F50",
    "cornflowerblue": "#6495ED",
    "cornsilk": "#FFF8DC",
    "crimson": "#DC143C",
    "cyan": "#00FFFF",
    "darkblue": "#00008B",
    "darkcyan": "#008B8B",
    "darkgoldenrod": "#B8860B",
    "darkgray": "#A9A9A9",
    "darkgreen": "#006400",
    "darkgrey": "#A9A9A9",
    "darkkhaki": "#BDB76B",
    "darkmagenta": "#8B008B",
    "darkolivegreen": "#556B2F",
    "darkorange": "#FF8C00",
    "darkorchid": "#9932CC",
    "darkred": "#8B0000",
    "darksalmon": "#E9967A",
    "darkseagreen": "#8FBC8F",
    "darkslateblue": "#483D8B",
    "darkslategray": "#2F4F4F",
    "darkslategrey": "#2F4F4F",
    "darkturquoise": "#00CED1",
    "darkviolet": "#9400D3",
    "deeppink": "#FF1493",
    "deepskyblue": "#00BFFF",
    "dimgray": "#696969",
    "dimgrey": "#696969",
    "dodgerblue": "#1E90FF",
    "firebrick": "#B22222",
    "floralwhite": "#FFFAF0",
    "forestgreen": "#228B22",
    "fuchsia": "#FF00FF",
    "gainsboro": "#DCDCDC",
    "ghostwhite": "#F8F8FF",
    "gold": "#FFD700",
    "goldenrod": "#DAA520",
    "gray": "#808080",
    "green": "#008000",
    "greenyellow": "#ADFF2F",
    "grey": "#808080",
    "honeydew": "#F0FFF0",
    "hotpink": "#FF69B4",
    "indianred": "#CD5C5C",
    "indigo": "#4B0082",
    "ivory": "#FFFFF0",
    "khaki": "#F0E68C",
    "lavender": "#E6E6FA",
    "lavenderblush": "#FFF0F5",
    "lawngreen": "#7CFC00",
    "lemonchiffon": "#FFFACD",
    "lightblue": "#ADD8E6",
    "lightcoral": "#F08080",
    "lightcyan": "#E0FFFF",
    "lightgoldenrodyellow": "#FAFAD2",
    "lightgray": "#D3D3D3",
    "lightgreen": "#90EE90",
    "lightgrey": "#D3D3D3",
    "lightpink": "#FFB6C1",
    "lightsalmon": "#FFA07A",
    "lightseagreen": "#20B2AA",
    "lightskyblue": "#87CEFA",
    "lightslategray": "#778899",
    "lightslategrey": "#778899",
    "lightsteelblue": "#B0C4DE",
    "lightyellow": "#FFFFE0",
    "lime": "#00FF00",
    "limegreen": "#32CD32",
    "linen": "#FAF0E6",
    "magenta": "#FF00FF",
    "maroon": "#800000",
    "mediumaquamarine": "#66CDAA",
    "mediumblue": "#0000CD",
    "mediumorchid": "#BA55D3",
    "mediumpurple": "#9370DB",
    "mediumseagreen": "#3CB371",
    "mediumslateblue": "#7B68EE",
    "mediumspringgreen": "#00FA9A",
    "mediumturquoise": "#48D1CC",
    "mediumvioletred": "#C71585",
    "midnightblue": "#191970",
    "mintcream": "#F5FFFA",
    "mistyrose": "#FFE4E1",
    "moccasin": "#FFE4B5",
    "navajowhite": "#FFDEAD",
    "navy": "#000080",
    "oldlace": "#FDF5E6",
    "olive": "#808000",
    "olivedrab": "#6B8E23",
    "orange": "#FFA500",
    "orangered": "#FF4500",
    "orchid": "#DA70D6",
    "palegoldenrod": "#EEE8AA",
    "palegreen": "#98FB98",
    "paleturquoise": "#AFEEEE",
    "palevioletred": "#DB7093",
    "papayawhip": "#FFEFD5",
    "peachpuff": "#FFDAB9",
    "peru": "#CD853F",
    "pink": "#FFC0CB",
    "plum": "#DDA0DD",
    "powderblue": "#B0E0E6",
    "purple": "#800080",
    "rebeccapurple": "#663399",
    "red": "#FF0000",
    "rosybrown": "#BC8F8F",
    "royalblue": "#4169E1",
    "saddlebrown": "#8B4513",
    "salmon": "#FA8072",
    "sandybrown": "#F4A460",
    "seagreen": "#2E8B57",
    "seashell": "#FFF5EE",
    "sienna": "#A0522D",
    "silver": "#C0C0C0",
    "skyblue": "#87CEEB",
    "slateblue": "#6A5ACD",
    "slategray": "#708090",
    "slategrey": "#708090",
    "snow": "#FFFAFA",
    "springgreen": "#00FF7F",
    "steelblue": "#4682B4",
    "tan": "#D2B48C",
    "teal": "#008080",
    "thistle": "#D8BFD8",
    "tomato": "#FF6347",
    "turquoise": "#40E0D0",
    "violet": "#EE82EE",
    "wheat": "#F5DEB3",
    "white": "#FFFFFF",
    "whitesmoke": "#F5F5F5",
    "yellow": "#FFFF00",
    "yellowgreen": "#9ACD32",
    "tab.blue": "#1F77B4",
    "tab.brown": "#8C564B",
    "tab.cyan": "#17BECF",
    "tab.gray": "#7F7F7F",
    "tab.green": "#2CA02C",
    "tab.olive": "#BCBD22",
    "tab.orange": "#FF7F0E",
    "tab.pink": "#E377C2",
    "tab.purple": "#9467BD",
    "tab.red": "#D62728",
    "xkcd.acid_green": "#8FFE09",
    "xkcd.adobe": "#BD6C48",
    "xkcd.algae": "#54AC68",
    "xkcd.algae_green": "#21C36F",
    "xkcd.almost_black": "#070D0D",
    "xkcd.amber": "#FEB308",
    "xkcd.amethyst": "#9B5FC0",
    "xkcd.apple": "#6ECB3C",
    "xkcd.apple_green": "#76CD26",
    "xkcd.apricot": "#FFB16D",
    "xkcd.aqua": "#13EAC9",
    "xkcd.aqua_blue": "#02D8E9",
    "xkcd.aqua_green": "#12E193",
    "xkcd.aqua_marine": "#2EE8BB",
    "xkcd.aquamarine": "#04D8B2",
    "xkcd.army_green": "#4B5D16",
    "xkcd.asparagus": "#77AB56",
    "xkcd.aubergine": "#3D0734",
    "xkcd.auburn": "#9A3001",
    "xkcd.avocado": "#90B134",
    "xkcd.avocado_green": "#87A922",
    "xkcd.azul": "#1D5DEC",
    "xkcd.azure": "#069AF3",
    "xkcd.baby_blue": "#A2CFFE",
    "xkcd.baby_green": "#8CFF9E",
    "xkcd.baby_pink": "#FFB7CE",
    "xkcd.baby_poo": "#AB9004",
    "xkcd.baby_poop": "#937C00",
    "xkcd.baby_poop_green": "#8F9805",
    "xkcd.baby_puke_green": "#B6C406",
    "xkcd.baby_purple": "#CA9BF7",
    "xkcd.baby_shit_brown": "#AD900D",
    "xkcd.baby_shit_green": "#889717",
    "xkcd.banana": "#FFFF7E",
    "xkcd.banana_yellow": "#FAFE4B",
    "xkcd.barbie_pink": "#FE46A5",
    "xkcd.barf_green": "#94AC02",
    "xkcd.barney": "#AC1DB8",
    "xkcd.barney_purple": "#A00498",
    "xkcd.battleship_grey": "#6B7C85",
    "xkcd.beige": "#E6DAA6",
    "xkcd.berry": "#990F4B",
    "xkcd.bile": "#B5C306",
    "xkcd.black": "#000000",
    "xkcd.bland": "#AFA88B",
    "xkcd.blood": "#770001",
    "xkcd.blood_orange": "#FE4B03",
    "xkcd.blood_red": "#980002",
    "xkcd.blue": "#0343DF",
    "xkcd.blue_blue": "#2242C7",
    "xkcd.blue_green": "#0F9B8E",
    "xkcd.blue_grey": "#758DA3",
    "xkcd.blue_purple": "#5A06EF",
    "xkcd.blue_violet": "#5D06E9",
    "xkcd.blue_with_a_hint_of_purple": "#533CC6",
    "xkcd.blueberry": "#464196",
    "xkcd.bluegreen": "#017A79",
    "xkcd.bluegrey": "#85A3B2",
    "xkcd.bluey_green": "#2BB179",
    "xkcd.bluey_grey": "#89A0B0",
    "xkcd.bluey_purple": "#6241C7",
    "xkcd.bluish": "#2976BB",
    "xkcd.bluish_green": "#10A674",
    "xkcd.bluish_grey": "#748B97",
    "xkcd.bluish_purple": "#703BE7",
    "xkcd.blurple": "#5539CC",
    "xkcd.blush": "#F29E8E",
    "xkcd.blush_pink": "#FE828C",
    "xkcd.booger": "#9BB53C",
    "xkcd.booger_green": "#96B403",
    "xkcd.bordeaux": "#7B002C",
    "xkcd.boring_green": "#63B365",
    "xkcd.bottle_green": "#044A05",
    "xkcd.brick": "#A03623",
    "xkcd.brick_orange": "#C14A09",
    "xkcd.brick_red": "#8F1402",
    "xkcd.bright_aqua": "#0BF9EA",
    "xkcd.bright_blue": "#0165FC",
    "xkcd.bright_cyan": "#41FDFE",
    "xkcd.bright_green": "#01FF07",
    "xkcd.bright_lavender": "#C760FF",
    "xkcd.bright_light_blue": "#26F7FD",
    "xkcd.bright_light_green": "#2DFE54",
    "xkcd.bright_lilac": "#C95EFB",
    "xkcd.bright_lime": "#87FD05",
    "xkcd.bright_lime_green": "#65FE08",
    "xkcd.bright_magenta": "#FF08E8",
    "xkcd.bright_olive": "#9CBB04",
    "xkcd.bright_orange": "#FF5B00",
    "xkcd.bright_pink": "#FE01B1",
    "xkcd.bright_purple": "#BE03FD",
    "xkcd.bright_red": "#FF000D",
    "xkcd.bright_sea_green": "#05FFA6",
    "xkcd.bright_sky_blue": "#02CCFE",
    "xkcd.bright_teal": "#01F9C6",
    "xkcd.bright_turquoise": "#0FFEF9",
    "xkcd.bright_violet": "#AD0AFD",
    "xkcd.bright_yellow": "#FFFD01",
    "xkcd.bright_yellow_green": "#9DFF00",
    "xkcd.british_racing_green": "#05480D",
    "xkcd.bronze": "#A87900",
    "xkcd.brown": "#653700",
    "xkcd.brown_green": "#706C11",
    "xkcd.brown_grey": "#8D8468",
    "xkcd.brown_orange": "#B96902",
    "xkcd.brown_red": "#922B05",
    "xkcd.brown_yellow": "#B29705",
    "xkcd.brownish": "#9C6D57",
    "xkcd.brownish_green": "#6A6E09",
    "xkcd.brownish_grey": "#86775F",
    "xkcd.brownish_orange": "#CB7723",
    "xkcd.brownish_pink": "#C27E79",
    "xkcd.brownish_purple": "#76424E",
    "xkcd.brownish_red": "#9E3623",
    "xkcd.brownish_yellow": "#C9B003",
    "xkcd.browny_green": "#6F6C0A",
    "xkcd.browny_orange": "#CA6B02",
    "xkcd.bruise": "#7E4071",
    "xkcd.bubble_gum_pink": "#FF69AF",
    "xkcd.bubblegum": "#FF6CB5",
    "xkcd.bubblegum_pink": "#FE83CC",
    "xkcd.buff": "#FEF69E",
    "xkcd.burgundy": "#610023",
    "xkcd.burnt_orange": "#C04E01",
    "xkcd.burnt_red": "#9F2305",
    "xkcd.burnt_siena": "#B75203",
    "xkcd.burnt_sienna": "#B04E0F",
    "xkcd.burnt_umber": "#A0450E",
    "xkcd.burnt_yellow": "#D5AB09",
    "xkcd.burple": "#6832E3",
    "xkcd.butter": "#FFFF81",
    "xkcd.butter_yellow": "#FFFD74",
    "xkcd.butterscotch": "#FDB147",
    "xkcd.cadet_blue": "#4E7496",
    "xkcd.camel": "#C69F59",
    "xkcd.camo": "#7F8F4E",
    "xkcd.camo_green": "#526525",
    "xkcd.camouflage_green": "#4B6113",
    "xkcd.canary": "#FDFF63",
    "xkcd.canary_yellow": "#FFFE40",
    "xkcd.candy_pink": "#FF63E9",
    "xkcd.caramel": "#AF6F09",
    "xkcd.carmine": "#9D0216",
    "xkcd.carnation": "#FD798F",
    "xkcd.carnation_pink": "#FF7FA7",
    "xkcd.carolina_blue": "#8AB8FE",
    "xkcd.celadon": "#BEFDB7",
    "xkcd.celery": "#C1FD95",
    "xkcd.cement": "#A5A391",
    "xkcd.cerise": "#DE0C62",
    "xkcd.cerulean": "#0485D1",
    "xkcd.cerulean_blue": "#056EEE",
    "xkcd.charcoal": "#343837",
    "xkcd.charcoal_grey": "#3C4142",
    "xkcd.chartreuse": "#C1F80A",
    "xkcd.cherry": "#CF0234",
    "xkcd.cherry_red": "#F7022A",
    "xkcd.chestnut": "#742802",
    "xkcd.chocolate": "#3D1C02",
    "xkcd.chocolate_brown": "#411900",
    "xkcd.cinnamon": "#AC4F06",
    "xkcd.claret": "#680018",
    "xkcd.clay": "#B66A50",
    "xkcd.clay_brown": "#B2713D",
    "xkcd.clear_blue": "#247AFD",
    "xkcd.cloudy_blue": "#ACC2D9",
    "xkcd.cobalt": "#1E488F",
    "xkcd.cobalt_blue": "#030AA7",
    "xkcd.cocoa": "#875F42",
    "xkcd.coffee": "#A6814C",
    "xkcd.cool_blue": "#4984B8",
    "xkcd.cool_green": "#33B864",
    "xkcd.cool_grey": "#95A3A6",
    "xkcd.copper": "#B66325",
    "xkcd.coral": "#FC5A50",
    "xkcd.coral_pink": "#FF6163",
    "xkcd.cornflower": "#6A79F7",
    "xkcd.cornflower_blue": "#5170D7",
    "xkcd.cranberry": "#9E003A",
    "xkcd.cream": "#FFFFC2",
    "xkcd.creme": "#FFFFB6",
    "xkcd.crimson": "#8C000F",
    "xkcd.custard": "#FFFD78",
    "xkcd.cyan": "#00FFFF",
    "xkcd.dandelion": "#FEDF08",
    "xkcd.dark": "#1B2431",
    "xkcd.dark_aqua": "#05696B",
    "xkcd.dark_aquamarine": "#017371",
    "xkcd.dark_beige": "#AC9362",
    "xkcd.dark_blue": "#00035B",
    "xkcd.dark_blue_green": "#005249",
    "xkcd.dark_blue_grey": "#1F3B4D",
    "xkcd.dark_brown": "#341C02",
    "xkcd.dark_coral": "#CF524E",
    "xkcd.dark_cream": "#FFF39A",
    "xkcd.dark_cyan": "#0A888A",
    "xkcd.dark_forest_green": "#002D04",
    "xkcd.dark_fuchsia": "#9D0759",
    "xkcd.dark_gold": "#B59410",
    "xkcd.dark_grass_green": "#388004",
    "xkcd.dark_green": "#033500",
    "xkcd.dark_green_blue": "#1F6357",
    "xkcd.dark_grey": "#363737",
    "xkcd.dark_grey_blue": "#29465B",
    "xkcd.dark_hot_pink": "#D90166",
    "xkcd.dark_indigo": "#1F0954",
    "xkcd.dark_khaki": "#9B8F55",
    "xkcd.dark_lavender": "#856798",
    "xkcd.dark_lilac": "#9C6DA5",
    "xkcd.dark_lime": "#84B701",
    "xkcd.dark_lime_green": "#7EBD01",
    "xkcd.dark_magenta": "#960056",
    "xkcd.dark_maroon": "#3C0008",
    "xkcd.dark_mauve": "#874C62",
    "xkcd.dark_mint": "#48C072",
    "xkcd.dark_mint_green": "#20C073",
    "xkcd.dark_mustard": "#A88905",
    "xkcd.dark_navy": "#000435",
    "xkcd.dark_navy_blue": "#00022E",
    "xkcd.dark_olive": "#373E02",
    "xkcd.dark_olive_green": "#3C4D03",
    "xkcd.dark_orange": "#C65102",
    "xkcd.dark_pastel_green": "#56AE57",
    "xkcd.dark_peach": "#DE7E5D",
    "xkcd.dark_periwinkle": "#665FD1",
    "xkcd.dark_pink": "#CB416B",
    "xkcd.dark_plum": "#3F012C",
    "xkcd.dark_purple": "#35063E",
    "xkcd.dark_red": "#840000",
    "xkcd.dark_rose": "#B5485D",
    "xkcd.dark_royal_blue": "#02066F",
    "xkcd.dark_sage": "#598556",
    "xkcd.dark_salmon": "#C85A53",
    "xkcd.dark_sand": "#A88F59",
    "xkcd.dark_sea_green": "#11875D",
    "xkcd.dark_seafoam": "#1FB57A",
    "xkcd.dark_seafoam_green": "#3EAF76",
    "xkcd.dark_sky_blue": "#448EE4",
    "xkcd.dark_slate_blue": "#214761",
    "xkcd.dark_tan": "#AF884A",
    "xkcd.dark_taupe": "#7F684E",
    "xkcd.dark_teal": "#014D4E",
    "xkcd.dark_turquoise": "#045C5A",
    "xkcd.dark_violet": "#34013F",
    "xkcd.dark_yellow": "#D5B60A",
    "xkcd.dark_yellow_green": "#728F02",
    "xkcd.darkblue": "#030764",
    "xkcd.darkgreen": "#054907",
    "xkcd.darkish_blue": "#014182",
    "xkcd.darkish_green": "#287C37",
    "xkcd.darkish_pink": "#DA467D",
    "xkcd.darkish_purple": "#751973",
    "xkcd.darkish_red": "#A90308",
    "xkcd.deep_aqua": "#08787F",
    "xkcd.deep_blue": "#040273",
    "xkcd.deep_brown": "#410200",
    "xkcd.deep_green": "#02590F",
    "xkcd.deep_lavender": "#8D5EB7",
    "xkcd.deep_lilac": "#966EBD",
    "xkcd.deep_magenta": "#A0025C",
    "xkcd.deep_orange": "#DC4D01",
    "xkcd.deep_pink": "#CB0162",
    "xkcd.deep_purple": "#36013F",
    "xkcd.deep_red": "#9A0200",
    "xkcd.deep_rose": "#C74767",
    "xkcd.deep_sea_blue": "#015482",
    "xkcd.deep_sky_blue": "#0D75F8",
    "xkcd.deep_teal": "#00555A",
    "xkcd.deep_turquoise": "#017374",
    "xkcd.deep_violet": "#490648",
    "xkcd.denim": "#3B638C",
    "xkcd.denim_blue": "#3B5B92",
    "xkcd.desert": "#CCAD60",
    "xkcd.diarrhea": "#9F8303",
    "xkcd.dirt": "#8A6E45",
    "xkcd.dirt_brown": "#836539",
    "xkcd.dirty_blue": "#3F829D",
    "xkcd.dirty_green": "#667E2C",
    "xkcd.dirty_orange": "#C87606",
    "xkcd.dirty_pink": "#CA7B80",
    "xkcd.dirty_purple": "#734A65",
    "xkcd.dirty_yellow": "#CDC50A",
    "xkcd.dodger_blue": "#3E82FC",
    "xkcd.drab": "#828344",
    "xkcd.drab_green": "#749551",
    "xkcd.dried_blood": "#4B0101",
    "xkcd.duck_egg_blue": "#C3FBF4",
    "xkcd.dull_blue": "#49759C",
    "xkcd.dull_brown": "#876E4B",
    "xkcd.dull_green": "#74A662",
    "xkcd.dull_orange": "#D8863B",
    "xkcd.dull_pink": "#D5869D",
    "xkcd.dull_purple": "#84597E",
    "xkcd.dull_red": "#BB3F3F",
    "xkcd.dull_teal": "#5F9E8F",
    "xkcd.dull_yellow": "#EEDC5B",
    "xkcd.dusk": "#4E5481",
    "xkcd.dusk_blue": "#26538D",
    "xkcd.dusky_blue": "#475F94",
    "xkcd.dusky_pink": "#CC7A8B",
    "xkcd.dusky_purple": "#895B7B",
    "xkcd.dusky_rose": "#BA6873",
    "xkcd.dust": "#B2996E",
    "xkcd.dusty_blue": "#5A86AD",
    "xkcd.dusty_green": "#76A973",
    "xkcd.dusty_lavender": "#AC86A8",
    "xkcd.dusty_orange": "#F0833A",
    "xkcd.dusty_pink": "#D58A94",
    "xkcd.dusty_purple": "#825F87",
    "xkcd.dusty_red": "#B9484E",
    "xkcd.dusty_rose": "#C0737A",
    "xkcd.dusty_teal": "#4C9085",
    "xkcd.earth": "#A2653E",
    "xkcd.easter_green": "#8CFD7E",
    "xkcd.easter_purple": "#C071FE",
    "xkcd.ecru": "#FEFFCA",
    "xkcd.egg_shell": "#FFFCC4",
    "xkcd.eggplant": "#380835",
    "xkcd.eggplant_purple": "#430541",
    "xkcd.eggshell": "#FFFFD4",
    "xkcd.eggshell_blue": "#C4FFF7",
    "xkcd.electric_blue": "#0652FF",
    "xkcd.electric_green": "#21FC0D",
    "xkcd.electric_lime": "#A8FF04",
    "xkcd.electric_pink": "#FF0490",
    "xkcd.electric_purple": "#AA23FF",
    "xkcd.emerald": "#01A049",
    "xkcd.emerald_green": "#028F1E",
    "xkcd.evergreen": "#05472A",
    "xkcd.faded_blue": "#658CBB",
    "xkcd.faded_green": "#7BB274",
    "xkcd.faded_orange": "#F0944D",
    "xkcd.faded_pink": "#DE9DAC",
    "xkcd.faded_purple": "#916E99",
    "xkcd.faded_red": "#D3494E",
    "xkcd.faded_yellow": "#FEFF7F",
    "xkcd.fawn": "#CFAF7B",
    "xkcd.fern": "#63A950",
    "xkcd.fern_green": "#548D44",
    "xkcd.fire_engine_red": "#FE0002",
    "xkcd.flat_blue": "#3C73A8",
    "xkcd.flat_green": "#699D4C",
    "xkcd.fluorescent_green": "#08FF08",
    "xkcd.fluro_green": "#0AFF02",
    "xkcd.foam_green": "#90FDA9",
    "xkcd.forest": "#0B5509",
    "xkcd.forest_green": "#06470C",
    "xkcd.forrest_green": "#154406",
    "xkcd.french_blue": "#436BAD",
    "xkcd.fresh_green": "#69D84F",
    "xkcd.frog_green": "#58BC08",
    "xkcd.fuchsia": "#ED0DD9",
    "xkcd.gold": "#DBB40C",
    "xkcd.golden": "#F5BF03",
    "xkcd.golden_brown": "#B27A01",
    "xkcd.golden_rod": "#F9BC08",
    "xkcd.golden_yellow": "#FEC615",
    "xkcd.goldenrod": "#FAC205",
    "xkcd.grape": "#6C3461",
    "xkcd.grape_purple": "#5D1451",
    "xkcd.grapefruit": "#FD5956",
    "xkcd.grass": "#5CAC2D",
    "xkcd.grass_green": "#3F9B0B",
    "xkcd.grassy_green": "#419C03",
    "xkcd.green": "#15B01A",
    "xkcd.green_apple": "#5EDC1F",
    "xkcd.green_blue": "#01C08D",
    "xkcd.green_brown": "#544E03",
    "xkcd.green_grey": "#77926F",
    "xkcd.green_teal": "#0CB577",
    "xkcd.green_yellow": "#B5CE08",
    "xkcd.greenblue": "#23C48B",
    "xkcd.greenish": "#40A368",
    "xkcd.greenish_beige": "#C9D179",
    "xkcd.greenish_blue": "#0B8B87",
    "xkcd.greenish_brown": "#696112",
    "xkcd.greenish_cyan": "#2AFEB7",
    "xkcd.greenish_grey": "#96AE8D",
    "xkcd.greenish_tan": "#BCCB7A",
    "xkcd.greenish_teal": "#32BF84",
    "xkcd.greenish_turquoise": "#00FBB0",
    "xkcd.greenish_yellow": "#CDFD02",
    "xkcd.greeny_blue": "#42B395",
    "xkcd.greeny_brown": "#696006",
    "xkcd.greeny_grey": "#7EA07A",
    "xkcd.greeny_yellow": "#C6F808",
    "xkcd.grey": "#929591",
    "xkcd.grey_blue": "#647D8E",
    "xkcd.grey_brown": "#7F7053",
    "xkcd.grey_green": "#86A17D",
    "xkcd.grey_pink": "#C3909B",
    "xkcd.grey_purple": "#826D8C",
    "xkcd.grey_teal": "#5E9B8A",
    "xkcd.greyblue": "#77A1B5",
    "xkcd.greyish": "#A8A495",
    "xkcd.greyish_blue": "#5E819D",
    "xkcd.greyish_brown": "#7A6A4F",
    "xkcd.greyish_green": "#82A67D",
    "xkcd.greyish_pink": "#C88D94",
    "xkcd.greyish_purple": "#887191",
    "xkcd.greyish_teal": "#719F91",
    "xkcd.gross_green": "#A0BF16",
    "xkcd.gunmetal": "#536267",
    "xkcd.hazel": "#8E7618",
    "xkcd.heather": "#A484AC",
    "xkcd.heliotrope": "#D94FF5",
    "xkcd.highlighter_green": "#1BFC06",
    "xkcd.hospital_green": "#9BE5AA",
    "xkcd.hot_green": "#25FF29",
    "xkcd.hot_magenta": "#F504C9",
    "xkcd.hot_pink": "#FF028D",
    "xkcd.hot_purple": "#CB00F5",
    "xkcd.hunter_green": "#0B4008",
    "xkcd.ice": "#D6FFFA",
    "xkcd.ice_blue": "#D7FFFE",
    "xkcd.icky_green": "#8FAE22",
    "xkcd.indian_red": "#850E04",
    "xkcd.indigo": "#380282",
    "xkcd.indigo_blue": "#3A18B1",
    "xkcd.iris": "#6258C4",
    "xkcd.irish_green": "#019529",
    "xkcd.ivory": "#FFFFCB",
    "xkcd.jade": "#1FA774",
    "xkcd.jade_green": "#2BAF6A",
    "xkcd.jungle_green": "#048243",
    "xkcd.kelley_green": "#009337",
    "xkcd.kelly_green": "#02AB2E",
    "xkcd.kermit_green": "#5CB200",
    "xkcd.key_lime": "#AEFF6E",
    "xkcd.khaki": "#AAA662",
    "xkcd.khaki_green": "#728639",
    "xkcd.kiwi": "#9CEF43",
    "xkcd.kiwi_green": "#8EE53F",
    "xkcd.lavender": "#C79FEF",
    "xkcd.lavender_blue": "#8B88F8",
    "xkcd.lavender_pink": "#DD85D7",
    "xkcd.lawn_green": "#4DA409",
    "xkcd.leaf": "#71AA34",
    "xkcd.leaf_green": "#5CA904",
    "xkcd.leafy_green": "#51B73B",
    "xkcd.leather": "#AC7434",
    "xkcd.lemon": "#FDFF52",
    "xkcd.lemon_green": "#ADF802",
    "xkcd.lemon_lime": "#BFFE28",
    "xkcd.lemon_yellow": "#FDFF38",
    "xkcd.lichen": "#8FB67B",
    "xkcd.light_aqua": "#8CFFDB",
    "xkcd.light_aquamarine": "#7BFDC7",
    "xkcd.light_beige": "#FFFEB6",
    "xkcd.light_blue": "#95D0FC",
    "xkcd.light_blue_green": "#7EFBB3",
    "xkcd.light_blue_grey": "#B7C9E2",
    "xkcd.light_bluish_green": "#76FDA8",
    "xkcd.light_bright_green": "#53FE5C",
    "xkcd.light_brown": "#AD8150",
    "xkcd.light_burgundy": "#A8415B",
    "xkcd.light_cyan": "#ACFFFC",
    "xkcd.light_eggplant": "#894585",
    "xkcd.light_forest_green": "#4F9153",
    "xkcd.light_gold": "#FDDC5C",
    "xkcd.light_grass_green": "#9AF764",
    "xkcd.light_green": "#96F97B",
    "xkcd.light_green_blue": "#56FCA2",
    "xkcd.light_greenish_blue": "#63F7B4",
    "xkcd.light_grey": "#D8DCD6",
    "xkcd.light_grey_blue": "#9DBCD4",
    "xkcd.light_grey_green": "#B7E1A1",
    "xkcd.light_indigo": "#6D5ACF",
    "xkcd.light_khaki": "#E6F2A2",
    "xkcd.light_lavendar": "#EFC0FE",
    "xkcd.light_lavender": "#DFC5FE",
    "xkcd.light_light_blue": "#CAFFFB",
    "xkcd.light_light_green": "#C8FFB0",
    "xkcd.light_lilac": "#EDC8FF",
    "xkcd.light_lime": "#AEFD6C",
    "xkcd.light_lime_green": "#B9FF66",
    "xkcd.light_magenta": "#FA5FF7",
    "xkcd.light_maroon": "#A24857",
    "xkcd.light_mauve": "#C292A1",
    "xkcd.light_mint": "#B6FFBB",
    "xkcd.light_mint_green": "#A6FBB2",
    "xkcd.light_moss_green": "#A6C875",
    "xkcd.light_mustard": "#F7D560",
    "xkcd.light_navy": "#155084",
    "xkcd.light_navy_blue": "#2E5A88",
    "xkcd.light_neon_green": "#4EFD54",
    "xkcd.light_olive": "#ACBF69",
    "xkcd.light_olive_green": "#A4BE5C",
    "xkcd.light_orange": "#FDAA48",
    "xkcd.light_pastel_green": "#B2FBA5",
    "xkcd.light_pea_green": "#C4FE82",
    "xkcd.light_peach": "#FFD8B1",
    "xkcd.light_periwinkle": "#C1C6FC",
    "xkcd.light_pink": "#FFD1DF",
    "xkcd.light_plum": "#9D5783",
    "xkcd.light_purple": "#BF77F6",
    "xkcd.light_red": "#FF474C",
    "xkcd.light_rose": "#FFC5CB",
    "xkcd.light_royal_blue": "#3A2EFE",
    "xkcd.light_sage": "#BCECAC",
    "xkcd.light_salmon": "#FEA993",
    "xkcd.light_sea_green": "#98F6B0",
    "xkcd.light_seafoam": "#A0FEBF",
    "xkcd.light_seafoam_green": "#A7FFB5",
    "xkcd.light_sky_blue": "#C6FCFF",
    "xkcd.light_tan": "#FBEEAC",
    "xkcd.light_teal": "#90E4C1",
    "xkcd.light_turquoise": "#7EF4CC",
    "xkcd.light_urple": "#B36FF6",
    "xkcd.light_violet": "#D6B4FC",
    "xkcd.light_yellow": "#FFFE7A",
    "xkcd.light_yellow_green": "#CCFD7F",
    "xkcd.light_yellowish_green": "#C2FF89",
    "xkcd.lightblue": "#7BC8F6",
    "xkcd.lighter_green": "#75FD63",
    "xkcd.lighter_purple": "#A55AF4",
    "xkcd.lightgreen": "#76FF7B",
    "xkcd.lightish_blue": "#3D7AFD",
    "xkcd.lightish_green": "#61E160",
    "xkcd.lightish_purple": "#A552E6",
    "xkcd.lightish_red": "#FE2F4A",
    "xkcd.lilac": "#CEA2FD",
    "xkcd.liliac": "#C48EFD",
    "xkcd.lime": "#AAFF32",
    "xkcd.lime_green": "#89FE05",
    "xkcd.lime_yellow": "#D0FE1D",
    "xkcd.lipstick": "#D5174E",
    "xkcd.lipstick_red": "#C0022F",
    "xkcd.macaroni_and_cheese": "#EFB435",
    "xkcd.magenta": "#C20078",
    "xkcd.mahogany": "#4A0100",
    "xkcd.maize": "#F4D054",
    "xkcd.mango": "#FFA62B",
    "xkcd.manilla": "#FFFA86",
    "xkcd.marigold": "#FCC006",
    "xkcd.marine": "#042E60",
    "xkcd.marine_blue": "#01386A",
    "xkcd.maroon": "#650021",
    "xkcd.mauve": "#AE7181",
    "xkcd.medium_blue": "#2C6FBB",
    "xkcd.medium_brown": "#7F5112",
    "xkcd.medium_green": "#39AD48",
    "xkcd.medium_grey": "#7D7F7C",
    "xkcd.medium_pink": "#F36196",
    "xkcd.medium_purple": "#9E43A2",
    "xkcd.melon": "#FF7855",
    "xkcd.merlot": "#730039",
    "xkcd.metallic_blue": "#4F738E",
    "xkcd.mid_blue": "#276AB3",
    "xkcd.mid_green": "#50A747",
    "xkcd.midnight": "#03012D",
    "xkcd.midnight_blue": "#020035",
    "xkcd.midnight_purple": "#280137",
    "xkcd.military_green": "#667C3E",
    "xkcd.milk_chocolate": "#7F4E1E",
    "xkcd.mint": "#9FFEB0",
    "xkcd.mint_green": "#8FFF9F",
    "xkcd.minty_green": "#0BF77D",
    "xkcd.mocha": "#9D7651",
    "xkcd.moss": "#769958",
    "xkcd.moss_green": "#658B38",
    "xkcd.mossy_green": "#638B27",
    "xkcd.mud": "#735C12",
    "xkcd.mud_brown": "#60460F",
    "xkcd.mud_green": "#606602",
    "xkcd.muddy_brown": "#886806",
    "xkcd.muddy_green": "#657432",
    "xkcd.muddy_yellow": "#BFAC05",
    "xkcd.mulberry": "#920A4E",
    "xkcd.murky_green": "#6C7A0E",
    "xkcd.mushroom": "#BA9E88",
    "xkcd.mustard": "#CEB301",
    "xkcd.mustard_brown": "#AC7E04",
    "xkcd.mustard_green": "#A8B504",
    "xkcd.mustard_yellow": "#D2BD0A",
    "xkcd.muted_blue": "#3B719F",
    "xkcd.muted_green": "#5FA052",
    "xkcd.muted_pink": "#D1768F",
    "xkcd.muted_purple": "#805B87",
    "xkcd.nasty_green": "#70B23F",
    "xkcd.navy": "#01153E",
    "xkcd.navy_blue": "#001146",
    "xkcd.navy_green": "#35530A",
    "xkcd.neon_blue": "#04D9FF",
    "xkcd.neon_green": "#0CFF0C",
    "xkcd.neon_pink": "#FE019A",
    "xkcd.neon_purple": "#BC13FE",
    "xkcd.neon_red": "#FF073A",
    "xkcd.neon_yellow": "#CFFF04",
    "xkcd.nice_blue": "#107AB0",
    "xkcd.night_blue": "#040348",
    "xkcd.ocean": "#017B92",
    "xkcd.ocean_blue": "#03719C",
    "xkcd.ocean_green": "#3D9973",
    "xkcd.ocher": "#BF9B0C",
    "xkcd.ochre": "#BF9005",
    "xkcd.ocre": "#C69C04",
    "xkcd.off_blue": "#5684AE",
    "xkcd.off_green": "#6BA353",
    "xkcd.off_white": "#FFFFE4",
    "xkcd.off_yellow": "#F1F33F",
    "xkcd.old_pink": "#C77986",
    "xkcd.old_rose": "#C87F89",
    "xkcd.olive": "#6E750E",
    "xkcd.olive_brown": "#645403",
    "xkcd.olive_drab": "#6F7632",
    "xkcd.olive_green": "#677A04",
    "xkcd.olive_yellow": "#C2B709",
    "xkcd.orange": "#F97306",
    "xkcd.orange_brown": "#BE6400",
    "xkcd.orange_pink": "#FF6F52",
    "xkcd.orange_red": "#FD411E",
    "xkcd.orange_yellow": "#FFAD01",
    "xkcd.orangeish": "#FD8D49",
    "xkcd.orangered": "#FE420F",
    "xkcd.orangey_brown": "#B16002",
    "xkcd.orangey_red": "#FA4224",
    "xkcd.orangey_yellow": "#FDB915",
    "xkcd.orangish": "#FC824A",
    "xkcd.orangish_brown": "#B25F03",
    "xkcd.orangish_red": "#F43605",
    "xkcd.orchid": "#C875C4",
    "xkcd.pale": "#FFF9D0",
    "xkcd.pale_aqua": "#B8FFEB",
    "xkcd.pale_blue": "#D0FEFE",
    "xkcd.pale_brown": "#B1916E",
    "xkcd.pale_cyan": "#B7FFFA",
    "xkcd.pale_gold": "#FDDE6C",
    "xkcd.pale_green": "#C7FDB5",
    "xkcd.pale_grey": "#FDFDFE",
    "xkcd.pale_lavender": "#EECFFE",
    "xkcd.pale_light_green": "#B1FC99",
    "xkcd.pale_lilac": "#E4CBFF",
    "xkcd.pale_lime": "#BEFD73",
    "xkcd.pale_lime_green": "#B1FF65",
    "xkcd.pale_magenta": "#D767AD",
    "xkcd.pale_mauve": "#FED0FC",
    "xkcd.pale_olive": "#B9CC81",
    "xkcd.pale_olive_green": "#B1D27B",
    "xkcd.pale_orange": "#FFA756",
    "xkcd.pale_peach": "#FFE5AD",
    "xkcd.pale_pink": "#FFCFDC",
    "xkcd.pale_purple": "#B790D4",
    "xkcd.pale_red": "#D9544D",
    "xkcd.pale_rose": "#FDC1C5",
    "xkcd.pale_salmon": "#FFB19A",
    "xkcd.pale_sky_blue": "#BDF6FE",
    "xkcd.pale_teal": "#82CBB2",
    "xkcd.pale_turquoise": "#A5FBD5",
    "xkcd.pale_violet": "#CEAEFA",
    "xkcd.pale_yellow": "#FFFF84",
    "xkcd.parchment": "#FEFCAF",
    "xkcd.pastel_blue": "#A2BFFE",
    "xkcd.pastel_green": "#B0FF9D",
    "xkcd.pastel_orange": "#FF964F",
    "xkcd.pastel_pink": "#FFBACD",
    "xkcd.pastel_purple": "#CAA0FF",
    "xkcd.pastel_red": "#DB5856",
    "xkcd.pastel_yellow": "#FFFE71",
    "xkcd.pea": "#A4BF20",
    "xkcd.pea_green": "#8EAB12",
    "xkcd.pea_soup": "#929901",
    "xkcd.pea_soup_green": "#94A617",
    "xkcd.peach": "#FFB07C",
    "xkcd.peachy_pink": "#FF9A8A",
    "xkcd.peacock_blue": "#016795",
    "xkcd.pear": "#CBF85F",
    "xkcd.periwinkle": "#8E82FE",
    "xkcd.periwinkle_blue": "#8F99FB",
    "xkcd.perrywinkle": "#8F8CE7",
    "xkcd.petrol": "#005F6A",
    "xkcd.pig_pink": "#E78EA5",
    "xkcd.pine": "#2B5D34",
    "xkcd.pine_green": "#0A481E",
    "xkcd.pink": "#FF81C0",
    "xkcd.pink_purple": "#EF1DE7",
    "xkcd.pink_red": "#F5054F",
    "xkcd.pinkish": "#D46A7E",
    "xkcd.pinkish_brown": "#B17261",
    "xkcd.pinkish_grey": "#C8ACA9",
    "xkcd.pinkish_orange": "#FF724C",
    "xkcd.pinkish_purple": "#D648D7",
    "xkcd.pinkish_red": "#F10C45",
    "xkcd.pinkish_tan": "#D99B82",
    "xkcd.pinky": "#FC86AA",
    "xkcd.pinky_purple": "#C94CBE",
    "xkcd.pinky_red": "#FC2647",
    "xkcd.piss_yellow": "#DDD618",
    "xkcd.pistachio": "#C0FA8B",
    "xkcd.plum": "#580F41",
    "xkcd.plum_purple": "#4E0550",
    "xkcd.poison_green": "#40FD14",
    "xkcd.poo": "#8F7303",
    "xkcd.poo_brown": "#885F01",
    "xkcd.poop": "#7F5E00",
    "xkcd.poop_brown": "#7A5901",
    "xkcd.poop_green": "#6F7C00",
    "xkcd.powder_blue": "#B1D1FC",
    "xkcd.powder_pink": "#FFB2D0",
    "xkcd.primary_blue": "#0804F9",
    "xkcd.prussian_blue": "#004577",
    "xkcd.puce": "#A57E52",
    "xkcd.puke": "#A5A502",
    "xkcd.puke_brown": "#947706",
    "xkcd.puke_green": "#9AAE07",
    "xkcd.puke_yellow": "#C2BE0E",
    "xkcd.pumpkin": "#E17701",
    "xkcd.pumpkin_orange": "#FB7D07",
    "xkcd.pure_blue": "#0203E2",
    "xkcd.purple": "#7E1E9C",
    "xkcd.purple_blue": "#5D21D0",
    "xkcd.purple_brown": "#673A3F",
    "xkcd.purple_grey": "#866F85",
    "xkcd.purple_pink": "#D725DE",
    "xkcd.purple_red": "#990147",
    "xkcd.purpleish": "#98568D",
    "xkcd.purpleish_blue": "#6140EF",
    "xkcd.purpleish_pink": "#DF4EC8",
    "xkcd.purpley": "#8756E4",
    "xkcd.purpley_blue": "#5F34E7",
    "xkcd.purpley_grey": "#947E94",
    "xkcd.purpley_pink": "#C83CB9",
    "xkcd.purplish": "#94568C",
    "xkcd.purplish_blue": "#601EF9",
    "xkcd.purplish_brown": "#6B4247",
    "xkcd.purplish_grey": "#7A687F",
    "xkcd.purplish_pink": "#CE5DAE",
    "xkcd.purplish_red": "#B0054B",
    "xkcd.purply": "#983FB2",
    "xkcd.purply_blue": "#661AEE",
    "xkcd.purply_pink": "#F075E6",
    "xkcd.putty": "#BEAE8A",
    "xkcd.racing_green": "#014600",
    "xkcd.radioactive_green": "#2CFA1F",
    "xkcd.raspberry": "#B00149",
    "xkcd.raw_sienna": "#9A6200",
    "xkcd.raw_umber": "#A75E09",
    "xkcd.really_light_blue": "#D4FFFF",
    "xkcd.red": "#E50000",
    "xkcd.red_brown": "#8B2E16",
    "xkcd.red_orange": "#FD3C06",
    "xkcd.red_pink": "#FA2A55",
    "xkcd.red_purple": "#820747",
    "xkcd.red_violet": "#9E0168",
    "xkcd.red_wine": "#8C0034",
    "xkcd.reddish": "#C44240",
    "xkcd.reddish_brown": "#7F2B0A",
    "xkcd.reddish_grey": "#997570",
    "xkcd.reddish_orange": "#F8481C",
    "xkcd.reddish_pink": "#FE2C54",
    "xkcd.reddish_purple": "#910951",
    "xkcd.reddy_brown": "#6E1005",
    "xkcd.rich_blue": "#021BF9",
    "xkcd.rich_purple": "#720058",
    "xkcd.robin_egg_blue": "#8AF1FE",
    "xkcd.robins_egg": "#6DEDFD",
    "xkcd.robins_egg_blue": "#98EFF9",
    "xkcd.rosa": "#FE86A4",
    "xkcd.rose": "#CF6275",
    "xkcd.rose_pink": "#F7879A",
    "xkcd.rose_red": "#BE013C",
    "xkcd.rosy_pink": "#F6688E",
    "xkcd.rouge": "#AB1239",
    "xkcd.royal": "#0C1793",
    "xkcd.royal_blue": "#0504AA",
    "xkcd.royal_purple": "#4B006E",
    "xkcd.ruby": "#CA0147",
    "xkcd.russet": "#A13905",
    "xkcd.rust": "#A83C09",
    "xkcd.rust_brown": "#8B3103",
    "xkcd.rust_orange": "#C45508",
    "xkcd.rust_red": "#AA2704",
    "xkcd.rusty_orange": "#CD5909",
    "xkcd.rusty_red": "#AF2F0D",
    "xkcd.saffron": "#FEB209",
    "xkcd.sage": "#87AE73",
    "xkcd.sage_green": "#88B378",
    "xkcd.salmon": "#FF796C",
    "xkcd.salmon_pink": "#FE7B7C",
    "xkcd.sand": "#E2CA76",
    "xkcd.sand_brown": "#CBA560",
    "xkcd.sand_yellow": "#FCE166",
    "xkcd.sandstone": "#C9AE74",
    "xkcd.sandy": "#F1DA7A",
    "xkcd.sandy_brown": "#C4A661",
    "xkcd.sandy_yellow": "#FDEE73",
    "xkcd.sap_green": "#5C8B15",
    "xkcd.sapphire": "#2138AB",
    "xkcd.scarlet": "#BE0119",
    "xkcd.sea": "#3C9992",
    "xkcd.sea_blue": "#047495",
    "xkcd.sea_green": "#53FCA1",
    "xkcd.seafoam": "#80F9AD",
    "xkcd.seafoam_blue": "#78D1B6",
    "xkcd.seafoam_green": "#7AF9AB",
    "xkcd.seaweed": "#18D17B",
    "xkcd.seaweed_green": "#35AD6B",
    "xkcd.sepia": "#985E2B",
    "xkcd.shamrock": "#01B44C",
    "xkcd.shamrock_green": "#02C14D",
    "xkcd.shit": "#7F5F00",
    "xkcd.shit_brown": "#7B5804",
    "xkcd.shit_green": "#758000",
    "xkcd.shocking_pink": "#FE02A2",
    "xkcd.sick_green": "#9DB92C",
    "xkcd.sickly_green": "#94B21C",
    "xkcd.sickly_yellow": "#D0E429",
    "xkcd.sienna": "#A9561E",
    "xkcd.silver": "#C5C9C7",
    "xkcd.sky": "#82CAFC",
    "xkcd.sky_blue": "#75BBFD",
    "xkcd.slate": "#516572",
    "xkcd.slate_blue": "#5B7C99",
    "xkcd.slate_green": "#658D6D",
    "xkcd.slate_grey": "#59656D",
    "xkcd.slime_green": "#99CC04",
    "xkcd.snot": "#ACBB0D",
    "xkcd.snot_green": "#9DC100",
    "xkcd.soft_blue": "#6488EA",
    "xkcd.soft_green": "#6FC276",
    "xkcd.soft_pink": "#FDB0C0",
    "xkcd.soft_purple": "#A66FB5",
    "xkcd.spearmint": "#1EF876",
    "xkcd.spring_green": "#A9F971",
    "xkcd.spruce": "#0A5F38",
    "xkcd.squash": "#F2AB15",
    "xkcd.steel": "#738595",
    "xkcd.steel_blue": "#5A7D9A",
    "xkcd.steel_grey": "#6F828A",
    "xkcd.stone": "#ADA587",
    "xkcd.stormy_blue": "#507B9C",
    "xkcd.straw": "#FCF679",
    "xkcd.strawberry": "#FB2943",
    "xkcd.strong_blue": "#0C06F7",
    "xkcd.strong_pink": "#FF0789",
    "xkcd.sun_yellow": "#FFDF22",
    "xkcd.sunflower": "#FFC512",
    "xkcd.sunflower_yellow": "#FFDA03",
    "xkcd.sunny_yellow": "#FFF917",
    "xkcd.sunshine_yellow": "#FFFD37",
    "xkcd.swamp": "#698339",
    "xkcd.swamp_green": "#748500",
    "xkcd.tan": "#D1B26F",
    "xkcd.tan_brown": "#AB7E4C",
    "xkcd.tan_green": "#A9BE70",
    "xkcd.tangerine": "#FF9408",
    "xkcd.taupe": "#B9A281",
    "xkcd.tea": "#65AB7C",
    "xkcd.tea_green": "#BDF8A3",
    "xkcd.teal": "#029386",
    "xkcd.teal_blue": "#01889F",
    "xkcd.teal_green": "#25A36F",
    "xkcd.tealish": "#24BCA8",
    "xkcd.tealish_green": "#0CDC73",
    "xkcd.terra_cotta": "#C9643B",
    "xkcd.terracota": "#CB6843",
    "xkcd.terracotta": "#CA6641",
    "xkcd.tiffany_blue": "#7BF2DA",
    "xkcd.tomato": "#EF4026",
    "xkcd.tomato_red": "#EC2D01",
    "xkcd.topaz": "#13BBAF",
    "xkcd.toupe": "#C7AC7D",
    "xkcd.toxic_green": "#61DE2A",
    "xkcd.tree_green": "#2A7E19",
    "xkcd.true_blue": "#010FCC",
    "xkcd.true_green": "#089404",
    "xkcd.turquoise": "#06C2AC",
    "xkcd.turquoise_blue": "#06B1C4",
    "xkcd.turquoise_green": "#04F489",
    "xkcd.turtle_green": "#75B84F",
    "xkcd.twilight": "#4E518B",
    "xkcd.twilight_blue": "#0A437A",
    "xkcd.ugly_blue": "#31668A",
    "xkcd.ugly_brown": "#7D7103",
    "xkcd.ugly_green": "#7A9703",
    "xkcd.ugly_pink": "#CD7584",
    "xkcd.ugly_purple": "#A442A0",
    "xkcd.ugly_yellow": "#D0C101",
    "xkcd.ultramarine": "#2000B1",
    "xkcd.ultramarine_blue": "#1805DB",
    "xkcd.umber": "#B26400",
    "xkcd.velvet": "#750851",
    "xkcd.vermillion": "#F4320C",
    "xkcd.very_dark_blue": "#000133",
    "xkcd.very_dark_brown": "#1D0200",
    "xkcd.very_dark_green": "#062E03",
    "xkcd.very_dark_purple": "#2A0134",
    "xkcd.very_light_blue": "#D5FFFF",
    "xkcd.very_light_brown": "#D3B683",
    "xkcd.very_light_green": "#D1FFBD",
    "xkcd.very_light_pink": "#FFF4F2",
    "xkcd.very_light_purple": "#F6CEFC",
    "xkcd.very_pale_blue": "#D6FFFE",
    "xkcd.very_pale_green": "#CFFDBC",
    "xkcd.vibrant_blue": "#0339F8",
    "xkcd.vibrant_green": "#0ADD08",
    "xkcd.vibrant_purple": "#AD03DE",
    "xkcd.violet": "#9A0EEA",
    "xkcd.violet_blue": "#510AC9",
    "xkcd.violet_pink": "#FB5FFC",
    "xkcd.violet_red": "#A50055",
    "xkcd.viridian": "#1E9167",
    "xkcd.vivid_blue": "#152EFF",
    "xkcd.vivid_green": "#2FEF10",
    "xkcd.vivid_purple": "#9900FA",
    "xkcd.vomit": "#A2A415",
    "xkcd.vomit_green": "#89A203",
    "xkcd.vomit_yellow": "#C7C10C",
    "xkcd.warm_blue": "#4B57DB",
    "xkcd.warm_brown": "#964E02",
    "xkcd.warm_grey": "#978A84",
    "xkcd.warm_pink": "#FB5581",
    "xkcd.warm_purple": "#952E8F",
    "xkcd.washed_out_green": "#BCF5A6",
    "xkcd.water_blue": "#0E87CC",
    "xkcd.watermelon": "#FD4659",
    "xkcd.weird_green": "#3AE57F",
    "xkcd.wheat": "#FBDD7E",
    "xkcd.white": "#FFFFFF",
    "xkcd.windows_blue": "#3778BF",
    "xkcd.wine": "#80013F",
    "xkcd.wine_red": "#7B0323",
    "xkcd.wintergreen": "#20F986",
    "xkcd.wisteria": "#A87DC2",
    "xkcd.yellow": "#FFFF14",
    "xkcd.yellow_brown": "#B79400",
    "xkcd.yellow_green": "#C8FD3D",
    "xkcd.yellow_ochre": "#CB9D06",
    "xkcd.yellow_orange": "#FCB001",
    "xkcd.yellow_tan": "#FFE36E",
    "xkcd.yellowgreen": "#BBF90F",
    "xkcd.yellowish": "#FAEE66",
    "xkcd.yellowish_brown": "#9B7A01",
    "xkcd.yellowish_green": "#B0DD16",
    "xkcd.yellowish_orange": "#FFAB0F",
    "xkcd.yellowish_tan": "#FCFC81",
    "xkcd.yellowy_brown": "#AE8B0C",
    "xkcd.yellowy_green": "#BFF128",
}
