"""Colormap definitions for different plotting libraries."""

# Plotly builtin colormaps (state: v2.5.0)
# - https://plot.ly/python/builtin-colorscales/
# - https://github.com/plotly/plotly.js/blob/master/src/components/colorscale/scales.js
PLOTLY_BUILTIN_COLORMAPS = {
    'aggrnyl': 'aggrnyl',
    'agsunset': 'agsunset',
    'algae': 'algae',
    'amp': 'amp',
    'armyrose': 'armyrose',
    'balance': 'balance',
    'blackbody': 'Blackbody',
    'bluered': 'Bluered',
    'blues': 'Blues',
    'blugrn': 'blugrn',
    'bluyl': 'bluyl',
    'brbg': 'brbg',
    'brwnyl': 'brwnyl',
    'bugn': 'bugn',
    'bupu': 'bupu',
    'burg': 'burg',
    'burgyl': 'burgyl',
    'cividis': 'Cividis',
    'curl': 'curl',
    'darkmint': 'darkmint',
    'deep': 'deep',
    'delta': 'delta',
    'dense': 'dense',
    'earth': 'Earth',
    'edge': 'edge',
    'electric': 'Electric',
    'emrld': 'emrld',
    'fall': 'fall',
    'geyser': 'geyser',
    'gnbu': 'gnbu',
    'gray': 'gray',
    'greens': 'Greens',
    'greys': 'Greys',
    'haline': 'haline',
    'hot': 'Hot',
    'hsv': 'hsv',
    'ice': 'ice',
    'icefire': 'icefire',
    'inferno': 'inferno',
    'jet': 'Jet',
    'magenta': 'magenta',
    'magma': 'magma',
    'matter': 'matter',
    'mint': 'mint',
    'mrybm': 'mrybm',
    'mygbm': 'mygbm',
    'oranges': 'oranges',
    'orrd': 'orrd',
    'oryel': 'oryel',
    'peach': 'peach',
    'phase': 'phase',
    'picnic': 'Picnic',
    'pinkyl': 'pinkyl',
    'piyg': 'piyg',
    'plasma': 'plasma',
    'plotly3': 'plotly3',
    'portland': 'Portland',
    'prgn': 'prgn',
    'pubu': 'pubu',
    'pubugn': 'pubugn',
    'puor': 'puor',
    'purd': 'purd',
    'purp': 'purp',
    'purples': 'purples',
    'purpor': 'purpor',
    'rainbow': 'Rainbow',
    'rdbu': 'RdBu',
    'rdgy': 'rdgy',
    'rdpu': 'rdpu',
    'rdylbu': 'rdylbu',
    'rdylgn': 'rdylgn',
    'redor': 'redor',
    'reds': 'Reds',
    'solar': 'solar',
    'spectral': 'spectral',
    'speed': 'speed',
    'sunset': 'sunset',
    'sunsetdark': 'sunsetdark',
    'teal': 'teal',
    'tealgrn': 'tealgrn',
    'tealrose': 'tealrose',
    'tempo': 'tempo',
    'temps': 'temps',
    'thermal': 'thermal',
    'tropic': 'tropic',
    'turbid': 'turbid',
    'twilight': 'twilight',
    'viridis': 'Viridis',
    'ylgn': 'ylgn',
    'ylgnbu': 'YlGnBu',
    'ylorbr': 'ylorbr',
    'ylorrd': 'YlOrRd',
}

# Matplotlib builtin colormaps (state: v3)
MATPLOTLIB_BUILTIN_COLORMAPS = {
    'accent': 'Accent',
    'blues': 'Blues',
    'brbg': 'BrBG',
    'bugn': 'BuGn',
    'bupu': 'BuPu',
    'cmrmap': 'CMRmap',
    'dark2': 'Dark2',
    'gnbu': 'GnBu',
    'greens': 'Greens',
    'greys': 'Greys',
    'orrd': 'OrRd',
    'oranges': 'Oranges',
    'prgn': 'PRGn',
    'paired': 'Paired',
    'pastel1': 'Pastel1',
    'pastel2': 'Pastel2',
    'piyg': 'PiYG',
    'pubu': 'PuBu',
    'pubugn': 'PuBuGn',
    'puor': 'PuOr',
    'purd': 'PuRd',
    'purples': 'Purples',
    'rdbu': 'RdBu',
    'rdgy': 'RdGy',
    'rdpu': 'RdPu',
    'rdylbu': 'RdYlBu',
    'rdylgn': 'RdYlGn',
    'reds': 'Reds',
    'set1': 'Set1',
    'set2': 'Set2',
    'set3': 'Set3',
    'spectral': 'Spectral',
    'wistia': 'Wistia',
    'ylgn': 'YlGn',
    'ylgnbu': 'YlGnBu',
    'ylorbr': 'YlOrBr',
    'ylorrd': 'YlOrRd',
    'afmhot': 'afmhot',
    'autumn': 'autumn',
    'binary': 'binary',
    'bone': 'bone',
    'brg': 'brg',
    'bwr': 'bwr',
    'cividis': 'cividis',
    'cool': 'cool',
    'coolwarm': 'coolwarm',
    'copper': 'copper',
    'cubehelix': 'cubehelix',
    'flag': 'flag',
    'gist_earth': 'gist_earth',
    'gist_gray': 'gist_gray',
    'gist_heat': 'gist_heat',
    'gist_ncar': 'gist_ncar',
    'gist_rainbow': 'gist_rainbow',
    'gist_stern': 'gist_stern',
    'gist_yarg': 'gist_yarg',
    'gnuplot': 'gnuplot',
    'gnuplot2': 'gnuplot2',
    'gray': 'gray',
    'hot': 'hot',
    'hsv': 'hsv',
    'inferno': 'inferno',
    'jet': 'jet',
    'magma': 'magma',
    'nipy_spectral': 'nipy_spectral',
    'ocean': 'ocean',
    'pink': 'pink',
    'plasma': 'plasma',
    'prism': 'prism',
    'rainbow': 'rainbow',
    'seismic': 'seismic',
    'spring': 'spring',
    'summer': 'summer',
    'tab10': 'tab10',
    'tab20': 'tab20',
    'tab20b': 'tab20b',
    'tab20c': 'tab20c',
    'terrain': 'terrain',
    'twilight': 'twilight',
    'twilight_shifted': 'twilight_shifted',
    'viridis': 'viridis',
    'winter': 'winter',
}

# D3 builtin colormaps
D3_BUILTIN_COLORMAPS = {
    'blues': 'Blues',
    'greens': 'Greens',
    'greys': 'Greys',
    'oranges': 'Oranges',
    'purples': 'Purples',
    'reds': 'Reds',
    'turbo': 'Turbo',
    'viridis': 'Viridis',
    'inferno': 'Inferno',
    'magma': 'Magma',
    'plasma': 'Plasma',
    'cividis': 'Cividis',
    'warm': 'Warm',
    'cool': 'Cool',
    'cubehelix': 'Cubehelix',
    'bugn': 'BuGn',
    'bupu': 'BuPu',
    'gnbu': 'GnBu',
    'orrd': 'OrRd',
    'pubugn': 'PuBuGn',
    'pubu': 'PuBu',
    'purd': 'PuRd',
    'rdpu': 'RdPu',
    'ylgnbu': 'YlGnBu',
    'ylgn': 'YlGn',
    'ylorbr': 'YlOrBr',
    'ylorrd': 'YlOrRd',
    'brbg': 'BrBG',
    'prgn': 'PRGn',
    'piyg': 'PiYG',
    'puor': 'PuOr',
    'rdbu': 'RdBu',
    'rdgy': 'RdGy',
    'rdylbu': 'RdYlBu',
    'rdylgn': 'RdYlGn',
    'spectral': 'Spectral',
    'rainbow': 'Rainbow',
    'sinebow': 'Sinebow',
}

# Plotly custom colormaps
PLOTLY_EXTERNAL_COLORMAPS = {
    # Matplotlib colormaps converted for Plotly
    'accent': [
        [0.0, 'rgb(127,201,127)'],
        [0.00392, 'rgb(127,201,127)'],
        [0.00784, 'rgb(127,201,127)'],
        [0.01176, 'rgb(127,201,127)'],
        [0.01569, 'rgb(127,201,127)'],
        [0.01961, 'rgb(127,201,127)'],
        [0.02353, 'rgb(127,201,127)'],
        [0.02745, 'rgb(127,201,127)'],
        [0.03137, 'rgb(127,201,127)'],
        [0.03529, 'rgb(127,201,127)'],
        [0.03922, 'rgb(127,201,127)'],
        [0.04314, 'rgb(127,201,127)'],
        [0.04706, 'rgb(127,201,127)'],
        [0.05098, 'rgb(127,201,127)'],
        [0.0549, 'rgb(127,201,127)'],
        [0.05882, 'rgb(127,201,127)'],
        [0.06275, 'rgb(127,201,127)'],
        [0.06667, 'rgb(127,201,127)'],
        [0.07059, 'rgb(127,201,127)'],
        [0.07451, 'rgb(127,201,127)'],
        [0.07843, 'rgb(127,201,127)'],
        [0.08235, 'rgb(127,201,127)'],
        [0.08627, 'rgb(127,201,127)'],
        [0.0902, 'rgb(127,201,127)'],
        [0.09412, 'rgb(127,201,127)'],
        [0.09804, 'rgb(127,201,127)'],
        [0.10196, 'rgb(127,201,127)'],
        [0.10588, 'rgb(127,201,127)'],
        [0.1098, 'rgb(127,201,127)'],
        [0.11373, 'rgb(127,201,127)'],
        [0.11765, 'rgb(127,201,127)'],
        [0.12157, 'rgb(127,201,127)'],
        [0.12549, 'rgb(190,174,212)'],
        [0.12941, 'rgb(190,174,212)'],
        [0.13333, 'rgb(190,174,212)'],
        [0.13725, 'rgb(190,174,212)'],
        [0.14118, 'rgb(190,174,212)'],
        [0.1451, 'rgb(190,174,212)'],
        [0.14902, 'rgb(190,174,212)'],
        [0.15294, 'rgb(190,174,212)'],
        [0.15686, 'rgb(190,174,212)'],
        [0.16078, 'rgb(190,174,212)'],
        [0.16471, 'rgb(190,174,212)'],
        [0.16863, 'rgb(190,174,212)'],
        [0.17255, 'rgb(190,174,212)'],
        [0.17647, 'rgb(190,174,212)'],
        [0.18039, 'rgb(190,174,212)'],
        [0.18431, 'rgb(190,174,212)'],
        [0.18824, 'rgb(190,174,212)'],
        [0.19216, 'rgb(190,174,212)'],
        [0.19608, 'rgb(190,174,212)'],
        [0.2, 'rgb(190,174,212)'],
        [0.20392, 'rgb(190,174,212)'],
        [0.20784, 'rgb(190,174,212)'],
        [0.21176, 'rgb(190,174,212)'],
        [0.21569, 'rgb(190,174,212)'],
        [0.21961, 'rgb(190,174,212)'],
        [0.22353, 'rgb(190,174,212)'],
        [0.22745, 'rgb(190,174,212)'],
        [0.23137, 'rgb(190,174,212)'],
        [0.23529, 'rgb(190,174,212)'],
        [0.23922, 'rgb(190,174,212)'],
        [0.24314, 'rgb(190,174,212)'],
        [0.24706, 'rgb(190,174,212)'],
        [0.25098, 'rgb(253,192,134)'],
        [0.2549, 'rgb(253,192,134)'],
        [0.25882, 'rgb(253,192,134)'],
        [0.26275, 'rgb(253,192,134)'],
        [0.26667, 'rgb(253,192,134)'],
        [0.27059, 'rgb(253,192,134)'],
        [0.27451, 'rgb(253,192,134)'],
        [0.27843, 'rgb(253,192,134)'],
        [0.28235, 'rgb(253,192,134)'],
        [0.28627, 'rgb(253,192,134)'],
        [0.2902, 'rgb(253,192,134)'],
        [0.29412, 'rgb(253,192,134)'],
        [0.29804, 'rgb(253,192,134)'],
        [0.30196, 'rgb(253,192,134)'],
        [0.30588, 'rgb(253,192,134)'],
        [0.3098, 'rgb(253,192,134)'],
        [0.31373, 'rgb(253,192,134)'],
        [0.31765, 'rgb(253,192,134)'],
        [0.32157, 'rgb(253,192,134)'],
        [0.32549, 'rgb(253,192,134)'],
        [0.32941, 'rgb(253,192,134)'],
        [0.33333, 'rgb(253,192,134)'],
        [0.33725, 'rgb(253,192,134)'],
        [0.34118, 'rgb(253,192,134)'],
        [0.3451, 'rgb(253,192,134)'],
        [0.34902, 'rgb(253,192,134)'],
        [0.35294, 'rgb(253,192,134)'],
        [0.35686, 'rgb(253,192,134)'],
        [0.36078, 'rgb(253,192,134)'],
        [0.36471, 'rgb(253,192,134)'],
        [0.36863, 'rgb(253,192,134)'],
        [0.37255, 'rgb(253,192,134)'],
        [0.37647, 'rgb(255,255,153)'],
        [0.38039, 'rgb(255,255,153)'],
        [0.38431, 'rgb(255,255,153)'],
        [0.38824, 'rgb(255,255,153)'],
        [0.39216, 'rgb(255,255,153)'],
        [0.39608, 'rgb(255,255,153)'],
        [0.4, 'rgb(255,255,153)'],
        [0.40392, 'rgb(255,255,153)'],
        [0.40784, 'rgb(255,255,153)'],
        [0.41176, 'rgb(255,255,153)'],
        [0.41569, 'rgb(255,255,153)'],
        [0.41961, 'rgb(255,255,153)'],
        [0.42353, 'rgb(255,255,153)'],
        [0.42745, 'rgb(255,255,153)'],
        [0.43137, 'rgb(255,255,153)'],
        [0.43529, 'rgb(255,255,153)'],
        [0.43922, 'rgb(255,255,153)'],
        [0.44314, 'rgb(255,255,153)'],
        [0.44706, 'rgb(255,255,153)'],
        [0.45098, 'rgb(255,255,153)'],
        [0.4549, 'rgb(255,255,153)'],
        [0.45882, 'rgb(255,255,153)'],
        [0.46275, 'rgb(255,255,153)'],
        [0.46667, 'rgb(255,255,153)'],
        [0.47059, 'rgb(255,255,153)'],
        [0.47451, 'rgb(255,255,153)'],
        [0.47843, 'rgb(255,255,153)'],
        [0.48235, 'rgb(255,255,153)'],
        [0.48627, 'rgb(255,255,153)'],
        [0.4902, 'rgb(255,255,153)'],
        [0.49412, 'rgb(255,255,153)'],
        [0.49804, 'rgb(255,255,153)'],
        [0.50196, 'rgb(56,108,176)'],
        [0.50588, 'rgb(56,108,176)'],
        [0.5098, 'rgb(56,108,176)'],
        [0.51373, 'rgb(56,108,176)'],
        [0.51765, 'rgb(56,108,176)'],
        [0.52157, 'rgb(56,108,176)'],
        [0.52549, 'rgb(56,108,176)'],
        [0.52941, 'rgb(56,108,176)'],
        [0.53333, 'rgb(56,108,176)'],
        [0.53725, 'rgb(56,108,176)'],
        [0.54118, 'rgb(56,108,176)'],
        [0.5451, 'rgb(56,108,176)'],
        [0.54902, 'rgb(56,108,176)'],
        [0.55294, 'rgb(56,108,176)'],
        [0.55686, 'rgb(56,108,176)'],
        [0.56078, 'rgb(56,108,176)'],
        [0.56471, 'rgb(56,108,176)'],
        [0.56863, 'rgb(56,108,176)'],
        [0.57255, 'rgb(56,108,176)'],
        [0.57647, 'rgb(56,108,176)'],
        [0.58039, 'rgb(56,108,176)'],
        [0.58431, 'rgb(56,108,176)'],
        [0.58824, 'rgb(56,108,176)'],
        [0.59216, 'rgb(56,108,176)'],
        [0.59608, 'rgb(56,108,176)'],
        [0.6, 'rgb(56,108,176)'],
        [0.60392, 'rgb(56,108,176)'],
        [0.60784, 'rgb(56,108,176)'],
        [0.61176, 'rgb(56,108,176)'],
        [0.61569, 'rgb(56,108,176)'],
        [0.61961, 'rgb(56,108,176)'],
        [0.62353, 'rgb(56,108,176)'],
        [0.62745, 'rgb(240,2,127)'],
        [0.63137, 'rgb(240,2,127)'],
        [0.63529, 'rgb(240,2,127)'],
        [0.63922, 'rgb(240,2,127)'],
        [0.64314, 'rgb(240,2,127)'],
        [0.64706, 'rgb(240,2,127)'],
        [0.65098, 'rgb(240,2,127)'],
        [0.6549, 'rgb(240,2,127)'],
        [0.65882, 'rgb(240,2,127)'],
        [0.66275, 'rgb(240,2,127)'],
        [0.66667, 'rgb(240,2,127)'],
        [0.67059, 'rgb(240,2,127)'],
        [0.67451, 'rgb(240,2,127)'],
        [0.67843, 'rgb(240,2,127)'],
        [0.68235, 'rgb(240,2,127)'],
        [0.68627, 'rgb(240,2,127)'],
        [0.6902, 'rgb(240,2,127)'],
        [0.69412, 'rgb(240,2,127)'],
        [0.69804, 'rgb(240,2,127)'],
        [0.70196, 'rgb(240,2,127)'],
        [0.70588, 'rgb(240,2,127)'],
        [0.7098, 'rgb(240,2,127)'],
        [0.71373, 'rgb(240,2,127)'],
        [0.71765, 'rgb(240,2,127)'],
        [0.72157, 'rgb(240,2,127)'],
        [0.72549, 'rgb(240,2,127)'],
        [0.72941, 'rgb(240,2,127)'],
        [0.73333, 'rgb(240,2,127)'],
        [0.73725, 'rgb(240,2,127)'],
        [0.74118, 'rgb(240,2,127)'],
        [0.7451, 'rgb(240,2,127)'],
        [0.74902, 'rgb(240,2,127)'],
        [0.75294, 'rgb(191,91,22)'],
        [0.75686, 'rgb(191,91,22)'],
        [0.76078, 'rgb(191,91,22)'],
        [0.76471, 'rgb(191,91,22)'],
        [0.76863, 'rgb(191,91,22)'],
        [0.77255, 'rgb(191,91,22)'],
        [0.77647, 'rgb(191,91,22)'],
        [0.78039, 'rgb(191,91,22)'],
        [0.78431, 'rgb(191,91,22)'],
        [0.78824, 'rgb(191,91,22)'],
        [0.79216, 'rgb(191,91,22)'],
        [0.79608, 'rgb(191,91,22)'],
        [0.8, 'rgb(191,91,22)'],
        [0.80392, 'rgb(191,91,22)'],
        [0.80784, 'rgb(191,91,22)'],
        [0.81176, 'rgb(191,91,22)'],
        [0.81569, 'rgb(191,91,22)'],
        [0.81961, 'rgb(191,91,22)'],
        [0.82353, 'rgb(191,91,22)'],
        [0.82745, 'rgb(191,91,22)'],
        [0.83137, 'rgb(191,91,22)'],
        [0.83529, 'rgb(191,91,22)'],
        [0.83922, 'rgb(191,91,22)'],
        [0.84314, 'rgb(191,91,22)'],
        [0.84706, 'rgb(191,91,22)'],
        [0.85098, 'rgb(191,91,22)'],
        [0.8549, 'rgb(191,91,22)'],
        [0.85882, 'rgb(191,91,22)'],
        [0.86275, 'rgb(191,91,22)'],
        [0.86667, 'rgb(191,91,22)'],
        [0.87059, 'rgb(191,91,22)'],
        [0.87451, 'rgb(191,91,22)'],
        [0.87843, 'rgb(102,102,102)'],
        [0.88235, 'rgb(102,102,102)'],
        [0.88627, 'rgb(102,102,102)'],
        [0.8902, 'rgb(102,102,102)'],
        [0.89412, 'rgb(102,102,102)'],
        [0.89804, 'rgb(102,102,102)'],
        [0.90196, 'rgb(102,102,102)'],
        [0.90588, 'rgb(102,102,102)'],
        [0.9098, 'rgb(102,102,102)'],
        [0.91373, 'rgb(102,102,102)'],
        [0.91765, 'rgb(102,102,102)'],
        [0.92157, 'rgb(102,102,102)'],
        [0.92549, 'rgb(102,102,102)'],
        [0.92941, 'rgb(102,102,102)'],
        [0.93333, 'rgb(102,102,102)'],
        [0.93725, 'rgb(102,102,102)'],
        [0.94118, 'rgb(102,102,102)'],
        [0.9451, 'rgb(102,102,102)'],
        [0.94902, 'rgb(102,102,102)'],
        [0.95294, 'rgb(102,102,102)'],
        [0.95686, 'rgb(102,102,102)'],
        [0.96078, 'rgb(102,102,102)'],
        [0.96471, 'rgb(102,102,102)'],
        [0.96863, 'rgb(102,102,102)'],
        [0.97255, 'rgb(102,102,102)'],
        [0.97647, 'rgb(102,102,102)'],
        [0.98039, 'rgb(102,102,102)'],
        [0.98431, 'rgb(102,102,102)'],
        [0.98824, 'rgb(102,102,102)'],
        [0.99216, 'rgb(102,102,102)'],
        [0.99608, 'rgb(102,102,102)'],
        [1.0, 'rgb(102,102,102)'],
    ],
    'cmrmap': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(1,1,4)'],
        [0.00784, 'rgb(2,2,8)'],
        [0.01176, 'rgb(3,3,12)'],
        [0.01569, 'rgb(4,4,16)'],
        [0.01961, 'rgb(6,6,20)'],
        [0.02353, 'rgb(7,7,24)'],
        [0.02745, 'rgb(8,8,28)'],
        [0.03137, 'rgb(9,9,32)'],
        [0.03529, 'rgb(10,10,36)'],
        [0.03922, 'rgb(12,12,40)'],
        [0.04314, 'rgb(13,13,44)'],
        [0.04706, 'rgb(14,14,48)'],
        [0.05098, 'rgb(15,15,52)'],
        [0.0549, 'rgb(16,16,56)'],
        [0.05882, 'rgb(18,18,60)'],
        [0.06275, 'rgb(19,19,64)'],
        [0.06667, 'rgb(20,20,68)'],
        [0.07059, 'rgb(21,21,72)'],
        [0.07451, 'rgb(22,22,76)'],
        [0.07843, 'rgb(24,24,80)'],
        [0.08235, 'rgb(25,25,84)'],
        [0.08627, 'rgb(26,26,88)'],
        [0.0902, 'rgb(27,27,92)'],
        [0.09412, 'rgb(28,28,96)'],
        [0.09804, 'rgb(30,30,100)'],
        [0.10196, 'rgb(31,31,104)'],
        [0.10588, 'rgb(32,32,108)'],
        [0.1098, 'rgb(33,33,112)'],
        [0.11373, 'rgb(34,34,116)'],
        [0.11765, 'rgb(36,36,120)'],
        [0.12157, 'rgb(37,37,124)'],
        [0.12549, 'rgb(38,38,127)'],
        [0.12941, 'rgb(39,38,129)'],
        [0.13333, 'rgb(40,38,131)'],
        [0.13725, 'rgb(42,38,133)'],
        [0.14118, 'rgb(43,38,135)'],
        [0.1451, 'rgb(44,38,137)'],
        [0.14902, 'rgb(45,38,139)'],
        [0.15294, 'rgb(46,38,141)'],
        [0.15686, 'rgb(48,38,143)'],
        [0.16078, 'rgb(49,38,145)'],
        [0.16471, 'rgb(50,38,147)'],
        [0.16863, 'rgb(51,38,149)'],
        [0.17255, 'rgb(52,38,151)'],
        [0.17647, 'rgb(53,38,153)'],
        [0.18039, 'rgb(55,38,155)'],
        [0.18431, 'rgb(56,38,157)'],
        [0.18824, 'rgb(57,38,159)'],
        [0.19216, 'rgb(58,38,161)'],
        [0.19608, 'rgb(60,38,163)'],
        [0.2, 'rgb(61,38,165)'],
        [0.20392, 'rgb(62,38,167)'],
        [0.20784, 'rgb(63,38,169)'],
        [0.21176, 'rgb(64,38,171)'],
        [0.21569, 'rgb(65,38,173)'],
        [0.21961, 'rgb(67,38,175)'],
        [0.22353, 'rgb(68,38,177)'],
        [0.22745, 'rgb(69,38,179)'],
        [0.23137, 'rgb(70,38,181)'],
        [0.23529, 'rgb(72,38,183)'],
        [0.23922, 'rgb(73,38,185)'],
        [0.24314, 'rgb(74,38,187)'],
        [0.24706, 'rgb(75,38,189)'],
        [0.25098, 'rgb(77,38,190)'],
        [0.2549, 'rgb(79,38,188)'],
        [0.25882, 'rgb(81,39,186)'],
        [0.26275, 'rgb(84,39,184)'],
        [0.26667, 'rgb(86,39,182)'],
        [0.27059, 'rgb(89,40,180)'],
        [0.27451, 'rgb(91,40,178)'],
        [0.27843, 'rgb(93,41,176)'],
        [0.28235, 'rgb(96,41,174)'],
        [0.28627, 'rgb(98,41,172)'],
        [0.2902, 'rgb(101,42,170)'],
        [0.29412, 'rgb(103,42,168)'],
        [0.29804, 'rgb(105,43,166)'],
        [0.30196, 'rgb(108,43,164)'],
        [0.30588, 'rgb(110,43,162)'],
        [0.3098, 'rgb(113,44,160)'],
        [0.31373, 'rgb(115,44,158)'],
        [0.31765, 'rgb(117,45,156)'],
        [0.32157, 'rgb(120,45,154)'],
        [0.32549, 'rgb(122,45,152)'],
        [0.32941, 'rgb(125,46,150)'],
        [0.33333, 'rgb(127,46,148)'],
        [0.33725, 'rgb(129,47,146)'],
        [0.34118, 'rgb(132,47,144)'],
        [0.3451, 'rgb(134,47,142)'],
        [0.34902, 'rgb(137,48,140)'],
        [0.35294, 'rgb(139,48,138)'],
        [0.35686, 'rgb(141,49,136)'],
        [0.36078, 'rgb(144,49,134)'],
        [0.36471, 'rgb(146,49,132)'],
        [0.36863, 'rgb(149,50,130)'],
        [0.37255, 'rgb(151,50,128)'],
        [0.37647, 'rgb(154,51,126)'],
        [0.38039, 'rgb(157,51,123)'],
        [0.38431, 'rgb(160,51,120)'],
        [0.38824, 'rgb(163,52,118)'],
        [0.39216, 'rgb(167,52,115)'],
        [0.39608, 'rgb(170,53,112)'],
        [0.4, 'rgb(173,53,109)'],
        [0.40392, 'rgb(176,53,106)'],
        [0.40784, 'rgb(179,54,104)'],
        [0.41176, 'rgb(183,54,101)'],
        [0.41569, 'rgb(186,55,98)'],
        [0.41961, 'rgb(189,55,95)'],
        [0.42353, 'rgb(192,55,92)'],
        [0.42745, 'rgb(195,56,90)'],
        [0.43137, 'rgb(199,56,87)'],
        [0.43529, 'rgb(202,57,84)'],
        [0.43922, 'rgb(205,57,81)'],
        [0.44314, 'rgb(208,57,78)'],
        [0.44706, 'rgb(211,58,76)'],
        [0.45098, 'rgb(215,58,73)'],
        [0.4549, 'rgb(218,59,70)'],
        [0.45882, 'rgb(221,59,67)'],
        [0.46275, 'rgb(224,59,64)'],
        [0.46667, 'rgb(227,60,62)'],
        [0.47059, 'rgb(231,60,59)'],
        [0.47451, 'rgb(234,61,56)'],
        [0.47843, 'rgb(237,61,53)'],
        [0.48235, 'rgb(240,61,50)'],
        [0.48627, 'rgb(243,62,48)'],
        [0.4902, 'rgb(247,62,45)'],
        [0.49412, 'rgb(250,63,42)'],
        [0.49804, 'rgb(253,63,39)'],
        [0.50196, 'rgb(254,64,37)'],
        [0.50588, 'rgb(253,66,36)'],
        [0.5098, 'rgb(253,68,35)'],
        [0.51373, 'rgb(252,70,34)'],
        [0.51765, 'rgb(251,72,32)'],
        [0.52157, 'rgb(250,74,31)'],
        [0.52549, 'rgb(249,76,30)'],
        [0.52941, 'rgb(249,78,29)'],
        [0.53333, 'rgb(248,80,28)'],
        [0.53725, 'rgb(247,82,26)'],
        [0.54118, 'rgb(246,84,25)'],
        [0.5451, 'rgb(245,86,24)'],
        [0.54902, 'rgb(245,88,23)'],
        [0.55294, 'rgb(244,90,22)'],
        [0.55686, 'rgb(243,92,20)'],
        [0.56078, 'rgb(242,94,19)'],
        [0.56471, 'rgb(241,96,18)'],
        [0.56863, 'rgb(241,98,17)'],
        [0.57255, 'rgb(240,100,16)'],
        [0.57647, 'rgb(239,102,14)'],
        [0.58039, 'rgb(238,104,13)'],
        [0.58431, 'rgb(237,106,12)'],
        [0.58824, 'rgb(237,108,11)'],
        [0.59216, 'rgb(236,110,10)'],
        [0.59608, 'rgb(235,112,8)'],
        [0.6, 'rgb(234,114,7)'],
        [0.60392, 'rgb(233,116,6)'],
        [0.60784, 'rgb(233,118,5)'],
        [0.61176, 'rgb(232,120,4)'],
        [0.61569, 'rgb(231,122,2)'],
        [0.61961, 'rgb(230,124,1)'],
        [0.62353, 'rgb(229,126,0)'],
        [0.62745, 'rgb(229,128,0)'],
        [0.63137, 'rgb(229,130,1)'],
        [0.63529, 'rgb(229,132,2)'],
        [0.63922, 'rgb(229,134,2)'],
        [0.64314, 'rgb(229,136,3)'],
        [0.64706, 'rgb(229,138,4)'],
        [0.65098, 'rgb(229,140,5)'],
        [0.6549, 'rgb(229,142,6)'],
        [0.65882, 'rgb(229,144,6)'],
        [0.66275, 'rgb(229,146,7)'],
        [0.66667, 'rgb(229,148,8)'],
        [0.67059, 'rgb(229,150,9)'],
        [0.67451, 'rgb(229,152,10)'],
        [0.67843, 'rgb(229,154,10)'],
        [0.68235, 'rgb(229,156,11)'],
        [0.68627, 'rgb(229,158,12)'],
        [0.6902, 'rgb(229,160,13)'],
        [0.69412, 'rgb(229,162,14)'],
        [0.69804, 'rgb(229,164,14)'],
        [0.70196, 'rgb(229,166,15)'],
        [0.70588, 'rgb(229,168,16)'],
        [0.7098, 'rgb(229,170,17)'],
        [0.71373, 'rgb(229,172,18)'],
        [0.71765, 'rgb(229,174,18)'],
        [0.72157, 'rgb(229,176,19)'],
        [0.72549, 'rgb(229,178,20)'],
        [0.72941, 'rgb(229,180,21)'],
        [0.73333, 'rgb(229,182,22)'],
        [0.73725, 'rgb(229,184,22)'],
        [0.74118, 'rgb(229,186,23)'],
        [0.7451, 'rgb(229,188,24)'],
        [0.74902, 'rgb(229,190,25)'],
        [0.75294, 'rgb(229,192,27)'],
        [0.75686, 'rgb(229,193,31)'],
        [0.76078, 'rgb(229,194,34)'],
        [0.76471, 'rgb(229,195,37)'],
        [0.76863, 'rgb(229,196,40)'],
        [0.77255, 'rgb(229,198,43)'],
        [0.77647, 'rgb(229,199,47)'],
        [0.78039, 'rgb(229,200,50)'],
        [0.78431, 'rgb(229,201,53)'],
        [0.78824, 'rgb(229,202,56)'],
        [0.79216, 'rgb(229,204,59)'],
        [0.79608, 'rgb(229,205,63)'],
        [0.8, 'rgb(229,206,66)'],
        [0.80392, 'rgb(229,207,69)'],
        [0.80784, 'rgb(229,208,72)'],
        [0.81176, 'rgb(229,210,75)'],
        [0.81569, 'rgb(229,211,79)'],
        [0.81961, 'rgb(229,212,82)'],
        [0.82353, 'rgb(229,213,85)'],
        [0.82745, 'rgb(229,214,88)'],
        [0.83137, 'rgb(229,216,91)'],
        [0.83529, 'rgb(229,217,95)'],
        [0.83922, 'rgb(229,218,98)'],
        [0.84314, 'rgb(229,219,101)'],
        [0.84706, 'rgb(229,220,104)'],
        [0.85098, 'rgb(229,222,107)'],
        [0.8549, 'rgb(229,223,111)'],
        [0.85882, 'rgb(229,224,114)'],
        [0.86275, 'rgb(229,225,117)'],
        [0.86667, 'rgb(229,226,120)'],
        [0.87059, 'rgb(229,228,123)'],
        [0.87451, 'rgb(229,229,127)'],
        [0.87843, 'rgb(230,230,131)'],
        [0.88235, 'rgb(231,231,135)'],
        [0.88627, 'rgb(231,231,139)'],
        [0.8902, 'rgb(232,232,143)'],
        [0.89412, 'rgb(233,233,146)'],
        [0.89804, 'rgb(234,234,151)'],
        [0.90196, 'rgb(235,235,155)'],
        [0.90588, 'rgb(235,235,159)'],
        [0.9098, 'rgb(236,236,163)'],
        [0.91373, 'rgb(237,237,167)'],
        [0.91765, 'rgb(238,238,171)'],
        [0.92157, 'rgb(239,239,175)'],
        [0.92549, 'rgb(239,239,179)'],
        [0.92941, 'rgb(240,240,183)'],
        [0.93333, 'rgb(241,241,187)'],
        [0.93725, 'rgb(242,242,191)'],
        [0.94118, 'rgb(243,243,195)'],
        [0.9451, 'rgb(243,243,199)'],
        [0.94902, 'rgb(244,244,203)'],
        [0.95294, 'rgb(245,245,207)'],
        [0.95686, 'rgb(246,246,210)'],
        [0.96078, 'rgb(247,247,215)'],
        [0.96471, 'rgb(247,247,219)'],
        [0.96863, 'rgb(248,248,223)'],
        [0.97255, 'rgb(249,249,227)'],
        [0.97647, 'rgb(250,250,231)'],
        [0.98039, 'rgb(251,251,235)'],
        [0.98431, 'rgb(251,251,239)'],
        [0.98824, 'rgb(252,252,243)'],
        [0.99216, 'rgb(253,253,247)'],
        [0.99608, 'rgb(254,254,251)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'dark2': [
        [0.0, 'rgb(27,158,119)'],
        [0.00392, 'rgb(27,158,119)'],
        [0.00784, 'rgb(27,158,119)'],
        [0.01176, 'rgb(27,158,119)'],
        [0.01569, 'rgb(27,158,119)'],
        [0.01961, 'rgb(27,158,119)'],
        [0.02353, 'rgb(27,158,119)'],
        [0.02745, 'rgb(27,158,119)'],
        [0.03137, 'rgb(27,158,119)'],
        [0.03529, 'rgb(27,158,119)'],
        [0.03922, 'rgb(27,158,119)'],
        [0.04314, 'rgb(27,158,119)'],
        [0.04706, 'rgb(27,158,119)'],
        [0.05098, 'rgb(27,158,119)'],
        [0.0549, 'rgb(27,158,119)'],
        [0.05882, 'rgb(27,158,119)'],
        [0.06275, 'rgb(27,158,119)'],
        [0.06667, 'rgb(27,158,119)'],
        [0.07059, 'rgb(27,158,119)'],
        [0.07451, 'rgb(27,158,119)'],
        [0.07843, 'rgb(27,158,119)'],
        [0.08235, 'rgb(27,158,119)'],
        [0.08627, 'rgb(27,158,119)'],
        [0.0902, 'rgb(27,158,119)'],
        [0.09412, 'rgb(27,158,119)'],
        [0.09804, 'rgb(27,158,119)'],
        [0.10196, 'rgb(27,158,119)'],
        [0.10588, 'rgb(27,158,119)'],
        [0.1098, 'rgb(27,158,119)'],
        [0.11373, 'rgb(27,158,119)'],
        [0.11765, 'rgb(27,158,119)'],
        [0.12157, 'rgb(27,158,119)'],
        [0.12549, 'rgb(217,95,2)'],
        [0.12941, 'rgb(217,95,2)'],
        [0.13333, 'rgb(217,95,2)'],
        [0.13725, 'rgb(217,95,2)'],
        [0.14118, 'rgb(217,95,2)'],
        [0.1451, 'rgb(217,95,2)'],
        [0.14902, 'rgb(217,95,2)'],
        [0.15294, 'rgb(217,95,2)'],
        [0.15686, 'rgb(217,95,2)'],
        [0.16078, 'rgb(217,95,2)'],
        [0.16471, 'rgb(217,95,2)'],
        [0.16863, 'rgb(217,95,2)'],
        [0.17255, 'rgb(217,95,2)'],
        [0.17647, 'rgb(217,95,2)'],
        [0.18039, 'rgb(217,95,2)'],
        [0.18431, 'rgb(217,95,2)'],
        [0.18824, 'rgb(217,95,2)'],
        [0.19216, 'rgb(217,95,2)'],
        [0.19608, 'rgb(217,95,2)'],
        [0.2, 'rgb(217,95,2)'],
        [0.20392, 'rgb(217,95,2)'],
        [0.20784, 'rgb(217,95,2)'],
        [0.21176, 'rgb(217,95,2)'],
        [0.21569, 'rgb(217,95,2)'],
        [0.21961, 'rgb(217,95,2)'],
        [0.22353, 'rgb(217,95,2)'],
        [0.22745, 'rgb(217,95,2)'],
        [0.23137, 'rgb(217,95,2)'],
        [0.23529, 'rgb(217,95,2)'],
        [0.23922, 'rgb(217,95,2)'],
        [0.24314, 'rgb(217,95,2)'],
        [0.24706, 'rgb(217,95,2)'],
        [0.25098, 'rgb(117,112,179)'],
        [0.2549, 'rgb(117,112,179)'],
        [0.25882, 'rgb(117,112,179)'],
        [0.26275, 'rgb(117,112,179)'],
        [0.26667, 'rgb(117,112,179)'],
        [0.27059, 'rgb(117,112,179)'],
        [0.27451, 'rgb(117,112,179)'],
        [0.27843, 'rgb(117,112,179)'],
        [0.28235, 'rgb(117,112,179)'],
        [0.28627, 'rgb(117,112,179)'],
        [0.2902, 'rgb(117,112,179)'],
        [0.29412, 'rgb(117,112,179)'],
        [0.29804, 'rgb(117,112,179)'],
        [0.30196, 'rgb(117,112,179)'],
        [0.30588, 'rgb(117,112,179)'],
        [0.3098, 'rgb(117,112,179)'],
        [0.31373, 'rgb(117,112,179)'],
        [0.31765, 'rgb(117,112,179)'],
        [0.32157, 'rgb(117,112,179)'],
        [0.32549, 'rgb(117,112,179)'],
        [0.32941, 'rgb(117,112,179)'],
        [0.33333, 'rgb(117,112,179)'],
        [0.33725, 'rgb(117,112,179)'],
        [0.34118, 'rgb(117,112,179)'],
        [0.3451, 'rgb(117,112,179)'],
        [0.34902, 'rgb(117,112,179)'],
        [0.35294, 'rgb(117,112,179)'],
        [0.35686, 'rgb(117,112,179)'],
        [0.36078, 'rgb(117,112,179)'],
        [0.36471, 'rgb(117,112,179)'],
        [0.36863, 'rgb(117,112,179)'],
        [0.37255, 'rgb(117,112,179)'],
        [0.37647, 'rgb(231,41,138)'],
        [0.38039, 'rgb(231,41,138)'],
        [0.38431, 'rgb(231,41,138)'],
        [0.38824, 'rgb(231,41,138)'],
        [0.39216, 'rgb(231,41,138)'],
        [0.39608, 'rgb(231,41,138)'],
        [0.4, 'rgb(231,41,138)'],
        [0.40392, 'rgb(231,41,138)'],
        [0.40784, 'rgb(231,41,138)'],
        [0.41176, 'rgb(231,41,138)'],
        [0.41569, 'rgb(231,41,138)'],
        [0.41961, 'rgb(231,41,138)'],
        [0.42353, 'rgb(231,41,138)'],
        [0.42745, 'rgb(231,41,138)'],
        [0.43137, 'rgb(231,41,138)'],
        [0.43529, 'rgb(231,41,138)'],
        [0.43922, 'rgb(231,41,138)'],
        [0.44314, 'rgb(231,41,138)'],
        [0.44706, 'rgb(231,41,138)'],
        [0.45098, 'rgb(231,41,138)'],
        [0.4549, 'rgb(231,41,138)'],
        [0.45882, 'rgb(231,41,138)'],
        [0.46275, 'rgb(231,41,138)'],
        [0.46667, 'rgb(231,41,138)'],
        [0.47059, 'rgb(231,41,138)'],
        [0.47451, 'rgb(231,41,138)'],
        [0.47843, 'rgb(231,41,138)'],
        [0.48235, 'rgb(231,41,138)'],
        [0.48627, 'rgb(231,41,138)'],
        [0.4902, 'rgb(231,41,138)'],
        [0.49412, 'rgb(231,41,138)'],
        [0.49804, 'rgb(231,41,138)'],
        [0.50196, 'rgb(102,166,30)'],
        [0.50588, 'rgb(102,166,30)'],
        [0.5098, 'rgb(102,166,30)'],
        [0.51373, 'rgb(102,166,30)'],
        [0.51765, 'rgb(102,166,30)'],
        [0.52157, 'rgb(102,166,30)'],
        [0.52549, 'rgb(102,166,30)'],
        [0.52941, 'rgb(102,166,30)'],
        [0.53333, 'rgb(102,166,30)'],
        [0.53725, 'rgb(102,166,30)'],
        [0.54118, 'rgb(102,166,30)'],
        [0.5451, 'rgb(102,166,30)'],
        [0.54902, 'rgb(102,166,30)'],
        [0.55294, 'rgb(102,166,30)'],
        [0.55686, 'rgb(102,166,30)'],
        [0.56078, 'rgb(102,166,30)'],
        [0.56471, 'rgb(102,166,30)'],
        [0.56863, 'rgb(102,166,30)'],
        [0.57255, 'rgb(102,166,30)'],
        [0.57647, 'rgb(102,166,30)'],
        [0.58039, 'rgb(102,166,30)'],
        [0.58431, 'rgb(102,166,30)'],
        [0.58824, 'rgb(102,166,30)'],
        [0.59216, 'rgb(102,166,30)'],
        [0.59608, 'rgb(102,166,30)'],
        [0.6, 'rgb(102,166,30)'],
        [0.60392, 'rgb(102,166,30)'],
        [0.60784, 'rgb(102,166,30)'],
        [0.61176, 'rgb(102,166,30)'],
        [0.61569, 'rgb(102,166,30)'],
        [0.61961, 'rgb(102,166,30)'],
        [0.62353, 'rgb(102,166,30)'],
        [0.62745, 'rgb(230,171,2)'],
        [0.63137, 'rgb(230,171,2)'],
        [0.63529, 'rgb(230,171,2)'],
        [0.63922, 'rgb(230,171,2)'],
        [0.64314, 'rgb(230,171,2)'],
        [0.64706, 'rgb(230,171,2)'],
        [0.65098, 'rgb(230,171,2)'],
        [0.6549, 'rgb(230,171,2)'],
        [0.65882, 'rgb(230,171,2)'],
        [0.66275, 'rgb(230,171,2)'],
        [0.66667, 'rgb(230,171,2)'],
        [0.67059, 'rgb(230,171,2)'],
        [0.67451, 'rgb(230,171,2)'],
        [0.67843, 'rgb(230,171,2)'],
        [0.68235, 'rgb(230,171,2)'],
        [0.68627, 'rgb(230,171,2)'],
        [0.6902, 'rgb(230,171,2)'],
        [0.69412, 'rgb(230,171,2)'],
        [0.69804, 'rgb(230,171,2)'],
        [0.70196, 'rgb(230,171,2)'],
        [0.70588, 'rgb(230,171,2)'],
        [0.7098, 'rgb(230,171,2)'],
        [0.71373, 'rgb(230,171,2)'],
        [0.71765, 'rgb(230,171,2)'],
        [0.72157, 'rgb(230,171,2)'],
        [0.72549, 'rgb(230,171,2)'],
        [0.72941, 'rgb(230,171,2)'],
        [0.73333, 'rgb(230,171,2)'],
        [0.73725, 'rgb(230,171,2)'],
        [0.74118, 'rgb(230,171,2)'],
        [0.7451, 'rgb(230,171,2)'],
        [0.74902, 'rgb(230,171,2)'],
        [0.75294, 'rgb(166,118,29)'],
        [0.75686, 'rgb(166,118,29)'],
        [0.76078, 'rgb(166,118,29)'],
        [0.76471, 'rgb(166,118,29)'],
        [0.76863, 'rgb(166,118,29)'],
        [0.77255, 'rgb(166,118,29)'],
        [0.77647, 'rgb(166,118,29)'],
        [0.78039, 'rgb(166,118,29)'],
        [0.78431, 'rgb(166,118,29)'],
        [0.78824, 'rgb(166,118,29)'],
        [0.79216, 'rgb(166,118,29)'],
        [0.79608, 'rgb(166,118,29)'],
        [0.8, 'rgb(166,118,29)'],
        [0.80392, 'rgb(166,118,29)'],
        [0.80784, 'rgb(166,118,29)'],
        [0.81176, 'rgb(166,118,29)'],
        [0.81569, 'rgb(166,118,29)'],
        [0.81961, 'rgb(166,118,29)'],
        [0.82353, 'rgb(166,118,29)'],
        [0.82745, 'rgb(166,118,29)'],
        [0.83137, 'rgb(166,118,29)'],
        [0.83529, 'rgb(166,118,29)'],
        [0.83922, 'rgb(166,118,29)'],
        [0.84314, 'rgb(166,118,29)'],
        [0.84706, 'rgb(166,118,29)'],
        [0.85098, 'rgb(166,118,29)'],
        [0.8549, 'rgb(166,118,29)'],
        [0.85882, 'rgb(166,118,29)'],
        [0.86275, 'rgb(166,118,29)'],
        [0.86667, 'rgb(166,118,29)'],
        [0.87059, 'rgb(166,118,29)'],
        [0.87451, 'rgb(166,118,29)'],
        [0.87843, 'rgb(102,102,102)'],
        [0.88235, 'rgb(102,102,102)'],
        [0.88627, 'rgb(102,102,102)'],
        [0.8902, 'rgb(102,102,102)'],
        [0.89412, 'rgb(102,102,102)'],
        [0.89804, 'rgb(102,102,102)'],
        [0.90196, 'rgb(102,102,102)'],
        [0.90588, 'rgb(102,102,102)'],
        [0.9098, 'rgb(102,102,102)'],
        [0.91373, 'rgb(102,102,102)'],
        [0.91765, 'rgb(102,102,102)'],
        [0.92157, 'rgb(102,102,102)'],
        [0.92549, 'rgb(102,102,102)'],
        [0.92941, 'rgb(102,102,102)'],
        [0.93333, 'rgb(102,102,102)'],
        [0.93725, 'rgb(102,102,102)'],
        [0.94118, 'rgb(102,102,102)'],
        [0.9451, 'rgb(102,102,102)'],
        [0.94902, 'rgb(102,102,102)'],
        [0.95294, 'rgb(102,102,102)'],
        [0.95686, 'rgb(102,102,102)'],
        [0.96078, 'rgb(102,102,102)'],
        [0.96471, 'rgb(102,102,102)'],
        [0.96863, 'rgb(102,102,102)'],
        [0.97255, 'rgb(102,102,102)'],
        [0.97647, 'rgb(102,102,102)'],
        [0.98039, 'rgb(102,102,102)'],
        [0.98431, 'rgb(102,102,102)'],
        [0.98824, 'rgb(102,102,102)'],
        [0.99216, 'rgb(102,102,102)'],
        [0.99608, 'rgb(102,102,102)'],
        [1.0, 'rgb(102,102,102)'],
    ],
    'paired': [
        [0.0, 'rgb(166,206,227)'],
        [0.00392, 'rgb(166,206,227)'],
        [0.00784, 'rgb(166,206,227)'],
        [0.01176, 'rgb(166,206,227)'],
        [0.01569, 'rgb(166,206,227)'],
        [0.01961, 'rgb(166,206,227)'],
        [0.02353, 'rgb(166,206,227)'],
        [0.02745, 'rgb(166,206,227)'],
        [0.03137, 'rgb(166,206,227)'],
        [0.03529, 'rgb(166,206,227)'],
        [0.03922, 'rgb(166,206,227)'],
        [0.04314, 'rgb(166,206,227)'],
        [0.04706, 'rgb(166,206,227)'],
        [0.05098, 'rgb(166,206,227)'],
        [0.0549, 'rgb(166,206,227)'],
        [0.05882, 'rgb(166,206,227)'],
        [0.06275, 'rgb(166,206,227)'],
        [0.06667, 'rgb(166,206,227)'],
        [0.07059, 'rgb(166,206,227)'],
        [0.07451, 'rgb(166,206,227)'],
        [0.07843, 'rgb(166,206,227)'],
        [0.08235, 'rgb(166,206,227)'],
        [0.08627, 'rgb(31,120,180)'],
        [0.0902, 'rgb(31,120,180)'],
        [0.09412, 'rgb(31,120,180)'],
        [0.09804, 'rgb(31,120,180)'],
        [0.10196, 'rgb(31,120,180)'],
        [0.10588, 'rgb(31,120,180)'],
        [0.1098, 'rgb(31,120,180)'],
        [0.11373, 'rgb(31,120,180)'],
        [0.11765, 'rgb(31,120,180)'],
        [0.12157, 'rgb(31,120,180)'],
        [0.12549, 'rgb(31,120,180)'],
        [0.12941, 'rgb(31,120,180)'],
        [0.13333, 'rgb(31,120,180)'],
        [0.13725, 'rgb(31,120,180)'],
        [0.14118, 'rgb(31,120,180)'],
        [0.1451, 'rgb(31,120,180)'],
        [0.14902, 'rgb(31,120,180)'],
        [0.15294, 'rgb(31,120,180)'],
        [0.15686, 'rgb(31,120,180)'],
        [0.16078, 'rgb(31,120,180)'],
        [0.16471, 'rgb(31,120,180)'],
        [0.16863, 'rgb(178,223,138)'],
        [0.17255, 'rgb(178,223,138)'],
        [0.17647, 'rgb(178,223,138)'],
        [0.18039, 'rgb(178,223,138)'],
        [0.18431, 'rgb(178,223,138)'],
        [0.18824, 'rgb(178,223,138)'],
        [0.19216, 'rgb(178,223,138)'],
        [0.19608, 'rgb(178,223,138)'],
        [0.2, 'rgb(178,223,138)'],
        [0.20392, 'rgb(178,223,138)'],
        [0.20784, 'rgb(178,223,138)'],
        [0.21176, 'rgb(178,223,138)'],
        [0.21569, 'rgb(178,223,138)'],
        [0.21961, 'rgb(178,223,138)'],
        [0.22353, 'rgb(178,223,138)'],
        [0.22745, 'rgb(178,223,138)'],
        [0.23137, 'rgb(178,223,138)'],
        [0.23529, 'rgb(178,223,138)'],
        [0.23922, 'rgb(178,223,138)'],
        [0.24314, 'rgb(178,223,138)'],
        [0.24706, 'rgb(178,223,138)'],
        [0.25098, 'rgb(51,160,44)'],
        [0.2549, 'rgb(51,160,44)'],
        [0.25882, 'rgb(51,160,44)'],
        [0.26275, 'rgb(51,160,44)'],
        [0.26667, 'rgb(51,160,44)'],
        [0.27059, 'rgb(51,160,44)'],
        [0.27451, 'rgb(51,160,44)'],
        [0.27843, 'rgb(51,160,44)'],
        [0.28235, 'rgb(51,160,44)'],
        [0.28627, 'rgb(51,160,44)'],
        [0.2902, 'rgb(51,160,44)'],
        [0.29412, 'rgb(51,160,44)'],
        [0.29804, 'rgb(51,160,44)'],
        [0.30196, 'rgb(51,160,44)'],
        [0.30588, 'rgb(51,160,44)'],
        [0.3098, 'rgb(51,160,44)'],
        [0.31373, 'rgb(51,160,44)'],
        [0.31765, 'rgb(51,160,44)'],
        [0.32157, 'rgb(51,160,44)'],
        [0.32549, 'rgb(51,160,44)'],
        [0.32941, 'rgb(51,160,44)'],
        [0.33333, 'rgb(51,160,44)'],
        [0.33725, 'rgb(251,154,153)'],
        [0.34118, 'rgb(251,154,153)'],
        [0.3451, 'rgb(251,154,153)'],
        [0.34902, 'rgb(251,154,153)'],
        [0.35294, 'rgb(251,154,153)'],
        [0.35686, 'rgb(251,154,153)'],
        [0.36078, 'rgb(251,154,153)'],
        [0.36471, 'rgb(251,154,153)'],
        [0.36863, 'rgb(251,154,153)'],
        [0.37255, 'rgb(251,154,153)'],
        [0.37647, 'rgb(251,154,153)'],
        [0.38039, 'rgb(251,154,153)'],
        [0.38431, 'rgb(251,154,153)'],
        [0.38824, 'rgb(251,154,153)'],
        [0.39216, 'rgb(251,154,153)'],
        [0.39608, 'rgb(251,154,153)'],
        [0.4, 'rgb(251,154,153)'],
        [0.40392, 'rgb(251,154,153)'],
        [0.40784, 'rgb(251,154,153)'],
        [0.41176, 'rgb(251,154,153)'],
        [0.41569, 'rgb(251,154,153)'],
        [0.41961, 'rgb(227,26,28)'],
        [0.42353, 'rgb(227,26,28)'],
        [0.42745, 'rgb(227,26,28)'],
        [0.43137, 'rgb(227,26,28)'],
        [0.43529, 'rgb(227,26,28)'],
        [0.43922, 'rgb(227,26,28)'],
        [0.44314, 'rgb(227,26,28)'],
        [0.44706, 'rgb(227,26,28)'],
        [0.45098, 'rgb(227,26,28)'],
        [0.4549, 'rgb(227,26,28)'],
        [0.45882, 'rgb(227,26,28)'],
        [0.46275, 'rgb(227,26,28)'],
        [0.46667, 'rgb(227,26,28)'],
        [0.47059, 'rgb(227,26,28)'],
        [0.47451, 'rgb(227,26,28)'],
        [0.47843, 'rgb(227,26,28)'],
        [0.48235, 'rgb(227,26,28)'],
        [0.48627, 'rgb(227,26,28)'],
        [0.4902, 'rgb(227,26,28)'],
        [0.49412, 'rgb(227,26,28)'],
        [0.49804, 'rgb(227,26,28)'],
        [0.50196, 'rgb(253,191,111)'],
        [0.50588, 'rgb(253,191,111)'],
        [0.5098, 'rgb(253,191,111)'],
        [0.51373, 'rgb(253,191,111)'],
        [0.51765, 'rgb(253,191,111)'],
        [0.52157, 'rgb(253,191,111)'],
        [0.52549, 'rgb(253,191,111)'],
        [0.52941, 'rgb(253,191,111)'],
        [0.53333, 'rgb(253,191,111)'],
        [0.53725, 'rgb(253,191,111)'],
        [0.54118, 'rgb(253,191,111)'],
        [0.5451, 'rgb(253,191,111)'],
        [0.54902, 'rgb(253,191,111)'],
        [0.55294, 'rgb(253,191,111)'],
        [0.55686, 'rgb(253,191,111)'],
        [0.56078, 'rgb(253,191,111)'],
        [0.56471, 'rgb(253,191,111)'],
        [0.56863, 'rgb(253,191,111)'],
        [0.57255, 'rgb(253,191,111)'],
        [0.57647, 'rgb(253,191,111)'],
        [0.58039, 'rgb(253,191,111)'],
        [0.58431, 'rgb(255,127,0)'],
        [0.58824, 'rgb(255,127,0)'],
        [0.59216, 'rgb(255,127,0)'],
        [0.59608, 'rgb(255,127,0)'],
        [0.6, 'rgb(255,127,0)'],
        [0.60392, 'rgb(255,127,0)'],
        [0.60784, 'rgb(255,127,0)'],
        [0.61176, 'rgb(255,127,0)'],
        [0.61569, 'rgb(255,127,0)'],
        [0.61961, 'rgb(255,127,0)'],
        [0.62353, 'rgb(255,127,0)'],
        [0.62745, 'rgb(255,127,0)'],
        [0.63137, 'rgb(255,127,0)'],
        [0.63529, 'rgb(255,127,0)'],
        [0.63922, 'rgb(255,127,0)'],
        [0.64314, 'rgb(255,127,0)'],
        [0.64706, 'rgb(255,127,0)'],
        [0.65098, 'rgb(255,127,0)'],
        [0.6549, 'rgb(255,127,0)'],
        [0.65882, 'rgb(255,127,0)'],
        [0.66275, 'rgb(255,127,0)'],
        [0.66667, 'rgb(202,178,214)'],
        [0.67059, 'rgb(202,178,214)'],
        [0.67451, 'rgb(202,178,214)'],
        [0.67843, 'rgb(202,178,214)'],
        [0.68235, 'rgb(202,178,214)'],
        [0.68627, 'rgb(202,178,214)'],
        [0.6902, 'rgb(202,178,214)'],
        [0.69412, 'rgb(202,178,214)'],
        [0.69804, 'rgb(202,178,214)'],
        [0.70196, 'rgb(202,178,214)'],
        [0.70588, 'rgb(202,178,214)'],
        [0.7098, 'rgb(202,178,214)'],
        [0.71373, 'rgb(202,178,214)'],
        [0.71765, 'rgb(202,178,214)'],
        [0.72157, 'rgb(202,178,214)'],
        [0.72549, 'rgb(202,178,214)'],
        [0.72941, 'rgb(202,178,214)'],
        [0.73333, 'rgb(202,178,214)'],
        [0.73725, 'rgb(202,178,214)'],
        [0.74118, 'rgb(202,178,214)'],
        [0.7451, 'rgb(202,178,214)'],
        [0.74902, 'rgb(202,178,214)'],
        [0.75294, 'rgb(106,61,154)'],
        [0.75686, 'rgb(106,61,154)'],
        [0.76078, 'rgb(106,61,154)'],
        [0.76471, 'rgb(106,61,154)'],
        [0.76863, 'rgb(106,61,154)'],
        [0.77255, 'rgb(106,61,154)'],
        [0.77647, 'rgb(106,61,154)'],
        [0.78039, 'rgb(106,61,154)'],
        [0.78431, 'rgb(106,61,154)'],
        [0.78824, 'rgb(106,61,154)'],
        [0.79216, 'rgb(106,61,154)'],
        [0.79608, 'rgb(106,61,154)'],
        [0.8, 'rgb(106,61,154)'],
        [0.80392, 'rgb(106,61,154)'],
        [0.80784, 'rgb(106,61,154)'],
        [0.81176, 'rgb(106,61,154)'],
        [0.81569, 'rgb(106,61,154)'],
        [0.81961, 'rgb(106,61,154)'],
        [0.82353, 'rgb(106,61,154)'],
        [0.82745, 'rgb(106,61,154)'],
        [0.83137, 'rgb(106,61,154)'],
        [0.83529, 'rgb(255,255,153)'],
        [0.83922, 'rgb(255,255,153)'],
        [0.84314, 'rgb(255,255,153)'],
        [0.84706, 'rgb(255,255,153)'],
        [0.85098, 'rgb(255,255,153)'],
        [0.8549, 'rgb(255,255,153)'],
        [0.85882, 'rgb(255,255,153)'],
        [0.86275, 'rgb(255,255,153)'],
        [0.86667, 'rgb(255,255,153)'],
        [0.87059, 'rgb(255,255,153)'],
        [0.87451, 'rgb(255,255,153)'],
        [0.87843, 'rgb(255,255,153)'],
        [0.88235, 'rgb(255,255,153)'],
        [0.88627, 'rgb(255,255,153)'],
        [0.8902, 'rgb(255,255,153)'],
        [0.89412, 'rgb(255,255,153)'],
        [0.89804, 'rgb(255,255,153)'],
        [0.90196, 'rgb(255,255,153)'],
        [0.90588, 'rgb(255,255,153)'],
        [0.9098, 'rgb(255,255,153)'],
        [0.91373, 'rgb(255,255,153)'],
        [0.91765, 'rgb(177,89,40)'],
        [0.92157, 'rgb(177,89,40)'],
        [0.92549, 'rgb(177,89,40)'],
        [0.92941, 'rgb(177,89,40)'],
        [0.93333, 'rgb(177,89,40)'],
        [0.93725, 'rgb(177,89,40)'],
        [0.94118, 'rgb(177,89,40)'],
        [0.9451, 'rgb(177,89,40)'],
        [0.94902, 'rgb(177,89,40)'],
        [0.95294, 'rgb(177,89,40)'],
        [0.95686, 'rgb(177,89,40)'],
        [0.96078, 'rgb(177,89,40)'],
        [0.96471, 'rgb(177,89,40)'],
        [0.96863, 'rgb(177,89,40)'],
        [0.97255, 'rgb(177,89,40)'],
        [0.97647, 'rgb(177,89,40)'],
        [0.98039, 'rgb(177,89,40)'],
        [0.98431, 'rgb(177,89,40)'],
        [0.98824, 'rgb(177,89,40)'],
        [0.99216, 'rgb(177,89,40)'],
        [0.99608, 'rgb(177,89,40)'],
        [1.0, 'rgb(177,89,40)'],
    ],
    'pastel1': [
        [0.0, 'rgb(251,180,174)'],
        [0.00392, 'rgb(251,180,174)'],
        [0.00784, 'rgb(251,180,174)'],
        [0.01176, 'rgb(251,180,174)'],
        [0.01569, 'rgb(251,180,174)'],
        [0.01961, 'rgb(251,180,174)'],
        [0.02353, 'rgb(251,180,174)'],
        [0.02745, 'rgb(251,180,174)'],
        [0.03137, 'rgb(251,180,174)'],
        [0.03529, 'rgb(251,180,174)'],
        [0.03922, 'rgb(251,180,174)'],
        [0.04314, 'rgb(251,180,174)'],
        [0.04706, 'rgb(251,180,174)'],
        [0.05098, 'rgb(251,180,174)'],
        [0.0549, 'rgb(251,180,174)'],
        [0.05882, 'rgb(251,180,174)'],
        [0.06275, 'rgb(251,180,174)'],
        [0.06667, 'rgb(251,180,174)'],
        [0.07059, 'rgb(251,180,174)'],
        [0.07451, 'rgb(251,180,174)'],
        [0.07843, 'rgb(251,180,174)'],
        [0.08235, 'rgb(251,180,174)'],
        [0.08627, 'rgb(251,180,174)'],
        [0.0902, 'rgb(251,180,174)'],
        [0.09412, 'rgb(251,180,174)'],
        [0.09804, 'rgb(251,180,174)'],
        [0.10196, 'rgb(251,180,174)'],
        [0.10588, 'rgb(251,180,174)'],
        [0.1098, 'rgb(251,180,174)'],
        [0.11373, 'rgb(179,205,227)'],
        [0.11765, 'rgb(179,205,227)'],
        [0.12157, 'rgb(179,205,227)'],
        [0.12549, 'rgb(179,205,227)'],
        [0.12941, 'rgb(179,205,227)'],
        [0.13333, 'rgb(179,205,227)'],
        [0.13725, 'rgb(179,205,227)'],
        [0.14118, 'rgb(179,205,227)'],
        [0.1451, 'rgb(179,205,227)'],
        [0.14902, 'rgb(179,205,227)'],
        [0.15294, 'rgb(179,205,227)'],
        [0.15686, 'rgb(179,205,227)'],
        [0.16078, 'rgb(179,205,227)'],
        [0.16471, 'rgb(179,205,227)'],
        [0.16863, 'rgb(179,205,227)'],
        [0.17255, 'rgb(179,205,227)'],
        [0.17647, 'rgb(179,205,227)'],
        [0.18039, 'rgb(179,205,227)'],
        [0.18431, 'rgb(179,205,227)'],
        [0.18824, 'rgb(179,205,227)'],
        [0.19216, 'rgb(179,205,227)'],
        [0.19608, 'rgb(179,205,227)'],
        [0.2, 'rgb(179,205,227)'],
        [0.20392, 'rgb(179,205,227)'],
        [0.20784, 'rgb(179,205,227)'],
        [0.21176, 'rgb(179,205,227)'],
        [0.21569, 'rgb(179,205,227)'],
        [0.21961, 'rgb(179,205,227)'],
        [0.22353, 'rgb(204,235,197)'],
        [0.22745, 'rgb(204,235,197)'],
        [0.23137, 'rgb(204,235,197)'],
        [0.23529, 'rgb(204,235,197)'],
        [0.23922, 'rgb(204,235,197)'],
        [0.24314, 'rgb(204,235,197)'],
        [0.24706, 'rgb(204,235,197)'],
        [0.25098, 'rgb(204,235,197)'],
        [0.2549, 'rgb(204,235,197)'],
        [0.25882, 'rgb(204,235,197)'],
        [0.26275, 'rgb(204,235,197)'],
        [0.26667, 'rgb(204,235,197)'],
        [0.27059, 'rgb(204,235,197)'],
        [0.27451, 'rgb(204,235,197)'],
        [0.27843, 'rgb(204,235,197)'],
        [0.28235, 'rgb(204,235,197)'],
        [0.28627, 'rgb(204,235,197)'],
        [0.2902, 'rgb(204,235,197)'],
        [0.29412, 'rgb(204,235,197)'],
        [0.29804, 'rgb(204,235,197)'],
        [0.30196, 'rgb(204,235,197)'],
        [0.30588, 'rgb(204,235,197)'],
        [0.3098, 'rgb(204,235,197)'],
        [0.31373, 'rgb(204,235,197)'],
        [0.31765, 'rgb(204,235,197)'],
        [0.32157, 'rgb(204,235,197)'],
        [0.32549, 'rgb(204,235,197)'],
        [0.32941, 'rgb(204,235,197)'],
        [0.33333, 'rgb(204,235,197)'],
        [0.33725, 'rgb(222,203,228)'],
        [0.34118, 'rgb(222,203,228)'],
        [0.3451, 'rgb(222,203,228)'],
        [0.34902, 'rgb(222,203,228)'],
        [0.35294, 'rgb(222,203,228)'],
        [0.35686, 'rgb(222,203,228)'],
        [0.36078, 'rgb(222,203,228)'],
        [0.36471, 'rgb(222,203,228)'],
        [0.36863, 'rgb(222,203,228)'],
        [0.37255, 'rgb(222,203,228)'],
        [0.37647, 'rgb(222,203,228)'],
        [0.38039, 'rgb(222,203,228)'],
        [0.38431, 'rgb(222,203,228)'],
        [0.38824, 'rgb(222,203,228)'],
        [0.39216, 'rgb(222,203,228)'],
        [0.39608, 'rgb(222,203,228)'],
        [0.4, 'rgb(222,203,228)'],
        [0.40392, 'rgb(222,203,228)'],
        [0.40784, 'rgb(222,203,228)'],
        [0.41176, 'rgb(222,203,228)'],
        [0.41569, 'rgb(222,203,228)'],
        [0.41961, 'rgb(222,203,228)'],
        [0.42353, 'rgb(222,203,228)'],
        [0.42745, 'rgb(222,203,228)'],
        [0.43137, 'rgb(222,203,228)'],
        [0.43529, 'rgb(222,203,228)'],
        [0.43922, 'rgb(222,203,228)'],
        [0.44314, 'rgb(222,203,228)'],
        [0.44706, 'rgb(254,217,166)'],
        [0.45098, 'rgb(254,217,166)'],
        [0.4549, 'rgb(254,217,166)'],
        [0.45882, 'rgb(254,217,166)'],
        [0.46275, 'rgb(254,217,166)'],
        [0.46667, 'rgb(254,217,166)'],
        [0.47059, 'rgb(254,217,166)'],
        [0.47451, 'rgb(254,217,166)'],
        [0.47843, 'rgb(254,217,166)'],
        [0.48235, 'rgb(254,217,166)'],
        [0.48627, 'rgb(254,217,166)'],
        [0.4902, 'rgb(254,217,166)'],
        [0.49412, 'rgb(254,217,166)'],
        [0.49804, 'rgb(254,217,166)'],
        [0.50196, 'rgb(254,217,166)'],
        [0.50588, 'rgb(254,217,166)'],
        [0.5098, 'rgb(254,217,166)'],
        [0.51373, 'rgb(254,217,166)'],
        [0.51765, 'rgb(254,217,166)'],
        [0.52157, 'rgb(254,217,166)'],
        [0.52549, 'rgb(254,217,166)'],
        [0.52941, 'rgb(254,217,166)'],
        [0.53333, 'rgb(254,217,166)'],
        [0.53725, 'rgb(254,217,166)'],
        [0.54118, 'rgb(254,217,166)'],
        [0.5451, 'rgb(254,217,166)'],
        [0.54902, 'rgb(254,217,166)'],
        [0.55294, 'rgb(254,217,166)'],
        [0.55686, 'rgb(255,255,204)'],
        [0.56078, 'rgb(255,255,204)'],
        [0.56471, 'rgb(255,255,204)'],
        [0.56863, 'rgb(255,255,204)'],
        [0.57255, 'rgb(255,255,204)'],
        [0.57647, 'rgb(255,255,204)'],
        [0.58039, 'rgb(255,255,204)'],
        [0.58431, 'rgb(255,255,204)'],
        [0.58824, 'rgb(255,255,204)'],
        [0.59216, 'rgb(255,255,204)'],
        [0.59608, 'rgb(255,255,204)'],
        [0.6, 'rgb(255,255,204)'],
        [0.60392, 'rgb(255,255,204)'],
        [0.60784, 'rgb(255,255,204)'],
        [0.61176, 'rgb(255,255,204)'],
        [0.61569, 'rgb(255,255,204)'],
        [0.61961, 'rgb(255,255,204)'],
        [0.62353, 'rgb(255,255,204)'],
        [0.62745, 'rgb(255,255,204)'],
        [0.63137, 'rgb(255,255,204)'],
        [0.63529, 'rgb(255,255,204)'],
        [0.63922, 'rgb(255,255,204)'],
        [0.64314, 'rgb(255,255,204)'],
        [0.64706, 'rgb(255,255,204)'],
        [0.65098, 'rgb(255,255,204)'],
        [0.6549, 'rgb(255,255,204)'],
        [0.65882, 'rgb(255,255,204)'],
        [0.66275, 'rgb(255,255,204)'],
        [0.66667, 'rgb(229,216,189)'],
        [0.67059, 'rgb(229,216,189)'],
        [0.67451, 'rgb(229,216,189)'],
        [0.67843, 'rgb(229,216,189)'],
        [0.68235, 'rgb(229,216,189)'],
        [0.68627, 'rgb(229,216,189)'],
        [0.6902, 'rgb(229,216,189)'],
        [0.69412, 'rgb(229,216,189)'],
        [0.69804, 'rgb(229,216,189)'],
        [0.70196, 'rgb(229,216,189)'],
        [0.70588, 'rgb(229,216,189)'],
        [0.7098, 'rgb(229,216,189)'],
        [0.71373, 'rgb(229,216,189)'],
        [0.71765, 'rgb(229,216,189)'],
        [0.72157, 'rgb(229,216,189)'],
        [0.72549, 'rgb(229,216,189)'],
        [0.72941, 'rgb(229,216,189)'],
        [0.73333, 'rgb(229,216,189)'],
        [0.73725, 'rgb(229,216,189)'],
        [0.74118, 'rgb(229,216,189)'],
        [0.7451, 'rgb(229,216,189)'],
        [0.74902, 'rgb(229,216,189)'],
        [0.75294, 'rgb(229,216,189)'],
        [0.75686, 'rgb(229,216,189)'],
        [0.76078, 'rgb(229,216,189)'],
        [0.76471, 'rgb(229,216,189)'],
        [0.76863, 'rgb(229,216,189)'],
        [0.77255, 'rgb(229,216,189)'],
        [0.77647, 'rgb(229,216,189)'],
        [0.78039, 'rgb(253,218,236)'],
        [0.78431, 'rgb(253,218,236)'],
        [0.78824, 'rgb(253,218,236)'],
        [0.79216, 'rgb(253,218,236)'],
        [0.79608, 'rgb(253,218,236)'],
        [0.8, 'rgb(253,218,236)'],
        [0.80392, 'rgb(253,218,236)'],
        [0.80784, 'rgb(253,218,236)'],
        [0.81176, 'rgb(253,218,236)'],
        [0.81569, 'rgb(253,218,236)'],
        [0.81961, 'rgb(253,218,236)'],
        [0.82353, 'rgb(253,218,236)'],
        [0.82745, 'rgb(253,218,236)'],
        [0.83137, 'rgb(253,218,236)'],
        [0.83529, 'rgb(253,218,236)'],
        [0.83922, 'rgb(253,218,236)'],
        [0.84314, 'rgb(253,218,236)'],
        [0.84706, 'rgb(253,218,236)'],
        [0.85098, 'rgb(253,218,236)'],
        [0.8549, 'rgb(253,218,236)'],
        [0.85882, 'rgb(253,218,236)'],
        [0.86275, 'rgb(253,218,236)'],
        [0.86667, 'rgb(253,218,236)'],
        [0.87059, 'rgb(253,218,236)'],
        [0.87451, 'rgb(253,218,236)'],
        [0.87843, 'rgb(253,218,236)'],
        [0.88235, 'rgb(253,218,236)'],
        [0.88627, 'rgb(253,218,236)'],
        [0.8902, 'rgb(242,242,242)'],
        [0.89412, 'rgb(242,242,242)'],
        [0.89804, 'rgb(242,242,242)'],
        [0.90196, 'rgb(242,242,242)'],
        [0.90588, 'rgb(242,242,242)'],
        [0.9098, 'rgb(242,242,242)'],
        [0.91373, 'rgb(242,242,242)'],
        [0.91765, 'rgb(242,242,242)'],
        [0.92157, 'rgb(242,242,242)'],
        [0.92549, 'rgb(242,242,242)'],
        [0.92941, 'rgb(242,242,242)'],
        [0.93333, 'rgb(242,242,242)'],
        [0.93725, 'rgb(242,242,242)'],
        [0.94118, 'rgb(242,242,242)'],
        [0.9451, 'rgb(242,242,242)'],
        [0.94902, 'rgb(242,242,242)'],
        [0.95294, 'rgb(242,242,242)'],
        [0.95686, 'rgb(242,242,242)'],
        [0.96078, 'rgb(242,242,242)'],
        [0.96471, 'rgb(242,242,242)'],
        [0.96863, 'rgb(242,242,242)'],
        [0.97255, 'rgb(242,242,242)'],
        [0.97647, 'rgb(242,242,242)'],
        [0.98039, 'rgb(242,242,242)'],
        [0.98431, 'rgb(242,242,242)'],
        [0.98824, 'rgb(242,242,242)'],
        [0.99216, 'rgb(242,242,242)'],
        [0.99608, 'rgb(242,242,242)'],
        [1.0, 'rgb(242,242,242)'],
    ],
    'pastel2': [
        [0.0, 'rgb(179,226,205)'],
        [0.00392, 'rgb(179,226,205)'],
        [0.00784, 'rgb(179,226,205)'],
        [0.01176, 'rgb(179,226,205)'],
        [0.01569, 'rgb(179,226,205)'],
        [0.01961, 'rgb(179,226,205)'],
        [0.02353, 'rgb(179,226,205)'],
        [0.02745, 'rgb(179,226,205)'],
        [0.03137, 'rgb(179,226,205)'],
        [0.03529, 'rgb(179,226,205)'],
        [0.03922, 'rgb(179,226,205)'],
        [0.04314, 'rgb(179,226,205)'],
        [0.04706, 'rgb(179,226,205)'],
        [0.05098, 'rgb(179,226,205)'],
        [0.0549, 'rgb(179,226,205)'],
        [0.05882, 'rgb(179,226,205)'],
        [0.06275, 'rgb(179,226,205)'],
        [0.06667, 'rgb(179,226,205)'],
        [0.07059, 'rgb(179,226,205)'],
        [0.07451, 'rgb(179,226,205)'],
        [0.07843, 'rgb(179,226,205)'],
        [0.08235, 'rgb(179,226,205)'],
        [0.08627, 'rgb(179,226,205)'],
        [0.0902, 'rgb(179,226,205)'],
        [0.09412, 'rgb(179,226,205)'],
        [0.09804, 'rgb(179,226,205)'],
        [0.10196, 'rgb(179,226,205)'],
        [0.10588, 'rgb(179,226,205)'],
        [0.1098, 'rgb(179,226,205)'],
        [0.11373, 'rgb(179,226,205)'],
        [0.11765, 'rgb(179,226,205)'],
        [0.12157, 'rgb(179,226,205)'],
        [0.12549, 'rgb(253,205,172)'],
        [0.12941, 'rgb(253,205,172)'],
        [0.13333, 'rgb(253,205,172)'],
        [0.13725, 'rgb(253,205,172)'],
        [0.14118, 'rgb(253,205,172)'],
        [0.1451, 'rgb(253,205,172)'],
        [0.14902, 'rgb(253,205,172)'],
        [0.15294, 'rgb(253,205,172)'],
        [0.15686, 'rgb(253,205,172)'],
        [0.16078, 'rgb(253,205,172)'],
        [0.16471, 'rgb(253,205,172)'],
        [0.16863, 'rgb(253,205,172)'],
        [0.17255, 'rgb(253,205,172)'],
        [0.17647, 'rgb(253,205,172)'],
        [0.18039, 'rgb(253,205,172)'],
        [0.18431, 'rgb(253,205,172)'],
        [0.18824, 'rgb(253,205,172)'],
        [0.19216, 'rgb(253,205,172)'],
        [0.19608, 'rgb(253,205,172)'],
        [0.2, 'rgb(253,205,172)'],
        [0.20392, 'rgb(253,205,172)'],
        [0.20784, 'rgb(253,205,172)'],
        [0.21176, 'rgb(253,205,172)'],
        [0.21569, 'rgb(253,205,172)'],
        [0.21961, 'rgb(253,205,172)'],
        [0.22353, 'rgb(253,205,172)'],
        [0.22745, 'rgb(253,205,172)'],
        [0.23137, 'rgb(253,205,172)'],
        [0.23529, 'rgb(253,205,172)'],
        [0.23922, 'rgb(253,205,172)'],
        [0.24314, 'rgb(253,205,172)'],
        [0.24706, 'rgb(253,205,172)'],
        [0.25098, 'rgb(203,213,232)'],
        [0.2549, 'rgb(203,213,232)'],
        [0.25882, 'rgb(203,213,232)'],
        [0.26275, 'rgb(203,213,232)'],
        [0.26667, 'rgb(203,213,232)'],
        [0.27059, 'rgb(203,213,232)'],
        [0.27451, 'rgb(203,213,232)'],
        [0.27843, 'rgb(203,213,232)'],
        [0.28235, 'rgb(203,213,232)'],
        [0.28627, 'rgb(203,213,232)'],
        [0.2902, 'rgb(203,213,232)'],
        [0.29412, 'rgb(203,213,232)'],
        [0.29804, 'rgb(203,213,232)'],
        [0.30196, 'rgb(203,213,232)'],
        [0.30588, 'rgb(203,213,232)'],
        [0.3098, 'rgb(203,213,232)'],
        [0.31373, 'rgb(203,213,232)'],
        [0.31765, 'rgb(203,213,232)'],
        [0.32157, 'rgb(203,213,232)'],
        [0.32549, 'rgb(203,213,232)'],
        [0.32941, 'rgb(203,213,232)'],
        [0.33333, 'rgb(203,213,232)'],
        [0.33725, 'rgb(203,213,232)'],
        [0.34118, 'rgb(203,213,232)'],
        [0.3451, 'rgb(203,213,232)'],
        [0.34902, 'rgb(203,213,232)'],
        [0.35294, 'rgb(203,213,232)'],
        [0.35686, 'rgb(203,213,232)'],
        [0.36078, 'rgb(203,213,232)'],
        [0.36471, 'rgb(203,213,232)'],
        [0.36863, 'rgb(203,213,232)'],
        [0.37255, 'rgb(203,213,232)'],
        [0.37647, 'rgb(244,202,228)'],
        [0.38039, 'rgb(244,202,228)'],
        [0.38431, 'rgb(244,202,228)'],
        [0.38824, 'rgb(244,202,228)'],
        [0.39216, 'rgb(244,202,228)'],
        [0.39608, 'rgb(244,202,228)'],
        [0.4, 'rgb(244,202,228)'],
        [0.40392, 'rgb(244,202,228)'],
        [0.40784, 'rgb(244,202,228)'],
        [0.41176, 'rgb(244,202,228)'],
        [0.41569, 'rgb(244,202,228)'],
        [0.41961, 'rgb(244,202,228)'],
        [0.42353, 'rgb(244,202,228)'],
        [0.42745, 'rgb(244,202,228)'],
        [0.43137, 'rgb(244,202,228)'],
        [0.43529, 'rgb(244,202,228)'],
        [0.43922, 'rgb(244,202,228)'],
        [0.44314, 'rgb(244,202,228)'],
        [0.44706, 'rgb(244,202,228)'],
        [0.45098, 'rgb(244,202,228)'],
        [0.4549, 'rgb(244,202,228)'],
        [0.45882, 'rgb(244,202,228)'],
        [0.46275, 'rgb(244,202,228)'],
        [0.46667, 'rgb(244,202,228)'],
        [0.47059, 'rgb(244,202,228)'],
        [0.47451, 'rgb(244,202,228)'],
        [0.47843, 'rgb(244,202,228)'],
        [0.48235, 'rgb(244,202,228)'],
        [0.48627, 'rgb(244,202,228)'],
        [0.4902, 'rgb(244,202,228)'],
        [0.49412, 'rgb(244,202,228)'],
        [0.49804, 'rgb(244,202,228)'],
        [0.50196, 'rgb(230,245,201)'],
        [0.50588, 'rgb(230,245,201)'],
        [0.5098, 'rgb(230,245,201)'],
        [0.51373, 'rgb(230,245,201)'],
        [0.51765, 'rgb(230,245,201)'],
        [0.52157, 'rgb(230,245,201)'],
        [0.52549, 'rgb(230,245,201)'],
        [0.52941, 'rgb(230,245,201)'],
        [0.53333, 'rgb(230,245,201)'],
        [0.53725, 'rgb(230,245,201)'],
        [0.54118, 'rgb(230,245,201)'],
        [0.5451, 'rgb(230,245,201)'],
        [0.54902, 'rgb(230,245,201)'],
        [0.55294, 'rgb(230,245,201)'],
        [0.55686, 'rgb(230,245,201)'],
        [0.56078, 'rgb(230,245,201)'],
        [0.56471, 'rgb(230,245,201)'],
        [0.56863, 'rgb(230,245,201)'],
        [0.57255, 'rgb(230,245,201)'],
        [0.57647, 'rgb(230,245,201)'],
        [0.58039, 'rgb(230,245,201)'],
        [0.58431, 'rgb(230,245,201)'],
        [0.58824, 'rgb(230,245,201)'],
        [0.59216, 'rgb(230,245,201)'],
        [0.59608, 'rgb(230,245,201)'],
        [0.6, 'rgb(230,245,201)'],
        [0.60392, 'rgb(230,245,201)'],
        [0.60784, 'rgb(230,245,201)'],
        [0.61176, 'rgb(230,245,201)'],
        [0.61569, 'rgb(230,245,201)'],
        [0.61961, 'rgb(230,245,201)'],
        [0.62353, 'rgb(230,245,201)'],
        [0.62745, 'rgb(255,242,174)'],
        [0.63137, 'rgb(255,242,174)'],
        [0.63529, 'rgb(255,242,174)'],
        [0.63922, 'rgb(255,242,174)'],
        [0.64314, 'rgb(255,242,174)'],
        [0.64706, 'rgb(255,242,174)'],
        [0.65098, 'rgb(255,242,174)'],
        [0.6549, 'rgb(255,242,174)'],
        [0.65882, 'rgb(255,242,174)'],
        [0.66275, 'rgb(255,242,174)'],
        [0.66667, 'rgb(255,242,174)'],
        [0.67059, 'rgb(255,242,174)'],
        [0.67451, 'rgb(255,242,174)'],
        [0.67843, 'rgb(255,242,174)'],
        [0.68235, 'rgb(255,242,174)'],
        [0.68627, 'rgb(255,242,174)'],
        [0.6902, 'rgb(255,242,174)'],
        [0.69412, 'rgb(255,242,174)'],
        [0.69804, 'rgb(255,242,174)'],
        [0.70196, 'rgb(255,242,174)'],
        [0.70588, 'rgb(255,242,174)'],
        [0.7098, 'rgb(255,242,174)'],
        [0.71373, 'rgb(255,242,174)'],
        [0.71765, 'rgb(255,242,174)'],
        [0.72157, 'rgb(255,242,174)'],
        [0.72549, 'rgb(255,242,174)'],
        [0.72941, 'rgb(255,242,174)'],
        [0.73333, 'rgb(255,242,174)'],
        [0.73725, 'rgb(255,242,174)'],
        [0.74118, 'rgb(255,242,174)'],
        [0.7451, 'rgb(255,242,174)'],
        [0.74902, 'rgb(255,242,174)'],
        [0.75294, 'rgb(241,226,204)'],
        [0.75686, 'rgb(241,226,204)'],
        [0.76078, 'rgb(241,226,204)'],
        [0.76471, 'rgb(241,226,204)'],
        [0.76863, 'rgb(241,226,204)'],
        [0.77255, 'rgb(241,226,204)'],
        [0.77647, 'rgb(241,226,204)'],
        [0.78039, 'rgb(241,226,204)'],
        [0.78431, 'rgb(241,226,204)'],
        [0.78824, 'rgb(241,226,204)'],
        [0.79216, 'rgb(241,226,204)'],
        [0.79608, 'rgb(241,226,204)'],
        [0.8, 'rgb(241,226,204)'],
        [0.80392, 'rgb(241,226,204)'],
        [0.80784, 'rgb(241,226,204)'],
        [0.81176, 'rgb(241,226,204)'],
        [0.81569, 'rgb(241,226,204)'],
        [0.81961, 'rgb(241,226,204)'],
        [0.82353, 'rgb(241,226,204)'],
        [0.82745, 'rgb(241,226,204)'],
        [0.83137, 'rgb(241,226,204)'],
        [0.83529, 'rgb(241,226,204)'],
        [0.83922, 'rgb(241,226,204)'],
        [0.84314, 'rgb(241,226,204)'],
        [0.84706, 'rgb(241,226,204)'],
        [0.85098, 'rgb(241,226,204)'],
        [0.8549, 'rgb(241,226,204)'],
        [0.85882, 'rgb(241,226,204)'],
        [0.86275, 'rgb(241,226,204)'],
        [0.86667, 'rgb(241,226,204)'],
        [0.87059, 'rgb(241,226,204)'],
        [0.87451, 'rgb(241,226,204)'],
        [0.87843, 'rgb(204,204,204)'],
        [0.88235, 'rgb(204,204,204)'],
        [0.88627, 'rgb(204,204,204)'],
        [0.8902, 'rgb(204,204,204)'],
        [0.89412, 'rgb(204,204,204)'],
        [0.89804, 'rgb(204,204,204)'],
        [0.90196, 'rgb(204,204,204)'],
        [0.90588, 'rgb(204,204,204)'],
        [0.9098, 'rgb(204,204,204)'],
        [0.91373, 'rgb(204,204,204)'],
        [0.91765, 'rgb(204,204,204)'],
        [0.92157, 'rgb(204,204,204)'],
        [0.92549, 'rgb(204,204,204)'],
        [0.92941, 'rgb(204,204,204)'],
        [0.93333, 'rgb(204,204,204)'],
        [0.93725, 'rgb(204,204,204)'],
        [0.94118, 'rgb(204,204,204)'],
        [0.9451, 'rgb(204,204,204)'],
        [0.94902, 'rgb(204,204,204)'],
        [0.95294, 'rgb(204,204,204)'],
        [0.95686, 'rgb(204,204,204)'],
        [0.96078, 'rgb(204,204,204)'],
        [0.96471, 'rgb(204,204,204)'],
        [0.96863, 'rgb(204,204,204)'],
        [0.97255, 'rgb(204,204,204)'],
        [0.97647, 'rgb(204,204,204)'],
        [0.98039, 'rgb(204,204,204)'],
        [0.98431, 'rgb(204,204,204)'],
        [0.98824, 'rgb(204,204,204)'],
        [0.99216, 'rgb(204,204,204)'],
        [0.99608, 'rgb(204,204,204)'],
        [1.0, 'rgb(204,204,204)'],
    ],
    'set1': [
        [0.0, 'rgb(228,26,28)'],
        [0.00392, 'rgb(228,26,28)'],
        [0.00784, 'rgb(228,26,28)'],
        [0.01176, 'rgb(228,26,28)'],
        [0.01569, 'rgb(228,26,28)'],
        [0.01961, 'rgb(228,26,28)'],
        [0.02353, 'rgb(228,26,28)'],
        [0.02745, 'rgb(228,26,28)'],
        [0.03137, 'rgb(228,26,28)'],
        [0.03529, 'rgb(228,26,28)'],
        [0.03922, 'rgb(228,26,28)'],
        [0.04314, 'rgb(228,26,28)'],
        [0.04706, 'rgb(228,26,28)'],
        [0.05098, 'rgb(228,26,28)'],
        [0.0549, 'rgb(228,26,28)'],
        [0.05882, 'rgb(228,26,28)'],
        [0.06275, 'rgb(228,26,28)'],
        [0.06667, 'rgb(228,26,28)'],
        [0.07059, 'rgb(228,26,28)'],
        [0.07451, 'rgb(228,26,28)'],
        [0.07843, 'rgb(228,26,28)'],
        [0.08235, 'rgb(228,26,28)'],
        [0.08627, 'rgb(228,26,28)'],
        [0.0902, 'rgb(228,26,28)'],
        [0.09412, 'rgb(228,26,28)'],
        [0.09804, 'rgb(228,26,28)'],
        [0.10196, 'rgb(228,26,28)'],
        [0.10588, 'rgb(228,26,28)'],
        [0.1098, 'rgb(228,26,28)'],
        [0.11373, 'rgb(55,126,184)'],
        [0.11765, 'rgb(55,126,184)'],
        [0.12157, 'rgb(55,126,184)'],
        [0.12549, 'rgb(55,126,184)'],
        [0.12941, 'rgb(55,126,184)'],
        [0.13333, 'rgb(55,126,184)'],
        [0.13725, 'rgb(55,126,184)'],
        [0.14118, 'rgb(55,126,184)'],
        [0.1451, 'rgb(55,126,184)'],
        [0.14902, 'rgb(55,126,184)'],
        [0.15294, 'rgb(55,126,184)'],
        [0.15686, 'rgb(55,126,184)'],
        [0.16078, 'rgb(55,126,184)'],
        [0.16471, 'rgb(55,126,184)'],
        [0.16863, 'rgb(55,126,184)'],
        [0.17255, 'rgb(55,126,184)'],
        [0.17647, 'rgb(55,126,184)'],
        [0.18039, 'rgb(55,126,184)'],
        [0.18431, 'rgb(55,126,184)'],
        [0.18824, 'rgb(55,126,184)'],
        [0.19216, 'rgb(55,126,184)'],
        [0.19608, 'rgb(55,126,184)'],
        [0.2, 'rgb(55,126,184)'],
        [0.20392, 'rgb(55,126,184)'],
        [0.20784, 'rgb(55,126,184)'],
        [0.21176, 'rgb(55,126,184)'],
        [0.21569, 'rgb(55,126,184)'],
        [0.21961, 'rgb(55,126,184)'],
        [0.22353, 'rgb(77,175,74)'],
        [0.22745, 'rgb(77,175,74)'],
        [0.23137, 'rgb(77,175,74)'],
        [0.23529, 'rgb(77,175,74)'],
        [0.23922, 'rgb(77,175,74)'],
        [0.24314, 'rgb(77,175,74)'],
        [0.24706, 'rgb(77,175,74)'],
        [0.25098, 'rgb(77,175,74)'],
        [0.2549, 'rgb(77,175,74)'],
        [0.25882, 'rgb(77,175,74)'],
        [0.26275, 'rgb(77,175,74)'],
        [0.26667, 'rgb(77,175,74)'],
        [0.27059, 'rgb(77,175,74)'],
        [0.27451, 'rgb(77,175,74)'],
        [0.27843, 'rgb(77,175,74)'],
        [0.28235, 'rgb(77,175,74)'],
        [0.28627, 'rgb(77,175,74)'],
        [0.2902, 'rgb(77,175,74)'],
        [0.29412, 'rgb(77,175,74)'],
        [0.29804, 'rgb(77,175,74)'],
        [0.30196, 'rgb(77,175,74)'],
        [0.30588, 'rgb(77,175,74)'],
        [0.3098, 'rgb(77,175,74)'],
        [0.31373, 'rgb(77,175,74)'],
        [0.31765, 'rgb(77,175,74)'],
        [0.32157, 'rgb(77,175,74)'],
        [0.32549, 'rgb(77,175,74)'],
        [0.32941, 'rgb(77,175,74)'],
        [0.33333, 'rgb(77,175,74)'],
        [0.33725, 'rgb(152,78,163)'],
        [0.34118, 'rgb(152,78,163)'],
        [0.3451, 'rgb(152,78,163)'],
        [0.34902, 'rgb(152,78,163)'],
        [0.35294, 'rgb(152,78,163)'],
        [0.35686, 'rgb(152,78,163)'],
        [0.36078, 'rgb(152,78,163)'],
        [0.36471, 'rgb(152,78,163)'],
        [0.36863, 'rgb(152,78,163)'],
        [0.37255, 'rgb(152,78,163)'],
        [0.37647, 'rgb(152,78,163)'],
        [0.38039, 'rgb(152,78,163)'],
        [0.38431, 'rgb(152,78,163)'],
        [0.38824, 'rgb(152,78,163)'],
        [0.39216, 'rgb(152,78,163)'],
        [0.39608, 'rgb(152,78,163)'],
        [0.4, 'rgb(152,78,163)'],
        [0.40392, 'rgb(152,78,163)'],
        [0.40784, 'rgb(152,78,163)'],
        [0.41176, 'rgb(152,78,163)'],
        [0.41569, 'rgb(152,78,163)'],
        [0.41961, 'rgb(152,78,163)'],
        [0.42353, 'rgb(152,78,163)'],
        [0.42745, 'rgb(152,78,163)'],
        [0.43137, 'rgb(152,78,163)'],
        [0.43529, 'rgb(152,78,163)'],
        [0.43922, 'rgb(152,78,163)'],
        [0.44314, 'rgb(152,78,163)'],
        [0.44706, 'rgb(255,127,0)'],
        [0.45098, 'rgb(255,127,0)'],
        [0.4549, 'rgb(255,127,0)'],
        [0.45882, 'rgb(255,127,0)'],
        [0.46275, 'rgb(255,127,0)'],
        [0.46667, 'rgb(255,127,0)'],
        [0.47059, 'rgb(255,127,0)'],
        [0.47451, 'rgb(255,127,0)'],
        [0.47843, 'rgb(255,127,0)'],
        [0.48235, 'rgb(255,127,0)'],
        [0.48627, 'rgb(255,127,0)'],
        [0.4902, 'rgb(255,127,0)'],
        [0.49412, 'rgb(255,127,0)'],
        [0.49804, 'rgb(255,127,0)'],
        [0.50196, 'rgb(255,127,0)'],
        [0.50588, 'rgb(255,127,0)'],
        [0.5098, 'rgb(255,127,0)'],
        [0.51373, 'rgb(255,127,0)'],
        [0.51765, 'rgb(255,127,0)'],
        [0.52157, 'rgb(255,127,0)'],
        [0.52549, 'rgb(255,127,0)'],
        [0.52941, 'rgb(255,127,0)'],
        [0.53333, 'rgb(255,127,0)'],
        [0.53725, 'rgb(255,127,0)'],
        [0.54118, 'rgb(255,127,0)'],
        [0.5451, 'rgb(255,127,0)'],
        [0.54902, 'rgb(255,127,0)'],
        [0.55294, 'rgb(255,127,0)'],
        [0.55686, 'rgb(255,255,51)'],
        [0.56078, 'rgb(255,255,51)'],
        [0.56471, 'rgb(255,255,51)'],
        [0.56863, 'rgb(255,255,51)'],
        [0.57255, 'rgb(255,255,51)'],
        [0.57647, 'rgb(255,255,51)'],
        [0.58039, 'rgb(255,255,51)'],
        [0.58431, 'rgb(255,255,51)'],
        [0.58824, 'rgb(255,255,51)'],
        [0.59216, 'rgb(255,255,51)'],
        [0.59608, 'rgb(255,255,51)'],
        [0.6, 'rgb(255,255,51)'],
        [0.60392, 'rgb(255,255,51)'],
        [0.60784, 'rgb(255,255,51)'],
        [0.61176, 'rgb(255,255,51)'],
        [0.61569, 'rgb(255,255,51)'],
        [0.61961, 'rgb(255,255,51)'],
        [0.62353, 'rgb(255,255,51)'],
        [0.62745, 'rgb(255,255,51)'],
        [0.63137, 'rgb(255,255,51)'],
        [0.63529, 'rgb(255,255,51)'],
        [0.63922, 'rgb(255,255,51)'],
        [0.64314, 'rgb(255,255,51)'],
        [0.64706, 'rgb(255,255,51)'],
        [0.65098, 'rgb(255,255,51)'],
        [0.6549, 'rgb(255,255,51)'],
        [0.65882, 'rgb(255,255,51)'],
        [0.66275, 'rgb(255,255,51)'],
        [0.66667, 'rgb(166,86,40)'],
        [0.67059, 'rgb(166,86,40)'],
        [0.67451, 'rgb(166,86,40)'],
        [0.67843, 'rgb(166,86,40)'],
        [0.68235, 'rgb(166,86,40)'],
        [0.68627, 'rgb(166,86,40)'],
        [0.6902, 'rgb(166,86,40)'],
        [0.69412, 'rgb(166,86,40)'],
        [0.69804, 'rgb(166,86,40)'],
        [0.70196, 'rgb(166,86,40)'],
        [0.70588, 'rgb(166,86,40)'],
        [0.7098, 'rgb(166,86,40)'],
        [0.71373, 'rgb(166,86,40)'],
        [0.71765, 'rgb(166,86,40)'],
        [0.72157, 'rgb(166,86,40)'],
        [0.72549, 'rgb(166,86,40)'],
        [0.72941, 'rgb(166,86,40)'],
        [0.73333, 'rgb(166,86,40)'],
        [0.73725, 'rgb(166,86,40)'],
        [0.74118, 'rgb(166,86,40)'],
        [0.7451, 'rgb(166,86,40)'],
        [0.74902, 'rgb(166,86,40)'],
        [0.75294, 'rgb(166,86,40)'],
        [0.75686, 'rgb(166,86,40)'],
        [0.76078, 'rgb(166,86,40)'],
        [0.76471, 'rgb(166,86,40)'],
        [0.76863, 'rgb(166,86,40)'],
        [0.77255, 'rgb(166,86,40)'],
        [0.77647, 'rgb(166,86,40)'],
        [0.78039, 'rgb(247,129,191)'],
        [0.78431, 'rgb(247,129,191)'],
        [0.78824, 'rgb(247,129,191)'],
        [0.79216, 'rgb(247,129,191)'],
        [0.79608, 'rgb(247,129,191)'],
        [0.8, 'rgb(247,129,191)'],
        [0.80392, 'rgb(247,129,191)'],
        [0.80784, 'rgb(247,129,191)'],
        [0.81176, 'rgb(247,129,191)'],
        [0.81569, 'rgb(247,129,191)'],
        [0.81961, 'rgb(247,129,191)'],
        [0.82353, 'rgb(247,129,191)'],
        [0.82745, 'rgb(247,129,191)'],
        [0.83137, 'rgb(247,129,191)'],
        [0.83529, 'rgb(247,129,191)'],
        [0.83922, 'rgb(247,129,191)'],
        [0.84314, 'rgb(247,129,191)'],
        [0.84706, 'rgb(247,129,191)'],
        [0.85098, 'rgb(247,129,191)'],
        [0.8549, 'rgb(247,129,191)'],
        [0.85882, 'rgb(247,129,191)'],
        [0.86275, 'rgb(247,129,191)'],
        [0.86667, 'rgb(247,129,191)'],
        [0.87059, 'rgb(247,129,191)'],
        [0.87451, 'rgb(247,129,191)'],
        [0.87843, 'rgb(247,129,191)'],
        [0.88235, 'rgb(247,129,191)'],
        [0.88627, 'rgb(247,129,191)'],
        [0.8902, 'rgb(153,153,153)'],
        [0.89412, 'rgb(153,153,153)'],
        [0.89804, 'rgb(153,153,153)'],
        [0.90196, 'rgb(153,153,153)'],
        [0.90588, 'rgb(153,153,153)'],
        [0.9098, 'rgb(153,153,153)'],
        [0.91373, 'rgb(153,153,153)'],
        [0.91765, 'rgb(153,153,153)'],
        [0.92157, 'rgb(153,153,153)'],
        [0.92549, 'rgb(153,153,153)'],
        [0.92941, 'rgb(153,153,153)'],
        [0.93333, 'rgb(153,153,153)'],
        [0.93725, 'rgb(153,153,153)'],
        [0.94118, 'rgb(153,153,153)'],
        [0.9451, 'rgb(153,153,153)'],
        [0.94902, 'rgb(153,153,153)'],
        [0.95294, 'rgb(153,153,153)'],
        [0.95686, 'rgb(153,153,153)'],
        [0.96078, 'rgb(153,153,153)'],
        [0.96471, 'rgb(153,153,153)'],
        [0.96863, 'rgb(153,153,153)'],
        [0.97255, 'rgb(153,153,153)'],
        [0.97647, 'rgb(153,153,153)'],
        [0.98039, 'rgb(153,153,153)'],
        [0.98431, 'rgb(153,153,153)'],
        [0.98824, 'rgb(153,153,153)'],
        [0.99216, 'rgb(153,153,153)'],
        [0.99608, 'rgb(153,153,153)'],
        [1.0, 'rgb(153,153,153)'],
    ],
    'set2': [
        [0.0, 'rgb(102,194,165)'],
        [0.00392, 'rgb(102,194,165)'],
        [0.00784, 'rgb(102,194,165)'],
        [0.01176, 'rgb(102,194,165)'],
        [0.01569, 'rgb(102,194,165)'],
        [0.01961, 'rgb(102,194,165)'],
        [0.02353, 'rgb(102,194,165)'],
        [0.02745, 'rgb(102,194,165)'],
        [0.03137, 'rgb(102,194,165)'],
        [0.03529, 'rgb(102,194,165)'],
        [0.03922, 'rgb(102,194,165)'],
        [0.04314, 'rgb(102,194,165)'],
        [0.04706, 'rgb(102,194,165)'],
        [0.05098, 'rgb(102,194,165)'],
        [0.0549, 'rgb(102,194,165)'],
        [0.05882, 'rgb(102,194,165)'],
        [0.06275, 'rgb(102,194,165)'],
        [0.06667, 'rgb(102,194,165)'],
        [0.07059, 'rgb(102,194,165)'],
        [0.07451, 'rgb(102,194,165)'],
        [0.07843, 'rgb(102,194,165)'],
        [0.08235, 'rgb(102,194,165)'],
        [0.08627, 'rgb(102,194,165)'],
        [0.0902, 'rgb(102,194,165)'],
        [0.09412, 'rgb(102,194,165)'],
        [0.09804, 'rgb(102,194,165)'],
        [0.10196, 'rgb(102,194,165)'],
        [0.10588, 'rgb(102,194,165)'],
        [0.1098, 'rgb(102,194,165)'],
        [0.11373, 'rgb(102,194,165)'],
        [0.11765, 'rgb(102,194,165)'],
        [0.12157, 'rgb(102,194,165)'],
        [0.12549, 'rgb(252,141,98)'],
        [0.12941, 'rgb(252,141,98)'],
        [0.13333, 'rgb(252,141,98)'],
        [0.13725, 'rgb(252,141,98)'],
        [0.14118, 'rgb(252,141,98)'],
        [0.1451, 'rgb(252,141,98)'],
        [0.14902, 'rgb(252,141,98)'],
        [0.15294, 'rgb(252,141,98)'],
        [0.15686, 'rgb(252,141,98)'],
        [0.16078, 'rgb(252,141,98)'],
        [0.16471, 'rgb(252,141,98)'],
        [0.16863, 'rgb(252,141,98)'],
        [0.17255, 'rgb(252,141,98)'],
        [0.17647, 'rgb(252,141,98)'],
        [0.18039, 'rgb(252,141,98)'],
        [0.18431, 'rgb(252,141,98)'],
        [0.18824, 'rgb(252,141,98)'],
        [0.19216, 'rgb(252,141,98)'],
        [0.19608, 'rgb(252,141,98)'],
        [0.2, 'rgb(252,141,98)'],
        [0.20392, 'rgb(252,141,98)'],
        [0.20784, 'rgb(252,141,98)'],
        [0.21176, 'rgb(252,141,98)'],
        [0.21569, 'rgb(252,141,98)'],
        [0.21961, 'rgb(252,141,98)'],
        [0.22353, 'rgb(252,141,98)'],
        [0.22745, 'rgb(252,141,98)'],
        [0.23137, 'rgb(252,141,98)'],
        [0.23529, 'rgb(252,141,98)'],
        [0.23922, 'rgb(252,141,98)'],
        [0.24314, 'rgb(252,141,98)'],
        [0.24706, 'rgb(252,141,98)'],
        [0.25098, 'rgb(141,160,203)'],
        [0.2549, 'rgb(141,160,203)'],
        [0.25882, 'rgb(141,160,203)'],
        [0.26275, 'rgb(141,160,203)'],
        [0.26667, 'rgb(141,160,203)'],
        [0.27059, 'rgb(141,160,203)'],
        [0.27451, 'rgb(141,160,203)'],
        [0.27843, 'rgb(141,160,203)'],
        [0.28235, 'rgb(141,160,203)'],
        [0.28627, 'rgb(141,160,203)'],
        [0.2902, 'rgb(141,160,203)'],
        [0.29412, 'rgb(141,160,203)'],
        [0.29804, 'rgb(141,160,203)'],
        [0.30196, 'rgb(141,160,203)'],
        [0.30588, 'rgb(141,160,203)'],
        [0.3098, 'rgb(141,160,203)'],
        [0.31373, 'rgb(141,160,203)'],
        [0.31765, 'rgb(141,160,203)'],
        [0.32157, 'rgb(141,160,203)'],
        [0.32549, 'rgb(141,160,203)'],
        [0.32941, 'rgb(141,160,203)'],
        [0.33333, 'rgb(141,160,203)'],
        [0.33725, 'rgb(141,160,203)'],
        [0.34118, 'rgb(141,160,203)'],
        [0.3451, 'rgb(141,160,203)'],
        [0.34902, 'rgb(141,160,203)'],
        [0.35294, 'rgb(141,160,203)'],
        [0.35686, 'rgb(141,160,203)'],
        [0.36078, 'rgb(141,160,203)'],
        [0.36471, 'rgb(141,160,203)'],
        [0.36863, 'rgb(141,160,203)'],
        [0.37255, 'rgb(141,160,203)'],
        [0.37647, 'rgb(231,138,195)'],
        [0.38039, 'rgb(231,138,195)'],
        [0.38431, 'rgb(231,138,195)'],
        [0.38824, 'rgb(231,138,195)'],
        [0.39216, 'rgb(231,138,195)'],
        [0.39608, 'rgb(231,138,195)'],
        [0.4, 'rgb(231,138,195)'],
        [0.40392, 'rgb(231,138,195)'],
        [0.40784, 'rgb(231,138,195)'],
        [0.41176, 'rgb(231,138,195)'],
        [0.41569, 'rgb(231,138,195)'],
        [0.41961, 'rgb(231,138,195)'],
        [0.42353, 'rgb(231,138,195)'],
        [0.42745, 'rgb(231,138,195)'],
        [0.43137, 'rgb(231,138,195)'],
        [0.43529, 'rgb(231,138,195)'],
        [0.43922, 'rgb(231,138,195)'],
        [0.44314, 'rgb(231,138,195)'],
        [0.44706, 'rgb(231,138,195)'],
        [0.45098, 'rgb(231,138,195)'],
        [0.4549, 'rgb(231,138,195)'],
        [0.45882, 'rgb(231,138,195)'],
        [0.46275, 'rgb(231,138,195)'],
        [0.46667, 'rgb(231,138,195)'],
        [0.47059, 'rgb(231,138,195)'],
        [0.47451, 'rgb(231,138,195)'],
        [0.47843, 'rgb(231,138,195)'],
        [0.48235, 'rgb(231,138,195)'],
        [0.48627, 'rgb(231,138,195)'],
        [0.4902, 'rgb(231,138,195)'],
        [0.49412, 'rgb(231,138,195)'],
        [0.49804, 'rgb(231,138,195)'],
        [0.50196, 'rgb(166,216,84)'],
        [0.50588, 'rgb(166,216,84)'],
        [0.5098, 'rgb(166,216,84)'],
        [0.51373, 'rgb(166,216,84)'],
        [0.51765, 'rgb(166,216,84)'],
        [0.52157, 'rgb(166,216,84)'],
        [0.52549, 'rgb(166,216,84)'],
        [0.52941, 'rgb(166,216,84)'],
        [0.53333, 'rgb(166,216,84)'],
        [0.53725, 'rgb(166,216,84)'],
        [0.54118, 'rgb(166,216,84)'],
        [0.5451, 'rgb(166,216,84)'],
        [0.54902, 'rgb(166,216,84)'],
        [0.55294, 'rgb(166,216,84)'],
        [0.55686, 'rgb(166,216,84)'],
        [0.56078, 'rgb(166,216,84)'],
        [0.56471, 'rgb(166,216,84)'],
        [0.56863, 'rgb(166,216,84)'],
        [0.57255, 'rgb(166,216,84)'],
        [0.57647, 'rgb(166,216,84)'],
        [0.58039, 'rgb(166,216,84)'],
        [0.58431, 'rgb(166,216,84)'],
        [0.58824, 'rgb(166,216,84)'],
        [0.59216, 'rgb(166,216,84)'],
        [0.59608, 'rgb(166,216,84)'],
        [0.6, 'rgb(166,216,84)'],
        [0.60392, 'rgb(166,216,84)'],
        [0.60784, 'rgb(166,216,84)'],
        [0.61176, 'rgb(166,216,84)'],
        [0.61569, 'rgb(166,216,84)'],
        [0.61961, 'rgb(166,216,84)'],
        [0.62353, 'rgb(166,216,84)'],
        [0.62745, 'rgb(255,217,47)'],
        [0.63137, 'rgb(255,217,47)'],
        [0.63529, 'rgb(255,217,47)'],
        [0.63922, 'rgb(255,217,47)'],
        [0.64314, 'rgb(255,217,47)'],
        [0.64706, 'rgb(255,217,47)'],
        [0.65098, 'rgb(255,217,47)'],
        [0.6549, 'rgb(255,217,47)'],
        [0.65882, 'rgb(255,217,47)'],
        [0.66275, 'rgb(255,217,47)'],
        [0.66667, 'rgb(255,217,47)'],
        [0.67059, 'rgb(255,217,47)'],
        [0.67451, 'rgb(255,217,47)'],
        [0.67843, 'rgb(255,217,47)'],
        [0.68235, 'rgb(255,217,47)'],
        [0.68627, 'rgb(255,217,47)'],
        [0.6902, 'rgb(255,217,47)'],
        [0.69412, 'rgb(255,217,47)'],
        [0.69804, 'rgb(255,217,47)'],
        [0.70196, 'rgb(255,217,47)'],
        [0.70588, 'rgb(255,217,47)'],
        [0.7098, 'rgb(255,217,47)'],
        [0.71373, 'rgb(255,217,47)'],
        [0.71765, 'rgb(255,217,47)'],
        [0.72157, 'rgb(255,217,47)'],
        [0.72549, 'rgb(255,217,47)'],
        [0.72941, 'rgb(255,217,47)'],
        [0.73333, 'rgb(255,217,47)'],
        [0.73725, 'rgb(255,217,47)'],
        [0.74118, 'rgb(255,217,47)'],
        [0.7451, 'rgb(255,217,47)'],
        [0.74902, 'rgb(255,217,47)'],
        [0.75294, 'rgb(229,196,148)'],
        [0.75686, 'rgb(229,196,148)'],
        [0.76078, 'rgb(229,196,148)'],
        [0.76471, 'rgb(229,196,148)'],
        [0.76863, 'rgb(229,196,148)'],
        [0.77255, 'rgb(229,196,148)'],
        [0.77647, 'rgb(229,196,148)'],
        [0.78039, 'rgb(229,196,148)'],
        [0.78431, 'rgb(229,196,148)'],
        [0.78824, 'rgb(229,196,148)'],
        [0.79216, 'rgb(229,196,148)'],
        [0.79608, 'rgb(229,196,148)'],
        [0.8, 'rgb(229,196,148)'],
        [0.80392, 'rgb(229,196,148)'],
        [0.80784, 'rgb(229,196,148)'],
        [0.81176, 'rgb(229,196,148)'],
        [0.81569, 'rgb(229,196,148)'],
        [0.81961, 'rgb(229,196,148)'],
        [0.82353, 'rgb(229,196,148)'],
        [0.82745, 'rgb(229,196,148)'],
        [0.83137, 'rgb(229,196,148)'],
        [0.83529, 'rgb(229,196,148)'],
        [0.83922, 'rgb(229,196,148)'],
        [0.84314, 'rgb(229,196,148)'],
        [0.84706, 'rgb(229,196,148)'],
        [0.85098, 'rgb(229,196,148)'],
        [0.8549, 'rgb(229,196,148)'],
        [0.85882, 'rgb(229,196,148)'],
        [0.86275, 'rgb(229,196,148)'],
        [0.86667, 'rgb(229,196,148)'],
        [0.87059, 'rgb(229,196,148)'],
        [0.87451, 'rgb(229,196,148)'],
        [0.87843, 'rgb(179,179,179)'],
        [0.88235, 'rgb(179,179,179)'],
        [0.88627, 'rgb(179,179,179)'],
        [0.8902, 'rgb(179,179,179)'],
        [0.89412, 'rgb(179,179,179)'],
        [0.89804, 'rgb(179,179,179)'],
        [0.90196, 'rgb(179,179,179)'],
        [0.90588, 'rgb(179,179,179)'],
        [0.9098, 'rgb(179,179,179)'],
        [0.91373, 'rgb(179,179,179)'],
        [0.91765, 'rgb(179,179,179)'],
        [0.92157, 'rgb(179,179,179)'],
        [0.92549, 'rgb(179,179,179)'],
        [0.92941, 'rgb(179,179,179)'],
        [0.93333, 'rgb(179,179,179)'],
        [0.93725, 'rgb(179,179,179)'],
        [0.94118, 'rgb(179,179,179)'],
        [0.9451, 'rgb(179,179,179)'],
        [0.94902, 'rgb(179,179,179)'],
        [0.95294, 'rgb(179,179,179)'],
        [0.95686, 'rgb(179,179,179)'],
        [0.96078, 'rgb(179,179,179)'],
        [0.96471, 'rgb(179,179,179)'],
        [0.96863, 'rgb(179,179,179)'],
        [0.97255, 'rgb(179,179,179)'],
        [0.97647, 'rgb(179,179,179)'],
        [0.98039, 'rgb(179,179,179)'],
        [0.98431, 'rgb(179,179,179)'],
        [0.98824, 'rgb(179,179,179)'],
        [0.99216, 'rgb(179,179,179)'],
        [0.99608, 'rgb(179,179,179)'],
        [1.0, 'rgb(179,179,179)'],
    ],
    'set3': [
        [0.0, 'rgb(141,211,199)'],
        [0.00392, 'rgb(141,211,199)'],
        [0.00784, 'rgb(141,211,199)'],
        [0.01176, 'rgb(141,211,199)'],
        [0.01569, 'rgb(141,211,199)'],
        [0.01961, 'rgb(141,211,199)'],
        [0.02353, 'rgb(141,211,199)'],
        [0.02745, 'rgb(141,211,199)'],
        [0.03137, 'rgb(141,211,199)'],
        [0.03529, 'rgb(141,211,199)'],
        [0.03922, 'rgb(141,211,199)'],
        [0.04314, 'rgb(141,211,199)'],
        [0.04706, 'rgb(141,211,199)'],
        [0.05098, 'rgb(141,211,199)'],
        [0.0549, 'rgb(141,211,199)'],
        [0.05882, 'rgb(141,211,199)'],
        [0.06275, 'rgb(141,211,199)'],
        [0.06667, 'rgb(141,211,199)'],
        [0.07059, 'rgb(141,211,199)'],
        [0.07451, 'rgb(141,211,199)'],
        [0.07843, 'rgb(141,211,199)'],
        [0.08235, 'rgb(141,211,199)'],
        [0.08627, 'rgb(255,255,179)'],
        [0.0902, 'rgb(255,255,179)'],
        [0.09412, 'rgb(255,255,179)'],
        [0.09804, 'rgb(255,255,179)'],
        [0.10196, 'rgb(255,255,179)'],
        [0.10588, 'rgb(255,255,179)'],
        [0.1098, 'rgb(255,255,179)'],
        [0.11373, 'rgb(255,255,179)'],
        [0.11765, 'rgb(255,255,179)'],
        [0.12157, 'rgb(255,255,179)'],
        [0.12549, 'rgb(255,255,179)'],
        [0.12941, 'rgb(255,255,179)'],
        [0.13333, 'rgb(255,255,179)'],
        [0.13725, 'rgb(255,255,179)'],
        [0.14118, 'rgb(255,255,179)'],
        [0.1451, 'rgb(255,255,179)'],
        [0.14902, 'rgb(255,255,179)'],
        [0.15294, 'rgb(255,255,179)'],
        [0.15686, 'rgb(255,255,179)'],
        [0.16078, 'rgb(255,255,179)'],
        [0.16471, 'rgb(255,255,179)'],
        [0.16863, 'rgb(190,186,218)'],
        [0.17255, 'rgb(190,186,218)'],
        [0.17647, 'rgb(190,186,218)'],
        [0.18039, 'rgb(190,186,218)'],
        [0.18431, 'rgb(190,186,218)'],
        [0.18824, 'rgb(190,186,218)'],
        [0.19216, 'rgb(190,186,218)'],
        [0.19608, 'rgb(190,186,218)'],
        [0.2, 'rgb(190,186,218)'],
        [0.20392, 'rgb(190,186,218)'],
        [0.20784, 'rgb(190,186,218)'],
        [0.21176, 'rgb(190,186,218)'],
        [0.21569, 'rgb(190,186,218)'],
        [0.21961, 'rgb(190,186,218)'],
        [0.22353, 'rgb(190,186,218)'],
        [0.22745, 'rgb(190,186,218)'],
        [0.23137, 'rgb(190,186,218)'],
        [0.23529, 'rgb(190,186,218)'],
        [0.23922, 'rgb(190,186,218)'],
        [0.24314, 'rgb(190,186,218)'],
        [0.24706, 'rgb(190,186,218)'],
        [0.25098, 'rgb(251,128,114)'],
        [0.2549, 'rgb(251,128,114)'],
        [0.25882, 'rgb(251,128,114)'],
        [0.26275, 'rgb(251,128,114)'],
        [0.26667, 'rgb(251,128,114)'],
        [0.27059, 'rgb(251,128,114)'],
        [0.27451, 'rgb(251,128,114)'],
        [0.27843, 'rgb(251,128,114)'],
        [0.28235, 'rgb(251,128,114)'],
        [0.28627, 'rgb(251,128,114)'],
        [0.2902, 'rgb(251,128,114)'],
        [0.29412, 'rgb(251,128,114)'],
        [0.29804, 'rgb(251,128,114)'],
        [0.30196, 'rgb(251,128,114)'],
        [0.30588, 'rgb(251,128,114)'],
        [0.3098, 'rgb(251,128,114)'],
        [0.31373, 'rgb(251,128,114)'],
        [0.31765, 'rgb(251,128,114)'],
        [0.32157, 'rgb(251,128,114)'],
        [0.32549, 'rgb(251,128,114)'],
        [0.32941, 'rgb(251,128,114)'],
        [0.33333, 'rgb(251,128,114)'],
        [0.33725, 'rgb(128,177,211)'],
        [0.34118, 'rgb(128,177,211)'],
        [0.3451, 'rgb(128,177,211)'],
        [0.34902, 'rgb(128,177,211)'],
        [0.35294, 'rgb(128,177,211)'],
        [0.35686, 'rgb(128,177,211)'],
        [0.36078, 'rgb(128,177,211)'],
        [0.36471, 'rgb(128,177,211)'],
        [0.36863, 'rgb(128,177,211)'],
        [0.37255, 'rgb(128,177,211)'],
        [0.37647, 'rgb(128,177,211)'],
        [0.38039, 'rgb(128,177,211)'],
        [0.38431, 'rgb(128,177,211)'],
        [0.38824, 'rgb(128,177,211)'],
        [0.39216, 'rgb(128,177,211)'],
        [0.39608, 'rgb(128,177,211)'],
        [0.4, 'rgb(128,177,211)'],
        [0.40392, 'rgb(128,177,211)'],
        [0.40784, 'rgb(128,177,211)'],
        [0.41176, 'rgb(128,177,211)'],
        [0.41569, 'rgb(128,177,211)'],
        [0.41961, 'rgb(253,180,98)'],
        [0.42353, 'rgb(253,180,98)'],
        [0.42745, 'rgb(253,180,98)'],
        [0.43137, 'rgb(253,180,98)'],
        [0.43529, 'rgb(253,180,98)'],
        [0.43922, 'rgb(253,180,98)'],
        [0.44314, 'rgb(253,180,98)'],
        [0.44706, 'rgb(253,180,98)'],
        [0.45098, 'rgb(253,180,98)'],
        [0.4549, 'rgb(253,180,98)'],
        [0.45882, 'rgb(253,180,98)'],
        [0.46275, 'rgb(253,180,98)'],
        [0.46667, 'rgb(253,180,98)'],
        [0.47059, 'rgb(253,180,98)'],
        [0.47451, 'rgb(253,180,98)'],
        [0.47843, 'rgb(253,180,98)'],
        [0.48235, 'rgb(253,180,98)'],
        [0.48627, 'rgb(253,180,98)'],
        [0.4902, 'rgb(253,180,98)'],
        [0.49412, 'rgb(253,180,98)'],
        [0.49804, 'rgb(253,180,98)'],
        [0.50196, 'rgb(179,222,105)'],
        [0.50588, 'rgb(179,222,105)'],
        [0.5098, 'rgb(179,222,105)'],
        [0.51373, 'rgb(179,222,105)'],
        [0.51765, 'rgb(179,222,105)'],
        [0.52157, 'rgb(179,222,105)'],
        [0.52549, 'rgb(179,222,105)'],
        [0.52941, 'rgb(179,222,105)'],
        [0.53333, 'rgb(179,222,105)'],
        [0.53725, 'rgb(179,222,105)'],
        [0.54118, 'rgb(179,222,105)'],
        [0.5451, 'rgb(179,222,105)'],
        [0.54902, 'rgb(179,222,105)'],
        [0.55294, 'rgb(179,222,105)'],
        [0.55686, 'rgb(179,222,105)'],
        [0.56078, 'rgb(179,222,105)'],
        [0.56471, 'rgb(179,222,105)'],
        [0.56863, 'rgb(179,222,105)'],
        [0.57255, 'rgb(179,222,105)'],
        [0.57647, 'rgb(179,222,105)'],
        [0.58039, 'rgb(179,222,105)'],
        [0.58431, 'rgb(252,205,229)'],
        [0.58824, 'rgb(252,205,229)'],
        [0.59216, 'rgb(252,205,229)'],
        [0.59608, 'rgb(252,205,229)'],
        [0.6, 'rgb(252,205,229)'],
        [0.60392, 'rgb(252,205,229)'],
        [0.60784, 'rgb(252,205,229)'],
        [0.61176, 'rgb(252,205,229)'],
        [0.61569, 'rgb(252,205,229)'],
        [0.61961, 'rgb(252,205,229)'],
        [0.62353, 'rgb(252,205,229)'],
        [0.62745, 'rgb(252,205,229)'],
        [0.63137, 'rgb(252,205,229)'],
        [0.63529, 'rgb(252,205,229)'],
        [0.63922, 'rgb(252,205,229)'],
        [0.64314, 'rgb(252,205,229)'],
        [0.64706, 'rgb(252,205,229)'],
        [0.65098, 'rgb(252,205,229)'],
        [0.6549, 'rgb(252,205,229)'],
        [0.65882, 'rgb(252,205,229)'],
        [0.66275, 'rgb(252,205,229)'],
        [0.66667, 'rgb(217,217,217)'],
        [0.67059, 'rgb(217,217,217)'],
        [0.67451, 'rgb(217,217,217)'],
        [0.67843, 'rgb(217,217,217)'],
        [0.68235, 'rgb(217,217,217)'],
        [0.68627, 'rgb(217,217,217)'],
        [0.6902, 'rgb(217,217,217)'],
        [0.69412, 'rgb(217,217,217)'],
        [0.69804, 'rgb(217,217,217)'],
        [0.70196, 'rgb(217,217,217)'],
        [0.70588, 'rgb(217,217,217)'],
        [0.7098, 'rgb(217,217,217)'],
        [0.71373, 'rgb(217,217,217)'],
        [0.71765, 'rgb(217,217,217)'],
        [0.72157, 'rgb(217,217,217)'],
        [0.72549, 'rgb(217,217,217)'],
        [0.72941, 'rgb(217,217,217)'],
        [0.73333, 'rgb(217,217,217)'],
        [0.73725, 'rgb(217,217,217)'],
        [0.74118, 'rgb(217,217,217)'],
        [0.7451, 'rgb(217,217,217)'],
        [0.74902, 'rgb(217,217,217)'],
        [0.75294, 'rgb(188,128,189)'],
        [0.75686, 'rgb(188,128,189)'],
        [0.76078, 'rgb(188,128,189)'],
        [0.76471, 'rgb(188,128,189)'],
        [0.76863, 'rgb(188,128,189)'],
        [0.77255, 'rgb(188,128,189)'],
        [0.77647, 'rgb(188,128,189)'],
        [0.78039, 'rgb(188,128,189)'],
        [0.78431, 'rgb(188,128,189)'],
        [0.78824, 'rgb(188,128,189)'],
        [0.79216, 'rgb(188,128,189)'],
        [0.79608, 'rgb(188,128,189)'],
        [0.8, 'rgb(188,128,189)'],
        [0.80392, 'rgb(188,128,189)'],
        [0.80784, 'rgb(188,128,189)'],
        [0.81176, 'rgb(188,128,189)'],
        [0.81569, 'rgb(188,128,189)'],
        [0.81961, 'rgb(188,128,189)'],
        [0.82353, 'rgb(188,128,189)'],
        [0.82745, 'rgb(188,128,189)'],
        [0.83137, 'rgb(188,128,189)'],
        [0.83529, 'rgb(204,235,197)'],
        [0.83922, 'rgb(204,235,197)'],
        [0.84314, 'rgb(204,235,197)'],
        [0.84706, 'rgb(204,235,197)'],
        [0.85098, 'rgb(204,235,197)'],
        [0.8549, 'rgb(204,235,197)'],
        [0.85882, 'rgb(204,235,197)'],
        [0.86275, 'rgb(204,235,197)'],
        [0.86667, 'rgb(204,235,197)'],
        [0.87059, 'rgb(204,235,197)'],
        [0.87451, 'rgb(204,235,197)'],
        [0.87843, 'rgb(204,235,197)'],
        [0.88235, 'rgb(204,235,197)'],
        [0.88627, 'rgb(204,235,197)'],
        [0.8902, 'rgb(204,235,197)'],
        [0.89412, 'rgb(204,235,197)'],
        [0.89804, 'rgb(204,235,197)'],
        [0.90196, 'rgb(204,235,197)'],
        [0.90588, 'rgb(204,235,197)'],
        [0.9098, 'rgb(204,235,197)'],
        [0.91373, 'rgb(204,235,197)'],
        [0.91765, 'rgb(255,237,111)'],
        [0.92157, 'rgb(255,237,111)'],
        [0.92549, 'rgb(255,237,111)'],
        [0.92941, 'rgb(255,237,111)'],
        [0.93333, 'rgb(255,237,111)'],
        [0.93725, 'rgb(255,237,111)'],
        [0.94118, 'rgb(255,237,111)'],
        [0.9451, 'rgb(255,237,111)'],
        [0.94902, 'rgb(255,237,111)'],
        [0.95294, 'rgb(255,237,111)'],
        [0.95686, 'rgb(255,237,111)'],
        [0.96078, 'rgb(255,237,111)'],
        [0.96471, 'rgb(255,237,111)'],
        [0.96863, 'rgb(255,237,111)'],
        [0.97255, 'rgb(255,237,111)'],
        [0.97647, 'rgb(255,237,111)'],
        [0.98039, 'rgb(255,237,111)'],
        [0.98431, 'rgb(255,237,111)'],
        [0.98824, 'rgb(255,237,111)'],
        [0.99216, 'rgb(255,237,111)'],
        [0.99608, 'rgb(255,237,111)'],
        [1.0, 'rgb(255,237,111)'],
    ],
    'wistia': [
        [0.0, 'rgb(228,255,122)'],
        [0.00392, 'rgb(228,254,120)'],
        [0.00784, 'rgb(228,254,118)'],
        [0.01176, 'rgb(229,253,117)'],
        [0.01569, 'rgb(229,253,115)'],
        [0.01961, 'rgb(230,253,114)'],
        [0.02353, 'rgb(230,252,112)'],
        [0.02745, 'rgb(230,252,111)'],
        [0.03137, 'rgb(231,252,109)'],
        [0.03529, 'rgb(231,251,108)'],
        [0.03922, 'rgb(232,251,106)'],
        [0.04314, 'rgb(232,251,105)'],
        [0.04706, 'rgb(233,250,103)'],
        [0.05098, 'rgb(233,250,102)'],
        [0.0549, 'rgb(233,249,100)'],
        [0.05882, 'rgb(234,249,99)'],
        [0.06275, 'rgb(234,249,97)'],
        [0.06667, 'rgb(235,248,96)'],
        [0.07059, 'rgb(235,248,94)'],
        [0.07451, 'rgb(236,248,93)'],
        [0.07843, 'rgb(236,247,91)'],
        [0.08235, 'rgb(236,247,90)'],
        [0.08627, 'rgb(237,247,88)'],
        [0.0902, 'rgb(237,246,87)'],
        [0.09412, 'rgb(238,246,85)'],
        [0.09804, 'rgb(238,245,84)'],
        [0.10196, 'rgb(239,245,82)'],
        [0.10588, 'rgb(239,245,81)'],
        [0.1098, 'rgb(239,244,79)'],
        [0.11373, 'rgb(240,244,78)'],
        [0.11765, 'rgb(240,244,76)'],
        [0.12157, 'rgb(241,243,75)'],
        [0.12549, 'rgb(241,243,73)'],
        [0.12941, 'rgb(241,243,72)'],
        [0.13333, 'rgb(242,242,70)'],
        [0.13725, 'rgb(242,242,69)'],
        [0.14118, 'rgb(243,242,67)'],
        [0.1451, 'rgb(243,241,66)'],
        [0.14902, 'rgb(244,241,64)'],
        [0.15294, 'rgb(244,240,63)'],
        [0.15686, 'rgb(244,240,61)'],
        [0.16078, 'rgb(245,240,60)'],
        [0.16471, 'rgb(245,239,58)'],
        [0.16863, 'rgb(246,239,57)'],
        [0.17255, 'rgb(246,239,55)'],
        [0.17647, 'rgb(247,238,54)'],
        [0.18039, 'rgb(247,238,52)'],
        [0.18431, 'rgb(247,238,51)'],
        [0.18824, 'rgb(248,237,49)'],
        [0.19216, 'rgb(248,237,48)'],
        [0.19608, 'rgb(249,236,46)'],
        [0.2, 'rgb(249,236,45)'],
        [0.20392, 'rgb(250,236,43)'],
        [0.20784, 'rgb(250,235,42)'],
        [0.21176, 'rgb(250,235,40)'],
        [0.21569, 'rgb(251,235,39)'],
        [0.21961, 'rgb(251,234,37)'],
        [0.22353, 'rgb(252,234,36)'],
        [0.22745, 'rgb(252,234,34)'],
        [0.23137, 'rgb(252,233,33)'],
        [0.23529, 'rgb(253,233,31)'],
        [0.23922, 'rgb(253,232,30)'],
        [0.24314, 'rgb(254,232,28)'],
        [0.24706, 'rgb(254,232,27)'],
        [0.25098, 'rgb(255,231,25)'],
        [0.2549, 'rgb(255,231,25)'],
        [0.25882, 'rgb(255,230,25)'],
        [0.26275, 'rgb(255,229,24)'],
        [0.26667, 'rgb(255,229,24)'],
        [0.27059, 'rgb(255,228,23)'],
        [0.27451, 'rgb(255,227,23)'],
        [0.27843, 'rgb(255,227,23)'],
        [0.28235, 'rgb(255,226,22)'],
        [0.28627, 'rgb(255,225,22)'],
        [0.2902, 'rgb(255,225,21)'],
        [0.29412, 'rgb(255,224,21)'],
        [0.29804, 'rgb(255,223,21)'],
        [0.30196, 'rgb(255,223,20)'],
        [0.30588, 'rgb(255,222,20)'],
        [0.3098, 'rgb(255,221,19)'],
        [0.31373, 'rgb(255,221,19)'],
        [0.31765, 'rgb(255,220,18)'],
        [0.32157, 'rgb(255,219,18)'],
        [0.32549, 'rgb(255,219,18)'],
        [0.32941, 'rgb(255,218,17)'],
        [0.33333, 'rgb(255,217,17)'],
        [0.33725, 'rgb(255,216,16)'],
        [0.34118, 'rgb(255,216,16)'],
        [0.3451, 'rgb(255,215,16)'],
        [0.34902, 'rgb(255,214,15)'],
        [0.35294, 'rgb(255,214,15)'],
        [0.35686, 'rgb(255,213,14)'],
        [0.36078, 'rgb(255,212,14)'],
        [0.36471, 'rgb(255,212,14)'],
        [0.36863, 'rgb(255,211,13)'],
        [0.37255, 'rgb(255,210,13)'],
        [0.37647, 'rgb(255,210,12)'],
        [0.38039, 'rgb(255,209,12)'],
        [0.38431, 'rgb(255,208,12)'],
        [0.38824, 'rgb(255,208,11)'],
        [0.39216, 'rgb(255,207,11)'],
        [0.39608, 'rgb(255,206,10)'],
        [0.4, 'rgb(255,206,10)'],
        [0.40392, 'rgb(255,205,9)'],
        [0.40784, 'rgb(255,204,9)'],
        [0.41176, 'rgb(255,204,9)'],
        [0.41569, 'rgb(255,203,8)'],
        [0.41961, 'rgb(255,202,8)'],
        [0.42353, 'rgb(255,202,7)'],
        [0.42745, 'rgb(255,201,7)'],
        [0.43137, 'rgb(255,200,7)'],
        [0.43529, 'rgb(255,200,6)'],
        [0.43922, 'rgb(255,199,6)'],
        [0.44314, 'rgb(255,198,5)'],
        [0.44706, 'rgb(255,198,5)'],
        [0.45098, 'rgb(255,197,5)'],
        [0.4549, 'rgb(255,196,4)'],
        [0.45882, 'rgb(255,196,4)'],
        [0.46275, 'rgb(255,195,3)'],
        [0.46667, 'rgb(255,194,3)'],
        [0.47059, 'rgb(255,194,3)'],
        [0.47451, 'rgb(255,193,2)'],
        [0.47843, 'rgb(255,192,2)'],
        [0.48235, 'rgb(255,192,1)'],
        [0.48627, 'rgb(255,191,1)'],
        [0.4902, 'rgb(255,190,1)'],
        [0.49412, 'rgb(255,190,0)'],
        [0.49804, 'rgb(255,189,0)'],
        [0.50196, 'rgb(255,188,0)'],
        [0.50588, 'rgb(255,188,0)'],
        [0.5098, 'rgb(255,187,0)'],
        [0.51373, 'rgb(255,187,0)'],
        [0.51765, 'rgb(255,186,0)'],
        [0.52157, 'rgb(255,186,0)'],
        [0.52549, 'rgb(255,186,0)'],
        [0.52941, 'rgb(255,185,0)'],
        [0.53333, 'rgb(255,185,0)'],
        [0.53725, 'rgb(255,184,0)'],
        [0.54118, 'rgb(255,184,0)'],
        [0.5451, 'rgb(255,183,0)'],
        [0.54902, 'rgb(255,183,0)'],
        [0.55294, 'rgb(255,182,0)'],
        [0.55686, 'rgb(255,182,0)'],
        [0.56078, 'rgb(255,181,0)'],
        [0.56471, 'rgb(255,181,0)'],
        [0.56863, 'rgb(255,181,0)'],
        [0.57255, 'rgb(255,180,0)'],
        [0.57647, 'rgb(255,180,0)'],
        [0.58039, 'rgb(255,179,0)'],
        [0.58431, 'rgb(255,179,0)'],
        [0.58824, 'rgb(255,178,0)'],
        [0.59216, 'rgb(255,178,0)'],
        [0.59608, 'rgb(255,177,0)'],
        [0.6, 'rgb(255,177,0)'],
        [0.60392, 'rgb(255,176,0)'],
        [0.60784, 'rgb(255,176,0)'],
        [0.61176, 'rgb(255,176,0)'],
        [0.61569, 'rgb(255,175,0)'],
        [0.61961, 'rgb(255,175,0)'],
        [0.62353, 'rgb(255,174,0)'],
        [0.62745, 'rgb(255,174,0)'],
        [0.63137, 'rgb(255,173,0)'],
        [0.63529, 'rgb(255,173,0)'],
        [0.63922, 'rgb(255,172,0)'],
        [0.64314, 'rgb(255,172,0)'],
        [0.64706, 'rgb(255,171,0)'],
        [0.65098, 'rgb(255,171,0)'],
        [0.6549, 'rgb(255,171,0)'],
        [0.65882, 'rgb(255,170,0)'],
        [0.66275, 'rgb(255,170,0)'],
        [0.66667, 'rgb(255,169,0)'],
        [0.67059, 'rgb(255,169,0)'],
        [0.67451, 'rgb(255,168,0)'],
        [0.67843, 'rgb(255,168,0)'],
        [0.68235, 'rgb(255,167,0)'],
        [0.68627, 'rgb(255,167,0)'],
        [0.6902, 'rgb(255,166,0)'],
        [0.69412, 'rgb(255,166,0)'],
        [0.69804, 'rgb(255,166,0)'],
        [0.70196, 'rgb(255,165,0)'],
        [0.70588, 'rgb(255,165,0)'],
        [0.7098, 'rgb(255,164,0)'],
        [0.71373, 'rgb(255,164,0)'],
        [0.71765, 'rgb(255,163,0)'],
        [0.72157, 'rgb(255,163,0)'],
        [0.72549, 'rgb(255,162,0)'],
        [0.72941, 'rgb(255,162,0)'],
        [0.73333, 'rgb(255,161,0)'],
        [0.73725, 'rgb(255,161,0)'],
        [0.74118, 'rgb(255,161,0)'],
        [0.7451, 'rgb(255,160,0)'],
        [0.74902, 'rgb(255,160,0)'],
        [0.75294, 'rgb(254,159,0)'],
        [0.75686, 'rgb(254,159,0)'],
        [0.76078, 'rgb(254,158,0)'],
        [0.76471, 'rgb(254,158,0)'],
        [0.76863, 'rgb(254,157,0)'],
        [0.77255, 'rgb(254,157,0)'],
        [0.77647, 'rgb(254,156,0)'],
        [0.78039, 'rgb(254,155,0)'],
        [0.78431, 'rgb(254,155,0)'],
        [0.78824, 'rgb(254,154,0)'],
        [0.79216, 'rgb(254,154,0)'],
        [0.79608, 'rgb(254,153,0)'],
        [0.8, 'rgb(254,153,0)'],
        [0.80392, 'rgb(254,152,0)'],
        [0.80784, 'rgb(254,152,0)'],
        [0.81176, 'rgb(254,151,0)'],
        [0.81569, 'rgb(254,151,0)'],
        [0.81961, 'rgb(254,150,0)'],
        [0.82353, 'rgb(254,150,0)'],
        [0.82745, 'rgb(254,149,0)'],
        [0.83137, 'rgb(254,149,0)'],
        [0.83529, 'rgb(253,148,0)'],
        [0.83922, 'rgb(253,148,0)'],
        [0.84314, 'rgb(253,147,0)'],
        [0.84706, 'rgb(253,147,0)'],
        [0.85098, 'rgb(253,146,0)'],
        [0.8549, 'rgb(253,146,0)'],
        [0.85882, 'rgb(253,145,0)'],
        [0.86275, 'rgb(253,145,0)'],
        [0.86667, 'rgb(253,144,0)'],
        [0.87059, 'rgb(253,144,0)'],
        [0.87451, 'rgb(253,143,0)'],
        [0.87843, 'rgb(253,143,0)'],
        [0.88235, 'rgb(253,142,0)'],
        [0.88627, 'rgb(253,142,0)'],
        [0.8902, 'rgb(253,141,0)'],
        [0.89412, 'rgb(253,140,0)'],
        [0.89804, 'rgb(253,140,0)'],
        [0.90196, 'rgb(253,139,0)'],
        [0.90588, 'rgb(253,139,0)'],
        [0.9098, 'rgb(253,138,0)'],
        [0.91373, 'rgb(253,138,0)'],
        [0.91765, 'rgb(252,137,0)'],
        [0.92157, 'rgb(252,137,0)'],
        [0.92549, 'rgb(252,136,0)'],
        [0.92941, 'rgb(252,136,0)'],
        [0.93333, 'rgb(252,135,0)'],
        [0.93725, 'rgb(252,135,0)'],
        [0.94118, 'rgb(252,134,0)'],
        [0.9451, 'rgb(252,134,0)'],
        [0.94902, 'rgb(252,133,0)'],
        [0.95294, 'rgb(252,133,0)'],
        [0.95686, 'rgb(252,132,0)'],
        [0.96078, 'rgb(252,132,0)'],
        [0.96471, 'rgb(252,131,0)'],
        [0.96863, 'rgb(252,131,0)'],
        [0.97255, 'rgb(252,130,0)'],
        [0.97647, 'rgb(252,130,0)'],
        [0.98039, 'rgb(252,129,0)'],
        [0.98431, 'rgb(252,129,0)'],
        [0.98824, 'rgb(252,128,0)'],
        [0.99216, 'rgb(252,128,0)'],
        [0.99608, 'rgb(252,127,0)'],
        [1.0, 'rgb(252,127,0)'],
    ],
    'afmhot': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(2,0,0)'],
        [0.00784, 'rgb(4,0,0)'],
        [0.01176, 'rgb(6,0,0)'],
        [0.01569, 'rgb(8,0,0)'],
        [0.01961, 'rgb(10,0,0)'],
        [0.02353, 'rgb(12,0,0)'],
        [0.02745, 'rgb(14,0,0)'],
        [0.03137, 'rgb(16,0,0)'],
        [0.03529, 'rgb(18,0,0)'],
        [0.03922, 'rgb(20,0,0)'],
        [0.04314, 'rgb(22,0,0)'],
        [0.04706, 'rgb(24,0,0)'],
        [0.05098, 'rgb(26,0,0)'],
        [0.0549, 'rgb(28,0,0)'],
        [0.05882, 'rgb(30,0,0)'],
        [0.06275, 'rgb(32,0,0)'],
        [0.06667, 'rgb(34,0,0)'],
        [0.07059, 'rgb(36,0,0)'],
        [0.07451, 'rgb(38,0,0)'],
        [0.07843, 'rgb(40,0,0)'],
        [0.08235, 'rgb(42,0,0)'],
        [0.08627, 'rgb(44,0,0)'],
        [0.0902, 'rgb(46,0,0)'],
        [0.09412, 'rgb(48,0,0)'],
        [0.09804, 'rgb(50,0,0)'],
        [0.10196, 'rgb(52,0,0)'],
        [0.10588, 'rgb(54,0,0)'],
        [0.1098, 'rgb(56,0,0)'],
        [0.11373, 'rgb(58,0,0)'],
        [0.11765, 'rgb(60,0,0)'],
        [0.12157, 'rgb(62,0,0)'],
        [0.12549, 'rgb(64,0,0)'],
        [0.12941, 'rgb(65,0,0)'],
        [0.13333, 'rgb(68,0,0)'],
        [0.13725, 'rgb(70,0,0)'],
        [0.14118, 'rgb(72,0,0)'],
        [0.1451, 'rgb(73,0,0)'],
        [0.14902, 'rgb(76,0,0)'],
        [0.15294, 'rgb(78,0,0)'],
        [0.15686, 'rgb(80,0,0)'],
        [0.16078, 'rgb(81,0,0)'],
        [0.16471, 'rgb(84,0,0)'],
        [0.16863, 'rgb(86,0,0)'],
        [0.17255, 'rgb(88,0,0)'],
        [0.17647, 'rgb(89,0,0)'],
        [0.18039, 'rgb(92,0,0)'],
        [0.18431, 'rgb(94,0,0)'],
        [0.18824, 'rgb(96,0,0)'],
        [0.19216, 'rgb(97,0,0)'],
        [0.19608, 'rgb(100,0,0)'],
        [0.2, 'rgb(102,0,0)'],
        [0.20392, 'rgb(104,0,0)'],
        [0.20784, 'rgb(105,0,0)'],
        [0.21176, 'rgb(108,0,0)'],
        [0.21569, 'rgb(110,0,0)'],
        [0.21961, 'rgb(112,0,0)'],
        [0.22353, 'rgb(113,0,0)'],
        [0.22745, 'rgb(116,0,0)'],
        [0.23137, 'rgb(118,0,0)'],
        [0.23529, 'rgb(120,0,0)'],
        [0.23922, 'rgb(121,0,0)'],
        [0.24314, 'rgb(124,0,0)'],
        [0.24706, 'rgb(126,0,0)'],
        [0.25098, 'rgb(128,0,0)'],
        [0.2549, 'rgb(130,2,0)'],
        [0.25882, 'rgb(131,4,0)'],
        [0.26275, 'rgb(134,6,0)'],
        [0.26667, 'rgb(136,8,0)'],
        [0.27059, 'rgb(138,10,0)'],
        [0.27451, 'rgb(140,12,0)'],
        [0.27843, 'rgb(142,14,0)'],
        [0.28235, 'rgb(144,16,0)'],
        [0.28627, 'rgb(146,18,0)'],
        [0.2902, 'rgb(147,20,0)'],
        [0.29412, 'rgb(150,22,0)'],
        [0.29804, 'rgb(152,24,0)'],
        [0.30196, 'rgb(154,26,0)'],
        [0.30588, 'rgb(156,28,0)'],
        [0.3098, 'rgb(158,30,0)'],
        [0.31373, 'rgb(160,32,0)'],
        [0.31765, 'rgb(162,34,0)'],
        [0.32157, 'rgb(163,36,0)'],
        [0.32549, 'rgb(166,38,0)'],
        [0.32941, 'rgb(168,40,0)'],
        [0.33333, 'rgb(170,42,0)'],
        [0.33725, 'rgb(172,44,0)'],
        [0.34118, 'rgb(174,46,0)'],
        [0.3451, 'rgb(176,48,0)'],
        [0.34902, 'rgb(178,50,0)'],
        [0.35294, 'rgb(179,52,0)'],
        [0.35686, 'rgb(182,54,0)'],
        [0.36078, 'rgb(184,56,0)'],
        [0.36471, 'rgb(186,58,0)'],
        [0.36863, 'rgb(188,60,0)'],
        [0.37255, 'rgb(190,62,0)'],
        [0.37647, 'rgb(192,64,0)'],
        [0.38039, 'rgb(194,66,0)'],
        [0.38431, 'rgb(195,68,0)'],
        [0.38824, 'rgb(198,70,0)'],
        [0.39216, 'rgb(200,72,0)'],
        [0.39608, 'rgb(202,74,0)'],
        [0.4, 'rgb(204,76,0)'],
        [0.40392, 'rgb(206,78,0)'],
        [0.40784, 'rgb(208,80,0)'],
        [0.41176, 'rgb(210,82,0)'],
        [0.41569, 'rgb(211,84,0)'],
        [0.41961, 'rgb(214,86,0)'],
        [0.42353, 'rgb(216,88,0)'],
        [0.42745, 'rgb(218,90,0)'],
        [0.43137, 'rgb(220,92,0)'],
        [0.43529, 'rgb(222,94,0)'],
        [0.43922, 'rgb(224,96,0)'],
        [0.44314, 'rgb(226,98,0)'],
        [0.44706, 'rgb(227,100,0)'],
        [0.45098, 'rgb(230,102,0)'],
        [0.4549, 'rgb(232,104,0)'],
        [0.45882, 'rgb(234,106,0)'],
        [0.46275, 'rgb(236,108,0)'],
        [0.46667, 'rgb(238,110,0)'],
        [0.47059, 'rgb(240,112,0)'],
        [0.47451, 'rgb(242,114,0)'],
        [0.47843, 'rgb(243,116,0)'],
        [0.48235, 'rgb(246,118,0)'],
        [0.48627, 'rgb(248,120,0)'],
        [0.4902, 'rgb(250,122,0)'],
        [0.49412, 'rgb(252,124,0)'],
        [0.49804, 'rgb(254,126,0)'],
        [0.50196, 'rgb(255,128,0)'],
        [0.50588, 'rgb(255,130,2)'],
        [0.5098, 'rgb(255,132,4)'],
        [0.51373, 'rgb(255,134,6)'],
        [0.51765, 'rgb(255,136,8)'],
        [0.52157, 'rgb(255,138,11)'],
        [0.52549, 'rgb(255,140,13)'],
        [0.52941, 'rgb(255,142,15)'],
        [0.53333, 'rgb(255,144,16)'],
        [0.53725, 'rgb(255,146,18)'],
        [0.54118, 'rgb(255,148,20)'],
        [0.5451, 'rgb(255,150,22)'],
        [0.54902, 'rgb(255,152,25)'],
        [0.55294, 'rgb(255,154,27)'],
        [0.55686, 'rgb(255,156,29)'],
        [0.56078, 'rgb(255,158,31)'],
        [0.56471, 'rgb(255,160,32)'],
        [0.56863, 'rgb(255,162,34)'],
        [0.57255, 'rgb(255,164,36)'],
        [0.57647, 'rgb(255,166,38)'],
        [0.58039, 'rgb(255,168,40)'],
        [0.58431, 'rgb(255,170,43)'],
        [0.58824, 'rgb(255,172,45)'],
        [0.59216, 'rgb(255,174,47)'],
        [0.59608, 'rgb(255,176,48)'],
        [0.6, 'rgb(255,178,50)'],
        [0.60392, 'rgb(255,180,52)'],
        [0.60784, 'rgb(255,182,54)'],
        [0.61176, 'rgb(255,184,57)'],
        [0.61569, 'rgb(255,186,59)'],
        [0.61961, 'rgb(255,188,61)'],
        [0.62353, 'rgb(255,190,63)'],
        [0.62745, 'rgb(255,192,65)'],
        [0.63137, 'rgb(255,194,66)'],
        [0.63529, 'rgb(255,196,68)'],
        [0.63922, 'rgb(255,198,70)'],
        [0.64314, 'rgb(255,200,72)'],
        [0.64706, 'rgb(255,202,75)'],
        [0.65098, 'rgb(255,204,77)'],
        [0.6549, 'rgb(255,206,79)'],
        [0.65882, 'rgb(255,208,81)'],
        [0.66275, 'rgb(255,210,82)'],
        [0.66667, 'rgb(255,212,84)'],
        [0.67059, 'rgb(255,214,86)'],
        [0.67451, 'rgb(255,216,89)'],
        [0.67843, 'rgb(255,218,91)'],
        [0.68235, 'rgb(255,220,93)'],
        [0.68627, 'rgb(255,222,95)'],
        [0.6902, 'rgb(255,224,97)'],
        [0.69412, 'rgb(255,226,98)'],
        [0.69804, 'rgb(255,228,100)'],
        [0.70196, 'rgb(255,230,102)'],
        [0.70588, 'rgb(255,232,104)'],
        [0.7098, 'rgb(255,234,107)'],
        [0.71373, 'rgb(255,236,109)'],
        [0.71765, 'rgb(255,238,111)'],
        [0.72157, 'rgb(255,240,113)'],
        [0.72549, 'rgb(255,242,114)'],
        [0.72941, 'rgb(255,244,116)'],
        [0.73333, 'rgb(255,246,118)'],
        [0.73725, 'rgb(255,248,121)'],
        [0.74118, 'rgb(255,250,123)'],
        [0.7451, 'rgb(255,252,125)'],
        [0.74902, 'rgb(255,254,127)'],
        [0.75294, 'rgb(255,255,129)'],
        [0.75686, 'rgb(255,255,131)'],
        [0.76078, 'rgb(255,255,132)'],
        [0.76471, 'rgb(255,255,134)'],
        [0.76863, 'rgb(255,255,136)'],
        [0.77255, 'rgb(255,255,139)'],
        [0.77647, 'rgb(255,255,141)'],
        [0.78039, 'rgb(255,255,143)'],
        [0.78431, 'rgb(255,255,145)'],
        [0.78824, 'rgb(255,255,147)'],
        [0.79216, 'rgb(255,255,148)'],
        [0.79608, 'rgb(255,255,150)'],
        [0.8, 'rgb(255,255,153)'],
        [0.80392, 'rgb(255,255,155)'],
        [0.80784, 'rgb(255,255,157)'],
        [0.81176, 'rgb(255,255,159)'],
        [0.81569, 'rgb(255,255,161)'],
        [0.81961, 'rgb(255,255,163)'],
        [0.82353, 'rgb(255,255,164)'],
        [0.82745, 'rgb(255,255,166)'],
        [0.83137, 'rgb(255,255,168)'],
        [0.83529, 'rgb(255,255,171)'],
        [0.83922, 'rgb(255,255,173)'],
        [0.84314, 'rgb(255,255,175)'],
        [0.84706, 'rgb(255,255,177)'],
        [0.85098, 'rgb(255,255,179)'],
        [0.8549, 'rgb(255,255,180)'],
        [0.85882, 'rgb(255,255,182)'],
        [0.86275, 'rgb(255,255,185)'],
        [0.86667, 'rgb(255,255,187)'],
        [0.87059, 'rgb(255,255,189)'],
        [0.87451, 'rgb(255,255,191)'],
        [0.87843, 'rgb(255,255,193)'],
        [0.88235, 'rgb(255,255,195)'],
        [0.88627, 'rgb(255,255,196)'],
        [0.8902, 'rgb(255,255,198)'],
        [0.89412, 'rgb(255,255,200)'],
        [0.89804, 'rgb(255,255,203)'],
        [0.90196, 'rgb(255,255,205)'],
        [0.90588, 'rgb(255,255,207)'],
        [0.9098, 'rgb(255,255,209)'],
        [0.91373, 'rgb(255,255,211)'],
        [0.91765, 'rgb(255,255,212)'],
        [0.92157, 'rgb(255,255,214)'],
        [0.92549, 'rgb(255,255,217)'],
        [0.92941, 'rgb(255,255,219)'],
        [0.93333, 'rgb(255,255,221)'],
        [0.93725, 'rgb(255,255,223)'],
        [0.94118, 'rgb(255,255,225)'],
        [0.9451, 'rgb(255,255,227)'],
        [0.94902, 'rgb(255,255,228)'],
        [0.95294, 'rgb(255,255,230)'],
        [0.95686, 'rgb(255,255,232)'],
        [0.96078, 'rgb(255,255,235)'],
        [0.96471, 'rgb(255,255,237)'],
        [0.96863, 'rgb(255,255,239)'],
        [0.97255, 'rgb(255,255,241)'],
        [0.97647, 'rgb(255,255,243)'],
        [0.98039, 'rgb(255,255,244)'],
        [0.98431, 'rgb(255,255,246)'],
        [0.98824, 'rgb(255,255,249)'],
        [0.99216, 'rgb(255,255,251)'],
        [0.99608, 'rgb(255,255,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'autumn': [
        [0.0, 'rgb(255,0,0)'],
        [0.00392, 'rgb(255,1,0)'],
        [0.00784, 'rgb(255,2,0)'],
        [0.01176, 'rgb(255,3,0)'],
        [0.01569, 'rgb(255,4,0)'],
        [0.01961, 'rgb(255,5,0)'],
        [0.02353, 'rgb(255,6,0)'],
        [0.02745, 'rgb(255,7,0)'],
        [0.03137, 'rgb(255,8,0)'],
        [0.03529, 'rgb(255,9,0)'],
        [0.03922, 'rgb(255,10,0)'],
        [0.04314, 'rgb(255,11,0)'],
        [0.04706, 'rgb(255,12,0)'],
        [0.05098, 'rgb(255,13,0)'],
        [0.0549, 'rgb(255,14,0)'],
        [0.05882, 'rgb(255,15,0)'],
        [0.06275, 'rgb(255,16,0)'],
        [0.06667, 'rgb(255,17,0)'],
        [0.07059, 'rgb(255,18,0)'],
        [0.07451, 'rgb(255,19,0)'],
        [0.07843, 'rgb(255,20,0)'],
        [0.08235, 'rgb(255,21,0)'],
        [0.08627, 'rgb(255,22,0)'],
        [0.0902, 'rgb(255,23,0)'],
        [0.09412, 'rgb(255,24,0)'],
        [0.09804, 'rgb(255,25,0)'],
        [0.10196, 'rgb(255,26,0)'],
        [0.10588, 'rgb(255,27,0)'],
        [0.1098, 'rgb(255,28,0)'],
        [0.11373, 'rgb(255,29,0)'],
        [0.11765, 'rgb(255,30,0)'],
        [0.12157, 'rgb(255,31,0)'],
        [0.12549, 'rgb(255,32,0)'],
        [0.12941, 'rgb(255,32,0)'],
        [0.13333, 'rgb(255,34,0)'],
        [0.13725, 'rgb(255,35,0)'],
        [0.14118, 'rgb(255,36,0)'],
        [0.1451, 'rgb(255,36,0)'],
        [0.14902, 'rgb(255,38,0)'],
        [0.15294, 'rgb(255,39,0)'],
        [0.15686, 'rgb(255,40,0)'],
        [0.16078, 'rgb(255,40,0)'],
        [0.16471, 'rgb(255,42,0)'],
        [0.16863, 'rgb(255,43,0)'],
        [0.17255, 'rgb(255,44,0)'],
        [0.17647, 'rgb(255,44,0)'],
        [0.18039, 'rgb(255,46,0)'],
        [0.18431, 'rgb(255,47,0)'],
        [0.18824, 'rgb(255,48,0)'],
        [0.19216, 'rgb(255,48,0)'],
        [0.19608, 'rgb(255,50,0)'],
        [0.2, 'rgb(255,51,0)'],
        [0.20392, 'rgb(255,52,0)'],
        [0.20784, 'rgb(255,52,0)'],
        [0.21176, 'rgb(255,54,0)'],
        [0.21569, 'rgb(255,55,0)'],
        [0.21961, 'rgb(255,56,0)'],
        [0.22353, 'rgb(255,56,0)'],
        [0.22745, 'rgb(255,58,0)'],
        [0.23137, 'rgb(255,59,0)'],
        [0.23529, 'rgb(255,60,0)'],
        [0.23922, 'rgb(255,60,0)'],
        [0.24314, 'rgb(255,62,0)'],
        [0.24706, 'rgb(255,63,0)'],
        [0.25098, 'rgb(255,64,0)'],
        [0.2549, 'rgb(255,65,0)'],
        [0.25882, 'rgb(255,65,0)'],
        [0.26275, 'rgb(255,67,0)'],
        [0.26667, 'rgb(255,68,0)'],
        [0.27059, 'rgb(255,69,0)'],
        [0.27451, 'rgb(255,70,0)'],
        [0.27843, 'rgb(255,71,0)'],
        [0.28235, 'rgb(255,72,0)'],
        [0.28627, 'rgb(255,73,0)'],
        [0.2902, 'rgb(255,73,0)'],
        [0.29412, 'rgb(255,75,0)'],
        [0.29804, 'rgb(255,76,0)'],
        [0.30196, 'rgb(255,77,0)'],
        [0.30588, 'rgb(255,78,0)'],
        [0.3098, 'rgb(255,79,0)'],
        [0.31373, 'rgb(255,80,0)'],
        [0.31765, 'rgb(255,81,0)'],
        [0.32157, 'rgb(255,81,0)'],
        [0.32549, 'rgb(255,83,0)'],
        [0.32941, 'rgb(255,84,0)'],
        [0.33333, 'rgb(255,85,0)'],
        [0.33725, 'rgb(255,86,0)'],
        [0.34118, 'rgb(255,87,0)'],
        [0.3451, 'rgb(255,88,0)'],
        [0.34902, 'rgb(255,89,0)'],
        [0.35294, 'rgb(255,89,0)'],
        [0.35686, 'rgb(255,91,0)'],
        [0.36078, 'rgb(255,92,0)'],
        [0.36471, 'rgb(255,93,0)'],
        [0.36863, 'rgb(255,94,0)'],
        [0.37255, 'rgb(255,95,0)'],
        [0.37647, 'rgb(255,96,0)'],
        [0.38039, 'rgb(255,97,0)'],
        [0.38431, 'rgb(255,97,0)'],
        [0.38824, 'rgb(255,99,0)'],
        [0.39216, 'rgb(255,100,0)'],
        [0.39608, 'rgb(255,101,0)'],
        [0.4, 'rgb(255,102,0)'],
        [0.40392, 'rgb(255,103,0)'],
        [0.40784, 'rgb(255,104,0)'],
        [0.41176, 'rgb(255,105,0)'],
        [0.41569, 'rgb(255,105,0)'],
        [0.41961, 'rgb(255,107,0)'],
        [0.42353, 'rgb(255,108,0)'],
        [0.42745, 'rgb(255,109,0)'],
        [0.43137, 'rgb(255,110,0)'],
        [0.43529, 'rgb(255,111,0)'],
        [0.43922, 'rgb(255,112,0)'],
        [0.44314, 'rgb(255,113,0)'],
        [0.44706, 'rgb(255,113,0)'],
        [0.45098, 'rgb(255,115,0)'],
        [0.4549, 'rgb(255,116,0)'],
        [0.45882, 'rgb(255,117,0)'],
        [0.46275, 'rgb(255,118,0)'],
        [0.46667, 'rgb(255,119,0)'],
        [0.47059, 'rgb(255,120,0)'],
        [0.47451, 'rgb(255,121,0)'],
        [0.47843, 'rgb(255,121,0)'],
        [0.48235, 'rgb(255,123,0)'],
        [0.48627, 'rgb(255,124,0)'],
        [0.4902, 'rgb(255,125,0)'],
        [0.49412, 'rgb(255,126,0)'],
        [0.49804, 'rgb(255,127,0)'],
        [0.50196, 'rgb(255,128,0)'],
        [0.50588, 'rgb(255,129,0)'],
        [0.5098, 'rgb(255,130,0)'],
        [0.51373, 'rgb(255,131,0)'],
        [0.51765, 'rgb(255,131,0)'],
        [0.52157, 'rgb(255,133,0)'],
        [0.52549, 'rgb(255,134,0)'],
        [0.52941, 'rgb(255,135,0)'],
        [0.53333, 'rgb(255,136,0)'],
        [0.53725, 'rgb(255,137,0)'],
        [0.54118, 'rgb(255,138,0)'],
        [0.5451, 'rgb(255,139,0)'],
        [0.54902, 'rgb(255,140,0)'],
        [0.55294, 'rgb(255,141,0)'],
        [0.55686, 'rgb(255,142,0)'],
        [0.56078, 'rgb(255,143,0)'],
        [0.56471, 'rgb(255,144,0)'],
        [0.56863, 'rgb(255,145,0)'],
        [0.57255, 'rgb(255,146,0)'],
        [0.57647, 'rgb(255,147,0)'],
        [0.58039, 'rgb(255,147,0)'],
        [0.58431, 'rgb(255,149,0)'],
        [0.58824, 'rgb(255,150,0)'],
        [0.59216, 'rgb(255,151,0)'],
        [0.59608, 'rgb(255,152,0)'],
        [0.6, 'rgb(255,153,0)'],
        [0.60392, 'rgb(255,154,0)'],
        [0.60784, 'rgb(255,155,0)'],
        [0.61176, 'rgb(255,156,0)'],
        [0.61569, 'rgb(255,157,0)'],
        [0.61961, 'rgb(255,158,0)'],
        [0.62353, 'rgb(255,159,0)'],
        [0.62745, 'rgb(255,160,0)'],
        [0.63137, 'rgb(255,161,0)'],
        [0.63529, 'rgb(255,162,0)'],
        [0.63922, 'rgb(255,163,0)'],
        [0.64314, 'rgb(255,163,0)'],
        [0.64706, 'rgb(255,165,0)'],
        [0.65098, 'rgb(255,166,0)'],
        [0.6549, 'rgb(255,167,0)'],
        [0.65882, 'rgb(255,168,0)'],
        [0.66275, 'rgb(255,169,0)'],
        [0.66667, 'rgb(255,170,0)'],
        [0.67059, 'rgb(255,171,0)'],
        [0.67451, 'rgb(255,172,0)'],
        [0.67843, 'rgb(255,173,0)'],
        [0.68235, 'rgb(255,174,0)'],
        [0.68627, 'rgb(255,175,0)'],
        [0.6902, 'rgb(255,176,0)'],
        [0.69412, 'rgb(255,177,0)'],
        [0.69804, 'rgb(255,178,0)'],
        [0.70196, 'rgb(255,179,0)'],
        [0.70588, 'rgb(255,179,0)'],
        [0.7098, 'rgb(255,181,0)'],
        [0.71373, 'rgb(255,182,0)'],
        [0.71765, 'rgb(255,183,0)'],
        [0.72157, 'rgb(255,184,0)'],
        [0.72549, 'rgb(255,185,0)'],
        [0.72941, 'rgb(255,186,0)'],
        [0.73333, 'rgb(255,187,0)'],
        [0.73725, 'rgb(255,188,0)'],
        [0.74118, 'rgb(255,189,0)'],
        [0.7451, 'rgb(255,190,0)'],
        [0.74902, 'rgb(255,191,0)'],
        [0.75294, 'rgb(255,192,0)'],
        [0.75686, 'rgb(255,193,0)'],
        [0.76078, 'rgb(255,194,0)'],
        [0.76471, 'rgb(255,195,0)'],
        [0.76863, 'rgb(255,195,0)'],
        [0.77255, 'rgb(255,197,0)'],
        [0.77647, 'rgb(255,198,0)'],
        [0.78039, 'rgb(255,199,0)'],
        [0.78431, 'rgb(255,200,0)'],
        [0.78824, 'rgb(255,201,0)'],
        [0.79216, 'rgb(255,202,0)'],
        [0.79608, 'rgb(255,203,0)'],
        [0.8, 'rgb(255,204,0)'],
        [0.80392, 'rgb(255,205,0)'],
        [0.80784, 'rgb(255,206,0)'],
        [0.81176, 'rgb(255,207,0)'],
        [0.81569, 'rgb(255,208,0)'],
        [0.81961, 'rgb(255,209,0)'],
        [0.82353, 'rgb(255,210,0)'],
        [0.82745, 'rgb(255,211,0)'],
        [0.83137, 'rgb(255,211,0)'],
        [0.83529, 'rgb(255,213,0)'],
        [0.83922, 'rgb(255,214,0)'],
        [0.84314, 'rgb(255,215,0)'],
        [0.84706, 'rgb(255,216,0)'],
        [0.85098, 'rgb(255,217,0)'],
        [0.8549, 'rgb(255,218,0)'],
        [0.85882, 'rgb(255,219,0)'],
        [0.86275, 'rgb(255,220,0)'],
        [0.86667, 'rgb(255,221,0)'],
        [0.87059, 'rgb(255,222,0)'],
        [0.87451, 'rgb(255,223,0)'],
        [0.87843, 'rgb(255,224,0)'],
        [0.88235, 'rgb(255,225,0)'],
        [0.88627, 'rgb(255,226,0)'],
        [0.8902, 'rgb(255,227,0)'],
        [0.89412, 'rgb(255,227,0)'],
        [0.89804, 'rgb(255,229,0)'],
        [0.90196, 'rgb(255,230,0)'],
        [0.90588, 'rgb(255,231,0)'],
        [0.9098, 'rgb(255,232,0)'],
        [0.91373, 'rgb(255,233,0)'],
        [0.91765, 'rgb(255,234,0)'],
        [0.92157, 'rgb(255,235,0)'],
        [0.92549, 'rgb(255,236,0)'],
        [0.92941, 'rgb(255,237,0)'],
        [0.93333, 'rgb(255,238,0)'],
        [0.93725, 'rgb(255,239,0)'],
        [0.94118, 'rgb(255,240,0)'],
        [0.9451, 'rgb(255,241,0)'],
        [0.94902, 'rgb(255,242,0)'],
        [0.95294, 'rgb(255,243,0)'],
        [0.95686, 'rgb(255,243,0)'],
        [0.96078, 'rgb(255,245,0)'],
        [0.96471, 'rgb(255,246,0)'],
        [0.96863, 'rgb(255,247,0)'],
        [0.97255, 'rgb(255,248,0)'],
        [0.97647, 'rgb(255,249,0)'],
        [0.98039, 'rgb(255,250,0)'],
        [0.98431, 'rgb(255,251,0)'],
        [0.98824, 'rgb(255,252,0)'],
        [0.99216, 'rgb(255,253,0)'],
        [0.99608, 'rgb(255,254,0)'],
        [1.0, 'rgb(255,255,0)'],
    ],
    'binary': [
        [0.0, 'rgb(255,255,255)'],
        [0.00392, 'rgb(254,254,254)'],
        [0.00784, 'rgb(253,253,253)'],
        [0.01176, 'rgb(252,252,252)'],
        [0.01569, 'rgb(251,251,251)'],
        [0.01961, 'rgb(250,250,250)'],
        [0.02353, 'rgb(249,249,249)'],
        [0.02745, 'rgb(248,248,248)'],
        [0.03137, 'rgb(247,247,247)'],
        [0.03529, 'rgb(246,246,246)'],
        [0.03922, 'rgb(245,245,245)'],
        [0.04314, 'rgb(244,244,244)'],
        [0.04706, 'rgb(243,243,243)'],
        [0.05098, 'rgb(242,242,242)'],
        [0.0549, 'rgb(241,241,241)'],
        [0.05882, 'rgb(240,240,240)'],
        [0.06275, 'rgb(239,239,239)'],
        [0.06667, 'rgb(238,238,238)'],
        [0.07059, 'rgb(237,237,237)'],
        [0.07451, 'rgb(236,236,236)'],
        [0.07843, 'rgb(235,235,235)'],
        [0.08235, 'rgb(234,234,234)'],
        [0.08627, 'rgb(233,233,233)'],
        [0.0902, 'rgb(232,232,232)'],
        [0.09412, 'rgb(231,231,231)'],
        [0.09804, 'rgb(230,230,230)'],
        [0.10196, 'rgb(229,229,229)'],
        [0.10588, 'rgb(228,228,228)'],
        [0.1098, 'rgb(227,227,227)'],
        [0.11373, 'rgb(226,226,226)'],
        [0.11765, 'rgb(225,225,225)'],
        [0.12157, 'rgb(224,224,224)'],
        [0.12549, 'rgb(223,223,223)'],
        [0.12941, 'rgb(222,222,222)'],
        [0.13333, 'rgb(221,221,221)'],
        [0.13725, 'rgb(220,220,220)'],
        [0.14118, 'rgb(219,219,219)'],
        [0.1451, 'rgb(218,218,218)'],
        [0.14902, 'rgb(217,217,217)'],
        [0.15294, 'rgb(216,216,216)'],
        [0.15686, 'rgb(215,215,215)'],
        [0.16078, 'rgb(214,214,214)'],
        [0.16471, 'rgb(213,213,213)'],
        [0.16863, 'rgb(211,211,211)'],
        [0.17255, 'rgb(211,211,211)'],
        [0.17647, 'rgb(210,210,210)'],
        [0.18039, 'rgb(209,209,209)'],
        [0.18431, 'rgb(208,208,208)'],
        [0.18824, 'rgb(207,207,207)'],
        [0.19216, 'rgb(206,206,206)'],
        [0.19608, 'rgb(205,205,205)'],
        [0.2, 'rgb(204,204,204)'],
        [0.20392, 'rgb(203,203,203)'],
        [0.20784, 'rgb(202,202,202)'],
        [0.21176, 'rgb(201,201,201)'],
        [0.21569, 'rgb(200,200,200)'],
        [0.21961, 'rgb(199,199,199)'],
        [0.22353, 'rgb(198,198,198)'],
        [0.22745, 'rgb(197,197,197)'],
        [0.23137, 'rgb(195,195,195)'],
        [0.23529, 'rgb(195,195,195)'],
        [0.23922, 'rgb(194,194,194)'],
        [0.24314, 'rgb(193,193,193)'],
        [0.24706, 'rgb(192,192,192)'],
        [0.25098, 'rgb(191,191,191)'],
        [0.2549, 'rgb(190,190,190)'],
        [0.25882, 'rgb(189,189,189)'],
        [0.26275, 'rgb(188,188,188)'],
        [0.26667, 'rgb(187,187,187)'],
        [0.27059, 'rgb(186,186,186)'],
        [0.27451, 'rgb(185,185,185)'],
        [0.27843, 'rgb(184,184,184)'],
        [0.28235, 'rgb(183,183,183)'],
        [0.28627, 'rgb(182,182,182)'],
        [0.2902, 'rgb(181,181,181)'],
        [0.29412, 'rgb(179,179,179)'],
        [0.29804, 'rgb(179,179,179)'],
        [0.30196, 'rgb(178,178,178)'],
        [0.30588, 'rgb(177,177,177)'],
        [0.3098, 'rgb(176,176,176)'],
        [0.31373, 'rgb(175,175,175)'],
        [0.31765, 'rgb(174,174,174)'],
        [0.32157, 'rgb(173,173,173)'],
        [0.32549, 'rgb(172,172,172)'],
        [0.32941, 'rgb(171,171,171)'],
        [0.33333, 'rgb(170,170,170)'],
        [0.33725, 'rgb(169,169,169)'],
        [0.34118, 'rgb(168,168,168)'],
        [0.3451, 'rgb(167,167,167)'],
        [0.34902, 'rgb(166,166,166)'],
        [0.35294, 'rgb(165,165,165)'],
        [0.35686, 'rgb(163,163,163)'],
        [0.36078, 'rgb(163,163,163)'],
        [0.36471, 'rgb(162,162,162)'],
        [0.36863, 'rgb(161,161,161)'],
        [0.37255, 'rgb(160,160,160)'],
        [0.37647, 'rgb(159,159,159)'],
        [0.38039, 'rgb(158,158,158)'],
        [0.38431, 'rgb(157,157,157)'],
        [0.38824, 'rgb(156,156,156)'],
        [0.39216, 'rgb(155,155,155)'],
        [0.39608, 'rgb(154,154,154)'],
        [0.4, 'rgb(153,153,153)'],
        [0.40392, 'rgb(152,152,152)'],
        [0.40784, 'rgb(151,151,151)'],
        [0.41176, 'rgb(150,150,150)'],
        [0.41569, 'rgb(149,149,149)'],
        [0.41961, 'rgb(147,147,147)'],
        [0.42353, 'rgb(147,147,147)'],
        [0.42745, 'rgb(146,146,146)'],
        [0.43137, 'rgb(145,145,145)'],
        [0.43529, 'rgb(144,144,144)'],
        [0.43922, 'rgb(143,143,143)'],
        [0.44314, 'rgb(142,142,142)'],
        [0.44706, 'rgb(141,141,141)'],
        [0.45098, 'rgb(140,140,140)'],
        [0.4549, 'rgb(139,139,139)'],
        [0.45882, 'rgb(138,138,138)'],
        [0.46275, 'rgb(137,137,137)'],
        [0.46667, 'rgb(136,136,136)'],
        [0.47059, 'rgb(135,135,135)'],
        [0.47451, 'rgb(134,134,134)'],
        [0.47843, 'rgb(133,133,133)'],
        [0.48235, 'rgb(131,131,131)'],
        [0.48627, 'rgb(131,131,131)'],
        [0.4902, 'rgb(130,130,130)'],
        [0.49412, 'rgb(129,129,129)'],
        [0.49804, 'rgb(128,128,128)'],
        [0.50196, 'rgb(127,127,127)'],
        [0.50588, 'rgb(126,126,126)'],
        [0.5098, 'rgb(125,125,125)'],
        [0.51373, 'rgb(124,124,124)'],
        [0.51765, 'rgb(123,123,123)'],
        [0.52157, 'rgb(121,121,121)'],
        [0.52549, 'rgb(121,121,121)'],
        [0.52941, 'rgb(120,120,120)'],
        [0.53333, 'rgb(119,119,119)'],
        [0.53725, 'rgb(118,118,118)'],
        [0.54118, 'rgb(117,117,117)'],
        [0.5451, 'rgb(116,116,116)'],
        [0.54902, 'rgb(114,114,114)'],
        [0.55294, 'rgb(113,113,113)'],
        [0.55686, 'rgb(113,113,113)'],
        [0.56078, 'rgb(112,112,112)'],
        [0.56471, 'rgb(111,111,111)'],
        [0.56863, 'rgb(110,110,110)'],
        [0.57255, 'rgb(109,109,109)'],
        [0.57647, 'rgb(108,108,108)'],
        [0.58039, 'rgb(107,107,107)'],
        [0.58431, 'rgb(105,105,105)'],
        [0.58824, 'rgb(105,105,105)'],
        [0.59216, 'rgb(104,104,104)'],
        [0.59608, 'rgb(103,103,103)'],
        [0.6, 'rgb(102,102,102)'],
        [0.60392, 'rgb(101,101,101)'],
        [0.60784, 'rgb(100,100,100)'],
        [0.61176, 'rgb(98,98,98)'],
        [0.61569, 'rgb(97,97,97)'],
        [0.61961, 'rgb(97,97,97)'],
        [0.62353, 'rgb(96,96,96)'],
        [0.62745, 'rgb(95,95,95)'],
        [0.63137, 'rgb(94,94,94)'],
        [0.63529, 'rgb(93,93,93)'],
        [0.63922, 'rgb(92,92,92)'],
        [0.64314, 'rgb(91,91,91)'],
        [0.64706, 'rgb(89,89,89)'],
        [0.65098, 'rgb(89,89,89)'],
        [0.6549, 'rgb(88,88,88)'],
        [0.65882, 'rgb(87,87,87)'],
        [0.66275, 'rgb(86,86,86)'],
        [0.66667, 'rgb(85,85,85)'],
        [0.67059, 'rgb(84,84,84)'],
        [0.67451, 'rgb(82,82,82)'],
        [0.67843, 'rgb(81,81,81)'],
        [0.68235, 'rgb(81,81,81)'],
        [0.68627, 'rgb(80,80,80)'],
        [0.6902, 'rgb(79,79,79)'],
        [0.69412, 'rgb(78,78,78)'],
        [0.69804, 'rgb(77,77,77)'],
        [0.70196, 'rgb(76,76,76)'],
        [0.70588, 'rgb(75,75,75)'],
        [0.7098, 'rgb(73,73,73)'],
        [0.71373, 'rgb(73,73,73)'],
        [0.71765, 'rgb(72,72,72)'],
        [0.72157, 'rgb(71,71,71)'],
        [0.72549, 'rgb(70,70,70)'],
        [0.72941, 'rgb(69,69,69)'],
        [0.73333, 'rgb(68,68,68)'],
        [0.73725, 'rgb(66,66,66)'],
        [0.74118, 'rgb(65,65,65)'],
        [0.7451, 'rgb(65,65,65)'],
        [0.74902, 'rgb(64,64,64)'],
        [0.75294, 'rgb(63,63,63)'],
        [0.75686, 'rgb(62,62,62)'],
        [0.76078, 'rgb(61,61,61)'],
        [0.76471, 'rgb(60,60,60)'],
        [0.76863, 'rgb(59,59,59)'],
        [0.77255, 'rgb(57,57,57)'],
        [0.77647, 'rgb(56,56,56)'],
        [0.78039, 'rgb(56,56,56)'],
        [0.78431, 'rgb(55,55,55)'],
        [0.78824, 'rgb(54,54,54)'],
        [0.79216, 'rgb(53,53,53)'],
        [0.79608, 'rgb(52,52,52)'],
        [0.8, 'rgb(50,50,50)'],
        [0.80392, 'rgb(49,49,49)'],
        [0.80784, 'rgb(48,48,48)'],
        [0.81176, 'rgb(48,48,48)'],
        [0.81569, 'rgb(47,47,47)'],
        [0.81961, 'rgb(46,46,46)'],
        [0.82353, 'rgb(45,45,45)'],
        [0.82745, 'rgb(44,44,44)'],
        [0.83137, 'rgb(43,43,43)'],
        [0.83529, 'rgb(41,41,41)'],
        [0.83922, 'rgb(40,40,40)'],
        [0.84314, 'rgb(40,40,40)'],
        [0.84706, 'rgb(39,39,39)'],
        [0.85098, 'rgb(38,38,38)'],
        [0.8549, 'rgb(37,37,37)'],
        [0.85882, 'rgb(36,36,36)'],
        [0.86275, 'rgb(34,34,34)'],
        [0.86667, 'rgb(33,33,33)'],
        [0.87059, 'rgb(32,32,32)'],
        [0.87451, 'rgb(32,32,32)'],
        [0.87843, 'rgb(31,31,31)'],
        [0.88235, 'rgb(30,30,30)'],
        [0.88627, 'rgb(29,29,29)'],
        [0.8902, 'rgb(28,28,28)'],
        [0.89412, 'rgb(27,27,27)'],
        [0.89804, 'rgb(25,25,25)'],
        [0.90196, 'rgb(24,24,24)'],
        [0.90588, 'rgb(24,24,24)'],
        [0.9098, 'rgb(23,23,23)'],
        [0.91373, 'rgb(22,22,22)'],
        [0.91765, 'rgb(21,21,21)'],
        [0.92157, 'rgb(20,20,20)'],
        [0.92549, 'rgb(18,18,18)'],
        [0.92941, 'rgb(17,17,17)'],
        [0.93333, 'rgb(16,16,16)'],
        [0.93725, 'rgb(16,16,16)'],
        [0.94118, 'rgb(15,15,15)'],
        [0.9451, 'rgb(14,14,14)'],
        [0.94902, 'rgb(13,13,13)'],
        [0.95294, 'rgb(12,12,12)'],
        [0.95686, 'rgb(11,11,11)'],
        [0.96078, 'rgb(9,9,9)'],
        [0.96471, 'rgb(8,8,8)'],
        [0.96863, 'rgb(8,8,8)'],
        [0.97255, 'rgb(7,7,7)'],
        [0.97647, 'rgb(6,6,6)'],
        [0.98039, 'rgb(5,5,5)'],
        [0.98431, 'rgb(4,4,4)'],
        [0.98824, 'rgb(2,2,2)'],
        [0.99216, 'rgb(1,1,1)'],
        [0.99608, 'rgb(0,0,0)'],
        [1.0, 'rgb(0,0,0)'],
    ],
    'bone': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(0,0,1)'],
        [0.00784, 'rgb(1,1,2)'],
        [0.01176, 'rgb(2,2,3)'],
        [0.01569, 'rgb(3,3,4)'],
        [0.01961, 'rgb(4,4,6)'],
        [0.02353, 'rgb(5,5,7)'],
        [0.02745, 'rgb(6,6,8)'],
        [0.03137, 'rgb(7,6,9)'],
        [0.03529, 'rgb(7,7,10)'],
        [0.03922, 'rgb(8,8,12)'],
        [0.04314, 'rgb(9,9,13)'],
        [0.04706, 'rgb(10,10,14)'],
        [0.05098, 'rgb(11,11,15)'],
        [0.0549, 'rgb(12,12,17)'],
        [0.05882, 'rgb(13,13,18)'],
        [0.06275, 'rgb(14,13,19)'],
        [0.06667, 'rgb(14,14,20)'],
        [0.07059, 'rgb(15,15,21)'],
        [0.07451, 'rgb(16,16,23)'],
        [0.07843, 'rgb(17,17,24)'],
        [0.08235, 'rgb(18,18,25)'],
        [0.08627, 'rgb(19,19,26)'],
        [0.0902, 'rgb(20,20,28)'],
        [0.09412, 'rgb(21,20,29)'],
        [0.09804, 'rgb(21,21,30)'],
        [0.10196, 'rgb(22,22,31)'],
        [0.10588, 'rgb(23,23,32)'],
        [0.1098, 'rgb(24,24,34)'],
        [0.11373, 'rgb(25,25,35)'],
        [0.11765, 'rgb(26,26,36)'],
        [0.12157, 'rgb(27,27,37)'],
        [0.12549, 'rgb(28,27,38)'],
        [0.12941, 'rgb(28,28,40)'],
        [0.13333, 'rgb(29,29,41)'],
        [0.13725, 'rgb(30,30,42)'],
        [0.14118, 'rgb(31,31,43)'],
        [0.1451, 'rgb(32,32,45)'],
        [0.14902, 'rgb(33,33,46)'],
        [0.15294, 'rgb(34,34,47)'],
        [0.15686, 'rgb(35,34,48)'],
        [0.16078, 'rgb(35,35,49)'],
        [0.16471, 'rgb(36,36,51)'],
        [0.16863, 'rgb(37,37,52)'],
        [0.17255, 'rgb(38,38,53)'],
        [0.17647, 'rgb(39,39,54)'],
        [0.18039, 'rgb(40,40,56)'],
        [0.18431, 'rgb(41,41,57)'],
        [0.18824, 'rgb(42,41,58)'],
        [0.19216, 'rgb(42,42,59)'],
        [0.19608, 'rgb(43,43,60)'],
        [0.2, 'rgb(44,44,62)'],
        [0.20392, 'rgb(45,45,63)'],
        [0.20784, 'rgb(46,46,64)'],
        [0.21176, 'rgb(47,47,65)'],
        [0.21569, 'rgb(48,48,66)'],
        [0.21961, 'rgb(49,48,68)'],
        [0.22353, 'rgb(49,49,69)'],
        [0.22745, 'rgb(50,50,70)'],
        [0.23137, 'rgb(51,51,71)'],
        [0.23529, 'rgb(52,52,73)'],
        [0.23922, 'rgb(53,53,74)'],
        [0.24314, 'rgb(54,54,75)'],
        [0.24706, 'rgb(55,55,76)'],
        [0.25098, 'rgb(56,55,77)'],
        [0.2549, 'rgb(56,56,79)'],
        [0.25882, 'rgb(57,57,80)'],
        [0.26275, 'rgb(58,58,81)'],
        [0.26667, 'rgb(59,59,82)'],
        [0.27059, 'rgb(60,60,84)'],
        [0.27451, 'rgb(61,61,85)'],
        [0.27843, 'rgb(62,62,86)'],
        [0.28235, 'rgb(63,62,87)'],
        [0.28627, 'rgb(63,63,88)'],
        [0.2902, 'rgb(64,64,90)'],
        [0.29412, 'rgb(65,65,91)'],
        [0.29804, 'rgb(66,66,92)'],
        [0.30196, 'rgb(67,67,93)'],
        [0.30588, 'rgb(68,68,94)'],
        [0.3098, 'rgb(69,69,96)'],
        [0.31373, 'rgb(70,69,97)'],
        [0.31765, 'rgb(70,70,98)'],
        [0.32157, 'rgb(71,71,99)'],
        [0.32549, 'rgb(72,72,101)'],
        [0.32941, 'rgb(73,73,102)'],
        [0.33333, 'rgb(74,74,103)'],
        [0.33725, 'rgb(75,75,104)'],
        [0.34118, 'rgb(76,76,105)'],
        [0.3451, 'rgb(77,76,107)'],
        [0.34902, 'rgb(77,77,108)'],
        [0.35294, 'rgb(78,78,109)'],
        [0.35686, 'rgb(79,79,110)'],
        [0.36078, 'rgb(80,80,112)'],
        [0.36471, 'rgb(81,81,113)'],
        [0.36863, 'rgb(82,82,114)'],
        [0.37255, 'rgb(83,83,114)'],
        [0.37647, 'rgb(84,84,115)'],
        [0.38039, 'rgb(84,86,116)'],
        [0.38431, 'rgb(85,87,117)'],
        [0.38824, 'rgb(86,88,118)'],
        [0.39216, 'rgb(87,89,119)'],
        [0.39608, 'rgb(88,90,120)'],
        [0.4, 'rgb(89,92,121)'],
        [0.40392, 'rgb(90,93,121)'],
        [0.40784, 'rgb(91,94,122)'],
        [0.41176, 'rgb(91,95,123)'],
        [0.41569, 'rgb(92,96,124)'],
        [0.41961, 'rgb(93,98,125)'],
        [0.42353, 'rgb(94,99,126)'],
        [0.42745, 'rgb(95,100,127)'],
        [0.43137, 'rgb(96,101,128)'],
        [0.43529, 'rgb(97,102,128)'],
        [0.43922, 'rgb(98,104,129)'],
        [0.44314, 'rgb(98,105,130)'],
        [0.44706, 'rgb(99,106,131)'],
        [0.45098, 'rgb(100,107,132)'],
        [0.4549, 'rgb(101,109,133)'],
        [0.45882, 'rgb(102,110,134)'],
        [0.46275, 'rgb(103,111,135)'],
        [0.46667, 'rgb(104,112,135)'],
        [0.47059, 'rgb(105,113,136)'],
        [0.47451, 'rgb(105,115,137)'],
        [0.47843, 'rgb(106,116,138)'],
        [0.48235, 'rgb(107,117,139)'],
        [0.48627, 'rgb(108,118,140)'],
        [0.4902, 'rgb(109,119,141)'],
        [0.49412, 'rgb(110,121,142)'],
        [0.49804, 'rgb(111,122,142)'],
        [0.50196, 'rgb(112,123,143)'],
        [0.50588, 'rgb(112,124,144)'],
        [0.5098, 'rgb(113,125,145)'],
        [0.51373, 'rgb(114,127,146)'],
        [0.51765, 'rgb(115,128,147)'],
        [0.52157, 'rgb(116,129,148)'],
        [0.52549, 'rgb(117,130,149)'],
        [0.52941, 'rgb(118,131,149)'],
        [0.53333, 'rgb(119,133,150)'],
        [0.53725, 'rgb(119,134,151)'],
        [0.54118, 'rgb(120,135,152)'],
        [0.5451, 'rgb(121,136,153)'],
        [0.54902, 'rgb(122,137,154)'],
        [0.55294, 'rgb(123,139,155)'],
        [0.55686, 'rgb(124,140,156)'],
        [0.56078, 'rgb(125,141,156)'],
        [0.56471, 'rgb(126,142,157)'],
        [0.56863, 'rgb(126,143,158)'],
        [0.57255, 'rgb(127,145,159)'],
        [0.57647, 'rgb(128,146,160)'],
        [0.58039, 'rgb(129,147,161)'],
        [0.58431, 'rgb(130,148,162)'],
        [0.58824, 'rgb(131,149,163)'],
        [0.59216, 'rgb(132,151,163)'],
        [0.59608, 'rgb(133,152,164)'],
        [0.6, 'rgb(133,153,165)'],
        [0.60392, 'rgb(134,154,166)'],
        [0.60784, 'rgb(135,155,167)'],
        [0.61176, 'rgb(136,157,168)'],
        [0.61569, 'rgb(137,158,169)'],
        [0.61961, 'rgb(138,159,170)'],
        [0.62353, 'rgb(139,160,170)'],
        [0.62745, 'rgb(140,161,171)'],
        [0.63137, 'rgb(140,163,172)'],
        [0.63529, 'rgb(141,164,173)'],
        [0.63922, 'rgb(142,165,174)'],
        [0.64314, 'rgb(143,166,175)'],
        [0.64706, 'rgb(144,167,176)'],
        [0.65098, 'rgb(145,169,177)'],
        [0.6549, 'rgb(146,170,177)'],
        [0.65882, 'rgb(147,171,178)'],
        [0.66275, 'rgb(147,172,179)'],
        [0.66667, 'rgb(148,173,180)'],
        [0.67059, 'rgb(149,175,181)'],
        [0.67451, 'rgb(150,176,182)'],
        [0.67843, 'rgb(151,177,183)'],
        [0.68235, 'rgb(152,178,184)'],
        [0.68627, 'rgb(153,179,184)'],
        [0.6902, 'rgb(154,181,185)'],
        [0.69412, 'rgb(154,182,186)'],
        [0.69804, 'rgb(155,183,187)'],
        [0.70196, 'rgb(156,184,188)'],
        [0.70588, 'rgb(157,186,189)'],
        [0.7098, 'rgb(158,187,190)'],
        [0.71373, 'rgb(159,188,191)'],
        [0.71765, 'rgb(160,189,191)'],
        [0.72157, 'rgb(161,190,192)'],
        [0.72549, 'rgb(161,192,193)'],
        [0.72941, 'rgb(162,193,194)'],
        [0.73333, 'rgb(163,194,195)'],
        [0.73725, 'rgb(164,195,196)'],
        [0.74118, 'rgb(165,196,197)'],
        [0.7451, 'rgb(166,198,198)'],
        [0.74902, 'rgb(167,199,198)'],
        [0.75294, 'rgb(168,199,199)'],
        [0.75686, 'rgb(170,200,200)'],
        [0.76078, 'rgb(171,201,201)'],
        [0.76471, 'rgb(172,202,202)'],
        [0.76863, 'rgb(174,203,203)'],
        [0.77255, 'rgb(175,204,204)'],
        [0.77647, 'rgb(177,205,205)'],
        [0.78039, 'rgb(178,206,205)'],
        [0.78431, 'rgb(179,206,206)'],
        [0.78824, 'rgb(181,207,207)'],
        [0.79216, 'rgb(182,208,208)'],
        [0.79608, 'rgb(183,209,209)'],
        [0.8, 'rgb(185,210,210)'],
        [0.80392, 'rgb(186,211,211)'],
        [0.80784, 'rgb(188,212,212)'],
        [0.81176, 'rgb(189,213,212)'],
        [0.81569, 'rgb(190,213,213)'],
        [0.81961, 'rgb(192,214,214)'],
        [0.82353, 'rgb(193,215,215)'],
        [0.82745, 'rgb(194,216,216)'],
        [0.83137, 'rgb(196,217,217)'],
        [0.83529, 'rgb(197,218,218)'],
        [0.83922, 'rgb(198,219,219)'],
        [0.84314, 'rgb(200,220,219)'],
        [0.84706, 'rgb(201,220,220)'],
        [0.85098, 'rgb(203,221,221)'],
        [0.8549, 'rgb(204,222,222)'],
        [0.85882, 'rgb(205,223,223)'],
        [0.86275, 'rgb(207,224,224)'],
        [0.86667, 'rgb(208,225,225)'],
        [0.87059, 'rgb(209,226,226)'],
        [0.87451, 'rgb(211,227,226)'],
        [0.87843, 'rgb(212,227,227)'],
        [0.88235, 'rgb(213,228,228)'],
        [0.88627, 'rgb(215,229,229)'],
        [0.8902, 'rgb(216,230,230)'],
        [0.89412, 'rgb(218,231,231)'],
        [0.89804, 'rgb(219,232,232)'],
        [0.90196, 'rgb(220,233,233)'],
        [0.90588, 'rgb(222,234,233)'],
        [0.9098, 'rgb(223,234,234)'],
        [0.91373, 'rgb(224,235,235)'],
        [0.91765, 'rgb(226,236,236)'],
        [0.92157, 'rgb(227,237,237)'],
        [0.92549, 'rgb(229,238,238)'],
        [0.92941, 'rgb(230,239,239)'],
        [0.93333, 'rgb(231,240,240)'],
        [0.93725, 'rgb(233,241,240)'],
        [0.94118, 'rgb(234,241,241)'],
        [0.9451, 'rgb(235,242,242)'],
        [0.94902, 'rgb(237,243,243)'],
        [0.95294, 'rgb(238,244,244)'],
        [0.95686, 'rgb(239,245,245)'],
        [0.96078, 'rgb(241,246,246)'],
        [0.96471, 'rgb(242,247,247)'],
        [0.96863, 'rgb(244,248,247)'],
        [0.97255, 'rgb(245,248,248)'],
        [0.97647, 'rgb(246,249,249)'],
        [0.98039, 'rgb(248,250,250)'],
        [0.98431, 'rgb(249,251,251)'],
        [0.98824, 'rgb(250,252,252)'],
        [0.99216, 'rgb(252,253,253)'],
        [0.99608, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'brg': [
        [0.0, 'rgb(0,0,255)'],
        [0.00392, 'rgb(2,0,253)'],
        [0.00784, 'rgb(4,0,251)'],
        [0.01176, 'rgb(6,0,249)'],
        [0.01569, 'rgb(8,0,247)'],
        [0.01961, 'rgb(10,0,245)'],
        [0.02353, 'rgb(12,0,243)'],
        [0.02745, 'rgb(14,0,241)'],
        [0.03137, 'rgb(16,0,239)'],
        [0.03529, 'rgb(18,0,237)'],
        [0.03922, 'rgb(20,0,235)'],
        [0.04314, 'rgb(22,0,233)'],
        [0.04706, 'rgb(24,0,231)'],
        [0.05098, 'rgb(26,0,229)'],
        [0.0549, 'rgb(28,0,227)'],
        [0.05882, 'rgb(30,0,225)'],
        [0.06275, 'rgb(32,0,223)'],
        [0.06667, 'rgb(34,0,221)'],
        [0.07059, 'rgb(36,0,219)'],
        [0.07451, 'rgb(38,0,217)'],
        [0.07843, 'rgb(40,0,215)'],
        [0.08235, 'rgb(42,0,213)'],
        [0.08627, 'rgb(44,0,211)'],
        [0.0902, 'rgb(46,0,209)'],
        [0.09412, 'rgb(48,0,207)'],
        [0.09804, 'rgb(50,0,205)'],
        [0.10196, 'rgb(52,0,203)'],
        [0.10588, 'rgb(54,0,201)'],
        [0.1098, 'rgb(56,0,199)'],
        [0.11373, 'rgb(58,0,197)'],
        [0.11765, 'rgb(60,0,195)'],
        [0.12157, 'rgb(62,0,193)'],
        [0.12549, 'rgb(64,0,191)'],
        [0.12941, 'rgb(65,0,189)'],
        [0.13333, 'rgb(68,0,187)'],
        [0.13725, 'rgb(70,0,185)'],
        [0.14118, 'rgb(72,0,183)'],
        [0.1451, 'rgb(73,0,181)'],
        [0.14902, 'rgb(76,0,179)'],
        [0.15294, 'rgb(78,0,177)'],
        [0.15686, 'rgb(80,0,175)'],
        [0.16078, 'rgb(81,0,173)'],
        [0.16471, 'rgb(84,0,171)'],
        [0.16863, 'rgb(86,0,169)'],
        [0.17255, 'rgb(88,0,167)'],
        [0.17647, 'rgb(89,0,165)'],
        [0.18039, 'rgb(92,0,163)'],
        [0.18431, 'rgb(94,0,161)'],
        [0.18824, 'rgb(96,0,159)'],
        [0.19216, 'rgb(97,0,157)'],
        [0.19608, 'rgb(100,0,155)'],
        [0.2, 'rgb(102,0,153)'],
        [0.20392, 'rgb(104,0,151)'],
        [0.20784, 'rgb(105,0,149)'],
        [0.21176, 'rgb(108,0,147)'],
        [0.21569, 'rgb(110,0,145)'],
        [0.21961, 'rgb(112,0,143)'],
        [0.22353, 'rgb(113,0,141)'],
        [0.22745, 'rgb(116,0,139)'],
        [0.23137, 'rgb(118,0,137)'],
        [0.23529, 'rgb(120,0,135)'],
        [0.23922, 'rgb(121,0,133)'],
        [0.24314, 'rgb(124,0,131)'],
        [0.24706, 'rgb(126,0,129)'],
        [0.25098, 'rgb(128,0,127)'],
        [0.2549, 'rgb(130,0,125)'],
        [0.25882, 'rgb(131,0,123)'],
        [0.26275, 'rgb(134,0,121)'],
        [0.26667, 'rgb(136,0,119)'],
        [0.27059, 'rgb(138,0,117)'],
        [0.27451, 'rgb(140,0,114)'],
        [0.27843, 'rgb(142,0,113)'],
        [0.28235, 'rgb(144,0,111)'],
        [0.28627, 'rgb(146,0,109)'],
        [0.2902, 'rgb(147,0,107)'],
        [0.29412, 'rgb(150,0,105)'],
        [0.29804, 'rgb(152,0,103)'],
        [0.30196, 'rgb(154,0,101)'],
        [0.30588, 'rgb(156,0,98)'],
        [0.3098, 'rgb(158,0,97)'],
        [0.31373, 'rgb(160,0,95)'],
        [0.31765, 'rgb(162,0,93)'],
        [0.32157, 'rgb(163,0,91)'],
        [0.32549, 'rgb(166,0,89)'],
        [0.32941, 'rgb(168,0,87)'],
        [0.33333, 'rgb(170,0,85)'],
        [0.33725, 'rgb(172,0,82)'],
        [0.34118, 'rgb(174,0,81)'],
        [0.3451, 'rgb(176,0,79)'],
        [0.34902, 'rgb(178,0,77)'],
        [0.35294, 'rgb(179,0,75)'],
        [0.35686, 'rgb(182,0,73)'],
        [0.36078, 'rgb(184,0,71)'],
        [0.36471, 'rgb(186,0,69)'],
        [0.36863, 'rgb(188,0,66)'],
        [0.37255, 'rgb(190,0,65)'],
        [0.37647, 'rgb(192,0,63)'],
        [0.38039, 'rgb(194,0,61)'],
        [0.38431, 'rgb(195,0,59)'],
        [0.38824, 'rgb(198,0,56)'],
        [0.39216, 'rgb(200,0,55)'],
        [0.39608, 'rgb(202,0,53)'],
        [0.4, 'rgb(204,0,50)'],
        [0.40392, 'rgb(206,0,48)'],
        [0.40784, 'rgb(208,0,47)'],
        [0.41176, 'rgb(210,0,45)'],
        [0.41569, 'rgb(211,0,43)'],
        [0.41961, 'rgb(214,0,40)'],
        [0.42353, 'rgb(216,0,39)'],
        [0.42745, 'rgb(218,0,37)'],
        [0.43137, 'rgb(220,0,34)'],
        [0.43529, 'rgb(222,0,32)'],
        [0.43922, 'rgb(224,0,31)'],
        [0.44314, 'rgb(226,0,29)'],
        [0.44706, 'rgb(227,0,27)'],
        [0.45098, 'rgb(230,0,24)'],
        [0.4549, 'rgb(232,0,23)'],
        [0.45882, 'rgb(234,0,21)'],
        [0.46275, 'rgb(236,0,18)'],
        [0.46667, 'rgb(238,0,16)'],
        [0.47059, 'rgb(240,0,15)'],
        [0.47451, 'rgb(242,0,13)'],
        [0.47843, 'rgb(243,0,11)'],
        [0.48235, 'rgb(246,0,8)'],
        [0.48627, 'rgb(248,0,7)'],
        [0.4902, 'rgb(250,0,5)'],
        [0.49412, 'rgb(252,0,2)'],
        [0.49804, 'rgb(254,0,0)'],
        [0.50196, 'rgb(254,1,0)'],
        [0.50588, 'rgb(252,3,0)'],
        [0.5098, 'rgb(250,5,0)'],
        [0.51373, 'rgb(248,7,0)'],
        [0.51765, 'rgb(246,8,0)'],
        [0.52157, 'rgb(244,11,0)'],
        [0.52549, 'rgb(242,13,0)'],
        [0.52941, 'rgb(240,15,0)'],
        [0.53333, 'rgb(238,17,0)'],
        [0.53725, 'rgb(236,19,0)'],
        [0.54118, 'rgb(234,21,0)'],
        [0.5451, 'rgb(232,23,0)'],
        [0.54902, 'rgb(230,25,0)'],
        [0.55294, 'rgb(228,27,0)'],
        [0.55686, 'rgb(226,29,0)'],
        [0.56078, 'rgb(224,31,0)'],
        [0.56471, 'rgb(222,33,0)'],
        [0.56863, 'rgb(220,35,0)'],
        [0.57255, 'rgb(218,37,0)'],
        [0.57647, 'rgb(216,39,0)'],
        [0.58039, 'rgb(214,40,0)'],
        [0.58431, 'rgb(211,43,0)'],
        [0.58824, 'rgb(210,45,0)'],
        [0.59216, 'rgb(208,47,0)'],
        [0.59608, 'rgb(206,49,0)'],
        [0.6, 'rgb(204,51,0)'],
        [0.60392, 'rgb(202,53,0)'],
        [0.60784, 'rgb(200,55,0)'],
        [0.61176, 'rgb(198,57,0)'],
        [0.61569, 'rgb(195,59,0)'],
        [0.61961, 'rgb(194,61,0)'],
        [0.62353, 'rgb(192,63,0)'],
        [0.62745, 'rgb(190,65,0)'],
        [0.63137, 'rgb(188,67,0)'],
        [0.63529, 'rgb(186,69,0)'],
        [0.63922, 'rgb(184,71,0)'],
        [0.64314, 'rgb(182,72,0)'],
        [0.64706, 'rgb(179,75,0)'],
        [0.65098, 'rgb(178,77,0)'],
        [0.6549, 'rgb(176,79,0)'],
        [0.65882, 'rgb(174,81,0)'],
        [0.66275, 'rgb(172,83,0)'],
        [0.66667, 'rgb(170,85,0)'],
        [0.67059, 'rgb(168,87,0)'],
        [0.67451, 'rgb(166,89,0)'],
        [0.67843, 'rgb(163,91,0)'],
        [0.68235, 'rgb(162,93,0)'],
        [0.68627, 'rgb(160,95,0)'],
        [0.6902, 'rgb(158,97,0)'],
        [0.69412, 'rgb(156,99,0)'],
        [0.69804, 'rgb(154,101,0)'],
        [0.70196, 'rgb(152,103,0)'],
        [0.70588, 'rgb(150,104,0)'],
        [0.7098, 'rgb(147,107,0)'],
        [0.71373, 'rgb(146,109,0)'],
        [0.71765, 'rgb(144,111,0)'],
        [0.72157, 'rgb(142,113,0)'],
        [0.72549, 'rgb(140,115,0)'],
        [0.72941, 'rgb(138,117,0)'],
        [0.73333, 'rgb(136,119,0)'],
        [0.73725, 'rgb(134,121,0)'],
        [0.74118, 'rgb(131,123,0)'],
        [0.7451, 'rgb(130,125,0)'],
        [0.74902, 'rgb(128,127,0)'],
        [0.75294, 'rgb(126,129,0)'],
        [0.75686, 'rgb(124,131,0)'],
        [0.76078, 'rgb(121,133,0)'],
        [0.76471, 'rgb(120,135,0)'],
        [0.76863, 'rgb(118,136,0)'],
        [0.77255, 'rgb(116,139,0)'],
        [0.77647, 'rgb(113,141,0)'],
        [0.78039, 'rgb(112,143,0)'],
        [0.78431, 'rgb(110,145,0)'],
        [0.78824, 'rgb(108,147,0)'],
        [0.79216, 'rgb(105,149,0)'],
        [0.79608, 'rgb(104,151,0)'],
        [0.8, 'rgb(102,153,0)'],
        [0.80392, 'rgb(100,155,0)'],
        [0.80784, 'rgb(97,157,0)'],
        [0.81176, 'rgb(96,159,0)'],
        [0.81569, 'rgb(94,161,0)'],
        [0.81961, 'rgb(92,163,0)'],
        [0.82353, 'rgb(89,165,0)'],
        [0.82745, 'rgb(88,167,0)'],
        [0.83137, 'rgb(86,168,0)'],
        [0.83529, 'rgb(84,171,0)'],
        [0.83922, 'rgb(81,173,0)'],
        [0.84314, 'rgb(80,175,0)'],
        [0.84706, 'rgb(78,177,0)'],
        [0.85098, 'rgb(76,179,0)'],
        [0.8549, 'rgb(73,181,0)'],
        [0.85882, 'rgb(72,183,0)'],
        [0.86275, 'rgb(70,185,0)'],
        [0.86667, 'rgb(68,187,0)'],
        [0.87059, 'rgb(65,189,0)'],
        [0.87451, 'rgb(64,191,0)'],
        [0.87843, 'rgb(62,193,0)'],
        [0.88235, 'rgb(60,195,0)'],
        [0.88627, 'rgb(57,197,0)'],
        [0.8902, 'rgb(56,199,0)'],
        [0.89412, 'rgb(54,200,0)'],
        [0.89804, 'rgb(52,203,0)'],
        [0.90196, 'rgb(49,205,0)'],
        [0.90588, 'rgb(48,207,0)'],
        [0.9098, 'rgb(46,209,0)'],
        [0.91373, 'rgb(44,211,0)'],
        [0.91765, 'rgb(41,213,0)'],
        [0.92157, 'rgb(40,215,0)'],
        [0.92549, 'rgb(38,217,0)'],
        [0.92941, 'rgb(36,219,0)'],
        [0.93333, 'rgb(33,221,0)'],
        [0.93725, 'rgb(32,223,0)'],
        [0.94118, 'rgb(30,225,0)'],
        [0.9451, 'rgb(28,227,0)'],
        [0.94902, 'rgb(25,229,0)'],
        [0.95294, 'rgb(24,231,0)'],
        [0.95686, 'rgb(22,232,0)'],
        [0.96078, 'rgb(20,235,0)'],
        [0.96471, 'rgb(17,237,0)'],
        [0.96863, 'rgb(16,239,0)'],
        [0.97255, 'rgb(14,241,0)'],
        [0.97647, 'rgb(12,243,0)'],
        [0.98039, 'rgb(9,245,0)'],
        [0.98431, 'rgb(8,247,0)'],
        [0.98824, 'rgb(6,249,0)'],
        [0.99216, 'rgb(4,251,0)'],
        [0.99608, 'rgb(1,253,0)'],
        [1.0, 'rgb(0,255,0)'],
    ],
    'bwr': [
        [0.0, 'rgb(0,0,255)'],
        [0.00392, 'rgb(2,2,255)'],
        [0.00784, 'rgb(4,4,255)'],
        [0.01176, 'rgb(6,6,255)'],
        [0.01569, 'rgb(8,8,255)'],
        [0.01961, 'rgb(10,10,255)'],
        [0.02353, 'rgb(12,12,255)'],
        [0.02745, 'rgb(14,14,255)'],
        [0.03137, 'rgb(16,16,255)'],
        [0.03529, 'rgb(18,18,255)'],
        [0.03922, 'rgb(20,20,255)'],
        [0.04314, 'rgb(22,22,255)'],
        [0.04706, 'rgb(24,24,255)'],
        [0.05098, 'rgb(26,26,255)'],
        [0.0549, 'rgb(28,28,255)'],
        [0.05882, 'rgb(30,30,255)'],
        [0.06275, 'rgb(32,32,255)'],
        [0.06667, 'rgb(34,34,255)'],
        [0.07059, 'rgb(36,36,255)'],
        [0.07451, 'rgb(38,38,255)'],
        [0.07843, 'rgb(40,40,255)'],
        [0.08235, 'rgb(42,42,255)'],
        [0.08627, 'rgb(44,44,255)'],
        [0.0902, 'rgb(46,46,255)'],
        [0.09412, 'rgb(48,48,255)'],
        [0.09804, 'rgb(50,50,255)'],
        [0.10196, 'rgb(52,52,255)'],
        [0.10588, 'rgb(54,54,255)'],
        [0.1098, 'rgb(56,56,255)'],
        [0.11373, 'rgb(58,58,255)'],
        [0.11765, 'rgb(60,60,255)'],
        [0.12157, 'rgb(62,62,255)'],
        [0.12549, 'rgb(64,64,255)'],
        [0.12941, 'rgb(65,65,255)'],
        [0.13333, 'rgb(68,68,255)'],
        [0.13725, 'rgb(70,70,255)'],
        [0.14118, 'rgb(72,72,255)'],
        [0.1451, 'rgb(73,73,255)'],
        [0.14902, 'rgb(76,76,255)'],
        [0.15294, 'rgb(78,78,255)'],
        [0.15686, 'rgb(80,80,255)'],
        [0.16078, 'rgb(81,81,255)'],
        [0.16471, 'rgb(84,84,255)'],
        [0.16863, 'rgb(86,86,255)'],
        [0.17255, 'rgb(88,88,255)'],
        [0.17647, 'rgb(89,89,255)'],
        [0.18039, 'rgb(92,92,255)'],
        [0.18431, 'rgb(94,94,255)'],
        [0.18824, 'rgb(96,96,255)'],
        [0.19216, 'rgb(97,97,255)'],
        [0.19608, 'rgb(100,100,255)'],
        [0.2, 'rgb(102,102,255)'],
        [0.20392, 'rgb(104,104,255)'],
        [0.20784, 'rgb(105,105,255)'],
        [0.21176, 'rgb(108,108,255)'],
        [0.21569, 'rgb(110,110,255)'],
        [0.21961, 'rgb(112,112,255)'],
        [0.22353, 'rgb(113,113,255)'],
        [0.22745, 'rgb(116,116,255)'],
        [0.23137, 'rgb(118,118,255)'],
        [0.23529, 'rgb(120,120,255)'],
        [0.23922, 'rgb(121,121,255)'],
        [0.24314, 'rgb(124,124,255)'],
        [0.24706, 'rgb(126,126,255)'],
        [0.25098, 'rgb(128,128,255)'],
        [0.2549, 'rgb(130,130,255)'],
        [0.25882, 'rgb(131,131,255)'],
        [0.26275, 'rgb(134,134,255)'],
        [0.26667, 'rgb(136,136,255)'],
        [0.27059, 'rgb(138,138,255)'],
        [0.27451, 'rgb(140,140,255)'],
        [0.27843, 'rgb(142,142,255)'],
        [0.28235, 'rgb(144,144,255)'],
        [0.28627, 'rgb(146,146,255)'],
        [0.2902, 'rgb(147,147,255)'],
        [0.29412, 'rgb(150,150,255)'],
        [0.29804, 'rgb(152,152,255)'],
        [0.30196, 'rgb(154,154,255)'],
        [0.30588, 'rgb(156,156,255)'],
        [0.3098, 'rgb(158,158,255)'],
        [0.31373, 'rgb(160,160,255)'],
        [0.31765, 'rgb(162,162,255)'],
        [0.32157, 'rgb(163,163,255)'],
        [0.32549, 'rgb(166,166,255)'],
        [0.32941, 'rgb(168,168,255)'],
        [0.33333, 'rgb(170,170,255)'],
        [0.33725, 'rgb(172,172,255)'],
        [0.34118, 'rgb(174,174,255)'],
        [0.3451, 'rgb(176,176,255)'],
        [0.34902, 'rgb(178,178,255)'],
        [0.35294, 'rgb(179,179,255)'],
        [0.35686, 'rgb(182,182,255)'],
        [0.36078, 'rgb(184,184,255)'],
        [0.36471, 'rgb(186,186,255)'],
        [0.36863, 'rgb(188,188,255)'],
        [0.37255, 'rgb(190,190,255)'],
        [0.37647, 'rgb(192,192,255)'],
        [0.38039, 'rgb(194,194,255)'],
        [0.38431, 'rgb(195,195,255)'],
        [0.38824, 'rgb(198,198,255)'],
        [0.39216, 'rgb(200,200,255)'],
        [0.39608, 'rgb(202,202,255)'],
        [0.4, 'rgb(204,204,255)'],
        [0.40392, 'rgb(206,206,255)'],
        [0.40784, 'rgb(208,208,255)'],
        [0.41176, 'rgb(210,210,255)'],
        [0.41569, 'rgb(211,211,255)'],
        [0.41961, 'rgb(214,214,255)'],
        [0.42353, 'rgb(216,216,255)'],
        [0.42745, 'rgb(218,218,255)'],
        [0.43137, 'rgb(220,220,255)'],
        [0.43529, 'rgb(222,222,255)'],
        [0.43922, 'rgb(224,224,255)'],
        [0.44314, 'rgb(226,226,255)'],
        [0.44706, 'rgb(227,227,255)'],
        [0.45098, 'rgb(230,230,255)'],
        [0.4549, 'rgb(232,232,255)'],
        [0.45882, 'rgb(234,234,255)'],
        [0.46275, 'rgb(236,236,255)'],
        [0.46667, 'rgb(238,238,255)'],
        [0.47059, 'rgb(240,240,255)'],
        [0.47451, 'rgb(242,242,255)'],
        [0.47843, 'rgb(243,243,255)'],
        [0.48235, 'rgb(246,246,255)'],
        [0.48627, 'rgb(248,248,255)'],
        [0.4902, 'rgb(250,250,255)'],
        [0.49412, 'rgb(252,252,255)'],
        [0.49804, 'rgb(254,254,255)'],
        [0.50196, 'rgb(255,254,254)'],
        [0.50588, 'rgb(255,252,252)'],
        [0.5098, 'rgb(255,250,250)'],
        [0.51373, 'rgb(255,248,248)'],
        [0.51765, 'rgb(255,246,246)'],
        [0.52157, 'rgb(255,244,244)'],
        [0.52549, 'rgb(255,242,242)'],
        [0.52941, 'rgb(255,240,240)'],
        [0.53333, 'rgb(255,238,238)'],
        [0.53725, 'rgb(255,236,236)'],
        [0.54118, 'rgb(255,234,234)'],
        [0.5451, 'rgb(255,232,232)'],
        [0.54902, 'rgb(255,230,230)'],
        [0.55294, 'rgb(255,228,228)'],
        [0.55686, 'rgb(255,226,226)'],
        [0.56078, 'rgb(255,224,224)'],
        [0.56471, 'rgb(255,222,222)'],
        [0.56863, 'rgb(255,220,220)'],
        [0.57255, 'rgb(255,218,218)'],
        [0.57647, 'rgb(255,216,216)'],
        [0.58039, 'rgb(255,214,214)'],
        [0.58431, 'rgb(255,211,211)'],
        [0.58824, 'rgb(255,210,210)'],
        [0.59216, 'rgb(255,208,208)'],
        [0.59608, 'rgb(255,206,206)'],
        [0.6, 'rgb(255,204,204)'],
        [0.60392, 'rgb(255,202,202)'],
        [0.60784, 'rgb(255,200,200)'],
        [0.61176, 'rgb(255,198,198)'],
        [0.61569, 'rgb(255,195,195)'],
        [0.61961, 'rgb(255,194,194)'],
        [0.62353, 'rgb(255,192,192)'],
        [0.62745, 'rgb(255,190,190)'],
        [0.63137, 'rgb(255,188,188)'],
        [0.63529, 'rgb(255,186,186)'],
        [0.63922, 'rgb(255,184,184)'],
        [0.64314, 'rgb(255,182,182)'],
        [0.64706, 'rgb(255,179,179)'],
        [0.65098, 'rgb(255,178,178)'],
        [0.6549, 'rgb(255,176,176)'],
        [0.65882, 'rgb(255,174,174)'],
        [0.66275, 'rgb(255,172,172)'],
        [0.66667, 'rgb(255,170,170)'],
        [0.67059, 'rgb(255,168,168)'],
        [0.67451, 'rgb(255,166,166)'],
        [0.67843, 'rgb(255,163,163)'],
        [0.68235, 'rgb(255,162,162)'],
        [0.68627, 'rgb(255,160,160)'],
        [0.6902, 'rgb(255,158,158)'],
        [0.69412, 'rgb(255,156,156)'],
        [0.69804, 'rgb(255,154,154)'],
        [0.70196, 'rgb(255,152,152)'],
        [0.70588, 'rgb(255,150,150)'],
        [0.7098, 'rgb(255,147,147)'],
        [0.71373, 'rgb(255,146,146)'],
        [0.71765, 'rgb(255,144,144)'],
        [0.72157, 'rgb(255,142,142)'],
        [0.72549, 'rgb(255,140,140)'],
        [0.72941, 'rgb(255,138,138)'],
        [0.73333, 'rgb(255,136,136)'],
        [0.73725, 'rgb(255,134,134)'],
        [0.74118, 'rgb(255,131,131)'],
        [0.7451, 'rgb(255,130,130)'],
        [0.74902, 'rgb(255,128,128)'],
        [0.75294, 'rgb(255,126,126)'],
        [0.75686, 'rgb(255,124,124)'],
        [0.76078, 'rgb(255,121,121)'],
        [0.76471, 'rgb(255,120,120)'],
        [0.76863, 'rgb(255,118,118)'],
        [0.77255, 'rgb(255,116,116)'],
        [0.77647, 'rgb(255,113,113)'],
        [0.78039, 'rgb(255,112,112)'],
        [0.78431, 'rgb(255,110,110)'],
        [0.78824, 'rgb(255,108,108)'],
        [0.79216, 'rgb(255,105,105)'],
        [0.79608, 'rgb(255,104,104)'],
        [0.8, 'rgb(255,102,102)'],
        [0.80392, 'rgb(255,100,100)'],
        [0.80784, 'rgb(255,97,97)'],
        [0.81176, 'rgb(255,96,96)'],
        [0.81569, 'rgb(255,94,94)'],
        [0.81961, 'rgb(255,92,92)'],
        [0.82353, 'rgb(255,89,89)'],
        [0.82745, 'rgb(255,88,88)'],
        [0.83137, 'rgb(255,86,86)'],
        [0.83529, 'rgb(255,84,84)'],
        [0.83922, 'rgb(255,81,81)'],
        [0.84314, 'rgb(255,80,80)'],
        [0.84706, 'rgb(255,78,78)'],
        [0.85098, 'rgb(255,76,76)'],
        [0.8549, 'rgb(255,73,73)'],
        [0.85882, 'rgb(255,72,72)'],
        [0.86275, 'rgb(255,70,70)'],
        [0.86667, 'rgb(255,68,68)'],
        [0.87059, 'rgb(255,65,65)'],
        [0.87451, 'rgb(255,64,64)'],
        [0.87843, 'rgb(255,62,62)'],
        [0.88235, 'rgb(255,60,60)'],
        [0.88627, 'rgb(255,57,57)'],
        [0.8902, 'rgb(255,56,56)'],
        [0.89412, 'rgb(255,54,54)'],
        [0.89804, 'rgb(255,52,52)'],
        [0.90196, 'rgb(255,49,49)'],
        [0.90588, 'rgb(255,48,48)'],
        [0.9098, 'rgb(255,46,46)'],
        [0.91373, 'rgb(255,44,44)'],
        [0.91765, 'rgb(255,41,41)'],
        [0.92157, 'rgb(255,40,40)'],
        [0.92549, 'rgb(255,38,38)'],
        [0.92941, 'rgb(255,36,36)'],
        [0.93333, 'rgb(255,33,33)'],
        [0.93725, 'rgb(255,32,32)'],
        [0.94118, 'rgb(255,30,30)'],
        [0.9451, 'rgb(255,28,28)'],
        [0.94902, 'rgb(255,25,25)'],
        [0.95294, 'rgb(255,24,24)'],
        [0.95686, 'rgb(255,22,22)'],
        [0.96078, 'rgb(255,20,20)'],
        [0.96471, 'rgb(255,17,17)'],
        [0.96863, 'rgb(255,16,16)'],
        [0.97255, 'rgb(255,14,14)'],
        [0.97647, 'rgb(255,12,12)'],
        [0.98039, 'rgb(255,9,9)'],
        [0.98431, 'rgb(255,8,8)'],
        [0.98824, 'rgb(255,6,6)'],
        [0.99216, 'rgb(255,4,4)'],
        [0.99608, 'rgb(255,1,1)'],
        [1.0, 'rgb(255,0,0)'],
    ],
    'cool': [
        [0.0, 'rgb(0,255,255)'],
        [0.00392, 'rgb(1,254,255)'],
        [0.00784, 'rgb(2,253,255)'],
        [0.01176, 'rgb(3,252,255)'],
        [0.01569, 'rgb(4,251,255)'],
        [0.01961, 'rgb(5,250,255)'],
        [0.02353, 'rgb(6,249,255)'],
        [0.02745, 'rgb(7,248,255)'],
        [0.03137, 'rgb(8,247,255)'],
        [0.03529, 'rgb(9,246,255)'],
        [0.03922, 'rgb(10,245,255)'],
        [0.04314, 'rgb(11,244,255)'],
        [0.04706, 'rgb(12,243,255)'],
        [0.05098, 'rgb(13,242,255)'],
        [0.0549, 'rgb(14,241,255)'],
        [0.05882, 'rgb(15,240,255)'],
        [0.06275, 'rgb(16,239,255)'],
        [0.06667, 'rgb(17,238,255)'],
        [0.07059, 'rgb(18,237,255)'],
        [0.07451, 'rgb(19,236,255)'],
        [0.07843, 'rgb(20,235,255)'],
        [0.08235, 'rgb(21,234,255)'],
        [0.08627, 'rgb(22,233,255)'],
        [0.0902, 'rgb(23,232,255)'],
        [0.09412, 'rgb(24,231,255)'],
        [0.09804, 'rgb(25,230,255)'],
        [0.10196, 'rgb(26,229,255)'],
        [0.10588, 'rgb(27,228,255)'],
        [0.1098, 'rgb(28,227,255)'],
        [0.11373, 'rgb(29,226,255)'],
        [0.11765, 'rgb(30,225,255)'],
        [0.12157, 'rgb(31,224,255)'],
        [0.12549, 'rgb(32,223,255)'],
        [0.12941, 'rgb(32,222,255)'],
        [0.13333, 'rgb(34,221,255)'],
        [0.13725, 'rgb(35,220,255)'],
        [0.14118, 'rgb(36,219,255)'],
        [0.1451, 'rgb(36,218,255)'],
        [0.14902, 'rgb(38,217,255)'],
        [0.15294, 'rgb(39,216,255)'],
        [0.15686, 'rgb(40,215,255)'],
        [0.16078, 'rgb(40,214,255)'],
        [0.16471, 'rgb(42,213,255)'],
        [0.16863, 'rgb(43,211,255)'],
        [0.17255, 'rgb(44,211,255)'],
        [0.17647, 'rgb(44,210,255)'],
        [0.18039, 'rgb(46,209,255)'],
        [0.18431, 'rgb(47,208,255)'],
        [0.18824, 'rgb(48,207,255)'],
        [0.19216, 'rgb(48,206,255)'],
        [0.19608, 'rgb(50,205,255)'],
        [0.2, 'rgb(51,204,255)'],
        [0.20392, 'rgb(52,203,255)'],
        [0.20784, 'rgb(52,202,255)'],
        [0.21176, 'rgb(54,201,255)'],
        [0.21569, 'rgb(55,200,255)'],
        [0.21961, 'rgb(56,199,255)'],
        [0.22353, 'rgb(56,198,255)'],
        [0.22745, 'rgb(58,197,255)'],
        [0.23137, 'rgb(59,195,255)'],
        [0.23529, 'rgb(60,195,255)'],
        [0.23922, 'rgb(60,194,255)'],
        [0.24314, 'rgb(62,193,255)'],
        [0.24706, 'rgb(63,192,255)'],
        [0.25098, 'rgb(64,191,255)'],
        [0.2549, 'rgb(65,190,255)'],
        [0.25882, 'rgb(65,189,255)'],
        [0.26275, 'rgb(67,188,255)'],
        [0.26667, 'rgb(68,187,255)'],
        [0.27059, 'rgb(69,186,255)'],
        [0.27451, 'rgb(70,185,255)'],
        [0.27843, 'rgb(71,184,255)'],
        [0.28235, 'rgb(72,183,255)'],
        [0.28627, 'rgb(73,182,255)'],
        [0.2902, 'rgb(73,181,255)'],
        [0.29412, 'rgb(75,179,255)'],
        [0.29804, 'rgb(76,179,255)'],
        [0.30196, 'rgb(77,178,255)'],
        [0.30588, 'rgb(78,177,255)'],
        [0.3098, 'rgb(79,176,255)'],
        [0.31373, 'rgb(80,175,255)'],
        [0.31765, 'rgb(81,174,255)'],
        [0.32157, 'rgb(81,173,255)'],
        [0.32549, 'rgb(83,172,255)'],
        [0.32941, 'rgb(84,171,255)'],
        [0.33333, 'rgb(85,170,255)'],
        [0.33725, 'rgb(86,169,255)'],
        [0.34118, 'rgb(87,168,255)'],
        [0.3451, 'rgb(88,167,255)'],
        [0.34902, 'rgb(89,166,255)'],
        [0.35294, 'rgb(89,165,255)'],
        [0.35686, 'rgb(91,163,255)'],
        [0.36078, 'rgb(92,163,255)'],
        [0.36471, 'rgb(93,162,255)'],
        [0.36863, 'rgb(94,161,255)'],
        [0.37255, 'rgb(95,160,255)'],
        [0.37647, 'rgb(96,159,255)'],
        [0.38039, 'rgb(97,158,255)'],
        [0.38431, 'rgb(97,157,255)'],
        [0.38824, 'rgb(99,156,255)'],
        [0.39216, 'rgb(100,155,255)'],
        [0.39608, 'rgb(101,154,255)'],
        [0.4, 'rgb(102,153,255)'],
        [0.40392, 'rgb(103,152,255)'],
        [0.40784, 'rgb(104,151,255)'],
        [0.41176, 'rgb(105,150,255)'],
        [0.41569, 'rgb(105,149,255)'],
        [0.41961, 'rgb(107,147,255)'],
        [0.42353, 'rgb(108,147,255)'],
        [0.42745, 'rgb(109,146,255)'],
        [0.43137, 'rgb(110,145,255)'],
        [0.43529, 'rgb(111,144,255)'],
        [0.43922, 'rgb(112,143,255)'],
        [0.44314, 'rgb(113,142,255)'],
        [0.44706, 'rgb(113,141,255)'],
        [0.45098, 'rgb(115,140,255)'],
        [0.4549, 'rgb(116,139,255)'],
        [0.45882, 'rgb(117,138,255)'],
        [0.46275, 'rgb(118,137,255)'],
        [0.46667, 'rgb(119,136,255)'],
        [0.47059, 'rgb(120,135,255)'],
        [0.47451, 'rgb(121,134,255)'],
        [0.47843, 'rgb(121,133,255)'],
        [0.48235, 'rgb(123,131,255)'],
        [0.48627, 'rgb(124,131,255)'],
        [0.4902, 'rgb(125,130,255)'],
        [0.49412, 'rgb(126,129,255)'],
        [0.49804, 'rgb(127,128,255)'],
        [0.50196, 'rgb(128,127,255)'],
        [0.50588, 'rgb(129,126,255)'],
        [0.5098, 'rgb(130,125,255)'],
        [0.51373, 'rgb(131,124,255)'],
        [0.51765, 'rgb(131,123,255)'],
        [0.52157, 'rgb(133,121,255)'],
        [0.52549, 'rgb(134,121,255)'],
        [0.52941, 'rgb(135,120,255)'],
        [0.53333, 'rgb(136,119,255)'],
        [0.53725, 'rgb(137,118,255)'],
        [0.54118, 'rgb(138,117,255)'],
        [0.5451, 'rgb(139,116,255)'],
        [0.54902, 'rgb(140,114,255)'],
        [0.55294, 'rgb(141,113,255)'],
        [0.55686, 'rgb(142,113,255)'],
        [0.56078, 'rgb(143,112,255)'],
        [0.56471, 'rgb(144,111,255)'],
        [0.56863, 'rgb(145,110,255)'],
        [0.57255, 'rgb(146,109,255)'],
        [0.57647, 'rgb(147,108,255)'],
        [0.58039, 'rgb(147,107,255)'],
        [0.58431, 'rgb(149,105,255)'],
        [0.58824, 'rgb(150,105,255)'],
        [0.59216, 'rgb(151,104,255)'],
        [0.59608, 'rgb(152,103,255)'],
        [0.6, 'rgb(153,102,255)'],
        [0.60392, 'rgb(154,101,255)'],
        [0.60784, 'rgb(155,100,255)'],
        [0.61176, 'rgb(156,98,255)'],
        [0.61569, 'rgb(157,97,255)'],
        [0.61961, 'rgb(158,97,255)'],
        [0.62353, 'rgb(159,96,255)'],
        [0.62745, 'rgb(160,95,255)'],
        [0.63137, 'rgb(161,94,255)'],
        [0.63529, 'rgb(162,93,255)'],
        [0.63922, 'rgb(163,92,255)'],
        [0.64314, 'rgb(163,91,255)'],
        [0.64706, 'rgb(165,89,255)'],
        [0.65098, 'rgb(166,89,255)'],
        [0.6549, 'rgb(167,88,255)'],
        [0.65882, 'rgb(168,87,255)'],
        [0.66275, 'rgb(169,86,255)'],
        [0.66667, 'rgb(170,85,255)'],
        [0.67059, 'rgb(171,84,255)'],
        [0.67451, 'rgb(172,82,255)'],
        [0.67843, 'rgb(173,81,255)'],
        [0.68235, 'rgb(174,81,255)'],
        [0.68627, 'rgb(175,80,255)'],
        [0.6902, 'rgb(176,79,255)'],
        [0.69412, 'rgb(177,78,255)'],
        [0.69804, 'rgb(178,77,255)'],
        [0.70196, 'rgb(179,76,255)'],
        [0.70588, 'rgb(179,75,255)'],
        [0.7098, 'rgb(181,73,255)'],
        [0.71373, 'rgb(182,73,255)'],
        [0.71765, 'rgb(183,72,255)'],
        [0.72157, 'rgb(184,71,255)'],
        [0.72549, 'rgb(185,70,255)'],
        [0.72941, 'rgb(186,69,255)'],
        [0.73333, 'rgb(187,68,255)'],
        [0.73725, 'rgb(188,66,255)'],
        [0.74118, 'rgb(189,65,255)'],
        [0.7451, 'rgb(190,65,255)'],
        [0.74902, 'rgb(191,64,255)'],
        [0.75294, 'rgb(192,63,255)'],
        [0.75686, 'rgb(193,62,255)'],
        [0.76078, 'rgb(194,61,255)'],
        [0.76471, 'rgb(195,60,255)'],
        [0.76863, 'rgb(195,59,255)'],
        [0.77255, 'rgb(197,57,255)'],
        [0.77647, 'rgb(198,56,255)'],
        [0.78039, 'rgb(199,56,255)'],
        [0.78431, 'rgb(200,55,255)'],
        [0.78824, 'rgb(201,54,255)'],
        [0.79216, 'rgb(202,53,255)'],
        [0.79608, 'rgb(203,52,255)'],
        [0.8, 'rgb(204,50,255)'],
        [0.80392, 'rgb(205,49,255)'],
        [0.80784, 'rgb(206,48,255)'],
        [0.81176, 'rgb(207,48,255)'],
        [0.81569, 'rgb(208,47,255)'],
        [0.81961, 'rgb(209,46,255)'],
        [0.82353, 'rgb(210,45,255)'],
        [0.82745, 'rgb(211,44,255)'],
        [0.83137, 'rgb(211,43,255)'],
        [0.83529, 'rgb(213,41,255)'],
        [0.83922, 'rgb(214,40,255)'],
        [0.84314, 'rgb(215,40,255)'],
        [0.84706, 'rgb(216,39,255)'],
        [0.85098, 'rgb(217,38,255)'],
        [0.8549, 'rgb(218,37,255)'],
        [0.85882, 'rgb(219,36,255)'],
        [0.86275, 'rgb(220,34,255)'],
        [0.86667, 'rgb(221,33,255)'],
        [0.87059, 'rgb(222,32,255)'],
        [0.87451, 'rgb(223,32,255)'],
        [0.87843, 'rgb(224,31,255)'],
        [0.88235, 'rgb(225,30,255)'],
        [0.88627, 'rgb(226,29,255)'],
        [0.8902, 'rgb(227,28,255)'],
        [0.89412, 'rgb(227,27,255)'],
        [0.89804, 'rgb(229,25,255)'],
        [0.90196, 'rgb(230,24,255)'],
        [0.90588, 'rgb(231,24,255)'],
        [0.9098, 'rgb(232,23,255)'],
        [0.91373, 'rgb(233,22,255)'],
        [0.91765, 'rgb(234,21,255)'],
        [0.92157, 'rgb(235,20,255)'],
        [0.92549, 'rgb(236,18,255)'],
        [0.92941, 'rgb(237,17,255)'],
        [0.93333, 'rgb(238,16,255)'],
        [0.93725, 'rgb(239,16,255)'],
        [0.94118, 'rgb(240,15,255)'],
        [0.9451, 'rgb(241,14,255)'],
        [0.94902, 'rgb(242,13,255)'],
        [0.95294, 'rgb(243,12,255)'],
        [0.95686, 'rgb(243,11,255)'],
        [0.96078, 'rgb(245,9,255)'],
        [0.96471, 'rgb(246,8,255)'],
        [0.96863, 'rgb(247,8,255)'],
        [0.97255, 'rgb(248,7,255)'],
        [0.97647, 'rgb(249,6,255)'],
        [0.98039, 'rgb(250,5,255)'],
        [0.98431, 'rgb(251,4,255)'],
        [0.98824, 'rgb(252,2,255)'],
        [0.99216, 'rgb(253,1,255)'],
        [0.99608, 'rgb(254,0,255)'],
        [1.0, 'rgb(255,0,255)'],
    ],
    'coolwarm': [
        [0.0, 'rgb(58,76,192)'],
        [0.00392, 'rgb(59,77,193)'],
        [0.00784, 'rgb(60,79,195)'],
        [0.01176, 'rgb(62,81,196)'],
        [0.01569, 'rgb(63,83,198)'],
        [0.01961, 'rgb(64,84,199)'],
        [0.02353, 'rgb(65,86,201)'],
        [0.02745, 'rgb(66,88,202)'],
        [0.03137, 'rgb(67,90,204)'],
        [0.03529, 'rgb(69,91,205)'],
        [0.03922, 'rgb(70,93,207)'],
        [0.04314, 'rgb(71,95,208)'],
        [0.04706, 'rgb(72,96,209)'],
        [0.05098, 'rgb(73,98,211)'],
        [0.0549, 'rgb(75,100,212)'],
        [0.05882, 'rgb(76,102,214)'],
        [0.06275, 'rgb(77,103,215)'],
        [0.06667, 'rgb(78,105,216)'],
        [0.07059, 'rgb(80,107,218)'],
        [0.07451, 'rgb(81,108,219)'],
        [0.07843, 'rgb(82,110,220)'],
        [0.08235, 'rgb(83,112,221)'],
        [0.08627, 'rgb(85,113,222)'],
        [0.0902, 'rgb(86,115,224)'],
        [0.09412, 'rgb(87,117,225)'],
        [0.09804, 'rgb(88,118,226)'],
        [0.10196, 'rgb(90,120,227)'],
        [0.10588, 'rgb(91,121,228)'],
        [0.1098, 'rgb(92,123,229)'],
        [0.11373, 'rgb(93,125,230)'],
        [0.11765, 'rgb(95,126,231)'],
        [0.12157, 'rgb(96,128,232)'],
        [0.12549, 'rgb(97,130,234)'],
        [0.12941, 'rgb(99,131,234)'],
        [0.13333, 'rgb(100,133,235)'],
        [0.13725, 'rgb(101,134,236)'],
        [0.14118, 'rgb(103,136,237)'],
        [0.1451, 'rgb(104,137,238)'],
        [0.14902, 'rgb(105,139,239)'],
        [0.15294, 'rgb(107,141,240)'],
        [0.15686, 'rgb(108,142,241)'],
        [0.16078, 'rgb(109,144,241)'],
        [0.16471, 'rgb(111,145,242)'],
        [0.16863, 'rgb(112,147,243)'],
        [0.17255, 'rgb(113,148,244)'],
        [0.17647, 'rgb(115,149,244)'],
        [0.18039, 'rgb(116,151,245)'],
        [0.18431, 'rgb(117,152,246)'],
        [0.18824, 'rgb(119,154,246)'],
        [0.19216, 'rgb(120,155,247)'],
        [0.19608, 'rgb(122,157,248)'],
        [0.2, 'rgb(123,158,248)'],
        [0.20392, 'rgb(124,160,249)'],
        [0.20784, 'rgb(126,161,249)'],
        [0.21176, 'rgb(127,162,250)'],
        [0.21569, 'rgb(128,164,250)'],
        [0.21961, 'rgb(130,165,251)'],
        [0.22353, 'rgb(131,166,251)'],
        [0.22745, 'rgb(133,168,251)'],
        [0.23137, 'rgb(134,169,252)'],
        [0.23529, 'rgb(135,170,252)'],
        [0.23922, 'rgb(137,172,252)'],
        [0.24314, 'rgb(138,173,253)'],
        [0.24706, 'rgb(139,174,253)'],
        [0.25098, 'rgb(141,175,253)'],
        [0.2549, 'rgb(142,177,253)'],
        [0.25882, 'rgb(144,178,254)'],
        [0.26275, 'rgb(145,179,254)'],
        [0.26667, 'rgb(146,180,254)'],
        [0.27059, 'rgb(148,181,254)'],
        [0.27451, 'rgb(149,183,254)'],
        [0.27843, 'rgb(151,184,254)'],
        [0.28235, 'rgb(152,185,254)'],
        [0.28627, 'rgb(153,186,254)'],
        [0.2902, 'rgb(155,187,254)'],
        [0.29412, 'rgb(156,188,254)'],
        [0.29804, 'rgb(157,189,254)'],
        [0.30196, 'rgb(159,190,254)'],
        [0.30588, 'rgb(160,191,254)'],
        [0.3098, 'rgb(162,192,254)'],
        [0.31373, 'rgb(163,193,254)'],
        [0.31765, 'rgb(164,194,254)'],
        [0.32157, 'rgb(166,195,253)'],
        [0.32549, 'rgb(167,196,253)'],
        [0.32941, 'rgb(168,197,253)'],
        [0.33333, 'rgb(170,198,253)'],
        [0.33725, 'rgb(171,199,252)'],
        [0.34118, 'rgb(172,200,252)'],
        [0.3451, 'rgb(174,201,252)'],
        [0.34902, 'rgb(175,202,251)'],
        [0.35294, 'rgb(176,203,251)'],
        [0.35686, 'rgb(178,203,251)'],
        [0.36078, 'rgb(179,204,250)'],
        [0.36471, 'rgb(180,205,250)'],
        [0.36863, 'rgb(182,206,249)'],
        [0.37255, 'rgb(183,207,249)'],
        [0.37647, 'rgb(184,207,248)'],
        [0.38039, 'rgb(185,208,248)'],
        [0.38431, 'rgb(187,209,247)'],
        [0.38824, 'rgb(188,209,246)'],
        [0.39216, 'rgb(189,210,246)'],
        [0.39608, 'rgb(190,211,245)'],
        [0.4, 'rgb(192,211,245)'],
        [0.40392, 'rgb(193,212,244)'],
        [0.40784, 'rgb(194,212,243)'],
        [0.41176, 'rgb(195,213,242)'],
        [0.41569, 'rgb(197,213,242)'],
        [0.41961, 'rgb(198,214,241)'],
        [0.42353, 'rgb(199,214,240)'],
        [0.42745, 'rgb(200,215,239)'],
        [0.43137, 'rgb(201,215,238)'],
        [0.43529, 'rgb(202,216,238)'],
        [0.43922, 'rgb(204,216,237)'],
        [0.44314, 'rgb(205,217,236)'],
        [0.44706, 'rgb(206,217,235)'],
        [0.45098, 'rgb(207,217,234)'],
        [0.4549, 'rgb(208,218,233)'],
        [0.45882, 'rgb(209,218,232)'],
        [0.46275, 'rgb(210,218,231)'],
        [0.46667, 'rgb(211,219,230)'],
        [0.47059, 'rgb(213,219,229)'],
        [0.47451, 'rgb(214,219,228)'],
        [0.47843, 'rgb(215,219,226)'],
        [0.48235, 'rgb(216,219,225)'],
        [0.48627, 'rgb(217,220,224)'],
        [0.4902, 'rgb(218,220,223)'],
        [0.49412, 'rgb(219,220,222)'],
        [0.49804, 'rgb(220,220,221)'],
        [0.50196, 'rgb(221,220,219)'],
        [0.50588, 'rgb(222,219,218)'],
        [0.5098, 'rgb(223,219,217)'],
        [0.51373, 'rgb(224,218,215)'],
        [0.51765, 'rgb(225,218,214)'],
        [0.52157, 'rgb(226,217,212)'],
        [0.52549, 'rgb(227,217,211)'],
        [0.52941, 'rgb(228,216,209)'],
        [0.53333, 'rgb(229,216,208)'],
        [0.53725, 'rgb(230,215,207)'],
        [0.54118, 'rgb(231,214,205)'],
        [0.5451, 'rgb(231,214,204)'],
        [0.54902, 'rgb(232,213,202)'],
        [0.55294, 'rgb(233,212,201)'],
        [0.55686, 'rgb(234,211,199)'],
        [0.56078, 'rgb(235,211,198)'],
        [0.56471, 'rgb(236,210,196)'],
        [0.56863, 'rgb(236,209,195)'],
        [0.57255, 'rgb(237,208,193)'],
        [0.57647, 'rgb(237,207,192)'],
        [0.58039, 'rgb(238,207,190)'],
        [0.58431, 'rgb(239,206,188)'],
        [0.58824, 'rgb(239,205,187)'],
        [0.59216, 'rgb(240,204,185)'],
        [0.59608, 'rgb(241,203,184)'],
        [0.6, 'rgb(241,202,182)'],
        [0.60392, 'rgb(242,201,181)'],
        [0.60784, 'rgb(242,200,179)'],
        [0.61176, 'rgb(242,199,178)'],
        [0.61569, 'rgb(243,198,176)'],
        [0.61961, 'rgb(243,197,175)'],
        [0.62353, 'rgb(244,196,173)'],
        [0.62745, 'rgb(244,195,171)'],
        [0.63137, 'rgb(244,194,170)'],
        [0.63529, 'rgb(245,193,168)'],
        [0.63922, 'rgb(245,192,167)'],
        [0.64314, 'rgb(245,191,165)'],
        [0.64706, 'rgb(246,189,164)'],
        [0.65098, 'rgb(246,188,162)'],
        [0.6549, 'rgb(246,187,160)'],
        [0.65882, 'rgb(246,186,159)'],
        [0.66275, 'rgb(246,185,157)'],
        [0.66667, 'rgb(246,183,156)'],
        [0.67059, 'rgb(246,182,154)'],
        [0.67451, 'rgb(247,181,152)'],
        [0.67843, 'rgb(247,179,151)'],
        [0.68235, 'rgb(247,178,149)'],
        [0.68627, 'rgb(247,177,148)'],
        [0.6902, 'rgb(247,176,146)'],
        [0.69412, 'rgb(247,174,145)'],
        [0.69804, 'rgb(247,173,143)'],
        [0.70196, 'rgb(246,171,141)'],
        [0.70588, 'rgb(246,170,140)'],
        [0.7098, 'rgb(246,169,138)'],
        [0.71373, 'rgb(246,167,137)'],
        [0.71765, 'rgb(246,166,135)'],
        [0.72157, 'rgb(246,164,134)'],
        [0.72549, 'rgb(246,163,132)'],
        [0.72941, 'rgb(245,161,130)'],
        [0.73333, 'rgb(245,160,129)'],
        [0.73725, 'rgb(245,158,127)'],
        [0.74118, 'rgb(244,157,126)'],
        [0.7451, 'rgb(244,155,124)'],
        [0.74902, 'rgb(244,154,123)'],
        [0.75294, 'rgb(243,152,121)'],
        [0.75686, 'rgb(243,150,120)'],
        [0.76078, 'rgb(243,149,118)'],
        [0.76471, 'rgb(242,147,117)'],
        [0.76863, 'rgb(242,145,115)'],
        [0.77255, 'rgb(241,144,114)'],
        [0.77647, 'rgb(241,142,112)'],
        [0.78039, 'rgb(240,141,111)'],
        [0.78431, 'rgb(240,139,109)'],
        [0.78824, 'rgb(239,137,108)'],
        [0.79216, 'rgb(238,135,106)'],
        [0.79608, 'rgb(238,134,105)'],
        [0.8, 'rgb(237,132,103)'],
        [0.80392, 'rgb(236,130,102)'],
        [0.80784, 'rgb(236,128,100)'],
        [0.81176, 'rgb(235,127,99)'],
        [0.81569, 'rgb(234,125,97)'],
        [0.81961, 'rgb(234,123,96)'],
        [0.82353, 'rgb(233,121,94)'],
        [0.82745, 'rgb(232,119,93)'],
        [0.83137, 'rgb(231,117,92)'],
        [0.83529, 'rgb(230,116,90)'],
        [0.83922, 'rgb(230,114,89)'],
        [0.84314, 'rgb(229,112,87)'],
        [0.84706, 'rgb(228,110,86)'],
        [0.85098, 'rgb(227,108,84)'],
        [0.8549, 'rgb(226,106,83)'],
        [0.85882, 'rgb(225,104,82)'],
        [0.86275, 'rgb(224,102,80)'],
        [0.86667, 'rgb(223,100,79)'],
        [0.87059, 'rgb(222,98,78)'],
        [0.87451, 'rgb(221,96,76)'],
        [0.87843, 'rgb(220,94,75)'],
        [0.88235, 'rgb(219,92,74)'],
        [0.88627, 'rgb(218,90,72)'],
        [0.8902, 'rgb(217,88,71)'],
        [0.89412, 'rgb(216,86,70)'],
        [0.89804, 'rgb(215,84,68)'],
        [0.90196, 'rgb(214,82,67)'],
        [0.90588, 'rgb(212,79,66)'],
        [0.9098, 'rgb(211,77,64)'],
        [0.91373, 'rgb(210,75,63)'],
        [0.91765, 'rgb(209,73,62)'],
        [0.92157, 'rgb(207,70,61)'],
        [0.92549, 'rgb(206,68,60)'],
        [0.92941, 'rgb(205,66,58)'],
        [0.93333, 'rgb(204,63,57)'],
        [0.93725, 'rgb(202,61,56)'],
        [0.94118, 'rgb(201,59,55)'],
        [0.9451, 'rgb(200,56,53)'],
        [0.94902, 'rgb(198,53,52)'],
        [0.95294, 'rgb(197,50,51)'],
        [0.95686, 'rgb(196,48,50)'],
        [0.96078, 'rgb(194,45,49)'],
        [0.96471, 'rgb(193,42,48)'],
        [0.96863, 'rgb(191,40,46)'],
        [0.97255, 'rgb(190,35,45)'],
        [0.97647, 'rgb(188,31,44)'],
        [0.98039, 'rgb(187,26,43)'],
        [0.98431, 'rgb(185,22,42)'],
        [0.98824, 'rgb(184,17,41)'],
        [0.99216, 'rgb(182,13,40)'],
        [0.99608, 'rgb(181,8,39)'],
        [1.0, 'rgb(179,3,38)'],
    ],
    'copper': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(1,0,0)'],
        [0.00784, 'rgb(2,1,0)'],
        [0.01176, 'rgb(3,2,1)'],
        [0.01569, 'rgb(4,3,1)'],
        [0.01961, 'rgb(6,3,2)'],
        [0.02353, 'rgb(7,4,2)'],
        [0.02745, 'rgb(8,5,3)'],
        [0.03137, 'rgb(9,6,3)'],
        [0.03529, 'rgb(11,7,4)'],
        [0.03922, 'rgb(12,7,4)'],
        [0.04314, 'rgb(13,8,5)'],
        [0.04706, 'rgb(14,9,5)'],
        [0.05098, 'rgb(16,10,6)'],
        [0.0549, 'rgb(17,10,6)'],
        [0.05882, 'rgb(18,11,7)'],
        [0.06275, 'rgb(19,12,7)'],
        [0.06667, 'rgb(20,13,8)'],
        [0.07059, 'rgb(22,14,8)'],
        [0.07451, 'rgb(23,14,9)'],
        [0.07843, 'rgb(24,15,9)'],
        [0.08235, 'rgb(25,16,10)'],
        [0.08627, 'rgb(27,17,10)'],
        [0.0902, 'rgb(28,17,11)'],
        [0.09412, 'rgb(29,18,11)'],
        [0.09804, 'rgb(30,19,12)'],
        [0.10196, 'rgb(32,20,12)'],
        [0.10588, 'rgb(33,21,13)'],
        [0.1098, 'rgb(34,21,13)'],
        [0.11373, 'rgb(35,22,14)'],
        [0.11765, 'rgb(37,23,14)'],
        [0.12157, 'rgb(38,24,15)'],
        [0.12549, 'rgb(39,24,15)'],
        [0.12941, 'rgb(40,25,16)'],
        [0.13333, 'rgb(41,26,16)'],
        [0.13725, 'rgb(43,27,17)'],
        [0.14118, 'rgb(44,28,17)'],
        [0.1451, 'rgb(45,28,18)'],
        [0.14902, 'rgb(46,29,18)'],
        [0.15294, 'rgb(48,30,19)'],
        [0.15686, 'rgb(49,31,19)'],
        [0.16078, 'rgb(50,32,20)'],
        [0.16471, 'rgb(51,32,20)'],
        [0.16863, 'rgb(53,33,21)'],
        [0.17255, 'rgb(54,34,21)'],
        [0.17647, 'rgb(55,35,22)'],
        [0.18039, 'rgb(56,35,22)'],
        [0.18431, 'rgb(58,36,23)'],
        [0.18824, 'rgb(59,37,23)'],
        [0.19216, 'rgb(60,38,24)'],
        [0.19608, 'rgb(61,39,24)'],
        [0.2, 'rgb(62,39,25)'],
        [0.20392, 'rgb(64,40,25)'],
        [0.20784, 'rgb(65,41,26)'],
        [0.21176, 'rgb(66,42,26)'],
        [0.21569, 'rgb(67,42,27)'],
        [0.21961, 'rgb(69,43,27)'],
        [0.22353, 'rgb(70,44,28)'],
        [0.22745, 'rgb(71,45,28)'],
        [0.23137, 'rgb(72,46,29)'],
        [0.23529, 'rgb(74,46,29)'],
        [0.23922, 'rgb(75,47,30)'],
        [0.24314, 'rgb(76,48,30)'],
        [0.24706, 'rgb(77,49,31)'],
        [0.25098, 'rgb(79,49,31)'],
        [0.2549, 'rgb(80,50,32)'],
        [0.25882, 'rgb(81,51,32)'],
        [0.26275, 'rgb(82,52,33)'],
        [0.26667, 'rgb(83,53,33)'],
        [0.27059, 'rgb(85,53,34)'],
        [0.27451, 'rgb(86,54,34)'],
        [0.27843, 'rgb(87,55,35)'],
        [0.28235, 'rgb(88,56,35)'],
        [0.28627, 'rgb(90,57,36)'],
        [0.2902, 'rgb(91,57,36)'],
        [0.29412, 'rgb(92,58,37)'],
        [0.29804, 'rgb(93,59,37)'],
        [0.30196, 'rgb(95,60,38)'],
        [0.30588, 'rgb(96,60,38)'],
        [0.3098, 'rgb(97,61,39)'],
        [0.31373, 'rgb(98,62,39)'],
        [0.31765, 'rgb(100,63,40)'],
        [0.32157, 'rgb(101,64,40)'],
        [0.32549, 'rgb(102,64,41)'],
        [0.32941, 'rgb(103,65,41)'],
        [0.33333, 'rgb(104,66,42)'],
        [0.33725, 'rgb(106,67,42)'],
        [0.34118, 'rgb(107,67,43)'],
        [0.3451, 'rgb(108,68,43)'],
        [0.34902, 'rgb(109,69,44)'],
        [0.35294, 'rgb(111,70,44)'],
        [0.35686, 'rgb(112,71,45)'],
        [0.36078, 'rgb(113,71,45)'],
        [0.36471, 'rgb(114,72,46)'],
        [0.36863, 'rgb(116,73,46)'],
        [0.37255, 'rgb(117,74,47)'],
        [0.37647, 'rgb(118,74,47)'],
        [0.38039, 'rgb(119,75,48)'],
        [0.38431, 'rgb(121,76,48)'],
        [0.38824, 'rgb(122,77,49)'],
        [0.39216, 'rgb(123,78,49)'],
        [0.39608, 'rgb(124,78,50)'],
        [0.4, 'rgb(125,79,50)'],
        [0.40392, 'rgb(127,80,51)'],
        [0.40784, 'rgb(128,81,51)'],
        [0.41176, 'rgb(129,82,52)'],
        [0.41569, 'rgb(130,82,52)'],
        [0.41961, 'rgb(132,83,53)'],
        [0.42353, 'rgb(133,84,53)'],
        [0.42745, 'rgb(134,85,54)'],
        [0.43137, 'rgb(135,85,54)'],
        [0.43529, 'rgb(137,86,55)'],
        [0.43922, 'rgb(138,87,55)'],
        [0.44314, 'rgb(139,88,56)'],
        [0.44706, 'rgb(140,89,56)'],
        [0.45098, 'rgb(142,89,57)'],
        [0.4549, 'rgb(143,90,57)'],
        [0.45882, 'rgb(144,91,58)'],
        [0.46275, 'rgb(145,92,58)'],
        [0.46667, 'rgb(146,92,59)'],
        [0.47059, 'rgb(148,93,59)'],
        [0.47451, 'rgb(149,94,60)'],
        [0.47843, 'rgb(150,95,60)'],
        [0.48235, 'rgb(151,96,61)'],
        [0.48627, 'rgb(153,96,61)'],
        [0.4902, 'rgb(154,97,62)'],
        [0.49412, 'rgb(155,98,62)'],
        [0.49804, 'rgb(156,99,63)'],
        [0.50196, 'rgb(158,99,63)'],
        [0.50588, 'rgb(159,100,64)'],
        [0.5098, 'rgb(160,101,64)'],
        [0.51373, 'rgb(161,102,65)'],
        [0.51765, 'rgb(163,103,65)'],
        [0.52157, 'rgb(164,103,66)'],
        [0.52549, 'rgb(165,104,66)'],
        [0.52941, 'rgb(166,105,67)'],
        [0.53333, 'rgb(167,106,67)'],
        [0.53725, 'rgb(169,107,68)'],
        [0.54118, 'rgb(170,107,68)'],
        [0.5451, 'rgb(171,108,69)'],
        [0.54902, 'rgb(172,109,69)'],
        [0.55294, 'rgb(174,110,70)'],
        [0.55686, 'rgb(175,110,70)'],
        [0.56078, 'rgb(176,111,71)'],
        [0.56471, 'rgb(177,112,71)'],
        [0.56863, 'rgb(179,113,72)'],
        [0.57255, 'rgb(180,114,72)'],
        [0.57647, 'rgb(181,114,73)'],
        [0.58039, 'rgb(182,115,73)'],
        [0.58431, 'rgb(184,116,74)'],
        [0.58824, 'rgb(185,117,74)'],
        [0.59216, 'rgb(186,117,75)'],
        [0.59608, 'rgb(187,118,75)'],
        [0.6, 'rgb(188,119,76)'],
        [0.60392, 'rgb(190,120,76)'],
        [0.60784, 'rgb(191,121,77)'],
        [0.61176, 'rgb(192,121,77)'],
        [0.61569, 'rgb(193,122,78)'],
        [0.61961, 'rgb(195,123,78)'],
        [0.62353, 'rgb(196,124,79)'],
        [0.62745, 'rgb(197,124,79)'],
        [0.63137, 'rgb(198,125,80)'],
        [0.63529, 'rgb(200,126,80)'],
        [0.63922, 'rgb(201,127,81)'],
        [0.64314, 'rgb(202,128,81)'],
        [0.64706, 'rgb(203,128,82)'],
        [0.65098, 'rgb(205,129,82)'],
        [0.6549, 'rgb(206,130,83)'],
        [0.65882, 'rgb(207,131,83)'],
        [0.66275, 'rgb(208,132,84)'],
        [0.66667, 'rgb(209,132,84)'],
        [0.67059, 'rgb(211,133,85)'],
        [0.67451, 'rgb(212,134,85)'],
        [0.67843, 'rgb(213,135,86)'],
        [0.68235, 'rgb(214,135,86)'],
        [0.68627, 'rgb(216,136,87)'],
        [0.6902, 'rgb(217,137,87)'],
        [0.69412, 'rgb(218,138,88)'],
        [0.69804, 'rgb(219,139,88)'],
        [0.70196, 'rgb(221,139,89)'],
        [0.70588, 'rgb(222,140,89)'],
        [0.7098, 'rgb(223,141,90)'],
        [0.71373, 'rgb(224,142,90)'],
        [0.71765, 'rgb(226,142,91)'],
        [0.72157, 'rgb(227,143,91)'],
        [0.72549, 'rgb(228,144,92)'],
        [0.72941, 'rgb(229,145,92)'],
        [0.73333, 'rgb(230,146,93)'],
        [0.73725, 'rgb(232,146,93)'],
        [0.74118, 'rgb(233,147,94)'],
        [0.7451, 'rgb(234,148,94)'],
        [0.74902, 'rgb(235,149,95)'],
        [0.75294, 'rgb(237,149,95)'],
        [0.75686, 'rgb(238,150,96)'],
        [0.76078, 'rgb(239,151,96)'],
        [0.76471, 'rgb(240,152,97)'],
        [0.76863, 'rgb(242,153,97)'],
        [0.77255, 'rgb(243,153,98)'],
        [0.77647, 'rgb(244,154,98)'],
        [0.78039, 'rgb(245,155,99)'],
        [0.78431, 'rgb(247,156,99)'],
        [0.78824, 'rgb(248,157,99)'],
        [0.79216, 'rgb(249,157,100)'],
        [0.79608, 'rgb(250,158,100)'],
        [0.8, 'rgb(251,159,101)'],
        [0.80392, 'rgb(253,160,101)'],
        [0.80784, 'rgb(254,160,102)'],
        [0.81176, 'rgb(255,161,102)'],
        [0.81569, 'rgb(255,162,103)'],
        [0.81961, 'rgb(255,163,103)'],
        [0.82353, 'rgb(255,164,104)'],
        [0.82745, 'rgb(255,164,104)'],
        [0.83137, 'rgb(255,165,105)'],
        [0.83529, 'rgb(255,166,105)'],
        [0.83922, 'rgb(255,167,106)'],
        [0.84314, 'rgb(255,167,106)'],
        [0.84706, 'rgb(255,168,107)'],
        [0.85098, 'rgb(255,169,107)'],
        [0.8549, 'rgb(255,170,108)'],
        [0.85882, 'rgb(255,171,108)'],
        [0.86275, 'rgb(255,171,109)'],
        [0.86667, 'rgb(255,172,109)'],
        [0.87059, 'rgb(255,173,110)'],
        [0.87451, 'rgb(255,174,110)'],
        [0.87843, 'rgb(255,174,111)'],
        [0.88235, 'rgb(255,175,111)'],
        [0.88627, 'rgb(255,176,112)'],
        [0.8902, 'rgb(255,177,112)'],
        [0.89412, 'rgb(255,178,113)'],
        [0.89804, 'rgb(255,178,113)'],
        [0.90196, 'rgb(255,179,114)'],
        [0.90588, 'rgb(255,180,114)'],
        [0.9098, 'rgb(255,181,115)'],
        [0.91373, 'rgb(255,182,115)'],
        [0.91765, 'rgb(255,182,116)'],
        [0.92157, 'rgb(255,183,116)'],
        [0.92549, 'rgb(255,184,117)'],
        [0.92941, 'rgb(255,185,117)'],
        [0.93333, 'rgb(255,185,118)'],
        [0.93725, 'rgb(255,186,118)'],
        [0.94118, 'rgb(255,187,119)'],
        [0.9451, 'rgb(255,188,119)'],
        [0.94902, 'rgb(255,189,120)'],
        [0.95294, 'rgb(255,189,120)'],
        [0.95686, 'rgb(255,190,121)'],
        [0.96078, 'rgb(255,191,121)'],
        [0.96471, 'rgb(255,192,122)'],
        [0.96863, 'rgb(255,192,122)'],
        [0.97255, 'rgb(255,193,123)'],
        [0.97647, 'rgb(255,194,123)'],
        [0.98039, 'rgb(255,195,124)'],
        [0.98431, 'rgb(255,196,124)'],
        [0.98824, 'rgb(255,196,125)'],
        [0.99216, 'rgb(255,197,125)'],
        [0.99608, 'rgb(255,198,126)'],
        [1.0, 'rgb(255,199,126)'],
    ],
    'cubehelix': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(1,0,1)'],
        [0.00784, 'rgb(3,1,3)'],
        [0.01176, 'rgb(4,1,4)'],
        [0.01569, 'rgb(6,2,6)'],
        [0.01961, 'rgb(8,2,8)'],
        [0.02353, 'rgb(9,3,9)'],
        [0.02745, 'rgb(10,4,11)'],
        [0.03137, 'rgb(12,4,13)'],
        [0.03529, 'rgb(13,5,15)'],
        [0.03922, 'rgb(14,6,17)'],
        [0.04314, 'rgb(15,6,19)'],
        [0.04706, 'rgb(17,7,21)'],
        [0.05098, 'rgb(18,8,23)'],
        [0.0549, 'rgb(19,9,25)'],
        [0.05882, 'rgb(20,10,27)'],
        [0.06275, 'rgb(20,11,29)'],
        [0.06667, 'rgb(21,11,31)'],
        [0.07059, 'rgb(22,12,33)'],
        [0.07451, 'rgb(23,13,35)'],
        [0.07843, 'rgb(23,14,37)'],
        [0.08235, 'rgb(24,15,39)'],
        [0.08627, 'rgb(24,17,41)'],
        [0.0902, 'rgb(25,18,43)'],
        [0.09412, 'rgb(25,19,45)'],
        [0.09804, 'rgb(25,20,47)'],
        [0.10196, 'rgb(26,21,48)'],
        [0.10588, 'rgb(26,22,50)'],
        [0.1098, 'rgb(26,24,52)'],
        [0.11373, 'rgb(26,25,54)'],
        [0.11765, 'rgb(26,26,56)'],
        [0.12157, 'rgb(26,28,57)'],
        [0.12549, 'rgb(26,29,59)'],
        [0.12941, 'rgb(26,31,60)'],
        [0.13333, 'rgb(26,32,62)'],
        [0.13725, 'rgb(26,34,63)'],
        [0.14118, 'rgb(26,35,65)'],
        [0.1451, 'rgb(25,37,66)'],
        [0.14902, 'rgb(25,38,67)'],
        [0.15294, 'rgb(25,40,69)'],
        [0.15686, 'rgb(25,41,70)'],
        [0.16078, 'rgb(24,43,71)'],
        [0.16471, 'rgb(24,45,72)'],
        [0.16863, 'rgb(24,46,73)'],
        [0.17255, 'rgb(23,48,74)'],
        [0.17647, 'rgb(23,50,74)'],
        [0.18039, 'rgb(23,52,75)'],
        [0.18431, 'rgb(23,53,76)'],
        [0.18824, 'rgb(22,55,76)'],
        [0.19216, 'rgb(22,57,77)'],
        [0.19608, 'rgb(22,58,77)'],
        [0.2, 'rgb(21,60,77)'],
        [0.20392, 'rgb(21,62,78)'],
        [0.20784, 'rgb(21,64,78)'],
        [0.21176, 'rgb(21,66,78)'],
        [0.21569, 'rgb(21,67,78)'],
        [0.21961, 'rgb(21,69,78)'],
        [0.22353, 'rgb(20,71,78)'],
        [0.22745, 'rgb(20,73,78)'],
        [0.23137, 'rgb(20,74,77)'],
        [0.23529, 'rgb(21,76,77)'],
        [0.23922, 'rgb(21,78,77)'],
        [0.24314, 'rgb(21,79,76)'],
        [0.24706, 'rgb(21,81,76)'],
        [0.25098, 'rgb(21,83,75)'],
        [0.2549, 'rgb(22,84,75)'],
        [0.25882, 'rgb(22,86,74)'],
        [0.26275, 'rgb(22,88,73)'],
        [0.26667, 'rgb(23,89,73)'],
        [0.27059, 'rgb(23,91,72)'],
        [0.27451, 'rgb(24,92,71)'],
        [0.27843, 'rgb(25,94,70)'],
        [0.28235, 'rgb(26,95,69)'],
        [0.28627, 'rgb(27,97,68)'],
        [0.2902, 'rgb(27,98,67)'],
        [0.29412, 'rgb(28,99,66)'],
        [0.29804, 'rgb(30,101,66)'],
        [0.30196, 'rgb(31,102,65)'],
        [0.30588, 'rgb(32,103,64)'],
        [0.3098, 'rgb(33,104,63)'],
        [0.31373, 'rgb(35,106,61)'],
        [0.31765, 'rgb(36,107,60)'],
        [0.32157, 'rgb(38,108,59)'],
        [0.32549, 'rgb(39,109,58)'],
        [0.32941, 'rgb(41,110,58)'],
        [0.33333, 'rgb(43,111,57)'],
        [0.33725, 'rgb(45,112,56)'],
        [0.34118, 'rgb(47,113,55)'],
        [0.3451, 'rgb(49,114,54)'],
        [0.34902, 'rgb(51,114,53)'],
        [0.35294, 'rgb(53,115,52)'],
        [0.35686, 'rgb(55,116,51)'],
        [0.36078, 'rgb(57,116,51)'],
        [0.36471, 'rgb(60,117,50)'],
        [0.36863, 'rgb(62,118,49)'],
        [0.37255, 'rgb(65,118,49)'],
        [0.37647, 'rgb(67,119,48)'],
        [0.38039, 'rgb(70,119,48)'],
        [0.38431, 'rgb(72,120,47)'],
        [0.38824, 'rgb(75,120,47)'],
        [0.39216, 'rgb(78,120,47)'],
        [0.39608, 'rgb(81,121,46)'],
        [0.4, 'rgb(83,121,46)'],
        [0.40392, 'rgb(86,121,46)'],
        [0.40784, 'rgb(89,121,46)'],
        [0.41176, 'rgb(92,122,46)'],
        [0.41569, 'rgb(95,122,47)'],
        [0.41961, 'rgb(98,122,47)'],
        [0.42353, 'rgb(101,122,47)'],
        [0.42745, 'rgb(104,122,48)'],
        [0.43137, 'rgb(107,122,48)'],
        [0.43529, 'rgb(110,122,49)'],
        [0.43922, 'rgb(113,122,50)'],
        [0.44314, 'rgb(116,122,50)'],
        [0.44706, 'rgb(120,122,51)'],
        [0.45098, 'rgb(123,122,52)'],
        [0.4549, 'rgb(126,122,53)'],
        [0.45882, 'rgb(129,122,55)'],
        [0.46275, 'rgb(132,122,56)'],
        [0.46667, 'rgb(135,122,57)'],
        [0.47059, 'rgb(138,121,59)'],
        [0.47451, 'rgb(141,121,60)'],
        [0.47843, 'rgb(144,121,62)'],
        [0.48235, 'rgb(147,121,64)'],
        [0.48627, 'rgb(150,121,65)'],
        [0.4902, 'rgb(153,121,67)'],
        [0.49412, 'rgb(155,121,69)'],
        [0.49804, 'rgb(158,121,71)'],
        [0.50196, 'rgb(161,121,74)'],
        [0.50588, 'rgb(164,120,76)'],
        [0.5098, 'rgb(166,120,78)'],
        [0.51373, 'rgb(169,120,81)'],
        [0.51765, 'rgb(171,120,83)'],
        [0.52157, 'rgb(174,120,86)'],
        [0.52549, 'rgb(176,120,88)'],
        [0.52941, 'rgb(178,120,91)'],
        [0.53333, 'rgb(181,120,94)'],
        [0.53725, 'rgb(183,120,96)'],
        [0.54118, 'rgb(185,120,99)'],
        [0.5451, 'rgb(187,121,102)'],
        [0.54902, 'rgb(189,121,105)'],
        [0.55294, 'rgb(191,121,108)'],
        [0.55686, 'rgb(193,121,111)'],
        [0.56078, 'rgb(194,121,114)'],
        [0.56471, 'rgb(196,122,117)'],
        [0.56863, 'rgb(198,122,120)'],
        [0.57255, 'rgb(199,122,124)'],
        [0.57647, 'rgb(201,123,127)'],
        [0.58039, 'rgb(202,123,130)'],
        [0.58431, 'rgb(203,124,133)'],
        [0.58824, 'rgb(204,124,136)'],
        [0.59216, 'rgb(205,125,140)'],
        [0.59608, 'rgb(206,125,143)'],
        [0.6, 'rgb(207,126,146)'],
        [0.60392, 'rgb(208,127,149)'],
        [0.60784, 'rgb(209,127,153)'],
        [0.61176, 'rgb(209,128,156)'],
        [0.61569, 'rgb(210,129,159)'],
        [0.61961, 'rgb(211,130,162)'],
        [0.62353, 'rgb(211,131,165)'],
        [0.62745, 'rgb(211,131,169)'],
        [0.63137, 'rgb(212,132,172)'],
        [0.63529, 'rgb(212,133,175)'],
        [0.63922, 'rgb(212,135,178)'],
        [0.64314, 'rgb(212,136,181)'],
        [0.64706, 'rgb(212,137,184)'],
        [0.65098, 'rgb(212,138,186)'],
        [0.6549, 'rgb(212,139,189)'],
        [0.65882, 'rgb(212,140,192)'],
        [0.66275, 'rgb(211,142,195)'],
        [0.66667, 'rgb(211,143,197)'],
        [0.67059, 'rgb(211,144,200)'],
        [0.67451, 'rgb(210,146,203)'],
        [0.67843, 'rgb(210,147,205)'],
        [0.68235, 'rgb(210,149,207)'],
        [0.68627, 'rgb(209,150,210)'],
        [0.6902, 'rgb(208,152,212)'],
        [0.69412, 'rgb(208,154,214)'],
        [0.69804, 'rgb(207,155,216)'],
        [0.70196, 'rgb(207,157,218)'],
        [0.70588, 'rgb(206,158,220)'],
        [0.7098, 'rgb(205,160,222)'],
        [0.71373, 'rgb(205,162,224)'],
        [0.71765, 'rgb(204,164,226)'],
        [0.72157, 'rgb(203,165,227)'],
        [0.72549, 'rgb(203,167,229)'],
        [0.72941, 'rgb(202,169,230)'],
        [0.73333, 'rgb(201,171,231)'],
        [0.73725, 'rgb(201,172,233)'],
        [0.74118, 'rgb(200,174,234)'],
        [0.7451, 'rgb(199,176,235)'],
        [0.74902, 'rgb(199,178,236)'],
        [0.75294, 'rgb(198,180,237)'],
        [0.75686, 'rgb(197,182,238)'],
        [0.76078, 'rgb(197,183,239)'],
        [0.76471, 'rgb(196,185,239)'],
        [0.76863, 'rgb(196,187,240)'],
        [0.77255, 'rgb(195,189,241)'],
        [0.77647, 'rgb(195,191,241)'],
        [0.78039, 'rgb(194,193,242)'],
        [0.78431, 'rgb(194,194,242)'],
        [0.78824, 'rgb(194,196,242)'],
        [0.79216, 'rgb(193,198,243)'],
        [0.79608, 'rgb(193,200,243)'],
        [0.8, 'rgb(193,202,243)'],
        [0.80392, 'rgb(193,203,243)'],
        [0.80784, 'rgb(193,205,243)'],
        [0.81176, 'rgb(193,207,243)'],
        [0.81569, 'rgb(193,208,243)'],
        [0.81961, 'rgb(193,210,243)'],
        [0.82353, 'rgb(193,212,243)'],
        [0.82745, 'rgb(193,213,243)'],
        [0.83137, 'rgb(194,215,242)'],
        [0.83529, 'rgb(194,216,242)'],
        [0.83922, 'rgb(195,218,242)'],
        [0.84314, 'rgb(195,219,242)'],
        [0.84706, 'rgb(196,221,241)'],
        [0.85098, 'rgb(196,222,241)'],
        [0.8549, 'rgb(197,224,241)'],
        [0.85882, 'rgb(198,225,241)'],
        [0.86275, 'rgb(199,226,240)'],
        [0.86667, 'rgb(200,228,240)'],
        [0.87059, 'rgb(200,229,240)'],
        [0.87451, 'rgb(202,230,239)'],
        [0.87843, 'rgb(203,231,239)'],
        [0.88235, 'rgb(204,232,239)'],
        [0.88627, 'rgb(205,233,239)'],
        [0.8902, 'rgb(206,235,239)'],
        [0.89412, 'rgb(208,236,238)'],
        [0.89804, 'rgb(209,237,238)'],
        [0.90196, 'rgb(210,238,238)'],
        [0.90588, 'rgb(212,239,238)'],
        [0.9098, 'rgb(213,240,238)'],
        [0.91373, 'rgb(215,240,238)'],
        [0.91765, 'rgb(217,241,238)'],
        [0.92157, 'rgb(218,242,238)'],
        [0.92549, 'rgb(220,243,239)'],
        [0.92941, 'rgb(222,244,239)'],
        [0.93333, 'rgb(223,244,239)'],
        [0.93725, 'rgb(225,245,240)'],
        [0.94118, 'rgb(227,246,240)'],
        [0.9451, 'rgb(229,247,240)'],
        [0.94902, 'rgb(231,247,241)'],
        [0.95294, 'rgb(232,248,242)'],
        [0.95686, 'rgb(234,248,242)'],
        [0.96078, 'rgb(236,249,243)'],
        [0.96471, 'rgb(238,250,244)'],
        [0.96863, 'rgb(240,250,245)'],
        [0.97255, 'rgb(242,251,246)'],
        [0.97647, 'rgb(244,251,247)'],
        [0.98039, 'rgb(245,252,248)'],
        [0.98431, 'rgb(247,252,249)'],
        [0.98824, 'rgb(249,253,250)'],
        [0.99216, 'rgb(251,253,252)'],
        [0.99608, 'rgb(253,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'flag': [
        [0.0, 'rgb(255,0,0)'],
        [0.00392, 'rgb(255,96,53)'],
        [0.00784, 'rgb(255,178,125)'],
        [0.01176, 'rgb(255,234,198)'],
        [0.01569, 'rgb(255,254,255)'],
        [0.01961, 'rgb(204,237,255)'],
        [0.02353, 'rgb(132,185,255)'],
        [0.02745, 'rgb(60,105,255)'],
        [0.03137, 'rgb(0,9,255)'],
        [0.03529, 'rgb(0,0,207)'],
        [0.03922, 'rgb(0,0,136)'],
        [0.04314, 'rgb(0,0,63)'],
        [0.04706, 'rgb(0,0,0)'],
        [0.05098, 'rgb(43,0,0)'],
        [0.0549, 'rgb(115,0,0)'],
        [0.05882, 'rgb(188,0,0)'],
        [0.06275, 'rgb(252,0,0)'],
        [0.06667, 'rgb(255,78,40)'],
        [0.07059, 'rgb(255,164,111)'],
        [0.07451, 'rgb(255,226,184)'],
        [0.07843, 'rgb(255,253,249)'],
        [0.08235, 'rgb(217,243,255)'],
        [0.08627, 'rgb(146,197,255)'],
        [0.0902, 'rgb(73,122,255)'],
        [0.09412, 'rgb(8,28,255)'],
        [0.09804, 'rgb(0,0,220)'],
        [0.10196, 'rgb(0,0,150)'],
        [0.10588, 'rgb(0,0,76)'],
        [0.1098, 'rgb(0,0,10)'],
        [0.11373, 'rgb(31,0,0)'],
        [0.11765, 'rgb(101,0,0)'],
        [0.12157, 'rgb(174,0,0)'],
        [0.12549, 'rgb(241,0,0)'],
        [0.12941, 'rgb(255,60,28)'],
        [0.13333, 'rgb(255,149,97)'],
        [0.13725, 'rgb(255,216,171)'],
        [0.14118, 'rgb(255,251,238)'],
        [0.1451, 'rgb(229,248,255)'],
        [0.14902, 'rgb(160,209,255)'],
        [0.15294, 'rgb(87,138,255)'],
        [0.15686, 'rgb(19,46,255)'],
        [0.16078, 'rgb(0,0,232)'],
        [0.16471, 'rgb(0,0,164)'],
        [0.16863, 'rgb(0,0,90)'],
        [0.17255, 'rgb(0,0,22)'],
        [0.17647, 'rgb(19,0,0)'],
        [0.18039, 'rgb(87,0,0)'],
        [0.18431, 'rgb(160,0,0)'],
        [0.18824, 'rgb(229,0,0)'],
        [0.19216, 'rgb(255,42,16)'],
        [0.19608, 'rgb(255,134,83)'],
        [0.2, 'rgb(255,206,157)'],
        [0.20392, 'rgb(255,247,226)'],
        [0.20784, 'rgb(241,252,255)'],
        [0.21176, 'rgb(174,219,255)'],
        [0.21569, 'rgb(101,153,255)'],
        [0.21961, 'rgb(31,65,255)'],
        [0.22353, 'rgb(0,0,244)'],
        [0.22745, 'rgb(0,0,178)'],
        [0.23137, 'rgb(0,0,104)'],
        [0.23529, 'rgb(0,0,34)'],
        [0.23922, 'rgb(8,0,0)'],
        [0.24314, 'rgb(73,0,0)'],
        [0.24706, 'rgb(146,0,0)'],
        [0.25098, 'rgb(217,0,0)'],
        [0.2549, 'rgb(255,23,5)'],
        [0.25882, 'rgb(255,117,70)'],
        [0.26275, 'rgb(255,194,143)'],
        [0.26667, 'rgb(255,242,214)'],
        [0.27059, 'rgb(252,254,255)'],
        [0.27451, 'rgb(188,228,255)'],
        [0.27843, 'rgb(115,168,255)'],
        [0.28235, 'rgb(43,83,255)'],
        [0.28627, 'rgb(0,0,255)'],
        [0.2902, 'rgb(0,0,191)'],
        [0.29412, 'rgb(0,0,118)'],
        [0.29804, 'rgb(0,0,47)'],
        [0.30196, 'rgb(0,0,0)'],
        [0.30588, 'rgb(60,0,0)'],
        [0.3098, 'rgb(132,0,0)'],
        [0.31373, 'rgb(204,0,0)'],
        [0.31765, 'rgb(255,4,0)'],
        [0.32157, 'rgb(255,100,56)'],
        [0.32549, 'rgb(255,181,129)'],
        [0.32941, 'rgb(255,236,201)'],
        [0.33333, 'rgb(255,255,255)'],
        [0.33725, 'rgb(201,236,255)'],
        [0.34118, 'rgb(129,181,255)'],
        [0.3451, 'rgb(56,100,255)'],
        [0.34902, 'rgb(0,4,255)'],
        [0.35294, 'rgb(0,0,204)'],
        [0.35686, 'rgb(0,0,132)'],
        [0.36078, 'rgb(0,0,60)'],
        [0.36471, 'rgb(0,0,0)'],
        [0.36863, 'rgb(47,0,0)'],
        [0.37255, 'rgb(118,0,0)'],
        [0.37647, 'rgb(191,0,0)'],
        [0.38039, 'rgb(255,0,0)'],
        [0.38431, 'rgb(255,83,43)'],
        [0.38824, 'rgb(255,168,115)'],
        [0.39216, 'rgb(255,228,188)'],
        [0.39608, 'rgb(255,254,252)'],
        [0.4, 'rgb(214,242,255)'],
        [0.40392, 'rgb(143,194,255)'],
        [0.40784, 'rgb(70,117,255)'],
        [0.41176, 'rgb(5,23,255)'],
        [0.41569, 'rgb(0,0,217)'],
        [0.41961, 'rgb(0,0,146)'],
        [0.42353, 'rgb(0,0,73)'],
        [0.42745, 'rgb(0,0,8)'],
        [0.43137, 'rgb(34,0,0)'],
        [0.43529, 'rgb(104,0,0)'],
        [0.43922, 'rgb(178,0,0)'],
        [0.44314, 'rgb(244,0,0)'],
        [0.44706, 'rgb(255,65,31)'],
        [0.45098, 'rgb(255,153,101)'],
        [0.4549, 'rgb(255,219,174)'],
        [0.45882, 'rgb(255,252,241)'],
        [0.46275, 'rgb(226,247,255)'],
        [0.46667, 'rgb(157,206,255)'],
        [0.47059, 'rgb(83,134,255)'],
        [0.47451, 'rgb(16,42,255)'],
        [0.47843, 'rgb(0,0,229)'],
        [0.48235, 'rgb(0,0,160)'],
        [0.48627, 'rgb(0,0,87)'],
        [0.4902, 'rgb(0,0,19)'],
        [0.49412, 'rgb(22,0,0)'],
        [0.49804, 'rgb(90,0,0)'],
        [0.50196, 'rgb(164,0,0)'],
        [0.50588, 'rgb(232,0,0)'],
        [0.5098, 'rgb(255,46,19)'],
        [0.51373, 'rgb(255,138,87)'],
        [0.51765, 'rgb(255,209,160)'],
        [0.52157, 'rgb(255,248,229)'],
        [0.52549, 'rgb(238,251,255)'],
        [0.52941, 'rgb(171,216,255)'],
        [0.53333, 'rgb(97,149,255)'],
        [0.53725, 'rgb(28,60,255)'],
        [0.54118, 'rgb(0,0,241)'],
        [0.5451, 'rgb(0,0,174)'],
        [0.54902, 'rgb(0,0,101)'],
        [0.55294, 'rgb(0,0,31)'],
        [0.55686, 'rgb(10,0,0)'],
        [0.56078, 'rgb(76,0,0)'],
        [0.56471, 'rgb(150,0,0)'],
        [0.56863, 'rgb(220,0,0)'],
        [0.57255, 'rgb(255,28,8)'],
        [0.57647, 'rgb(255,122,73)'],
        [0.58039, 'rgb(255,197,146)'],
        [0.58431, 'rgb(255,243,217)'],
        [0.58824, 'rgb(249,253,255)'],
        [0.59216, 'rgb(184,226,255)'],
        [0.59608, 'rgb(111,164,255)'],
        [0.6, 'rgb(40,78,255)'],
        [0.60392, 'rgb(0,0,252)'],
        [0.60784, 'rgb(0,0,188)'],
        [0.61176, 'rgb(0,0,115)'],
        [0.61569, 'rgb(0,0,43)'],
        [0.61961, 'rgb(0,0,0)'],
        [0.62353, 'rgb(63,0,0)'],
        [0.62745, 'rgb(136,0,0)'],
        [0.63137, 'rgb(207,0,0)'],
        [0.63529, 'rgb(255,9,0)'],
        [0.63922, 'rgb(255,105,60)'],
        [0.64314, 'rgb(255,185,132)'],
        [0.64706, 'rgb(255,237,204)'],
        [0.65098, 'rgb(255,254,255)'],
        [0.6549, 'rgb(198,234,255)'],
        [0.65882, 'rgb(125,178,255)'],
        [0.66275, 'rgb(53,96,255)'],
        [0.66667, 'rgb(0,0,255)'],
        [0.67059, 'rgb(0,0,201)'],
        [0.67451, 'rgb(0,0,129)'],
        [0.67843, 'rgb(0,0,56)'],
        [0.68235, 'rgb(0,0,0)'],
        [0.68627, 'rgb(50,0,0)'],
        [0.6902, 'rgb(122,0,0)'],
        [0.69412, 'rgb(194,0,0)'],
        [0.69804, 'rgb(255,0,0)'],
        [0.70196, 'rgb(255,87,47)'],
        [0.70588, 'rgb(255,171,118)'],
        [0.7098, 'rgb(255,230,191)'],
        [0.71373, 'rgb(255,254,255)'],
        [0.71765, 'rgb(211,241,255)'],
        [0.72157, 'rgb(139,191,255)'],
        [0.72549, 'rgb(66,113,255)'],
        [0.72941, 'rgb(2,18,255)'],
        [0.73333, 'rgb(0,0,214)'],
        [0.73725, 'rgb(0,0,143)'],
        [0.74118, 'rgb(0,0,70)'],
        [0.7451, 'rgb(0,0,5)'],
        [0.74902, 'rgb(37,0,0)'],
        [0.75294, 'rgb(108,0,0)'],
        [0.75686, 'rgb(181,0,0)'],
        [0.76078, 'rgb(246,0,0)'],
        [0.76471, 'rgb(255,69,34)'],
        [0.76863, 'rgb(255,157,104)'],
        [0.77255, 'rgb(255,221,178)'],
        [0.77647, 'rgb(255,252,244)'],
        [0.78039, 'rgb(223,246,255)'],
        [0.78431, 'rgb(153,203,255)'],
        [0.78824, 'rgb(80,130,255)'],
        [0.79216, 'rgb(13,37,255)'],
        [0.79608, 'rgb(0,0,226)'],
        [0.8, 'rgb(0,0,157)'],
        [0.80392, 'rgb(0,0,83)'],
        [0.80784, 'rgb(0,0,16)'],
        [0.81176, 'rgb(25,0,0)'],
        [0.81569, 'rgb(94,0,0)'],
        [0.81961, 'rgb(167,0,0)'],
        [0.82353, 'rgb(235,0,0)'],
        [0.82745, 'rgb(255,51,22)'],
        [0.83137, 'rgb(255,142,90)'],
        [0.83529, 'rgb(255,211,164)'],
        [0.83922, 'rgb(255,249,232)'],
        [0.84314, 'rgb(235,250,255)'],
        [0.84706, 'rgb(167,214,255)'],
        [0.85098, 'rgb(94,146,255)'],
        [0.8549, 'rgb(25,56,255)'],
        [0.85882, 'rgb(0,0,238)'],
        [0.86275, 'rgb(0,0,171)'],
        [0.86667, 'rgb(0,0,97)'],
        [0.87059, 'rgb(0,0,28)'],
        [0.87451, 'rgb(13,0,0)'],
        [0.87843, 'rgb(80,0,0)'],
        [0.88235, 'rgb(153,0,0)'],
        [0.88627, 'rgb(223,0,0)'],
        [0.8902, 'rgb(255,32,10)'],
        [0.89412, 'rgb(255,126,76)'],
        [0.89804, 'rgb(255,200,150)'],
        [0.90196, 'rgb(255,245,220)'],
        [0.90588, 'rgb(246,253,255)'],
        [0.9098, 'rgb(181,223,255)'],
        [0.91373, 'rgb(108,161,255)'],
        [0.91765, 'rgb(37,74,255)'],
        [0.92157, 'rgb(0,0,249)'],
        [0.92549, 'rgb(0,0,184)'],
        [0.92941, 'rgb(0,0,111)'],
        [0.93333, 'rgb(0,0,40)'],
        [0.93725, 'rgb(2,0,0)'],
        [0.94118, 'rgb(66,0,0)'],
        [0.9451, 'rgb(139,0,0)'],
        [0.94902, 'rgb(211,0,0)'],
        [0.95294, 'rgb(255,14,0)'],
        [0.95686, 'rgb(255,109,63)'],
        [0.96078, 'rgb(255,188,136)'],
        [0.96471, 'rgb(255,239,207)'],
        [0.96863, 'rgb(255,254,255)'],
        [0.97255, 'rgb(194,232,255)'],
        [0.97647, 'rgb(122,175,255)'],
        [0.98039, 'rgb(50,92,255)'],
        [0.98431, 'rgb(0,0,255)'],
        [0.98824, 'rgb(0,0,198)'],
        [0.99216, 'rgb(0,0,125)'],
        [0.99608, 'rgb(0,0,53)'],
        [1.0, 'rgb(0,0,0)'],
    ],
    'gist_earth': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(0,0,43)'],
        [0.00784, 'rgb(1,0,56)'],
        [0.01176, 'rgb(1,0,67)'],
        [0.01569, 'rgb(2,0,78)'],
        [0.01961, 'rgb(3,0,88)'],
        [0.02353, 'rgb(3,0,99)'],
        [0.02745, 'rgb(4,0,110)'],
        [0.03137, 'rgb(5,2,115)'],
        [0.03529, 'rgb(5,4,116)'],
        [0.03922, 'rgb(6,6,116)'],
        [0.04314, 'rgb(7,9,116)'],
        [0.04706, 'rgb(7,11,116)'],
        [0.05098, 'rgb(8,13,116)'],
        [0.0549, 'rgb(9,16,117)'],
        [0.05882, 'rgb(9,18,117)'],
        [0.06275, 'rgb(10,20,117)'],
        [0.06667, 'rgb(11,22,117)'],
        [0.07059, 'rgb(11,25,117)'],
        [0.07451, 'rgb(12,27,117)'],
        [0.07843, 'rgb(13,29,118)'],
        [0.08235, 'rgb(13,32,118)'],
        [0.08627, 'rgb(14,34,118)'],
        [0.0902, 'rgb(15,36,118)'],
        [0.09412, 'rgb(15,39,118)'],
        [0.09804, 'rgb(16,41,119)'],
        [0.10196, 'rgb(17,43,119)'],
        [0.10588, 'rgb(17,45,119)'],
        [0.1098, 'rgb(18,48,119)'],
        [0.11373, 'rgb(19,50,119)'],
        [0.11765, 'rgb(19,52,119)'],
        [0.12157, 'rgb(20,54,120)'],
        [0.12549, 'rgb(21,56,120)'],
        [0.12941, 'rgb(21,58,120)'],
        [0.13333, 'rgb(22,60,120)'],
        [0.13725, 'rgb(23,62,120)'],
        [0.14118, 'rgb(23,64,121)'],
        [0.1451, 'rgb(24,66,121)'],
        [0.14902, 'rgb(25,69,121)'],
        [0.15294, 'rgb(25,71,121)'],
        [0.15686, 'rgb(26,73,121)'],
        [0.16078, 'rgb(27,75,121)'],
        [0.16471, 'rgb(27,77,122)'],
        [0.16863, 'rgb(28,79,122)'],
        [0.17255, 'rgb(29,81,122)'],
        [0.17647, 'rgb(29,83,122)'],
        [0.18039, 'rgb(30,84,122)'],
        [0.18431, 'rgb(31,86,123)'],
        [0.18824, 'rgb(31,88,123)'],
        [0.19216, 'rgb(32,90,123)'],
        [0.19608, 'rgb(33,92,123)'],
        [0.2, 'rgb(33,94,123)'],
        [0.20392, 'rgb(34,96,123)'],
        [0.20784, 'rgb(35,97,124)'],
        [0.21176, 'rgb(35,99,124)'],
        [0.21569, 'rgb(36,101,124)'],
        [0.21961, 'rgb(37,102,124)'],
        [0.22353, 'rgb(37,104,124)'],
        [0.22745, 'rgb(38,105,125)'],
        [0.23137, 'rgb(39,107,125)'],
        [0.23529, 'rgb(39,109,125)'],
        [0.23922, 'rgb(40,110,125)'],
        [0.24314, 'rgb(41,112,125)'],
        [0.24706, 'rgb(41,113,125)'],
        [0.25098, 'rgb(42,115,126)'],
        [0.2549, 'rgb(43,116,126)'],
        [0.25882, 'rgb(43,118,126)'],
        [0.26275, 'rgb(44,120,126)'],
        [0.26667, 'rgb(45,121,126)'],
        [0.27059, 'rgb(45,123,127)'],
        [0.27451, 'rgb(46,124,127)'],
        [0.27843, 'rgb(47,126,127)'],
        [0.28235, 'rgb(47,127,127)'],
        [0.28627, 'rgb(48,128,126)'],
        [0.2902, 'rgb(48,129,125)'],
        [0.29412, 'rgb(49,129,123)'],
        [0.29804, 'rgb(49,130,122)'],
        [0.30196, 'rgb(50,130,121)'],
        [0.30588, 'rgb(50,131,120)'],
        [0.3098, 'rgb(51,132,119)'],
        [0.31373, 'rgb(51,132,117)'],
        [0.31765, 'rgb(52,133,116)'],
        [0.32157, 'rgb(52,133,115)'],
        [0.32549, 'rgb(53,134,114)'],
        [0.32941, 'rgb(53,134,112)'],
        [0.33333, 'rgb(54,135,111)'],
        [0.33725, 'rgb(54,136,110)'],
        [0.34118, 'rgb(55,136,109)'],
        [0.3451, 'rgb(55,137,108)'],
        [0.34902, 'rgb(56,137,106)'],
        [0.35294, 'rgb(56,138,105)'],
        [0.35686, 'rgb(56,138,104)'],
        [0.36078, 'rgb(57,139,103)'],
        [0.36471, 'rgb(57,140,101)'],
        [0.36863, 'rgb(58,140,100)'],
        [0.37255, 'rgb(58,141,99)'],
        [0.37647, 'rgb(59,141,98)'],
        [0.38039, 'rgb(59,142,97)'],
        [0.38431, 'rgb(60,142,95)'],
        [0.38824, 'rgb(60,143,94)'],
        [0.39216, 'rgb(61,144,93)'],
        [0.39608, 'rgb(61,144,92)'],
        [0.4, 'rgb(62,145,90)'],
        [0.40392, 'rgb(62,145,89)'],
        [0.40784, 'rgb(63,146,88)'],
        [0.41176, 'rgb(63,147,87)'],
        [0.41569, 'rgb(64,147,85)'],
        [0.41961, 'rgb(64,148,84)'],
        [0.42353, 'rgb(64,148,83)'],
        [0.42745, 'rgb(65,149,82)'],
        [0.43137, 'rgb(65,149,81)'],
        [0.43529, 'rgb(66,150,79)'],
        [0.43922, 'rgb(66,151,78)'],
        [0.44314, 'rgb(67,151,77)'],
        [0.44706, 'rgb(67,152,76)'],
        [0.45098, 'rgb(68,152,74)'],
        [0.4549, 'rgb(68,153,73)'],
        [0.45882, 'rgb(69,153,72)'],
        [0.46275, 'rgb(71,154,71)'],
        [0.46667, 'rgb(73,155,70)'],
        [0.47059, 'rgb(75,155,70)'],
        [0.47451, 'rgb(78,156,71)'],
        [0.47843, 'rgb(80,156,71)'],
        [0.48235, 'rgb(82,157,72)'],
        [0.48627, 'rgb(84,157,72)'],
        [0.4902, 'rgb(87,158,73)'],
        [0.49412, 'rgb(89,159,74)'],
        [0.49804, 'rgb(91,159,74)'],
        [0.50196, 'rgb(93,160,75)'],
        [0.50588, 'rgb(95,160,75)'],
        [0.5098, 'rgb(98,161,76)'],
        [0.51373, 'rgb(100,161,77)'],
        [0.51765, 'rgb(102,162,77)'],
        [0.52157, 'rgb(104,163,78)'],
        [0.52549, 'rgb(107,163,78)'],
        [0.52941, 'rgb(109,163,79)'],
        [0.53333, 'rgb(111,164,79)'],
        [0.53725, 'rgb(113,164,80)'],
        [0.54118, 'rgb(115,165,81)'],
        [0.5451, 'rgb(118,165,81)'],
        [0.54902, 'rgb(120,166,82)'],
        [0.55294, 'rgb(121,166,82)'],
        [0.55686, 'rgb(123,167,82)'],
        [0.56078, 'rgb(125,167,82)'],
        [0.56471, 'rgb(126,167,83)'],
        [0.56863, 'rgb(128,168,83)'],
        [0.57255, 'rgb(130,168,83)'],
        [0.57647, 'rgb(131,169,84)'],
        [0.58039, 'rgb(133,169,84)'],
        [0.58431, 'rgb(135,170,84)'],
        [0.58824, 'rgb(136,170,85)'],
        [0.59216, 'rgb(138,171,85)'],
        [0.59608, 'rgb(140,171,85)'],
        [0.6, 'rgb(141,171,86)'],
        [0.60392, 'rgb(143,172,86)'],
        [0.60784, 'rgb(145,172,86)'],
        [0.61176, 'rgb(146,173,87)'],
        [0.61569, 'rgb(148,173,87)'],
        [0.61961, 'rgb(150,174,87)'],
        [0.62353, 'rgb(151,174,88)'],
        [0.62745, 'rgb(153,174,88)'],
        [0.63137, 'rgb(154,175,88)'],
        [0.63529, 'rgb(156,175,88)'],
        [0.63922, 'rgb(158,176,89)'],
        [0.64314, 'rgb(159,176,89)'],
        [0.64706, 'rgb(161,177,89)'],
        [0.65098, 'rgb(163,177,90)'],
        [0.6549, 'rgb(164,178,90)'],
        [0.65882, 'rgb(166,178,90)'],
        [0.66275, 'rgb(168,178,91)'],
        [0.66667, 'rgb(169,179,91)'],
        [0.67059, 'rgb(171,179,91)'],
        [0.67451, 'rgb(173,180,92)'],
        [0.67843, 'rgb(174,180,92)'],
        [0.68235, 'rgb(176,181,92)'],
        [0.68627, 'rgb(178,181,93)'],
        [0.6902, 'rgb(179,181,93)'],
        [0.69412, 'rgb(181,182,93)'],
        [0.69804, 'rgb(182,182,94)'],
        [0.70196, 'rgb(183,181,94)'],
        [0.70588, 'rgb(183,181,94)'],
        [0.7098, 'rgb(184,180,95)'],
        [0.71373, 'rgb(184,179,95)'],
        [0.71765, 'rgb(185,178,95)'],
        [0.72157, 'rgb(185,177,95)'],
        [0.72549, 'rgb(185,176,96)'],
        [0.72941, 'rgb(186,175,96)'],
        [0.73333, 'rgb(186,175,96)'],
        [0.73725, 'rgb(187,174,97)'],
        [0.74118, 'rgb(187,173,97)'],
        [0.7451, 'rgb(188,172,97)'],
        [0.74902, 'rgb(188,171,98)'],
        [0.75294, 'rgb(188,170,98)'],
        [0.75686, 'rgb(189,169,98)'],
        [0.76078, 'rgb(189,169,99)'],
        [0.76471, 'rgb(190,168,99)'],
        [0.76863, 'rgb(190,167,99)'],
        [0.77255, 'rgb(190,166,100)'],
        [0.77647, 'rgb(191,165,100)'],
        [0.78039, 'rgb(191,164,100)'],
        [0.78431, 'rgb(192,163,101)'],
        [0.78824, 'rgb(192,163,103)'],
        [0.79216, 'rgb(193,163,105)'],
        [0.79608, 'rgb(194,163,108)'],
        [0.8, 'rgb(195,164,110)'],
        [0.80392, 'rgb(197,164,113)'],
        [0.80784, 'rgb(198,165,115)'],
        [0.81176, 'rgb(199,166,118)'],
        [0.81569, 'rgb(200,166,120)'],
        [0.81961, 'rgb(201,167,123)'],
        [0.82353, 'rgb(202,168,125)'],
        [0.82745, 'rgb(203,169,127)'],
        [0.83137, 'rgb(204,170,130)'],
        [0.83529, 'rgb(206,171,132)'],
        [0.83922, 'rgb(207,172,135)'],
        [0.84314, 'rgb(208,173,137)'],
        [0.84706, 'rgb(209,173,140)'],
        [0.85098, 'rgb(210,174,142)'],
        [0.8549, 'rgb(211,175,145)'],
        [0.85882, 'rgb(212,176,147)'],
        [0.86275, 'rgb(213,177,150)'],
        [0.86667, 'rgb(214,178,152)'],
        [0.87059, 'rgb(216,179,154)'],
        [0.87451, 'rgb(217,181,157)'],
        [0.87843, 'rgb(218,182,159)'],
        [0.88235, 'rgb(219,183,162)'],
        [0.88627, 'rgb(220,185,164)'],
        [0.8902, 'rgb(221,186,167)'],
        [0.89412, 'rgb(222,188,169)'],
        [0.89804, 'rgb(223,189,172)'],
        [0.90196, 'rgb(225,191,175)'],
        [0.90588, 'rgb(226,193,178)'],
        [0.9098, 'rgb(227,195,181)'],
        [0.91373, 'rgb(228,197,184)'],
        [0.91765, 'rgb(229,199,187)'],
        [0.92157, 'rgb(230,201,190)'],
        [0.92549, 'rgb(231,203,193)'],
        [0.92941, 'rgb(232,205,196)'],
        [0.93333, 'rgb(233,207,199)'],
        [0.93725, 'rgb(235,209,202)'],
        [0.94118, 'rgb(236,211,205)'],
        [0.9451, 'rgb(237,213,208)'],
        [0.94902, 'rgb(238,215,211)'],
        [0.95294, 'rgb(239,217,214)'],
        [0.95686, 'rgb(240,220,217)'],
        [0.96078, 'rgb(241,222,220)'],
        [0.96471, 'rgb(242,224,223)'],
        [0.96863, 'rgb(244,227,226)'],
        [0.97255, 'rgb(245,230,229)'],
        [0.97647, 'rgb(246,233,232)'],
        [0.98039, 'rgb(247,236,235)'],
        [0.98431, 'rgb(248,239,238)'],
        [0.98824, 'rgb(249,242,241)'],
        [0.99216, 'rgb(250,245,244)'],
        [0.99608, 'rgb(251,248,247)'],
        [1.0, 'rgb(253,250,250)'],
    ],
    'gist_gray': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(1,1,1)'],
        [0.00784, 'rgb(2,2,2)'],
        [0.01176, 'rgb(3,3,3)'],
        [0.01569, 'rgb(4,4,4)'],
        [0.01961, 'rgb(5,5,5)'],
        [0.02353, 'rgb(6,6,6)'],
        [0.02745, 'rgb(7,7,7)'],
        [0.03137, 'rgb(8,8,8)'],
        [0.03529, 'rgb(9,9,9)'],
        [0.03922, 'rgb(10,10,10)'],
        [0.04314, 'rgb(11,11,11)'],
        [0.04706, 'rgb(12,12,12)'],
        [0.05098, 'rgb(13,13,13)'],
        [0.0549, 'rgb(14,14,14)'],
        [0.05882, 'rgb(15,15,15)'],
        [0.06275, 'rgb(16,16,16)'],
        [0.06667, 'rgb(17,17,17)'],
        [0.07059, 'rgb(18,18,18)'],
        [0.07451, 'rgb(19,19,19)'],
        [0.07843, 'rgb(20,20,20)'],
        [0.08235, 'rgb(21,21,21)'],
        [0.08627, 'rgb(22,22,22)'],
        [0.0902, 'rgb(23,23,23)'],
        [0.09412, 'rgb(24,24,24)'],
        [0.09804, 'rgb(25,25,25)'],
        [0.10196, 'rgb(26,26,26)'],
        [0.10588, 'rgb(27,27,27)'],
        [0.1098, 'rgb(28,28,28)'],
        [0.11373, 'rgb(29,29,29)'],
        [0.11765, 'rgb(30,30,30)'],
        [0.12157, 'rgb(31,31,31)'],
        [0.12549, 'rgb(32,32,32)'],
        [0.12941, 'rgb(32,32,32)'],
        [0.13333, 'rgb(34,34,34)'],
        [0.13725, 'rgb(35,35,35)'],
        [0.14118, 'rgb(36,36,36)'],
        [0.1451, 'rgb(36,36,36)'],
        [0.14902, 'rgb(38,38,38)'],
        [0.15294, 'rgb(39,39,39)'],
        [0.15686, 'rgb(40,40,40)'],
        [0.16078, 'rgb(40,40,40)'],
        [0.16471, 'rgb(42,42,42)'],
        [0.16863, 'rgb(43,43,43)'],
        [0.17255, 'rgb(44,44,44)'],
        [0.17647, 'rgb(44,44,44)'],
        [0.18039, 'rgb(46,46,46)'],
        [0.18431, 'rgb(47,47,47)'],
        [0.18824, 'rgb(48,48,48)'],
        [0.19216, 'rgb(48,48,48)'],
        [0.19608, 'rgb(50,50,50)'],
        [0.2, 'rgb(51,51,51)'],
        [0.20392, 'rgb(52,52,52)'],
        [0.20784, 'rgb(52,52,52)'],
        [0.21176, 'rgb(54,54,54)'],
        [0.21569, 'rgb(55,55,55)'],
        [0.21961, 'rgb(56,56,56)'],
        [0.22353, 'rgb(56,56,56)'],
        [0.22745, 'rgb(58,58,58)'],
        [0.23137, 'rgb(59,59,59)'],
        [0.23529, 'rgb(60,60,60)'],
        [0.23922, 'rgb(60,60,60)'],
        [0.24314, 'rgb(62,62,62)'],
        [0.24706, 'rgb(63,63,63)'],
        [0.25098, 'rgb(64,64,64)'],
        [0.2549, 'rgb(65,65,65)'],
        [0.25882, 'rgb(65,65,65)'],
        [0.26275, 'rgb(67,67,67)'],
        [0.26667, 'rgb(68,68,68)'],
        [0.27059, 'rgb(69,69,69)'],
        [0.27451, 'rgb(70,70,70)'],
        [0.27843, 'rgb(71,71,71)'],
        [0.28235, 'rgb(72,72,72)'],
        [0.28627, 'rgb(73,73,73)'],
        [0.2902, 'rgb(73,73,73)'],
        [0.29412, 'rgb(75,75,75)'],
        [0.29804, 'rgb(76,76,76)'],
        [0.30196, 'rgb(77,77,77)'],
        [0.30588, 'rgb(78,78,78)'],
        [0.3098, 'rgb(79,79,79)'],
        [0.31373, 'rgb(80,80,80)'],
        [0.31765, 'rgb(81,81,81)'],
        [0.32157, 'rgb(81,81,81)'],
        [0.32549, 'rgb(83,83,83)'],
        [0.32941, 'rgb(84,84,84)'],
        [0.33333, 'rgb(85,85,85)'],
        [0.33725, 'rgb(86,86,86)'],
        [0.34118, 'rgb(87,87,87)'],
        [0.3451, 'rgb(88,88,88)'],
        [0.34902, 'rgb(89,89,89)'],
        [0.35294, 'rgb(89,89,89)'],
        [0.35686, 'rgb(91,91,91)'],
        [0.36078, 'rgb(92,92,92)'],
        [0.36471, 'rgb(93,93,93)'],
        [0.36863, 'rgb(94,94,94)'],
        [0.37255, 'rgb(95,95,95)'],
        [0.37647, 'rgb(96,96,96)'],
        [0.38039, 'rgb(97,97,97)'],
        [0.38431, 'rgb(97,97,97)'],
        [0.38824, 'rgb(99,99,99)'],
        [0.39216, 'rgb(100,100,100)'],
        [0.39608, 'rgb(101,101,101)'],
        [0.4, 'rgb(102,102,102)'],
        [0.40392, 'rgb(103,103,103)'],
        [0.40784, 'rgb(104,104,104)'],
        [0.41176, 'rgb(105,105,105)'],
        [0.41569, 'rgb(105,105,105)'],
        [0.41961, 'rgb(107,107,107)'],
        [0.42353, 'rgb(108,108,108)'],
        [0.42745, 'rgb(109,109,109)'],
        [0.43137, 'rgb(110,110,110)'],
        [0.43529, 'rgb(111,111,111)'],
        [0.43922, 'rgb(112,112,112)'],
        [0.44314, 'rgb(113,113,113)'],
        [0.44706, 'rgb(113,113,113)'],
        [0.45098, 'rgb(115,115,115)'],
        [0.4549, 'rgb(116,116,116)'],
        [0.45882, 'rgb(117,117,117)'],
        [0.46275, 'rgb(118,118,118)'],
        [0.46667, 'rgb(119,119,119)'],
        [0.47059, 'rgb(120,120,120)'],
        [0.47451, 'rgb(121,121,121)'],
        [0.47843, 'rgb(121,121,121)'],
        [0.48235, 'rgb(123,123,123)'],
        [0.48627, 'rgb(124,124,124)'],
        [0.4902, 'rgb(125,125,125)'],
        [0.49412, 'rgb(126,126,126)'],
        [0.49804, 'rgb(127,127,127)'],
        [0.50196, 'rgb(128,128,128)'],
        [0.50588, 'rgb(129,129,129)'],
        [0.5098, 'rgb(130,130,130)'],
        [0.51373, 'rgb(131,131,131)'],
        [0.51765, 'rgb(131,131,131)'],
        [0.52157, 'rgb(133,133,133)'],
        [0.52549, 'rgb(134,134,134)'],
        [0.52941, 'rgb(135,135,135)'],
        [0.53333, 'rgb(136,136,136)'],
        [0.53725, 'rgb(137,137,137)'],
        [0.54118, 'rgb(138,138,138)'],
        [0.5451, 'rgb(139,139,139)'],
        [0.54902, 'rgb(140,140,140)'],
        [0.55294, 'rgb(141,141,141)'],
        [0.55686, 'rgb(142,142,142)'],
        [0.56078, 'rgb(143,143,143)'],
        [0.56471, 'rgb(144,144,144)'],
        [0.56863, 'rgb(145,145,145)'],
        [0.57255, 'rgb(146,146,146)'],
        [0.57647, 'rgb(147,147,147)'],
        [0.58039, 'rgb(147,147,147)'],
        [0.58431, 'rgb(149,149,149)'],
        [0.58824, 'rgb(150,150,150)'],
        [0.59216, 'rgb(151,151,151)'],
        [0.59608, 'rgb(152,152,152)'],
        [0.6, 'rgb(153,153,153)'],
        [0.60392, 'rgb(154,154,154)'],
        [0.60784, 'rgb(155,155,155)'],
        [0.61176, 'rgb(156,156,156)'],
        [0.61569, 'rgb(157,157,157)'],
        [0.61961, 'rgb(158,158,158)'],
        [0.62353, 'rgb(159,159,159)'],
        [0.62745, 'rgb(160,160,160)'],
        [0.63137, 'rgb(161,161,161)'],
        [0.63529, 'rgb(162,162,162)'],
        [0.63922, 'rgb(163,163,163)'],
        [0.64314, 'rgb(163,163,163)'],
        [0.64706, 'rgb(165,165,165)'],
        [0.65098, 'rgb(166,166,166)'],
        [0.6549, 'rgb(167,167,167)'],
        [0.65882, 'rgb(168,168,168)'],
        [0.66275, 'rgb(169,169,169)'],
        [0.66667, 'rgb(170,170,170)'],
        [0.67059, 'rgb(171,171,171)'],
        [0.67451, 'rgb(172,172,172)'],
        [0.67843, 'rgb(173,173,173)'],
        [0.68235, 'rgb(174,174,174)'],
        [0.68627, 'rgb(175,175,175)'],
        [0.6902, 'rgb(176,176,176)'],
        [0.69412, 'rgb(177,177,177)'],
        [0.69804, 'rgb(178,178,178)'],
        [0.70196, 'rgb(179,179,179)'],
        [0.70588, 'rgb(179,179,179)'],
        [0.7098, 'rgb(181,181,181)'],
        [0.71373, 'rgb(182,182,182)'],
        [0.71765, 'rgb(183,183,183)'],
        [0.72157, 'rgb(184,184,184)'],
        [0.72549, 'rgb(185,185,185)'],
        [0.72941, 'rgb(186,186,186)'],
        [0.73333, 'rgb(187,187,187)'],
        [0.73725, 'rgb(188,188,188)'],
        [0.74118, 'rgb(189,189,189)'],
        [0.7451, 'rgb(190,190,190)'],
        [0.74902, 'rgb(191,191,191)'],
        [0.75294, 'rgb(192,192,192)'],
        [0.75686, 'rgb(193,193,193)'],
        [0.76078, 'rgb(194,194,194)'],
        [0.76471, 'rgb(195,195,195)'],
        [0.76863, 'rgb(195,195,195)'],
        [0.77255, 'rgb(197,197,197)'],
        [0.77647, 'rgb(198,198,198)'],
        [0.78039, 'rgb(199,199,199)'],
        [0.78431, 'rgb(200,200,200)'],
        [0.78824, 'rgb(201,201,201)'],
        [0.79216, 'rgb(202,202,202)'],
        [0.79608, 'rgb(203,203,203)'],
        [0.8, 'rgb(204,204,204)'],
        [0.80392, 'rgb(205,205,205)'],
        [0.80784, 'rgb(206,206,206)'],
        [0.81176, 'rgb(207,207,207)'],
        [0.81569, 'rgb(208,208,208)'],
        [0.81961, 'rgb(209,209,209)'],
        [0.82353, 'rgb(210,210,210)'],
        [0.82745, 'rgb(211,211,211)'],
        [0.83137, 'rgb(211,211,211)'],
        [0.83529, 'rgb(213,213,213)'],
        [0.83922, 'rgb(214,214,214)'],
        [0.84314, 'rgb(215,215,215)'],
        [0.84706, 'rgb(216,216,216)'],
        [0.85098, 'rgb(217,217,217)'],
        [0.8549, 'rgb(218,218,218)'],
        [0.85882, 'rgb(219,219,219)'],
        [0.86275, 'rgb(220,220,220)'],
        [0.86667, 'rgb(221,221,221)'],
        [0.87059, 'rgb(222,222,222)'],
        [0.87451, 'rgb(223,223,223)'],
        [0.87843, 'rgb(224,224,224)'],
        [0.88235, 'rgb(225,225,225)'],
        [0.88627, 'rgb(226,226,226)'],
        [0.8902, 'rgb(227,227,227)'],
        [0.89412, 'rgb(227,227,227)'],
        [0.89804, 'rgb(229,229,229)'],
        [0.90196, 'rgb(230,230,230)'],
        [0.90588, 'rgb(231,231,231)'],
        [0.9098, 'rgb(232,232,232)'],
        [0.91373, 'rgb(233,233,233)'],
        [0.91765, 'rgb(234,234,234)'],
        [0.92157, 'rgb(235,235,235)'],
        [0.92549, 'rgb(236,236,236)'],
        [0.92941, 'rgb(237,237,237)'],
        [0.93333, 'rgb(238,238,238)'],
        [0.93725, 'rgb(239,239,239)'],
        [0.94118, 'rgb(240,240,240)'],
        [0.9451, 'rgb(241,241,241)'],
        [0.94902, 'rgb(242,242,242)'],
        [0.95294, 'rgb(243,243,243)'],
        [0.95686, 'rgb(243,243,243)'],
        [0.96078, 'rgb(245,245,245)'],
        [0.96471, 'rgb(246,246,246)'],
        [0.96863, 'rgb(247,247,247)'],
        [0.97255, 'rgb(248,248,248)'],
        [0.97647, 'rgb(249,249,249)'],
        [0.98039, 'rgb(250,250,250)'],
        [0.98431, 'rgb(251,251,251)'],
        [0.98824, 'rgb(252,252,252)'],
        [0.99216, 'rgb(253,253,253)'],
        [0.99608, 'rgb(254,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'gist_heat': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(1,0,0)'],
        [0.00784, 'rgb(3,0,0)'],
        [0.01176, 'rgb(4,0,0)'],
        [0.01569, 'rgb(6,0,0)'],
        [0.01961, 'rgb(7,0,0)'],
        [0.02353, 'rgb(9,0,0)'],
        [0.02745, 'rgb(10,0,0)'],
        [0.03137, 'rgb(12,0,0)'],
        [0.03529, 'rgb(13,0,0)'],
        [0.03922, 'rgb(15,0,0)'],
        [0.04314, 'rgb(16,0,0)'],
        [0.04706, 'rgb(18,0,0)'],
        [0.05098, 'rgb(19,0,0)'],
        [0.0549, 'rgb(21,0,0)'],
        [0.05882, 'rgb(22,0,0)'],
        [0.06275, 'rgb(24,0,0)'],
        [0.06667, 'rgb(25,0,0)'],
        [0.07059, 'rgb(27,0,0)'],
        [0.07451, 'rgb(28,0,0)'],
        [0.07843, 'rgb(30,0,0)'],
        [0.08235, 'rgb(31,0,0)'],
        [0.08627, 'rgb(32,0,0)'],
        [0.0902, 'rgb(34,0,0)'],
        [0.09412, 'rgb(36,0,0)'],
        [0.09804, 'rgb(37,0,0)'],
        [0.10196, 'rgb(39,0,0)'],
        [0.10588, 'rgb(40,0,0)'],
        [0.1098, 'rgb(42,0,0)'],
        [0.11373, 'rgb(43,0,0)'],
        [0.11765, 'rgb(44,0,0)'],
        [0.12157, 'rgb(46,0,0)'],
        [0.12549, 'rgb(48,0,0)'],
        [0.12941, 'rgb(49,0,0)'],
        [0.13333, 'rgb(51,0,0)'],
        [0.13725, 'rgb(52,0,0)'],
        [0.14118, 'rgb(54,0,0)'],
        [0.1451, 'rgb(55,0,0)'],
        [0.14902, 'rgb(56,0,0)'],
        [0.15294, 'rgb(58,0,0)'],
        [0.15686, 'rgb(60,0,0)'],
        [0.16078, 'rgb(61,0,0)'],
        [0.16471, 'rgb(63,0,0)'],
        [0.16863, 'rgb(64,0,0)'],
        [0.17255, 'rgb(65,0,0)'],
        [0.17647, 'rgb(67,0,0)'],
        [0.18039, 'rgb(69,0,0)'],
        [0.18431, 'rgb(70,0,0)'],
        [0.18824, 'rgb(72,0,0)'],
        [0.19216, 'rgb(73,0,0)'],
        [0.19608, 'rgb(75,0,0)'],
        [0.2, 'rgb(76,0,0)'],
        [0.20392, 'rgb(78,0,0)'],
        [0.20784, 'rgb(79,0,0)'],
        [0.21176, 'rgb(81,0,0)'],
        [0.21569, 'rgb(82,0,0)'],
        [0.21961, 'rgb(84,0,0)'],
        [0.22353, 'rgb(85,0,0)'],
        [0.22745, 'rgb(87,0,0)'],
        [0.23137, 'rgb(88,0,0)'],
        [0.23529, 'rgb(89,0,0)'],
        [0.23922, 'rgb(91,0,0)'],
        [0.24314, 'rgb(93,0,0)'],
        [0.24706, 'rgb(94,0,0)'],
        [0.25098, 'rgb(96,0,0)'],
        [0.2549, 'rgb(97,0,0)'],
        [0.25882, 'rgb(98,0,0)'],
        [0.26275, 'rgb(100,0,0)'],
        [0.26667, 'rgb(102,0,0)'],
        [0.27059, 'rgb(103,0,0)'],
        [0.27451, 'rgb(105,0,0)'],
        [0.27843, 'rgb(106,0,0)'],
        [0.28235, 'rgb(108,0,0)'],
        [0.28627, 'rgb(109,0,0)'],
        [0.2902, 'rgb(110,0,0)'],
        [0.29412, 'rgb(112,0,0)'],
        [0.29804, 'rgb(113,0,0)'],
        [0.30196, 'rgb(115,0,0)'],
        [0.30588, 'rgb(117,0,0)'],
        [0.3098, 'rgb(118,0,0)'],
        [0.31373, 'rgb(120,0,0)'],
        [0.31765, 'rgb(121,0,0)'],
        [0.32157, 'rgb(122,0,0)'],
        [0.32549, 'rgb(124,0,0)'],
        [0.32941, 'rgb(126,0,0)'],
        [0.33333, 'rgb(127,0,0)'],
        [0.33725, 'rgb(129,0,0)'],
        [0.34118, 'rgb(130,0,0)'],
        [0.3451, 'rgb(131,0,0)'],
        [0.34902, 'rgb(133,0,0)'],
        [0.35294, 'rgb(134,0,0)'],
        [0.35686, 'rgb(136,0,0)'],
        [0.36078, 'rgb(138,0,0)'],
        [0.36471, 'rgb(139,0,0)'],
        [0.36863, 'rgb(141,0,0)'],
        [0.37255, 'rgb(142,0,0)'],
        [0.37647, 'rgb(144,0,0)'],
        [0.38039, 'rgb(145,0,0)'],
        [0.38431, 'rgb(147,0,0)'],
        [0.38824, 'rgb(148,0,0)'],
        [0.39216, 'rgb(150,0,0)'],
        [0.39608, 'rgb(151,0,0)'],
        [0.4, 'rgb(153,0,0)'],
        [0.40392, 'rgb(154,0,0)'],
        [0.40784, 'rgb(156,0,0)'],
        [0.41176, 'rgb(157,0,0)'],
        [0.41569, 'rgb(159,0,0)'],
        [0.41961, 'rgb(160,0,0)'],
        [0.42353, 'rgb(162,0,0)'],
        [0.42745, 'rgb(163,0,0)'],
        [0.43137, 'rgb(165,0,0)'],
        [0.43529, 'rgb(166,0,0)'],
        [0.43922, 'rgb(168,0,0)'],
        [0.44314, 'rgb(169,0,0)'],
        [0.44706, 'rgb(171,0,0)'],
        [0.45098, 'rgb(172,0,0)'],
        [0.4549, 'rgb(174,0,0)'],
        [0.45882, 'rgb(175,0,0)'],
        [0.46275, 'rgb(177,0,0)'],
        [0.46667, 'rgb(178,0,0)'],
        [0.47059, 'rgb(179,0,0)'],
        [0.47451, 'rgb(181,0,0)'],
        [0.47843, 'rgb(182,0,0)'],
        [0.48235, 'rgb(184,0,0)'],
        [0.48627, 'rgb(186,0,0)'],
        [0.4902, 'rgb(187,0,0)'],
        [0.49412, 'rgb(189,0,0)'],
        [0.49804, 'rgb(190,0,0)'],
        [0.50196, 'rgb(192,0,0)'],
        [0.50588, 'rgb(193,2,0)'],
        [0.5098, 'rgb(195,4,0)'],
        [0.51373, 'rgb(196,6,0)'],
        [0.51765, 'rgb(197,8,0)'],
        [0.52157, 'rgb(199,11,0)'],
        [0.52549, 'rgb(201,13,0)'],
        [0.52941, 'rgb(202,15,0)'],
        [0.53333, 'rgb(204,16,0)'],
        [0.53725, 'rgb(205,18,0)'],
        [0.54118, 'rgb(207,20,0)'],
        [0.5451, 'rgb(208,22,0)'],
        [0.54902, 'rgb(210,25,0)'],
        [0.55294, 'rgb(211,27,0)'],
        [0.55686, 'rgb(213,29,0)'],
        [0.56078, 'rgb(214,31,0)'],
        [0.56471, 'rgb(216,32,0)'],
        [0.56863, 'rgb(217,34,0)'],
        [0.57255, 'rgb(219,36,0)'],
        [0.57647, 'rgb(220,38,0)'],
        [0.58039, 'rgb(221,40,0)'],
        [0.58431, 'rgb(223,43,0)'],
        [0.58824, 'rgb(225,45,0)'],
        [0.59216, 'rgb(226,47,0)'],
        [0.59608, 'rgb(227,48,0)'],
        [0.6, 'rgb(229,50,0)'],
        [0.60392, 'rgb(230,52,0)'],
        [0.60784, 'rgb(232,54,0)'],
        [0.61176, 'rgb(234,57,0)'],
        [0.61569, 'rgb(235,59,0)'],
        [0.61961, 'rgb(237,61,0)'],
        [0.62353, 'rgb(238,63,0)'],
        [0.62745, 'rgb(240,65,0)'],
        [0.63137, 'rgb(241,66,0)'],
        [0.63529, 'rgb(243,68,0)'],
        [0.63922, 'rgb(244,70,0)'],
        [0.64314, 'rgb(245,72,0)'],
        [0.64706, 'rgb(247,75,0)'],
        [0.65098, 'rgb(249,77,0)'],
        [0.6549, 'rgb(250,79,0)'],
        [0.65882, 'rgb(252,81,0)'],
        [0.66275, 'rgb(253,82,0)'],
        [0.66667, 'rgb(255,84,0)'],
        [0.67059, 'rgb(255,86,0)'],
        [0.67451, 'rgb(255,89,0)'],
        [0.67843, 'rgb(255,91,0)'],
        [0.68235, 'rgb(255,93,0)'],
        [0.68627, 'rgb(255,95,0)'],
        [0.6902, 'rgb(255,97,0)'],
        [0.69412, 'rgb(255,98,0)'],
        [0.69804, 'rgb(255,100,0)'],
        [0.70196, 'rgb(255,102,0)'],
        [0.70588, 'rgb(255,104,0)'],
        [0.7098, 'rgb(255,107,0)'],
        [0.71373, 'rgb(255,109,0)'],
        [0.71765, 'rgb(255,111,0)'],
        [0.72157, 'rgb(255,113,0)'],
        [0.72549, 'rgb(255,114,0)'],
        [0.72941, 'rgb(255,116,0)'],
        [0.73333, 'rgb(255,118,0)'],
        [0.73725, 'rgb(255,121,0)'],
        [0.74118, 'rgb(255,123,0)'],
        [0.7451, 'rgb(255,125,0)'],
        [0.74902, 'rgb(255,127,0)'],
        [0.75294, 'rgb(255,129,2)'],
        [0.75686, 'rgb(255,131,6)'],
        [0.76078, 'rgb(255,132,10)'],
        [0.76471, 'rgb(255,134,14)'],
        [0.76863, 'rgb(255,136,18)'],
        [0.77255, 'rgb(255,139,23)'],
        [0.77647, 'rgb(255,141,27)'],
        [0.78039, 'rgb(255,143,31)'],
        [0.78431, 'rgb(255,145,34)'],
        [0.78824, 'rgb(255,147,38)'],
        [0.79216, 'rgb(255,148,42)'],
        [0.79608, 'rgb(255,150,46)'],
        [0.8, 'rgb(255,153,51)'],
        [0.80392, 'rgb(255,155,55)'],
        [0.80784, 'rgb(255,157,59)'],
        [0.81176, 'rgb(255,159,63)'],
        [0.81569, 'rgb(255,161,66)'],
        [0.81961, 'rgb(255,163,70)'],
        [0.82353, 'rgb(255,164,74)'],
        [0.82745, 'rgb(255,166,78)'],
        [0.83137, 'rgb(255,168,82)'],
        [0.83529, 'rgb(255,171,87)'],
        [0.83922, 'rgb(255,173,91)'],
        [0.84314, 'rgb(255,175,95)'],
        [0.84706, 'rgb(255,177,98)'],
        [0.85098, 'rgb(255,179,102)'],
        [0.8549, 'rgb(255,180,106)'],
        [0.85882, 'rgb(255,182,110)'],
        [0.86275, 'rgb(255,185,115)'],
        [0.86667, 'rgb(255,187,119)'],
        [0.87059, 'rgb(255,189,123)'],
        [0.87451, 'rgb(255,191,127)'],
        [0.87843, 'rgb(255,193,131)'],
        [0.88235, 'rgb(255,195,134)'],
        [0.88627, 'rgb(255,196,138)'],
        [0.8902, 'rgb(255,198,142)'],
        [0.89412, 'rgb(255,200,146)'],
        [0.89804, 'rgb(255,203,151)'],
        [0.90196, 'rgb(255,205,155)'],
        [0.90588, 'rgb(255,207,159)'],
        [0.9098, 'rgb(255,209,163)'],
        [0.91373, 'rgb(255,211,166)'],
        [0.91765, 'rgb(255,212,170)'],
        [0.92157, 'rgb(255,214,174)'],
        [0.92549, 'rgb(255,217,179)'],
        [0.92941, 'rgb(255,219,183)'],
        [0.93333, 'rgb(255,221,187)'],
        [0.93725, 'rgb(255,223,191)'],
        [0.94118, 'rgb(255,225,195)'],
        [0.9451, 'rgb(255,227,198)'],
        [0.94902, 'rgb(255,228,202)'],
        [0.95294, 'rgb(255,230,206)'],
        [0.95686, 'rgb(255,232,210)'],
        [0.96078, 'rgb(255,235,215)'],
        [0.96471, 'rgb(255,237,219)'],
        [0.96863, 'rgb(255,239,223)'],
        [0.97255, 'rgb(255,241,227)'],
        [0.97647, 'rgb(255,243,230)'],
        [0.98039, 'rgb(255,244,234)'],
        [0.98431, 'rgb(255,246,238)'],
        [0.98824, 'rgb(255,249,243)'],
        [0.99216, 'rgb(255,251,247)'],
        [0.99608, 'rgb(255,253,251)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'gist_ncar': [
        [0.0, 'rgb(0,0,128)'],
        [0.00392, 'rgb(0,7,118)'],
        [0.00784, 'rgb(0,14,109)'],
        [0.01176, 'rgb(0,21,99)'],
        [0.01569, 'rgb(0,29,90)'],
        [0.01961, 'rgb(0,36,80)'],
        [0.02353, 'rgb(0,43,71)'],
        [0.02745, 'rgb(0,51,62)'],
        [0.03137, 'rgb(0,58,52)'],
        [0.03529, 'rgb(0,65,43)'],
        [0.03922, 'rgb(0,72,33)'],
        [0.04314, 'rgb(0,80,24)'],
        [0.04706, 'rgb(0,87,15)'],
        [0.05098, 'rgb(0,94,5)'],
        [0.0549, 'rgb(0,88,22)'],
        [0.05882, 'rgb(0,81,38)'],
        [0.06275, 'rgb(0,74,55)'],
        [0.06667, 'rgb(0,67,72)'],
        [0.07059, 'rgb(0,61,88)'],
        [0.07451, 'rgb(0,54,105)'],
        [0.07843, 'rgb(0,47,121)'],
        [0.08235, 'rgb(0,40,138)'],
        [0.08627, 'rgb(0,33,155)'],
        [0.0902, 'rgb(0,27,171)'],
        [0.09412, 'rgb(0,20,188)'],
        [0.09804, 'rgb(0,13,205)'],
        [0.10196, 'rgb(0,6,221)'],
        [0.10588, 'rgb(0,0,238)'],
        [0.1098, 'rgb(0,14,255)'],
        [0.11373, 'rgb(0,28,255)'],
        [0.11765, 'rgb(0,42,255)'],
        [0.12157, 'rgb(0,56,255)'],
        [0.12549, 'rgb(0,70,255)'],
        [0.12941, 'rgb(0,84,255)'],
        [0.13333, 'rgb(0,98,255)'],
        [0.13725, 'rgb(0,112,255)'],
        [0.14118, 'rgb(0,127,255)'],
        [0.1451, 'rgb(0,141,255)'],
        [0.14902, 'rgb(0,155,255)'],
        [0.15294, 'rgb(0,169,255)'],
        [0.15686, 'rgb(0,183,255)'],
        [0.16078, 'rgb(0,192,255)'],
        [0.16471, 'rgb(0,197,255)'],
        [0.16863, 'rgb(0,202,255)'],
        [0.17255, 'rgb(0,206,255)'],
        [0.17647, 'rgb(0,210,255)'],
        [0.18039, 'rgb(0,215,255)'],
        [0.18431, 'rgb(0,219,255)'],
        [0.18824, 'rgb(0,224,255)'],
        [0.19216, 'rgb(0,228,255)'],
        [0.19608, 'rgb(0,232,255)'],
        [0.2, 'rgb(0,237,255)'],
        [0.20392, 'rgb(0,241,254)'],
        [0.20784, 'rgb(0,246,248)'],
        [0.21176, 'rgb(0,250,241)'],
        [0.21569, 'rgb(0,254,235)'],
        [0.21961, 'rgb(0,254,228)'],
        [0.22353, 'rgb(0,254,222)'],
        [0.22745, 'rgb(0,253,215)'],
        [0.23137, 'rgb(0,253,209)'],
        [0.23529, 'rgb(0,252,202)'],
        [0.23922, 'rgb(0,252,195)'],
        [0.24314, 'rgb(0,251,189)'],
        [0.24706, 'rgb(0,251,182)'],
        [0.25098, 'rgb(0,250,176)'],
        [0.2549, 'rgb(0,250,169)'],
        [0.25882, 'rgb(0,250,163)'],
        [0.26275, 'rgb(0,250,156)'],
        [0.26667, 'rgb(0,250,146)'],
        [0.27059, 'rgb(0,250,135)'],
        [0.27451, 'rgb(0,250,125)'],
        [0.27843, 'rgb(0,250,114)'],
        [0.28235, 'rgb(0,251,104)'],
        [0.28627, 'rgb(0,251,93)'],
        [0.2902, 'rgb(0,252,83)'],
        [0.29412, 'rgb(0,252,73)'],
        [0.29804, 'rgb(0,252,62)'],
        [0.30196, 'rgb(0,253,52)'],
        [0.30588, 'rgb(0,253,41)'],
        [0.3098, 'rgb(0,254,31)'],
        [0.31373, 'rgb(6,254,20)'],
        [0.31765, 'rgb(12,254,10)'],
        [0.32157, 'rgb(19,251,0)'],
        [0.32549, 'rgb(25,247,0)'],
        [0.32941, 'rgb(31,243,0)'],
        [0.33333, 'rgb(38,239,0)'],
        [0.33725, 'rgb(44,236,0)'],
        [0.34118, 'rgb(50,232,0)'],
        [0.3451, 'rgb(57,228,0)'],
        [0.34902, 'rgb(63,224,0)'],
        [0.35294, 'rgb(70,221,0)'],
        [0.35686, 'rgb(76,217,0)'],
        [0.36078, 'rgb(82,213,0)'],
        [0.36471, 'rgb(89,209,0)'],
        [0.36863, 'rgb(95,206,0)'],
        [0.37255, 'rgb(101,209,0)'],
        [0.37647, 'rgb(103,212,0)'],
        [0.38039, 'rgb(105,215,0)'],
        [0.38431, 'rgb(107,219,0)'],
        [0.38824, 'rgb(109,222,0)'],
        [0.39216, 'rgb(111,225,0)'],
        [0.39608, 'rgb(113,228,0)'],
        [0.4, 'rgb(115,232,0)'],
        [0.40392, 'rgb(117,235,0)'],
        [0.40784, 'rgb(119,238,0)'],
        [0.41176, 'rgb(121,241,0)'],
        [0.41569, 'rgb(123,245,0)'],
        [0.41961, 'rgb(125,248,3)'],
        [0.42353, 'rgb(127,251,7)'],
        [0.42745, 'rgb(132,254,11)'],
        [0.43137, 'rgb(136,255,15)'],
        [0.43529, 'rgb(141,255,19)'],
        [0.43922, 'rgb(145,255,23)'],
        [0.44314, 'rgb(150,255,27)'],
        [0.44706, 'rgb(154,255,31)'],
        [0.45098, 'rgb(159,255,35)'],
        [0.4549, 'rgb(164,255,39)'],
        [0.45882, 'rgb(168,255,43)'],
        [0.46275, 'rgb(173,255,47)'],
        [0.46667, 'rgb(177,255,51)'],
        [0.47059, 'rgb(182,255,55)'],
        [0.47451, 'rgb(186,255,59)'],
        [0.47843, 'rgb(191,255,55)'],
        [0.48235, 'rgb(195,255,51)'],
        [0.48627, 'rgb(200,255,47)'],
        [0.4902, 'rgb(204,255,43)'],
        [0.49412, 'rgb(209,255,39)'],
        [0.49804, 'rgb(214,255,35)'],
        [0.50196, 'rgb(218,255,31)'],
        [0.50588, 'rgb(223,255,27)'],
        [0.5098, 'rgb(227,255,23)'],
        [0.51373, 'rgb(232,255,19)'],
        [0.51765, 'rgb(236,255,15)'],
        [0.52157, 'rgb(241,255,11)'],
        [0.52549, 'rgb(245,252,7)'],
        [0.52941, 'rgb(250,250,3)'],
        [0.53333, 'rgb(255,247,0)'],
        [0.53725, 'rgb(255,245,0)'],
        [0.54118, 'rgb(255,242,0)'],
        [0.5451, 'rgb(255,240,0)'],
        [0.54902, 'rgb(255,237,0)'],
        [0.55294, 'rgb(255,235,0)'],
        [0.55686, 'rgb(255,232,0)'],
        [0.56078, 'rgb(255,230,0)'],
        [0.56471, 'rgb(255,227,0)'],
        [0.56863, 'rgb(255,225,0)'],
        [0.57255, 'rgb(255,222,0)'],
        [0.57647, 'rgb(255,220,0)'],
        [0.58039, 'rgb(255,218,0)'],
        [0.58431, 'rgb(255,215,1)'],
        [0.58824, 'rgb(255,213,2)'],
        [0.59216, 'rgb(255,210,3)'],
        [0.59608, 'rgb(255,208,4)'],
        [0.6, 'rgb(255,205,5)'],
        [0.60392, 'rgb(255,203,6)'],
        [0.60784, 'rgb(255,200,7)'],
        [0.61176, 'rgb(255,198,8)'],
        [0.61569, 'rgb(255,195,9)'],
        [0.61961, 'rgb(255,193,10)'],
        [0.62353, 'rgb(255,190,11)'],
        [0.62745, 'rgb(255,188,12)'],
        [0.63137, 'rgb(255,185,13)'],
        [0.63529, 'rgb(255,177,13)'],
        [0.63922, 'rgb(255,169,12)'],
        [0.64314, 'rgb(255,161,11)'],
        [0.64706, 'rgb(255,153,10)'],
        [0.65098, 'rgb(255,145,9)'],
        [0.6549, 'rgb(255,136,8)'],
        [0.65882, 'rgb(255,128,7)'],
        [0.66275, 'rgb(255,120,6)'],
        [0.66667, 'rgb(255,112,5)'],
        [0.67059, 'rgb(255,104,4)'],
        [0.67451, 'rgb(255,95,3)'],
        [0.67843, 'rgb(255,87,2)'],
        [0.68235, 'rgb(255,79,1)'],
        [0.68627, 'rgb(255,71,0)'],
        [0.6902, 'rgb(255,66,0)'],
        [0.69412, 'rgb(255,61,0)'],
        [0.69804, 'rgb(255,57,0)'],
        [0.70196, 'rgb(255,52,0)'],
        [0.70588, 'rgb(255,47,0)'],
        [0.7098, 'rgb(255,42,0)'],
        [0.71373, 'rgb(255,38,0)'],
        [0.71765, 'rgb(255,33,0)'],
        [0.72157, 'rgb(255,28,0)'],
        [0.72549, 'rgb(255,23,0)'],
        [0.72941, 'rgb(255,19,0)'],
        [0.73333, 'rgb(255,14,0)'],
        [0.73725, 'rgb(255,9,0)'],
        [0.74118, 'rgb(255,4,17)'],
        [0.7451, 'rgb(255,0,35)'],
        [0.74902, 'rgb(255,0,53)'],
        [0.75294, 'rgb(255,0,70)'],
        [0.75686, 'rgb(255,0,88)'],
        [0.76078, 'rgb(255,0,106)'],
        [0.76471, 'rgb(255,0,123)'],
        [0.76863, 'rgb(255,0,141)'],
        [0.77255, 'rgb(255,0,159)'],
        [0.77647, 'rgb(255,0,177)'],
        [0.78039, 'rgb(255,0,194)'],
        [0.78431, 'rgb(255,0,212)'],
        [0.78824, 'rgb(255,0,230)'],
        [0.79216, 'rgb(255,0,248)'],
        [0.79608, 'rgb(248,3,251)'],
        [0.8, 'rgb(241,6,255)'],
        [0.80392, 'rgb(234,10,255)'],
        [0.80784, 'rgb(227,13,255)'],
        [0.81176, 'rgb(220,17,255)'],
        [0.81569, 'rgb(213,20,255)'],
        [0.81961, 'rgb(206,24,255)'],
        [0.82353, 'rgb(199,27,255)'],
        [0.82745, 'rgb(193,30,255)'],
        [0.83137, 'rgb(186,34,255)'],
        [0.83529, 'rgb(179,37,255)'],
        [0.83922, 'rgb(172,41,255)'],
        [0.84314, 'rgb(165,44,254)'],
        [0.84706, 'rgb(158,50,253)'],
        [0.85098, 'rgb(164,56,252)'],
        [0.8549, 'rgb(170,62,251)'],
        [0.85882, 'rgb(176,68,250)'],
        [0.86275, 'rgb(182,74,248)'],
        [0.86667, 'rgb(188,80,247)'],
        [0.87059, 'rgb(194,86,246)'],
        [0.87451, 'rgb(199,92,245)'],
        [0.87843, 'rgb(205,97,244)'],
        [0.88235, 'rgb(211,103,242)'],
        [0.88627, 'rgb(217,109,241)'],
        [0.8902, 'rgb(223,115,240)'],
        [0.89412, 'rgb(229,121,239)'],
        [0.89804, 'rgb(235,127,238)'],
        [0.90196, 'rgb(236,132,238)'],
        [0.90588, 'rgb(236,136,239)'],
        [0.9098, 'rgb(237,141,240)'],
        [0.91373, 'rgb(238,146,240)'],
        [0.91765, 'rgb(239,150,241)'],
        [0.92157, 'rgb(239,155,241)'],
        [0.92549, 'rgb(240,159,242)'],
        [0.92941, 'rgb(241,164,243)'],
        [0.93333, 'rgb(241,169,243)'],
        [0.93725, 'rgb(242,173,244)'],
        [0.94118, 'rgb(243,178,244)'],
        [0.9451, 'rgb(244,183,245)'],
        [0.94902, 'rgb(244,187,246)'],
        [0.95294, 'rgb(245,192,246)'],
        [0.95686, 'rgb(246,197,247)'],
        [0.96078, 'rgb(246,201,247)'],
        [0.96471, 'rgb(247,206,248)'],
        [0.96863, 'rgb(248,210,249)'],
        [0.97255, 'rgb(249,215,249)'],
        [0.97647, 'rgb(249,220,250)'],
        [0.98039, 'rgb(250,224,250)'],
        [0.98431, 'rgb(251,229,251)'],
        [0.98824, 'rgb(251,234,252)'],
        [0.99216, 'rgb(252,238,252)'],
        [0.99608, 'rgb(253,243,253)'],
        [1.0, 'rgb(254,247,254)'],
    ],
    'gist_rainbow': [
        [0.0, 'rgb(255,0,40)'],
        [0.00392, 'rgb(255,0,35)'],
        [0.00784, 'rgb(255,0,30)'],
        [0.01176, 'rgb(255,0,24)'],
        [0.01569, 'rgb(255,0,19)'],
        [0.01961, 'rgb(255,0,14)'],
        [0.02353, 'rgb(255,0,8)'],
        [0.02745, 'rgb(255,0,3)'],
        [0.03137, 'rgb(255,1,0)'],
        [0.03529, 'rgb(255,7,0)'],
        [0.03922, 'rgb(255,12,0)'],
        [0.04314, 'rgb(255,18,0)'],
        [0.04706, 'rgb(255,23,0)'],
        [0.05098, 'rgb(255,28,0)'],
        [0.0549, 'rgb(255,34,0)'],
        [0.05882, 'rgb(255,39,0)'],
        [0.06275, 'rgb(255,45,0)'],
        [0.06667, 'rgb(255,50,0)'],
        [0.07059, 'rgb(255,55,0)'],
        [0.07451, 'rgb(255,61,0)'],
        [0.07843, 'rgb(255,66,0)'],
        [0.08235, 'rgb(255,72,0)'],
        [0.08627, 'rgb(255,77,0)'],
        [0.0902, 'rgb(255,82,0)'],
        [0.09412, 'rgb(255,88,0)'],
        [0.09804, 'rgb(255,93,0)'],
        [0.10196, 'rgb(255,99,0)'],
        [0.10588, 'rgb(255,104,0)'],
        [0.1098, 'rgb(255,110,0)'],
        [0.11373, 'rgb(255,115,0)'],
        [0.11765, 'rgb(255,120,0)'],
        [0.12157, 'rgb(255,126,0)'],
        [0.12549, 'rgb(255,131,0)'],
        [0.12941, 'rgb(255,137,0)'],
        [0.13333, 'rgb(255,142,0)'],
        [0.13725, 'rgb(255,147,0)'],
        [0.14118, 'rgb(255,153,0)'],
        [0.1451, 'rgb(255,158,0)'],
        [0.14902, 'rgb(255,164,0)'],
        [0.15294, 'rgb(255,169,0)'],
        [0.15686, 'rgb(255,174,0)'],
        [0.16078, 'rgb(255,180,0)'],
        [0.16471, 'rgb(255,185,0)'],
        [0.16863, 'rgb(255,191,0)'],
        [0.17255, 'rgb(255,196,0)'],
        [0.17647, 'rgb(255,201,0)'],
        [0.18039, 'rgb(255,207,0)'],
        [0.18431, 'rgb(255,212,0)'],
        [0.18824, 'rgb(255,218,0)'],
        [0.19216, 'rgb(255,223,0)'],
        [0.19608, 'rgb(255,228,0)'],
        [0.2, 'rgb(255,234,0)'],
        [0.20392, 'rgb(255,239,0)'],
        [0.20784, 'rgb(255,245,0)'],
        [0.21176, 'rgb(255,250,0)'],
        [0.21569, 'rgb(254,255,0)'],
        [0.21961, 'rgb(248,255,0)'],
        [0.22353, 'rgb(243,255,0)'],
        [0.22745, 'rgb(237,255,0)'],
        [0.23137, 'rgb(232,255,0)'],
        [0.23529, 'rgb(227,255,0)'],
        [0.23922, 'rgb(221,255,0)'],
        [0.24314, 'rgb(216,255,0)'],
        [0.24706, 'rgb(210,255,0)'],
        [0.25098, 'rgb(205,255,0)'],
        [0.2549, 'rgb(199,255,0)'],
        [0.25882, 'rgb(194,255,0)'],
        [0.26275, 'rgb(189,255,0)'],
        [0.26667, 'rgb(183,255,0)'],
        [0.27059, 'rgb(178,255,0)'],
        [0.27451, 'rgb(172,255,0)'],
        [0.27843, 'rgb(167,255,0)'],
        [0.28235, 'rgb(162,255,0)'],
        [0.28627, 'rgb(156,255,0)'],
        [0.2902, 'rgb(151,255,0)'],
        [0.29412, 'rgb(145,255,0)'],
        [0.29804, 'rgb(140,255,0)'],
        [0.30196, 'rgb(135,255,0)'],
        [0.30588, 'rgb(129,255,0)'],
        [0.3098, 'rgb(124,255,0)'],
        [0.31373, 'rgb(118,255,0)'],
        [0.31765, 'rgb(113,255,0)'],
        [0.32157, 'rgb(108,255,0)'],
        [0.32549, 'rgb(102,255,0)'],
        [0.32941, 'rgb(97,255,0)'],
        [0.33333, 'rgb(91,255,0)'],
        [0.33725, 'rgb(86,255,0)'],
        [0.34118, 'rgb(81,255,0)'],
        [0.3451, 'rgb(75,255,0)'],
        [0.34902, 'rgb(70,255,0)'],
        [0.35294, 'rgb(64,255,0)'],
        [0.35686, 'rgb(59,255,0)'],
        [0.36078, 'rgb(54,255,0)'],
        [0.36471, 'rgb(48,255,0)'],
        [0.36863, 'rgb(43,255,0)'],
        [0.37255, 'rgb(37,255,0)'],
        [0.37647, 'rgb(32,255,0)'],
        [0.38039, 'rgb(27,255,0)'],
        [0.38431, 'rgb(21,255,0)'],
        [0.38824, 'rgb(16,255,0)'],
        [0.39216, 'rgb(10,255,0)'],
        [0.39608, 'rgb(5,255,0)'],
        [0.4, 'rgb(0,255,0)'],
        [0.40392, 'rgb(0,255,5)'],
        [0.40784, 'rgb(0,255,10)'],
        [0.41176, 'rgb(0,255,16)'],
        [0.41569, 'rgb(0,255,21)'],
        [0.41961, 'rgb(0,255,26)'],
        [0.42353, 'rgb(0,255,32)'],
        [0.42745, 'rgb(0,255,37)'],
        [0.43137, 'rgb(0,255,43)'],
        [0.43529, 'rgb(0,255,48)'],
        [0.43922, 'rgb(0,255,53)'],
        [0.44314, 'rgb(0,255,59)'],
        [0.44706, 'rgb(0,255,64)'],
        [0.45098, 'rgb(0,255,69)'],
        [0.4549, 'rgb(0,255,75)'],
        [0.45882, 'rgb(0,255,80)'],
        [0.46275, 'rgb(0,255,86)'],
        [0.46667, 'rgb(0,255,91)'],
        [0.47059, 'rgb(0,255,96)'],
        [0.47451, 'rgb(0,255,102)'],
        [0.47843, 'rgb(0,255,107)'],
        [0.48235, 'rgb(0,255,112)'],
        [0.48627, 'rgb(0,255,118)'],
        [0.4902, 'rgb(0,255,123)'],
        [0.49412, 'rgb(0,255,129)'],
        [0.49804, 'rgb(0,255,134)'],
        [0.50196, 'rgb(0,255,139)'],
        [0.50588, 'rgb(0,255,145)'],
        [0.5098, 'rgb(0,255,150)'],
        [0.51373, 'rgb(0,255,155)'],
        [0.51765, 'rgb(0,255,161)'],
        [0.52157, 'rgb(0,255,166)'],
        [0.52549, 'rgb(0,255,172)'],
        [0.52941, 'rgb(0,255,177)'],
        [0.53333, 'rgb(0,255,182)'],
        [0.53725, 'rgb(0,255,188)'],
        [0.54118, 'rgb(0,255,193)'],
        [0.5451, 'rgb(0,255,198)'],
        [0.54902, 'rgb(0,255,204)'],
        [0.55294, 'rgb(0,255,209)'],
        [0.55686, 'rgb(0,255,215)'],
        [0.56078, 'rgb(0,255,220)'],
        [0.56471, 'rgb(0,255,225)'],
        [0.56863, 'rgb(0,255,231)'],
        [0.57255, 'rgb(0,255,236)'],
        [0.57647, 'rgb(0,255,241)'],
        [0.58039, 'rgb(0,255,247)'],
        [0.58431, 'rgb(0,255,252)'],
        [0.58824, 'rgb(0,251,255)'],
        [0.59216, 'rgb(0,246,255)'],
        [0.59608, 'rgb(0,241,255)'],
        [0.6, 'rgb(0,235,255)'],
        [0.60392, 'rgb(0,230,255)'],
        [0.60784, 'rgb(0,224,255)'],
        [0.61176, 'rgb(0,219,255)'],
        [0.61569, 'rgb(0,213,255)'],
        [0.61961, 'rgb(0,208,255)'],
        [0.62353, 'rgb(0,202,255)'],
        [0.62745, 'rgb(0,197,255)'],
        [0.63137, 'rgb(0,192,255)'],
        [0.63529, 'rgb(0,186,255)'],
        [0.63922, 'rgb(0,181,255)'],
        [0.64314, 'rgb(0,175,255)'],
        [0.64706, 'rgb(0,170,255)'],
        [0.65098, 'rgb(0,164,255)'],
        [0.6549, 'rgb(0,159,255)'],
        [0.65882, 'rgb(0,154,255)'],
        [0.66275, 'rgb(0,148,255)'],
        [0.66667, 'rgb(0,143,255)'],
        [0.67059, 'rgb(0,137,255)'],
        [0.67451, 'rgb(0,132,255)'],
        [0.67843, 'rgb(0,126,255)'],
        [0.68235, 'rgb(0,121,255)'],
        [0.68627, 'rgb(0,116,255)'],
        [0.6902, 'rgb(0,110,255)'],
        [0.69412, 'rgb(0,105,255)'],
        [0.69804, 'rgb(0,99,255)'],
        [0.70196, 'rgb(0,94,255)'],
        [0.70588, 'rgb(0,88,255)'],
        [0.7098, 'rgb(0,83,255)'],
        [0.71373, 'rgb(0,77,255)'],
        [0.71765, 'rgb(0,72,255)'],
        [0.72157, 'rgb(0,67,255)'],
        [0.72549, 'rgb(0,61,255)'],
        [0.72941, 'rgb(0,56,255)'],
        [0.73333, 'rgb(0,50,255)'],
        [0.73725, 'rgb(0,45,255)'],
        [0.74118, 'rgb(0,39,255)'],
        [0.7451, 'rgb(0,34,255)'],
        [0.74902, 'rgb(0,29,255)'],
        [0.75294, 'rgb(0,23,255)'],
        [0.75686, 'rgb(0,18,255)'],
        [0.76078, 'rgb(0,12,255)'],
        [0.76471, 'rgb(0,7,255)'],
        [0.76863, 'rgb(0,1,255)'],
        [0.77255, 'rgb(3,0,255)'],
        [0.77647, 'rgb(8,0,255)'],
        [0.78039, 'rgb(14,0,255)'],
        [0.78431, 'rgb(19,0,255)'],
        [0.78824, 'rgb(25,0,255)'],
        [0.79216, 'rgb(30,0,255)'],
        [0.79608, 'rgb(36,0,255)'],
        [0.8, 'rgb(41,0,255)'],
        [0.80392, 'rgb(47,0,255)'],
        [0.80784, 'rgb(52,0,255)'],
        [0.81176, 'rgb(57,0,255)'],
        [0.81569, 'rgb(63,0,255)'],
        [0.81961, 'rgb(68,0,255)'],
        [0.82353, 'rgb(74,0,255)'],
        [0.82745, 'rgb(79,0,255)'],
        [0.83137, 'rgb(85,0,255)'],
        [0.83529, 'rgb(90,0,255)'],
        [0.83922, 'rgb(95,0,255)'],
        [0.84314, 'rgb(101,0,255)'],
        [0.84706, 'rgb(106,0,255)'],
        [0.85098, 'rgb(112,0,255)'],
        [0.8549, 'rgb(117,0,255)'],
        [0.85882, 'rgb(123,0,255)'],
        [0.86275, 'rgb(128,0,255)'],
        [0.86667, 'rgb(133,0,255)'],
        [0.87059, 'rgb(139,0,255)'],
        [0.87451, 'rgb(144,0,255)'],
        [0.87843, 'rgb(150,0,255)'],
        [0.88235, 'rgb(155,0,255)'],
        [0.88627, 'rgb(161,0,255)'],
        [0.8902, 'rgb(166,0,255)'],
        [0.89412, 'rgb(172,0,255)'],
        [0.89804, 'rgb(177,0,255)'],
        [0.90196, 'rgb(182,0,255)'],
        [0.90588, 'rgb(188,0,255)'],
        [0.9098, 'rgb(193,0,255)'],
        [0.91373, 'rgb(199,0,255)'],
        [0.91765, 'rgb(204,0,255)'],
        [0.92157, 'rgb(210,0,255)'],
        [0.92549, 'rgb(215,0,255)'],
        [0.92941, 'rgb(220,0,255)'],
        [0.93333, 'rgb(226,0,255)'],
        [0.93725, 'rgb(231,0,255)'],
        [0.94118, 'rgb(237,0,255)'],
        [0.9451, 'rgb(242,0,255)'],
        [0.94902, 'rgb(248,0,255)'],
        [0.95294, 'rgb(253,0,255)'],
        [0.95686, 'rgb(255,0,251)'],
        [0.96078, 'rgb(255,0,245)'],
        [0.96471, 'rgb(255,0,240)'],
        [0.96863, 'rgb(255,0,234)'],
        [0.97255, 'rgb(255,0,229)'],
        [0.97647, 'rgb(255,0,223)'],
        [0.98039, 'rgb(255,0,218)'],
        [0.98431, 'rgb(255,0,212)'],
        [0.98824, 'rgb(255,0,207)'],
        [0.99216, 'rgb(255,0,202)'],
        [0.99608, 'rgb(255,0,196)'],
        [1.0, 'rgb(255,0,191)'],
    ],
    'gist_stern': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(18,1,2)'],
        [0.00784, 'rgb(36,2,4)'],
        [0.01176, 'rgb(54,3,6)'],
        [0.01569, 'rgb(73,4,8)'],
        [0.01961, 'rgb(91,5,10)'],
        [0.02353, 'rgb(109,6,12)'],
        [0.02745, 'rgb(127,7,14)'],
        [0.03137, 'rgb(146,8,16)'],
        [0.03529, 'rgb(164,9,18)'],
        [0.03922, 'rgb(182,10,20)'],
        [0.04314, 'rgb(201,11,22)'],
        [0.04706, 'rgb(219,12,24)'],
        [0.05098, 'rgb(237,13,26)'],
        [0.0549, 'rgb(254,14,28)'],
        [0.05882, 'rgb(249,15,30)'],
        [0.06275, 'rgb(244,16,32)'],
        [0.06667, 'rgb(239,17,34)'],
        [0.07059, 'rgb(234,18,36)'],
        [0.07451, 'rgb(229,19,38)'],
        [0.07843, 'rgb(224,20,40)'],
        [0.08235, 'rgb(219,21,42)'],
        [0.08627, 'rgb(214,22,44)'],
        [0.0902, 'rgb(209,23,46)'],
        [0.09412, 'rgb(204,24,48)'],
        [0.09804, 'rgb(199,25,50)'],
        [0.10196, 'rgb(194,26,52)'],
        [0.10588, 'rgb(189,27,54)'],
        [0.1098, 'rgb(184,28,56)'],
        [0.11373, 'rgb(180,29,58)'],
        [0.11765, 'rgb(175,30,60)'],
        [0.12157, 'rgb(170,31,62)'],
        [0.12549, 'rgb(165,32,64)'],
        [0.12941, 'rgb(160,32,65)'],
        [0.13333, 'rgb(155,34,68)'],
        [0.13725, 'rgb(150,35,70)'],
        [0.14118, 'rgb(145,36,72)'],
        [0.1451, 'rgb(140,36,73)'],
        [0.14902, 'rgb(135,38,76)'],
        [0.15294, 'rgb(130,39,78)'],
        [0.15686, 'rgb(125,40,80)'],
        [0.16078, 'rgb(120,40,81)'],
        [0.16471, 'rgb(115,42,84)'],
        [0.16863, 'rgb(110,43,86)'],
        [0.17255, 'rgb(105,44,88)'],
        [0.17647, 'rgb(100,44,89)'],
        [0.18039, 'rgb(95,46,92)'],
        [0.18431, 'rgb(90,47,94)'],
        [0.18824, 'rgb(85,48,96)'],
        [0.19216, 'rgb(80,48,97)'],
        [0.19608, 'rgb(75,50,100)'],
        [0.2, 'rgb(70,51,102)'],
        [0.20392, 'rgb(65,52,104)'],
        [0.20784, 'rgb(60,52,105)'],
        [0.21176, 'rgb(55,54,108)'],
        [0.21569, 'rgb(50,55,110)'],
        [0.21961, 'rgb(45,56,112)'],
        [0.22353, 'rgb(40,56,113)'],
        [0.22745, 'rgb(35,58,116)'],
        [0.23137, 'rgb(30,59,118)'],
        [0.23529, 'rgb(25,60,120)'],
        [0.23922, 'rgb(20,60,121)'],
        [0.24314, 'rgb(15,62,124)'],
        [0.24706, 'rgb(10,63,126)'],
        [0.25098, 'rgb(64,64,128)'],
        [0.2549, 'rgb(65,65,130)'],
        [0.25882, 'rgb(65,65,131)'],
        [0.26275, 'rgb(67,67,134)'],
        [0.26667, 'rgb(68,68,136)'],
        [0.27059, 'rgb(69,69,138)'],
        [0.27451, 'rgb(70,70,140)'],
        [0.27843, 'rgb(71,71,142)'],
        [0.28235, 'rgb(72,72,144)'],
        [0.28627, 'rgb(73,73,146)'],
        [0.2902, 'rgb(73,73,147)'],
        [0.29412, 'rgb(75,75,150)'],
        [0.29804, 'rgb(76,76,152)'],
        [0.30196, 'rgb(77,77,154)'],
        [0.30588, 'rgb(78,78,156)'],
        [0.3098, 'rgb(79,79,158)'],
        [0.31373, 'rgb(80,80,160)'],
        [0.31765, 'rgb(81,81,162)'],
        [0.32157, 'rgb(81,81,163)'],
        [0.32549, 'rgb(83,83,166)'],
        [0.32941, 'rgb(84,84,168)'],
        [0.33333, 'rgb(85,85,170)'],
        [0.33725, 'rgb(86,86,172)'],
        [0.34118, 'rgb(87,87,174)'],
        [0.3451, 'rgb(88,88,176)'],
        [0.34902, 'rgb(89,89,178)'],
        [0.35294, 'rgb(89,89,179)'],
        [0.35686, 'rgb(91,91,182)'],
        [0.36078, 'rgb(92,92,184)'],
        [0.36471, 'rgb(93,93,186)'],
        [0.36863, 'rgb(94,94,188)'],
        [0.37255, 'rgb(95,95,190)'],
        [0.37647, 'rgb(96,96,192)'],
        [0.38039, 'rgb(97,97,194)'],
        [0.38431, 'rgb(97,97,195)'],
        [0.38824, 'rgb(99,99,198)'],
        [0.39216, 'rgb(100,100,200)'],
        [0.39608, 'rgb(101,101,202)'],
        [0.4, 'rgb(102,102,204)'],
        [0.40392, 'rgb(103,103,206)'],
        [0.40784, 'rgb(104,104,208)'],
        [0.41176, 'rgb(105,105,210)'],
        [0.41569, 'rgb(105,105,211)'],
        [0.41961, 'rgb(107,107,214)'],
        [0.42353, 'rgb(108,108,216)'],
        [0.42745, 'rgb(109,109,218)'],
        [0.43137, 'rgb(110,110,220)'],
        [0.43529, 'rgb(111,111,222)'],
        [0.43922, 'rgb(112,112,224)'],
        [0.44314, 'rgb(113,113,226)'],
        [0.44706, 'rgb(113,113,227)'],
        [0.45098, 'rgb(115,115,230)'],
        [0.4549, 'rgb(116,116,232)'],
        [0.45882, 'rgb(117,117,234)'],
        [0.46275, 'rgb(118,118,236)'],
        [0.46667, 'rgb(119,119,238)'],
        [0.47059, 'rgb(120,120,240)'],
        [0.47451, 'rgb(121,121,242)'],
        [0.47843, 'rgb(121,121,243)'],
        [0.48235, 'rgb(123,123,246)'],
        [0.48627, 'rgb(124,124,248)'],
        [0.4902, 'rgb(125,125,250)'],
        [0.49412, 'rgb(126,126,252)'],
        [0.49804, 'rgb(127,127,254)'],
        [0.50196, 'rgb(128,128,252)'],
        [0.50588, 'rgb(129,129,248)'],
        [0.5098, 'rgb(130,130,244)'],
        [0.51373, 'rgb(131,131,240)'],
        [0.51765, 'rgb(131,131,235)'],
        [0.52157, 'rgb(132,133,231)'],
        [0.52549, 'rgb(134,134,227)'],
        [0.52941, 'rgb(135,135,223)'],
        [0.53333, 'rgb(136,136,218)'],
        [0.53725, 'rgb(137,137,214)'],
        [0.54118, 'rgb(138,138,210)'],
        [0.5451, 'rgb(139,139,206)'],
        [0.54902, 'rgb(140,140,201)'],
        [0.55294, 'rgb(141,141,197)'],
        [0.55686, 'rgb(142,142,193)'],
        [0.56078, 'rgb(143,143,189)'],
        [0.56471, 'rgb(144,144,184)'],
        [0.56863, 'rgb(145,145,180)'],
        [0.57255, 'rgb(146,146,176)'],
        [0.57647, 'rgb(147,147,172)'],
        [0.58039, 'rgb(147,147,167)'],
        [0.58431, 'rgb(149,149,163)'],
        [0.58824, 'rgb(150,150,159)'],
        [0.59216, 'rgb(151,151,154)'],
        [0.59608, 'rgb(152,152,150)'],
        [0.6, 'rgb(153,153,146)'],
        [0.60392, 'rgb(154,154,142)'],
        [0.60784, 'rgb(155,155,137)'],
        [0.61176, 'rgb(156,156,133)'],
        [0.61569, 'rgb(157,157,129)'],
        [0.61961, 'rgb(158,158,125)'],
        [0.62353, 'rgb(159,159,120)'],
        [0.62745, 'rgb(160,160,116)'],
        [0.63137, 'rgb(161,161,112)'],
        [0.63529, 'rgb(162,162,108)'],
        [0.63922, 'rgb(163,163,103)'],
        [0.64314, 'rgb(163,163,99)'],
        [0.64706, 'rgb(165,165,95)'],
        [0.65098, 'rgb(166,166,91)'],
        [0.6549, 'rgb(167,167,86)'],
        [0.65882, 'rgb(168,168,82)'],
        [0.66275, 'rgb(169,169,78)'],
        [0.66667, 'rgb(170,170,74)'],
        [0.67059, 'rgb(171,171,69)'],
        [0.67451, 'rgb(172,172,65)'],
        [0.67843, 'rgb(173,173,61)'],
        [0.68235, 'rgb(174,174,57)'],
        [0.68627, 'rgb(175,175,52)'],
        [0.6902, 'rgb(176,176,48)'],
        [0.69412, 'rgb(177,177,44)'],
        [0.69804, 'rgb(178,178,40)'],
        [0.70196, 'rgb(179,179,35)'],
        [0.70588, 'rgb(179,179,31)'],
        [0.7098, 'rgb(181,181,27)'],
        [0.71373, 'rgb(182,182,23)'],
        [0.71765, 'rgb(183,183,18)'],
        [0.72157, 'rgb(184,184,14)'],
        [0.72549, 'rgb(185,185,10)'],
        [0.72941, 'rgb(186,186,6)'],
        [0.73333, 'rgb(187,187,1)'],
        [0.73725, 'rgb(188,188,2)'],
        [0.74118, 'rgb(189,189,5)'],
        [0.7451, 'rgb(190,190,9)'],
        [0.74902, 'rgb(191,191,13)'],
        [0.75294, 'rgb(192,192,17)'],
        [0.75686, 'rgb(193,193,21)'],
        [0.76078, 'rgb(194,194,24)'],
        [0.76471, 'rgb(195,195,28)'],
        [0.76863, 'rgb(195,195,32)'],
        [0.77255, 'rgb(196,197,36)'],
        [0.77647, 'rgb(197,198,39)'],
        [0.78039, 'rgb(199,199,43)'],
        [0.78431, 'rgb(200,200,47)'],
        [0.78824, 'rgb(201,201,51)'],
        [0.79216, 'rgb(202,202,55)'],
        [0.79608, 'rgb(203,203,58)'],
        [0.8, 'rgb(203,204,62)'],
        [0.80392, 'rgb(205,205,66)'],
        [0.80784, 'rgb(206,206,70)'],
        [0.81176, 'rgb(207,207,73)'],
        [0.81569, 'rgb(208,208,77)'],
        [0.81961, 'rgb(209,209,81)'],
        [0.82353, 'rgb(210,210,85)'],
        [0.82745, 'rgb(211,211,88)'],
        [0.83137, 'rgb(211,211,92)'],
        [0.83529, 'rgb(213,213,96)'],
        [0.83922, 'rgb(214,214,100)'],
        [0.84314, 'rgb(215,215,104)'],
        [0.84706, 'rgb(216,216,107)'],
        [0.85098, 'rgb(217,217,111)'],
        [0.8549, 'rgb(218,218,115)'],
        [0.85882, 'rgb(219,219,119)'],
        [0.86275, 'rgb(220,220,122)'],
        [0.86667, 'rgb(221,221,126)'],
        [0.87059, 'rgb(222,222,130)'],
        [0.87451, 'rgb(223,223,134)'],
        [0.87843, 'rgb(224,224,138)'],
        [0.88235, 'rgb(225,225,141)'],
        [0.88627, 'rgb(226,226,145)'],
        [0.8902, 'rgb(227,227,149)'],
        [0.89412, 'rgb(227,227,153)'],
        [0.89804, 'rgb(229,229,156)'],
        [0.90196, 'rgb(230,230,160)'],
        [0.90588, 'rgb(231,231,164)'],
        [0.9098, 'rgb(232,232,168)'],
        [0.91373, 'rgb(233,233,171)'],
        [0.91765, 'rgb(234,234,175)'],
        [0.92157, 'rgb(235,235,179)'],
        [0.92549, 'rgb(236,236,183)'],
        [0.92941, 'rgb(237,237,187)'],
        [0.93333, 'rgb(238,238,190)'],
        [0.93725, 'rgb(239,239,194)'],
        [0.94118, 'rgb(240,240,198)'],
        [0.9451, 'rgb(241,241,202)'],
        [0.94902, 'rgb(242,242,205)'],
        [0.95294, 'rgb(243,243,209)'],
        [0.95686, 'rgb(243,243,213)'],
        [0.96078, 'rgb(244,245,217)'],
        [0.96471, 'rgb(245,246,221)'],
        [0.96863, 'rgb(247,247,224)'],
        [0.97255, 'rgb(248,248,228)'],
        [0.97647, 'rgb(249,249,232)'],
        [0.98039, 'rgb(250,250,236)'],
        [0.98431, 'rgb(251,251,239)'],
        [0.98824, 'rgb(251,252,243)'],
        [0.99216, 'rgb(253,253,247)'],
        [0.99608, 'rgb(254,254,251)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'gist_yarg': [
        [0.0, 'rgb(255,255,255)'],
        [0.00392, 'rgb(254,254,254)'],
        [0.00784, 'rgb(253,253,253)'],
        [0.01176, 'rgb(252,252,252)'],
        [0.01569, 'rgb(251,251,251)'],
        [0.01961, 'rgb(250,250,250)'],
        [0.02353, 'rgb(249,249,249)'],
        [0.02745, 'rgb(248,248,248)'],
        [0.03137, 'rgb(247,247,247)'],
        [0.03529, 'rgb(246,246,246)'],
        [0.03922, 'rgb(245,245,245)'],
        [0.04314, 'rgb(244,244,244)'],
        [0.04706, 'rgb(243,243,243)'],
        [0.05098, 'rgb(242,242,242)'],
        [0.0549, 'rgb(241,241,241)'],
        [0.05882, 'rgb(240,240,240)'],
        [0.06275, 'rgb(239,239,239)'],
        [0.06667, 'rgb(238,238,238)'],
        [0.07059, 'rgb(237,237,237)'],
        [0.07451, 'rgb(236,236,236)'],
        [0.07843, 'rgb(235,235,235)'],
        [0.08235, 'rgb(234,234,234)'],
        [0.08627, 'rgb(233,233,233)'],
        [0.0902, 'rgb(232,232,232)'],
        [0.09412, 'rgb(231,231,231)'],
        [0.09804, 'rgb(230,230,230)'],
        [0.10196, 'rgb(229,229,229)'],
        [0.10588, 'rgb(228,228,228)'],
        [0.1098, 'rgb(227,227,227)'],
        [0.11373, 'rgb(226,226,226)'],
        [0.11765, 'rgb(225,225,225)'],
        [0.12157, 'rgb(224,224,224)'],
        [0.12549, 'rgb(223,223,223)'],
        [0.12941, 'rgb(222,222,222)'],
        [0.13333, 'rgb(221,221,221)'],
        [0.13725, 'rgb(220,220,220)'],
        [0.14118, 'rgb(219,219,219)'],
        [0.1451, 'rgb(218,218,218)'],
        [0.14902, 'rgb(217,217,217)'],
        [0.15294, 'rgb(216,216,216)'],
        [0.15686, 'rgb(215,215,215)'],
        [0.16078, 'rgb(214,214,214)'],
        [0.16471, 'rgb(213,213,213)'],
        [0.16863, 'rgb(211,211,211)'],
        [0.17255, 'rgb(211,211,211)'],
        [0.17647, 'rgb(210,210,210)'],
        [0.18039, 'rgb(209,209,209)'],
        [0.18431, 'rgb(208,208,208)'],
        [0.18824, 'rgb(207,207,207)'],
        [0.19216, 'rgb(206,206,206)'],
        [0.19608, 'rgb(205,205,205)'],
        [0.2, 'rgb(204,204,204)'],
        [0.20392, 'rgb(203,203,203)'],
        [0.20784, 'rgb(202,202,202)'],
        [0.21176, 'rgb(201,201,201)'],
        [0.21569, 'rgb(200,200,200)'],
        [0.21961, 'rgb(199,199,199)'],
        [0.22353, 'rgb(198,198,198)'],
        [0.22745, 'rgb(197,197,197)'],
        [0.23137, 'rgb(195,195,195)'],
        [0.23529, 'rgb(195,195,195)'],
        [0.23922, 'rgb(194,194,194)'],
        [0.24314, 'rgb(193,193,193)'],
        [0.24706, 'rgb(192,192,192)'],
        [0.25098, 'rgb(191,191,191)'],
        [0.2549, 'rgb(190,190,190)'],
        [0.25882, 'rgb(189,189,189)'],
        [0.26275, 'rgb(188,188,188)'],
        [0.26667, 'rgb(187,187,187)'],
        [0.27059, 'rgb(186,186,186)'],
        [0.27451, 'rgb(185,185,185)'],
        [0.27843, 'rgb(184,184,184)'],
        [0.28235, 'rgb(183,183,183)'],
        [0.28627, 'rgb(182,182,182)'],
        [0.2902, 'rgb(181,181,181)'],
        [0.29412, 'rgb(179,179,179)'],
        [0.29804, 'rgb(179,179,179)'],
        [0.30196, 'rgb(178,178,178)'],
        [0.30588, 'rgb(177,177,177)'],
        [0.3098, 'rgb(176,176,176)'],
        [0.31373, 'rgb(175,175,175)'],
        [0.31765, 'rgb(174,174,174)'],
        [0.32157, 'rgb(173,173,173)'],
        [0.32549, 'rgb(172,172,172)'],
        [0.32941, 'rgb(171,171,171)'],
        [0.33333, 'rgb(170,170,170)'],
        [0.33725, 'rgb(169,169,169)'],
        [0.34118, 'rgb(168,168,168)'],
        [0.3451, 'rgb(167,167,167)'],
        [0.34902, 'rgb(166,166,166)'],
        [0.35294, 'rgb(165,165,165)'],
        [0.35686, 'rgb(163,163,163)'],
        [0.36078, 'rgb(163,163,163)'],
        [0.36471, 'rgb(162,162,162)'],
        [0.36863, 'rgb(161,161,161)'],
        [0.37255, 'rgb(160,160,160)'],
        [0.37647, 'rgb(159,159,159)'],
        [0.38039, 'rgb(158,158,158)'],
        [0.38431, 'rgb(157,157,157)'],
        [0.38824, 'rgb(156,156,156)'],
        [0.39216, 'rgb(155,155,155)'],
        [0.39608, 'rgb(154,154,154)'],
        [0.4, 'rgb(153,153,153)'],
        [0.40392, 'rgb(152,152,152)'],
        [0.40784, 'rgb(151,151,151)'],
        [0.41176, 'rgb(150,150,150)'],
        [0.41569, 'rgb(149,149,149)'],
        [0.41961, 'rgb(147,147,147)'],
        [0.42353, 'rgb(147,147,147)'],
        [0.42745, 'rgb(146,146,146)'],
        [0.43137, 'rgb(145,145,145)'],
        [0.43529, 'rgb(144,144,144)'],
        [0.43922, 'rgb(143,143,143)'],
        [0.44314, 'rgb(142,142,142)'],
        [0.44706, 'rgb(141,141,141)'],
        [0.45098, 'rgb(140,140,140)'],
        [0.4549, 'rgb(139,139,139)'],
        [0.45882, 'rgb(138,138,138)'],
        [0.46275, 'rgb(137,137,137)'],
        [0.46667, 'rgb(136,136,136)'],
        [0.47059, 'rgb(135,135,135)'],
        [0.47451, 'rgb(134,134,134)'],
        [0.47843, 'rgb(133,133,133)'],
        [0.48235, 'rgb(131,131,131)'],
        [0.48627, 'rgb(131,131,131)'],
        [0.4902, 'rgb(130,130,130)'],
        [0.49412, 'rgb(129,129,129)'],
        [0.49804, 'rgb(128,128,128)'],
        [0.50196, 'rgb(127,127,127)'],
        [0.50588, 'rgb(126,126,126)'],
        [0.5098, 'rgb(125,125,125)'],
        [0.51373, 'rgb(124,124,124)'],
        [0.51765, 'rgb(123,123,123)'],
        [0.52157, 'rgb(121,121,121)'],
        [0.52549, 'rgb(121,121,121)'],
        [0.52941, 'rgb(120,120,120)'],
        [0.53333, 'rgb(119,119,119)'],
        [0.53725, 'rgb(118,118,118)'],
        [0.54118, 'rgb(117,117,117)'],
        [0.5451, 'rgb(116,116,116)'],
        [0.54902, 'rgb(114,114,114)'],
        [0.55294, 'rgb(113,113,113)'],
        [0.55686, 'rgb(113,113,113)'],
        [0.56078, 'rgb(112,112,112)'],
        [0.56471, 'rgb(111,111,111)'],
        [0.56863, 'rgb(110,110,110)'],
        [0.57255, 'rgb(109,109,109)'],
        [0.57647, 'rgb(108,108,108)'],
        [0.58039, 'rgb(107,107,107)'],
        [0.58431, 'rgb(105,105,105)'],
        [0.58824, 'rgb(105,105,105)'],
        [0.59216, 'rgb(104,104,104)'],
        [0.59608, 'rgb(103,103,103)'],
        [0.6, 'rgb(102,102,102)'],
        [0.60392, 'rgb(101,101,101)'],
        [0.60784, 'rgb(100,100,100)'],
        [0.61176, 'rgb(98,98,98)'],
        [0.61569, 'rgb(97,97,97)'],
        [0.61961, 'rgb(97,97,97)'],
        [0.62353, 'rgb(96,96,96)'],
        [0.62745, 'rgb(95,95,95)'],
        [0.63137, 'rgb(94,94,94)'],
        [0.63529, 'rgb(93,93,93)'],
        [0.63922, 'rgb(92,92,92)'],
        [0.64314, 'rgb(91,91,91)'],
        [0.64706, 'rgb(89,89,89)'],
        [0.65098, 'rgb(89,89,89)'],
        [0.6549, 'rgb(88,88,88)'],
        [0.65882, 'rgb(87,87,87)'],
        [0.66275, 'rgb(86,86,86)'],
        [0.66667, 'rgb(85,85,85)'],
        [0.67059, 'rgb(84,84,84)'],
        [0.67451, 'rgb(82,82,82)'],
        [0.67843, 'rgb(81,81,81)'],
        [0.68235, 'rgb(81,81,81)'],
        [0.68627, 'rgb(80,80,80)'],
        [0.6902, 'rgb(79,79,79)'],
        [0.69412, 'rgb(78,78,78)'],
        [0.69804, 'rgb(77,77,77)'],
        [0.70196, 'rgb(76,76,76)'],
        [0.70588, 'rgb(75,75,75)'],
        [0.7098, 'rgb(73,73,73)'],
        [0.71373, 'rgb(73,73,73)'],
        [0.71765, 'rgb(72,72,72)'],
        [0.72157, 'rgb(71,71,71)'],
        [0.72549, 'rgb(70,70,70)'],
        [0.72941, 'rgb(69,69,69)'],
        [0.73333, 'rgb(68,68,68)'],
        [0.73725, 'rgb(66,66,66)'],
        [0.74118, 'rgb(65,65,65)'],
        [0.7451, 'rgb(65,65,65)'],
        [0.74902, 'rgb(64,64,64)'],
        [0.75294, 'rgb(63,63,63)'],
        [0.75686, 'rgb(62,62,62)'],
        [0.76078, 'rgb(61,61,61)'],
        [0.76471, 'rgb(60,60,60)'],
        [0.76863, 'rgb(59,59,59)'],
        [0.77255, 'rgb(57,57,57)'],
        [0.77647, 'rgb(56,56,56)'],
        [0.78039, 'rgb(56,56,56)'],
        [0.78431, 'rgb(55,55,55)'],
        [0.78824, 'rgb(54,54,54)'],
        [0.79216, 'rgb(53,53,53)'],
        [0.79608, 'rgb(52,52,52)'],
        [0.8, 'rgb(50,50,50)'],
        [0.80392, 'rgb(49,49,49)'],
        [0.80784, 'rgb(48,48,48)'],
        [0.81176, 'rgb(48,48,48)'],
        [0.81569, 'rgb(47,47,47)'],
        [0.81961, 'rgb(46,46,46)'],
        [0.82353, 'rgb(45,45,45)'],
        [0.82745, 'rgb(44,44,44)'],
        [0.83137, 'rgb(43,43,43)'],
        [0.83529, 'rgb(41,41,41)'],
        [0.83922, 'rgb(40,40,40)'],
        [0.84314, 'rgb(40,40,40)'],
        [0.84706, 'rgb(39,39,39)'],
        [0.85098, 'rgb(38,38,38)'],
        [0.8549, 'rgb(37,37,37)'],
        [0.85882, 'rgb(36,36,36)'],
        [0.86275, 'rgb(34,34,34)'],
        [0.86667, 'rgb(33,33,33)'],
        [0.87059, 'rgb(32,32,32)'],
        [0.87451, 'rgb(32,32,32)'],
        [0.87843, 'rgb(31,31,31)'],
        [0.88235, 'rgb(30,30,30)'],
        [0.88627, 'rgb(29,29,29)'],
        [0.8902, 'rgb(28,28,28)'],
        [0.89412, 'rgb(27,27,27)'],
        [0.89804, 'rgb(25,25,25)'],
        [0.90196, 'rgb(24,24,24)'],
        [0.90588, 'rgb(24,24,24)'],
        [0.9098, 'rgb(23,23,23)'],
        [0.91373, 'rgb(22,22,22)'],
        [0.91765, 'rgb(21,21,21)'],
        [0.92157, 'rgb(20,20,20)'],
        [0.92549, 'rgb(18,18,18)'],
        [0.92941, 'rgb(17,17,17)'],
        [0.93333, 'rgb(16,16,16)'],
        [0.93725, 'rgb(16,16,16)'],
        [0.94118, 'rgb(15,15,15)'],
        [0.9451, 'rgb(14,14,14)'],
        [0.94902, 'rgb(13,13,13)'],
        [0.95294, 'rgb(12,12,12)'],
        [0.95686, 'rgb(11,11,11)'],
        [0.96078, 'rgb(9,9,9)'],
        [0.96471, 'rgb(8,8,8)'],
        [0.96863, 'rgb(8,8,8)'],
        [0.97255, 'rgb(7,7,7)'],
        [0.97647, 'rgb(6,6,6)'],
        [0.98039, 'rgb(5,5,5)'],
        [0.98431, 'rgb(4,4,4)'],
        [0.98824, 'rgb(2,2,2)'],
        [0.99216, 'rgb(1,1,1)'],
        [0.99608, 'rgb(0,0,0)'],
        [1.0, 'rgb(0,0,0)'],
    ],
    'gnuplot': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(15,0,6)'],
        [0.00784, 'rgb(22,0,12)'],
        [0.01176, 'rgb(27,0,18)'],
        [0.01569, 'rgb(31,0,25)'],
        [0.01961, 'rgb(35,0,31)'],
        [0.02353, 'rgb(39,0,37)'],
        [0.02745, 'rgb(42,0,43)'],
        [0.03137, 'rgb(45,0,49)'],
        [0.03529, 'rgb(47,0,56)'],
        [0.03922, 'rgb(50,0,62)'],
        [0.04314, 'rgb(52,0,68)'],
        [0.04706, 'rgb(55,0,74)'],
        [0.05098, 'rgb(57,0,80)'],
        [0.0549, 'rgb(59,0,86)'],
        [0.05882, 'rgb(61,0,92)'],
        [0.06275, 'rgb(63,0,97)'],
        [0.06667, 'rgb(65,0,103)'],
        [0.07059, 'rgb(67,0,109)'],
        [0.07451, 'rgb(69,0,115)'],
        [0.07843, 'rgb(71,0,120)'],
        [0.08235, 'rgb(73,0,126)'],
        [0.08627, 'rgb(74,0,131)'],
        [0.0902, 'rgb(76,0,136)'],
        [0.09412, 'rgb(78,0,142)'],
        [0.09804, 'rgb(79,0,147)'],
        [0.10196, 'rgb(81,0,152)'],
        [0.10588, 'rgb(82,0,157)'],
        [0.1098, 'rgb(84,0,162)'],
        [0.11373, 'rgb(85,0,167)'],
        [0.11765, 'rgb(87,0,171)'],
        [0.12157, 'rgb(88,0,176)'],
        [0.12549, 'rgb(90,0,180)'],
        [0.12941, 'rgb(91,0,185)'],
        [0.13333, 'rgb(93,0,189)'],
        [0.13725, 'rgb(94,0,193)'],
        [0.14118, 'rgb(95,0,197)'],
        [0.1451, 'rgb(97,0,201)'],
        [0.14902, 'rgb(98,0,205)'],
        [0.15294, 'rgb(99,0,209)'],
        [0.15686, 'rgb(100,0,212)'],
        [0.16078, 'rgb(102,1,215)'],
        [0.16471, 'rgb(103,1,219)'],
        [0.16863, 'rgb(104,1,222)'],
        [0.17255, 'rgb(105,1,225)'],
        [0.17647, 'rgb(107,1,228)'],
        [0.18039, 'rgb(108,1,230)'],
        [0.18431, 'rgb(109,1,233)'],
        [0.18824, 'rgb(110,1,236)'],
        [0.19216, 'rgb(111,1,238)'],
        [0.19608, 'rgb(112,1,240)'],
        [0.2, 'rgb(114,2,242)'],
        [0.20392, 'rgb(115,2,244)'],
        [0.20784, 'rgb(116,2,246)'],
        [0.21176, 'rgb(117,2,247)'],
        [0.21569, 'rgb(118,2,249)'],
        [0.21961, 'rgb(119,2,250)'],
        [0.22353, 'rgb(120,2,251)'],
        [0.22745, 'rgb(121,3,252)'],
        [0.23137, 'rgb(122,3,253)'],
        [0.23529, 'rgb(123,3,253)'],
        [0.23922, 'rgb(124,3,254)'],
        [0.24314, 'rgb(125,3,254)'],
        [0.24706, 'rgb(126,3,254)'],
        [0.25098, 'rgb(127,4,254)'],
        [0.2549, 'rgb(128,4,254)'],
        [0.25882, 'rgb(129,4,254)'],
        [0.26275, 'rgb(130,4,254)'],
        [0.26667, 'rgb(131,4,253)'],
        [0.27059, 'rgb(132,5,252)'],
        [0.27451, 'rgb(133,5,251)'],
        [0.27843, 'rgb(134,5,250)'],
        [0.28235, 'rgb(135,5,249)'],
        [0.28627, 'rgb(136,5,248)'],
        [0.2902, 'rgb(137,6,246)'],
        [0.29412, 'rgb(138,6,245)'],
        [0.29804, 'rgb(139,6,243)'],
        [0.30196, 'rgb(140,7,241)'],
        [0.30588, 'rgb(141,7,239)'],
        [0.3098, 'rgb(141,7,237)'],
        [0.31373, 'rgb(142,7,234)'],
        [0.31765, 'rgb(143,8,232)'],
        [0.32157, 'rgb(144,8,229)'],
        [0.32549, 'rgb(145,8,226)'],
        [0.32941, 'rgb(146,9,223)'],
        [0.33333, 'rgb(147,9,220)'],
        [0.33725, 'rgb(148,9,217)'],
        [0.34118, 'rgb(148,10,214)'],
        [0.3451, 'rgb(149,10,210)'],
        [0.34902, 'rgb(150,10,207)'],
        [0.35294, 'rgb(151,11,203)'],
        [0.35686, 'rgb(152,11,199)'],
        [0.36078, 'rgb(153,11,195)'],
        [0.36471, 'rgb(153,12,191)'],
        [0.36863, 'rgb(154,12,187)'],
        [0.37255, 'rgb(155,13,183)'],
        [0.37647, 'rgb(156,13,178)'],
        [0.38039, 'rgb(157,14,174)'],
        [0.38431, 'rgb(158,14,169)'],
        [0.38824, 'rgb(158,14,164)'],
        [0.39216, 'rgb(159,15,159)'],
        [0.39608, 'rgb(160,15,154)'],
        [0.4, 'rgb(161,16,149)'],
        [0.40392, 'rgb(162,16,144)'],
        [0.40784, 'rgb(162,17,139)'],
        [0.41176, 'rgb(163,17,134)'],
        [0.41569, 'rgb(164,18,128)'],
        [0.41961, 'rgb(165,18,123)'],
        [0.42353, 'rgb(165,19,117)'],
        [0.42745, 'rgb(166,19,112)'],
        [0.43137, 'rgb(167,20,106)'],
        [0.43529, 'rgb(168,21,100)'],
        [0.43922, 'rgb(168,21,95)'],
        [0.44314, 'rgb(169,22,89)'],
        [0.44706, 'rgb(170,22,83)'],
        [0.45098, 'rgb(171,23,77)'],
        [0.4549, 'rgb(171,24,71)'],
        [0.45882, 'rgb(172,24,65)'],
        [0.46275, 'rgb(173,25,59)'],
        [0.46667, 'rgb(174,25,53)'],
        [0.47059, 'rgb(174,26,46)'],
        [0.47451, 'rgb(175,27,40)'],
        [0.47843, 'rgb(176,27,34)'],
        [0.48235, 'rgb(177,28,28)'],
        [0.48627, 'rgb(177,29,21)'],
        [0.4902, 'rgb(178,30,15)'],
        [0.49412, 'rgb(179,30,9)'],
        [0.49804, 'rgb(179,31,3)'],
        [0.50196, 'rgb(180,32,0)'],
        [0.50588, 'rgb(181,33,0)'],
        [0.5098, 'rgb(182,33,0)'],
        [0.51373, 'rgb(182,34,0)'],
        [0.51765, 'rgb(183,35,0)'],
        [0.52157, 'rgb(184,36,0)'],
        [0.52549, 'rgb(184,37,0)'],
        [0.52941, 'rgb(185,37,0)'],
        [0.53333, 'rgb(186,38,0)'],
        [0.53725, 'rgb(186,39,0)'],
        [0.54118, 'rgb(187,40,0)'],
        [0.5451, 'rgb(188,41,0)'],
        [0.54902, 'rgb(188,42,0)'],
        [0.55294, 'rgb(189,43,0)'],
        [0.55686, 'rgb(190,44,0)'],
        [0.56078, 'rgb(190,44,0)'],
        [0.56471, 'rgb(191,45,0)'],
        [0.56863, 'rgb(192,46,0)'],
        [0.57255, 'rgb(192,47,0)'],
        [0.57647, 'rgb(193,48,0)'],
        [0.58039, 'rgb(194,49,0)'],
        [0.58431, 'rgb(194,50,0)'],
        [0.58824, 'rgb(195,51,0)'],
        [0.59216, 'rgb(196,52,0)'],
        [0.59608, 'rgb(196,54,0)'],
        [0.6, 'rgb(197,55,0)'],
        [0.60392, 'rgb(198,56,0)'],
        [0.60784, 'rgb(198,57,0)'],
        [0.61176, 'rgb(199,58,0)'],
        [0.61569, 'rgb(200,59,0)'],
        [0.61961, 'rgb(200,60,0)'],
        [0.62353, 'rgb(201,61,0)'],
        [0.62745, 'rgb(201,62,0)'],
        [0.63137, 'rgb(202,64,0)'],
        [0.63529, 'rgb(203,65,0)'],
        [0.63922, 'rgb(203,66,0)'],
        [0.64314, 'rgb(204,67,0)'],
        [0.64706, 'rgb(205,69,0)'],
        [0.65098, 'rgb(205,70,0)'],
        [0.6549, 'rgb(206,71,0)'],
        [0.65882, 'rgb(206,72,0)'],
        [0.66275, 'rgb(207,74,0)'],
        [0.66667, 'rgb(208,75,0)'],
        [0.67059, 'rgb(208,76,0)'],
        [0.67451, 'rgb(209,78,0)'],
        [0.67843, 'rgb(210,79,0)'],
        [0.68235, 'rgb(210,81,0)'],
        [0.68627, 'rgb(211,82,0)'],
        [0.6902, 'rgb(211,83,0)'],
        [0.69412, 'rgb(212,85,0)'],
        [0.69804, 'rgb(213,86,0)'],
        [0.70196, 'rgb(213,88,0)'],
        [0.70588, 'rgb(214,89,0)'],
        [0.7098, 'rgb(214,91,0)'],
        [0.71373, 'rgb(215,92,0)'],
        [0.71765, 'rgb(216,94,0)'],
        [0.72157, 'rgb(216,95,0)'],
        [0.72549, 'rgb(217,97,0)'],
        [0.72941, 'rgb(217,98,0)'],
        [0.73333, 'rgb(218,100,0)'],
        [0.73725, 'rgb(218,102,0)'],
        [0.74118, 'rgb(219,103,0)'],
        [0.7451, 'rgb(220,105,0)'],
        [0.74902, 'rgb(220,107,0)'],
        [0.75294, 'rgb(221,108,0)'],
        [0.75686, 'rgb(221,110,0)'],
        [0.76078, 'rgb(222,112,0)'],
        [0.76471, 'rgb(222,114,0)'],
        [0.76863, 'rgb(223,115,0)'],
        [0.77255, 'rgb(224,117,0)'],
        [0.77647, 'rgb(224,119,0)'],
        [0.78039, 'rgb(225,121,0)'],
        [0.78431, 'rgb(225,123,0)'],
        [0.78824, 'rgb(226,124,0)'],
        [0.79216, 'rgb(226,126,0)'],
        [0.79608, 'rgb(227,128,0)'],
        [0.8, 'rgb(228,130,0)'],
        [0.80392, 'rgb(228,132,0)'],
        [0.80784, 'rgb(229,134,0)'],
        [0.81176, 'rgb(229,136,0)'],
        [0.81569, 'rgb(230,138,0)'],
        [0.81961, 'rgb(230,140,0)'],
        [0.82353, 'rgb(231,142,0)'],
        [0.82745, 'rgb(231,144,0)'],
        [0.83137, 'rgb(232,146,0)'],
        [0.83529, 'rgb(233,148,0)'],
        [0.83922, 'rgb(233,150,0)'],
        [0.84314, 'rgb(234,152,0)'],
        [0.84706, 'rgb(234,154,0)'],
        [0.85098, 'rgb(235,157,0)'],
        [0.8549, 'rgb(235,159,0)'],
        [0.85882, 'rgb(236,161,0)'],
        [0.86275, 'rgb(236,163,0)'],
        [0.86667, 'rgb(237,165,0)'],
        [0.87059, 'rgb(237,168,0)'],
        [0.87451, 'rgb(238,170,0)'],
        [0.87843, 'rgb(238,172,0)'],
        [0.88235, 'rgb(239,175,0)'],
        [0.88627, 'rgb(240,177,0)'],
        [0.8902, 'rgb(240,179,0)'],
        [0.89412, 'rgb(241,182,0)'],
        [0.89804, 'rgb(241,184,0)'],
        [0.90196, 'rgb(242,187,0)'],
        [0.90588, 'rgb(242,189,0)'],
        [0.9098, 'rgb(243,192,0)'],
        [0.91373, 'rgb(243,194,0)'],
        [0.91765, 'rgb(244,197,0)'],
        [0.92157, 'rgb(244,199,0)'],
        [0.92549, 'rgb(245,202,0)'],
        [0.92941, 'rgb(245,204,0)'],
        [0.93333, 'rgb(246,207,0)'],
        [0.93725, 'rgb(246,209,0)'],
        [0.94118, 'rgb(247,212,0)'],
        [0.9451, 'rgb(247,215,0)'],
        [0.94902, 'rgb(248,217,0)'],
        [0.95294, 'rgb(248,220,0)'],
        [0.95686, 'rgb(249,223,0)'],
        [0.96078, 'rgb(249,226,0)'],
        [0.96471, 'rgb(250,228,0)'],
        [0.96863, 'rgb(250,231,0)'],
        [0.97255, 'rgb(251,234,0)'],
        [0.97647, 'rgb(251,237,0)'],
        [0.98039, 'rgb(252,240,0)'],
        [0.98431, 'rgb(252,243,0)'],
        [0.98824, 'rgb(253,246,0)'],
        [0.99216, 'rgb(253,249,0)'],
        [0.99608, 'rgb(254,252,0)'],
        [1.0, 'rgb(255,255,0)'],
    ],
    'gnuplot2': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(0,0,4)'],
        [0.00784, 'rgb(0,0,8)'],
        [0.01176, 'rgb(0,0,12)'],
        [0.01569, 'rgb(0,0,16)'],
        [0.01961, 'rgb(0,0,20)'],
        [0.02353, 'rgb(0,0,24)'],
        [0.02745, 'rgb(0,0,28)'],
        [0.03137, 'rgb(0,0,32)'],
        [0.03529, 'rgb(0,0,36)'],
        [0.03922, 'rgb(0,0,40)'],
        [0.04314, 'rgb(0,0,44)'],
        [0.04706, 'rgb(0,0,48)'],
        [0.05098, 'rgb(0,0,52)'],
        [0.0549, 'rgb(0,0,56)'],
        [0.05882, 'rgb(0,0,60)'],
        [0.06275, 'rgb(0,0,64)'],
        [0.06667, 'rgb(0,0,68)'],
        [0.07059, 'rgb(0,0,72)'],
        [0.07451, 'rgb(0,0,76)'],
        [0.07843, 'rgb(0,0,80)'],
        [0.08235, 'rgb(0,0,84)'],
        [0.08627, 'rgb(0,0,88)'],
        [0.0902, 'rgb(0,0,92)'],
        [0.09412, 'rgb(0,0,96)'],
        [0.09804, 'rgb(0,0,100)'],
        [0.10196, 'rgb(0,0,104)'],
        [0.10588, 'rgb(0,0,108)'],
        [0.1098, 'rgb(0,0,112)'],
        [0.11373, 'rgb(0,0,116)'],
        [0.11765, 'rgb(0,0,120)'],
        [0.12157, 'rgb(0,0,124)'],
        [0.12549, 'rgb(0,0,128)'],
        [0.12941, 'rgb(0,0,131)'],
        [0.13333, 'rgb(0,0,136)'],
        [0.13725, 'rgb(0,0,140)'],
        [0.14118, 'rgb(0,0,144)'],
        [0.1451, 'rgb(0,0,147)'],
        [0.14902, 'rgb(0,0,152)'],
        [0.15294, 'rgb(0,0,156)'],
        [0.15686, 'rgb(0,0,160)'],
        [0.16078, 'rgb(0,0,163)'],
        [0.16471, 'rgb(0,0,168)'],
        [0.16863, 'rgb(0,0,172)'],
        [0.17255, 'rgb(0,0,176)'],
        [0.17647, 'rgb(0,0,179)'],
        [0.18039, 'rgb(0,0,184)'],
        [0.18431, 'rgb(0,0,188)'],
        [0.18824, 'rgb(0,0,192)'],
        [0.19216, 'rgb(0,0,195)'],
        [0.19608, 'rgb(0,0,200)'],
        [0.2, 'rgb(0,0,204)'],
        [0.20392, 'rgb(0,0,208)'],
        [0.20784, 'rgb(0,0,211)'],
        [0.21176, 'rgb(0,0,216)'],
        [0.21569, 'rgb(0,0,220)'],
        [0.21961, 'rgb(0,0,224)'],
        [0.22353, 'rgb(0,0,227)'],
        [0.22745, 'rgb(0,0,232)'],
        [0.23137, 'rgb(0,0,236)'],
        [0.23529, 'rgb(0,0,240)'],
        [0.23922, 'rgb(0,0,243)'],
        [0.24314, 'rgb(0,0,248)'],
        [0.24706, 'rgb(0,0,252)'],
        [0.25098, 'rgb(0,0,255)'],
        [0.2549, 'rgb(3,0,255)'],
        [0.25882, 'rgb(7,0,255)'],
        [0.26275, 'rgb(10,0,255)'],
        [0.26667, 'rgb(13,0,255)'],
        [0.27059, 'rgb(16,0,255)'],
        [0.27451, 'rgb(19,0,255)'],
        [0.27843, 'rgb(22,0,255)'],
        [0.28235, 'rgb(25,0,255)'],
        [0.28627, 'rgb(28,0,255)'],
        [0.2902, 'rgb(32,0,255)'],
        [0.29412, 'rgb(35,0,255)'],
        [0.29804, 'rgb(38,0,255)'],
        [0.30196, 'rgb(41,0,255)'],
        [0.30588, 'rgb(44,0,255)'],
        [0.3098, 'rgb(47,0,255)'],
        [0.31373, 'rgb(50,0,255)'],
        [0.31765, 'rgb(53,0,255)'],
        [0.32157, 'rgb(57,0,255)'],
        [0.32549, 'rgb(60,0,255)'],
        [0.32941, 'rgb(63,0,255)'],
        [0.33333, 'rgb(66,0,255)'],
        [0.33725, 'rgb(69,0,255)'],
        [0.34118, 'rgb(72,0,255)'],
        [0.3451, 'rgb(75,0,255)'],
        [0.34902, 'rgb(78,0,255)'],
        [0.35294, 'rgb(82,0,255)'],
        [0.35686, 'rgb(85,0,255)'],
        [0.36078, 'rgb(88,0,255)'],
        [0.36471, 'rgb(91,0,255)'],
        [0.36863, 'rgb(94,0,255)'],
        [0.37255, 'rgb(97,0,255)'],
        [0.37647, 'rgb(100,0,255)'],
        [0.38039, 'rgb(103,0,255)'],
        [0.38431, 'rgb(107,0,255)'],
        [0.38824, 'rgb(110,0,255)'],
        [0.39216, 'rgb(113,0,255)'],
        [0.39608, 'rgb(116,0,255)'],
        [0.4, 'rgb(119,0,255)'],
        [0.40392, 'rgb(122,0,255)'],
        [0.40784, 'rgb(125,0,255)'],
        [0.41176, 'rgb(128,0,255)'],
        [0.41569, 'rgb(132,0,255)'],
        [0.41961, 'rgb(135,0,255)'],
        [0.42353, 'rgb(138,1,253)'],
        [0.42745, 'rgb(141,3,251)'],
        [0.43137, 'rgb(144,5,249)'],
        [0.43529, 'rgb(147,7,247)'],
        [0.43922, 'rgb(150,9,245)'],
        [0.44314, 'rgb(153,11,243)'],
        [0.44706, 'rgb(157,13,241)'],
        [0.45098, 'rgb(160,15,239)'],
        [0.4549, 'rgb(163,17,237)'],
        [0.45882, 'rgb(166,19,235)'],
        [0.46275, 'rgb(169,21,233)'],
        [0.46667, 'rgb(172,23,231)'],
        [0.47059, 'rgb(175,25,229)'],
        [0.47451, 'rgb(178,27,227)'],
        [0.47843, 'rgb(182,29,225)'],
        [0.48235, 'rgb(185,31,223)'],
        [0.48627, 'rgb(188,33,221)'],
        [0.4902, 'rgb(191,35,219)'],
        [0.49412, 'rgb(194,37,217)'],
        [0.49804, 'rgb(197,39,215)'],
        [0.50196, 'rgb(200,41,213)'],
        [0.50588, 'rgb(203,43,211)'],
        [0.5098, 'rgb(207,45,209)'],
        [0.51373, 'rgb(210,47,207)'],
        [0.51765, 'rgb(213,49,205)'],
        [0.52157, 'rgb(216,51,203)'],
        [0.52549, 'rgb(219,53,201)'],
        [0.52941, 'rgb(222,55,199)'],
        [0.53333, 'rgb(225,57,197)'],
        [0.53725, 'rgb(228,59,195)'],
        [0.54118, 'rgb(232,61,193)'],
        [0.5451, 'rgb(235,63,191)'],
        [0.54902, 'rgb(238,65,189)'],
        [0.55294, 'rgb(241,67,187)'],
        [0.55686, 'rgb(244,69,185)'],
        [0.56078, 'rgb(247,71,183)'],
        [0.56471, 'rgb(250,73,181)'],
        [0.56863, 'rgb(253,75,179)'],
        [0.57255, 'rgb(255,77,177)'],
        [0.57647, 'rgb(255,79,175)'],
        [0.58039, 'rgb(255,81,173)'],
        [0.58431, 'rgb(255,83,171)'],
        [0.58824, 'rgb(255,85,169)'],
        [0.59216, 'rgb(255,87,167)'],
        [0.59608, 'rgb(255,89,165)'],
        [0.6, 'rgb(255,91,163)'],
        [0.60392, 'rgb(255,93,161)'],
        [0.60784, 'rgb(255,95,159)'],
        [0.61176, 'rgb(255,97,157)'],
        [0.61569, 'rgb(255,99,155)'],
        [0.61961, 'rgb(255,101,153)'],
        [0.62353, 'rgb(255,103,151)'],
        [0.62745, 'rgb(255,105,149)'],
        [0.63137, 'rgb(255,107,147)'],
        [0.63529, 'rgb(255,109,145)'],
        [0.63922, 'rgb(255,111,143)'],
        [0.64314, 'rgb(255,113,141)'],
        [0.64706, 'rgb(255,115,139)'],
        [0.65098, 'rgb(255,117,137)'],
        [0.6549, 'rgb(255,119,135)'],
        [0.65882, 'rgb(255,121,133)'],
        [0.66275, 'rgb(255,123,131)'],
        [0.66667, 'rgb(255,125,129)'],
        [0.67059, 'rgb(255,127,127)'],
        [0.67451, 'rgb(255,129,125)'],
        [0.67843, 'rgb(255,131,123)'],
        [0.68235, 'rgb(255,133,121)'],
        [0.68627, 'rgb(255,135,119)'],
        [0.6902, 'rgb(255,137,117)'],
        [0.69412, 'rgb(255,139,115)'],
        [0.69804, 'rgb(255,141,113)'],
        [0.70196, 'rgb(255,143,111)'],
        [0.70588, 'rgb(255,145,109)'],
        [0.7098, 'rgb(255,147,107)'],
        [0.71373, 'rgb(255,149,105)'],
        [0.71765, 'rgb(255,151,103)'],
        [0.72157, 'rgb(255,153,101)'],
        [0.72549, 'rgb(255,155,99)'],
        [0.72941, 'rgb(255,157,97)'],
        [0.73333, 'rgb(255,159,95)'],
        [0.73725, 'rgb(255,161,93)'],
        [0.74118, 'rgb(255,163,91)'],
        [0.7451, 'rgb(255,165,89)'],
        [0.74902, 'rgb(255,167,87)'],
        [0.75294, 'rgb(255,169,85)'],
        [0.75686, 'rgb(255,171,83)'],
        [0.76078, 'rgb(255,173,81)'],
        [0.76471, 'rgb(255,175,79)'],
        [0.76863, 'rgb(255,177,77)'],
        [0.77255, 'rgb(255,179,75)'],
        [0.77647, 'rgb(255,181,73)'],
        [0.78039, 'rgb(255,183,71)'],
        [0.78431, 'rgb(255,185,69)'],
        [0.78824, 'rgb(255,187,67)'],
        [0.79216, 'rgb(255,189,65)'],
        [0.79608, 'rgb(255,191,63)'],
        [0.8, 'rgb(255,193,61)'],
        [0.80392, 'rgb(255,195,59)'],
        [0.80784, 'rgb(255,197,57)'],
        [0.81176, 'rgb(255,199,55)'],
        [0.81569, 'rgb(255,201,53)'],
        [0.81961, 'rgb(255,203,51)'],
        [0.82353, 'rgb(255,205,49)'],
        [0.82745, 'rgb(255,207,47)'],
        [0.83137, 'rgb(255,209,45)'],
        [0.83529, 'rgb(255,211,43)'],
        [0.83922, 'rgb(255,213,41)'],
        [0.84314, 'rgb(255,215,39)'],
        [0.84706, 'rgb(255,217,37)'],
        [0.85098, 'rgb(255,219,35)'],
        [0.8549, 'rgb(255,221,33)'],
        [0.85882, 'rgb(255,223,31)'],
        [0.86275, 'rgb(255,225,29)'],
        [0.86667, 'rgb(255,227,27)'],
        [0.87059, 'rgb(255,229,25)'],
        [0.87451, 'rgb(255,231,23)'],
        [0.87843, 'rgb(255,233,21)'],
        [0.88235, 'rgb(255,235,19)'],
        [0.88627, 'rgb(255,237,17)'],
        [0.8902, 'rgb(255,239,15)'],
        [0.89412, 'rgb(255,241,13)'],
        [0.89804, 'rgb(255,243,11)'],
        [0.90196, 'rgb(255,245,9)'],
        [0.90588, 'rgb(255,247,7)'],
        [0.9098, 'rgb(255,249,5)'],
        [0.91373, 'rgb(255,251,3)'],
        [0.91765, 'rgb(255,253,1)'],
        [0.92157, 'rgb(255,255,4)'],
        [0.92549, 'rgb(255,255,17)'],
        [0.92941, 'rgb(255,255,29)'],
        [0.93333, 'rgb(255,255,42)'],
        [0.93725, 'rgb(255,255,54)'],
        [0.94118, 'rgb(255,255,67)'],
        [0.9451, 'rgb(255,255,79)'],
        [0.94902, 'rgb(255,255,92)'],
        [0.95294, 'rgb(255,255,104)'],
        [0.95686, 'rgb(255,255,117)'],
        [0.96078, 'rgb(255,255,130)'],
        [0.96471, 'rgb(255,255,142)'],
        [0.96863, 'rgb(255,255,154)'],
        [0.97255, 'rgb(255,255,167)'],
        [0.97647, 'rgb(255,255,179)'],
        [0.98039, 'rgb(255,255,192)'],
        [0.98431, 'rgb(255,255,204)'],
        [0.98824, 'rgb(255,255,217)'],
        [0.99216, 'rgb(255,255,230)'],
        [0.99608, 'rgb(255,255,242)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'nipy_spectral': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392, 'rgb(9,0,10)'],
        [0.00784, 'rgb(18,0,21)'],
        [0.01176, 'rgb(28,0,31)'],
        [0.01569, 'rgb(37,0,42)'],
        [0.01961, 'rgb(46,0,53)'],
        [0.02353, 'rgb(56,0,63)'],
        [0.02745, 'rgb(65,0,74)'],
        [0.03137, 'rgb(74,0,85)'],
        [0.03529, 'rgb(84,0,95)'],
        [0.03922, 'rgb(93,0,106)'],
        [0.04314, 'rgb(102,0,117)'],
        [0.04706, 'rgb(112,0,127)'],
        [0.05098, 'rgb(119,0,136)'],
        [0.0549, 'rgb(120,0,137)'],
        [0.05882, 'rgb(122,0,138)'],
        [0.06275, 'rgb(123,0,140)'],
        [0.06667, 'rgb(124,0,141)'],
        [0.07059, 'rgb(126,0,142)'],
        [0.07451, 'rgb(127,0,144)'],
        [0.07843, 'rgb(128,0,145)'],
        [0.08235, 'rgb(129,0,146)'],
        [0.08627, 'rgb(131,0,148)'],
        [0.0902, 'rgb(132,0,149)'],
        [0.09412, 'rgb(133,0,150)'],
        [0.09804, 'rgb(135,0,152)'],
        [0.10196, 'rgb(130,0,153)'],
        [0.10588, 'rgb(119,0,155)'],
        [0.1098, 'rgb(109,0,156)'],
        [0.11373, 'rgb(98,0,157)'],
        [0.11765, 'rgb(87,0,159)'],
        [0.12157, 'rgb(77,0,160)'],
        [0.12549, 'rgb(66,0,161)'],
        [0.12941, 'rgb(55,0,163)'],
        [0.13333, 'rgb(45,0,164)'],
        [0.13725, 'rgb(34,0,165)'],
        [0.14118, 'rgb(23,0,167)'],
        [0.1451, 'rgb(13,0,168)'],
        [0.14902, 'rgb(2,0,169)'],
        [0.15294, 'rgb(0,0,173)'],
        [0.15686, 'rgb(0,0,177)'],
        [0.16078, 'rgb(0,0,181)'],
        [0.16471, 'rgb(0,0,185)'],
        [0.16863, 'rgb(0,0,189)'],
        [0.17255, 'rgb(0,0,193)'],
        [0.17647, 'rgb(0,0,197)'],
        [0.18039, 'rgb(0,0,201)'],
        [0.18431, 'rgb(0,0,205)'],
        [0.18824, 'rgb(0,0,209)'],
        [0.19216, 'rgb(0,0,213)'],
        [0.19608, 'rgb(0,0,217)'],
        [0.2, 'rgb(0,0,221)'],
        [0.20392, 'rgb(0,9,221)'],
        [0.20784, 'rgb(0,18,221)'],
        [0.21176, 'rgb(0,28,221)'],
        [0.21569, 'rgb(0,37,221)'],
        [0.21961, 'rgb(0,46,221)'],
        [0.22353, 'rgb(0,56,221)'],
        [0.22745, 'rgb(0,65,221)'],
        [0.23137, 'rgb(0,74,221)'],
        [0.23529, 'rgb(0,84,221)'],
        [0.23922, 'rgb(0,93,221)'],
        [0.24314, 'rgb(0,102,221)'],
        [0.24706, 'rgb(0,112,221)'],
        [0.25098, 'rgb(0,119,221)'],
        [0.2549, 'rgb(0,122,221)'],
        [0.25882, 'rgb(0,125,221)'],
        [0.26275, 'rgb(0,127,221)'],
        [0.26667, 'rgb(0,130,221)'],
        [0.27059, 'rgb(0,133,221)'],
        [0.27451, 'rgb(0,135,221)'],
        [0.27843, 'rgb(0,138,221)'],
        [0.28235, 'rgb(0,141,221)'],
        [0.28627, 'rgb(0,143,221)'],
        [0.2902, 'rgb(0,146,221)'],
        [0.29412, 'rgb(0,149,221)'],
        [0.29804, 'rgb(0,151,221)'],
        [0.30196, 'rgb(0,153,219)'],
        [0.30588, 'rgb(0,155,215)'],
        [0.3098, 'rgb(0,156,211)'],
        [0.31373, 'rgb(0,157,207)'],
        [0.31765, 'rgb(0,159,203)'],
        [0.32157, 'rgb(0,160,199)'],
        [0.32549, 'rgb(0,161,195)'],
        [0.32941, 'rgb(0,163,191)'],
        [0.33333, 'rgb(0,164,187)'],
        [0.33725, 'rgb(0,165,183)'],
        [0.34118, 'rgb(0,167,179)'],
        [0.3451, 'rgb(0,168,175)'],
        [0.34902, 'rgb(0,169,171)'],
        [0.35294, 'rgb(0,170,168)'],
        [0.35686, 'rgb(0,170,165)'],
        [0.36078, 'rgb(0,170,162)'],
        [0.36471, 'rgb(0,170,160)'],
        [0.36863, 'rgb(0,170,157)'],
        [0.37255, 'rgb(0,170,154)'],
        [0.37647, 'rgb(0,170,151)'],
        [0.38039, 'rgb(0,170,149)'],
        [0.38431, 'rgb(0,170,146)'],
        [0.38824, 'rgb(0,170,143)'],
        [0.39216, 'rgb(0,170,141)'],
        [0.39608, 'rgb(0,170,138)'],
        [0.4, 'rgb(0,170,135)'],
        [0.40392, 'rgb(0,168,125)'],
        [0.40784, 'rgb(0,167,114)'],
        [0.41176, 'rgb(0,166,103)'],
        [0.41569, 'rgb(0,164,93)'],
        [0.41961, 'rgb(0,163,82)'],
        [0.42353, 'rgb(0,162,71)'],
        [0.42745, 'rgb(0,160,61)'],
        [0.43137, 'rgb(0,159,50)'],
        [0.43529, 'rgb(0,158,39)'],
        [0.43922, 'rgb(0,156,29)'],
        [0.44314, 'rgb(0,155,18)'],
        [0.44706, 'rgb(0,154,7)'],
        [0.45098, 'rgb(0,153,0)'],
        [0.4549, 'rgb(0,156,0)'],
        [0.45882, 'rgb(0,158,0)'],
        [0.46275, 'rgb(0,161,0)'],
        [0.46667, 'rgb(0,164,0)'],
        [0.47059, 'rgb(0,166,0)'],
        [0.47451, 'rgb(0,169,0)'],
        [0.47843, 'rgb(0,172,0)'],
        [0.48235, 'rgb(0,174,0)'],
        [0.48627, 'rgb(0,177,0)'],
        [0.4902, 'rgb(0,180,0)'],
        [0.49412, 'rgb(0,182,0)'],
        [0.49804, 'rgb(0,185,0)'],
        [0.50196, 'rgb(0,188,0)'],
        [0.50588, 'rgb(0,190,0)'],
        [0.5098, 'rgb(0,193,0)'],
        [0.51373, 'rgb(0,196,0)'],
        [0.51765, 'rgb(0,198,0)'],
        [0.52157, 'rgb(0,201,0)'],
        [0.52549, 'rgb(0,204,0)'],
        [0.52941, 'rgb(0,207,0)'],
        [0.53333, 'rgb(0,209,0)'],
        [0.53725, 'rgb(0,212,0)'],
        [0.54118, 'rgb(0,215,0)'],
        [0.5451, 'rgb(0,217,0)'],
        [0.54902, 'rgb(0,220,0)'],
        [0.55294, 'rgb(0,223,0)'],
        [0.55686, 'rgb(0,225,0)'],
        [0.56078, 'rgb(0,228,0)'],
        [0.56471, 'rgb(0,231,0)'],
        [0.56863, 'rgb(0,233,0)'],
        [0.57255, 'rgb(0,236,0)'],
        [0.57647, 'rgb(0,239,0)'],
        [0.58039, 'rgb(0,241,0)'],
        [0.58431, 'rgb(0,244,0)'],
        [0.58824, 'rgb(0,247,0)'],
        [0.59216, 'rgb(0,249,0)'],
        [0.59608, 'rgb(0,252,0)'],
        [0.6, 'rgb(0,255,0)'],
        [0.60392, 'rgb(14,255,0)'],
        [0.60784, 'rgb(29,255,0)'],
        [0.61176, 'rgb(43,255,0)'],
        [0.61569, 'rgb(58,255,0)'],
        [0.61961, 'rgb(73,255,0)'],
        [0.62353, 'rgb(87,255,0)'],
        [0.62745, 'rgb(102,255,0)'],
        [0.63137, 'rgb(117,255,0)'],
        [0.63529, 'rgb(131,255,0)'],
        [0.63922, 'rgb(146,255,0)'],
        [0.64314, 'rgb(161,255,0)'],
        [0.64706, 'rgb(175,255,0)'],
        [0.65098, 'rgb(187,254,0)'],
        [0.6549, 'rgb(191,253,0)'],
        [0.65882, 'rgb(195,251,0)'],
        [0.66275, 'rgb(199,250,0)'],
        [0.66667, 'rgb(203,249,0)'],
        [0.67059, 'rgb(207,247,0)'],
        [0.67451, 'rgb(211,246,0)'],
        [0.67843, 'rgb(215,245,0)'],
        [0.68235, 'rgb(219,243,0)'],
        [0.68627, 'rgb(223,242,0)'],
        [0.6902, 'rgb(227,241,0)'],
        [0.69412, 'rgb(231,239,0)'],
        [0.69804, 'rgb(235,238,0)'],
        [0.70196, 'rgb(238,236,0)'],
        [0.70588, 'rgb(239,233,0)'],
        [0.7098, 'rgb(241,231,0)'],
        [0.71373, 'rgb(242,228,0)'],
        [0.71765, 'rgb(243,225,0)'],
        [0.72157, 'rgb(245,223,0)'],
        [0.72549, 'rgb(246,220,0)'],
        [0.72941, 'rgb(247,217,0)'],
        [0.73333, 'rgb(249,215,0)'],
        [0.73725, 'rgb(250,212,0)'],
        [0.74118, 'rgb(251,209,0)'],
        [0.7451, 'rgb(253,207,0)'],
        [0.74902, 'rgb(254,204,0)'],
        [0.75294, 'rgb(255,201,0)'],
        [0.75686, 'rgb(255,197,0)'],
        [0.76078, 'rgb(255,193,0)'],
        [0.76471, 'rgb(255,189,0)'],
        [0.76863, 'rgb(255,185,0)'],
        [0.77255, 'rgb(255,181,0)'],
        [0.77647, 'rgb(255,177,0)'],
        [0.78039, 'rgb(255,173,0)'],
        [0.78431, 'rgb(255,169,0)'],
        [0.78824, 'rgb(255,165,0)'],
        [0.79216, 'rgb(255,161,0)'],
        [0.79608, 'rgb(255,157,0)'],
        [0.8, 'rgb(255,153,0)'],
        [0.80392, 'rgb(255,141,0)'],
        [0.80784, 'rgb(255,129,0)'],
        [0.81176, 'rgb(255,117,0)'],
        [0.81569, 'rgb(255,105,0)'],
        [0.81961, 'rgb(255,93,0)'],
        [0.82353, 'rgb(255,81,0)'],
        [0.82745, 'rgb(255,69,0)'],
        [0.83137, 'rgb(255,57,0)'],
        [0.83529, 'rgb(255,44,0)'],
        [0.83922, 'rgb(255,32,0)'],
        [0.84314, 'rgb(255,20,0)'],
        [0.84706, 'rgb(255,8,0)'],
        [0.85098, 'rgb(254,0,0)'],
        [0.8549, 'rgb(251,0,0)'],
        [0.85882, 'rgb(249,0,0)'],
        [0.86275, 'rgb(246,0,0)'],
        [0.86667, 'rgb(243,0,0)'],
        [0.87059, 'rgb(241,0,0)'],
        [0.87451, 'rgb(238,0,0)'],
        [0.87843, 'rgb(235,0,0)'],
        [0.88235, 'rgb(233,0,0)'],
        [0.88627, 'rgb(230,0,0)'],
        [0.8902, 'rgb(227,0,0)'],
        [0.89412, 'rgb(225,0,0)'],
        [0.89804, 'rgb(222,0,0)'],
        [0.90196, 'rgb(220,0,0)'],
        [0.90588, 'rgb(219,0,0)'],
        [0.9098, 'rgb(217,0,0)'],
        [0.91373, 'rgb(216,0,0)'],
        [0.91765, 'rgb(215,0,0)'],
        [0.92157, 'rgb(213,0,0)'],
        [0.92549, 'rgb(212,0,0)'],
        [0.92941, 'rgb(211,0,0)'],
        [0.93333, 'rgb(209,0,0)'],
        [0.93725, 'rgb(208,0,0)'],
        [0.94118, 'rgb(207,0,0)'],
        [0.9451, 'rgb(205,0,0)'],
        [0.94902, 'rgb(204,0,0)'],
        [0.95294, 'rgb(204,12,12)'],
        [0.95686, 'rgb(204,27,27)'],
        [0.96078, 'rgb(204,44,44)'],
        [0.96471, 'rgb(204,60,60)'],
        [0.96863, 'rgb(204,76,76)'],
        [0.97255, 'rgb(204,92,92)'],
        [0.97647, 'rgb(204,108,108)'],
        [0.98039, 'rgb(204,124,124)'],
        [0.98431, 'rgb(204,140,140)'],
        [0.98824, 'rgb(204,156,156)'],
        [0.99216, 'rgb(204,172,172)'],
        [0.99608, 'rgb(204,188,188)'],
        [1.0, 'rgb(204,204,204)'],
    ],
    'ocean': [
        [0.0, 'rgb(0,127,0)'],
        [0.00392, 'rgb(0,126,1)'],
        [0.00784, 'rgb(0,124,2)'],
        [0.01176, 'rgb(0,123,3)'],
        [0.01569, 'rgb(0,121,4)'],
        [0.01961, 'rgb(0,120,5)'],
        [0.02353, 'rgb(0,118,6)'],
        [0.02745, 'rgb(0,117,7)'],
        [0.03137, 'rgb(0,115,8)'],
        [0.03529, 'rgb(0,114,9)'],
        [0.03922, 'rgb(0,112,10)'],
        [0.04314, 'rgb(0,111,11)'],
        [0.04706, 'rgb(0,109,12)'],
        [0.05098, 'rgb(0,108,13)'],
        [0.0549, 'rgb(0,106,14)'],
        [0.05882, 'rgb(0,105,15)'],
        [0.06275, 'rgb(0,103,16)'],
        [0.06667, 'rgb(0,102,17)'],
        [0.07059, 'rgb(0,100,18)'],
        [0.07451, 'rgb(0,99,19)'],
        [0.07843, 'rgb(0,97,20)'],
        [0.08235, 'rgb(0,96,21)'],
        [0.08627, 'rgb(0,94,22)'],
        [0.0902, 'rgb(0,93,23)'],
        [0.09412, 'rgb(0,91,24)'],
        [0.09804, 'rgb(0,89,25)'],
        [0.10196, 'rgb(0,88,26)'],
        [0.10588, 'rgb(0,87,27)'],
        [0.1098, 'rgb(0,85,28)'],
        [0.11373, 'rgb(0,84,29)'],
        [0.11765, 'rgb(0,82,30)'],
        [0.12157, 'rgb(0,81,31)'],
        [0.12549, 'rgb(0,79,32)'],
        [0.12941, 'rgb(0,78,32)'],
        [0.13333, 'rgb(0,76,34)'],
        [0.13725, 'rgb(0,74,35)'],
        [0.14118, 'rgb(0,73,36)'],
        [0.1451, 'rgb(0,72,36)'],
        [0.14902, 'rgb(0,70,38)'],
        [0.15294, 'rgb(0,69,39)'],
        [0.15686, 'rgb(0,67,40)'],
        [0.16078, 'rgb(0,66,40)'],
        [0.16471, 'rgb(0,64,42)'],
        [0.16863, 'rgb(0,63,43)'],
        [0.17255, 'rgb(0,61,44)'],
        [0.17647, 'rgb(0,60,44)'],
        [0.18039, 'rgb(0,58,46)'],
        [0.18431, 'rgb(0,56,47)'],
        [0.18824, 'rgb(0,55,48)'],
        [0.19216, 'rgb(0,54,48)'],
        [0.19608, 'rgb(0,52,50)'],
        [0.2, 'rgb(0,50,51)'],
        [0.20392, 'rgb(0,49,52)'],
        [0.20784, 'rgb(0,48,52)'],
        [0.21176, 'rgb(0,46,54)'],
        [0.21569, 'rgb(0,44,55)'],
        [0.21961, 'rgb(0,43,56)'],
        [0.22353, 'rgb(0,42,56)'],
        [0.22745, 'rgb(0,40,58)'],
        [0.23137, 'rgb(0,39,59)'],
        [0.23529, 'rgb(0,37,60)'],
        [0.23922, 'rgb(0,36,60)'],
        [0.24314, 'rgb(0,34,62)'],
        [0.24706, 'rgb(0,32,63)'],
        [0.25098, 'rgb(0,31,64)'],
        [0.2549, 'rgb(0,30,65)'],
        [0.25882, 'rgb(0,28,65)'],
        [0.26275, 'rgb(0,26,67)'],
        [0.26667, 'rgb(0,25,68)'],
        [0.27059, 'rgb(0,24,69)'],
        [0.27451, 'rgb(0,22,70)'],
        [0.27843, 'rgb(0,20,71)'],
        [0.28235, 'rgb(0,19,72)'],
        [0.28627, 'rgb(0,18,73)'],
        [0.2902, 'rgb(0,16,73)'],
        [0.29412, 'rgb(0,15,75)'],
        [0.29804, 'rgb(0,13,76)'],
        [0.30196, 'rgb(0,12,77)'],
        [0.30588, 'rgb(0,10,78)'],
        [0.3098, 'rgb(0,8,79)'],
        [0.31373, 'rgb(0,7,80)'],
        [0.31765, 'rgb(0,6,81)'],
        [0.32157, 'rgb(0,4,81)'],
        [0.32549, 'rgb(0,2,83)'],
        [0.32941, 'rgb(0,1,84)'],
        [0.33333, 'rgb(0,0,85)'],
        [0.33725, 'rgb(0,1,86)'],
        [0.34118, 'rgb(0,2,87)'],
        [0.3451, 'rgb(0,4,88)'],
        [0.34902, 'rgb(0,5,89)'],
        [0.35294, 'rgb(0,7,89)'],
        [0.35686, 'rgb(0,8,91)'],
        [0.36078, 'rgb(0,10,92)'],
        [0.36471, 'rgb(0,11,93)'],
        [0.36863, 'rgb(0,13,94)'],
        [0.37255, 'rgb(0,15,95)'],
        [0.37647, 'rgb(0,16,96)'],
        [0.38039, 'rgb(0,17,97)'],
        [0.38431, 'rgb(0,19,97)'],
        [0.38824, 'rgb(0,21,99)'],
        [0.39216, 'rgb(0,22,100)'],
        [0.39608, 'rgb(0,24,101)'],
        [0.4, 'rgb(0,25,102)'],
        [0.40392, 'rgb(0,27,103)'],
        [0.40784, 'rgb(0,28,104)'],
        [0.41176, 'rgb(0,30,105)'],
        [0.41569, 'rgb(0,31,105)'],
        [0.41961, 'rgb(0,32,107)'],
        [0.42353, 'rgb(0,34,108)'],
        [0.42745, 'rgb(0,35,109)'],
        [0.43137, 'rgb(0,37,110)'],
        [0.43529, 'rgb(0,39,111)'],
        [0.43922, 'rgb(0,40,112)'],
        [0.44314, 'rgb(0,41,113)'],
        [0.44706, 'rgb(0,43,113)'],
        [0.45098, 'rgb(0,45,115)'],
        [0.4549, 'rgb(0,46,116)'],
        [0.45882, 'rgb(0,48,117)'],
        [0.46275, 'rgb(0,49,118)'],
        [0.46667, 'rgb(0,50,119)'],
        [0.47059, 'rgb(0,52,120)'],
        [0.47451, 'rgb(0,53,121)'],
        [0.47843, 'rgb(0,55,121)'],
        [0.48235, 'rgb(0,56,123)'],
        [0.48627, 'rgb(0,58,124)'],
        [0.4902, 'rgb(0,59,125)'],
        [0.49412, 'rgb(0,61,126)'],
        [0.49804, 'rgb(0,63,127)'],
        [0.50196, 'rgb(0,64,128)'],
        [0.50588, 'rgb(0,65,129)'],
        [0.5098, 'rgb(0,67,130)'],
        [0.51373, 'rgb(0,68,131)'],
        [0.51765, 'rgb(0,70,131)'],
        [0.52157, 'rgb(0,72,133)'],
        [0.52549, 'rgb(0,73,134)'],
        [0.52941, 'rgb(0,75,135)'],
        [0.53333, 'rgb(0,76,136)'],
        [0.53725, 'rgb(0,78,137)'],
        [0.54118, 'rgb(0,79,138)'],
        [0.5451, 'rgb(0,81,139)'],
        [0.54902, 'rgb(0,82,140)'],
        [0.55294, 'rgb(0,84,141)'],
        [0.55686, 'rgb(0,85,142)'],
        [0.56078, 'rgb(0,87,143)'],
        [0.56471, 'rgb(0,88,144)'],
        [0.56863, 'rgb(0,89,145)'],
        [0.57255, 'rgb(0,91,146)'],
        [0.57647, 'rgb(0,92,147)'],
        [0.58039, 'rgb(0,94,147)'],
        [0.58431, 'rgb(0,96,149)'],
        [0.58824, 'rgb(0,97,150)'],
        [0.59216, 'rgb(0,98,151)'],
        [0.59608, 'rgb(0,100,152)'],
        [0.6, 'rgb(0,101,153)'],
        [0.60392, 'rgb(0,103,154)'],
        [0.60784, 'rgb(0,104,155)'],
        [0.61176, 'rgb(0,106,156)'],
        [0.61569, 'rgb(0,108,157)'],
        [0.61961, 'rgb(0,109,158)'],
        [0.62353, 'rgb(0,111,159)'],
        [0.62745, 'rgb(0,112,160)'],
        [0.63137, 'rgb(0,113,161)'],
        [0.63529, 'rgb(0,115,162)'],
        [0.63922, 'rgb(0,116,163)'],
        [0.64314, 'rgb(0,118,163)'],
        [0.64706, 'rgb(0,120,165)'],
        [0.65098, 'rgb(0,121,166)'],
        [0.6549, 'rgb(0,123,167)'],
        [0.65882, 'rgb(0,124,168)'],
        [0.66275, 'rgb(0,126,169)'],
        [0.66667, 'rgb(0,127,170)'],
        [0.67059, 'rgb(2,129,171)'],
        [0.67451, 'rgb(5,130,172)'],
        [0.67843, 'rgb(8,131,173)'],
        [0.68235, 'rgb(11,133,174)'],
        [0.68627, 'rgb(14,134,175)'],
        [0.6902, 'rgb(17,136,176)'],
        [0.69412, 'rgb(20,137,177)'],
        [0.69804, 'rgb(23,139,178)'],
        [0.70196, 'rgb(26,140,179)'],
        [0.70588, 'rgb(29,142,179)'],
        [0.7098, 'rgb(32,144,181)'],
        [0.71373, 'rgb(35,145,182)'],
        [0.71765, 'rgb(38,147,183)'],
        [0.72157, 'rgb(41,148,184)'],
        [0.72549, 'rgb(44,149,185)'],
        [0.72941, 'rgb(47,151,186)'],
        [0.73333, 'rgb(50,152,187)'],
        [0.73725, 'rgb(54,154,188)'],
        [0.74118, 'rgb(57,156,189)'],
        [0.7451, 'rgb(60,157,190)'],
        [0.74902, 'rgb(63,159,191)'],
        [0.75294, 'rgb(65,160,192)'],
        [0.75686, 'rgb(68,162,193)'],
        [0.76078, 'rgb(71,163,194)'],
        [0.76471, 'rgb(74,164,195)'],
        [0.76863, 'rgb(77,166,195)'],
        [0.77255, 'rgb(81,168,197)'],
        [0.77647, 'rgb(84,169,198)'],
        [0.78039, 'rgb(87,171,199)'],
        [0.78431, 'rgb(90,172,200)'],
        [0.78824, 'rgb(93,174,201)'],
        [0.79216, 'rgb(96,175,202)'],
        [0.79608, 'rgb(98,177,203)'],
        [0.8, 'rgb(102,178,204)'],
        [0.80392, 'rgb(105,180,205)'],
        [0.80784, 'rgb(108,181,206)'],
        [0.81176, 'rgb(111,183,207)'],
        [0.81569, 'rgb(114,184,208)'],
        [0.81961, 'rgb(117,186,209)'],
        [0.82353, 'rgb(120,187,210)'],
        [0.82745, 'rgb(123,189,211)'],
        [0.83137, 'rgb(126,190,211)'],
        [0.83529, 'rgb(129,192,213)'],
        [0.83922, 'rgb(131,193,214)'],
        [0.84314, 'rgb(134,195,215)'],
        [0.84706, 'rgb(137,196,216)'],
        [0.85098, 'rgb(140,197,217)'],
        [0.8549, 'rgb(143,199,218)'],
        [0.85882, 'rgb(146,200,219)'],
        [0.86275, 'rgb(150,202,220)'],
        [0.86667, 'rgb(153,204,221)'],
        [0.87059, 'rgb(156,205,222)'],
        [0.87451, 'rgb(159,207,223)'],
        [0.87843, 'rgb(162,208,224)'],
        [0.88235, 'rgb(164,210,225)'],
        [0.88627, 'rgb(167,211,226)'],
        [0.8902, 'rgb(170,212,227)'],
        [0.89412, 'rgb(173,214,227)'],
        [0.89804, 'rgb(177,216,229)'],
        [0.90196, 'rgb(180,217,230)'],
        [0.90588, 'rgb(183,219,231)'],
        [0.9098, 'rgb(186,220,232)'],
        [0.91373, 'rgb(189,222,233)'],
        [0.91765, 'rgb(192,223,234)'],
        [0.92157, 'rgb(195,225,235)'],
        [0.92549, 'rgb(197,226,236)'],
        [0.92941, 'rgb(200,227,237)'],
        [0.93333, 'rgb(203,229,238)'],
        [0.93725, 'rgb(206,230,239)'],
        [0.94118, 'rgb(209,232,240)'],
        [0.9451, 'rgb(212,233,241)'],
        [0.94902, 'rgb(215,235,242)'],
        [0.95294, 'rgb(218,236,243)'],
        [0.95686, 'rgb(221,238,243)'],
        [0.96078, 'rgb(225,240,245)'],
        [0.96471, 'rgb(227,241,246)'],
        [0.96863, 'rgb(230,243,247)'],
        [0.97255, 'rgb(233,244,248)'],
        [0.97647, 'rgb(236,245,249)'],
        [0.98039, 'rgb(239,247,250)'],
        [0.98431, 'rgb(242,248,251)'],
        [0.98824, 'rgb(246,250,252)'],
        [0.99216, 'rgb(249,252,253)'],
        [0.99608, 'rgb(252,253,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'pink': [
        [0.0, 'rgb(30,0,0)'],
        [0.00392, 'rgb(34,6,6)'],
        [0.00784, 'rgb(39,12,12)'],
        [0.01176, 'rgb(44,19,19)'],
        [0.01569, 'rgb(49,25,25)'],
        [0.01961, 'rgb(53,28,28)'],
        [0.02353, 'rgb(56,31,31)'],
        [0.02745, 'rgb(60,34,34)'],
        [0.03137, 'rgb(63,36,36)'],
        [0.03529, 'rgb(66,38,38)'],
        [0.03922, 'rgb(69,41,41)'],
        [0.04314, 'rgb(72,43,43)'],
        [0.04706, 'rgb(74,45,45)'],
        [0.05098, 'rgb(77,46,46)'],
        [0.0549, 'rgb(79,48,48)'],
        [0.05882, 'rgb(82,50,50)'],
        [0.06275, 'rgb(84,52,52)'],
        [0.06667, 'rgb(87,53,53)'],
        [0.07059, 'rgb(89,55,55)'],
        [0.07451, 'rgb(91,56,56)'],
        [0.07843, 'rgb(93,58,58)'],
        [0.08235, 'rgb(95,59,59)'],
        [0.08627, 'rgb(97,61,61)'],
        [0.0902, 'rgb(99,62,62)'],
        [0.09412, 'rgb(101,63,63)'],
        [0.09804, 'rgb(103,65,65)'],
        [0.10196, 'rgb(105,66,66)'],
        [0.10588, 'rgb(107,67,67)'],
        [0.1098, 'rgb(109,68,68)'],
        [0.11373, 'rgb(110,70,70)'],
        [0.11765, 'rgb(112,71,71)'],
        [0.12157, 'rgb(114,72,72)'],
        [0.12549, 'rgb(116,73,73)'],
        [0.12941, 'rgb(117,74,74)'],
        [0.13333, 'rgb(119,75,75)'],
        [0.13725, 'rgb(121,77,77)'],
        [0.14118, 'rgb(122,78,78)'],
        [0.1451, 'rgb(124,79,79)'],
        [0.14902, 'rgb(125,80,80)'],
        [0.15294, 'rgb(127,81,81)'],
        [0.15686, 'rgb(128,82,82)'],
        [0.16078, 'rgb(130,83,83)'],
        [0.16471, 'rgb(131,84,84)'],
        [0.16863, 'rgb(133,85,85)'],
        [0.17255, 'rgb(134,86,86)'],
        [0.17647, 'rgb(136,87,87)'],
        [0.18039, 'rgb(137,88,88)'],
        [0.18431, 'rgb(139,89,89)'],
        [0.18824, 'rgb(140,90,90)'],
        [0.19216, 'rgb(141,91,91)'],
        [0.19608, 'rgb(143,92,92)'],
        [0.2, 'rgb(144,93,93)'],
        [0.20392, 'rgb(146,94,94)'],
        [0.20784, 'rgb(147,94,94)'],
        [0.21176, 'rgb(148,95,95)'],
        [0.21569, 'rgb(150,96,96)'],
        [0.21961, 'rgb(151,97,97)'],
        [0.22353, 'rgb(152,98,98)'],
        [0.22745, 'rgb(153,99,99)'],
        [0.23137, 'rgb(155,100,100)'],
        [0.23529, 'rgb(156,100,100)'],
        [0.23922, 'rgb(157,101,101)'],
        [0.24314, 'rgb(158,102,102)'],
        [0.24706, 'rgb(160,103,103)'],
        [0.25098, 'rgb(161,104,104)'],
        [0.2549, 'rgb(162,105,105)'],
        [0.25882, 'rgb(163,105,105)'],
        [0.26275, 'rgb(165,106,106)'],
        [0.26667, 'rgb(166,107,107)'],
        [0.27059, 'rgb(167,108,108)'],
        [0.27451, 'rgb(168,109,109)'],
        [0.27843, 'rgb(169,109,109)'],
        [0.28235, 'rgb(170,110,110)'],
        [0.28627, 'rgb(172,111,111)'],
        [0.2902, 'rgb(173,112,112)'],
        [0.29412, 'rgb(174,112,112)'],
        [0.29804, 'rgb(175,113,113)'],
        [0.30196, 'rgb(176,114,114)'],
        [0.30588, 'rgb(177,115,115)'],
        [0.3098, 'rgb(178,115,115)'],
        [0.31373, 'rgb(179,116,116)'],
        [0.31765, 'rgb(180,117,117)'],
        [0.32157, 'rgb(182,118,118)'],
        [0.32549, 'rgb(183,118,118)'],
        [0.32941, 'rgb(184,119,119)'],
        [0.33333, 'rgb(185,120,120)'],
        [0.33725, 'rgb(186,120,120)'],
        [0.34118, 'rgb(187,121,121)'],
        [0.3451, 'rgb(188,122,122)'],
        [0.34902, 'rgb(189,123,123)'],
        [0.35294, 'rgb(190,123,123)'],
        [0.35686, 'rgb(191,124,124)'],
        [0.36078, 'rgb(192,125,125)'],
        [0.36471, 'rgb(193,125,125)'],
        [0.36863, 'rgb(194,127,126)'],
        [0.37255, 'rgb(194,128,127)'],
        [0.37647, 'rgb(194,130,127)'],
        [0.38039, 'rgb(195,131,128)'],
        [0.38431, 'rgb(195,133,129)'],
        [0.38824, 'rgb(196,134,129)'],
        [0.39216, 'rgb(196,136,130)'],
        [0.39608, 'rgb(197,137,131)'],
        [0.4, 'rgb(197,139,131)'],
        [0.40392, 'rgb(197,140,132)'],
        [0.40784, 'rgb(198,141,132)'],
        [0.41176, 'rgb(198,143,133)'],
        [0.41569, 'rgb(199,144,134)'],
        [0.41961, 'rgb(199,145,134)'],
        [0.42353, 'rgb(200,147,135)'],
        [0.42745, 'rgb(200,148,136)'],
        [0.43137, 'rgb(200,149,136)'],
        [0.43529, 'rgb(201,151,137)'],
        [0.43922, 'rgb(201,152,137)'],
        [0.44314, 'rgb(202,153,138)'],
        [0.44706, 'rgb(202,155,139)'],
        [0.45098, 'rgb(203,156,139)'],
        [0.4549, 'rgb(203,157,140)'],
        [0.45882, 'rgb(203,158,141)'],
        [0.46275, 'rgb(204,160,141)'],
        [0.46667, 'rgb(204,161,142)'],
        [0.47059, 'rgb(205,162,142)'],
        [0.47451, 'rgb(205,163,143)'],
        [0.47843, 'rgb(205,164,144)'],
        [0.48235, 'rgb(206,166,144)'],
        [0.48627, 'rgb(206,167,145)'],
        [0.4902, 'rgb(207,168,145)'],
        [0.49412, 'rgb(207,169,146)'],
        [0.49804, 'rgb(208,170,146)'],
        [0.50196, 'rgb(208,171,147)'],
        [0.50588, 'rgb(208,173,148)'],
        [0.5098, 'rgb(209,174,148)'],
        [0.51373, 'rgb(209,175,149)'],
        [0.51765, 'rgb(210,176,149)'],
        [0.52157, 'rgb(210,177,150)'],
        [0.52549, 'rgb(210,178,150)'],
        [0.52941, 'rgb(211,179,151)'],
        [0.53333, 'rgb(211,180,152)'],
        [0.53725, 'rgb(212,181,152)'],
        [0.54118, 'rgb(212,182,153)'],
        [0.5451, 'rgb(212,184,153)'],
        [0.54902, 'rgb(213,185,154)'],
        [0.55294, 'rgb(213,186,154)'],
        [0.55686, 'rgb(214,187,155)'],
        [0.56078, 'rgb(214,188,155)'],
        [0.56471, 'rgb(214,189,156)'],
        [0.56863, 'rgb(215,190,157)'],
        [0.57255, 'rgb(215,191,157)'],
        [0.57647, 'rgb(216,192,158)'],
        [0.58039, 'rgb(216,193,158)'],
        [0.58431, 'rgb(216,194,159)'],
        [0.58824, 'rgb(217,195,159)'],
        [0.59216, 'rgb(217,196,160)'],
        [0.59608, 'rgb(217,197,160)'],
        [0.6, 'rgb(218,198,161)'],
        [0.60392, 'rgb(218,199,161)'],
        [0.60784, 'rgb(219,200,162)'],
        [0.61176, 'rgb(219,201,162)'],
        [0.61569, 'rgb(219,202,163)'],
        [0.61961, 'rgb(220,203,163)'],
        [0.62353, 'rgb(220,204,164)'],
        [0.62745, 'rgb(221,205,164)'],
        [0.63137, 'rgb(221,206,165)'],
        [0.63529, 'rgb(221,207,165)'],
        [0.63922, 'rgb(222,208,166)'],
        [0.64314, 'rgb(222,209,166)'],
        [0.64706, 'rgb(222,209,167)'],
        [0.65098, 'rgb(223,210,167)'],
        [0.6549, 'rgb(223,211,168)'],
        [0.65882, 'rgb(224,212,168)'],
        [0.66275, 'rgb(224,213,169)'],
        [0.66667, 'rgb(224,214,170)'],
        [0.67059, 'rgb(225,215,170)'],
        [0.67451, 'rgb(225,216,170)'],
        [0.67843, 'rgb(226,217,171)'],
        [0.68235, 'rgb(226,218,171)'],
        [0.68627, 'rgb(226,219,172)'],
        [0.6902, 'rgb(227,220,172)'],
        [0.69412, 'rgb(227,220,173)'],
        [0.69804, 'rgb(227,221,173)'],
        [0.70196, 'rgb(228,222,174)'],
        [0.70588, 'rgb(228,223,174)'],
        [0.7098, 'rgb(229,224,175)'],
        [0.71373, 'rgb(229,225,175)'],
        [0.71765, 'rgb(229,226,176)'],
        [0.72157, 'rgb(230,227,176)'],
        [0.72549, 'rgb(230,227,177)'],
        [0.72941, 'rgb(230,228,177)'],
        [0.73333, 'rgb(231,229,178)'],
        [0.73725, 'rgb(231,230,178)'],
        [0.74118, 'rgb(231,231,179)'],
        [0.7451, 'rgb(232,232,179)'],
        [0.74902, 'rgb(232,232,180)'],
        [0.75294, 'rgb(233,233,182)'],
        [0.75686, 'rgb(233,233,183)'],
        [0.76078, 'rgb(233,233,185)'],
        [0.76471, 'rgb(234,234,186)'],
        [0.76863, 'rgb(234,234,187)'],
        [0.77255, 'rgb(234,234,189)'],
        [0.77647, 'rgb(235,235,190)'],
        [0.78039, 'rgb(235,235,191)'],
        [0.78431, 'rgb(235,235,193)'],
        [0.78824, 'rgb(236,236,194)'],
        [0.79216, 'rgb(236,236,195)'],
        [0.79608, 'rgb(237,237,196)'],
        [0.8, 'rgb(237,237,198)'],
        [0.80392, 'rgb(237,237,199)'],
        [0.80784, 'rgb(238,238,200)'],
        [0.81176, 'rgb(238,238,201)'],
        [0.81569, 'rgb(238,238,203)'],
        [0.81961, 'rgb(239,239,204)'],
        [0.82353, 'rgb(239,239,205)'],
        [0.82745, 'rgb(239,239,206)'],
        [0.83137, 'rgb(240,240,208)'],
        [0.83529, 'rgb(240,240,209)'],
        [0.83922, 'rgb(240,240,210)'],
        [0.84314, 'rgb(241,241,211)'],
        [0.84706, 'rgb(241,241,212)'],
        [0.85098, 'rgb(242,242,214)'],
        [0.8549, 'rgb(242,242,215)'],
        [0.85882, 'rgb(242,242,216)'],
        [0.86275, 'rgb(243,243,217)'],
        [0.86667, 'rgb(243,243,218)'],
        [0.87059, 'rgb(243,243,219)'],
        [0.87451, 'rgb(244,244,221)'],
        [0.87843, 'rgb(244,244,222)'],
        [0.88235, 'rgb(244,244,223)'],
        [0.88627, 'rgb(245,245,224)'],
        [0.8902, 'rgb(245,245,225)'],
        [0.89412, 'rgb(245,245,226)'],
        [0.89804, 'rgb(246,246,227)'],
        [0.90196, 'rgb(246,246,228)'],
        [0.90588, 'rgb(246,246,230)'],
        [0.9098, 'rgb(247,247,231)'],
        [0.91373, 'rgb(247,247,232)'],
        [0.91765, 'rgb(247,247,233)'],
        [0.92157, 'rgb(248,248,234)'],
        [0.92549, 'rgb(248,248,235)'],
        [0.92941, 'rgb(248,248,236)'],
        [0.93333, 'rgb(249,249,237)'],
        [0.93725, 'rgb(249,249,238)'],
        [0.94118, 'rgb(249,249,239)'],
        [0.9451, 'rgb(250,250,240)'],
        [0.94902, 'rgb(250,250,241)'],
        [0.95294, 'rgb(250,250,242)'],
        [0.95686, 'rgb(251,251,243)'],
        [0.96078, 'rgb(251,251,244)'],
        [0.96471, 'rgb(251,251,245)'],
        [0.96863, 'rgb(252,252,246)'],
        [0.97255, 'rgb(252,252,247)'],
        [0.97647, 'rgb(252,252,248)'],
        [0.98039, 'rgb(253,253,249)'],
        [0.98431, 'rgb(253,253,251)'],
        [0.98824, 'rgb(253,253,252)'],
        [0.99216, 'rgb(254,254,253)'],
        [0.99608, 'rgb(254,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'prism': [
        [0.0, 'rgb(255,0,0)'],
        [0.00392, 'rgb(255,0,0)'],
        [0.00784, 'rgb(255,33,0)'],
        [0.01176, 'rgb(255,81,0)'],
        [0.01569, 'rgb(255,130,0)'],
        [0.01961, 'rgb(255,176,0)'],
        [0.02353, 'rgb(255,215,0)'],
        [0.02745, 'rgb(255,246,0)'],
        [0.03137, 'rgb(226,255,0)'],
        [0.03529, 'rgb(178,255,0)'],
        [0.03922, 'rgb(129,255,0)'],
        [0.04314, 'rgb(83,254,0)'],
        [0.04706, 'rgb(42,226,0)'],
        [0.05098, 'rgb(10,188,57)'],
        [0.0549, 'rgb(0,144,125)'],
        [0.05882, 'rgb(0,96,185)'],
        [0.06275, 'rgb(0,47,232)'],
        [0.06667, 'rgb(0,0,255)'],
        [0.07059, 'rgb(25,0,255)'],
        [0.07451, 'rgb(61,0,255)'],
        [0.07843, 'rgb(105,0,254)'],
        [0.08235, 'rgb(153,0,215)'],
        [0.08627, 'rgb(202,0,162)'],
        [0.0902, 'rgb(249,0,99)'],
        [0.09412, 'rgb(255,0,28)'],
        [0.09804, 'rgb(255,0,0)'],
        [0.10196, 'rgb(255,14,0)'],
        [0.10588, 'rgb(255,61,0)'],
        [0.1098, 'rgb(255,111,0)'],
        [0.11373, 'rgb(255,158,0)'],
        [0.11765, 'rgb(255,200,0)'],
        [0.12157, 'rgb(255,235,0)'],
        [0.12549, 'rgb(245,255,0)'],
        [0.12941, 'rgb(197,255,0)'],
        [0.13333, 'rgb(148,255,0)'],
        [0.13725, 'rgb(101,255,0)'],
        [0.14118, 'rgb(58,238,0)'],
        [0.1451, 'rgb(22,204,28)'],
        [0.14902, 'rgb(0,163,98)'],
        [0.15294, 'rgb(0,116,162)'],
        [0.15686, 'rgb(0,67,215)'],
        [0.16078, 'rgb(0,19,253)'],
        [0.16471, 'rgb(13,0,255)'],
        [0.16863, 'rgb(46,0,255)'],
        [0.17255, 'rgb(87,0,255)'],
        [0.17647, 'rgb(133,0,232)'],
        [0.18039, 'rgb(182,0,185)'],
        [0.18431, 'rgb(231,0,125)'],
        [0.18824, 'rgb(255,0,57)'],
        [0.19216, 'rgb(255,0,0)'],
        [0.19608, 'rgb(255,0,0)'],
        [0.2, 'rgb(255,42,0)'],
        [0.20392, 'rgb(255,91,0)'],
        [0.20784, 'rgb(255,139,0)'],
        [0.21176, 'rgb(255,184,0)'],
        [0.21569, 'rgb(255,222,0)'],
        [0.21961, 'rgb(255,251,0)'],
        [0.22353, 'rgb(217,255,0)'],
        [0.22745, 'rgb(168,255,0)'],
        [0.23137, 'rgb(119,255,0)'],
        [0.23529, 'rgb(74,249,0)'],
        [0.23922, 'rgb(35,219,0)'],
        [0.24314, 'rgb(5,180,71)'],
        [0.24706, 'rgb(0,135,137)'],
        [0.25098, 'rgb(0,86,195)'],
        [0.2549, 'rgb(0,38,240)'],
        [0.25882, 'rgb(3,0,255)'],
        [0.26275, 'rgb(32,0,255)'],
        [0.26667, 'rgb(70,0,255)'],
        [0.27059, 'rgb(114,0,247)'],
        [0.27451, 'rgb(163,0,206)'],
        [0.27843, 'rgb(212,0,150)'],
        [0.28235, 'rgb(255,0,85)'],
        [0.28627, 'rgb(255,0,14)'],
        [0.2902, 'rgb(255,0,0)'],
        [0.29412, 'rgb(255,23,0)'],
        [0.29804, 'rgb(255,71,0)'],
        [0.30196, 'rgb(255,120,0)'],
        [0.30588, 'rgb(255,167,0)'],
        [0.3098, 'rgb(255,208,0)'],
        [0.31373, 'rgb(255,241,0)'],
        [0.31765, 'rgb(236,255,0)'],
        [0.32157, 'rgb(188,255,0)'],
        [0.32549, 'rgb(139,255,0)'],
        [0.32941, 'rgb(92,255,0)'],
        [0.33333, 'rgb(50,232,0)'],
        [0.33725, 'rgb(16,197,42)'],
        [0.34118, 'rgb(0,154,111)'],
        [0.3451, 'rgb(0,106,173)'],
        [0.34902, 'rgb(0,57,224)'],
        [0.35294, 'rgb(0,10,255)'],
        [0.35686, 'rgb(19,0,255)'],
        [0.36078, 'rgb(53,0,255)'],
        [0.36471, 'rgb(96,0,255)'],
        [0.36863, 'rgb(143,0,224)'],
        [0.37255, 'rgb(192,0,174)'],
        [0.37647, 'rgb(240,0,112)'],
        [0.38039, 'rgb(255,0,43)'],
        [0.38431, 'rgb(255,0,0)'],
        [0.38824, 'rgb(255,4,0)'],
        [0.39216, 'rgb(255,51,0)'],
        [0.39608, 'rgb(255,100,0)'],
        [0.4, 'rgb(255,148,0)'],
        [0.40392, 'rgb(255,192,0)'],
        [0.40784, 'rgb(255,229,0)'],
        [0.41176, 'rgb(254,255,0)'],
        [0.41569, 'rgb(207,255,0)'],
        [0.41961, 'rgb(158,255,0)'],
        [0.42353, 'rgb(110,255,0)'],
        [0.42745, 'rgb(66,244,0)'],
        [0.43137, 'rgb(29,212,13)'],
        [0.43529, 'rgb(1,172,84)'],
        [0.43922, 'rgb(0,126,150)'],
        [0.44314, 'rgb(0,77,205)'],
        [0.44706, 'rgb(0,28,247)'],
        [0.45098, 'rgb(7,0,255)'],
        [0.4549, 'rgb(38,0,255)'],
        [0.45882, 'rgb(78,0,255)'],
        [0.46275, 'rgb(124,0,240)'],
        [0.46667, 'rgb(172,0,196)'],
        [0.47059, 'rgb(221,0,138)'],
        [0.47451, 'rgb(255,0,72)'],
        [0.47843, 'rgb(255,0,0)'],
        [0.48235, 'rgb(255,0,0)'],
        [0.48627, 'rgb(255,32,0)'],
        [0.4902, 'rgb(255,81,0)'],
        [0.49412, 'rgb(255,129,0)'],
        [0.49804, 'rgb(255,175,0)'],
        [0.50196, 'rgb(255,215,0)'],
        [0.50588, 'rgb(255,246,0)'],
        [0.5098, 'rgb(227,255,0)'],
        [0.51373, 'rgb(178,255,0)'],
        [0.51765, 'rgb(129,255,0)'],
        [0.52157, 'rgb(83,254,0)'],
        [0.52549, 'rgb(43,226,0)'],
        [0.52941, 'rgb(11,189,56)'],
        [0.53333, 'rgb(0,145,124)'],
        [0.53725, 'rgb(0,96,184)'],
        [0.54118, 'rgb(0,47,232)'],
        [0.5451, 'rgb(0,1,255)'],
        [0.54902, 'rgb(25,0,255)'],
        [0.55294, 'rgb(61,0,255)'],
        [0.55686, 'rgb(105,0,254)'],
        [0.56078, 'rgb(153,0,215)'],
        [0.56471, 'rgb(202,0,163)'],
        [0.56863, 'rgb(249,0,99)'],
        [0.57255, 'rgb(255,0,29)'],
        [0.57647, 'rgb(255,0,0)'],
        [0.58039, 'rgb(255,13,0)'],
        [0.58431, 'rgb(255,61,0)'],
        [0.58824, 'rgb(255,110,0)'],
        [0.59216, 'rgb(255,157,0)'],
        [0.59608, 'rgb(255,200,0)'],
        [0.6, 'rgb(255,235,0)'],
        [0.60392, 'rgb(245,255,0)'],
        [0.60784, 'rgb(198,255,0)'],
        [0.61176, 'rgb(149,255,0)'],
        [0.61569, 'rgb(101,255,0)'],
        [0.61961, 'rgb(58,238,0)'],
        [0.62353, 'rgb(22,205,27)'],
        [0.62745, 'rgb(0,163,98)'],
        [0.63137, 'rgb(0,116,161)'],
        [0.63529, 'rgb(0,67,214)'],
        [0.63922, 'rgb(0,19,253)'],
        [0.64314, 'rgb(13,0,255)'],
        [0.64706, 'rgb(45,0,255)'],
        [0.65098, 'rgb(86,0,255)'],
        [0.6549, 'rgb(133,0,233)'],
        [0.65882, 'rgb(182,0,185)'],
        [0.66275, 'rgb(230,0,126)'],
        [0.66667, 'rgb(255,0,58)'],
        [0.67059, 'rgb(255,0,0)'],
        [0.67451, 'rgb(255,0,0)'],
        [0.67843, 'rgb(255,41,0)'],
        [0.68235, 'rgb(255,90,0)'],
        [0.68627, 'rgb(255,139,0)'],
        [0.6902, 'rgb(255,184,0)'],
        [0.69412, 'rgb(255,222,0)'],
        [0.69804, 'rgb(255,251,0)'],
        [0.70196, 'rgb(217,255,0)'],
        [0.70588, 'rgb(169,255,0)'],
        [0.7098, 'rgb(120,255,0)'],
        [0.71373, 'rgb(75,249,0)'],
        [0.71765, 'rgb(36,219,0)'],
        [0.72157, 'rgb(5,181,70)'],
        [0.72549, 'rgb(0,135,137)'],
        [0.72941, 'rgb(0,87,195)'],
        [0.73333, 'rgb(0,38,239)'],
        [0.73725, 'rgb(2,0,255)'],
        [0.74118, 'rgb(31,0,255)'],
        [0.7451, 'rgb(69,0,255)'],
        [0.74902, 'rgb(114,0,248)'],
        [0.75294, 'rgb(162,0,206)'],
        [0.75686, 'rgb(211,0,151)'],
        [0.76078, 'rgb(255,0,86)'],
        [0.76471, 'rgb(255,0,15)'],
        [0.76863, 'rgb(255,0,0)'],
        [0.77255, 'rgb(255,22,0)'],
        [0.77647, 'rgb(255,71,0)'],
        [0.78039, 'rgb(255,120,0)'],
        [0.78431, 'rgb(255,166,0)'],
        [0.78824, 'rgb(255,207,0)'],
        [0.79216, 'rgb(255,240,0)'],
        [0.79608, 'rgb(236,255,0)'],
        [0.8, 'rgb(188,255,0)'],
        [0.80392, 'rgb(139,255,0)'],
        [0.80784, 'rgb(92,255,0)'],
        [0.81176, 'rgb(50,233,0)'],
        [0.81569, 'rgb(16,197,42)'],
        [0.81961, 'rgb(0,154,111)'],
        [0.82353, 'rgb(0,107,173)'],
        [0.82745, 'rgb(0,57,223)'],
        [0.83137, 'rgb(0,10,255)'],
        [0.83529, 'rgb(18,0,255)'],
        [0.83922, 'rgb(53,0,255)'],
        [0.84314, 'rgb(95,0,255)'],
        [0.84706, 'rgb(143,0,225)'],
        [0.85098, 'rgb(192,0,175)'],
        [0.8549, 'rgb(239,0,113)'],
        [0.85882, 'rgb(255,0,44)'],
        [0.86275, 'rgb(255,0,0)'],
        [0.86667, 'rgb(255,4,0)'],
        [0.87059, 'rgb(255,51,0)'],
        [0.87451, 'rgb(255,100,0)'],
        [0.87843, 'rgb(255,148,0)'],
        [0.88235, 'rgb(255,192,0)'],
        [0.88627, 'rgb(255,228,0)'],
        [0.8902, 'rgb(254,255,0)'],
        [0.89412, 'rgb(208,255,0)'],
        [0.89804, 'rgb(159,255,0)'],
        [0.90196, 'rgb(111,255,0)'],
        [0.90588, 'rgb(66,244,0)'],
        [0.9098, 'rgb(29,212,13)'],
        [0.91373, 'rgb(1,172,84)'],
        [0.91765, 'rgb(0,126,149)'],
        [0.92157, 'rgb(0,77,204)'],
        [0.92549, 'rgb(0,29,246)'],
        [0.92941, 'rgb(7,0,255)'],
        [0.93333, 'rgb(38,0,255)'],
        [0.93725, 'rgb(77,0,255)'],
        [0.94118, 'rgb(123,0,241)'],
        [0.9451, 'rgb(172,0,196)'],
        [0.94902, 'rgb(221,0,139)'],
        [0.95294, 'rgb(255,0,72)'],
        [0.95686, 'rgb(255,0,1)'],
        [0.96078, 'rgb(255,0,0)'],
        [0.96471, 'rgb(255,32,0)'],
        [0.96863, 'rgb(255,80,0)'],
        [0.97255, 'rgb(255,129,0)'],
        [0.97647, 'rgb(255,175,0)'],
        [0.98039, 'rgb(255,215,0)'],
        [0.98431, 'rgb(255,246,0)'],
        [0.98824, 'rgb(227,255,0)'],
        [0.99216, 'rgb(179,255,0)'],
        [0.99608, 'rgb(130,255,0)'],
        [1.0, 'rgb(84,254,0)'],
    ],
    'seismic': [
        [0.0, 'rgb(0,0,76)'],
        [0.00392, 'rgb(0,0,79)'],
        [0.00784, 'rgb(0,0,82)'],
        [0.01176, 'rgb(0,0,84)'],
        [0.01569, 'rgb(0,0,87)'],
        [0.01961, 'rgb(0,0,90)'],
        [0.02353, 'rgb(0,0,93)'],
        [0.02745, 'rgb(0,0,96)'],
        [0.03137, 'rgb(0,0,98)'],
        [0.03529, 'rgb(0,0,101)'],
        [0.03922, 'rgb(0,0,104)'],
        [0.04314, 'rgb(0,0,107)'],
        [0.04706, 'rgb(0,0,110)'],
        [0.05098, 'rgb(0,0,112)'],
        [0.0549, 'rgb(0,0,115)'],
        [0.05882, 'rgb(0,0,118)'],
        [0.06275, 'rgb(0,0,121)'],
        [0.06667, 'rgb(0,0,124)'],
        [0.07059, 'rgb(0,0,126)'],
        [0.07451, 'rgb(0,0,129)'],
        [0.07843, 'rgb(0,0,132)'],
        [0.08235, 'rgb(0,0,135)'],
        [0.08627, 'rgb(0,0,138)'],
        [0.0902, 'rgb(0,0,140)'],
        [0.09412, 'rgb(0,0,143)'],
        [0.09804, 'rgb(0,0,146)'],
        [0.10196, 'rgb(0,0,149)'],
        [0.10588, 'rgb(0,0,152)'],
        [0.1098, 'rgb(0,0,154)'],
        [0.11373, 'rgb(0,0,157)'],
        [0.11765, 'rgb(0,0,160)'],
        [0.12157, 'rgb(0,0,163)'],
        [0.12549, 'rgb(0,0,166)'],
        [0.12941, 'rgb(0,0,168)'],
        [0.13333, 'rgb(0,0,171)'],
        [0.13725, 'rgb(0,0,174)'],
        [0.14118, 'rgb(0,0,177)'],
        [0.1451, 'rgb(0,0,180)'],
        [0.14902, 'rgb(0,0,182)'],
        [0.15294, 'rgb(0,0,185)'],
        [0.15686, 'rgb(0,0,188)'],
        [0.16078, 'rgb(0,0,191)'],
        [0.16471, 'rgb(0,0,194)'],
        [0.16863, 'rgb(0,0,196)'],
        [0.17255, 'rgb(0,0,199)'],
        [0.17647, 'rgb(0,0,202)'],
        [0.18039, 'rgb(0,0,205)'],
        [0.18431, 'rgb(0,0,208)'],
        [0.18824, 'rgb(0,0,210)'],
        [0.19216, 'rgb(0,0,213)'],
        [0.19608, 'rgb(0,0,216)'],
        [0.2, 'rgb(0,0,219)'],
        [0.20392, 'rgb(0,0,222)'],
        [0.20784, 'rgb(0,0,224)'],
        [0.21176, 'rgb(0,0,227)'],
        [0.21569, 'rgb(0,0,230)'],
        [0.21961, 'rgb(0,0,233)'],
        [0.22353, 'rgb(0,0,236)'],
        [0.22745, 'rgb(0,0,238)'],
        [0.23137, 'rgb(0,0,241)'],
        [0.23529, 'rgb(0,0,244)'],
        [0.23922, 'rgb(0,0,247)'],
        [0.24314, 'rgb(0,0,250)'],
        [0.24706, 'rgb(0,0,252)'],
        [0.25098, 'rgb(1,1,255)'],
        [0.2549, 'rgb(5,5,255)'],
        [0.25882, 'rgb(8,8,255)'],
        [0.26275, 'rgb(13,13,255)'],
        [0.26667, 'rgb(17,17,255)'],
        [0.27059, 'rgb(21,21,255)'],
        [0.27451, 'rgb(25,25,255)'],
        [0.27843, 'rgb(29,29,255)'],
        [0.28235, 'rgb(33,33,255)'],
        [0.28627, 'rgb(37,37,255)'],
        [0.2902, 'rgb(40,40,255)'],
        [0.29412, 'rgb(45,45,255)'],
        [0.29804, 'rgb(49,49,255)'],
        [0.30196, 'rgb(53,53,255)'],
        [0.30588, 'rgb(57,57,255)'],
        [0.3098, 'rgb(61,61,255)'],
        [0.31373, 'rgb(65,65,255)'],
        [0.31765, 'rgb(69,69,255)'],
        [0.32157, 'rgb(72,72,255)'],
        [0.32549, 'rgb(77,77,255)'],
        [0.32941, 'rgb(81,81,255)'],
        [0.33333, 'rgb(85,85,255)'],
        [0.33725, 'rgb(89,89,255)'],
        [0.34118, 'rgb(93,93,255)'],
        [0.3451, 'rgb(97,97,255)'],
        [0.34902, 'rgb(101,101,255)'],
        [0.35294, 'rgb(104,104,255)'],
        [0.35686, 'rgb(109,109,255)'],
        [0.36078, 'rgb(113,113,255)'],
        [0.36471, 'rgb(117,117,255)'],
        [0.36863, 'rgb(121,121,255)'],
        [0.37255, 'rgb(125,125,255)'],
        [0.37647, 'rgb(129,129,255)'],
        [0.38039, 'rgb(133,133,255)'],
        [0.38431, 'rgb(136,136,255)'],
        [0.38824, 'rgb(141,141,255)'],
        [0.39216, 'rgb(145,145,255)'],
        [0.39608, 'rgb(149,149,255)'],
        [0.4, 'rgb(153,153,255)'],
        [0.40392, 'rgb(157,157,255)'],
        [0.40784, 'rgb(161,161,255)'],
        [0.41176, 'rgb(165,165,255)'],
        [0.41569, 'rgb(168,168,255)'],
        [0.41961, 'rgb(173,173,255)'],
        [0.42353, 'rgb(177,177,255)'],
        [0.42745, 'rgb(181,181,255)'],
        [0.43137, 'rgb(185,185,255)'],
        [0.43529, 'rgb(189,189,255)'],
        [0.43922, 'rgb(193,193,255)'],
        [0.44314, 'rgb(197,197,255)'],
        [0.44706, 'rgb(200,200,255)'],
        [0.45098, 'rgb(205,205,255)'],
        [0.4549, 'rgb(209,209,255)'],
        [0.45882, 'rgb(213,213,255)'],
        [0.46275, 'rgb(217,217,255)'],
        [0.46667, 'rgb(221,221,255)'],
        [0.47059, 'rgb(225,225,255)'],
        [0.47451, 'rgb(229,229,255)'],
        [0.47843, 'rgb(232,232,255)'],
        [0.48235, 'rgb(237,237,255)'],
        [0.48627, 'rgb(241,241,255)'],
        [0.4902, 'rgb(245,245,255)'],
        [0.49412, 'rgb(249,249,255)'],
        [0.49804, 'rgb(253,253,255)'],
        [0.50196, 'rgb(255,253,253)'],
        [0.50588, 'rgb(255,249,249)'],
        [0.5098, 'rgb(255,245,245)'],
        [0.51373, 'rgb(255,241,241)'],
        [0.51765, 'rgb(255,237,237)'],
        [0.52157, 'rgb(255,233,233)'],
        [0.52549, 'rgb(255,229,229)'],
        [0.52941, 'rgb(255,225,225)'],
        [0.53333, 'rgb(255,221,221)'],
        [0.53725, 'rgb(255,217,217)'],
        [0.54118, 'rgb(255,213,213)'],
        [0.5451, 'rgb(255,209,209)'],
        [0.54902, 'rgb(255,205,205)'],
        [0.55294, 'rgb(255,201,201)'],
        [0.55686, 'rgb(255,197,197)'],
        [0.56078, 'rgb(255,193,193)'],
        [0.56471, 'rgb(255,189,189)'],
        [0.56863, 'rgb(255,185,185)'],
        [0.57255, 'rgb(255,180,180)'],
        [0.57647, 'rgb(255,177,177)'],
        [0.58039, 'rgb(255,173,173)'],
        [0.58431, 'rgb(255,169,169)'],
        [0.58824, 'rgb(255,164,164)'],
        [0.59216, 'rgb(255,161,161)'],
        [0.59608, 'rgb(255,157,157)'],
        [0.6, 'rgb(255,153,153)'],
        [0.60392, 'rgb(255,148,148)'],
        [0.60784, 'rgb(255,145,145)'],
        [0.61176, 'rgb(255,141,141)'],
        [0.61569, 'rgb(255,137,137)'],
        [0.61961, 'rgb(255,132,132)'],
        [0.62353, 'rgb(255,129,129)'],
        [0.62745, 'rgb(255,125,125)'],
        [0.63137, 'rgb(255,121,121)'],
        [0.63529, 'rgb(255,117,117)'],
        [0.63922, 'rgb(255,113,113)'],
        [0.64314, 'rgb(255,109,109)'],
        [0.64706, 'rgb(255,105,105)'],
        [0.65098, 'rgb(255,101,101)'],
        [0.6549, 'rgb(255,97,97)'],
        [0.65882, 'rgb(255,93,93)'],
        [0.66275, 'rgb(255,89,89)'],
        [0.66667, 'rgb(255,85,85)'],
        [0.67059, 'rgb(255,81,81)'],
        [0.67451, 'rgb(255,77,77)'],
        [0.67843, 'rgb(255,73,73)'],
        [0.68235, 'rgb(255,69,69)'],
        [0.68627, 'rgb(255,65,65)'],
        [0.6902, 'rgb(255,61,61)'],
        [0.69412, 'rgb(255,56,56)'],
        [0.69804, 'rgb(255,53,53)'],
        [0.70196, 'rgb(255,48,48)'],
        [0.70588, 'rgb(255,45,45)'],
        [0.7098, 'rgb(255,40,40)'],
        [0.71373, 'rgb(255,37,37)'],
        [0.71765, 'rgb(255,32,32)'],
        [0.72157, 'rgb(255,29,29)'],
        [0.72549, 'rgb(255,24,24)'],
        [0.72941, 'rgb(255,21,21)'],
        [0.73333, 'rgb(255,16,16)'],
        [0.73725, 'rgb(255,13,13)'],
        [0.74118, 'rgb(255,8,8)'],
        [0.7451, 'rgb(255,5,5)'],
        [0.74902, 'rgb(255,0,0)'],
        [0.75294, 'rgb(253,0,0)'],
        [0.75686, 'rgb(251,0,0)'],
        [0.76078, 'rgb(249,0,0)'],
        [0.76471, 'rgb(247,0,0)'],
        [0.76863, 'rgb(245,0,0)'],
        [0.77255, 'rgb(243,0,0)'],
        [0.77647, 'rgb(241,0,0)'],
        [0.78039, 'rgb(239,0,0)'],
        [0.78431, 'rgb(237,0,0)'],
        [0.78824, 'rgb(235,0,0)'],
        [0.79216, 'rgb(233,0,0)'],
        [0.79608, 'rgb(231,0,0)'],
        [0.8, 'rgb(229,0,0)'],
        [0.80392, 'rgb(227,0,0)'],
        [0.80784, 'rgb(225,0,0)'],
        [0.81176, 'rgb(223,0,0)'],
        [0.81569, 'rgb(221,0,0)'],
        [0.81961, 'rgb(219,0,0)'],
        [0.82353, 'rgb(217,0,0)'],
        [0.82745, 'rgb(215,0,0)'],
        [0.83137, 'rgb(213,0,0)'],
        [0.83529, 'rgb(211,0,0)'],
        [0.83922, 'rgb(209,0,0)'],
        [0.84314, 'rgb(207,0,0)'],
        [0.84706, 'rgb(205,0,0)'],
        [0.85098, 'rgb(203,0,0)'],
        [0.8549, 'rgb(201,0,0)'],
        [0.85882, 'rgb(199,0,0)'],
        [0.86275, 'rgb(197,0,0)'],
        [0.86667, 'rgb(195,0,0)'],
        [0.87059, 'rgb(193,0,0)'],
        [0.87451, 'rgb(191,0,0)'],
        [0.87843, 'rgb(189,0,0)'],
        [0.88235, 'rgb(187,0,0)'],
        [0.88627, 'rgb(185,0,0)'],
        [0.8902, 'rgb(183,0,0)'],
        [0.89412, 'rgb(181,0,0)'],
        [0.89804, 'rgb(179,0,0)'],
        [0.90196, 'rgb(177,0,0)'],
        [0.90588, 'rgb(175,0,0)'],
        [0.9098, 'rgb(173,0,0)'],
        [0.91373, 'rgb(171,0,0)'],
        [0.91765, 'rgb(169,0,0)'],
        [0.92157, 'rgb(167,0,0)'],
        [0.92549, 'rgb(165,0,0)'],
        [0.92941, 'rgb(163,0,0)'],
        [0.93333, 'rgb(161,0,0)'],
        [0.93725, 'rgb(159,0,0)'],
        [0.94118, 'rgb(157,0,0)'],
        [0.9451, 'rgb(155,0,0)'],
        [0.94902, 'rgb(153,0,0)'],
        [0.95294, 'rgb(151,0,0)'],
        [0.95686, 'rgb(149,0,0)'],
        [0.96078, 'rgb(147,0,0)'],
        [0.96471, 'rgb(145,0,0)'],
        [0.96863, 'rgb(143,0,0)'],
        [0.97255, 'rgb(141,0,0)'],
        [0.97647, 'rgb(139,0,0)'],
        [0.98039, 'rgb(137,0,0)'],
        [0.98431, 'rgb(135,0,0)'],
        [0.98824, 'rgb(133,0,0)'],
        [0.99216, 'rgb(131,0,0)'],
        [0.99608, 'rgb(129,0,0)'],
        [1.0, 'rgb(127,0,0)'],
    ],
    'spring': [
        [0.0, 'rgb(255,0,255)'],
        [0.00392, 'rgb(255,1,254)'],
        [0.00784, 'rgb(255,2,253)'],
        [0.01176, 'rgb(255,3,252)'],
        [0.01569, 'rgb(255,4,251)'],
        [0.01961, 'rgb(255,5,250)'],
        [0.02353, 'rgb(255,6,249)'],
        [0.02745, 'rgb(255,7,248)'],
        [0.03137, 'rgb(255,8,247)'],
        [0.03529, 'rgb(255,9,246)'],
        [0.03922, 'rgb(255,10,245)'],
        [0.04314, 'rgb(255,11,244)'],
        [0.04706, 'rgb(255,12,243)'],
        [0.05098, 'rgb(255,13,242)'],
        [0.0549, 'rgb(255,14,241)'],
        [0.05882, 'rgb(255,15,240)'],
        [0.06275, 'rgb(255,16,239)'],
        [0.06667, 'rgb(255,17,238)'],
        [0.07059, 'rgb(255,18,237)'],
        [0.07451, 'rgb(255,19,236)'],
        [0.07843, 'rgb(255,20,235)'],
        [0.08235, 'rgb(255,21,234)'],
        [0.08627, 'rgb(255,22,233)'],
        [0.0902, 'rgb(255,23,232)'],
        [0.09412, 'rgb(255,24,231)'],
        [0.09804, 'rgb(255,25,230)'],
        [0.10196, 'rgb(255,26,229)'],
        [0.10588, 'rgb(255,27,228)'],
        [0.1098, 'rgb(255,28,227)'],
        [0.11373, 'rgb(255,29,226)'],
        [0.11765, 'rgb(255,30,225)'],
        [0.12157, 'rgb(255,31,224)'],
        [0.12549, 'rgb(255,32,223)'],
        [0.12941, 'rgb(255,32,222)'],
        [0.13333, 'rgb(255,34,221)'],
        [0.13725, 'rgb(255,35,220)'],
        [0.14118, 'rgb(255,36,219)'],
        [0.1451, 'rgb(255,36,218)'],
        [0.14902, 'rgb(255,38,217)'],
        [0.15294, 'rgb(255,39,216)'],
        [0.15686, 'rgb(255,40,215)'],
        [0.16078, 'rgb(255,40,214)'],
        [0.16471, 'rgb(255,42,213)'],
        [0.16863, 'rgb(255,43,211)'],
        [0.17255, 'rgb(255,44,211)'],
        [0.17647, 'rgb(255,44,210)'],
        [0.18039, 'rgb(255,46,209)'],
        [0.18431, 'rgb(255,47,208)'],
        [0.18824, 'rgb(255,48,207)'],
        [0.19216, 'rgb(255,48,206)'],
        [0.19608, 'rgb(255,50,205)'],
        [0.2, 'rgb(255,51,204)'],
        [0.20392, 'rgb(255,52,203)'],
        [0.20784, 'rgb(255,52,202)'],
        [0.21176, 'rgb(255,54,201)'],
        [0.21569, 'rgb(255,55,200)'],
        [0.21961, 'rgb(255,56,199)'],
        [0.22353, 'rgb(255,56,198)'],
        [0.22745, 'rgb(255,58,197)'],
        [0.23137, 'rgb(255,59,195)'],
        [0.23529, 'rgb(255,60,195)'],
        [0.23922, 'rgb(255,60,194)'],
        [0.24314, 'rgb(255,62,193)'],
        [0.24706, 'rgb(255,63,192)'],
        [0.25098, 'rgb(255,64,191)'],
        [0.2549, 'rgb(255,65,190)'],
        [0.25882, 'rgb(255,65,189)'],
        [0.26275, 'rgb(255,67,188)'],
        [0.26667, 'rgb(255,68,187)'],
        [0.27059, 'rgb(255,69,186)'],
        [0.27451, 'rgb(255,70,185)'],
        [0.27843, 'rgb(255,71,184)'],
        [0.28235, 'rgb(255,72,183)'],
        [0.28627, 'rgb(255,73,182)'],
        [0.2902, 'rgb(255,73,181)'],
        [0.29412, 'rgb(255,75,179)'],
        [0.29804, 'rgb(255,76,179)'],
        [0.30196, 'rgb(255,77,178)'],
        [0.30588, 'rgb(255,78,177)'],
        [0.3098, 'rgb(255,79,176)'],
        [0.31373, 'rgb(255,80,175)'],
        [0.31765, 'rgb(255,81,174)'],
        [0.32157, 'rgb(255,81,173)'],
        [0.32549, 'rgb(255,83,172)'],
        [0.32941, 'rgb(255,84,171)'],
        [0.33333, 'rgb(255,85,170)'],
        [0.33725, 'rgb(255,86,169)'],
        [0.34118, 'rgb(255,87,168)'],
        [0.3451, 'rgb(255,88,167)'],
        [0.34902, 'rgb(255,89,166)'],
        [0.35294, 'rgb(255,89,165)'],
        [0.35686, 'rgb(255,91,163)'],
        [0.36078, 'rgb(255,92,163)'],
        [0.36471, 'rgb(255,93,162)'],
        [0.36863, 'rgb(255,94,161)'],
        [0.37255, 'rgb(255,95,160)'],
        [0.37647, 'rgb(255,96,159)'],
        [0.38039, 'rgb(255,97,158)'],
        [0.38431, 'rgb(255,97,157)'],
        [0.38824, 'rgb(255,99,156)'],
        [0.39216, 'rgb(255,100,155)'],
        [0.39608, 'rgb(255,101,154)'],
        [0.4, 'rgb(255,102,153)'],
        [0.40392, 'rgb(255,103,152)'],
        [0.40784, 'rgb(255,104,151)'],
        [0.41176, 'rgb(255,105,150)'],
        [0.41569, 'rgb(255,105,149)'],
        [0.41961, 'rgb(255,107,147)'],
        [0.42353, 'rgb(255,108,147)'],
        [0.42745, 'rgb(255,109,146)'],
        [0.43137, 'rgb(255,110,145)'],
        [0.43529, 'rgb(255,111,144)'],
        [0.43922, 'rgb(255,112,143)'],
        [0.44314, 'rgb(255,113,142)'],
        [0.44706, 'rgb(255,113,141)'],
        [0.45098, 'rgb(255,115,140)'],
        [0.4549, 'rgb(255,116,139)'],
        [0.45882, 'rgb(255,117,138)'],
        [0.46275, 'rgb(255,118,137)'],
        [0.46667, 'rgb(255,119,136)'],
        [0.47059, 'rgb(255,120,135)'],
        [0.47451, 'rgb(255,121,134)'],
        [0.47843, 'rgb(255,121,133)'],
        [0.48235, 'rgb(255,123,131)'],
        [0.48627, 'rgb(255,124,131)'],
        [0.4902, 'rgb(255,125,130)'],
        [0.49412, 'rgb(255,126,129)'],
        [0.49804, 'rgb(255,127,128)'],
        [0.50196, 'rgb(255,128,127)'],
        [0.50588, 'rgb(255,129,126)'],
        [0.5098, 'rgb(255,130,125)'],
        [0.51373, 'rgb(255,131,124)'],
        [0.51765, 'rgb(255,131,123)'],
        [0.52157, 'rgb(255,133,121)'],
        [0.52549, 'rgb(255,134,121)'],
        [0.52941, 'rgb(255,135,120)'],
        [0.53333, 'rgb(255,136,119)'],
        [0.53725, 'rgb(255,137,118)'],
        [0.54118, 'rgb(255,138,117)'],
        [0.5451, 'rgb(255,139,116)'],
        [0.54902, 'rgb(255,140,114)'],
        [0.55294, 'rgb(255,141,113)'],
        [0.55686, 'rgb(255,142,113)'],
        [0.56078, 'rgb(255,143,112)'],
        [0.56471, 'rgb(255,144,111)'],
        [0.56863, 'rgb(255,145,110)'],
        [0.57255, 'rgb(255,146,109)'],
        [0.57647, 'rgb(255,147,108)'],
        [0.58039, 'rgb(255,147,107)'],
        [0.58431, 'rgb(255,149,105)'],
        [0.58824, 'rgb(255,150,105)'],
        [0.59216, 'rgb(255,151,104)'],
        [0.59608, 'rgb(255,152,103)'],
        [0.6, 'rgb(255,153,102)'],
        [0.60392, 'rgb(255,154,101)'],
        [0.60784, 'rgb(255,155,100)'],
        [0.61176, 'rgb(255,156,98)'],
        [0.61569, 'rgb(255,157,97)'],
        [0.61961, 'rgb(255,158,97)'],
        [0.62353, 'rgb(255,159,96)'],
        [0.62745, 'rgb(255,160,95)'],
        [0.63137, 'rgb(255,161,94)'],
        [0.63529, 'rgb(255,162,93)'],
        [0.63922, 'rgb(255,163,92)'],
        [0.64314, 'rgb(255,163,91)'],
        [0.64706, 'rgb(255,165,89)'],
        [0.65098, 'rgb(255,166,89)'],
        [0.6549, 'rgb(255,167,88)'],
        [0.65882, 'rgb(255,168,87)'],
        [0.66275, 'rgb(255,169,86)'],
        [0.66667, 'rgb(255,170,85)'],
        [0.67059, 'rgb(255,171,84)'],
        [0.67451, 'rgb(255,172,82)'],
        [0.67843, 'rgb(255,173,81)'],
        [0.68235, 'rgb(255,174,81)'],
        [0.68627, 'rgb(255,175,80)'],
        [0.6902, 'rgb(255,176,79)'],
        [0.69412, 'rgb(255,177,78)'],
        [0.69804, 'rgb(255,178,77)'],
        [0.70196, 'rgb(255,179,76)'],
        [0.70588, 'rgb(255,179,75)'],
        [0.7098, 'rgb(255,181,73)'],
        [0.71373, 'rgb(255,182,73)'],
        [0.71765, 'rgb(255,183,72)'],
        [0.72157, 'rgb(255,184,71)'],
        [0.72549, 'rgb(255,185,70)'],
        [0.72941, 'rgb(255,186,69)'],
        [0.73333, 'rgb(255,187,68)'],
        [0.73725, 'rgb(255,188,66)'],
        [0.74118, 'rgb(255,189,65)'],
        [0.7451, 'rgb(255,190,65)'],
        [0.74902, 'rgb(255,191,64)'],
        [0.75294, 'rgb(255,192,63)'],
        [0.75686, 'rgb(255,193,62)'],
        [0.76078, 'rgb(255,194,61)'],
        [0.76471, 'rgb(255,195,60)'],
        [0.76863, 'rgb(255,195,59)'],
        [0.77255, 'rgb(255,197,57)'],
        [0.77647, 'rgb(255,198,56)'],
        [0.78039, 'rgb(255,199,56)'],
        [0.78431, 'rgb(255,200,55)'],
        [0.78824, 'rgb(255,201,54)'],
        [0.79216, 'rgb(255,202,53)'],
        [0.79608, 'rgb(255,203,52)'],
        [0.8, 'rgb(255,204,50)'],
        [0.80392, 'rgb(255,205,49)'],
        [0.80784, 'rgb(255,206,48)'],
        [0.81176, 'rgb(255,207,48)'],
        [0.81569, 'rgb(255,208,47)'],
        [0.81961, 'rgb(255,209,46)'],
        [0.82353, 'rgb(255,210,45)'],
        [0.82745, 'rgb(255,211,44)'],
        [0.83137, 'rgb(255,211,43)'],
        [0.83529, 'rgb(255,213,41)'],
        [0.83922, 'rgb(255,214,40)'],
        [0.84314, 'rgb(255,215,40)'],
        [0.84706, 'rgb(255,216,39)'],
        [0.85098, 'rgb(255,217,38)'],
        [0.8549, 'rgb(255,218,37)'],
        [0.85882, 'rgb(255,219,36)'],
        [0.86275, 'rgb(255,220,34)'],
        [0.86667, 'rgb(255,221,33)'],
        [0.87059, 'rgb(255,222,32)'],
        [0.87451, 'rgb(255,223,32)'],
        [0.87843, 'rgb(255,224,31)'],
        [0.88235, 'rgb(255,225,30)'],
        [0.88627, 'rgb(255,226,29)'],
        [0.8902, 'rgb(255,227,28)'],
        [0.89412, 'rgb(255,227,27)'],
        [0.89804, 'rgb(255,229,25)'],
        [0.90196, 'rgb(255,230,24)'],
        [0.90588, 'rgb(255,231,24)'],
        [0.9098, 'rgb(255,232,23)'],
        [0.91373, 'rgb(255,233,22)'],
        [0.91765, 'rgb(255,234,21)'],
        [0.92157, 'rgb(255,235,20)'],
        [0.92549, 'rgb(255,236,18)'],
        [0.92941, 'rgb(255,237,17)'],
        [0.93333, 'rgb(255,238,16)'],
        [0.93725, 'rgb(255,239,16)'],
        [0.94118, 'rgb(255,240,15)'],
        [0.9451, 'rgb(255,241,14)'],
        [0.94902, 'rgb(255,242,13)'],
        [0.95294, 'rgb(255,243,12)'],
        [0.95686, 'rgb(255,243,11)'],
        [0.96078, 'rgb(255,245,9)'],
        [0.96471, 'rgb(255,246,8)'],
        [0.96863, 'rgb(255,247,8)'],
        [0.97255, 'rgb(255,248,7)'],
        [0.97647, 'rgb(255,249,6)'],
        [0.98039, 'rgb(255,250,5)'],
        [0.98431, 'rgb(255,251,4)'],
        [0.98824, 'rgb(255,252,2)'],
        [0.99216, 'rgb(255,253,1)'],
        [0.99608, 'rgb(255,254,0)'],
        [1.0, 'rgb(255,255,0)'],
    ],
    'summer': [
        [0.0, 'rgb(0,127,102)'],
        [0.00392, 'rgb(1,128,102)'],
        [0.00784, 'rgb(2,128,102)'],
        [0.01176, 'rgb(3,129,102)'],
        [0.01569, 'rgb(4,129,102)'],
        [0.01961, 'rgb(5,130,102)'],
        [0.02353, 'rgb(6,130,102)'],
        [0.02745, 'rgb(7,131,102)'],
        [0.03137, 'rgb(8,131,102)'],
        [0.03529, 'rgb(9,132,102)'],
        [0.03922, 'rgb(10,132,102)'],
        [0.04314, 'rgb(11,133,102)'],
        [0.04706, 'rgb(12,133,102)'],
        [0.05098, 'rgb(13,134,102)'],
        [0.0549, 'rgb(14,134,102)'],
        [0.05882, 'rgb(15,135,102)'],
        [0.06275, 'rgb(16,135,102)'],
        [0.06667, 'rgb(17,136,102)'],
        [0.07059, 'rgb(18,136,102)'],
        [0.07451, 'rgb(19,137,102)'],
        [0.07843, 'rgb(20,137,102)'],
        [0.08235, 'rgb(21,138,102)'],
        [0.08627, 'rgb(22,138,102)'],
        [0.0902, 'rgb(23,139,102)'],
        [0.09412, 'rgb(24,139,102)'],
        [0.09804, 'rgb(25,140,102)'],
        [0.10196, 'rgb(26,140,102)'],
        [0.10588, 'rgb(27,141,102)'],
        [0.1098, 'rgb(28,141,102)'],
        [0.11373, 'rgb(29,142,102)'],
        [0.11765, 'rgb(30,142,102)'],
        [0.12157, 'rgb(31,143,102)'],
        [0.12549, 'rgb(32,143,102)'],
        [0.12941, 'rgb(32,144,102)'],
        [0.13333, 'rgb(34,144,102)'],
        [0.13725, 'rgb(35,145,102)'],
        [0.14118, 'rgb(36,145,102)'],
        [0.1451, 'rgb(36,146,102)'],
        [0.14902, 'rgb(38,146,102)'],
        [0.15294, 'rgb(39,147,102)'],
        [0.15686, 'rgb(40,147,102)'],
        [0.16078, 'rgb(40,147,102)'],
        [0.16471, 'rgb(42,148,102)'],
        [0.16863, 'rgb(43,149,102)'],
        [0.17255, 'rgb(44,149,102)'],
        [0.17647, 'rgb(44,150,102)'],
        [0.18039, 'rgb(46,150,102)'],
        [0.18431, 'rgb(47,151,102)'],
        [0.18824, 'rgb(48,151,102)'],
        [0.19216, 'rgb(48,152,102)'],
        [0.19608, 'rgb(50,152,102)'],
        [0.2, 'rgb(51,153,102)'],
        [0.20392, 'rgb(52,153,102)'],
        [0.20784, 'rgb(52,154,102)'],
        [0.21176, 'rgb(54,154,102)'],
        [0.21569, 'rgb(55,155,102)'],
        [0.21961, 'rgb(56,155,102)'],
        [0.22353, 'rgb(56,156,102)'],
        [0.22745, 'rgb(58,156,102)'],
        [0.23137, 'rgb(59,157,102)'],
        [0.23529, 'rgb(60,157,102)'],
        [0.23922, 'rgb(60,158,102)'],
        [0.24314, 'rgb(62,158,102)'],
        [0.24706, 'rgb(63,159,102)'],
        [0.25098, 'rgb(64,159,102)'],
        [0.2549, 'rgb(65,160,102)'],
        [0.25882, 'rgb(65,160,102)'],
        [0.26275, 'rgb(67,161,102)'],
        [0.26667, 'rgb(68,161,102)'],
        [0.27059, 'rgb(69,162,102)'],
        [0.27451, 'rgb(70,162,102)'],
        [0.27843, 'rgb(71,163,102)'],
        [0.28235, 'rgb(72,163,102)'],
        [0.28627, 'rgb(73,163,102)'],
        [0.2902, 'rgb(73,164,102)'],
        [0.29412, 'rgb(75,165,102)'],
        [0.29804, 'rgb(76,165,102)'],
        [0.30196, 'rgb(77,166,102)'],
        [0.30588, 'rgb(78,166,102)'],
        [0.3098, 'rgb(79,167,102)'],
        [0.31373, 'rgb(80,167,102)'],
        [0.31765, 'rgb(81,168,102)'],
        [0.32157, 'rgb(81,168,102)'],
        [0.32549, 'rgb(83,169,102)'],
        [0.32941, 'rgb(84,169,102)'],
        [0.33333, 'rgb(85,170,102)'],
        [0.33725, 'rgb(86,170,102)'],
        [0.34118, 'rgb(87,171,102)'],
        [0.3451, 'rgb(88,171,102)'],
        [0.34902, 'rgb(89,172,102)'],
        [0.35294, 'rgb(89,172,102)'],
        [0.35686, 'rgb(91,173,102)'],
        [0.36078, 'rgb(92,173,102)'],
        [0.36471, 'rgb(93,174,102)'],
        [0.36863, 'rgb(94,174,102)'],
        [0.37255, 'rgb(95,175,102)'],
        [0.37647, 'rgb(96,175,102)'],
        [0.38039, 'rgb(97,176,102)'],
        [0.38431, 'rgb(97,176,102)'],
        [0.38824, 'rgb(99,177,102)'],
        [0.39216, 'rgb(100,177,102)'],
        [0.39608, 'rgb(101,178,102)'],
        [0.4, 'rgb(102,178,102)'],
        [0.40392, 'rgb(103,179,102)'],
        [0.40784, 'rgb(104,179,102)'],
        [0.41176, 'rgb(105,179,102)'],
        [0.41569, 'rgb(105,180,102)'],
        [0.41961, 'rgb(107,181,102)'],
        [0.42353, 'rgb(108,181,102)'],
        [0.42745, 'rgb(109,182,102)'],
        [0.43137, 'rgb(110,182,102)'],
        [0.43529, 'rgb(111,183,102)'],
        [0.43922, 'rgb(112,183,102)'],
        [0.44314, 'rgb(113,184,102)'],
        [0.44706, 'rgb(113,184,102)'],
        [0.45098, 'rgb(115,185,102)'],
        [0.4549, 'rgb(116,185,102)'],
        [0.45882, 'rgb(117,186,102)'],
        [0.46275, 'rgb(118,186,102)'],
        [0.46667, 'rgb(119,187,102)'],
        [0.47059, 'rgb(120,187,102)'],
        [0.47451, 'rgb(121,188,102)'],
        [0.47843, 'rgb(121,188,102)'],
        [0.48235, 'rgb(123,189,102)'],
        [0.48627, 'rgb(124,189,102)'],
        [0.4902, 'rgb(125,190,102)'],
        [0.49412, 'rgb(126,190,102)'],
        [0.49804, 'rgb(127,191,102)'],
        [0.50196, 'rgb(128,191,102)'],
        [0.50588, 'rgb(129,192,102)'],
        [0.5098, 'rgb(130,192,102)'],
        [0.51373, 'rgb(131,193,102)'],
        [0.51765, 'rgb(131,193,102)'],
        [0.52157, 'rgb(133,194,102)'],
        [0.52549, 'rgb(134,194,102)'],
        [0.52941, 'rgb(135,195,102)'],
        [0.53333, 'rgb(136,195,102)'],
        [0.53725, 'rgb(137,195,102)'],
        [0.54118, 'rgb(138,196,102)'],
        [0.5451, 'rgb(139,196,102)'],
        [0.54902, 'rgb(140,197,102)'],
        [0.55294, 'rgb(141,198,102)'],
        [0.55686, 'rgb(142,198,102)'],
        [0.56078, 'rgb(143,199,102)'],
        [0.56471, 'rgb(144,199,102)'],
        [0.56863, 'rgb(145,200,102)'],
        [0.57255, 'rgb(146,200,102)'],
        [0.57647, 'rgb(147,201,102)'],
        [0.58039, 'rgb(147,201,102)'],
        [0.58431, 'rgb(149,202,102)'],
        [0.58824, 'rgb(150,202,102)'],
        [0.59216, 'rgb(151,203,102)'],
        [0.59608, 'rgb(152,203,102)'],
        [0.6, 'rgb(153,204,102)'],
        [0.60392, 'rgb(154,204,102)'],
        [0.60784, 'rgb(155,205,102)'],
        [0.61176, 'rgb(156,205,102)'],
        [0.61569, 'rgb(157,206,102)'],
        [0.61961, 'rgb(158,206,102)'],
        [0.62353, 'rgb(159,207,102)'],
        [0.62745, 'rgb(160,207,102)'],
        [0.63137, 'rgb(161,208,102)'],
        [0.63529, 'rgb(162,208,102)'],
        [0.63922, 'rgb(163,209,102)'],
        [0.64314, 'rgb(163,209,102)'],
        [0.64706, 'rgb(165,210,102)'],
        [0.65098, 'rgb(166,210,102)'],
        [0.6549, 'rgb(167,211,102)'],
        [0.65882, 'rgb(168,211,102)'],
        [0.66275, 'rgb(169,211,102)'],
        [0.66667, 'rgb(170,212,102)'],
        [0.67059, 'rgb(171,212,102)'],
        [0.67451, 'rgb(172,213,102)'],
        [0.67843, 'rgb(173,214,102)'],
        [0.68235, 'rgb(174,214,102)'],
        [0.68627, 'rgb(175,215,102)'],
        [0.6902, 'rgb(176,215,102)'],
        [0.69412, 'rgb(177,216,102)'],
        [0.69804, 'rgb(178,216,102)'],
        [0.70196, 'rgb(179,217,102)'],
        [0.70588, 'rgb(179,217,102)'],
        [0.7098, 'rgb(181,218,102)'],
        [0.71373, 'rgb(182,218,102)'],
        [0.71765, 'rgb(183,219,102)'],
        [0.72157, 'rgb(184,219,102)'],
        [0.72549, 'rgb(185,220,102)'],
        [0.72941, 'rgb(186,220,102)'],
        [0.73333, 'rgb(187,221,102)'],
        [0.73725, 'rgb(188,221,102)'],
        [0.74118, 'rgb(189,222,102)'],
        [0.7451, 'rgb(190,222,102)'],
        [0.74902, 'rgb(191,223,102)'],
        [0.75294, 'rgb(192,223,102)'],
        [0.75686, 'rgb(193,224,102)'],
        [0.76078, 'rgb(194,224,102)'],
        [0.76471, 'rgb(195,225,102)'],
        [0.76863, 'rgb(195,225,102)'],
        [0.77255, 'rgb(197,226,102)'],
        [0.77647, 'rgb(198,226,102)'],
        [0.78039, 'rgb(199,227,102)'],
        [0.78431, 'rgb(200,227,102)'],
        [0.78824, 'rgb(201,227,102)'],
        [0.79216, 'rgb(202,228,102)'],
        [0.79608, 'rgb(203,228,102)'],
        [0.8, 'rgb(204,229,102)'],
        [0.80392, 'rgb(205,230,102)'],
        [0.80784, 'rgb(206,230,102)'],
        [0.81176, 'rgb(207,231,102)'],
        [0.81569, 'rgb(208,231,102)'],
        [0.81961, 'rgb(209,232,102)'],
        [0.82353, 'rgb(210,232,102)'],
        [0.82745, 'rgb(211,233,102)'],
        [0.83137, 'rgb(211,233,102)'],
        [0.83529, 'rgb(213,234,102)'],
        [0.83922, 'rgb(214,234,102)'],
        [0.84314, 'rgb(215,235,102)'],
        [0.84706, 'rgb(216,235,102)'],
        [0.85098, 'rgb(217,236,102)'],
        [0.8549, 'rgb(218,236,102)'],
        [0.85882, 'rgb(219,237,102)'],
        [0.86275, 'rgb(220,237,102)'],
        [0.86667, 'rgb(221,238,102)'],
        [0.87059, 'rgb(222,238,102)'],
        [0.87451, 'rgb(223,239,102)'],
        [0.87843, 'rgb(224,239,102)'],
        [0.88235, 'rgb(225,240,102)'],
        [0.88627, 'rgb(226,240,102)'],
        [0.8902, 'rgb(227,241,102)'],
        [0.89412, 'rgb(227,241,102)'],
        [0.89804, 'rgb(229,242,102)'],
        [0.90196, 'rgb(230,242,102)'],
        [0.90588, 'rgb(231,243,102)'],
        [0.9098, 'rgb(232,243,102)'],
        [0.91373, 'rgb(233,243,102)'],
        [0.91765, 'rgb(234,244,102)'],
        [0.92157, 'rgb(235,244,102)'],
        [0.92549, 'rgb(236,245,102)'],
        [0.92941, 'rgb(237,246,102)'],
        [0.93333, 'rgb(238,246,102)'],
        [0.93725, 'rgb(239,247,102)'],
        [0.94118, 'rgb(240,247,102)'],
        [0.9451, 'rgb(241,248,102)'],
        [0.94902, 'rgb(242,248,102)'],
        [0.95294, 'rgb(243,249,102)'],
        [0.95686, 'rgb(243,249,102)'],
        [0.96078, 'rgb(245,250,102)'],
        [0.96471, 'rgb(246,250,102)'],
        [0.96863, 'rgb(247,251,102)'],
        [0.97255, 'rgb(248,251,102)'],
        [0.97647, 'rgb(249,252,102)'],
        [0.98039, 'rgb(250,252,102)'],
        [0.98431, 'rgb(251,253,102)'],
        [0.98824, 'rgb(252,253,102)'],
        [0.99216, 'rgb(253,254,102)'],
        [0.99608, 'rgb(254,254,102)'],
        [1.0, 'rgb(255,255,102)'],
    ],
    'tab10': [
        [0.0, 'rgb(31,119,180)'],
        [0.00392, 'rgb(31,119,180)'],
        [0.00784, 'rgb(31,119,180)'],
        [0.01176, 'rgb(31,119,180)'],
        [0.01569, 'rgb(31,119,180)'],
        [0.01961, 'rgb(31,119,180)'],
        [0.02353, 'rgb(31,119,180)'],
        [0.02745, 'rgb(31,119,180)'],
        [0.03137, 'rgb(31,119,180)'],
        [0.03529, 'rgb(31,119,180)'],
        [0.03922, 'rgb(31,119,180)'],
        [0.04314, 'rgb(31,119,180)'],
        [0.04706, 'rgb(31,119,180)'],
        [0.05098, 'rgb(31,119,180)'],
        [0.0549, 'rgb(31,119,180)'],
        [0.05882, 'rgb(31,119,180)'],
        [0.06275, 'rgb(31,119,180)'],
        [0.06667, 'rgb(31,119,180)'],
        [0.07059, 'rgb(31,119,180)'],
        [0.07451, 'rgb(31,119,180)'],
        [0.07843, 'rgb(31,119,180)'],
        [0.08235, 'rgb(31,119,180)'],
        [0.08627, 'rgb(31,119,180)'],
        [0.0902, 'rgb(31,119,180)'],
        [0.09412, 'rgb(31,119,180)'],
        [0.09804, 'rgb(31,119,180)'],
        [0.10196, 'rgb(255,127,14)'],
        [0.10588, 'rgb(255,127,14)'],
        [0.1098, 'rgb(255,127,14)'],
        [0.11373, 'rgb(255,127,14)'],
        [0.11765, 'rgb(255,127,14)'],
        [0.12157, 'rgb(255,127,14)'],
        [0.12549, 'rgb(255,127,14)'],
        [0.12941, 'rgb(255,127,14)'],
        [0.13333, 'rgb(255,127,14)'],
        [0.13725, 'rgb(255,127,14)'],
        [0.14118, 'rgb(255,127,14)'],
        [0.1451, 'rgb(255,127,14)'],
        [0.14902, 'rgb(255,127,14)'],
        [0.15294, 'rgb(255,127,14)'],
        [0.15686, 'rgb(255,127,14)'],
        [0.16078, 'rgb(255,127,14)'],
        [0.16471, 'rgb(255,127,14)'],
        [0.16863, 'rgb(255,127,14)'],
        [0.17255, 'rgb(255,127,14)'],
        [0.17647, 'rgb(255,127,14)'],
        [0.18039, 'rgb(255,127,14)'],
        [0.18431, 'rgb(255,127,14)'],
        [0.18824, 'rgb(255,127,14)'],
        [0.19216, 'rgb(255,127,14)'],
        [0.19608, 'rgb(255,127,14)'],
        [0.2, 'rgb(44,160,44)'],
        [0.20392, 'rgb(44,160,44)'],
        [0.20784, 'rgb(44,160,44)'],
        [0.21176, 'rgb(44,160,44)'],
        [0.21569, 'rgb(44,160,44)'],
        [0.21961, 'rgb(44,160,44)'],
        [0.22353, 'rgb(44,160,44)'],
        [0.22745, 'rgb(44,160,44)'],
        [0.23137, 'rgb(44,160,44)'],
        [0.23529, 'rgb(44,160,44)'],
        [0.23922, 'rgb(44,160,44)'],
        [0.24314, 'rgb(44,160,44)'],
        [0.24706, 'rgb(44,160,44)'],
        [0.25098, 'rgb(44,160,44)'],
        [0.2549, 'rgb(44,160,44)'],
        [0.25882, 'rgb(44,160,44)'],
        [0.26275, 'rgb(44,160,44)'],
        [0.26667, 'rgb(44,160,44)'],
        [0.27059, 'rgb(44,160,44)'],
        [0.27451, 'rgb(44,160,44)'],
        [0.27843, 'rgb(44,160,44)'],
        [0.28235, 'rgb(44,160,44)'],
        [0.28627, 'rgb(44,160,44)'],
        [0.2902, 'rgb(44,160,44)'],
        [0.29412, 'rgb(44,160,44)'],
        [0.29804, 'rgb(44,160,44)'],
        [0.30196, 'rgb(214,39,40)'],
        [0.30588, 'rgb(214,39,40)'],
        [0.3098, 'rgb(214,39,40)'],
        [0.31373, 'rgb(214,39,40)'],
        [0.31765, 'rgb(214,39,40)'],
        [0.32157, 'rgb(214,39,40)'],
        [0.32549, 'rgb(214,39,40)'],
        [0.32941, 'rgb(214,39,40)'],
        [0.33333, 'rgb(214,39,40)'],
        [0.33725, 'rgb(214,39,40)'],
        [0.34118, 'rgb(214,39,40)'],
        [0.3451, 'rgb(214,39,40)'],
        [0.34902, 'rgb(214,39,40)'],
        [0.35294, 'rgb(214,39,40)'],
        [0.35686, 'rgb(214,39,40)'],
        [0.36078, 'rgb(214,39,40)'],
        [0.36471, 'rgb(214,39,40)'],
        [0.36863, 'rgb(214,39,40)'],
        [0.37255, 'rgb(214,39,40)'],
        [0.37647, 'rgb(214,39,40)'],
        [0.38039, 'rgb(214,39,40)'],
        [0.38431, 'rgb(214,39,40)'],
        [0.38824, 'rgb(214,39,40)'],
        [0.39216, 'rgb(214,39,40)'],
        [0.39608, 'rgb(214,39,40)'],
        [0.4, 'rgb(148,103,189)'],
        [0.40392, 'rgb(148,103,189)'],
        [0.40784, 'rgb(148,103,189)'],
        [0.41176, 'rgb(148,103,189)'],
        [0.41569, 'rgb(148,103,189)'],
        [0.41961, 'rgb(148,103,189)'],
        [0.42353, 'rgb(148,103,189)'],
        [0.42745, 'rgb(148,103,189)'],
        [0.43137, 'rgb(148,103,189)'],
        [0.43529, 'rgb(148,103,189)'],
        [0.43922, 'rgb(148,103,189)'],
        [0.44314, 'rgb(148,103,189)'],
        [0.44706, 'rgb(148,103,189)'],
        [0.45098, 'rgb(148,103,189)'],
        [0.4549, 'rgb(148,103,189)'],
        [0.45882, 'rgb(148,103,189)'],
        [0.46275, 'rgb(148,103,189)'],
        [0.46667, 'rgb(148,103,189)'],
        [0.47059, 'rgb(148,103,189)'],
        [0.47451, 'rgb(148,103,189)'],
        [0.47843, 'rgb(148,103,189)'],
        [0.48235, 'rgb(148,103,189)'],
        [0.48627, 'rgb(148,103,189)'],
        [0.4902, 'rgb(148,103,189)'],
        [0.49412, 'rgb(148,103,189)'],
        [0.49804, 'rgb(148,103,189)'],
        [0.50196, 'rgb(140,86,75)'],
        [0.50588, 'rgb(140,86,75)'],
        [0.5098, 'rgb(140,86,75)'],
        [0.51373, 'rgb(140,86,75)'],
        [0.51765, 'rgb(140,86,75)'],
        [0.52157, 'rgb(140,86,75)'],
        [0.52549, 'rgb(140,86,75)'],
        [0.52941, 'rgb(140,86,75)'],
        [0.53333, 'rgb(140,86,75)'],
        [0.53725, 'rgb(140,86,75)'],
        [0.54118, 'rgb(140,86,75)'],
        [0.5451, 'rgb(140,86,75)'],
        [0.54902, 'rgb(140,86,75)'],
        [0.55294, 'rgb(140,86,75)'],
        [0.55686, 'rgb(140,86,75)'],
        [0.56078, 'rgb(140,86,75)'],
        [0.56471, 'rgb(140,86,75)'],
        [0.56863, 'rgb(140,86,75)'],
        [0.57255, 'rgb(140,86,75)'],
        [0.57647, 'rgb(140,86,75)'],
        [0.58039, 'rgb(140,86,75)'],
        [0.58431, 'rgb(140,86,75)'],
        [0.58824, 'rgb(140,86,75)'],
        [0.59216, 'rgb(140,86,75)'],
        [0.59608, 'rgb(140,86,75)'],
        [0.6, 'rgb(227,119,194)'],
        [0.60392, 'rgb(227,119,194)'],
        [0.60784, 'rgb(227,119,194)'],
        [0.61176, 'rgb(227,119,194)'],
        [0.61569, 'rgb(227,119,194)'],
        [0.61961, 'rgb(227,119,194)'],
        [0.62353, 'rgb(227,119,194)'],
        [0.62745, 'rgb(227,119,194)'],
        [0.63137, 'rgb(227,119,194)'],
        [0.63529, 'rgb(227,119,194)'],
        [0.63922, 'rgb(227,119,194)'],
        [0.64314, 'rgb(227,119,194)'],
        [0.64706, 'rgb(227,119,194)'],
        [0.65098, 'rgb(227,119,194)'],
        [0.6549, 'rgb(227,119,194)'],
        [0.65882, 'rgb(227,119,194)'],
        [0.66275, 'rgb(227,119,194)'],
        [0.66667, 'rgb(227,119,194)'],
        [0.67059, 'rgb(227,119,194)'],
        [0.67451, 'rgb(227,119,194)'],
        [0.67843, 'rgb(227,119,194)'],
        [0.68235, 'rgb(227,119,194)'],
        [0.68627, 'rgb(227,119,194)'],
        [0.6902, 'rgb(227,119,194)'],
        [0.69412, 'rgb(227,119,194)'],
        [0.69804, 'rgb(227,119,194)'],
        [0.70196, 'rgb(127,127,127)'],
        [0.70588, 'rgb(127,127,127)'],
        [0.7098, 'rgb(127,127,127)'],
        [0.71373, 'rgb(127,127,127)'],
        [0.71765, 'rgb(127,127,127)'],
        [0.72157, 'rgb(127,127,127)'],
        [0.72549, 'rgb(127,127,127)'],
        [0.72941, 'rgb(127,127,127)'],
        [0.73333, 'rgb(127,127,127)'],
        [0.73725, 'rgb(127,127,127)'],
        [0.74118, 'rgb(127,127,127)'],
        [0.7451, 'rgb(127,127,127)'],
        [0.74902, 'rgb(127,127,127)'],
        [0.75294, 'rgb(127,127,127)'],
        [0.75686, 'rgb(127,127,127)'],
        [0.76078, 'rgb(127,127,127)'],
        [0.76471, 'rgb(127,127,127)'],
        [0.76863, 'rgb(127,127,127)'],
        [0.77255, 'rgb(127,127,127)'],
        [0.77647, 'rgb(127,127,127)'],
        [0.78039, 'rgb(127,127,127)'],
        [0.78431, 'rgb(127,127,127)'],
        [0.78824, 'rgb(127,127,127)'],
        [0.79216, 'rgb(127,127,127)'],
        [0.79608, 'rgb(127,127,127)'],
        [0.8, 'rgb(188,189,34)'],
        [0.80392, 'rgb(188,189,34)'],
        [0.80784, 'rgb(188,189,34)'],
        [0.81176, 'rgb(188,189,34)'],
        [0.81569, 'rgb(188,189,34)'],
        [0.81961, 'rgb(188,189,34)'],
        [0.82353, 'rgb(188,189,34)'],
        [0.82745, 'rgb(188,189,34)'],
        [0.83137, 'rgb(188,189,34)'],
        [0.83529, 'rgb(188,189,34)'],
        [0.83922, 'rgb(188,189,34)'],
        [0.84314, 'rgb(188,189,34)'],
        [0.84706, 'rgb(188,189,34)'],
        [0.85098, 'rgb(188,189,34)'],
        [0.8549, 'rgb(188,189,34)'],
        [0.85882, 'rgb(188,189,34)'],
        [0.86275, 'rgb(188,189,34)'],
        [0.86667, 'rgb(188,189,34)'],
        [0.87059, 'rgb(188,189,34)'],
        [0.87451, 'rgb(188,189,34)'],
        [0.87843, 'rgb(188,189,34)'],
        [0.88235, 'rgb(188,189,34)'],
        [0.88627, 'rgb(188,189,34)'],
        [0.8902, 'rgb(188,189,34)'],
        [0.89412, 'rgb(188,189,34)'],
        [0.89804, 'rgb(188,189,34)'],
        [0.90196, 'rgb(23,190,207)'],
        [0.90588, 'rgb(23,190,207)'],
        [0.9098, 'rgb(23,190,207)'],
        [0.91373, 'rgb(23,190,207)'],
        [0.91765, 'rgb(23,190,207)'],
        [0.92157, 'rgb(23,190,207)'],
        [0.92549, 'rgb(23,190,207)'],
        [0.92941, 'rgb(23,190,207)'],
        [0.93333, 'rgb(23,190,207)'],
        [0.93725, 'rgb(23,190,207)'],
        [0.94118, 'rgb(23,190,207)'],
        [0.9451, 'rgb(23,190,207)'],
        [0.94902, 'rgb(23,190,207)'],
        [0.95294, 'rgb(23,190,207)'],
        [0.95686, 'rgb(23,190,207)'],
        [0.96078, 'rgb(23,190,207)'],
        [0.96471, 'rgb(23,190,207)'],
        [0.96863, 'rgb(23,190,207)'],
        [0.97255, 'rgb(23,190,207)'],
        [0.97647, 'rgb(23,190,207)'],
        [0.98039, 'rgb(23,190,207)'],
        [0.98431, 'rgb(23,190,207)'],
        [0.98824, 'rgb(23,190,207)'],
        [0.99216, 'rgb(23,190,207)'],
        [0.99608, 'rgb(23,190,207)'],
        [1.0, 'rgb(23,190,207)'],
    ],
    'tab20': [
        [0.0, 'rgb(31,119,180)'],
        [0.00392, 'rgb(31,119,180)'],
        [0.00784, 'rgb(31,119,180)'],
        [0.01176, 'rgb(31,119,180)'],
        [0.01569, 'rgb(31,119,180)'],
        [0.01961, 'rgb(31,119,180)'],
        [0.02353, 'rgb(31,119,180)'],
        [0.02745, 'rgb(31,119,180)'],
        [0.03137, 'rgb(31,119,180)'],
        [0.03529, 'rgb(31,119,180)'],
        [0.03922, 'rgb(31,119,180)'],
        [0.04314, 'rgb(31,119,180)'],
        [0.04706, 'rgb(31,119,180)'],
        [0.05098, 'rgb(174,199,232)'],
        [0.0549, 'rgb(174,199,232)'],
        [0.05882, 'rgb(174,199,232)'],
        [0.06275, 'rgb(174,199,232)'],
        [0.06667, 'rgb(174,199,232)'],
        [0.07059, 'rgb(174,199,232)'],
        [0.07451, 'rgb(174,199,232)'],
        [0.07843, 'rgb(174,199,232)'],
        [0.08235, 'rgb(174,199,232)'],
        [0.08627, 'rgb(174,199,232)'],
        [0.0902, 'rgb(174,199,232)'],
        [0.09412, 'rgb(174,199,232)'],
        [0.09804, 'rgb(174,199,232)'],
        [0.10196, 'rgb(255,127,14)'],
        [0.10588, 'rgb(255,127,14)'],
        [0.1098, 'rgb(255,127,14)'],
        [0.11373, 'rgb(255,127,14)'],
        [0.11765, 'rgb(255,127,14)'],
        [0.12157, 'rgb(255,127,14)'],
        [0.12549, 'rgb(255,127,14)'],
        [0.12941, 'rgb(255,127,14)'],
        [0.13333, 'rgb(255,127,14)'],
        [0.13725, 'rgb(255,127,14)'],
        [0.14118, 'rgb(255,127,14)'],
        [0.1451, 'rgb(255,127,14)'],
        [0.14902, 'rgb(255,127,14)'],
        [0.15294, 'rgb(255,187,120)'],
        [0.15686, 'rgb(255,187,120)'],
        [0.16078, 'rgb(255,187,120)'],
        [0.16471, 'rgb(255,187,120)'],
        [0.16863, 'rgb(255,187,120)'],
        [0.17255, 'rgb(255,187,120)'],
        [0.17647, 'rgb(255,187,120)'],
        [0.18039, 'rgb(255,187,120)'],
        [0.18431, 'rgb(255,187,120)'],
        [0.18824, 'rgb(255,187,120)'],
        [0.19216, 'rgb(255,187,120)'],
        [0.19608, 'rgb(255,187,120)'],
        [0.2, 'rgb(44,160,44)'],
        [0.20392, 'rgb(44,160,44)'],
        [0.20784, 'rgb(44,160,44)'],
        [0.21176, 'rgb(44,160,44)'],
        [0.21569, 'rgb(44,160,44)'],
        [0.21961, 'rgb(44,160,44)'],
        [0.22353, 'rgb(44,160,44)'],
        [0.22745, 'rgb(44,160,44)'],
        [0.23137, 'rgb(44,160,44)'],
        [0.23529, 'rgb(44,160,44)'],
        [0.23922, 'rgb(44,160,44)'],
        [0.24314, 'rgb(44,160,44)'],
        [0.24706, 'rgb(44,160,44)'],
        [0.25098, 'rgb(152,223,138)'],
        [0.2549, 'rgb(152,223,138)'],
        [0.25882, 'rgb(152,223,138)'],
        [0.26275, 'rgb(152,223,138)'],
        [0.26667, 'rgb(152,223,138)'],
        [0.27059, 'rgb(152,223,138)'],
        [0.27451, 'rgb(152,223,138)'],
        [0.27843, 'rgb(152,223,138)'],
        [0.28235, 'rgb(152,223,138)'],
        [0.28627, 'rgb(152,223,138)'],
        [0.2902, 'rgb(152,223,138)'],
        [0.29412, 'rgb(152,223,138)'],
        [0.29804, 'rgb(152,223,138)'],
        [0.30196, 'rgb(214,39,40)'],
        [0.30588, 'rgb(214,39,40)'],
        [0.3098, 'rgb(214,39,40)'],
        [0.31373, 'rgb(214,39,40)'],
        [0.31765, 'rgb(214,39,40)'],
        [0.32157, 'rgb(214,39,40)'],
        [0.32549, 'rgb(214,39,40)'],
        [0.32941, 'rgb(214,39,40)'],
        [0.33333, 'rgb(214,39,40)'],
        [0.33725, 'rgb(214,39,40)'],
        [0.34118, 'rgb(214,39,40)'],
        [0.3451, 'rgb(214,39,40)'],
        [0.34902, 'rgb(214,39,40)'],
        [0.35294, 'rgb(255,152,150)'],
        [0.35686, 'rgb(255,152,150)'],
        [0.36078, 'rgb(255,152,150)'],
        [0.36471, 'rgb(255,152,150)'],
        [0.36863, 'rgb(255,152,150)'],
        [0.37255, 'rgb(255,152,150)'],
        [0.37647, 'rgb(255,152,150)'],
        [0.38039, 'rgb(255,152,150)'],
        [0.38431, 'rgb(255,152,150)'],
        [0.38824, 'rgb(255,152,150)'],
        [0.39216, 'rgb(255,152,150)'],
        [0.39608, 'rgb(255,152,150)'],
        [0.4, 'rgb(148,103,189)'],
        [0.40392, 'rgb(148,103,189)'],
        [0.40784, 'rgb(148,103,189)'],
        [0.41176, 'rgb(148,103,189)'],
        [0.41569, 'rgb(148,103,189)'],
        [0.41961, 'rgb(148,103,189)'],
        [0.42353, 'rgb(148,103,189)'],
        [0.42745, 'rgb(148,103,189)'],
        [0.43137, 'rgb(148,103,189)'],
        [0.43529, 'rgb(148,103,189)'],
        [0.43922, 'rgb(148,103,189)'],
        [0.44314, 'rgb(148,103,189)'],
        [0.44706, 'rgb(148,103,189)'],
        [0.45098, 'rgb(197,176,213)'],
        [0.4549, 'rgb(197,176,213)'],
        [0.45882, 'rgb(197,176,213)'],
        [0.46275, 'rgb(197,176,213)'],
        [0.46667, 'rgb(197,176,213)'],
        [0.47059, 'rgb(197,176,213)'],
        [0.47451, 'rgb(197,176,213)'],
        [0.47843, 'rgb(197,176,213)'],
        [0.48235, 'rgb(197,176,213)'],
        [0.48627, 'rgb(197,176,213)'],
        [0.4902, 'rgb(197,176,213)'],
        [0.49412, 'rgb(197,176,213)'],
        [0.49804, 'rgb(197,176,213)'],
        [0.50196, 'rgb(140,86,75)'],
        [0.50588, 'rgb(140,86,75)'],
        [0.5098, 'rgb(140,86,75)'],
        [0.51373, 'rgb(140,86,75)'],
        [0.51765, 'rgb(140,86,75)'],
        [0.52157, 'rgb(140,86,75)'],
        [0.52549, 'rgb(140,86,75)'],
        [0.52941, 'rgb(140,86,75)'],
        [0.53333, 'rgb(140,86,75)'],
        [0.53725, 'rgb(140,86,75)'],
        [0.54118, 'rgb(140,86,75)'],
        [0.5451, 'rgb(140,86,75)'],
        [0.54902, 'rgb(140,86,75)'],
        [0.55294, 'rgb(196,156,148)'],
        [0.55686, 'rgb(196,156,148)'],
        [0.56078, 'rgb(196,156,148)'],
        [0.56471, 'rgb(196,156,148)'],
        [0.56863, 'rgb(196,156,148)'],
        [0.57255, 'rgb(196,156,148)'],
        [0.57647, 'rgb(196,156,148)'],
        [0.58039, 'rgb(196,156,148)'],
        [0.58431, 'rgb(196,156,148)'],
        [0.58824, 'rgb(196,156,148)'],
        [0.59216, 'rgb(196,156,148)'],
        [0.59608, 'rgb(196,156,148)'],
        [0.6, 'rgb(227,119,194)'],
        [0.60392, 'rgb(227,119,194)'],
        [0.60784, 'rgb(227,119,194)'],
        [0.61176, 'rgb(227,119,194)'],
        [0.61569, 'rgb(227,119,194)'],
        [0.61961, 'rgb(227,119,194)'],
        [0.62353, 'rgb(227,119,194)'],
        [0.62745, 'rgb(227,119,194)'],
        [0.63137, 'rgb(227,119,194)'],
        [0.63529, 'rgb(227,119,194)'],
        [0.63922, 'rgb(227,119,194)'],
        [0.64314, 'rgb(227,119,194)'],
        [0.64706, 'rgb(227,119,194)'],
        [0.65098, 'rgb(247,182,210)'],
        [0.6549, 'rgb(247,182,210)'],
        [0.65882, 'rgb(247,182,210)'],
        [0.66275, 'rgb(247,182,210)'],
        [0.66667, 'rgb(247,182,210)'],
        [0.67059, 'rgb(247,182,210)'],
        [0.67451, 'rgb(247,182,210)'],
        [0.67843, 'rgb(247,182,210)'],
        [0.68235, 'rgb(247,182,210)'],
        [0.68627, 'rgb(247,182,210)'],
        [0.6902, 'rgb(247,182,210)'],
        [0.69412, 'rgb(247,182,210)'],
        [0.69804, 'rgb(247,182,210)'],
        [0.70196, 'rgb(127,127,127)'],
        [0.70588, 'rgb(127,127,127)'],
        [0.7098, 'rgb(127,127,127)'],
        [0.71373, 'rgb(127,127,127)'],
        [0.71765, 'rgb(127,127,127)'],
        [0.72157, 'rgb(127,127,127)'],
        [0.72549, 'rgb(127,127,127)'],
        [0.72941, 'rgb(127,127,127)'],
        [0.73333, 'rgb(127,127,127)'],
        [0.73725, 'rgb(127,127,127)'],
        [0.74118, 'rgb(127,127,127)'],
        [0.7451, 'rgb(127,127,127)'],
        [0.74902, 'rgb(127,127,127)'],
        [0.75294, 'rgb(199,199,199)'],
        [0.75686, 'rgb(199,199,199)'],
        [0.76078, 'rgb(199,199,199)'],
        [0.76471, 'rgb(199,199,199)'],
        [0.76863, 'rgb(199,199,199)'],
        [0.77255, 'rgb(199,199,199)'],
        [0.77647, 'rgb(199,199,199)'],
        [0.78039, 'rgb(199,199,199)'],
        [0.78431, 'rgb(199,199,199)'],
        [0.78824, 'rgb(199,199,199)'],
        [0.79216, 'rgb(199,199,199)'],
        [0.79608, 'rgb(199,199,199)'],
        [0.8, 'rgb(188,189,34)'],
        [0.80392, 'rgb(188,189,34)'],
        [0.80784, 'rgb(188,189,34)'],
        [0.81176, 'rgb(188,189,34)'],
        [0.81569, 'rgb(188,189,34)'],
        [0.81961, 'rgb(188,189,34)'],
        [0.82353, 'rgb(188,189,34)'],
        [0.82745, 'rgb(188,189,34)'],
        [0.83137, 'rgb(188,189,34)'],
        [0.83529, 'rgb(188,189,34)'],
        [0.83922, 'rgb(188,189,34)'],
        [0.84314, 'rgb(188,189,34)'],
        [0.84706, 'rgb(188,189,34)'],
        [0.85098, 'rgb(219,219,141)'],
        [0.8549, 'rgb(219,219,141)'],
        [0.85882, 'rgb(219,219,141)'],
        [0.86275, 'rgb(219,219,141)'],
        [0.86667, 'rgb(219,219,141)'],
        [0.87059, 'rgb(219,219,141)'],
        [0.87451, 'rgb(219,219,141)'],
        [0.87843, 'rgb(219,219,141)'],
        [0.88235, 'rgb(219,219,141)'],
        [0.88627, 'rgb(219,219,141)'],
        [0.8902, 'rgb(219,219,141)'],
        [0.89412, 'rgb(219,219,141)'],
        [0.89804, 'rgb(219,219,141)'],
        [0.90196, 'rgb(23,190,207)'],
        [0.90588, 'rgb(23,190,207)'],
        [0.9098, 'rgb(23,190,207)'],
        [0.91373, 'rgb(23,190,207)'],
        [0.91765, 'rgb(23,190,207)'],
        [0.92157, 'rgb(23,190,207)'],
        [0.92549, 'rgb(23,190,207)'],
        [0.92941, 'rgb(23,190,207)'],
        [0.93333, 'rgb(23,190,207)'],
        [0.93725, 'rgb(23,190,207)'],
        [0.94118, 'rgb(23,190,207)'],
        [0.9451, 'rgb(23,190,207)'],
        [0.94902, 'rgb(23,190,207)'],
        [0.95294, 'rgb(158,218,229)'],
        [0.95686, 'rgb(158,218,229)'],
        [0.96078, 'rgb(158,218,229)'],
        [0.96471, 'rgb(158,218,229)'],
        [0.96863, 'rgb(158,218,229)'],
        [0.97255, 'rgb(158,218,229)'],
        [0.97647, 'rgb(158,218,229)'],
        [0.98039, 'rgb(158,218,229)'],
        [0.98431, 'rgb(158,218,229)'],
        [0.98824, 'rgb(158,218,229)'],
        [0.99216, 'rgb(158,218,229)'],
        [0.99608, 'rgb(158,218,229)'],
        [1.0, 'rgb(158,218,229)'],
    ],
    'tab20b': [
        [0.0, 'rgb(57,59,121)'],
        [0.00392, 'rgb(57,59,121)'],
        [0.00784, 'rgb(57,59,121)'],
        [0.01176, 'rgb(57,59,121)'],
        [0.01569, 'rgb(57,59,121)'],
        [0.01961, 'rgb(57,59,121)'],
        [0.02353, 'rgb(57,59,121)'],
        [0.02745, 'rgb(57,59,121)'],
        [0.03137, 'rgb(57,59,121)'],
        [0.03529, 'rgb(57,59,121)'],
        [0.03922, 'rgb(57,59,121)'],
        [0.04314, 'rgb(57,59,121)'],
        [0.04706, 'rgb(57,59,121)'],
        [0.05098, 'rgb(82,84,163)'],
        [0.0549, 'rgb(82,84,163)'],
        [0.05882, 'rgb(82,84,163)'],
        [0.06275, 'rgb(82,84,163)'],
        [0.06667, 'rgb(82,84,163)'],
        [0.07059, 'rgb(82,84,163)'],
        [0.07451, 'rgb(82,84,163)'],
        [0.07843, 'rgb(82,84,163)'],
        [0.08235, 'rgb(82,84,163)'],
        [0.08627, 'rgb(82,84,163)'],
        [0.0902, 'rgb(82,84,163)'],
        [0.09412, 'rgb(82,84,163)'],
        [0.09804, 'rgb(82,84,163)'],
        [0.10196, 'rgb(107,110,207)'],
        [0.10588, 'rgb(107,110,207)'],
        [0.1098, 'rgb(107,110,207)'],
        [0.11373, 'rgb(107,110,207)'],
        [0.11765, 'rgb(107,110,207)'],
        [0.12157, 'rgb(107,110,207)'],
        [0.12549, 'rgb(107,110,207)'],
        [0.12941, 'rgb(107,110,207)'],
        [0.13333, 'rgb(107,110,207)'],
        [0.13725, 'rgb(107,110,207)'],
        [0.14118, 'rgb(107,110,207)'],
        [0.1451, 'rgb(107,110,207)'],
        [0.14902, 'rgb(107,110,207)'],
        [0.15294, 'rgb(156,158,222)'],
        [0.15686, 'rgb(156,158,222)'],
        [0.16078, 'rgb(156,158,222)'],
        [0.16471, 'rgb(156,158,222)'],
        [0.16863, 'rgb(156,158,222)'],
        [0.17255, 'rgb(156,158,222)'],
        [0.17647, 'rgb(156,158,222)'],
        [0.18039, 'rgb(156,158,222)'],
        [0.18431, 'rgb(156,158,222)'],
        [0.18824, 'rgb(156,158,222)'],
        [0.19216, 'rgb(156,158,222)'],
        [0.19608, 'rgb(156,158,222)'],
        [0.2, 'rgb(99,121,57)'],
        [0.20392, 'rgb(99,121,57)'],
        [0.20784, 'rgb(99,121,57)'],
        [0.21176, 'rgb(99,121,57)'],
        [0.21569, 'rgb(99,121,57)'],
        [0.21961, 'rgb(99,121,57)'],
        [0.22353, 'rgb(99,121,57)'],
        [0.22745, 'rgb(99,121,57)'],
        [0.23137, 'rgb(99,121,57)'],
        [0.23529, 'rgb(99,121,57)'],
        [0.23922, 'rgb(99,121,57)'],
        [0.24314, 'rgb(99,121,57)'],
        [0.24706, 'rgb(99,121,57)'],
        [0.25098, 'rgb(140,162,82)'],
        [0.2549, 'rgb(140,162,82)'],
        [0.25882, 'rgb(140,162,82)'],
        [0.26275, 'rgb(140,162,82)'],
        [0.26667, 'rgb(140,162,82)'],
        [0.27059, 'rgb(140,162,82)'],
        [0.27451, 'rgb(140,162,82)'],
        [0.27843, 'rgb(140,162,82)'],
        [0.28235, 'rgb(140,162,82)'],
        [0.28627, 'rgb(140,162,82)'],
        [0.2902, 'rgb(140,162,82)'],
        [0.29412, 'rgb(140,162,82)'],
        [0.29804, 'rgb(140,162,82)'],
        [0.30196, 'rgb(181,207,107)'],
        [0.30588, 'rgb(181,207,107)'],
        [0.3098, 'rgb(181,207,107)'],
        [0.31373, 'rgb(181,207,107)'],
        [0.31765, 'rgb(181,207,107)'],
        [0.32157, 'rgb(181,207,107)'],
        [0.32549, 'rgb(181,207,107)'],
        [0.32941, 'rgb(181,207,107)'],
        [0.33333, 'rgb(181,207,107)'],
        [0.33725, 'rgb(181,207,107)'],
        [0.34118, 'rgb(181,207,107)'],
        [0.3451, 'rgb(181,207,107)'],
        [0.34902, 'rgb(181,207,107)'],
        [0.35294, 'rgb(206,219,156)'],
        [0.35686, 'rgb(206,219,156)'],
        [0.36078, 'rgb(206,219,156)'],
        [0.36471, 'rgb(206,219,156)'],
        [0.36863, 'rgb(206,219,156)'],
        [0.37255, 'rgb(206,219,156)'],
        [0.37647, 'rgb(206,219,156)'],
        [0.38039, 'rgb(206,219,156)'],
        [0.38431, 'rgb(206,219,156)'],
        [0.38824, 'rgb(206,219,156)'],
        [0.39216, 'rgb(206,219,156)'],
        [0.39608, 'rgb(206,219,156)'],
        [0.4, 'rgb(140,109,49)'],
        [0.40392, 'rgb(140,109,49)'],
        [0.40784, 'rgb(140,109,49)'],
        [0.41176, 'rgb(140,109,49)'],
        [0.41569, 'rgb(140,109,49)'],
        [0.41961, 'rgb(140,109,49)'],
        [0.42353, 'rgb(140,109,49)'],
        [0.42745, 'rgb(140,109,49)'],
        [0.43137, 'rgb(140,109,49)'],
        [0.43529, 'rgb(140,109,49)'],
        [0.43922, 'rgb(140,109,49)'],
        [0.44314, 'rgb(140,109,49)'],
        [0.44706, 'rgb(140,109,49)'],
        [0.45098, 'rgb(189,158,57)'],
        [0.4549, 'rgb(189,158,57)'],
        [0.45882, 'rgb(189,158,57)'],
        [0.46275, 'rgb(189,158,57)'],
        [0.46667, 'rgb(189,158,57)'],
        [0.47059, 'rgb(189,158,57)'],
        [0.47451, 'rgb(189,158,57)'],
        [0.47843, 'rgb(189,158,57)'],
        [0.48235, 'rgb(189,158,57)'],
        [0.48627, 'rgb(189,158,57)'],
        [0.4902, 'rgb(189,158,57)'],
        [0.49412, 'rgb(189,158,57)'],
        [0.49804, 'rgb(189,158,57)'],
        [0.50196, 'rgb(231,186,82)'],
        [0.50588, 'rgb(231,186,82)'],
        [0.5098, 'rgb(231,186,82)'],
        [0.51373, 'rgb(231,186,82)'],
        [0.51765, 'rgb(231,186,82)'],
        [0.52157, 'rgb(231,186,82)'],
        [0.52549, 'rgb(231,186,82)'],
        [0.52941, 'rgb(231,186,82)'],
        [0.53333, 'rgb(231,186,82)'],
        [0.53725, 'rgb(231,186,82)'],
        [0.54118, 'rgb(231,186,82)'],
        [0.5451, 'rgb(231,186,82)'],
        [0.54902, 'rgb(231,186,82)'],
        [0.55294, 'rgb(231,203,148)'],
        [0.55686, 'rgb(231,203,148)'],
        [0.56078, 'rgb(231,203,148)'],
        [0.56471, 'rgb(231,203,148)'],
        [0.56863, 'rgb(231,203,148)'],
        [0.57255, 'rgb(231,203,148)'],
        [0.57647, 'rgb(231,203,148)'],
        [0.58039, 'rgb(231,203,148)'],
        [0.58431, 'rgb(231,203,148)'],
        [0.58824, 'rgb(231,203,148)'],
        [0.59216, 'rgb(231,203,148)'],
        [0.59608, 'rgb(231,203,148)'],
        [0.6, 'rgb(132,60,57)'],
        [0.60392, 'rgb(132,60,57)'],
        [0.60784, 'rgb(132,60,57)'],
        [0.61176, 'rgb(132,60,57)'],
        [0.61569, 'rgb(132,60,57)'],
        [0.61961, 'rgb(132,60,57)'],
        [0.62353, 'rgb(132,60,57)'],
        [0.62745, 'rgb(132,60,57)'],
        [0.63137, 'rgb(132,60,57)'],
        [0.63529, 'rgb(132,60,57)'],
        [0.63922, 'rgb(132,60,57)'],
        [0.64314, 'rgb(132,60,57)'],
        [0.64706, 'rgb(132,60,57)'],
        [0.65098, 'rgb(173,73,74)'],
        [0.6549, 'rgb(173,73,74)'],
        [0.65882, 'rgb(173,73,74)'],
        [0.66275, 'rgb(173,73,74)'],
        [0.66667, 'rgb(173,73,74)'],
        [0.67059, 'rgb(173,73,74)'],
        [0.67451, 'rgb(173,73,74)'],
        [0.67843, 'rgb(173,73,74)'],
        [0.68235, 'rgb(173,73,74)'],
        [0.68627, 'rgb(173,73,74)'],
        [0.6902, 'rgb(173,73,74)'],
        [0.69412, 'rgb(173,73,74)'],
        [0.69804, 'rgb(173,73,74)'],
        [0.70196, 'rgb(214,97,107)'],
        [0.70588, 'rgb(214,97,107)'],
        [0.7098, 'rgb(214,97,107)'],
        [0.71373, 'rgb(214,97,107)'],
        [0.71765, 'rgb(214,97,107)'],
        [0.72157, 'rgb(214,97,107)'],
        [0.72549, 'rgb(214,97,107)'],
        [0.72941, 'rgb(214,97,107)'],
        [0.73333, 'rgb(214,97,107)'],
        [0.73725, 'rgb(214,97,107)'],
        [0.74118, 'rgb(214,97,107)'],
        [0.7451, 'rgb(214,97,107)'],
        [0.74902, 'rgb(214,97,107)'],
        [0.75294, 'rgb(231,150,156)'],
        [0.75686, 'rgb(231,150,156)'],
        [0.76078, 'rgb(231,150,156)'],
        [0.76471, 'rgb(231,150,156)'],
        [0.76863, 'rgb(231,150,156)'],
        [0.77255, 'rgb(231,150,156)'],
        [0.77647, 'rgb(231,150,156)'],
        [0.78039, 'rgb(231,150,156)'],
        [0.78431, 'rgb(231,150,156)'],
        [0.78824, 'rgb(231,150,156)'],
        [0.79216, 'rgb(231,150,156)'],
        [0.79608, 'rgb(231,150,156)'],
        [0.8, 'rgb(123,65,115)'],
        [0.80392, 'rgb(123,65,115)'],
        [0.80784, 'rgb(123,65,115)'],
        [0.81176, 'rgb(123,65,115)'],
        [0.81569, 'rgb(123,65,115)'],
        [0.81961, 'rgb(123,65,115)'],
        [0.82353, 'rgb(123,65,115)'],
        [0.82745, 'rgb(123,65,115)'],
        [0.83137, 'rgb(123,65,115)'],
        [0.83529, 'rgb(123,65,115)'],
        [0.83922, 'rgb(123,65,115)'],
        [0.84314, 'rgb(123,65,115)'],
        [0.84706, 'rgb(123,65,115)'],
        [0.85098, 'rgb(165,81,148)'],
        [0.8549, 'rgb(165,81,148)'],
        [0.85882, 'rgb(165,81,148)'],
        [0.86275, 'rgb(165,81,148)'],
        [0.86667, 'rgb(165,81,148)'],
        [0.87059, 'rgb(165,81,148)'],
        [0.87451, 'rgb(165,81,148)'],
        [0.87843, 'rgb(165,81,148)'],
        [0.88235, 'rgb(165,81,148)'],
        [0.88627, 'rgb(165,81,148)'],
        [0.8902, 'rgb(165,81,148)'],
        [0.89412, 'rgb(165,81,148)'],
        [0.89804, 'rgb(165,81,148)'],
        [0.90196, 'rgb(206,109,189)'],
        [0.90588, 'rgb(206,109,189)'],
        [0.9098, 'rgb(206,109,189)'],
        [0.91373, 'rgb(206,109,189)'],
        [0.91765, 'rgb(206,109,189)'],
        [0.92157, 'rgb(206,109,189)'],
        [0.92549, 'rgb(206,109,189)'],
        [0.92941, 'rgb(206,109,189)'],
        [0.93333, 'rgb(206,109,189)'],
        [0.93725, 'rgb(206,109,189)'],
        [0.94118, 'rgb(206,109,189)'],
        [0.9451, 'rgb(206,109,189)'],
        [0.94902, 'rgb(206,109,189)'],
        [0.95294, 'rgb(222,158,214)'],
        [0.95686, 'rgb(222,158,214)'],
        [0.96078, 'rgb(222,158,214)'],
        [0.96471, 'rgb(222,158,214)'],
        [0.96863, 'rgb(222,158,214)'],
        [0.97255, 'rgb(222,158,214)'],
        [0.97647, 'rgb(222,158,214)'],
        [0.98039, 'rgb(222,158,214)'],
        [0.98431, 'rgb(222,158,214)'],
        [0.98824, 'rgb(222,158,214)'],
        [0.99216, 'rgb(222,158,214)'],
        [0.99608, 'rgb(222,158,214)'],
        [1.0, 'rgb(222,158,214)'],
    ],
    'tab20c': [
        [0.0, 'rgb(49,130,189)'],
        [0.00392, 'rgb(49,130,189)'],
        [0.00784, 'rgb(49,130,189)'],
        [0.01176, 'rgb(49,130,189)'],
        [0.01569, 'rgb(49,130,189)'],
        [0.01961, 'rgb(49,130,189)'],
        [0.02353, 'rgb(49,130,189)'],
        [0.02745, 'rgb(49,130,189)'],
        [0.03137, 'rgb(49,130,189)'],
        [0.03529, 'rgb(49,130,189)'],
        [0.03922, 'rgb(49,130,189)'],
        [0.04314, 'rgb(49,130,189)'],
        [0.04706, 'rgb(49,130,189)'],
        [0.05098, 'rgb(107,174,214)'],
        [0.0549, 'rgb(107,174,214)'],
        [0.05882, 'rgb(107,174,214)'],
        [0.06275, 'rgb(107,174,214)'],
        [0.06667, 'rgb(107,174,214)'],
        [0.07059, 'rgb(107,174,214)'],
        [0.07451, 'rgb(107,174,214)'],
        [0.07843, 'rgb(107,174,214)'],
        [0.08235, 'rgb(107,174,214)'],
        [0.08627, 'rgb(107,174,214)'],
        [0.0902, 'rgb(107,174,214)'],
        [0.09412, 'rgb(107,174,214)'],
        [0.09804, 'rgb(107,174,214)'],
        [0.10196, 'rgb(158,202,225)'],
        [0.10588, 'rgb(158,202,225)'],
        [0.1098, 'rgb(158,202,225)'],
        [0.11373, 'rgb(158,202,225)'],
        [0.11765, 'rgb(158,202,225)'],
        [0.12157, 'rgb(158,202,225)'],
        [0.12549, 'rgb(158,202,225)'],
        [0.12941, 'rgb(158,202,225)'],
        [0.13333, 'rgb(158,202,225)'],
        [0.13725, 'rgb(158,202,225)'],
        [0.14118, 'rgb(158,202,225)'],
        [0.1451, 'rgb(158,202,225)'],
        [0.14902, 'rgb(158,202,225)'],
        [0.15294, 'rgb(198,219,239)'],
        [0.15686, 'rgb(198,219,239)'],
        [0.16078, 'rgb(198,219,239)'],
        [0.16471, 'rgb(198,219,239)'],
        [0.16863, 'rgb(198,219,239)'],
        [0.17255, 'rgb(198,219,239)'],
        [0.17647, 'rgb(198,219,239)'],
        [0.18039, 'rgb(198,219,239)'],
        [0.18431, 'rgb(198,219,239)'],
        [0.18824, 'rgb(198,219,239)'],
        [0.19216, 'rgb(198,219,239)'],
        [0.19608, 'rgb(198,219,239)'],
        [0.2, 'rgb(230,85,13)'],
        [0.20392, 'rgb(230,85,13)'],
        [0.20784, 'rgb(230,85,13)'],
        [0.21176, 'rgb(230,85,13)'],
        [0.21569, 'rgb(230,85,13)'],
        [0.21961, 'rgb(230,85,13)'],
        [0.22353, 'rgb(230,85,13)'],
        [0.22745, 'rgb(230,85,13)'],
        [0.23137, 'rgb(230,85,13)'],
        [0.23529, 'rgb(230,85,13)'],
        [0.23922, 'rgb(230,85,13)'],
        [0.24314, 'rgb(230,85,13)'],
        [0.24706, 'rgb(230,85,13)'],
        [0.25098, 'rgb(253,141,60)'],
        [0.2549, 'rgb(253,141,60)'],
        [0.25882, 'rgb(253,141,60)'],
        [0.26275, 'rgb(253,141,60)'],
        [0.26667, 'rgb(253,141,60)'],
        [0.27059, 'rgb(253,141,60)'],
        [0.27451, 'rgb(253,141,60)'],
        [0.27843, 'rgb(253,141,60)'],
        [0.28235, 'rgb(253,141,60)'],
        [0.28627, 'rgb(253,141,60)'],
        [0.2902, 'rgb(253,141,60)'],
        [0.29412, 'rgb(253,141,60)'],
        [0.29804, 'rgb(253,141,60)'],
        [0.30196, 'rgb(253,174,107)'],
        [0.30588, 'rgb(253,174,107)'],
        [0.3098, 'rgb(253,174,107)'],
        [0.31373, 'rgb(253,174,107)'],
        [0.31765, 'rgb(253,174,107)'],
        [0.32157, 'rgb(253,174,107)'],
        [0.32549, 'rgb(253,174,107)'],
        [0.32941, 'rgb(253,174,107)'],
        [0.33333, 'rgb(253,174,107)'],
        [0.33725, 'rgb(253,174,107)'],
        [0.34118, 'rgb(253,174,107)'],
        [0.3451, 'rgb(253,174,107)'],
        [0.34902, 'rgb(253,174,107)'],
        [0.35294, 'rgb(253,208,162)'],
        [0.35686, 'rgb(253,208,162)'],
        [0.36078, 'rgb(253,208,162)'],
        [0.36471, 'rgb(253,208,162)'],
        [0.36863, 'rgb(253,208,162)'],
        [0.37255, 'rgb(253,208,162)'],
        [0.37647, 'rgb(253,208,162)'],
        [0.38039, 'rgb(253,208,162)'],
        [0.38431, 'rgb(253,208,162)'],
        [0.38824, 'rgb(253,208,162)'],
        [0.39216, 'rgb(253,208,162)'],
        [0.39608, 'rgb(253,208,162)'],
        [0.4, 'rgb(49,163,84)'],
        [0.40392, 'rgb(49,163,84)'],
        [0.40784, 'rgb(49,163,84)'],
        [0.41176, 'rgb(49,163,84)'],
        [0.41569, 'rgb(49,163,84)'],
        [0.41961, 'rgb(49,163,84)'],
        [0.42353, 'rgb(49,163,84)'],
        [0.42745, 'rgb(49,163,84)'],
        [0.43137, 'rgb(49,163,84)'],
        [0.43529, 'rgb(49,163,84)'],
        [0.43922, 'rgb(49,163,84)'],
        [0.44314, 'rgb(49,163,84)'],
        [0.44706, 'rgb(49,163,84)'],
        [0.45098, 'rgb(116,196,118)'],
        [0.4549, 'rgb(116,196,118)'],
        [0.45882, 'rgb(116,196,118)'],
        [0.46275, 'rgb(116,196,118)'],
        [0.46667, 'rgb(116,196,118)'],
        [0.47059, 'rgb(116,196,118)'],
        [0.47451, 'rgb(116,196,118)'],
        [0.47843, 'rgb(116,196,118)'],
        [0.48235, 'rgb(116,196,118)'],
        [0.48627, 'rgb(116,196,118)'],
        [0.4902, 'rgb(116,196,118)'],
        [0.49412, 'rgb(116,196,118)'],
        [0.49804, 'rgb(116,196,118)'],
        [0.50196, 'rgb(161,217,155)'],
        [0.50588, 'rgb(161,217,155)'],
        [0.5098, 'rgb(161,217,155)'],
        [0.51373, 'rgb(161,217,155)'],
        [0.51765, 'rgb(161,217,155)'],
        [0.52157, 'rgb(161,217,155)'],
        [0.52549, 'rgb(161,217,155)'],
        [0.52941, 'rgb(161,217,155)'],
        [0.53333, 'rgb(161,217,155)'],
        [0.53725, 'rgb(161,217,155)'],
        [0.54118, 'rgb(161,217,155)'],
        [0.5451, 'rgb(161,217,155)'],
        [0.54902, 'rgb(161,217,155)'],
        [0.55294, 'rgb(199,233,192)'],
        [0.55686, 'rgb(199,233,192)'],
        [0.56078, 'rgb(199,233,192)'],
        [0.56471, 'rgb(199,233,192)'],
        [0.56863, 'rgb(199,233,192)'],
        [0.57255, 'rgb(199,233,192)'],
        [0.57647, 'rgb(199,233,192)'],
        [0.58039, 'rgb(199,233,192)'],
        [0.58431, 'rgb(199,233,192)'],
        [0.58824, 'rgb(199,233,192)'],
        [0.59216, 'rgb(199,233,192)'],
        [0.59608, 'rgb(199,233,192)'],
        [0.6, 'rgb(117,107,177)'],
        [0.60392, 'rgb(117,107,177)'],
        [0.60784, 'rgb(117,107,177)'],
        [0.61176, 'rgb(117,107,177)'],
        [0.61569, 'rgb(117,107,177)'],
        [0.61961, 'rgb(117,107,177)'],
        [0.62353, 'rgb(117,107,177)'],
        [0.62745, 'rgb(117,107,177)'],
        [0.63137, 'rgb(117,107,177)'],
        [0.63529, 'rgb(117,107,177)'],
        [0.63922, 'rgb(117,107,177)'],
        [0.64314, 'rgb(117,107,177)'],
        [0.64706, 'rgb(117,107,177)'],
        [0.65098, 'rgb(158,154,200)'],
        [0.6549, 'rgb(158,154,200)'],
        [0.65882, 'rgb(158,154,200)'],
        [0.66275, 'rgb(158,154,200)'],
        [0.66667, 'rgb(158,154,200)'],
        [0.67059, 'rgb(158,154,200)'],
        [0.67451, 'rgb(158,154,200)'],
        [0.67843, 'rgb(158,154,200)'],
        [0.68235, 'rgb(158,154,200)'],
        [0.68627, 'rgb(158,154,200)'],
        [0.6902, 'rgb(158,154,200)'],
        [0.69412, 'rgb(158,154,200)'],
        [0.69804, 'rgb(158,154,200)'],
        [0.70196, 'rgb(188,189,220)'],
        [0.70588, 'rgb(188,189,220)'],
        [0.7098, 'rgb(188,189,220)'],
        [0.71373, 'rgb(188,189,220)'],
        [0.71765, 'rgb(188,189,220)'],
        [0.72157, 'rgb(188,189,220)'],
        [0.72549, 'rgb(188,189,220)'],
        [0.72941, 'rgb(188,189,220)'],
        [0.73333, 'rgb(188,189,220)'],
        [0.73725, 'rgb(188,189,220)'],
        [0.74118, 'rgb(188,189,220)'],
        [0.7451, 'rgb(188,189,220)'],
        [0.74902, 'rgb(188,189,220)'],
        [0.75294, 'rgb(218,218,235)'],
        [0.75686, 'rgb(218,218,235)'],
        [0.76078, 'rgb(218,218,235)'],
        [0.76471, 'rgb(218,218,235)'],
        [0.76863, 'rgb(218,218,235)'],
        [0.77255, 'rgb(218,218,235)'],
        [0.77647, 'rgb(218,218,235)'],
        [0.78039, 'rgb(218,218,235)'],
        [0.78431, 'rgb(218,218,235)'],
        [0.78824, 'rgb(218,218,235)'],
        [0.79216, 'rgb(218,218,235)'],
        [0.79608, 'rgb(218,218,235)'],
        [0.8, 'rgb(99,99,99)'],
        [0.80392, 'rgb(99,99,99)'],
        [0.80784, 'rgb(99,99,99)'],
        [0.81176, 'rgb(99,99,99)'],
        [0.81569, 'rgb(99,99,99)'],
        [0.81961, 'rgb(99,99,99)'],
        [0.82353, 'rgb(99,99,99)'],
        [0.82745, 'rgb(99,99,99)'],
        [0.83137, 'rgb(99,99,99)'],
        [0.83529, 'rgb(99,99,99)'],
        [0.83922, 'rgb(99,99,99)'],
        [0.84314, 'rgb(99,99,99)'],
        [0.84706, 'rgb(99,99,99)'],
        [0.85098, 'rgb(150,150,150)'],
        [0.8549, 'rgb(150,150,150)'],
        [0.85882, 'rgb(150,150,150)'],
        [0.86275, 'rgb(150,150,150)'],
        [0.86667, 'rgb(150,150,150)'],
        [0.87059, 'rgb(150,150,150)'],
        [0.87451, 'rgb(150,150,150)'],
        [0.87843, 'rgb(150,150,150)'],
        [0.88235, 'rgb(150,150,150)'],
        [0.88627, 'rgb(150,150,150)'],
        [0.8902, 'rgb(150,150,150)'],
        [0.89412, 'rgb(150,150,150)'],
        [0.89804, 'rgb(150,150,150)'],
        [0.90196, 'rgb(189,189,189)'],
        [0.90588, 'rgb(189,189,189)'],
        [0.9098, 'rgb(189,189,189)'],
        [0.91373, 'rgb(189,189,189)'],
        [0.91765, 'rgb(189,189,189)'],
        [0.92157, 'rgb(189,189,189)'],
        [0.92549, 'rgb(189,189,189)'],
        [0.92941, 'rgb(189,189,189)'],
        [0.93333, 'rgb(189,189,189)'],
        [0.93725, 'rgb(189,189,189)'],
        [0.94118, 'rgb(189,189,189)'],
        [0.9451, 'rgb(189,189,189)'],
        [0.94902, 'rgb(189,189,189)'],
        [0.95294, 'rgb(217,217,217)'],
        [0.95686, 'rgb(217,217,217)'],
        [0.96078, 'rgb(217,217,217)'],
        [0.96471, 'rgb(217,217,217)'],
        [0.96863, 'rgb(217,217,217)'],
        [0.97255, 'rgb(217,217,217)'],
        [0.97647, 'rgb(217,217,217)'],
        [0.98039, 'rgb(217,217,217)'],
        [0.98431, 'rgb(217,217,217)'],
        [0.98824, 'rgb(217,217,217)'],
        [0.99216, 'rgb(217,217,217)'],
        [0.99608, 'rgb(217,217,217)'],
        [1.0, 'rgb(217,217,217)'],
    ],
    'terrain': [
        [0.0, 'rgb(51,51,153)'],
        [0.00392, 'rgb(49,53,155)'],
        [0.00784, 'rgb(48,56,158)'],
        [0.01176, 'rgb(47,59,161)'],
        [0.01569, 'rgb(45,61,163)'],
        [0.01961, 'rgb(44,64,166)'],
        [0.02353, 'rgb(43,67,169)'],
        [0.02745, 'rgb(41,69,171)'],
        [0.03137, 'rgb(40,72,174)'],
        [0.03529, 'rgb(39,75,177)'],
        [0.03922, 'rgb(37,77,179)'],
        [0.04314, 'rgb(36,80,182)'],
        [0.04706, 'rgb(35,83,185)'],
        [0.05098, 'rgb(33,85,187)'],
        [0.0549, 'rgb(32,88,190)'],
        [0.05882, 'rgb(31,91,193)'],
        [0.06275, 'rgb(29,93,195)'],
        [0.06667, 'rgb(28,96,198)'],
        [0.07059, 'rgb(27,98,201)'],
        [0.07451, 'rgb(25,101,203)'],
        [0.07843, 'rgb(24,104,206)'],
        [0.08235, 'rgb(23,107,209)'],
        [0.08627, 'rgb(21,109,211)'],
        [0.0902, 'rgb(20,112,214)'],
        [0.09412, 'rgb(19,115,217)'],
        [0.09804, 'rgb(17,117,219)'],
        [0.10196, 'rgb(16,120,222)'],
        [0.10588, 'rgb(14,123,225)'],
        [0.1098, 'rgb(13,125,227)'],
        [0.11373, 'rgb(12,128,230)'],
        [0.11765, 'rgb(11,131,233)'],
        [0.12157, 'rgb(9,133,235)'],
        [0.12549, 'rgb(8,136,238)'],
        [0.12941, 'rgb(7,138,241)'],
        [0.13333, 'rgb(5,141,243)'],
        [0.13725, 'rgb(4,144,246)'],
        [0.14118, 'rgb(3,147,249)'],
        [0.1451, 'rgb(1,149,251)'],
        [0.14902, 'rgb(0,152,254)'],
        [0.15294, 'rgb(0,154,250)'],
        [0.15686, 'rgb(0,156,244)'],
        [0.16078, 'rgb(0,158,238)'],
        [0.16471, 'rgb(0,160,232)'],
        [0.16863, 'rgb(0,162,226)'],
        [0.17255, 'rgb(0,164,220)'],
        [0.17647, 'rgb(0,166,214)'],
        [0.18039, 'rgb(0,168,208)'],
        [0.18431, 'rgb(0,170,202)'],
        [0.18824, 'rgb(0,172,196)'],
        [0.19216, 'rgb(0,174,190)'],
        [0.19608, 'rgb(0,176,184)'],
        [0.2, 'rgb(0,178,178)'],
        [0.20392, 'rgb(0,180,172)'],
        [0.20784, 'rgb(0,182,166)'],
        [0.21176, 'rgb(0,184,160)'],
        [0.21569, 'rgb(0,186,154)'],
        [0.21961, 'rgb(0,188,148)'],
        [0.22353, 'rgb(0,190,142)'],
        [0.22745, 'rgb(0,192,136)'],
        [0.23137, 'rgb(0,194,130)'],
        [0.23529, 'rgb(0,196,124)'],
        [0.23922, 'rgb(0,198,118)'],
        [0.24314, 'rgb(0,200,112)'],
        [0.24706, 'rgb(0,202,106)'],
        [0.25098, 'rgb(1,204,102)'],
        [0.2549, 'rgb(5,205,103)'],
        [0.25882, 'rgb(8,205,103)'],
        [0.26275, 'rgb(13,206,104)'],
        [0.26667, 'rgb(17,207,105)'],
        [0.27059, 'rgb(21,208,106)'],
        [0.27451, 'rgb(25,209,107)'],
        [0.27843, 'rgb(29,209,107)'],
        [0.28235, 'rgb(33,210,108)'],
        [0.28627, 'rgb(37,211,109)'],
        [0.2902, 'rgb(40,212,110)'],
        [0.29412, 'rgb(45,213,111)'],
        [0.29804, 'rgb(49,213,111)'],
        [0.30196, 'rgb(53,214,112)'],
        [0.30588, 'rgb(57,215,113)'],
        [0.3098, 'rgb(61,216,114)'],
        [0.31373, 'rgb(65,217,115)'],
        [0.31765, 'rgb(69,217,115)'],
        [0.32157, 'rgb(72,218,116)'],
        [0.32549, 'rgb(77,219,117)'],
        [0.32941, 'rgb(81,220,118)'],
        [0.33333, 'rgb(85,221,119)'],
        [0.33725, 'rgb(89,221,119)'],
        [0.34118, 'rgb(93,222,120)'],
        [0.3451, 'rgb(97,223,121)'],
        [0.34902, 'rgb(101,224,122)'],
        [0.35294, 'rgb(104,225,122)'],
        [0.35686, 'rgb(109,225,123)'],
        [0.36078, 'rgb(113,226,124)'],
        [0.36471, 'rgb(117,227,125)'],
        [0.36863, 'rgb(121,228,126)'],
        [0.37255, 'rgb(125,229,127)'],
        [0.37647, 'rgb(129,229,127)'],
        [0.38039, 'rgb(133,230,128)'],
        [0.38431, 'rgb(136,231,129)'],
        [0.38824, 'rgb(141,232,130)'],
        [0.39216, 'rgb(145,233,131)'],
        [0.39608, 'rgb(149,233,131)'],
        [0.4, 'rgb(153,234,132)'],
        [0.40392, 'rgb(157,235,133)'],
        [0.40784, 'rgb(161,236,134)'],
        [0.41176, 'rgb(165,237,135)'],
        [0.41569, 'rgb(168,237,135)'],
        [0.41961, 'rgb(173,238,136)'],
        [0.42353, 'rgb(177,239,137)'],
        [0.42745, 'rgb(181,240,138)'],
        [0.43137, 'rgb(185,241,139)'],
        [0.43529, 'rgb(189,241,139)'],
        [0.43922, 'rgb(193,242,140)'],
        [0.44314, 'rgb(197,243,141)'],
        [0.44706, 'rgb(200,244,142)'],
        [0.45098, 'rgb(205,245,143)'],
        [0.4549, 'rgb(209,245,143)'],
        [0.45882, 'rgb(213,246,144)'],
        [0.46275, 'rgb(217,247,145)'],
        [0.46667, 'rgb(221,248,146)'],
        [0.47059, 'rgb(225,249,147)'],
        [0.47451, 'rgb(229,249,147)'],
        [0.47843, 'rgb(232,250,148)'],
        [0.48235, 'rgb(237,251,149)'],
        [0.48627, 'rgb(241,252,150)'],
        [0.4902, 'rgb(245,253,151)'],
        [0.49412, 'rgb(249,253,151)'],
        [0.49804, 'rgb(253,254,152)'],
        [0.50196, 'rgb(254,253,152)'],
        [0.50588, 'rgb(252,251,151)'],
        [0.5098, 'rgb(250,248,150)'],
        [0.51373, 'rgb(248,246,149)'],
        [0.51765, 'rgb(246,243,148)'],
        [0.52157, 'rgb(244,240,147)'],
        [0.52549, 'rgb(242,238,145)'],
        [0.52941, 'rgb(240,235,144)'],
        [0.53333, 'rgb(238,233,143)'],
        [0.53725, 'rgb(236,230,142)'],
        [0.54118, 'rgb(234,228,141)'],
        [0.5451, 'rgb(232,225,140)'],
        [0.54902, 'rgb(230,223,139)'],
        [0.55294, 'rgb(228,220,138)'],
        [0.55686, 'rgb(226,217,137)'],
        [0.56078, 'rgb(224,215,136)'],
        [0.56471, 'rgb(222,212,135)'],
        [0.56863, 'rgb(220,210,134)'],
        [0.57255, 'rgb(218,207,133)'],
        [0.57647, 'rgb(216,205,131)'],
        [0.58039, 'rgb(214,202,130)'],
        [0.58431, 'rgb(211,199,129)'],
        [0.58824, 'rgb(210,197,128)'],
        [0.59216, 'rgb(208,194,127)'],
        [0.59608, 'rgb(206,192,126)'],
        [0.6, 'rgb(204,189,125)'],
        [0.60392, 'rgb(202,187,124)'],
        [0.60784, 'rgb(200,184,123)'],
        [0.61176, 'rgb(198,182,122)'],
        [0.61569, 'rgb(195,179,121)'],
        [0.61961, 'rgb(194,176,120)'],
        [0.62353, 'rgb(192,174,118)'],
        [0.62745, 'rgb(190,171,117)'],
        [0.63137, 'rgb(188,169,116)'],
        [0.63529, 'rgb(186,166,115)'],
        [0.63922, 'rgb(184,164,114)'],
        [0.64314, 'rgb(182,161,113)'],
        [0.64706, 'rgb(179,159,112)'],
        [0.65098, 'rgb(178,156,111)'],
        [0.6549, 'rgb(176,153,110)'],
        [0.65882, 'rgb(174,151,109)'],
        [0.66275, 'rgb(172,148,108)'],
        [0.66667, 'rgb(170,146,107)'],
        [0.67059, 'rgb(168,143,106)'],
        [0.67451, 'rgb(166,141,104)'],
        [0.67843, 'rgb(163,138,103)'],
        [0.68235, 'rgb(162,135,102)'],
        [0.68627, 'rgb(160,133,101)'],
        [0.6902, 'rgb(158,130,100)'],
        [0.69412, 'rgb(156,128,99)'],
        [0.69804, 'rgb(154,125,98)'],
        [0.70196, 'rgb(152,123,97)'],
        [0.70588, 'rgb(150,120,96)'],
        [0.7098, 'rgb(147,118,95)'],
        [0.71373, 'rgb(146,115,94)'],
        [0.71765, 'rgb(144,112,93)'],
        [0.72157, 'rgb(142,110,91)'],
        [0.72549, 'rgb(140,107,90)'],
        [0.72941, 'rgb(138,105,89)'],
        [0.73333, 'rgb(136,102,88)'],
        [0.73725, 'rgb(134,100,87)'],
        [0.74118, 'rgb(131,97,86)'],
        [0.7451, 'rgb(130,95,85)'],
        [0.74902, 'rgb(128,92,84)'],
        [0.75294, 'rgb(129,93,86)'],
        [0.75686, 'rgb(131,96,88)'],
        [0.76078, 'rgb(133,98,91)'],
        [0.76471, 'rgb(135,101,94)'],
        [0.76863, 'rgb(136,103,96)'],
        [0.77255, 'rgb(139,106,99)'],
        [0.77647, 'rgb(141,109,102)'],
        [0.78039, 'rgb(143,111,104)'],
        [0.78431, 'rgb(145,114,107)'],
        [0.78824, 'rgb(147,116,110)'],
        [0.79216, 'rgb(149,119,112)'],
        [0.79608, 'rgb(151,121,115)'],
        [0.8, 'rgb(153,124,118)'],
        [0.80392, 'rgb(155,127,121)'],
        [0.80784, 'rgb(157,129,123)'],
        [0.81176, 'rgb(159,132,126)'],
        [0.81569, 'rgb(161,134,129)'],
        [0.81961, 'rgb(163,137,131)'],
        [0.82353, 'rgb(165,139,134)'],
        [0.82745, 'rgb(167,142,137)'],
        [0.83137, 'rgb(168,144,139)'],
        [0.83529, 'rgb(171,147,142)'],
        [0.83922, 'rgb(173,150,145)'],
        [0.84314, 'rgb(175,152,147)'],
        [0.84706, 'rgb(177,155,150)'],
        [0.85098, 'rgb(179,157,153)'],
        [0.8549, 'rgb(181,160,155)'],
        [0.85882, 'rgb(183,162,158)'],
        [0.86275, 'rgb(185,165,161)'],
        [0.86667, 'rgb(187,167,163)'],
        [0.87059, 'rgb(189,170,166)'],
        [0.87451, 'rgb(191,173,169)'],
        [0.87843, 'rgb(193,175,171)'],
        [0.88235, 'rgb(195,178,174)'],
        [0.88627, 'rgb(196,180,177)'],
        [0.8902, 'rgb(199,183,179)'],
        [0.89412, 'rgb(200,185,182)'],
        [0.89804, 'rgb(203,188,185)'],
        [0.90196, 'rgb(205,191,187)'],
        [0.90588, 'rgb(207,193,190)'],
        [0.9098, 'rgb(209,196,193)'],
        [0.91373, 'rgb(211,198,196)'],
        [0.91765, 'rgb(212,201,198)'],
        [0.92157, 'rgb(215,203,201)'],
        [0.92549, 'rgb(217,206,204)'],
        [0.92941, 'rgb(219,208,206)'],
        [0.93333, 'rgb(221,211,209)'],
        [0.93725, 'rgb(223,214,212)'],
        [0.94118, 'rgb(225,216,214)'],
        [0.9451, 'rgb(227,219,217)'],
        [0.94902, 'rgb(228,221,220)'],
        [0.95294, 'rgb(231,224,222)'],
        [0.95686, 'rgb(232,226,225)'],
        [0.96078, 'rgb(235,229,228)'],
        [0.96471, 'rgb(237,231,230)'],
        [0.96863, 'rgb(239,234,233)'],
        [0.97255, 'rgb(241,237,236)'],
        [0.97647, 'rgb(243,239,238)'],
        [0.98039, 'rgb(244,242,241)'],
        [0.98431, 'rgb(247,244,244)'],
        [0.98824, 'rgb(249,247,246)'],
        [0.99216, 'rgb(251,249,249)'],
        [0.99608, 'rgb(253,252,252)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'twilight_shifted': [
        [0.0, 'rgb(47,19,55)'],
        [0.00392, 'rgb(48,19,55)'],
        [0.00784, 'rgb(49,18,57)'],
        [0.01176, 'rgb(50,17,59)'],
        [0.01569, 'rgb(51,17,61)'],
        [0.01961, 'rgb(52,16,63)'],
        [0.02353, 'rgb(54,16,65)'],
        [0.02745, 'rgb(54,16,66)'],
        [0.03137, 'rgb(56,16,69)'],
        [0.03529, 'rgb(57,16,71)'],
        [0.03922, 'rgb(59,17,75)'],
        [0.04314, 'rgb(61,17,78)'],
        [0.04706, 'rgb(62,17,81)'],
        [0.05098, 'rgb(63,17,82)'],
        [0.0549, 'rgb(65,18,85)'],
        [0.05882, 'rgb(67,18,88)'],
        [0.06275, 'rgb(69,19,93)'],
        [0.06667, 'rgb(71,20,96)'],
        [0.07059, 'rgb(73,21,100)'],
        [0.07451, 'rgb(74,21,103)'],
        [0.07843, 'rgb(75,22,105)'],
        [0.08235, 'rgb(77,23,108)'],
        [0.08627, 'rgb(78,24,112)'],
        [0.0902, 'rgb(80,26,117)'],
        [0.09412, 'rgb(82,27,120)'],
        [0.09804, 'rgb(83,29,124)'],
        [0.10196, 'rgb(83,30,125)'],
        [0.10588, 'rgb(85,32,128)'],
        [0.1098, 'rgb(86,33,131)'],
        [0.11373, 'rgb(87,36,136)'],
        [0.11765, 'rgb(88,39,139)'],
        [0.12157, 'rgb(89,41,141)'],
        [0.12549, 'rgb(89,42,143)'],
        [0.12941, 'rgb(90,44,145)'],
        [0.13333, 'rgb(90,46,148)'],
        [0.13725, 'rgb(91,49,150)'],
        [0.14118, 'rgb(91,52,153)'],
        [0.1451, 'rgb(92,55,155)'],
        [0.14902, 'rgb(92,57,157)'],
        [0.15294, 'rgb(92,58,158)'],
        [0.15686, 'rgb(92,61,160)'],
        [0.16078, 'rgb(93,63,162)'],
        [0.16471, 'rgb(93,67,164)'],
        [0.16863, 'rgb(93,69,166)'],
        [0.17255, 'rgb(93,72,167)'],
        [0.17647, 'rgb(93,73,168)'],
        [0.18039, 'rgb(94,75,170)'],
        [0.18431, 'rgb(94,78,171)'],
        [0.18824, 'rgb(94,81,173)'],
        [0.19216, 'rgb(94,84,174)'],
        [0.19608, 'rgb(94,86,175)'],
        [0.2, 'rgb(94,89,176)'],
        [0.20392, 'rgb(94,90,177)'],
        [0.20784, 'rgb(94,92,178)'],
        [0.21176, 'rgb(95,94,179)'],
        [0.21569, 'rgb(95,98,180)'],
        [0.21961, 'rgb(95,100,181)'],
        [0.22353, 'rgb(95,103,182)'],
        [0.22745, 'rgb(95,104,182)'],
        [0.23137, 'rgb(96,106,183)'],
        [0.23529, 'rgb(96,108,183)'],
        [0.23922, 'rgb(96,112,184)'],
        [0.24314, 'rgb(97,114,185)'],
        [0.24706, 'rgb(97,116,186)'],
        [0.25098, 'rgb(97,117,186)'],
        [0.2549, 'rgb(98,119,186)'],
        [0.25882, 'rgb(99,122,187)'],
        [0.26275, 'rgb(100,125,188)'],
        [0.26667, 'rgb(100,127,188)'],
        [0.27059, 'rgb(101,129,189)'],
        [0.27451, 'rgb(102,131,189)'],
        [0.27843, 'rgb(102,132,189)'],
        [0.28235, 'rgb(103,134,190)'],
        [0.28627, 'rgb(104,136,190)'],
        [0.2902, 'rgb(106,139,190)'],
        [0.29412, 'rgb(107,142,191)'],
        [0.29804, 'rgb(109,144,191)'],
        [0.30196, 'rgb(109,145,191)'],
        [0.30588, 'rgb(111,147,192)'],
        [0.3098, 'rgb(112,149,192)'],
        [0.31373, 'rgb(115,152,192)'],
        [0.31765, 'rgb(116,154,193)'],
        [0.32157, 'rgb(118,155,193)'],
        [0.32549, 'rgb(119,156,193)'],
        [0.32941, 'rgb(121,158,193)'],
        [0.33333, 'rgb(123,160,194)'],
        [0.33725, 'rgb(125,162,194)'],
        [0.34118, 'rgb(128,165,195)'],
        [0.3451, 'rgb(130,167,195)'],
        [0.34902, 'rgb(132,169,195)'],
        [0.35294, 'rgb(133,170,196)'],
        [0.35686, 'rgb(136,171,196)'],
        [0.36078, 'rgb(138,173,196)'],
        [0.36471, 'rgb(142,176,197)'],
        [0.36863, 'rgb(144,178,197)'],
        [0.37255, 'rgb(147,180,198)'],
        [0.37647, 'rgb(148,180,198)'],
        [0.38039, 'rgb(151,182,199)'],
        [0.38431, 'rgb(154,184,199)'],
        [0.38824, 'rgb(158,187,200)'],
        [0.39216, 'rgb(161,188,201)'],
        [0.39608, 'rgb(164,190,202)'],
        [0.4, 'rgb(167,192,202)'],
        [0.40392, 'rgb(168,192,203)'],
        [0.40784, 'rgb(171,194,204)'],
        [0.41176, 'rgb(174,196,204)'],
        [0.41569, 'rgb(179,198,206)'],
        [0.41961, 'rgb(182,199,207)'],
        [0.42353, 'rgb(185,201,208)'],
        [0.42745, 'rgb(186,202,208)'],
        [0.43137, 'rgb(189,203,210)'],
        [0.43529, 'rgb(192,205,211)'],
        [0.43922, 'rgb(197,207,212)'],
        [0.44314, 'rgb(199,208,214)'],
        [0.44706, 'rgb(202,209,215)'],
        [0.45098, 'rgb(203,210,215)'],
        [0.4549, 'rgb(206,211,216)'],
        [0.45882, 'rgb(208,212,218)'],
        [0.46275, 'rgb(212,214,219)'],
        [0.46667, 'rgb(214,214,220)'],
        [0.47059, 'rgb(216,215,221)'],
        [0.47451, 'rgb(217,216,222)'],
        [0.47843, 'rgb(218,216,222)'],
        [0.48235, 'rgb(220,216,223)'],
        [0.48627, 'rgb(221,217,224)'],
        [0.4902, 'rgb(223,217,225)'],
        [0.49412, 'rgb(224,217,226)'],
        [0.49804, 'rgb(225,216,226)'],
        [0.50196, 'rgb(225,216,225)'],
        [0.50588, 'rgb(225,216,224)'],
        [0.5098, 'rgb(225,216,223)'],
        [0.51373, 'rgb(224,215,221)'],
        [0.51765, 'rgb(224,214,219)'],
        [0.52157, 'rgb(223,214,217)'],
        [0.52549, 'rgb(223,213,216)'],
        [0.52941, 'rgb(223,212,214)'],
        [0.53333, 'rgb(222,211,212)'],
        [0.53725, 'rgb(221,209,209)'],
        [0.54118, 'rgb(220,207,205)'],
        [0.5451, 'rgb(219,206,203)'],
        [0.54902, 'rgb(219,204,200)'],
        [0.55294, 'rgb(218,203,198)'],
        [0.55686, 'rgb(217,201,195)'],
        [0.56078, 'rgb(216,199,192)'],
        [0.56471, 'rgb(215,196,187)'],
        [0.56863, 'rgb(214,194,183)'],
        [0.57255, 'rgb(213,192,180)'],
        [0.57647, 'rgb(213,191,178)'],
        [0.58039, 'rgb(212,189,175)'],
        [0.58431, 'rgb(211,187,171)'],
        [0.58824, 'rgb(210,184,166)'],
        [0.59216, 'rgb(209,182,163)'],
        [0.59608, 'rgb(208,179,159)'],
        [0.6, 'rgb(207,177,156)'],
        [0.60392, 'rgb(207,176,154)'],
        [0.60784, 'rgb(206,174,151)'],
        [0.61176, 'rgb(206,171,148)'],
        [0.61569, 'rgb(205,168,143)'],
        [0.61961, 'rgb(204,165,140)'],
        [0.62353, 'rgb(204,163,137)'],
        [0.62745, 'rgb(203,162,135)'],
        [0.63137, 'rgb(203,159,132)'],
        [0.63529, 'rgb(202,157,129)'],
        [0.63922, 'rgb(201,153,125)'],
        [0.64314, 'rgb(201,151,122)'],
        [0.64706, 'rgb(200,148,120)'],
        [0.65098, 'rgb(200,147,118)'],
        [0.6549, 'rgb(199,145,116)'],
        [0.65882, 'rgb(199,142,113)'],
        [0.66275, 'rgb(198,139,110)'],
        [0.66667, 'rgb(197,136,108)'],
        [0.67059, 'rgb(197,134,106)'],
        [0.67451, 'rgb(196,131,104)'],
        [0.67843, 'rgb(196,130,103)'],
        [0.68235, 'rgb(195,127,101)'],
        [0.68627, 'rgb(194,125,99)'],
        [0.6902, 'rgb(193,121,96)'],
        [0.69412, 'rgb(192,119,95)'],
        [0.69804, 'rgb(192,116,93)'],
        [0.70196, 'rgb(191,115,93)'],
        [0.70588, 'rgb(190,113,91)'],
        [0.7098, 'rgb(189,110,90)'],
        [0.71373, 'rgb(188,107,89)'],
        [0.71765, 'rgb(187,104,87)'],
        [0.72157, 'rgb(186,102,87)'],
        [0.72549, 'rgb(185,101,86)'],
        [0.72941, 'rgb(184,98,85)'],
        [0.73333, 'rgb(183,96,84)'],
        [0.73725, 'rgb(182,94,84)'],
        [0.74118, 'rgb(180,90,83)'],
        [0.7451, 'rgb(179,88,82)'],
        [0.74902, 'rgb(178,86,82)'],
        [0.75294, 'rgb(177,85,81)'],
        [0.75686, 'rgb(175,82,81)'],
        [0.76078, 'rgb(174,80,81)'],
        [0.76471, 'rgb(172,77,80)'],
        [0.76863, 'rgb(170,75,80)'],
        [0.77255, 'rgb(169,73,80)'],
        [0.77647, 'rgb(168,71,80)'],
        [0.78039, 'rgb(167,69,79)'],
        [0.78431, 'rgb(165,67,79)'],
        [0.78824, 'rgb(162,64,79)'],
        [0.79216, 'rgb(161,62,79)'],
        [0.79608, 'rgb(159,60,79)'],
        [0.8, 'rgb(157,58,79)'],
        [0.80392, 'rgb(156,57,79)'],
        [0.80784, 'rgb(154,55,79)'],
        [0.81176, 'rgb(153,53,79)'],
        [0.81569, 'rgb(150,50,79)'],
        [0.81961, 'rgb(148,49,79)'],
        [0.82353, 'rgb(146,47,79)'],
        [0.82745, 'rgb(145,46,80)'],
        [0.83137, 'rgb(143,44,80)'],
        [0.83529, 'rgb(140,43,80)'],
        [0.83922, 'rgb(137,40,80)'],
        [0.84314, 'rgb(135,39,80)'],
        [0.84706, 'rgb(132,37,80)'],
        [0.85098, 'rgb(131,37,80)'],
        [0.8549, 'rgb(129,35,80)'],
        [0.85882, 'rgb(127,34,80)'],
        [0.86275, 'rgb(123,32,79)'],
        [0.86667, 'rgb(120,31,79)'],
        [0.87059, 'rgb(118,30,79)'],
        [0.87451, 'rgb(115,29,78)'],
        [0.87843, 'rgb(114,29,78)'],
        [0.88235, 'rgb(111,28,78)'],
        [0.88627, 'rgb(109,27,77)'],
        [0.8902, 'rgb(105,26,76)'],
        [0.89412, 'rgb(102,25,76)'],
        [0.89804, 'rgb(99,24,75)'],
        [0.90196, 'rgb(98,24,75)'],
        [0.90588, 'rgb(95,23,74)'],
        [0.9098, 'rgb(93,23,73)'],
        [0.91373, 'rgb(89,22,71)'],
        [0.91765, 'rgb(86,21,70)'],
        [0.92157, 'rgb(84,21,69)'],
        [0.92549, 'rgb(82,20,69)'],
        [0.92941, 'rgb(80,20,68)'],
        [0.93333, 'rgb(77,19,67)'],
        [0.93725, 'rgb(75,19,66)'],
        [0.94118, 'rgb(71,18,64)'],
        [0.9451, 'rgb(69,18,63)'],
        [0.94902, 'rgb(67,18,62)'],
        [0.95294, 'rgb(66,17,61)'],
        [0.95686, 'rgb(64,17,60)'],
        [0.96078, 'rgb(62,17,60)'],
        [0.96471, 'rgb(59,17,58)'],
        [0.96863, 'rgb(57,17,57)'],
        [0.97255, 'rgb(55,17,57)'],
        [0.97647, 'rgb(55,17,56)'],
        [0.98039, 'rgb(53,17,56)'],
        [0.98431, 'rgb(52,17,55)'],
        [0.98824, 'rgb(50,18,55)'],
        [0.99216, 'rgb(49,18,54)'],
        [0.99608, 'rgb(47,19,54)'],
        [1.0, 'rgb(47,20,54)'],
    ],
    'winter': [
        [0.0, 'rgb(0,0,255)'],
        [0.00392, 'rgb(0,1,254)'],
        [0.00784, 'rgb(0,2,254)'],
        [0.01176, 'rgb(0,3,253)'],
        [0.01569, 'rgb(0,4,253)'],
        [0.01961, 'rgb(0,5,252)'],
        [0.02353, 'rgb(0,6,252)'],
        [0.02745, 'rgb(0,7,251)'],
        [0.03137, 'rgb(0,8,251)'],
        [0.03529, 'rgb(0,9,250)'],
        [0.03922, 'rgb(0,10,250)'],
        [0.04314, 'rgb(0,11,249)'],
        [0.04706, 'rgb(0,12,249)'],
        [0.05098, 'rgb(0,13,248)'],
        [0.0549, 'rgb(0,14,248)'],
        [0.05882, 'rgb(0,15,247)'],
        [0.06275, 'rgb(0,16,247)'],
        [0.06667, 'rgb(0,17,246)'],
        [0.07059, 'rgb(0,18,246)'],
        [0.07451, 'rgb(0,19,245)'],
        [0.07843, 'rgb(0,20,245)'],
        [0.08235, 'rgb(0,21,244)'],
        [0.08627, 'rgb(0,22,244)'],
        [0.0902, 'rgb(0,23,243)'],
        [0.09412, 'rgb(0,24,243)'],
        [0.09804, 'rgb(0,25,242)'],
        [0.10196, 'rgb(0,26,242)'],
        [0.10588, 'rgb(0,27,241)'],
        [0.1098, 'rgb(0,28,241)'],
        [0.11373, 'rgb(0,29,240)'],
        [0.11765, 'rgb(0,30,240)'],
        [0.12157, 'rgb(0,31,239)'],
        [0.12549, 'rgb(0,32,239)'],
        [0.12941, 'rgb(0,32,238)'],
        [0.13333, 'rgb(0,34,238)'],
        [0.13725, 'rgb(0,35,237)'],
        [0.14118, 'rgb(0,36,237)'],
        [0.1451, 'rgb(0,36,236)'],
        [0.14902, 'rgb(0,38,236)'],
        [0.15294, 'rgb(0,39,235)'],
        [0.15686, 'rgb(0,40,235)'],
        [0.16078, 'rgb(0,40,234)'],
        [0.16471, 'rgb(0,42,234)'],
        [0.16863, 'rgb(0,43,233)'],
        [0.17255, 'rgb(0,44,233)'],
        [0.17647, 'rgb(0,44,232)'],
        [0.18039, 'rgb(0,46,232)'],
        [0.18431, 'rgb(0,47,231)'],
        [0.18824, 'rgb(0,48,231)'],
        [0.19216, 'rgb(0,48,230)'],
        [0.19608, 'rgb(0,50,230)'],
        [0.2, 'rgb(0,51,229)'],
        [0.20392, 'rgb(0,52,229)'],
        [0.20784, 'rgb(0,52,228)'],
        [0.21176, 'rgb(0,54,228)'],
        [0.21569, 'rgb(0,55,227)'],
        [0.21961, 'rgb(0,56,227)'],
        [0.22353, 'rgb(0,56,226)'],
        [0.22745, 'rgb(0,58,226)'],
        [0.23137, 'rgb(0,59,225)'],
        [0.23529, 'rgb(0,60,225)'],
        [0.23922, 'rgb(0,60,224)'],
        [0.24314, 'rgb(0,62,224)'],
        [0.24706, 'rgb(0,63,223)'],
        [0.25098, 'rgb(0,64,223)'],
        [0.2549, 'rgb(0,65,222)'],
        [0.25882, 'rgb(0,65,222)'],
        [0.26275, 'rgb(0,67,221)'],
        [0.26667, 'rgb(0,68,221)'],
        [0.27059, 'rgb(0,69,220)'],
        [0.27451, 'rgb(0,70,220)'],
        [0.27843, 'rgb(0,71,219)'],
        [0.28235, 'rgb(0,72,219)'],
        [0.28627, 'rgb(0,73,218)'],
        [0.2902, 'rgb(0,73,218)'],
        [0.29412, 'rgb(0,75,217)'],
        [0.29804, 'rgb(0,76,217)'],
        [0.30196, 'rgb(0,77,216)'],
        [0.30588, 'rgb(0,78,216)'],
        [0.3098, 'rgb(0,79,215)'],
        [0.31373, 'rgb(0,80,215)'],
        [0.31765, 'rgb(0,81,214)'],
        [0.32157, 'rgb(0,81,214)'],
        [0.32549, 'rgb(0,83,213)'],
        [0.32941, 'rgb(0,84,213)'],
        [0.33333, 'rgb(0,85,212)'],
        [0.33725, 'rgb(0,86,211)'],
        [0.34118, 'rgb(0,87,211)'],
        [0.3451, 'rgb(0,88,211)'],
        [0.34902, 'rgb(0,89,210)'],
        [0.35294, 'rgb(0,89,210)'],
        [0.35686, 'rgb(0,91,209)'],
        [0.36078, 'rgb(0,92,209)'],
        [0.36471, 'rgb(0,93,208)'],
        [0.36863, 'rgb(0,94,208)'],
        [0.37255, 'rgb(0,95,207)'],
        [0.37647, 'rgb(0,96,207)'],
        [0.38039, 'rgb(0,97,206)'],
        [0.38431, 'rgb(0,97,206)'],
        [0.38824, 'rgb(0,99,205)'],
        [0.39216, 'rgb(0,100,205)'],
        [0.39608, 'rgb(0,101,204)'],
        [0.4, 'rgb(0,102,204)'],
        [0.40392, 'rgb(0,103,203)'],
        [0.40784, 'rgb(0,104,203)'],
        [0.41176, 'rgb(0,105,202)'],
        [0.41569, 'rgb(0,105,202)'],
        [0.41961, 'rgb(0,107,201)'],
        [0.42353, 'rgb(0,108,201)'],
        [0.42745, 'rgb(0,109,200)'],
        [0.43137, 'rgb(0,110,200)'],
        [0.43529, 'rgb(0,111,199)'],
        [0.43922, 'rgb(0,112,199)'],
        [0.44314, 'rgb(0,113,198)'],
        [0.44706, 'rgb(0,113,198)'],
        [0.45098, 'rgb(0,115,197)'],
        [0.4549, 'rgb(0,116,197)'],
        [0.45882, 'rgb(0,117,196)'],
        [0.46275, 'rgb(0,118,195)'],
        [0.46667, 'rgb(0,119,195)'],
        [0.47059, 'rgb(0,120,195)'],
        [0.47451, 'rgb(0,121,194)'],
        [0.47843, 'rgb(0,121,194)'],
        [0.48235, 'rgb(0,123,193)'],
        [0.48627, 'rgb(0,124,193)'],
        [0.4902, 'rgb(0,125,192)'],
        [0.49412, 'rgb(0,126,192)'],
        [0.49804, 'rgb(0,127,191)'],
        [0.50196, 'rgb(0,128,191)'],
        [0.50588, 'rgb(0,129,190)'],
        [0.5098, 'rgb(0,130,190)'],
        [0.51373, 'rgb(0,131,189)'],
        [0.51765, 'rgb(0,131,189)'],
        [0.52157, 'rgb(0,133,188)'],
        [0.52549, 'rgb(0,134,188)'],
        [0.52941, 'rgb(0,135,187)'],
        [0.53333, 'rgb(0,136,187)'],
        [0.53725, 'rgb(0,137,186)'],
        [0.54118, 'rgb(0,138,186)'],
        [0.5451, 'rgb(0,139,185)'],
        [0.54902, 'rgb(0,140,185)'],
        [0.55294, 'rgb(0,141,184)'],
        [0.55686, 'rgb(0,142,184)'],
        [0.56078, 'rgb(0,143,183)'],
        [0.56471, 'rgb(0,144,183)'],
        [0.56863, 'rgb(0,145,182)'],
        [0.57255, 'rgb(0,146,182)'],
        [0.57647, 'rgb(0,147,181)'],
        [0.58039, 'rgb(0,147,181)'],
        [0.58431, 'rgb(0,149,180)'],
        [0.58824, 'rgb(0,150,179)'],
        [0.59216, 'rgb(0,151,179)'],
        [0.59608, 'rgb(0,152,179)'],
        [0.6, 'rgb(0,153,178)'],
        [0.60392, 'rgb(0,154,178)'],
        [0.60784, 'rgb(0,155,177)'],
        [0.61176, 'rgb(0,156,177)'],
        [0.61569, 'rgb(0,157,176)'],
        [0.61961, 'rgb(0,158,176)'],
        [0.62353, 'rgb(0,159,175)'],
        [0.62745, 'rgb(0,160,175)'],
        [0.63137, 'rgb(0,161,174)'],
        [0.63529, 'rgb(0,162,174)'],
        [0.63922, 'rgb(0,163,173)'],
        [0.64314, 'rgb(0,163,173)'],
        [0.64706, 'rgb(0,165,172)'],
        [0.65098, 'rgb(0,166,172)'],
        [0.6549, 'rgb(0,167,171)'],
        [0.65882, 'rgb(0,168,171)'],
        [0.66275, 'rgb(0,169,170)'],
        [0.66667, 'rgb(0,170,170)'],
        [0.67059, 'rgb(0,171,169)'],
        [0.67451, 'rgb(0,172,169)'],
        [0.67843, 'rgb(0,173,168)'],
        [0.68235, 'rgb(0,174,168)'],
        [0.68627, 'rgb(0,175,167)'],
        [0.6902, 'rgb(0,176,167)'],
        [0.69412, 'rgb(0,177,166)'],
        [0.69804, 'rgb(0,178,166)'],
        [0.70196, 'rgb(0,179,165)'],
        [0.70588, 'rgb(0,179,165)'],
        [0.7098, 'rgb(0,181,164)'],
        [0.71373, 'rgb(0,182,163)'],
        [0.71765, 'rgb(0,183,163)'],
        [0.72157, 'rgb(0,184,163)'],
        [0.72549, 'rgb(0,185,162)'],
        [0.72941, 'rgb(0,186,162)'],
        [0.73333, 'rgb(0,187,161)'],
        [0.73725, 'rgb(0,188,161)'],
        [0.74118, 'rgb(0,189,160)'],
        [0.7451, 'rgb(0,190,160)'],
        [0.74902, 'rgb(0,191,159)'],
        [0.75294, 'rgb(0,192,159)'],
        [0.75686, 'rgb(0,193,158)'],
        [0.76078, 'rgb(0,194,158)'],
        [0.76471, 'rgb(0,195,157)'],
        [0.76863, 'rgb(0,195,157)'],
        [0.77255, 'rgb(0,197,156)'],
        [0.77647, 'rgb(0,198,156)'],
        [0.78039, 'rgb(0,199,155)'],
        [0.78431, 'rgb(0,200,155)'],
        [0.78824, 'rgb(0,201,154)'],
        [0.79216, 'rgb(0,202,154)'],
        [0.79608, 'rgb(0,203,153)'],
        [0.8, 'rgb(0,204,153)'],
        [0.80392, 'rgb(0,205,152)'],
        [0.80784, 'rgb(0,206,152)'],
        [0.81176, 'rgb(0,207,151)'],
        [0.81569, 'rgb(0,208,151)'],
        [0.81961, 'rgb(0,209,150)'],
        [0.82353, 'rgb(0,210,150)'],
        [0.82745, 'rgb(0,211,149)'],
        [0.83137, 'rgb(0,211,149)'],
        [0.83529, 'rgb(0,213,148)'],
        [0.83922, 'rgb(0,214,147)'],
        [0.84314, 'rgb(0,215,147)'],
        [0.84706, 'rgb(0,216,147)'],
        [0.85098, 'rgb(0,217,146)'],
        [0.8549, 'rgb(0,218,146)'],
        [0.85882, 'rgb(0,219,145)'],
        [0.86275, 'rgb(0,220,145)'],
        [0.86667, 'rgb(0,221,144)'],
        [0.87059, 'rgb(0,222,144)'],
        [0.87451, 'rgb(0,223,143)'],
        [0.87843, 'rgb(0,224,143)'],
        [0.88235, 'rgb(0,225,142)'],
        [0.88627, 'rgb(0,226,142)'],
        [0.8902, 'rgb(0,227,141)'],
        [0.89412, 'rgb(0,227,141)'],
        [0.89804, 'rgb(0,229,140)'],
        [0.90196, 'rgb(0,230,140)'],
        [0.90588, 'rgb(0,231,139)'],
        [0.9098, 'rgb(0,232,139)'],
        [0.91373, 'rgb(0,233,138)'],
        [0.91765, 'rgb(0,234,138)'],
        [0.92157, 'rgb(0,235,137)'],
        [0.92549, 'rgb(0,236,137)'],
        [0.92941, 'rgb(0,237,136)'],
        [0.93333, 'rgb(0,238,136)'],
        [0.93725, 'rgb(0,239,135)'],
        [0.94118, 'rgb(0,240,135)'],
        [0.9451, 'rgb(0,241,134)'],
        [0.94902, 'rgb(0,242,134)'],
        [0.95294, 'rgb(0,243,133)'],
        [0.95686, 'rgb(0,243,133)'],
        [0.96078, 'rgb(0,245,132)'],
        [0.96471, 'rgb(0,246,131)'],
        [0.96863, 'rgb(0,247,131)'],
        [0.97255, 'rgb(0,248,131)'],
        [0.97647, 'rgb(0,249,130)'],
        [0.98039, 'rgb(0,250,130)'],
        [0.98431, 'rgb(0,251,129)'],
        [0.98824, 'rgb(0,252,129)'],
        [0.99216, 'rgb(0,253,128)'],
        [0.99608, 'rgb(0,254,128)'],
        [1.0, 'rgb(0,255,127)'],
    ],
    # CMasher colormaps converted for Plotly
    'cmr.amber': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(2,1,1)'],
        [0.027450980392156862, 'rgb(3,2,2)'],
        [0.03137254901960784, 'rgb(3,2,2)'],
        [0.03529411764705882, 'rgb(4,2,3)'],
        [0.0392156862745098, 'rgb(5,3,3)'],
        [0.043137254901960784, 'rgb(6,3,4)'],
        [0.047058823529411764, 'rgb(7,4,4)'],
        [0.050980392156862744, 'rgb(9,4,5)'],
        [0.054901960784313725, 'rgb(10,5,6)'],
        [0.058823529411764705, 'rgb(12,6,7)'],
        [0.06274509803921569, 'rgb(13,6,7)'],
        [0.06666666666666667, 'rgb(14,7,8)'],
        [0.07058823529411765, 'rgb(16,8,9)'],
        [0.07450980392156863, 'rgb(17,8,10)'],
        [0.0784313725490196, 'rgb(19,9,11)'],
        [0.08235294117647059, 'rgb(20,10,12)'],
        [0.08627450980392157, 'rgb(21,11,13)'],
        [0.09019607843137255, 'rgb(23,11,14)'],
        [0.09411764705882353, 'rgb(24,12,15)'],
        [0.09803921568627451, 'rgb(26,13,15)'],
        [0.10196078431372549, 'rgb(27,14,16)'],
        [0.10588235294117647, 'rgb(28,14,17)'],
        [0.10980392156862745, 'rgb(30,15,18)'],
        [0.11372549019607843, 'rgb(31,16,19)'],
        [0.11764705882352941, 'rgb(32,17,19)'],
        [0.12156862745098039, 'rgb(34,17,20)'],
        [0.12549019607843137, 'rgb(35,18,21)'],
        [0.12941176470588237, 'rgb(37,19,22)'],
        [0.13333333333333333, 'rgb(38,19,23)'],
        [0.13725490196078433, 'rgb(39,20,23)'],
        [0.1411764705882353, 'rgb(41,21,24)'],
        [0.1450980392156863, 'rgb(42,21,25)'],
        [0.14901960784313725, 'rgb(43,22,25)'],
        [0.15294117647058825, 'rgb(45,23,26)'],
        [0.1568627450980392, 'rgb(46,23,27)'],
        [0.1607843137254902, 'rgb(48,24,27)'],
        [0.16470588235294117, 'rgb(49,24,28)'],
        [0.16862745098039217, 'rgb(50,25,29)'],
        [0.17254901960784313, 'rgb(52,26,29)'],
        [0.17647058823529413, 'rgb(53,26,30)'],
        [0.1803921568627451, 'rgb(55,27,31)'],
        [0.1843137254901961, 'rgb(56,27,31)'],
        [0.18823529411764706, 'rgb(57,28,32)'],
        [0.19215686274509805, 'rgb(59,29,32)'],
        [0.19607843137254902, 'rgb(60,29,33)'],
        [0.2, 'rgb(61,30,34)'],
        [0.20392156862745098, 'rgb(63,30,34)'],
        [0.20784313725490197, 'rgb(64,31,35)'],
        [0.21176470588235294, 'rgb(66,31,35)'],
        [0.21568627450980393, 'rgb(67,32,36)'],
        [0.2196078431372549, 'rgb(68,33,36)'],
        [0.2235294117647059, 'rgb(70,33,37)'],
        [0.22745098039215686, 'rgb(71,34,37)'],
        [0.23137254901960785, 'rgb(73,34,38)'],
        [0.23529411764705882, 'rgb(74,35,38)'],
        [0.23921568627450981, 'rgb(76,35,39)'],
        [0.24313725490196078, 'rgb(77,36,39)'],
        [0.24705882352941178, 'rgb(78,36,39)'],
        [0.25098039215686274, 'rgb(80,37,40)'],
        [0.2549019607843137, 'rgb(81,37,40)'],
        [0.25882352941176473, 'rgb(83,38,41)'],
        [0.2627450980392157, 'rgb(84,38,41)'],
        [0.26666666666666666, 'rgb(85,39,41)'],
        [0.27058823529411763, 'rgb(87,39,42)'],
        [0.27450980392156865, 'rgb(88,40,42)'],
        [0.2784313725490196, 'rgb(90,40,42)'],
        [0.2823529411764706, 'rgb(91,41,43)'],
        [0.28627450980392155, 'rgb(93,41,43)'],
        [0.2901960784313726, 'rgb(94,42,43)'],
        [0.29411764705882354, 'rgb(95,42,44)'],
        [0.2980392156862745, 'rgb(97,43,44)'],
        [0.30196078431372547, 'rgb(98,43,44)'],
        [0.3058823529411765, 'rgb(100,44,44)'],
        [0.30980392156862746, 'rgb(101,44,44)'],
        [0.3137254901960784, 'rgb(103,45,45)'],
        [0.3176470588235294, 'rgb(104,45,45)'],
        [0.3215686274509804, 'rgb(105,46,45)'],
        [0.3254901960784314, 'rgb(107,46,45)'],
        [0.32941176470588235, 'rgb(108,47,45)'],
        [0.3333333333333333, 'rgb(110,47,45)'],
        [0.33725490196078434, 'rgb(111,48,45)'],
        [0.3411764705882353, 'rgb(112,48,46)'],
        [0.34509803921568627, 'rgb(114,49,46)'],
        [0.34901960784313724, 'rgb(115,50,46)'],
        [0.35294117647058826, 'rgb(117,50,46)'],
        [0.3568627450980392, 'rgb(118,51,46)'],
        [0.3607843137254902, 'rgb(119,51,46)'],
        [0.36470588235294116, 'rgb(121,52,46)'],
        [0.3686274509803922, 'rgb(122,52,46)'],
        [0.37254901960784315, 'rgb(124,53,46)'],
        [0.3764705882352941, 'rgb(125,53,46)'],
        [0.3803921568627451, 'rgb(126,54,46)'],
        [0.3843137254901961, 'rgb(128,55,46)'],
        [0.38823529411764707, 'rgb(129,55,45)'],
        [0.39215686274509803, 'rgb(131,56,45)'],
        [0.396078431372549, 'rgb(132,56,45)'],
        [0.4, 'rgb(133,57,45)'],
        [0.403921568627451, 'rgb(135,58,45)'],
        [0.40784313725490196, 'rgb(136,58,45)'],
        [0.4117647058823529, 'rgb(137,59,45)'],
        [0.41568627450980394, 'rgb(139,59,44)'],
        [0.4196078431372549, 'rgb(140,60,44)'],
        [0.4235294117647059, 'rgb(141,61,44)'],
        [0.42745098039215684, 'rgb(143,61,44)'],
        [0.43137254901960786, 'rgb(144,62,44)'],
        [0.43529411764705883, 'rgb(145,63,43)'],
        [0.4392156862745098, 'rgb(146,64,43)'],
        [0.44313725490196076, 'rgb(148,64,43)'],
        [0.4470588235294118, 'rgb(149,65,43)'],
        [0.45098039215686275, 'rgb(150,66,42)'],
        [0.4549019607843137, 'rgb(151,66,42)'],
        [0.4588235294117647, 'rgb(153,67,42)'],
        [0.4627450980392157, 'rgb(154,68,42)'],
        [0.4666666666666667, 'rgb(155,69,41)'],
        [0.47058823529411764, 'rgb(156,70,41)'],
        [0.4745098039215686, 'rgb(158,70,41)'],
        [0.47843137254901963, 'rgb(159,71,41)'],
        [0.4823529411764706, 'rgb(160,72,40)'],
        [0.48627450980392156, 'rgb(161,73,40)'],
        [0.49019607843137253, 'rgb(162,74,40)'],
        [0.49411764705882355, 'rgb(163,75,39)'],
        [0.4980392156862745, 'rgb(165,75,39)'],
        [0.5019607843137255, 'rgb(166,76,39)'],
        [0.5058823529411764, 'rgb(167,77,38)'],
        [0.5098039215686274, 'rgb(168,78,38)'],
        [0.5137254901960784, 'rgb(169,79,38)'],
        [0.5176470588235295, 'rgb(170,80,37)'],
        [0.5215686274509804, 'rgb(171,81,37)'],
        [0.5254901960784314, 'rgb(172,82,37)'],
        [0.5294117647058824, 'rgb(173,83,36)'],
        [0.5333333333333333, 'rgb(174,84,36)'],
        [0.5372549019607843, 'rgb(175,85,36)'],
        [0.5411764705882353, 'rgb(177,86,35)'],
        [0.5450980392156862, 'rgb(178,87,35)'],
        [0.5490196078431373, 'rgb(179,88,35)'],
        [0.5529411764705883, 'rgb(180,89,35)'],
        [0.5568627450980392, 'rgb(181,90,34)'],
        [0.5607843137254902, 'rgb(182,91,34)'],
        [0.5647058823529412, 'rgb(183,92,34)'],
        [0.5686274509803921, 'rgb(184,93,33)'],
        [0.5725490196078431, 'rgb(184,94,33)'],
        [0.5764705882352941, 'rgb(185,95,33)'],
        [0.5803921568627451, 'rgb(186,96,33)'],
        [0.5843137254901961, 'rgb(187,97,32)'],
        [0.5882352941176471, 'rgb(188,98,32)'],
        [0.592156862745098, 'rgb(189,100,32)'],
        [0.596078431372549, 'rgb(190,101,32)'],
        [0.6, 'rgb(191,102,31)'],
        [0.6039215686274509, 'rgb(192,103,31)'],
        [0.6078431372549019, 'rgb(193,104,31)'],
        [0.611764705882353, 'rgb(194,105,31)'],
        [0.615686274509804, 'rgb(195,106,31)'],
        [0.6196078431372549, 'rgb(195,107,30)'],
        [0.6235294117647059, 'rgb(196,109,30)'],
        [0.6274509803921569, 'rgb(197,110,30)'],
        [0.6313725490196078, 'rgb(198,111,30)'],
        [0.6352941176470588, 'rgb(199,112,30)'],
        [0.6392156862745098, 'rgb(200,113,30)'],
        [0.6431372549019608, 'rgb(200,114,30)'],
        [0.6470588235294118, 'rgb(201,116,29)'],
        [0.6509803921568628, 'rgb(202,117,29)'],
        [0.6549019607843137, 'rgb(203,118,29)'],
        [0.6588235294117647, 'rgb(204,119,29)'],
        [0.6627450980392157, 'rgb(204,121,29)'],
        [0.6666666666666666, 'rgb(205,122,29)'],
        [0.6705882352941176, 'rgb(206,123,29)'],
        [0.6745098039215687, 'rgb(207,124,29)'],
        [0.6784313725490196, 'rgb(207,125,29)'],
        [0.6823529411764706, 'rgb(208,127,29)'],
        [0.6862745098039216, 'rgb(209,128,29)'],
        [0.6901960784313725, 'rgb(210,129,30)'],
        [0.6941176470588235, 'rgb(210,131,30)'],
        [0.6980392156862745, 'rgb(211,132,30)'],
        [0.7019607843137254, 'rgb(212,133,30)'],
        [0.7058823529411765, 'rgb(213,134,30)'],
        [0.7098039215686275, 'rgb(213,136,30)'],
        [0.7137254901960784, 'rgb(214,137,30)'],
        [0.7176470588235294, 'rgb(215,138,31)'],
        [0.7215686274509804, 'rgb(215,140,31)'],
        [0.7254901960784313, 'rgb(216,141,31)'],
        [0.7294117647058823, 'rgb(217,142,32)'],
        [0.7333333333333333, 'rgb(217,143,32)'],
        [0.7372549019607844, 'rgb(218,145,32)'],
        [0.7411764705882353, 'rgb(219,146,33)'],
        [0.7450980392156863, 'rgb(219,147,33)'],
        [0.7490196078431373, 'rgb(220,149,33)'],
        [0.7529411764705882, 'rgb(221,150,34)'],
        [0.7568627450980392, 'rgb(221,151,34)'],
        [0.7607843137254902, 'rgb(222,153,35)'],
        [0.7647058823529411, 'rgb(223,154,35)'],
        [0.7686274509803922, 'rgb(223,155,35)'],
        [0.7725490196078432, 'rgb(224,157,36)'],
        [0.7764705882352941, 'rgb(224,158,36)'],
        [0.7803921568627451, 'rgb(225,160,37)'],
        [0.7843137254901961, 'rgb(226,161,38)'],
        [0.788235294117647, 'rgb(226,162,38)'],
        [0.792156862745098, 'rgb(227,164,39)'],
        [0.796078431372549, 'rgb(227,165,39)'],
        [0.8, 'rgb(228,166,40)'],
        [0.803921568627451, 'rgb(228,168,40)'],
        [0.807843137254902, 'rgb(229,169,41)'],
        [0.8117647058823529, 'rgb(230,171,42)'],
        [0.8156862745098039, 'rgb(230,172,42)'],
        [0.8196078431372549, 'rgb(231,174,43)'],
        [0.8235294117647058, 'rgb(231,175,44)'],
        [0.8274509803921568, 'rgb(232,176,45)'],
        [0.8313725490196079, 'rgb(232,178,45)'],
        [0.8352941176470589, 'rgb(233,179,46)'],
        [0.8392156862745098, 'rgb(233,181,47)'],
        [0.8431372549019608, 'rgb(234,182,48)'],
        [0.8470588235294118, 'rgb(234,184,48)'],
        [0.8509803921568627, 'rgb(235,185,49)'],
        [0.8549019607843137, 'rgb(235,186,50)'],
        [0.8588235294117647, 'rgb(236,188,51)'],
        [0.8627450980392157, 'rgb(236,189,52)'],
        [0.8666666666666667, 'rgb(237,191,52)'],
        [0.8705882352941177, 'rgb(237,192,53)'],
        [0.8745098039215686, 'rgb(238,194,54)'],
        [0.8784313725490196, 'rgb(238,195,55)'],
        [0.8823529411764706, 'rgb(239,197,56)'],
        [0.8862745098039215, 'rgb(239,198,57)'],
        [0.8901960784313725, 'rgb(240,200,58)'],
        [0.8941176470588236, 'rgb(240,201,59)'],
        [0.8980392156862745, 'rgb(241,203,60)'],
        [0.9019607843137255, 'rgb(241,204,61)'],
        [0.9058823529411765, 'rgb(242,206,61)'],
        [0.9098039215686274, 'rgb(242,207,62)'],
        [0.9137254901960784, 'rgb(242,209,63)'],
        [0.9176470588235294, 'rgb(243,210,64)'],
        [0.9215686274509803, 'rgb(243,212,65)'],
        [0.9254901960784314, 'rgb(244,213,66)'],
        [0.9294117647058824, 'rgb(244,215,67)'],
        [0.9333333333333333, 'rgb(245,216,68)'],
        [0.9372549019607843, 'rgb(245,218,69)'],
        [0.9411764705882353, 'rgb(245,219,70)'],
        [0.9450980392156862, 'rgb(246,221,71)'],
        [0.9490196078431372, 'rgb(246,223,73)'],
        [0.9529411764705882, 'rgb(247,224,74)'],
        [0.9568627450980393, 'rgb(247,226,75)'],
        [0.9607843137254902, 'rgb(247,227,76)'],
        [0.9647058823529412, 'rgb(248,229,77)'],
        [0.9686274509803922, 'rgb(248,230,78)'],
        [0.9725490196078431, 'rgb(248,232,79)'],
        [0.9764705882352941, 'rgb(249,234,80)'],
        [0.9803921568627451, 'rgb(249,235,81)'],
        [0.984313725490196, 'rgb(249,237,82)'],
        [0.9882352941176471, 'rgb(250,238,83)'],
        [0.9921568627450981, 'rgb(250,240,85)'],
        [0.996078431372549, 'rgb(251,242,86)'],
        [1.0, 'rgb(251,243,87)'],
    ],
    'cmr.apple': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(2,1,1)'],
        [0.023529411764705882, 'rgb(3,1,1)'],
        [0.027450980392156862, 'rgb(4,1,2)'],
        [0.03137254901960784, 'rgb(5,2,2)'],
        [0.03529411764705882, 'rgb(6,2,3)'],
        [0.0392156862745098, 'rgb(7,2,3)'],
        [0.043137254901960784, 'rgb(9,3,4)'],
        [0.047058823529411764, 'rgb(11,3,5)'],
        [0.050980392156862744, 'rgb(13,4,5)'],
        [0.054901960784313725, 'rgb(14,4,6)'],
        [0.058823529411764705, 'rgb(16,5,7)'],
        [0.06274509803921569, 'rgb(18,5,8)'],
        [0.06666666666666667, 'rgb(20,5,9)'],
        [0.07058823529411765, 'rgb(21,6,9)'],
        [0.07450980392156863, 'rgb(23,6,10)'],
        [0.0784313725490196, 'rgb(25,7,11)'],
        [0.08235294117647059, 'rgb(27,7,12)'],
        [0.08627450980392157, 'rgb(28,8,13)'],
        [0.09019607843137255, 'rgb(30,8,14)'],
        [0.09411764705882353, 'rgb(32,9,15)'],
        [0.09803921568627451, 'rgb(34,9,15)'],
        [0.10196078431372549, 'rgb(35,9,16)'],
        [0.10588235294117647, 'rgb(37,10,17)'],
        [0.10980392156862745, 'rgb(39,10,18)'],
        [0.11372549019607843, 'rgb(41,11,18)'],
        [0.11764705882352941, 'rgb(42,11,19)'],
        [0.12156862745098039, 'rgb(44,11,20)'],
        [0.12549019607843137, 'rgb(46,11,20)'],
        [0.12941176470588237, 'rgb(48,12,21)'],
        [0.13333333333333333, 'rgb(50,12,22)'],
        [0.13725490196078433, 'rgb(51,12,22)'],
        [0.1411764705882353, 'rgb(53,12,23)'],
        [0.1450980392156863, 'rgb(55,13,24)'],
        [0.14901960784313725, 'rgb(57,13,24)'],
        [0.15294117647058825, 'rgb(59,13,25)'],
        [0.1568627450980392, 'rgb(60,13,25)'],
        [0.1607843137254902, 'rgb(62,13,26)'],
        [0.16470588235294117, 'rgb(64,13,26)'],
        [0.16862745098039217, 'rgb(66,13,27)'],
        [0.17254901960784313, 'rgb(68,13,27)'],
        [0.17647058823529413, 'rgb(70,13,27)'],
        [0.1803921568627451, 'rgb(71,13,28)'],
        [0.1843137254901961, 'rgb(73,13,28)'],
        [0.18823529411764706, 'rgb(75,13,29)'],
        [0.19215686274509805, 'rgb(77,12,29)'],
        [0.19607843137254902, 'rgb(79,12,29)'],
        [0.2, 'rgb(81,12,29)'],
        [0.20392156862745098, 'rgb(83,12,30)'],
        [0.20784313725490197, 'rgb(84,11,30)'],
        [0.21176470588235294, 'rgb(86,11,30)'],
        [0.21568627450980393, 'rgb(88,11,30)'],
        [0.2196078431372549, 'rgb(90,10,30)'],
        [0.2235294117647059, 'rgb(92,10,30)'],
        [0.22745098039215686, 'rgb(94,9,30)'],
        [0.23137254901960785, 'rgb(96,9,30)'],
        [0.23529411764705882, 'rgb(98,8,30)'],
        [0.23921568627450981, 'rgb(99,7,30)'],
        [0.24313725490196078, 'rgb(101,7,30)'],
        [0.24705882352941178, 'rgb(103,6,30)'],
        [0.25098039215686274, 'rgb(105,5,29)'],
        [0.2549019607843137, 'rgb(107,5,29)'],
        [0.25882352941176473, 'rgb(109,4,29)'],
        [0.2627450980392157, 'rgb(111,4,28)'],
        [0.26666666666666666, 'rgb(112,3,28)'],
        [0.27058823529411763, 'rgb(114,3,27)'],
        [0.27450980392156865, 'rgb(116,2,26)'],
        [0.2784313725490196, 'rgb(118,2,26)'],
        [0.2823529411764706, 'rgb(119,2,25)'],
        [0.28627450980392155, 'rgb(121,2,24)'],
        [0.2901960784313726, 'rgb(123,3,23)'],
        [0.29411764705882354, 'rgb(124,3,22)'],
        [0.2980392156862745, 'rgb(126,4,21)'],
        [0.30196078431372547, 'rgb(127,6,21)'],
        [0.3058823529411765, 'rgb(128,7,20)'],
        [0.30980392156862746, 'rgb(130,9,19)'],
        [0.3137254901960784, 'rgb(131,11,18)'],
        [0.3176470588235294, 'rgb(132,13,17)'],
        [0.3215686274509804, 'rgb(133,15,16)'],
        [0.3254901960784314, 'rgb(134,17,15)'],
        [0.32941176470588235, 'rgb(135,19,14)'],
        [0.3333333333333333, 'rgb(136,21,13)'],
        [0.33725490196078434, 'rgb(137,23,12)'],
        [0.3411764705882353, 'rgb(138,25,11)'],
        [0.34509803921568627, 'rgb(139,27,11)'],
        [0.34901960784313724, 'rgb(140,29,10)'],
        [0.35294117647058826, 'rgb(141,31,9)'],
        [0.3568627450980392, 'rgb(141,33,8)'],
        [0.3607843137254902, 'rgb(142,35,7)'],
        [0.36470588235294116, 'rgb(143,37,7)'],
        [0.3686274509803922, 'rgb(144,39,6)'],
        [0.37254901960784315, 'rgb(145,41,6)'],
        [0.3764705882352941, 'rgb(145,42,5)'],
        [0.3803921568627451, 'rgb(146,44,5)'],
        [0.3843137254901961, 'rgb(147,46,4)'],
        [0.38823529411764707, 'rgb(147,48,4)'],
        [0.39215686274509803, 'rgb(148,49,3)'],
        [0.396078431372549, 'rgb(148,51,3)'],
        [0.4, 'rgb(149,53,2)'],
        [0.403921568627451, 'rgb(150,54,2)'],
        [0.40784313725490196, 'rgb(150,56,2)'],
        [0.4117647058823529, 'rgb(151,58,2)'],
        [0.41568627450980394, 'rgb(151,60,1)'],
        [0.4196078431372549, 'rgb(152,61,1)'],
        [0.4235294117647059, 'rgb(152,63,1)'],
        [0.42745098039215684, 'rgb(153,65,1)'],
        [0.43137254901960786, 'rgb(153,66,1)'],
        [0.43529411764705883, 'rgb(154,68,1)'],
        [0.4392156862745098, 'rgb(154,69,0)'],
        [0.44313725490196076, 'rgb(155,71,0)'],
        [0.4470588235294118, 'rgb(155,73,0)'],
        [0.45098039215686275, 'rgb(155,74,1)'],
        [0.4549019607843137, 'rgb(156,76,1)'],
        [0.4588235294117647, 'rgb(156,78,1)'],
        [0.4627450980392157, 'rgb(157,79,1)'],
        [0.4666666666666667, 'rgb(157,81,1)'],
        [0.47058823529411764, 'rgb(157,82,1)'],
        [0.4745098039215686, 'rgb(158,84,2)'],
        [0.47843137254901963, 'rgb(158,86,2)'],
        [0.4823529411764706, 'rgb(158,87,3)'],
        [0.48627450980392156, 'rgb(158,89,3)'],
        [0.49019607843137253, 'rgb(159,90,4)'],
        [0.49411764705882355, 'rgb(159,92,4)'],
        [0.4980392156862745, 'rgb(159,94,5)'],
        [0.5019607843137255, 'rgb(159,95,6)'],
        [0.5058823529411764, 'rgb(160,97,7)'],
        [0.5098039215686274, 'rgb(160,98,7)'],
        [0.5137254901960784, 'rgb(160,100,8)'],
        [0.5176470588235295, 'rgb(160,101,9)'],
        [0.5215686274509804, 'rgb(160,103,11)'],
        [0.5254901960784314, 'rgb(160,105,12)'],
        [0.5294117647058824, 'rgb(160,106,13)'],
        [0.5333333333333333, 'rgb(160,108,14)'],
        [0.5372549019607843, 'rgb(160,109,15)'],
        [0.5411764705882353, 'rgb(161,111,16)'],
        [0.5450980392156862, 'rgb(161,113,18)'],
        [0.5490196078431373, 'rgb(161,114,19)'],
        [0.5529411764705883, 'rgb(161,116,20)'],
        [0.5568627450980392, 'rgb(161,117,21)'],
        [0.5607843137254902, 'rgb(161,119,23)'],
        [0.5647058823529412, 'rgb(160,120,24)'],
        [0.5686274509803921, 'rgb(160,122,25)'],
        [0.5725490196078431, 'rgb(160,124,26)'],
        [0.5764705882352941, 'rgb(160,125,28)'],
        [0.5803921568627451, 'rgb(160,127,29)'],
        [0.5843137254901961, 'rgb(160,128,30)'],
        [0.5882352941176471, 'rgb(160,130,32)'],
        [0.592156862745098, 'rgb(160,132,33)'],
        [0.596078431372549, 'rgb(159,133,35)'],
        [0.6, 'rgb(159,135,36)'],
        [0.6039215686274509, 'rgb(159,136,37)'],
        [0.6078431372549019, 'rgb(159,138,39)'],
        [0.611764705882353, 'rgb(158,140,40)'],
        [0.615686274509804, 'rgb(158,141,42)'],
        [0.6196078431372549, 'rgb(158,143,43)'],
        [0.6235294117647059, 'rgb(158,144,45)'],
        [0.6274509803921569, 'rgb(157,146,46)'],
        [0.6313725490196078, 'rgb(157,148,48)'],
        [0.6352941176470588, 'rgb(157,149,49)'],
        [0.6392156862745098, 'rgb(156,151,51)'],
        [0.6431372549019608, 'rgb(156,152,52)'],
        [0.6470588235294118, 'rgb(155,154,54)'],
        [0.6509803921568628, 'rgb(155,156,56)'],
        [0.6549019607843137, 'rgb(154,157,57)'],
        [0.6588235294117647, 'rgb(154,159,59)'],
        [0.6627450980392157, 'rgb(153,160,61)'],
        [0.6666666666666666, 'rgb(153,162,62)'],
        [0.6705882352941176, 'rgb(152,163,64)'],
        [0.6745098039215687, 'rgb(152,165,66)'],
        [0.6784313725490196, 'rgb(151,167,68)'],
        [0.6823529411764706, 'rgb(151,168,69)'],
        [0.6862745098039216, 'rgb(150,170,71)'],
        [0.6901960784313725, 'rgb(149,171,73)'],
        [0.6941176470588235, 'rgb(149,173,75)'],
        [0.6980392156862745, 'rgb(148,175,77)'],
        [0.7019607843137254, 'rgb(147,176,79)'],
        [0.7058823529411765, 'rgb(147,178,81)'],
        [0.7098039215686275, 'rgb(146,179,83)'],
        [0.7137254901960784, 'rgb(145,181,85)'],
        [0.7176470588235294, 'rgb(144,183,87)'],
        [0.7215686274509804, 'rgb(144,184,89)'],
        [0.7254901960784313, 'rgb(143,186,92)'],
        [0.7294117647058823, 'rgb(142,187,94)'],
        [0.7333333333333333, 'rgb(141,189,96)'],
        [0.7372549019607844, 'rgb(141,190,98)'],
        [0.7411764705882353, 'rgb(140,192,101)'],
        [0.7450980392156863, 'rgb(139,193,103)'],
        [0.7490196078431373, 'rgb(139,195,106)'],
        [0.7529411764705882, 'rgb(138,196,109)'],
        [0.7568627450980392, 'rgb(137,198,111)'],
        [0.7607843137254902, 'rgb(137,199,114)'],
        [0.7647058823529411, 'rgb(137,201,117)'],
        [0.7686274509803922, 'rgb(136,202,120)'],
        [0.7725490196078432, 'rgb(136,203,122)'],
        [0.7764705882352941, 'rgb(136,205,125)'],
        [0.7803921568627451, 'rgb(136,206,128)'],
        [0.7843137254901961, 'rgb(137,207,131)'],
        [0.788235294117647, 'rgb(137,208,134)'],
        [0.792156862745098, 'rgb(138,209,138)'],
        [0.796078431372549, 'rgb(139,210,141)'],
        [0.8, 'rgb(140,211,144)'],
        [0.803921568627451, 'rgb(141,212,147)'],
        [0.807843137254902, 'rgb(142,213,150)'],
        [0.8117647058823529, 'rgb(144,214,153)'],
        [0.8156862745098039, 'rgb(146,215,155)'],
        [0.8196078431372549, 'rgb(147,216,158)'],
        [0.8235294117647058, 'rgb(149,217,161)'],
        [0.8274509803921568, 'rgb(151,218,164)'],
        [0.8313725490196079, 'rgb(153,219,167)'],
        [0.8352941176470589, 'rgb(156,220,169)'],
        [0.8392156862745098, 'rgb(158,220,172)'],
        [0.8431372549019608, 'rgb(160,221,175)'],
        [0.8470588235294118, 'rgb(162,222,177)'],
        [0.8509803921568627, 'rgb(165,223,180)'],
        [0.8549019607843137, 'rgb(167,224,182)'],
        [0.8588235294117647, 'rgb(170,224,185)'],
        [0.8627450980392157, 'rgb(172,225,187)'],
        [0.8666666666666667, 'rgb(175,226,189)'],
        [0.8705882352941177, 'rgb(177,227,192)'],
        [0.8745098039215686, 'rgb(179,227,194)'],
        [0.8784313725490196, 'rgb(182,228,196)'],
        [0.8823529411764706, 'rgb(184,229,198)'],
        [0.8862745098039215, 'rgb(187,230,201)'],
        [0.8901960784313725, 'rgb(189,230,203)'],
        [0.8941176470588236, 'rgb(192,231,205)'],
        [0.8980392156862745, 'rgb(194,232,207)'],
        [0.9019607843137255, 'rgb(197,233,209)'],
        [0.9058823529411765, 'rgb(199,234,211)'],
        [0.9098039215686274, 'rgb(202,234,213)'],
        [0.9137254901960784, 'rgb(204,235,215)'],
        [0.9176470588235294, 'rgb(207,236,217)'],
        [0.9215686274509803, 'rgb(209,237,219)'],
        [0.9254901960784314, 'rgb(211,238,221)'],
        [0.9294117647058824, 'rgb(214,238,223)'],
        [0.9333333333333333, 'rgb(216,239,225)'],
        [0.9372549019607843, 'rgb(219,240,227)'],
        [0.9411764705882353, 'rgb(221,241,229)'],
        [0.9450980392156862, 'rgb(223,242,231)'],
        [0.9490196078431372, 'rgb(226,243,233)'],
        [0.9529411764705882, 'rgb(228,244,234)'],
        [0.9568627450980393, 'rgb(230,244,236)'],
        [0.9607843137254902, 'rgb(233,245,238)'],
        [0.9647058823529412, 'rgb(235,246,240)'],
        [0.9686274509803922, 'rgb(237,247,242)'],
        [0.9725490196078431, 'rgb(240,248,243)'],
        [0.9764705882352941, 'rgb(242,249,245)'],
        [0.9803921568627451, 'rgb(244,250,247)'],
        [0.984313725490196, 'rgb(246,251,248)'],
        [0.9882352941176471, 'rgb(249,252,250)'],
        [0.9921568627450981, 'rgb(251,253,252)'],
        [0.996078431372549, 'rgb(253,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.arctic': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(1,1,2)'],
        [0.027450980392156862, 'rgb(2,2,3)'],
        [0.03137254901960784, 'rgb(2,2,3)'],
        [0.03529411764705882, 'rgb(3,3,4)'],
        [0.0392156862745098, 'rgb(4,4,5)'],
        [0.043137254901960784, 'rgb(4,4,6)'],
        [0.047058823529411764, 'rgb(5,5,8)'],
        [0.050980392156862744, 'rgb(6,6,9)'],
        [0.054901960784313725, 'rgb(7,7,10)'],
        [0.058823529411764705, 'rgb(7,8,12)'],
        [0.06274509803921569, 'rgb(8,9,13)'],
        [0.06666666666666667, 'rgb(9,10,15)'],
        [0.07058823529411765, 'rgb(10,11,16)'],
        [0.07450980392156863, 'rgb(11,12,18)'],
        [0.0784313725490196, 'rgb(12,13,19)'],
        [0.08235294117647059, 'rgb(13,14,21)'],
        [0.08627450980392157, 'rgb(14,15,22)'],
        [0.09019607843137255, 'rgb(15,16,24)'],
        [0.09411764705882353, 'rgb(16,17,25)'],
        [0.09803921568627451, 'rgb(17,18,27)'],
        [0.10196078431372549, 'rgb(18,19,28)'],
        [0.10588235294117647, 'rgb(19,20,29)'],
        [0.10980392156862745, 'rgb(20,21,31)'],
        [0.11372549019607843, 'rgb(21,22,32)'],
        [0.11764705882352941, 'rgb(21,23,34)'],
        [0.12156862745098039, 'rgb(22,24,35)'],
        [0.12549019607843137, 'rgb(23,25,37)'],
        [0.12941176470588237, 'rgb(24,26,38)'],
        [0.13333333333333333, 'rgb(25,27,40)'],
        [0.13725490196078433, 'rgb(26,28,41)'],
        [0.1411764705882353, 'rgb(27,28,43)'],
        [0.1450980392156863, 'rgb(27,29,44)'],
        [0.14901960784313725, 'rgb(28,30,46)'],
        [0.15294117647058825, 'rgb(29,31,47)'],
        [0.1568627450980392, 'rgb(30,32,49)'],
        [0.1607843137254902, 'rgb(31,33,50)'],
        [0.16470588235294117, 'rgb(31,34,52)'],
        [0.16862745098039217, 'rgb(32,35,53)'],
        [0.17254901960784313, 'rgb(33,36,55)'],
        [0.17647058823529413, 'rgb(34,37,56)'],
        [0.1803921568627451, 'rgb(34,38,58)'],
        [0.1843137254901961, 'rgb(35,38,60)'],
        [0.18823529411764706, 'rgb(36,39,61)'],
        [0.19215686274509805, 'rgb(37,40,63)'],
        [0.19607843137254902, 'rgb(37,41,64)'],
        [0.2, 'rgb(38,42,66)'],
        [0.20392156862745098, 'rgb(39,43,67)'],
        [0.20784313725490197, 'rgb(39,44,69)'],
        [0.21176470588235294, 'rgb(40,45,71)'],
        [0.21568627450980393, 'rgb(41,46,72)'],
        [0.2196078431372549, 'rgb(42,47,74)'],
        [0.2235294117647059, 'rgb(42,47,76)'],
        [0.22745098039215686, 'rgb(43,48,77)'],
        [0.23137254901960785, 'rgb(44,49,79)'],
        [0.23529411764705882, 'rgb(44,50,81)'],
        [0.23921568627450981, 'rgb(45,51,82)'],
        [0.24313725490196078, 'rgb(45,52,84)'],
        [0.24705882352941178, 'rgb(46,53,86)'],
        [0.25098039215686274, 'rgb(47,54,87)'],
        [0.2549019607843137, 'rgb(47,54,89)'],
        [0.25882352941176473, 'rgb(48,55,91)'],
        [0.2627450980392157, 'rgb(48,56,92)'],
        [0.26666666666666666, 'rgb(49,57,94)'],
        [0.27058823529411763, 'rgb(50,58,96)'],
        [0.27450980392156865, 'rgb(50,59,98)'],
        [0.2784313725490196, 'rgb(51,60,99)'],
        [0.2823529411764706, 'rgb(51,61,101)'],
        [0.28627450980392155, 'rgb(52,61,103)'],
        [0.2901960784313726, 'rgb(52,62,105)'],
        [0.29411764705882354, 'rgb(53,63,107)'],
        [0.2980392156862745, 'rgb(53,64,108)'],
        [0.30196078431372547, 'rgb(54,65,110)'],
        [0.3058823529411765, 'rgb(54,66,112)'],
        [0.30980392156862746, 'rgb(55,67,114)'],
        [0.3137254901960784, 'rgb(55,68,116)'],
        [0.3176470588235294, 'rgb(56,69,118)'],
        [0.3215686274509804, 'rgb(56,69,119)'],
        [0.3254901960784314, 'rgb(57,70,121)'],
        [0.32941176470588235, 'rgb(57,71,123)'],
        [0.3333333333333333, 'rgb(57,72,125)'],
        [0.33725490196078434, 'rgb(58,73,127)'],
        [0.3411764705882353, 'rgb(58,74,129)'],
        [0.34509803921568627, 'rgb(59,75,131)'],
        [0.34901960784313724, 'rgb(59,76,133)'],
        [0.35294117647058826, 'rgb(59,77,135)'],
        [0.3568627450980392, 'rgb(59,78,137)'],
        [0.3607843137254902, 'rgb(60,79,139)'],
        [0.36470588235294116, 'rgb(60,80,141)'],
        [0.3686274509803922, 'rgb(60,80,143)'],
        [0.37254901960784315, 'rgb(60,81,144)'],
        [0.3764705882352941, 'rgb(61,82,146)'],
        [0.3803921568627451, 'rgb(61,83,148)'],
        [0.3843137254901961, 'rgb(61,84,150)'],
        [0.38823529411764707, 'rgb(61,85,152)'],
        [0.39215686274509803, 'rgb(61,86,154)'],
        [0.396078431372549, 'rgb(61,87,156)'],
        [0.4, 'rgb(61,88,158)'],
        [0.403921568627451, 'rgb(61,89,160)'],
        [0.40784313725490196, 'rgb(61,90,162)'],
        [0.4117647058823529, 'rgb(61,91,164)'],
        [0.41568627450980394, 'rgb(61,92,166)'],
        [0.4196078431372549, 'rgb(61,93,168)'],
        [0.4235294117647059, 'rgb(61,94,170)'],
        [0.42745098039215684, 'rgb(60,95,172)'],
        [0.43137254901960786, 'rgb(60,96,174)'],
        [0.43529411764705883, 'rgb(60,97,176)'],
        [0.4392156862745098, 'rgb(59,98,178)'],
        [0.44313725490196076, 'rgb(59,100,179)'],
        [0.4470588235294118, 'rgb(58,101,181)'],
        [0.45098039215686275, 'rgb(58,102,183)'],
        [0.4549019607843137, 'rgb(57,103,185)'],
        [0.4588235294117647, 'rgb(56,104,186)'],
        [0.4627450980392157, 'rgb(56,105,188)'],
        [0.4666666666666667, 'rgb(55,107,189)'],
        [0.47058823529411764, 'rgb(54,108,190)'],
        [0.4745098039215686, 'rgb(53,109,192)'],
        [0.47843137254901963, 'rgb(53,110,193)'],
        [0.4823529411764706, 'rgb(52,112,194)'],
        [0.48627450980392156, 'rgb(51,113,195)'],
        [0.49019607843137253, 'rgb(51,114,196)'],
        [0.49411764705882355, 'rgb(50,115,196)'],
        [0.4980392156862745, 'rgb(49,117,197)'],
        [0.5019607843137255, 'rgb(49,118,198)'],
        [0.5058823529411764, 'rgb(49,119,198)'],
        [0.5098039215686274, 'rgb(49,121,198)'],
        [0.5137254901960784, 'rgb(49,122,199)'],
        [0.5176470588235295, 'rgb(49,123,199)'],
        [0.5215686274509804, 'rgb(49,124,199)'],
        [0.5254901960784314, 'rgb(49,126,200)'],
        [0.5294117647058824, 'rgb(50,127,200)'],
        [0.5333333333333333, 'rgb(50,128,200)'],
        [0.5372549019607843, 'rgb(51,129,200)'],
        [0.5411764705882353, 'rgb(52,130,200)'],
        [0.5450980392156862, 'rgb(53,132,200)'],
        [0.5490196078431373, 'rgb(54,133,200)'],
        [0.5529411764705883, 'rgb(55,134,200)'],
        [0.5568627450980392, 'rgb(56,135,200)'],
        [0.5607843137254902, 'rgb(57,136,200)'],
        [0.5647058823529412, 'rgb(58,137,200)'],
        [0.5686274509803921, 'rgb(60,139,200)'],
        [0.5725490196078431, 'rgb(61,140,200)'],
        [0.5764705882352941, 'rgb(62,141,201)'],
        [0.5803921568627451, 'rgb(64,142,201)'],
        [0.5843137254901961, 'rgb(65,143,201)'],
        [0.5882352941176471, 'rgb(67,144,201)'],
        [0.592156862745098, 'rgb(68,145,201)'],
        [0.596078431372549, 'rgb(70,146,201)'],
        [0.6, 'rgb(71,147,201)'],
        [0.6039215686274509, 'rgb(73,149,201)'],
        [0.6078431372549019, 'rgb(75,150,201)'],
        [0.611764705882353, 'rgb(76,151,201)'],
        [0.615686274509804, 'rgb(78,152,201)'],
        [0.6196078431372549, 'rgb(79,153,201)'],
        [0.6235294117647059, 'rgb(81,154,201)'],
        [0.6274509803921569, 'rgb(83,155,201)'],
        [0.6313725490196078, 'rgb(84,156,201)'],
        [0.6352941176470588, 'rgb(86,157,201)'],
        [0.6392156862745098, 'rgb(88,158,201)'],
        [0.6431372549019608, 'rgb(90,159,201)'],
        [0.6470588235294118, 'rgb(91,160,201)'],
        [0.6509803921568628, 'rgb(93,161,202)'],
        [0.6549019607843137, 'rgb(95,162,202)'],
        [0.6588235294117647, 'rgb(96,163,202)'],
        [0.6627450980392157, 'rgb(98,164,202)'],
        [0.6666666666666666, 'rgb(100,165,202)'],
        [0.6705882352941176, 'rgb(102,166,202)'],
        [0.6745098039215687, 'rgb(103,167,202)'],
        [0.6784313725490196, 'rgb(105,168,203)'],
        [0.6823529411764706, 'rgb(107,169,203)'],
        [0.6862745098039216, 'rgb(109,171,203)'],
        [0.6901960784313725, 'rgb(110,172,203)'],
        [0.6941176470588235, 'rgb(112,173,203)'],
        [0.6980392156862745, 'rgb(114,174,204)'],
        [0.7019607843137254, 'rgb(116,175,204)'],
        [0.7058823529411765, 'rgb(117,176,204)'],
        [0.7098039215686275, 'rgb(119,177,204)'],
        [0.7137254901960784, 'rgb(121,178,205)'],
        [0.7176470588235294, 'rgb(123,179,205)'],
        [0.7215686274509804, 'rgb(125,180,205)'],
        [0.7254901960784313, 'rgb(126,181,206)'],
        [0.7294117647058823, 'rgb(128,182,206)'],
        [0.7333333333333333, 'rgb(130,183,206)'],
        [0.7372549019607844, 'rgb(132,184,206)'],
        [0.7411764705882353, 'rgb(133,185,207)'],
        [0.7450980392156863, 'rgb(135,186,207)'],
        [0.7490196078431373, 'rgb(137,187,207)'],
        [0.7529411764705882, 'rgb(139,188,208)'],
        [0.7568627450980392, 'rgb(141,189,208)'],
        [0.7607843137254902, 'rgb(142,190,209)'],
        [0.7647058823529411, 'rgb(144,191,209)'],
        [0.7686274509803922, 'rgb(146,192,209)'],
        [0.7725490196078432, 'rgb(148,193,210)'],
        [0.7764705882352941, 'rgb(150,194,210)'],
        [0.7803921568627451, 'rgb(151,195,211)'],
        [0.7843137254901961, 'rgb(153,196,211)'],
        [0.788235294117647, 'rgb(155,197,212)'],
        [0.792156862745098, 'rgb(157,198,212)'],
        [0.796078431372549, 'rgb(159,199,213)'],
        [0.8, 'rgb(160,200,213)'],
        [0.803921568627451, 'rgb(162,201,214)'],
        [0.807843137254902, 'rgb(164,202,214)'],
        [0.8117647058823529, 'rgb(166,203,215)'],
        [0.8156862745098039, 'rgb(168,204,215)'],
        [0.8196078431372549, 'rgb(170,205,216)'],
        [0.8235294117647058, 'rgb(171,206,216)'],
        [0.8274509803921568, 'rgb(173,207,217)'],
        [0.8313725490196079, 'rgb(175,208,217)'],
        [0.8352941176470589, 'rgb(177,209,218)'],
        [0.8392156862745098, 'rgb(179,210,219)'],
        [0.8431372549019608, 'rgb(180,211,219)'],
        [0.8470588235294118, 'rgb(182,212,220)'],
        [0.8509803921568627, 'rgb(184,213,220)'],
        [0.8549019607843137, 'rgb(186,214,221)'],
        [0.8588235294117647, 'rgb(188,215,222)'],
        [0.8627450980392157, 'rgb(190,216,223)'],
        [0.8666666666666667, 'rgb(192,217,223)'],
        [0.8705882352941177, 'rgb(193,218,224)'],
        [0.8745098039215686, 'rgb(195,220,225)'],
        [0.8784313725490196, 'rgb(197,221,225)'],
        [0.8823529411764706, 'rgb(199,222,226)'],
        [0.8862745098039215, 'rgb(201,223,227)'],
        [0.8901960784313725, 'rgb(203,224,228)'],
        [0.8941176470588236, 'rgb(204,225,228)'],
        [0.8980392156862745, 'rgb(206,226,229)'],
        [0.9019607843137255, 'rgb(208,227,230)'],
        [0.9058823529411765, 'rgb(210,228,231)'],
        [0.9098039215686274, 'rgb(212,229,232)'],
        [0.9137254901960784, 'rgb(214,230,233)'],
        [0.9176470588235294, 'rgb(216,231,233)'],
        [0.9215686274509803, 'rgb(218,232,234)'],
        [0.9254901960784314, 'rgb(219,233,235)'],
        [0.9294117647058824, 'rgb(221,235,236)'],
        [0.9333333333333333, 'rgb(223,236,237)'],
        [0.9372549019607843, 'rgb(225,237,238)'],
        [0.9411764705882353, 'rgb(227,238,239)'],
        [0.9450980392156862, 'rgb(229,239,240)'],
        [0.9490196078431372, 'rgb(231,240,241)'],
        [0.9529411764705882, 'rgb(233,241,242)'],
        [0.9568627450980393, 'rgb(234,242,243)'],
        [0.9607843137254902, 'rgb(236,243,244)'],
        [0.9647058823529412, 'rgb(238,245,245)'],
        [0.9686274509803922, 'rgb(240,246,246)'],
        [0.9725490196078431, 'rgb(242,247,247)'],
        [0.9764705882352941, 'rgb(244,248,248)'],
        [0.9803921568627451, 'rgb(246,249,249)'],
        [0.984313725490196, 'rgb(248,250,250)'],
        [0.9882352941176471, 'rgb(249,251,252)'],
        [0.9921568627450981, 'rgb(251,253,253)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.chroma': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(0,1,1)'],
        [0.0196078431372549, 'rgb(1,1,2)'],
        [0.023529411764705882, 'rgb(1,2,4)'],
        [0.027450980392156862, 'rgb(1,2,5)'],
        [0.03137254901960784, 'rgb(1,3,7)'],
        [0.03529411764705882, 'rgb(1,3,9)'],
        [0.0392156862745098, 'rgb(1,4,11)'],
        [0.043137254901960784, 'rgb(1,5,14)'],
        [0.047058823529411764, 'rgb(1,6,16)'],
        [0.050980392156862744, 'rgb(1,7,19)'],
        [0.054901960784313725, 'rgb(1,7,22)'],
        [0.058823529411764705, 'rgb(1,8,24)'],
        [0.06274509803921569, 'rgb(1,9,27)'],
        [0.06666666666666667, 'rgb(1,10,30)'],
        [0.07058823529411765, 'rgb(1,11,33)'],
        [0.07450980392156863, 'rgb(1,12,36)'],
        [0.0784313725490196, 'rgb(1,13,39)'],
        [0.08235294117647059, 'rgb(1,14,43)'],
        [0.08627450980392157, 'rgb(1,15,46)'],
        [0.09019607843137255, 'rgb(1,15,49)'],
        [0.09411764705882353, 'rgb(1,16,53)'],
        [0.09803921568627451, 'rgb(1,16,57)'],
        [0.10196078431372549, 'rgb(2,17,61)'],
        [0.10588235294117647, 'rgb(2,17,64)'],
        [0.10980392156862745, 'rgb(3,17,68)'],
        [0.11372549019607843, 'rgb(4,17,72)'],
        [0.11764705882352941, 'rgb(6,17,77)'],
        [0.12156862745098039, 'rgb(8,17,81)'],
        [0.12549019607843137, 'rgb(10,16,85)'],
        [0.12941176470588237, 'rgb(13,15,89)'],
        [0.13333333333333333, 'rgb(16,14,93)'],
        [0.13725490196078433, 'rgb(19,13,97)'],
        [0.1411764705882353, 'rgb(22,11,100)'],
        [0.1450980392156863, 'rgb(25,10,104)'],
        [0.14901960784313725, 'rgb(28,8,107)'],
        [0.15294117647058825, 'rgb(31,6,109)'],
        [0.1568627450980392, 'rgb(34,5,111)'],
        [0.1607843137254902, 'rgb(37,4,113)'],
        [0.16470588235294117, 'rgb(40,3,115)'],
        [0.16862745098039217, 'rgb(42,2,116)'],
        [0.17254901960784313, 'rgb(45,1,117)'],
        [0.17647058823529413, 'rgb(47,1,118)'],
        [0.1803921568627451, 'rgb(50,0,119)'],
        [0.1843137254901961, 'rgb(52,0,119)'],
        [0.18823529411764706, 'rgb(54,0,120)'],
        [0.19215686274509805, 'rgb(56,0,120)'],
        [0.19607843137254902, 'rgb(59,0,120)'],
        [0.2, 'rgb(61,1,121)'],
        [0.20392156862745098, 'rgb(63,1,121)'],
        [0.20784313725490197, 'rgb(65,1,121)'],
        [0.21176470588235294, 'rgb(67,1,121)'],
        [0.21568627450980393, 'rgb(69,2,121)'],
        [0.2196078431372549, 'rgb(71,2,121)'],
        [0.2235294117647059, 'rgb(73,3,120)'],
        [0.22745098039215686, 'rgb(75,3,120)'],
        [0.23137254901960785, 'rgb(77,3,120)'],
        [0.23529411764705882, 'rgb(79,4,120)'],
        [0.23921568627450981, 'rgb(81,4,119)'],
        [0.24313725490196078, 'rgb(83,4,119)'],
        [0.24705882352941178, 'rgb(85,5,119)'],
        [0.25098039215686274, 'rgb(87,5,118)'],
        [0.2549019607843137, 'rgb(89,6,118)'],
        [0.25882352941176473, 'rgb(91,6,118)'],
        [0.2627450980392157, 'rgb(93,6,117)'],
        [0.26666666666666666, 'rgb(95,6,117)'],
        [0.27058823529411763, 'rgb(97,7,116)'],
        [0.27450980392156865, 'rgb(99,7,116)'],
        [0.2784313725490196, 'rgb(101,7,115)'],
        [0.2823529411764706, 'rgb(103,7,115)'],
        [0.28627450980392155, 'rgb(105,7,114)'],
        [0.2901960784313726, 'rgb(107,8,113)'],
        [0.29411764705882354, 'rgb(109,8,112)'],
        [0.2980392156862745, 'rgb(111,8,112)'],
        [0.30196078431372547, 'rgb(113,8,111)'],
        [0.3058823529411765, 'rgb(115,8,110)'],
        [0.30980392156862746, 'rgb(117,8,109)'],
        [0.3137254901960784, 'rgb(119,8,108)'],
        [0.3176470588235294, 'rgb(121,8,107)'],
        [0.3215686274509804, 'rgb(123,9,106)'],
        [0.3254901960784314, 'rgb(125,9,105)'],
        [0.32941176470588235, 'rgb(127,9,104)'],
        [0.3333333333333333, 'rgb(129,9,103)'],
        [0.33725490196078434, 'rgb(131,9,102)'],
        [0.3411764705882353, 'rgb(133,10,101)'],
        [0.34509803921568627, 'rgb(135,10,99)'],
        [0.34901960784313724, 'rgb(137,10,98)'],
        [0.35294117647058826, 'rgb(139,11,97)'],
        [0.3568627450980392, 'rgb(141,11,95)'],
        [0.3607843137254902, 'rgb(143,12,94)'],
        [0.36470588235294116, 'rgb(144,12,92)'],
        [0.3686274509803922, 'rgb(146,13,91)'],
        [0.37254901960784315, 'rgb(148,14,89)'],
        [0.3764705882352941, 'rgb(150,15,88)'],
        [0.3803921568627451, 'rgb(152,16,86)'],
        [0.3843137254901961, 'rgb(153,17,84)'],
        [0.38823529411764707, 'rgb(155,18,83)'],
        [0.39215686274509803, 'rgb(157,19,81)'],
        [0.396078431372549, 'rgb(158,20,79)'],
        [0.4, 'rgb(160,21,77)'],
        [0.403921568627451, 'rgb(161,23,75)'],
        [0.40784313725490196, 'rgb(163,24,74)'],
        [0.4117647058823529, 'rgb(164,26,72)'],
        [0.41568627450980394, 'rgb(166,27,70)'],
        [0.4196078431372549, 'rgb(167,29,68)'],
        [0.4235294117647059, 'rgb(168,31,66)'],
        [0.42745098039215684, 'rgb(170,32,64)'],
        [0.43137254901960786, 'rgb(171,34,63)'],
        [0.43529411764705883, 'rgb(172,36,61)'],
        [0.4392156862745098, 'rgb(173,38,59)'],
        [0.44313725490196076, 'rgb(174,40,57)'],
        [0.4470588235294118, 'rgb(175,42,55)'],
        [0.45098039215686275, 'rgb(176,44,54)'],
        [0.4549019607843137, 'rgb(177,46,52)'],
        [0.4588235294117647, 'rgb(178,48,50)'],
        [0.4627450980392157, 'rgb(179,50,48)'],
        [0.4666666666666667, 'rgb(179,52,47)'],
        [0.47058823529411764, 'rgb(180,54,45)'],
        [0.4745098039215686, 'rgb(181,56,44)'],
        [0.47843137254901963, 'rgb(182,58,42)'],
        [0.4823529411764706, 'rgb(182,60,40)'],
        [0.48627450980392156, 'rgb(183,62,39)'],
        [0.49019607843137253, 'rgb(183,64,37)'],
        [0.49411764705882355, 'rgb(184,66,36)'],
        [0.4980392156862745, 'rgb(184,68,34)'],
        [0.5019607843137255, 'rgb(184,71,33)'],
        [0.5058823529411764, 'rgb(185,73,32)'],
        [0.5098039215686274, 'rgb(185,75,30)'],
        [0.5137254901960784, 'rgb(185,77,29)'],
        [0.5176470588235295, 'rgb(186,79,27)'],
        [0.5215686274509804, 'rgb(186,81,26)'],
        [0.5254901960784314, 'rgb(186,83,25)'],
        [0.5294117647058824, 'rgb(186,85,23)'],
        [0.5333333333333333, 'rgb(186,87,22)'],
        [0.5372549019607843, 'rgb(186,89,21)'],
        [0.5411764705882353, 'rgb(186,91,19)'],
        [0.5450980392156862, 'rgb(186,93,18)'],
        [0.5490196078431373, 'rgb(186,96,16)'],
        [0.5529411764705883, 'rgb(186,98,15)'],
        [0.5568627450980392, 'rgb(186,100,14)'],
        [0.5607843137254902, 'rgb(186,102,12)'],
        [0.5647058823529412, 'rgb(186,104,11)'],
        [0.5686274509803921, 'rgb(186,106,10)'],
        [0.5725490196078431, 'rgb(186,108,8)'],
        [0.5764705882352941, 'rgb(185,110,7)'],
        [0.5803921568627451, 'rgb(185,112,6)'],
        [0.5843137254901961, 'rgb(185,114,5)'],
        [0.5882352941176471, 'rgb(184,116,5)'],
        [0.592156862745098, 'rgb(184,118,4)'],
        [0.596078431372549, 'rgb(183,120,3)'],
        [0.6, 'rgb(183,122,3)'],
        [0.6039215686274509, 'rgb(182,124,3)'],
        [0.6078431372549019, 'rgb(182,126,2)'],
        [0.611764705882353, 'rgb(181,128,2)'],
        [0.615686274509804, 'rgb(181,130,2)'],
        [0.6196078431372549, 'rgb(180,132,3)'],
        [0.6235294117647059, 'rgb(179,135,3)'],
        [0.6274509803921569, 'rgb(179,137,3)'],
        [0.6313725490196078, 'rgb(178,139,4)'],
        [0.6352941176470588, 'rgb(177,141,5)'],
        [0.6392156862745098, 'rgb(176,143,6)'],
        [0.6431372549019608, 'rgb(175,145,7)'],
        [0.6470588235294118, 'rgb(174,147,8)'],
        [0.6509803921568628, 'rgb(173,149,9)'],
        [0.6549019607843137, 'rgb(172,151,11)'],
        [0.6588235294117647, 'rgb(171,153,12)'],
        [0.6627450980392157, 'rgb(170,155,14)'],
        [0.6666666666666666, 'rgb(169,157,16)'],
        [0.6705882352941176, 'rgb(167,159,17)'],
        [0.6745098039215687, 'rgb(166,161,19)'],
        [0.6784313725490196, 'rgb(165,163,21)'],
        [0.6823529411764706, 'rgb(163,165,22)'],
        [0.6862745098039216, 'rgb(162,167,24)'],
        [0.6901960784313725, 'rgb(160,169,26)'],
        [0.6941176470588235, 'rgb(158,171,27)'],
        [0.6980392156862745, 'rgb(157,173,29)'],
        [0.7019607843137254, 'rgb(155,175,31)'],
        [0.7058823529411765, 'rgb(153,177,33)'],
        [0.7098039215686275, 'rgb(151,179,34)'],
        [0.7137254901960784, 'rgb(149,182,36)'],
        [0.7176470588235294, 'rgb(147,184,38)'],
        [0.7215686274509804, 'rgb(144,186,40)'],
        [0.7254901960784313, 'rgb(142,188,42)'],
        [0.7294117647058823, 'rgb(139,190,44)'],
        [0.7333333333333333, 'rgb(136,192,46)'],
        [0.7372549019607844, 'rgb(133,194,48)'],
        [0.7411764705882353, 'rgb(130,196,50)'],
        [0.7450980392156863, 'rgb(127,198,53)'],
        [0.7490196078431373, 'rgb(123,200,55)'],
        [0.7529411764705882, 'rgb(120,203,57)'],
        [0.7568627450980392, 'rgb(116,205,60)'],
        [0.7607843137254902, 'rgb(111,207,62)'],
        [0.7647058823529411, 'rgb(107,209,65)'],
        [0.7686274509803922, 'rgb(102,211,68)'],
        [0.7725490196078432, 'rgb(96,213,71)'],
        [0.7764705882352941, 'rgb(90,215,74)'],
        [0.7803921568627451, 'rgb(84,217,77)'],
        [0.7843137254901961, 'rgb(77,219,81)'],
        [0.788235294117647, 'rgb(70,221,84)'],
        [0.792156862745098, 'rgb(61,223,88)'],
        [0.796078431372549, 'rgb(52,225,92)'],
        [0.8, 'rgb(42,227,97)'],
        [0.803921568627451, 'rgb(31,229,102)'],
        [0.807843137254902, 'rgb(19,230,107)'],
        [0.8117647058823529, 'rgb(7,231,112)'],
        [0.8156862745098039, 'rgb(3,233,117)'],
        [0.8196078431372549, 'rgb(10,234,122)'],
        [0.8235294117647058, 'rgb(22,235,127)'],
        [0.8274509803921568, 'rgb(34,235,132)'],
        [0.8313725490196079, 'rgb(45,236,137)'],
        [0.8352941176470589, 'rgb(55,237,142)'],
        [0.8392156862745098, 'rgb(65,237,146)'],
        [0.8431372549019608, 'rgb(74,237,150)'],
        [0.8470588235294118, 'rgb(82,238,154)'],
        [0.8509803921568627, 'rgb(90,238,158)'],
        [0.8549019607843137, 'rgb(97,239,162)'],
        [0.8588235294117647, 'rgb(104,239,166)'],
        [0.8627450980392157, 'rgb(111,239,169)'],
        [0.8666666666666667, 'rgb(118,239,173)'],
        [0.8705882352941177, 'rgb(124,240,176)'],
        [0.8745098039215686, 'rgb(130,240,179)'],
        [0.8784313725490196, 'rgb(136,240,183)'],
        [0.8823529411764706, 'rgb(141,241,186)'],
        [0.8862745098039215, 'rgb(146,241,189)'],
        [0.8901960784313725, 'rgb(152,241,192)'],
        [0.8941176470588236, 'rgb(157,242,194)'],
        [0.8980392156862745, 'rgb(161,242,197)'],
        [0.9019607843137255, 'rgb(166,242,200)'],
        [0.9058823529411765, 'rgb(171,242,203)'],
        [0.9098039215686274, 'rgb(175,243,205)'],
        [0.9137254901960784, 'rgb(179,243,208)'],
        [0.9176470588235294, 'rgb(184,243,211)'],
        [0.9215686274509803, 'rgb(188,244,213)'],
        [0.9254901960784314, 'rgb(192,244,215)'],
        [0.9294117647058824, 'rgb(196,245,218)'],
        [0.9333333333333333, 'rgb(200,245,220)'],
        [0.9372549019607843, 'rgb(204,245,223)'],
        [0.9411764705882353, 'rgb(207,246,225)'],
        [0.9450980392156862, 'rgb(211,246,227)'],
        [0.9490196078431372, 'rgb(214,247,229)'],
        [0.9529411764705882, 'rgb(218,247,232)'],
        [0.9568627450980393, 'rgb(221,248,234)'],
        [0.9607843137254902, 'rgb(225,248,236)'],
        [0.9647058823529412, 'rgb(228,249,238)'],
        [0.9686274509803922, 'rgb(231,250,240)'],
        [0.9725490196078431, 'rgb(235,250,242)'],
        [0.9764705882352941, 'rgb(238,251,244)'],
        [0.9803921568627451, 'rgb(241,251,246)'],
        [0.984313725490196, 'rgb(244,252,248)'],
        [0.9882352941176471, 'rgb(247,253,250)'],
        [0.9921568627450981, 'rgb(250,253,252)'],
        [0.996078431372549, 'rgb(252,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.dusk': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,2)'],
        [0.023529411764705882, 'rgb(1,1,3)'],
        [0.027450980392156862, 'rgb(2,2,4)'],
        [0.03137254901960784, 'rgb(2,2,5)'],
        [0.03529411764705882, 'rgb(3,3,6)'],
        [0.0392156862745098, 'rgb(3,4,8)'],
        [0.043137254901960784, 'rgb(4,4,9)'],
        [0.047058823529411764, 'rgb(5,5,11)'],
        [0.050980392156862744, 'rgb(5,6,13)'],
        [0.054901960784313725, 'rgb(6,7,15)'],
        [0.058823529411764705, 'rgb(7,7,17)'],
        [0.06274509803921569, 'rgb(8,8,19)'],
        [0.06666666666666667, 'rgb(8,9,21)'],
        [0.07058823529411765, 'rgb(9,10,23)'],
        [0.07450980392156863, 'rgb(10,11,25)'],
        [0.0784313725490196, 'rgb(11,12,27)'],
        [0.08235294117647059, 'rgb(12,13,29)'],
        [0.08627450980392157, 'rgb(13,14,31)'],
        [0.09019607843137255, 'rgb(14,15,33)'],
        [0.09411764705882353, 'rgb(15,16,35)'],
        [0.09803921568627451, 'rgb(16,17,38)'],
        [0.10196078431372549, 'rgb(16,18,40)'],
        [0.10588235294117647, 'rgb(17,18,42)'],
        [0.10980392156862745, 'rgb(18,19,44)'],
        [0.11372549019607843, 'rgb(19,20,46)'],
        [0.11764705882352941, 'rgb(20,21,49)'],
        [0.12156862745098039, 'rgb(20,22,51)'],
        [0.12549019607843137, 'rgb(21,22,53)'],
        [0.12941176470588237, 'rgb(22,23,56)'],
        [0.13333333333333333, 'rgb(23,24,58)'],
        [0.13725490196078433, 'rgb(23,25,61)'],
        [0.1411764705882353, 'rgb(24,26,63)'],
        [0.1450980392156863, 'rgb(25,26,66)'],
        [0.14901960784313725, 'rgb(25,27,68)'],
        [0.15294117647058825, 'rgb(26,28,71)'],
        [0.1568627450980392, 'rgb(27,28,74)'],
        [0.1607843137254902, 'rgb(27,29,76)'],
        [0.16470588235294117, 'rgb(28,30,79)'],
        [0.16862745098039217, 'rgb(28,30,82)'],
        [0.17254901960784313, 'rgb(29,31,85)'],
        [0.17647058823529413, 'rgb(29,32,87)'],
        [0.1803921568627451, 'rgb(30,32,90)'],
        [0.1843137254901961, 'rgb(30,33,93)'],
        [0.18823529411764706, 'rgb(30,34,96)'],
        [0.19215686274509805, 'rgb(30,35,99)'],
        [0.19607843137254902, 'rgb(30,35,102)'],
        [0.2, 'rgb(30,36,105)'],
        [0.20392156862745098, 'rgb(30,37,107)'],
        [0.20784313725490197, 'rgb(29,38,110)'],
        [0.21176470588235294, 'rgb(28,40,112)'],
        [0.21568627450980393, 'rgb(27,41,114)'],
        [0.2196078431372549, 'rgb(25,42,115)'],
        [0.2235294117647059, 'rgb(24,44,116)'],
        [0.22745098039215686, 'rgb(22,46,116)'],
        [0.23137254901960785, 'rgb(21,47,117)'],
        [0.23529411764705882, 'rgb(19,49,117)'],
        [0.23921568627450981, 'rgb(17,51,117)'],
        [0.24313725490196078, 'rgb(16,52,117)'],
        [0.24705882352941178, 'rgb(15,54,116)'],
        [0.25098039215686274, 'rgb(14,55,116)'],
        [0.2549019607843137, 'rgb(13,57,115)'],
        [0.25882352941176473, 'rgb(13,58,115)'],
        [0.2627450980392157, 'rgb(13,60,114)'],
        [0.26666666666666666, 'rgb(14,61,113)'],
        [0.27058823529411763, 'rgb(14,62,113)'],
        [0.27450980392156865, 'rgb(16,64,112)'],
        [0.2784313725490196, 'rgb(17,65,111)'],
        [0.2823529411764706, 'rgb(18,66,111)'],
        [0.28627450980392155, 'rgb(20,67,110)'],
        [0.2901960784313726, 'rgb(22,68,109)'],
        [0.29411764705882354, 'rgb(24,69,109)'],
        [0.2980392156862745, 'rgb(26,70,108)'],
        [0.30196078431372547, 'rgb(28,72,107)'],
        [0.3058823529411765, 'rgb(29,73,107)'],
        [0.30980392156862746, 'rgb(31,74,106)'],
        [0.3137254901960784, 'rgb(33,75,106)'],
        [0.3176470588235294, 'rgb(35,75,105)'],
        [0.3215686274509804, 'rgb(37,76,105)'],
        [0.3254901960784314, 'rgb(39,77,104)'],
        [0.32941176470588235, 'rgb(41,78,104)'],
        [0.3333333333333333, 'rgb(43,79,103)'],
        [0.33725490196078434, 'rgb(45,80,103)'],
        [0.3411764705882353, 'rgb(47,81,103)'],
        [0.34509803921568627, 'rgb(49,82,102)'],
        [0.34901960784313724, 'rgb(51,83,102)'],
        [0.35294117647058826, 'rgb(53,84,102)'],
        [0.3568627450980392, 'rgb(55,84,101)'],
        [0.3607843137254902, 'rgb(56,85,101)'],
        [0.36470588235294116, 'rgb(58,86,101)'],
        [0.3686274509803922, 'rgb(60,87,101)'],
        [0.37254901960784315, 'rgb(62,88,101)'],
        [0.3764705882352941, 'rgb(63,89,100)'],
        [0.3803921568627451, 'rgb(65,89,100)'],
        [0.3843137254901961, 'rgb(67,90,100)'],
        [0.38823529411764707, 'rgb(69,91,100)'],
        [0.39215686274509803, 'rgb(70,92,100)'],
        [0.396078431372549, 'rgb(72,93,100)'],
        [0.4, 'rgb(73,93,100)'],
        [0.403921568627451, 'rgb(75,94,100)'],
        [0.40784313725490196, 'rgb(77,95,100)'],
        [0.4117647058823529, 'rgb(78,96,100)'],
        [0.41568627450980394, 'rgb(80,97,100)'],
        [0.4196078431372549, 'rgb(81,97,100)'],
        [0.4235294117647059, 'rgb(83,98,100)'],
        [0.42745098039215684, 'rgb(84,99,100)'],
        [0.43137254901960786, 'rgb(86,100,100)'],
        [0.43529411764705883, 'rgb(87,101,101)'],
        [0.4392156862745098, 'rgb(89,101,101)'],
        [0.44313725490196076, 'rgb(90,102,101)'],
        [0.4470588235294118, 'rgb(92,103,101)'],
        [0.45098039215686275, 'rgb(93,104,101)'],
        [0.4549019607843137, 'rgb(95,105,101)'],
        [0.4588235294117647, 'rgb(96,106,102)'],
        [0.4627450980392157, 'rgb(97,107,102)'],
        [0.4666666666666667, 'rgb(99,107,102)'],
        [0.47058823529411764, 'rgb(100,108,102)'],
        [0.4745098039215686, 'rgb(102,109,102)'],
        [0.47843137254901963, 'rgb(103,110,102)'],
        [0.4823529411764706, 'rgb(104,111,102)'],
        [0.48627450980392156, 'rgb(106,112,102)'],
        [0.49019607843137253, 'rgb(107,113,101)'],
        [0.49411764705882355, 'rgb(109,113,101)'],
        [0.4980392156862745, 'rgb(110,114,101)'],
        [0.5019607843137255, 'rgb(112,115,100)'],
        [0.5058823529411764, 'rgb(114,116,100)'],
        [0.5098039215686274, 'rgb(115,117,100)'],
        [0.5137254901960784, 'rgb(117,117,99)'],
        [0.5176470588235295, 'rgb(119,118,99)'],
        [0.5215686274509804, 'rgb(121,119,98)'],
        [0.5254901960784314, 'rgb(123,120,98)'],
        [0.5294117647058824, 'rgb(124,120,97)'],
        [0.5333333333333333, 'rgb(126,121,97)'],
        [0.5372549019607843, 'rgb(128,122,96)'],
        [0.5411764705882353, 'rgb(130,122,96)'],
        [0.5450980392156862, 'rgb(132,123,95)'],
        [0.5490196078431373, 'rgb(134,124,94)'],
        [0.5529411764705883, 'rgb(136,124,94)'],
        [0.5568627450980392, 'rgb(138,125,93)'],
        [0.5607843137254902, 'rgb(140,126,93)'],
        [0.5647058823529412, 'rgb(142,126,92)'],
        [0.5686274509803921, 'rgb(144,127,91)'],
        [0.5725490196078431, 'rgb(146,127,91)'],
        [0.5764705882352941, 'rgb(149,128,90)'],
        [0.5803921568627451, 'rgb(151,128,89)'],
        [0.5843137254901961, 'rgb(153,129,89)'],
        [0.5882352941176471, 'rgb(155,130,88)'],
        [0.592156862745098, 'rgb(157,130,87)'],
        [0.596078431372549, 'rgb(159,131,87)'],
        [0.6, 'rgb(162,131,86)'],
        [0.6039215686274509, 'rgb(164,132,85)'],
        [0.6078431372549019, 'rgb(166,132,84)'],
        [0.611764705882353, 'rgb(168,133,84)'],
        [0.615686274509804, 'rgb(171,133,83)'],
        [0.6196078431372549, 'rgb(173,133,82)'],
        [0.6235294117647059, 'rgb(175,134,82)'],
        [0.6274509803921569, 'rgb(178,134,81)'],
        [0.6313725490196078, 'rgb(180,135,80)'],
        [0.6352941176470588, 'rgb(182,135,79)'],
        [0.6392156862745098, 'rgb(185,135,79)'],
        [0.6431372549019608, 'rgb(187,136,78)'],
        [0.6470588235294118, 'rgb(190,136,77)'],
        [0.6509803921568628, 'rgb(192,136,77)'],
        [0.6549019607843137, 'rgb(195,137,76)'],
        [0.6588235294117647, 'rgb(197,137,76)'],
        [0.6627450980392157, 'rgb(200,137,75)'],
        [0.6666666666666666, 'rgb(202,138,75)'],
        [0.6705882352941176, 'rgb(205,138,74)'],
        [0.6745098039215687, 'rgb(207,138,74)'],
        [0.6784313725490196, 'rgb(210,138,73)'],
        [0.6823529411764706, 'rgb(212,138,73)'],
        [0.6862745098039216, 'rgb(215,139,73)'],
        [0.6901960784313725, 'rgb(217,139,73)'],
        [0.6941176470588235, 'rgb(220,139,73)'],
        [0.6980392156862745, 'rgb(222,139,73)'],
        [0.7019607843137254, 'rgb(225,139,73)'],
        [0.7058823529411765, 'rgb(227,139,73)'],
        [0.7098039215686275, 'rgb(230,139,73)'],
        [0.7137254901960784, 'rgb(233,139,74)'],
        [0.7176470588235294, 'rgb(235,140,75)'],
        [0.7215686274509804, 'rgb(237,140,76)'],
        [0.7254901960784313, 'rgb(240,140,77)'],
        [0.7294117647058823, 'rgb(242,140,78)'],
        [0.7333333333333333, 'rgb(244,140,80)'],
        [0.7372549019607844, 'rgb(246,141,82)'],
        [0.7411764705882353, 'rgb(248,141,85)'],
        [0.7450980392156863, 'rgb(250,142,87)'],
        [0.7490196078431373, 'rgb(251,143,91)'],
        [0.7529411764705882, 'rgb(252,144,94)'],
        [0.7568627450980392, 'rgb(253,145,97)'],
        [0.7607843137254902, 'rgb(254,146,101)'],
        [0.7647058823529411, 'rgb(254,148,104)'],
        [0.7686274509803922, 'rgb(254,150,108)'],
        [0.7725490196078432, 'rgb(255,151,111)'],
        [0.7764705882352941, 'rgb(255,153,114)'],
        [0.7803921568627451, 'rgb(255,155,117)'],
        [0.7843137254901961, 'rgb(255,157,120)'],
        [0.788235294117647, 'rgb(255,159,123)'],
        [0.792156862745098, 'rgb(255,160,126)'],
        [0.796078431372549, 'rgb(255,162,129)'],
        [0.8, 'rgb(255,164,132)'],
        [0.803921568627451, 'rgb(255,166,135)'],
        [0.807843137254902, 'rgb(255,168,138)'],
        [0.8117647058823529, 'rgb(254,170,141)'],
        [0.8156862745098039, 'rgb(254,172,144)'],
        [0.8196078431372549, 'rgb(254,174,146)'],
        [0.8235294117647058, 'rgb(254,175,149)'],
        [0.8274509803921568, 'rgb(254,177,152)'],
        [0.8313725490196079, 'rgb(254,179,154)'],
        [0.8352941176470589, 'rgb(254,181,157)'],
        [0.8392156862745098, 'rgb(254,183,160)'],
        [0.8431372549019608, 'rgb(253,185,162)'],
        [0.8470588235294118, 'rgb(253,187,165)'],
        [0.8509803921568627, 'rgb(253,188,168)'],
        [0.8549019607843137, 'rgb(253,190,170)'],
        [0.8588235294117647, 'rgb(253,192,173)'],
        [0.8627450980392157, 'rgb(253,194,175)'],
        [0.8666666666666667, 'rgb(252,196,178)'],
        [0.8705882352941177, 'rgb(252,198,180)'],
        [0.8745098039215686, 'rgb(252,199,183)'],
        [0.8784313725490196, 'rgb(252,201,185)'],
        [0.8823529411764706, 'rgb(252,203,188)'],
        [0.8862745098039215, 'rgb(252,205,190)'],
        [0.8901960784313725, 'rgb(252,207,193)'],
        [0.8941176470588236, 'rgb(251,208,195)'],
        [0.8980392156862745, 'rgb(251,210,198)'],
        [0.9019607843137255, 'rgb(251,212,200)'],
        [0.9058823529411765, 'rgb(251,214,202)'],
        [0.9098039215686274, 'rgb(251,216,205)'],
        [0.9137254901960784, 'rgb(251,217,207)'],
        [0.9176470588235294, 'rgb(251,219,210)'],
        [0.9215686274509803, 'rgb(251,221,212)'],
        [0.9254901960784314, 'rgb(251,223,214)'],
        [0.9294117647058824, 'rgb(251,225,217)'],
        [0.9333333333333333, 'rgb(251,226,219)'],
        [0.9372549019607843, 'rgb(251,228,221)'],
        [0.9411764705882353, 'rgb(251,230,224)'],
        [0.9450980392156862, 'rgb(251,232,226)'],
        [0.9490196078431372, 'rgb(251,233,228)'],
        [0.9529411764705882, 'rgb(251,235,230)'],
        [0.9568627450980393, 'rgb(251,237,233)'],
        [0.9607843137254902, 'rgb(251,239,235)'],
        [0.9647058823529412, 'rgb(251,240,237)'],
        [0.9686274509803922, 'rgb(251,242,239)'],
        [0.9725490196078431, 'rgb(251,244,241)'],
        [0.9764705882352941, 'rgb(251,245,244)'],
        [0.9803921568627451, 'rgb(252,247,246)'],
        [0.984313725490196, 'rgb(252,249,248)'],
        [0.9882352941176471, 'rgb(253,250,249)'],
        [0.9921568627450981, 'rgb(254,252,251)'],
        [0.996078431372549, 'rgb(254,253,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.eclipse': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(1,1,2)'],
        [0.027450980392156862, 'rgb(2,2,3)'],
        [0.03137254901960784, 'rgb(2,2,3)'],
        [0.03529411764705882, 'rgb(3,3,4)'],
        [0.0392156862745098, 'rgb(3,3,5)'],
        [0.043137254901960784, 'rgb(4,4,7)'],
        [0.047058823529411764, 'rgb(4,5,8)'],
        [0.050980392156862744, 'rgb(5,6,9)'],
        [0.054901960784313725, 'rgb(5,6,11)'],
        [0.058823529411764705, 'rgb(6,7,12)'],
        [0.06274509803921569, 'rgb(7,8,14)'],
        [0.06666666666666667, 'rgb(8,9,15)'],
        [0.07058823529411765, 'rgb(8,10,17)'],
        [0.07450980392156863, 'rgb(9,11,18)'],
        [0.0784313725490196, 'rgb(10,12,20)'],
        [0.08235294117647059, 'rgb(11,13,21)'],
        [0.08627450980392157, 'rgb(11,14,23)'],
        [0.09019607843137255, 'rgb(12,15,24)'],
        [0.09411764705882353, 'rgb(13,16,26)'],
        [0.09803921568627451, 'rgb(13,17,28)'],
        [0.10196078431372549, 'rgb(14,18,29)'],
        [0.10588235294117647, 'rgb(15,19,31)'],
        [0.10980392156862745, 'rgb(15,20,32)'],
        [0.11372549019607843, 'rgb(16,21,34)'],
        [0.11764705882352941, 'rgb(17,22,35)'],
        [0.12156862745098039, 'rgb(17,23,37)'],
        [0.12549019607843137, 'rgb(18,24,38)'],
        [0.12941176470588237, 'rgb(18,25,40)'],
        [0.13333333333333333, 'rgb(19,26,41)'],
        [0.13725490196078433, 'rgb(19,27,43)'],
        [0.1411764705882353, 'rgb(20,28,45)'],
        [0.1450980392156863, 'rgb(20,29,46)'],
        [0.14901960784313725, 'rgb(20,30,48)'],
        [0.15294117647058825, 'rgb(21,31,49)'],
        [0.1568627450980392, 'rgb(21,32,51)'],
        [0.1607843137254902, 'rgb(21,33,53)'],
        [0.16470588235294117, 'rgb(22,34,54)'],
        [0.16862745098039217, 'rgb(22,35,56)'],
        [0.17254901960784313, 'rgb(22,36,57)'],
        [0.17647058823529413, 'rgb(22,37,59)'],
        [0.1803921568627451, 'rgb(22,38,60)'],
        [0.1843137254901961, 'rgb(22,39,62)'],
        [0.18823529411764706, 'rgb(22,40,63)'],
        [0.19215686274509805, 'rgb(22,41,65)'],
        [0.19607843137254902, 'rgb(22,42,67)'],
        [0.2, 'rgb(22,43,68)'],
        [0.20392156862745098, 'rgb(22,44,70)'],
        [0.20784313725490197, 'rgb(22,45,71)'],
        [0.21176470588235294, 'rgb(22,46,73)'],
        [0.21568627450980393, 'rgb(21,47,74)'],
        [0.2196078431372549, 'rgb(21,48,75)'],
        [0.2235294117647059, 'rgb(20,49,77)'],
        [0.22745098039215686, 'rgb(20,50,78)'],
        [0.23137254901960785, 'rgb(19,51,80)'],
        [0.23529411764705882, 'rgb(18,52,81)'],
        [0.23921568627450981, 'rgb(17,53,82)'],
        [0.24313725490196078, 'rgb(17,55,83)'],
        [0.24705882352941178, 'rgb(16,56,84)'],
        [0.25098039215686274, 'rgb(15,57,86)'],
        [0.2549019607843137, 'rgb(13,58,87)'],
        [0.25882352941176473, 'rgb(12,59,87)'],
        [0.2627450980392157, 'rgb(11,60,88)'],
        [0.26666666666666666, 'rgb(10,61,89)'],
        [0.27058823529411763, 'rgb(9,62,90)'],
        [0.27450980392156865, 'rgb(8,63,91)'],
        [0.2784313725490196, 'rgb(7,65,91)'],
        [0.2823529411764706, 'rgb(6,66,92)'],
        [0.28627450980392155, 'rgb(5,67,92)'],
        [0.2901960784313726, 'rgb(5,68,93)'],
        [0.29411764705882354, 'rgb(5,69,93)'],
        [0.2980392156862745, 'rgb(5,70,93)'],
        [0.30196078431372547, 'rgb(6,71,94)'],
        [0.3058823529411765, 'rgb(7,72,94)'],
        [0.30980392156862746, 'rgb(7,73,94)'],
        [0.3137254901960784, 'rgb(9,74,94)'],
        [0.3176470588235294, 'rgb(10,75,95)'],
        [0.3215686274509804, 'rgb(12,76,95)'],
        [0.3254901960784314, 'rgb(13,77,95)'],
        [0.32941176470588235, 'rgb(15,78,95)'],
        [0.3333333333333333, 'rgb(17,79,95)'],
        [0.33725490196078434, 'rgb(19,80,95)'],
        [0.3411764705882353, 'rgb(21,81,96)'],
        [0.34509803921568627, 'rgb(22,82,96)'],
        [0.34901960784313724, 'rgb(24,82,96)'],
        [0.35294117647058826, 'rgb(26,83,96)'],
        [0.3568627450980392, 'rgb(28,84,96)'],
        [0.3607843137254902, 'rgb(30,85,96)'],
        [0.36470588235294116, 'rgb(31,86,96)'],
        [0.3686274509803922, 'rgb(33,87,97)'],
        [0.37254901960784315, 'rgb(35,88,97)'],
        [0.3764705882352941, 'rgb(37,89,97)'],
        [0.3803921568627451, 'rgb(38,89,97)'],
        [0.3843137254901961, 'rgb(40,90,97)'],
        [0.38823529411764707, 'rgb(42,91,97)'],
        [0.39215686274509803, 'rgb(44,92,98)'],
        [0.396078431372549, 'rgb(45,93,98)'],
        [0.4, 'rgb(47,94,98)'],
        [0.403921568627451, 'rgb(49,94,98)'],
        [0.40784313725490196, 'rgb(50,95,98)'],
        [0.4117647058823529, 'rgb(52,96,99)'],
        [0.41568627450980394, 'rgb(53,97,99)'],
        [0.4196078431372549, 'rgb(55,98,99)'],
        [0.4235294117647059, 'rgb(57,98,99)'],
        [0.42745098039215684, 'rgb(58,99,99)'],
        [0.43137254901960786, 'rgb(60,100,100)'],
        [0.43529411764705883, 'rgb(61,101,100)'],
        [0.4392156862745098, 'rgb(63,102,100)'],
        [0.44313725490196076, 'rgb(64,102,100)'],
        [0.4470588235294118, 'rgb(66,103,101)'],
        [0.45098039215686275, 'rgb(67,104,101)'],
        [0.4549019607843137, 'rgb(69,105,101)'],
        [0.4588235294117647, 'rgb(70,106,101)'],
        [0.4627450980392157, 'rgb(72,106,102)'],
        [0.4666666666666667, 'rgb(73,107,102)'],
        [0.47058823529411764, 'rgb(75,108,102)'],
        [0.4745098039215686, 'rgb(76,109,102)'],
        [0.47843137254901963, 'rgb(78,110,103)'],
        [0.4823529411764706, 'rgb(79,110,103)'],
        [0.48627450980392156, 'rgb(81,111,103)'],
        [0.49019607843137253, 'rgb(82,112,104)'],
        [0.49411764705882355, 'rgb(84,113,104)'],
        [0.4980392156862745, 'rgb(85,114,104)'],
        [0.5019607843137255, 'rgb(86,114,105)'],
        [0.5058823529411764, 'rgb(88,115,105)'],
        [0.5098039215686274, 'rgb(89,116,105)'],
        [0.5137254901960784, 'rgb(91,117,105)'],
        [0.5176470588235295, 'rgb(92,118,106)'],
        [0.5215686274509804, 'rgb(93,119,106)'],
        [0.5254901960784314, 'rgb(95,119,106)'],
        [0.5294117647058824, 'rgb(96,120,107)'],
        [0.5333333333333333, 'rgb(98,121,107)'],
        [0.5372549019607843, 'rgb(99,122,107)'],
        [0.5411764705882353, 'rgb(100,123,107)'],
        [0.5450980392156862, 'rgb(102,123,108)'],
        [0.5490196078431373, 'rgb(103,124,108)'],
        [0.5529411764705883, 'rgb(105,125,108)'],
        [0.5568627450980392, 'rgb(106,126,108)'],
        [0.5607843137254902, 'rgb(108,127,108)'],
        [0.5647058823529412, 'rgb(109,127,109)'],
        [0.5686274509803921, 'rgb(110,128,109)'],
        [0.5725490196078431, 'rgb(112,129,109)'],
        [0.5764705882352941, 'rgb(113,130,109)'],
        [0.5803921568627451, 'rgb(115,131,109)'],
        [0.5843137254901961, 'rgb(116,131,110)'],
        [0.5882352941176471, 'rgb(118,132,110)'],
        [0.592156862745098, 'rgb(119,133,110)'],
        [0.596078431372549, 'rgb(121,134,110)'],
        [0.6, 'rgb(122,135,110)'],
        [0.6039215686274509, 'rgb(124,135,110)'],
        [0.6078431372549019, 'rgb(125,136,110)'],
        [0.611764705882353, 'rgb(127,137,110)'],
        [0.615686274509804, 'rgb(128,138,110)'],
        [0.6196078431372549, 'rgb(130,139,110)'],
        [0.6235294117647059, 'rgb(132,139,110)'],
        [0.6274509803921569, 'rgb(133,140,110)'],
        [0.6313725490196078, 'rgb(135,141,110)'],
        [0.6352941176470588, 'rgb(136,142,110)'],
        [0.6392156862745098, 'rgb(138,142,110)'],
        [0.6431372549019608, 'rgb(140,143,110)'],
        [0.6470588235294118, 'rgb(141,144,110)'],
        [0.6509803921568628, 'rgb(143,145,110)'],
        [0.6549019607843137, 'rgb(145,145,110)'],
        [0.6588235294117647, 'rgb(146,146,110)'],
        [0.6627450980392157, 'rgb(148,147,110)'],
        [0.6666666666666666, 'rgb(150,148,110)'],
        [0.6705882352941176, 'rgb(152,148,110)'],
        [0.6745098039215687, 'rgb(153,149,110)'],
        [0.6784313725490196, 'rgb(155,150,110)'],
        [0.6823529411764706, 'rgb(157,151,110)'],
        [0.6862745098039216, 'rgb(159,151,110)'],
        [0.6901960784313725, 'rgb(160,152,110)'],
        [0.6941176470588235, 'rgb(162,153,109)'],
        [0.6980392156862745, 'rgb(164,153,109)'],
        [0.7019607843137254, 'rgb(166,154,109)'],
        [0.7058823529411765, 'rgb(168,155,109)'],
        [0.7098039215686275, 'rgb(170,156,109)'],
        [0.7137254901960784, 'rgb(171,156,109)'],
        [0.7176470588235294, 'rgb(173,157,109)'],
        [0.7215686274509804, 'rgb(175,158,108)'],
        [0.7254901960784313, 'rgb(177,158,108)'],
        [0.7294117647058823, 'rgb(179,159,108)'],
        [0.7333333333333333, 'rgb(181,160,108)'],
        [0.7372549019607844, 'rgb(183,161,108)'],
        [0.7411764705882353, 'rgb(184,161,107)'],
        [0.7450980392156863, 'rgb(186,162,107)'],
        [0.7490196078431373, 'rgb(188,163,107)'],
        [0.7529411764705882, 'rgb(190,163,106)'],
        [0.7568627450980392, 'rgb(192,164,106)'],
        [0.7607843137254902, 'rgb(194,165,106)'],
        [0.7647058823529411, 'rgb(196,165,105)'],
        [0.7686274509803922, 'rgb(198,166,105)'],
        [0.7725490196078432, 'rgb(200,167,105)'],
        [0.7764705882352941, 'rgb(201,168,104)'],
        [0.7803921568627451, 'rgb(203,168,104)'],
        [0.7843137254901961, 'rgb(205,169,103)'],
        [0.788235294117647, 'rgb(207,170,103)'],
        [0.792156862745098, 'rgb(209,171,102)'],
        [0.796078431372549, 'rgb(211,171,101)'],
        [0.8, 'rgb(212,172,101)'],
        [0.803921568627451, 'rgb(214,173,100)'],
        [0.807843137254902, 'rgb(216,174,99)'],
        [0.8117647058823529, 'rgb(218,175,99)'],
        [0.8156862745098039, 'rgb(219,176,98)'],
        [0.8196078431372549, 'rgb(221,177,97)'],
        [0.8235294117647058, 'rgb(222,178,96)'],
        [0.8274509803921568, 'rgb(224,179,95)'],
        [0.8313725490196079, 'rgb(225,180,95)'],
        [0.8352941176470589, 'rgb(226,181,94)'],
        [0.8392156862745098, 'rgb(227,182,93)'],
        [0.8431372549019608, 'rgb(229,183,93)'],
        [0.8470588235294118, 'rgb(230,184,92)'],
        [0.8509803921568627, 'rgb(231,185,91)'],
        [0.8549019607843137, 'rgb(232,187,91)'],
        [0.8588235294117647, 'rgb(233,188,90)'],
        [0.8627450980392157, 'rgb(233,189,90)'],
        [0.8666666666666667, 'rgb(234,191,89)'],
        [0.8705882352941177, 'rgb(235,192,89)'],
        [0.8745098039215686, 'rgb(236,193,89)'],
        [0.8784313725490196, 'rgb(237,195,88)'],
        [0.8823529411764706, 'rgb(237,196,88)'],
        [0.8862745098039215, 'rgb(238,198,88)'],
        [0.8901960784313725, 'rgb(239,199,88)'],
        [0.8941176470588236, 'rgb(239,200,87)'],
        [0.8980392156862745, 'rgb(240,202,87)'],
        [0.9019607843137255, 'rgb(241,203,87)'],
        [0.9058823529411765, 'rgb(241,205,87)'],
        [0.9098039215686274, 'rgb(242,206,87)'],
        [0.9137254901960784, 'rgb(243,208,87)'],
        [0.9176470588235294, 'rgb(243,209,87)'],
        [0.9215686274509803, 'rgb(244,211,86)'],
        [0.9254901960784314, 'rgb(244,212,86)'],
        [0.9294117647058824, 'rgb(245,214,86)'],
        [0.9333333333333333, 'rgb(245,215,86)'],
        [0.9372549019607843, 'rgb(246,217,86)'],
        [0.9411764705882353, 'rgb(247,218,86)'],
        [0.9450980392156862, 'rgb(247,220,86)'],
        [0.9490196078431372, 'rgb(248,221,86)'],
        [0.9529411764705882, 'rgb(248,223,86)'],
        [0.9568627450980393, 'rgb(249,225,86)'],
        [0.9607843137254902, 'rgb(249,226,86)'],
        [0.9647058823529412, 'rgb(250,228,86)'],
        [0.9686274509803922, 'rgb(250,229,86)'],
        [0.9725490196078431, 'rgb(251,231,85)'],
        [0.9764705882352941, 'rgb(251,233,85)'],
        [0.9803921568627451, 'rgb(252,234,85)'],
        [0.984313725490196, 'rgb(252,236,85)'],
        [0.9882352941176471, 'rgb(252,237,85)'],
        [0.9921568627450981, 'rgb(253,239,85)'],
        [0.996078431372549, 'rgb(253,241,85)'],
        [1.0, 'rgb(254,242,85)'],
    ],
    'cmr.ember': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(1,1,2)'],
        [0.027450980392156862, 'rgb(1,2,3)'],
        [0.03137254901960784, 'rgb(2,2,4)'],
        [0.03529411764705882, 'rgb(2,3,5)'],
        [0.0392156862745098, 'rgb(3,3,6)'],
        [0.043137254901960784, 'rgb(3,4,7)'],
        [0.047058823529411764, 'rgb(4,4,8)'],
        [0.050980392156862744, 'rgb(5,5,10)'],
        [0.054901960784313725, 'rgb(6,5,11)'],
        [0.058823529411764705, 'rgb(6,6,13)'],
        [0.06274509803921569, 'rgb(7,7,14)'],
        [0.06666666666666667, 'rgb(9,7,16)'],
        [0.07058823529411765, 'rgb(10,8,17)'],
        [0.07450980392156863, 'rgb(11,9,19)'],
        [0.0784313725490196, 'rgb(13,9,20)'],
        [0.08235294117647059, 'rgb(14,10,22)'],
        [0.08627450980392157, 'rgb(15,11,23)'],
        [0.09019607843137255, 'rgb(17,11,24)'],
        [0.09411764705882353, 'rgb(18,12,26)'],
        [0.09803921568627451, 'rgb(19,13,27)'],
        [0.10196078431372549, 'rgb(21,13,28)'],
        [0.10588235294117647, 'rgb(22,14,29)'],
        [0.10980392156862745, 'rgb(24,14,31)'],
        [0.11372549019607843, 'rgb(25,15,32)'],
        [0.11764705882352941, 'rgb(27,16,33)'],
        [0.12156862745098039, 'rgb(28,16,34)'],
        [0.12549019607843137, 'rgb(30,17,35)'],
        [0.12941176470588237, 'rgb(31,17,36)'],
        [0.13333333333333333, 'rgb(33,18,37)'],
        [0.13725490196078433, 'rgb(34,18,38)'],
        [0.1411764705882353, 'rgb(36,19,40)'],
        [0.1450980392156863, 'rgb(37,19,41)'],
        [0.14901960784313725, 'rgb(39,19,42)'],
        [0.15294117647058825, 'rgb(40,20,43)'],
        [0.1568627450980392, 'rgb(42,20,44)'],
        [0.1607843137254902, 'rgb(43,21,44)'],
        [0.16470588235294117, 'rgb(45,21,45)'],
        [0.16862745098039217, 'rgb(46,21,46)'],
        [0.17254901960784313, 'rgb(48,22,47)'],
        [0.17647058823529413, 'rgb(49,22,48)'],
        [0.1803921568627451, 'rgb(51,22,49)'],
        [0.1843137254901961, 'rgb(52,23,50)'],
        [0.18823529411764706, 'rgb(54,23,51)'],
        [0.19215686274509805, 'rgb(55,23,52)'],
        [0.19607843137254902, 'rgb(57,24,52)'],
        [0.2, 'rgb(59,24,53)'],
        [0.20392156862745098, 'rgb(60,24,54)'],
        [0.20784313725490197, 'rgb(62,24,55)'],
        [0.21176470588235294, 'rgb(63,25,55)'],
        [0.21568627450980393, 'rgb(65,25,56)'],
        [0.2196078431372549, 'rgb(67,25,57)'],
        [0.2235294117647059, 'rgb(68,25,58)'],
        [0.22745098039215686, 'rgb(70,25,58)'],
        [0.23137254901960785, 'rgb(71,25,59)'],
        [0.23529411764705882, 'rgb(73,26,59)'],
        [0.23921568627450981, 'rgb(75,26,60)'],
        [0.24313725490196078, 'rgb(76,26,61)'],
        [0.24705882352941178, 'rgb(78,26,61)'],
        [0.25098039215686274, 'rgb(80,26,62)'],
        [0.2549019607843137, 'rgb(81,26,62)'],
        [0.25882352941176473, 'rgb(83,26,63)'],
        [0.2627450980392157, 'rgb(85,26,63)'],
        [0.26666666666666666, 'rgb(86,26,64)'],
        [0.27058823529411763, 'rgb(88,26,64)'],
        [0.27450980392156865, 'rgb(90,26,65)'],
        [0.2784313725490196, 'rgb(91,26,65)'],
        [0.2823529411764706, 'rgb(93,26,66)'],
        [0.28627450980392155, 'rgb(95,26,66)'],
        [0.2901960784313726, 'rgb(96,26,66)'],
        [0.29411764705882354, 'rgb(98,26,67)'],
        [0.2980392156862745, 'rgb(100,26,67)'],
        [0.30196078431372547, 'rgb(101,26,67)'],
        [0.3058823529411765, 'rgb(103,26,68)'],
        [0.30980392156862746, 'rgb(105,26,68)'],
        [0.3137254901960784, 'rgb(106,26,68)'],
        [0.3176470588235294, 'rgb(108,25,69)'],
        [0.3215686274509804, 'rgb(110,25,69)'],
        [0.3254901960784314, 'rgb(112,25,69)'],
        [0.32941176470588235, 'rgb(113,25,69)'],
        [0.3333333333333333, 'rgb(115,25,69)'],
        [0.33725490196078434, 'rgb(117,24,69)'],
        [0.3411764705882353, 'rgb(118,24,70)'],
        [0.34509803921568627, 'rgb(120,24,70)'],
        [0.34901960784313724, 'rgb(122,24,70)'],
        [0.35294117647058826, 'rgb(124,23,70)'],
        [0.3568627450980392, 'rgb(125,23,70)'],
        [0.3607843137254902, 'rgb(127,23,70)'],
        [0.36470588235294116, 'rgb(129,22,70)'],
        [0.3686274509803922, 'rgb(130,22,70)'],
        [0.37254901960784315, 'rgb(132,21,70)'],
        [0.3764705882352941, 'rgb(134,21,69)'],
        [0.3803921568627451, 'rgb(136,21,69)'],
        [0.3843137254901961, 'rgb(137,20,69)'],
        [0.38823529411764707, 'rgb(139,20,69)'],
        [0.39215686274509803, 'rgb(141,19,69)'],
        [0.396078431372549, 'rgb(143,19,69)'],
        [0.4, 'rgb(144,18,68)'],
        [0.403921568627451, 'rgb(146,18,68)'],
        [0.40784313725490196, 'rgb(148,17,68)'],
        [0.4117647058823529, 'rgb(149,16,67)'],
        [0.41568627450980394, 'rgb(151,16,67)'],
        [0.4196078431372549, 'rgb(153,15,67)'],
        [0.4235294117647059, 'rgb(155,15,66)'],
        [0.42745098039215684, 'rgb(156,14,66)'],
        [0.43137254901960786, 'rgb(158,13,65)'],
        [0.43529411764705883, 'rgb(160,13,65)'],
        [0.4392156862745098, 'rgb(161,12,64)'],
        [0.44313725490196076, 'rgb(163,12,64)'],
        [0.4470588235294118, 'rgb(165,11,63)'],
        [0.45098039215686275, 'rgb(166,11,63)'],
        [0.4549019607843137, 'rgb(168,10,62)'],
        [0.4588235294117647, 'rgb(170,10,61)'],
        [0.4627450980392157, 'rgb(171,10,61)'],
        [0.4666666666666667, 'rgb(173,10,60)'],
        [0.47058823529411764, 'rgb(174,9,59)'],
        [0.4745098039215686, 'rgb(176,9,58)'],
        [0.47843137254901963, 'rgb(177,10,58)'],
        [0.4823529411764706, 'rgb(179,10,57)'],
        [0.48627450980392156, 'rgb(181,10,56)'],
        [0.49019607843137253, 'rgb(182,11,55)'],
        [0.49411764705882355, 'rgb(183,12,54)'],
        [0.4980392156862745, 'rgb(185,12,53)'],
        [0.5019607843137255, 'rgb(186,13,52)'],
        [0.5058823529411764, 'rgb(188,14,51)'],
        [0.5098039215686274, 'rgb(189,16,51)'],
        [0.5137254901960784, 'rgb(191,17,50)'],
        [0.5176470588235295, 'rgb(192,18,49)'],
        [0.5215686274509804, 'rgb(193,20,48)'],
        [0.5254901960784314, 'rgb(194,21,47)'],
        [0.5294117647058824, 'rgb(196,23,46)'],
        [0.5333333333333333, 'rgb(197,24,45)'],
        [0.5372549019607843, 'rgb(198,26,44)'],
        [0.5411764705882353, 'rgb(199,27,43)'],
        [0.5450980392156862, 'rgb(200,29,42)'],
        [0.5490196078431373, 'rgb(202,31,41)'],
        [0.5529411764705883, 'rgb(203,33,40)'],
        [0.5568627450980392, 'rgb(204,34,39)'],
        [0.5607843137254902, 'rgb(205,36,38)'],
        [0.5647058823529412, 'rgb(206,38,37)'],
        [0.5686274509803921, 'rgb(207,40,36)'],
        [0.5725490196078431, 'rgb(208,41,35)'],
        [0.5764705882352941, 'rgb(209,43,34)'],
        [0.5803921568627451, 'rgb(210,45,33)'],
        [0.5843137254901961, 'rgb(211,47,32)'],
        [0.5882352941176471, 'rgb(211,48,31)'],
        [0.592156862745098, 'rgb(212,50,31)'],
        [0.596078431372549, 'rgb(213,52,30)'],
        [0.6, 'rgb(214,54,29)'],
        [0.6039215686274509, 'rgb(215,56,28)'],
        [0.6078431372549019, 'rgb(216,57,27)'],
        [0.611764705882353, 'rgb(216,59,26)'],
        [0.615686274509804, 'rgb(217,61,25)'],
        [0.6196078431372549, 'rgb(218,63,24)'],
        [0.6235294117647059, 'rgb(219,64,24)'],
        [0.6274509803921569, 'rgb(219,66,23)'],
        [0.6313725490196078, 'rgb(220,68,22)'],
        [0.6352941176470588, 'rgb(221,70,21)'],
        [0.6392156862745098, 'rgb(221,71,20)'],
        [0.6431372549019608, 'rgb(222,73,19)'],
        [0.6470588235294118, 'rgb(223,75,18)'],
        [0.6509803921568628, 'rgb(223,76,18)'],
        [0.6549019607843137, 'rgb(224,78,17)'],
        [0.6588235294117647, 'rgb(225,80,16)'],
        [0.6627450980392157, 'rgb(225,81,15)'],
        [0.6666666666666666, 'rgb(226,83,14)'],
        [0.6705882352941176, 'rgb(226,85,13)'],
        [0.6745098039215687, 'rgb(227,87,12)'],
        [0.6784313725490196, 'rgb(228,88,12)'],
        [0.6823529411764706, 'rgb(228,90,11)'],
        [0.6862745098039216, 'rgb(229,92,10)'],
        [0.6901960784313725, 'rgb(229,93,9)'],
        [0.6941176470588235, 'rgb(230,95,8)'],
        [0.6980392156862745, 'rgb(230,97,7)'],
        [0.7019607843137254, 'rgb(231,98,7)'],
        [0.7058823529411765, 'rgb(231,100,6)'],
        [0.7098039215686275, 'rgb(232,102,5)'],
        [0.7137254901960784, 'rgb(232,103,5)'],
        [0.7176470588235294, 'rgb(233,105,4)'],
        [0.7215686274509804, 'rgb(233,107,4)'],
        [0.7254901960784313, 'rgb(234,108,3)'],
        [0.7294117647058823, 'rgb(234,110,3)'],
        [0.7333333333333333, 'rgb(234,111,2)'],
        [0.7372549019607844, 'rgb(235,113,2)'],
        [0.7411764705882353, 'rgb(235,115,2)'],
        [0.7450980392156863, 'rgb(236,116,2)'],
        [0.7490196078431373, 'rgb(236,118,1)'],
        [0.7529411764705882, 'rgb(236,120,1)'],
        [0.7568627450980392, 'rgb(237,121,1)'],
        [0.7607843137254902, 'rgb(237,123,1)'],
        [0.7647058823529411, 'rgb(237,125,1)'],
        [0.7686274509803922, 'rgb(238,126,1)'],
        [0.7725490196078432, 'rgb(238,128,1)'],
        [0.7764705882352941, 'rgb(238,129,1)'],
        [0.7803921568627451, 'rgb(239,131,1)'],
        [0.7843137254901961, 'rgb(239,133,2)'],
        [0.788235294117647, 'rgb(239,134,2)'],
        [0.792156862745098, 'rgb(240,136,2)'],
        [0.796078431372549, 'rgb(240,138,3)'],
        [0.8, 'rgb(240,139,3)'],
        [0.803921568627451, 'rgb(240,141,4)'],
        [0.807843137254902, 'rgb(241,143,5)'],
        [0.8117647058823529, 'rgb(241,144,5)'],
        [0.8156862745098039, 'rgb(241,146,6)'],
        [0.8196078431372549, 'rgb(241,147,7)'],
        [0.8235294117647058, 'rgb(242,149,8)'],
        [0.8274509803921568, 'rgb(242,151,9)'],
        [0.8313725490196079, 'rgb(242,152,10)'],
        [0.8352941176470589, 'rgb(242,154,11)'],
        [0.8392156862745098, 'rgb(242,156,12)'],
        [0.8431372549019608, 'rgb(243,157,13)'],
        [0.8470588235294118, 'rgb(243,159,14)'],
        [0.8509803921568627, 'rgb(243,161,15)'],
        [0.8549019607843137, 'rgb(243,162,17)'],
        [0.8588235294117647, 'rgb(243,164,18)'],
        [0.8627450980392157, 'rgb(243,166,19)'],
        [0.8666666666666667, 'rgb(243,167,20)'],
        [0.8705882352941177, 'rgb(243,169,21)'],
        [0.8745098039215686, 'rgb(243,171,22)'],
        [0.8784313725490196, 'rgb(244,172,23)'],
        [0.8823529411764706, 'rgb(244,174,25)'],
        [0.8862745098039215, 'rgb(244,175,26)'],
        [0.8901960784313725, 'rgb(244,177,27)'],
        [0.8941176470588236, 'rgb(244,179,28)'],
        [0.8980392156862745, 'rgb(244,180,29)'],
        [0.9019607843137255, 'rgb(244,182,31)'],
        [0.9058823529411765, 'rgb(244,184,32)'],
        [0.9098039215686274, 'rgb(244,185,33)'],
        [0.9137254901960784, 'rgb(244,187,34)'],
        [0.9176470588235294, 'rgb(244,189,35)'],
        [0.9215686274509803, 'rgb(244,191,37)'],
        [0.9254901960784314, 'rgb(244,192,38)'],
        [0.9294117647058824, 'rgb(244,194,39)'],
        [0.9333333333333333, 'rgb(244,196,40)'],
        [0.9372549019607843, 'rgb(243,197,41)'],
        [0.9411764705882353, 'rgb(243,199,43)'],
        [0.9450980392156862, 'rgb(243,201,44)'],
        [0.9490196078431372, 'rgb(243,202,45)'],
        [0.9529411764705882, 'rgb(243,204,46)'],
        [0.9568627450980393, 'rgb(243,206,48)'],
        [0.9607843137254902, 'rgb(243,207,49)'],
        [0.9647058823529412, 'rgb(243,209,50)'],
        [0.9686274509803922, 'rgb(242,211,51)'],
        [0.9725490196078431, 'rgb(242,213,53)'],
        [0.9764705882352941, 'rgb(242,214,54)'],
        [0.9803921568627451, 'rgb(242,216,55)'],
        [0.984313725490196, 'rgb(242,218,57)'],
        [0.9882352941176471, 'rgb(241,219,58)'],
        [0.9921568627450981, 'rgb(241,221,59)'],
        [0.996078431372549, 'rgb(241,223,60)'],
        [1.0, 'rgb(241,225,62)'],
    ],
    'cmr.flamingo': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(2,1,1)'],
        [0.023529411764705882, 'rgb(2,1,1)'],
        [0.027450980392156862, 'rgb(3,2,1)'],
        [0.03137254901960784, 'rgb(4,2,2)'],
        [0.03529411764705882, 'rgb(5,2,2)'],
        [0.0392156862745098, 'rgb(6,3,2)'],
        [0.043137254901960784, 'rgb(8,3,3)'],
        [0.047058823529411764, 'rgb(9,4,3)'],
        [0.050980392156862744, 'rgb(11,4,4)'],
        [0.054901960784313725, 'rgb(13,5,4)'],
        [0.058823529411764705, 'rgb(14,6,5)'],
        [0.06274509803921569, 'rgb(16,6,5)'],
        [0.06666666666666667, 'rgb(17,7,6)'],
        [0.07058823529411765, 'rgb(19,8,6)'],
        [0.07450980392156863, 'rgb(21,8,7)'],
        [0.0784313725490196, 'rgb(22,9,7)'],
        [0.08235294117647059, 'rgb(24,10,8)'],
        [0.08627450980392157, 'rgb(25,11,9)'],
        [0.09019607843137255, 'rgb(27,11,9)'],
        [0.09411764705882353, 'rgb(28,12,10)'],
        [0.09803921568627451, 'rgb(30,13,10)'],
        [0.10196078431372549, 'rgb(32,13,11)'],
        [0.10588235294117647, 'rgb(33,14,12)'],
        [0.10980392156862745, 'rgb(35,15,12)'],
        [0.11372549019607843, 'rgb(36,15,13)'],
        [0.11764705882352941, 'rgb(38,16,13)'],
        [0.12156862745098039, 'rgb(39,17,14)'],
        [0.12549019607843137, 'rgb(41,17,14)'],
        [0.12941176470588237, 'rgb(42,18,15)'],
        [0.13333333333333333, 'rgb(44,19,15)'],
        [0.13725490196078433, 'rgb(46,19,16)'],
        [0.1411764705882353, 'rgb(47,20,16)'],
        [0.1450980392156863, 'rgb(49,20,17)'],
        [0.14901960784313725, 'rgb(50,21,17)'],
        [0.15294117647058825, 'rgb(52,21,18)'],
        [0.1568627450980392, 'rgb(54,22,18)'],
        [0.1607843137254902, 'rgb(55,22,19)'],
        [0.16470588235294117, 'rgb(57,23,19)'],
        [0.16862745098039217, 'rgb(58,23,20)'],
        [0.17254901960784313, 'rgb(60,24,20)'],
        [0.17647058823529413, 'rgb(61,24,21)'],
        [0.1803921568627451, 'rgb(63,25,21)'],
        [0.1843137254901961, 'rgb(65,25,21)'],
        [0.18823529411764706, 'rgb(66,26,22)'],
        [0.19215686274509805, 'rgb(68,26,22)'],
        [0.19607843137254902, 'rgb(69,27,23)'],
        [0.2, 'rgb(71,27,23)'],
        [0.20392156862745098, 'rgb(73,28,23)'],
        [0.20784313725490197, 'rgb(74,28,24)'],
        [0.21176470588235294, 'rgb(76,28,24)'],
        [0.21568627450980393, 'rgb(78,29,25)'],
        [0.2196078431372549, 'rgb(79,29,25)'],
        [0.2235294117647059, 'rgb(81,29,25)'],
        [0.22745098039215686, 'rgb(83,30,26)'],
        [0.23137254901960785, 'rgb(84,30,26)'],
        [0.23529411764705882, 'rgb(86,30,26)'],
        [0.23921568627450981, 'rgb(87,31,27)'],
        [0.24313725490196078, 'rgb(89,31,27)'],
        [0.24705882352941178, 'rgb(91,31,28)'],
        [0.25098039215686274, 'rgb(93,32,28)'],
        [0.2549019607843137, 'rgb(94,32,28)'],
        [0.25882352941176473, 'rgb(96,32,29)'],
        [0.2627450980392157, 'rgb(98,32,29)'],
        [0.26666666666666666, 'rgb(99,33,29)'],
        [0.27058823529411763, 'rgb(101,33,30)'],
        [0.27450980392156865, 'rgb(103,33,30)'],
        [0.2784313725490196, 'rgb(104,33,30)'],
        [0.2823529411764706, 'rgb(106,33,31)'],
        [0.28627450980392155, 'rgb(108,33,31)'],
        [0.2901960784313726, 'rgb(110,34,31)'],
        [0.29411764705882354, 'rgb(111,34,32)'],
        [0.2980392156862745, 'rgb(113,34,32)'],
        [0.30196078431372547, 'rgb(115,34,32)'],
        [0.3058823529411765, 'rgb(117,34,33)'],
        [0.30980392156862746, 'rgb(118,34,33)'],
        [0.3137254901960784, 'rgb(120,34,33)'],
        [0.3176470588235294, 'rgb(122,34,34)'],
        [0.3215686274509804, 'rgb(124,34,34)'],
        [0.3254901960784314, 'rgb(125,34,34)'],
        [0.32941176470588235, 'rgb(127,34,35)'],
        [0.3333333333333333, 'rgb(129,34,35)'],
        [0.33725490196078434, 'rgb(131,34,36)'],
        [0.3411764705882353, 'rgb(133,34,36)'],
        [0.34509803921568627, 'rgb(134,34,36)'],
        [0.34901960784313724, 'rgb(136,34,37)'],
        [0.35294117647058826, 'rgb(138,33,37)'],
        [0.3568627450980392, 'rgb(140,33,37)'],
        [0.3607843137254902, 'rgb(142,33,38)'],
        [0.36470588235294116, 'rgb(144,33,38)'],
        [0.3686274509803922, 'rgb(145,33,39)'],
        [0.37254901960784315, 'rgb(147,32,39)'],
        [0.3764705882352941, 'rgb(149,32,39)'],
        [0.3803921568627451, 'rgb(151,32,40)'],
        [0.3843137254901961, 'rgb(153,31,40)'],
        [0.38823529411764707, 'rgb(155,31,41)'],
        [0.39215686274509803, 'rgb(157,30,41)'],
        [0.396078431372549, 'rgb(159,30,42)'],
        [0.4, 'rgb(160,29,42)'],
        [0.403921568627451, 'rgb(162,29,43)'],
        [0.40784313725490196, 'rgb(164,28,44)'],
        [0.4117647058823529, 'rgb(166,27,44)'],
        [0.41568627450980394, 'rgb(168,27,45)'],
        [0.4196078431372549, 'rgb(170,26,46)'],
        [0.4235294117647059, 'rgb(172,25,46)'],
        [0.42745098039215684, 'rgb(174,24,47)'],
        [0.43137254901960786, 'rgb(176,23,48)'],
        [0.43529411764705883, 'rgb(178,22,49)'],
        [0.4392156862745098, 'rgb(180,21,50)'],
        [0.44313725490196076, 'rgb(181,20,51)'],
        [0.4470588235294118, 'rgb(183,19,52)'],
        [0.45098039215686275, 'rgb(185,18,53)'],
        [0.4549019607843137, 'rgb(187,17,55)'],
        [0.4588235294117647, 'rgb(189,16,56)'],
        [0.4627450980392157, 'rgb(190,16,58)'],
        [0.4666666666666667, 'rgb(192,16,60)'],
        [0.47058823529411764, 'rgb(193,16,62)'],
        [0.4745098039215686, 'rgb(195,17,64)'],
        [0.47843137254901963, 'rgb(196,19,66)'],
        [0.4823529411764706, 'rgb(197,21,68)'],
        [0.48627450980392156, 'rgb(198,23,70)'],
        [0.49019607843137253, 'rgb(199,25,72)'],
        [0.49411764705882355, 'rgb(200,28,75)'],
        [0.4980392156862745, 'rgb(201,30,77)'],
        [0.5019607843137255, 'rgb(201,33,79)'],
        [0.5058823529411764, 'rgb(202,35,81)'],
        [0.5098039215686274, 'rgb(203,38,83)'],
        [0.5137254901960784, 'rgb(204,40,85)'],
        [0.5176470588235295, 'rgb(204,42,87)'],
        [0.5215686274509804, 'rgb(205,45,89)'],
        [0.5254901960784314, 'rgb(206,47,91)'],
        [0.5294117647058824, 'rgb(206,49,93)'],
        [0.5333333333333333, 'rgb(207,52,95)'],
        [0.5372549019607843, 'rgb(207,54,97)'],
        [0.5411764705882353, 'rgb(208,56,99)'],
        [0.5450980392156862, 'rgb(208,58,101)'],
        [0.5490196078431373, 'rgb(209,60,103)'],
        [0.5529411764705883, 'rgb(209,62,105)'],
        [0.5568627450980392, 'rgb(210,64,106)'],
        [0.5607843137254902, 'rgb(210,66,108)'],
        [0.5647058823529412, 'rgb(211,68,110)'],
        [0.5686274509803921, 'rgb(211,70,112)'],
        [0.5725490196078431, 'rgb(212,72,114)'],
        [0.5764705882352941, 'rgb(212,74,116)'],
        [0.5803921568627451, 'rgb(213,76,117)'],
        [0.5843137254901961, 'rgb(213,78,119)'],
        [0.5882352941176471, 'rgb(213,80,121)'],
        [0.592156862745098, 'rgb(214,82,123)'],
        [0.596078431372549, 'rgb(214,84,124)'],
        [0.6, 'rgb(214,86,126)'],
        [0.6039215686274509, 'rgb(215,88,128)'],
        [0.6078431372549019, 'rgb(215,90,130)'],
        [0.611764705882353, 'rgb(216,92,131)'],
        [0.615686274509804, 'rgb(216,93,133)'],
        [0.6196078431372549, 'rgb(216,95,135)'],
        [0.6235294117647059, 'rgb(216,97,136)'],
        [0.6274509803921569, 'rgb(217,99,138)'],
        [0.6313725490196078, 'rgb(217,101,139)'],
        [0.6352941176470588, 'rgb(217,103,141)'],
        [0.6392156862745098, 'rgb(218,104,143)'],
        [0.6431372549019608, 'rgb(218,106,144)'],
        [0.6470588235294118, 'rgb(218,108,146)'],
        [0.6509803921568628, 'rgb(218,110,147)'],
        [0.6549019607843137, 'rgb(219,112,149)'],
        [0.6588235294117647, 'rgb(219,113,151)'],
        [0.6627450980392157, 'rgb(219,115,152)'],
        [0.6666666666666666, 'rgb(219,117,154)'],
        [0.6705882352941176, 'rgb(220,119,155)'],
        [0.6745098039215687, 'rgb(220,120,157)'],
        [0.6784313725490196, 'rgb(220,122,158)'],
        [0.6823529411764706, 'rgb(220,124,160)'],
        [0.6862745098039216, 'rgb(221,126,161)'],
        [0.6901960784313725, 'rgb(221,127,163)'],
        [0.6941176470588235, 'rgb(221,129,164)'],
        [0.6980392156862745, 'rgb(221,131,165)'],
        [0.7019607843137254, 'rgb(221,132,167)'],
        [0.7058823529411765, 'rgb(222,134,168)'],
        [0.7098039215686275, 'rgb(222,136,170)'],
        [0.7137254901960784, 'rgb(222,138,171)'],
        [0.7176470588235294, 'rgb(222,139,173)'],
        [0.7215686274509804, 'rgb(222,141,174)'],
        [0.7254901960784313, 'rgb(223,143,175)'],
        [0.7294117647058823, 'rgb(223,144,177)'],
        [0.7333333333333333, 'rgb(223,146,178)'],
        [0.7372549019607844, 'rgb(223,148,179)'],
        [0.7411764705882353, 'rgb(223,149,181)'],
        [0.7450980392156863, 'rgb(224,151,182)'],
        [0.7490196078431373, 'rgb(224,153,184)'],
        [0.7529411764705882, 'rgb(224,154,185)'],
        [0.7568627450980392, 'rgb(224,156,186)'],
        [0.7607843137254902, 'rgb(224,158,187)'],
        [0.7647058823529411, 'rgb(225,159,189)'],
        [0.7686274509803922, 'rgb(225,161,190)'],
        [0.7725490196078432, 'rgb(225,163,191)'],
        [0.7764705882352941, 'rgb(225,164,193)'],
        [0.7803921568627451, 'rgb(225,166,194)'],
        [0.7843137254901961, 'rgb(226,168,195)'],
        [0.788235294117647, 'rgb(226,169,196)'],
        [0.792156862745098, 'rgb(226,171,198)'],
        [0.796078431372549, 'rgb(226,173,199)'],
        [0.8, 'rgb(227,174,200)'],
        [0.803921568627451, 'rgb(227,176,201)'],
        [0.807843137254902, 'rgb(227,177,203)'],
        [0.8117647058823529, 'rgb(227,179,204)'],
        [0.8156862745098039, 'rgb(228,181,205)'],
        [0.8196078431372549, 'rgb(228,182,206)'],
        [0.8235294117647058, 'rgb(228,184,207)'],
        [0.8274509803921568, 'rgb(228,186,208)'],
        [0.8313725490196079, 'rgb(229,187,210)'],
        [0.8352941176470589, 'rgb(229,189,211)'],
        [0.8392156862745098, 'rgb(229,191,212)'],
        [0.8431372549019608, 'rgb(230,192,213)'],
        [0.8470588235294118, 'rgb(230,194,214)'],
        [0.8509803921568627, 'rgb(230,195,215)'],
        [0.8549019607843137, 'rgb(231,197,216)'],
        [0.8588235294117647, 'rgb(231,199,218)'],
        [0.8627450980392157, 'rgb(231,200,219)'],
        [0.8666666666666667, 'rgb(232,202,220)'],
        [0.8705882352941177, 'rgb(232,203,221)'],
        [0.8745098039215686, 'rgb(232,205,222)'],
        [0.8784313725490196, 'rgb(233,207,223)'],
        [0.8823529411764706, 'rgb(233,208,224)'],
        [0.8862745098039215, 'rgb(234,210,225)'],
        [0.8901960784313725, 'rgb(234,211,226)'],
        [0.8941176470588236, 'rgb(235,213,227)'],
        [0.8980392156862745, 'rgb(235,215,228)'],
        [0.9019607843137255, 'rgb(236,216,229)'],
        [0.9058823529411765, 'rgb(236,218,230)'],
        [0.9098039215686274, 'rgb(237,219,231)'],
        [0.9137254901960784, 'rgb(237,221,232)'],
        [0.9176470588235294, 'rgb(238,223,233)'],
        [0.9215686274509803, 'rgb(238,224,235)'],
        [0.9254901960784314, 'rgb(239,226,236)'],
        [0.9294117647058824, 'rgb(240,227,237)'],
        [0.9333333333333333, 'rgb(240,229,238)'],
        [0.9372549019607843, 'rgb(241,230,238)'],
        [0.9411764705882353, 'rgb(242,232,239)'],
        [0.9450980392156862, 'rgb(242,234,240)'],
        [0.9490196078431372, 'rgb(243,235,241)'],
        [0.9529411764705882, 'rgb(244,237,242)'],
        [0.9568627450980393, 'rgb(245,238,243)'],
        [0.9607843137254902, 'rgb(245,240,244)'],
        [0.9647058823529412, 'rgb(246,241,245)'],
        [0.9686274509803922, 'rgb(247,243,246)'],
        [0.9725490196078431, 'rgb(248,244,247)'],
        [0.9764705882352941, 'rgb(249,246,248)'],
        [0.9803921568627451, 'rgb(250,247,249)'],
        [0.984313725490196, 'rgb(251,249,251)'],
        [0.9882352941176471, 'rgb(252,250,252)'],
        [0.9921568627450981, 'rgb(253,252,253)'],
        [0.996078431372549, 'rgb(254,253,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.freeze': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,2)'],
        [0.023529411764705882, 'rgb(2,1,2)'],
        [0.027450980392156862, 'rgb(2,2,3)'],
        [0.03137254901960784, 'rgb(3,2,4)'],
        [0.03529411764705882, 'rgb(3,3,5)'],
        [0.0392156862745098, 'rgb(4,3,6)'],
        [0.043137254901960784, 'rgb(5,4,7)'],
        [0.047058823529411764, 'rgb(6,5,9)'],
        [0.050980392156862744, 'rgb(7,5,10)'],
        [0.054901960784313725, 'rgb(8,6,12)'],
        [0.058823529411764705, 'rgb(9,7,13)'],
        [0.06274509803921569, 'rgb(10,8,15)'],
        [0.06666666666666667, 'rgb(11,9,17)'],
        [0.07058823529411765, 'rgb(12,10,18)'],
        [0.07450980392156863, 'rgb(13,11,20)'],
        [0.0784313725490196, 'rgb(15,12,22)'],
        [0.08235294117647059, 'rgb(16,13,23)'],
        [0.08627450980392157, 'rgb(17,13,25)'],
        [0.09019607843137255, 'rgb(18,14,27)'],
        [0.09411764705882353, 'rgb(19,15,28)'],
        [0.09803921568627451, 'rgb(20,16,30)'],
        [0.10196078431372549, 'rgb(21,17,31)'],
        [0.10588235294117647, 'rgb(22,18,33)'],
        [0.10980392156862745, 'rgb(23,19,35)'],
        [0.11372549019607843, 'rgb(24,20,37)'],
        [0.11764705882352941, 'rgb(25,21,38)'],
        [0.12156862745098039, 'rgb(26,21,40)'],
        [0.12549019607843137, 'rgb(27,22,42)'],
        [0.12941176470588237, 'rgb(28,23,43)'],
        [0.13333333333333333, 'rgb(29,24,45)'],
        [0.13725490196078433, 'rgb(30,25,47)'],
        [0.1411764705882353, 'rgb(31,26,49)'],
        [0.1450980392156863, 'rgb(32,26,51)'],
        [0.14901960784313725, 'rgb(33,27,52)'],
        [0.15294117647058825, 'rgb(34,28,54)'],
        [0.1568627450980392, 'rgb(35,29,56)'],
        [0.1607843137254902, 'rgb(36,30,58)'],
        [0.16470588235294117, 'rgb(37,30,60)'],
        [0.16862745098039217, 'rgb(38,31,62)'],
        [0.17254901960784313, 'rgb(39,32,63)'],
        [0.17647058823529413, 'rgb(40,33,65)'],
        [0.1803921568627451, 'rgb(41,33,67)'],
        [0.1843137254901961, 'rgb(41,34,69)'],
        [0.18823529411764706, 'rgb(42,35,71)'],
        [0.19215686274509805, 'rgb(43,36,73)'],
        [0.19607843137254902, 'rgb(44,36,75)'],
        [0.2, 'rgb(45,37,77)'],
        [0.20392156862745098, 'rgb(46,38,79)'],
        [0.20784313725490197, 'rgb(47,39,81)'],
        [0.21176470588235294, 'rgb(48,39,83)'],
        [0.21568627450980393, 'rgb(48,40,85)'],
        [0.2196078431372549, 'rgb(49,41,87)'],
        [0.2235294117647059, 'rgb(50,41,90)'],
        [0.22745098039215686, 'rgb(51,42,92)'],
        [0.23137254901960785, 'rgb(52,43,94)'],
        [0.23529411764705882, 'rgb(53,44,96)'],
        [0.23921568627450981, 'rgb(53,44,98)'],
        [0.24313725490196078, 'rgb(54,45,100)'],
        [0.24705882352941178, 'rgb(55,46,103)'],
        [0.25098039215686274, 'rgb(56,46,105)'],
        [0.2549019607843137, 'rgb(56,47,107)'],
        [0.25882352941176473, 'rgb(57,48,109)'],
        [0.2627450980392157, 'rgb(58,48,112)'],
        [0.26666666666666666, 'rgb(59,49,114)'],
        [0.27058823529411763, 'rgb(59,50,116)'],
        [0.27450980392156865, 'rgb(60,50,119)'],
        [0.2784313725490196, 'rgb(61,51,121)'],
        [0.2823529411764706, 'rgb(61,52,124)'],
        [0.28627450980392155, 'rgb(62,52,126)'],
        [0.2901960784313726, 'rgb(63,53,128)'],
        [0.29411764705882354, 'rgb(63,54,131)'],
        [0.2980392156862745, 'rgb(64,55,133)'],
        [0.30196078431372547, 'rgb(65,55,136)'],
        [0.3058823529411765, 'rgb(65,56,138)'],
        [0.30980392156862746, 'rgb(66,57,141)'],
        [0.3137254901960784, 'rgb(66,57,143)'],
        [0.3176470588235294, 'rgb(67,58,146)'],
        [0.3215686274509804, 'rgb(67,59,149)'],
        [0.3254901960784314, 'rgb(68,59,151)'],
        [0.32941176470588235, 'rgb(68,60,154)'],
        [0.3333333333333333, 'rgb(69,61,156)'],
        [0.33725490196078434, 'rgb(69,62,159)'],
        [0.3411764705882353, 'rgb(69,62,162)'],
        [0.34509803921568627, 'rgb(70,63,164)'],
        [0.34901960784313724, 'rgb(70,64,167)'],
        [0.35294117647058826, 'rgb(70,65,170)'],
        [0.3568627450980392, 'rgb(70,65,172)'],
        [0.3607843137254902, 'rgb(70,66,175)'],
        [0.36470588235294116, 'rgb(71,67,177)'],
        [0.3686274509803922, 'rgb(71,68,180)'],
        [0.37254901960784315, 'rgb(71,69,183)'],
        [0.3764705882352941, 'rgb(71,70,185)'],
        [0.3803921568627451, 'rgb(70,71,188)'],
        [0.3843137254901961, 'rgb(70,72,190)'],
        [0.38823529411764707, 'rgb(70,73,192)'],
        [0.39215686274509803, 'rgb(70,74,195)'],
        [0.396078431372549, 'rgb(69,75,197)'],
        [0.4, 'rgb(69,76,199)'],
        [0.403921568627451, 'rgb(68,77,202)'],
        [0.40784313725490196, 'rgb(68,78,204)'],
        [0.4117647058823529, 'rgb(67,79,206)'],
        [0.41568627450980394, 'rgb(66,81,208)'],
        [0.4196078431372549, 'rgb(65,82,209)'],
        [0.4235294117647059, 'rgb(65,83,211)'],
        [0.42745098039215684, 'rgb(64,85,213)'],
        [0.43137254901960786, 'rgb(63,86,214)'],
        [0.43529411764705883, 'rgb(61,88,215)'],
        [0.4392156862745098, 'rgb(60,89,217)'],
        [0.44313725490196076, 'rgb(59,91,218)'],
        [0.4470588235294118, 'rgb(58,92,219)'],
        [0.45098039215686275, 'rgb(56,94,220)'],
        [0.4549019607843137, 'rgb(55,95,220)'],
        [0.4588235294117647, 'rgb(53,97,221)'],
        [0.4627450980392157, 'rgb(52,99,222)'],
        [0.4666666666666667, 'rgb(51,100,222)'],
        [0.47058823529411764, 'rgb(49,102,223)'],
        [0.4745098039215686, 'rgb(48,103,223)'],
        [0.47843137254901963, 'rgb(46,105,223)'],
        [0.4823529411764706, 'rgb(44,107,224)'],
        [0.48627450980392156, 'rgb(43,108,224)'],
        [0.49019607843137253, 'rgb(41,110,224)'],
        [0.49411764705882355, 'rgb(40,111,224)'],
        [0.4980392156862745, 'rgb(39,113,224)'],
        [0.5019607843137255, 'rgb(37,114,224)'],
        [0.5058823529411764, 'rgb(36,116,224)'],
        [0.5098039215686274, 'rgb(34,117,224)'],
        [0.5137254901960784, 'rgb(33,119,224)'],
        [0.5176470588235295, 'rgb(32,120,224)'],
        [0.5215686274509804, 'rgb(31,122,224)'],
        [0.5254901960784314, 'rgb(30,123,224)'],
        [0.5294117647058824, 'rgb(29,125,223)'],
        [0.5333333333333333, 'rgb(28,126,223)'],
        [0.5372549019607843, 'rgb(27,128,223)'],
        [0.5411764705882353, 'rgb(26,129,223)'],
        [0.5450980392156862, 'rgb(26,130,223)'],
        [0.5490196078431373, 'rgb(25,132,222)'],
        [0.5529411764705883, 'rgb(25,133,222)'],
        [0.5568627450980392, 'rgb(25,135,222)'],
        [0.5607843137254902, 'rgb(25,136,222)'],
        [0.5647058823529412, 'rgb(26,137,221)'],
        [0.5686274509803921, 'rgb(26,139,221)'],
        [0.5725490196078431, 'rgb(27,140,221)'],
        [0.5764705882352941, 'rgb(27,141,221)'],
        [0.5803921568627451, 'rgb(28,143,220)'],
        [0.5843137254901961, 'rgb(29,144,220)'],
        [0.5882352941176471, 'rgb(30,145,220)'],
        [0.592156862745098, 'rgb(31,147,220)'],
        [0.596078431372549, 'rgb(33,148,219)'],
        [0.6, 'rgb(34,149,219)'],
        [0.6039215686274509, 'rgb(35,150,219)'],
        [0.6078431372549019, 'rgb(37,152,219)'],
        [0.611764705882353, 'rgb(38,153,218)'],
        [0.615686274509804, 'rgb(40,154,218)'],
        [0.6196078431372549, 'rgb(42,155,218)'],
        [0.6235294117647059, 'rgb(43,157,218)'],
        [0.6274509803921569, 'rgb(45,158,217)'],
        [0.6313725490196078, 'rgb(47,159,217)'],
        [0.6352941176470588, 'rgb(49,160,217)'],
        [0.6392156862745098, 'rgb(50,161,217)'],
        [0.6431372549019608, 'rgb(52,163,217)'],
        [0.6470588235294118, 'rgb(54,164,216)'],
        [0.6509803921568628, 'rgb(56,165,216)'],
        [0.6549019607843137, 'rgb(58,166,216)'],
        [0.6588235294117647, 'rgb(60,167,216)'],
        [0.6627450980392157, 'rgb(62,168,216)'],
        [0.6666666666666666, 'rgb(64,170,216)'],
        [0.6705882352941176, 'rgb(66,171,215)'],
        [0.6745098039215687, 'rgb(68,172,215)'],
        [0.6784313725490196, 'rgb(70,173,215)'],
        [0.6823529411764706, 'rgb(72,174,215)'],
        [0.6862745098039216, 'rgb(74,175,215)'],
        [0.6901960784313725, 'rgb(76,176,215)'],
        [0.6941176470588235, 'rgb(78,178,215)'],
        [0.6980392156862745, 'rgb(80,179,215)'],
        [0.7019607843137254, 'rgb(82,180,214)'],
        [0.7058823529411765, 'rgb(84,181,214)'],
        [0.7098039215686275, 'rgb(86,182,214)'],
        [0.7137254901960784, 'rgb(88,183,214)'],
        [0.7176470588235294, 'rgb(91,184,214)'],
        [0.7215686274509804, 'rgb(93,185,214)'],
        [0.7254901960784313, 'rgb(95,186,214)'],
        [0.7294117647058823, 'rgb(97,187,214)'],
        [0.7333333333333333, 'rgb(99,188,214)'],
        [0.7372549019607844, 'rgb(101,189,214)'],
        [0.7411764705882353, 'rgb(104,190,214)'],
        [0.7450980392156863, 'rgb(106,192,214)'],
        [0.7490196078431373, 'rgb(108,193,214)'],
        [0.7529411764705882, 'rgb(111,194,214)'],
        [0.7568627450980392, 'rgb(113,195,214)'],
        [0.7607843137254902, 'rgb(115,196,214)'],
        [0.7647058823529411, 'rgb(117,197,214)'],
        [0.7686274509803922, 'rgb(120,198,214)'],
        [0.7725490196078432, 'rgb(122,199,214)'],
        [0.7764705882352941, 'rgb(125,200,214)'],
        [0.7803921568627451, 'rgb(127,201,214)'],
        [0.7843137254901961, 'rgb(129,202,215)'],
        [0.788235294117647, 'rgb(132,203,215)'],
        [0.792156862745098, 'rgb(134,203,215)'],
        [0.796078431372549, 'rgb(137,204,215)'],
        [0.8, 'rgb(139,205,215)'],
        [0.803921568627451, 'rgb(141,206,216)'],
        [0.807843137254902, 'rgb(144,207,216)'],
        [0.8117647058823529, 'rgb(146,208,216)'],
        [0.8156862745098039, 'rgb(149,209,216)'],
        [0.8196078431372549, 'rgb(151,210,217)'],
        [0.8235294117647058, 'rgb(154,211,217)'],
        [0.8274509803921568, 'rgb(156,212,218)'],
        [0.8313725490196079, 'rgb(159,213,218)'],
        [0.8352941176470589, 'rgb(161,214,218)'],
        [0.8392156862745098, 'rgb(163,215,219)'],
        [0.8431372549019608, 'rgb(166,216,219)'],
        [0.8470588235294118, 'rgb(168,216,220)'],
        [0.8509803921568627, 'rgb(171,217,220)'],
        [0.8549019607843137, 'rgb(173,218,221)'],
        [0.8588235294117647, 'rgb(175,219,222)'],
        [0.8627450980392157, 'rgb(178,220,222)'],
        [0.8666666666666667, 'rgb(180,221,223)'],
        [0.8705882352941177, 'rgb(183,222,223)'],
        [0.8745098039215686, 'rgb(185,223,224)'],
        [0.8784313725490196, 'rgb(187,224,225)'],
        [0.8823529411764706, 'rgb(190,225,226)'],
        [0.8862745098039215, 'rgb(192,226,226)'],
        [0.8901960784313725, 'rgb(194,227,227)'],
        [0.8941176470588236, 'rgb(197,227,228)'],
        [0.8980392156862745, 'rgb(199,228,229)'],
        [0.9019607843137255, 'rgb(201,229,230)'],
        [0.9058823529411765, 'rgb(203,230,230)'],
        [0.9098039215686274, 'rgb(206,231,231)'],
        [0.9137254901960784, 'rgb(208,232,232)'],
        [0.9176470588235294, 'rgb(210,233,233)'],
        [0.9215686274509803, 'rgb(212,234,234)'],
        [0.9254901960784314, 'rgb(215,235,235)'],
        [0.9294117647058824, 'rgb(217,236,236)'],
        [0.9333333333333333, 'rgb(219,237,237)'],
        [0.9372549019607843, 'rgb(221,238,238)'],
        [0.9411764705882353, 'rgb(223,239,239)'],
        [0.9450980392156862, 'rgb(226,240,240)'],
        [0.9490196078431372, 'rgb(228,241,241)'],
        [0.9529411764705882, 'rgb(230,242,242)'],
        [0.9568627450980393, 'rgb(232,243,243)'],
        [0.9607843137254902, 'rgb(234,244,244)'],
        [0.9647058823529412, 'rgb(236,245,245)'],
        [0.9686274509803922, 'rgb(238,246,246)'],
        [0.9725490196078431, 'rgb(241,247,247)'],
        [0.9764705882352941, 'rgb(243,248,248)'],
        [0.9803921568627451, 'rgb(245,249,249)'],
        [0.984313725490196, 'rgb(247,251,250)'],
        [0.9882352941176471, 'rgb(249,252,252)'],
        [0.9921568627450981, 'rgb(251,253,253)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.fusion': [
        [0.0, 'rgb(39,4,18)'],
        [0.00392156862745098, 'rgb(42,5,20)'],
        [0.00784313725490196, 'rgb(45,5,22)'],
        [0.011764705882352941, 'rgb(47,6,25)'],
        [0.01568627450980392, 'rgb(50,6,27)'],
        [0.0196078431372549, 'rgb(53,6,29)'],
        [0.023529411764705882, 'rgb(56,7,31)'],
        [0.027450980392156862, 'rgb(59,7,33)'],
        [0.03137254901960784, 'rgb(62,7,35)'],
        [0.03529411764705882, 'rgb(65,7,37)'],
        [0.0392156862745098, 'rgb(68,7,39)'],
        [0.043137254901960784, 'rgb(71,7,41)'],
        [0.047058823529411764, 'rgb(74,7,42)'],
        [0.050980392156862744, 'rgb(77,7,44)'],
        [0.054901960784313725, 'rgb(80,6,45)'],
        [0.058823529411764705, 'rgb(83,6,47)'],
        [0.06274509803921569, 'rgb(87,6,48)'],
        [0.06666666666666667, 'rgb(90,5,49)'],
        [0.07058823529411765, 'rgb(93,5,50)'],
        [0.07450980392156863, 'rgb(96,5,50)'],
        [0.0784313725490196, 'rgb(99,5,51)'],
        [0.08235294117647059, 'rgb(102,4,51)'],
        [0.08627450980392157, 'rgb(105,4,51)'],
        [0.09019607843137255, 'rgb(108,5,52)'],
        [0.09411764705882353, 'rgb(111,5,52)'],
        [0.09803921568627451, 'rgb(114,6,51)'],
        [0.10196078431372549, 'rgb(116,7,51)'],
        [0.10588235294117647, 'rgb(119,8,51)'],
        [0.10980392156862745, 'rgb(122,9,51)'],
        [0.11372549019607843, 'rgb(124,11,50)'],
        [0.11764705882352941, 'rgb(127,12,50)'],
        [0.12156862745098039, 'rgb(130,14,49)'],
        [0.12549019607843137, 'rgb(132,16,49)'],
        [0.12941176470588237, 'rgb(135,18,48)'],
        [0.13333333333333333, 'rgb(137,20,48)'],
        [0.13725490196078433, 'rgb(140,22,47)'],
        [0.1411764705882353, 'rgb(142,24,46)'],
        [0.1450980392156863, 'rgb(144,26,46)'],
        [0.14901960784313725, 'rgb(146,29,45)'],
        [0.15294117647058825, 'rgb(149,31,45)'],
        [0.1568627450980392, 'rgb(151,33,44)'],
        [0.1607843137254902, 'rgb(153,35,43)'],
        [0.16470588235294117, 'rgb(155,37,42)'],
        [0.16862745098039217, 'rgb(157,40,42)'],
        [0.17254901960784313, 'rgb(159,42,41)'],
        [0.17647058823529413, 'rgb(161,44,40)'],
        [0.1803921568627451, 'rgb(163,46,40)'],
        [0.1843137254901961, 'rgb(165,49,39)'],
        [0.18823529411764706, 'rgb(167,51,38)'],
        [0.19215686274509805, 'rgb(169,53,38)'],
        [0.19607843137254902, 'rgb(171,56,37)'],
        [0.2, 'rgb(173,58,36)'],
        [0.20392156862745098, 'rgb(175,60,36)'],
        [0.20784313725490197, 'rgb(176,63,35)'],
        [0.21176470588235294, 'rgb(178,65,34)'],
        [0.21568627450980393, 'rgb(180,68,34)'],
        [0.2196078431372549, 'rgb(181,70,33)'],
        [0.2235294117647059, 'rgb(183,73,33)'],
        [0.22745098039215686, 'rgb(184,75,33)'],
        [0.23137254901960785, 'rgb(186,78,32)'],
        [0.23529411764705882, 'rgb(187,80,32)'],
        [0.23921568627450981, 'rgb(189,83,32)'],
        [0.24313725490196078, 'rgb(190,86,32)'],
        [0.24705882352941178, 'rgb(191,88,32)'],
        [0.25098039215686274, 'rgb(193,91,32)'],
        [0.2549019607843137, 'rgb(194,93,32)'],
        [0.25882352941176473, 'rgb(195,96,33)'],
        [0.2627450980392157, 'rgb(196,99,34)'],
        [0.26666666666666666, 'rgb(197,102,34)'],
        [0.27058823529411763, 'rgb(198,104,35)'],
        [0.27450980392156865, 'rgb(199,107,36)'],
        [0.2784313725490196, 'rgb(200,110,38)'],
        [0.2823529411764706, 'rgb(200,113,39)'],
        [0.28627450980392155, 'rgb(201,116,41)'],
        [0.2901960784313726, 'rgb(202,118,43)'],
        [0.29411764705882354, 'rgb(203,121,45)'],
        [0.2980392156862745, 'rgb(203,124,47)'],
        [0.30196078431372547, 'rgb(204,127,50)'],
        [0.3058823529411765, 'rgb(204,130,52)'],
        [0.30980392156862746, 'rgb(205,133,55)'],
        [0.3137254901960784, 'rgb(205,135,58)'],
        [0.3176470588235294, 'rgb(206,138,61)'],
        [0.3215686274509804, 'rgb(206,141,64)'],
        [0.3254901960784314, 'rgb(206,144,67)'],
        [0.32941176470588235, 'rgb(207,147,71)'],
        [0.3333333333333333, 'rgb(207,150,74)'],
        [0.33725490196078434, 'rgb(207,152,78)'],
        [0.3411764705882353, 'rgb(208,155,82)'],
        [0.34509803921568627, 'rgb(208,158,86)'],
        [0.34901960784313724, 'rgb(208,161,90)'],
        [0.35294117647058826, 'rgb(209,163,94)'],
        [0.3568627450980392, 'rgb(209,166,98)'],
        [0.3607843137254902, 'rgb(210,169,102)'],
        [0.36470588235294116, 'rgb(210,171,106)'],
        [0.3686274509803922, 'rgb(211,174,111)'],
        [0.37254901960784315, 'rgb(211,177,115)'],
        [0.3764705882352941, 'rgb(212,179,119)'],
        [0.3803921568627451, 'rgb(212,182,124)'],
        [0.3843137254901961, 'rgb(213,184,128)'],
        [0.38823529411764707, 'rgb(213,187,132)'],
        [0.39215686274509803, 'rgb(214,189,137)'],
        [0.396078431372549, 'rgb(215,192,141)'],
        [0.4, 'rgb(216,194,146)'],
        [0.403921568627451, 'rgb(216,197,150)'],
        [0.40784313725490196, 'rgb(217,199,155)'],
        [0.4117647058823529, 'rgb(218,202,159)'],
        [0.41568627450980394, 'rgb(219,204,164)'],
        [0.4196078431372549, 'rgb(220,207,168)'],
        [0.4235294117647059, 'rgb(221,209,173)'],
        [0.42745098039215684, 'rgb(222,212,177)'],
        [0.43137254901960786, 'rgb(224,214,182)'],
        [0.43529411764705883, 'rgb(225,216,186)'],
        [0.4392156862745098, 'rgb(226,219,191)'],
        [0.44313725490196076, 'rgb(227,221,195)'],
        [0.4470588235294118, 'rgb(229,223,200)'],
        [0.45098039215686275, 'rgb(230,226,204)'],
        [0.4549019607843137, 'rgb(232,228,209)'],
        [0.4588235294117647, 'rgb(233,230,213)'],
        [0.4627450980392157, 'rgb(235,233,217)'],
        [0.4666666666666667, 'rgb(237,235,222)'],
        [0.47058823529411764, 'rgb(239,238,226)'],
        [0.4745098039215686, 'rgb(241,240,230)'],
        [0.47843137254901963, 'rgb(243,242,235)'],
        [0.4823529411764706, 'rgb(245,244,239)'],
        [0.48627450980392156, 'rgb(247,247,243)'],
        [0.49019607843137253, 'rgb(249,249,246)'],
        [0.49411764705882355, 'rgb(252,251,250)'],
        [0.4980392156862745, 'rgb(254,254,253)'],
        [0.5019607843137255, 'rgb(253,254,254)'],
        [0.5058823529411764, 'rgb(250,252,252)'],
        [0.5098039215686274, 'rgb(246,250,250)'],
        [0.5137254901960784, 'rgb(242,248,248)'],
        [0.5176470588235295, 'rgb(238,246,247)'],
        [0.5215686274509804, 'rgb(235,244,245)'],
        [0.5254901960784314, 'rgb(231,242,243)'],
        [0.5294117647058824, 'rgb(227,240,241)'],
        [0.5333333333333333, 'rgb(223,239,240)'],
        [0.5372549019607843, 'rgb(219,237,238)'],
        [0.5411764705882353, 'rgb(215,235,237)'],
        [0.5450980392156862, 'rgb(212,233,235)'],
        [0.5490196078431373, 'rgb(208,231,234)'],
        [0.5529411764705883, 'rgb(204,229,233)'],
        [0.5568627450980392, 'rgb(200,228,231)'],
        [0.5607843137254902, 'rgb(196,226,230)'],
        [0.5647058823529412, 'rgb(192,224,229)'],
        [0.5686274509803921, 'rgb(188,222,228)'],
        [0.5725490196078431, 'rgb(184,221,227)'],
        [0.5764705882352941, 'rgb(179,219,226)'],
        [0.5803921568627451, 'rgb(175,217,225)'],
        [0.5843137254901961, 'rgb(171,216,224)'],
        [0.5882352941176471, 'rgb(167,214,224)'],
        [0.592156862745098, 'rgb(163,212,223)'],
        [0.596078431372549, 'rgb(159,211,222)'],
        [0.6, 'rgb(155,209,222)'],
        [0.6039215686274509, 'rgb(150,207,221)'],
        [0.6078431372549019, 'rgb(146,205,221)'],
        [0.611764705882353, 'rgb(142,204,220)'],
        [0.615686274509804, 'rgb(138,202,220)'],
        [0.6196078431372549, 'rgb(134,200,220)'],
        [0.6235294117647059, 'rgb(129,198,220)'],
        [0.6274509803921569, 'rgb(125,197,220)'],
        [0.6313725490196078, 'rgb(121,195,220)'],
        [0.6352941176470588, 'rgb(117,193,220)'],
        [0.6392156862745098, 'rgb(113,191,220)'],
        [0.6431372549019608, 'rgb(110,189,220)'],
        [0.6470588235294118, 'rgb(106,187,220)'],
        [0.6509803921568628, 'rgb(102,185,220)'],
        [0.6549019607843137, 'rgb(99,183,220)'],
        [0.6588235294117647, 'rgb(96,181,220)'],
        [0.6627450980392157, 'rgb(93,179,221)'],
        [0.6666666666666666, 'rgb(90,177,221)'],
        [0.6705882352941176, 'rgb(87,175,221)'],
        [0.6745098039215687, 'rgb(84,173,221)'],
        [0.6784313725490196, 'rgb(82,171,221)'],
        [0.6823529411764706, 'rgb(80,168,221)'],
        [0.6862745098039216, 'rgb(78,166,221)'],
        [0.6901960784313725, 'rgb(76,164,222)'],
        [0.6941176470588235, 'rgb(75,162,222)'],
        [0.6980392156862745, 'rgb(73,159,222)'],
        [0.7019607843137254, 'rgb(72,157,222)'],
        [0.7058823529411765, 'rgb(71,155,222)'],
        [0.7098039215686275, 'rgb(71,152,222)'],
        [0.7137254901960784, 'rgb(70,150,222)'],
        [0.7176470588235294, 'rgb(70,147,222)'],
        [0.7215686274509804, 'rgb(69,145,222)'],
        [0.7254901960784313, 'rgb(69,143,221)'],
        [0.7294117647058823, 'rgb(70,140,221)'],
        [0.7333333333333333, 'rgb(70,138,221)'],
        [0.7372549019607844, 'rgb(70,135,221)'],
        [0.7411764705882353, 'rgb(71,133,221)'],
        [0.7450980392156863, 'rgb(71,130,220)'],
        [0.7490196078431373, 'rgb(72,127,220)'],
        [0.7529411764705882, 'rgb(72,125,220)'],
        [0.7568627450980392, 'rgb(73,122,219)'],
        [0.7607843137254902, 'rgb(74,119,219)'],
        [0.7647058823529411, 'rgb(75,117,219)'],
        [0.7686274509803922, 'rgb(76,114,218)'],
        [0.7725490196078432, 'rgb(76,111,218)'],
        [0.7764705882352941, 'rgb(77,109,217)'],
        [0.7803921568627451, 'rgb(78,106,217)'],
        [0.7843137254901961, 'rgb(79,103,216)'],
        [0.788235294117647, 'rgb(80,100,215)'],
        [0.792156862745098, 'rgb(81,97,215)'],
        [0.796078431372549, 'rgb(82,94,214)'],
        [0.8, 'rgb(83,91,213)'],
        [0.803921568627451, 'rgb(84,88,212)'],
        [0.807843137254902, 'rgb(85,85,211)'],
        [0.8117647058823529, 'rgb(86,82,211)'],
        [0.8156862745098039, 'rgb(86,79,210)'],
        [0.8196078431372549, 'rgb(87,76,208)'],
        [0.8235294117647058, 'rgb(88,73,207)'],
        [0.8274509803921568, 'rgb(89,70,206)'],
        [0.8313725490196079, 'rgb(89,66,205)'],
        [0.8352941176470589, 'rgb(90,63,203)'],
        [0.8392156862745098, 'rgb(91,60,202)'],
        [0.8431372549019608, 'rgb(91,56,200)'],
        [0.8470588235294118, 'rgb(91,53,198)'],
        [0.8509803921568627, 'rgb(92,49,196)'],
        [0.8549019607843137, 'rgb(92,46,194)'],
        [0.8588235294117647, 'rgb(92,42,192)'],
        [0.8627450980392157, 'rgb(92,38,190)'],
        [0.8666666666666667, 'rgb(92,35,187)'],
        [0.8705882352941177, 'rgb(92,31,184)'],
        [0.8745098039215686, 'rgb(92,27,181)'],
        [0.8784313725490196, 'rgb(91,24,178)'],
        [0.8823529411764706, 'rgb(91,21,174)'],
        [0.8862745098039215, 'rgb(90,18,170)'],
        [0.8901960784313725, 'rgb(89,15,166)'],
        [0.8941176470588236, 'rgb(88,13,161)'],
        [0.8980392156862745, 'rgb(87,12,157)'],
        [0.9019607843137255, 'rgb(85,11,152)'],
        [0.9058823529411765, 'rgb(83,11,147)'],
        [0.9098039215686274, 'rgb(82,12,142)'],
        [0.9137254901960784, 'rgb(79,13,137)'],
        [0.9176470588235294, 'rgb(77,13,132)'],
        [0.9215686274509803, 'rgb(75,14,127)'],
        [0.9254901960784314, 'rgb(73,15,122)'],
        [0.9294117647058824, 'rgb(70,16,118)'],
        [0.9333333333333333, 'rgb(68,16,113)'],
        [0.9372549019607843, 'rgb(65,17,108)'],
        [0.9411764705882353, 'rgb(63,17,104)'],
        [0.9450980392156862, 'rgb(60,17,100)'],
        [0.9490196078431372, 'rgb(58,17,96)'],
        [0.9529411764705882, 'rgb(55,17,92)'],
        [0.9568627450980393, 'rgb(53,17,88)'],
        [0.9607843137254902, 'rgb(50,17,84)'],
        [0.9647058823529412, 'rgb(47,16,80)'],
        [0.9686274509803922, 'rgb(45,16,77)'],
        [0.9725490196078431, 'rgb(42,15,73)'],
        [0.9764705882352941, 'rgb(40,15,69)'],
        [0.9803921568627451, 'rgb(37,14,66)'],
        [0.984313725490196, 'rgb(35,13,63)'],
        [0.9882352941176471, 'rgb(32,13,59)'],
        [0.9921568627450981, 'rgb(29,12,56)'],
        [0.996078431372549, 'rgb(27,11,53)'],
        [1.0, 'rgb(24,10,50)'],
    ],
    'cmr.gem': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,0)'],
        [0.01568627450980392, 'rgb(1,1,0)'],
        [0.0196078431372549, 'rgb(2,1,1)'],
        [0.023529411764705882, 'rgb(3,1,1)'],
        [0.027450980392156862, 'rgb(4,1,1)'],
        [0.03137254901960784, 'rgb(5,2,1)'],
        [0.03529411764705882, 'rgb(7,2,1)'],
        [0.0392156862745098, 'rgb(8,2,2)'],
        [0.043137254901960784, 'rgb(10,3,2)'],
        [0.047058823529411764, 'rgb(12,3,2)'],
        [0.050980392156862744, 'rgb(14,3,2)'],
        [0.054901960784313725, 'rgb(16,4,3)'],
        [0.058823529411764705, 'rgb(17,4,3)'],
        [0.06274509803921569, 'rgb(19,5,3)'],
        [0.06666666666666667, 'rgb(21,5,4)'],
        [0.07058823529411765, 'rgb(23,5,4)'],
        [0.07450980392156863, 'rgb(25,6,4)'],
        [0.0784313725490196, 'rgb(27,6,5)'],
        [0.08235294117647059, 'rgb(28,7,5)'],
        [0.08627450980392157, 'rgb(30,7,5)'],
        [0.09019607843137255, 'rgb(32,7,6)'],
        [0.09411764705882353, 'rgb(34,8,6)'],
        [0.09803921568627451, 'rgb(36,8,6)'],
        [0.10196078431372549, 'rgb(38,8,7)'],
        [0.10588235294117647, 'rgb(40,8,7)'],
        [0.10980392156862745, 'rgb(41,9,8)'],
        [0.11372549019607843, 'rgb(43,9,8)'],
        [0.11764705882352941, 'rgb(45,9,9)'],
        [0.12156862745098039, 'rgb(47,9,9)'],
        [0.12549019607843137, 'rgb(49,9,10)'],
        [0.12941176470588237, 'rgb(51,9,11)'],
        [0.13333333333333333, 'rgb(53,9,11)'],
        [0.13725490196078433, 'rgb(54,9,12)'],
        [0.1411764705882353, 'rgb(56,9,13)'],
        [0.1450980392156863, 'rgb(58,9,13)'],
        [0.14901960784313725, 'rgb(60,9,14)'],
        [0.15294117647058825, 'rgb(62,9,15)'],
        [0.1568627450980392, 'rgb(64,9,16)'],
        [0.1607843137254902, 'rgb(66,8,17)'],
        [0.16470588235294117, 'rgb(68,8,18)'],
        [0.16862745098039217, 'rgb(69,8,19)'],
        [0.17254901960784313, 'rgb(71,7,20)'],
        [0.17647058823529413, 'rgb(73,7,21)'],
        [0.1803921568627451, 'rgb(75,6,22)'],
        [0.1843137254901961, 'rgb(77,6,24)'],
        [0.18823529411764706, 'rgb(79,5,25)'],
        [0.19215686274509805, 'rgb(80,5,27)'],
        [0.19607843137254902, 'rgb(82,4,28)'],
        [0.2, 'rgb(84,4,30)'],
        [0.20392156862745098, 'rgb(86,3,32)'],
        [0.20784313725490197, 'rgb(87,3,33)'],
        [0.21176470588235294, 'rgb(89,2,35)'],
        [0.21568627450980393, 'rgb(90,2,37)'],
        [0.2196078431372549, 'rgb(92,1,39)'],
        [0.2235294117647059, 'rgb(94,1,41)'],
        [0.22745098039215686, 'rgb(95,1,44)'],
        [0.23137254901960785, 'rgb(97,0,46)'],
        [0.23529411764705882, 'rgb(98,0,48)'],
        [0.23921568627450981, 'rgb(99,0,50)'],
        [0.24313725490196078, 'rgb(101,0,53)'],
        [0.24705882352941178, 'rgb(102,0,55)'],
        [0.25098039215686274, 'rgb(103,0,57)'],
        [0.2549019607843137, 'rgb(105,0,60)'],
        [0.25882352941176473, 'rgb(106,1,62)'],
        [0.2627450980392157, 'rgb(107,1,65)'],
        [0.26666666666666666, 'rgb(108,2,67)'],
        [0.27058823529411763, 'rgb(109,2,70)'],
        [0.27450980392156865, 'rgb(110,3,72)'],
        [0.2784313725490196, 'rgb(112,4,75)'],
        [0.2823529411764706, 'rgb(113,5,78)'],
        [0.28627450980392155, 'rgb(114,6,80)'],
        [0.2901960784313726, 'rgb(114,7,83)'],
        [0.29411764705882354, 'rgb(115,8,85)'],
        [0.2980392156862745, 'rgb(116,10,88)'],
        [0.30196078431372547, 'rgb(117,11,90)'],
        [0.3058823529411765, 'rgb(118,13,93)'],
        [0.30980392156862746, 'rgb(119,14,96)'],
        [0.3137254901960784, 'rgb(120,16,98)'],
        [0.3176470588235294, 'rgb(120,18,101)'],
        [0.3215686274509804, 'rgb(121,19,103)'],
        [0.3254901960784314, 'rgb(122,21,106)'],
        [0.32941176470588235, 'rgb(122,22,108)'],
        [0.3333333333333333, 'rgb(123,24,111)'],
        [0.33725490196078434, 'rgb(124,25,113)'],
        [0.3411764705882353, 'rgb(124,27,116)'],
        [0.34509803921568627, 'rgb(125,28,118)'],
        [0.34901960784313724, 'rgb(125,30,120)'],
        [0.35294117647058826, 'rgb(126,32,123)'],
        [0.3568627450980392, 'rgb(126,33,125)'],
        [0.3607843137254902, 'rgb(127,35,128)'],
        [0.36470588235294116, 'rgb(127,36,130)'],
        [0.3686274509803922, 'rgb(127,38,132)'],
        [0.37254901960784315, 'rgb(128,40,135)'],
        [0.3764705882352941, 'rgb(128,41,137)'],
        [0.3803921568627451, 'rgb(128,43,139)'],
        [0.3843137254901961, 'rgb(129,44,141)'],
        [0.38823529411764707, 'rgb(129,46,143)'],
        [0.39215686274509803, 'rgb(129,48,146)'],
        [0.396078431372549, 'rgb(129,49,148)'],
        [0.4, 'rgb(130,51,150)'],
        [0.403921568627451, 'rgb(130,52,152)'],
        [0.40784313725490196, 'rgb(130,54,154)'],
        [0.4117647058823529, 'rgb(130,56,156)'],
        [0.41568627450980394, 'rgb(130,57,158)'],
        [0.4196078431372549, 'rgb(130,59,160)'],
        [0.4235294117647059, 'rgb(130,60,162)'],
        [0.42745098039215684, 'rgb(130,62,164)'],
        [0.43137254901960786, 'rgb(130,64,166)'],
        [0.43529411764705883, 'rgb(130,65,168)'],
        [0.4392156862745098, 'rgb(130,67,170)'],
        [0.44313725490196076, 'rgb(130,69,171)'],
        [0.4470588235294118, 'rgb(130,70,173)'],
        [0.45098039215686275, 'rgb(130,72,175)'],
        [0.4549019607843137, 'rgb(130,73,177)'],
        [0.4588235294117647, 'rgb(130,75,179)'],
        [0.4627450980392157, 'rgb(130,77,180)'],
        [0.4666666666666667, 'rgb(130,78,182)'],
        [0.47058823529411764, 'rgb(129,80,184)'],
        [0.4745098039215686, 'rgb(129,82,185)'],
        [0.47843137254901963, 'rgb(129,83,187)'],
        [0.4823529411764706, 'rgb(129,85,189)'],
        [0.48627450980392156, 'rgb(128,87,190)'],
        [0.49019607843137253, 'rgb(128,88,192)'],
        [0.49411764705882355, 'rgb(128,90,193)'],
        [0.4980392156862745, 'rgb(127,92,195)'],
        [0.5019607843137255, 'rgb(127,93,196)'],
        [0.5058823529411764, 'rgb(127,95,198)'],
        [0.5098039215686274, 'rgb(126,96,199)'],
        [0.5137254901960784, 'rgb(126,98,201)'],
        [0.5176470588235295, 'rgb(125,100,202)'],
        [0.5215686274509804, 'rgb(125,101,203)'],
        [0.5254901960784314, 'rgb(124,103,205)'],
        [0.5294117647058824, 'rgb(124,105,206)'],
        [0.5333333333333333, 'rgb(123,106,207)'],
        [0.5372549019607843, 'rgb(123,108,209)'],
        [0.5411764705882353, 'rgb(122,110,210)'],
        [0.5450980392156862, 'rgb(121,111,211)'],
        [0.5490196078431373, 'rgb(121,113,213)'],
        [0.5529411764705883, 'rgb(120,115,214)'],
        [0.5568627450980392, 'rgb(119,116,215)'],
        [0.5607843137254902, 'rgb(118,118,216)'],
        [0.5647058823529412, 'rgb(118,120,217)'],
        [0.5686274509803921, 'rgb(117,121,218)'],
        [0.5725490196078431, 'rgb(116,123,220)'],
        [0.5764705882352941, 'rgb(115,125,221)'],
        [0.5803921568627451, 'rgb(114,126,222)'],
        [0.5843137254901961, 'rgb(113,128,223)'],
        [0.5882352941176471, 'rgb(112,130,224)'],
        [0.592156862745098, 'rgb(111,131,225)'],
        [0.596078431372549, 'rgb(110,133,226)'],
        [0.6, 'rgb(109,135,227)'],
        [0.6039215686274509, 'rgb(108,136,228)'],
        [0.6078431372549019, 'rgb(107,138,229)'],
        [0.611764705882353, 'rgb(106,140,230)'],
        [0.615686274509804, 'rgb(105,141,231)'],
        [0.6196078431372549, 'rgb(103,143,232)'],
        [0.6235294117647059, 'rgb(102,145,232)'],
        [0.6274509803921569, 'rgb(101,146,233)'],
        [0.6313725490196078, 'rgb(99,148,234)'],
        [0.6352941176470588, 'rgb(98,150,235)'],
        [0.6392156862745098, 'rgb(96,151,236)'],
        [0.6431372549019608, 'rgb(95,153,236)'],
        [0.6470588235294118, 'rgb(93,155,237)'],
        [0.6509803921568628, 'rgb(92,156,238)'],
        [0.6549019607843137, 'rgb(90,158,238)'],
        [0.6588235294117647, 'rgb(88,160,239)'],
        [0.6627450980392157, 'rgb(87,161,240)'],
        [0.6666666666666666, 'rgb(85,163,240)'],
        [0.6705882352941176, 'rgb(83,165,241)'],
        [0.6745098039215687, 'rgb(81,166,241)'],
        [0.6784313725490196, 'rgb(79,168,242)'],
        [0.6823529411764706, 'rgb(77,170,242)'],
        [0.6862745098039216, 'rgb(75,171,243)'],
        [0.6901960784313725, 'rgb(73,173,243)'],
        [0.6941176470588235, 'rgb(71,175,243)'],
        [0.6980392156862745, 'rgb(69,176,244)'],
        [0.7019607843137254, 'rgb(66,178,244)'],
        [0.7058823529411765, 'rgb(64,180,244)'],
        [0.7098039215686275, 'rgb(62,181,244)'],
        [0.7137254901960784, 'rgb(59,183,244)'],
        [0.7176470588235294, 'rgb(57,184,245)'],
        [0.7215686274509804, 'rgb(55,186,245)'],
        [0.7254901960784313, 'rgb(53,188,245)'],
        [0.7294117647058823, 'rgb(50,189,245)'],
        [0.7333333333333333, 'rgb(48,191,245)'],
        [0.7372549019607844, 'rgb(46,192,244)'],
        [0.7411764705882353, 'rgb(44,194,244)'],
        [0.7450980392156863, 'rgb(43,196,244)'],
        [0.7490196078431373, 'rgb(42,197,244)'],
        [0.7529411764705882, 'rgb(41,199,243)'],
        [0.7568627450980392, 'rgb(41,200,243)'],
        [0.7607843137254902, 'rgb(41,202,243)'],
        [0.7647058823529411, 'rgb(42,203,242)'],
        [0.7686274509803922, 'rgb(43,204,242)'],
        [0.7725490196078432, 'rgb(45,206,241)'],
        [0.7764705882352941, 'rgb(47,207,240)'],
        [0.7803921568627451, 'rgb(50,208,240)'],
        [0.7843137254901961, 'rgb(54,210,239)'],
        [0.788235294117647, 'rgb(58,211,238)'],
        [0.792156862745098, 'rgb(62,212,238)'],
        [0.796078431372549, 'rgb(66,213,237)'],
        [0.8, 'rgb(71,214,236)'],
        [0.803921568627451, 'rgb(76,215,235)'],
        [0.807843137254902, 'rgb(81,216,235)'],
        [0.8117647058823529, 'rgb(85,217,234)'],
        [0.8156862745098039, 'rgb(90,218,233)'],
        [0.8196078431372549, 'rgb(95,219,233)'],
        [0.8235294117647058, 'rgb(100,220,232)'],
        [0.8274509803921568, 'rgb(105,221,231)'],
        [0.8313725490196079, 'rgb(110,222,231)'],
        [0.8352941176470589, 'rgb(115,223,231)'],
        [0.8392156862745098, 'rgb(120,223,230)'],
        [0.8431372549019608, 'rgb(124,224,230)'],
        [0.8470588235294118, 'rgb(129,225,230)'],
        [0.8509803921568627, 'rgb(133,226,230)'],
        [0.8549019607843137, 'rgb(138,226,229)'],
        [0.8588235294117647, 'rgb(142,227,229)'],
        [0.8627450980392157, 'rgb(146,228,229)'],
        [0.8666666666666667, 'rgb(150,228,230)'],
        [0.8705882352941177, 'rgb(154,229,230)'],
        [0.8745098039215686, 'rgb(158,230,230)'],
        [0.8784313725490196, 'rgb(162,230,230)'],
        [0.8823529411764706, 'rgb(166,231,230)'],
        [0.8862745098039215, 'rgb(170,232,231)'],
        [0.8901960784313725, 'rgb(173,232,231)'],
        [0.8941176470588236, 'rgb(177,233,232)'],
        [0.8980392156862745, 'rgb(180,234,232)'],
        [0.9019607843137255, 'rgb(184,234,233)'],
        [0.9058823529411765, 'rgb(187,235,233)'],
        [0.9098039215686274, 'rgb(190,236,234)'],
        [0.9137254901960784, 'rgb(194,237,234)'],
        [0.9176470588235294, 'rgb(197,237,235)'],
        [0.9215686274509803, 'rgb(200,238,236)'],
        [0.9254901960784314, 'rgb(203,239,236)'],
        [0.9294117647058824, 'rgb(206,240,237)'],
        [0.9333333333333333, 'rgb(209,240,238)'],
        [0.9372549019607843, 'rgb(212,241,239)'],
        [0.9411764705882353, 'rgb(215,242,240)'],
        [0.9450980392156862, 'rgb(218,243,241)'],
        [0.9490196078431372, 'rgb(221,243,241)'],
        [0.9529411764705882, 'rgb(224,244,242)'],
        [0.9568627450980393, 'rgb(227,245,243)'],
        [0.9607843137254902, 'rgb(229,246,244)'],
        [0.9647058823529412, 'rgb(232,247,245)'],
        [0.9686274509803922, 'rgb(235,248,246)'],
        [0.9725490196078431, 'rgb(237,249,247)'],
        [0.9764705882352941, 'rgb(240,249,248)'],
        [0.9803921568627451, 'rgb(243,250,249)'],
        [0.984313725490196, 'rgb(245,251,251)'],
        [0.9882352941176471, 'rgb(248,252,252)'],
        [0.9921568627450981, 'rgb(250,253,253)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.gothic': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,2)'],
        [0.023529411764705882, 'rgb(1,1,2)'],
        [0.027450980392156862, 'rgb(2,2,3)'],
        [0.03137254901960784, 'rgb(2,2,4)'],
        [0.03529411764705882, 'rgb(3,3,6)'],
        [0.0392156862745098, 'rgb(3,4,7)'],
        [0.043137254901960784, 'rgb(4,4,9)'],
        [0.047058823529411764, 'rgb(5,5,10)'],
        [0.050980392156862744, 'rgb(5,6,12)'],
        [0.054901960784313725, 'rgb(6,7,14)'],
        [0.058823529411764705, 'rgb(7,7,16)'],
        [0.06274509803921569, 'rgb(8,8,18)'],
        [0.06666666666666667, 'rgb(9,9,19)'],
        [0.07058823529411765, 'rgb(10,10,21)'],
        [0.07450980392156863, 'rgb(11,11,23)'],
        [0.0784313725490196, 'rgb(12,12,25)'],
        [0.08235294117647059, 'rgb(13,13,27)'],
        [0.08627450980392157, 'rgb(14,14,29)'],
        [0.09019607843137255, 'rgb(15,15,31)'],
        [0.09411764705882353, 'rgb(16,16,33)'],
        [0.09803921568627451, 'rgb(17,17,35)'],
        [0.10196078431372549, 'rgb(18,18,37)'],
        [0.10588235294117647, 'rgb(19,19,39)'],
        [0.10980392156862745, 'rgb(19,19,41)'],
        [0.11372549019607843, 'rgb(20,20,43)'],
        [0.11764705882352941, 'rgb(21,21,45)'],
        [0.12156862745098039, 'rgb(22,22,47)'],
        [0.12549019607843137, 'rgb(23,23,49)'],
        [0.12941176470588237, 'rgb(24,23,51)'],
        [0.13333333333333333, 'rgb(25,24,53)'],
        [0.13725490196078433, 'rgb(26,25,55)'],
        [0.1411764705882353, 'rgb(27,26,57)'],
        [0.1450980392156863, 'rgb(28,26,60)'],
        [0.14901960784313725, 'rgb(29,27,62)'],
        [0.15294117647058825, 'rgb(30,28,64)'],
        [0.1568627450980392, 'rgb(31,28,66)'],
        [0.1607843137254902, 'rgb(32,29,69)'],
        [0.16470588235294117, 'rgb(33,30,71)'],
        [0.16862745098039217, 'rgb(34,30,73)'],
        [0.17254901960784313, 'rgb(35,31,76)'],
        [0.17647058823529413, 'rgb(36,31,78)'],
        [0.1803921568627451, 'rgb(37,32,81)'],
        [0.1843137254901961, 'rgb(38,32,83)'],
        [0.18823529411764706, 'rgb(39,33,86)'],
        [0.19215686274509805, 'rgb(40,33,88)'],
        [0.19607843137254902, 'rgb(41,34,91)'],
        [0.2, 'rgb(43,34,94)'],
        [0.20392156862745098, 'rgb(44,35,96)'],
        [0.20784313725490197, 'rgb(45,35,99)'],
        [0.21176470588235294, 'rgb(46,35,102)'],
        [0.21568627450980393, 'rgb(47,36,104)'],
        [0.2196078431372549, 'rgb(49,36,107)'],
        [0.2235294117647059, 'rgb(50,36,110)'],
        [0.22745098039215686, 'rgb(51,36,113)'],
        [0.23137254901960785, 'rgb(53,36,116)'],
        [0.23529411764705882, 'rgb(54,36,119)'],
        [0.23921568627450981, 'rgb(55,36,122)'],
        [0.24313725490196078, 'rgb(57,36,124)'],
        [0.24705882352941178, 'rgb(58,36,127)'],
        [0.25098039215686274, 'rgb(60,36,130)'],
        [0.2549019607843137, 'rgb(61,36,134)'],
        [0.25882352941176473, 'rgb(63,36,137)'],
        [0.2627450980392157, 'rgb(64,35,140)'],
        [0.26666666666666666, 'rgb(66,35,143)'],
        [0.27058823529411763, 'rgb(68,35,146)'],
        [0.27450980392156865, 'rgb(69,34,149)'],
        [0.2784313725490196, 'rgb(71,33,152)'],
        [0.2823529411764706, 'rgb(73,33,155)'],
        [0.28627450980392155, 'rgb(75,32,158)'],
        [0.2901960784313726, 'rgb(77,31,161)'],
        [0.29411764705882354, 'rgb(79,30,164)'],
        [0.2980392156862745, 'rgb(80,29,167)'],
        [0.30196078431372547, 'rgb(82,27,170)'],
        [0.3058823529411765, 'rgb(84,26,173)'],
        [0.30980392156862746, 'rgb(86,25,176)'],
        [0.3137254901960784, 'rgb(89,23,178)'],
        [0.3176470588235294, 'rgb(91,21,181)'],
        [0.3215686274509804, 'rgb(93,20,183)'],
        [0.3254901960784314, 'rgb(95,18,185)'],
        [0.32941176470588235, 'rgb(97,16,188)'],
        [0.3333333333333333, 'rgb(99,14,190)'],
        [0.33725490196078434, 'rgb(101,12,191)'],
        [0.3411764705882353, 'rgb(103,10,193)'],
        [0.34509803921568627, 'rgb(105,8,195)'],
        [0.34901960784313724, 'rgb(107,6,196)'],
        [0.35294117647058826, 'rgb(109,5,197)'],
        [0.3568627450980392, 'rgb(111,4,198)'],
        [0.3607843137254902, 'rgb(113,3,199)'],
        [0.36470588235294116, 'rgb(115,3,200)'],
        [0.3686274509803922, 'rgb(117,3,201)'],
        [0.37254901960784315, 'rgb(118,3,202)'],
        [0.3764705882352941, 'rgb(120,3,202)'],
        [0.3803921568627451, 'rgb(122,4,203)'],
        [0.3843137254901961, 'rgb(124,4,203)'],
        [0.38823529411764707, 'rgb(126,5,204)'],
        [0.39215686274509803, 'rgb(127,6,204)'],
        [0.396078431372549, 'rgb(129,8,204)'],
        [0.4, 'rgb(131,9,204)'],
        [0.403921568627451, 'rgb(133,11,204)'],
        [0.40784313725490196, 'rgb(134,13,205)'],
        [0.4117647058823529, 'rgb(136,14,205)'],
        [0.41568627450980394, 'rgb(138,16,205)'],
        [0.4196078431372549, 'rgb(139,17,205)'],
        [0.4235294117647059, 'rgb(141,19,205)'],
        [0.42745098039215684, 'rgb(143,20,204)'],
        [0.43137254901960786, 'rgb(144,22,204)'],
        [0.43529411764705883, 'rgb(146,23,204)'],
        [0.4392156862745098, 'rgb(148,25,204)'],
        [0.44313725490196076, 'rgb(149,26,204)'],
        [0.4470588235294118, 'rgb(151,28,204)'],
        [0.45098039215686275, 'rgb(153,29,203)'],
        [0.4549019607843137, 'rgb(154,30,203)'],
        [0.4588235294117647, 'rgb(156,32,203)'],
        [0.4627450980392157, 'rgb(158,33,203)'],
        [0.4666666666666667, 'rgb(159,34,203)'],
        [0.47058823529411764, 'rgb(161,35,202)'],
        [0.4745098039215686, 'rgb(163,37,202)'],
        [0.47843137254901963, 'rgb(164,38,202)'],
        [0.4823529411764706, 'rgb(166,39,201)'],
        [0.48627450980392156, 'rgb(167,40,201)'],
        [0.49019607843137253, 'rgb(169,41,201)'],
        [0.49411764705882355, 'rgb(171,42,200)'],
        [0.4980392156862745, 'rgb(172,44,200)'],
        [0.5019607843137255, 'rgb(174,45,200)'],
        [0.5058823529411764, 'rgb(176,46,199)'],
        [0.5098039215686274, 'rgb(177,47,199)'],
        [0.5137254901960784, 'rgb(179,48,198)'],
        [0.5176470588235295, 'rgb(180,49,198)'],
        [0.5215686274509804, 'rgb(182,50,198)'],
        [0.5254901960784314, 'rgb(184,52,197)'],
        [0.5294117647058824, 'rgb(185,53,197)'],
        [0.5333333333333333, 'rgb(187,54,196)'],
        [0.5372549019607843, 'rgb(188,55,196)'],
        [0.5411764705882353, 'rgb(190,56,195)'],
        [0.5450980392156862, 'rgb(191,57,195)'],
        [0.5490196078431373, 'rgb(193,59,194)'],
        [0.5529411764705883, 'rgb(194,60,193)'],
        [0.5568627450980392, 'rgb(196,61,193)'],
        [0.5607843137254902, 'rgb(197,63,192)'],
        [0.5647058823529412, 'rgb(199,64,191)'],
        [0.5686274509803921, 'rgb(200,65,191)'],
        [0.5725490196078431, 'rgb(201,67,190)'],
        [0.5764705882352941, 'rgb(203,69,189)'],
        [0.5803921568627451, 'rgb(204,71,188)'],
        [0.5843137254901961, 'rgb(205,73,188)'],
        [0.5882352941176471, 'rgb(205,75,187)'],
        [0.592156862745098, 'rgb(206,78,186)'],
        [0.596078431372549, 'rgb(206,80,186)'],
        [0.6, 'rgb(206,83,186)'],
        [0.6039215686274509, 'rgb(206,86,186)'],
        [0.6078431372549019, 'rgb(206,88,186)'],
        [0.611764705882353, 'rgb(206,91,187)'],
        [0.615686274509804, 'rgb(206,93,187)'],
        [0.6196078431372549, 'rgb(205,96,188)'],
        [0.6235294117647059, 'rgb(205,98,189)'],
        [0.6274509803921569, 'rgb(205,100,190)'],
        [0.6313725490196078, 'rgb(205,103,191)'],
        [0.6352941176470588, 'rgb(205,105,192)'],
        [0.6392156862745098, 'rgb(205,107,193)'],
        [0.6431372549019608, 'rgb(205,109,194)'],
        [0.6470588235294118, 'rgb(205,111,195)'],
        [0.6509803921568628, 'rgb(205,113,196)'],
        [0.6549019607843137, 'rgb(204,115,197)'],
        [0.6588235294117647, 'rgb(204,117,199)'],
        [0.6627450980392157, 'rgb(204,119,200)'],
        [0.6666666666666666, 'rgb(204,121,201)'],
        [0.6705882352941176, 'rgb(204,123,202)'],
        [0.6745098039215687, 'rgb(204,125,203)'],
        [0.6784313725490196, 'rgb(204,127,205)'],
        [0.6823529411764706, 'rgb(204,129,206)'],
        [0.6862745098039216, 'rgb(204,130,207)'],
        [0.6901960784313725, 'rgb(204,132,208)'],
        [0.6941176470588235, 'rgb(204,134,209)'],
        [0.6980392156862745, 'rgb(204,136,211)'],
        [0.7019607843137254, 'rgb(204,138,212)'],
        [0.7058823529411765, 'rgb(203,140,213)'],
        [0.7098039215686275, 'rgb(203,141,214)'],
        [0.7137254901960784, 'rgb(203,143,215)'],
        [0.7176470588235294, 'rgb(203,145,217)'],
        [0.7215686274509804, 'rgb(203,147,218)'],
        [0.7254901960784313, 'rgb(203,148,219)'],
        [0.7294117647058823, 'rgb(203,150,220)'],
        [0.7333333333333333, 'rgb(203,152,221)'],
        [0.7372549019607844, 'rgb(203,154,222)'],
        [0.7411764705882353, 'rgb(203,155,224)'],
        [0.7450980392156863, 'rgb(203,157,225)'],
        [0.7490196078431373, 'rgb(203,159,226)'],
        [0.7529411764705882, 'rgb(203,160,227)'],
        [0.7568627450980392, 'rgb(203,162,228)'],
        [0.7607843137254902, 'rgb(203,164,229)'],
        [0.7647058823529411, 'rgb(203,165,230)'],
        [0.7686274509803922, 'rgb(203,167,231)'],
        [0.7725490196078432, 'rgb(203,169,232)'],
        [0.7764705882352941, 'rgb(203,171,233)'],
        [0.7803921568627451, 'rgb(203,172,234)'],
        [0.7843137254901961, 'rgb(203,174,235)'],
        [0.788235294117647, 'rgb(203,176,236)'],
        [0.792156862745098, 'rgb(203,177,237)'],
        [0.796078431372549, 'rgb(203,179,238)'],
        [0.8, 'rgb(203,181,239)'],
        [0.803921568627451, 'rgb(204,182,240)'],
        [0.807843137254902, 'rgb(204,184,241)'],
        [0.8117647058823529, 'rgb(204,186,241)'],
        [0.8156862745098039, 'rgb(204,187,242)'],
        [0.8196078431372549, 'rgb(204,189,243)'],
        [0.8235294117647058, 'rgb(204,191,243)'],
        [0.8274509803921568, 'rgb(205,192,244)'],
        [0.8313725490196079, 'rgb(205,194,244)'],
        [0.8352941176470589, 'rgb(205,195,245)'],
        [0.8392156862745098, 'rgb(206,197,245)'],
        [0.8431372549019608, 'rgb(206,199,246)'],
        [0.8470588235294118, 'rgb(206,200,246)'],
        [0.8509803921568627, 'rgb(207,202,246)'],
        [0.8549019607843137, 'rgb(207,203,246)'],
        [0.8588235294117647, 'rgb(208,205,246)'],
        [0.8627450980392157, 'rgb(209,207,247)'],
        [0.8666666666666667, 'rgb(210,208,247)'],
        [0.8705882352941177, 'rgb(210,210,247)'],
        [0.8745098039215686, 'rgb(211,211,247)'],
        [0.8784313725490196, 'rgb(212,213,247)'],
        [0.8823529411764706, 'rgb(213,214,247)'],
        [0.8862745098039215, 'rgb(214,216,247)'],
        [0.8901960784313725, 'rgb(215,217,247)'],
        [0.8941176470588236, 'rgb(216,218,247)'],
        [0.8980392156862745, 'rgb(217,220,247)'],
        [0.9019607843137255, 'rgb(219,221,247)'],
        [0.9058823529411765, 'rgb(220,223,247)'],
        [0.9098039215686274, 'rgb(221,224,247)'],
        [0.9137254901960784, 'rgb(222,225,248)'],
        [0.9176470588235294, 'rgb(224,227,248)'],
        [0.9215686274509803, 'rgb(225,228,248)'],
        [0.9254901960784314, 'rgb(226,229,248)'],
        [0.9294117647058824, 'rgb(228,231,248)'],
        [0.9333333333333333, 'rgb(229,232,248)'],
        [0.9372549019607843, 'rgb(230,234,248)'],
        [0.9411764705882353, 'rgb(232,235,249)'],
        [0.9450980392156862, 'rgb(233,236,249)'],
        [0.9490196078431372, 'rgb(235,238,249)'],
        [0.9529411764705882, 'rgb(236,239,250)'],
        [0.9568627450980393, 'rgb(238,240,250)'],
        [0.9607843137254902, 'rgb(239,242,250)'],
        [0.9647058823529412, 'rgb(241,243,251)'],
        [0.9686274509803922, 'rgb(242,244,251)'],
        [0.9725490196078431, 'rgb(244,246,251)'],
        [0.9764705882352941, 'rgb(246,247,252)'],
        [0.9803921568627451, 'rgb(247,248,252)'],
        [0.984313725490196, 'rgb(249,250,253)'],
        [0.9882352941176471, 'rgb(250,251,253)'],
        [0.9921568627450981, 'rgb(252,252,254)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.heat': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,2)'],
        [0.023529411764705882, 'rgb(1,2,3)'],
        [0.027450980392156862, 'rgb(1,2,4)'],
        [0.03137254901960784, 'rgb(1,3,5)'],
        [0.03529411764705882, 'rgb(2,3,6)'],
        [0.0392156862745098, 'rgb(2,4,8)'],
        [0.043137254901960784, 'rgb(2,5,10)'],
        [0.047058823529411764, 'rgb(3,6,12)'],
        [0.050980392156862744, 'rgb(3,7,14)'],
        [0.054901960784313725, 'rgb(3,8,16)'],
        [0.058823529411764705, 'rgb(3,9,18)'],
        [0.06274509803921569, 'rgb(4,10,20)'],
        [0.06666666666666667, 'rgb(4,11,22)'],
        [0.07058823529411765, 'rgb(4,12,24)'],
        [0.07450980392156863, 'rgb(4,13,26)'],
        [0.0784313725490196, 'rgb(4,14,28)'],
        [0.08235294117647059, 'rgb(4,15,30)'],
        [0.08627450980392157, 'rgb(4,16,32)'],
        [0.09019607843137255, 'rgb(4,18,35)'],
        [0.09411764705882353, 'rgb(4,19,37)'],
        [0.09803921568627451, 'rgb(4,20,39)'],
        [0.10196078431372549, 'rgb(4,21,41)'],
        [0.10588235294117647, 'rgb(4,22,44)'],
        [0.10980392156862745, 'rgb(4,23,46)'],
        [0.11372549019607843, 'rgb(4,24,49)'],
        [0.11764705882352941, 'rgb(4,25,51)'],
        [0.12156862745098039, 'rgb(4,25,54)'],
        [0.12549019607843137, 'rgb(3,26,56)'],
        [0.12941176470588237, 'rgb(3,27,59)'],
        [0.13333333333333333, 'rgb(3,28,62)'],
        [0.13725490196078433, 'rgb(3,29,64)'],
        [0.1411764705882353, 'rgb(2,30,67)'],
        [0.1450980392156863, 'rgb(2,31,70)'],
        [0.14901960784313725, 'rgb(2,31,73)'],
        [0.15294117647058825, 'rgb(2,32,76)'],
        [0.1568627450980392, 'rgb(1,33,79)'],
        [0.1607843137254902, 'rgb(1,34,82)'],
        [0.16470588235294117, 'rgb(1,34,85)'],
        [0.16862745098039217, 'rgb(2,35,88)'],
        [0.17254901960784313, 'rgb(2,35,91)'],
        [0.17647058823529413, 'rgb(3,36,95)'],
        [0.1803921568627451, 'rgb(4,36,98)'],
        [0.1843137254901961, 'rgb(5,37,101)'],
        [0.18823529411764706, 'rgb(7,37,104)'],
        [0.19215686274509805, 'rgb(9,37,108)'],
        [0.19607843137254902, 'rgb(12,37,111)'],
        [0.2, 'rgb(16,37,113)'],
        [0.20392156862745098, 'rgb(19,37,116)'],
        [0.20784313725490197, 'rgb(22,37,118)'],
        [0.21176470588235294, 'rgb(25,38,120)'],
        [0.21568627450980393, 'rgb(29,38,121)'],
        [0.2196078431372549, 'rgb(32,38,122)'],
        [0.2235294117647059, 'rgb(34,39,123)'],
        [0.22745098039215686, 'rgb(37,39,123)'],
        [0.23137254901960785, 'rgb(40,40,124)'],
        [0.23529411764705882, 'rgb(42,41,124)'],
        [0.23921568627450981, 'rgb(45,41,124)'],
        [0.24313725490196078, 'rgb(47,42,124)'],
        [0.24705882352941178, 'rgb(49,43,124)'],
        [0.25098039215686274, 'rgb(51,43,124)'],
        [0.2549019607843137, 'rgb(53,44,124)'],
        [0.25882352941176473, 'rgb(55,45,124)'],
        [0.2627450980392157, 'rgb(57,46,123)'],
        [0.26666666666666666, 'rgb(59,46,123)'],
        [0.27058823529411763, 'rgb(61,47,123)'],
        [0.27450980392156865, 'rgb(63,48,123)'],
        [0.2784313725490196, 'rgb(65,48,123)'],
        [0.2823529411764706, 'rgb(67,49,123)'],
        [0.28627450980392155, 'rgb(69,50,122)'],
        [0.2901960784313726, 'rgb(71,51,122)'],
        [0.29411764705882354, 'rgb(72,51,122)'],
        [0.2980392156862745, 'rgb(74,52,122)'],
        [0.30196078431372547, 'rgb(76,53,122)'],
        [0.3058823529411765, 'rgb(78,54,122)'],
        [0.30980392156862746, 'rgb(79,54,122)'],
        [0.3137254901960784, 'rgb(81,55,122)'],
        [0.3176470588235294, 'rgb(83,56,121)'],
        [0.3215686274509804, 'rgb(85,56,121)'],
        [0.3254901960784314, 'rgb(86,57,121)'],
        [0.32941176470588235, 'rgb(88,58,121)'],
        [0.3333333333333333, 'rgb(90,58,121)'],
        [0.33725490196078434, 'rgb(92,59,121)'],
        [0.3411764705882353, 'rgb(93,60,121)'],
        [0.34509803921568627, 'rgb(95,60,121)'],
        [0.34901960784313724, 'rgb(97,61,121)'],
        [0.35294117647058826, 'rgb(98,61,121)'],
        [0.3568627450980392, 'rgb(100,62,121)'],
        [0.3607843137254902, 'rgb(102,63,121)'],
        [0.36470588235294116, 'rgb(104,63,121)'],
        [0.3686274509803922, 'rgb(105,64,121)'],
        [0.37254901960784315, 'rgb(107,64,121)'],
        [0.3764705882352941, 'rgb(109,65,121)'],
        [0.3803921568627451, 'rgb(111,65,121)'],
        [0.3843137254901961, 'rgb(112,66,121)'],
        [0.38823529411764707, 'rgb(114,67,121)'],
        [0.39215686274509803, 'rgb(116,67,121)'],
        [0.396078431372549, 'rgb(118,68,121)'],
        [0.4, 'rgb(119,68,121)'],
        [0.403921568627451, 'rgb(121,69,121)'],
        [0.40784313725490196, 'rgb(123,69,120)'],
        [0.4117647058823529, 'rgb(125,70,120)'],
        [0.41568627450980394, 'rgb(127,70,120)'],
        [0.4196078431372549, 'rgb(129,70,120)'],
        [0.4235294117647059, 'rgb(130,71,120)'],
        [0.42745098039215684, 'rgb(132,71,120)'],
        [0.43137254901960786, 'rgb(134,72,120)'],
        [0.43529411764705883, 'rgb(136,72,120)'],
        [0.4392156862745098, 'rgb(138,73,119)'],
        [0.44313725490196076, 'rgb(140,73,119)'],
        [0.4470588235294118, 'rgb(142,73,119)'],
        [0.45098039215686275, 'rgb(144,74,119)'],
        [0.4549019607843137, 'rgb(145,74,118)'],
        [0.4588235294117647, 'rgb(147,75,118)'],
        [0.4627450980392157, 'rgb(149,75,118)'],
        [0.4666666666666667, 'rgb(151,75,117)'],
        [0.47058823529411764, 'rgb(153,76,117)'],
        [0.4745098039215686, 'rgb(155,76,117)'],
        [0.47843137254901963, 'rgb(157,76,116)'],
        [0.4823529411764706, 'rgb(159,77,116)'],
        [0.48627450980392156, 'rgb(161,77,115)'],
        [0.49019607843137253, 'rgb(163,77,115)'],
        [0.49411764705882355, 'rgb(165,78,114)'],
        [0.4980392156862745, 'rgb(167,78,114)'],
        [0.5019607843137255, 'rgb(169,78,113)'],
        [0.5058823529411764, 'rgb(171,78,112)'],
        [0.5098039215686274, 'rgb(173,79,112)'],
        [0.5137254901960784, 'rgb(175,79,111)'],
        [0.5176470588235295, 'rgb(177,79,110)'],
        [0.5215686274509804, 'rgb(179,80,109)'],
        [0.5254901960784314, 'rgb(181,80,109)'],
        [0.5294117647058824, 'rgb(183,80,108)'],
        [0.5333333333333333, 'rgb(185,80,107)'],
        [0.5372549019607843, 'rgb(187,81,106)'],
        [0.5411764705882353, 'rgb(189,81,105)'],
        [0.5450980392156862, 'rgb(191,81,104)'],
        [0.5490196078431373, 'rgb(193,82,103)'],
        [0.5529411764705883, 'rgb(195,82,102)'],
        [0.5568627450980392, 'rgb(197,82,101)'],
        [0.5607843137254902, 'rgb(199,83,100)'],
        [0.5647058823529412, 'rgb(201,83,99)'],
        [0.5686274509803921, 'rgb(203,83,98)'],
        [0.5725490196078431, 'rgb(205,83,97)'],
        [0.5764705882352941, 'rgb(207,84,95)'],
        [0.5803921568627451, 'rgb(209,84,94)'],
        [0.5843137254901961, 'rgb(211,84,93)'],
        [0.5882352941176471, 'rgb(213,85,91)'],
        [0.592156862745098, 'rgb(215,85,90)'],
        [0.596078431372549, 'rgb(217,86,89)'],
        [0.6, 'rgb(219,86,87)'],
        [0.6039215686274509, 'rgb(221,86,86)'],
        [0.6078431372549019, 'rgb(223,87,84)'],
        [0.611764705882353, 'rgb(225,87,83)'],
        [0.615686274509804, 'rgb(227,88,81)'],
        [0.6196078431372549, 'rgb(229,88,80)'],
        [0.6235294117647059, 'rgb(230,89,78)'],
        [0.6274509803921569, 'rgb(232,90,76)'],
        [0.6313725490196078, 'rgb(234,90,74)'],
        [0.6352941176470588, 'rgb(236,91,73)'],
        [0.6392156862745098, 'rgb(237,92,71)'],
        [0.6431372549019608, 'rgb(239,93,69)'],
        [0.6470588235294118, 'rgb(241,94,67)'],
        [0.6509803921568628, 'rgb(242,95,66)'],
        [0.6549019607843137, 'rgb(243,96,64)'],
        [0.6588235294117647, 'rgb(245,97,62)'],
        [0.6627450980392157, 'rgb(246,98,60)'],
        [0.6666666666666666, 'rgb(247,99,59)'],
        [0.6705882352941176, 'rgb(249,101,57)'],
        [0.6745098039215687, 'rgb(250,102,55)'],
        [0.6784313725490196, 'rgb(251,104,54)'],
        [0.6823529411764706, 'rgb(251,105,53)'],
        [0.6862745098039216, 'rgb(252,107,51)'],
        [0.6901960784313725, 'rgb(253,109,50)'],
        [0.6941176470588235, 'rgb(253,111,50)'],
        [0.6980392156862745, 'rgb(254,113,49)'],
        [0.7019607843137254, 'rgb(254,115,49)'],
        [0.7058823529411765, 'rgb(254,117,49)'],
        [0.7098039215686275, 'rgb(255,120,49)'],
        [0.7137254901960784, 'rgb(255,122,50)'],
        [0.7176470588235294, 'rgb(255,124,50)'],
        [0.7215686274509804, 'rgb(255,126,51)'],
        [0.7254901960784313, 'rgb(255,129,53)'],
        [0.7294117647058823, 'rgb(255,131,54)'],
        [0.7333333333333333, 'rgb(255,133,56)'],
        [0.7372549019607844, 'rgb(255,135,57)'],
        [0.7411764705882353, 'rgb(254,138,59)'],
        [0.7450980392156863, 'rgb(254,140,61)'],
        [0.7490196078431373, 'rgb(254,142,63)'],
        [0.7529411764705882, 'rgb(254,144,66)'],
        [0.7568627450980392, 'rgb(253,147,68)'],
        [0.7607843137254902, 'rgb(253,149,70)'],
        [0.7647058823529411, 'rgb(253,151,73)'],
        [0.7686274509803922, 'rgb(253,153,75)'],
        [0.7725490196078432, 'rgb(252,155,78)'],
        [0.7764705882352941, 'rgb(252,158,81)'],
        [0.7803921568627451, 'rgb(252,160,83)'],
        [0.7843137254901961, 'rgb(251,162,86)'],
        [0.788235294117647, 'rgb(251,164,89)'],
        [0.792156862745098, 'rgb(251,166,92)'],
        [0.796078431372549, 'rgb(250,168,95)'],
        [0.8, 'rgb(250,170,98)'],
        [0.803921568627451, 'rgb(250,172,101)'],
        [0.807843137254902, 'rgb(249,174,104)'],
        [0.8117647058823529, 'rgb(249,176,107)'],
        [0.8156862745098039, 'rgb(248,178,110)'],
        [0.8196078431372549, 'rgb(248,180,113)'],
        [0.8235294117647058, 'rgb(248,182,116)'],
        [0.8274509803921568, 'rgb(247,184,119)'],
        [0.8313725490196079, 'rgb(247,186,122)'],
        [0.8352941176470589, 'rgb(247,188,125)'],
        [0.8392156862745098, 'rgb(246,189,128)'],
        [0.8431372549019608, 'rgb(246,191,132)'],
        [0.8470588235294118, 'rgb(246,193,135)'],
        [0.8509803921568627, 'rgb(246,195,138)'],
        [0.8549019607843137, 'rgb(245,197,141)'],
        [0.8588235294117647, 'rgb(245,199,144)'],
        [0.8627450980392157, 'rgb(245,200,148)'],
        [0.8666666666666667, 'rgb(245,202,151)'],
        [0.8705882352941177, 'rgb(244,204,154)'],
        [0.8745098039215686, 'rgb(244,206,157)'],
        [0.8784313725490196, 'rgb(244,207,161)'],
        [0.8823529411764706, 'rgb(244,209,164)'],
        [0.8862745098039215, 'rgb(244,211,167)'],
        [0.8901960784313725, 'rgb(244,213,170)'],
        [0.8941176470588236, 'rgb(244,214,174)'],
        [0.8980392156862745, 'rgb(243,216,177)'],
        [0.9019607843137255, 'rgb(243,218,180)'],
        [0.9058823529411765, 'rgb(243,219,183)'],
        [0.9098039215686274, 'rgb(243,221,187)'],
        [0.9137254901960784, 'rgb(243,222,190)'],
        [0.9176470588235294, 'rgb(244,224,193)'],
        [0.9215686274509803, 'rgb(244,226,196)'],
        [0.9254901960784314, 'rgb(244,227,200)'],
        [0.9294117647058824, 'rgb(244,229,203)'],
        [0.9333333333333333, 'rgb(244,230,206)'],
        [0.9372549019607843, 'rgb(244,232,209)'],
        [0.9411764705882353, 'rgb(245,234,212)'],
        [0.9450980392156862, 'rgb(245,235,216)'],
        [0.9490196078431372, 'rgb(245,237,219)'],
        [0.9529411764705882, 'rgb(246,238,222)'],
        [0.9568627450980393, 'rgb(246,240,225)'],
        [0.9607843137254902, 'rgb(246,241,228)'],
        [0.9647058823529412, 'rgb(247,242,231)'],
        [0.9686274509803922, 'rgb(248,244,234)'],
        [0.9725490196078431, 'rgb(248,245,237)'],
        [0.9764705882352941, 'rgb(249,247,240)'],
        [0.9803921568627451, 'rgb(250,248,243)'],
        [0.984313725490196, 'rgb(251,249,246)'],
        [0.9882352941176471, 'rgb(252,251,248)'],
        [0.9921568627450981, 'rgb(253,252,250)'],
        [0.996078431372549, 'rgb(254,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.horizon': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,0)'],
        [0.01568627450980392, 'rgb(1,1,0)'],
        [0.0196078431372549, 'rgb(1,1,0)'],
        [0.023529411764705882, 'rgb(2,2,1)'],
        [0.027450980392156862, 'rgb(2,2,1)'],
        [0.03137254901960784, 'rgb(3,3,1)'],
        [0.03529411764705882, 'rgb(4,3,1)'],
        [0.0392156862745098, 'rgb(4,4,1)'],
        [0.043137254901960784, 'rgb(5,5,1)'],
        [0.047058823529411764, 'rgb(6,5,1)'],
        [0.050980392156862744, 'rgb(7,6,1)'],
        [0.054901960784313725, 'rgb(8,7,2)'],
        [0.058823529411764705, 'rgb(9,8,2)'],
        [0.06274509803921569, 'rgb(11,9,2)'],
        [0.06666666666666667, 'rgb(12,10,2)'],
        [0.07058823529411765, 'rgb(13,11,2)'],
        [0.07450980392156863, 'rgb(14,12,2)'],
        [0.0784313725490196, 'rgb(15,14,2)'],
        [0.08235294117647059, 'rgb(16,15,2)'],
        [0.08627450980392157, 'rgb(17,16,2)'],
        [0.09019607843137255, 'rgb(18,17,2)'],
        [0.09411764705882353, 'rgb(19,18,2)'],
        [0.09803921568627451, 'rgb(20,19,2)'],
        [0.10196078431372549, 'rgb(21,20,2)'],
        [0.10588235294117647, 'rgb(22,21,2)'],
        [0.10980392156862745, 'rgb(23,22,2)'],
        [0.11372549019607843, 'rgb(24,23,2)'],
        [0.11764705882352941, 'rgb(25,24,2)'],
        [0.12156862745098039, 'rgb(26,25,1)'],
        [0.12549019607843137, 'rgb(27,27,1)'],
        [0.12941176470588237, 'rgb(28,28,1)'],
        [0.13333333333333333, 'rgb(28,29,1)'],
        [0.13725490196078433, 'rgb(29,30,1)'],
        [0.1411764705882353, 'rgb(30,31,1)'],
        [0.1450980392156863, 'rgb(30,32,1)'],
        [0.14901960784313725, 'rgb(31,33,1)'],
        [0.15294117647058825, 'rgb(31,34,1)'],
        [0.1568627450980392, 'rgb(32,35,0)'],
        [0.1607843137254902, 'rgb(32,37,0)'],
        [0.16470588235294117, 'rgb(33,38,0)'],
        [0.16862745098039217, 'rgb(33,39,0)'],
        [0.17254901960784313, 'rgb(33,40,1)'],
        [0.17647058823529413, 'rgb(33,41,1)'],
        [0.1803921568627451, 'rgb(34,43,1)'],
        [0.1843137254901961, 'rgb(34,44,1)'],
        [0.18823529411764706, 'rgb(34,45,2)'],
        [0.19215686274509805, 'rgb(33,46,2)'],
        [0.19607843137254902, 'rgb(33,48,3)'],
        [0.2, 'rgb(33,49,4)'],
        [0.20392156862745098, 'rgb(33,50,5)'],
        [0.20784313725490197, 'rgb(33,51,6)'],
        [0.21176470588235294, 'rgb(32,53,7)'],
        [0.21568627450980393, 'rgb(32,54,8)'],
        [0.2196078431372549, 'rgb(32,55,10)'],
        [0.2235294117647059, 'rgb(31,56,11)'],
        [0.22745098039215686, 'rgb(31,57,13)'],
        [0.23137254901960785, 'rgb(30,59,15)'],
        [0.23529411764705882, 'rgb(30,60,17)'],
        [0.23921568627450981, 'rgb(29,61,18)'],
        [0.24313725490196078, 'rgb(29,62,20)'],
        [0.24705882352941178, 'rgb(28,63,22)'],
        [0.25098039215686274, 'rgb(28,64,24)'],
        [0.2549019607843137, 'rgb(27,66,25)'],
        [0.25882352941176473, 'rgb(27,67,27)'],
        [0.2627450980392157, 'rgb(26,68,29)'],
        [0.26666666666666666, 'rgb(26,69,31)'],
        [0.27058823529411763, 'rgb(25,70,33)'],
        [0.27450980392156865, 'rgb(25,71,34)'],
        [0.2784313725490196, 'rgb(24,72,36)'],
        [0.2823529411764706, 'rgb(24,73,38)'],
        [0.28627450980392155, 'rgb(24,74,40)'],
        [0.2901960784313726, 'rgb(23,75,42)'],
        [0.29411764705882354, 'rgb(23,76,43)'],
        [0.2980392156862745, 'rgb(22,77,45)'],
        [0.30196078431372547, 'rgb(22,78,47)'],
        [0.3058823529411765, 'rgb(22,80,49)'],
        [0.30980392156862746, 'rgb(22,81,51)'],
        [0.3137254901960784, 'rgb(21,82,53)'],
        [0.3176470588235294, 'rgb(21,83,54)'],
        [0.3215686274509804, 'rgb(21,84,56)'],
        [0.3254901960784314, 'rgb(21,85,58)'],
        [0.32941176470588235, 'rgb(21,86,60)'],
        [0.3333333333333333, 'rgb(21,87,62)'],
        [0.33725490196078434, 'rgb(21,88,64)'],
        [0.3411764705882353, 'rgb(21,89,65)'],
        [0.34509803921568627, 'rgb(21,89,67)'],
        [0.34901960784313724, 'rgb(21,90,69)'],
        [0.35294117647058826, 'rgb(22,91,71)'],
        [0.3568627450980392, 'rgb(22,92,73)'],
        [0.3607843137254902, 'rgb(22,93,74)'],
        [0.36470588235294116, 'rgb(23,94,76)'],
        [0.3686274509803922, 'rgb(23,95,78)'],
        [0.37254901960784315, 'rgb(24,96,80)'],
        [0.3764705882352941, 'rgb(24,97,82)'],
        [0.3803921568627451, 'rgb(25,98,84)'],
        [0.3843137254901961, 'rgb(25,99,85)'],
        [0.38823529411764707, 'rgb(26,100,87)'],
        [0.39215686274509803, 'rgb(26,101,89)'],
        [0.396078431372549, 'rgb(27,102,91)'],
        [0.4, 'rgb(28,103,93)'],
        [0.403921568627451, 'rgb(29,104,94)'],
        [0.40784313725490196, 'rgb(29,104,96)'],
        [0.4117647058823529, 'rgb(30,105,98)'],
        [0.41568627450980394, 'rgb(31,106,100)'],
        [0.4196078431372549, 'rgb(32,107,102)'],
        [0.4235294117647059, 'rgb(33,108,104)'],
        [0.42745098039215684, 'rgb(33,109,105)'],
        [0.43137254901960786, 'rgb(34,110,107)'],
        [0.43529411764705883, 'rgb(35,111,109)'],
        [0.4392156862745098, 'rgb(36,112,111)'],
        [0.44313725490196076, 'rgb(37,113,113)'],
        [0.4470588235294118, 'rgb(38,113,115)'],
        [0.45098039215686275, 'rgb(39,114,117)'],
        [0.4549019607843137, 'rgb(40,115,118)'],
        [0.4588235294117647, 'rgb(41,116,120)'],
        [0.4627450980392157, 'rgb(42,117,122)'],
        [0.4666666666666667, 'rgb(43,118,124)'],
        [0.47058823529411764, 'rgb(44,119,126)'],
        [0.4745098039215686, 'rgb(45,120,128)'],
        [0.47843137254901963, 'rgb(46,120,130)'],
        [0.4823529411764706, 'rgb(47,121,132)'],
        [0.48627450980392156, 'rgb(48,122,134)'],
        [0.49019607843137253, 'rgb(49,123,136)'],
        [0.49411764705882355, 'rgb(51,124,137)'],
        [0.4980392156862745, 'rgb(52,125,139)'],
        [0.5019607843137255, 'rgb(53,126,141)'],
        [0.5058823529411764, 'rgb(54,127,143)'],
        [0.5098039215686274, 'rgb(55,127,145)'],
        [0.5137254901960784, 'rgb(56,128,147)'],
        [0.5176470588235295, 'rgb(58,129,149)'],
        [0.5215686274509804, 'rgb(59,130,151)'],
        [0.5254901960784314, 'rgb(60,131,153)'],
        [0.5294117647058824, 'rgb(61,132,155)'],
        [0.5333333333333333, 'rgb(63,132,157)'],
        [0.5372549019607843, 'rgb(64,133,159)'],
        [0.5411764705882353, 'rgb(65,134,161)'],
        [0.5450980392156862, 'rgb(67,135,163)'],
        [0.5490196078431373, 'rgb(68,136,165)'],
        [0.5529411764705883, 'rgb(69,136,167)'],
        [0.5568627450980392, 'rgb(71,137,169)'],
        [0.5607843137254902, 'rgb(72,138,171)'],
        [0.5647058823529412, 'rgb(74,139,173)'],
        [0.5686274509803921, 'rgb(75,140,175)'],
        [0.5725490196078431, 'rgb(77,140,177)'],
        [0.5764705882352941, 'rgb(78,141,179)'],
        [0.5803921568627451, 'rgb(80,142,181)'],
        [0.5843137254901961, 'rgb(81,143,183)'],
        [0.5882352941176471, 'rgb(83,143,185)'],
        [0.592156862745098, 'rgb(85,144,187)'],
        [0.596078431372549, 'rgb(86,145,189)'],
        [0.6, 'rgb(88,146,191)'],
        [0.6039215686274509, 'rgb(90,146,193)'],
        [0.6078431372549019, 'rgb(91,147,195)'],
        [0.611764705882353, 'rgb(93,148,197)'],
        [0.615686274509804, 'rgb(95,149,199)'],
        [0.6196078431372549, 'rgb(97,149,201)'],
        [0.6235294117647059, 'rgb(99,150,203)'],
        [0.6274509803921569, 'rgb(100,151,205)'],
        [0.6313725490196078, 'rgb(102,151,207)'],
        [0.6352941176470588, 'rgb(104,152,209)'],
        [0.6392156862745098, 'rgb(106,153,211)'],
        [0.6431372549019608, 'rgb(108,153,213)'],
        [0.6470588235294118, 'rgb(110,154,215)'],
        [0.6509803921568628, 'rgb(112,155,217)'],
        [0.6549019607843137, 'rgb(114,155,219)'],
        [0.6588235294117647, 'rgb(116,156,220)'],
        [0.6627450980392157, 'rgb(118,157,222)'],
        [0.6666666666666666, 'rgb(121,157,224)'],
        [0.6705882352941176, 'rgb(123,158,226)'],
        [0.6745098039215687, 'rgb(125,159,227)'],
        [0.6784313725490196, 'rgb(127,159,229)'],
        [0.6823529411764706, 'rgb(129,160,231)'],
        [0.6862745098039216, 'rgb(132,160,232)'],
        [0.6901960784313725, 'rgb(134,161,234)'],
        [0.6941176470588235, 'rgb(136,162,235)'],
        [0.6980392156862745, 'rgb(138,162,236)'],
        [0.7019607843137254, 'rgb(141,163,238)'],
        [0.7058823529411765, 'rgb(143,164,239)'],
        [0.7098039215686275, 'rgb(146,164,240)'],
        [0.7137254901960784, 'rgb(148,165,241)'],
        [0.7176470588235294, 'rgb(150,165,242)'],
        [0.7215686274509804, 'rgb(153,166,243)'],
        [0.7254901960784313, 'rgb(155,167,243)'],
        [0.7294117647058823, 'rgb(157,168,244)'],
        [0.7333333333333333, 'rgb(160,168,245)'],
        [0.7372549019607844, 'rgb(162,169,245)'],
        [0.7411764705882353, 'rgb(164,170,245)'],
        [0.7450980392156863, 'rgb(166,171,246)'],
        [0.7490196078431373, 'rgb(168,171,246)'],
        [0.7529411764705882, 'rgb(171,172,246)'],
        [0.7568627450980392, 'rgb(173,173,246)'],
        [0.7607843137254902, 'rgb(175,174,246)'],
        [0.7647058823529411, 'rgb(177,175,246)'],
        [0.7686274509803922, 'rgb(179,176,246)'],
        [0.7725490196078432, 'rgb(181,177,246)'],
        [0.7764705882352941, 'rgb(182,178,246)'],
        [0.7803921568627451, 'rgb(184,179,245)'],
        [0.7843137254901961, 'rgb(186,180,245)'],
        [0.788235294117647, 'rgb(188,181,245)'],
        [0.792156862745098, 'rgb(189,182,245)'],
        [0.796078431372549, 'rgb(191,183,244)'],
        [0.8, 'rgb(193,185,244)'],
        [0.803921568627451, 'rgb(194,186,244)'],
        [0.807843137254902, 'rgb(196,187,244)'],
        [0.8117647058823529, 'rgb(197,188,243)'],
        [0.8156862745098039, 'rgb(199,189,243)'],
        [0.8196078431372549, 'rgb(200,191,243)'],
        [0.8235294117647058, 'rgb(202,192,243)'],
        [0.8274509803921568, 'rgb(203,193,243)'],
        [0.8313725490196079, 'rgb(205,194,242)'],
        [0.8352941176470589, 'rgb(206,196,242)'],
        [0.8392156862745098, 'rgb(207,197,242)'],
        [0.8431372549019608, 'rgb(209,198,242)'],
        [0.8470588235294118, 'rgb(210,199,242)'],
        [0.8509803921568627, 'rgb(211,201,242)'],
        [0.8549019607843137, 'rgb(212,202,242)'],
        [0.8588235294117647, 'rgb(214,203,242)'],
        [0.8627450980392157, 'rgb(215,205,242)'],
        [0.8666666666666667, 'rgb(216,206,242)'],
        [0.8705882352941177, 'rgb(217,207,242)'],
        [0.8745098039215686, 'rgb(218,209,242)'],
        [0.8784313725490196, 'rgb(220,210,242)'],
        [0.8823529411764706, 'rgb(221,212,242)'],
        [0.8862745098039215, 'rgb(222,213,242)'],
        [0.8901960784313725, 'rgb(223,214,242)'],
        [0.8941176470588236, 'rgb(224,216,242)'],
        [0.8980392156862745, 'rgb(226,217,242)'],
        [0.9019607843137255, 'rgb(227,219,242)'],
        [0.9058823529411765, 'rgb(228,220,243)'],
        [0.9098039215686274, 'rgb(229,221,243)'],
        [0.9137254901960784, 'rgb(230,223,243)'],
        [0.9176470588235294, 'rgb(231,224,243)'],
        [0.9215686274509803, 'rgb(232,226,244)'],
        [0.9254901960784314, 'rgb(233,227,244)'],
        [0.9294117647058824, 'rgb(235,228,244)'],
        [0.9333333333333333, 'rgb(236,230,245)'],
        [0.9372549019607843, 'rgb(237,231,245)'],
        [0.9411764705882353, 'rgb(238,233,246)'],
        [0.9450980392156862, 'rgb(239,234,246)'],
        [0.9490196078431372, 'rgb(240,236,246)'],
        [0.9529411764705882, 'rgb(241,237,247)'],
        [0.9568627450980393, 'rgb(242,239,247)'],
        [0.9607843137254902, 'rgb(244,240,248)'],
        [0.9647058823529412, 'rgb(245,242,248)'],
        [0.9686274509803922, 'rgb(246,243,249)'],
        [0.9725490196078431, 'rgb(247,245,250)'],
        [0.9764705882352941, 'rgb(248,246,250)'],
        [0.9803921568627451, 'rgb(249,247,251)'],
        [0.984313725490196, 'rgb(251,249,252)'],
        [0.9882352941176471, 'rgb(252,250,252)'],
        [0.9921568627450981, 'rgb(253,252,253)'],
        [0.996078431372549, 'rgb(254,253,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.iceburn': [
        [0.0, 'rgb(148,241,243)'],
        [0.00392156862745098, 'rgb(145,239,242)'],
        [0.00784313725490196, 'rgb(142,237,242)'],
        [0.011764705882352941, 'rgb(139,235,241)'],
        [0.01568627450980392, 'rgb(137,232,240)'],
        [0.0196078431372549, 'rgb(134,230,239)'],
        [0.023529411764705882, 'rgb(131,228,238)'],
        [0.027450980392156862, 'rgb(128,226,238)'],
        [0.03137254901960784, 'rgb(125,223,237)'],
        [0.03529411764705882, 'rgb(123,221,236)'],
        [0.0392156862745098, 'rgb(120,219,236)'],
        [0.043137254901960784, 'rgb(117,217,235)'],
        [0.047058823529411764, 'rgb(114,214,234)'],
        [0.050980392156862744, 'rgb(111,212,234)'],
        [0.054901960784313725, 'rgb(108,210,233)'],
        [0.058823529411764705, 'rgb(106,208,232)'],
        [0.06274509803921569, 'rgb(103,206,232)'],
        [0.06666666666666667, 'rgb(100,204,231)'],
        [0.07058823529411765, 'rgb(97,202,231)'],
        [0.07450980392156863, 'rgb(94,199,230)'],
        [0.0784313725490196, 'rgb(91,197,230)'],
        [0.08235294117647059, 'rgb(88,195,229)'],
        [0.08627450980392157, 'rgb(85,193,229)'],
        [0.09019607843137255, 'rgb(82,191,229)'],
        [0.09411764705882353, 'rgb(79,189,228)'],
        [0.09803921568627451, 'rgb(76,187,228)'],
        [0.10196078431372549, 'rgb(73,185,227)'],
        [0.10588235294117647, 'rgb(70,182,227)'],
        [0.10980392156862745, 'rgb(67,180,227)'],
        [0.11372549019607843, 'rgb(64,178,227)'],
        [0.11764705882352941, 'rgb(61,176,226)'],
        [0.12156862745098039, 'rgb(58,174,226)'],
        [0.12549019607843137, 'rgb(55,172,226)'],
        [0.12941176470588237, 'rgb(52,170,226)'],
        [0.13333333333333333, 'rgb(49,168,225)'],
        [0.13725490196078433, 'rgb(46,165,225)'],
        [0.1411764705882353, 'rgb(43,163,225)'],
        [0.1450980392156863, 'rgb(40,161,225)'],
        [0.14901960784313725, 'rgb(37,159,225)'],
        [0.15294117647058825, 'rgb(35,157,224)'],
        [0.1568627450980392, 'rgb(32,154,224)'],
        [0.1607843137254902, 'rgb(30,152,224)'],
        [0.16470588235294117, 'rgb(28,150,224)'],
        [0.16862745098039217, 'rgb(26,148,224)'],
        [0.17254901960784313, 'rgb(25,145,223)'],
        [0.17647058823529413, 'rgb(24,143,223)'],
        [0.1803921568627451, 'rgb(24,141,223)'],
        [0.1843137254901961, 'rgb(24,139,222)'],
        [0.18823529411764706, 'rgb(25,136,222)'],
        [0.19215686274509805, 'rgb(26,134,221)'],
        [0.19607843137254902, 'rgb(28,131,220)'],
        [0.2, 'rgb(30,129,220)'],
        [0.20392156862745098, 'rgb(33,127,219)'],
        [0.20784313725490197, 'rgb(35,124,217)'],
        [0.21176470588235294, 'rgb(38,122,216)'],
        [0.21568627450980393, 'rgb(41,119,214)'],
        [0.2196078431372549, 'rgb(43,117,212)'],
        [0.2235294117647059, 'rgb(46,115,210)'],
        [0.22745098039215686, 'rgb(48,112,207)'],
        [0.23137254901960785, 'rgb(51,110,205)'],
        [0.23529411764705882, 'rgb(53,108,202)'],
        [0.23921568627450981, 'rgb(54,106,199)'],
        [0.24313725490196078, 'rgb(56,104,195)'],
        [0.24705882352941178, 'rgb(57,102,192)'],
        [0.25098039215686274, 'rgb(58,100,188)'],
        [0.2549019607843137, 'rgb(59,98,185)'],
        [0.25882352941176473, 'rgb(60,96,181)'],
        [0.2627450980392157, 'rgb(60,94,177)'],
        [0.26666666666666666, 'rgb(61,92,173)'],
        [0.27058823529411763, 'rgb(61,90,170)'],
        [0.27450980392156865, 'rgb(61,89,166)'],
        [0.2784313725490196, 'rgb(61,87,162)'],
        [0.2823529411764706, 'rgb(61,85,158)'],
        [0.28627450980392155, 'rgb(61,84,155)'],
        [0.2901960784313726, 'rgb(61,82,151)'],
        [0.29411764705882354, 'rgb(60,80,147)'],
        [0.2980392156862745, 'rgb(60,79,143)'],
        [0.30196078431372547, 'rgb(59,77,140)'],
        [0.3058823529411765, 'rgb(59,75,136)'],
        [0.30980392156862746, 'rgb(58,74,132)'],
        [0.3137254901960784, 'rgb(58,72,129)'],
        [0.3176470588235294, 'rgb(57,71,125)'],
        [0.3215686274509804, 'rgb(56,69,122)'],
        [0.3254901960784314, 'rgb(55,67,118)'],
        [0.32941176470588235, 'rgb(54,66,115)'],
        [0.3333333333333333, 'rgb(54,64,112)'],
        [0.33725490196078434, 'rgb(53,63,108)'],
        [0.3411764705882353, 'rgb(52,61,105)'],
        [0.34509803921568627, 'rgb(51,60,102)'],
        [0.34901960784313724, 'rgb(50,58,98)'],
        [0.35294117647058826, 'rgb(49,56,95)'],
        [0.3568627450980392, 'rgb(48,55,92)'],
        [0.3607843137254902, 'rgb(47,53,89)'],
        [0.36470588235294116, 'rgb(45,52,86)'],
        [0.3686274509803922, 'rgb(44,50,82)'],
        [0.37254901960784315, 'rgb(43,49,79)'],
        [0.3764705882352941, 'rgb(42,47,76)'],
        [0.3803921568627451, 'rgb(41,45,73)'],
        [0.3843137254901961, 'rgb(39,44,70)'],
        [0.38823529411764707, 'rgb(38,42,67)'],
        [0.39215686274509803, 'rgb(37,41,64)'],
        [0.396078431372549, 'rgb(36,39,62)'],
        [0.4, 'rgb(34,37,59)'],
        [0.403921568627451, 'rgb(33,36,56)'],
        [0.40784313725490196, 'rgb(31,34,53)'],
        [0.4117647058823529, 'rgb(30,33,50)'],
        [0.41568627450980394, 'rgb(29,31,47)'],
        [0.4196078431372549, 'rgb(27,29,45)'],
        [0.4235294117647059, 'rgb(26,28,42)'],
        [0.42745098039215684, 'rgb(24,26,39)'],
        [0.43137254901960786, 'rgb(23,24,37)'],
        [0.43529411764705883, 'rgb(21,22,34)'],
        [0.4392156862745098, 'rgb(20,21,31)'],
        [0.44313725490196076, 'rgb(18,19,28)'],
        [0.4470588235294118, 'rgb(16,17,26)'],
        [0.45098039215686275, 'rgb(15,15,23)'],
        [0.4549019607843137, 'rgb(13,14,21)'],
        [0.4588235294117647, 'rgb(11,12,18)'],
        [0.4627450980392157, 'rgb(9,10,15)'],
        [0.4666666666666667, 'rgb(8,8,13)'],
        [0.47058823529411764, 'rgb(6,6,10)'],
        [0.4745098039215686, 'rgb(5,5,7)'],
        [0.47843137254901963, 'rgb(4,4,5)'],
        [0.4823529411764706, 'rgb(2,3,4)'],
        [0.48627450980392156, 'rgb(2,2,2)'],
        [0.49019607843137253, 'rgb(1,1,1)'],
        [0.49411764705882355, 'rgb(0,0,0)'],
        [0.4980392156862745, 'rgb(0,0,0)'],
        [0.5019607843137255, 'rgb(0,0,0)'],
        [0.5058823529411764, 'rgb(0,0,0)'],
        [0.5098039215686274, 'rgb(1,1,1)'],
        [0.5137254901960784, 'rgb(2,1,2)'],
        [0.5176470588235295, 'rgb(4,2,2)'],
        [0.5215686274509804, 'rgb(6,3,3)'],
        [0.5254901960784314, 'rgb(8,4,5)'],
        [0.5294117647058824, 'rgb(11,5,6)'],
        [0.5333333333333333, 'rgb(13,6,7)'],
        [0.5372549019607843, 'rgb(16,8,9)'],
        [0.5411764705882353, 'rgb(19,9,11)'],
        [0.5450980392156862, 'rgb(21,10,13)'],
        [0.5490196078431373, 'rgb(24,12,14)'],
        [0.5529411764705883, 'rgb(27,13,16)'],
        [0.5568627450980392, 'rgb(29,15,17)'],
        [0.5607843137254902, 'rgb(32,16,19)'],
        [0.5647058823529412, 'rgb(34,17,20)'],
        [0.5686274509803921, 'rgb(37,19,22)'],
        [0.5725490196078431, 'rgb(40,20,23)'],
        [0.5764705882352941, 'rgb(42,21,24)'],
        [0.5803921568627451, 'rgb(45,22,26)'],
        [0.5843137254901961, 'rgb(48,23,27)'],
        [0.5882352941176471, 'rgb(50,25,28)'],
        [0.592156862745098, 'rgb(53,26,29)'],
        [0.596078431372549, 'rgb(56,27,31)'],
        [0.6, 'rgb(58,28,32)'],
        [0.6039215686274509, 'rgb(61,29,33)'],
        [0.6078431372549019, 'rgb(64,30,34)'],
        [0.611764705882353, 'rgb(66,31,35)'],
        [0.615686274509804, 'rgb(69,32,36)'],
        [0.6196078431372549, 'rgb(72,33,37)'],
        [0.6235294117647059, 'rgb(74,34,37)'],
        [0.6274509803921569, 'rgb(77,35,38)'],
        [0.6313725490196078, 'rgb(80,36,39)'],
        [0.6352941176470588, 'rgb(82,37,40)'],
        [0.6392156862745098, 'rgb(85,38,40)'],
        [0.6431372549019608, 'rgb(88,39,41)'],
        [0.6470588235294118, 'rgb(90,40,42)'],
        [0.6509803921568628, 'rgb(93,41,42)'],
        [0.6549019607843137, 'rgb(96,42,43)'],
        [0.6588235294117647, 'rgb(99,43,43)'],
        [0.6627450980392157, 'rgb(101,44,43)'],
        [0.6666666666666666, 'rgb(104,44,44)'],
        [0.6705882352941176, 'rgb(107,45,44)'],
        [0.6745098039215687, 'rgb(109,46,44)'],
        [0.6784313725490196, 'rgb(112,47,44)'],
        [0.6823529411764706, 'rgb(115,48,44)'],
        [0.6862745098039216, 'rgb(118,49,44)'],
        [0.6901960784313725, 'rgb(120,50,44)'],
        [0.6941176470588235, 'rgb(123,51,44)'],
        [0.6980392156862745, 'rgb(126,52,44)'],
        [0.7019607843137254, 'rgb(128,53,44)'],
        [0.7058823529411765, 'rgb(131,55,44)'],
        [0.7098039215686275, 'rgb(133,56,43)'],
        [0.7137254901960784, 'rgb(136,57,43)'],
        [0.7176470588235294, 'rgb(138,58,43)'],
        [0.7215686274509804, 'rgb(141,59,42)'],
        [0.7254901960784313, 'rgb(143,61,42)'],
        [0.7294117647058823, 'rgb(146,62,41)'],
        [0.7333333333333333, 'rgb(148,63,41)'],
        [0.7372549019607844, 'rgb(151,65,40)'],
        [0.7411764705882353, 'rgb(153,66,39)'],
        [0.7450980392156863, 'rgb(156,67,39)'],
        [0.7490196078431373, 'rgb(158,69,38)'],
        [0.7529411764705882, 'rgb(160,70,37)'],
        [0.7568627450980392, 'rgb(162,72,37)'],
        [0.7607843137254902, 'rgb(165,74,36)'],
        [0.7647058823529411, 'rgb(167,75,35)'],
        [0.7686274509803922, 'rgb(169,77,35)'],
        [0.7725490196078432, 'rgb(171,79,34)'],
        [0.7764705882352941, 'rgb(173,81,33)'],
        [0.7803921568627451, 'rgb(175,82,32)'],
        [0.7843137254901961, 'rgb(177,84,31)'],
        [0.788235294117647, 'rgb(179,86,31)'],
        [0.792156862745098, 'rgb(181,88,30)'],
        [0.796078431372549, 'rgb(183,90,29)'],
        [0.8, 'rgb(185,92,28)'],
        [0.803921568627451, 'rgb(187,94,28)'],
        [0.807843137254902, 'rgb(188,96,27)'],
        [0.8117647058823529, 'rgb(190,98,26)'],
        [0.8156862745098039, 'rgb(192,100,25)'],
        [0.8196078431372549, 'rgb(193,103,25)'],
        [0.8235294117647058, 'rgb(195,105,24)'],
        [0.8274509803921568, 'rgb(197,107,24)'],
        [0.8313725490196079, 'rgb(198,109,23)'],
        [0.8352941176470589, 'rgb(200,111,23)'],
        [0.8392156862745098, 'rgb(202,114,22)'],
        [0.8431372549019608, 'rgb(203,116,22)'],
        [0.8470588235294118, 'rgb(205,118,21)'],
        [0.8509803921568627, 'rgb(206,121,21)'],
        [0.8549019607843137, 'rgb(207,123,21)'],
        [0.8588235294117647, 'rgb(209,125,21)'],
        [0.8627450980392157, 'rgb(210,128,21)'],
        [0.8666666666666667, 'rgb(212,130,21)'],
        [0.8705882352941177, 'rgb(213,133,21)'],
        [0.8745098039215686, 'rgb(214,135,21)'],
        [0.8784313725490196, 'rgb(216,138,22)'],
        [0.8823529411764706, 'rgb(217,140,22)'],
        [0.8862745098039215, 'rgb(218,143,23)'],
        [0.8901960784313725, 'rgb(219,145,23)'],
        [0.8941176470588236, 'rgb(220,148,24)'],
        [0.8980392156862745, 'rgb(222,150,25)'],
        [0.9019607843137255, 'rgb(223,153,26)'],
        [0.9058823529411765, 'rgb(224,155,27)'],
        [0.9098039215686274, 'rgb(225,158,28)'],
        [0.9137254901960784, 'rgb(226,161,29)'],
        [0.9176470588235294, 'rgb(227,163,31)'],
        [0.9215686274509803, 'rgb(228,166,32)'],
        [0.9254901960784314, 'rgb(229,169,33)'],
        [0.9294117647058824, 'rgb(230,171,35)'],
        [0.9333333333333333, 'rgb(231,174,36)'],
        [0.9372549019607843, 'rgb(232,177,38)'],
        [0.9411764705882353, 'rgb(233,180,39)'],
        [0.9450980392156862, 'rgb(234,182,41)'],
        [0.9490196078431372, 'rgb(235,185,43)'],
        [0.9529411764705882, 'rgb(236,188,45)'],
        [0.9568627450980393, 'rgb(237,191,46)'],
        [0.9607843137254902, 'rgb(237,193,48)'],
        [0.9647058823529412, 'rgb(238,196,50)'],
        [0.9686274509803922, 'rgb(239,199,52)'],
        [0.9725490196078431, 'rgb(240,202,54)'],
        [0.9764705882352941, 'rgb(241,205,56)'],
        [0.9803921568627451, 'rgb(241,208,58)'],
        [0.984313725490196, 'rgb(242,211,60)'],
        [0.9882352941176471, 'rgb(243,214,62)'],
        [0.9921568627450981, 'rgb(244,217,64)'],
        [0.996078431372549, 'rgb(244,220,67)'],
        [1.0, 'rgb(245,223,69)'],
    ],
    'cmr.jungle': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(1,2,1)'],
        [0.027450980392156862, 'rgb(1,2,2)'],
        [0.03137254901960784, 'rgb(2,3,2)'],
        [0.03529411764705882, 'rgb(2,4,3)'],
        [0.0392156862745098, 'rgb(2,4,4)'],
        [0.043137254901960784, 'rgb(3,5,4)'],
        [0.047058823529411764, 'rgb(3,6,5)'],
        [0.050980392156862744, 'rgb(3,7,6)'],
        [0.054901960784313725, 'rgb(4,8,6)'],
        [0.058823529411764705, 'rgb(4,10,7)'],
        [0.06274509803921569, 'rgb(5,11,8)'],
        [0.06666666666666667, 'rgb(5,12,9)'],
        [0.07058823529411765, 'rgb(5,13,10)'],
        [0.07450980392156863, 'rgb(6,14,11)'],
        [0.0784313725490196, 'rgb(6,16,12)'],
        [0.08235294117647059, 'rgb(7,17,12)'],
        [0.08627450980392157, 'rgb(7,18,13)'],
        [0.09019607843137255, 'rgb(7,19,14)'],
        [0.09411764705882353, 'rgb(8,20,15)'],
        [0.09803921568627451, 'rgb(8,22,16)'],
        [0.10196078431372549, 'rgb(9,23,17)'],
        [0.10588235294117647, 'rgb(9,24,17)'],
        [0.10980392156862745, 'rgb(9,25,18)'],
        [0.11372549019607843, 'rgb(10,26,19)'],
        [0.11764705882352941, 'rgb(10,27,19)'],
        [0.12156862745098039, 'rgb(10,29,20)'],
        [0.12549019607843137, 'rgb(11,30,21)'],
        [0.12941176470588237, 'rgb(11,31,22)'],
        [0.13333333333333333, 'rgb(11,32,22)'],
        [0.13725490196078433, 'rgb(12,33,23)'],
        [0.1411764705882353, 'rgb(12,34,23)'],
        [0.1450980392156863, 'rgb(12,35,24)'],
        [0.14901960784313725, 'rgb(12,37,25)'],
        [0.15294117647058825, 'rgb(13,38,25)'],
        [0.1568627450980392, 'rgb(13,39,26)'],
        [0.1607843137254902, 'rgb(13,40,26)'],
        [0.16470588235294117, 'rgb(13,41,27)'],
        [0.16862745098039217, 'rgb(13,42,27)'],
        [0.17254901960784313, 'rgb(13,43,28)'],
        [0.17647058823529413, 'rgb(14,44,28)'],
        [0.1803921568627451, 'rgb(14,46,29)'],
        [0.1843137254901961, 'rgb(14,47,29)'],
        [0.18823529411764706, 'rgb(14,48,30)'],
        [0.19215686274509805, 'rgb(14,49,30)'],
        [0.19607843137254902, 'rgb(14,50,31)'],
        [0.2, 'rgb(14,51,31)'],
        [0.20392156862745098, 'rgb(14,52,32)'],
        [0.20784313725490197, 'rgb(14,53,32)'],
        [0.21176470588235294, 'rgb(14,54,32)'],
        [0.21568627450980393, 'rgb(14,56,33)'],
        [0.2196078431372549, 'rgb(14,57,33)'],
        [0.2235294117647059, 'rgb(14,58,33)'],
        [0.22745098039215686, 'rgb(14,59,34)'],
        [0.23137254901960785, 'rgb(14,60,34)'],
        [0.23529411764705882, 'rgb(14,61,34)'],
        [0.23921568627450981, 'rgb(13,62,35)'],
        [0.24313725490196078, 'rgb(13,63,35)'],
        [0.24705882352941178, 'rgb(13,64,35)'],
        [0.25098039215686274, 'rgb(13,66,36)'],
        [0.2549019607843137, 'rgb(13,67,36)'],
        [0.25882352941176473, 'rgb(13,68,36)'],
        [0.2627450980392157, 'rgb(12,69,36)'],
        [0.26666666666666666, 'rgb(12,70,36)'],
        [0.27058823529411763, 'rgb(12,71,37)'],
        [0.27450980392156865, 'rgb(12,72,37)'],
        [0.2784313725490196, 'rgb(12,73,37)'],
        [0.2823529411764706, 'rgb(11,74,37)'],
        [0.28627450980392155, 'rgb(11,76,37)'],
        [0.2901960784313726, 'rgb(11,77,37)'],
        [0.29411764705882354, 'rgb(10,78,38)'],
        [0.2980392156862745, 'rgb(10,79,38)'],
        [0.30196078431372547, 'rgb(10,80,38)'],
        [0.3058823529411765, 'rgb(9,81,38)'],
        [0.30980392156862746, 'rgb(9,82,38)'],
        [0.3137254901960784, 'rgb(9,83,38)'],
        [0.3176470588235294, 'rgb(8,84,38)'],
        [0.3215686274509804, 'rgb(8,86,38)'],
        [0.3254901960784314, 'rgb(8,87,38)'],
        [0.32941176470588235, 'rgb(7,88,38)'],
        [0.3333333333333333, 'rgb(7,89,38)'],
        [0.33725490196078434, 'rgb(6,90,38)'],
        [0.3411764705882353, 'rgb(6,91,38)'],
        [0.34509803921568627, 'rgb(6,92,38)'],
        [0.34901960784313724, 'rgb(6,93,37)'],
        [0.35294117647058826, 'rgb(5,94,37)'],
        [0.3568627450980392, 'rgb(5,96,37)'],
        [0.3607843137254902, 'rgb(5,97,37)'],
        [0.36470588235294116, 'rgb(5,98,37)'],
        [0.3686274509803922, 'rgb(4,99,37)'],
        [0.37254901960784315, 'rgb(4,100,36)'],
        [0.3764705882352941, 'rgb(4,101,36)'],
        [0.3803921568627451, 'rgb(4,102,36)'],
        [0.3843137254901961, 'rgb(4,103,35)'],
        [0.38823529411764707, 'rgb(4,104,35)'],
        [0.39215686274509803, 'rgb(4,105,35)'],
        [0.396078431372549, 'rgb(4,107,34)'],
        [0.4, 'rgb(5,108,34)'],
        [0.403921568627451, 'rgb(5,109,34)'],
        [0.40784313725490196, 'rgb(5,110,33)'],
        [0.4117647058823529, 'rgb(6,111,33)'],
        [0.41568627450980394, 'rgb(6,112,32)'],
        [0.4196078431372549, 'rgb(7,113,31)'],
        [0.4235294117647059, 'rgb(8,114,31)'],
        [0.42745098039215684, 'rgb(9,115,30)'],
        [0.43137254901960786, 'rgb(10,116,30)'],
        [0.43529411764705883, 'rgb(11,117,29)'],
        [0.4392156862745098, 'rgb(13,118,28)'],
        [0.44313725490196076, 'rgb(14,120,27)'],
        [0.4470588235294118, 'rgb(15,121,26)'],
        [0.45098039215686275, 'rgb(17,122,26)'],
        [0.4549019607843137, 'rgb(18,123,25)'],
        [0.4588235294117647, 'rgb(20,124,24)'],
        [0.4627450980392157, 'rgb(22,125,22)'],
        [0.4666666666666667, 'rgb(24,126,21)'],
        [0.47058823529411764, 'rgb(25,127,20)'],
        [0.4745098039215686, 'rgb(27,128,19)'],
        [0.47843137254901963, 'rgb(29,129,17)'],
        [0.4823529411764706, 'rgb(32,130,16)'],
        [0.48627450980392156, 'rgb(34,131,14)'],
        [0.49019607843137253, 'rgb(36,132,12)'],
        [0.49411764705882355, 'rgb(39,133,10)'],
        [0.4980392156862745, 'rgb(41,134,8)'],
        [0.5019607843137255, 'rgb(44,135,6)'],
        [0.5058823529411764, 'rgb(47,135,4)'],
        [0.5098039215686274, 'rgb(50,136,3)'],
        [0.5137254901960784, 'rgb(53,137,2)'],
        [0.5176470588235295, 'rgb(56,138,1)'],
        [0.5215686274509804, 'rgb(59,138,2)'],
        [0.5254901960784314, 'rgb(63,139,2)'],
        [0.5294117647058824, 'rgb(66,140,4)'],
        [0.5333333333333333, 'rgb(68,141,6)'],
        [0.5372549019607843, 'rgb(71,141,8)'],
        [0.5411764705882353, 'rgb(74,142,11)'],
        [0.5450980392156862, 'rgb(76,143,14)'],
        [0.5490196078431373, 'rgb(79,144,17)'],
        [0.5529411764705883, 'rgb(81,144,20)'],
        [0.5568627450980392, 'rgb(83,145,22)'],
        [0.5607843137254902, 'rgb(85,146,25)'],
        [0.5647058823529412, 'rgb(87,147,27)'],
        [0.5686274509803921, 'rgb(89,147,30)'],
        [0.5725490196078431, 'rgb(91,148,32)'],
        [0.5764705882352941, 'rgb(93,149,35)'],
        [0.5803921568627451, 'rgb(95,150,37)'],
        [0.5843137254901961, 'rgb(97,150,39)'],
        [0.5882352941176471, 'rgb(99,151,41)'],
        [0.592156862745098, 'rgb(101,152,44)'],
        [0.596078431372549, 'rgb(103,153,46)'],
        [0.6, 'rgb(104,154,48)'],
        [0.6039215686274509, 'rgb(106,154,50)'],
        [0.6078431372549019, 'rgb(108,155,52)'],
        [0.611764705882353, 'rgb(110,156,54)'],
        [0.615686274509804, 'rgb(111,157,57)'],
        [0.6196078431372549, 'rgb(113,158,59)'],
        [0.6235294117647059, 'rgb(114,159,61)'],
        [0.6274509803921569, 'rgb(116,159,63)'],
        [0.6313725490196078, 'rgb(118,160,65)'],
        [0.6352941176470588, 'rgb(119,161,67)'],
        [0.6392156862745098, 'rgb(121,162,69)'],
        [0.6431372549019608, 'rgb(122,163,71)'],
        [0.6470588235294118, 'rgb(124,164,73)'],
        [0.6509803921568628, 'rgb(126,164,75)'],
        [0.6549019607843137, 'rgb(127,165,77)'],
        [0.6588235294117647, 'rgb(129,166,79)'],
        [0.6627450980392157, 'rgb(130,167,81)'],
        [0.6666666666666666, 'rgb(132,168,83)'],
        [0.6705882352941176, 'rgb(133,169,85)'],
        [0.6745098039215687, 'rgb(135,170,87)'],
        [0.6784313725490196, 'rgb(136,170,89)'],
        [0.6823529411764706, 'rgb(138,171,91)'],
        [0.6862745098039216, 'rgb(139,172,93)'],
        [0.6901960784313725, 'rgb(141,173,95)'],
        [0.6941176470588235, 'rgb(142,174,97)'],
        [0.6980392156862745, 'rgb(144,175,99)'],
        [0.7019607843137254, 'rgb(145,176,101)'],
        [0.7058823529411765, 'rgb(147,177,104)'],
        [0.7098039215686275, 'rgb(148,177,106)'],
        [0.7137254901960784, 'rgb(149,178,108)'],
        [0.7176470588235294, 'rgb(151,179,110)'],
        [0.7215686274509804, 'rgb(152,180,112)'],
        [0.7254901960784313, 'rgb(154,181,114)'],
        [0.7294117647058823, 'rgb(155,182,116)'],
        [0.7333333333333333, 'rgb(157,183,118)'],
        [0.7372549019607844, 'rgb(158,184,120)'],
        [0.7411764705882353, 'rgb(160,185,122)'],
        [0.7450980392156863, 'rgb(161,186,124)'],
        [0.7490196078431373, 'rgb(162,187,126)'],
        [0.7529411764705882, 'rgb(164,188,128)'],
        [0.7568627450980392, 'rgb(165,188,130)'],
        [0.7607843137254902, 'rgb(167,189,132)'],
        [0.7647058823529411, 'rgb(168,190,134)'],
        [0.7686274509803922, 'rgb(170,191,136)'],
        [0.7725490196078432, 'rgb(171,192,138)'],
        [0.7764705882352941, 'rgb(172,193,140)'],
        [0.7803921568627451, 'rgb(174,194,142)'],
        [0.7843137254901961, 'rgb(175,195,144)'],
        [0.788235294117647, 'rgb(177,196,146)'],
        [0.792156862745098, 'rgb(178,197,148)'],
        [0.796078431372549, 'rgb(179,198,150)'],
        [0.8, 'rgb(181,199,152)'],
        [0.803921568627451, 'rgb(182,200,154)'],
        [0.807843137254902, 'rgb(184,201,156)'],
        [0.8117647058823529, 'rgb(185,202,159)'],
        [0.8156862745098039, 'rgb(187,203,161)'],
        [0.8196078431372549, 'rgb(188,204,163)'],
        [0.8235294117647058, 'rgb(189,205,165)'],
        [0.8274509803921568, 'rgb(191,206,167)'],
        [0.8313725490196079, 'rgb(192,207,169)'],
        [0.8352941176470589, 'rgb(194,208,171)'],
        [0.8392156862745098, 'rgb(195,209,173)'],
        [0.8431372549019608, 'rgb(196,210,175)'],
        [0.8470588235294118, 'rgb(198,211,177)'],
        [0.8509803921568627, 'rgb(199,212,179)'],
        [0.8549019607843137, 'rgb(201,213,181)'],
        [0.8588235294117647, 'rgb(202,214,183)'],
        [0.8627450980392157, 'rgb(204,215,185)'],
        [0.8666666666666667, 'rgb(205,216,187)'],
        [0.8705882352941177, 'rgb(206,217,189)'],
        [0.8745098039215686, 'rgb(208,218,192)'],
        [0.8784313725490196, 'rgb(209,219,194)'],
        [0.8823529411764706, 'rgb(211,220,196)'],
        [0.8862745098039215, 'rgb(212,222,198)'],
        [0.8901960784313725, 'rgb(214,223,200)'],
        [0.8941176470588236, 'rgb(215,224,202)'],
        [0.8980392156862745, 'rgb(216,225,204)'],
        [0.9019607843137255, 'rgb(218,226,206)'],
        [0.9058823529411765, 'rgb(219,227,208)'],
        [0.9098039215686274, 'rgb(221,228,210)'],
        [0.9137254901960784, 'rgb(222,229,212)'],
        [0.9176470588235294, 'rgb(224,230,214)'],
        [0.9215686274509803, 'rgb(225,231,216)'],
        [0.9254901960784314, 'rgb(227,232,218)'],
        [0.9294117647058824, 'rgb(228,234,220)'],
        [0.9333333333333333, 'rgb(229,235,222)'],
        [0.9372549019607843, 'rgb(231,236,224)'],
        [0.9411764705882353, 'rgb(232,237,226)'],
        [0.9450980392156862, 'rgb(234,238,228)'],
        [0.9490196078431372, 'rgb(235,239,230)'],
        [0.9529411764705882, 'rgb(237,240,232)'],
        [0.9568627450980393, 'rgb(238,242,234)'],
        [0.9607843137254902, 'rgb(240,243,236)'],
        [0.9647058823529412, 'rgb(241,244,238)'],
        [0.9686274509803922, 'rgb(243,245,240)'],
        [0.9725490196078431, 'rgb(244,246,242)'],
        [0.9764705882352941, 'rgb(246,248,244)'],
        [0.9803921568627451, 'rgb(248,249,246)'],
        [0.984313725490196, 'rgb(249,250,248)'],
        [0.9882352941176471, 'rgb(251,251,250)'],
        [0.9921568627450981, 'rgb(252,252,251)'],
        [0.996078431372549, 'rgb(254,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.lavender': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,0)'],
        [0.01568627450980392, 'rgb(1,0,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(2,1,1)'],
        [0.027450980392156862, 'rgb(2,1,2)'],
        [0.03137254901960784, 'rgb(3,1,2)'],
        [0.03529411764705882, 'rgb(4,1,3)'],
        [0.0392156862745098, 'rgb(5,2,3)'],
        [0.043137254901960784, 'rgb(6,2,4)'],
        [0.047058823529411764, 'rgb(7,2,5)'],
        [0.050980392156862744, 'rgb(8,2,6)'],
        [0.054901960784313725, 'rgb(9,3,7)'],
        [0.058823529411764705, 'rgb(10,3,8)'],
        [0.06274509803921569, 'rgb(12,3,9)'],
        [0.06666666666666667, 'rgb(13,4,10)'],
        [0.07058823529411765, 'rgb(15,4,12)'],
        [0.07450980392156863, 'rgb(16,4,13)'],
        [0.0784313725490196, 'rgb(17,4,14)'],
        [0.08235294117647059, 'rgb(19,5,16)'],
        [0.08627450980392157, 'rgb(20,5,17)'],
        [0.09019607843137255, 'rgb(21,5,18)'],
        [0.09411764705882353, 'rgb(23,6,20)'],
        [0.09803921568627451, 'rgb(24,6,21)'],
        [0.10196078431372549, 'rgb(26,6,22)'],
        [0.10588235294117647, 'rgb(27,6,24)'],
        [0.10980392156862745, 'rgb(28,7,25)'],
        [0.11372549019607843, 'rgb(30,7,27)'],
        [0.11764705882352941, 'rgb(31,7,28)'],
        [0.12156862745098039, 'rgb(32,7,30)'],
        [0.12549019607843137, 'rgb(34,7,31)'],
        [0.12941176470588237, 'rgb(35,8,33)'],
        [0.13333333333333333, 'rgb(36,8,34)'],
        [0.13725490196078433, 'rgb(38,8,36)'],
        [0.1411764705882353, 'rgb(39,8,38)'],
        [0.1450980392156863, 'rgb(40,8,39)'],
        [0.14901960784313725, 'rgb(41,8,41)'],
        [0.15294117647058825, 'rgb(43,8,43)'],
        [0.1568627450980392, 'rgb(44,8,44)'],
        [0.1607843137254902, 'rgb(45,8,46)'],
        [0.16470588235294117, 'rgb(47,8,48)'],
        [0.16862745098039217, 'rgb(48,8,50)'],
        [0.17254901960784313, 'rgb(49,8,52)'],
        [0.17647058823529413, 'rgb(50,8,53)'],
        [0.1803921568627451, 'rgb(52,7,55)'],
        [0.1843137254901961, 'rgb(53,7,57)'],
        [0.18823529411764706, 'rgb(54,7,59)'],
        [0.19215686274509805, 'rgb(55,7,61)'],
        [0.19607843137254902, 'rgb(57,6,63)'],
        [0.2, 'rgb(58,6,66)'],
        [0.20392156862745098, 'rgb(59,6,68)'],
        [0.20784313725490197, 'rgb(60,5,70)'],
        [0.21176470588235294, 'rgb(61,5,72)'],
        [0.21568627450980393, 'rgb(62,5,74)'],
        [0.2196078431372549, 'rgb(63,4,77)'],
        [0.2235294117647059, 'rgb(64,4,79)'],
        [0.22745098039215686, 'rgb(66,4,81)'],
        [0.23137254901960785, 'rgb(67,3,84)'],
        [0.23529411764705882, 'rgb(68,3,86)'],
        [0.23921568627450981, 'rgb(68,3,88)'],
        [0.24313725490196078, 'rgb(69,2,91)'],
        [0.24705882352941178, 'rgb(70,2,93)'],
        [0.25098039215686274, 'rgb(71,2,95)'],
        [0.2549019607843137, 'rgb(72,2,98)'],
        [0.25882352941176473, 'rgb(73,2,100)'],
        [0.2627450980392157, 'rgb(73,2,103)'],
        [0.26666666666666666, 'rgb(74,3,105)'],
        [0.27058823529411763, 'rgb(75,3,107)'],
        [0.27450980392156865, 'rgb(75,4,109)'],
        [0.2784313725490196, 'rgb(76,4,111)'],
        [0.2823529411764706, 'rgb(76,5,114)'],
        [0.28627450980392155, 'rgb(77,6,116)'],
        [0.2901960784313726, 'rgb(77,8,118)'],
        [0.29411764705882354, 'rgb(77,9,120)'],
        [0.2980392156862745, 'rgb(77,11,121)'],
        [0.30196078431372547, 'rgb(78,13,123)'],
        [0.3058823529411765, 'rgb(78,15,125)'],
        [0.30980392156862746, 'rgb(78,16,127)'],
        [0.3137254901960784, 'rgb(78,18,128)'],
        [0.3176470588235294, 'rgb(78,20,130)'],
        [0.3215686274509804, 'rgb(78,22,131)'],
        [0.3254901960784314, 'rgb(78,24,132)'],
        [0.32941176470588235, 'rgb(78,26,134)'],
        [0.3333333333333333, 'rgb(78,28,135)'],
        [0.33725490196078434, 'rgb(78,29,136)'],
        [0.3411764705882353, 'rgb(77,31,137)'],
        [0.34509803921568627, 'rgb(77,33,138)'],
        [0.34901960784313724, 'rgb(77,35,139)'],
        [0.35294117647058826, 'rgb(77,37,140)'],
        [0.3568627450980392, 'rgb(76,39,140)'],
        [0.3607843137254902, 'rgb(76,40,141)'],
        [0.36470588235294116, 'rgb(75,42,142)'],
        [0.3686274509803922, 'rgb(75,44,142)'],
        [0.37254901960784315, 'rgb(75,46,143)'],
        [0.3764705882352941, 'rgb(74,47,143)'],
        [0.3803921568627451, 'rgb(74,49,144)'],
        [0.3843137254901961, 'rgb(73,51,144)'],
        [0.38823529411764707, 'rgb(73,52,145)'],
        [0.39215686274509803, 'rgb(72,54,145)'],
        [0.396078431372549, 'rgb(72,55,145)'],
        [0.4, 'rgb(71,57,145)'],
        [0.403921568627451, 'rgb(71,58,146)'],
        [0.40784313725490196, 'rgb(70,60,146)'],
        [0.4117647058823529, 'rgb(70,62,146)'],
        [0.41568627450980394, 'rgb(69,63,146)'],
        [0.4196078431372549, 'rgb(69,64,146)'],
        [0.4235294117647059, 'rgb(68,66,146)'],
        [0.42745098039215684, 'rgb(68,67,146)'],
        [0.43137254901960786, 'rgb(67,69,147)'],
        [0.43529411764705883, 'rgb(66,70,147)'],
        [0.4392156862745098, 'rgb(66,72,147)'],
        [0.44313725490196076, 'rgb(65,73,147)'],
        [0.4470588235294118, 'rgb(65,74,147)'],
        [0.45098039215686275, 'rgb(64,76,147)'],
        [0.4549019607843137, 'rgb(64,77,146)'],
        [0.4588235294117647, 'rgb(63,78,146)'],
        [0.4627450980392157, 'rgb(63,79,146)'],
        [0.4666666666666667, 'rgb(62,81,146)'],
        [0.47058823529411764, 'rgb(62,82,146)'],
        [0.4745098039215686, 'rgb(62,83,146)'],
        [0.47843137254901963, 'rgb(61,84,146)'],
        [0.4823529411764706, 'rgb(61,86,146)'],
        [0.48627450980392156, 'rgb(60,87,146)'],
        [0.49019607843137253, 'rgb(60,88,146)'],
        [0.49411764705882355, 'rgb(59,89,146)'],
        [0.4980392156862745, 'rgb(59,90,146)'],
        [0.5019607843137255, 'rgb(59,92,146)'],
        [0.5058823529411764, 'rgb(58,93,146)'],
        [0.5098039215686274, 'rgb(58,94,145)'],
        [0.5137254901960784, 'rgb(58,95,145)'],
        [0.5176470588235295, 'rgb(57,96,145)'],
        [0.5215686274509804, 'rgb(57,97,145)'],
        [0.5254901960784314, 'rgb(57,98,145)'],
        [0.5294117647058824, 'rgb(56,99,145)'],
        [0.5333333333333333, 'rgb(56,101,145)'],
        [0.5372549019607843, 'rgb(56,102,145)'],
        [0.5411764705882353, 'rgb(55,103,145)'],
        [0.5450980392156862, 'rgb(55,104,145)'],
        [0.5490196078431373, 'rgb(55,105,145)'],
        [0.5529411764705883, 'rgb(55,106,145)'],
        [0.5568627450980392, 'rgb(54,107,145)'],
        [0.5607843137254902, 'rgb(54,108,144)'],
        [0.5647058823529412, 'rgb(54,109,144)'],
        [0.5686274509803921, 'rgb(54,110,144)'],
        [0.5725490196078431, 'rgb(53,111,144)'],
        [0.5764705882352941, 'rgb(53,112,144)'],
        [0.5803921568627451, 'rgb(53,113,144)'],
        [0.5843137254901961, 'rgb(53,114,144)'],
        [0.5882352941176471, 'rgb(52,115,144)'],
        [0.592156862745098, 'rgb(52,116,144)'],
        [0.596078431372549, 'rgb(52,118,144)'],
        [0.6, 'rgb(52,119,144)'],
        [0.6039215686274509, 'rgb(52,120,144)'],
        [0.6078431372549019, 'rgb(51,121,144)'],
        [0.611764705882353, 'rgb(51,122,144)'],
        [0.615686274509804, 'rgb(51,123,144)'],
        [0.6196078431372549, 'rgb(51,124,144)'],
        [0.6235294117647059, 'rgb(50,125,144)'],
        [0.6274509803921569, 'rgb(50,126,144)'],
        [0.6313725490196078, 'rgb(50,127,144)'],
        [0.6352941176470588, 'rgb(49,128,144)'],
        [0.6392156862745098, 'rgb(49,129,144)'],
        [0.6431372549019608, 'rgb(49,130,144)'],
        [0.6470588235294118, 'rgb(49,131,144)'],
        [0.6509803921568628, 'rgb(48,132,143)'],
        [0.6549019607843137, 'rgb(48,133,143)'],
        [0.6588235294117647, 'rgb(47,134,143)'],
        [0.6627450980392157, 'rgb(47,135,143)'],
        [0.6666666666666666, 'rgb(47,136,143)'],
        [0.6705882352941176, 'rgb(46,137,143)'],
        [0.6745098039215687, 'rgb(46,138,143)'],
        [0.6784313725490196, 'rgb(45,139,143)'],
        [0.6823529411764706, 'rgb(45,140,143)'],
        [0.6862745098039216, 'rgb(44,141,143)'],
        [0.6901960784313725, 'rgb(44,142,142)'],
        [0.6941176470588235, 'rgb(43,143,142)'],
        [0.6980392156862745, 'rgb(43,145,142)'],
        [0.7019607843137254, 'rgb(42,146,142)'],
        [0.7058823529411765, 'rgb(42,147,142)'],
        [0.7098039215686275, 'rgb(41,148,142)'],
        [0.7137254901960784, 'rgb(40,149,141)'],
        [0.7176470588235294, 'rgb(40,150,141)'],
        [0.7215686274509804, 'rgb(39,151,141)'],
        [0.7254901960784313, 'rgb(38,152,141)'],
        [0.7294117647058823, 'rgb(38,153,140)'],
        [0.7333333333333333, 'rgb(37,154,140)'],
        [0.7372549019607844, 'rgb(36,155,140)'],
        [0.7411764705882353, 'rgb(35,156,140)'],
        [0.7450980392156863, 'rgb(34,157,139)'],
        [0.7490196078431373, 'rgb(34,158,139)'],
        [0.7529411764705882, 'rgb(33,159,139)'],
        [0.7568627450980392, 'rgb(32,161,138)'],
        [0.7607843137254902, 'rgb(31,162,138)'],
        [0.7647058823529411, 'rgb(30,163,137)'],
        [0.7686274509803922, 'rgb(29,164,137)'],
        [0.7725490196078432, 'rgb(29,165,136)'],
        [0.7764705882352941, 'rgb(28,166,136)'],
        [0.7803921568627451, 'rgb(27,167,136)'],
        [0.7843137254901961, 'rgb(26,168,135)'],
        [0.788235294117647, 'rgb(25,169,134)'],
        [0.792156862745098, 'rgb(24,170,134)'],
        [0.796078431372549, 'rgb(24,171,133)'],
        [0.8, 'rgb(23,172,133)'],
        [0.803921568627451, 'rgb(22,173,132)'],
        [0.807843137254902, 'rgb(22,175,131)'],
        [0.8117647058823529, 'rgb(21,176,131)'],
        [0.8156862745098039, 'rgb(21,177,130)'],
        [0.8196078431372549, 'rgb(20,178,129)'],
        [0.8235294117647058, 'rgb(20,179,129)'],
        [0.8274509803921568, 'rgb(20,180,128)'],
        [0.8313725490196079, 'rgb(20,181,127)'],
        [0.8352941176470589, 'rgb(20,182,126)'],
        [0.8392156862745098, 'rgb(20,183,125)'],
        [0.8431372549019608, 'rgb(21,184,125)'],
        [0.8470588235294118, 'rgb(22,185,124)'],
        [0.8509803921568627, 'rgb(22,186,123)'],
        [0.8549019607843137, 'rgb(23,187,122)'],
        [0.8588235294117647, 'rgb(24,188,121)'],
        [0.8627450980392157, 'rgb(26,189,120)'],
        [0.8666666666666667, 'rgb(27,190,119)'],
        [0.8705882352941177, 'rgb(28,191,118)'],
        [0.8745098039215686, 'rgb(30,192,117)'],
        [0.8784313725490196, 'rgb(32,193,116)'],
        [0.8823529411764706, 'rgb(33,194,114)'],
        [0.8862745098039215, 'rgb(35,195,113)'],
        [0.8901960784313725, 'rgb(37,196,112)'],
        [0.8941176470588236, 'rgb(39,197,111)'],
        [0.8980392156862745, 'rgb(42,198,110)'],
        [0.9019607843137255, 'rgb(44,199,108)'],
        [0.9058823529411765, 'rgb(46,200,107)'],
        [0.9098039215686274, 'rgb(48,201,106)'],
        [0.9137254901960784, 'rgb(51,202,104)'],
        [0.9176470588235294, 'rgb(53,203,103)'],
        [0.9215686274509803, 'rgb(56,204,101)'],
        [0.9254901960784314, 'rgb(58,205,100)'],
        [0.9294117647058824, 'rgb(61,206,98)'],
        [0.9333333333333333, 'rgb(64,207,97)'],
        [0.9372549019607843, 'rgb(66,208,95)'],
        [0.9411764705882353, 'rgb(69,209,94)'],
        [0.9450980392156862, 'rgb(72,210,92)'],
        [0.9490196078431372, 'rgb(75,210,91)'],
        [0.9529411764705882, 'rgb(78,211,89)'],
        [0.9568627450980393, 'rgb(81,212,87)'],
        [0.9607843137254902, 'rgb(84,213,86)'],
        [0.9647058823529412, 'rgb(87,214,84)'],
        [0.9686274509803922, 'rgb(91,214,82)'],
        [0.9725490196078431, 'rgb(94,215,81)'],
        [0.9764705882352941, 'rgb(97,216,79)'],
        [0.9803921568627451, 'rgb(101,216,77)'],
        [0.984313725490196, 'rgb(104,217,76)'],
        [0.9882352941176471, 'rgb(108,218,74)'],
        [0.9921568627450981, 'rgb(111,218,73)'],
        [0.996078431372549, 'rgb(115,219,72)'],
        [1.0, 'rgb(119,219,70)'],
    ],
    'cmr.neutral': [
        [0.0, 'rgb(0,0,0)'],
        [0.0042985541227041815, 'rgb(0,0,0)'],
        [0.008597108245408363, 'rgb(0,0,0)'],
        [0.012895662368112544, 'rgb(1,1,0)'],
        [0.017194216490816726, 'rgb(1,1,1)'],
        [0.021492770613520906, 'rgb(1,1,1)'],
        [0.02579132473622509, 'rgb(2,2,2)'],
        [0.03008987885892927, 'rgb(2,2,2)'],
        [0.03438843298163345, 'rgb(3,3,3)'],
        [0.038686987104337635, 'rgb(4,4,4)'],
        [0.04298554122704181, 'rgb(5,4,4)'],
        [0.047284095349745994, 'rgb(5,5,5)'],
        [0.05158264947245018, 'rgb(6,6,6)'],
        [0.055881203595154354, 'rgb(7,7,7)'],
        [0.06017975771785854, 'rgb(8,8,8)'],
        [0.06447831184056271, 'rgb(10,9,9)'],
        [0.0687768659632669, 'rgb(11,11,10)'],
        [0.07307542008597108, 'rgb(12,12,12)'],
        [0.07737397420867527, 'rgb(13,13,13)'],
        [0.08167252833137945, 'rgb(14,14,14)'],
        [0.08597108245408362, 'rgb(15,15,15)'],
        [0.09026963657678781, 'rgb(17,16,16)'],
        [0.09456819069949199, 'rgb(18,17,17)'],
        [0.09886674482219616, 'rgb(19,19,18)'],
        [0.10316529894490035, 'rgb(20,20,20)'],
        [0.10746385306760453, 'rgb(21,21,21)'],
        [0.11176240719030871, 'rgb(22,22,22)'],
        [0.1160609613130129, 'rgb(23,23,23)'],
        [0.12035951543571707, 'rgb(24,24,24)'],
        [0.12465806955842126, 'rgb(25,25,25)'],
        [0.12895662368112543, 'rgb(26,26,26)'],
        [0.13325517780382962, 'rgb(28,27,27)'],
        [0.1375537319265338, 'rgb(29,28,28)'],
        [0.141852286049238, 'rgb(30,29,29)'],
        [0.14615084017194216, 'rgb(31,30,30)'],
        [0.15044939429464635, 'rgb(32,31,31)'],
        [0.15474794841735054, 'rgb(33,32,32)'],
        [0.1590465025400547, 'rgb(34,33,33)'],
        [0.1633450566627589, 'rgb(35,34,34)'],
        [0.16764361078546308, 'rgb(36,35,35)'],
        [0.17194216490816724, 'rgb(37,36,36)'],
        [0.17624071903087143, 'rgb(38,37,37)'],
        [0.18053927315357562, 'rgb(39,38,38)'],
        [0.1848378272762798, 'rgb(40,39,39)'],
        [0.18913638139898398, 'rgb(41,40,40)'],
        [0.19343493552168817, 'rgb(42,41,41)'],
        [0.19773348964439233, 'rgb(43,42,42)'],
        [0.20203204376709652, 'rgb(44,43,43)'],
        [0.2063305978898007, 'rgb(45,44,44)'],
        [0.21062915201250487, 'rgb(46,45,45)'],
        [0.21492770613520906, 'rgb(47,46,46)'],
        [0.21922626025791325, 'rgb(48,47,47)'],
        [0.22352481438061741, 'rgb(49,48,48)'],
        [0.2278233685033216, 'rgb(50,49,49)'],
        [0.2321219226260258, 'rgb(51,50,50)'],
        [0.23642047674872999, 'rgb(52,51,51)'],
        [0.24071903087143415, 'rgb(53,52,52)'],
        [0.24501758499413834, 'rgb(54,53,53)'],
        [0.24931613911684253, 'rgb(55,54,54)'],
        [0.2536146932395467, 'rgb(56,55,55)'],
        [0.25791324736225085, 'rgb(57,56,56)'],
        [0.26221180148495504, 'rgb(58,57,57)'],
        [0.26651035560765923, 'rgb(59,58,58)'],
        [0.2708089097303634, 'rgb(60,59,59)'],
        [0.2751074638530676, 'rgb(61,60,60)'],
        [0.2794060179757718, 'rgb(62,61,61)'],
        [0.283704572098476, 'rgb(63,62,62)'],
        [0.28800312622118013, 'rgb(64,63,63)'],
        [0.2923016803438843, 'rgb(65,64,64)'],
        [0.2966002344665885, 'rgb(66,65,65)'],
        [0.3008987885892927, 'rgb(67,66,66)'],
        [0.3051973427119969, 'rgb(68,67,67)'],
        [0.3094958968347011, 'rgb(69,68,68)'],
        [0.3137944509574052, 'rgb(70,69,69)'],
        [0.3180930050801094, 'rgb(71,70,70)'],
        [0.3223915592028136, 'rgb(72,71,71)'],
        [0.3266901133255178, 'rgb(73,72,72)'],
        [0.330988667448222, 'rgb(74,73,73)'],
        [0.33528722157092616, 'rgb(75,74,74)'],
        [0.3395857756936303, 'rgb(76,75,75)'],
        [0.3438843298163345, 'rgb(77,76,76)'],
        [0.3481828839390387, 'rgb(78,77,77)'],
        [0.35248143806174287, 'rgb(79,78,78)'],
        [0.35677999218444706, 'rgb(80,79,79)'],
        [0.36107854630715125, 'rgb(81,80,80)'],
        [0.36537710042985544, 'rgb(82,81,81)'],
        [0.3696756545525596, 'rgb(83,82,82)'],
        [0.37397420867526376, 'rgb(84,83,83)'],
        [0.37827276279796795, 'rgb(85,84,84)'],
        [0.38257131692067214, 'rgb(86,85,85)'],
        [0.38686987104337633, 'rgb(87,86,86)'],
        [0.3911684251660805, 'rgb(88,87,87)'],
        [0.39546697928878466, 'rgb(89,88,88)'],
        [0.39976553341148885, 'rgb(90,89,89)'],
        [0.40406408753419304, 'rgb(91,90,90)'],
        [0.40836264165689723, 'rgb(91,91,91)'],
        [0.4126611957796014, 'rgb(93,92,92)'],
        [0.4169597499023056, 'rgb(94,93,93)'],
        [0.42125830402500974, 'rgb(95,94,94)'],
        [0.42555685814771393, 'rgb(96,95,95)'],
        [0.4298554122704181, 'rgb(97,96,96)'],
        [0.4341539663931223, 'rgb(98,97,97)'],
        [0.4384525205158265, 'rgb(99,98,98)'],
        [0.4427510746385307, 'rgb(100,99,99)'],
        [0.44704962876123483, 'rgb(101,100,100)'],
        [0.451348182883939, 'rgb(102,101,101)'],
        [0.4556467370066432, 'rgb(103,102,102)'],
        [0.4599452911293474, 'rgb(104,103,103)'],
        [0.4642438452520516, 'rgb(105,104,104)'],
        [0.4685423993747558, 'rgb(106,105,105)'],
        [0.47284095349745997, 'rgb(107,106,106)'],
        [0.4771395076201641, 'rgb(108,107,107)'],
        [0.4814380617428683, 'rgb(109,108,108)'],
        [0.4857366158655725, 'rgb(110,109,109)'],
        [0.4900351699882767, 'rgb(111,110,110)'],
        [0.49433372411098087, 'rgb(112,111,111)'],
        [0.49863227823368506, 'rgb(113,112,112)'],
        [0.5029308323563892, 'rgb(114,113,113)'],
        [0.5072293864790934, 'rgb(115,114,114)'],
        [0.5115279406017976, 'rgb(116,115,115)'],
        [0.5158264947245017, 'rgb(117,116,116)'],
        [0.5201250488472059, 'rgb(118,118,117)'],
        [0.5244236029699101, 'rgb(119,119,119)'],
        [0.5287221570926143, 'rgb(120,120,120)'],
        [0.5330207112153185, 'rgb(121,121,121)'],
        [0.5373192653380227, 'rgb(122,122,122)'],
        [0.5416178194607268, 'rgb(123,123,123)'],
        [0.545916373583431, 'rgb(124,124,124)'],
        [0.5502149277061352, 'rgb(125,125,125)'],
        [0.5545134818288394, 'rgb(126,126,126)'],
        [0.5588120359515436, 'rgb(127,127,127)'],
        [0.5631105900742478, 'rgb(129,128,128)'],
        [0.567409144196952, 'rgb(130,129,129)'],
        [0.5717076983196561, 'rgb(131,130,130)'],
        [0.5760062524423603, 'rgb(132,131,131)'],
        [0.5803048065650644, 'rgb(133,132,132)'],
        [0.5846033606877686, 'rgb(134,133,133)'],
        [0.5889019148104728, 'rgb(135,135,134)'],
        [0.593200468933177, 'rgb(136,136,136)'],
        [0.5974990230558812, 'rgb(137,137,137)'],
        [0.6017975771785854, 'rgb(138,138,138)'],
        [0.6060961313012896, 'rgb(139,139,139)'],
        [0.6103946854239938, 'rgb(140,140,140)'],
        [0.614693239546698, 'rgb(141,141,141)'],
        [0.6189917936694022, 'rgb(143,142,142)'],
        [0.6232903477921062, 'rgb(144,143,143)'],
        [0.6275889019148104, 'rgb(145,144,144)'],
        [0.6318874560375146, 'rgb(146,146,145)'],
        [0.6361860101602188, 'rgb(147,147,147)'],
        [0.640484564282923, 'rgb(148,148,148)'],
        [0.6447831184056272, 'rgb(149,149,149)'],
        [0.6490816725283314, 'rgb(150,150,150)'],
        [0.6533802266510356, 'rgb(151,151,151)'],
        [0.6576787807737398, 'rgb(153,152,152)'],
        [0.661977334896444, 'rgb(154,153,153)'],
        [0.6662758890191481, 'rgb(155,154,154)'],
        [0.6705744431418523, 'rgb(156,156,156)'],
        [0.6748729972645565, 'rgb(157,157,157)'],
        [0.6791715513872606, 'rgb(158,158,158)'],
        [0.6834701055099648, 'rgb(159,159,159)'],
        [0.687768659632669, 'rgb(161,160,160)'],
        [0.6920672137553732, 'rgb(162,161,161)'],
        [0.6963657678780774, 'rgb(163,162,162)'],
        [0.7006643220007815, 'rgb(164,164,164)'],
        [0.7049628761234857, 'rgb(165,165,165)'],
        [0.7092614302461899, 'rgb(166,166,166)'],
        [0.7135599843688941, 'rgb(167,167,167)'],
        [0.7178585384915983, 'rgb(169,168,168)'],
        [0.7221570926143025, 'rgb(170,169,169)'],
        [0.7264556467370067, 'rgb(171,171,171)'],
        [0.7307542008597109, 'rgb(172,172,172)'],
        [0.735052754982415, 'rgb(173,173,173)'],
        [0.7393513091051191, 'rgb(175,174,174)'],
        [0.7436498632278233, 'rgb(176,175,175)'],
        [0.7479484173505275, 'rgb(177,177,177)'],
        [0.7522469714732317, 'rgb(178,178,178)'],
        [0.7565455255959359, 'rgb(179,179,179)'],
        [0.7608440797186401, 'rgb(180,180,180)'],
        [0.7651426338413443, 'rgb(182,181,181)'],
        [0.7694411879640485, 'rgb(183,183,183)'],
        [0.7737397420867527, 'rgb(184,184,184)'],
        [0.7780382962094569, 'rgb(185,185,185)'],
        [0.782336850332161, 'rgb(187,186,186)'],
        [0.7866354044548651, 'rgb(188,188,188)'],
        [0.7909339585775693, 'rgb(189,189,189)'],
        [0.7952325127002735, 'rgb(190,190,190)'],
        [0.7995310668229777, 'rgb(192,191,191)'],
        [0.8038296209456819, 'rgb(193,193,193)'],
        [0.8081281750683861, 'rgb(194,194,194)'],
        [0.8124267291910903, 'rgb(195,195,195)'],
        [0.8167252833137945, 'rgb(197,196,196)'],
        [0.8210238374364986, 'rgb(198,198,198)'],
        [0.8253223915592028, 'rgb(199,199,199)'],
        [0.829620945681907, 'rgb(200,200,200)'],
        [0.8339194998046112, 'rgb(202,201,201)'],
        [0.8382180539273154, 'rgb(203,203,203)'],
        [0.8425166080500195, 'rgb(204,204,204)'],
        [0.8468151621727237, 'rgb(205,205,205)'],
        [0.8511137162954279, 'rgb(207,207,207)'],
        [0.8554122704181321, 'rgb(208,208,208)'],
        [0.8597108245408362, 'rgb(209,209,209)'],
        [0.8640093786635404, 'rgb(211,211,211)'],
        [0.8683079327862446, 'rgb(212,212,212)'],
        [0.8726064869089488, 'rgb(213,213,213)'],
        [0.876905041031653, 'rgb(215,215,215)'],
        [0.8812035951543572, 'rgb(216,216,216)'],
        [0.8855021492770614, 'rgb(217,217,217)'],
        [0.8898007033997656, 'rgb(219,219,219)'],
        [0.8940992575224697, 'rgb(220,220,220)'],
        [0.8983978116451738, 'rgb(221,221,221)'],
        [0.902696365767878, 'rgb(223,223,223)'],
        [0.9069949198905822, 'rgb(224,224,224)'],
        [0.9112934740132864, 'rgb(225,225,225)'],
        [0.9155920281359906, 'rgb(227,227,227)'],
        [0.9198905822586948, 'rgb(228,228,228)'],
        [0.924189136381399, 'rgb(230,230,230)'],
        [0.9284876905041032, 'rgb(231,231,231)'],
        [0.9327862446268074, 'rgb(232,232,232)'],
        [0.9370847987495116, 'rgb(234,234,234)'],
        [0.9413833528722158, 'rgb(235,235,235)'],
        [0.9456819069949199, 'rgb(237,237,237)'],
        [0.949980461117624, 'rgb(238,238,238)'],
        [0.9542790152403282, 'rgb(239,239,239)'],
        [0.9585775693630324, 'rgb(241,241,241)'],
        [0.9628761234857366, 'rgb(242,242,242)'],
        [0.9671746776084408, 'rgb(244,244,244)'],
        [0.971473231731145, 'rgb(245,245,245)'],
        [0.9757717858538492, 'rgb(247,247,247)'],
        [0.9800703399765534, 'rgb(248,248,248)'],
        [0.9843688940992575, 'rgb(250,250,250)'],
        [0.9886674482219617, 'rgb(251,251,251)'],
        [0.9929660023446659, 'rgb(253,253,253)'],
        [0.9972645564673701, 'rgb(254,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.nuclear': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(1,1,2)'],
        [0.027450980392156862, 'rgb(2,1,3)'],
        [0.03137254901960784, 'rgb(2,2,4)'],
        [0.03529411764705882, 'rgb(3,2,4)'],
        [0.0392156862745098, 'rgb(4,3,6)'],
        [0.043137254901960784, 'rgb(4,3,7)'],
        [0.047058823529411764, 'rgb(5,4,8)'],
        [0.050980392156862744, 'rgb(6,4,10)'],
        [0.054901960784313725, 'rgb(7,5,11)'],
        [0.058823529411764705, 'rgb(8,5,13)'],
        [0.06274509803921569, 'rgb(9,6,15)'],
        [0.06666666666666667, 'rgb(10,7,16)'],
        [0.07058823529411765, 'rgb(11,7,18)'],
        [0.07450980392156863, 'rgb(12,8,20)'],
        [0.0784313725490196, 'rgb(13,9,22)'],
        [0.08235294117647059, 'rgb(14,10,23)'],
        [0.08627450980392157, 'rgb(15,10,25)'],
        [0.09019607843137255, 'rgb(16,11,27)'],
        [0.09411764705882353, 'rgb(17,12,28)'],
        [0.09803921568627451, 'rgb(18,13,30)'],
        [0.10196078431372549, 'rgb(19,13,32)'],
        [0.10588235294117647, 'rgb(20,14,34)'],
        [0.10980392156862745, 'rgb(21,15,36)'],
        [0.11372549019607843, 'rgb(22,16,38)'],
        [0.11764705882352941, 'rgb(23,16,39)'],
        [0.12156862745098039, 'rgb(24,17,41)'],
        [0.12549019607843137, 'rgb(25,18,43)'],
        [0.12941176470588237, 'rgb(25,19,45)'],
        [0.13333333333333333, 'rgb(26,19,47)'],
        [0.13725490196078433, 'rgb(27,20,49)'],
        [0.1411764705882353, 'rgb(28,21,51)'],
        [0.1450980392156863, 'rgb(29,21,53)'],
        [0.14901960784313725, 'rgb(29,22,55)'],
        [0.15294117647058825, 'rgb(30,23,57)'],
        [0.1568627450980392, 'rgb(31,24,59)'],
        [0.1607843137254902, 'rgb(32,24,61)'],
        [0.16470588235294117, 'rgb(32,25,63)'],
        [0.16862745098039217, 'rgb(33,26,65)'],
        [0.17254901960784313, 'rgb(33,26,67)'],
        [0.17647058823529413, 'rgb(34,27,69)'],
        [0.1803921568627451, 'rgb(34,28,71)'],
        [0.1843137254901961, 'rgb(35,29,73)'],
        [0.18823529411764706, 'rgb(35,30,76)'],
        [0.19215686274509805, 'rgb(35,30,78)'],
        [0.19607843137254902, 'rgb(36,31,80)'],
        [0.2, 'rgb(36,32,81)'],
        [0.20392156862745098, 'rgb(36,33,83)'],
        [0.20784313725490197, 'rgb(36,34,85)'],
        [0.21176470588235294, 'rgb(36,35,87)'],
        [0.21568627450980393, 'rgb(36,36,88)'],
        [0.2196078431372549, 'rgb(36,37,90)'],
        [0.2235294117647059, 'rgb(35,38,91)'],
        [0.22745098039215686, 'rgb(35,40,92)'],
        [0.23137254901960785, 'rgb(35,41,93)'],
        [0.23529411764705882, 'rgb(34,42,94)'],
        [0.23921568627450981, 'rgb(34,43,95)'],
        [0.24313725490196078, 'rgb(33,45,96)'],
        [0.24705882352941178, 'rgb(33,46,96)'],
        [0.25098039215686274, 'rgb(32,47,97)'],
        [0.2549019607843137, 'rgb(32,49,97)'],
        [0.25882352941176473, 'rgb(32,50,98)'],
        [0.2627450980392157, 'rgb(31,51,98)'],
        [0.26666666666666666, 'rgb(31,52,98)'],
        [0.27058823529411763, 'rgb(31,54,98)'],
        [0.27450980392156865, 'rgb(30,55,99)'],
        [0.2784313725490196, 'rgb(30,56,99)'],
        [0.2823529411764706, 'rgb(30,57,99)'],
        [0.28627450980392155, 'rgb(30,58,99)'],
        [0.2901960784313726, 'rgb(30,59,99)'],
        [0.29411764705882354, 'rgb(29,61,99)'],
        [0.2980392156862745, 'rgb(29,62,99)'],
        [0.30196078431372547, 'rgb(29,63,99)'],
        [0.3058823529411765, 'rgb(29,64,100)'],
        [0.30980392156862746, 'rgb(29,65,100)'],
        [0.3137254901960784, 'rgb(29,66,100)'],
        [0.3176470588235294, 'rgb(29,67,100)'],
        [0.3215686274509804, 'rgb(29,68,100)'],
        [0.3254901960784314, 'rgb(30,69,100)'],
        [0.32941176470588235, 'rgb(30,71,100)'],
        [0.3333333333333333, 'rgb(30,72,100)'],
        [0.33725490196078434, 'rgb(30,73,100)'],
        [0.3411764705882353, 'rgb(30,74,100)'],
        [0.34509803921568627, 'rgb(30,75,100)'],
        [0.34901960784313724, 'rgb(31,76,100)'],
        [0.35294117647058826, 'rgb(31,77,101)'],
        [0.3568627450980392, 'rgb(31,78,101)'],
        [0.3607843137254902, 'rgb(31,79,101)'],
        [0.36470588235294116, 'rgb(31,80,101)'],
        [0.3686274509803922, 'rgb(32,81,101)'],
        [0.37254901960784315, 'rgb(32,82,101)'],
        [0.3764705882352941, 'rgb(32,83,101)'],
        [0.3803921568627451, 'rgb(32,84,101)'],
        [0.3843137254901961, 'rgb(33,85,101)'],
        [0.38823529411764707, 'rgb(33,86,102)'],
        [0.39215686274509803, 'rgb(33,87,102)'],
        [0.396078431372549, 'rgb(33,88,102)'],
        [0.4, 'rgb(34,89,102)'],
        [0.403921568627451, 'rgb(34,90,102)'],
        [0.40784313725490196, 'rgb(34,91,102)'],
        [0.4117647058823529, 'rgb(34,92,102)'],
        [0.41568627450980394, 'rgb(35,93,102)'],
        [0.4196078431372549, 'rgb(35,94,103)'],
        [0.4235294117647059, 'rgb(35,95,103)'],
        [0.42745098039215684, 'rgb(35,96,103)'],
        [0.43137254901960786, 'rgb(35,97,103)'],
        [0.43529411764705883, 'rgb(35,98,103)'],
        [0.4392156862745098, 'rgb(35,99,103)'],
        [0.44313725490196076, 'rgb(36,100,103)'],
        [0.4470588235294118, 'rgb(36,101,103)'],
        [0.45098039215686275, 'rgb(36,103,103)'],
        [0.4549019607843137, 'rgb(36,104,104)'],
        [0.4588235294117647, 'rgb(36,105,104)'],
        [0.4627450980392157, 'rgb(36,106,104)'],
        [0.4666666666666667, 'rgb(36,107,104)'],
        [0.47058823529411764, 'rgb(36,108,104)'],
        [0.4745098039215686, 'rgb(36,109,104)'],
        [0.47843137254901963, 'rgb(36,110,104)'],
        [0.4823529411764706, 'rgb(36,111,104)'],
        [0.48627450980392156, 'rgb(36,112,104)'],
        [0.49019607843137253, 'rgb(36,113,104)'],
        [0.49411764705882355, 'rgb(35,114,104)'],
        [0.4980392156862745, 'rgb(35,115,104)'],
        [0.5019607843137255, 'rgb(35,116,104)'],
        [0.5058823529411764, 'rgb(35,117,104)'],
        [0.5098039215686274, 'rgb(35,118,104)'],
        [0.5137254901960784, 'rgb(35,119,104)'],
        [0.5176470588235295, 'rgb(34,121,103)'],
        [0.5215686274509804, 'rgb(34,122,103)'],
        [0.5254901960784314, 'rgb(34,123,103)'],
        [0.5294117647058824, 'rgb(34,124,103)'],
        [0.5333333333333333, 'rgb(34,125,103)'],
        [0.5372549019607843, 'rgb(33,126,103)'],
        [0.5411764705882353, 'rgb(33,127,102)'],
        [0.5450980392156862, 'rgb(33,128,102)'],
        [0.5490196078431373, 'rgb(32,129,102)'],
        [0.5529411764705883, 'rgb(32,130,102)'],
        [0.5568627450980392, 'rgb(32,131,101)'],
        [0.5607843137254902, 'rgb(32,133,101)'],
        [0.5647058823529412, 'rgb(31,134,101)'],
        [0.5686274509803921, 'rgb(31,135,101)'],
        [0.5725490196078431, 'rgb(31,136,100)'],
        [0.5764705882352941, 'rgb(30,137,100)'],
        [0.5803921568627451, 'rgb(30,138,99)'],
        [0.5843137254901961, 'rgb(30,139,99)'],
        [0.5882352941176471, 'rgb(30,140,99)'],
        [0.592156862745098, 'rgb(29,141,98)'],
        [0.596078431372549, 'rgb(29,143,98)'],
        [0.6, 'rgb(29,144,97)'],
        [0.6039215686274509, 'rgb(29,145,97)'],
        [0.6078431372549019, 'rgb(29,146,96)'],
        [0.611764705882353, 'rgb(28,147,96)'],
        [0.615686274509804, 'rgb(28,148,95)'],
        [0.6196078431372549, 'rgb(28,149,94)'],
        [0.6235294117647059, 'rgb(28,150,94)'],
        [0.6274509803921569, 'rgb(28,151,93)'],
        [0.6313725490196078, 'rgb(28,153,92)'],
        [0.6352941176470588, 'rgb(28,154,92)'],
        [0.6392156862745098, 'rgb(28,155,91)'],
        [0.6431372549019608, 'rgb(29,156,90)'],
        [0.6470588235294118, 'rgb(29,157,89)'],
        [0.6509803921568628, 'rgb(29,158,88)'],
        [0.6549019607843137, 'rgb(29,159,88)'],
        [0.6588235294117647, 'rgb(30,160,87)'],
        [0.6627450980392157, 'rgb(30,161,86)'],
        [0.6666666666666666, 'rgb(31,163,85)'],
        [0.6705882352941176, 'rgb(31,164,84)'],
        [0.6745098039215687, 'rgb(32,165,83)'],
        [0.6784313725490196, 'rgb(33,166,82)'],
        [0.6823529411764706, 'rgb(34,167,81)'],
        [0.6862745098039216, 'rgb(34,168,80)'],
        [0.6901960784313725, 'rgb(35,169,79)'],
        [0.6941176470588235, 'rgb(36,170,77)'],
        [0.6980392156862745, 'rgb(37,171,76)'],
        [0.7019607843137254, 'rgb(38,172,75)'],
        [0.7058823529411765, 'rgb(40,173,74)'],
        [0.7098039215686275, 'rgb(41,175,72)'],
        [0.7137254901960784, 'rgb(42,176,71)'],
        [0.7176470588235294, 'rgb(43,177,69)'],
        [0.7215686274509804, 'rgb(45,178,68)'],
        [0.7254901960784313, 'rgb(46,179,66)'],
        [0.7294117647058823, 'rgb(48,180,65)'],
        [0.7333333333333333, 'rgb(50,181,63)'],
        [0.7372549019607844, 'rgb(51,182,61)'],
        [0.7411764705882353, 'rgb(53,183,60)'],
        [0.7450980392156863, 'rgb(55,184,58)'],
        [0.7490196078431373, 'rgb(57,185,56)'],
        [0.7529411764705882, 'rgb(59,186,54)'],
        [0.7568627450980392, 'rgb(61,187,51)'],
        [0.7607843137254902, 'rgb(63,188,49)'],
        [0.7647058823529411, 'rgb(65,189,47)'],
        [0.7686274509803922, 'rgb(68,190,44)'],
        [0.7725490196078432, 'rgb(70,191,42)'],
        [0.7764705882352941, 'rgb(73,192,39)'],
        [0.7803921568627451, 'rgb(75,193,36)'],
        [0.7843137254901961, 'rgb(78,194,33)'],
        [0.788235294117647, 'rgb(81,194,30)'],
        [0.792156862745098, 'rgb(84,195,26)'],
        [0.796078431372549, 'rgb(88,196,22)'],
        [0.8, 'rgb(91,197,18)'],
        [0.803921568627451, 'rgb(95,197,14)'],
        [0.807843137254902, 'rgb(99,198,10)'],
        [0.8117647058823529, 'rgb(103,199,8)'],
        [0.8156862745098039, 'rgb(107,199,8)'],
        [0.8196078431372549, 'rgb(111,200,10)'],
        [0.8235294117647058, 'rgb(114,200,14)'],
        [0.8274509803921568, 'rgb(118,201,18)'],
        [0.8313725490196079, 'rgb(121,201,22)'],
        [0.8352941176470589, 'rgb(124,202,27)'],
        [0.8392156862745098, 'rgb(127,202,31)'],
        [0.8431372549019608, 'rgb(130,203,35)'],
        [0.8470588235294118, 'rgb(133,203,39)'],
        [0.8509803921568627, 'rgb(136,204,43)'],
        [0.8549019607843137, 'rgb(138,205,47)'],
        [0.8588235294117647, 'rgb(141,205,50)'],
        [0.8627450980392157, 'rgb(143,206,54)'],
        [0.8666666666666667, 'rgb(145,207,57)'],
        [0.8705882352941177, 'rgb(148,207,61)'],
        [0.8745098039215686, 'rgb(150,208,64)'],
        [0.8784313725490196, 'rgb(152,209,67)'],
        [0.8823529411764706, 'rgb(154,209,71)'],
        [0.8862745098039215, 'rgb(156,210,74)'],
        [0.8901960784313725, 'rgb(158,211,77)'],
        [0.8941176470588236, 'rgb(160,211,80)'],
        [0.8980392156862745, 'rgb(162,212,83)'],
        [0.9019607843137255, 'rgb(164,213,86)'],
        [0.9058823529411765, 'rgb(166,214,89)'],
        [0.9098039215686274, 'rgb(168,214,92)'],
        [0.9137254901960784, 'rgb(170,215,95)'],
        [0.9176470588235294, 'rgb(172,216,98)'],
        [0.9215686274509803, 'rgb(174,217,101)'],
        [0.9254901960784314, 'rgb(176,217,104)'],
        [0.9294117647058824, 'rgb(177,218,107)'],
        [0.9333333333333333, 'rgb(179,219,109)'],
        [0.9372549019607843, 'rgb(181,220,112)'],
        [0.9411764705882353, 'rgb(183,220,115)'],
        [0.9450980392156862, 'rgb(185,221,118)'],
        [0.9490196078431372, 'rgb(186,222,121)'],
        [0.9529411764705882, 'rgb(188,223,123)'],
        [0.9568627450980393, 'rgb(190,223,126)'],
        [0.9607843137254902, 'rgb(192,224,129)'],
        [0.9647058823529412, 'rgb(193,225,132)'],
        [0.9686274509803922, 'rgb(195,226,134)'],
        [0.9725490196078431, 'rgb(197,227,137)'],
        [0.9764705882352941, 'rgb(199,227,140)'],
        [0.9803921568627451, 'rgb(200,228,143)'],
        [0.984313725490196, 'rgb(202,229,145)'],
        [0.9882352941176471, 'rgb(204,230,148)'],
        [0.9921568627450981, 'rgb(205,231,151)'],
        [0.996078431372549, 'rgb(207,231,153)'],
        [1.0, 'rgb(209,232,156)'],
    ],
    'cmr.ocean': [
        [0.0, 'rgb(28,0,65)'],
        [0.00392156862745098, 'rgb(29,2,66)'],
        [0.00784313725490196, 'rgb(29,3,67)'],
        [0.011764705882352941, 'rgb(30,4,68)'],
        [0.01568627450980392, 'rgb(30,5,69)'],
        [0.0196078431372549, 'rgb(30,7,70)'],
        [0.023529411764705882, 'rgb(31,8,71)'],
        [0.027450980392156862, 'rgb(31,9,73)'],
        [0.03137254901960784, 'rgb(32,11,74)'],
        [0.03529411764705882, 'rgb(32,12,75)'],
        [0.0392156862745098, 'rgb(33,14,76)'],
        [0.043137254901960784, 'rgb(33,15,77)'],
        [0.047058823529411764, 'rgb(33,17,78)'],
        [0.050980392156862744, 'rgb(34,18,79)'],
        [0.054901960784313725, 'rgb(34,19,80)'],
        [0.058823529411764705, 'rgb(34,20,82)'],
        [0.06274509803921569, 'rgb(35,22,83)'],
        [0.06666666666666667, 'rgb(35,23,84)'],
        [0.07058823529411765, 'rgb(35,24,85)'],
        [0.07450980392156863, 'rgb(35,25,86)'],
        [0.0784313725490196, 'rgb(36,26,87)'],
        [0.08235294117647059, 'rgb(36,28,88)'],
        [0.08627450980392157, 'rgb(36,29,89)'],
        [0.09019607843137255, 'rgb(36,30,90)'],
        [0.09411764705882353, 'rgb(37,31,91)'],
        [0.09803921568627451, 'rgb(37,32,92)'],
        [0.10196078431372549, 'rgb(37,33,93)'],
        [0.10588235294117647, 'rgb(37,34,94)'],
        [0.10980392156862745, 'rgb(37,36,95)'],
        [0.11372549019607843, 'rgb(38,37,97)'],
        [0.11764705882352941, 'rgb(38,38,98)'],
        [0.12156862745098039, 'rgb(38,39,99)'],
        [0.12549019607843137, 'rgb(38,40,100)'],
        [0.12941176470588237, 'rgb(38,41,100)'],
        [0.13333333333333333, 'rgb(38,42,101)'],
        [0.13725490196078433, 'rgb(38,43,102)'],
        [0.1411764705882353, 'rgb(38,44,103)'],
        [0.1450980392156863, 'rgb(38,46,104)'],
        [0.14901960784313725, 'rgb(39,47,105)'],
        [0.15294117647058825, 'rgb(39,48,106)'],
        [0.1568627450980392, 'rgb(39,49,107)'],
        [0.1607843137254902, 'rgb(39,50,108)'],
        [0.16470588235294117, 'rgb(39,51,109)'],
        [0.16862745098039217, 'rgb(39,52,110)'],
        [0.17254901960784313, 'rgb(39,53,111)'],
        [0.17647058823529413, 'rgb(39,54,112)'],
        [0.1803921568627451, 'rgb(39,55,112)'],
        [0.1843137254901961, 'rgb(39,56,113)'],
        [0.18823529411764706, 'rgb(39,57,114)'],
        [0.19215686274509805, 'rgb(39,58,115)'],
        [0.19607843137254902, 'rgb(38,60,116)'],
        [0.2, 'rgb(38,61,117)'],
        [0.20392156862745098, 'rgb(38,62,117)'],
        [0.20784313725490197, 'rgb(38,63,118)'],
        [0.21176470588235294, 'rgb(38,64,119)'],
        [0.21568627450980393, 'rgb(38,65,120)'],
        [0.2196078431372549, 'rgb(38,66,120)'],
        [0.2235294117647059, 'rgb(38,67,121)'],
        [0.22745098039215686, 'rgb(38,68,122)'],
        [0.23137254901960785, 'rgb(38,69,123)'],
        [0.23529411764705882, 'rgb(38,70,123)'],
        [0.23921568627450981, 'rgb(38,71,124)'],
        [0.24313725490196078, 'rgb(38,72,125)'],
        [0.24705882352941178, 'rgb(37,73,125)'],
        [0.25098039215686274, 'rgb(37,74,126)'],
        [0.2549019607843137, 'rgb(37,75,127)'],
        [0.25882352941176473, 'rgb(37,77,127)'],
        [0.2627450980392157, 'rgb(37,78,128)'],
        [0.26666666666666666, 'rgb(37,79,129)'],
        [0.27058823529411763, 'rgb(37,80,129)'],
        [0.27450980392156865, 'rgb(37,81,130)'],
        [0.2784313725490196, 'rgb(37,82,130)'],
        [0.2823529411764706, 'rgb(37,83,131)'],
        [0.28627450980392155, 'rgb(37,84,132)'],
        [0.2901960784313726, 'rgb(37,85,132)'],
        [0.29411764705882354, 'rgb(37,86,133)'],
        [0.2980392156862745, 'rgb(37,87,133)'],
        [0.30196078431372547, 'rgb(37,88,134)'],
        [0.3058823529411765, 'rgb(37,89,134)'],
        [0.30980392156862746, 'rgb(37,90,135)'],
        [0.3137254901960784, 'rgb(37,91,136)'],
        [0.3176470588235294, 'rgb(37,92,136)'],
        [0.3215686274509804, 'rgb(37,93,137)'],
        [0.3254901960784314, 'rgb(37,94,137)'],
        [0.32941176470588235, 'rgb(37,95,138)'],
        [0.3333333333333333, 'rgb(37,96,138)'],
        [0.33725490196078434, 'rgb(37,97,139)'],
        [0.3411764705882353, 'rgb(37,98,139)'],
        [0.34509803921568627, 'rgb(37,99,140)'],
        [0.34901960784313724, 'rgb(37,100,140)'],
        [0.35294117647058826, 'rgb(37,101,141)'],
        [0.3568627450980392, 'rgb(38,102,141)'],
        [0.3607843137254902, 'rgb(38,103,142)'],
        [0.36470588235294116, 'rgb(38,104,142)'],
        [0.3686274509803922, 'rgb(38,105,142)'],
        [0.37254901960784315, 'rgb(38,106,143)'],
        [0.3764705882352941, 'rgb(39,107,143)'],
        [0.3803921568627451, 'rgb(39,108,144)'],
        [0.3843137254901961, 'rgb(39,109,144)'],
        [0.38823529411764707, 'rgb(40,110,145)'],
        [0.39215686274509803, 'rgb(40,111,145)'],
        [0.396078431372549, 'rgb(40,112,146)'],
        [0.4, 'rgb(41,113,146)'],
        [0.403921568627451, 'rgb(41,114,146)'],
        [0.40784313725490196, 'rgb(41,115,147)'],
        [0.4117647058823529, 'rgb(42,116,147)'],
        [0.41568627450980394, 'rgb(42,118,148)'],
        [0.4196078431372549, 'rgb(43,119,148)'],
        [0.4235294117647059, 'rgb(43,120,149)'],
        [0.42745098039215684, 'rgb(44,121,149)'],
        [0.43137254901960786, 'rgb(44,122,149)'],
        [0.43529411764705883, 'rgb(45,123,150)'],
        [0.4392156862745098, 'rgb(45,123,150)'],
        [0.44313725490196076, 'rgb(46,124,151)'],
        [0.4470588235294118, 'rgb(46,125,151)'],
        [0.45098039215686275, 'rgb(47,126,151)'],
        [0.4549019607843137, 'rgb(48,127,152)'],
        [0.4588235294117647, 'rgb(48,128,152)'],
        [0.4627450980392157, 'rgb(49,129,153)'],
        [0.4666666666666667, 'rgb(49,130,153)'],
        [0.47058823529411764, 'rgb(50,131,153)'],
        [0.4745098039215686, 'rgb(51,132,154)'],
        [0.47843137254901963, 'rgb(51,133,154)'],
        [0.4823529411764706, 'rgb(52,134,155)'],
        [0.48627450980392156, 'rgb(53,135,155)'],
        [0.49019607843137253, 'rgb(54,136,155)'],
        [0.49411764705882355, 'rgb(54,137,156)'],
        [0.4980392156862745, 'rgb(55,138,156)'],
        [0.5019607843137255, 'rgb(56,139,156)'],
        [0.5058823529411764, 'rgb(57,140,157)'],
        [0.5098039215686274, 'rgb(57,141,157)'],
        [0.5137254901960784, 'rgb(58,142,157)'],
        [0.5176470588235295, 'rgb(59,143,158)'],
        [0.5215686274509804, 'rgb(60,144,158)'],
        [0.5254901960784314, 'rgb(61,145,159)'],
        [0.5294117647058824, 'rgb(62,146,159)'],
        [0.5333333333333333, 'rgb(63,147,159)'],
        [0.5372549019607843, 'rgb(64,148,160)'],
        [0.5411764705882353, 'rgb(64,149,160)'],
        [0.5450980392156862, 'rgb(65,150,160)'],
        [0.5490196078431373, 'rgb(66,151,161)'],
        [0.5529411764705883, 'rgb(67,152,161)'],
        [0.5568627450980392, 'rgb(68,153,161)'],
        [0.5607843137254902, 'rgb(69,154,162)'],
        [0.5647058823529412, 'rgb(70,155,162)'],
        [0.5686274509803921, 'rgb(71,156,162)'],
        [0.5725490196078431, 'rgb(72,157,163)'],
        [0.5764705882352941, 'rgb(73,158,163)'],
        [0.5803921568627451, 'rgb(75,159,163)'],
        [0.5843137254901961, 'rgb(76,160,164)'],
        [0.5882352941176471, 'rgb(77,161,164)'],
        [0.592156862745098, 'rgb(78,162,164)'],
        [0.596078431372549, 'rgb(79,163,165)'],
        [0.6, 'rgb(80,164,165)'],
        [0.6039215686274509, 'rgb(81,165,165)'],
        [0.6078431372549019, 'rgb(83,166,166)'],
        [0.611764705882353, 'rgb(84,167,166)'],
        [0.615686274509804, 'rgb(85,168,166)'],
        [0.6196078431372549, 'rgb(86,169,167)'],
        [0.6235294117647059, 'rgb(88,170,167)'],
        [0.6274509803921569, 'rgb(89,171,167)'],
        [0.6313725490196078, 'rgb(90,172,168)'],
        [0.6352941176470588, 'rgb(92,173,168)'],
        [0.6392156862745098, 'rgb(93,174,168)'],
        [0.6431372549019608, 'rgb(95,175,169)'],
        [0.6470588235294118, 'rgb(96,175,169)'],
        [0.6509803921568628, 'rgb(97,176,169)'],
        [0.6549019607843137, 'rgb(99,177,170)'],
        [0.6588235294117647, 'rgb(100,178,170)'],
        [0.6627450980392157, 'rgb(102,179,170)'],
        [0.6666666666666666, 'rgb(104,180,171)'],
        [0.6705882352941176, 'rgb(105,181,171)'],
        [0.6745098039215687, 'rgb(107,182,172)'],
        [0.6784313725490196, 'rgb(108,183,172)'],
        [0.6823529411764706, 'rgb(110,184,172)'],
        [0.6862745098039216, 'rgb(112,185,173)'],
        [0.6901960784313725, 'rgb(114,185,173)'],
        [0.6941176470588235, 'rgb(115,186,174)'],
        [0.6980392156862745, 'rgb(117,187,174)'],
        [0.7019607843137254, 'rgb(119,188,174)'],
        [0.7058823529411765, 'rgb(121,189,175)'],
        [0.7098039215686275, 'rgb(123,190,175)'],
        [0.7137254901960784, 'rgb(125,191,176)'],
        [0.7176470588235294, 'rgb(126,191,176)'],
        [0.7215686274509804, 'rgb(128,192,177)'],
        [0.7254901960784313, 'rgb(130,193,178)'],
        [0.7294117647058823, 'rgb(132,194,178)'],
        [0.7333333333333333, 'rgb(134,195,179)'],
        [0.7372549019607844, 'rgb(136,195,179)'],
        [0.7411764705882353, 'rgb(138,196,180)'],
        [0.7450980392156863, 'rgb(140,197,181)'],
        [0.7490196078431373, 'rgb(142,198,182)'],
        [0.7529411764705882, 'rgb(144,199,182)'],
        [0.7568627450980392, 'rgb(146,199,183)'],
        [0.7607843137254902, 'rgb(148,200,184)'],
        [0.7647058823529411, 'rgb(150,201,185)'],
        [0.7686274509803922, 'rgb(152,202,185)'],
        [0.7725490196078432, 'rgb(154,203,186)'],
        [0.7764705882352941, 'rgb(156,203,187)'],
        [0.7803921568627451, 'rgb(158,204,188)'],
        [0.7843137254901961, 'rgb(159,205,189)'],
        [0.788235294117647, 'rgb(161,206,190)'],
        [0.792156862745098, 'rgb(163,207,191)'],
        [0.796078431372549, 'rgb(165,207,192)'],
        [0.8, 'rgb(167,208,193)'],
        [0.803921568627451, 'rgb(169,209,194)'],
        [0.807843137254902, 'rgb(171,210,195)'],
        [0.8117647058823529, 'rgb(173,211,196)'],
        [0.8156862745098039, 'rgb(174,211,197)'],
        [0.8196078431372549, 'rgb(176,212,198)'],
        [0.8235294117647058, 'rgb(178,213,199)'],
        [0.8274509803921568, 'rgb(180,214,200)'],
        [0.8313725490196079, 'rgb(182,215,201)'],
        [0.8352941176470589, 'rgb(183,216,202)'],
        [0.8392156862745098, 'rgb(185,216,203)'],
        [0.8431372549019608, 'rgb(187,217,205)'],
        [0.8470588235294118, 'rgb(189,218,206)'],
        [0.8509803921568627, 'rgb(191,219,207)'],
        [0.8549019607843137, 'rgb(192,220,208)'],
        [0.8588235294117647, 'rgb(194,221,209)'],
        [0.8627450980392157, 'rgb(196,222,210)'],
        [0.8666666666666667, 'rgb(198,222,211)'],
        [0.8705882352941177, 'rgb(199,223,213)'],
        [0.8745098039215686, 'rgb(201,224,214)'],
        [0.8784313725490196, 'rgb(203,225,215)'],
        [0.8823529411764706, 'rgb(205,226,216)'],
        [0.8862745098039215, 'rgb(206,227,218)'],
        [0.8901960784313725, 'rgb(208,228,219)'],
        [0.8941176470588236, 'rgb(210,229,220)'],
        [0.8980392156862745, 'rgb(212,230,221)'],
        [0.9019607843137255, 'rgb(213,230,222)'],
        [0.9058823529411765, 'rgb(215,231,224)'],
        [0.9098039215686274, 'rgb(217,232,225)'],
        [0.9137254901960784, 'rgb(218,233,226)'],
        [0.9176470588235294, 'rgb(220,234,228)'],
        [0.9215686274509803, 'rgb(222,235,229)'],
        [0.9254901960784314, 'rgb(223,236,230)'],
        [0.9294117647058824, 'rgb(225,237,231)'],
        [0.9333333333333333, 'rgb(227,238,233)'],
        [0.9372549019607843, 'rgb(229,239,234)'],
        [0.9411764705882353, 'rgb(230,240,235)'],
        [0.9450980392156862, 'rgb(232,241,237)'],
        [0.9490196078431372, 'rgb(234,242,238)'],
        [0.9529411764705882, 'rgb(235,243,239)'],
        [0.9568627450980393, 'rgb(237,244,240)'],
        [0.9607843137254902, 'rgb(239,245,242)'],
        [0.9647058823529412, 'rgb(240,246,243)'],
        [0.9686274509803922, 'rgb(242,247,244)'],
        [0.9725490196078431, 'rgb(244,248,246)'],
        [0.9764705882352941, 'rgb(245,249,247)'],
        [0.9803921568627451, 'rgb(247,250,248)'],
        [0.984313725490196, 'rgb(248,251,250)'],
        [0.9882352941176471, 'rgb(250,252,251)'],
        [0.9921568627450981, 'rgb(252,253,252)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.rainforest': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,1)'],
        [0.01568627450980392, 'rgb(1,0,1)'],
        [0.0196078431372549, 'rgb(2,1,2)'],
        [0.023529411764705882, 'rgb(3,1,2)'],
        [0.027450980392156862, 'rgb(4,1,3)'],
        [0.03137254901960784, 'rgb(5,1,4)'],
        [0.03529411764705882, 'rgb(6,2,5)'],
        [0.0392156862745098, 'rgb(8,2,6)'],
        [0.043137254901960784, 'rgb(9,2,8)'],
        [0.047058823529411764, 'rgb(11,3,9)'],
        [0.050980392156862744, 'rgb(13,3,11)'],
        [0.054901960784313725, 'rgb(15,3,13)'],
        [0.058823529411764705, 'rgb(16,3,15)'],
        [0.06274509803921569, 'rgb(18,4,17)'],
        [0.06666666666666667, 'rgb(20,4,19)'],
        [0.07058823529411765, 'rgb(21,4,21)'],
        [0.07450980392156863, 'rgb(23,4,23)'],
        [0.0784313725490196, 'rgb(25,5,25)'],
        [0.08235294117647059, 'rgb(26,5,27)'],
        [0.08627450980392157, 'rgb(28,5,30)'],
        [0.09019607843137255, 'rgb(30,5,32)'],
        [0.09411764705882353, 'rgb(31,5,34)'],
        [0.09803921568627451, 'rgb(33,5,37)'],
        [0.10196078431372549, 'rgb(34,5,39)'],
        [0.10588235294117647, 'rgb(36,5,42)'],
        [0.10980392156862745, 'rgb(38,5,44)'],
        [0.11372549019607843, 'rgb(39,5,47)'],
        [0.11764705882352941, 'rgb(41,5,50)'],
        [0.12156862745098039, 'rgb(42,5,53)'],
        [0.12549019607843137, 'rgb(43,4,55)'],
        [0.12941176470588237, 'rgb(45,4,58)'],
        [0.13333333333333333, 'rgb(46,4,61)'],
        [0.13725490196078433, 'rgb(48,4,64)'],
        [0.1411764705882353, 'rgb(49,3,68)'],
        [0.1450980392156863, 'rgb(50,3,71)'],
        [0.14901960784313725, 'rgb(51,3,74)'],
        [0.15294117647058825, 'rgb(52,2,77)'],
        [0.1568627450980392, 'rgb(54,2,80)'],
        [0.1607843137254902, 'rgb(55,2,84)'],
        [0.16470588235294117, 'rgb(56,1,87)'],
        [0.16862745098039217, 'rgb(57,1,90)'],
        [0.17254901960784313, 'rgb(58,1,94)'],
        [0.17647058823529413, 'rgb(58,1,97)'],
        [0.1803921568627451, 'rgb(59,1,100)'],
        [0.1843137254901961, 'rgb(60,1,103)'],
        [0.18823529411764706, 'rgb(60,1,107)'],
        [0.19215686274509805, 'rgb(61,1,110)'],
        [0.19607843137254902, 'rgb(61,2,113)'],
        [0.2, 'rgb(62,3,116)'],
        [0.20392156862745098, 'rgb(62,4,119)'],
        [0.20784313725490197, 'rgb(62,5,122)'],
        [0.21176470588235294, 'rgb(62,7,124)'],
        [0.21568627450980393, 'rgb(62,9,127)'],
        [0.2196078431372549, 'rgb(62,12,129)'],
        [0.2235294117647059, 'rgb(62,14,132)'],
        [0.22745098039215686, 'rgb(62,16,134)'],
        [0.23137254901960785, 'rgb(61,19,136)'],
        [0.23529411764705882, 'rgb(61,22,138)'],
        [0.23921568627450981, 'rgb(60,24,140)'],
        [0.24313725490196078, 'rgb(59,27,141)'],
        [0.24705882352941178, 'rgb(59,29,142)'],
        [0.25098039215686274, 'rgb(58,32,144)'],
        [0.2549019607843137, 'rgb(57,34,145)'],
        [0.25882352941176473, 'rgb(55,37,145)'],
        [0.2627450980392157, 'rgb(54,39,146)'],
        [0.26666666666666666, 'rgb(53,42,147)'],
        [0.27058823529411763, 'rgb(52,44,147)'],
        [0.27450980392156865, 'rgb(50,47,147)'],
        [0.2784313725490196, 'rgb(49,49,147)'],
        [0.2823529411764706, 'rgb(47,51,147)'],
        [0.28627450980392155, 'rgb(45,53,147)'],
        [0.2901960784313726, 'rgb(44,56,147)'],
        [0.29411764705882354, 'rgb(42,58,147)'],
        [0.2980392156862745, 'rgb(40,60,146)'],
        [0.30196078431372547, 'rgb(38,62,146)'],
        [0.3058823529411765, 'rgb(37,64,145)'],
        [0.30980392156862746, 'rgb(35,66,145)'],
        [0.3137254901960784, 'rgb(33,67,144)'],
        [0.3176470588235294, 'rgb(31,69,144)'],
        [0.3215686274509804, 'rgb(29,71,143)'],
        [0.3254901960784314, 'rgb(27,73,142)'],
        [0.32941176470588235, 'rgb(25,75,142)'],
        [0.3333333333333333, 'rgb(23,76,141)'],
        [0.33725490196078434, 'rgb(22,78,140)'],
        [0.3411764705882353, 'rgb(20,79,140)'],
        [0.34509803921568627, 'rgb(18,81,139)'],
        [0.34901960784313724, 'rgb(16,82,138)'],
        [0.35294117647058826, 'rgb(14,84,138)'],
        [0.3568627450980392, 'rgb(12,85,137)'],
        [0.3607843137254902, 'rgb(11,87,136)'],
        [0.36470588235294116, 'rgb(9,88,136)'],
        [0.3686274509803922, 'rgb(7,90,135)'],
        [0.37254901960784315, 'rgb(6,91,134)'],
        [0.3764705882352941, 'rgb(5,92,134)'],
        [0.3803921568627451, 'rgb(4,94,133)'],
        [0.3843137254901961, 'rgb(3,95,132)'],
        [0.38823529411764707, 'rgb(2,96,132)'],
        [0.39215686274509803, 'rgb(2,98,131)'],
        [0.396078431372549, 'rgb(1,99,131)'],
        [0.4, 'rgb(1,100,130)'],
        [0.403921568627451, 'rgb(1,101,130)'],
        [0.40784313725490196, 'rgb(1,103,129)'],
        [0.4117647058823529, 'rgb(1,104,128)'],
        [0.41568627450980394, 'rgb(1,105,128)'],
        [0.4196078431372549, 'rgb(1,106,127)'],
        [0.4235294117647059, 'rgb(2,108,127)'],
        [0.42745098039215684, 'rgb(2,109,126)'],
        [0.43137254901960786, 'rgb(2,110,126)'],
        [0.43529411764705883, 'rgb(3,111,126)'],
        [0.4392156862745098, 'rgb(3,112,125)'],
        [0.44313725490196076, 'rgb(4,114,125)'],
        [0.4470588235294118, 'rgb(4,115,124)'],
        [0.45098039215686275, 'rgb(5,116,124)'],
        [0.4549019607843137, 'rgb(5,117,123)'],
        [0.4588235294117647, 'rgb(6,118,123)'],
        [0.4627450980392157, 'rgb(7,120,122)'],
        [0.4666666666666667, 'rgb(7,121,122)'],
        [0.47058823529411764, 'rgb(8,122,121)'],
        [0.4745098039215686, 'rgb(9,123,121)'],
        [0.47843137254901963, 'rgb(9,124,120)'],
        [0.4823529411764706, 'rgb(10,126,120)'],
        [0.48627450980392156, 'rgb(11,127,119)'],
        [0.49019607843137253, 'rgb(12,128,118)'],
        [0.49411764705882355, 'rgb(12,129,118)'],
        [0.4980392156862745, 'rgb(13,130,117)'],
        [0.5019607843137255, 'rgb(14,132,116)'],
        [0.5058823529411764, 'rgb(15,133,116)'],
        [0.5098039215686274, 'rgb(16,134,115)'],
        [0.5137254901960784, 'rgb(17,135,114)'],
        [0.5176470588235295, 'rgb(18,136,114)'],
        [0.5215686274509804, 'rgb(19,138,113)'],
        [0.5254901960784314, 'rgb(20,139,112)'],
        [0.5294117647058824, 'rgb(21,140,111)'],
        [0.5333333333333333, 'rgb(22,141,110)'],
        [0.5372549019607843, 'rgb(24,142,109)'],
        [0.5411764705882353, 'rgb(25,143,108)'],
        [0.5450980392156862, 'rgb(26,145,107)'],
        [0.5490196078431373, 'rgb(28,146,106)'],
        [0.5529411764705883, 'rgb(30,147,105)'],
        [0.5568627450980392, 'rgb(31,148,104)'],
        [0.5607843137254902, 'rgb(33,149,103)'],
        [0.5647058823529412, 'rgb(35,150,101)'],
        [0.5686274509803921, 'rgb(37,152,100)'],
        [0.5725490196078431, 'rgb(39,153,99)'],
        [0.5764705882352941, 'rgb(41,154,97)'],
        [0.5803921568627451, 'rgb(43,155,96)'],
        [0.5843137254901961, 'rgb(45,156,94)'],
        [0.5882352941176471, 'rgb(47,157,93)'],
        [0.592156862745098, 'rgb(50,158,91)'],
        [0.596078431372549, 'rgb(52,159,90)'],
        [0.6, 'rgb(54,160,88)'],
        [0.6039215686274509, 'rgb(57,161,86)'],
        [0.6078431372549019, 'rgb(59,163,84)'],
        [0.611764705882353, 'rgb(62,164,82)'],
        [0.615686274509804, 'rgb(65,165,80)'],
        [0.6196078431372549, 'rgb(67,166,78)'],
        [0.6235294117647059, 'rgb(70,167,76)'],
        [0.6274509803921569, 'rgb(73,167,74)'],
        [0.6313725490196078, 'rgb(76,168,72)'],
        [0.6352941176470588, 'rgb(79,169,70)'],
        [0.6392156862745098, 'rgb(82,170,67)'],
        [0.6431372549019608, 'rgb(85,171,65)'],
        [0.6470588235294118, 'rgb(88,172,63)'],
        [0.6509803921568628, 'rgb(92,173,60)'],
        [0.6549019607843137, 'rgb(95,174,57)'],
        [0.6588235294117647, 'rgb(98,174,55)'],
        [0.6627450980392157, 'rgb(102,175,52)'],
        [0.6666666666666666, 'rgb(105,176,49)'],
        [0.6705882352941176, 'rgb(108,176,46)'],
        [0.6745098039215687, 'rgb(112,177,43)'],
        [0.6784313725490196, 'rgb(116,178,39)'],
        [0.6823529411764706, 'rgb(119,178,36)'],
        [0.6862745098039216, 'rgb(123,179,33)'],
        [0.6901960784313725, 'rgb(127,179,29)'],
        [0.6941176470588235, 'rgb(131,180,25)'],
        [0.6980392156862745, 'rgb(134,180,21)'],
        [0.7019607843137254, 'rgb(138,181,17)'],
        [0.7058823529411765, 'rgb(142,181,13)'],
        [0.7098039215686275, 'rgb(146,181,9)'],
        [0.7137254901960784, 'rgb(150,182,5)'],
        [0.7176470588235294, 'rgb(153,182,3)'],
        [0.7215686274509804, 'rgb(157,182,2)'],
        [0.7254901960784313, 'rgb(161,183,1)'],
        [0.7294117647058823, 'rgb(164,183,2)'],
        [0.7333333333333333, 'rgb(168,183,5)'],
        [0.7372549019607844, 'rgb(171,183,8)'],
        [0.7411764705882353, 'rgb(175,184,12)'],
        [0.7450980392156863, 'rgb(178,184,17)'],
        [0.7490196078431373, 'rgb(181,184,21)'],
        [0.7529411764705882, 'rgb(184,185,26)'],
        [0.7568627450980392, 'rgb(187,185,30)'],
        [0.7607843137254902, 'rgb(190,185,34)'],
        [0.7647058823529411, 'rgb(193,186,38)'],
        [0.7686274509803922, 'rgb(195,186,42)'],
        [0.7725490196078432, 'rgb(198,187,46)'],
        [0.7764705882352941, 'rgb(200,187,51)'],
        [0.7803921568627451, 'rgb(203,188,54)'],
        [0.7843137254901961, 'rgb(205,188,58)'],
        [0.788235294117647, 'rgb(207,189,62)'],
        [0.792156862745098, 'rgb(210,189,66)'],
        [0.796078431372549, 'rgb(212,190,70)'],
        [0.8, 'rgb(214,191,74)'],
        [0.803921568627451, 'rgb(216,191,78)'],
        [0.807843137254902, 'rgb(218,192,82)'],
        [0.8117647058823529, 'rgb(220,193,86)'],
        [0.8156862745098039, 'rgb(222,193,90)'],
        [0.8196078431372549, 'rgb(224,194,94)'],
        [0.8235294117647058, 'rgb(225,195,97)'],
        [0.8274509803921568, 'rgb(227,195,101)'],
        [0.8313725490196079, 'rgb(229,196,105)'],
        [0.8352941176470589, 'rgb(231,197,109)'],
        [0.8392156862745098, 'rgb(232,198,113)'],
        [0.8431372549019608, 'rgb(234,199,117)'],
        [0.8470588235294118, 'rgb(235,200,121)'],
        [0.8509803921568627, 'rgb(237,200,125)'],
        [0.8549019607843137, 'rgb(238,201,129)'],
        [0.8588235294117647, 'rgb(239,202,132)'],
        [0.8627450980392157, 'rgb(241,203,136)'],
        [0.8666666666666667, 'rgb(242,204,140)'],
        [0.8705882352941177, 'rgb(243,205,144)'],
        [0.8745098039215686, 'rgb(244,206,148)'],
        [0.8784313725490196, 'rgb(246,207,152)'],
        [0.8823529411764706, 'rgb(247,208,156)'],
        [0.8862745098039215, 'rgb(248,210,160)'],
        [0.8901960784313725, 'rgb(249,211,164)'],
        [0.8941176470588236, 'rgb(249,212,168)'],
        [0.8980392156862745, 'rgb(250,213,172)'],
        [0.9019607843137255, 'rgb(251,214,176)'],
        [0.9058823529411765, 'rgb(252,216,180)'],
        [0.9098039215686274, 'rgb(252,217,184)'],
        [0.9137254901960784, 'rgb(253,218,188)'],
        [0.9176470588235294, 'rgb(253,220,192)'],
        [0.9215686274509803, 'rgb(254,221,196)'],
        [0.9254901960784314, 'rgb(254,223,199)'],
        [0.9294117647058824, 'rgb(255,224,203)'],
        [0.9333333333333333, 'rgb(255,226,207)'],
        [0.9372549019607843, 'rgb(255,227,211)'],
        [0.9411764705882353, 'rgb(255,229,214)'],
        [0.9450980392156862, 'rgb(255,230,218)'],
        [0.9490196078431372, 'rgb(255,232,221)'],
        [0.9529411764705882, 'rgb(255,234,225)'],
        [0.9568627450980393, 'rgb(255,236,228)'],
        [0.9607843137254902, 'rgb(255,237,231)'],
        [0.9647058823529412, 'rgb(254,239,234)'],
        [0.9686274509803922, 'rgb(254,241,237)'],
        [0.9725490196078431, 'rgb(254,243,240)'],
        [0.9764705882352941, 'rgb(254,245,242)'],
        [0.9803921568627451, 'rgb(254,246,245)'],
        [0.984313725490196, 'rgb(254,248,247)'],
        [0.9882352941176471, 'rgb(254,250,249)'],
        [0.9921568627450981, 'rgb(254,252,251)'],
        [0.996078431372549, 'rgb(255,253,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.redshift': [
        [0.0, 'rgb(148,241,243)'],
        [0.00392156862745098, 'rgb(145,239,242)'],
        [0.00784313725490196, 'rgb(142,237,242)'],
        [0.011764705882352941, 'rgb(139,235,241)'],
        [0.01568627450980392, 'rgb(137,232,240)'],
        [0.0196078431372549, 'rgb(134,230,239)'],
        [0.023529411764705882, 'rgb(131,228,238)'],
        [0.027450980392156862, 'rgb(128,226,238)'],
        [0.03137254901960784, 'rgb(125,223,237)'],
        [0.03529411764705882, 'rgb(123,221,236)'],
        [0.0392156862745098, 'rgb(120,219,236)'],
        [0.043137254901960784, 'rgb(117,217,235)'],
        [0.047058823529411764, 'rgb(114,214,234)'],
        [0.050980392156862744, 'rgb(111,212,234)'],
        [0.054901960784313725, 'rgb(108,210,233)'],
        [0.058823529411764705, 'rgb(106,208,232)'],
        [0.06274509803921569, 'rgb(103,206,232)'],
        [0.06666666666666667, 'rgb(100,204,231)'],
        [0.07058823529411765, 'rgb(97,202,231)'],
        [0.07450980392156863, 'rgb(94,199,230)'],
        [0.0784313725490196, 'rgb(91,197,230)'],
        [0.08235294117647059, 'rgb(88,195,229)'],
        [0.08627450980392157, 'rgb(85,193,229)'],
        [0.09019607843137255, 'rgb(82,191,229)'],
        [0.09411764705882353, 'rgb(79,189,228)'],
        [0.09803921568627451, 'rgb(76,187,228)'],
        [0.10196078431372549, 'rgb(73,185,227)'],
        [0.10588235294117647, 'rgb(70,182,227)'],
        [0.10980392156862745, 'rgb(67,180,227)'],
        [0.11372549019607843, 'rgb(64,178,227)'],
        [0.11764705882352941, 'rgb(61,176,226)'],
        [0.12156862745098039, 'rgb(58,174,226)'],
        [0.12549019607843137, 'rgb(55,172,226)'],
        [0.12941176470588237, 'rgb(52,170,226)'],
        [0.13333333333333333, 'rgb(49,168,225)'],
        [0.13725490196078433, 'rgb(46,165,225)'],
        [0.1411764705882353, 'rgb(43,163,225)'],
        [0.1450980392156863, 'rgb(40,161,225)'],
        [0.14901960784313725, 'rgb(37,159,225)'],
        [0.15294117647058825, 'rgb(35,157,224)'],
        [0.1568627450980392, 'rgb(32,154,224)'],
        [0.1607843137254902, 'rgb(30,152,224)'],
        [0.16470588235294117, 'rgb(28,150,224)'],
        [0.16862745098039217, 'rgb(26,148,224)'],
        [0.17254901960784313, 'rgb(25,145,223)'],
        [0.17647058823529413, 'rgb(24,143,223)'],
        [0.1803921568627451, 'rgb(24,141,223)'],
        [0.1843137254901961, 'rgb(24,139,222)'],
        [0.18823529411764706, 'rgb(25,136,222)'],
        [0.19215686274509805, 'rgb(26,134,221)'],
        [0.19607843137254902, 'rgb(28,131,220)'],
        [0.2, 'rgb(30,129,220)'],
        [0.20392156862745098, 'rgb(33,127,219)'],
        [0.20784313725490197, 'rgb(35,124,217)'],
        [0.21176470588235294, 'rgb(38,122,216)'],
        [0.21568627450980393, 'rgb(41,119,214)'],
        [0.2196078431372549, 'rgb(43,117,212)'],
        [0.2235294117647059, 'rgb(46,115,210)'],
        [0.22745098039215686, 'rgb(48,112,207)'],
        [0.23137254901960785, 'rgb(51,110,205)'],
        [0.23529411764705882, 'rgb(53,108,202)'],
        [0.23921568627450981, 'rgb(54,106,199)'],
        [0.24313725490196078, 'rgb(56,104,195)'],
        [0.24705882352941178, 'rgb(57,102,192)'],
        [0.25098039215686274, 'rgb(58,100,188)'],
        [0.2549019607843137, 'rgb(59,98,185)'],
        [0.25882352941176473, 'rgb(60,96,181)'],
        [0.2627450980392157, 'rgb(60,94,177)'],
        [0.26666666666666666, 'rgb(61,92,173)'],
        [0.27058823529411763, 'rgb(61,90,170)'],
        [0.27450980392156865, 'rgb(61,89,166)'],
        [0.2784313725490196, 'rgb(61,87,162)'],
        [0.2823529411764706, 'rgb(61,85,158)'],
        [0.28627450980392155, 'rgb(61,84,155)'],
        [0.2901960784313726, 'rgb(61,82,151)'],
        [0.29411764705882354, 'rgb(60,80,147)'],
        [0.2980392156862745, 'rgb(60,79,143)'],
        [0.30196078431372547, 'rgb(59,77,140)'],
        [0.3058823529411765, 'rgb(59,75,136)'],
        [0.30980392156862746, 'rgb(58,74,132)'],
        [0.3137254901960784, 'rgb(58,72,129)'],
        [0.3176470588235294, 'rgb(57,71,125)'],
        [0.3215686274509804, 'rgb(56,69,122)'],
        [0.3254901960784314, 'rgb(55,67,118)'],
        [0.32941176470588235, 'rgb(54,66,115)'],
        [0.3333333333333333, 'rgb(54,64,112)'],
        [0.33725490196078434, 'rgb(53,63,108)'],
        [0.3411764705882353, 'rgb(52,61,105)'],
        [0.34509803921568627, 'rgb(51,60,102)'],
        [0.34901960784313724, 'rgb(50,58,98)'],
        [0.35294117647058826, 'rgb(49,56,95)'],
        [0.3568627450980392, 'rgb(48,55,92)'],
        [0.3607843137254902, 'rgb(47,53,89)'],
        [0.36470588235294116, 'rgb(45,52,86)'],
        [0.3686274509803922, 'rgb(44,50,82)'],
        [0.37254901960784315, 'rgb(43,49,79)'],
        [0.3764705882352941, 'rgb(42,47,76)'],
        [0.3803921568627451, 'rgb(41,45,73)'],
        [0.3843137254901961, 'rgb(39,44,70)'],
        [0.38823529411764707, 'rgb(38,42,67)'],
        [0.39215686274509803, 'rgb(37,41,64)'],
        [0.396078431372549, 'rgb(36,39,62)'],
        [0.4, 'rgb(34,37,59)'],
        [0.403921568627451, 'rgb(33,36,56)'],
        [0.40784313725490196, 'rgb(31,34,53)'],
        [0.4117647058823529, 'rgb(30,33,50)'],
        [0.41568627450980394, 'rgb(29,31,47)'],
        [0.4196078431372549, 'rgb(27,29,45)'],
        [0.4235294117647059, 'rgb(26,28,42)'],
        [0.42745098039215684, 'rgb(24,26,39)'],
        [0.43137254901960786, 'rgb(23,24,37)'],
        [0.43529411764705883, 'rgb(21,22,34)'],
        [0.4392156862745098, 'rgb(20,21,31)'],
        [0.44313725490196076, 'rgb(18,19,28)'],
        [0.4470588235294118, 'rgb(16,17,26)'],
        [0.45098039215686275, 'rgb(15,15,23)'],
        [0.4549019607843137, 'rgb(13,14,21)'],
        [0.4588235294117647, 'rgb(11,12,18)'],
        [0.4627450980392157, 'rgb(9,10,15)'],
        [0.4666666666666667, 'rgb(8,8,13)'],
        [0.47058823529411764, 'rgb(6,6,10)'],
        [0.4745098039215686, 'rgb(5,5,7)'],
        [0.47843137254901963, 'rgb(4,4,5)'],
        [0.4823529411764706, 'rgb(2,3,4)'],
        [0.48627450980392156, 'rgb(2,2,2)'],
        [0.49019607843137253, 'rgb(1,1,1)'],
        [0.49411764705882355, 'rgb(0,0,0)'],
        [0.4980392156862745, 'rgb(0,0,0)'],
        [0.5019607843137255, 'rgb(0,0,0)'],
        [0.5058823529411764, 'rgb(0,0,0)'],
        [0.5098039215686274, 'rgb(1,1,1)'],
        [0.5137254901960784, 'rgb(2,1,1)'],
        [0.5176470588235295, 'rgb(4,2,2)'],
        [0.5215686274509804, 'rgb(6,3,3)'],
        [0.5254901960784314, 'rgb(8,4,3)'],
        [0.5294117647058824, 'rgb(11,5,4)'],
        [0.5333333333333333, 'rgb(13,6,5)'],
        [0.5372549019607843, 'rgb(16,8,6)'],
        [0.5411764705882353, 'rgb(19,9,8)'],
        [0.5450980392156862, 'rgb(22,11,9)'],
        [0.5490196078431373, 'rgb(24,12,10)'],
        [0.5529411764705883, 'rgb(27,14,11)'],
        [0.5568627450980392, 'rgb(29,15,13)'],
        [0.5607843137254902, 'rgb(32,16,14)'],
        [0.5647058823529412, 'rgb(35,18,15)'],
        [0.5686274509803921, 'rgb(37,19,16)'],
        [0.5725490196078431, 'rgb(40,20,17)'],
        [0.5764705882352941, 'rgb(43,22,18)'],
        [0.5803921568627451, 'rgb(45,23,19)'],
        [0.5843137254901961, 'rgb(48,24,20)'],
        [0.5882352941176471, 'rgb(50,25,21)'],
        [0.592156862745098, 'rgb(53,26,22)'],
        [0.596078431372549, 'rgb(56,27,23)'],
        [0.6, 'rgb(58,29,24)'],
        [0.6039215686274509, 'rgb(61,30,25)'],
        [0.6078431372549019, 'rgb(64,31,26)'],
        [0.611764705882353, 'rgb(66,32,27)'],
        [0.615686274509804, 'rgb(69,33,28)'],
        [0.6196078431372549, 'rgb(72,34,29)'],
        [0.6235294117647059, 'rgb(74,35,30)'],
        [0.6274509803921569, 'rgb(77,36,31)'],
        [0.6313725490196078, 'rgb(80,37,32)'],
        [0.6352941176470588, 'rgb(83,38,32)'],
        [0.6392156862745098, 'rgb(85,38,33)'],
        [0.6431372549019608, 'rgb(88,39,34)'],
        [0.6470588235294118, 'rgb(91,40,35)'],
        [0.6509803921568628, 'rgb(94,41,36)'],
        [0.6549019607843137, 'rgb(96,42,37)'],
        [0.6588235294117647, 'rgb(99,43,38)'],
        [0.6627450980392157, 'rgb(102,43,38)'],
        [0.6666666666666666, 'rgb(105,44,39)'],
        [0.6705882352941176, 'rgb(108,45,40)'],
        [0.6745098039215687, 'rgb(111,46,41)'],
        [0.6784313725490196, 'rgb(113,46,42)'],
        [0.6823529411764706, 'rgb(116,47,43)'],
        [0.6862745098039216, 'rgb(119,48,43)'],
        [0.6901960784313725, 'rgb(122,48,44)'],
        [0.6941176470588235, 'rgb(125,49,45)'],
        [0.6980392156862745, 'rgb(128,49,46)'],
        [0.7019607843137254, 'rgb(131,50,47)'],
        [0.7058823529411765, 'rgb(134,50,48)'],
        [0.7098039215686275, 'rgb(137,51,49)'],
        [0.7137254901960784, 'rgb(140,51,50)'],
        [0.7176470588235294, 'rgb(143,52,51)'],
        [0.7215686274509804, 'rgb(146,52,52)'],
        [0.7254901960784313, 'rgb(149,53,53)'],
        [0.7294117647058823, 'rgb(152,53,55)'],
        [0.7333333333333333, 'rgb(155,53,56)'],
        [0.7372549019607844, 'rgb(158,54,57)'],
        [0.7411764705882353, 'rgb(162,54,58)'],
        [0.7450980392156863, 'rgb(165,54,60)'],
        [0.7490196078431373, 'rgb(168,54,62)'],
        [0.7529411764705882, 'rgb(171,55,63)'],
        [0.7568627450980392, 'rgb(174,55,65)'],
        [0.7607843137254902, 'rgb(177,55,67)'],
        [0.7647058823529411, 'rgb(180,56,70)'],
        [0.7686274509803922, 'rgb(182,56,72)'],
        [0.7725490196078432, 'rgb(185,57,75)'],
        [0.7764705882352941, 'rgb(188,58,78)'],
        [0.7803921568627451, 'rgb(190,60,81)'],
        [0.7843137254901961, 'rgb(192,61,85)'],
        [0.788235294117647, 'rgb(194,63,88)'],
        [0.792156862745098, 'rgb(196,65,91)'],
        [0.796078431372549, 'rgb(198,67,95)'],
        [0.8, 'rgb(199,69,98)'],
        [0.803921568627451, 'rgb(201,71,102)'],
        [0.807843137254902, 'rgb(202,74,105)'],
        [0.8117647058823529, 'rgb(204,76,109)'],
        [0.8156862745098039, 'rgb(205,79,112)'],
        [0.8196078431372549, 'rgb(206,81,115)'],
        [0.8235294117647058, 'rgb(208,84,119)'],
        [0.8274509803921568, 'rgb(209,86,122)'],
        [0.8313725490196079, 'rgb(210,89,125)'],
        [0.8352941176470589, 'rgb(211,91,129)'],
        [0.8392156862745098, 'rgb(213,94,132)'],
        [0.8431372549019608, 'rgb(214,97,135)'],
        [0.8470588235294118, 'rgb(215,99,138)'],
        [0.8509803921568627, 'rgb(216,102,141)'],
        [0.8549019607843137, 'rgb(217,104,145)'],
        [0.8588235294117647, 'rgb(218,107,148)'],
        [0.8627450980392157, 'rgb(219,110,151)'],
        [0.8666666666666667, 'rgb(220,112,154)'],
        [0.8705882352941177, 'rgb(221,115,157)'],
        [0.8745098039215686, 'rgb(222,118,160)'],
        [0.8784313725490196, 'rgb(223,120,163)'],
        [0.8823529411764706, 'rgb(224,123,166)'],
        [0.8862745098039215, 'rgb(225,126,169)'],
        [0.8901960784313725, 'rgb(226,128,172)'],
        [0.8941176470588236, 'rgb(227,131,175)'],
        [0.8980392156862745, 'rgb(228,134,178)'],
        [0.9019607843137255, 'rgb(229,136,181)'],
        [0.9058823529411765, 'rgb(229,139,184)'],
        [0.9098039215686274, 'rgb(230,142,187)'],
        [0.9137254901960784, 'rgb(231,145,190)'],
        [0.9176470588235294, 'rgb(232,147,193)'],
        [0.9215686274509803, 'rgb(233,150,196)'],
        [0.9254901960784314, 'rgb(234,153,199)'],
        [0.9294117647058824, 'rgb(235,155,202)'],
        [0.9333333333333333, 'rgb(236,158,205)'],
        [0.9372549019607843, 'rgb(236,161,207)'],
        [0.9411764705882353, 'rgb(237,164,210)'],
        [0.9450980392156862, 'rgb(238,166,213)'],
        [0.9490196078431372, 'rgb(239,169,216)'],
        [0.9529411764705882, 'rgb(240,172,219)'],
        [0.9568627450980393, 'rgb(241,174,222)'],
        [0.9607843137254902, 'rgb(242,177,224)'],
        [0.9647058823529412, 'rgb(243,180,227)'],
        [0.9686274509803922, 'rgb(244,183,230)'],
        [0.9725490196078431, 'rgb(245,185,233)'],
        [0.9764705882352941, 'rgb(246,188,236)'],
        [0.9803921568627451, 'rgb(247,191,238)'],
        [0.984313725490196, 'rgb(248,194,241)'],
        [0.9882352941176471, 'rgb(249,197,244)'],
        [0.9921568627450981, 'rgb(250,199,247)'],
        [0.996078431372549, 'rgb(251,202,249)'],
        [1.0, 'rgb(252,205,252)'],
    ],
    'cmr.sunburst': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,1)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(2,1,2)'],
        [0.027450980392156862, 'rgb(3,2,3)'],
        [0.03137254901960784, 'rgb(4,2,4)'],
        [0.03529411764705882, 'rgb(5,2,4)'],
        [0.0392156862745098, 'rgb(6,3,5)'],
        [0.043137254901960784, 'rgb(7,3,7)'],
        [0.047058823529411764, 'rgb(8,4,8)'],
        [0.050980392156862744, 'rgb(10,4,9)'],
        [0.054901960784313725, 'rgb(11,5,10)'],
        [0.058823529411764705, 'rgb(13,5,12)'],
        [0.06274509803921569, 'rgb(15,6,13)'],
        [0.06666666666666667, 'rgb(16,7,14)'],
        [0.07058823529411765, 'rgb(18,7,16)'],
        [0.07450980392156863, 'rgb(19,8,17)'],
        [0.0784313725490196, 'rgb(21,8,18)'],
        [0.08235294117647059, 'rgb(23,9,20)'],
        [0.08627450980392157, 'rgb(24,10,21)'],
        [0.09019607843137255, 'rgb(26,10,22)'],
        [0.09411764705882353, 'rgb(27,11,23)'],
        [0.09803921568627451, 'rgb(29,12,24)'],
        [0.10196078431372549, 'rgb(31,12,26)'],
        [0.10588235294117647, 'rgb(32,13,27)'],
        [0.10980392156862745, 'rgb(34,13,28)'],
        [0.11372549019607843, 'rgb(36,14,29)'],
        [0.11764705882352941, 'rgb(37,14,30)'],
        [0.12156862745098039, 'rgb(39,15,31)'],
        [0.12549019607843137, 'rgb(41,15,32)'],
        [0.12941176470588237, 'rgb(42,16,33)'],
        [0.13333333333333333, 'rgb(44,16,34)'],
        [0.13725490196078433, 'rgb(46,16,35)'],
        [0.1411764705882353, 'rgb(47,17,36)'],
        [0.1450980392156863, 'rgb(49,17,37)'],
        [0.14901960784313725, 'rgb(51,18,38)'],
        [0.15294117647058825, 'rgb(52,18,38)'],
        [0.1568627450980392, 'rgb(54,18,39)'],
        [0.1607843137254902, 'rgb(56,19,40)'],
        [0.16470588235294117, 'rgb(57,19,41)'],
        [0.16862745098039217, 'rgb(59,19,42)'],
        [0.17254901960784313, 'rgb(61,19,42)'],
        [0.17647058823529413, 'rgb(63,20,43)'],
        [0.1803921568627451, 'rgb(64,20,44)'],
        [0.1843137254901961, 'rgb(66,20,44)'],
        [0.18823529411764706, 'rgb(68,20,45)'],
        [0.19215686274509805, 'rgb(70,21,45)'],
        [0.19607843137254902, 'rgb(71,21,46)'],
        [0.2, 'rgb(73,21,47)'],
        [0.20392156862745098, 'rgb(75,21,47)'],
        [0.20784313725490197, 'rgb(77,21,48)'],
        [0.21176470588235294, 'rgb(78,22,48)'],
        [0.21568627450980393, 'rgb(80,22,49)'],
        [0.2196078431372549, 'rgb(82,22,49)'],
        [0.2235294117647059, 'rgb(84,22,49)'],
        [0.22745098039215686, 'rgb(85,22,50)'],
        [0.23137254901960785, 'rgb(87,22,50)'],
        [0.23529411764705882, 'rgb(89,22,50)'],
        [0.23921568627450981, 'rgb(91,22,51)'],
        [0.24313725490196078, 'rgb(92,22,51)'],
        [0.24705882352941178, 'rgb(94,22,51)'],
        [0.25098039215686274, 'rgb(96,22,52)'],
        [0.2549019607843137, 'rgb(98,22,52)'],
        [0.25882352941176473, 'rgb(100,22,52)'],
        [0.2627450980392157, 'rgb(101,22,52)'],
        [0.26666666666666666, 'rgb(103,22,52)'],
        [0.27058823529411763, 'rgb(105,22,52)'],
        [0.27450980392156865, 'rgb(107,22,53)'],
        [0.2784313725490196, 'rgb(109,22,53)'],
        [0.2823529411764706, 'rgb(110,22,53)'],
        [0.28627450980392155, 'rgb(112,22,53)'],
        [0.2901960784313726, 'rgb(114,22,53)'],
        [0.29411764705882354, 'rgb(116,22,53)'],
        [0.2980392156862745, 'rgb(118,22,53)'],
        [0.30196078431372547, 'rgb(119,22,53)'],
        [0.3058823529411765, 'rgb(121,21,53)'],
        [0.30980392156862746, 'rgb(123,21,52)'],
        [0.3137254901960784, 'rgb(125,21,52)'],
        [0.3176470588235294, 'rgb(127,21,52)'],
        [0.3215686274509804, 'rgb(129,21,52)'],
        [0.3254901960784314, 'rgb(130,20,52)'],
        [0.32941176470588235, 'rgb(132,20,52)'],
        [0.3333333333333333, 'rgb(134,20,51)'],
        [0.33725490196078434, 'rgb(136,20,51)'],
        [0.3411764705882353, 'rgb(138,19,51)'],
        [0.34509803921568627, 'rgb(139,19,50)'],
        [0.34901960784313724, 'rgb(141,19,50)'],
        [0.35294117647058826, 'rgb(143,18,50)'],
        [0.3568627450980392, 'rgb(145,18,49)'],
        [0.3607843137254902, 'rgb(147,18,49)'],
        [0.36470588235294116, 'rgb(149,17,48)'],
        [0.3686274509803922, 'rgb(150,17,48)'],
        [0.37254901960784315, 'rgb(152,17,47)'],
        [0.3764705882352941, 'rgb(154,16,47)'],
        [0.3803921568627451, 'rgb(156,16,46)'],
        [0.3843137254901961, 'rgb(158,16,46)'],
        [0.38823529411764707, 'rgb(159,15,45)'],
        [0.39215686274509803, 'rgb(161,15,44)'],
        [0.396078431372549, 'rgb(163,15,44)'],
        [0.4, 'rgb(165,14,43)'],
        [0.403921568627451, 'rgb(167,14,42)'],
        [0.40784313725490196, 'rgb(168,14,41)'],
        [0.4117647058823529, 'rgb(170,14,41)'],
        [0.41568627450980394, 'rgb(172,14,40)'],
        [0.4196078431372549, 'rgb(173,14,39)'],
        [0.4235294117647059, 'rgb(175,14,38)'],
        [0.42745098039215684, 'rgb(177,14,37)'],
        [0.43137254901960786, 'rgb(179,14,36)'],
        [0.43529411764705883, 'rgb(180,15,35)'],
        [0.4392156862745098, 'rgb(182,15,34)'],
        [0.44313725490196076, 'rgb(183,16,33)'],
        [0.4470588235294118, 'rgb(185,17,32)'],
        [0.45098039215686275, 'rgb(187,17,30)'],
        [0.4549019607843137, 'rgb(188,18,29)'],
        [0.4588235294117647, 'rgb(190,20,28)'],
        [0.4627450980392157, 'rgb(191,21,27)'],
        [0.4666666666666667, 'rgb(193,22,25)'],
        [0.47058823529411764, 'rgb(194,24,24)'],
        [0.4745098039215686, 'rgb(195,25,23)'],
        [0.47843137254901963, 'rgb(197,27,21)'],
        [0.4823529411764706, 'rgb(198,29,20)'],
        [0.48627450980392156, 'rgb(199,31,18)'],
        [0.49019607843137253, 'rgb(200,33,17)'],
        [0.49411764705882355, 'rgb(201,35,16)'],
        [0.4980392156862745, 'rgb(202,37,14)'],
        [0.5019607843137255, 'rgb(203,39,13)'],
        [0.5058823529411764, 'rgb(204,42,12)'],
        [0.5098039215686274, 'rgb(205,44,10)'],
        [0.5137254901960784, 'rgb(206,46,9)'],
        [0.5176470588235295, 'rgb(207,48,8)'],
        [0.5215686274509804, 'rgb(207,51,8)'],
        [0.5254901960784314, 'rgb(208,53,7)'],
        [0.5294117647058824, 'rgb(209,55,7)'],
        [0.5333333333333333, 'rgb(210,57,6)'],
        [0.5372549019607843, 'rgb(210,60,6)'],
        [0.5411764705882353, 'rgb(211,62,6)'],
        [0.5450980392156862, 'rgb(211,64,6)'],
        [0.5490196078431373, 'rgb(212,66,7)'],
        [0.5529411764705883, 'rgb(213,68,7)'],
        [0.5568627450980392, 'rgb(213,70,8)'],
        [0.5607843137254902, 'rgb(214,72,9)'],
        [0.5647058823529412, 'rgb(214,75,10)'],
        [0.5686274509803921, 'rgb(215,77,11)'],
        [0.5725490196078431, 'rgb(215,79,12)'],
        [0.5764705882352941, 'rgb(215,81,13)'],
        [0.5803921568627451, 'rgb(216,83,15)'],
        [0.5843137254901961, 'rgb(216,85,16)'],
        [0.5882352941176471, 'rgb(217,87,18)'],
        [0.592156862745098, 'rgb(217,89,19)'],
        [0.596078431372549, 'rgb(217,91,21)'],
        [0.6, 'rgb(218,93,22)'],
        [0.6039215686274509, 'rgb(218,95,24)'],
        [0.6078431372549019, 'rgb(218,97,25)'],
        [0.611764705882353, 'rgb(219,99,27)'],
        [0.615686274509804, 'rgb(219,100,29)'],
        [0.6196078431372549, 'rgb(219,102,30)'],
        [0.6235294117647059, 'rgb(220,104,32)'],
        [0.6274509803921569, 'rgb(220,106,34)'],
        [0.6313725490196078, 'rgb(220,108,35)'],
        [0.6352941176470588, 'rgb(220,110,37)'],
        [0.6392156862745098, 'rgb(221,112,39)'],
        [0.6431372549019608, 'rgb(221,114,41)'],
        [0.6470588235294118, 'rgb(221,115,42)'],
        [0.6509803921568628, 'rgb(221,117,44)'],
        [0.6549019607843137, 'rgb(221,119,46)'],
        [0.6588235294117647, 'rgb(222,121,48)'],
        [0.6627450980392157, 'rgb(222,123,50)'],
        [0.6666666666666666, 'rgb(222,125,52)'],
        [0.6705882352941176, 'rgb(222,126,53)'],
        [0.6745098039215687, 'rgb(222,128,55)'],
        [0.6784313725490196, 'rgb(222,130,57)'],
        [0.6823529411764706, 'rgb(223,132,59)'],
        [0.6862745098039216, 'rgb(223,134,61)'],
        [0.6901960784313725, 'rgb(223,135,63)'],
        [0.6941176470588235, 'rgb(223,137,65)'],
        [0.6980392156862745, 'rgb(223,139,67)'],
        [0.7019607843137254, 'rgb(223,141,69)'],
        [0.7058823529411765, 'rgb(223,142,71)'],
        [0.7098039215686275, 'rgb(223,144,73)'],
        [0.7137254901960784, 'rgb(223,146,75)'],
        [0.7176470588235294, 'rgb(223,148,77)'],
        [0.7215686274509804, 'rgb(223,149,79)'],
        [0.7254901960784313, 'rgb(223,151,81)'],
        [0.7294117647058823, 'rgb(223,153,83)'],
        [0.7333333333333333, 'rgb(224,155,86)'],
        [0.7372549019607844, 'rgb(224,156,88)'],
        [0.7411764705882353, 'rgb(224,158,90)'],
        [0.7450980392156863, 'rgb(224,160,92)'],
        [0.7490196078431373, 'rgb(224,161,94)'],
        [0.7529411764705882, 'rgb(224,163,96)'],
        [0.7568627450980392, 'rgb(224,165,99)'],
        [0.7607843137254902, 'rgb(224,166,101)'],
        [0.7647058823529411, 'rgb(224,168,103)'],
        [0.7686274509803922, 'rgb(224,170,105)'],
        [0.7725490196078432, 'rgb(224,171,108)'],
        [0.7764705882352941, 'rgb(224,173,110)'],
        [0.7803921568627451, 'rgb(224,175,112)'],
        [0.7843137254901961, 'rgb(224,176,115)'],
        [0.788235294117647, 'rgb(224,178,117)'],
        [0.792156862745098, 'rgb(224,180,120)'],
        [0.796078431372549, 'rgb(224,181,122)'],
        [0.8, 'rgb(224,183,124)'],
        [0.803921568627451, 'rgb(224,185,127)'],
        [0.807843137254902, 'rgb(224,186,129)'],
        [0.8117647058823529, 'rgb(224,188,132)'],
        [0.8156862745098039, 'rgb(224,189,134)'],
        [0.8196078431372549, 'rgb(224,191,137)'],
        [0.8235294117647058, 'rgb(224,193,139)'],
        [0.8274509803921568, 'rgb(224,194,142)'],
        [0.8313725490196079, 'rgb(224,196,144)'],
        [0.8352941176470589, 'rgb(224,197,147)'],
        [0.8392156862745098, 'rgb(224,199,150)'],
        [0.8431372549019608, 'rgb(225,200,152)'],
        [0.8470588235294118, 'rgb(225,202,155)'],
        [0.8509803921568627, 'rgb(225,204,157)'],
        [0.8549019607843137, 'rgb(225,205,160)'],
        [0.8588235294117647, 'rgb(225,207,163)'],
        [0.8627450980392157, 'rgb(226,208,165)'],
        [0.8666666666666667, 'rgb(226,210,168)'],
        [0.8705882352941177, 'rgb(226,211,171)'],
        [0.8745098039215686, 'rgb(226,213,173)'],
        [0.8784313725490196, 'rgb(227,214,176)'],
        [0.8823529411764706, 'rgb(227,215,179)'],
        [0.8862745098039215, 'rgb(227,217,182)'],
        [0.8901960784313725, 'rgb(228,218,184)'],
        [0.8941176470588236, 'rgb(228,220,187)'],
        [0.8980392156862745, 'rgb(229,221,190)'],
        [0.9019607843137255, 'rgb(229,223,193)'],
        [0.9058823529411765, 'rgb(230,224,195)'],
        [0.9098039215686274, 'rgb(230,225,198)'],
        [0.9137254901960784, 'rgb(231,227,201)'],
        [0.9176470588235294, 'rgb(232,228,203)'],
        [0.9215686274509803, 'rgb(232,229,206)'],
        [0.9254901960784314, 'rgb(233,231,209)'],
        [0.9294117647058824, 'rgb(234,232,212)'],
        [0.9333333333333333, 'rgb(235,233,214)'],
        [0.9372549019607843, 'rgb(236,235,217)'],
        [0.9411764705882353, 'rgb(237,236,220)'],
        [0.9450980392156862, 'rgb(237,237,222)'],
        [0.9490196078431372, 'rgb(238,239,225)'],
        [0.9529411764705882, 'rgb(240,240,227)'],
        [0.9568627450980393, 'rgb(241,241,230)'],
        [0.9607843137254902, 'rgb(242,242,233)'],
        [0.9647058823529412, 'rgb(243,244,235)'],
        [0.9686274509803922, 'rgb(244,245,238)'],
        [0.9725490196078431, 'rgb(245,246,240)'],
        [0.9764705882352941, 'rgb(247,247,242)'],
        [0.9803921568627451, 'rgb(248,249,245)'],
        [0.984313725490196, 'rgb(249,250,247)'],
        [0.9882352941176471, 'rgb(251,251,249)'],
        [0.9921568627450981, 'rgb(252,252,251)'],
        [0.996078431372549, 'rgb(254,254,253)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.voltage': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(1,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(2,1,1)'],
        [0.023529411764705882, 'rgb(2,1,2)'],
        [0.027450980392156862, 'rgb(3,2,2)'],
        [0.03137254901960784, 'rgb(4,2,3)'],
        [0.03529411764705882, 'rgb(5,2,4)'],
        [0.0392156862745098, 'rgb(6,3,5)'],
        [0.043137254901960784, 'rgb(8,3,6)'],
        [0.047058823529411764, 'rgb(9,4,7)'],
        [0.050980392156862744, 'rgb(11,4,8)'],
        [0.054901960784313725, 'rgb(12,5,9)'],
        [0.058823529411764705, 'rgb(14,5,11)'],
        [0.06274509803921569, 'rgb(15,6,12)'],
        [0.06666666666666667, 'rgb(17,6,13)'],
        [0.07058823529411765, 'rgb(19,7,15)'],
        [0.07450980392156863, 'rgb(20,8,16)'],
        [0.0784313725490196, 'rgb(22,8,17)'],
        [0.08235294117647059, 'rgb(23,9,19)'],
        [0.08627450980392157, 'rgb(25,9,20)'],
        [0.09019607843137255, 'rgb(26,10,22)'],
        [0.09411764705882353, 'rgb(28,11,23)'],
        [0.09803921568627451, 'rgb(29,11,24)'],
        [0.10196078431372549, 'rgb(31,12,26)'],
        [0.10588235294117647, 'rgb(32,12,27)'],
        [0.10980392156862745, 'rgb(34,13,29)'],
        [0.11372549019607843, 'rgb(36,14,30)'],
        [0.11764705882352941, 'rgb(37,14,32)'],
        [0.12156862745098039, 'rgb(39,15,33)'],
        [0.12549019607843137, 'rgb(40,15,34)'],
        [0.12941176470588237, 'rgb(42,16,36)'],
        [0.13333333333333333, 'rgb(43,16,37)'],
        [0.13725490196078433, 'rgb(45,16,39)'],
        [0.1411764705882353, 'rgb(46,17,40)'],
        [0.1450980392156863, 'rgb(48,17,42)'],
        [0.14901960784313725, 'rgb(49,18,43)'],
        [0.15294117647058825, 'rgb(51,18,45)'],
        [0.1568627450980392, 'rgb(53,18,47)'],
        [0.1607843137254902, 'rgb(54,19,48)'],
        [0.16470588235294117, 'rgb(56,19,50)'],
        [0.16862745098039217, 'rgb(57,19,51)'],
        [0.17254901960784313, 'rgb(59,19,53)'],
        [0.17647058823529413, 'rgb(60,20,55)'],
        [0.1803921568627451, 'rgb(62,20,57)'],
        [0.1843137254901961, 'rgb(63,20,58)'],
        [0.18823529411764706, 'rgb(65,20,60)'],
        [0.19215686274509805, 'rgb(66,20,62)'],
        [0.19607843137254902, 'rgb(68,21,64)'],
        [0.2, 'rgb(70,21,65)'],
        [0.20392156862745098, 'rgb(71,21,67)'],
        [0.20784313725490197, 'rgb(73,21,69)'],
        [0.21176470588235294, 'rgb(74,21,71)'],
        [0.21568627450980393, 'rgb(76,21,73)'],
        [0.2196078431372549, 'rgb(77,21,75)'],
        [0.2235294117647059, 'rgb(79,21,77)'],
        [0.22745098039215686, 'rgb(80,21,79)'],
        [0.23137254901960785, 'rgb(82,21,81)'],
        [0.23529411764705882, 'rgb(83,21,83)'],
        [0.23921568627450981, 'rgb(85,21,85)'],
        [0.24313725490196078, 'rgb(86,20,87)'],
        [0.24705882352941178, 'rgb(88,20,89)'],
        [0.25098039215686274, 'rgb(89,20,92)'],
        [0.2549019607843137, 'rgb(91,20,94)'],
        [0.25882352941176473, 'rgb(92,19,96)'],
        [0.2627450980392157, 'rgb(94,19,99)'],
        [0.26666666666666666, 'rgb(95,19,101)'],
        [0.27058823529411763, 'rgb(97,18,103)'],
        [0.27450980392156865, 'rgb(98,18,106)'],
        [0.2784313725490196, 'rgb(100,18,108)'],
        [0.2823529411764706, 'rgb(101,17,111)'],
        [0.28627450980392155, 'rgb(103,17,113)'],
        [0.2901960784313726, 'rgb(104,16,116)'],
        [0.29411764705882354, 'rgb(105,16,118)'],
        [0.2980392156862745, 'rgb(107,16,121)'],
        [0.30196078431372547, 'rgb(108,15,124)'],
        [0.3058823529411765, 'rgb(109,15,126)'],
        [0.30980392156862746, 'rgb(110,14,129)'],
        [0.3137254901960784, 'rgb(112,14,132)'],
        [0.3176470588235294, 'rgb(113,14,134)'],
        [0.3215686274509804, 'rgb(114,14,137)'],
        [0.3254901960784314, 'rgb(115,14,140)'],
        [0.32941176470588235, 'rgb(116,14,143)'],
        [0.3333333333333333, 'rgb(117,14,145)'],
        [0.33725490196078434, 'rgb(118,14,148)'],
        [0.3411764705882353, 'rgb(119,15,151)'],
        [0.34509803921568627, 'rgb(120,15,153)'],
        [0.34901960784313724, 'rgb(121,16,156)'],
        [0.35294117647058826, 'rgb(122,17,159)'],
        [0.3568627450980392, 'rgb(123,18,161)'],
        [0.3607843137254902, 'rgb(123,19,164)'],
        [0.36470588235294116, 'rgb(124,20,166)'],
        [0.3686274509803922, 'rgb(125,21,169)'],
        [0.37254901960784315, 'rgb(125,22,171)'],
        [0.3764705882352941, 'rgb(126,24,174)'],
        [0.3803921568627451, 'rgb(127,25,176)'],
        [0.3843137254901961, 'rgb(127,27,178)'],
        [0.38823529411764707, 'rgb(128,28,181)'],
        [0.39215686274509803, 'rgb(128,30,183)'],
        [0.396078431372549, 'rgb(129,32,185)'],
        [0.4, 'rgb(129,33,187)'],
        [0.403921568627451, 'rgb(129,35,189)'],
        [0.40784313725490196, 'rgb(130,37,191)'],
        [0.4117647058823529, 'rgb(130,39,193)'],
        [0.41568627450980394, 'rgb(130,41,195)'],
        [0.4196078431372549, 'rgb(130,43,197)'],
        [0.4235294117647059, 'rgb(131,44,199)'],
        [0.42745098039215684, 'rgb(131,46,201)'],
        [0.43137254901960786, 'rgb(131,48,203)'],
        [0.43529411764705883, 'rgb(131,50,205)'],
        [0.4392156862745098, 'rgb(131,52,207)'],
        [0.44313725490196076, 'rgb(131,54,208)'],
        [0.4470588235294118, 'rgb(131,56,210)'],
        [0.45098039215686275, 'rgb(131,58,212)'],
        [0.4549019607843137, 'rgb(131,59,213)'],
        [0.4588235294117647, 'rgb(131,61,215)'],
        [0.4627450980392157, 'rgb(131,63,216)'],
        [0.4666666666666667, 'rgb(131,65,218)'],
        [0.47058823529411764, 'rgb(131,67,219)'],
        [0.4745098039215686, 'rgb(131,69,221)'],
        [0.47843137254901963, 'rgb(131,71,222)'],
        [0.4823529411764706, 'rgb(131,73,223)'],
        [0.48627450980392156, 'rgb(131,74,225)'],
        [0.49019607843137253, 'rgb(130,76,226)'],
        [0.49411764705882355, 'rgb(130,78,227)'],
        [0.4980392156862745, 'rgb(130,80,228)'],
        [0.5019607843137255, 'rgb(130,82,229)'],
        [0.5058823529411764, 'rgb(129,84,231)'],
        [0.5098039215686274, 'rgb(129,86,232)'],
        [0.5137254901960784, 'rgb(129,87,233)'],
        [0.5176470588235295, 'rgb(129,89,234)'],
        [0.5215686274509804, 'rgb(128,91,235)'],
        [0.5254901960784314, 'rgb(128,93,236)'],
        [0.5294117647058824, 'rgb(127,95,237)'],
        [0.5333333333333333, 'rgb(127,97,238)'],
        [0.5372549019607843, 'rgb(127,98,239)'],
        [0.5411764705882353, 'rgb(126,100,240)'],
        [0.5450980392156862, 'rgb(126,102,241)'],
        [0.5490196078431373, 'rgb(125,104,242)'],
        [0.5529411764705883, 'rgb(125,106,242)'],
        [0.5568627450980392, 'rgb(124,107,243)'],
        [0.5607843137254902, 'rgb(124,109,244)'],
        [0.5647058823529412, 'rgb(124,111,245)'],
        [0.5686274509803921, 'rgb(123,113,245)'],
        [0.5725490196078431, 'rgb(122,114,246)'],
        [0.5764705882352941, 'rgb(122,116,247)'],
        [0.5803921568627451, 'rgb(121,118,247)'],
        [0.5843137254901961, 'rgb(121,120,248)'],
        [0.5882352941176471, 'rgb(120,121,249)'],
        [0.592156862745098, 'rgb(120,123,249)'],
        [0.596078431372549, 'rgb(119,125,250)'],
        [0.6, 'rgb(119,127,250)'],
        [0.6039215686274509, 'rgb(118,128,251)'],
        [0.6078431372549019, 'rgb(118,130,251)'],
        [0.611764705882353, 'rgb(117,132,252)'],
        [0.615686274509804, 'rgb(117,133,252)'],
        [0.6196078431372549, 'rgb(116,135,252)'],
        [0.6235294117647059, 'rgb(115,137,253)'],
        [0.6274509803921569, 'rgb(115,138,253)'],
        [0.6313725490196078, 'rgb(114,140,253)'],
        [0.6352941176470588, 'rgb(114,142,254)'],
        [0.6392156862745098, 'rgb(113,143,254)'],
        [0.6431372549019608, 'rgb(113,145,254)'],
        [0.6470588235294118, 'rgb(113,147,254)'],
        [0.6509803921568628, 'rgb(112,148,254)'],
        [0.6549019607843137, 'rgb(112,150,254)'],
        [0.6588235294117647, 'rgb(111,152,254)'],
        [0.6627450980392157, 'rgb(111,153,254)'],
        [0.6666666666666666, 'rgb(111,155,254)'],
        [0.6705882352941176, 'rgb(111,156,254)'],
        [0.6745098039215687, 'rgb(110,158,254)'],
        [0.6784313725490196, 'rgb(110,160,254)'],
        [0.6823529411764706, 'rgb(110,161,254)'],
        [0.6862745098039216, 'rgb(110,163,254)'],
        [0.6901960784313725, 'rgb(110,164,254)'],
        [0.6941176470588235, 'rgb(110,166,254)'],
        [0.6980392156862745, 'rgb(111,167,253)'],
        [0.7019607843137254, 'rgb(111,169,253)'],
        [0.7058823529411765, 'rgb(111,170,253)'],
        [0.7098039215686275, 'rgb(112,172,252)'],
        [0.7137254901960784, 'rgb(112,173,252)'],
        [0.7176470588235294, 'rgb(113,175,252)'],
        [0.7215686274509804, 'rgb(114,176,251)'],
        [0.7254901960784313, 'rgb(115,177,251)'],
        [0.7294117647058823, 'rgb(115,179,250)'],
        [0.7333333333333333, 'rgb(116,180,250)'],
        [0.7372549019607844, 'rgb(118,182,249)'],
        [0.7411764705882353, 'rgb(119,183,249)'],
        [0.7450980392156863, 'rgb(120,184,248)'],
        [0.7490196078431373, 'rgb(121,185,248)'],
        [0.7529411764705882, 'rgb(123,187,247)'],
        [0.7568627450980392, 'rgb(124,188,247)'],
        [0.7607843137254902, 'rgb(126,189,246)'],
        [0.7647058823529411, 'rgb(128,190,246)'],
        [0.7686274509803922, 'rgb(129,192,245)'],
        [0.7725490196078432, 'rgb(131,193,245)'],
        [0.7764705882352941, 'rgb(133,194,244)'],
        [0.7803921568627451, 'rgb(135,195,244)'],
        [0.7843137254901961, 'rgb(137,196,244)'],
        [0.788235294117647, 'rgb(139,197,243)'],
        [0.792156862745098, 'rgb(141,199,243)'],
        [0.796078431372549, 'rgb(143,200,242)'],
        [0.8, 'rgb(145,201,242)'],
        [0.803921568627451, 'rgb(147,202,242)'],
        [0.807843137254902, 'rgb(149,203,241)'],
        [0.8117647058823529, 'rgb(152,204,241)'],
        [0.8156862745098039, 'rgb(154,205,241)'],
        [0.8196078431372549, 'rgb(156,206,241)'],
        [0.8235294117647058, 'rgb(158,207,240)'],
        [0.8274509803921568, 'rgb(160,208,240)'],
        [0.8313725490196079, 'rgb(162,209,240)'],
        [0.8352941176470589, 'rgb(165,210,240)'],
        [0.8392156862745098, 'rgb(167,211,240)'],
        [0.8431372549019608, 'rgb(169,212,240)'],
        [0.8470588235294118, 'rgb(171,213,240)'],
        [0.8509803921568627, 'rgb(174,214,240)'],
        [0.8549019607843137, 'rgb(176,215,240)'],
        [0.8588235294117647, 'rgb(178,216,240)'],
        [0.8627450980392157, 'rgb(180,217,240)'],
        [0.8666666666666667, 'rgb(183,218,240)'],
        [0.8705882352941177, 'rgb(185,220,240)'],
        [0.8745098039215686, 'rgb(187,221,240)'],
        [0.8784313725490196, 'rgb(189,222,240)'],
        [0.8823529411764706, 'rgb(191,223,240)'],
        [0.8862745098039215, 'rgb(194,224,240)'],
        [0.8901960784313725, 'rgb(196,225,241)'],
        [0.8941176470588236, 'rgb(198,226,241)'],
        [0.8980392156862745, 'rgb(200,227,241)'],
        [0.9019607843137255, 'rgb(202,228,241)'],
        [0.9058823529411765, 'rgb(205,229,242)'],
        [0.9098039215686274, 'rgb(207,230,242)'],
        [0.9137254901960784, 'rgb(209,231,242)'],
        [0.9176470588235294, 'rgb(211,232,243)'],
        [0.9215686274509803, 'rgb(213,233,243)'],
        [0.9254901960784314, 'rgb(215,234,243)'],
        [0.9294117647058824, 'rgb(218,235,244)'],
        [0.9333333333333333, 'rgb(220,236,244)'],
        [0.9372549019607843, 'rgb(222,237,245)'],
        [0.9411764705882353, 'rgb(224,238,245)'],
        [0.9450980392156862, 'rgb(226,239,246)'],
        [0.9490196078431372, 'rgb(228,240,246)'],
        [0.9529411764705882, 'rgb(230,241,247)'],
        [0.9568627450980393, 'rgb(232,243,247)'],
        [0.9607843137254902, 'rgb(234,244,248)'],
        [0.9647058823529412, 'rgb(237,245,249)'],
        [0.9686274509803922, 'rgb(239,246,249)'],
        [0.9725490196078431, 'rgb(241,247,250)'],
        [0.9764705882352941, 'rgb(243,248,251)'],
        [0.9803921568627451, 'rgb(245,249,251)'],
        [0.984313725490196, 'rgb(247,250,252)'],
        [0.9882352941176471, 'rgb(249,252,253)'],
        [0.9921568627450981, 'rgb(251,253,253)'],
        [0.996078431372549, 'rgb(253,254,254)'],
        [1.0, 'rgb(255,255,255)'],
    ],
    'cmr.waterlily': [
        [0.0, 'rgb(32,2,55)'],
        [0.00392156862745098, 'rgb(34,2,58)'],
        [0.00784313725490196, 'rgb(37,2,61)'],
        [0.011764705882352941, 'rgb(39,3,64)'],
        [0.01568627450980392, 'rgb(42,3,67)'],
        [0.0196078431372549, 'rgb(44,3,71)'],
        [0.023529411764705882, 'rgb(47,4,74)'],
        [0.027450980392156862, 'rgb(49,4,78)'],
        [0.03137254901960784, 'rgb(52,4,81)'],
        [0.03529411764705882, 'rgb(54,4,85)'],
        [0.0392156862745098, 'rgb(57,4,89)'],
        [0.043137254901960784, 'rgb(59,4,92)'],
        [0.047058823529411764, 'rgb(61,4,96)'],
        [0.050980392156862744, 'rgb(63,5,100)'],
        [0.054901960784313725, 'rgb(65,6,104)'],
        [0.058823529411764705, 'rgb(67,7,108)'],
        [0.06274509803921569, 'rgb(68,9,111)'],
        [0.06666666666666667, 'rgb(69,12,115)'],
        [0.07058823529411765, 'rgb(70,16,118)'],
        [0.07450980392156863, 'rgb(71,19,120)'],
        [0.0784313725490196, 'rgb(72,22,123)'],
        [0.08235294117647059, 'rgb(73,25,125)'],
        [0.08627450980392157, 'rgb(73,29,127)'],
        [0.09019607843137255, 'rgb(74,32,129)'],
        [0.09411764705882353, 'rgb(74,35,131)'],
        [0.09803921568627451, 'rgb(75,38,133)'],
        [0.10196078431372549, 'rgb(75,41,135)'],
        [0.10588235294117647, 'rgb(76,43,136)'],
        [0.10980392156862745, 'rgb(76,46,138)'],
        [0.11372549019607843, 'rgb(76,49,139)'],
        [0.11764705882352941, 'rgb(77,52,141)'],
        [0.12156862745098039, 'rgb(77,54,142)'],
        [0.12549019607843137, 'rgb(77,57,144)'],
        [0.12941176470588237, 'rgb(77,59,145)'],
        [0.13333333333333333, 'rgb(77,62,147)'],
        [0.13725490196078433, 'rgb(78,64,148)'],
        [0.1411764705882353, 'rgb(78,67,150)'],
        [0.1450980392156863, 'rgb(78,69,151)'],
        [0.14901960784313725, 'rgb(78,72,152)'],
        [0.15294117647058825, 'rgb(78,74,154)'],
        [0.1568627450980392, 'rgb(78,77,155)'],
        [0.1607843137254902, 'rgb(79,79,156)'],
        [0.16470588235294117, 'rgb(79,81,158)'],
        [0.16862745098039217, 'rgb(79,84,159)'],
        [0.17254901960784313, 'rgb(79,86,160)'],
        [0.17647058823529413, 'rgb(79,88,162)'],
        [0.1803921568627451, 'rgb(79,91,163)'],
        [0.1843137254901961, 'rgb(79,93,164)'],
        [0.18823529411764706, 'rgb(79,95,165)'],
        [0.19215686274509805, 'rgb(79,98,167)'],
        [0.19607843137254902, 'rgb(79,100,168)'],
        [0.2, 'rgb(79,102,169)'],
        [0.20392156862745098, 'rgb(79,104,171)'],
        [0.20784313725490197, 'rgb(80,107,172)'],
        [0.21176470588235294, 'rgb(80,109,173)'],
        [0.21568627450980393, 'rgb(80,111,174)'],
        [0.2196078431372549, 'rgb(80,113,176)'],
        [0.2235294117647059, 'rgb(80,116,177)'],
        [0.22745098039215686, 'rgb(80,118,178)'],
        [0.23137254901960785, 'rgb(80,120,179)'],
        [0.23529411764705882, 'rgb(80,122,181)'],
        [0.23921568627450981, 'rgb(80,125,182)'],
        [0.24313725490196078, 'rgb(80,127,183)'],
        [0.24705882352941178, 'rgb(80,129,184)'],
        [0.25098039215686274, 'rgb(80,131,185)'],
        [0.2549019607843137, 'rgb(80,134,187)'],
        [0.25882352941176473, 'rgb(80,136,188)'],
        [0.2627450980392157, 'rgb(80,138,189)'],
        [0.26666666666666666, 'rgb(80,141,190)'],
        [0.27058823529411763, 'rgb(80,143,191)'],
        [0.27450980392156865, 'rgb(80,145,192)'],
        [0.2784313725490196, 'rgb(81,147,193)'],
        [0.2823529411764706, 'rgb(81,150,194)'],
        [0.28627450980392155, 'rgb(81,152,195)'],
        [0.2901960784313726, 'rgb(82,154,196)'],
        [0.29411764705882354, 'rgb(82,156,197)'],
        [0.2980392156862745, 'rgb(83,159,198)'],
        [0.30196078431372547, 'rgb(84,161,199)'],
        [0.3058823529411765, 'rgb(85,163,199)'],
        [0.30980392156862746, 'rgb(86,165,200)'],
        [0.3137254901960784, 'rgb(87,167,201)'],
        [0.3176470588235294, 'rgb(89,169,201)'],
        [0.3215686274509804, 'rgb(91,172,202)'],
        [0.3254901960784314, 'rgb(93,174,202)'],
        [0.32941176470588235, 'rgb(95,176,203)'],
        [0.3333333333333333, 'rgb(98,178,203)'],
        [0.33725490196078434, 'rgb(101,180,203)'],
        [0.3411764705882353, 'rgb(104,182,204)'],
        [0.34509803921568627, 'rgb(107,184,204)'],
        [0.34901960784313724, 'rgb(111,185,205)'],
        [0.35294117647058826, 'rgb(114,187,205)'],
        [0.3568627450980392, 'rgb(118,189,205)'],
        [0.3607843137254902, 'rgb(122,191,206)'],
        [0.36470588235294116, 'rgb(126,192,206)'],
        [0.3686274509803922, 'rgb(130,194,207)'],
        [0.37254901960784315, 'rgb(134,196,208)'],
        [0.3764705882352941, 'rgb(138,198,208)'],
        [0.3803921568627451, 'rgb(142,199,209)'],
        [0.3843137254901961, 'rgb(146,201,210)'],
        [0.38823529411764707, 'rgb(150,203,211)'],
        [0.39215686274509803, 'rgb(154,204,212)'],
        [0.396078431372549, 'rgb(158,206,213)'],
        [0.4, 'rgb(162,208,214)'],
        [0.403921568627451, 'rgb(166,209,215)'],
        [0.40784313725490196, 'rgb(170,211,216)'],
        [0.4117647058823529, 'rgb(174,213,218)'],
        [0.41568627450980394, 'rgb(177,214,219)'],
        [0.4196078431372549, 'rgb(181,216,220)'],
        [0.4235294117647059, 'rgb(185,218,221)'],
        [0.42745098039215684, 'rgb(189,220,223)'],
        [0.43137254901960786, 'rgb(192,221,224)'],
        [0.43529411764705883, 'rgb(196,223,226)'],
        [0.4392156862745098, 'rgb(200,225,227)'],
        [0.44313725490196076, 'rgb(203,227,229)'],
        [0.4470588235294118, 'rgb(207,229,230)'],
        [0.45098039215686275, 'rgb(211,230,232)'],
        [0.4549019607843137, 'rgb(214,232,234)'],
        [0.4588235294117647, 'rgb(218,234,235)'],
        [0.4627450980392157, 'rgb(222,236,237)'],
        [0.4666666666666667, 'rgb(225,238,239)'],
        [0.47058823529411764, 'rgb(229,240,241)'],
        [0.4745098039215686, 'rgb(232,242,242)'],
        [0.47843137254901963, 'rgb(236,244,244)'],
        [0.4823529411764706, 'rgb(239,246,246)'],
        [0.48627450980392156, 'rgb(243,248,248)'],
        [0.49019607843137253, 'rgb(246,250,250)'],
        [0.49411764705882355, 'rgb(250,252,252)'],
        [0.4980392156862745, 'rgb(253,254,254)'],
        [0.5019607843137255, 'rgb(253,254,254)'],
        [0.5058823529411764, 'rgb(250,252,251)'],
        [0.5098039215686274, 'rgb(247,250,248)'],
        [0.5137254901960784, 'rgb(244,248,245)'],
        [0.5176470588235295, 'rgb(241,246,242)'],
        [0.5215686274509804, 'rgb(237,244,239)'],
        [0.5254901960784314, 'rgb(234,242,236)'],
        [0.5294117647058824, 'rgb(231,240,233)'],
        [0.5333333333333333, 'rgb(227,238,230)'],
        [0.5372549019607843, 'rgb(224,236,226)'],
        [0.5411764705882353, 'rgb(221,234,223)'],
        [0.5450980392156862, 'rgb(218,232,220)'],
        [0.5490196078431373, 'rgb(214,231,217)'],
        [0.5529411764705883, 'rgb(211,229,214)'],
        [0.5568627450980392, 'rgb(208,227,211)'],
        [0.5607843137254902, 'rgb(205,225,208)'],
        [0.5647058823529412, 'rgb(201,223,205)'],
        [0.5686274509803921, 'rgb(198,222,201)'],
        [0.5725490196078431, 'rgb(195,220,198)'],
        [0.5764705882352941, 'rgb(192,218,195)'],
        [0.5803921568627451, 'rgb(188,217,192)'],
        [0.5843137254901961, 'rgb(185,215,189)'],
        [0.5882352941176471, 'rgb(182,213,185)'],
        [0.592156862745098, 'rgb(179,212,182)'],
        [0.596078431372549, 'rgb(175,210,179)'],
        [0.6, 'rgb(172,208,176)'],
        [0.6039215686274509, 'rgb(169,207,173)'],
        [0.6078431372549019, 'rgb(165,205,169)'],
        [0.611764705882353, 'rgb(162,203,166)'],
        [0.615686274509804, 'rgb(159,202,163)'],
        [0.6196078431372549, 'rgb(156,200,160)'],
        [0.6235294117647059, 'rgb(152,199,156)'],
        [0.6274509803921569, 'rgb(149,197,153)'],
        [0.6313725490196078, 'rgb(146,196,150)'],
        [0.6352941176470588, 'rgb(142,194,146)'],
        [0.6392156862745098, 'rgb(139,192,143)'],
        [0.6431372549019608, 'rgb(136,191,140)'],
        [0.6470588235294118, 'rgb(132,189,136)'],
        [0.6509803921568628, 'rgb(129,188,133)'],
        [0.6549019607843137, 'rgb(126,186,130)'],
        [0.6588235294117647, 'rgb(122,185,126)'],
        [0.6627450980392157, 'rgb(119,183,123)'],
        [0.6666666666666666, 'rgb(116,182,119)'],
        [0.6705882352941176, 'rgb(112,180,116)'],
        [0.6745098039215687, 'rgb(109,179,112)'],
        [0.6784313725490196, 'rgb(105,177,109)'],
        [0.6823529411764706, 'rgb(102,176,105)'],
        [0.6862745098039216, 'rgb(99,174,102)'],
        [0.6901960784313725, 'rgb(95,173,98)'],
        [0.6941176470588235, 'rgb(92,171,95)'],
        [0.6980392156862745, 'rgb(88,169,91)'],
        [0.7019607843137254, 'rgb(85,168,87)'],
        [0.7058823529411765, 'rgb(82,166,83)'],
        [0.7098039215686275, 'rgb(78,165,79)'],
        [0.7137254901960784, 'rgb(75,163,76)'],
        [0.7176470588235294, 'rgb(72,162,72)'],
        [0.7215686274509804, 'rgb(69,160,68)'],
        [0.7254901960784313, 'rgb(65,158,63)'],
        [0.7294117647058823, 'rgb(63,157,59)'],
        [0.7333333333333333, 'rgb(60,155,55)'],
        [0.7372549019607844, 'rgb(58,153,50)'],
        [0.7411764705882353, 'rgb(57,151,45)'],
        [0.7450980392156863, 'rgb(56,150,40)'],
        [0.7490196078431373, 'rgb(56,147,36)'],
        [0.7529411764705882, 'rgb(58,145,31)'],
        [0.7568627450980392, 'rgb(60,143,27)'],
        [0.7607843137254902, 'rgb(62,141,24)'],
        [0.7647058823529411, 'rgb(64,138,22)'],
        [0.7686274509803922, 'rgb(66,136,21)'],
        [0.7725490196078432, 'rgb(67,133,20)'],
        [0.7764705882352941, 'rgb(68,131,19)'],
        [0.7803921568627451, 'rgb(69,129,19)'],
        [0.7843137254901961, 'rgb(70,126,19)'],
        [0.788235294117647, 'rgb(71,124,19)'],
        [0.792156862745098, 'rgb(72,122,19)'],
        [0.796078431372549, 'rgb(72,120,19)'],
        [0.8, 'rgb(72,117,19)'],
        [0.803921568627451, 'rgb(72,115,19)'],
        [0.807843137254902, 'rgb(73,113,19)'],
        [0.8117647058823529, 'rgb(73,111,20)'],
        [0.8156862745098039, 'rgb(73,109,20)'],
        [0.8196078431372549, 'rgb(73,107,20)'],
        [0.8235294117647058, 'rgb(72,104,20)'],
        [0.8274509803921568, 'rgb(72,102,20)'],
        [0.8313725490196079, 'rgb(72,100,21)'],
        [0.8352941176470589, 'rgb(71,98,21)'],
        [0.8392156862745098, 'rgb(71,96,21)'],
        [0.8431372549019608, 'rgb(71,94,21)'],
        [0.8470588235294118, 'rgb(70,92,21)'],
        [0.8509803921568627, 'rgb(70,90,21)'],
        [0.8549019607843137, 'rgb(69,88,21)'],
        [0.8588235294117647, 'rgb(68,86,21)'],
        [0.8627450980392157, 'rgb(68,84,21)'],
        [0.8666666666666667, 'rgb(67,82,21)'],
        [0.8705882352941177, 'rgb(66,80,21)'],
        [0.8745098039215686, 'rgb(66,78,21)'],
        [0.8784313725490196, 'rgb(65,76,21)'],
        [0.8823529411764706, 'rgb(64,74,21)'],
        [0.8862745098039215, 'rgb(63,72,21)'],
        [0.8901960784313725, 'rgb(62,70,21)'],
        [0.8941176470588236, 'rgb(61,68,20)'],
        [0.8980392156862745, 'rgb(60,66,20)'],
        [0.9019607843137255, 'rgb(60,64,20)'],
        [0.9058823529411765, 'rgb(59,62,20)'],
        [0.9098039215686274, 'rgb(58,60,19)'],
        [0.9137254901960784, 'rgb(57,58,19)'],
        [0.9176470588235294, 'rgb(55,56,19)'],
        [0.9215686274509803, 'rgb(54,55,18)'],
        [0.9254901960784314, 'rgb(53,53,18)'],
        [0.9294117647058824, 'rgb(52,51,17)'],
        [0.9333333333333333, 'rgb(51,49,17)'],
        [0.9372549019607843, 'rgb(50,47,17)'],
        [0.9411764705882353, 'rgb(49,45,16)'],
        [0.9450980392156862, 'rgb(47,43,16)'],
        [0.9490196078431372, 'rgb(46,41,15)'],
        [0.9529411764705882, 'rgb(45,39,14)'],
        [0.9568627450980393, 'rgb(44,37,14)'],
        [0.9607843137254902, 'rgb(42,35,13)'],
        [0.9647058823529412, 'rgb(41,33,13)'],
        [0.9686274509803922, 'rgb(40,32,12)'],
        [0.9725490196078431, 'rgb(38,30,11)'],
        [0.9764705882352941, 'rgb(37,28,11)'],
        [0.9803921568627451, 'rgb(35,26,10)'],
        [0.984313725490196, 'rgb(34,24,9)'],
        [0.9882352941176471, 'rgb(32,22,8)'],
        [0.9921568627450981, 'rgb(31,20,8)'],
        [0.996078431372549, 'rgb(29,18,7)'],
        [1.0, 'rgb(27,16,6)'],
    ],
    # cmocean colormaps converted for Plotly
    'cmo.algae': [
        [0.0, 'rgb(215,249,208)'],
        [0.00392156862745098, 'rgb(214,248,206)'],
        [0.00784313725490196, 'rgb(212,247,205)'],
        [0.011764705882352941, 'rgb(211,246,203)'],
        [0.01568627450980392, 'rgb(210,245,202)'],
        [0.0196078431372549, 'rgb(209,244,200)'],
        [0.023529411764705882, 'rgb(207,244,199)'],
        [0.027450980392156862, 'rgb(206,243,197)'],
        [0.03137254901960784, 'rgb(205,242,196)'],
        [0.03529411764705882, 'rgb(204,241,195)'],
        [0.0392156862745098, 'rgb(202,240,193)'],
        [0.043137254901960784, 'rgb(201,239,192)'],
        [0.047058823529411764, 'rgb(200,238,190)'],
        [0.050980392156862744, 'rgb(199,237,189)'],
        [0.054901960784313725, 'rgb(197,236,187)'],
        [0.058823529411764705, 'rgb(196,235,186)'],
        [0.06274509803921569, 'rgb(195,235,185)'],
        [0.06666666666666667, 'rgb(194,234,183)'],
        [0.07058823529411765, 'rgb(192,233,182)'],
        [0.07450980392156863, 'rgb(191,232,180)'],
        [0.0784313725490196, 'rgb(190,231,179)'],
        [0.08235294117647059, 'rgb(189,230,177)'],
        [0.08627450980392157, 'rgb(187,229,176)'],
        [0.09019607843137255, 'rgb(186,228,175)'],
        [0.09411764705882353, 'rgb(185,228,173)'],
        [0.09803921568627451, 'rgb(184,227,172)'],
        [0.10196078431372549, 'rgb(182,226,171)'],
        [0.10588235294117647, 'rgb(181,225,169)'],
        [0.10980392156862745, 'rgb(180,224,168)'],
        [0.11372549019607843, 'rgb(178,223,166)'],
        [0.11764705882352941, 'rgb(177,222,165)'],
        [0.12156862745098039, 'rgb(176,222,164)'],
        [0.12549019607843137, 'rgb(175,221,162)'],
        [0.12941176470588237, 'rgb(173,220,161)'],
        [0.13333333333333333, 'rgb(172,219,160)'],
        [0.13725490196078433, 'rgb(171,218,158)'],
        [0.1411764705882353, 'rgb(170,218,157)'],
        [0.1450980392156863, 'rgb(168,217,156)'],
        [0.14901960784313725, 'rgb(167,216,154)'],
        [0.15294117647058825, 'rgb(166,215,153)'],
        [0.1568627450980392, 'rgb(164,214,152)'],
        [0.1607843137254902, 'rgb(163,213,150)'],
        [0.16470588235294117, 'rgb(162,213,149)'],
        [0.16862745098039217, 'rgb(160,212,148)'],
        [0.17254901960784313, 'rgb(159,211,146)'],
        [0.17647058823529413, 'rgb(158,210,145)'],
        [0.1803921568627451, 'rgb(157,209,144)'],
        [0.1843137254901961, 'rgb(155,209,143)'],
        [0.18823529411764706, 'rgb(154,208,141)'],
        [0.19215686274509805, 'rgb(153,207,140)'],
        [0.19607843137254902, 'rgb(151,206,139)'],
        [0.2, 'rgb(150,205,138)'],
        [0.20392156862745098, 'rgb(149,205,136)'],
        [0.20784313725490197, 'rgb(147,204,135)'],
        [0.21176470588235294, 'rgb(146,203,134)'],
        [0.21568627450980393, 'rgb(145,202,133)'],
        [0.2196078431372549, 'rgb(143,202,131)'],
        [0.2235294117647059, 'rgb(142,201,130)'],
        [0.22745098039215686, 'rgb(140,200,129)'],
        [0.23137254901960785, 'rgb(139,199,128)'],
        [0.23529411764705882, 'rgb(138,199,126)'],
        [0.23921568627450981, 'rgb(136,198,125)'],
        [0.24313725490196078, 'rgb(135,197,124)'],
        [0.24705882352941178, 'rgb(133,196,123)'],
        [0.25098039215686274, 'rgb(132,196,122)'],
        [0.2549019607843137, 'rgb(131,195,121)'],
        [0.25882352941176473, 'rgb(129,194,119)'],
        [0.2627450980392157, 'rgb(128,193,118)'],
        [0.26666666666666666, 'rgb(126,193,117)'],
        [0.27058823529411763, 'rgb(125,192,116)'],
        [0.27450980392156865, 'rgb(123,191,115)'],
        [0.2784313725490196, 'rgb(122,190,114)'],
        [0.2823529411764706, 'rgb(120,190,113)'],
        [0.28627450980392155, 'rgb(119,189,111)'],
        [0.2901960784313726, 'rgb(117,188,110)'],
        [0.29411764705882354, 'rgb(116,187,109)'],
        [0.2980392156862745, 'rgb(114,187,108)'],
        [0.30196078431372547, 'rgb(113,186,107)'],
        [0.3058823529411765, 'rgb(111,185,106)'],
        [0.30980392156862746, 'rgb(110,185,105)'],
        [0.3137254901960784, 'rgb(108,184,104)'],
        [0.3176470588235294, 'rgb(107,183,103)'],
        [0.3215686274509804, 'rgb(105,182,102)'],
        [0.3254901960784314, 'rgb(103,182,101)'],
        [0.32941176470588235, 'rgb(102,181,100)'],
        [0.3333333333333333, 'rgb(100,180,99)'],
        [0.33725490196078434, 'rgb(98,180,98)'],
        [0.3411764705882353, 'rgb(97,179,97)'],
        [0.34509803921568627, 'rgb(95,178,96)'],
        [0.34901960784313724, 'rgb(93,178,95)'],
        [0.35294117647058826, 'rgb(91,177,94)'],
        [0.3568627450980392, 'rgb(90,176,93)'],
        [0.3607843137254902, 'rgb(88,175,93)'],
        [0.36470588235294116, 'rgb(86,175,92)'],
        [0.3686274509803922, 'rgb(84,174,91)'],
        [0.37254901960784315, 'rgb(82,173,90)'],
        [0.3764705882352941, 'rgb(80,173,89)'],
        [0.3803921568627451, 'rgb(78,172,89)'],
        [0.3843137254901961, 'rgb(76,171,88)'],
        [0.38823529411764707, 'rgb(74,171,87)'],
        [0.39215686274509803, 'rgb(72,170,87)'],
        [0.396078431372549, 'rgb(70,169,86)'],
        [0.4, 'rgb(68,168,85)'],
        [0.403921568627451, 'rgb(66,168,85)'],
        [0.40784313725490196, 'rgb(63,167,84)'],
        [0.4117647058823529, 'rgb(61,166,84)'],
        [0.41568627450980394, 'rgb(59,166,84)'],
        [0.4196078431372549, 'rgb(57,165,83)'],
        [0.4235294117647059, 'rgb(55,164,83)'],
        [0.42745098039215684, 'rgb(52,163,83)'],
        [0.43137254901960786, 'rgb(50,163,82)'],
        [0.43529411764705883, 'rgb(48,162,82)'],
        [0.4392156862745098, 'rgb(46,161,82)'],
        [0.44313725490196076, 'rgb(44,160,82)'],
        [0.4470588235294118, 'rgb(42,160,82)'],
        [0.45098039215686275, 'rgb(40,159,81)'],
        [0.4549019607843137, 'rgb(38,158,81)'],
        [0.4588235294117647, 'rgb(36,157,81)'],
        [0.4627450980392157, 'rgb(34,156,81)'],
        [0.4666666666666667, 'rgb(32,156,81)'],
        [0.47058823529411764, 'rgb(30,155,81)'],
        [0.4745098039215686, 'rgb(28,154,81)'],
        [0.47843137254901963, 'rgb(27,153,81)'],
        [0.4823529411764706, 'rgb(25,152,81)'],
        [0.48627450980392156, 'rgb(24,151,80)'],
        [0.49019607843137253, 'rgb(22,150,80)'],
        [0.49411764705882355, 'rgb(21,150,80)'],
        [0.4980392156862745, 'rgb(19,149,80)'],
        [0.5019607843137255, 'rgb(18,148,80)'],
        [0.5058823529411764, 'rgb(16,147,80)'],
        [0.5098039215686274, 'rgb(15,146,80)'],
        [0.5137254901960784, 'rgb(14,145,80)'],
        [0.5176470588235295, 'rgb(13,144,79)'],
        [0.5215686274509804, 'rgb(12,143,79)'],
        [0.5254901960784314, 'rgb(11,143,79)'],
        [0.5294117647058824, 'rgb(10,142,79)'],
        [0.5333333333333333, 'rgb(9,141,79)'],
        [0.5372549019607843, 'rgb(9,140,79)'],
        [0.5411764705882353, 'rgb(8,139,78)'],
        [0.5450980392156862, 'rgb(8,138,78)'],
        [0.5490196078431373, 'rgb(7,137,78)'],
        [0.5529411764705883, 'rgb(7,136,78)'],
        [0.5568627450980392, 'rgb(7,135,77)'],
        [0.5607843137254902, 'rgb(7,134,77)'],
        [0.5647058823529412, 'rgb(7,134,77)'],
        [0.5686274509803921, 'rgb(7,133,77)'],
        [0.5725490196078431, 'rgb(7,132,77)'],
        [0.5764705882352941, 'rgb(7,131,76)'],
        [0.5803921568627451, 'rgb(7,130,76)'],
        [0.5843137254901961, 'rgb(8,129,76)'],
        [0.5882352941176471, 'rgb(8,128,75)'],
        [0.592156862745098, 'rgb(8,127,75)'],
        [0.596078431372549, 'rgb(9,126,75)'],
        [0.6, 'rgb(9,125,75)'],
        [0.6039215686274509, 'rgb(10,124,74)'],
        [0.6078431372549019, 'rgb(10,124,74)'],
        [0.611764705882353, 'rgb(11,123,74)'],
        [0.615686274509804, 'rgb(11,122,73)'],
        [0.6196078431372549, 'rgb(12,121,73)'],
        [0.6235294117647059, 'rgb(12,120,73)'],
        [0.6274509803921569, 'rgb(13,119,72)'],
        [0.6313725490196078, 'rgb(13,118,72)'],
        [0.6352941176470588, 'rgb(14,117,72)'],
        [0.6392156862745098, 'rgb(14,116,71)'],
        [0.6431372549019608, 'rgb(15,115,71)'],
        [0.6470588235294118, 'rgb(15,115,71)'],
        [0.6509803921568628, 'rgb(16,114,70)'],
        [0.6549019607843137, 'rgb(16,113,70)'],
        [0.6588235294117647, 'rgb(17,112,69)'],
        [0.6627450980392157, 'rgb(17,111,69)'],
        [0.6666666666666666, 'rgb(18,110,69)'],
        [0.6705882352941176, 'rgb(18,109,68)'],
        [0.6745098039215687, 'rgb(18,108,68)'],
        [0.6784313725490196, 'rgb(19,107,67)'],
        [0.6823529411764706, 'rgb(19,106,67)'],
        [0.6862745098039216, 'rgb(20,106,67)'],
        [0.6901960784313725, 'rgb(20,105,66)'],
        [0.6941176470588235, 'rgb(20,104,66)'],
        [0.6980392156862745, 'rgb(21,103,65)'],
        [0.7019607843137254, 'rgb(21,102,65)'],
        [0.7058823529411765, 'rgb(21,101,64)'],
        [0.7098039215686275, 'rgb(22,100,64)'],
        [0.7137254901960784, 'rgb(22,99,64)'],
        [0.7176470588235294, 'rgb(22,98,63)'],
        [0.7215686274509804, 'rgb(23,98,63)'],
        [0.7254901960784313, 'rgb(23,97,62)'],
        [0.7294117647058823, 'rgb(23,96,62)'],
        [0.7333333333333333, 'rgb(23,95,61)'],
        [0.7372549019607844, 'rgb(24,94,61)'],
        [0.7411764705882353, 'rgb(24,93,60)'],
        [0.7450980392156863, 'rgb(24,92,60)'],
        [0.7490196078431373, 'rgb(24,91,59)'],
        [0.7529411764705882, 'rgb(24,91,59)'],
        [0.7568627450980392, 'rgb(25,90,58)'],
        [0.7607843137254902, 'rgb(25,89,58)'],
        [0.7647058823529411, 'rgb(25,88,57)'],
        [0.7686274509803922, 'rgb(25,87,57)'],
        [0.7725490196078432, 'rgb(25,86,56)'],
        [0.7764705882352941, 'rgb(25,85,56)'],
        [0.7803921568627451, 'rgb(25,84,55)'],
        [0.7843137254901961, 'rgb(25,84,55)'],
        [0.788235294117647, 'rgb(26,83,54)'],
        [0.792156862745098, 'rgb(26,82,53)'],
        [0.796078431372549, 'rgb(26,81,53)'],
        [0.8, 'rgb(26,80,52)'],
        [0.803921568627451, 'rgb(26,79,52)'],
        [0.807843137254902, 'rgb(26,78,51)'],
        [0.8117647058823529, 'rgb(26,77,51)'],
        [0.8156862745098039, 'rgb(26,77,50)'],
        [0.8196078431372549, 'rgb(26,76,50)'],
        [0.8235294117647058, 'rgb(26,75,49)'],
        [0.8274509803921568, 'rgb(26,74,48)'],
        [0.8313725490196079, 'rgb(26,73,48)'],
        [0.8352941176470589, 'rgb(26,72,47)'],
        [0.8392156862745098, 'rgb(26,71,47)'],
        [0.8431372549019608, 'rgb(26,71,46)'],
        [0.8470588235294118, 'rgb(26,70,46)'],
        [0.8509803921568627, 'rgb(26,69,45)'],
        [0.8549019607843137, 'rgb(26,68,44)'],
        [0.8588235294117647, 'rgb(26,67,44)'],
        [0.8627450980392157, 'rgb(25,66,43)'],
        [0.8666666666666667, 'rgb(25,65,43)'],
        [0.8705882352941177, 'rgb(25,64,42)'],
        [0.8745098039215686, 'rgb(25,64,41)'],
        [0.8784313725490196, 'rgb(25,63,41)'],
        [0.8823529411764706, 'rgb(25,62,40)'],
        [0.8862745098039215, 'rgb(25,61,39)'],
        [0.8901960784313725, 'rgb(25,60,39)'],
        [0.8941176470588236, 'rgb(24,59,38)'],
        [0.8980392156862745, 'rgb(24,59,38)'],
        [0.9019607843137255, 'rgb(24,58,37)'],
        [0.9058823529411765, 'rgb(24,57,36)'],
        [0.9098039215686274, 'rgb(24,56,36)'],
        [0.9137254901960784, 'rgb(24,55,35)'],
        [0.9176470588235294, 'rgb(23,54,34)'],
        [0.9215686274509803, 'rgb(23,53,34)'],
        [0.9254901960784314, 'rgb(23,53,33)'],
        [0.9294117647058824, 'rgb(23,52,32)'],
        [0.9333333333333333, 'rgb(23,51,32)'],
        [0.9372549019607843, 'rgb(22,50,31)'],
        [0.9411764705882353, 'rgb(22,49,30)'],
        [0.9450980392156862, 'rgb(22,48,30)'],
        [0.9490196078431372, 'rgb(22,47,29)'],
        [0.9529411764705882, 'rgb(21,47,28)'],
        [0.9568627450980393, 'rgb(21,46,28)'],
        [0.9607843137254902, 'rgb(21,45,27)'],
        [0.9647058823529412, 'rgb(20,44,26)'],
        [0.9686274509803922, 'rgb(20,43,26)'],
        [0.9725490196078431, 'rgb(20,42,25)'],
        [0.9764705882352941, 'rgb(20,41,24)'],
        [0.9803921568627451, 'rgb(19,41,24)'],
        [0.984313725490196, 'rgb(19,40,23)'],
        [0.9882352941176471, 'rgb(19,39,22)'],
        [0.9921568627450981, 'rgb(18,38,22)'],
        [0.996078431372549, 'rgb(18,37,21)'],
        [1.0, 'rgb(18,36,20)'],
    ],
    'cmo.amp': [
        [0.0, 'rgb(241,237,236)'],
        [0.00392156862745098, 'rgb(241,236,235)'],
        [0.00784313725490196, 'rgb(240,235,233)'],
        [0.011764705882352941, 'rgb(239,233,232)'],
        [0.01568627450980392, 'rgb(239,232,231)'],
        [0.0196078431372549, 'rgb(238,231,229)'],
        [0.023529411764705882, 'rgb(238,230,228)'],
        [0.027450980392156862, 'rgb(237,229,227)'],
        [0.03137254901960784, 'rgb(237,227,225)'],
        [0.03529411764705882, 'rgb(236,226,224)'],
        [0.0392156862745098, 'rgb(236,225,222)'],
        [0.043137254901960784, 'rgb(235,224,221)'],
        [0.047058823529411764, 'rgb(235,223,220)'],
        [0.050980392156862744, 'rgb(234,221,218)'],
        [0.054901960784313725, 'rgb(234,220,217)'],
        [0.058823529411764705, 'rgb(233,219,215)'],
        [0.06274509803921569, 'rgb(233,218,214)'],
        [0.06666666666666667, 'rgb(233,217,212)'],
        [0.07058823529411765, 'rgb(232,216,211)'],
        [0.07450980392156863, 'rgb(232,214,210)'],
        [0.0784313725490196, 'rgb(231,213,208)'],
        [0.08235294117647059, 'rgb(231,212,207)'],
        [0.08627450980392157, 'rgb(230,211,205)'],
        [0.09019607843137255, 'rgb(230,210,204)'],
        [0.09411764705882353, 'rgb(230,209,202)'],
        [0.09803921568627451, 'rgb(229,207,201)'],
        [0.10196078431372549, 'rgb(229,206,200)'],
        [0.10588235294117647, 'rgb(228,205,198)'],
        [0.10980392156862745, 'rgb(228,204,197)'],
        [0.11372549019607843, 'rgb(228,203,195)'],
        [0.11764705882352941, 'rgb(227,201,194)'],
        [0.12156862745098039, 'rgb(227,200,192)'],
        [0.12549019607843137, 'rgb(226,199,191)'],
        [0.12941176470588237, 'rgb(226,198,189)'],
        [0.13333333333333333, 'rgb(226,197,188)'],
        [0.13725490196078433, 'rgb(225,196,187)'],
        [0.1411764705882353, 'rgb(225,195,185)'],
        [0.1450980392156863, 'rgb(225,193,184)'],
        [0.14901960784313725, 'rgb(224,192,182)'],
        [0.15294117647058825, 'rgb(224,191,181)'],
        [0.1568627450980392, 'rgb(223,190,179)'],
        [0.1607843137254902, 'rgb(223,189,178)'],
        [0.16470588235294117, 'rgb(223,188,176)'],
        [0.16862745098039217, 'rgb(222,186,175)'],
        [0.17254901960784313, 'rgb(222,185,174)'],
        [0.17647058823529413, 'rgb(222,184,172)'],
        [0.1803921568627451, 'rgb(221,183,171)'],
        [0.1843137254901961, 'rgb(221,182,169)'],
        [0.18823529411764706, 'rgb(221,181,168)'],
        [0.19215686274509805, 'rgb(220,180,166)'],
        [0.19607843137254902, 'rgb(220,178,165)'],
        [0.2, 'rgb(220,177,163)'],
        [0.20392156862745098, 'rgb(219,176,162)'],
        [0.20784313725490197, 'rgb(219,175,161)'],
        [0.21176470588235294, 'rgb(219,174,159)'],
        [0.21568627450980393, 'rgb(218,173,158)'],
        [0.2196078431372549, 'rgb(218,172,156)'],
        [0.2235294117647059, 'rgb(217,170,155)'],
        [0.22745098039215686, 'rgb(217,169,153)'],
        [0.23137254901960785, 'rgb(217,168,152)'],
        [0.23529411764705882, 'rgb(216,167,150)'],
        [0.23921568627450981, 'rgb(216,166,149)'],
        [0.24313725490196078, 'rgb(216,165,148)'],
        [0.24705882352941178, 'rgb(215,164,146)'],
        [0.25098039215686274, 'rgb(215,162,145)'],
        [0.2549019607843137, 'rgb(215,161,143)'],
        [0.25882352941176473, 'rgb(214,160,142)'],
        [0.2627450980392157, 'rgb(214,159,140)'],
        [0.26666666666666666, 'rgb(214,158,139)'],
        [0.27058823529411763, 'rgb(213,157,137)'],
        [0.27450980392156865, 'rgb(213,156,136)'],
        [0.2784313725490196, 'rgb(213,154,135)'],
        [0.2823529411764706, 'rgb(212,153,133)'],
        [0.28627450980392155, 'rgb(212,152,132)'],
        [0.2901960784313726, 'rgb(212,151,130)'],
        [0.29411764705882354, 'rgb(211,150,129)'],
        [0.2980392156862745, 'rgb(211,149,127)'],
        [0.30196078431372547, 'rgb(211,148,126)'],
        [0.3058823529411765, 'rgb(210,146,125)'],
        [0.30980392156862746, 'rgb(210,145,123)'],
        [0.3137254901960784, 'rgb(210,144,122)'],
        [0.3176470588235294, 'rgb(209,143,120)'],
        [0.3215686274509804, 'rgb(209,142,119)'],
        [0.3254901960784314, 'rgb(209,141,118)'],
        [0.32941176470588235, 'rgb(208,140,116)'],
        [0.3333333333333333, 'rgb(208,139,115)'],
        [0.33725490196078434, 'rgb(208,137,113)'],
        [0.3411764705882353, 'rgb(207,136,112)'],
        [0.34509803921568627, 'rgb(207,135,111)'],
        [0.34901960784313724, 'rgb(207,134,109)'],
        [0.35294117647058826, 'rgb(206,133,108)'],
        [0.3568627450980392, 'rgb(206,132,106)'],
        [0.3607843137254902, 'rgb(205,131,105)'],
        [0.36470588235294116, 'rgb(205,129,104)'],
        [0.3686274509803922, 'rgb(205,128,102)'],
        [0.37254901960784315, 'rgb(204,127,101)'],
        [0.3764705882352941, 'rgb(204,126,100)'],
        [0.3803921568627451, 'rgb(204,125,98)'],
        [0.3843137254901961, 'rgb(203,124,97)'],
        [0.38823529411764707, 'rgb(203,122,96)'],
        [0.39215686274509803, 'rgb(203,121,94)'],
        [0.396078431372549, 'rgb(202,120,93)'],
        [0.4, 'rgb(202,119,91)'],
        [0.403921568627451, 'rgb(201,118,90)'],
        [0.40784313725490196, 'rgb(201,117,89)'],
        [0.4117647058823529, 'rgb(201,116,87)'],
        [0.41568627450980394, 'rgb(200,114,86)'],
        [0.4196078431372549, 'rgb(200,113,85)'],
        [0.4235294117647059, 'rgb(200,112,84)'],
        [0.42745098039215684, 'rgb(199,111,82)'],
        [0.43137254901960786, 'rgb(199,110,81)'],
        [0.43529411764705883, 'rgb(198,109,80)'],
        [0.4392156862745098, 'rgb(198,107,78)'],
        [0.44313725490196076, 'rgb(198,106,77)'],
        [0.4470588235294118, 'rgb(197,105,76)'],
        [0.45098039215686275, 'rgb(197,104,74)'],
        [0.4549019607843137, 'rgb(197,103,73)'],
        [0.4588235294117647, 'rgb(196,101,72)'],
        [0.4627450980392157, 'rgb(196,100,71)'],
        [0.4666666666666667, 'rgb(195,99,70)'],
        [0.47058823529411764, 'rgb(195,98,68)'],
        [0.4745098039215686, 'rgb(195,97,67)'],
        [0.47843137254901963, 'rgb(194,95,66)'],
        [0.4823529411764706, 'rgb(194,94,65)'],
        [0.48627450980392156, 'rgb(193,93,63)'],
        [0.49019607843137253, 'rgb(193,92,62)'],
        [0.49411764705882355, 'rgb(192,91,61)'],
        [0.4980392156862745, 'rgb(192,89,60)'],
        [0.5019607843137255, 'rgb(192,88,59)'],
        [0.5058823529411764, 'rgb(191,87,58)'],
        [0.5098039215686274, 'rgb(191,86,57)'],
        [0.5137254901960784, 'rgb(190,84,56)'],
        [0.5176470588235295, 'rgb(190,83,54)'],
        [0.5215686274509804, 'rgb(189,82,53)'],
        [0.5254901960784314, 'rgb(189,81,52)'],
        [0.5294117647058824, 'rgb(189,79,51)'],
        [0.5333333333333333, 'rgb(188,78,50)'],
        [0.5372549019607843, 'rgb(188,77,49)'],
        [0.5411764705882353, 'rgb(187,76,48)'],
        [0.5450980392156862, 'rgb(187,74,48)'],
        [0.5490196078431373, 'rgb(186,73,47)'],
        [0.5529411764705883, 'rgb(186,72,46)'],
        [0.5568627450980392, 'rgb(185,70,45)'],
        [0.5607843137254902, 'rgb(185,69,44)'],
        [0.5647058823529412, 'rgb(184,68,43)'],
        [0.5686274509803921, 'rgb(184,66,43)'],
        [0.5725490196078431, 'rgb(183,65,42)'],
        [0.5764705882352941, 'rgb(183,64,41)'],
        [0.5803921568627451, 'rgb(182,63,41)'],
        [0.5843137254901961, 'rgb(181,61,40)'],
        [0.5882352941176471, 'rgb(181,60,39)'],
        [0.592156862745098, 'rgb(180,59,39)'],
        [0.596078431372549, 'rgb(180,57,38)'],
        [0.6, 'rgb(179,56,38)'],
        [0.6039215686274509, 'rgb(178,55,38)'],
        [0.6078431372549019, 'rgb(178,53,37)'],
        [0.611764705882353, 'rgb(177,52,37)'],
        [0.615686274509804, 'rgb(176,51,37)'],
        [0.6196078431372549, 'rgb(176,49,37)'],
        [0.6235294117647059, 'rgb(175,48,36)'],
        [0.6274509803921569, 'rgb(174,47,36)'],
        [0.6313725490196078, 'rgb(174,45,36)'],
        [0.6352941176470588, 'rgb(173,44,36)'],
        [0.6392156862745098, 'rgb(172,43,36)'],
        [0.6431372549019608, 'rgb(171,42,36)'],
        [0.6470588235294118, 'rgb(170,40,36)'],
        [0.6509803921568628, 'rgb(170,39,36)'],
        [0.6549019607843137, 'rgb(169,38,36)'],
        [0.6588235294117647, 'rgb(168,37,36)'],
        [0.6627450980392157, 'rgb(167,36,36)'],
        [0.6666666666666666, 'rgb(166,34,37)'],
        [0.6705882352941176, 'rgb(165,33,37)'],
        [0.6745098039215687, 'rgb(164,32,37)'],
        [0.6784313725490196, 'rgb(163,31,37)'],
        [0.6823529411764706, 'rgb(162,30,37)'],
        [0.6862745098039216, 'rgb(161,29,37)'],
        [0.6901960784313725, 'rgb(160,28,38)'],
        [0.6941176470588235, 'rgb(159,27,38)'],
        [0.6980392156862745, 'rgb(158,26,38)'],
        [0.7019607843137254, 'rgb(157,25,38)'],
        [0.7058823529411765, 'rgb(156,24,39)'],
        [0.7098039215686275, 'rgb(155,23,39)'],
        [0.7137254901960784, 'rgb(154,22,39)'],
        [0.7176470588235294, 'rgb(153,21,39)'],
        [0.7215686274509804, 'rgb(152,21,39)'],
        [0.7254901960784313, 'rgb(151,20,40)'],
        [0.7294117647058823, 'rgb(149,19,40)'],
        [0.7333333333333333, 'rgb(148,19,40)'],
        [0.7372549019607844, 'rgb(147,18,40)'],
        [0.7411764705882353, 'rgb(146,17,40)'],
        [0.7450980392156863, 'rgb(145,17,41)'],
        [0.7490196078431373, 'rgb(144,16,41)'],
        [0.7529411764705882, 'rgb(142,16,41)'],
        [0.7568627450980392, 'rgb(141,16,41)'],
        [0.7607843137254902, 'rgb(140,15,41)'],
        [0.7647058823529411, 'rgb(139,15,41)'],
        [0.7686274509803922, 'rgb(137,15,41)'],
        [0.7725490196078432, 'rgb(136,15,41)'],
        [0.7764705882352941, 'rgb(135,14,41)'],
        [0.7803921568627451, 'rgb(133,14,41)'],
        [0.7843137254901961, 'rgb(132,14,41)'],
        [0.788235294117647, 'rgb(131,14,41)'],
        [0.792156862745098, 'rgb(129,14,41)'],
        [0.796078431372549, 'rgb(128,14,41)'],
        [0.8, 'rgb(127,14,41)'],
        [0.803921568627451, 'rgb(125,14,41)'],
        [0.807843137254902, 'rgb(124,14,41)'],
        [0.8117647058823529, 'rgb(123,14,41)'],
        [0.8156862745098039, 'rgb(121,14,41)'],
        [0.8196078431372549, 'rgb(120,14,40)'],
        [0.8235294117647058, 'rgb(119,14,40)'],
        [0.8274509803921568, 'rgb(117,14,40)'],
        [0.8313725490196079, 'rgb(116,14,40)'],
        [0.8352941176470589, 'rgb(115,14,39)'],
        [0.8392156862745098, 'rgb(113,14,39)'],
        [0.8431372549019608, 'rgb(112,14,39)'],
        [0.8470588235294118, 'rgb(111,14,38)'],
        [0.8509803921568627, 'rgb(109,14,38)'],
        [0.8549019607843137, 'rgb(108,15,38)'],
        [0.8588235294117647, 'rgb(107,15,37)'],
        [0.8627450980392157, 'rgb(105,15,37)'],
        [0.8666666666666667, 'rgb(104,15,37)'],
        [0.8705882352941177, 'rgb(103,15,36)'],
        [0.8745098039215686, 'rgb(101,15,36)'],
        [0.8784313725490196, 'rgb(100,14,35)'],
        [0.8823529411764706, 'rgb(99,14,35)'],
        [0.8862745098039215, 'rgb(97,14,34)'],
        [0.8901960784313725, 'rgb(96,14,34)'],
        [0.8941176470588236, 'rgb(95,14,33)'],
        [0.8980392156862745, 'rgb(93,14,33)'],
        [0.9019607843137255, 'rgb(92,14,33)'],
        [0.9058823529411765, 'rgb(91,14,32)'],
        [0.9098039215686274, 'rgb(90,14,31)'],
        [0.9137254901960784, 'rgb(88,14,31)'],
        [0.9176470588235294, 'rgb(87,14,30)'],
        [0.9215686274509803, 'rgb(86,14,30)'],
        [0.9254901960784314, 'rgb(84,13,29)'],
        [0.9294117647058824, 'rgb(83,13,29)'],
        [0.9333333333333333, 'rgb(82,13,28)'],
        [0.9372549019607843, 'rgb(81,13,28)'],
        [0.9411764705882353, 'rgb(79,13,27)'],
        [0.9450980392156862, 'rgb(78,13,26)'],
        [0.9490196078431372, 'rgb(77,12,26)'],
        [0.9529411764705882, 'rgb(75,12,25)'],
        [0.9568627450980393, 'rgb(74,12,25)'],
        [0.9607843137254902, 'rgb(73,12,24)'],
        [0.9647058823529412, 'rgb(72,11,23)'],
        [0.9686274509803922, 'rgb(70,11,23)'],
        [0.9725490196078431, 'rgb(69,11,22)'],
        [0.9764705882352941, 'rgb(68,11,22)'],
        [0.9803921568627451, 'rgb(67,10,21)'],
        [0.984313725490196, 'rgb(65,10,20)'],
        [0.9882352941176471, 'rgb(64,10,20)'],
        [0.9921568627450981, 'rgb(63,10,19)'],
        [0.996078431372549, 'rgb(61,9,18)'],
        [1.0, 'rgb(60,9,18)'],
    ],
    'cmo.balance': [
        [0.0, 'rgb(24,28,67)'],
        [0.00392156862745098, 'rgb(25,30,70)'],
        [0.00784313725490196, 'rgb(26,31,73)'],
        [0.011764705882352941, 'rgb(27,33,76)'],
        [0.01568627450980392, 'rgb(28,34,79)'],
        [0.0196078431372549, 'rgb(29,35,82)'],
        [0.023529411764705882, 'rgb(30,37,85)'],
        [0.027450980392156862, 'rgb(31,38,88)'],
        [0.03137254901960784, 'rgb(32,39,91)'],
        [0.03529411764705882, 'rgb(33,41,95)'],
        [0.0392156862745098, 'rgb(33,42,98)'],
        [0.043137254901960784, 'rgb(34,43,101)'],
        [0.047058823529411764, 'rgb(35,45,105)'],
        [0.050980392156862744, 'rgb(36,46,108)'],
        [0.054901960784313725, 'rgb(37,47,111)'],
        [0.058823529411764705, 'rgb(37,48,115)'],
        [0.06274509803921569, 'rgb(38,50,118)'],
        [0.06666666666666667, 'rgb(39,51,122)'],
        [0.07058823529411765, 'rgb(39,52,125)'],
        [0.07450980392156863, 'rgb(40,54,129)'],
        [0.0784313725490196, 'rgb(40,55,132)'],
        [0.08235294117647059, 'rgb(41,56,136)'],
        [0.08627450980392157, 'rgb(41,58,140)'],
        [0.09019607843137255, 'rgb(41,59,143)'],
        [0.09411764705882353, 'rgb(41,60,147)'],
        [0.09803921568627451, 'rgb(41,62,151)'],
        [0.10196078431372549, 'rgb(41,63,154)'],
        [0.10588235294117647, 'rgb(41,64,158)'],
        [0.10980392156862745, 'rgb(41,66,162)'],
        [0.11372549019607843, 'rgb(40,67,165)'],
        [0.11764705882352941, 'rgb(39,69,169)'],
        [0.12156862745098039, 'rgb(38,71,172)'],
        [0.12549019607843137, 'rgb(37,72,176)'],
        [0.12941176470588237, 'rgb(35,74,179)'],
        [0.13333333333333333, 'rgb(33,76,182)'],
        [0.13725490196078433, 'rgb(31,78,184)'],
        [0.1411764705882353, 'rgb(28,80,186)'],
        [0.1450980392156863, 'rgb(25,82,188)'],
        [0.14901960784313725, 'rgb(22,85,189)'],
        [0.15294117647058825, 'rgb(19,87,190)'],
        [0.1568627450980392, 'rgb(16,89,190)'],
        [0.1607843137254902, 'rgb(13,91,190)'],
        [0.16470588235294117, 'rgb(12,94,190)'],
        [0.16862745098039217, 'rgb(10,96,190)'],
        [0.17254901960784313, 'rgb(10,98,190)'],
        [0.17647058823529413, 'rgb(10,100,190)'],
        [0.1803921568627451, 'rgb(11,102,189)'],
        [0.1843137254901961, 'rgb(13,104,189)'],
        [0.18823529411764706, 'rgb(15,106,189)'],
        [0.19215686274509805, 'rgb(17,108,188)'],
        [0.19607843137254902, 'rgb(19,110,188)'],
        [0.2, 'rgb(22,112,188)'],
        [0.20392156862745098, 'rgb(25,114,187)'],
        [0.20784313725490197, 'rgb(27,116,187)'],
        [0.21176470588235294, 'rgb(30,118,187)'],
        [0.21568627450980393, 'rgb(33,120,187)'],
        [0.2196078431372549, 'rgb(35,122,186)'],
        [0.2235294117647059, 'rgb(38,123,186)'],
        [0.22745098039215686, 'rgb(41,125,186)'],
        [0.23137254901960785, 'rgb(43,127,186)'],
        [0.23529411764705882, 'rgb(46,129,186)'],
        [0.23921568627450981, 'rgb(48,131,186)'],
        [0.24313725490196078, 'rgb(51,132,186)'],
        [0.24705882352941178, 'rgb(54,134,186)'],
        [0.25098039215686274, 'rgb(56,136,186)'],
        [0.2549019607843137, 'rgb(59,137,186)'],
        [0.25882352941176473, 'rgb(62,139,186)'],
        [0.2627450980392157, 'rgb(64,141,186)'],
        [0.26666666666666666, 'rgb(67,143,186)'],
        [0.27058823529411763, 'rgb(70,144,186)'],
        [0.27450980392156865, 'rgb(72,146,186)'],
        [0.2784313725490196, 'rgb(75,148,186)'],
        [0.2823529411764706, 'rgb(78,149,186)'],
        [0.28627450980392155, 'rgb(81,151,186)'],
        [0.2901960784313726, 'rgb(83,153,186)'],
        [0.29411764705882354, 'rgb(86,154,187)'],
        [0.2980392156862745, 'rgb(89,156,187)'],
        [0.30196078431372547, 'rgb(92,157,187)'],
        [0.3058823529411765, 'rgb(95,159,187)'],
        [0.30980392156862746, 'rgb(98,160,187)'],
        [0.3137254901960784, 'rgb(101,162,188)'],
        [0.3176470588235294, 'rgb(104,164,188)'],
        [0.3215686274509804, 'rgb(107,165,188)'],
        [0.3254901960784314, 'rgb(110,167,189)'],
        [0.32941176470588235, 'rgb(113,168,189)'],
        [0.3333333333333333, 'rgb(117,170,190)'],
        [0.33725490196078434, 'rgb(120,171,190)'],
        [0.3411764705882353, 'rgb(123,172,191)'],
        [0.34509803921568627, 'rgb(126,174,191)'],
        [0.34901960784313724, 'rgb(129,175,192)'],
        [0.35294117647058826, 'rgb(133,177,192)'],
        [0.3568627450980392, 'rgb(136,178,193)'],
        [0.3607843137254902, 'rgb(139,180,194)'],
        [0.36470588235294116, 'rgb(142,181,195)'],
        [0.3686274509803922, 'rgb(145,183,195)'],
        [0.37254901960784315, 'rgb(148,184,196)'],
        [0.3764705882352941, 'rgb(152,186,197)'],
        [0.3803921568627451, 'rgb(155,187,198)'],
        [0.3843137254901961, 'rgb(158,188,199)'],
        [0.38823529411764707, 'rgb(161,190,200)'],
        [0.39215686274509803, 'rgb(164,191,201)'],
        [0.396078431372549, 'rgb(167,193,202)'],
        [0.4, 'rgb(170,194,203)'],
        [0.403921568627451, 'rgb(173,196,204)'],
        [0.40784313725490196, 'rgb(176,197,205)'],
        [0.4117647058823529, 'rgb(179,199,206)'],
        [0.41568627450980394, 'rgb(182,201,207)'],
        [0.4196078431372549, 'rgb(185,202,208)'],
        [0.4235294117647059, 'rgb(188,204,210)'],
        [0.42745098039215684, 'rgb(191,205,211)'],
        [0.43137254901960786, 'rgb(193,207,212)'],
        [0.43529411764705883, 'rgb(196,208,213)'],
        [0.4392156862745098, 'rgb(199,210,215)'],
        [0.44313725490196076, 'rgb(202,212,216)'],
        [0.4470588235294118, 'rgb(205,213,217)'],
        [0.45098039215686275, 'rgb(208,215,218)'],
        [0.4549019607843137, 'rgb(211,217,220)'],
        [0.4588235294117647, 'rgb(213,218,221)'],
        [0.4627450980392157, 'rgb(216,220,222)'],
        [0.4666666666666667, 'rgb(219,222,224)'],
        [0.47058823529411764, 'rgb(222,224,225)'],
        [0.4745098039215686, 'rgb(225,225,227)'],
        [0.47843137254901963, 'rgb(227,227,228)'],
        [0.4823529411764706, 'rgb(230,229,230)'],
        [0.48627450980392156, 'rgb(233,231,231)'],
        [0.49019607843137253, 'rgb(235,233,233)'],
        [0.49411764705882355, 'rgb(238,234,234)'],
        [0.4980392156862745, 'rgb(241,236,236)'],
        [0.5019607843137255, 'rgb(241,236,235)'],
        [0.5058823529411764, 'rgb(240,234,233)'],
        [0.5098039215686274, 'rgb(239,232,230)'],
        [0.5137254901960784, 'rgb(238,229,227)'],
        [0.5176470588235295, 'rgb(237,227,224)'],
        [0.5215686274509804, 'rgb(236,224,222)'],
        [0.5254901960784314, 'rgb(235,222,219)'],
        [0.5294117647058824, 'rgb(234,220,216)'],
        [0.5333333333333333, 'rgb(233,217,213)'],
        [0.5372549019607843, 'rgb(232,215,210)'],
        [0.5411764705882353, 'rgb(231,213,207)'],
        [0.5450980392156862, 'rgb(230,210,205)'],
        [0.5490196078431373, 'rgb(229,208,202)'],
        [0.5529411764705883, 'rgb(229,206,199)'],
        [0.5568627450980392, 'rgb(228,203,196)'],
        [0.5607843137254902, 'rgb(227,201,193)'],
        [0.5647058823529412, 'rgb(226,199,190)'],
        [0.5686274509803921, 'rgb(225,196,187)'],
        [0.5725490196078431, 'rgb(225,194,184)'],
        [0.5764705882352941, 'rgb(224,192,181)'],
        [0.5803921568627451, 'rgb(223,189,178)'],
        [0.5843137254901961, 'rgb(223,187,176)'],
        [0.5882352941176471, 'rgb(222,185,173)'],
        [0.592156862745098, 'rgb(221,182,170)'],
        [0.596078431372549, 'rgb(220,180,167)'],
        [0.6, 'rgb(220,178,164)'],
        [0.6039215686274509, 'rgb(219,175,161)'],
        [0.6078431372549019, 'rgb(218,173,158)'],
        [0.611764705882353, 'rgb(218,171,155)'],
        [0.615686274509804, 'rgb(217,169,152)'],
        [0.6196078431372549, 'rgb(216,166,150)'],
        [0.6235294117647059, 'rgb(216,164,147)'],
        [0.6274509803921569, 'rgb(215,162,144)'],
        [0.6313725490196078, 'rgb(214,159,141)'],
        [0.6352941176470588, 'rgb(214,157,138)'],
        [0.6392156862745098, 'rgb(213,155,135)'],
        [0.6431372549019608, 'rgb(212,153,132)'],
        [0.6470588235294118, 'rgb(211,150,129)'],
        [0.6509803921568628, 'rgb(211,148,127)'],
        [0.6549019607843137, 'rgb(210,146,124)'],
        [0.6588235294117647, 'rgb(209,143,121)'],
        [0.6627450980392157, 'rgb(209,141,118)'],
        [0.6666666666666666, 'rgb(208,139,115)'],
        [0.6705882352941176, 'rgb(207,137,112)'],
        [0.6745098039215687, 'rgb(207,134,110)'],
        [0.6784313725490196, 'rgb(206,132,107)'],
        [0.6823529411764706, 'rgb(205,130,104)'],
        [0.6862745098039216, 'rgb(205,127,101)'],
        [0.6901960784313725, 'rgb(204,125,99)'],
        [0.6941176470588235, 'rgb(203,123,96)'],
        [0.6980392156862745, 'rgb(202,121,93)'],
        [0.7019607843137254, 'rgb(202,118,91)'],
        [0.7058823529411765, 'rgb(201,116,88)'],
        [0.7098039215686275, 'rgb(200,114,85)'],
        [0.7137254901960784, 'rgb(199,111,83)'],
        [0.7176470588235294, 'rgb(199,109,80)'],
        [0.7215686274509804, 'rgb(198,107,77)'],
        [0.7254901960784313, 'rgb(197,104,75)'],
        [0.7294117647058823, 'rgb(196,102,72)'],
        [0.7333333333333333, 'rgb(195,99,70)'],
        [0.7372549019607844, 'rgb(195,97,67)'],
        [0.7411764705882353, 'rgb(194,95,65)'],
        [0.7450980392156863, 'rgb(193,92,63)'],
        [0.7490196078431373, 'rgb(192,90,60)'],
        [0.7529411764705882, 'rgb(191,87,58)'],
        [0.7568627450980392, 'rgb(190,85,56)'],
        [0.7607843137254902, 'rgb(190,82,54)'],
        [0.7647058823529411, 'rgb(189,80,52)'],
        [0.7686274509803922, 'rgb(188,77,50)'],
        [0.7725490196078432, 'rgb(187,75,48)'],
        [0.7764705882352941, 'rgb(186,72,46)'],
        [0.7803921568627451, 'rgb(185,69,44)'],
        [0.7843137254901961, 'rgb(184,67,43)'],
        [0.788235294117647, 'rgb(183,64,41)'],
        [0.792156862745098, 'rgb(182,61,40)'],
        [0.796078431372549, 'rgb(180,59,39)'],
        [0.8, 'rgb(179,56,38)'],
        [0.803921568627451, 'rgb(178,53,37)'],
        [0.807843137254902, 'rgb(177,51,37)'],
        [0.8117647058823529, 'rgb(175,48,36)'],
        [0.8156862745098039, 'rgb(174,46,36)'],
        [0.8196078431372549, 'rgb(172,43,36)'],
        [0.8235294117647058, 'rgb(171,41,36)'],
        [0.8274509803921568, 'rgb(169,38,36)'],
        [0.8313725490196079, 'rgb(167,36,36)'],
        [0.8352941176470589, 'rgb(165,33,37)'],
        [0.8392156862745098, 'rgb(163,31,37)'],
        [0.8431372549019608, 'rgb(161,29,37)'],
        [0.8470588235294118, 'rgb(159,27,38)'],
        [0.8509803921568627, 'rgb(157,25,38)'],
        [0.8549019607843137, 'rgb(155,23,39)'],
        [0.8588235294117647, 'rgb(153,22,39)'],
        [0.8627450980392157, 'rgb(151,20,40)'],
        [0.8666666666666667, 'rgb(148,19,40)'],
        [0.8705882352941177, 'rgb(146,18,40)'],
        [0.8745098039215686, 'rgb(144,16,41)'],
        [0.8784313725490196, 'rgb(141,16,41)'],
        [0.8823529411764706, 'rgb(139,15,41)'],
        [0.8862745098039215, 'rgb(136,15,41)'],
        [0.8901960784313725, 'rgb(134,14,41)'],
        [0.8941176470588236, 'rgb(131,14,41)'],
        [0.8980392156862745, 'rgb(128,14,41)'],
        [0.9019607843137255, 'rgb(126,14,41)'],
        [0.9058823529411765, 'rgb(123,14,41)'],
        [0.9098039215686274, 'rgb(120,14,40)'],
        [0.9137254901960784, 'rgb(118,14,40)'],
        [0.9176470588235294, 'rgb(115,14,39)'],
        [0.9215686274509803, 'rgb(112,14,39)'],
        [0.9254901960784314, 'rgb(109,14,38)'],
        [0.9294117647058824, 'rgb(107,15,37)'],
        [0.9333333333333333, 'rgb(104,15,37)'],
        [0.9372549019607843, 'rgb(101,15,36)'],
        [0.9411764705882353, 'rgb(99,14,35)'],
        [0.9450980392156862, 'rgb(96,14,34)'],
        [0.9490196078431372, 'rgb(94,14,33)'],
        [0.9529411764705882, 'rgb(91,14,32)'],
        [0.9568627450980393, 'rgb(88,14,31)'],
        [0.9607843137254902, 'rgb(86,14,30)'],
        [0.9647058823529412, 'rgb(83,13,29)'],
        [0.9686274509803922, 'rgb(81,13,28)'],
        [0.9725490196078431, 'rgb(78,13,27)'],
        [0.9764705882352941, 'rgb(75,12,25)'],
        [0.9803921568627451, 'rgb(73,12,24)'],
        [0.984313725490196, 'rgb(70,11,23)'],
        [0.9882352941176471, 'rgb(68,11,22)'],
        [0.9921568627450981, 'rgb(65,10,20)'],
        [0.996078431372549, 'rgb(63,10,19)'],
        [1.0, 'rgb(60,9,18)'],
    ],
    'cmo.curl': [
        [0.0, 'rgb(21,29,68)'],
        [0.00392156862745098, 'rgb(21,31,69)'],
        [0.00784313725490196, 'rgb(22,33,70)'],
        [0.011764705882352941, 'rgb(22,35,71)'],
        [0.01568627450980392, 'rgb(23,37,72)'],
        [0.0196078431372549, 'rgb(23,39,73)'],
        [0.023529411764705882, 'rgb(24,41,74)'],
        [0.027450980392156862, 'rgb(24,43,75)'],
        [0.03137254901960784, 'rgb(24,45,76)'],
        [0.03529411764705882, 'rgb(25,47,77)'],
        [0.0392156862745098, 'rgb(25,49,79)'],
        [0.043137254901960784, 'rgb(26,51,80)'],
        [0.047058823529411764, 'rgb(26,53,81)'],
        [0.050980392156862744, 'rgb(26,55,82)'],
        [0.054901960784313725, 'rgb(27,56,83)'],
        [0.058823529411764705, 'rgb(27,58,84)'],
        [0.06274509803921569, 'rgb(27,60,86)'],
        [0.06666666666666667, 'rgb(27,62,87)'],
        [0.07058823529411765, 'rgb(28,64,88)'],
        [0.07450980392156863, 'rgb(28,66,89)'],
        [0.0784313725490196, 'rgb(28,67,90)'],
        [0.08235294117647059, 'rgb(28,69,91)'],
        [0.08627450980392157, 'rgb(28,71,93)'],
        [0.09019607843137255, 'rgb(28,73,94)'],
        [0.09411764705882353, 'rgb(28,75,95)'],
        [0.09803921568627451, 'rgb(28,77,96)'],
        [0.10196078431372549, 'rgb(28,78,97)'],
        [0.10588235294117647, 'rgb(28,80,98)'],
        [0.10980392156862745, 'rgb(28,82,100)'],
        [0.11372549019607843, 'rgb(28,84,101)'],
        [0.11764705882352941, 'rgb(27,86,102)'],
        [0.12156862745098039, 'rgb(27,88,103)'],
        [0.12549019607843137, 'rgb(27,89,104)'],
        [0.12941176470588237, 'rgb(26,91,105)'],
        [0.13333333333333333, 'rgb(26,93,106)'],
        [0.13725490196078433, 'rgb(26,95,107)'],
        [0.1411764705882353, 'rgb(25,97,108)'],
        [0.1450980392156863, 'rgb(24,99,109)'],
        [0.14901960784313725, 'rgb(24,101,110)'],
        [0.15294117647058825, 'rgb(23,103,111)'],
        [0.1568627450980392, 'rgb(23,104,112)'],
        [0.1607843137254902, 'rgb(22,106,113)'],
        [0.16470588235294117, 'rgb(21,108,114)'],
        [0.16862745098039217, 'rgb(20,110,115)'],
        [0.17254901960784313, 'rgb(20,112,116)'],
        [0.17647058823529413, 'rgb(19,114,117)'],
        [0.1803921568627451, 'rgb(18,116,118)'],
        [0.1843137254901961, 'rgb(18,118,118)'],
        [0.18823529411764706, 'rgb(17,120,119)'],
        [0.19215686274509805, 'rgb(17,121,120)'],
        [0.19607843137254902, 'rgb(17,123,121)'],
        [0.2, 'rgb(17,125,121)'],
        [0.20392156862745098, 'rgb(17,127,122)'],
        [0.20784313725490197, 'rgb(18,129,123)'],
        [0.21176470588235294, 'rgb(19,131,123)'],
        [0.21568627450980393, 'rgb(20,133,124)'],
        [0.2196078431372549, 'rgb(22,135,124)'],
        [0.2235294117647059, 'rgb(24,136,125)'],
        [0.22745098039215686, 'rgb(26,138,125)'],
        [0.23137254901960785, 'rgb(29,140,126)'],
        [0.23529411764705882, 'rgb(31,142,126)'],
        [0.23921568627450981, 'rgb(34,143,126)'],
        [0.24313725490196078, 'rgb(38,145,127)'],
        [0.24705882352941178, 'rgb(41,147,127)'],
        [0.25098039215686274, 'rgb(45,149,128)'],
        [0.2549019607843137, 'rgb(48,150,128)'],
        [0.25882352941176473, 'rgb(52,152,128)'],
        [0.2627450980392157, 'rgb(56,153,129)'],
        [0.26666666666666666, 'rgb(60,155,129)'],
        [0.27058823529411763, 'rgb(64,156,130)'],
        [0.27450980392156865, 'rgb(68,158,130)'],
        [0.2784313725490196, 'rgb(72,159,131)'],
        [0.2823529411764706, 'rgb(76,161,131)'],
        [0.28627450980392155, 'rgb(80,162,132)'],
        [0.2901960784313726, 'rgb(84,164,132)'],
        [0.29411764705882354, 'rgb(88,165,133)'],
        [0.2980392156862745, 'rgb(92,167,134)'],
        [0.30196078431372547, 'rgb(96,168,135)'],
        [0.3058823529411765, 'rgb(100,169,136)'],
        [0.30980392156862746, 'rgb(104,171,137)'],
        [0.3137254901960784, 'rgb(108,172,138)'],
        [0.3176470588235294, 'rgb(111,174,139)'],
        [0.3215686274509804, 'rgb(115,175,140)'],
        [0.3254901960784314, 'rgb(119,176,141)'],
        [0.32941176470588235, 'rgb(122,178,143)'],
        [0.3333333333333333, 'rgb(126,179,144)'],
        [0.33725490196078434, 'rgb(130,180,145)'],
        [0.3411764705882353, 'rgb(133,182,147)'],
        [0.34509803921568627, 'rgb(137,183,148)'],
        [0.34901960784313724, 'rgb(140,184,150)'],
        [0.35294117647058826, 'rgb(144,186,152)'],
        [0.3568627450980392, 'rgb(147,187,153)'],
        [0.3607843137254902, 'rgb(150,189,155)'],
        [0.36470588235294116, 'rgb(154,190,157)'],
        [0.3686274509803922, 'rgb(157,191,159)'],
        [0.37254901960784315, 'rgb(160,193,161)'],
        [0.3764705882352941, 'rgb(163,194,163)'],
        [0.3803921568627451, 'rgb(167,196,165)'],
        [0.3843137254901961, 'rgb(170,197,167)'],
        [0.38823529411764707, 'rgb(173,198,169)'],
        [0.39215686274509803, 'rgb(176,200,171)'],
        [0.396078431372549, 'rgb(179,201,173)'],
        [0.4, 'rgb(182,203,176)'],
        [0.403921568627451, 'rgb(185,204,178)'],
        [0.40784313725490196, 'rgb(188,206,180)'],
        [0.4117647058823529, 'rgb(192,207,183)'],
        [0.41568627450980394, 'rgb(195,209,185)'],
        [0.4196078431372549, 'rgb(197,210,188)'],
        [0.4235294117647059, 'rgb(200,212,190)'],
        [0.42745098039215684, 'rgb(203,214,193)'],
        [0.43137254901960786, 'rgb(206,215,195)'],
        [0.43529411764705883, 'rgb(209,217,198)'],
        [0.4392156862745098, 'rgb(212,218,200)'],
        [0.44313725490196076, 'rgb(215,220,203)'],
        [0.4470588235294118, 'rgb(218,222,206)'],
        [0.45098039215686275, 'rgb(221,223,209)'],
        [0.4549019607843137, 'rgb(224,225,211)'],
        [0.4588235294117647, 'rgb(226,227,214)'],
        [0.4627450980392157, 'rgb(229,229,217)'],
        [0.4666666666666667, 'rgb(232,230,220)'],
        [0.47058823529411764, 'rgb(235,232,223)'],
        [0.4745098039215686, 'rgb(238,234,225)'],
        [0.47843137254901963, 'rgb(240,236,228)'],
        [0.4823529411764706, 'rgb(243,238,231)'],
        [0.48627450980392156, 'rgb(246,239,234)'],
        [0.49019607843137253, 'rgb(249,241,237)'],
        [0.49411764705882355, 'rgb(251,243,240)'],
        [0.4980392156862745, 'rgb(254,245,243)'],
        [0.5019607843137255, 'rgb(253,245,244)'],
        [0.5058823529411764, 'rgb(252,243,240)'],
        [0.5098039215686274, 'rgb(251,240,237)'],
        [0.5137254901960784, 'rgb(250,238,234)'],
        [0.5176470588235295, 'rgb(248,236,230)'],
        [0.5215686274509804, 'rgb(247,233,227)'],
        [0.5254901960784314, 'rgb(246,231,224)'],
        [0.5294117647058824, 'rgb(245,228,220)'],
        [0.5333333333333333, 'rgb(244,226,217)'],
        [0.5372549019607843, 'rgb(243,223,214)'],
        [0.5411764705882353, 'rgb(242,221,210)'],
        [0.5450980392156862, 'rgb(241,218,207)'],
        [0.5490196078431373, 'rgb(240,216,204)'],
        [0.5529411764705883, 'rgb(239,213,200)'],
        [0.5568627450980392, 'rgb(239,211,197)'],
        [0.5607843137254902, 'rgb(238,208,194)'],
        [0.5647058823529412, 'rgb(237,206,190)'],
        [0.5686274509803921, 'rgb(236,203,187)'],
        [0.5725490196078431, 'rgb(235,201,184)'],
        [0.5764705882352941, 'rgb(235,198,181)'],
        [0.5803921568627451, 'rgb(234,196,178)'],
        [0.5843137254901961, 'rgb(233,193,175)'],
        [0.5882352941176471, 'rgb(232,191,171)'],
        [0.592156862745098, 'rgb(232,189,168)'],
        [0.596078431372549, 'rgb(231,186,165)'],
        [0.6, 'rgb(230,184,162)'],
        [0.6039215686274509, 'rgb(230,181,159)'],
        [0.6078431372549019, 'rgb(229,179,156)'],
        [0.611764705882353, 'rgb(228,176,154)'],
        [0.615686274509804, 'rgb(228,174,151)'],
        [0.6196078431372549, 'rgb(227,171,148)'],
        [0.6235294117647059, 'rgb(227,169,145)'],
        [0.6274509803921569, 'rgb(226,166,142)'],
        [0.6313725490196078, 'rgb(225,164,140)'],
        [0.6352941176470588, 'rgb(225,161,137)'],
        [0.6392156862745098, 'rgb(224,158,135)'],
        [0.6431372549019608, 'rgb(223,156,132)'],
        [0.6470588235294118, 'rgb(223,153,130)'],
        [0.6509803921568628, 'rgb(222,151,128)'],
        [0.6549019607843137, 'rgb(221,148,125)'],
        [0.6588235294117647, 'rgb(221,146,123)'],
        [0.6627450980392157, 'rgb(220,143,121)'],
        [0.6666666666666666, 'rgb(219,141,119)'],
        [0.6705882352941176, 'rgb(218,138,117)'],
        [0.6745098039215687, 'rgb(218,136,116)'],
        [0.6784313725490196, 'rgb(217,133,114)'],
        [0.6823529411764706, 'rgb(216,131,112)'],
        [0.6862745098039216, 'rgb(215,128,111)'],
        [0.6901960784313725, 'rgb(214,126,109)'],
        [0.6941176470588235, 'rgb(213,123,108)'],
        [0.6980392156862745, 'rgb(212,121,107)'],
        [0.7019607843137254, 'rgb(211,118,105)'],
        [0.7058823529411765, 'rgb(210,116,104)'],
        [0.7098039215686275, 'rgb(209,114,103)'],
        [0.7137254901960784, 'rgb(208,111,102)'],
        [0.7176470588235294, 'rgb(207,109,102)'],
        [0.7215686274509804, 'rgb(206,106,101)'],
        [0.7254901960784313, 'rgb(204,104,100)'],
        [0.7294117647058823, 'rgb(203,102,100)'],
        [0.7333333333333333, 'rgb(202,99,99)'],
        [0.7372549019607844, 'rgb(200,97,98)'],
        [0.7411764705882353, 'rgb(199,95,98)'],
        [0.7450980392156863, 'rgb(198,93,98)'],
        [0.7490196078431373, 'rgb(196,90,97)'],
        [0.7529411764705882, 'rgb(195,88,97)'],
        [0.7568627450980392, 'rgb(193,86,97)'],
        [0.7607843137254902, 'rgb(192,84,97)'],
        [0.7647058823529411, 'rgb(190,82,96)'],
        [0.7686274509803922, 'rgb(188,80,96)'],
        [0.7725490196078432, 'rgb(187,78,96)'],
        [0.7764705882352941, 'rgb(185,76,96)'],
        [0.7803921568627451, 'rgb(183,74,96)'],
        [0.7843137254901961, 'rgb(181,72,96)'],
        [0.788235294117647, 'rgb(180,70,96)'],
        [0.792156862745098, 'rgb(178,68,96)'],
        [0.796078431372549, 'rgb(176,66,96)'],
        [0.8, 'rgb(174,64,96)'],
        [0.803921568627451, 'rgb(172,62,96)'],
        [0.807843137254902, 'rgb(170,60,96)'],
        [0.8117647058823529, 'rgb(168,58,96)'],
        [0.8156862745098039, 'rgb(166,56,96)'],
        [0.8196078431372549, 'rgb(164,55,96)'],
        [0.8235294117647058, 'rgb(162,53,96)'],
        [0.8274509803921568, 'rgb(160,51,96)'],
        [0.8313725490196079, 'rgb(158,49,96)'],
        [0.8352941176470589, 'rgb(156,48,96)'],
        [0.8392156862745098, 'rgb(154,46,96)'],
        [0.8431372549019608, 'rgb(152,44,97)'],
        [0.8470588235294118, 'rgb(150,43,97)'],
        [0.8509803921568627, 'rgb(148,41,97)'],
        [0.8549019607843137, 'rgb(145,40,96)'],
        [0.8588235294117647, 'rgb(143,38,96)'],
        [0.8627450980392157, 'rgb(141,37,96)'],
        [0.8666666666666667, 'rgb(139,35,96)'],
        [0.8705882352941177, 'rgb(136,34,96)'],
        [0.8745098039215686, 'rgb(134,33,96)'],
        [0.8784313725490196, 'rgb(132,31,96)'],
        [0.8823529411764706, 'rgb(129,30,95)'],
        [0.8862745098039215, 'rgb(127,29,95)'],
        [0.8901960784313725, 'rgb(124,28,95)'],
        [0.8941176470588236, 'rgb(122,27,94)'],
        [0.8980392156862745, 'rgb(119,26,94)'],
        [0.9019607843137255, 'rgb(117,25,93)'],
        [0.9058823529411765, 'rgb(114,24,92)'],
        [0.9098039215686274, 'rgb(112,24,92)'],
        [0.9137254901960784, 'rgb(109,23,91)'],
        [0.9176470588235294, 'rgb(106,22,90)'],
        [0.9215686274509803, 'rgb(104,22,89)'],
        [0.9254901960784314, 'rgb(101,21,88)'],
        [0.9294117647058824, 'rgb(99,21,87)'],
        [0.9333333333333333, 'rgb(96,20,85)'],
        [0.9372549019607843, 'rgb(93,20,84)'],
        [0.9411764705882353, 'rgb(91,20,82)'],
        [0.9450980392156862, 'rgb(88,19,81)'],
        [0.9490196078431372, 'rgb(85,19,79)'],
        [0.9529411764705882, 'rgb(83,19,78)'],
        [0.9568627450980393, 'rgb(80,18,76)'],
        [0.9607843137254902, 'rgb(77,18,74)'],
        [0.9647058823529412, 'rgb(75,18,72)'],
        [0.9686274509803922, 'rgb(72,17,70)'],
        [0.9725490196078431, 'rgb(70,17,68)'],
        [0.9764705882352941, 'rgb(67,16,66)'],
        [0.9803921568627451, 'rgb(64,16,64)'],
        [0.984313725490196, 'rgb(62,15,62)'],
        [0.9882352941176471, 'rgb(59,15,60)'],
        [0.9921568627450981, 'rgb(57,14,58)'],
        [0.996078431372549, 'rgb(54,14,55)'],
        [1.0, 'rgb(52,13,53)'],
    ],
    'cmo.deep': [
        [0.0, 'rgb(253,254,204)'],
        [0.00392156862745098, 'rgb(251,253,203)'],
        [0.00784313725490196, 'rgb(249,252,202)'],
        [0.011764705882352941, 'rgb(247,251,200)'],
        [0.01568627450980392, 'rgb(245,250,199)'],
        [0.0196078431372549, 'rgb(243,250,198)'],
        [0.023529411764705882, 'rgb(241,249,197)'],
        [0.027450980392156862, 'rgb(239,248,196)'],
        [0.03137254901960784, 'rgb(237,247,195)'],
        [0.03529411764705882, 'rgb(235,247,193)'],
        [0.0392156862745098, 'rgb(233,246,192)'],
        [0.043137254901960784, 'rgb(231,245,191)'],
        [0.047058823529411764, 'rgb(229,244,190)'],
        [0.050980392156862744, 'rgb(227,244,189)'],
        [0.054901960784313725, 'rgb(225,243,188)'],
        [0.058823529411764705, 'rgb(223,242,187)'],
        [0.06274509803921569, 'rgb(221,242,186)'],
        [0.06666666666666667, 'rgb(219,241,185)'],
        [0.07058823529411765, 'rgb(217,240,184)'],
        [0.07450980392156863, 'rgb(215,239,183)'],
        [0.0784313725490196, 'rgb(212,239,182)'],
        [0.08235294117647059, 'rgb(210,238,181)'],
        [0.08627450980392157, 'rgb(208,237,180)'],
        [0.09019607843137255, 'rgb(206,236,179)'],
        [0.09411764705882353, 'rgb(204,236,179)'],
        [0.09803921568627451, 'rgb(202,235,178)'],
        [0.10196078431372549, 'rgb(200,234,177)'],
        [0.10588235294117647, 'rgb(198,234,176)'],
        [0.10980392156862745, 'rgb(196,233,175)'],
        [0.11372549019607843, 'rgb(193,232,175)'],
        [0.11764705882352941, 'rgb(191,231,174)'],
        [0.12156862745098039, 'rgb(189,231,173)'],
        [0.12549019607843137, 'rgb(187,230,172)'],
        [0.12941176470588237, 'rgb(185,229,172)'],
        [0.13333333333333333, 'rgb(183,229,171)'],
        [0.13725490196078433, 'rgb(181,228,170)'],
        [0.1411764705882353, 'rgb(178,227,170)'],
        [0.1450980392156863, 'rgb(176,226,169)'],
        [0.14901960784313725, 'rgb(174,226,169)'],
        [0.15294117647058825, 'rgb(172,225,168)'],
        [0.1568627450980392, 'rgb(170,224,168)'],
        [0.1607843137254902, 'rgb(167,224,167)'],
        [0.16470588235294117, 'rgb(165,223,167)'],
        [0.16862745098039217, 'rgb(163,222,166)'],
        [0.17254901960784313, 'rgb(161,221,166)'],
        [0.17647058823529413, 'rgb(159,221,165)'],
        [0.1803921568627451, 'rgb(156,220,165)'],
        [0.1843137254901961, 'rgb(154,219,165)'],
        [0.18823529411764706, 'rgb(152,218,164)'],
        [0.19215686274509805, 'rgb(150,218,164)'],
        [0.19607843137254902, 'rgb(148,217,164)'],
        [0.2, 'rgb(146,216,164)'],
        [0.20392156862745098, 'rgb(144,215,164)'],
        [0.20784313725490197, 'rgb(141,215,163)'],
        [0.21176470588235294, 'rgb(139,214,163)'],
        [0.21568627450980393, 'rgb(137,213,163)'],
        [0.2196078431372549, 'rgb(135,212,163)'],
        [0.2235294117647059, 'rgb(133,211,163)'],
        [0.22745098039215686, 'rgb(131,211,163)'],
        [0.23137254901960785, 'rgb(129,210,163)'],
        [0.23529411764705882, 'rgb(127,209,163)'],
        [0.23921568627450981, 'rgb(125,208,163)'],
        [0.24313725490196078, 'rgb(124,207,163)'],
        [0.24705882352941178, 'rgb(122,206,163)'],
        [0.25098039215686274, 'rgb(120,206,163)'],
        [0.2549019607843137, 'rgb(118,205,163)'],
        [0.25882352941176473, 'rgb(117,204,163)'],
        [0.2627450980392157, 'rgb(115,203,163)'],
        [0.26666666666666666, 'rgb(113,202,163)'],
        [0.27058823529411763, 'rgb(112,201,163)'],
        [0.27450980392156865, 'rgb(110,200,163)'],
        [0.2784313725490196, 'rgb(109,199,163)'],
        [0.2823529411764706, 'rgb(107,198,163)'],
        [0.28627450980392155, 'rgb(106,197,164)'],
        [0.2901960784313726, 'rgb(105,196,164)'],
        [0.29411764705882354, 'rgb(103,195,164)'],
        [0.2980392156862745, 'rgb(102,194,164)'],
        [0.30196078431372547, 'rgb(101,194,164)'],
        [0.3058823529411765, 'rgb(100,193,164)'],
        [0.30980392156862746, 'rgb(99,192,164)'],
        [0.3137254901960784, 'rgb(98,191,164)'],
        [0.3176470588235294, 'rgb(97,190,164)'],
        [0.3215686274509804, 'rgb(96,189,164)'],
        [0.3254901960784314, 'rgb(95,188,164)'],
        [0.32941176470588235, 'rgb(94,187,164)'],
        [0.3333333333333333, 'rgb(93,186,164)'],
        [0.33725490196078434, 'rgb(92,185,164)'],
        [0.3411764705882353, 'rgb(91,184,164)'],
        [0.34509803921568627, 'rgb(90,183,164)'],
        [0.34901960784313724, 'rgb(90,182,164)'],
        [0.35294117647058826, 'rgb(89,180,164)'],
        [0.3568627450980392, 'rgb(88,179,164)'],
        [0.3607843137254902, 'rgb(88,178,164)'],
        [0.36470588235294116, 'rgb(87,177,164)'],
        [0.3686274509803922, 'rgb(86,176,164)'],
        [0.37254901960784315, 'rgb(86,175,164)'],
        [0.3764705882352941, 'rgb(85,174,163)'],
        [0.3803921568627451, 'rgb(85,173,163)'],
        [0.3843137254901961, 'rgb(84,172,163)'],
        [0.38823529411764707, 'rgb(83,171,163)'],
        [0.39215686274509803, 'rgb(83,170,163)'],
        [0.396078431372549, 'rgb(82,169,163)'],
        [0.4, 'rgb(82,168,163)'],
        [0.403921568627451, 'rgb(81,167,163)'],
        [0.40784313725490196, 'rgb(81,166,162)'],
        [0.4117647058823529, 'rgb(81,165,162)'],
        [0.41568627450980394, 'rgb(80,164,162)'],
        [0.4196078431372549, 'rgb(80,163,162)'],
        [0.4235294117647059, 'rgb(79,162,162)'],
        [0.42745098039215684, 'rgb(79,161,162)'],
        [0.43137254901960786, 'rgb(79,160,162)'],
        [0.43529411764705883, 'rgb(78,159,161)'],
        [0.4392156862745098, 'rgb(78,158,161)'],
        [0.44313725490196076, 'rgb(77,157,161)'],
        [0.4470588235294118, 'rgb(77,156,161)'],
        [0.45098039215686275, 'rgb(77,155,161)'],
        [0.4549019607843137, 'rgb(76,154,160)'],
        [0.4588235294117647, 'rgb(76,153,160)'],
        [0.4627450980392157, 'rgb(75,152,160)'],
        [0.4666666666666667, 'rgb(75,151,160)'],
        [0.47058823529411764, 'rgb(75,150,160)'],
        [0.4745098039215686, 'rgb(74,149,159)'],
        [0.47843137254901963, 'rgb(74,148,159)'],
        [0.4823529411764706, 'rgb(74,147,159)'],
        [0.48627450980392156, 'rgb(73,146,159)'],
        [0.49019607843137253, 'rgb(73,145,158)'],
        [0.49411764705882355, 'rgb(73,144,158)'],
        [0.4980392156862745, 'rgb(72,143,158)'],
        [0.5019607843137255, 'rgb(72,142,158)'],
        [0.5058823529411764, 'rgb(72,141,157)'],
        [0.5098039215686274, 'rgb(71,140,157)'],
        [0.5137254901960784, 'rgb(71,139,157)'],
        [0.5176470588235295, 'rgb(71,138,157)'],
        [0.5215686274509804, 'rgb(70,137,157)'],
        [0.5254901960784314, 'rgb(70,136,156)'],
        [0.5294117647058824, 'rgb(70,135,156)'],
        [0.5333333333333333, 'rgb(69,134,156)'],
        [0.5372549019607843, 'rgb(69,133,156)'],
        [0.5411764705882353, 'rgb(69,132,155)'],
        [0.5450980392156862, 'rgb(68,131,155)'],
        [0.5490196078431373, 'rgb(68,130,155)'],
        [0.5529411764705883, 'rgb(68,129,155)'],
        [0.5568627450980392, 'rgb(68,128,155)'],
        [0.5607843137254902, 'rgb(67,127,154)'],
        [0.5647058823529412, 'rgb(67,126,154)'],
        [0.5686274509803921, 'rgb(67,125,154)'],
        [0.5725490196078431, 'rgb(66,124,154)'],
        [0.5764705882352941, 'rgb(66,123,153)'],
        [0.5803921568627451, 'rgb(66,122,153)'],
        [0.5843137254901961, 'rgb(66,121,153)'],
        [0.5882352941176471, 'rgb(65,120,153)'],
        [0.592156862745098, 'rgb(65,119,153)'],
        [0.596078431372549, 'rgb(65,118,152)'],
        [0.6, 'rgb(64,117,152)'],
        [0.6039215686274509, 'rgb(64,116,152)'],
        [0.6078431372549019, 'rgb(64,115,152)'],
        [0.611764705882353, 'rgb(64,114,152)'],
        [0.615686274509804, 'rgb(64,113,151)'],
        [0.6196078431372549, 'rgb(63,112,151)'],
        [0.6235294117647059, 'rgb(63,111,151)'],
        [0.6274509803921569, 'rgb(63,110,151)'],
        [0.6313725490196078, 'rgb(63,109,151)'],
        [0.6352941176470588, 'rgb(63,108,150)'],
        [0.6392156862745098, 'rgb(62,107,150)'],
        [0.6431372549019608, 'rgb(62,106,150)'],
        [0.6470588235294118, 'rgb(62,105,150)'],
        [0.6509803921568628, 'rgb(62,104,150)'],
        [0.6549019607843137, 'rgb(62,103,149)'],
        [0.6588235294117647, 'rgb(62,102,149)'],
        [0.6627450980392157, 'rgb(62,101,149)'],
        [0.6666666666666666, 'rgb(62,100,149)'],
        [0.6705882352941176, 'rgb(62,99,148)'],
        [0.6745098039215687, 'rgb(62,98,148)'],
        [0.6784313725490196, 'rgb(62,97,148)'],
        [0.6823529411764706, 'rgb(62,96,148)'],
        [0.6862745098039216, 'rgb(62,95,147)'],
        [0.6901960784313725, 'rgb(62,94,147)'],
        [0.6941176470588235, 'rgb(62,92,147)'],
        [0.6980392156862745, 'rgb(62,91,147)'],
        [0.7019607843137254, 'rgb(62,90,146)'],
        [0.7058823529411765, 'rgb(62,89,146)'],
        [0.7098039215686275, 'rgb(62,88,146)'],
        [0.7137254901960784, 'rgb(62,87,145)'],
        [0.7176470588235294, 'rgb(62,86,145)'],
        [0.7215686274509804, 'rgb(63,85,144)'],
        [0.7254901960784313, 'rgb(63,84,144)'],
        [0.7294117647058823, 'rgb(63,83,143)'],
        [0.7333333333333333, 'rgb(63,82,143)'],
        [0.7372549019607844, 'rgb(63,80,142)'],
        [0.7411764705882353, 'rgb(64,79,141)'],
        [0.7450980392156863, 'rgb(64,78,141)'],
        [0.7490196078431373, 'rgb(64,77,140)'],
        [0.7529411764705882, 'rgb(64,76,139)'],
        [0.7568627450980392, 'rgb(65,75,138)'],
        [0.7607843137254902, 'rgb(65,74,137)'],
        [0.7647058823529411, 'rgb(65,73,136)'],
        [0.7686274509803922, 'rgb(65,72,135)'],
        [0.7725490196078432, 'rgb(65,71,133)'],
        [0.7764705882352941, 'rgb(65,70,132)'],
        [0.7803921568627451, 'rgb(65,69,131)'],
        [0.7843137254901961, 'rgb(65,68,129)'],
        [0.788235294117647, 'rgb(66,67,128)'],
        [0.792156862745098, 'rgb(65,66,126)'],
        [0.796078431372549, 'rgb(65,65,125)'],
        [0.8, 'rgb(65,64,123)'],
        [0.803921568627451, 'rgb(65,64,122)'],
        [0.807843137254902, 'rgb(65,63,120)'],
        [0.8117647058823529, 'rgb(65,62,118)'],
        [0.8156862745098039, 'rgb(65,61,117)'],
        [0.8196078431372549, 'rgb(64,60,115)'],
        [0.8235294117647058, 'rgb(64,60,113)'],
        [0.8274509803921568, 'rgb(64,59,112)'],
        [0.8313725490196079, 'rgb(64,58,110)'],
        [0.8352941176470589, 'rgb(63,57,108)'],
        [0.8392156862745098, 'rgb(63,56,107)'],
        [0.8431372549019608, 'rgb(63,56,105)'],
        [0.8470588235294118, 'rgb(62,55,103)'],
        [0.8509803921568627, 'rgb(62,54,102)'],
        [0.8549019607843137, 'rgb(61,53,100)'],
        [0.8588235294117647, 'rgb(61,53,98)'],
        [0.8627450980392157, 'rgb(61,52,97)'],
        [0.8666666666666667, 'rgb(60,51,95)'],
        [0.8705882352941177, 'rgb(60,50,93)'],
        [0.8745098039215686, 'rgb(59,50,92)'],
        [0.8784313725490196, 'rgb(59,49,90)'],
        [0.8823529411764706, 'rgb(58,48,88)'],
        [0.8862745098039215, 'rgb(58,48,87)'],
        [0.8901960784313725, 'rgb(57,47,85)'],
        [0.8941176470588236, 'rgb(57,46,84)'],
        [0.8980392156862745, 'rgb(56,45,82)'],
        [0.9019607843137255, 'rgb(56,45,81)'],
        [0.9058823529411765, 'rgb(55,44,79)'],
        [0.9098039215686274, 'rgb(54,43,77)'],
        [0.9137254901960784, 'rgb(54,42,76)'],
        [0.9176470588235294, 'rgb(53,42,74)'],
        [0.9215686274509803, 'rgb(53,41,73)'],
        [0.9254901960784314, 'rgb(52,40,71)'],
        [0.9294117647058824, 'rgb(52,40,70)'],
        [0.9333333333333333, 'rgb(51,39,68)'],
        [0.9372549019607843, 'rgb(50,38,67)'],
        [0.9411764705882353, 'rgb(50,37,65)'],
        [0.9450980392156862, 'rgb(49,37,64)'],
        [0.9490196078431372, 'rgb(48,36,62)'],
        [0.9529411764705882, 'rgb(48,35,61)'],
        [0.9568627450980393, 'rgb(47,34,59)'],
        [0.9607843137254902, 'rgb(47,34,58)'],
        [0.9647058823529412, 'rgb(46,33,57)'],
        [0.9686274509803922, 'rgb(45,32,55)'],
        [0.9725490196078431, 'rgb(45,31,54)'],
        [0.9764705882352941, 'rgb(44,31,52)'],
        [0.9803921568627451, 'rgb(43,30,51)'],
        [0.984313725490196, 'rgb(43,29,50)'],
        [0.9882352941176471, 'rgb(42,28,48)'],
        [0.9921568627450981, 'rgb(41,28,47)'],
        [0.996078431372549, 'rgb(40,27,45)'],
        [1.0, 'rgb(40,26,44)'],
    ],
    'cmo.delta': [
        [0.0, 'rgb(17,32,64)'],
        [0.00392156862745098, 'rgb(18,33,67)'],
        [0.00784313725490196, 'rgb(20,34,70)'],
        [0.011764705882352941, 'rgb(21,36,73)'],
        [0.01568627450980392, 'rgb(22,37,76)'],
        [0.0196078431372549, 'rgb(23,39,80)'],
        [0.023529411764705882, 'rgb(25,40,83)'],
        [0.027450980392156862, 'rgb(26,41,86)'],
        [0.03137254901960784, 'rgb(27,42,90)'],
        [0.03529411764705882, 'rgb(28,44,93)'],
        [0.0392156862745098, 'rgb(30,45,96)'],
        [0.043137254901960784, 'rgb(31,46,100)'],
        [0.047058823529411764, 'rgb(32,48,103)'],
        [0.050980392156862744, 'rgb(33,49,107)'],
        [0.054901960784313725, 'rgb(34,50,111)'],
        [0.058823529411764705, 'rgb(35,51,114)'],
        [0.06274509803921569, 'rgb(36,53,118)'],
        [0.06666666666666667, 'rgb(37,54,122)'],
        [0.07058823529411765, 'rgb(37,55,126)'],
        [0.07450980392156863, 'rgb(38,56,130)'],
        [0.0784313725490196, 'rgb(38,58,134)'],
        [0.08235294117647059, 'rgb(39,59,138)'],
        [0.08627450980392157, 'rgb(39,61,141)'],
        [0.09019607843137255, 'rgb(38,62,145)'],
        [0.09411764705882353, 'rgb(37,64,148)'],
        [0.09803921568627451, 'rgb(36,66,151)'],
        [0.10196078431372549, 'rgb(35,68,152)'],
        [0.10588235294117647, 'rgb(33,71,154)'],
        [0.10980392156862745, 'rgb(32,73,155)'],
        [0.11372549019607843, 'rgb(31,75,155)'],
        [0.11764705882352941, 'rgb(30,77,156)'],
        [0.12156862745098039, 'rgb(29,80,156)'],
        [0.12549019607843137, 'rgb(28,82,157)'],
        [0.12941176470588237, 'rgb(28,84,157)'],
        [0.13333333333333333, 'rgb(27,86,157)'],
        [0.13725490196078433, 'rgb(27,88,158)'],
        [0.1411764705882353, 'rgb(27,90,158)'],
        [0.1450980392156863, 'rgb(27,92,158)'],
        [0.14901960784313725, 'rgb(27,94,159)'],
        [0.15294117647058825, 'rgb(27,96,159)'],
        [0.1568627450980392, 'rgb(27,99,159)'],
        [0.1607843137254902, 'rgb(27,101,159)'],
        [0.16470588235294117, 'rgb(28,103,160)'],
        [0.16862745098039217, 'rgb(28,105,160)'],
        [0.17254901960784313, 'rgb(29,106,160)'],
        [0.17647058823529413, 'rgb(30,108,161)'],
        [0.1803921568627451, 'rgb(30,110,161)'],
        [0.1843137254901961, 'rgb(31,112,162)'],
        [0.18823529411764706, 'rgb(32,114,162)'],
        [0.19215686274509805, 'rgb(33,116,162)'],
        [0.19607843137254902, 'rgb(34,118,163)'],
        [0.2, 'rgb(35,120,163)'],
        [0.20392156862745098, 'rgb(36,122,164)'],
        [0.20784313725490197, 'rgb(37,124,164)'],
        [0.21176470588235294, 'rgb(38,126,165)'],
        [0.21568627450980393, 'rgb(39,128,165)'],
        [0.2196078431372549, 'rgb(40,130,166)'],
        [0.2235294117647059, 'rgb(42,132,166)'],
        [0.22745098039215686, 'rgb(43,133,166)'],
        [0.23137254901960785, 'rgb(44,135,167)'],
        [0.23529411764705882, 'rgb(46,137,167)'],
        [0.23921568627450981, 'rgb(47,139,168)'],
        [0.24313725490196078, 'rgb(48,141,168)'],
        [0.24705882352941178, 'rgb(50,143,169)'],
        [0.25098039215686274, 'rgb(51,145,169)'],
        [0.2549019607843137, 'rgb(53,147,170)'],
        [0.25882352941176473, 'rgb(55,149,170)'],
        [0.2627450980392157, 'rgb(56,151,171)'],
        [0.26666666666666666, 'rgb(58,152,171)'],
        [0.27058823529411763, 'rgb(60,154,172)'],
        [0.27450980392156865, 'rgb(62,156,172)'],
        [0.2784313725490196, 'rgb(64,158,173)'],
        [0.2823529411764706, 'rgb(66,160,173)'],
        [0.28627450980392155, 'rgb(69,162,174)'],
        [0.2901960784313726, 'rgb(71,163,174)'],
        [0.29411764705882354, 'rgb(74,165,174)'],
        [0.2980392156862745, 'rgb(77,167,175)'],
        [0.30196078431372547, 'rgb(80,169,175)'],
        [0.3058823529411765, 'rgb(83,170,176)'],
        [0.30980392156862746, 'rgb(86,172,176)'],
        [0.3137254901960784, 'rgb(90,174,176)'],
        [0.3176470588235294, 'rgb(93,175,177)'],
        [0.3215686274509804, 'rgb(97,177,177)'],
        [0.3254901960784314, 'rgb(101,179,178)'],
        [0.32941176470588235, 'rgb(105,180,179)'],
        [0.3333333333333333, 'rgb(109,182,179)'],
        [0.33725490196078434, 'rgb(113,183,180)'],
        [0.3411764705882353, 'rgb(117,184,181)'],
        [0.34509803921568627, 'rgb(121,186,181)'],
        [0.34901960784313724, 'rgb(125,187,182)'],
        [0.35294117647058826, 'rgb(129,189,183)'],
        [0.3568627450980392, 'rgb(132,190,184)'],
        [0.3607843137254902, 'rgb(136,192,185)'],
        [0.36470588235294116, 'rgb(140,193,186)'],
        [0.3686274509803922, 'rgb(144,195,188)'],
        [0.37254901960784315, 'rgb(148,196,189)'],
        [0.3764705882352941, 'rgb(151,197,190)'],
        [0.3803921568627451, 'rgb(155,199,191)'],
        [0.3843137254901961, 'rgb(158,200,193)'],
        [0.38823529411764707, 'rgb(162,202,194)'],
        [0.39215686274509803, 'rgb(166,203,195)'],
        [0.396078431372549, 'rgb(169,205,196)'],
        [0.4, 'rgb(172,206,198)'],
        [0.403921568627451, 'rgb(176,208,199)'],
        [0.40784313725490196, 'rgb(179,210,201)'],
        [0.4117647058823529, 'rgb(183,211,202)'],
        [0.41568627450980394, 'rgb(186,213,204)'],
        [0.4196078431372549, 'rgb(189,214,205)'],
        [0.4235294117647059, 'rgb(193,216,206)'],
        [0.42745098039215684, 'rgb(196,218,208)'],
        [0.43137254901960786, 'rgb(199,219,209)'],
        [0.43529411764705883, 'rgb(202,221,211)'],
        [0.4392156862745098, 'rgb(205,223,212)'],
        [0.44313725490196076, 'rgb(209,224,214)'],
        [0.4470588235294118, 'rgb(212,226,215)'],
        [0.45098039215686275, 'rgb(215,228,217)'],
        [0.4549019607843137, 'rgb(218,230,218)'],
        [0.4588235294117647, 'rgb(221,231,219)'],
        [0.4627450980392157, 'rgb(224,233,221)'],
        [0.4666666666666667, 'rgb(227,235,222)'],
        [0.47058823529411764, 'rgb(230,237,223)'],
        [0.4745098039215686, 'rgb(234,239,224)'],
        [0.47843137254901963, 'rgb(237,241,226)'],
        [0.4823529411764706, 'rgb(240,243,227)'],
        [0.48627450980392156, 'rgb(243,245,227)'],
        [0.49019607843137253, 'rgb(246,247,228)'],
        [0.49411764705882355, 'rgb(250,248,229)'],
        [0.4980392156862745, 'rgb(253,250,230)'],
        [0.5019607843137255, 'rgb(255,252,204)'],
        [0.5058823529411764, 'rgb(253,250,200)'],
        [0.5098039215686274, 'rgb(252,247,196)'],
        [0.5137254901960784, 'rgb(250,245,191)'],
        [0.5176470588235295, 'rgb(249,243,187)'],
        [0.5215686274509804, 'rgb(248,240,183)'],
        [0.5254901960784314, 'rgb(246,238,178)'],
        [0.5294117647058824, 'rgb(245,235,174)'],
        [0.5333333333333333, 'rgb(244,233,170)'],
        [0.5372549019607843, 'rgb(242,231,166)'],
        [0.5411764705882353, 'rgb(241,228,161)'],
        [0.5450980392156862, 'rgb(240,226,157)'],
        [0.5490196078431373, 'rgb(238,224,153)'],
        [0.5529411764705883, 'rgb(237,222,148)'],
        [0.5568627450980392, 'rgb(235,220,144)'],
        [0.5607843137254902, 'rgb(234,217,140)'],
        [0.5647058823529412, 'rgb(232,215,135)'],
        [0.5686274509803921, 'rgb(231,213,131)'],
        [0.5725490196078431, 'rgb(229,211,127)'],
        [0.5764705882352941, 'rgb(228,209,122)'],
        [0.5803921568627451, 'rgb(226,207,118)'],
        [0.5843137254901961, 'rgb(224,205,113)'],
        [0.5882352941176471, 'rgb(223,203,109)'],
        [0.592156862745098, 'rgb(221,201,105)'],
        [0.596078431372549, 'rgb(219,199,100)'],
        [0.6, 'rgb(217,197,96)'],
        [0.6039215686274509, 'rgb(215,196,92)'],
        [0.6078431372549019, 'rgb(213,194,88)'],
        [0.611764705882353, 'rgb(210,192,83)'],
        [0.615686274509804, 'rgb(208,190,79)'],
        [0.6196078431372549, 'rgb(206,189,75)'],
        [0.6235294117647059, 'rgb(203,187,71)'],
        [0.6274509803921569, 'rgb(200,186,67)'],
        [0.6313725490196078, 'rgb(198,184,63)'],
        [0.6352941176470588, 'rgb(195,183,60)'],
        [0.6392156862745098, 'rgb(192,181,56)'],
        [0.6431372549019608, 'rgb(189,180,52)'],
        [0.6470588235294118, 'rgb(186,179,49)'],
        [0.6509803921568628, 'rgb(183,177,46)'],
        [0.6549019607843137, 'rgb(180,176,42)'],
        [0.6588235294117647, 'rgb(177,175,39)'],
        [0.6627450980392157, 'rgb(174,173,36)'],
        [0.6666666666666666, 'rgb(171,172,33)'],
        [0.6705882352941176, 'rgb(168,171,30)'],
        [0.6745098039215687, 'rgb(164,170,27)'],
        [0.6784313725490196, 'rgb(161,168,24)'],
        [0.6823529411764706, 'rgb(158,167,22)'],
        [0.6862745098039216, 'rgb(154,166,19)'],
        [0.6901960784313725, 'rgb(151,165,17)'],
        [0.6941176470588235, 'rgb(147,164,14)'],
        [0.6980392156862745, 'rgb(144,162,12)'],
        [0.7019607843137254, 'rgb(140,161,10)'],
        [0.7058823529411765, 'rgb(137,160,9)'],
        [0.7098039215686275, 'rgb(133,159,7)'],
        [0.7137254901960784, 'rgb(130,158,6)'],
        [0.7176470588235294, 'rgb(126,156,6)'],
        [0.7215686274509804, 'rgb(123,155,6)'],
        [0.7254901960784313, 'rgb(119,154,6)'],
        [0.7294117647058823, 'rgb(116,153,6)'],
        [0.7333333333333333, 'rgb(112,152,7)'],
        [0.7372549019607844, 'rgb(108,150,7)'],
        [0.7411764705882353, 'rgb(105,149,8)'],
        [0.7450980392156863, 'rgb(101,148,10)'],
        [0.7490196078431373, 'rgb(97,146,11)'],
        [0.7529411764705882, 'rgb(94,145,13)'],
        [0.7568627450980392, 'rgb(90,144,14)'],
        [0.7607843137254902, 'rgb(87,143,16)'],
        [0.7647058823529411, 'rgb(83,141,17)'],
        [0.7686274509803922, 'rgb(79,140,19)'],
        [0.7725490196078432, 'rgb(76,139,21)'],
        [0.7764705882352941, 'rgb(72,137,22)'],
        [0.7803921568627451, 'rgb(68,136,24)'],
        [0.7843137254901961, 'rgb(65,134,25)'],
        [0.788235294117647, 'rgb(61,133,27)'],
        [0.792156862745098, 'rgb(58,131,28)'],
        [0.796078431372549, 'rgb(54,130,29)'],
        [0.8, 'rgb(51,128,31)'],
        [0.803921568627451, 'rgb(47,127,32)'],
        [0.807843137254902, 'rgb(44,125,33)'],
        [0.8117647058823529, 'rgb(41,124,34)'],
        [0.8156862745098039, 'rgb(38,122,36)'],
        [0.8196078431372549, 'rgb(34,121,37)'],
        [0.8235294117647058, 'rgb(31,119,38)'],
        [0.8274509803921568, 'rgb(29,117,39)'],
        [0.8313725490196079, 'rgb(26,116,39)'],
        [0.8352941176470589, 'rgb(23,114,40)'],
        [0.8392156862745098, 'rgb(21,112,41)'],
        [0.8431372549019608, 'rgb(19,110,42)'],
        [0.8470588235294118, 'rgb(17,109,42)'],
        [0.8509803921568627, 'rgb(15,107,43)'],
        [0.8549019607843137, 'rgb(13,105,43)'],
        [0.8588235294117647, 'rgb(12,103,44)'],
        [0.8627450980392157, 'rgb(11,101,44)'],
        [0.8666666666666667, 'rgb(11,100,44)'],
        [0.8705882352941177, 'rgb(11,98,45)'],
        [0.8745098039215686, 'rgb(11,96,45)'],
        [0.8784313725490196, 'rgb(11,94,45)'],
        [0.8823529411764706, 'rgb(12,92,45)'],
        [0.8862745098039215, 'rgb(13,90,45)'],
        [0.8901960784313725, 'rgb(14,88,45)'],
        [0.8941176470588236, 'rgb(15,86,44)'],
        [0.8980392156862745, 'rgb(15,85,44)'],
        [0.9019607843137255, 'rgb(16,83,44)'],
        [0.9058823529411765, 'rgb(17,81,44)'],
        [0.9098039215686274, 'rgb(18,79,43)'],
        [0.9137254901960784, 'rgb(19,77,43)'],
        [0.9176470588235294, 'rgb(20,75,42)'],
        [0.9215686274509803, 'rgb(21,73,42)'],
        [0.9254901960784314, 'rgb(22,71,41)'],
        [0.9294117647058824, 'rgb(22,69,40)'],
        [0.9333333333333333, 'rgb(23,67,39)'],
        [0.9372549019607843, 'rgb(23,65,39)'],
        [0.9411764705882353, 'rgb(24,64,38)'],
        [0.9450980392156862, 'rgb(24,62,37)'],
        [0.9490196078431372, 'rgb(25,60,36)'],
        [0.9529411764705882, 'rgb(25,58,35)'],
        [0.9568627450980393, 'rgb(25,56,34)'],
        [0.9607843137254902, 'rgb(25,54,33)'],
        [0.9647058823529412, 'rgb(25,52,31)'],
        [0.9686274509803922, 'rgb(25,50,30)'],
        [0.9725490196078431, 'rgb(25,48,29)'],
        [0.9764705882352941, 'rgb(25,46,28)'],
        [0.9803921568627451, 'rgb(25,44,26)'],
        [0.984313725490196, 'rgb(25,43,25)'],
        [0.9882352941176471, 'rgb(24,41,23)'],
        [0.9921568627450981, 'rgb(24,39,22)'],
        [0.996078431372549, 'rgb(24,37,20)'],
        [1.0, 'rgb(23,35,19)'],
    ],
    'cmo.dense': [
        [0.0, 'rgb(230,241,241)'],
        [0.00392156862745098, 'rgb(228,240,240)'],
        [0.00784313725490196, 'rgb(227,239,239)'],
        [0.011764705882352941, 'rgb(225,238,239)'],
        [0.01568627450980392, 'rgb(223,237,238)'],
        [0.0196078431372549, 'rgb(221,237,237)'],
        [0.023529411764705882, 'rgb(220,236,237)'],
        [0.027450980392156862, 'rgb(218,235,236)'],
        [0.03137254901960784, 'rgb(216,234,236)'],
        [0.03529411764705882, 'rgb(215,233,235)'],
        [0.0392156862745098, 'rgb(213,233,235)'],
        [0.043137254901960784, 'rgb(211,232,234)'],
        [0.047058823529411764, 'rgb(209,231,234)'],
        [0.050980392156862744, 'rgb(208,230,233)'],
        [0.054901960784313725, 'rgb(206,229,233)'],
        [0.058823529411764705, 'rgb(204,228,232)'],
        [0.06274509803921569, 'rgb(203,228,232)'],
        [0.06666666666666667, 'rgb(201,227,232)'],
        [0.07058823529411765, 'rgb(199,226,231)'],
        [0.07450980392156863, 'rgb(198,225,231)'],
        [0.0784313725490196, 'rgb(196,224,230)'],
        [0.08235294117647059, 'rgb(194,223,230)'],
        [0.08627450980392157, 'rgb(193,223,230)'],
        [0.09019607843137255, 'rgb(191,222,230)'],
        [0.09411764705882353, 'rgb(190,221,229)'],
        [0.09803921568627451, 'rgb(188,220,229)'],
        [0.10196078431372549, 'rgb(186,219,229)'],
        [0.10588235294117647, 'rgb(185,218,228)'],
        [0.10980392156862745, 'rgb(183,218,228)'],
        [0.11372549019607843, 'rgb(182,217,228)'],
        [0.11764705882352941, 'rgb(180,216,228)'],
        [0.12156862745098039, 'rgb(178,215,228)'],
        [0.12549019607843137, 'rgb(177,214,227)'],
        [0.12941176470588237, 'rgb(175,213,227)'],
        [0.13333333333333333, 'rgb(174,212,227)'],
        [0.13725490196078433, 'rgb(172,212,227)'],
        [0.1411764705882353, 'rgb(171,211,227)'],
        [0.1450980392156863, 'rgb(169,210,227)'],
        [0.14901960784313725, 'rgb(168,209,227)'],
        [0.15294117647058825, 'rgb(166,208,227)'],
        [0.1568627450980392, 'rgb(165,207,226)'],
        [0.1607843137254902, 'rgb(163,206,226)'],
        [0.16470588235294117, 'rgb(162,206,226)'],
        [0.16862745098039217, 'rgb(160,205,226)'],
        [0.17254901960784313, 'rgb(159,204,226)'],
        [0.17647058823529413, 'rgb(158,203,226)'],
        [0.1803921568627451, 'rgb(156,202,226)'],
        [0.1843137254901961, 'rgb(155,201,226)'],
        [0.18823529411764706, 'rgb(154,200,226)'],
        [0.19215686274509805, 'rgb(152,199,226)'],
        [0.19607843137254902, 'rgb(151,198,226)'],
        [0.2, 'rgb(150,197,226)'],
        [0.20392156862745098, 'rgb(148,197,226)'],
        [0.20784313725490197, 'rgb(147,196,226)'],
        [0.21176470588235294, 'rgb(146,195,226)'],
        [0.21568627450980393, 'rgb(144,194,226)'],
        [0.2196078431372549, 'rgb(143,193,226)'],
        [0.2235294117647059, 'rgb(142,192,226)'],
        [0.22745098039215686, 'rgb(141,191,226)'],
        [0.23137254901960785, 'rgb(140,190,226)'],
        [0.23529411764705882, 'rgb(138,189,227)'],
        [0.23921568627450981, 'rgb(137,188,227)'],
        [0.24313725490196078, 'rgb(136,187,227)'],
        [0.24705882352941178, 'rgb(135,186,227)'],
        [0.25098039215686274, 'rgb(134,185,227)'],
        [0.2549019607843137, 'rgb(133,184,227)'],
        [0.25882352941176473, 'rgb(132,183,227)'],
        [0.2627450980392157, 'rgb(131,182,227)'],
        [0.26666666666666666, 'rgb(130,181,227)'],
        [0.27058823529411763, 'rgb(129,180,227)'],
        [0.27450980392156865, 'rgb(128,179,227)'],
        [0.2784313725490196, 'rgb(127,178,227)'],
        [0.2823529411764706, 'rgb(127,177,228)'],
        [0.28627450980392155, 'rgb(126,176,228)'],
        [0.2901960784313726, 'rgb(125,175,228)'],
        [0.29411764705882354, 'rgb(124,174,228)'],
        [0.2980392156862745, 'rgb(123,173,228)'],
        [0.30196078431372547, 'rgb(123,172,228)'],
        [0.3058823529411765, 'rgb(122,171,228)'],
        [0.30980392156862746, 'rgb(121,170,228)'],
        [0.3137254901960784, 'rgb(121,169,228)'],
        [0.3176470588235294, 'rgb(120,168,228)'],
        [0.3215686274509804, 'rgb(120,167,228)'],
        [0.3254901960784314, 'rgb(119,166,228)'],
        [0.32941176470588235, 'rgb(119,165,228)'],
        [0.3333333333333333, 'rgb(118,164,229)'],
        [0.33725490196078434, 'rgb(118,163,229)'],
        [0.3411764705882353, 'rgb(117,161,229)'],
        [0.34509803921568627, 'rgb(117,160,229)'],
        [0.34901960784313724, 'rgb(117,159,229)'],
        [0.35294117647058826, 'rgb(117,158,229)'],
        [0.3568627450980392, 'rgb(116,157,229)'],
        [0.3607843137254902, 'rgb(116,156,228)'],
        [0.36470588235294116, 'rgb(116,155,228)'],
        [0.3686274509803922, 'rgb(116,154,228)'],
        [0.37254901960784315, 'rgb(116,152,228)'],
        [0.3764705882352941, 'rgb(115,151,228)'],
        [0.3803921568627451, 'rgb(115,150,228)'],
        [0.3843137254901961, 'rgb(115,149,228)'],
        [0.38823529411764707, 'rgb(115,148,228)'],
        [0.39215686274509803, 'rgb(115,147,227)'],
        [0.396078431372549, 'rgb(115,145,227)'],
        [0.4, 'rgb(115,144,227)'],
        [0.403921568627451, 'rgb(115,143,227)'],
        [0.40784313725490196, 'rgb(115,142,226)'],
        [0.4117647058823529, 'rgb(116,141,226)'],
        [0.41568627450980394, 'rgb(116,139,226)'],
        [0.4196078431372549, 'rgb(116,138,226)'],
        [0.4235294117647059, 'rgb(116,137,225)'],
        [0.42745098039215684, 'rgb(116,136,225)'],
        [0.43137254901960786, 'rgb(116,135,224)'],
        [0.43529411764705883, 'rgb(116,133,224)'],
        [0.4392156862745098, 'rgb(117,132,223)'],
        [0.44313725490196076, 'rgb(117,131,223)'],
        [0.4470588235294118, 'rgb(117,130,222)'],
        [0.45098039215686275, 'rgb(117,129,222)'],
        [0.4549019607843137, 'rgb(117,127,221)'],
        [0.4588235294117647, 'rgb(117,126,221)'],
        [0.4627450980392157, 'rgb(118,125,220)'],
        [0.4666666666666667, 'rgb(118,124,220)'],
        [0.47058823529411764, 'rgb(118,123,219)'],
        [0.4745098039215686, 'rgb(118,121,218)'],
        [0.47843137254901963, 'rgb(118,120,218)'],
        [0.4823529411764706, 'rgb(119,119,217)'],
        [0.48627450980392156, 'rgb(119,118,216)'],
        [0.49019607843137253, 'rgb(119,117,215)'],
        [0.49411764705882355, 'rgb(119,115,215)'],
        [0.4980392156862745, 'rgb(119,114,214)'],
        [0.5019607843137255, 'rgb(120,113,213)'],
        [0.5058823529411764, 'rgb(120,112,212)'],
        [0.5098039215686274, 'rgb(120,111,211)'],
        [0.5137254901960784, 'rgb(120,110,210)'],
        [0.5176470588235295, 'rgb(120,108,210)'],
        [0.5215686274509804, 'rgb(120,107,209)'],
        [0.5254901960784314, 'rgb(120,106,208)'],
        [0.5294117647058824, 'rgb(121,105,207)'],
        [0.5333333333333333, 'rgb(121,104,206)'],
        [0.5372549019607843, 'rgb(121,102,205)'],
        [0.5411764705882353, 'rgb(121,101,204)'],
        [0.5450980392156862, 'rgb(121,100,203)'],
        [0.5490196078431373, 'rgb(121,99,202)'],
        [0.5529411764705883, 'rgb(121,98,201)'],
        [0.5568627450980392, 'rgb(121,97,200)'],
        [0.5607843137254902, 'rgb(121,96,199)'],
        [0.5647058823529412, 'rgb(121,94,197)'],
        [0.5686274509803921, 'rgb(121,93,196)'],
        [0.5725490196078431, 'rgb(121,92,195)'],
        [0.5764705882352941, 'rgb(121,91,194)'],
        [0.5803921568627451, 'rgb(121,90,193)'],
        [0.5843137254901961, 'rgb(121,89,192)'],
        [0.5882352941176471, 'rgb(121,88,191)'],
        [0.592156862745098, 'rgb(121,87,189)'],
        [0.596078431372549, 'rgb(121,86,188)'],
        [0.6, 'rgb(121,84,187)'],
        [0.6039215686274509, 'rgb(121,83,186)'],
        [0.6078431372549019, 'rgb(121,82,184)'],
        [0.611764705882353, 'rgb(121,81,183)'],
        [0.615686274509804, 'rgb(121,80,182)'],
        [0.6196078431372549, 'rgb(121,79,181)'],
        [0.6235294117647059, 'rgb(120,78,179)'],
        [0.6274509803921569, 'rgb(120,77,178)'],
        [0.6313725490196078, 'rgb(120,76,177)'],
        [0.6352941176470588, 'rgb(120,75,175)'],
        [0.6392156862745098, 'rgb(120,74,174)'],
        [0.6431372549019608, 'rgb(120,73,173)'],
        [0.6470588235294118, 'rgb(119,72,171)'],
        [0.6509803921568628, 'rgb(119,71,170)'],
        [0.6549019607843137, 'rgb(119,70,169)'],
        [0.6588235294117647, 'rgb(119,69,167)'],
        [0.6627450980392157, 'rgb(119,67,166)'],
        [0.6666666666666666, 'rgb(118,66,165)'],
        [0.6705882352941176, 'rgb(118,65,163)'],
        [0.6745098039215687, 'rgb(118,64,162)'],
        [0.6784313725490196, 'rgb(118,63,160)'],
        [0.6823529411764706, 'rgb(117,62,159)'],
        [0.6862745098039216, 'rgb(117,61,157)'],
        [0.6901960784313725, 'rgb(117,60,156)'],
        [0.6941176470588235, 'rgb(116,59,155)'],
        [0.6980392156862745, 'rgb(116,59,153)'],
        [0.7019607843137254, 'rgb(116,58,152)'],
        [0.7058823529411765, 'rgb(115,57,150)'],
        [0.7098039215686275, 'rgb(115,56,149)'],
        [0.7137254901960784, 'rgb(115,55,147)'],
        [0.7176470588235294, 'rgb(114,54,146)'],
        [0.7215686274509804, 'rgb(114,53,144)'],
        [0.7254901960784313, 'rgb(114,52,143)'],
        [0.7294117647058823, 'rgb(113,51,141)'],
        [0.7333333333333333, 'rgb(113,50,140)'],
        [0.7372549019607844, 'rgb(112,49,138)'],
        [0.7411764705882353, 'rgb(112,48,136)'],
        [0.7450980392156863, 'rgb(111,47,135)'],
        [0.7490196078431373, 'rgb(111,46,133)'],
        [0.7529411764705882, 'rgb(110,45,132)'],
        [0.7568627450980392, 'rgb(110,45,130)'],
        [0.7607843137254902, 'rgb(109,44,129)'],
        [0.7647058823529411, 'rgb(109,43,127)'],
        [0.7686274509803922, 'rgb(108,42,126)'],
        [0.7725490196078432, 'rgb(108,41,124)'],
        [0.7764705882352941, 'rgb(107,40,122)'],
        [0.7803921568627451, 'rgb(107,40,121)'],
        [0.7843137254901961, 'rgb(106,39,119)'],
        [0.788235294117647, 'rgb(106,38,117)'],
        [0.792156862745098, 'rgb(105,37,116)'],
        [0.796078431372549, 'rgb(104,36,114)'],
        [0.8, 'rgb(104,36,113)'],
        [0.803921568627451, 'rgb(103,35,111)'],
        [0.807843137254902, 'rgb(103,34,109)'],
        [0.8117647058823529, 'rgb(102,33,108)'],
        [0.8156862745098039, 'rgb(101,33,106)'],
        [0.8196078431372549, 'rgb(101,32,104)'],
        [0.8235294117647058, 'rgb(100,31,103)'],
        [0.8274509803921568, 'rgb(99,31,101)'],
        [0.8313725490196079, 'rgb(98,30,99)'],
        [0.8352941176470589, 'rgb(98,29,98)'],
        [0.8392156862745098, 'rgb(97,29,96)'],
        [0.8431372549019608, 'rgb(96,28,94)'],
        [0.8470588235294118, 'rgb(95,27,93)'],
        [0.8509803921568627, 'rgb(95,27,91)'],
        [0.8549019607843137, 'rgb(94,26,89)'],
        [0.8588235294117647, 'rgb(93,26,88)'],
        [0.8627450980392157, 'rgb(92,25,86)'],
        [0.8666666666666667, 'rgb(91,25,84)'],
        [0.8705882352941177, 'rgb(90,24,83)'],
        [0.8745098039215686, 'rgb(90,24,81)'],
        [0.8784313725490196, 'rgb(89,23,80)'],
        [0.8823529411764706, 'rgb(88,23,78)'],
        [0.8862745098039215, 'rgb(87,22,76)'],
        [0.8901960784313725, 'rgb(86,22,75)'],
        [0.8941176470588236, 'rgb(85,22,73)'],
        [0.8980392156862745, 'rgb(84,21,72)'],
        [0.9019607843137255, 'rgb(83,21,70)'],
        [0.9058823529411765, 'rgb(82,21,68)'],
        [0.9098039215686274, 'rgb(81,20,67)'],
        [0.9137254901960784, 'rgb(80,20,65)'],
        [0.9176470588235294, 'rgb(79,20,64)'],
        [0.9215686274509803, 'rgb(78,19,62)'],
        [0.9254901960784314, 'rgb(77,19,61)'],
        [0.9294117647058824, 'rgb(75,19,59)'],
        [0.9333333333333333, 'rgb(74,19,58)'],
        [0.9372549019607843, 'rgb(73,18,56)'],
        [0.9411764705882353, 'rgb(72,18,55)'],
        [0.9450980392156862, 'rgb(71,18,54)'],
        [0.9490196078431372, 'rgb(70,18,52)'],
        [0.9529411764705882, 'rgb(69,17,51)'],
        [0.9568627450980393, 'rgb(68,17,50)'],
        [0.9607843137254902, 'rgb(66,17,48)'],
        [0.9647058823529412, 'rgb(65,17,47)'],
        [0.9686274509803922, 'rgb(64,16,46)'],
        [0.9725490196078431, 'rgb(63,16,45)'],
        [0.9764705882352941, 'rgb(62,16,43)'],
        [0.9803921568627451, 'rgb(60,16,42)'],
        [0.984313725490196, 'rgb(59,15,41)'],
        [0.9882352941176471, 'rgb(58,15,40)'],
        [0.9921568627450981, 'rgb(57,15,39)'],
        [0.996078431372549, 'rgb(56,15,37)'],
        [1.0, 'rgb(54,14,36)'],
    ],
    'cmo.diff': [
        [0.0, 'rgb(8,35,64)'],
        [0.00392156862745098, 'rgb(9,37,66)'],
        [0.00784313725490196, 'rgb(10,38,68)'],
        [0.011764705882352941, 'rgb(11,40,69)'],
        [0.01568627450980392, 'rgb(12,42,71)'],
        [0.0196078431372549, 'rgb(12,44,73)'],
        [0.023529411764705882, 'rgb(13,45,75)'],
        [0.027450980392156862, 'rgb(14,47,77)'],
        [0.03137254901960784, 'rgb(15,49,79)'],
        [0.03529411764705882, 'rgb(16,50,81)'],
        [0.0392156862745098, 'rgb(17,52,83)'],
        [0.043137254901960784, 'rgb(17,54,85)'],
        [0.047058823529411764, 'rgb(18,55,86)'],
        [0.050980392156862744, 'rgb(19,57,88)'],
        [0.054901960784313725, 'rgb(20,59,90)'],
        [0.058823529411764705, 'rgb(20,61,92)'],
        [0.06274509803921569, 'rgb(21,62,94)'],
        [0.06666666666666667, 'rgb(22,64,95)'],
        [0.07058823529411765, 'rgb(23,66,97)'],
        [0.07450980392156863, 'rgb(24,67,99)'],
        [0.0784313725490196, 'rgb(25,69,100)'],
        [0.08235294117647059, 'rgb(26,71,102)'],
        [0.08627450980392157, 'rgb(27,72,103)'],
        [0.09019607843137255, 'rgb(29,74,104)'],
        [0.09411764705882353, 'rgb(31,76,105)'],
        [0.09803921568627451, 'rgb(33,77,106)'],
        [0.10196078431372549, 'rgb(36,79,107)'],
        [0.10588235294117647, 'rgb(38,80,108)'],
        [0.10980392156862745, 'rgb(40,82,109)'],
        [0.11372549019607843, 'rgb(43,83,110)'],
        [0.11764705882352941, 'rgb(45,85,111)'],
        [0.12156862745098039, 'rgb(47,86,112)'],
        [0.12549019607843137, 'rgb(49,88,113)'],
        [0.12941176470588237, 'rgb(52,89,115)'],
        [0.13333333333333333, 'rgb(54,91,116)'],
        [0.13725490196078433, 'rgb(56,92,117)'],
        [0.1411764705882353, 'rgb(58,94,118)'],
        [0.1450980392156863, 'rgb(60,95,119)'],
        [0.14901960784313725, 'rgb(62,97,120)'],
        [0.15294117647058825, 'rgb(65,98,121)'],
        [0.1568627450980392, 'rgb(67,100,122)'],
        [0.1607843137254902, 'rgb(69,101,123)'],
        [0.16470588235294117, 'rgb(71,103,125)'],
        [0.16862745098039217, 'rgb(73,104,126)'],
        [0.17254901960784313, 'rgb(75,106,127)'],
        [0.17647058823529413, 'rgb(77,107,128)'],
        [0.1803921568627451, 'rgb(79,109,129)'],
        [0.1843137254901961, 'rgb(81,110,130)'],
        [0.18823529411764706, 'rgb(83,112,132)'],
        [0.19215686274509805, 'rgb(85,113,133)'],
        [0.19607843137254902, 'rgb(88,115,134)'],
        [0.2, 'rgb(90,116,135)'],
        [0.20392156862745098, 'rgb(92,118,136)'],
        [0.20784313725490197, 'rgb(94,120,138)'],
        [0.21176470588235294, 'rgb(96,121,139)'],
        [0.21568627450980393, 'rgb(98,123,140)'],
        [0.2196078431372549, 'rgb(100,124,141)'],
        [0.2235294117647059, 'rgb(102,126,142)'],
        [0.22745098039215686, 'rgb(104,127,144)'],
        [0.23137254901960785, 'rgb(106,129,145)'],
        [0.23529411764705882, 'rgb(108,130,146)'],
        [0.23921568627450981, 'rgb(110,132,148)'],
        [0.24313725490196078, 'rgb(112,134,149)'],
        [0.24705882352941178, 'rgb(114,135,150)'],
        [0.25098039215686274, 'rgb(116,137,151)'],
        [0.2549019607843137, 'rgb(118,138,153)'],
        [0.25882352941176473, 'rgb(120,140,154)'],
        [0.2627450980392157, 'rgb(123,141,155)'],
        [0.26666666666666666, 'rgb(125,143,157)'],
        [0.27058823529411763, 'rgb(127,145,158)'],
        [0.27450980392156865, 'rgb(129,146,159)'],
        [0.2784313725490196, 'rgb(131,148,161)'],
        [0.2823529411764706, 'rgb(133,150,162)'],
        [0.28627450980392155, 'rgb(135,151,163)'],
        [0.2901960784313726, 'rgb(137,153,165)'],
        [0.29411764705882354, 'rgb(139,154,166)'],
        [0.2980392156862745, 'rgb(141,156,167)'],
        [0.30196078431372547, 'rgb(143,158,169)'],
        [0.3058823529411765, 'rgb(146,159,170)'],
        [0.30980392156862746, 'rgb(148,161,172)'],
        [0.3137254901960784, 'rgb(150,163,173)'],
        [0.3176470588235294, 'rgb(152,165,175)'],
        [0.3215686274509804, 'rgb(154,166,176)'],
        [0.3254901960784314, 'rgb(156,168,177)'],
        [0.32941176470588235, 'rgb(158,170,179)'],
        [0.3333333333333333, 'rgb(160,171,180)'],
        [0.33725490196078434, 'rgb(163,173,182)'],
        [0.3411764705882353, 'rgb(165,175,183)'],
        [0.34509803921568627, 'rgb(167,177,185)'],
        [0.34901960784313724, 'rgb(169,178,186)'],
        [0.35294117647058826, 'rgb(171,180,188)'],
        [0.3568627450980392, 'rgb(174,182,189)'],
        [0.3607843137254902, 'rgb(176,184,191)'],
        [0.36470588235294116, 'rgb(178,186,192)'],
        [0.3686274509803922, 'rgb(180,187,194)'],
        [0.37254901960784315, 'rgb(182,189,196)'],
        [0.3764705882352941, 'rgb(185,191,197)'],
        [0.3803921568627451, 'rgb(187,193,199)'],
        [0.3843137254901961, 'rgb(189,195,200)'],
        [0.38823529411764707, 'rgb(191,197,202)'],
        [0.39215686274509803, 'rgb(194,198,204)'],
        [0.396078431372549, 'rgb(196,200,205)'],
        [0.4, 'rgb(198,202,207)'],
        [0.403921568627451, 'rgb(200,204,209)'],
        [0.40784313725490196, 'rgb(203,206,210)'],
        [0.4117647058823529, 'rgb(205,208,212)'],
        [0.41568627450980394, 'rgb(207,210,214)'],
        [0.4196078431372549, 'rgb(210,212,215)'],
        [0.4235294117647059, 'rgb(212,214,217)'],
        [0.42745098039215684, 'rgb(214,216,219)'],
        [0.43137254901960786, 'rgb(217,218,221)'],
        [0.43529411764705883, 'rgb(219,220,222)'],
        [0.4392156862745098, 'rgb(221,222,224)'],
        [0.44313725490196076, 'rgb(224,224,226)'],
        [0.4470588235294118, 'rgb(226,226,227)'],
        [0.45098039215686275, 'rgb(228,227,229)'],
        [0.4549019607843137, 'rgb(230,229,231)'],
        [0.4588235294117647, 'rgb(232,231,232)'],
        [0.4627450980392157, 'rgb(235,233,234)'],
        [0.4666666666666667, 'rgb(236,234,235)'],
        [0.47058823529411764, 'rgb(238,236,236)'],
        [0.4745098039215686, 'rgb(240,237,238)'],
        [0.47843137254901963, 'rgb(241,238,239)'],
        [0.4823529411764706, 'rgb(243,239,239)'],
        [0.48627450980392156, 'rgb(244,240,240)'],
        [0.49019607843137253, 'rgb(245,241,240)'],
        [0.49411764705882355, 'rgb(245,241,240)'],
        [0.4980392156862745, 'rgb(246,241,240)'],
        [0.5019607843137255, 'rgb(246,241,240)'],
        [0.5058823529411764, 'rgb(245,241,239)'],
        [0.5098039215686274, 'rgb(245,240,238)'],
        [0.5137254901960784, 'rgb(244,239,237)'],
        [0.5176470588235295, 'rgb(243,238,235)'],
        [0.5215686274509804, 'rgb(242,237,233)'],
        [0.5254901960784314, 'rgb(241,235,232)'],
        [0.5294117647058824, 'rgb(239,234,229)'],
        [0.5333333333333333, 'rgb(238,232,227)'],
        [0.5372549019607843, 'rgb(236,230,225)'],
        [0.5411764705882353, 'rgb(234,229,223)'],
        [0.5450980392156862, 'rgb(232,227,220)'],
        [0.5490196078431373, 'rgb(231,225,218)'],
        [0.5529411764705883, 'rgb(229,223,215)'],
        [0.5568627450980392, 'rgb(227,221,212)'],
        [0.5607843137254902, 'rgb(225,219,210)'],
        [0.5647058823529412, 'rgb(223,217,207)'],
        [0.5686274509803921, 'rgb(221,215,205)'],
        [0.5725490196078431, 'rgb(219,213,202)'],
        [0.5764705882352941, 'rgb(217,211,199)'],
        [0.5803921568627451, 'rgb(215,209,197)'],
        [0.5843137254901961, 'rgb(213,207,194)'],
        [0.5882352941176471, 'rgb(211,205,192)'],
        [0.592156862745098, 'rgb(210,203,189)'],
        [0.596078431372549, 'rgb(208,201,187)'],
        [0.6, 'rgb(206,199,184)'],
        [0.6039215686274509, 'rgb(204,197,181)'],
        [0.6078431372549019, 'rgb(202,195,179)'],
        [0.611764705882353, 'rgb(200,193,176)'],
        [0.615686274509804, 'rgb(199,191,174)'],
        [0.6196078431372549, 'rgb(197,189,171)'],
        [0.6235294117647059, 'rgb(195,187,169)'],
        [0.6274509803921569, 'rgb(193,185,166)'],
        [0.6313725490196078, 'rgb(191,183,164)'],
        [0.6352941176470588, 'rgb(190,181,161)'],
        [0.6392156862745098, 'rgb(188,179,159)'],
        [0.6431372549019608, 'rgb(186,177,157)'],
        [0.6470588235294118, 'rgb(185,176,154)'],
        [0.6509803921568628, 'rgb(183,174,152)'],
        [0.6549019607843137, 'rgb(181,172,149)'],
        [0.6588235294117647, 'rgb(179,170,147)'],
        [0.6627450980392157, 'rgb(178,168,144)'],
        [0.6666666666666666, 'rgb(176,166,142)'],
        [0.6705882352941176, 'rgb(174,165,140)'],
        [0.6745098039215687, 'rgb(173,163,137)'],
        [0.6784313725490196, 'rgb(171,161,135)'],
        [0.6823529411764706, 'rgb(169,159,133)'],
        [0.6862745098039216, 'rgb(168,157,130)'],
        [0.6901960784313725, 'rgb(166,156,128)'],
        [0.6941176470588235, 'rgb(164,154,125)'],
        [0.6980392156862745, 'rgb(163,152,123)'],
        [0.7019607843137254, 'rgb(161,150,121)'],
        [0.7058823529411765, 'rgb(160,149,118)'],
        [0.7098039215686275, 'rgb(158,147,116)'],
        [0.7137254901960784, 'rgb(156,145,114)'],
        [0.7176470588235294, 'rgb(155,143,112)'],
        [0.7215686274509804, 'rgb(153,142,109)'],
        [0.7254901960784313, 'rgb(152,140,107)'],
        [0.7294117647058823, 'rgb(150,138,105)'],
        [0.7333333333333333, 'rgb(149,137,103)'],
        [0.7372549019607844, 'rgb(147,135,100)'],
        [0.7411764705882353, 'rgb(145,133,98)'],
        [0.7450980392156863, 'rgb(144,132,96)'],
        [0.7490196078431373, 'rgb(142,130,94)'],
        [0.7529411764705882, 'rgb(141,128,91)'],
        [0.7568627450980392, 'rgb(139,127,89)'],
        [0.7607843137254902, 'rgb(138,125,87)'],
        [0.7647058823529411, 'rgb(136,123,85)'],
        [0.7686274509803922, 'rgb(135,122,83)'],
        [0.7725490196078432, 'rgb(133,120,80)'],
        [0.7764705882352941, 'rgb(131,118,78)'],
        [0.7803921568627451, 'rgb(130,117,76)'],
        [0.7843137254901961, 'rgb(128,115,74)'],
        [0.788235294117647, 'rgb(127,114,72)'],
        [0.792156862745098, 'rgb(125,112,70)'],
        [0.796078431372549, 'rgb(124,110,67)'],
        [0.8, 'rgb(122,109,65)'],
        [0.803921568627451, 'rgb(121,107,63)'],
        [0.807843137254902, 'rgb(119,106,61)'],
        [0.8117647058823529, 'rgb(118,104,59)'],
        [0.8156862745098039, 'rgb(116,102,57)'],
        [0.8196078431372549, 'rgb(114,101,55)'],
        [0.8235294117647058, 'rgb(113,99,53)'],
        [0.8274509803921568, 'rgb(111,98,51)'],
        [0.8313725490196079, 'rgb(110,96,48)'],
        [0.8352941176470589, 'rgb(108,95,46)'],
        [0.8392156862745098, 'rgb(106,93,44)'],
        [0.8431372549019608, 'rgb(104,92,43)'],
        [0.8470588235294118, 'rgb(103,90,41)'],
        [0.8509803921568627, 'rgb(101,89,39)'],
        [0.8549019607843137, 'rgb(99,88,38)'],
        [0.8588235294117647, 'rgb(97,86,37)'],
        [0.8627450980392157, 'rgb(95,85,36)'],
        [0.8666666666666667, 'rgb(93,84,35)'],
        [0.8705882352941177, 'rgb(91,82,34)'],
        [0.8745098039215686, 'rgb(89,81,33)'],
        [0.8784313725490196, 'rgb(87,79,32)'],
        [0.8823529411764706, 'rgb(85,78,32)'],
        [0.8862745098039215, 'rgb(83,77,31)'],
        [0.8901960784313725, 'rgb(81,75,30)'],
        [0.8941176470588236, 'rgb(79,74,29)'],
        [0.8980392156862745, 'rgb(77,72,29)'],
        [0.9019607843137255, 'rgb(75,71,28)'],
        [0.9058823529411765, 'rgb(73,69,27)'],
        [0.9098039215686274, 'rgb(71,68,26)'],
        [0.9137254901960784, 'rgb(69,67,26)'],
        [0.9176470588235294, 'rgb(67,65,25)'],
        [0.9215686274509803, 'rgb(66,64,24)'],
        [0.9254901960784314, 'rgb(64,62,23)'],
        [0.9294117647058824, 'rgb(62,61,22)'],
        [0.9333333333333333, 'rgb(60,59,22)'],
        [0.9372549019607843, 'rgb(58,58,21)'],
        [0.9411764705882353, 'rgb(56,57,20)'],
        [0.9450980392156862, 'rgb(54,55,19)'],
        [0.9490196078431372, 'rgb(52,54,18)'],
        [0.9529411764705882, 'rgb(51,52,18)'],
        [0.9568627450980393, 'rgb(49,51,17)'],
        [0.9607843137254902, 'rgb(47,49,16)'],
        [0.9647058823529412, 'rgb(45,48,15)'],
        [0.9686274509803922, 'rgb(43,46,14)'],
        [0.9725490196078431, 'rgb(41,45,13)'],
        [0.9764705882352941, 'rgb(39,43,12)'],
        [0.9803921568627451, 'rgb(38,42,11)'],
        [0.984313725490196, 'rgb(36,40,10)'],
        [0.9882352941176471, 'rgb(34,39,9)'],
        [0.9921568627450981, 'rgb(32,37,9)'],
        [0.996078431372549, 'rgb(30,36,8)'],
        [1.0, 'rgb(28,34,7)'],
    ],
    'cmo.gray': [
        [0.0, 'rgb(0,0,0)'],
        [0.00392156862745098, 'rgb(0,0,0)'],
        [0.00784313725490196, 'rgb(0,0,0)'],
        [0.011764705882352941, 'rgb(0,0,0)'],
        [0.01568627450980392, 'rgb(1,1,1)'],
        [0.0196078431372549, 'rgb(1,1,1)'],
        [0.023529411764705882, 'rgb(2,2,2)'],
        [0.027450980392156862, 'rgb(2,2,2)'],
        [0.03137254901960784, 'rgb(3,3,3)'],
        [0.03529411764705882, 'rgb(3,3,3)'],
        [0.0392156862745098, 'rgb(4,4,4)'],
        [0.043137254901960784, 'rgb(5,5,5)'],
        [0.047058823529411764, 'rgb(5,5,5)'],
        [0.050980392156862744, 'rgb(6,6,6)'],
        [0.054901960784313725, 'rgb(7,7,7)'],
        [0.058823529411764705, 'rgb(8,8,8)'],
        [0.06274509803921569, 'rgb(9,9,9)'],
        [0.06666666666666667, 'rgb(10,10,10)'],
        [0.07058823529411765, 'rgb(11,11,11)'],
        [0.07450980392156863, 'rgb(12,12,12)'],
        [0.0784313725490196, 'rgb(13,13,13)'],
        [0.08235294117647059, 'rgb(15,14,14)'],
        [0.08627450980392157, 'rgb(16,15,15)'],
        [0.09019607843137255, 'rgb(17,16,16)'],
        [0.09411764705882353, 'rgb(18,17,17)'],
        [0.09803921568627451, 'rgb(19,18,18)'],
        [0.10196078431372549, 'rgb(20,19,19)'],
        [0.10588235294117647, 'rgb(21,20,20)'],
        [0.10980392156862745, 'rgb(22,21,21)'],
        [0.11372549019607843, 'rgb(23,22,22)'],
        [0.11764705882352941, 'rgb(24,23,23)'],
        [0.12156862745098039, 'rgb(25,24,24)'],
        [0.12549019607843137, 'rgb(26,25,25)'],
        [0.12941176470588237, 'rgb(27,26,26)'],
        [0.13333333333333333, 'rgb(28,27,27)'],
        [0.13725490196078433, 'rgb(29,28,28)'],
        [0.1411764705882353, 'rgb(29,29,29)'],
        [0.1450980392156863, 'rgb(30,30,30)'],
        [0.14901960784313725, 'rgb(31,31,31)'],
        [0.15294117647058825, 'rgb(32,32,32)'],
        [0.1568627450980392, 'rgb(33,33,33)'],
        [0.1607843137254902, 'rgb(34,34,34)'],
        [0.16470588235294117, 'rgb(35,35,35)'],
        [0.16862745098039217, 'rgb(36,36,36)'],
        [0.17254901960784313, 'rgb(37,37,36)'],
        [0.17647058823529413, 'rgb(38,38,37)'],
        [0.1803921568627451, 'rgb(39,38,38)'],
        [0.1843137254901961, 'rgb(40,39,39)'],
        [0.18823529411764706, 'rgb(41,40,40)'],
        [0.19215686274509805, 'rgb(42,41,41)'],
        [0.19607843137254902, 'rgb(43,42,42)'],
        [0.2, 'rgb(43,43,43)'],
        [0.20392156862745098, 'rgb(44,44,44)'],
        [0.20784313725490197, 'rgb(45,45,45)'],
        [0.21176470588235294, 'rgb(46,46,46)'],
        [0.21568627450980393, 'rgb(47,47,46)'],
        [0.2196078431372549, 'rgb(48,48,47)'],
        [0.2235294117647059, 'rgb(49,48,48)'],
        [0.22745098039215686, 'rgb(50,49,49)'],
        [0.23137254901960785, 'rgb(51,50,50)'],
        [0.23529411764705882, 'rgb(52,51,51)'],
        [0.23921568627450981, 'rgb(53,52,52)'],
        [0.24313725490196078, 'rgb(53,53,53)'],
        [0.24705882352941178, 'rgb(54,54,54)'],
        [0.25098039215686274, 'rgb(55,55,55)'],
        [0.2549019607843137, 'rgb(56,56,55)'],
        [0.25882352941176473, 'rgb(57,57,56)'],
        [0.2627450980392157, 'rgb(58,57,57)'],
        [0.26666666666666666, 'rgb(59,58,58)'],
        [0.27058823529411763, 'rgb(60,59,59)'],
        [0.27450980392156865, 'rgb(61,60,60)'],
        [0.2784313725490196, 'rgb(62,61,61)'],
        [0.2823529411764706, 'rgb(62,62,62)'],
        [0.28627450980392155, 'rgb(63,63,63)'],
        [0.2901960784313726, 'rgb(64,64,64)'],
        [0.29411764705882354, 'rgb(65,65,64)'],
        [0.2980392156862745, 'rgb(66,66,65)'],
        [0.30196078431372547, 'rgb(67,66,66)'],
        [0.3058823529411765, 'rgb(68,67,67)'],
        [0.30980392156862746, 'rgb(69,68,68)'],
        [0.3137254901960784, 'rgb(70,69,69)'],
        [0.3176470588235294, 'rgb(71,70,70)'],
        [0.3215686274509804, 'rgb(71,71,71)'],
        [0.3254901960784314, 'rgb(72,72,72)'],
        [0.32941176470588235, 'rgb(73,73,72)'],
        [0.3333333333333333, 'rgb(74,74,73)'],
        [0.33725490196078434, 'rgb(75,75,74)'],
        [0.3411764705882353, 'rgb(76,75,75)'],
        [0.34509803921568627, 'rgb(77,76,76)'],
        [0.34901960784313724, 'rgb(78,77,77)'],
        [0.35294117647058826, 'rgb(79,78,78)'],
        [0.3568627450980392, 'rgb(80,79,79)'],
        [0.3607843137254902, 'rgb(80,80,80)'],
        [0.36470588235294116, 'rgb(81,81,80)'],
        [0.3686274509803922, 'rgb(82,82,81)'],
        [0.37254901960784315, 'rgb(83,83,82)'],
        [0.3764705882352941, 'rgb(84,84,83)'],
        [0.3803921568627451, 'rgb(85,84,84)'],
        [0.3843137254901961, 'rgb(86,85,85)'],
        [0.38823529411764707, 'rgb(87,86,86)'],
        [0.39215686274509803, 'rgb(88,87,87)'],
        [0.396078431372549, 'rgb(89,88,88)'],
        [0.4, 'rgb(90,89,89)'],
        [0.403921568627451, 'rgb(90,90,90)'],
        [0.40784313725490196, 'rgb(91,91,90)'],
        [0.4117647058823529, 'rgb(92,92,91)'],
        [0.41568627450980394, 'rgb(93,93,92)'],
        [0.4196078431372549, 'rgb(94,94,93)'],
        [0.4235294117647059, 'rgb(95,94,94)'],
        [0.42745098039215684, 'rgb(96,95,95)'],
        [0.43137254901960786, 'rgb(97,96,96)'],
        [0.43529411764705883, 'rgb(98,97,97)'],
        [0.4392156862745098, 'rgb(99,98,98)'],
        [0.44313725490196076, 'rgb(100,99,99)'],
        [0.4470588235294118, 'rgb(101,100,100)'],
        [0.45098039215686275, 'rgb(101,101,100)'],
        [0.4549019607843137, 'rgb(102,102,101)'],
        [0.4588235294117647, 'rgb(103,103,102)'],
        [0.4627450980392157, 'rgb(104,104,103)'],
        [0.4666666666666667, 'rgb(105,105,104)'],
        [0.47058823529411764, 'rgb(106,106,105)'],
        [0.4745098039215686, 'rgb(107,107,106)'],
        [0.47843137254901963, 'rgb(108,107,107)'],
        [0.4823529411764706, 'rgb(109,108,108)'],
        [0.48627450980392156, 'rgb(110,109,109)'],
        [0.49019607843137253, 'rgb(111,110,110)'],
        [0.49411764705882355, 'rgb(112,111,111)'],
        [0.4980392156862745, 'rgb(113,112,112)'],
        [0.5019607843137255, 'rgb(114,113,113)'],
        [0.5058823529411764, 'rgb(115,114,113)'],
        [0.5098039215686274, 'rgb(115,115,114)'],
        [0.5137254901960784, 'rgb(116,116,115)'],
        [0.5176470588235295, 'rgb(117,117,116)'],
        [0.5215686274509804, 'rgb(118,118,117)'],
        [0.5254901960784314, 'rgb(119,119,118)'],
        [0.5294117647058824, 'rgb(120,120,119)'],
        [0.5333333333333333, 'rgb(121,121,120)'],
        [0.5372549019607843, 'rgb(122,122,121)'],
        [0.5411764705882353, 'rgb(123,123,122)'],
        [0.5450980392156862, 'rgb(124,124,123)'],
        [0.5490196078431373, 'rgb(125,125,124)'],
        [0.5529411764705883, 'rgb(126,125,125)'],
        [0.5568627450980392, 'rgb(127,126,126)'],
        [0.5607843137254902, 'rgb(128,127,127)'],
        [0.5647058823529412, 'rgb(129,128,128)'],
        [0.5686274509803921, 'rgb(130,129,129)'],
        [0.5725490196078431, 'rgb(131,130,130)'],
        [0.5764705882352941, 'rgb(132,131,131)'],
        [0.5803921568627451, 'rgb(133,132,132)'],
        [0.5843137254901961, 'rgb(134,133,133)'],
        [0.5882352941176471, 'rgb(135,134,134)'],
        [0.592156862745098, 'rgb(136,135,135)'],
        [0.596078431372549, 'rgb(137,136,136)'],
        [0.6, 'rgb(138,137,137)'],
        [0.6039215686274509, 'rgb(139,138,138)'],
        [0.6078431372549019, 'rgb(140,139,139)'],
        [0.611764705882353, 'rgb(141,140,140)'],
        [0.615686274509804, 'rgb(142,141,141)'],
        [0.6196078431372549, 'rgb(143,142,142)'],
        [0.6235294117647059, 'rgb(144,143,143)'],
        [0.6274509803921569, 'rgb(145,144,144)'],
        [0.6313725490196078, 'rgb(146,145,145)'],
        [0.6352941176470588, 'rgb(147,146,146)'],
        [0.6392156862745098, 'rgb(148,147,147)'],
        [0.6431372549019608, 'rgb(149,148,148)'],
        [0.6470588235294118, 'rgb(150,149,149)'],
        [0.6509803921568628, 'rgb(151,150,150)'],
        [0.6549019607843137, 'rgb(152,151,151)'],
        [0.6588235294117647, 'rgb(153,152,152)'],
        [0.6627450980392157, 'rgb(154,153,153)'],
        [0.6666666666666666, 'rgb(155,154,154)'],
        [0.6705882352941176, 'rgb(156,155,155)'],
        [0.6745098039215687, 'rgb(157,157,156)'],
        [0.6784313725490196, 'rgb(158,158,157)'],
        [0.6823529411764706, 'rgb(159,159,158)'],
        [0.6862745098039216, 'rgb(160,160,159)'],
        [0.6901960784313725, 'rgb(161,161,160)'],
        [0.6941176470588235, 'rgb(162,162,161)'],
        [0.6980392156862745, 'rgb(163,163,162)'],
        [0.7019607843137254, 'rgb(164,164,163)'],
        [0.7058823529411765, 'rgb(165,165,164)'],
        [0.7098039215686275, 'rgb(166,166,165)'],
        [0.7137254901960784, 'rgb(167,167,166)'],
        [0.7176470588235294, 'rgb(168,168,167)'],
        [0.7215686274509804, 'rgb(170,169,168)'],
        [0.7254901960784313, 'rgb(171,170,169)'],
        [0.7294117647058823, 'rgb(172,171,170)'],
        [0.7333333333333333, 'rgb(173,172,172)'],
        [0.7372549019607844, 'rgb(174,173,173)'],
        [0.7411764705882353, 'rgb(175,175,174)'],
        [0.7450980392156863, 'rgb(176,176,175)'],
        [0.7490196078431373, 'rgb(177,177,176)'],
        [0.7529411764705882, 'rgb(178,178,177)'],
        [0.7568627450980392, 'rgb(179,179,178)'],
        [0.7607843137254902, 'rgb(180,180,179)'],
        [0.7647058823529411, 'rgb(182,181,180)'],
        [0.7686274509803922, 'rgb(183,182,181)'],
        [0.7725490196078432, 'rgb(184,183,182)'],
        [0.7764705882352941, 'rgb(185,185,184)'],
        [0.7803921568627451, 'rgb(186,186,185)'],
        [0.7843137254901961, 'rgb(187,187,186)'],
        [0.788235294117647, 'rgb(188,188,187)'],
        [0.792156862745098, 'rgb(189,189,188)'],
        [0.796078431372549, 'rgb(190,190,189)'],
        [0.8, 'rgb(192,191,190)'],
        [0.803921568627451, 'rgb(193,192,191)'],
        [0.807843137254902, 'rgb(194,194,193)'],
        [0.8117647058823529, 'rgb(195,195,194)'],
        [0.8156862745098039, 'rgb(196,196,195)'],
        [0.8196078431372549, 'rgb(197,197,196)'],
        [0.8235294117647058, 'rgb(198,198,197)'],
        [0.8274509803921568, 'rgb(200,199,198)'],
        [0.8313725490196079, 'rgb(201,200,199)'],
        [0.8352941176470589, 'rgb(202,202,201)'],
        [0.8392156862745098, 'rgb(203,203,202)'],
        [0.8431372549019608, 'rgb(204,204,203)'],
        [0.8470588235294118, 'rgb(205,205,204)'],
        [0.8509803921568627, 'rgb(207,206,205)'],
        [0.8549019607843137, 'rgb(208,208,206)'],
        [0.8588235294117647, 'rgb(209,209,208)'],
        [0.8627450980392157, 'rgb(210,210,209)'],
        [0.8666666666666667, 'rgb(211,211,210)'],
        [0.8705882352941177, 'rgb(213,212,211)'],
        [0.8745098039215686, 'rgb(214,214,212)'],
        [0.8784313725490196, 'rgb(215,215,214)'],
        [0.8823529411764706, 'rgb(216,216,215)'],
        [0.8862745098039215, 'rgb(217,217,216)'],
        [0.8901960784313725, 'rgb(219,218,217)'],
        [0.8941176470588236, 'rgb(220,220,219)'],
        [0.8980392156862745, 'rgb(221,221,220)'],
        [0.9019607843137255, 'rgb(222,222,221)'],
        [0.9058823529411765, 'rgb(224,223,222)'],
        [0.9098039215686274, 'rgb(225,225,223)'],
        [0.9137254901960784, 'rgb(226,226,225)'],
        [0.9176470588235294, 'rgb(227,227,226)'],
        [0.9215686274509803, 'rgb(229,228,227)'],
        [0.9254901960784314, 'rgb(230,230,228)'],
        [0.9294117647058824, 'rgb(231,231,230)'],
        [0.9333333333333333, 'rgb(232,232,231)'],
        [0.9372549019607843, 'rgb(234,234,232)'],
        [0.9411764705882353, 'rgb(235,235,234)'],
        [0.9450980392156862, 'rgb(236,236,235)'],
        [0.9490196078431372, 'rgb(238,237,236)'],
        [0.9529411764705882, 'rgb(239,239,237)'],
        [0.9568627450980393, 'rgb(240,240,239)'],
        [0.9607843137254902, 'rgb(242,241,240)'],
        [0.9647058823529412, 'rgb(243,243,241)'],
        [0.9686274509803922, 'rgb(244,244,243)'],
        [0.9725490196078431, 'rgb(245,245,244)'],
        [0.9764705882352941, 'rgb(247,247,245)'],
        [0.9803921568627451, 'rgb(248,248,247)'],
        [0.984313725490196, 'rgb(249,249,248)'],
        [0.9882352941176471, 'rgb(251,251,249)'],
        [0.9921568627450981, 'rgb(252,252,251)'],
        [0.996078431372549, 'rgb(254,253,252)'],
        [1.0, 'rgb(255,255,253)'],
    ],
    'cmo.haline': [
        [0.0, 'rgb(42,24,108)'],
        [0.00392156862745098, 'rgb(42,25,110)'],
        [0.00784313725490196, 'rgb(42,25,113)'],
        [0.011764705882352941, 'rgb(43,25,115)'],
        [0.01568627450980392, 'rgb(43,25,117)'],
        [0.0196078431372549, 'rgb(44,26,120)'],
        [0.023529411764705882, 'rgb(44,26,122)'],
        [0.027450980392156862, 'rgb(45,26,125)'],
        [0.03137254901960784, 'rgb(45,26,127)'],
        [0.03529411764705882, 'rgb(45,27,130)'],
        [0.0392156862745098, 'rgb(46,27,132)'],
        [0.043137254901960784, 'rgb(46,27,135)'],
        [0.047058823529411764, 'rgb(46,28,137)'],
        [0.050980392156862744, 'rgb(46,28,140)'],
        [0.054901960784313725, 'rgb(46,28,142)'],
        [0.058823529411764705, 'rgb(46,29,145)'],
        [0.06274509803921569, 'rgb(46,29,147)'],
        [0.06666666666666667, 'rgb(46,30,149)'],
        [0.07058823529411765, 'rgb(46,30,152)'],
        [0.07450980392156863, 'rgb(46,31,154)'],
        [0.0784313725490196, 'rgb(45,32,156)'],
        [0.08235294117647059, 'rgb(45,33,157)'],
        [0.08627450980392157, 'rgb(44,34,159)'],
        [0.09019607843137255, 'rgb(43,36,160)'],
        [0.09411764705882353, 'rgb(42,37,161)'],
        [0.09803921568627451, 'rgb(41,39,162)'],
        [0.10196078431372549, 'rgb(40,41,163)'],
        [0.10588235294117647, 'rgb(38,43,163)'],
        [0.10980392156862745, 'rgb(37,45,163)'],
        [0.11372549019607843, 'rgb(36,46,163)'],
        [0.11764705882352941, 'rgb(34,48,163)'],
        [0.12156862745098039, 'rgb(33,50,162)'],
        [0.12549019607843137, 'rgb(32,52,162)'],
        [0.12941176470588237, 'rgb(30,53,161)'],
        [0.13333333333333333, 'rgb(29,55,161)'],
        [0.13725490196078433, 'rgb(28,57,160)'],
        [0.1411764705882353, 'rgb(27,58,160)'],
        [0.1450980392156863, 'rgb(25,60,159)'],
        [0.14901960784313725, 'rgb(24,61,158)'],
        [0.15294117647058825, 'rgb(23,63,158)'],
        [0.1568627450980392, 'rgb(22,64,157)'],
        [0.1607843137254902, 'rgb(21,65,156)'],
        [0.16470588235294117, 'rgb(20,67,156)'],
        [0.16862745098039217, 'rgb(19,68,155)'],
        [0.17254901960784313, 'rgb(18,69,155)'],
        [0.17647058823529413, 'rgb(17,71,154)'],
        [0.1803921568627451, 'rgb(16,72,153)'],
        [0.1843137254901961, 'rgb(15,73,153)'],
        [0.18823529411764706, 'rgb(15,74,152)'],
        [0.19215686274509805, 'rgb(14,76,151)'],
        [0.19607843137254902, 'rgb(13,77,151)'],
        [0.2, 'rgb(13,78,150)'],
        [0.20392156862745098, 'rgb(13,79,150)'],
        [0.20784313725490197, 'rgb(12,80,149)'],
        [0.21176470588235294, 'rgb(12,81,149)'],
        [0.21568627450980393, 'rgb(12,82,148)'],
        [0.2196078431372549, 'rgb(12,83,148)'],
        [0.2235294117647059, 'rgb(12,84,147)'],
        [0.22745098039215686, 'rgb(13,85,147)'],
        [0.23137254901960785, 'rgb(13,86,146)'],
        [0.23529411764705882, 'rgb(13,87,146)'],
        [0.23921568627450981, 'rgb(14,88,145)'],
        [0.24313725490196078, 'rgb(14,89,145)'],
        [0.24705882352941178, 'rgb(15,90,145)'],
        [0.25098039215686274, 'rgb(15,91,144)'],
        [0.2549019607843137, 'rgb(16,92,144)'],
        [0.25882352941176473, 'rgb(17,93,143)'],
        [0.2627450980392157, 'rgb(17,94,143)'],
        [0.26666666666666666, 'rgb(18,95,143)'],
        [0.27058823529411763, 'rgb(19,96,142)'],
        [0.27450980392156865, 'rgb(20,97,142)'],
        [0.2784313725490196, 'rgb(20,98,142)'],
        [0.2823529411764706, 'rgb(21,99,142)'],
        [0.28627450980392155, 'rgb(22,99,141)'],
        [0.2901960784313726, 'rgb(23,100,141)'],
        [0.29411764705882354, 'rgb(24,101,141)'],
        [0.2980392156862745, 'rgb(24,102,140)'],
        [0.30196078431372547, 'rgb(25,103,140)'],
        [0.3058823529411765, 'rgb(26,104,140)'],
        [0.30980392156862746, 'rgb(27,105,140)'],
        [0.3137254901960784, 'rgb(28,106,140)'],
        [0.3176470588235294, 'rgb(29,107,139)'],
        [0.3215686274509804, 'rgb(29,107,139)'],
        [0.3254901960784314, 'rgb(30,108,139)'],
        [0.32941176470588235, 'rgb(31,109,139)'],
        [0.3333333333333333, 'rgb(32,110,139)'],
        [0.33725490196078434, 'rgb(33,111,139)'],
        [0.3411764705882353, 'rgb(34,112,138)'],
        [0.34509803921568627, 'rgb(34,113,138)'],
        [0.34901960784313724, 'rgb(35,113,138)'],
        [0.35294117647058826, 'rgb(36,114,138)'],
        [0.3568627450980392, 'rgb(37,115,138)'],
        [0.3607843137254902, 'rgb(38,116,138)'],
        [0.36470588235294116, 'rgb(38,117,138)'],
        [0.3686274509803922, 'rgb(39,118,138)'],
        [0.37254901960784315, 'rgb(40,118,137)'],
        [0.3764705882352941, 'rgb(41,119,137)'],
        [0.3803921568627451, 'rgb(41,120,137)'],
        [0.3843137254901961, 'rgb(42,121,137)'],
        [0.38823529411764707, 'rgb(43,122,137)'],
        [0.39215686274509803, 'rgb(43,123,137)'],
        [0.396078431372549, 'rgb(44,124,137)'],
        [0.4, 'rgb(45,124,137)'],
        [0.403921568627451, 'rgb(45,125,137)'],
        [0.40784313725490196, 'rgb(46,126,137)'],
        [0.4117647058823529, 'rgb(47,127,137)'],
        [0.41568627450980394, 'rgb(47,128,137)'],
        [0.4196078431372549, 'rgb(48,129,137)'],
        [0.4235294117647059, 'rgb(49,130,137)'],
        [0.42745098039215684, 'rgb(49,130,136)'],
        [0.43137254901960786, 'rgb(50,131,136)'],
        [0.43529411764705883, 'rgb(51,132,136)'],
        [0.4392156862745098, 'rgb(51,133,136)'],
        [0.44313725490196076, 'rgb(52,134,136)'],
        [0.4470588235294118, 'rgb(52,135,136)'],
        [0.45098039215686275, 'rgb(53,136,136)'],
        [0.4549019607843137, 'rgb(53,137,136)'],
        [0.4588235294117647, 'rgb(54,137,136)'],
        [0.4627450980392157, 'rgb(55,138,136)'],
        [0.4666666666666667, 'rgb(55,139,136)'],
        [0.47058823529411764, 'rgb(56,140,136)'],
        [0.4745098039215686, 'rgb(56,141,136)'],
        [0.47843137254901963, 'rgb(57,142,136)'],
        [0.4823529411764706, 'rgb(57,143,136)'],
        [0.48627450980392156, 'rgb(58,144,135)'],
        [0.49019607843137253, 'rgb(58,144,135)'],
        [0.49411764705882355, 'rgb(59,145,135)'],
        [0.4980392156862745, 'rgb(59,146,135)'],
        [0.5019607843137255, 'rgb(60,147,135)'],
        [0.5058823529411764, 'rgb(60,148,135)'],
        [0.5098039215686274, 'rgb(61,149,135)'],
        [0.5137254901960784, 'rgb(61,150,135)'],
        [0.5176470588235295, 'rgb(62,151,135)'],
        [0.5215686274509804, 'rgb(62,152,134)'],
        [0.5254901960784314, 'rgb(63,153,134)'],
        [0.5294117647058824, 'rgb(63,153,134)'],
        [0.5333333333333333, 'rgb(64,154,134)'],
        [0.5372549019607843, 'rgb(65,155,134)'],
        [0.5411764705882353, 'rgb(65,156,133)'],
        [0.5450980392156862, 'rgb(66,157,133)'],
        [0.5490196078431373, 'rgb(66,158,133)'],
        [0.5529411764705883, 'rgb(67,159,133)'],
        [0.5568627450980392, 'rgb(67,160,132)'],
        [0.5607843137254902, 'rgb(68,161,132)'],
        [0.5647058823529412, 'rgb(68,162,132)'],
        [0.5686274509803921, 'rgb(69,163,132)'],
        [0.5725490196078431, 'rgb(70,164,131)'],
        [0.5764705882352941, 'rgb(70,164,131)'],
        [0.5803921568627451, 'rgb(71,165,131)'],
        [0.5843137254901961, 'rgb(72,166,130)'],
        [0.5882352941176471, 'rgb(72,167,130)'],
        [0.592156862745098, 'rgb(73,168,130)'],
        [0.596078431372549, 'rgb(74,169,129)'],
        [0.6, 'rgb(74,170,129)'],
        [0.6039215686274509, 'rgb(75,171,129)'],
        [0.6078431372549019, 'rgb(76,172,128)'],
        [0.611764705882353, 'rgb(76,173,128)'],
        [0.615686274509804, 'rgb(77,174,127)'],
        [0.6196078431372549, 'rgb(78,174,127)'],
        [0.6235294117647059, 'rgb(79,175,126)'],
        [0.6274509803921569, 'rgb(80,176,126)'],
        [0.6313725490196078, 'rgb(81,177,125)'],
        [0.6352941176470588, 'rgb(81,178,125)'],
        [0.6392156862745098, 'rgb(82,179,124)'],
        [0.6431372549019608, 'rgb(83,180,124)'],
        [0.6470588235294118, 'rgb(84,181,123)'],
        [0.6509803921568628, 'rgb(85,182,123)'],
        [0.6549019607843137, 'rgb(86,183,122)'],
        [0.6588235294117647, 'rgb(87,184,121)'],
        [0.6627450980392157, 'rgb(88,184,121)'],
        [0.6666666666666666, 'rgb(90,185,120)'],
        [0.6705882352941176, 'rgb(91,186,119)'],
        [0.6745098039215687, 'rgb(92,187,119)'],
        [0.6784313725490196, 'rgb(93,188,118)'],
        [0.6823529411764706, 'rgb(94,189,117)'],
        [0.6862745098039216, 'rgb(95,190,117)'],
        [0.6901960784313725, 'rgb(97,191,116)'],
        [0.6941176470588235, 'rgb(98,191,115)'],
        [0.6980392156862745, 'rgb(99,192,114)'],
        [0.7019607843137254, 'rgb(101,193,114)'],
        [0.7058823529411765, 'rgb(102,194,113)'],
        [0.7098039215686275, 'rgb(104,195,112)'],
        [0.7137254901960784, 'rgb(105,196,111)'],
        [0.7176470588235294, 'rgb(107,196,110)'],
        [0.7215686274509804, 'rgb(108,197,110)'],
        [0.7254901960784313, 'rgb(110,198,109)'],
        [0.7294117647058823, 'rgb(112,199,108)'],
        [0.7333333333333333, 'rgb(113,200,107)'],
        [0.7372549019607844, 'rgb(115,200,106)'],
        [0.7411764705882353, 'rgb(117,201,105)'],
        [0.7450980392156863, 'rgb(119,202,104)'],
        [0.7490196078431373, 'rgb(120,203,104)'],
        [0.7529411764705882, 'rgb(122,203,103)'],
        [0.7568627450980392, 'rgb(124,204,102)'],
        [0.7607843137254902, 'rgb(126,205,101)'],
        [0.7647058823529411, 'rgb(128,206,100)'],
        [0.7686274509803922, 'rgb(130,206,99)'],
        [0.7725490196078432, 'rgb(132,207,98)'],
        [0.7764705882352941, 'rgb(134,208,98)'],
        [0.7803921568627451, 'rgb(137,208,97)'],
        [0.7843137254901961, 'rgb(139,209,96)'],
        [0.788235294117647, 'rgb(141,210,95)'],
        [0.792156862745098, 'rgb(143,210,95)'],
        [0.796078431372549, 'rgb(146,211,94)'],
        [0.8, 'rgb(148,211,93)'],
        [0.803921568627451, 'rgb(151,212,93)'],
        [0.807843137254902, 'rgb(153,212,93)'],
        [0.8117647058823529, 'rgb(155,213,92)'],
        [0.8156862745098039, 'rgb(158,214,92)'],
        [0.8196078431372549, 'rgb(160,214,92)'],
        [0.8235294117647058, 'rgb(163,215,92)'],
        [0.8274509803921568, 'rgb(165,215,92)'],
        [0.8313725490196079, 'rgb(168,216,92)'],
        [0.8352941176470589, 'rgb(170,216,92)'],
        [0.8392156862745098, 'rgb(173,216,92)'],
        [0.8431372549019608, 'rgb(175,217,93)'],
        [0.8470588235294118, 'rgb(177,217,93)'],
        [0.8509803921568627, 'rgb(180,218,94)'],
        [0.8549019607843137, 'rgb(182,218,95)'],
        [0.8588235294117647, 'rgb(184,219,96)'],
        [0.8627450980392157, 'rgb(187,219,97)'],
        [0.8666666666666667, 'rgb(189,220,98)'],
        [0.8705882352941177, 'rgb(191,220,99)'],
        [0.8745098039215686, 'rgb(193,221,100)'],
        [0.8784313725490196, 'rgb(196,221,101)'],
        [0.8823529411764706, 'rgb(198,222,102)'],
        [0.8862745098039215, 'rgb(200,222,103)'],
        [0.8901960784313725, 'rgb(202,223,105)'],
        [0.8941176470588236, 'rgb(204,223,106)'],
        [0.8980392156862745, 'rgb(206,224,108)'],
        [0.9019607843137255, 'rgb(208,224,109)'],
        [0.9058823529411765, 'rgb(210,225,111)'],
        [0.9098039215686274, 'rgb(212,225,112)'],
        [0.9137254901960784, 'rgb(214,226,114)'],
        [0.9176470588235294, 'rgb(216,226,115)'],
        [0.9215686274509803, 'rgb(218,227,117)'],
        [0.9254901960784314, 'rgb(220,227,119)'],
        [0.9294117647058824, 'rgb(222,228,121)'],
        [0.9333333333333333, 'rgb(224,229,122)'],
        [0.9372549019607843, 'rgb(225,229,124)'],
        [0.9411764705882353, 'rgb(227,230,126)'],
        [0.9450980392156862, 'rgb(229,230,128)'],
        [0.9490196078431372, 'rgb(231,231,129)'],
        [0.9529411764705882, 'rgb(233,231,131)'],
        [0.9568627450980393, 'rgb(235,232,133)'],
        [0.9607843137254902, 'rgb(236,233,135)'],
        [0.9647058823529412, 'rgb(238,233,137)'],
        [0.9686274509803922, 'rgb(240,234,138)'],
        [0.9725490196078431, 'rgb(242,234,140)'],
        [0.9764705882352941, 'rgb(243,235,142)'],
        [0.9803921568627451, 'rgb(245,236,144)'],
        [0.984313725490196, 'rgb(247,236,146)'],
        [0.9882352941176471, 'rgb(248,237,148)'],
        [0.9921568627450981, 'rgb(250,238,150)'],
        [0.996078431372549, 'rgb(252,238,152)'],
        [1.0, 'rgb(253,239,154)'],
    ],
    'cmo.ice': [
        [0.0, 'rgb(4,6,19)'],
        [0.00392156862745098, 'rgb(5,6,20)'],
        [0.00784313725490196, 'rgb(5,7,21)'],
        [0.011764705882352941, 'rgb(6,8,23)'],
        [0.01568627450980392, 'rgb(7,9,24)'],
        [0.0196078431372549, 'rgb(8,10,26)'],
        [0.023529411764705882, 'rgb(9,11,27)'],
        [0.027450980392156862, 'rgb(10,12,29)'],
        [0.03137254901960784, 'rgb(11,13,30)'],
        [0.03529411764705882, 'rgb(12,13,31)'],
        [0.0392156862745098, 'rgb(13,14,33)'],
        [0.043137254901960784, 'rgb(14,15,34)'],
        [0.047058823529411764, 'rgb(15,16,36)'],
        [0.050980392156862744, 'rgb(16,17,37)'],
        [0.054901960784313725, 'rgb(17,18,39)'],
        [0.058823529411764705, 'rgb(18,19,40)'],
        [0.06274509803921569, 'rgb(19,19,42)'],
        [0.06666666666666667, 'rgb(20,20,43)'],
        [0.07058823529411765, 'rgb(21,21,44)'],
        [0.07450980392156863, 'rgb(22,22,46)'],
        [0.0784313725490196, 'rgb(23,23,47)'],
        [0.08235294117647059, 'rgb(23,24,49)'],
        [0.08627450980392157, 'rgb(24,24,50)'],
        [0.09019607843137255, 'rgb(25,25,52)'],
        [0.09411764705882353, 'rgb(26,26,53)'],
        [0.09803921568627451, 'rgb(27,27,55)'],
        [0.10196078431372549, 'rgb(28,28,56)'],
        [0.10588235294117647, 'rgb(29,28,58)'],
        [0.10980392156862745, 'rgb(30,29,59)'],
        [0.11372549019607843, 'rgb(31,30,61)'],
        [0.11764705882352941, 'rgb(31,31,62)'],
        [0.12156862745098039, 'rgb(32,31,64)'],
        [0.12549019607843137, 'rgb(33,32,65)'],
        [0.12941176470588237, 'rgb(34,33,67)'],
        [0.13333333333333333, 'rgb(35,34,68)'],
        [0.13725490196078433, 'rgb(36,34,70)'],
        [0.1411764705882353, 'rgb(37,35,71)'],
        [0.1450980392156863, 'rgb(37,36,73)'],
        [0.14901960784313725, 'rgb(38,37,74)'],
        [0.15294117647058825, 'rgb(39,37,76)'],
        [0.1568627450980392, 'rgb(40,38,78)'],
        [0.1607843137254902, 'rgb(41,39,79)'],
        [0.16470588235294117, 'rgb(41,40,81)'],
        [0.16862745098039217, 'rgb(42,40,82)'],
        [0.17254901960784313, 'rgb(43,41,84)'],
        [0.17647058823529413, 'rgb(44,42,85)'],
        [0.1803921568627451, 'rgb(44,43,87)'],
        [0.1843137254901961, 'rgb(45,43,89)'],
        [0.18823529411764706, 'rgb(46,44,90)'],
        [0.19215686274509805, 'rgb(47,45,92)'],
        [0.19607843137254902, 'rgb(47,46,94)'],
        [0.2, 'rgb(48,47,95)'],
        [0.20392156862745098, 'rgb(49,47,97)'],
        [0.20784313725490197, 'rgb(49,48,98)'],
        [0.21176470588235294, 'rgb(50,49,100)'],
        [0.21568627450980393, 'rgb(51,50,102)'],
        [0.2196078431372549, 'rgb(51,50,103)'],
        [0.2235294117647059, 'rgb(52,51,105)'],
        [0.22745098039215686, 'rgb(53,52,107)'],
        [0.23137254901960785, 'rgb(53,53,108)'],
        [0.23529411764705882, 'rgb(54,53,110)'],
        [0.23921568627450981, 'rgb(54,54,112)'],
        [0.24313725490196078, 'rgb(55,55,113)'],
        [0.24705882352941178, 'rgb(56,56,115)'],
        [0.25098039215686274, 'rgb(56,57,117)'],
        [0.2549019607843137, 'rgb(57,57,118)'],
        [0.25882352941176473, 'rgb(57,58,120)'],
        [0.2627450980392157, 'rgb(58,59,122)'],
        [0.26666666666666666, 'rgb(58,60,123)'],
        [0.27058823529411763, 'rgb(58,61,125)'],
        [0.27450980392156865, 'rgb(59,62,127)'],
        [0.2784313725490196, 'rgb(59,62,128)'],
        [0.2823529411764706, 'rgb(60,63,130)'],
        [0.28627450980392155, 'rgb(60,64,132)'],
        [0.2901960784313726, 'rgb(60,65,133)'],
        [0.29411764705882354, 'rgb(61,66,135)'],
        [0.2980392156862745, 'rgb(61,67,137)'],
        [0.30196078431372547, 'rgb(61,68,138)'],
        [0.3058823529411765, 'rgb(62,69,140)'],
        [0.30980392156862746, 'rgb(62,70,141)'],
        [0.3137254901960784, 'rgb(62,71,143)'],
        [0.3176470588235294, 'rgb(62,72,144)'],
        [0.3215686274509804, 'rgb(62,73,146)'],
        [0.3254901960784314, 'rgb(62,73,147)'],
        [0.32941176470588235, 'rgb(63,74,149)'],
        [0.3333333333333333, 'rgb(63,75,150)'],
        [0.33725490196078434, 'rgb(63,76,151)'],
        [0.3411764705882353, 'rgb(63,78,153)'],
        [0.34509803921568627, 'rgb(63,79,154)'],
        [0.34901960784313724, 'rgb(63,80,155)'],
        [0.35294117647058826, 'rgb(63,81,157)'],
        [0.3568627450980392, 'rgb(63,82,158)'],
        [0.3607843137254902, 'rgb(63,83,159)'],
        [0.36470588235294116, 'rgb(63,84,160)'],
        [0.3686274509803922, 'rgb(63,85,161)'],
        [0.37254901960784315, 'rgb(63,86,162)'],
        [0.3764705882352941, 'rgb(63,87,163)'],
        [0.3803921568627451, 'rgb(63,88,164)'],
        [0.3843137254901961, 'rgb(63,89,165)'],
        [0.38823529411764707, 'rgb(62,90,166)'],
        [0.39215686274509803, 'rgb(62,92,167)'],
        [0.396078431372549, 'rgb(62,93,168)'],
        [0.4, 'rgb(62,94,169)'],
        [0.403921568627451, 'rgb(62,95,170)'],
        [0.40784313725490196, 'rgb(62,96,171)'],
        [0.4117647058823529, 'rgb(62,97,171)'],
        [0.41568627450980394, 'rgb(62,98,172)'],
        [0.4196078431372549, 'rgb(62,99,173)'],
        [0.4235294117647059, 'rgb(62,101,173)'],
        [0.42745098039215684, 'rgb(62,102,174)'],
        [0.43137254901960786, 'rgb(62,103,175)'],
        [0.43529411764705883, 'rgb(62,104,175)'],
        [0.4392156862745098, 'rgb(62,105,176)'],
        [0.44313725490196076, 'rgb(62,106,176)'],
        [0.4470588235294118, 'rgb(63,107,177)'],
        [0.45098039215686275, 'rgb(63,108,178)'],
        [0.4549019607843137, 'rgb(63,110,178)'],
        [0.4588235294117647, 'rgb(63,111,179)'],
        [0.4627450980392157, 'rgb(63,112,179)'],
        [0.4666666666666667, 'rgb(63,113,180)'],
        [0.47058823529411764, 'rgb(64,114,180)'],
        [0.4745098039215686, 'rgb(64,115,180)'],
        [0.47843137254901963, 'rgb(64,116,181)'],
        [0.4823529411764706, 'rgb(64,117,181)'],
        [0.48627450980392156, 'rgb(65,118,182)'],
        [0.49019607843137253, 'rgb(65,120,182)'],
        [0.49411764705882355, 'rgb(66,121,183)'],
        [0.4980392156862745, 'rgb(66,122,183)'],
        [0.5019607843137255, 'rgb(66,123,183)'],
        [0.5058823529411764, 'rgb(67,124,184)'],
        [0.5098039215686274, 'rgb(67,125,184)'],
        [0.5137254901960784, 'rgb(68,126,185)'],
        [0.5176470588235295, 'rgb(68,127,185)'],
        [0.5215686274509804, 'rgb(69,128,185)'],
        [0.5254901960784314, 'rgb(69,129,186)'],
        [0.5294117647058824, 'rgb(70,130,186)'],
        [0.5333333333333333, 'rgb(70,132,187)'],
        [0.5372549019607843, 'rgb(71,133,187)'],
        [0.5411764705882353, 'rgb(71,134,187)'],
        [0.5450980392156862, 'rgb(72,135,188)'],
        [0.5490196078431373, 'rgb(73,136,188)'],
        [0.5529411764705883, 'rgb(73,137,188)'],
        [0.5568627450980392, 'rgb(74,138,189)'],
        [0.5607843137254902, 'rgb(75,139,189)'],
        [0.5647058823529412, 'rgb(75,140,189)'],
        [0.5686274509803921, 'rgb(76,141,190)'],
        [0.5725490196078431, 'rgb(77,142,190)'],
        [0.5764705882352941, 'rgb(78,143,191)'],
        [0.5803921568627451, 'rgb(78,144,191)'],
        [0.5843137254901961, 'rgb(79,145,191)'],
        [0.5882352941176471, 'rgb(80,146,192)'],
        [0.592156862745098, 'rgb(81,148,192)'],
        [0.596078431372549, 'rgb(81,149,192)'],
        [0.6, 'rgb(82,150,193)'],
        [0.6039215686274509, 'rgb(83,151,193)'],
        [0.6078431372549019, 'rgb(84,152,194)'],
        [0.611764705882353, 'rgb(85,153,194)'],
        [0.615686274509804, 'rgb(85,154,194)'],
        [0.6196078431372549, 'rgb(86,155,195)'],
        [0.6235294117647059, 'rgb(87,156,195)'],
        [0.6274509803921569, 'rgb(88,157,195)'],
        [0.6313725490196078, 'rgb(89,158,196)'],
        [0.6352941176470588, 'rgb(90,159,196)'],
        [0.6392156862745098, 'rgb(91,160,197)'],
        [0.6431372549019608, 'rgb(92,161,197)'],
        [0.6470588235294118, 'rgb(93,162,197)'],
        [0.6509803921568628, 'rgb(94,163,198)'],
        [0.6549019607843137, 'rgb(95,164,198)'],
        [0.6588235294117647, 'rgb(95,166,199)'],
        [0.6627450980392157, 'rgb(96,167,199)'],
        [0.6666666666666666, 'rgb(97,168,199)'],
        [0.6705882352941176, 'rgb(98,169,200)'],
        [0.6745098039215687, 'rgb(99,170,200)'],
        [0.6784313725490196, 'rgb(100,171,201)'],
        [0.6823529411764706, 'rgb(101,172,201)'],
        [0.6862745098039216, 'rgb(103,173,201)'],
        [0.6901960784313725, 'rgb(104,174,202)'],
        [0.6941176470588235, 'rgb(105,175,202)'],
        [0.6980392156862745, 'rgb(106,176,203)'],
        [0.7019607843137254, 'rgb(107,177,203)'],
        [0.7058823529411765, 'rgb(108,178,203)'],
        [0.7098039215686275, 'rgb(109,179,204)'],
        [0.7137254901960784, 'rgb(110,180,204)'],
        [0.7176470588235294, 'rgb(111,181,205)'],
        [0.7215686274509804, 'rgb(113,182,205)'],
        [0.7254901960784313, 'rgb(114,184,206)'],
        [0.7294117647058823, 'rgb(115,185,206)'],
        [0.7333333333333333, 'rgb(116,186,206)'],
        [0.7372549019607844, 'rgb(117,187,207)'],
        [0.7411764705882353, 'rgb(119,188,207)'],
        [0.7450980392156863, 'rgb(120,189,208)'],
        [0.7490196078431373, 'rgb(121,190,208)'],
        [0.7529411764705882, 'rgb(123,191,208)'],
        [0.7568627450980392, 'rgb(124,192,209)'],
        [0.7607843137254902, 'rgb(125,193,209)'],
        [0.7647058823529411, 'rgb(127,194,210)'],
        [0.7686274509803922, 'rgb(128,195,210)'],
        [0.7725490196078432, 'rgb(130,196,211)'],
        [0.7764705882352941, 'rgb(131,197,211)'],
        [0.7803921568627451, 'rgb(133,198,211)'],
        [0.7843137254901961, 'rgb(134,199,212)'],
        [0.788235294117647, 'rgb(136,200,212)'],
        [0.792156862745098, 'rgb(137,201,213)'],
        [0.796078431372549, 'rgb(139,202,213)'],
        [0.8, 'rgb(140,203,214)'],
        [0.803921568627451, 'rgb(142,204,214)'],
        [0.807843137254902, 'rgb(144,205,215)'],
        [0.8117647058823529, 'rgb(146,206,215)'],
        [0.8156862745098039, 'rgb(147,207,216)'],
        [0.8196078431372549, 'rgb(149,208,216)'],
        [0.8235294117647058, 'rgb(151,209,217)'],
        [0.8274509803921568, 'rgb(153,210,217)'],
        [0.8313725490196079, 'rgb(154,211,218)'],
        [0.8352941176470589, 'rgb(156,212,218)'],
        [0.8392156862745098, 'rgb(158,213,219)'],
        [0.8431372549019608, 'rgb(160,214,220)'],
        [0.8470588235294118, 'rgb(162,214,220)'],
        [0.8509803921568627, 'rgb(164,215,221)'],
        [0.8549019607843137, 'rgb(166,216,222)'],
        [0.8588235294117647, 'rgb(168,217,222)'],
        [0.8627450980392157, 'rgb(169,218,223)'],
        [0.8666666666666667, 'rgb(171,219,224)'],
        [0.8705882352941177, 'rgb(173,220,224)'],
        [0.8745098039215686, 'rgb(175,221,225)'],
        [0.8784313725490196, 'rgb(177,222,226)'],
        [0.8823529411764706, 'rgb(179,223,227)'],
        [0.8862745098039215, 'rgb(181,224,227)'],
        [0.8901960784313725, 'rgb(183,225,228)'],
        [0.8941176470588236, 'rgb(185,226,229)'],
        [0.8980392156862745, 'rgb(186,227,230)'],
        [0.9019607843137255, 'rgb(188,228,231)'],
        [0.9058823529411765, 'rgb(190,229,231)'],
        [0.9098039215686274, 'rgb(192,230,232)'],
        [0.9137254901960784, 'rgb(194,230,233)'],
        [0.9176470588235294, 'rgb(196,231,234)'],
        [0.9215686274509803, 'rgb(198,232,235)'],
        [0.9254901960784314, 'rgb(200,233,236)'],
        [0.9294117647058824, 'rgb(201,234,237)'],
        [0.9333333333333333, 'rgb(203,235,238)'],
        [0.9372549019607843, 'rgb(205,236,239)'],
        [0.9411764705882353, 'rgb(207,237,239)'],
        [0.9450980392156862, 'rgb(209,238,240)'],
        [0.9490196078431372, 'rgb(211,239,241)'],
        [0.9529411764705882, 'rgb(213,240,242)'],
        [0.9568627450980393, 'rgb(214,241,243)'],
        [0.9607843137254902, 'rgb(216,242,244)'],
        [0.9647058823529412, 'rgb(218,243,245)'],
        [0.9686274509803922, 'rgb(220,244,246)'],
        [0.9725490196078431, 'rgb(222,245,247)'],
        [0.9764705882352941, 'rgb(224,246,248)'],
        [0.9803921568627451, 'rgb(225,247,249)'],
        [0.984313725490196, 'rgb(227,249,250)'],
        [0.9882352941176471, 'rgb(229,250,251)'],
        [0.9921568627450981, 'rgb(231,251,251)'],
        [0.996078431372549, 'rgb(232,252,252)'],
        [1.0, 'rgb(234,253,253)'],
    ],
    'cmo.matter': [
        [0.0, 'rgb(254,237,176)'],
        [0.00392156862745098, 'rgb(253,236,175)'],
        [0.00784313725490196, 'rgb(253,234,173)'],
        [0.011764705882352941, 'rgb(253,233,172)'],
        [0.01568627450980392, 'rgb(253,232,171)'],
        [0.0196078431372549, 'rgb(253,230,169)'],
        [0.023529411764705882, 'rgb(253,229,168)'],
        [0.027450980392156862, 'rgb(253,227,167)'],
        [0.03137254901960784, 'rgb(253,226,165)'],
        [0.03529411764705882, 'rgb(252,225,164)'],
        [0.0392156862745098, 'rgb(252,223,163)'],
        [0.043137254901960784, 'rgb(252,222,161)'],
        [0.047058823529411764, 'rgb(252,220,160)'],
        [0.050980392156862744, 'rgb(252,219,159)'],
        [0.054901960784313725, 'rgb(252,218,157)'],
        [0.058823529411764705, 'rgb(252,216,156)'],
        [0.06274509803921569, 'rgb(251,215,155)'],
        [0.06666666666666667, 'rgb(251,213,154)'],
        [0.07058823529411765, 'rgb(251,212,152)'],
        [0.07450980392156863, 'rgb(251,211,151)'],
        [0.0784313725490196, 'rgb(251,209,150)'],
        [0.08235294117647059, 'rgb(251,208,148)'],
        [0.08627450980392157, 'rgb(251,207,147)'],
        [0.09019607843137255, 'rgb(250,205,146)'],
        [0.09411764705882353, 'rgb(250,204,145)'],
        [0.09803921568627451, 'rgb(250,202,144)'],
        [0.10196078431372549, 'rgb(250,201,142)'],
        [0.10588235294117647, 'rgb(250,200,141)'],
        [0.10980392156862745, 'rgb(250,198,140)'],
        [0.11372549019607843, 'rgb(250,197,139)'],
        [0.11764705882352941, 'rgb(249,195,138)'],
        [0.12156862745098039, 'rgb(249,194,136)'],
        [0.12549019607843137, 'rgb(249,193,135)'],
        [0.12941176470588237, 'rgb(249,191,134)'],
        [0.13333333333333333, 'rgb(249,190,133)'],
        [0.13725490196078433, 'rgb(249,189,132)'],
        [0.1411764705882353, 'rgb(248,187,131)'],
        [0.1450980392156863, 'rgb(248,186,130)'],
        [0.14901960784313725, 'rgb(248,184,128)'],
        [0.15294117647058825, 'rgb(248,183,127)'],
        [0.1568627450980392, 'rgb(248,182,126)'],
        [0.1607843137254902, 'rgb(247,180,125)'],
        [0.16470588235294117, 'rgb(247,179,124)'],
        [0.16862745098039217, 'rgb(247,178,123)'],
        [0.17254901960784313, 'rgb(247,176,122)'],
        [0.17647058823529413, 'rgb(247,175,121)'],
        [0.1803921568627451, 'rgb(246,174,120)'],
        [0.1843137254901961, 'rgb(246,172,119)'],
        [0.18823529411764706, 'rgb(246,171,118)'],
        [0.19215686274509805, 'rgb(246,169,117)'],
        [0.19607843137254902, 'rgb(245,168,116)'],
        [0.2, 'rgb(245,167,115)'],
        [0.20392156862745098, 'rgb(245,165,114)'],
        [0.20784313725490197, 'rgb(245,164,113)'],
        [0.21176470588235294, 'rgb(245,163,112)'],
        [0.21568627450980393, 'rgb(244,161,111)'],
        [0.2196078431372549, 'rgb(244,160,110)'],
        [0.2235294117647059, 'rgb(244,159,109)'],
        [0.22745098039215686, 'rgb(244,157,108)'],
        [0.23137254901960785, 'rgb(243,156,107)'],
        [0.23529411764705882, 'rgb(243,154,106)'],
        [0.23921568627450981, 'rgb(243,153,105)'],
        [0.24313725490196078, 'rgb(242,152,104)'],
        [0.24705882352941178, 'rgb(242,150,104)'],
        [0.25098039215686274, 'rgb(242,149,103)'],
        [0.2549019607843137, 'rgb(242,148,102)'],
        [0.25882352941176473, 'rgb(241,146,101)'],
        [0.2627450980392157, 'rgb(241,145,100)'],
        [0.26666666666666666, 'rgb(241,143,99)'],
        [0.27058823529411763, 'rgb(240,142,99)'],
        [0.27450980392156865, 'rgb(240,141,98)'],
        [0.2784313725490196, 'rgb(240,139,97)'],
        [0.2823529411764706, 'rgb(239,138,96)'],
        [0.28627450980392155, 'rgb(239,137,96)'],
        [0.2901960784313726, 'rgb(239,135,95)'],
        [0.29411764705882354, 'rgb(238,134,94)'],
        [0.2980392156862745, 'rgb(238,133,94)'],
        [0.30196078431372547, 'rgb(238,131,93)'],
        [0.3058823529411765, 'rgb(237,130,92)'],
        [0.30980392156862746, 'rgb(237,129,92)'],
        [0.3137254901960784, 'rgb(237,127,91)'],
        [0.3176470588235294, 'rgb(236,126,90)'],
        [0.3215686274509804, 'rgb(236,124,90)'],
        [0.3254901960784314, 'rgb(236,123,89)'],
        [0.32941176470588235, 'rgb(235,122,89)'],
        [0.3333333333333333, 'rgb(235,120,88)'],
        [0.33725490196078434, 'rgb(234,119,88)'],
        [0.3411764705882353, 'rgb(234,118,87)'],
        [0.34509803921568627, 'rgb(233,116,87)'],
        [0.34901960784313724, 'rgb(233,115,86)'],
        [0.35294117647058826, 'rgb(233,114,86)'],
        [0.3568627450980392, 'rgb(232,112,86)'],
        [0.3607843137254902, 'rgb(232,111,85)'],
        [0.36470588235294116, 'rgb(231,110,85)'],
        [0.3686274509803922, 'rgb(231,108,85)'],
        [0.37254901960784315, 'rgb(230,107,84)'],
        [0.3764705882352941, 'rgb(230,106,84)'],
        [0.3803921568627451, 'rgb(229,104,84)'],
        [0.3843137254901961, 'rgb(229,103,84)'],
        [0.38823529411764707, 'rgb(228,102,83)'],
        [0.39215686274509803, 'rgb(227,100,83)'],
        [0.396078431372549, 'rgb(227,99,83)'],
        [0.4, 'rgb(226,98,83)'],
        [0.403921568627451, 'rgb(226,96,83)'],
        [0.40784313725490196, 'rgb(225,95,83)'],
        [0.4117647058823529, 'rgb(224,94,83)'],
        [0.41568627450980394, 'rgb(224,93,83)'],
        [0.4196078431372549, 'rgb(223,91,83)'],
        [0.4235294117647059, 'rgb(223,90,83)'],
        [0.42745098039215684, 'rgb(222,89,83)'],
        [0.43137254901960786, 'rgb(221,88,83)'],
        [0.43529411764705883, 'rgb(220,86,83)'],
        [0.4392156862745098, 'rgb(220,85,83)'],
        [0.44313725490196076, 'rgb(219,84,83)'],
        [0.4470588235294118, 'rgb(218,83,83)'],
        [0.45098039215686275, 'rgb(217,81,83)'],
        [0.4549019607843137, 'rgb(217,80,83)'],
        [0.4588235294117647, 'rgb(216,79,84)'],
        [0.4627450980392157, 'rgb(215,78,84)'],
        [0.4666666666666667, 'rgb(214,77,84)'],
        [0.47058823529411764, 'rgb(213,76,84)'],
        [0.4745098039215686, 'rgb(213,75,84)'],
        [0.47843137254901963, 'rgb(212,74,85)'],
        [0.4823529411764706, 'rgb(211,72,85)'],
        [0.48627450980392156, 'rgb(210,71,85)'],
        [0.49019607843137253, 'rgb(209,70,86)'],
        [0.49411764705882355, 'rgb(208,69,86)'],
        [0.4980392156862745, 'rgb(207,68,86)'],
        [0.5019607843137255, 'rgb(206,67,86)'],
        [0.5058823529411764, 'rgb(205,66,87)'],
        [0.5098039215686274, 'rgb(204,65,87)'],
        [0.5137254901960784, 'rgb(203,64,87)'],
        [0.5176470588235295, 'rgb(202,63,88)'],
        [0.5215686274509804, 'rgb(201,62,88)'],
        [0.5254901960784314, 'rgb(200,61,88)'],
        [0.5294117647058824, 'rgb(199,61,89)'],
        [0.5333333333333333, 'rgb(198,60,89)'],
        [0.5372549019607843, 'rgb(197,59,89)'],
        [0.5411764705882353, 'rgb(196,58,90)'],
        [0.5450980392156862, 'rgb(195,57,90)'],
        [0.5490196078431373, 'rgb(194,56,90)'],
        [0.5529411764705883, 'rgb(193,55,91)'],
        [0.5568627450980392, 'rgb(192,54,91)'],
        [0.5607843137254902, 'rgb(191,54,91)'],
        [0.5647058823529412, 'rgb(190,53,92)'],
        [0.5686274509803921, 'rgb(189,52,92)'],
        [0.5725490196078431, 'rgb(187,51,92)'],
        [0.5764705882352941, 'rgb(186,50,93)'],
        [0.5803921568627451, 'rgb(185,50,93)'],
        [0.5843137254901961, 'rgb(184,49,93)'],
        [0.5882352941176471, 'rgb(183,48,94)'],
        [0.592156862745098, 'rgb(182,47,94)'],
        [0.596078431372549, 'rgb(181,47,94)'],
        [0.6, 'rgb(179,46,95)'],
        [0.6039215686274509, 'rgb(178,45,95)'],
        [0.6078431372549019, 'rgb(177,45,95)'],
        [0.611764705882353, 'rgb(176,44,95)'],
        [0.615686274509804, 'rgb(175,43,96)'],
        [0.6196078431372549, 'rgb(174,43,96)'],
        [0.6235294117647059, 'rgb(172,42,96)'],
        [0.6274509803921569, 'rgb(171,41,96)'],
        [0.6313725490196078, 'rgb(170,41,97)'],
        [0.6352941176470588, 'rgb(169,40,97)'],
        [0.6392156862745098, 'rgb(167,40,97)'],
        [0.6431372549019608, 'rgb(166,39,97)'],
        [0.6470588235294118, 'rgb(165,38,98)'],
        [0.6509803921568628, 'rgb(164,38,98)'],
        [0.6549019607843137, 'rgb(163,37,98)'],
        [0.6588235294117647, 'rgb(161,37,98)'],
        [0.6627450980392157, 'rgb(160,36,98)'],
        [0.6666666666666666, 'rgb(159,36,98)'],
        [0.6705882352941176, 'rgb(158,35,99)'],
        [0.6745098039215687, 'rgb(156,35,99)'],
        [0.6784313725490196, 'rgb(155,34,99)'],
        [0.6823529411764706, 'rgb(154,34,99)'],
        [0.6862745098039216, 'rgb(153,34,99)'],
        [0.6901960784313725, 'rgb(151,33,99)'],
        [0.6941176470588235, 'rgb(150,33,99)'],
        [0.6980392156862745, 'rgb(149,32,99)'],
        [0.7019607843137254, 'rgb(147,32,99)'],
        [0.7058823529411765, 'rgb(146,31,99)'],
        [0.7098039215686275, 'rgb(145,31,99)'],
        [0.7137254901960784, 'rgb(144,31,99)'],
        [0.7176470588235294, 'rgb(142,30,99)'],
        [0.7215686274509804, 'rgb(141,30,99)'],
        [0.7254901960784313, 'rgb(140,30,99)'],
        [0.7294117647058823, 'rgb(138,29,99)'],
        [0.7333333333333333, 'rgb(137,29,99)'],
        [0.7372549019607844, 'rgb(136,29,99)'],
        [0.7411764705882353, 'rgb(134,29,99)'],
        [0.7450980392156863, 'rgb(133,28,99)'],
        [0.7490196078431373, 'rgb(132,28,99)'],
        [0.7529411764705882, 'rgb(130,28,99)'],
        [0.7568627450980392, 'rgb(129,28,99)'],
        [0.7607843137254902, 'rgb(128,27,98)'],
        [0.7647058823529411, 'rgb(126,27,98)'],
        [0.7686274509803922, 'rgb(125,27,98)'],
        [0.7725490196078432, 'rgb(124,27,98)'],
        [0.7764705882352941, 'rgb(122,27,98)'],
        [0.7803921568627451, 'rgb(121,26,97)'],
        [0.7843137254901961, 'rgb(120,26,97)'],
        [0.788235294117647, 'rgb(118,26,97)'],
        [0.792156862745098, 'rgb(117,26,97)'],
        [0.796078431372549, 'rgb(116,26,96)'],
        [0.8, 'rgb(114,26,96)'],
        [0.803921568627451, 'rgb(113,25,96)'],
        [0.807843137254902, 'rgb(112,25,95)'],
        [0.8117647058823529, 'rgb(110,25,95)'],
        [0.8156862745098039, 'rgb(109,25,94)'],
        [0.8196078431372549, 'rgb(107,25,94)'],
        [0.8235294117647058, 'rgb(106,25,94)'],
        [0.8274509803921568, 'rgb(105,25,93)'],
        [0.8313725490196079, 'rgb(103,25,93)'],
        [0.8352941176470589, 'rgb(102,24,92)'],
        [0.8392156862745098, 'rgb(101,24,92)'],
        [0.8431372549019608, 'rgb(99,24,91)'],
        [0.8470588235294118, 'rgb(98,24,91)'],
        [0.8509803921568627, 'rgb(97,24,90)'],
        [0.8549019607843137, 'rgb(95,24,90)'],
        [0.8588235294117647, 'rgb(94,24,89)'],
        [0.8627450980392157, 'rgb(93,23,88)'],
        [0.8666666666666667, 'rgb(91,23,88)'],
        [0.8705882352941177, 'rgb(90,23,87)'],
        [0.8745098039215686, 'rgb(89,23,87)'],
        [0.8784313725490196, 'rgb(87,23,86)'],
        [0.8823529411764706, 'rgb(86,23,85)'],
        [0.8862745098039215, 'rgb(85,23,85)'],
        [0.8901960784313725, 'rgb(83,22,84)'],
        [0.8941176470588236, 'rgb(82,22,83)'],
        [0.8980392156862745, 'rgb(81,22,83)'],
        [0.9019607843137255, 'rgb(79,22,82)'],
        [0.9058823529411765, 'rgb(78,22,81)'],
        [0.9098039215686274, 'rgb(77,21,81)'],
        [0.9137254901960784, 'rgb(75,21,80)'],
        [0.9176470588235294, 'rgb(74,21,79)'],
        [0.9215686274509803, 'rgb(73,21,78)'],
        [0.9254901960784314, 'rgb(71,21,78)'],
        [0.9294117647058824, 'rgb(70,20,77)'],
        [0.9333333333333333, 'rgb(69,20,76)'],
        [0.9372549019607843, 'rgb(68,20,75)'],
        [0.9411764705882353, 'rgb(66,20,75)'],
        [0.9450980392156862, 'rgb(65,19,74)'],
        [0.9490196078431372, 'rgb(64,19,73)'],
        [0.9529411764705882, 'rgb(62,19,72)'],
        [0.9568627450980393, 'rgb(61,19,71)'],
        [0.9607843137254902, 'rgb(60,18,71)'],
        [0.9647058823529412, 'rgb(59,18,70)'],
        [0.9686274509803922, 'rgb(57,18,69)'],
        [0.9725490196078431, 'rgb(56,17,68)'],
        [0.9764705882352941, 'rgb(55,17,67)'],
        [0.9803921568627451, 'rgb(54,17,66)'],
        [0.984313725490196, 'rgb(52,17,65)'],
        [0.9882352941176471, 'rgb(51,16,65)'],
        [0.9921568627450981, 'rgb(50,16,64)'],
        [0.996078431372549, 'rgb(48,15,63)'],
        [1.0, 'rgb(47,15,62)'],
    ],
    'cmo.oxy': [
        [0.0, 'rgb(64,5,5)'],
        [0.00392156862745098, 'rgb(65,5,5)'],
        [0.00784313725490196, 'rgb(67,6,6)'],
        [0.011764705882352941, 'rgb(68,6,6)'],
        [0.01568627450980392, 'rgb(71,6,7)'],
        [0.0196078431372549, 'rgb(72,6,7)'],
        [0.023529411764705882, 'rgb(73,6,7)'],
        [0.027450980392156862, 'rgb(75,6,8)'],
        [0.03137254901960784, 'rgb(77,7,8)'],
        [0.03529411764705882, 'rgb(79,7,9)'],
        [0.0392156862745098, 'rgb(80,7,9)'],
        [0.043137254901960784, 'rgb(81,7,9)'],
        [0.047058823529411764, 'rgb(84,7,10)'],
        [0.050980392156862744, 'rgb(85,7,11)'],
        [0.054901960784313725, 'rgb(87,7,11)'],
        [0.058823529411764705, 'rgb(88,7,11)'],
        [0.06274509803921569, 'rgb(91,7,12)'],
        [0.06666666666666667, 'rgb(92,7,12)'],
        [0.07058823529411765, 'rgb(93,7,12)'],
        [0.07450980392156863, 'rgb(95,7,13)'],
        [0.0784313725490196, 'rgb(98,7,13)'],
        [0.08235294117647059, 'rgb(99,7,14)'],
        [0.08627450980392157, 'rgb(100,7,14)'],
        [0.09019607843137255, 'rgb(102,7,14)'],
        [0.09411764705882353, 'rgb(104,7,14)'],
        [0.09803921568627451, 'rgb(106,6,15)'],
        [0.10196078431372549, 'rgb(107,6,15)'],
        [0.10588235294117647, 'rgb(109,6,15)'],
        [0.10980392156862745, 'rgb(111,6,15)'],
        [0.11372549019607843, 'rgb(113,6,15)'],
        [0.11764705882352941, 'rgb(114,6,15)'],
        [0.12156862745098039, 'rgb(115,5,15)'],
        [0.12549019607843137, 'rgb(118,5,15)'],
        [0.12941176470588237, 'rgb(120,5,15)'],
        [0.13333333333333333, 'rgb(121,5,15)'],
        [0.13725490196078433, 'rgb(122,5,15)'],
        [0.1411764705882353, 'rgb(125,5,14)'],
        [0.1450980392156863, 'rgb(126,5,14)'],
        [0.14901960784313725, 'rgb(127,6,13)'],
        [0.15294117647058825, 'rgb(129,6,13)'],
        [0.1568627450980392, 'rgb(131,8,12)'],
        [0.1607843137254902, 'rgb(132,9,12)'],
        [0.16470588235294117, 'rgb(133,10,11)'],
        [0.16862745098039217, 'rgb(134,12,11)'],
        [0.17254901960784313, 'rgb(136,14,10)'],
        [0.17647058823529413, 'rgb(137,16,10)'],
        [0.1803921568627451, 'rgb(138,17,9)'],
        [0.1843137254901961, 'rgb(139,19,9)'],
        [0.18823529411764706, 'rgb(141,21,8)'],
        [0.19215686274509805, 'rgb(142,23,8)'],
        [0.19607843137254902, 'rgb(143,24,8)'],
        [0.2, 'rgb(80,79,79)'],
        [0.20392156862745098, 'rgb(80,80,80)'],
        [0.20784313725490197, 'rgb(81,81,80)'],
        [0.21176470588235294, 'rgb(82,81,81)'],
        [0.21568627450980393, 'rgb(83,83,83)'],
        [0.2196078431372549, 'rgb(84,84,83)'],
        [0.2235294117647059, 'rgb(85,84,84)'],
        [0.22745098039215686, 'rgb(86,85,85)'],
        [0.23137254901960785, 'rgb(87,87,86)'],
        [0.23529411764705882, 'rgb(88,87,87)'],
        [0.23921568627450981, 'rgb(89,88,88)'],
        [0.24313725490196078, 'rgb(89,89,88)'],
        [0.24705882352941178, 'rgb(91,90,90)'],
        [0.25098039215686274, 'rgb(92,91,91)'],
        [0.2549019607843137, 'rgb(92,92,91)'],
        [0.25882352941176473, 'rgb(93,93,92)'],
        [0.2627450980392157, 'rgb(95,94,94)'],
        [0.26666666666666666, 'rgb(95,95,94)'],
        [0.27058823529411763, 'rgb(96,96,95)'],
        [0.27450980392156865, 'rgb(97,96,96)'],
        [0.2784313725490196, 'rgb(98,98,97)'],
        [0.2823529411764706, 'rgb(99,99,98)'],
        [0.28627450980392155, 'rgb(100,99,99)'],
        [0.2901960784313726, 'rgb(101,100,100)'],
        [0.29411764705882354, 'rgb(102,102,101)'],
        [0.2980392156862745, 'rgb(103,102,102)'],
        [0.30196078431372547, 'rgb(104,103,103)'],
        [0.3058823529411765, 'rgb(104,104,103)'],
        [0.30980392156862746, 'rgb(106,105,105)'],
        [0.3137254901960784, 'rgb(107,106,106)'],
        [0.3176470588235294, 'rgb(107,107,106)'],
        [0.3215686274509804, 'rgb(108,108,107)'],
        [0.3254901960784314, 'rgb(110,109,109)'],
        [0.32941176470588235, 'rgb(111,110,110)'],
        [0.3333333333333333, 'rgb(111,111,110)'],
        [0.33725490196078434, 'rgb(112,112,111)'],
        [0.3411764705882353, 'rgb(114,113,113)'],
        [0.34509803921568627, 'rgb(114,114,113)'],
        [0.34901960784313724, 'rgb(115,115,114)'],
        [0.35294117647058826, 'rgb(116,115,115)'],
        [0.3568627450980392, 'rgb(118,117,116)'],
        [0.3607843137254902, 'rgb(118,118,117)'],
        [0.36470588235294116, 'rgb(119,119,118)'],
        [0.3686274509803922, 'rgb(120,119,119)'],
        [0.37254901960784315, 'rgb(121,121,120)'],
        [0.3764705882352941, 'rgb(122,122,121)'],
        [0.3803921568627451, 'rgb(123,123,122)'],
        [0.3843137254901961, 'rgb(124,123,123)'],
        [0.38823529411764707, 'rgb(125,125,124)'],
        [0.39215686274509803, 'rgb(126,126,125)'],
        [0.396078431372549, 'rgb(127,127,126)'],
        [0.4, 'rgb(129,128,127)'],
        [0.403921568627451, 'rgb(129,129,128)'],
        [0.40784313725490196, 'rgb(130,130,129)'],
        [0.4117647058823529, 'rgb(131,131,130)'],
        [0.41568627450980394, 'rgb(133,132,131)'],
        [0.4196078431372549, 'rgb(133,133,132)'],
        [0.4235294117647059, 'rgb(134,134,133)'],
        [0.42745098039215684, 'rgb(135,135,134)'],
        [0.43137254901960786, 'rgb(137,136,135)'],
        [0.43529411764705883, 'rgb(137,137,136)'],
        [0.4392156862745098, 'rgb(138,138,137)'],
        [0.44313725490196076, 'rgb(139,139,138)'],
        [0.4470588235294118, 'rgb(141,140,140)'],
        [0.45098039215686275, 'rgb(141,141,140)'],
        [0.4549019607843137, 'rgb(142,142,141)'],
        [0.4588235294117647, 'rgb(143,143,142)'],
        [0.4627450980392157, 'rgb(145,144,144)'],
        [0.4666666666666667, 'rgb(146,145,144)'],
        [0.47058823529411764, 'rgb(146,146,145)'],
        [0.4745098039215686, 'rgb(147,147,146)'],
        [0.47843137254901963, 'rgb(149,149,148)'],
        [0.4823529411764706, 'rgb(150,149,149)'],
        [0.48627450980392156, 'rgb(151,150,149)'],
        [0.49019607843137253, 'rgb(151,151,150)'],
        [0.49411764705882355, 'rgb(153,153,152)'],
        [0.4980392156862745, 'rgb(154,154,153)'],
        [0.5019607843137255, 'rgb(155,154,154)'],
        [0.5058823529411764, 'rgb(156,155,154)'],
        [0.5098039215686274, 'rgb(157,157,156)'],
        [0.5137254901960784, 'rgb(158,158,157)'],
        [0.5176470588235295, 'rgb(159,159,158)'],
        [0.5215686274509804, 'rgb(160,160,159)'],
        [0.5254901960784314, 'rgb(162,161,160)'],
        [0.5294117647058824, 'rgb(163,162,161)'],
        [0.5333333333333333, 'rgb(163,163,162)'],
        [0.5372549019607843, 'rgb(164,164,163)'],
        [0.5411764705882353, 'rgb(166,166,165)'],
        [0.5450980392156862, 'rgb(167,166,166)'],
        [0.5490196078431373, 'rgb(168,167,167)'],
        [0.5529411764705883, 'rgb(169,168,167)'],
        [0.5568627450980392, 'rgb(170,170,169)'],
        [0.5607843137254902, 'rgb(171,171,170)'],
        [0.5647058823529412, 'rgb(172,172,171)'],
        [0.5686274509803921, 'rgb(173,173,172)'],
        [0.5725490196078431, 'rgb(175,174,174)'],
        [0.5764705882352941, 'rgb(176,175,174)'],
        [0.5803921568627451, 'rgb(177,176,175)'],
        [0.5843137254901961, 'rgb(177,177,176)'],
        [0.5882352941176471, 'rgb(179,179,178)'],
        [0.592156862745098, 'rgb(180,180,179)'],
        [0.596078431372549, 'rgb(181,181,180)'],
        [0.6, 'rgb(183,183,182)'],
        [0.6039215686274509, 'rgb(184,183,183)'],
        [0.6078431372549019, 'rgb(185,184,183)'],
        [0.611764705882353, 'rgb(186,185,184)'],
        [0.615686274509804, 'rgb(187,187,186)'],
        [0.6196078431372549, 'rgb(188,188,187)'],
        [0.6235294117647059, 'rgb(189,189,188)'],
        [0.6274509803921569, 'rgb(190,190,189)'],
        [0.6313725490196078, 'rgb(192,192,191)'],
        [0.6352941176470588, 'rgb(193,193,192)'],
        [0.6392156862745098, 'rgb(194,194,193)'],
        [0.6431372549019608, 'rgb(195,195,194)'],
        [0.6470588235294118, 'rgb(197,197,195)'],
        [0.6509803921568628, 'rgb(198,197,196)'],
        [0.6549019607843137, 'rgb(199,198,197)'],
        [0.6588235294117647, 'rgb(200,199,198)'],
        [0.6627450980392157, 'rgb(202,201,200)'],
        [0.6666666666666666, 'rgb(203,202,201)'],
        [0.6705882352941176, 'rgb(204,203,202)'],
        [0.6745098039215687, 'rgb(204,204,203)'],
        [0.6784313725490196, 'rgb(206,206,205)'],
        [0.6823529411764706, 'rgb(207,207,206)'],
        [0.6862745098039216, 'rgb(208,208,207)'],
        [0.6901960784313725, 'rgb(209,209,208)'],
        [0.6941176470588235, 'rgb(211,211,210)'],
        [0.6980392156862745, 'rgb(212,212,211)'],
        [0.7019607843137254, 'rgb(213,213,212)'],
        [0.7058823529411765, 'rgb(214,214,213)'],
        [0.7098039215686275, 'rgb(216,216,215)'],
        [0.7137254901960784, 'rgb(217,217,216)'],
        [0.7176470588235294, 'rgb(218,218,217)'],
        [0.7215686274509804, 'rgb(219,219,218)'],
        [0.7254901960784313, 'rgb(221,221,220)'],
        [0.7294117647058823, 'rgb(222,222,221)'],
        [0.7333333333333333, 'rgb(223,223,222)'],
        [0.7372549019607844, 'rgb(224,224,223)'],
        [0.7411764705882353, 'rgb(226,226,225)'],
        [0.7450980392156863, 'rgb(227,227,226)'],
        [0.7490196078431373, 'rgb(228,228,227)'],
        [0.7529411764705882, 'rgb(230,229,228)'],
        [0.7568627450980392, 'rgb(232,231,230)'],
        [0.7607843137254902, 'rgb(233,232,231)'],
        [0.7647058823529411, 'rgb(234,233,232)'],
        [0.7686274509803922, 'rgb(235,235,233)'],
        [0.7725490196078432, 'rgb(237,237,235)'],
        [0.7764705882352941, 'rgb(238,238,236)'],
        [0.7803921568627451, 'rgb(239,239,238)'],
        [0.7843137254901961, 'rgb(240,240,239)'],
        [0.788235294117647, 'rgb(242,242,241)'],
        [0.792156862745098, 'rgb(243,243,242)'],
        [0.796078431372549, 'rgb(244,244,243)'],
        [0.8, 'rgb(248,254,105)'],
        [0.803921568627451, 'rgb(246,253,103)'],
        [0.807843137254902, 'rgb(245,252,100)'],
        [0.8117647058823529, 'rgb(244,252,98)'],
        [0.8156862745098039, 'rgb(241,250,93)'],
        [0.8196078431372549, 'rgb(240,249,90)'],
        [0.8235294117647058, 'rgb(239,248,87)'],
        [0.8274509803921568, 'rgb(238,247,84)'],
        [0.8313725490196079, 'rgb(236,245,78)'],
        [0.8352941176470589, 'rgb(235,243,75)'],
        [0.8392156862745098, 'rgb(235,242,72)'],
        [0.8431372549019608, 'rgb(234,241,69)'],
        [0.8470588235294118, 'rgb(234,238,64)'],
        [0.8509803921568627, 'rgb(234,237,62)'],
        [0.8549019607843137, 'rgb(234,235,61)'],
        [0.8588235294117647, 'rgb(234,234,59)'],
        [0.8627450980392157, 'rgb(234,231,56)'],
        [0.8666666666666667, 'rgb(233,230,55)'],
        [0.8705882352941177, 'rgb(233,228,54)'],
        [0.8745098039215686, 'rgb(233,227,52)'],
        [0.8784313725490196, 'rgb(233,224,50)'],
        [0.8823529411764706, 'rgb(232,223,49)'],
        [0.8862745098039215, 'rgb(232,221,48)'],
        [0.8901960784313725, 'rgb(232,220,48)'],
        [0.8941176470588236, 'rgb(232,217,46)'],
        [0.8980392156862745, 'rgb(231,216,45)'],
        [0.9019607843137255, 'rgb(231,215,44)'],
        [0.9058823529411765, 'rgb(231,213,43)'],
        [0.9098039215686274, 'rgb(230,211,42)'],
        [0.9137254901960784, 'rgb(230,209,41)'],
        [0.9176470588235294, 'rgb(230,208,40)'],
        [0.9215686274509803, 'rgb(229,207,40)'],
        [0.9254901960784314, 'rgb(229,204,38)'],
        [0.9294117647058824, 'rgb(229,203,38)'],
        [0.9333333333333333, 'rgb(228,201,37)'],
        [0.9372549019607843, 'rgb(228,200,37)'],
        [0.9411764705882353, 'rgb(227,198,35)'],
        [0.9450980392156862, 'rgb(227,196,35)'],
        [0.9490196078431372, 'rgb(227,195,34)'],
        [0.9529411764705882, 'rgb(226,194,33)'],
        [0.9568627450980393, 'rgb(226,191,32)'],
        [0.9607843137254902, 'rgb(225,190,32)'],
        [0.9647058823529412, 'rgb(225,189,31)'],
        [0.9686274509803922, 'rgb(224,187,31)'],
        [0.9725490196078431, 'rgb(224,185,30)'],
        [0.9764705882352941, 'rgb(223,184,29)'],
        [0.9803921568627451, 'rgb(223,182,29)'],
        [0.984313725490196, 'rgb(223,181,28)'],
        [0.9882352941176471, 'rgb(222,179,27)'],
        [0.9921568627450981, 'rgb(221,177,26)'],
        [0.996078431372549, 'rgb(221,176,26)'],
        [1.0, 'rgb(221,175,25)'],
    ],
    'cmo.phase': [
        [0.0, 'rgb(168,120,13)'],
        [0.00392156862745098, 'rgb(169,119,15)'],
        [0.00784313725490196, 'rgb(171,118,17)'],
        [0.011764705882352941, 'rgb(172,117,19)'],
        [0.01568627450980392, 'rgb(174,116,20)'],
        [0.0196078431372549, 'rgb(175,115,22)'],
        [0.023529411764705882, 'rgb(177,114,24)'],
        [0.027450980392156862, 'rgb(178,113,25)'],
        [0.03137254901960784, 'rgb(179,112,27)'],
        [0.03529411764705882, 'rgb(181,111,29)'],
        [0.0392156862745098, 'rgb(182,110,30)'],
        [0.043137254901960784, 'rgb(183,109,32)'],
        [0.047058823529411764, 'rgb(185,108,34)'],
        [0.050980392156862744, 'rgb(186,107,35)'],
        [0.054901960784313725, 'rgb(187,106,37)'],
        [0.058823529411764705, 'rgb(189,105,38)'],
        [0.06274509803921569, 'rgb(190,104,40)'],
        [0.06666666666666667, 'rgb(191,103,42)'],
        [0.07058823529411765, 'rgb(192,102,43)'],
        [0.07450980392156863, 'rgb(193,101,45)'],
        [0.0784313725490196, 'rgb(194,100,46)'],
        [0.08235294117647059, 'rgb(196,98,48)'],
        [0.08627450980392157, 'rgb(197,97,50)'],
        [0.09019607843137255, 'rgb(198,96,51)'],
        [0.09411764705882353, 'rgb(199,95,53)'],
        [0.09803921568627451, 'rgb(200,94,55)'],
        [0.10196078431372549, 'rgb(201,93,56)'],
        [0.10588235294117647, 'rgb(202,92,58)'],
        [0.10980392156862745, 'rgb(203,90,60)'],
        [0.11372549019607843, 'rgb(204,89,62)'],
        [0.11764705882352941, 'rgb(205,88,63)'],
        [0.12156862745098039, 'rgb(206,87,65)'],
        [0.12549019607843137, 'rgb(207,86,67)'],
        [0.12941176470588237, 'rgb(208,84,69)'],
        [0.13333333333333333, 'rgb(208,83,71)'],
        [0.13725490196078433, 'rgb(209,82,73)'],
        [0.1411764705882353, 'rgb(210,81,75)'],
        [0.1450980392156863, 'rgb(211,79,77)'],
        [0.14901960784313725, 'rgb(212,78,79)'],
        [0.15294117647058825, 'rgb(213,77,81)'],
        [0.1568627450980392, 'rgb(213,75,83)'],
        [0.1607843137254902, 'rgb(214,74,85)'],
        [0.16470588235294117, 'rgb(215,73,87)'],
        [0.16862745098039217, 'rgb(216,71,90)'],
        [0.17254901960784313, 'rgb(216,70,92)'],
        [0.17647058823529413, 'rgb(217,69,94)'],
        [0.1803921568627451, 'rgb(217,67,97)'],
        [0.1843137254901961, 'rgb(218,66,99)'],
        [0.18823529411764706, 'rgb(219,64,102)'],
        [0.19215686274509805, 'rgb(219,63,104)'],
        [0.19607843137254902, 'rgb(220,61,107)'],
        [0.2, 'rgb(220,60,109)'],
        [0.20392156862745098, 'rgb(221,58,112)'],
        [0.20784313725490197, 'rgb(221,57,115)'],
        [0.21176470588235294, 'rgb(221,56,118)'],
        [0.21568627450980393, 'rgb(222,54,120)'],
        [0.2196078431372549, 'rgb(222,53,123)'],
        [0.2235294117647059, 'rgb(222,51,126)'],
        [0.22745098039215686, 'rgb(222,50,129)'],
        [0.23137254901960785, 'rgb(223,49,132)'],
        [0.23529411764705882, 'rgb(223,47,135)'],
        [0.23921568627450981, 'rgb(223,46,138)'],
        [0.24313725490196078, 'rgb(223,45,141)'],
        [0.24705882352941178, 'rgb(223,43,144)'],
        [0.25098039215686274, 'rgb(223,42,147)'],
        [0.2549019607843137, 'rgb(222,41,151)'],
        [0.25882352941176473, 'rgb(222,40,154)'],
        [0.2627450980392157, 'rgb(222,40,157)'],
        [0.26666666666666666, 'rgb(222,39,160)'],
        [0.27058823529411763, 'rgb(221,38,163)'],
        [0.27450980392156865, 'rgb(221,38,166)'],
        [0.2784313725490196, 'rgb(220,37,169)'],
        [0.2823529411764706, 'rgb(220,37,173)'],
        [0.28627450980392155, 'rgb(219,37,176)'],
        [0.2901960784313726, 'rgb(218,37,179)'],
        [0.29411764705882354, 'rgb(218,38,182)'],
        [0.2980392156862745, 'rgb(217,38,185)'],
        [0.30196078431372547, 'rgb(216,39,188)'],
        [0.3058823529411765, 'rgb(215,39,190)'],
        [0.30980392156862746, 'rgb(214,40,193)'],
        [0.3137254901960784, 'rgb(213,41,196)'],
        [0.3176470588235294, 'rgb(212,42,199)'],
        [0.3215686274509804, 'rgb(211,43,201)'],
        [0.3254901960784314, 'rgb(210,45,204)'],
        [0.32941176470588235, 'rgb(209,46,206)'],
        [0.3333333333333333, 'rgb(208,47,208)'],
        [0.33725490196078434, 'rgb(207,49,211)'],
        [0.3411764705882353, 'rgb(205,50,213)'],
        [0.34509803921568627, 'rgb(204,52,215)'],
        [0.34901960784313724, 'rgb(203,53,217)'],
        [0.35294117647058826, 'rgb(201,55,219)'],
        [0.3568627450980392, 'rgb(200,57,221)'],
        [0.3607843137254902, 'rgb(198,58,223)'],
        [0.36470588235294116, 'rgb(197,60,225)'],
        [0.3686274509803922, 'rgb(195,62,226)'],
        [0.37254901960784315, 'rgb(194,63,228)'],
        [0.3764705882352941, 'rgb(192,65,229)'],
        [0.3803921568627451, 'rgb(190,67,231)'],
        [0.3843137254901961, 'rgb(189,69,232)'],
        [0.38823529411764707, 'rgb(187,70,233)'],
        [0.39215686274509803, 'rgb(185,72,235)'],
        [0.396078431372549, 'rgb(184,74,236)'],
        [0.4, 'rgb(182,75,237)'],
        [0.403921568627451, 'rgb(180,77,238)'],
        [0.40784313725490196, 'rgb(178,79,239)'],
        [0.4117647058823529, 'rgb(176,80,239)'],
        [0.41568627450980394, 'rgb(174,82,240)'],
        [0.4196078431372549, 'rgb(172,84,241)'],
        [0.4235294117647059, 'rgb(170,85,241)'],
        [0.42745098039215684, 'rgb(169,87,242)'],
        [0.43137254901960786, 'rgb(167,89,243)'],
        [0.43529411764705883, 'rgb(164,90,243)'],
        [0.4392156862745098, 'rgb(162,92,243)'],
        [0.44313725490196076, 'rgb(160,93,244)'],
        [0.4470588235294118, 'rgb(158,95,244)'],
        [0.45098039215686275, 'rgb(156,96,244)'],
        [0.4549019607843137, 'rgb(154,98,244)'],
        [0.4588235294117647, 'rgb(152,99,244)'],
        [0.4627450980392157, 'rgb(149,101,244)'],
        [0.4666666666666667, 'rgb(147,102,244)'],
        [0.47058823529411764, 'rgb(145,104,244)'],
        [0.4745098039215686, 'rgb(143,105,244)'],
        [0.47843137254901963, 'rgb(140,107,243)'],
        [0.4823529411764706, 'rgb(138,108,243)'],
        [0.48627450980392156, 'rgb(135,109,243)'],
        [0.49019607843137253, 'rgb(133,111,242)'],
        [0.49411764705882355, 'rgb(130,112,241)'],
        [0.4980392156862745, 'rgb(128,113,241)'],
        [0.5019607843137255, 'rgb(125,115,240)'],
        [0.5058823529411764, 'rgb(123,116,239)'],
        [0.5098039215686274, 'rgb(120,117,239)'],
        [0.5137254901960784, 'rgb(118,119,238)'],
        [0.5176470588235295, 'rgb(115,120,237)'],
        [0.5215686274509804, 'rgb(112,121,236)'],
        [0.5254901960784314, 'rgb(110,122,235)'],
        [0.5294117647058824, 'rgb(107,123,233)'],
        [0.5333333333333333, 'rgb(104,124,232)'],
        [0.5372549019607843, 'rgb(102,126,231)'],
        [0.5411764705882353, 'rgb(99,127,230)'],
        [0.5450980392156862, 'rgb(96,128,228)'],
        [0.5490196078431373, 'rgb(93,129,227)'],
        [0.5529411764705883, 'rgb(90,130,225)'],
        [0.5568627450980392, 'rgb(88,131,223)'],
        [0.5607843137254902, 'rgb(85,132,222)'],
        [0.5647058823529412, 'rgb(82,133,220)'],
        [0.5686274509803921, 'rgb(79,134,218)'],
        [0.5725490196078431, 'rgb(77,135,216)'],
        [0.5764705882352941, 'rgb(74,135,215)'],
        [0.5803921568627451, 'rgb(71,136,213)'],
        [0.5843137254901961, 'rgb(69,137,211)'],
        [0.5882352941176471, 'rgb(66,138,209)'],
        [0.592156862745098, 'rgb(64,138,207)'],
        [0.596078431372549, 'rgb(61,139,205)'],
        [0.6, 'rgb(59,140,203)'],
        [0.6039215686274509, 'rgb(56,140,201)'],
        [0.6078431372549019, 'rgb(54,141,199)'],
        [0.611764705882353, 'rgb(52,142,196)'],
        [0.615686274509804, 'rgb(50,142,194)'],
        [0.6196078431372549, 'rgb(48,143,192)'],
        [0.6235294117647059, 'rgb(46,143,190)'],
        [0.6274509803921569, 'rgb(44,144,188)'],
        [0.6313725490196078, 'rgb(42,144,186)'],
        [0.6352941176470588, 'rgb(40,145,184)'],
        [0.6392156862745098, 'rgb(39,145,182)'],
        [0.6431372549019608, 'rgb(37,145,180)'],
        [0.6470588235294118, 'rgb(36,146,178)'],
        [0.6509803921568628, 'rgb(35,146,176)'],
        [0.6549019607843137, 'rgb(33,146,174)'],
        [0.6588235294117647, 'rgb(32,147,172)'],
        [0.6627450980392157, 'rgb(31,147,170)'],
        [0.6666666666666666, 'rgb(30,147,168)'],
        [0.6705882352941176, 'rgb(29,148,166)'],
        [0.6745098039215687, 'rgb(28,148,164)'],
        [0.6784313725490196, 'rgb(27,148,162)'],
        [0.6823529411764706, 'rgb(26,148,160)'],
        [0.6862745098039216, 'rgb(25,149,158)'],
        [0.6901960784313725, 'rgb(25,149,156)'],
        [0.6941176470588235, 'rgb(24,149,154)'],
        [0.6980392156862745, 'rgb(23,149,152)'],
        [0.7019607843137254, 'rgb(22,150,150)'],
        [0.7058823529411765, 'rgb(21,150,148)'],
        [0.7098039215686275, 'rgb(20,150,146)'],
        [0.7137254901960784, 'rgb(20,150,144)'],
        [0.7176470588235294, 'rgb(19,151,142)'],
        [0.7215686274509804, 'rgb(18,151,140)'],
        [0.7254901960784313, 'rgb(17,151,138)'],
        [0.7294117647058823, 'rgb(16,151,136)'],
        [0.7333333333333333, 'rgb(15,151,134)'],
        [0.7372549019607844, 'rgb(14,152,132)'],
        [0.7411764705882353, 'rgb(13,152,130)'],
        [0.7450980392156863, 'rgb(13,152,128)'],
        [0.7490196078431373, 'rgb(12,152,126)'],
        [0.7529411764705882, 'rgb(12,152,124)'],
        [0.7568627450980392, 'rgb(11,153,121)'],
        [0.7607843137254902, 'rgb(11,153,119)'],
        [0.7647058823529411, 'rgb(11,153,117)'],
        [0.7686274509803922, 'rgb(12,153,115)'],
        [0.7725490196078432, 'rgb(13,153,112)'],
        [0.7764705882352941, 'rgb(14,153,110)'],
        [0.7803921568627451, 'rgb(15,154,107)'],
        [0.7843137254901961, 'rgb(17,154,105)'],
        [0.788235294117647, 'rgb(19,154,102)'],
        [0.792156862745098, 'rgb(21,154,99)'],
        [0.796078431372549, 'rgb(23,154,97)'],
        [0.8, 'rgb(25,154,94)'],
        [0.803921568627451, 'rgb(28,154,91)'],
        [0.807843137254902, 'rgb(31,154,88)'],
        [0.8117647058823529, 'rgb(33,154,85)'],
        [0.8156862745098039, 'rgb(36,154,82)'],
        [0.8196078431372549, 'rgb(39,154,79)'],
        [0.8235294117647058, 'rgb(43,154,76)'],
        [0.8274509803921568, 'rgb(46,154,73)'],
        [0.8313725490196079, 'rgb(49,153,70)'],
        [0.8352941176470589, 'rgb(53,153,67)'],
        [0.8392156862745098, 'rgb(56,153,64)'],
        [0.8431372549019608, 'rgb(60,153,60)'],
        [0.8470588235294118, 'rgb(64,152,57)'],
        [0.8509803921568627, 'rgb(67,152,54)'],
        [0.8549019607843137, 'rgb(71,151,50)'],
        [0.8588235294117647, 'rgb(75,151,47)'],
        [0.8627450980392157, 'rgb(79,150,44)'],
        [0.8666666666666667, 'rgb(83,150,41)'],
        [0.8705882352941177, 'rgb(86,149,38)'],
        [0.8745098039215686, 'rgb(90,148,35)'],
        [0.8784313725490196, 'rgb(94,148,32)'],
        [0.8823529411764706, 'rgb(97,147,30)'],
        [0.8862745098039215, 'rgb(101,146,27)'],
        [0.8901960784313725, 'rgb(104,145,25)'],
        [0.8941176470588236, 'rgb(107,144,23)'],
        [0.8980392156862745, 'rgb(111,144,22)'],
        [0.9019607843137255, 'rgb(114,143,20)'],
        [0.9058823529411765, 'rgb(116,142,19)'],
        [0.9098039215686274, 'rgb(119,141,18)'],
        [0.9137254901960784, 'rgb(122,140,17)'],
        [0.9176470588235294, 'rgb(125,139,16)'],
        [0.9215686274509803, 'rgb(127,139,15)'],
        [0.9254901960784314, 'rgb(130,138,15)'],
        [0.9294117647058824, 'rgb(132,137,14)'],
        [0.9333333333333333, 'rgb(134,136,14)'],
        [0.9372549019607843, 'rgb(136,135,14)'],
        [0.9411764705882353, 'rgb(139,134,13)'],
        [0.9450980392156862, 'rgb(141,133,13)'],
        [0.9490196078431372, 'rgb(143,132,13)'],
        [0.9529411764705882, 'rgb(145,131,13)'],
        [0.9568627450980393, 'rgb(147,131,13)'],
        [0.9607843137254902, 'rgb(149,130,13)'],
        [0.9647058823529412, 'rgb(151,129,13)'],
        [0.9686274509803922, 'rgb(153,128,13)'],
        [0.9725490196078431, 'rgb(155,127,13)'],
        [0.9764705882352941, 'rgb(157,126,13)'],
        [0.9803921568627451, 'rgb(159,125,13)'],
        [0.984313725490196, 'rgb(161,124,13)'],
        [0.9882352941176471, 'rgb(162,123,13)'],
        [0.9921568627450981, 'rgb(164,122,13)'],
        [0.996078431372549, 'rgb(166,121,13)'],
        [1.0, 'rgb(168,120,13)'],
    ],
    'cmo.rain': [
        [0.0, 'rgb(238,237,243)'],
        [0.00392156862745098, 'rgb(238,236,241)'],
        [0.00784313725490196, 'rgb(237,235,240)'],
        [0.011764705882352941, 'rgb(236,234,238)'],
        [0.01568627450980392, 'rgb(235,233,236)'],
        [0.0196078431372549, 'rgb(235,232,235)'],
        [0.023529411764705882, 'rgb(234,231,233)'],
        [0.027450980392156862, 'rgb(233,230,232)'],
        [0.03137254901960784, 'rgb(232,229,230)'],
        [0.03529411764705882, 'rgb(232,228,229)'],
        [0.0392156862745098, 'rgb(231,227,227)'],
        [0.043137254901960784, 'rgb(230,226,226)'],
        [0.047058823529411764, 'rgb(229,225,224)'],
        [0.050980392156862744, 'rgb(228,223,223)'],
        [0.054901960784313725, 'rgb(228,222,221)'],
        [0.058823529411764705, 'rgb(227,221,220)'],
        [0.06274509803921569, 'rgb(227,220,218)'],
        [0.06666666666666667, 'rgb(226,219,216)'],
        [0.07058823529411765, 'rgb(226,218,214)'],
        [0.07450980392156863, 'rgb(225,217,212)'],
        [0.0784313725490196, 'rgb(224,216,211)'],
        [0.08235294117647059, 'rgb(224,215,209)'],
        [0.08627450980392157, 'rgb(223,214,207)'],
        [0.09019607843137255, 'rgb(223,213,205)'],
        [0.09411764705882353, 'rgb(222,212,203)'],
        [0.09803921568627451, 'rgb(222,211,201)'],
        [0.10196078431372549, 'rgb(221,209,199)'],
        [0.10588235294117647, 'rgb(221,208,197)'],
        [0.10980392156862745, 'rgb(220,207,195)'],
        [0.11372549019607843, 'rgb(220,206,193)'],
        [0.11764705882352941, 'rgb(219,205,191)'],
        [0.12156862745098039, 'rgb(219,204,190)'],
        [0.12549019607843137, 'rgb(219,203,188)'],
        [0.12941176470588237, 'rgb(218,202,186)'],
        [0.13333333333333333, 'rgb(218,201,184)'],
        [0.13725490196078433, 'rgb(217,200,182)'],
        [0.1411764705882353, 'rgb(216,199,180)'],
        [0.1450980392156863, 'rgb(216,198,178)'],
        [0.14901960784313725, 'rgb(215,197,176)'],
        [0.15294117647058825, 'rgb(215,196,174)'],
        [0.1568627450980392, 'rgb(214,195,172)'],
        [0.1607843137254902, 'rgb(213,194,170)'],
        [0.16470588235294117, 'rgb(213,193,168)'],
        [0.16862745098039217, 'rgb(212,192,166)'],
        [0.17254901960784313, 'rgb(211,191,164)'],
        [0.17647058823529413, 'rgb(210,191,162)'],
        [0.1803921568627451, 'rgb(209,190,160)'],
        [0.1843137254901961, 'rgb(208,189,158)'],
        [0.18823529411764706, 'rgb(207,188,156)'],
        [0.19215686274509805, 'rgb(205,188,155)'],
        [0.19607843137254902, 'rgb(204,187,153)'],
        [0.2, 'rgb(203,186,152)'],
        [0.20392156862745098, 'rgb(201,186,150)'],
        [0.20784313725490197, 'rgb(200,185,149)'],
        [0.21176470588235294, 'rgb(198,185,148)'],
        [0.21568627450980393, 'rgb(196,184,146)'],
        [0.2196078431372549, 'rgb(195,183,145)'],
        [0.2235294117647059, 'rgb(193,183,144)'],
        [0.22745098039215686, 'rgb(192,182,143)'],
        [0.23137254901960785, 'rgb(190,182,142)'],
        [0.23529411764705882, 'rgb(188,181,141)'],
        [0.23921568627450981, 'rgb(186,181,141)'],
        [0.24313725490196078, 'rgb(185,180,140)'],
        [0.24705882352941178, 'rgb(183,179,139)'],
        [0.25098039215686274, 'rgb(181,179,138)'],
        [0.2549019607843137, 'rgb(180,178,137)'],
        [0.25882352941176473, 'rgb(178,178,137)'],
        [0.2627450980392157, 'rgb(176,177,136)'],
        [0.26666666666666666, 'rgb(174,177,135)'],
        [0.27058823529411763, 'rgb(173,176,135)'],
        [0.27450980392156865, 'rgb(171,176,134)'],
        [0.2784313725490196, 'rgb(169,175,133)'],
        [0.2823529411764706, 'rgb(168,174,133)'],
        [0.28627450980392155, 'rgb(166,174,132)'],
        [0.2901960784313726, 'rgb(164,173,132)'],
        [0.29411764705882354, 'rgb(162,173,131)'],
        [0.2980392156862745, 'rgb(161,172,130)'],
        [0.30196078431372547, 'rgb(159,172,130)'],
        [0.3058823529411765, 'rgb(157,171,129)'],
        [0.30980392156862746, 'rgb(156,170,129)'],
        [0.3137254901960784, 'rgb(154,170,128)'],
        [0.3176470588235294, 'rgb(152,169,128)'],
        [0.3215686274509804, 'rgb(150,169,127)'],
        [0.3254901960784314, 'rgb(149,168,126)'],
        [0.32941176470588235, 'rgb(147,168,126)'],
        [0.3333333333333333, 'rgb(145,167,125)'],
        [0.33725490196078434, 'rgb(144,167,125)'],
        [0.3411764705882353, 'rgb(142,166,124)'],
        [0.34509803921568627, 'rgb(140,165,124)'],
        [0.34901960784313724, 'rgb(138,165,123)'],
        [0.35294117647058826, 'rgb(137,164,123)'],
        [0.3568627450980392, 'rgb(135,164,122)'],
        [0.3607843137254902, 'rgb(133,163,122)'],
        [0.36470588235294116, 'rgb(131,163,121)'],
        [0.3686274509803922, 'rgb(130,162,120)'],
        [0.37254901960784315, 'rgb(128,161,120)'],
        [0.3764705882352941, 'rgb(126,161,119)'],
        [0.3803921568627451, 'rgb(124,160,119)'],
        [0.3843137254901961, 'rgb(122,160,118)'],
        [0.38823529411764707, 'rgb(121,159,118)'],
        [0.39215686274509803, 'rgb(119,159,117)'],
        [0.396078431372549, 'rgb(117,158,117)'],
        [0.4, 'rgb(115,157,117)'],
        [0.403921568627451, 'rgb(113,157,116)'],
        [0.40784313725490196, 'rgb(111,156,116)'],
        [0.4117647058823529, 'rgb(109,156,115)'],
        [0.41568627450980394, 'rgb(107,155,115)'],
        [0.4196078431372549, 'rgb(105,155,114)'],
        [0.4235294117647059, 'rgb(103,154,114)'],
        [0.42745098039215684, 'rgb(101,154,114)'],
        [0.43137254901960786, 'rgb(100,153,113)'],
        [0.43529411764705883, 'rgb(97,152,113)'],
        [0.4392156862745098, 'rgb(95,152,113)'],
        [0.44313725490196076, 'rgb(93,151,112)'],
        [0.4470588235294118, 'rgb(91,151,112)'],
        [0.45098039215686275, 'rgb(89,150,112)'],
        [0.4549019607843137, 'rgb(87,149,111)'],
        [0.4588235294117647, 'rgb(85,149,111)'],
        [0.4627450980392157, 'rgb(83,148,111)'],
        [0.4666666666666667, 'rgb(81,148,111)'],
        [0.47058823529411764, 'rgb(79,147,110)'],
        [0.4745098039215686, 'rgb(76,147,110)'],
        [0.47843137254901963, 'rgb(74,146,110)'],
        [0.4823529411764706, 'rgb(72,145,110)'],
        [0.48627450980392156, 'rgb(70,145,110)'],
        [0.49019607843137253, 'rgb(67,144,110)'],
        [0.49411764705882355, 'rgb(65,143,110)'],
        [0.4980392156862745, 'rgb(63,143,110)'],
        [0.5019607843137255, 'rgb(61,142,110)'],
        [0.5058823529411764, 'rgb(58,141,109)'],
        [0.5098039215686274, 'rgb(56,141,109)'],
        [0.5137254901960784, 'rgb(54,140,109)'],
        [0.5176470588235295, 'rgb(52,139,109)'],
        [0.5215686274509804, 'rgb(49,139,110)'],
        [0.5254901960784314, 'rgb(47,138,110)'],
        [0.5294117647058824, 'rgb(45,137,110)'],
        [0.5333333333333333, 'rgb(43,137,110)'],
        [0.5372549019607843, 'rgb(41,136,110)'],
        [0.5411764705882353, 'rgb(38,135,110)'],
        [0.5450980392156862, 'rgb(36,134,110)'],
        [0.5490196078431373, 'rgb(34,134,110)'],
        [0.5529411764705883, 'rgb(32,133,110)'],
        [0.5568627450980392, 'rgb(30,132,110)'],
        [0.5607843137254902, 'rgb(28,131,110)'],
        [0.5647058823529412, 'rgb(27,130,110)'],
        [0.5686274509803921, 'rgb(25,129,110)'],
        [0.5725490196078431, 'rgb(23,129,110)'],
        [0.5764705882352941, 'rgb(21,128,110)'],
        [0.5803921568627451, 'rgb(20,127,110)'],
        [0.5843137254901961, 'rgb(18,126,110)'],
        [0.5882352941176471, 'rgb(17,125,110)'],
        [0.592156862745098, 'rgb(15,124,110)'],
        [0.596078431372549, 'rgb(14,124,110)'],
        [0.6, 'rgb(12,123,110)'],
        [0.6039215686274509, 'rgb(11,122,110)'],
        [0.6078431372549019, 'rgb(10,121,110)'],
        [0.611764705882353, 'rgb(9,120,110)'],
        [0.615686274509804, 'rgb(8,119,110)'],
        [0.6196078431372549, 'rgb(7,118,110)'],
        [0.6235294117647059, 'rgb(6,117,110)'],
        [0.6274509803921569, 'rgb(6,116,110)'],
        [0.6313725490196078, 'rgb(5,116,110)'],
        [0.6352941176470588, 'rgb(5,115,110)'],
        [0.6392156862745098, 'rgb(4,114,110)'],
        [0.6431372549019608, 'rgb(4,113,110)'],
        [0.6470588235294118, 'rgb(4,112,109)'],
        [0.6509803921568628, 'rgb(3,111,109)'],
        [0.6549019607843137, 'rgb(3,110,109)'],
        [0.6588235294117647, 'rgb(3,109,109)'],
        [0.6627450980392157, 'rgb(3,108,109)'],
        [0.6666666666666666, 'rgb(4,107,109)'],
        [0.6705882352941176, 'rgb(4,107,109)'],
        [0.6745098039215687, 'rgb(4,106,108)'],
        [0.6784313725490196, 'rgb(4,105,108)'],
        [0.6823529411764706, 'rgb(5,104,108)'],
        [0.6862745098039216, 'rgb(5,103,108)'],
        [0.6901960784313725, 'rgb(6,102,108)'],
        [0.6941176470588235, 'rgb(7,101,107)'],
        [0.6980392156862745, 'rgb(7,100,107)'],
        [0.7019607843137254, 'rgb(8,99,107)'],
        [0.7058823529411765, 'rgb(9,98,107)'],
        [0.7098039215686275, 'rgb(10,97,106)'],
        [0.7137254901960784, 'rgb(11,96,106)'],
        [0.7176470588235294, 'rgb(12,95,106)'],
        [0.7215686274509804, 'rgb(13,95,105)'],
        [0.7254901960784313, 'rgb(14,94,105)'],
        [0.7294117647058823, 'rgb(15,93,105)'],
        [0.7333333333333333, 'rgb(16,92,104)'],
        [0.7372549019607844, 'rgb(17,91,104)'],
        [0.7411764705882353, 'rgb(18,90,103)'],
        [0.7450980392156863, 'rgb(19,89,103)'],
        [0.7490196078431373, 'rgb(20,88,103)'],
        [0.7529411764705882, 'rgb(21,87,102)'],
        [0.7568627450980392, 'rgb(22,86,102)'],
        [0.7607843137254902, 'rgb(22,85,101)'],
        [0.7647058823529411, 'rgb(23,84,101)'],
        [0.7686274509803922, 'rgb(24,83,100)'],
        [0.7725490196078432, 'rgb(25,82,100)'],
        [0.7764705882352941, 'rgb(26,81,99)'],
        [0.7803921568627451, 'rgb(26,80,99)'],
        [0.7843137254901961, 'rgb(27,79,98)'],
        [0.788235294117647, 'rgb(28,78,97)'],
        [0.792156862745098, 'rgb(28,77,97)'],
        [0.796078431372549, 'rgb(29,76,96)'],
        [0.8, 'rgb(30,75,95)'],
        [0.803921568627451, 'rgb(30,74,95)'],
        [0.807843137254902, 'rgb(31,73,94)'],
        [0.8117647058823529, 'rgb(31,72,93)'],
        [0.8156862745098039, 'rgb(32,72,93)'],
        [0.8196078431372549, 'rgb(33,71,92)'],
        [0.8235294117647058, 'rgb(33,70,91)'],
        [0.8274509803921568, 'rgb(33,69,90)'],
        [0.8313725490196079, 'rgb(34,68,90)'],
        [0.8352941176470589, 'rgb(34,67,89)'],
        [0.8392156862745098, 'rgb(35,66,88)'],
        [0.8431372549019608, 'rgb(35,65,87)'],
        [0.8470588235294118, 'rgb(35,64,86)'],
        [0.8509803921568627, 'rgb(36,63,86)'],
        [0.8549019607843137, 'rgb(36,62,85)'],
        [0.8588235294117647, 'rgb(36,61,84)'],
        [0.8627450980392157, 'rgb(36,60,83)'],
        [0.8666666666666667, 'rgb(36,59,82)'],
        [0.8705882352941177, 'rgb(37,58,81)'],
        [0.8745098039215686, 'rgb(37,57,81)'],
        [0.8784313725490196, 'rgb(37,56,80)'],
        [0.8823529411764706, 'rgb(37,55,79)'],
        [0.8862745098039215, 'rgb(37,55,78)'],
        [0.8901960784313725, 'rgb(37,54,77)'],
        [0.8941176470588236, 'rgb(37,53,76)'],
        [0.8980392156862745, 'rgb(37,52,76)'],
        [0.9019607843137255, 'rgb(37,51,75)'],
        [0.9058823529411765, 'rgb(37,50,74)'],
        [0.9098039215686274, 'rgb(37,49,73)'],
        [0.9137254901960784, 'rgb(37,48,72)'],
        [0.9176470588235294, 'rgb(37,47,72)'],
        [0.9215686274509803, 'rgb(37,46,71)'],
        [0.9254901960784314, 'rgb(37,45,70)'],
        [0.9294117647058824, 'rgb(37,44,69)'],
        [0.9333333333333333, 'rgb(37,43,69)'],
        [0.9372549019607843, 'rgb(37,42,68)'],
        [0.9411764705882353, 'rgb(36,41,67)'],
        [0.9450980392156862, 'rgb(36,40,66)'],
        [0.9490196078431372, 'rgb(36,39,66)'],
        [0.9529411764705882, 'rgb(36,39,65)'],
        [0.9568627450980393, 'rgb(36,38,64)'],
        [0.9607843137254902, 'rgb(36,37,63)'],
        [0.9647058823529412, 'rgb(35,36,63)'],
        [0.9686274509803922, 'rgb(35,35,62)'],
        [0.9725490196078431, 'rgb(35,34,61)'],
        [0.9764705882352941, 'rgb(35,33,61)'],
        [0.9803921568627451, 'rgb(35,32,60)'],
        [0.984313725490196, 'rgb(34,31,59)'],
        [0.9882352941176471, 'rgb(34,30,58)'],
        [0.9921568627450981, 'rgb(34,29,58)'],
        [0.996078431372549, 'rgb(34,28,57)'],
        [1.0, 'rgb(34,27,56)'],
    ],
    'cmo.solar': [
        [0.0, 'rgb(51,20,24)'],
        [0.00392156862745098, 'rgb(53,20,24)'],
        [0.00784313725490196, 'rgb(54,21,25)'],
        [0.011764705882352941, 'rgb(55,21,25)'],
        [0.01568627450980392, 'rgb(56,21,26)'],
        [0.0196078431372549, 'rgb(58,22,26)'],
        [0.023529411764705882, 'rgb(59,22,27)'],
        [0.027450980392156862, 'rgb(60,23,27)'],
        [0.03137254901960784, 'rgb(61,23,28)'],
        [0.03529411764705882, 'rgb(62,24,28)'],
        [0.0392156862745098, 'rgb(64,24,29)'],
        [0.043137254901960784, 'rgb(65,24,29)'],
        [0.047058823529411764, 'rgb(66,25,29)'],
        [0.050980392156862744, 'rgb(67,25,30)'],
        [0.054901960784313725, 'rgb(69,26,30)'],
        [0.058823529411764705, 'rgb(70,26,31)'],
        [0.06274509803921569, 'rgb(71,26,31)'],
        [0.06666666666666667, 'rgb(72,27,31)'],
        [0.07058823529411765, 'rgb(74,27,32)'],
        [0.07450980392156863, 'rgb(75,27,32)'],
        [0.0784313725490196, 'rgb(76,28,32)'],
        [0.08235294117647059, 'rgb(77,28,33)'],
        [0.08627450980392157, 'rgb(79,28,33)'],
        [0.09019607843137255, 'rgb(80,29,33)'],
        [0.09411764705882353, 'rgb(81,29,34)'],
        [0.09803921568627451, 'rgb(82,30,34)'],
        [0.10196078431372549, 'rgb(84,30,34)'],
        [0.10588235294117647, 'rgb(85,30,34)'],
        [0.10980392156862745, 'rgb(86,31,35)'],
        [0.11372549019607843, 'rgb(87,31,35)'],
        [0.11764705882352941, 'rgb(89,31,35)'],
        [0.12156862745098039, 'rgb(90,32,35)'],
        [0.12549019607843137, 'rgb(91,32,35)'],
        [0.12941176470588237, 'rgb(92,32,36)'],
        [0.13333333333333333, 'rgb(94,33,36)'],
        [0.13725490196078433, 'rgb(95,33,36)'],
        [0.1411764705882353, 'rgb(96,33,36)'],
        [0.1450980392156863, 'rgb(97,34,36)'],
        [0.14901960784313725, 'rgb(99,34,36)'],
        [0.15294117647058825, 'rgb(100,34,36)'],
        [0.1568627450980392, 'rgb(101,35,36)'],
        [0.1607843137254902, 'rgb(102,35,37)'],
        [0.16470588235294117, 'rgb(104,35,37)'],
        [0.16862745098039217, 'rgb(105,36,37)'],
        [0.17254901960784313, 'rgb(106,36,37)'],
        [0.17647058823529413, 'rgb(107,36,37)'],
        [0.1803921568627451, 'rgb(109,37,37)'],
        [0.1843137254901961, 'rgb(110,37,37)'],
        [0.18823529411764706, 'rgb(111,37,37)'],
        [0.19215686274509805, 'rgb(112,38,37)'],
        [0.19607843137254902, 'rgb(114,38,37)'],
        [0.2, 'rgb(115,39,36)'],
        [0.20392156862745098, 'rgb(116,39,36)'],
        [0.20784313725490197, 'rgb(117,39,36)'],
        [0.21176470588235294, 'rgb(119,40,36)'],
        [0.21568627450980393, 'rgb(120,40,36)'],
        [0.2196078431372549, 'rgb(121,41,36)'],
        [0.2235294117647059, 'rgb(122,41,36)'],
        [0.22745098039215686, 'rgb(123,42,36)'],
        [0.23137254901960785, 'rgb(124,42,35)'],
        [0.23529411764705882, 'rgb(126,43,35)'],
        [0.23921568627450981, 'rgb(127,43,35)'],
        [0.24313725490196078, 'rgb(128,44,35)'],
        [0.24705882352941178, 'rgb(129,44,34)'],
        [0.25098039215686274, 'rgb(130,45,34)'],
        [0.2549019607843137, 'rgb(131,45,34)'],
        [0.25882352941176473, 'rgb(132,46,34)'],
        [0.2627450980392157, 'rgb(133,46,33)'],
        [0.26666666666666666, 'rgb(135,47,33)'],
        [0.27058823529411763, 'rgb(136,48,33)'],
        [0.27450980392156865, 'rgb(137,48,33)'],
        [0.2784313725490196, 'rgb(138,49,32)'],
        [0.2823529411764706, 'rgb(139,49,32)'],
        [0.28627450980392155, 'rgb(140,50,32)'],
        [0.2901960784313726, 'rgb(141,51,31)'],
        [0.29411764705882354, 'rgb(142,52,31)'],
        [0.2980392156862745, 'rgb(143,52,31)'],
        [0.30196078431372547, 'rgb(144,53,30)'],
        [0.3058823529411765, 'rgb(145,54,30)'],
        [0.30980392156862746, 'rgb(146,54,30)'],
        [0.3137254901960784, 'rgb(147,55,29)'],
        [0.3176470588235294, 'rgb(147,56,29)'],
        [0.3215686274509804, 'rgb(148,57,29)'],
        [0.3254901960784314, 'rgb(149,58,29)'],
        [0.32941176470588235, 'rgb(150,58,28)'],
        [0.3333333333333333, 'rgb(151,59,28)'],
        [0.33725490196078434, 'rgb(152,60,28)'],
        [0.3411764705882353, 'rgb(153,61,27)'],
        [0.34509803921568627, 'rgb(154,62,27)'],
        [0.34901960784313724, 'rgb(154,63,27)'],
        [0.35294117647058826, 'rgb(155,64,26)'],
        [0.3568627450980392, 'rgb(156,64,26)'],
        [0.3607843137254902, 'rgb(157,65,26)'],
        [0.36470588235294116, 'rgb(158,66,26)'],
        [0.3686274509803922, 'rgb(159,67,25)'],
        [0.37254901960784315, 'rgb(159,68,25)'],
        [0.3764705882352941, 'rgb(160,69,25)'],
        [0.3803921568627451, 'rgb(161,70,25)'],
        [0.3843137254901961, 'rgb(162,71,24)'],
        [0.38823529411764707, 'rgb(163,72,24)'],
        [0.39215686274509803, 'rgb(163,73,24)'],
        [0.396078431372549, 'rgb(164,74,24)'],
        [0.4, 'rgb(165,74,23)'],
        [0.403921568627451, 'rgb(166,75,23)'],
        [0.40784313725490196, 'rgb(166,76,23)'],
        [0.4117647058823529, 'rgb(167,77,23)'],
        [0.41568627450980394, 'rgb(168,78,22)'],
        [0.4196078431372549, 'rgb(168,79,22)'],
        [0.4235294117647059, 'rgb(169,80,22)'],
        [0.42745098039215684, 'rgb(170,81,22)'],
        [0.43137254901960786, 'rgb(171,82,22)'],
        [0.43529411764705883, 'rgb(171,83,21)'],
        [0.4392156862745098, 'rgb(172,84,21)'],
        [0.44313725490196076, 'rgb(173,85,21)'],
        [0.4470588235294118, 'rgb(173,86,21)'],
        [0.45098039215686275, 'rgb(174,87,21)'],
        [0.4549019607843137, 'rgb(175,88,20)'],
        [0.4588235294117647, 'rgb(175,89,20)'],
        [0.4627450980392157, 'rgb(176,90,20)'],
        [0.4666666666666667, 'rgb(177,91,20)'],
        [0.47058823529411764, 'rgb(177,92,20)'],
        [0.4745098039215686, 'rgb(178,93,20)'],
        [0.47843137254901963, 'rgb(178,94,20)'],
        [0.4823529411764706, 'rgb(179,95,20)'],
        [0.48627450980392156, 'rgb(180,96,19)'],
        [0.49019607843137253, 'rgb(180,97,19)'],
        [0.49411764705882355, 'rgb(181,98,19)'],
        [0.4980392156862745, 'rgb(182,99,19)'],
        [0.5019607843137255, 'rgb(182,100,19)'],
        [0.5058823529411764, 'rgb(183,101,19)'],
        [0.5098039215686274, 'rgb(183,102,19)'],
        [0.5137254901960784, 'rgb(184,104,19)'],
        [0.5176470588235295, 'rgb(184,105,19)'],
        [0.5215686274509804, 'rgb(185,106,19)'],
        [0.5254901960784314, 'rgb(186,107,19)'],
        [0.5294117647058824, 'rgb(186,108,19)'],
        [0.5333333333333333, 'rgb(187,109,19)'],
        [0.5372549019607843, 'rgb(187,110,19)'],
        [0.5411764705882353, 'rgb(188,111,19)'],
        [0.5450980392156862, 'rgb(188,112,19)'],
        [0.5490196078431373, 'rgb(189,113,19)'],
        [0.5529411764705883, 'rgb(190,114,19)'],
        [0.5568627450980392, 'rgb(190,115,19)'],
        [0.5607843137254902, 'rgb(191,116,19)'],
        [0.5647058823529412, 'rgb(191,117,19)'],
        [0.5686274509803921, 'rgb(192,118,19)'],
        [0.5725490196078431, 'rgb(192,119,20)'],
        [0.5764705882352941, 'rgb(193,121,20)'],
        [0.5803921568627451, 'rgb(193,122,20)'],
        [0.5843137254901961, 'rgb(194,123,20)'],
        [0.5882352941176471, 'rgb(194,124,20)'],
        [0.592156862745098, 'rgb(195,125,20)'],
        [0.596078431372549, 'rgb(195,126,21)'],
        [0.6, 'rgb(196,127,21)'],
        [0.6039215686274509, 'rgb(196,128,21)'],
        [0.6078431372549019, 'rgb(197,129,21)'],
        [0.611764705882353, 'rgb(197,130,21)'],
        [0.615686274509804, 'rgb(198,132,22)'],
        [0.6196078431372549, 'rgb(198,133,22)'],
        [0.6235294117647059, 'rgb(199,134,22)'],
        [0.6274509803921569, 'rgb(199,135,22)'],
        [0.6313725490196078, 'rgb(199,136,23)'],
        [0.6352941176470588, 'rgb(200,137,23)'],
        [0.6392156862745098, 'rgb(200,138,23)'],
        [0.6431372549019608, 'rgb(201,139,24)'],
        [0.6470588235294118, 'rgb(201,140,24)'],
        [0.6509803921568628, 'rgb(202,142,24)'],
        [0.6549019607843137, 'rgb(202,143,25)'],
        [0.6588235294117647, 'rgb(203,144,25)'],
        [0.6627450980392157, 'rgb(203,145,25)'],
        [0.6666666666666666, 'rgb(203,146,26)'],
        [0.6705882352941176, 'rgb(204,147,26)'],
        [0.6745098039215687, 'rgb(204,148,26)'],
        [0.6784313725490196, 'rgb(205,150,27)'],
        [0.6823529411764706, 'rgb(205,151,27)'],
        [0.6862745098039216, 'rgb(206,152,28)'],
        [0.6901960784313725, 'rgb(206,153,28)'],
        [0.6941176470588235, 'rgb(206,154,28)'],
        [0.6980392156862745, 'rgb(207,155,29)'],
        [0.7019607843137254, 'rgb(207,156,29)'],
        [0.7058823529411765, 'rgb(208,158,30)'],
        [0.7098039215686275, 'rgb(208,159,30)'],
        [0.7137254901960784, 'rgb(208,160,31)'],
        [0.7176470588235294, 'rgb(209,161,31)'],
        [0.7215686274509804, 'rgb(209,162,32)'],
        [0.7254901960784313, 'rgb(209,164,32)'],
        [0.7294117647058823, 'rgb(210,165,32)'],
        [0.7333333333333333, 'rgb(210,166,33)'],
        [0.7372549019607844, 'rgb(211,167,33)'],
        [0.7411764705882353, 'rgb(211,168,34)'],
        [0.7450980392156863, 'rgb(211,169,34)'],
        [0.7490196078431373, 'rgb(212,171,35)'],
        [0.7529411764705882, 'rgb(212,172,36)'],
        [0.7568627450980392, 'rgb(212,173,36)'],
        [0.7607843137254902, 'rgb(213,174,37)'],
        [0.7647058823529411, 'rgb(213,175,37)'],
        [0.7686274509803922, 'rgb(213,177,38)'],
        [0.7725490196078432, 'rgb(214,178,38)'],
        [0.7764705882352941, 'rgb(214,179,39)'],
        [0.7803921568627451, 'rgb(214,180,39)'],
        [0.7843137254901961, 'rgb(215,181,40)'],
        [0.788235294117647, 'rgb(215,183,40)'],
        [0.792156862745098, 'rgb(215,184,41)'],
        [0.796078431372549, 'rgb(215,185,42)'],
        [0.8, 'rgb(216,186,42)'],
        [0.803921568627451, 'rgb(216,188,43)'],
        [0.807843137254902, 'rgb(216,189,43)'],
        [0.8117647058823529, 'rgb(217,190,44)'],
        [0.8156862745098039, 'rgb(217,191,44)'],
        [0.8196078431372549, 'rgb(217,193,45)'],
        [0.8235294117647058, 'rgb(217,194,46)'],
        [0.8274509803921568, 'rgb(218,195,46)'],
        [0.8313725490196079, 'rgb(218,196,47)'],
        [0.8352941176470589, 'rgb(218,198,47)'],
        [0.8392156862745098, 'rgb(218,199,48)'],
        [0.8431372549019608, 'rgb(219,200,49)'],
        [0.8470588235294118, 'rgb(219,201,49)'],
        [0.8509803921568627, 'rgb(219,203,50)'],
        [0.8549019607843137, 'rgb(219,204,50)'],
        [0.8588235294117647, 'rgb(220,205,51)'],
        [0.8627450980392157, 'rgb(220,206,52)'],
        [0.8666666666666667, 'rgb(220,208,52)'],
        [0.8705882352941177, 'rgb(220,209,53)'],
        [0.8745098039215686, 'rgb(221,210,54)'],
        [0.8784313725490196, 'rgb(221,212,54)'],
        [0.8823529411764706, 'rgb(221,213,55)'],
        [0.8862745098039215, 'rgb(221,214,55)'],
        [0.8901960784313725, 'rgb(221,215,56)'],
        [0.8941176470588236, 'rgb(222,217,57)'],
        [0.8980392156862745, 'rgb(222,218,57)'],
        [0.9019607843137255, 'rgb(222,219,58)'],
        [0.9058823529411765, 'rgb(222,221,59)'],
        [0.9098039215686274, 'rgb(222,222,59)'],
        [0.9137254901960784, 'rgb(222,223,60)'],
        [0.9176470588235294, 'rgb(223,225,61)'],
        [0.9215686274509803, 'rgb(223,226,61)'],
        [0.9254901960784314, 'rgb(223,227,62)'],
        [0.9294117647058824, 'rgb(223,229,63)'],
        [0.9333333333333333, 'rgb(223,230,63)'],
        [0.9372549019607843, 'rgb(223,231,64)'],
        [0.9411764705882353, 'rgb(223,233,65)'],
        [0.9450980392156862, 'rgb(224,234,65)'],
        [0.9490196078431372, 'rgb(224,235,66)'],
        [0.9529411764705882, 'rgb(224,237,67)'],
        [0.9568627450980393, 'rgb(224,238,67)'],
        [0.9607843137254902, 'rgb(224,240,68)'],
        [0.9647058823529412, 'rgb(224,241,69)'],
        [0.9686274509803922, 'rgb(224,242,69)'],
        [0.9725490196078431, 'rgb(224,244,70)'],
        [0.9764705882352941, 'rgb(224,245,71)'],
        [0.9803921568627451, 'rgb(224,246,71)'],
        [0.984313725490196, 'rgb(224,248,72)'],
        [0.9882352941176471, 'rgb(224,249,73)'],
        [0.9921568627450981, 'rgb(224,251,73)'],
        [0.996078431372549, 'rgb(225,252,74)'],
        [1.0, 'rgb(225,253,75)'],
    ],
    'cmo.speed': [
        [0.0, 'rgb(255,253,205)'],
        [0.00392156862745098, 'rgb(254,252,203)'],
        [0.00784313725490196, 'rgb(254,250,201)'],
        [0.011764705882352941, 'rgb(253,249,199)'],
        [0.01568627450980392, 'rgb(252,248,197)'],
        [0.0196078431372549, 'rgb(252,247,194)'],
        [0.023529411764705882, 'rgb(251,246,192)'],
        [0.027450980392156862, 'rgb(250,244,190)'],
        [0.03137254901960784, 'rgb(249,243,188)'],
        [0.03529411764705882, 'rgb(249,242,186)'],
        [0.0392156862745098, 'rgb(248,241,184)'],
        [0.043137254901960784, 'rgb(247,240,182)'],
        [0.047058823529411764, 'rgb(247,238,180)'],
        [0.050980392156862744, 'rgb(246,237,177)'],
        [0.054901960784313725, 'rgb(246,236,175)'],
        [0.058823529411764705, 'rgb(245,235,173)'],
        [0.06274509803921569, 'rgb(244,234,171)'],
        [0.06666666666666667, 'rgb(243,233,169)'],
        [0.07058823529411765, 'rgb(243,231,167)'],
        [0.07450980392156863, 'rgb(242,230,165)'],
        [0.0784313725490196, 'rgb(241,229,162)'],
        [0.08235294117647059, 'rgb(241,228,160)'],
        [0.08627450980392157, 'rgb(240,227,158)'],
        [0.09019607843137255, 'rgb(239,226,156)'],
        [0.09411764705882353, 'rgb(239,225,154)'],
        [0.09803921568627451, 'rgb(238,223,152)'],
        [0.10196078431372549, 'rgb(237,222,150)'],
        [0.10588235294117647, 'rgb(237,221,147)'],
        [0.10980392156862745, 'rgb(236,220,145)'],
        [0.11372549019607843, 'rgb(235,219,143)'],
        [0.11764705882352941, 'rgb(234,218,141)'],
        [0.12156862745098039, 'rgb(234,217,139)'],
        [0.12549019607843137, 'rgb(233,216,137)'],
        [0.12941176470588237, 'rgb(232,215,134)'],
        [0.13333333333333333, 'rgb(231,214,132)'],
        [0.13725490196078433, 'rgb(231,213,130)'],
        [0.1411764705882353, 'rgb(230,212,128)'],
        [0.1450980392156863, 'rgb(229,211,126)'],
        [0.14901960784313725, 'rgb(228,210,123)'],
        [0.15294117647058825, 'rgb(227,208,121)'],
        [0.1568627450980392, 'rgb(227,207,119)'],
        [0.1607843137254902, 'rgb(226,206,117)'],
        [0.16470588235294117, 'rgb(225,205,115)'],
        [0.16862745098039217, 'rgb(224,205,113)'],
        [0.17254901960784313, 'rgb(223,204,110)'],
        [0.17647058823529413, 'rgb(222,203,108)'],
        [0.1803921568627451, 'rgb(221,202,106)'],
        [0.1843137254901961, 'rgb(220,201,104)'],
        [0.18823529411764706, 'rgb(219,200,102)'],
        [0.19215686274509805, 'rgb(218,199,100)'],
        [0.19607843137254902, 'rgb(217,198,97)'],
        [0.2, 'rgb(216,197,95)'],
        [0.20392156862745098, 'rgb(215,196,93)'],
        [0.20784313725490197, 'rgb(214,195,91)'],
        [0.21176470588235294, 'rgb(213,194,89)'],
        [0.21568627450980393, 'rgb(212,193,87)'],
        [0.2196078431372549, 'rgb(211,193,85)'],
        [0.2235294117647059, 'rgb(210,192,83)'],
        [0.22745098039215686, 'rgb(209,191,81)'],
        [0.23137254901960785, 'rgb(208,190,79)'],
        [0.23529411764705882, 'rgb(206,189,76)'],
        [0.23921568627450981, 'rgb(205,189,74)'],
        [0.24313725490196078, 'rgb(204,188,72)'],
        [0.24705882352941178, 'rgb(203,187,70)'],
        [0.25098039215686274, 'rgb(201,186,69)'],
        [0.2549019607843137, 'rgb(200,185,67)'],
        [0.25882352941176473, 'rgb(199,185,65)'],
        [0.2627450980392157, 'rgb(197,184,63)'],
        [0.26666666666666666, 'rgb(196,183,61)'],
        [0.27058823529411763, 'rgb(195,183,59)'],
        [0.27450980392156865, 'rgb(193,182,57)'],
        [0.2784313725490196, 'rgb(192,181,55)'],
        [0.2823529411764706, 'rgb(190,180,54)'],
        [0.28627450980392155, 'rgb(189,180,52)'],
        [0.2901960784313726, 'rgb(187,179,50)'],
        [0.29411764705882354, 'rgb(186,178,48)'],
        [0.2980392156862745, 'rgb(184,178,47)'],
        [0.30196078431372547, 'rgb(183,177,45)'],
        [0.3058823529411765, 'rgb(181,176,43)'],
        [0.30980392156862746, 'rgb(180,176,42)'],
        [0.3137254901960784, 'rgb(178,175,40)'],
        [0.3176470588235294, 'rgb(177,174,39)'],
        [0.3215686274509804, 'rgb(175,174,37)'],
        [0.3254901960784314, 'rgb(173,173,35)'],
        [0.32941176470588235, 'rgb(172,173,34)'],
        [0.3333333333333333, 'rgb(170,172,32)'],
        [0.33725490196078434, 'rgb(169,171,31)'],
        [0.3411764705882353, 'rgb(167,171,30)'],
        [0.34509803921568627, 'rgb(165,170,28)'],
        [0.34901960784313724, 'rgb(164,169,27)'],
        [0.35294117647058826, 'rgb(162,169,25)'],
        [0.3568627450980392, 'rgb(160,168,24)'],
        [0.3607843137254902, 'rgb(159,168,23)'],
        [0.36470588235294116, 'rgb(157,167,21)'],
        [0.3686274509803922, 'rgb(155,166,20)'],
        [0.37254901960784315, 'rgb(154,166,19)'],
        [0.3764705882352941, 'rgb(152,165,18)'],
        [0.3803921568627451, 'rgb(150,165,16)'],
        [0.3843137254901961, 'rgb(149,164,15)'],
        [0.38823529411764707, 'rgb(147,163,14)'],
        [0.39215686274509803, 'rgb(145,163,13)'],
        [0.396078431372549, 'rgb(143,162,12)'],
        [0.4, 'rgb(142,162,11)'],
        [0.403921568627451, 'rgb(140,161,10)'],
        [0.40784313725490196, 'rgb(138,160,9)'],
        [0.4117647058823529, 'rgb(136,160,8)'],
        [0.41568627450980394, 'rgb(135,159,8)'],
        [0.4196078431372549, 'rgb(133,159,7)'],
        [0.4235294117647059, 'rgb(131,158,7)'],
        [0.42745098039215684, 'rgb(129,157,6)'],
        [0.43137254901960786, 'rgb(128,157,6)'],
        [0.43529411764705883, 'rgb(126,156,6)'],
        [0.4392156862745098, 'rgb(124,156,6)'],
        [0.44313725490196076, 'rgb(122,155,6)'],
        [0.4470588235294118, 'rgb(121,154,6)'],
        [0.45098039215686275, 'rgb(119,154,6)'],
        [0.4549019607843137, 'rgb(117,153,6)'],
        [0.4588235294117647, 'rgb(115,153,6)'],
        [0.4627450980392157, 'rgb(113,152,6)'],
        [0.4666666666666667, 'rgb(112,151,7)'],
        [0.47058823529411764, 'rgb(110,151,7)'],
        [0.4745098039215686, 'rgb(108,150,7)'],
        [0.47843137254901963, 'rgb(106,149,8)'],
        [0.4823529411764706, 'rgb(104,149,9)'],
        [0.48627450980392156, 'rgb(102,148,9)'],
        [0.49019607843137253, 'rgb(101,148,10)'],
        [0.49411764705882355, 'rgb(99,147,11)'],
        [0.4980392156862745, 'rgb(97,146,11)'],
        [0.5019607843137255, 'rgb(95,146,12)'],
        [0.5058823529411764, 'rgb(93,145,13)'],
        [0.5098039215686274, 'rgb(92,144,14)'],
        [0.5137254901960784, 'rgb(90,144,15)'],
        [0.5176470588235295, 'rgb(88,143,15)'],
        [0.5215686274509804, 'rgb(86,142,16)'],
        [0.5254901960784314, 'rgb(84,142,17)'],
        [0.5294117647058824, 'rgb(82,141,18)'],
        [0.5333333333333333, 'rgb(81,140,18)'],
        [0.5372549019607843, 'rgb(79,140,19)'],
        [0.5411764705882353, 'rgb(77,139,20)'],
        [0.5450980392156862, 'rgb(75,138,21)'],
        [0.5490196078431373, 'rgb(73,138,22)'],
        [0.5529411764705883, 'rgb(72,137,22)'],
        [0.5568627450980392, 'rgb(70,136,23)'],
        [0.5607843137254902, 'rgb(68,136,24)'],
        [0.5647058823529412, 'rgb(66,135,25)'],
        [0.5686274509803921, 'rgb(64,134,25)'],
        [0.5725490196078431, 'rgb(63,133,26)'],
        [0.5764705882352941, 'rgb(61,133,27)'],
        [0.5803921568627451, 'rgb(59,132,28)'],
        [0.5843137254901961, 'rgb(57,131,28)'],
        [0.5882352941176471, 'rgb(56,131,29)'],
        [0.592156862745098, 'rgb(54,130,30)'],
        [0.596078431372549, 'rgb(52,129,30)'],
        [0.6, 'rgb(50,128,31)'],
        [0.6039215686274509, 'rgb(49,127,32)'],
        [0.6078431372549019, 'rgb(47,127,32)'],
        [0.611764705882353, 'rgb(45,126,33)'],
        [0.615686274509804, 'rgb(44,125,33)'],
        [0.6196078431372549, 'rgb(42,124,34)'],
        [0.6235294117647059, 'rgb(40,124,35)'],
        [0.6274509803921569, 'rgb(39,123,35)'],
        [0.6313725490196078, 'rgb(37,122,36)'],
        [0.6352941176470588, 'rgb(36,121,36)'],
        [0.6392156862745098, 'rgb(34,120,37)'],
        [0.6431372549019608, 'rgb(33,120,37)'],
        [0.6470588235294118, 'rgb(31,119,38)'],
        [0.6509803921568628, 'rgb(30,118,38)'],
        [0.6549019607843137, 'rgb(28,117,39)'],
        [0.6588235294117647, 'rgb(27,116,39)'],
        [0.6627450980392157, 'rgb(26,115,39)'],
        [0.6666666666666666, 'rgb(24,115,40)'],
        [0.6705882352941176, 'rgb(23,114,40)'],
        [0.6745098039215687, 'rgb(22,113,41)'],
        [0.6784313725490196, 'rgb(21,112,41)'],
        [0.6823529411764706, 'rgb(19,111,41)'],
        [0.6862745098039216, 'rgb(18,110,42)'],
        [0.6901960784313725, 'rgb(17,109,42)'],
        [0.6941176470588235, 'rgb(16,108,42)'],
        [0.6980392156862745, 'rgb(15,108,43)'],
        [0.7019607843137254, 'rgb(15,107,43)'],
        [0.7058823529411765, 'rgb(14,106,43)'],
        [0.7098039215686275, 'rgb(13,105,43)'],
        [0.7137254901960784, 'rgb(13,104,43)'],
        [0.7176470588235294, 'rgb(12,103,44)'],
        [0.7215686274509804, 'rgb(12,102,44)'],
        [0.7254901960784313, 'rgb(11,101,44)'],
        [0.7294117647058823, 'rgb(11,100,44)'],
        [0.7333333333333333, 'rgb(11,99,44)'],
        [0.7372549019607844, 'rgb(11,99,44)'],
        [0.7411764705882353, 'rgb(11,98,45)'],
        [0.7450980392156863, 'rgb(11,97,45)'],
        [0.7490196078431373, 'rgb(11,96,45)'],
        [0.7529411764705882, 'rgb(11,95,45)'],
        [0.7568627450980392, 'rgb(11,94,45)'],
        [0.7607843137254902, 'rgb(12,93,45)'],
        [0.7647058823529411, 'rgb(12,92,45)'],
        [0.7686274509803922, 'rgb(12,91,45)'],
        [0.7725490196078432, 'rgb(13,90,45)'],
        [0.7764705882352941, 'rgb(13,89,45)'],
        [0.7803921568627451, 'rgb(14,88,45)'],
        [0.7843137254901961, 'rgb(14,87,45)'],
        [0.788235294117647, 'rgb(15,86,44)'],
        [0.792156862745098, 'rgb(15,85,44)'],
        [0.796078431372549, 'rgb(16,84,44)'],
        [0.8, 'rgb(16,84,44)'],
        [0.803921568627451, 'rgb(16,83,44)'],
        [0.807843137254902, 'rgb(17,82,44)'],
        [0.8117647058823529, 'rgb(17,81,44)'],
        [0.8156862745098039, 'rgb(18,80,43)'],
        [0.8196078431372549, 'rgb(18,79,43)'],
        [0.8235294117647058, 'rgb(19,78,43)'],
        [0.8274509803921568, 'rgb(19,77,43)'],
        [0.8313725490196079, 'rgb(20,76,42)'],
        [0.8352941176470589, 'rgb(20,75,42)'],
        [0.8392156862745098, 'rgb(20,74,42)'],
        [0.8431372549019608, 'rgb(21,73,42)'],
        [0.8470588235294118, 'rgb(21,72,41)'],
        [0.8509803921568627, 'rgb(22,71,41)'],
        [0.8549019607843137, 'rgb(22,70,41)'],
        [0.8588235294117647, 'rgb(22,69,40)'],
        [0.8627450980392157, 'rgb(23,68,40)'],
        [0.8666666666666667, 'rgb(23,67,39)'],
        [0.8705882352941177, 'rgb(23,66,39)'],
        [0.8745098039215686, 'rgb(23,65,39)'],
        [0.8784313725490196, 'rgb(24,64,38)'],
        [0.8823529411764706, 'rgb(24,63,38)'],
        [0.8862745098039215, 'rgb(24,63,37)'],
        [0.8901960784313725, 'rgb(24,62,37)'],
        [0.8941176470588236, 'rgb(25,61,36)'],
        [0.8980392156862745, 'rgb(25,60,36)'],
        [0.9019607843137255, 'rgb(25,59,35)'],
        [0.9058823529411765, 'rgb(25,58,35)'],
        [0.9098039215686274, 'rgb(25,57,34)'],
        [0.9137254901960784, 'rgb(25,56,34)'],
        [0.9176470588235294, 'rgb(25,55,33)'],
        [0.9215686274509803, 'rgb(25,54,33)'],
        [0.9254901960784314, 'rgb(25,53,32)'],
        [0.9294117647058824, 'rgb(25,52,31)'],
        [0.9333333333333333, 'rgb(25,51,31)'],
        [0.9372549019607843, 'rgb(25,50,30)'],
        [0.9411764705882353, 'rgb(25,49,30)'],
        [0.9450980392156862, 'rgb(25,48,29)'],
        [0.9490196078431372, 'rgb(25,47,28)'],
        [0.9529411764705882, 'rgb(25,46,28)'],
        [0.9568627450980393, 'rgb(25,45,27)'],
        [0.9607843137254902, 'rgb(25,44,26)'],
        [0.9647058823529412, 'rgb(25,44,25)'],
        [0.9686274509803922, 'rgb(25,43,25)'],
        [0.9725490196078431, 'rgb(25,42,24)'],
        [0.9764705882352941, 'rgb(24,41,23)'],
        [0.9803921568627451, 'rgb(24,40,23)'],
        [0.984313725490196, 'rgb(24,39,22)'],
        [0.9882352941176471, 'rgb(24,38,21)'],
        [0.9921568627450981, 'rgb(24,37,20)'],
        [0.996078431372549, 'rgb(23,36,19)'],
        [1.0, 'rgb(23,35,19)'],
    ],
    'cmo.tarn': [
        [0.0, 'rgb(23,35,14)'],
        [0.00392156862745098, 'rgb(24,37,14)'],
        [0.00784313725490196, 'rgb(25,39,14)'],
        [0.011764705882352941, 'rgb(27,41,15)'],
        [0.01568627450980392, 'rgb(28,42,15)'],
        [0.0196078431372549, 'rgb(29,44,15)'],
        [0.023529411764705882, 'rgb(31,46,16)'],
        [0.027450980392156862, 'rgb(32,48,16)'],
        [0.03137254901960784, 'rgb(33,49,16)'],
        [0.03529411764705882, 'rgb(34,51,16)'],
        [0.0392156862745098, 'rgb(35,53,16)'],
        [0.043137254901960784, 'rgb(37,55,16)'],
        [0.047058823529411764, 'rgb(38,56,16)'],
        [0.050980392156862744, 'rgb(39,58,16)'],
        [0.054901960784313725, 'rgb(40,60,16)'],
        [0.058823529411764705, 'rgb(42,61,16)'],
        [0.06274509803921569, 'rgb(43,63,15)'],
        [0.06666666666666667, 'rgb(44,65,15)'],
        [0.07058823529411765, 'rgb(46,66,15)'],
        [0.07450980392156863, 'rgb(47,68,14)'],
        [0.0784313725490196, 'rgb(48,70,14)'],
        [0.08235294117647059, 'rgb(50,71,13)'],
        [0.08627450980392157, 'rgb(52,73,12)'],
        [0.09019607843137255, 'rgb(54,74,12)'],
        [0.09411764705882353, 'rgb(57,75,12)'],
        [0.09803921568627451, 'rgb(60,77,13)'],
        [0.10196078431372549, 'rgb(63,78,14)'],
        [0.10588235294117647, 'rgb(66,79,15)'],
        [0.10980392156862745, 'rgb(68,80,16)'],
        [0.11372549019607843, 'rgb(71,81,17)'],
        [0.11764705882352941, 'rgb(74,83,18)'],
        [0.12156862745098039, 'rgb(77,84,19)'],
        [0.12549019607843137, 'rgb(79,85,20)'],
        [0.12941176470588237, 'rgb(82,86,21)'],
        [0.13333333333333333, 'rgb(85,87,22)'],
        [0.13725490196078433, 'rgb(87,88,23)'],
        [0.1411764705882353, 'rgb(90,89,24)'],
        [0.1450980392156863, 'rgb(93,91,25)'],
        [0.14901960784313725, 'rgb(96,92,26)'],
        [0.15294117647058825, 'rgb(98,93,26)'],
        [0.1568627450980392, 'rgb(101,94,27)'],
        [0.1607843137254902, 'rgb(104,95,28)'],
        [0.16470588235294117, 'rgb(107,96,29)'],
        [0.16862745098039217, 'rgb(109,97,30)'],
        [0.17254901960784313, 'rgb(112,98,31)'],
        [0.17647058823529413, 'rgb(115,99,32)'],
        [0.1803921568627451, 'rgb(118,100,33)'],
        [0.1843137254901961, 'rgb(120,102,33)'],
        [0.18823529411764706, 'rgb(123,103,34)'],
        [0.19215686274509805, 'rgb(126,104,35)'],
        [0.19607843137254902, 'rgb(129,105,36)'],
        [0.2, 'rgb(132,106,37)'],
        [0.20392156862745098, 'rgb(134,107,38)'],
        [0.20784313725490197, 'rgb(137,108,39)'],
        [0.21176470588235294, 'rgb(140,109,39)'],
        [0.21568627450980393, 'rgb(143,110,40)'],
        [0.2196078431372549, 'rgb(146,111,41)'],
        [0.2235294117647059, 'rgb(149,112,42)'],
        [0.22745098039215686, 'rgb(152,113,43)'],
        [0.23137254901960785, 'rgb(155,114,44)'],
        [0.23529411764705882, 'rgb(158,115,45)'],
        [0.23921568627450981, 'rgb(160,116,46)'],
        [0.24313725490196078, 'rgb(163,117,47)'],
        [0.24705882352941178, 'rgb(166,118,48)'],
        [0.25098039215686274, 'rgb(169,119,49)'],
        [0.2549019607843137, 'rgb(172,120,50)'],
        [0.25882352941176473, 'rgb(175,121,51)'],
        [0.2627450980392157, 'rgb(178,122,53)'],
        [0.26666666666666666, 'rgb(181,123,54)'],
        [0.27058823529411763, 'rgb(184,124,55)'],
        [0.27450980392156865, 'rgb(187,125,57)'],
        [0.2784313725490196, 'rgb(190,126,58)'],
        [0.2823529411764706, 'rgb(193,127,60)'],
        [0.28627450980392155, 'rgb(196,128,62)'],
        [0.2901960784313726, 'rgb(198,129,65)'],
        [0.29411764705882354, 'rgb(201,130,68)'],
        [0.2980392156862745, 'rgb(203,132,72)'],
        [0.30196078431372547, 'rgb(204,134,76)'],
        [0.3058823529411765, 'rgb(205,136,79)'],
        [0.30980392156862746, 'rgb(206,138,83)'],
        [0.3137254901960784, 'rgb(207,140,87)'],
        [0.3176470588235294, 'rgb(208,143,90)'],
        [0.3215686274509804, 'rgb(209,145,93)'],
        [0.3254901960784314, 'rgb(210,147,97)'],
        [0.32941176470588235, 'rgb(210,150,100)'],
        [0.3333333333333333, 'rgb(211,152,104)'],
        [0.33725490196078434, 'rgb(212,154,107)'],
        [0.3411764705882353, 'rgb(213,156,111)'],
        [0.34509803921568627, 'rgb(214,159,114)'],
        [0.34901960784313724, 'rgb(215,161,117)'],
        [0.35294117647058826, 'rgb(216,163,121)'],
        [0.3568627450980392, 'rgb(217,166,124)'],
        [0.3607843137254902, 'rgb(218,168,128)'],
        [0.36470588235294116, 'rgb(219,170,131)'],
        [0.3686274509803922, 'rgb(219,173,135)'],
        [0.37254901960784315, 'rgb(220,175,138)'],
        [0.3764705882352941, 'rgb(221,177,142)'],
        [0.3803921568627451, 'rgb(222,179,145)'],
        [0.3843137254901961, 'rgb(223,182,149)'],
        [0.38823529411764707, 'rgb(224,184,152)'],
        [0.39215686274509803, 'rgb(225,186,156)'],
        [0.396078431372549, 'rgb(226,189,159)'],
        [0.4, 'rgb(227,191,163)'],
        [0.403921568627451, 'rgb(228,193,166)'],
        [0.40784313725490196, 'rgb(229,196,170)'],
        [0.4117647058823529, 'rgb(230,198,173)'],
        [0.41568627450980394, 'rgb(231,200,177)'],
        [0.4196078431372549, 'rgb(232,203,180)'],
        [0.4235294117647059, 'rgb(233,205,184)'],
        [0.42745098039215684, 'rgb(234,208,187)'],
        [0.43137254901960786, 'rgb(235,210,191)'],
        [0.43529411764705883, 'rgb(236,212,194)'],
        [0.4392156862745098, 'rgb(237,215,198)'],
        [0.44313725490196076, 'rgb(239,217,201)'],
        [0.4470588235294118, 'rgb(240,219,205)'],
        [0.45098039215686275, 'rgb(241,222,209)'],
        [0.4549019607843137, 'rgb(242,224,212)'],
        [0.4588235294117647, 'rgb(243,227,216)'],
        [0.4627450980392157, 'rgb(244,229,219)'],
        [0.4666666666666667, 'rgb(246,232,223)'],
        [0.47058823529411764, 'rgb(247,234,226)'],
        [0.4745098039215686, 'rgb(248,236,229)'],
        [0.47843137254901963, 'rgb(249,239,233)'],
        [0.4823529411764706, 'rgb(250,241,236)'],
        [0.48627450980392156, 'rgb(251,243,239)'],
        [0.49019607843137253, 'rgb(252,245,242)'],
        [0.49411764705882355, 'rgb(252,246,244)'],
        [0.4980392156862745, 'rgb(252,247,246)'],
        [0.5019607843137255, 'rgb(252,247,246)'],
        [0.5058823529411764, 'rgb(252,247,245)'],
        [0.5098039215686274, 'rgb(251,246,243)'],
        [0.5137254901960784, 'rgb(251,245,240)'],
        [0.5176470588235295, 'rgb(249,244,237)'],
        [0.5215686274509804, 'rgb(248,242,234)'],
        [0.5254901960784314, 'rgb(246,240,231)'],
        [0.5294117647058824, 'rgb(244,238,227)'],
        [0.5333333333333333, 'rgb(242,236,224)'],
        [0.5372549019607843, 'rgb(240,234,220)'],
        [0.5411764705882353, 'rgb(239,232,216)'],
        [0.5450980392156862, 'rgb(237,230,213)'],
        [0.5490196078431373, 'rgb(235,228,209)'],
        [0.5529411764705883, 'rgb(233,226,205)'],
        [0.5568627450980392, 'rgb(231,223,202)'],
        [0.5607843137254902, 'rgb(229,221,198)'],
        [0.5647058823529412, 'rgb(227,219,194)'],
        [0.5686274509803921, 'rgb(225,217,191)'],
        [0.5725490196078431, 'rgb(223,215,187)'],
        [0.5764705882352941, 'rgb(221,214,184)'],
        [0.5803921568627451, 'rgb(218,212,180)'],
        [0.5843137254901961, 'rgb(215,210,178)'],
        [0.5882352941176471, 'rgb(212,209,175)'],
        [0.592156862745098, 'rgb(209,207,173)'],
        [0.596078431372549, 'rgb(206,206,171)'],
        [0.6, 'rgb(203,204,170)'],
        [0.6039215686274509, 'rgb(199,203,168)'],
        [0.6078431372549019, 'rgb(196,201,167)'],
        [0.611764705882353, 'rgb(193,200,166)'],
        [0.615686274509804, 'rgb(190,198,165)'],
        [0.6196078431372549, 'rgb(186,196,164)'],
        [0.6235294117647059, 'rgb(183,195,163)'],
        [0.6274509803921569, 'rgb(180,193,162)'],
        [0.6313725490196078, 'rgb(177,192,161)'],
        [0.6352941176470588, 'rgb(174,190,160)'],
        [0.6392156862745098, 'rgb(171,189,159)'],
        [0.6431372549019608, 'rgb(168,187,158)'],
        [0.6470588235294118, 'rgb(165,185,157)'],
        [0.6509803921568628, 'rgb(162,184,156)'],
        [0.6549019607843137, 'rgb(159,182,155)'],
        [0.6588235294117647, 'rgb(156,181,154)'],
        [0.6627450980392157, 'rgb(153,179,153)'],
        [0.6666666666666666, 'rgb(151,178,152)'],
        [0.6705882352941176, 'rgb(148,176,151)'],
        [0.6745098039215687, 'rgb(145,174,150)'],
        [0.6784313725490196, 'rgb(142,173,149)'],
        [0.6823529411764706, 'rgb(139,171,148)'],
        [0.6862745098039216, 'rgb(136,170,147)'],
        [0.6901960784313725, 'rgb(133,168,146)'],
        [0.6941176470588235, 'rgb(130,167,146)'],
        [0.6980392156862745, 'rgb(127,165,145)'],
        [0.7019607843137254, 'rgb(124,164,144)'],
        [0.7058823529411765, 'rgb(121,162,143)'],
        [0.7098039215686275, 'rgb(118,161,142)'],
        [0.7137254901960784, 'rgb(115,159,141)'],
        [0.7176470588235294, 'rgb(112,158,140)'],
        [0.7215686274509804, 'rgb(109,156,139)'],
        [0.7254901960784313, 'rgb(106,155,138)'],
        [0.7294117647058823, 'rgb(103,154,137)'],
        [0.7333333333333333, 'rgb(100,152,137)'],
        [0.7372549019607844, 'rgb(97,151,136)'],
        [0.7411764705882353, 'rgb(94,149,135)'],
        [0.7450980392156863, 'rgb(90,148,134)'],
        [0.7490196078431373, 'rgb(87,146,133)'],
        [0.7529411764705882, 'rgb(84,145,133)'],
        [0.7568627450980392, 'rgb(81,143,132)'],
        [0.7607843137254902, 'rgb(78,142,131)'],
        [0.7647058823529411, 'rgb(74,140,131)'],
        [0.7686274509803922, 'rgb(71,139,130)'],
        [0.7725490196078432, 'rgb(68,137,130)'],
        [0.7764705882352941, 'rgb(65,136,129)'],
        [0.7803921568627451, 'rgb(61,134,128)'],
        [0.7843137254901961, 'rgb(58,133,128)'],
        [0.788235294117647, 'rgb(55,131,127)'],
        [0.792156862745098, 'rgb(52,129,127)'],
        [0.796078431372549, 'rgb(49,128,126)'],
        [0.8, 'rgb(46,126,126)'],
        [0.803921568627451, 'rgb(44,124,125)'],
        [0.807843137254902, 'rgb(42,123,125)'],
        [0.8117647058823529, 'rgb(39,121,124)'],
        [0.8156862745098039, 'rgb(37,119,124)'],
        [0.8196078431372549, 'rgb(36,117,123)'],
        [0.8235294117647058, 'rgb(34,116,122)'],
        [0.8274509803921568, 'rgb(33,114,122)'],
        [0.8313725490196079, 'rgb(32,112,121)'],
        [0.8352941176470589, 'rgb(32,110,120)'],
        [0.8392156862745098, 'rgb(31,108,119)'],
        [0.8431372549019608, 'rgb(31,106,118)'],
        [0.8470588235294118, 'rgb(30,105,118)'],
        [0.8509803921568627, 'rgb(30,103,117)'],
        [0.8549019607843137, 'rgb(29,101,116)'],
        [0.8588235294117647, 'rgb(29,99,115)'],
        [0.8627450980392157, 'rgb(28,97,114)'],
        [0.8666666666666667, 'rgb(28,95,113)'],
        [0.8705882352941177, 'rgb(27,93,112)'],
        [0.8745098039215686, 'rgb(26,92,111)'],
        [0.8784313725490196, 'rgb(26,90,111)'],
        [0.8823529411764706, 'rgb(25,88,110)'],
        [0.8862745098039215, 'rgb(24,86,109)'],
        [0.8901960784313725, 'rgb(24,84,108)'],
        [0.8941176470588236, 'rgb(23,83,107)'],
        [0.8980392156862745, 'rgb(22,81,107)'],
        [0.9019607843137255, 'rgb(21,79,106)'],
        [0.9058823529411765, 'rgb(20,77,105)'],
        [0.9098039215686274, 'rgb(19,75,104)'],
        [0.9137254901960784, 'rgb(18,73,104)'],
        [0.9176470588235294, 'rgb(17,72,103)'],
        [0.9215686274509803, 'rgb(16,70,102)'],
        [0.9254901960784314, 'rgb(16,68,101)'],
        [0.9294117647058824, 'rgb(15,66,101)'],
        [0.9333333333333333, 'rgb(14,64,100)'],
        [0.9372549019607843, 'rgb(13,62,99)'],
        [0.9411764705882353, 'rgb(12,60,99)'],
        [0.9450980392156862, 'rgb(11,59,98)'],
        [0.9490196078431372, 'rgb(10,57,98)'],
        [0.9529411764705882, 'rgb(9,55,97)'],
        [0.9568627450980393, 'rgb(9,53,96)'],
        [0.9607843137254902, 'rgb(9,51,96)'],
        [0.9647058823529412, 'rgb(9,49,95)'],
        [0.9686274509803922, 'rgb(10,47,94)'],
        [0.9725490196078431, 'rgb(11,45,93)'],
        [0.9764705882352941, 'rgb(12,42,91)'],
        [0.9803921568627451, 'rgb(13,40,89)'],
        [0.984313725490196, 'rgb(14,38,88)'],
        [0.9882352941176471, 'rgb(14,36,86)'],
        [0.9921568627450981, 'rgb(15,34,84)'],
        [0.996078431372549, 'rgb(15,32,82)'],
        [1.0, 'rgb(16,30,79)'],
    ],
    'cmo.tempo': [
        [0.0, 'rgb(255,246,244)'],
        [0.00392156862745098, 'rgb(253,245,243)'],
        [0.00784313725490196, 'rgb(252,244,241)'],
        [0.011764705882352941, 'rgb(251,243,240)'],
        [0.01568627450980392, 'rgb(249,242,238)'],
        [0.0196078431372549, 'rgb(248,241,237)'],
        [0.023529411764705882, 'rgb(247,240,235)'],
        [0.027450980392156862, 'rgb(245,239,234)'],
        [0.03137254901960784, 'rgb(244,238,232)'],
        [0.03529411764705882, 'rgb(242,237,231)'],
        [0.0392156862745098, 'rgb(241,236,229)'],
        [0.043137254901960784, 'rgb(240,235,228)'],
        [0.047058823529411764, 'rgb(238,234,226)'],
        [0.050980392156862744, 'rgb(237,234,225)'],
        [0.054901960784313725, 'rgb(235,233,223)'],
        [0.058823529411764705, 'rgb(234,232,222)'],
        [0.06274509803921569, 'rgb(233,231,221)'],
        [0.06666666666666667, 'rgb(231,230,219)'],
        [0.07058823529411765, 'rgb(230,229,218)'],
        [0.07450980392156863, 'rgb(228,228,216)'],
        [0.0784313725490196, 'rgb(227,227,215)'],
        [0.08235294117647059, 'rgb(226,226,214)'],
        [0.08627450980392157, 'rgb(224,226,212)'],
        [0.09019607843137255, 'rgb(223,225,211)'],
        [0.09411764705882353, 'rgb(221,224,209)'],
        [0.09803921568627451, 'rgb(220,223,208)'],
        [0.10196078431372549, 'rgb(219,222,207)'],
        [0.10588235294117647, 'rgb(217,221,205)'],
        [0.10980392156862745, 'rgb(216,221,204)'],
        [0.11372549019607843, 'rgb(214,220,203)'],
        [0.11764705882352941, 'rgb(213,219,201)'],
        [0.12156862745098039, 'rgb(211,218,200)'],
        [0.12549019607843137, 'rgb(210,217,199)'],
        [0.12941176470588237, 'rgb(209,216,197)'],
        [0.13333333333333333, 'rgb(207,216,196)'],
        [0.13725490196078433, 'rgb(206,215,195)'],
        [0.1411764705882353, 'rgb(204,214,193)'],
        [0.1450980392156863, 'rgb(203,213,192)'],
        [0.14901960784313725, 'rgb(201,212,191)'],
        [0.15294117647058825, 'rgb(200,212,190)'],
        [0.1568627450980392, 'rgb(198,211,188)'],
        [0.1607843137254902, 'rgb(197,210,187)'],
        [0.16470588235294117, 'rgb(195,209,186)'],
        [0.16862745098039217, 'rgb(194,209,185)'],
        [0.17254901960784313, 'rgb(192,208,183)'],
        [0.17647058823529413, 'rgb(191,207,182)'],
        [0.1803921568627451, 'rgb(189,206,181)'],
        [0.1843137254901961, 'rgb(188,206,180)'],
        [0.18823529411764706, 'rgb(186,205,179)'],
        [0.19215686274509805, 'rgb(185,204,178)'],
        [0.19607843137254902, 'rgb(183,203,176)'],
        [0.2, 'rgb(182,203,175)'],
        [0.20392156862745098, 'rgb(180,202,174)'],
        [0.20784313725490197, 'rgb(179,201,173)'],
        [0.21176470588235294, 'rgb(177,200,172)'],
        [0.21568627450980393, 'rgb(176,200,171)'],
        [0.2196078431372549, 'rgb(174,199,170)'],
        [0.2235294117647059, 'rgb(172,198,169)'],
        [0.22745098039215686, 'rgb(171,197,168)'],
        [0.23137254901960785, 'rgb(169,197,166)'],
        [0.23529411764705882, 'rgb(168,196,165)'],
        [0.23921568627450981, 'rgb(166,195,164)'],
        [0.24313725490196078, 'rgb(164,195,163)'],
        [0.24705882352941178, 'rgb(163,194,162)'],
        [0.25098039215686274, 'rgb(161,193,161)'],
        [0.2549019607843137, 'rgb(160,192,160)'],
        [0.25882352941176473, 'rgb(158,192,159)'],
        [0.2627450980392157, 'rgb(156,191,159)'],
        [0.26666666666666666, 'rgb(155,190,158)'],
        [0.27058823529411763, 'rgb(153,190,157)'],
        [0.27450980392156865, 'rgb(151,189,156)'],
        [0.2784313725490196, 'rgb(150,188,155)'],
        [0.2823529411764706, 'rgb(148,188,154)'],
        [0.28627450980392155, 'rgb(146,187,153)'],
        [0.2901960784313726, 'rgb(145,186,152)'],
        [0.29411764705882354, 'rgb(143,186,151)'],
        [0.2980392156862745, 'rgb(141,185,151)'],
        [0.30196078431372547, 'rgb(139,184,150)'],
        [0.3058823529411765, 'rgb(138,183,149)'],
        [0.30980392156862746, 'rgb(136,183,148)'],
        [0.3137254901960784, 'rgb(134,182,147)'],
        [0.3176470588235294, 'rgb(133,181,147)'],
        [0.3215686274509804, 'rgb(131,181,146)'],
        [0.3254901960784314, 'rgb(129,180,145)'],
        [0.32941176470588235, 'rgb(127,179,144)'],
        [0.3333333333333333, 'rgb(125,179,144)'],
        [0.33725490196078434, 'rgb(124,178,143)'],
        [0.3411764705882353, 'rgb(122,177,142)'],
        [0.34509803921568627, 'rgb(120,177,142)'],
        [0.34901960784313724, 'rgb(118,176,141)'],
        [0.35294117647058826, 'rgb(116,175,141)'],
        [0.3568627450980392, 'rgb(114,175,140)'],
        [0.3607843137254902, 'rgb(113,174,139)'],
        [0.36470588235294116, 'rgb(111,173,139)'],
        [0.3686274509803922, 'rgb(109,173,138)'],
        [0.37254901960784315, 'rgb(107,172,138)'],
        [0.3764705882352941, 'rgb(105,171,137)'],
        [0.3803921568627451, 'rgb(103,171,137)'],
        [0.3843137254901961, 'rgb(101,170,136)'],
        [0.38823529411764707, 'rgb(99,169,136)'],
        [0.39215686274509803, 'rgb(97,169,135)'],
        [0.396078431372549, 'rgb(95,168,135)'],
        [0.4, 'rgb(93,167,134)'],
        [0.403921568627451, 'rgb(91,166,134)'],
        [0.40784313725490196, 'rgb(89,166,133)'],
        [0.4117647058823529, 'rgb(87,165,133)'],
        [0.41568627450980394, 'rgb(86,164,133)'],
        [0.4196078431372549, 'rgb(84,164,132)'],
        [0.4235294117647059, 'rgb(82,163,132)'],
        [0.42745098039215684, 'rgb(80,162,132)'],
        [0.43137254901960786, 'rgb(78,161,131)'],
        [0.43529411764705883, 'rgb(75,161,131)'],
        [0.4392156862745098, 'rgb(73,160,131)'],
        [0.44313725490196076, 'rgb(71,159,130)'],
        [0.4470588235294118, 'rgb(69,159,130)'],
        [0.45098039215686275, 'rgb(67,158,130)'],
        [0.4549019607843137, 'rgb(65,157,130)'],
        [0.4588235294117647, 'rgb(63,156,129)'],
        [0.4627450980392157, 'rgb(61,156,129)'],
        [0.4666666666666667, 'rgb(59,155,129)'],
        [0.47058823529411764, 'rgb(58,154,129)'],
        [0.4745098039215686, 'rgb(56,153,129)'],
        [0.47843137254901963, 'rgb(54,152,128)'],
        [0.4823529411764706, 'rgb(52,152,128)'],
        [0.48627450980392156, 'rgb(50,151,128)'],
        [0.49019607843137253, 'rgb(48,150,128)'],
        [0.49411764705882355, 'rgb(46,149,128)'],
        [0.4980392156862745, 'rgb(44,148,127)'],
        [0.5019607843137255, 'rgb(42,147,127)'],
        [0.5058823529411764, 'rgb(41,147,127)'],
        [0.5098039215686274, 'rgb(39,146,127)'],
        [0.5137254901960784, 'rgb(37,145,127)'],
        [0.5176470588235295, 'rgb(36,144,127)'],
        [0.5215686274509804, 'rgb(34,143,126)'],
        [0.5254901960784314, 'rgb(33,142,126)'],
        [0.5294117647058824, 'rgb(31,141,126)'],
        [0.5333333333333333, 'rgb(30,141,126)'],
        [0.5372549019607843, 'rgb(28,140,126)'],
        [0.5411764705882353, 'rgb(27,139,125)'],
        [0.5450980392156862, 'rgb(26,138,125)'],
        [0.5490196078431373, 'rgb(25,137,125)'],
        [0.5529411764705883, 'rgb(23,136,125)'],
        [0.5568627450980392, 'rgb(22,135,124)'],
        [0.5607843137254902, 'rgb(22,134,124)'],
        [0.5647058823529412, 'rgb(21,133,124)'],
        [0.5686274509803921, 'rgb(20,132,124)'],
        [0.5725490196078431, 'rgb(19,132,123)'],
        [0.5764705882352941, 'rgb(19,131,123)'],
        [0.5803921568627451, 'rgb(18,130,123)'],
        [0.5843137254901961, 'rgb(18,129,123)'],
        [0.5882352941176471, 'rgb(17,128,122)'],
        [0.592156862745098, 'rgb(17,127,122)'],
        [0.596078431372549, 'rgb(17,126,122)'],
        [0.6, 'rgb(17,125,121)'],
        [0.6039215686274509, 'rgb(17,124,121)'],
        [0.6078431372549019, 'rgb(17,123,121)'],
        [0.611764705882353, 'rgb(17,122,120)'],
        [0.615686274509804, 'rgb(17,121,120)'],
        [0.6196078431372549, 'rgb(17,120,120)'],
        [0.6235294117647059, 'rgb(17,119,119)'],
        [0.6274509803921569, 'rgb(17,118,119)'],
        [0.6313725490196078, 'rgb(18,118,118)'],
        [0.6352941176470588, 'rgb(18,117,118)'],
        [0.6392156862745098, 'rgb(18,116,118)'],
        [0.6431372549019608, 'rgb(19,115,117)'],
        [0.6470588235294118, 'rgb(19,114,117)'],
        [0.6509803921568628, 'rgb(19,113,116)'],
        [0.6549019607843137, 'rgb(20,112,116)'],
        [0.6588235294117647, 'rgb(20,111,115)'],
        [0.6627450980392157, 'rgb(20,110,115)'],
        [0.6666666666666666, 'rgb(21,109,115)'],
        [0.6705882352941176, 'rgb(21,108,114)'],
        [0.6745098039215687, 'rgb(22,107,114)'],
        [0.6784313725490196, 'rgb(22,106,113)'],
        [0.6823529411764706, 'rgb(22,105,113)'],
        [0.6862745098039216, 'rgb(23,104,112)'],
        [0.6901960784313725, 'rgb(23,103,112)'],
        [0.6941176470588235, 'rgb(23,102,111)'],
        [0.6980392156862745, 'rgb(24,101,111)'],
        [0.7019607843137254, 'rgb(24,101,110)'],
        [0.7058823529411765, 'rgb(24,100,110)'],
        [0.7098039215686275, 'rgb(25,99,109)'],
        [0.7137254901960784, 'rgb(25,98,109)'],
        [0.7176470588235294, 'rgb(25,97,108)'],
        [0.7215686274509804, 'rgb(25,96,108)'],
        [0.7254901960784313, 'rgb(26,95,107)'],
        [0.7294117647058823, 'rgb(26,94,107)'],
        [0.7333333333333333, 'rgb(26,93,106)'],
        [0.7372549019607844, 'rgb(26,92,106)'],
        [0.7411764705882353, 'rgb(26,91,105)'],
        [0.7450980392156863, 'rgb(27,90,104)'],
        [0.7490196078431373, 'rgb(27,89,104)'],
        [0.7529411764705882, 'rgb(27,88,103)'],
        [0.7568627450980392, 'rgb(27,88,103)'],
        [0.7607843137254902, 'rgb(27,87,102)'],
        [0.7647058823529411, 'rgb(27,86,102)'],
        [0.7686274509803922, 'rgb(28,85,101)'],
        [0.7725490196078432, 'rgb(28,84,101)'],
        [0.7764705882352941, 'rgb(28,83,100)'],
        [0.7803921568627451, 'rgb(28,82,99)'],
        [0.7843137254901961, 'rgb(28,81,99)'],
        [0.788235294117647, 'rgb(28,80,98)'],
        [0.792156862745098, 'rgb(28,79,98)'],
        [0.796078431372549, 'rgb(28,78,97)'],
        [0.8, 'rgb(28,77,97)'],
        [0.803921568627451, 'rgb(28,76,96)'],
        [0.807843137254902, 'rgb(28,76,95)'],
        [0.8117647058823529, 'rgb(28,75,95)'],
        [0.8156862745098039, 'rgb(28,74,94)'],
        [0.8196078431372549, 'rgb(28,73,94)'],
        [0.8235294117647058, 'rgb(28,72,93)'],
        [0.8274509803921568, 'rgb(28,71,93)'],
        [0.8313725490196079, 'rgb(28,70,92)'],
        [0.8352941176470589, 'rgb(28,69,91)'],
        [0.8392156862745098, 'rgb(28,68,91)'],
        [0.8431372549019608, 'rgb(28,67,90)'],
        [0.8470588235294118, 'rgb(28,66,90)'],
        [0.8509803921568627, 'rgb(28,66,89)'],
        [0.8549019607843137, 'rgb(28,65,88)'],
        [0.8588235294117647, 'rgb(28,64,88)'],
        [0.8627450980392157, 'rgb(27,63,87)'],
        [0.8666666666666667, 'rgb(27,62,87)'],
        [0.8705882352941177, 'rgb(27,61,86)'],
        [0.8745098039215686, 'rgb(27,60,86)'],
        [0.8784313725490196, 'rgb(27,59,85)'],
        [0.8823529411764706, 'rgb(27,58,84)'],
        [0.8862745098039215, 'rgb(27,57,84)'],
        [0.8901960784313725, 'rgb(27,56,83)'],
        [0.8941176470588236, 'rgb(26,55,83)'],
        [0.8980392156862745, 'rgb(26,54,82)'],
        [0.9019607843137255, 'rgb(26,54,81)'],
        [0.9058823529411765, 'rgb(26,53,81)'],
        [0.9098039215686274, 'rgb(26,52,80)'],
        [0.9137254901960784, 'rgb(26,51,80)'],
        [0.9176470588235294, 'rgb(25,50,79)'],
        [0.9215686274509803, 'rgb(25,49,79)'],
        [0.9254901960784314, 'rgb(25,48,78)'],
        [0.9294117647058824, 'rgb(25,47,77)'],
        [0.9333333333333333, 'rgb(25,46,77)'],
        [0.9372549019607843, 'rgb(24,45,76)'],
        [0.9411764705882353, 'rgb(24,44,76)'],
        [0.9450980392156862, 'rgb(24,43,75)'],
        [0.9490196078431372, 'rgb(24,42,75)'],
        [0.9529411764705882, 'rgb(24,41,74)'],
        [0.9568627450980393, 'rgb(23,40,74)'],
        [0.9607843137254902, 'rgb(23,39,73)'],
        [0.9647058823529412, 'rgb(23,38,72)'],
        [0.9686274509803922, 'rgb(23,37,72)'],
        [0.9725490196078431, 'rgb(23,36,71)'],
        [0.9764705882352941, 'rgb(22,35,71)'],
        [0.9803921568627451, 'rgb(22,34,70)'],
        [0.984313725490196, 'rgb(22,33,70)'],
        [0.9882352941176471, 'rgb(22,32,69)'],
        [0.9921568627450981, 'rgb(21,31,69)'],
        [0.996078431372549, 'rgb(21,30,68)'],
        [1.0, 'rgb(21,29,68)'],
    ],
    'cmo.thermal': [
        [0.0, 'rgb(4,35,51)'],
        [0.00392156862745098, 'rgb(4,36,53)'],
        [0.00784313725490196, 'rgb(4,37,55)'],
        [0.011764705882352941, 'rgb(4,37,57)'],
        [0.01568627450980392, 'rgb(5,38,59)'],
        [0.0196078431372549, 'rgb(5,39,61)'],
        [0.023529411764705882, 'rgb(5,39,63)'],
        [0.027450980392156862, 'rgb(5,40,65)'],
        [0.03137254901960784, 'rgb(5,41,67)'],
        [0.03529411764705882, 'rgb(6,41,69)'],
        [0.0392156862745098, 'rgb(6,42,71)'],
        [0.043137254901960784, 'rgb(6,43,73)'],
        [0.047058823529411764, 'rgb(7,43,75)'],
        [0.050980392156862744, 'rgb(7,44,77)'],
        [0.054901960784313725, 'rgb(7,44,80)'],
        [0.058823529411764705, 'rgb(8,45,82)'],
        [0.06274509803921569, 'rgb(8,46,84)'],
        [0.06666666666666667, 'rgb(9,46,86)'],
        [0.07058823529411765, 'rgb(9,47,89)'],
        [0.07450980392156863, 'rgb(10,47,91)'],
        [0.0784313725490196, 'rgb(11,48,93)'],
        [0.08235294117647059, 'rgb(12,48,96)'],
        [0.08627450980392157, 'rgb(12,48,98)'],
        [0.09019607843137255, 'rgb(13,49,101)'],
        [0.09411764705882353, 'rgb(14,49,103)'],
        [0.09803921568627451, 'rgb(15,50,106)'],
        [0.10196078431372549, 'rgb(16,50,108)'],
        [0.10588235294117647, 'rgb(18,50,111)'],
        [0.10980392156862745, 'rgb(19,51,114)'],
        [0.11372549019607843, 'rgb(20,51,116)'],
        [0.11764705882352941, 'rgb(22,51,119)'],
        [0.12156862745098039, 'rgb(23,51,122)'],
        [0.12549019607843137, 'rgb(25,51,124)'],
        [0.12941176470588237, 'rgb(26,52,127)'],
        [0.13333333333333333, 'rgb(28,52,130)'],
        [0.13725490196078433, 'rgb(30,52,132)'],
        [0.1411764705882353, 'rgb(31,52,135)'],
        [0.1450980392156863, 'rgb(33,52,138)'],
        [0.14901960784313725, 'rgb(35,52,140)'],
        [0.15294117647058825, 'rgb(37,52,143)'],
        [0.1568627450980392, 'rgb(39,52,145)'],
        [0.1607843137254902, 'rgb(42,51,147)'],
        [0.16470588235294117, 'rgb(44,51,149)'],
        [0.16862745098039217, 'rgb(46,51,151)'],
        [0.17254901960784313, 'rgb(48,51,153)'],
        [0.17647058823529413, 'rgb(51,51,155)'],
        [0.1803921568627451, 'rgb(53,51,156)'],
        [0.1843137254901961, 'rgb(55,51,157)'],
        [0.18823529411764706, 'rgb(57,51,158)'],
        [0.19215686274509805, 'rgb(60,51,159)'],
        [0.19607843137254902, 'rgb(62,52,159)'],
        [0.2, 'rgb(64,52,159)'],
        [0.20392156862745098, 'rgb(66,52,160)'],
        [0.20784313725490197, 'rgb(68,53,160)'],
        [0.21176470588235294, 'rgb(70,53,160)'],
        [0.21568627450980393, 'rgb(71,54,160)'],
        [0.2196078431372549, 'rgb(73,54,159)'],
        [0.2235294117647059, 'rgb(75,55,159)'],
        [0.22745098039215686, 'rgb(77,55,159)'],
        [0.23137254901960785, 'rgb(78,56,158)'],
        [0.23529411764705882, 'rgb(80,57,158)'],
        [0.23921568627450981, 'rgb(82,57,157)'],
        [0.24313725490196078, 'rgb(83,58,157)'],
        [0.24705882352941178, 'rgb(85,59,157)'],
        [0.25098039215686274, 'rgb(86,59,156)'],
        [0.2549019607843137, 'rgb(88,60,156)'],
        [0.25882352941176473, 'rgb(89,61,155)'],
        [0.2627450980392157, 'rgb(91,61,155)'],
        [0.26666666666666666, 'rgb(92,62,154)'],
        [0.27058823529411763, 'rgb(94,63,154)'],
        [0.27450980392156865, 'rgb(95,63,153)'],
        [0.2784313725490196, 'rgb(96,64,153)'],
        [0.2823529411764706, 'rgb(98,65,152)'],
        [0.28627450980392155, 'rgb(99,65,152)'],
        [0.2901960784313726, 'rgb(101,66,151)'],
        [0.29411764705882354, 'rgb(102,67,151)'],
        [0.2980392156862745, 'rgb(103,67,150)'],
        [0.30196078431372547, 'rgb(105,68,150)'],
        [0.3058823529411765, 'rgb(106,69,149)'],
        [0.30980392156862746, 'rgb(108,69,149)'],
        [0.3137254901960784, 'rgb(109,70,148)'],
        [0.3176470588235294, 'rgb(110,71,148)'],
        [0.3215686274509804, 'rgb(112,71,148)'],
        [0.3254901960784314, 'rgb(113,72,147)'],
        [0.32941176470588235, 'rgb(114,72,147)'],
        [0.3333333333333333, 'rgb(116,73,146)'],
        [0.33725490196078434, 'rgb(117,74,146)'],
        [0.3411764705882353, 'rgb(118,74,146)'],
        [0.34509803921568627, 'rgb(120,75,145)'],
        [0.34901960784313724, 'rgb(121,75,145)'],
        [0.35294117647058826, 'rgb(122,76,145)'],
        [0.3568627450980392, 'rgb(124,77,144)'],
        [0.3607843137254902, 'rgb(125,77,144)'],
        [0.36470588235294116, 'rgb(126,78,144)'],
        [0.3686274509803922, 'rgb(128,78,143)'],
        [0.37254901960784315, 'rgb(129,79,143)'],
        [0.3764705882352941, 'rgb(131,80,143)'],
        [0.3803921568627451, 'rgb(132,80,142)'],
        [0.3843137254901961, 'rgb(133,81,142)'],
        [0.38823529411764707, 'rgb(135,81,142)'],
        [0.39215686274509803, 'rgb(136,82,141)'],
        [0.396078431372549, 'rgb(137,82,141)'],
        [0.4, 'rgb(139,83,141)'],
        [0.403921568627451, 'rgb(140,83,140)'],
        [0.40784313725490196, 'rgb(142,84,140)'],
        [0.4117647058823529, 'rgb(143,84,140)'],
        [0.41568627450980394, 'rgb(144,85,139)'],
        [0.4196078431372549, 'rgb(146,85,139)'],
        [0.4235294117647059, 'rgb(147,86,139)'],
        [0.42745098039215684, 'rgb(149,86,138)'],
        [0.43137254901960786, 'rgb(150,87,138)'],
        [0.43529411764705883, 'rgb(151,87,138)'],
        [0.4392156862745098, 'rgb(153,88,137)'],
        [0.44313725490196076, 'rgb(154,88,137)'],
        [0.4470588235294118, 'rgb(156,89,137)'],
        [0.45098039215686275, 'rgb(157,89,136)'],
        [0.4549019607843137, 'rgb(159,90,136)'],
        [0.4588235294117647, 'rgb(160,90,135)'],
        [0.4627450980392157, 'rgb(162,91,135)'],
        [0.4666666666666667, 'rgb(163,91,134)'],
        [0.47058823529411764, 'rgb(165,92,134)'],
        [0.4745098039215686, 'rgb(166,92,134)'],
        [0.47843137254901963, 'rgb(168,93,133)'],
        [0.4823529411764706, 'rgb(169,93,132)'],
        [0.48627450980392156, 'rgb(171,93,132)'],
        [0.49019607843137253, 'rgb(172,94,131)'],
        [0.49411764705882355, 'rgb(174,94,131)'],
        [0.4980392156862745, 'rgb(175,95,130)'],
        [0.5019607843137255, 'rgb(177,95,130)'],
        [0.5058823529411764, 'rgb(178,96,129)'],
        [0.5098039215686274, 'rgb(180,96,128)'],
        [0.5137254901960784, 'rgb(181,97,128)'],
        [0.5176470588235295, 'rgb(183,97,127)'],
        [0.5215686274509804, 'rgb(184,98,126)'],
        [0.5254901960784314, 'rgb(186,98,126)'],
        [0.5294117647058824, 'rgb(187,98,125)'],
        [0.5333333333333333, 'rgb(189,99,124)'],
        [0.5372549019607843, 'rgb(190,99,123)'],
        [0.5411764705882353, 'rgb(192,100,123)'],
        [0.5450980392156862, 'rgb(193,100,122)'],
        [0.5490196078431373, 'rgb(195,101,121)'],
        [0.5529411764705883, 'rgb(196,101,120)'],
        [0.5568627450980392, 'rgb(198,102,119)'],
        [0.5607843137254902, 'rgb(199,102,118)'],
        [0.5647058823529412, 'rgb(201,103,117)'],
        [0.5686274509803921, 'rgb(202,103,116)'],
        [0.5725490196078431, 'rgb(204,104,115)'],
        [0.5764705882352941, 'rgb(205,104,114)'],
        [0.5803921568627451, 'rgb(206,105,113)'],
        [0.5843137254901961, 'rgb(208,105,112)'],
        [0.5882352941176471, 'rgb(209,106,111)'],
        [0.592156862745098, 'rgb(211,106,110)'],
        [0.596078431372549, 'rgb(212,107,109)'],
        [0.6, 'rgb(214,108,108)'],
        [0.6039215686274509, 'rgb(215,108,107)'],
        [0.6078431372549019, 'rgb(216,109,106)'],
        [0.611764705882353, 'rgb(218,110,105)'],
        [0.615686274509804, 'rgb(219,110,104)'],
        [0.6196078431372549, 'rgb(220,111,102)'],
        [0.6235294117647059, 'rgb(222,112,101)'],
        [0.6274509803921569, 'rgb(223,112,100)'],
        [0.6313725490196078, 'rgb(224,113,99)'],
        [0.6352941176470588, 'rgb(225,114,98)'],
        [0.6392156862745098, 'rgb(227,114,96)'],
        [0.6431372549019608, 'rgb(228,115,95)'],
        [0.6470588235294118, 'rgb(229,116,94)'],
        [0.6509803921568628, 'rgb(230,117,93)'],
        [0.6549019607843137, 'rgb(231,118,91)'],
        [0.6588235294117647, 'rgb(232,119,90)'],
        [0.6627450980392157, 'rgb(234,120,89)'],
        [0.6666666666666666, 'rgb(235,121,88)'],
        [0.6705882352941176, 'rgb(236,121,86)'],
        [0.6745098039215687, 'rgb(237,122,85)'],
        [0.6784313725490196, 'rgb(238,123,84)'],
        [0.6823529411764706, 'rgb(238,125,83)'],
        [0.6862745098039216, 'rgb(239,126,82)'],
        [0.6901960784313725, 'rgb(240,127,80)'],
        [0.6941176470588235, 'rgb(241,128,79)'],
        [0.6980392156862745, 'rgb(242,129,78)'],
        [0.7019607843137254, 'rgb(243,130,77)'],
        [0.7058823529411765, 'rgb(243,131,76)'],
        [0.7098039215686275, 'rgb(244,133,75)'],
        [0.7137254901960784, 'rgb(245,134,74)'],
        [0.7176470588235294, 'rgb(245,135,73)'],
        [0.7215686274509804, 'rgb(246,136,72)'],
        [0.7254901960784313, 'rgb(246,138,71)'],
        [0.7294117647058823, 'rgb(247,139,70)'],
        [0.7333333333333333, 'rgb(247,140,69)'],
        [0.7372549019607844, 'rgb(248,142,68)'],
        [0.7411764705882353, 'rgb(248,143,67)'],
        [0.7450980392156863, 'rgb(249,145,67)'],
        [0.7490196078431373, 'rgb(249,146,66)'],
        [0.7529411764705882, 'rgb(249,147,65)'],
        [0.7568627450980392, 'rgb(250,149,65)'],
        [0.7607843137254902, 'rgb(250,150,64)'],
        [0.7647058823529411, 'rgb(250,152,63)'],
        [0.7686274509803922, 'rgb(251,153,63)'],
        [0.7725490196078432, 'rgb(251,155,62)'],
        [0.7764705882352941, 'rgb(251,156,62)'],
        [0.7803921568627451, 'rgb(251,158,62)'],
        [0.7843137254901961, 'rgb(251,159,61)'],
        [0.788235294117647, 'rgb(251,161,61)'],
        [0.792156862745098, 'rgb(252,163,61)'],
        [0.796078431372549, 'rgb(252,164,61)'],
        [0.8, 'rgb(252,166,60)'],
        [0.803921568627451, 'rgb(252,167,60)'],
        [0.807843137254902, 'rgb(252,169,60)'],
        [0.8117647058823529, 'rgb(252,170,60)'],
        [0.8156862745098039, 'rgb(252,172,60)'],
        [0.8196078431372549, 'rgb(252,174,60)'],
        [0.8235294117647058, 'rgb(252,175,60)'],
        [0.8274509803921568, 'rgb(252,177,60)'],
        [0.8313725490196079, 'rgb(251,178,61)'],
        [0.8352941176470589, 'rgb(251,180,61)'],
        [0.8392156862745098, 'rgb(251,182,61)'],
        [0.8431372549019608, 'rgb(251,183,61)'],
        [0.8470588235294118, 'rgb(251,185,62)'],
        [0.8509803921568627, 'rgb(251,187,62)'],
        [0.8549019607843137, 'rgb(251,188,62)'],
        [0.8588235294117647, 'rgb(250,190,63)'],
        [0.8627450980392157, 'rgb(250,191,63)'],
        [0.8666666666666667, 'rgb(250,193,64)'],
        [0.8705882352941177, 'rgb(250,195,64)'],
        [0.8745098039215686, 'rgb(249,196,65)'],
        [0.8784313725490196, 'rgb(249,198,65)'],
        [0.8823529411764706, 'rgb(249,200,66)'],
        [0.8862745098039215, 'rgb(248,201,67)'],
        [0.8901960784313725, 'rgb(248,203,67)'],
        [0.8941176470588236, 'rgb(248,205,68)'],
        [0.8980392156862745, 'rgb(247,206,69)'],
        [0.9019607843137255, 'rgb(247,208,69)'],
        [0.9058823529411765, 'rgb(247,210,70)'],
        [0.9098039215686274, 'rgb(246,211,71)'],
        [0.9137254901960784, 'rgb(246,213,71)'],
        [0.9176470588235294, 'rgb(245,215,72)'],
        [0.9215686274509803, 'rgb(245,216,73)'],
        [0.9254901960784314, 'rgb(244,218,74)'],
        [0.9294117647058824, 'rgb(244,220,75)'],
        [0.9333333333333333, 'rgb(243,221,75)'],
        [0.9372549019607843, 'rgb(243,223,76)'],
        [0.9411764705882353, 'rgb(242,225,77)'],
        [0.9450980392156862, 'rgb(242,226,78)'],
        [0.9490196078431372, 'rgb(241,228,79)'],
        [0.9529411764705882, 'rgb(241,230,80)'],
        [0.9568627450980393, 'rgb(240,232,81)'],
        [0.9607843137254902, 'rgb(239,233,81)'],
        [0.9647058823529412, 'rgb(239,235,82)'],
        [0.9686274509803922, 'rgb(238,237,83)'],
        [0.9725490196078431, 'rgb(237,238,84)'],
        [0.9764705882352941, 'rgb(237,240,85)'],
        [0.9803921568627451, 'rgb(236,242,86)'],
        [0.984313725490196, 'rgb(235,244,87)'],
        [0.9882352941176471, 'rgb(234,245,88)'],
        [0.9921568627450981, 'rgb(234,247,89)'],
        [0.996078431372549, 'rgb(233,249,90)'],
        [1.0, 'rgb(232,250,91)'],
    ],
    'cmo.topo': [
        [0.0, 'rgb(40,26,44)'],
        [0.00392156862745098, 'rgb(41,28,47)'],
        [0.00784313725490196, 'rgb(43,29,50)'],
        [0.011764705882352941, 'rgb(44,31,52)'],
        [0.01568627450980392, 'rgb(45,32,55)'],
        [0.0196078431372549, 'rgb(47,34,58)'],
        [0.023529411764705882, 'rgb(48,35,61)'],
        [0.027450980392156862, 'rgb(49,37,64)'],
        [0.03137254901960784, 'rgb(50,38,67)'],
        [0.03529411764705882, 'rgb(52,40,70)'],
        [0.0392156862745098, 'rgb(53,41,73)'],
        [0.043137254901960784, 'rgb(54,42,76)'],
        [0.047058823529411764, 'rgb(55,44,79)'],
        [0.050980392156862744, 'rgb(56,45,82)'],
        [0.054901960784313725, 'rgb(57,47,85)'],
        [0.058823529411764705, 'rgb(58,48,88)'],
        [0.06274509803921569, 'rgb(59,50,92)'],
        [0.06666666666666667, 'rgb(60,51,95)'],
        [0.07058823529411765, 'rgb(61,53,98)'],
        [0.07450980392156863, 'rgb(62,54,102)'],
        [0.0784313725490196, 'rgb(63,56,105)'],
        [0.08235294117647059, 'rgb(63,57,108)'],
        [0.08627450980392157, 'rgb(64,59,112)'],
        [0.09019607843137255, 'rgb(64,60,115)'],
        [0.09411764705882353, 'rgb(65,62,118)'],
        [0.09803921568627451, 'rgb(65,64,122)'],
        [0.10196078431372549, 'rgb(65,65,125)'],
        [0.10588235294117647, 'rgb(66,67,128)'],
        [0.10980392156862745, 'rgb(65,69,131)'],
        [0.11372549019607843, 'rgb(65,71,133)'],
        [0.11764705882352941, 'rgb(65,73,136)'],
        [0.12156862745098039, 'rgb(65,75,138)'],
        [0.12549019607843137, 'rgb(64,77,140)'],
        [0.12941176470588237, 'rgb(64,79,141)'],
        [0.13333333333333333, 'rgb(63,82,143)'],
        [0.13725490196078433, 'rgb(63,84,144)'],
        [0.1411764705882353, 'rgb(62,86,145)'],
        [0.1450980392156863, 'rgb(62,88,146)'],
        [0.14901960784313725, 'rgb(62,90,146)'],
        [0.15294117647058825, 'rgb(62,92,147)'],
        [0.1568627450980392, 'rgb(62,95,147)'],
        [0.1607843137254902, 'rgb(62,97,148)'],
        [0.16470588235294117, 'rgb(62,99,148)'],
        [0.16862745098039217, 'rgb(62,101,149)'],
        [0.17254901960784313, 'rgb(62,103,149)'],
        [0.17647058823529413, 'rgb(62,105,150)'],
        [0.1803921568627451, 'rgb(62,107,150)'],
        [0.1843137254901961, 'rgb(63,109,151)'],
        [0.18823529411764706, 'rgb(63,111,151)'],
        [0.19215686274509805, 'rgb(64,113,151)'],
        [0.19607843137254902, 'rgb(64,115,152)'],
        [0.2, 'rgb(64,117,152)'],
        [0.20392156862745098, 'rgb(65,119,153)'],
        [0.20784313725490197, 'rgb(66,121,153)'],
        [0.21176470588235294, 'rgb(66,123,153)'],
        [0.21568627450980393, 'rgb(67,125,154)'],
        [0.2196078431372549, 'rgb(67,127,154)'],
        [0.2235294117647059, 'rgb(68,129,155)'],
        [0.22745098039215686, 'rgb(68,131,155)'],
        [0.23137254901960785, 'rgb(69,133,156)'],
        [0.23529411764705882, 'rgb(70,135,156)'],
        [0.23921568627450981, 'rgb(70,137,157)'],
        [0.24313725490196078, 'rgb(71,139,157)'],
        [0.24705882352941178, 'rgb(72,141,157)'],
        [0.25098039215686274, 'rgb(72,143,158)'],
        [0.2549019607843137, 'rgb(73,145,158)'],
        [0.25882352941176473, 'rgb(74,147,159)'],
        [0.2627450980392157, 'rgb(74,149,159)'],
        [0.26666666666666666, 'rgb(75,151,160)'],
        [0.27058823529411763, 'rgb(76,153,160)'],
        [0.27450980392156865, 'rgb(77,155,161)'],
        [0.2784313725490196, 'rgb(77,157,161)'],
        [0.2823529411764706, 'rgb(78,159,161)'],
        [0.28627450980392155, 'rgb(79,161,162)'],
        [0.2901960784313726, 'rgb(80,163,162)'],
        [0.29411764705882354, 'rgb(81,165,162)'],
        [0.2980392156862745, 'rgb(81,167,163)'],
        [0.30196078431372547, 'rgb(82,169,163)'],
        [0.3058823529411765, 'rgb(83,171,163)'],
        [0.30980392156862746, 'rgb(85,173,163)'],
        [0.3137254901960784, 'rgb(86,175,164)'],
        [0.3176470588235294, 'rgb(87,177,164)'],
        [0.3215686274509804, 'rgb(88,179,164)'],
        [0.3254901960784314, 'rgb(90,182,164)'],
        [0.32941176470588235, 'rgb(91,184,164)'],
        [0.3333333333333333, 'rgb(93,186,164)'],
        [0.33725490196078434, 'rgb(95,188,164)'],
        [0.3411764705882353, 'rgb(97,190,164)'],
        [0.34509803921568627, 'rgb(99,192,164)'],
        [0.34901960784313724, 'rgb(101,194,164)'],
        [0.35294117647058826, 'rgb(103,195,164)'],
        [0.3568627450980392, 'rgb(106,197,164)'],
        [0.3607843137254902, 'rgb(109,199,163)'],
        [0.36470588235294116, 'rgb(112,201,163)'],
        [0.3686274509803922, 'rgb(115,203,163)'],
        [0.37254901960784315, 'rgb(118,205,163)'],
        [0.3764705882352941, 'rgb(122,206,163)'],
        [0.3803921568627451, 'rgb(125,208,163)'],
        [0.3843137254901961, 'rgb(129,210,163)'],
        [0.38823529411764707, 'rgb(133,211,163)'],
        [0.39215686274509803, 'rgb(137,213,163)'],
        [0.396078431372549, 'rgb(141,215,163)'],
        [0.4, 'rgb(146,216,164)'],
        [0.403921568627451, 'rgb(150,218,164)'],
        [0.40784313725490196, 'rgb(154,219,165)'],
        [0.4117647058823529, 'rgb(159,221,165)'],
        [0.41568627450980394, 'rgb(163,222,166)'],
        [0.4196078431372549, 'rgb(167,224,167)'],
        [0.4235294117647059, 'rgb(172,225,168)'],
        [0.42745098039215684, 'rgb(176,226,169)'],
        [0.43137254901960786, 'rgb(181,228,170)'],
        [0.43529411764705883, 'rgb(185,229,172)'],
        [0.4392156862745098, 'rgb(189,231,173)'],
        [0.44313725490196076, 'rgb(193,232,175)'],
        [0.4470588235294118, 'rgb(198,234,176)'],
        [0.45098039215686275, 'rgb(202,235,178)'],
        [0.4549019607843137, 'rgb(206,236,179)'],
        [0.4588235294117647, 'rgb(210,238,181)'],
        [0.4627450980392157, 'rgb(215,239,183)'],
        [0.4666666666666667, 'rgb(219,241,185)'],
        [0.47058823529411764, 'rgb(223,242,187)'],
        [0.4745098039215686, 'rgb(227,244,189)'],
        [0.47843137254901963, 'rgb(231,245,191)'],
        [0.4823529411764706, 'rgb(235,247,193)'],
        [0.48627450980392156, 'rgb(239,248,196)'],
        [0.49019607843137253, 'rgb(243,250,198)'],
        [0.49411764705882355, 'rgb(247,251,200)'],
        [0.4980392156862745, 'rgb(251,253,203)'],
        [0.5019607843137255, 'rgb(13,37,20)'],
        [0.5058823529411764, 'rgb(14,39,21)'],
        [0.5098039215686274, 'rgb(15,41,21)'],
        [0.5137254901960784, 'rgb(16,42,22)'],
        [0.5176470588235295, 'rgb(17,44,23)'],
        [0.5215686274509804, 'rgb(18,46,23)'],
        [0.5254901960784314, 'rgb(19,48,24)'],
        [0.5294117647058824, 'rgb(20,50,24)'],
        [0.5333333333333333, 'rgb(21,51,25)'],
        [0.5372549019607843, 'rgb(22,53,26)'],
        [0.5411764705882353, 'rgb(23,55,26)'],
        [0.5450980392156862, 'rgb(23,57,27)'],
        [0.5490196078431373, 'rgb(24,58,27)'],
        [0.5529411764705883, 'rgb(25,60,28)'],
        [0.5568627450980392, 'rgb(26,62,28)'],
        [0.5607843137254902, 'rgb(27,64,28)'],
        [0.5647058823529412, 'rgb(27,65,29)'],
        [0.5686274509803921, 'rgb(28,67,29)'],
        [0.5725490196078431, 'rgb(29,69,29)'],
        [0.5764705882352941, 'rgb(30,71,30)'],
        [0.5803921568627451, 'rgb(31,72,30)'],
        [0.5843137254901961, 'rgb(32,74,30)'],
        [0.5882352941176471, 'rgb(33,76,30)'],
        [0.592156862745098, 'rgb(35,78,30)'],
        [0.596078431372549, 'rgb(37,79,30)'],
        [0.6, 'rgb(39,81,30)'],
        [0.6039215686274509, 'rgb(42,82,30)'],
        [0.6078431372549019, 'rgb(45,83,31)'],
        [0.611764705882353, 'rgb(48,85,32)'],
        [0.615686274509804, 'rgb(51,86,34)'],
        [0.6196078431372549, 'rgb(54,87,35)'],
        [0.6235294117647059, 'rgb(57,88,37)'],
        [0.6274509803921569, 'rgb(60,90,38)'],
        [0.6313725490196078, 'rgb(63,91,40)'],
        [0.6352941176470588, 'rgb(65,92,42)'],
        [0.6392156862745098, 'rgb(68,93,43)'],
        [0.6431372549019608, 'rgb(71,95,45)'],
        [0.6470588235294118, 'rgb(73,96,47)'],
        [0.6509803921568628, 'rgb(76,97,48)'],
        [0.6549019607843137, 'rgb(78,98,49)'],
        [0.6588235294117647, 'rgb(81,99,51)'],
        [0.6627450980392157, 'rgb(84,101,52)'],
        [0.6666666666666666, 'rgb(86,102,53)'],
        [0.6705882352941176, 'rgb(89,103,54)'],
        [0.6745098039215687, 'rgb(92,104,55)'],
        [0.6784313725490196, 'rgb(94,106,56)'],
        [0.6823529411764706, 'rgb(97,107,57)'],
        [0.6862745098039216, 'rgb(100,108,58)'],
        [0.6901960784313725, 'rgb(102,109,58)'],
        [0.6941176470588235, 'rgb(105,111,59)'],
        [0.6980392156862745, 'rgb(107,112,60)'],
        [0.7019607843137254, 'rgb(110,113,60)'],
        [0.7058823529411765, 'rgb(113,114,61)'],
        [0.7098039215686275, 'rgb(115,116,61)'],
        [0.7137254901960784, 'rgb(118,117,62)'],
        [0.7176470588235294, 'rgb(121,118,62)'],
        [0.7215686274509804, 'rgb(123,119,62)'],
        [0.7254901960784313, 'rgb(126,121,63)'],
        [0.7294117647058823, 'rgb(129,122,63)'],
        [0.7333333333333333, 'rgb(131,123,63)'],
        [0.7372549019607844, 'rgb(134,124,63)'],
        [0.7411764705882353, 'rgb(137,126,64)'],
        [0.7450980392156863, 'rgb(140,127,64)'],
        [0.7490196078431373, 'rgb(142,128,64)'],
        [0.7529411764705882, 'rgb(145,129,64)'],
        [0.7568627450980392, 'rgb(148,131,64)'],
        [0.7607843137254902, 'rgb(150,132,64)'],
        [0.7647058823529411, 'rgb(153,133,64)'],
        [0.7686274509803922, 'rgb(156,134,64)'],
        [0.7725490196078432, 'rgb(159,136,64)'],
        [0.7764705882352941, 'rgb(161,137,64)'],
        [0.7803921568627451, 'rgb(164,138,63)'],
        [0.7843137254901961, 'rgb(167,140,63)'],
        [0.788235294117647, 'rgb(170,141,63)'],
        [0.792156862745098, 'rgb(173,142,63)'],
        [0.796078431372549, 'rgb(176,143,63)'],
        [0.8, 'rgb(179,145,63)'],
        [0.803921568627451, 'rgb(182,146,63)'],
        [0.807843137254902, 'rgb(185,147,62)'],
        [0.8117647058823529, 'rgb(188,148,62)'],
        [0.8156862745098039, 'rgb(191,149,63)'],
        [0.8196078431372549, 'rgb(193,151,65)'],
        [0.8235294117647058, 'rgb(195,153,69)'],
        [0.8274509803921568, 'rgb(196,155,72)'],
        [0.8313725490196079, 'rgb(197,157,76)'],
        [0.8352941176470589, 'rgb(198,159,80)'],
        [0.8392156862745098, 'rgb(199,161,83)'],
        [0.8431372549019608, 'rgb(200,163,87)'],
        [0.8470588235294118, 'rgb(202,165,90)'],
        [0.8509803921568627, 'rgb(203,167,94)'],
        [0.8549019607843137, 'rgb(204,169,97)'],
        [0.8588235294117647, 'rgb(205,171,101)'],
        [0.8627450980392157, 'rgb(206,173,104)'],
        [0.8666666666666667, 'rgb(207,176,108)'],
        [0.8705882352941177, 'rgb(208,178,111)'],
        [0.8745098039215686, 'rgb(209,180,115)'],
        [0.8784313725490196, 'rgb(210,182,118)'],
        [0.8823529411764706, 'rgb(211,184,122)'],
        [0.8862745098039215, 'rgb(212,187,125)'],
        [0.8901960784313725, 'rgb(213,189,129)'],
        [0.8941176470588236, 'rgb(214,191,132)'],
        [0.8980392156862745, 'rgb(215,193,136)'],
        [0.9019607843137255, 'rgb(216,195,139)'],
        [0.9058823529411765, 'rgb(218,198,143)'],
        [0.9098039215686274, 'rgb(219,200,146)'],
        [0.9137254901960784, 'rgb(220,202,150)'],
        [0.9176470588235294, 'rgb(221,204,153)'],
        [0.9215686274509803, 'rgb(222,207,157)'],
        [0.9254901960784314, 'rgb(223,209,160)'],
        [0.9294117647058824, 'rgb(224,211,164)'],
        [0.9333333333333333, 'rgb(226,213,167)'],
        [0.9372549019607843, 'rgb(227,216,171)'],
        [0.9411764705882353, 'rgb(228,218,174)'],
        [0.9450980392156862, 'rgb(229,220,178)'],
        [0.9490196078431372, 'rgb(230,223,182)'],
        [0.9529411764705882, 'rgb(232,225,185)'],
        [0.9568627450980393, 'rgb(233,227,189)'],
        [0.9607843137254902, 'rgb(234,230,192)'],
        [0.9647058823529412, 'rgb(236,232,196)'],
        [0.9686274509803922, 'rgb(237,234,199)'],
        [0.9725490196078431, 'rgb(238,237,203)'],
        [0.9764705882352941, 'rgb(240,239,207)'],
        [0.9803921568627451, 'rgb(241,241,210)'],
        [0.984313725490196, 'rgb(242,244,214)'],
        [0.9882352941176471, 'rgb(244,246,217)'],
        [0.9921568627450981, 'rgb(245,249,221)'],
        [0.996078431372549, 'rgb(247,251,225)'],
        [1.0, 'rgb(249,253,228)'],
    ],
    'cmo.turbid': [
        [0.0, 'rgb(233,246,171)'],
        [0.00392156862745098, 'rgb(232,245,170)'],
        [0.00784313725490196, 'rgb(232,243,168)'],
        [0.011764705882352941, 'rgb(231,242,167)'],
        [0.01568627450980392, 'rgb(230,241,165)'],
        [0.0196078431372549, 'rgb(230,240,164)'],
        [0.023529411764705882, 'rgb(229,239,162)'],
        [0.027450980392156862, 'rgb(229,238,161)'],
        [0.03137254901960784, 'rgb(228,236,159)'],
        [0.03529411764705882, 'rgb(228,235,158)'],
        [0.0392156862745098, 'rgb(227,234,156)'],
        [0.043137254901960784, 'rgb(227,233,155)'],
        [0.047058823529411764, 'rgb(226,232,154)'],
        [0.050980392156862744, 'rgb(226,231,152)'],
        [0.054901960784313725, 'rgb(225,229,151)'],
        [0.058823529411764705, 'rgb(224,228,149)'],
        [0.06274509803921569, 'rgb(224,227,148)'],
        [0.06666666666666667, 'rgb(223,226,146)'],
        [0.07058823529411765, 'rgb(223,225,145)'],
        [0.07450980392156863, 'rgb(222,224,143)'],
        [0.0784313725490196, 'rgb(222,223,142)'],
        [0.08235294117647059, 'rgb(221,221,141)'],
        [0.08627450980392157, 'rgb(221,220,139)'],
        [0.09019607843137255, 'rgb(220,219,138)'],
        [0.09411764705882353, 'rgb(220,218,136)'],
        [0.09803921568627451, 'rgb(219,217,135)'],
        [0.10196078431372549, 'rgb(219,216,134)'],
        [0.10588235294117647, 'rgb(218,215,132)'],
        [0.10980392156862745, 'rgb(218,213,131)'],
        [0.11372549019607843, 'rgb(217,212,130)'],
        [0.11764705882352941, 'rgb(217,211,128)'],
        [0.12156862745098039, 'rgb(217,210,127)'],
        [0.12549019607843137, 'rgb(216,209,126)'],
        [0.12941176470588237, 'rgb(216,208,124)'],
        [0