# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetTrailResult',
    'AwaitableGetTrailResult',
    'get_trail',
    'get_trail_output',
]

@pulumi.output_type
class GetTrailResult:
    def __init__(__self__, arn=None, cloud_watch_logs_log_group_arn=None, cloud_watch_logs_role_arn=None, enable_log_file_validation=None, event_selectors=None, include_global_service_events=None, insight_selectors=None, is_logging=None, is_multi_region_trail=None, is_organization_trail=None, k_ms_key_id=None, s3_bucket_name=None, s3_key_prefix=None, sns_topic_arn=None, sns_topic_name=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cloud_watch_logs_log_group_arn and not isinstance(cloud_watch_logs_log_group_arn, str):
            raise TypeError("Expected argument 'cloud_watch_logs_log_group_arn' to be a str")
        pulumi.set(__self__, "cloud_watch_logs_log_group_arn", cloud_watch_logs_log_group_arn)
        if cloud_watch_logs_role_arn and not isinstance(cloud_watch_logs_role_arn, str):
            raise TypeError("Expected argument 'cloud_watch_logs_role_arn' to be a str")
        pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        if enable_log_file_validation and not isinstance(enable_log_file_validation, bool):
            raise TypeError("Expected argument 'enable_log_file_validation' to be a bool")
        pulumi.set(__self__, "enable_log_file_validation", enable_log_file_validation)
        if event_selectors and not isinstance(event_selectors, list):
            raise TypeError("Expected argument 'event_selectors' to be a list")
        pulumi.set(__self__, "event_selectors", event_selectors)
        if include_global_service_events and not isinstance(include_global_service_events, bool):
            raise TypeError("Expected argument 'include_global_service_events' to be a bool")
        pulumi.set(__self__, "include_global_service_events", include_global_service_events)
        if insight_selectors and not isinstance(insight_selectors, list):
            raise TypeError("Expected argument 'insight_selectors' to be a list")
        pulumi.set(__self__, "insight_selectors", insight_selectors)
        if is_logging and not isinstance(is_logging, bool):
            raise TypeError("Expected argument 'is_logging' to be a bool")
        pulumi.set(__self__, "is_logging", is_logging)
        if is_multi_region_trail and not isinstance(is_multi_region_trail, bool):
            raise TypeError("Expected argument 'is_multi_region_trail' to be a bool")
        pulumi.set(__self__, "is_multi_region_trail", is_multi_region_trail)
        if is_organization_trail and not isinstance(is_organization_trail, bool):
            raise TypeError("Expected argument 'is_organization_trail' to be a bool")
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        if k_ms_key_id and not isinstance(k_ms_key_id, str):
            raise TypeError("Expected argument 'k_ms_key_id' to be a str")
        pulumi.set(__self__, "k_ms_key_id", k_ms_key_id)
        if s3_bucket_name and not isinstance(s3_bucket_name, str):
            raise TypeError("Expected argument 's3_bucket_name' to be a str")
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix and not isinstance(s3_key_prefix, str):
            raise TypeError("Expected argument 's3_key_prefix' to be a str")
        pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)
        if sns_topic_arn and not isinstance(sns_topic_arn, str):
            raise TypeError("Expected argument 'sns_topic_arn' to be a str")
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if sns_topic_name and not isinstance(sns_topic_name, str):
            raise TypeError("Expected argument 'sns_topic_name' to be a str")
        pulumi.set(__self__, "sns_topic_name", sns_topic_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroupArn")
    def cloud_watch_logs_log_group_arn(self) -> Optional[str]:
        """
        Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn.
        """
        return pulumi.get(self, "cloud_watch_logs_log_group_arn")

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> Optional[str]:
        """
        Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @property
    @pulumi.getter(name="enableLogFileValidation")
    def enable_log_file_validation(self) -> Optional[bool]:
        """
        Specifies whether log file validation is enabled. The default is false.
        """
        return pulumi.get(self, "enable_log_file_validation")

    @property
    @pulumi.getter(name="eventSelectors")
    def event_selectors(self) -> Optional[Sequence['outputs.TrailEventSelector']]:
        """
        Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event. You can configure up to five event selectors for a trail.
        """
        return pulumi.get(self, "event_selectors")

    @property
    @pulumi.getter(name="includeGlobalServiceEvents")
    def include_global_service_events(self) -> Optional[bool]:
        """
        Specifies whether the trail is publishing events from global services such as IAM to the log files.
        """
        return pulumi.get(self, "include_global_service_events")

    @property
    @pulumi.getter(name="insightSelectors")
    def insight_selectors(self) -> Optional[Sequence['outputs.TrailInsightSelector']]:
        """
        Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail.
        """
        return pulumi.get(self, "insight_selectors")

    @property
    @pulumi.getter(name="isLogging")
    def is_logging(self) -> Optional[bool]:
        """
        Whether the CloudTrail is currently logging AWS API calls.
        """
        return pulumi.get(self, "is_logging")

    @property
    @pulumi.getter(name="isMultiRegionTrail")
    def is_multi_region_trail(self) -> Optional[bool]:
        """
        Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
        """
        return pulumi.get(self, "is_multi_region_trail")

    @property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> Optional[bool]:
        """
        Specifies whether the trail is created for all accounts in an organization in AWS Organizations, or only for the current AWS account. The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the master account for an organization in AWS Organizations.
        """
        return pulumi.get(self, "is_organization_trail")

    @property
    @pulumi.getter(name="kMSKeyId")
    def k_ms_key_id(self) -> Optional[str]:
        """
        Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by 'alias/', a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
        """
        return pulumi.get(self, "k_ms_key_id")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        Specifies the name of the Amazon S3 bucket designated for publishing log files. See Amazon S3 Bucket Naming Requirements.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see Finding Your CloudTrail Log Files. The maximum length is 200 characters.
        """
        return pulumi.get(self, "s3_key_prefix")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[str]:
        return pulumi.get(self, "sns_topic_arn")

    @property
    @pulumi.getter(name="snsTopicName")
    def sns_topic_name(self) -> Optional[str]:
        """
        Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.
        """
        return pulumi.get(self, "sns_topic_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TrailTag']]:
        return pulumi.get(self, "tags")


class AwaitableGetTrailResult(GetTrailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrailResult(
            arn=self.arn,
            cloud_watch_logs_log_group_arn=self.cloud_watch_logs_log_group_arn,
            cloud_watch_logs_role_arn=self.cloud_watch_logs_role_arn,
            enable_log_file_validation=self.enable_log_file_validation,
            event_selectors=self.event_selectors,
            include_global_service_events=self.include_global_service_events,
            insight_selectors=self.insight_selectors,
            is_logging=self.is_logging,
            is_multi_region_trail=self.is_multi_region_trail,
            is_organization_trail=self.is_organization_trail,
            k_ms_key_id=self.k_ms_key_id,
            s3_bucket_name=self.s3_bucket_name,
            s3_key_prefix=self.s3_key_prefix,
            sns_topic_arn=self.sns_topic_arn,
            sns_topic_name=self.sns_topic_name,
            tags=self.tags)


def get_trail(trail_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrailResult:
    """
    Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective of the region in which they were created.
    """
    __args__ = dict()
    __args__['trailName'] = trail_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudtrail:getTrail', __args__, opts=opts, typ=GetTrailResult).value

    return AwaitableGetTrailResult(
        arn=__ret__.arn,
        cloud_watch_logs_log_group_arn=__ret__.cloud_watch_logs_log_group_arn,
        cloud_watch_logs_role_arn=__ret__.cloud_watch_logs_role_arn,
        enable_log_file_validation=__ret__.enable_log_file_validation,
        event_selectors=__ret__.event_selectors,
        include_global_service_events=__ret__.include_global_service_events,
        insight_selectors=__ret__.insight_selectors,
        is_logging=__ret__.is_logging,
        is_multi_region_trail=__ret__.is_multi_region_trail,
        is_organization_trail=__ret__.is_organization_trail,
        k_ms_key_id=__ret__.k_ms_key_id,
        s3_bucket_name=__ret__.s3_bucket_name,
        s3_key_prefix=__ret__.s3_key_prefix,
        sns_topic_arn=__ret__.sns_topic_arn,
        sns_topic_name=__ret__.sns_topic_name,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_trail)
def get_trail_output(trail_name: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrailResult]:
    """
    Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective of the region in which they were created.
    """
    ...
