"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps
 * * Visit the URL provided by stack output 'SignInLink' in a browser, and verify the 'Login with Amazon' link shows up.
 * * If you plug in valid 'Login with Amazon' credentials, the federated log in should work.
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-idp');
const userpool = new lib_1.UserPool(stack, 'pool');
new lib_1.UserPoolIdentityProviderAmazon(stack, 'amazon', {
    userPool: userpool,
    clientId: 'amzn-client-id',
    clientSecret: 'amzn-client-secret',
});
const client = userpool.addClient('client');
const domain = userpool.addDomain('domain', {
    cognitoDomain: {
        domainPrefix: 'nija-test-pool',
    },
});
new core_1.CfnOutput(stack, 'SignInLink', {
    value: domain.signInUrl(client, {
        redirectUri: 'https://example.com',
    }),
});
//# sourceMappingURL=data:application/json;base64,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