"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cognito_generated_1 = require("../cognito.generated");
const base_1 = require("./base");
/**
 * Represents a identity provider that integrates with 'Login with Amazon'
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderAmazon extends base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'LoginWithAmazon',
            providerType: 'LoginWithAmazon',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderAmazon = UserPoolIdentityProviderAmazon;
//# sourceMappingURL=data:application/json;base64,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