"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        if (props.minLen && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,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