"""
Filter Banks
------------
This is a collection of useful filter banks. They use primarily the
`FilterBank` class or some derivation from it.

Perfect magnitude reconstruction:

- `linkwitz_riley_crossovers()`

Perfect reconstruction:

- `reconstructing_fractional_octave_bands()`

Psychoacoustics:

- `auditory_filters_gammatone()`

Other:

- `qmf_crossover()`: Quadrature mirror filters crossover.
- `fractional_octave_bands()`: Butterworth bandpass filter bank with signal
  energy conservation.
- `weightning_filter()`: A- or C-Weightning filter.

"""
from .filterbanks import (linkwitz_riley_crossovers,
                          reconstructing_fractional_octave_bands,
                          auditory_filters_gammatone,
                          fractional_octave_bands,
                          qmf_crossover,
                          weightning_filter)

__all__ = [
    'linkwitz_riley_crossovers',
    'reconstructing_fractional_octave_bands',
    'fractional_octave_bands',
    'auditory_filters_gammatone',
    'qmf_crossover',
    'weightning_filter'
]
