# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_video.ipynb (unless otherwise specified).

__all__ = ['select_frames', 'get_frames', 'get_vid']

# Cell

def select_frames(l):
  "Get first, 25%, 50%, 75%, and last frame from a list"
  f1 = l[0]
  quarter=float(len(l))/4
  f2 = (l[int(quarter+.5)] if quarter%2 !=0 else l[int(quarter)])
  mid= float(len(l))/2
  f3 = (l[int(mid-.5)] if mid%2 !=0 else l[int(mid)])
  threeq =float(len(l))*.75
  f4 = (l[int(threeq-.5)] if threeq%2 !=0 else l[int(threeq)])
  f5 = l[-1]
  return [f1,f2,f3,f4,f5]

# Cell

import av

def get_frames(vid):
  "Get frames from video"
  container=av.open(vid)
  fs=[f.to_ndarray(format='rgb24') for f in container.decode(video=0)]
  return select_frames(fs)

# Cell

from ..core import to_bytesio

def get_vid(encoded):
    "Get video from encoded bytes"
    return to_bytesio(bytes_decode(encoded))