# loniapi

loniapi is a Python package to make calls to the LONI API. It can list all files associated with a group-id and download specific files.

## Installation

1. Download the latest version of the loniapi package from Pypi
https://pypi.org/project/loniapi/
```bash
pip install loniapi
```

2. If step 1 errors outInstall pandas if it is not already installed. and requests. or upgrade
```bash
pip install pandas      # pip install pandas --upgrade
pip install requests    # pip install requests --upgrade
```

3. Create a config file in your home directory
```bash
cd ~
vim .loniApiConfig
```

4. Specify your group-id and loni log-in credentials
```bash
[<your-group-id>]
email = <your-email>
password = <your-password
```

## Usage

```python
from loniapi import filedownloader
myAPI = filedownloader.LoniApi()

# Log-in using a group ID acquired from IDA/LONI
myAPI.login('ampad')

# get list of files associated with the group id
loniAPI.get_LONI_files()

# test download a few file types 
myAPI.download_LONI_file('1')   #is a pdf
myAPI.download_LONI_file('3')   #is a csv

# to download a specific file version
myAPI.download_LONI_file(file_id = '2', version = '2015-11-13') #is a pdf

# log out
myAPI.logout()

```

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[MIT](https://choosealicense.com/licenses/mit/)
