# Automatically generated by scidbpy-aflgen
# DO NOT EDIT -- changes will be overwritten!
operators = [
  {
    "doc": "project( srcArray {, selectedAttr}+ )\n\nProduces a result array that includes some attributes of the source array.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - a list of at least one selectedAttrs from the source array.", 
    "name": "project", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "create_array ( array_name, array_schema , temp [, load_array , cells ] )\n\n        or\n\n       CREATE ['TEMP'] ARRAY array_name  array_schema [ [ [cells] ] USING load_array ]\n\nCreates an array with the given name and schema and adds it to the database.\n\nParameters\n----------\n\n    - array_name: an identifier that names the new array.\n    - array_schema: a multidimensional array schema that describes the\n      rank and shape of the array to be created, as well as the types\n      of each its attributes.\n    - temp: a boolean flag, true for a temporary array, false for a db\n      array.\n    - load_array an existing database array whose values are to be used\n      to determine sensible choices for those details of the target\n      dimensions that were elided.\n    - cells the desired number of logical cells per chunk (default is\n      1M)", 
    "name": "create_array", 
    "signature": [
      "array", 
      "array", 
      "array", 
      "schema", 
      "constant"
    ]
  }, 
  {
    "doc": "create_array_using ( array_name, array_schema , temp [, load_array , cells ] )\n\n        or\n\n       CREATE ['TEMP'] ARRAY array_name  array_schema [ [ [cells] ] USING load_array ]\n\nCreates an array with the given name and schema and adds it to the database.\n\nParameters\n----------\n\n    - array_name: an identifier that names the new array.\n    - array_schema: a multidimensional array schema that describes the\n      rank and shape of the array to be created, as well as the types\n      of each its attributes.\n    - temp: a boolean flag, true for a temporary array, false for a db\n      array.\n    - load_array an existing database array whose values are to be used\n      to determine sensible choices for those details of the target\n      dimensions that were elided.\n    - cells the desired number of logical cells per chunk (default is\n      1M)", 
    "name": "create_array_using", 
    "signature": [
      "array", 
      "array", 
      "array", 
      "schema", 
      "constant"
    ]
  }, 
  {
    "doc": "sort( srcArray {, attr [asc | desc]}* {, chunkSize}? )\n\nProduces a 1D array by sorting the non-empty cells of a source array.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDim.\n    - attr: the list of attributes to sort by. If no attribute is\n      provided, the first attribute will be used.\n    - asc | desc: whether ascending or descending order of the\n      attribute should be used. The default is asc.\n    - chunkSize: the size of a chunk in the result array. If not\n      provided, 1M will be used.\n\nNotes\n-----\n\n    Assuming null < NaN < other values", 
    "name": "sort", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "consume( array [, numAttrsToScanAtOnce] )\n\nAccesses each cell of an input array, if possible, by extracting tiles and iterating over tiles. numAttrsToScanAtOnce determines the number of attributes to scan as a group. Setting this value to '1' will result in a 'vertical' scan---all chunks of the current attribute will be scanned before moving on to the next attribute. Setting this value to the number of attributes will result in a 'horizontal' scan---chunk i of every attribute will be scanned before moving on to chunk i+1\n\nParameters\n----------\n\n    - array: the array to consume\n    - numAttrsToScanAtOnce: optional 'stride' of the scan, default is 1\n       Output array (an empty array):\n    <\n     >\n     [\n     ]", 
    "name": "consume", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "index_lookup (input_array, index_array,\n       input_array.attribute_name [,output_attribute_name]\n       [,'memory_limit=MEMORY_LIMIT'])\n\nThe input_array may have any attributes or dimensions. The index_array must have a single dimension and a single non-nullable attribute. The index array data must be sorted, unique values with no empty cells between them (though it does not necessarily need to be populated to the upper bound). The third argument must correctly refer to one of the attributes of the input array - the looked-up attribute. This attribute must have the same datatype as the only attribute of the index array. The comparison '<' function must be registered in SciDB for this datatype.\n The operator will create a new attribute, named input_attribute_name_index by default, or using the provided name, which will be the new last non-empty-tag attribute in the output array. The output attribute will be of type int64 nullable and will contain the respective coordinate of the corresponding input_attribute in index_array. If the corresponding input_attribute is null, or if no value for input_attribute exists in the index_array, the output attribute at that position shall be set to null. The output attribute shall be returned along all the input attributes in a fashion similar to the apply() operator.\n The operator uses some memory to cache a part of the index_array for fast lookup of values. By default, the size of this cache is limited to MEM_ARRAY_THRESHOLD. Note this is in addition to the memory already consumed by cached MemArrays as the operator is running. If a larger or smaller limit is desired, the 'memory_limit' parameter may be used. It is provided in units of mebibytes and must be at least 1.\n The operator may be further optimized to reduce memory footprint, optimized with a more clever data distribution pattern and/or extended to use multiple index arrays at the same time.\n\nParameters\n----------\n\n     input_array <..., input_attribute: type,... > [*]\n     index_array <index_attribute: type not null>\n    [dimension=0:any,any,any]\n     input_attribute --the name of the input attribute\n     [output_attribute_name] --the name for the output attribute if\n    desired\n     ['memory_limit=MEMORY_LIMIT'] --the memory limit to use MB)\n\nExamples\n--------\n\n     index_lookup(stock_trades, stock_symbols, stock_trades.ticker)\n     index_lookup(stock_trades, stock_symbols, stock_trades.ticker,\n    ticker_id, 'memory_limit=1024')", 
    "name": "index_lookup", 
    "signature": [
      "array", 
      "array", 
      "attribute", 
      "args"
    ]
  }, 
  {
    "doc": "setopt( option [, newValue] )\n\nGets/Sets a config option at runtime.\n\nParameters\n----------\n\n    - option: the config option.\n    - newValue: an optional new value for the config option. If\n      provided, the option is set. Either way, the option value(s) is\n      returned.", 
    "name": "setopt", 
    "signature": [
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "", 
    "name": "build", 
    "signature": [
      "schema", 
      "expression", 
      "args"
    ]
  }, 
  {
    "doc": "merge( leftArray, rightArray )\n\nCombines elements from the input arrays the following way: for each cell in the two inputs, if the cell of leftArray is not empty, the attributes from that cell are selected and placed in the output array; otherwise, the attributes from the corresponding cell in rightArray are taken. The two arrays should have the same attribute list, number of dimensions, and dimension start index. If the dimensions are not the same size, the output array uses the larger of the two.\n\nParameters\n----------\n\n    - leftArray: the left-hand-side array.\n    - rightArray: the right-hand-side array.", 
    "name": "merge", 
    "signature": [
      "array", 
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "store( srcArray, outputArray )\n\nStores an array to the database. Each execution of store() causes a new version of the array to be created.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDim.\n    - outputArray: an existing array in the database, with the same\n      schema as srcArray.", 
    "name": "store", 
    "signature": [
      "array", 
      "array"
    ]
  }, 
  {
    "doc": "subarray( srcArray {, lowCoord}+ {, highCoord}+ )\n\nProduces a result array from a specified, contiguous region of a source array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - the low coordinates\n    - the high coordinates\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - subarray(A, 2011, 1, 2012, 2) <quantity: uint64, sales:double>\n      [year, item] =\n       year, item, quantity, sales\n       0, 1, 7, 31.64\n       1, 0, 5, 41.65\n       1, 1, 9, 40.68\n\nNotes\n-----\n\n    - Almost the same as between(). The only difference is that the\n      dimensions are 'cropped'.", 
    "name": "subarray", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "transpose( srcArray )\n\nProduces an array with the same data in srcArray but with the list of dimensions reversd.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.", 
    "name": "transpose", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "rank( srcArray [, attr {, groupbyDim}*] )\n\nComputes the rankings of an array, based on the ordering of attr (within each group as specified by the list of groupbyDims, if provided). If groupbyDims is not specified, global ordering will be performed. If attr is not specified, the first attribute will be used.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - attr: which attribute to sort on. The default is the first\n      attribute.\n    - groupbyDim: if provided, the ordering will be performed among the\n      records in the same group.", 
    "name": "rank", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "avg_rank( srcArray [, attr {, groupbyDim}*] )\n\nRanks the array elements, where each element is ranked as the average of the upper bound (UB) and lower bound (LB) rankings. The LB ranking of an element E is the number of elements less than E, plus 1. The UB ranking of an element E is the number of elements less than or equal to E, plus 1.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - 0 or 1 attribute to rank with. If no attribute is provided, the\n      first attribute is used.\n    - an optional list of groupbyDims used to group the elements, such\n      that the rankings are calculated within each group. If no\n      groupbyDim is provided, the whole array is treated as one group.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - avg_rank(A, sales, year) <sales:double, sales_rank: uint64>\n      [year, item] =\n       year, item, sales, sales_rank\n       2011, 2, 31.64, 2\n       2011, 3, 19.98, 1\n       2012, 1, 41.65, 3\n       2012, 2, 40.68, 2\n       2012, 3, 26.64, 1\n\nNotes\n-----\n\n    - For any element with a distinct value, its UB ranking and LB\n      ranking are equal.", 
    "name": "avg_rank", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "quantile( srcArray, numQuantiles [, attr {, groupbyDim}*] )\n\nComputes the quantiles of an array, based on the ordering of attr (within each group as specified by groupbyDim, if specified). If groupbyDim is not specified, global ordering will be performed. If attr is not specified, the first attribute will be used.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - numQuantiles: the number of quantiles.\n    - attr: which attribute to sort on. The default is the first\n      attribute.\n    - groupbyDim: if provided, the ordering will be performed among the\n      records in the same group.\n\nExamples\n--------\n\n    - Given array A <v:int64> [i=0:5,3,0] =\n       i, v\n       0, 0\n       1, 1\n       2, 2\n       3, 3\n       4, 4\n       5, 5\n    - quantile(A, 2) <percentage, v_quantile>[quantile=0:2,3,0] =\n       {quantile} percentage, v_quantile\n       {0} 0, 0\n       {1} 0.5, 2\n       {2} 1, 5", 
    "name": "quantile", 
    "signature": [
      "array", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "list( what='arrays', showSystem=false )\n\nProduces a result array and loads data from a given file, and optionally stores to shadowArray. The available things to list include:\n - aggregates: show all the aggregate operators.\n - arrays: show all the arrays.\n - chunk descriptors: show all the chunk descriptors.\n - chunk map: show the chunk map.\n - functions: show all the functions.\n - instances: show all SciDB instances.\n - libraries: show all the libraries that are loaded in the current SciDB session.\n - operators: show all the operators and the libraries in which they reside.\n - types: show all the datatypes that SciDB supports.\n - queries: show all the active queries.\n - datastores: show information about each datastore\n - counters: (undocumented) dump info from performance counters\n\nParameters\n----------\n\n    - what: what to list.\n    - showSystem: whether to show systems information.", 
    "name": "list", 
    "signature": [
      "args"
    ]
  }, 
  {
    "doc": "input( schemaArray | schema, filename, instance=-2, format='',\n           maxErrors=0, shadowArray='', isStrict=false )\n\nProduces a result array and loads data from a given file, and optionally stores to shadowArray.\n\nParameters\n----------\n\n    - schemaArray | schema: the array schema.\n    - filename: where to load data from.\n    - instance: which instance; default is -2. ??\n    - format: ??\n    - maxErrors: ??\n    - shadowArray: if provided, the result array will be written to it.\n    - isStrict if true, enables the data integrity checks such as for\n      data collisions and out-of-order input chunks, defualt=false.\n\nNotes\n-----\n\n    - [comment from author] Must be called as\n      INPUT('existing_array_name', '/path/to/file/on/instance'). ??\n      schema not allowed??\n    - This really needs to be modified by the author.", 
    "name": "input", 
    "signature": [
      "schema", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "apply(srcArray {, newAttr, expression}+)\n\nProduces a result array with new attributes and computes values for them.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - 1 or more pairs of a new attribute and the expression to compute\n      the values for the attribute.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - apply(A, unitprice, sales/quantity) <quantity: uint64, sales:\n      double, unitprice: double> [year, item] =\n       year, item, quantity, sales, unitprice\n       2011, 2, 7, 31.64, 4.52\n       2011, 3, 6, 19.98, 3.33\n       2012, 1, 5, 41.65, 8.33\n       2012, 2, 9, 40.68, 4.52\n       2012, 3, 8, 26.64, 3.33", 
    "name": "apply", 
    "signature": [
      "array", 
      "attribute", 
      "expression", 
      "args"
    ]
  }, 
  {
    "doc": "xgrid( srcArray {, scale}+ )\n\nProduces a result array by 'scaling up' the source array. Within each dimension, the operator duplicates each cell a specified number of times before moving to the next cell. A scale must be provided for every dimension.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - scale: for each dimension, a scale is provided telling how much\n      larger the dimension should grow.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - xgrid(A, 1, 2) <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 3, 7, 31.64\n       2011, 4, 7, 31.64\n       2011, 5, 6, 19.98\n       2011, 6, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 5, 41.65\n       2012, 3, 9, 40.68\n       2012, 4, 9, 40.68\n       2012, 5, 8, 26.64\n       2012, 6, 8, 26.64", 
    "name": "xgrid", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "filter( srcArray, expression )\n\nThe filter operator returns an array the with the same schema as the input array. The result is identical to the input except that those cells for which the expression evaluates either false or null are marked as being empty.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - expression: an expression which takes a cell in the source array\n      as input and evaluates to either True or False.", 
    "name": "filter", 
    "signature": [
      "array", 
      "expression"
    ]
  }, 
  {
    "doc": "cross_between( srcArray, rangesArray )\n\nProduces a result array by cutting out data in one of the rectangular ranges specified in rangesArray.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - rangesArray: an array with (|srcDims| * 2) attributes all having\n      type int64.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - Given array R <year_low, item_low, year_high, item_high>[i] =\n       i, year_low, item_low, year_high, item_high\n       0, 2011, 3, 2011, 3\n       1, 2012, 1, 2012, 2\n    - cross_between(A, R) <quantity: uint64, sales:double> [year, item]\n      =\n       year, item, quantity, sales\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n\nNotes\n-----\n\n    - Similar to between().\n    - The operator only works if the size of the rangesArray is very\n      small.", 
    "name": "cross_between", 
    "signature": [
      "array", 
      "array"
    ]
  }, 
  {
    "doc": "between( srcArray {, lowCoord}+ {, highCoord}+ )\n\nProduces a result array from a specified, contiguous region of a source array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - the low coordinates\n    - the high coordinates\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - between(A, 2011, 1, 2012, 2) <quantity: uint64, sales:double>\n      [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n\nNotes\n-----\n\n    - Almost the same as subarray. The only difference is that the\n      dimensions retain the original start/end/boundaries.", 
    "name": "between", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "cast( srcArray, schemaArray | schema )\n\nProduces a result array with data from srcArray but with the provided schema. There are three primary purposes:\n - To change names of attributes or dimensions.\n - To change types of attributes\n - To change a non-integer dimension to an integer dimension.\n - To change a nulls-disallowed attribute to a nulls-allowed attribute.\n\nParameters\n----------\n\n    - srcArray: a source array.\n    - schemaArray | schema: an array or a schema, from which attrs and\n      dims will be used by the output array.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - cast(A, <q:uint64, s:double>[y=2011:2012,2,0, i=1:3,3,0])\n      <q:uint64, s:double> [y, i] =\n       y, i, q, s\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64", 
    "name": "cast", 
    "signature": [
      "array", 
      "schema"
    ]
  }, 
  {
    "doc": "cancel( queryId )\n\nCancels a query by ID.\n\nParameters\n----------\n\n    - queryId: the query ID that can be obtained from the SciDB log or\n      via the list() command.\n\nNotes\n-----\n\n    - This operator is designed for internal use.", 
    "name": "cancel", 
    "signature": [
      "constant"
    ]
  }, 
  {
    "doc": "diskinfo()\n\nChecks disk usage.\n\nNotes\n-----\n\n    - For internal usage.", 
    "name": "_diskinfo", 
    "signature": []
  }, 
  {
    "doc": "slice( srcArray {, dim, dimValue}* )\n\nProduces a 'slice' of the source array, by holding zero or more dimension values constant. The result array does not include the dimensions that are used for slicing.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - dim: one of the dimensions to be used for slicing.\n    - dimValue: the constant value in the dimension to slice.", 
    "name": "slice", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "explain_logical( query , language = 'aql' )\n\nProduces a single-element array containing the logical query plan.\n\nParameters\n----------\n\n    - query: a query string.\n    - language: the language string; either 'aql' or 'afl'; default is\n      'aql'\n\nNotes\n-----\n\n    - For internal usage.", 
    "name": "_explain_logical", 
    "signature": [
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "unpack( srcArray, newDim )\n\nUnpacks a multi-dimensional array into a single-dimensional array, creating new attributes to represent the dimensions in the source array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - newDim: the name of the dimension in the result 1D array.", 
    "name": "unpack", 
    "signature": [
      "array", 
      "dimname", 
      "args"
    ]
  }, 
  {
    "doc": "variable_window( srcArray, dim, leftEdge, rightEdge {,\n           AGGREGATE_CALL}+ )\n            AGGREGATE_CALL := AGGREGATE_FUNC(inputAttr) [as resultName]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n\nProduces a result array with the same dimensions as the source array, where each cell stores some aggregates calculated over a 1D window covering the current cell. The window has fixed number of non-empty elements. For instance, when rightEdge is 1, the window extends to the right-hand side however number of coordinatesthat are needed, to cover the next larger non-empty cell.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - dim: along which dimension is the window defined.\n    - leftEdge: how many cells to the left of the current cell are\n      included in the window.\n    - rightEdge: how many cells to the right of the current cell are\n      included in the window.\n    - 1 or more aggregate calls. Each aggregate call has an\n      AGGREGATE_FUNC, an inputAttr and a resultName. The default\n      resultName is inputAttr followed by '_' and then AGGREGATE_FUNC.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - variable_window(A, item, 1, 0, sum(quantity)) <quantity_sum:\n      uint64> [year, item] =\n       year, item, quantity_sum\n       2011, 2, 7\n       2011, 3, 13\n       2012, 1, 5\n       2012, 2, 14\n       2012, 3, 17\n\nNotes\n-----\n\n    - For a dense array, this is a special case of window().\n    - For the aggregate function approxdc(), the attribute name is\n      currently non-conventional. It is xxx_ApproxDC instead of\n      xxx_approxdc. Should change.", 
    "name": "variable_window", 
    "signature": [
      "array", 
      "dimname", 
      "constant", 
      "constant", 
      "aggregate", 
      "args"
    ]
  }, 
  {
    "doc": "reduce_distro( replicatedArray, partitioningSchema )\n\nMakes a replicated array appear as if it has the required partitioningSchema.\n\nParameters\n----------\n\n    - replicatedArray: an source array which is replicated across all\n      the instances.\n    - partitioningSchema: the desired partitioning schema.", 
    "name": "_reduce_distro", 
    "signature": [
      "array", 
      "constant"
    ]
  }, 
  {
    "doc": "cross_join( leftArray, rightArray {, attrLeft, attrRight}* )\n\nCalculates the cross product of two arrays, with 0 or more equality conditions on the dimensions. Assume p pairs of equality conditions exist. The result is an (m+n-p) dimensional array. From the coordinates of each cell in the result array, a single cell in leftArray and a single cell in rightArray can be located. The cell in the result array contains the concatenation of the attributes from the two source cells. If a pair of join dimensions have different lengths, the result array uses the smaller of the two.\n\nParameters\n----------\n\n    - leftArray: the left-side source array with leftAttrs and\n      leftDims.\n    - rightArray: the right-side source array with rightAttrs and\n      rightDims.\n    - 0 or more pairs of an attribute from leftArray and an attribute\n      from rightArray.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - Given array B <v:uint64> [k] =\n       k, v\n       1, 10\n       2, 20\n       3, 30\n       4, 40\n       5, 50\n    - cross_join(A, B, item, k) <quantity: uint64, sales:double,\n      v:uint64> [year, item] =\n       year, item, quantity, sales, v\n       2011, 2, 7, 31.64, 20\n       2011, 3, 6, 19.98, 30\n       2012, 1, 5, 41.65, 10\n       2012, 2, 9, 40.68, 20\n       2012, 3, 8, 26.64, 30\n\nNotes\n-----\n\n    - Joining non-integer dimensions does not work.", 
    "name": "cross_join", 
    "signature": [
      "array", 
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "help( operator )\n\nProduces a single-element array containing the help information for an operator.\n\nParameters\n----------\n\n    - operator: the name of an operator.", 
    "name": "help", 
    "signature": [
      "args"
    ]
  }, 
  {
    "doc": "rename( oldArray, newArray )\n\nChanges the name of an array.\n\nParameters\n----------\n\n    - oldArray: an existing array.\n    - newArray: the new name of the array.", 
    "name": "rename", 
    "signature": [
      "array", 
      "array"
    ]
  }, 
  {
    "doc": "insert( sourceArray, targetArrayName )\n\nInserts all data from left array into the persistent targetArray. targetArray must exist with matching dimensions and attributes. targetArray must also be mutable. The operator shall create a new version of targetArray that contains all data of the array that would have been received by merge(sourceArray, targetArrayName). In other words, new data is inserted between old data and overwrites any overlapping old values. The resulting array is then returned.\n\nParameters\n----------\n\n    - sourceArray the array or query that provides inserted data\n    - targetArrayName: the name of the persistent array inserted into\n\nNotes\n-----\n\n    Some might wonder - if this returns the same result as\n    merge(sourceArray, targetArrayName), then why not use\n    store(merge())? The answer is that\n    1.  this runs a lot faster - it does not perform a full scan of\n        targetArray\n    2.  this also generates less chunk headers", 
    "name": "insert", 
    "signature": [
      "array", 
      "array"
    ]
  }, 
  {
    "doc": "remove_versions( targetArray, oldestVersionToSave )\n\nRemoves all versions of targetArray that are older than oldestVersionToSave\n\nParameters\n----------\n\n    - targetArray: the array which is targeted.\n    - oldestVersionToSave: the version, prior to which all versions\n      will be removed.", 
    "name": "remove_versions", 
    "signature": [
      "array", 
      "constant"
    ]
  }, 
  {
    "doc": "remove( arrayToRemove )\n\nDrops an array.\n\nParameters\n----------\n\n    - arrayToRemove: the array to drop.", 
    "name": "remove", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "reshape( srcArray, schema )\n\nProduces a result array containing the same cells as, but a different shape from, the source array.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - schema: the desired schema, with the same attributes as srcAttrs,\n      but with different size and/or number of dimensions. The\n      restriction is that the product of the dimension sizes is equal\n      to the number of cells in srcArray.", 
    "name": "reshape", 
    "signature": [
      "array", 
      "schema"
    ]
  }, 
  {
    "doc": "repart( srcArray, schema )\n\nProduces a result array similar to the source array, but with different chunk sizes, different chunk overlaps, or both.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - schema: the desired schema.", 
    "name": "repart", 
    "signature": [
      "array", 
      "schema"
    ]
  }, 
  {
    "doc": "redimension( srcArray, schemaArray | schema , isStrict=true | {,\n           AGGREGATE_CALL}* )\n            AGGREGATE_CALL := AGGREGATE_FUNC(inputAttr) [as resultName]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n\nProduces a array using some or all of the variables of a source array, potentially changing some or all of those variables from dimensions to attributes or vice versa, and optionally calculating aggregates to be included in the new array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - schemaArray | schema: an array or schema from which outputAttrs\n      and outputDims can be acquired. All the dimensions in outputDims\n      must exist either in srcAttrs or in srcDims, with one exception.\n      One new dimension called the synthetic dimension is allowed. All\n      the attributes in outputAttrs, which is not the result of an\n      aggregate, must exist either in srcAttrs or in srcDims.\n    - isStrict if true, enables the data integrity checks such as for\n      data collisions and out-of-order input chunks, defualt=false. In\n      case of aggregates, isStrict requires that the aggreates be\n      specified for all source array attributes which are also\n      attributes in the new array. In case of synthetic dimension,\n      isStrict has no effect.\n    - 0 or more aggregate calls. Each aggregate call has an\n      AGGREGATE_FUNC, an inputAttr and a resultName. The default\n      resultName is inputAttr followed by '_' and then AGGREGATE_FUNC.\n      The resultNames must already exist in outputAttrs.\n\nNotes\n-----\n\n    - The synthetic dimension cannot co-exist with aggregates. That is,\n      if there exists at least one aggregate call, the synthetic\n      dimension must not exist.\n    - When multiple values are 'redimensioned' into the same cell in\n      the output array, the collision handling depends on the schema:\n      (a) If there exists a synthetic dimension, all the values are\n      retained in a vector along the synthetic dimension. (b)\n      Otherwise, for an aggregate attribute, the aggregate result of\n      the values is stored. (c) Otherwise, an arbitrary value is picked\n      and the rest are discarded.\n    - Current redimension() does not support Non-integer dimensions or\n      data larger than memory.", 
    "name": "redimension", 
    "signature": [
      "array", 
      "schema", 
      "args"
    ]
  }, 
  {
    "doc": "join( leftArray, rightArray )\n\nCombines the attributes of two arrays at matching dimension values. The two arrays must have the same dimension start coordinates, the same chunk size, and the same chunk overlap. The join result has the same dimension names as the first input. The cell in the result array contains the concatenation of the attributes from the two source cells. If a pair of join dimensions have different lengths, the result array uses the smaller of the two.\n\nParameters\n----------\n\n    - leftArray: the left-side source array with leftAttrs and\n      leftDims.\n    - rightArray: the right-side source array with rightAttrs and\n      rightDims.\n\nNotes\n-----\n\n    - join() is a special case of cross_join() with all pairs of\n      dimensions given.", 
    "name": "join", 
    "signature": [
      "array", 
      "array"
    ]
  }, 
  {
    "doc": "unload_library( library )\n\nUnloads a SciDB plugin.\n\nParameters\n----------\n\n    - library: the name of the library to unload.\n\nNotes\n-----\n\n    - This operator is the reverse of load_library().", 
    "name": "unload_library", 
    "signature": [
      "constant"
    ]
  }, 
  {
    "doc": "versions( srcArray )\n\nLists all versions of an array in the database.\n\nParameters\n----------\n\n    - srcArray: a source array.", 
    "name": "versions", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "save( srcArray, file, instanceId = -2, format = 'store' )\n\nSaves the data in an array to a file.\n\nParameters\n----------\n\n    - srcArray: the source array to save from.\n    - file: the file to save to.\n    - instanceId: positive number means an instance ID on which file\n      will be saved. -1 means to save file on every instance. -2 - on\n      coordinator.\n    - format: ArrayWriter format in which file will be stored\n\nNotes\n-----\n\n    n/a Must be called as SAVE('existing_array_name',\n    '/path/to/file/on/instance')", 
    "name": "save", 
    "signature": [
      "array", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "save( srcArray, file, instanceId = -2, format = 'store' )\n\nSaves the data in an array to a file.\n\nParameters\n----------\n\n    - srcArray: the source array to save from.\n    - file: the file to save to.\n    - instanceId: positive number means an instance ID on which file\n      will be saved. -1 means to save file on every instance. -2 - on\n      coordinator.\n    - format: ArrayWriter format in which file will be stored\n\nNotes\n-----\n\n    n/a Must be called as SAVE('existing_array_name',\n    '/path/to/file/on/instance')", 
    "name": "_save_old", 
    "signature": [
      "array", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "sg( srcArray, partitionSchema, instanceId=-1, outputArray='',\n           isStrict=false, offsetVector=null)\n\nSCATTER/GATHER distributes array chunks over the instances of a cluster. The result array is returned. It is the only operator that uses the network manager. Typically this operator is inserted by the optimizer into the physical plan.\n\nParameters\n----------\n\n    - srcArray: the source array, with srcAttrs and srcDims.\n    - partitionSchema:\n       0 = psReplication,\n       1 = psHashPartitioned,\n       2 = psLocalInstance,\n       3 = psByRow,\n       4 = psByCol,\n       5 = psUndefined.\n    - instanceId:\n       -2 = to coordinator (same with 0),\n       -1 = all instances participate,\n       0..#instances-1 = to a particular instance.\n       [TO-DO: The usage of instanceId, in calculating which instance a\n      chunk should go to, requires further documentation.]\n    - outputArray: if not empty, the result will be stored into this\n      array\n    - isStrict if true, enables the data integrity checks such as for\n      data collisions and out-of-order input chunks, defualt=false.\n    - offsetVector: a vector of #dimensions values.\n       To calculate which instance a chunk belongs, the chunkPos is\n      augmented with the offset vector before calculation.", 
    "name": "_sg", 
    "signature": [
      "array", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "bernoulli( srcArray, probability [, seed] )\n\nEvaluates whether to include a cell in the result array by generating a random number and checks if it is less than probability.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - probability: the probability threshold, in [0..1]\n    - an optional seed for the random number generator.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - bernoulli(A, 0.5, 100) <quantity: uint64, sales:double> [year,\n      item] =\n       year, item, quantity, sales\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 3, 8, 26.64", 
    "name": "bernoulli", 
    "signature": [
      "array", 
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "explain_physical( query , language = 'aql' )\n\nProduces a single-element array containing the physical query plan.\n\nParameters\n----------\n\n    - query: a query string.\n    - language: the language string; either 'aql' or 'afl'; default is\n      'aql'\n\nNotes\n-----\n\n    - For internal usage.", 
    "name": "_explain_physical", 
    "signature": [
      "constant", 
      "args"
    ]
  }, 
  {
    "doc": "scan( srcArray [, ifTrim] )\n\nProduces a result array that is equivalent to a stored array.\n\nParameters\n----------\n\n    - srcArray: the array to scan, with srcAttrs and srcDims.\n    - ifTrim: whether to turn an unbounded array to a bounded array.\n      Default value is false.", 
    "name": "scan", 
    "signature": [
      "array", 
      "array", 
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "load_library( library )\n\nLoads a SciDB plugin.\n\nParameters\n----------\n\n    - library: the name of the library to load.\n\nNotes\n-----\n\n    - A library may be unloaded using unload_library()", 
    "name": "load_library", 
    "signature": [
      "constant"
    ]
  }, 
  {
    "doc": "unfold( array )\n\nComplicated input data are often loaded into table-like 1-d multi- attribute arrays. Sometimes we want to assemble uniformly-typed subsets of the array attributes into a matrix, for example to compute correlations or regressions. unfold will transform the input array into a 2-d matrix whose columns correspond to the input array attributes. The output matrix row dimension will have a chunk size equal to the input array, and column chunk size equal to the number of columns.\n\nParameters\n----------\n\n    - array: the array to consume\n\nExamples\n--------\n\n    unfold(apply(build(<v:double>[i=0:9,3,0],i),w,i+0.5))", 
    "name": "unfold", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "dimensions( srcArray )\n\nList the dimensions of the source array.\n\nParameters\n----------\n\n    - srcArray: a source array.", 
    "name": "dimensions", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "show( schemaArray | schema | queryString [, 'aql' | 'afl'] )\n\nShows the schema of an array.\n\nParameters\n----------\n\n    - schemaArray | schema | queryString: an array where the schema is\n      used, the schema itself or arbitrary query string\n    o", 
    "name": "show", 
    "signature": [
      "args"
    ]
  }, 
  {
    "doc": "substitute( srcArray, substituteArray {, attr}* )\n\nProduces a result array the same as srcArray, but with null values (of selected attributes) substituted using the values in substituteArray.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims, that may\n      contain null values.\n    - substituteArray: the array from which the values may be used to\n      substitute the null values in srcArray. It must have a single\n      dimension which starts at 0, and a single attribute.\n    - An optional list of attributes to substitute. The default is to\n      substitute all nullable attributes.", 
    "name": "substitute", 
    "signature": [
      "array", 
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "attributes( srcArray )\n\nProduces a 1D result array where each cell describes one attribute of the source array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - attributes(A) <name:string, type_id:string, nullable:bool> [No] =\n       No, name, type_id, nullable\n       0, 'quantity', 'uint64', false\n       1, 'sales', 'double', false", 
    "name": "attributes", 
    "signature": [
      "array"
    ]
  }, 
  {
    "doc": "", 
    "name": "load_module", 
    "signature": [
      "constant"
    ]
  }, 
  {
    "doc": "window( srcArray {, leftEdge, rightEdge}+ {, AGGREGATE_CALL}+ [,\n           METHOD ] )\n            AGGREGATE_CALL := AGGREGATE_FUNC(inputAttr) [as resultName]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n            METHOD := 'materialize' | 'probe'\n\nProduces a result array with the same size and dimensions as the source array, where each ouput cell stores some aggregate calculated over a window around the corresponding cell in the source array. A pair of window specification values (leftEdge, rightEdge) must exist for every dimension in the source and output array.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - leftEdge: how many cells to the left of the current cell (in one\n      dimension) are included in the window.\n    - rightEdge: how many cells to the right of the current cell (in\n      one dimension) are included in the window.\n    - 1 or more aggregate calls. Each aggregate call has an\n      AGGREGATE_FUNC, an inputAttr and a resultName. The default\n      resultName is inputAttr followed by '_' and then AGGREGATE_FUNC.\n      For instance, the default resultName for sum(sales) is\n      'sales_sum'. The count aggregate may take * as the input\n      attribute, meaning to count all the items in the group including\n      null items. The default resultName for count(*) is 'count'.\n    - An optional final argument that specifies how the operator is to\n      perform its calculation. At the moment, we support two internal\n      algorithms: 'materialize' (which materializes an entire source\n      chunk before computing the output windows) and 'probe' (which\n      probes the source array for the data in each window). In general,\n      materializing the input is a more efficient strategy, but when\n      we're using thin(...) in conjunction with window(...), we're\n      often better off using probes, rather than materilization. This\n      is a decision that the optimizer needs to make.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - window(A, 0, 0, 1, 0, sum(quantity)) <quantity_sum: uint64>\n      [year, item] =\n       year, item, quantity_sum\n       2011, 2, 7\n       2011, 3, 13\n       2012, 1, 5\n       2012, 2, 14\n       2012, 3, 17", 
    "name": "window", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "regrid( srcArray {, blockSize}+ {, AGGREGATE_CALL}+ {, chunkSize}*\n           )\n            AGGREGATE_CALL := AGGREGATE_FUNC(inputAttr) [as resultName]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n\nPartitions the cells in the source array into blocks (with the given blockSize in each dimension), and for each block, calculates the required aggregates.\n\nParameters\n----------\n\n    - srcArray: the source array with srcAttrs and srcDims.\n    - A list of blockSizes, one for each dimension.\n    - 1 or more aggregate calls. Each aggregate call has an\n      AGGREGATE_FUNC, an inputAttr and a resultName. The default\n      resultName is inputAttr followed by '_' and then AGGREGATE_FUNC.\n      For instance, the default resultName for sum(sales) is\n      'sales_sum'. The count aggregate may take * as the input\n      attribute, meaning to count all the items in the group including\n      null items. The default resultName for count(*) is 'count'.\n    - 0 or numDims chunk sizes. If no chunk size is given, the chunk\n      sizes from the input dims will be used. If at least one chunk\n      size is given, the number of chunk sizes must be equal to the\n      number of dimensions, and the specified chunk sizes will be used.\n\nNotes\n-----\n\n    - Regrid does not allow a block to span chunks. So for every\n      dimension, the chunk interval needs to be a multiple of the block\n      size.", 
    "name": "regrid", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "aggregate( srcArray {, AGGREGATE_CALL}+ {, groupbyDim}* {,\n           chunkSize}* )\n            AGGREGATE_CALL := AGGREGATE_FUNC(inputAttr) [as resultName]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n\nCalculates aggregates over groups of values in an array, given the aggregate types and attributes to aggregate on.\n\nParameters\n----------\n\n    - srcArray: a source array with srcAttrs and srcDims.\n    - 1 or more aggregate calls. Each aggregate call has an\n      AGGREGATE_FUNC, an inputAttr and a resultName. The default\n      resultName is inputAttr followed by '_' and then AGGREGATE_FUNC.\n      For instance, the default resultName for sum(sales) is\n      'sales_sum'. The count aggregate may take * as the input\n      attribute, meaning to count all the items in the group including\n      null items. The default resultName for count(*) is 'count'.\n    - 0 or more dimensions that together determines the grouping\n      criteria.\n    - 0 or numGroupbyDims chunk sizes. If no chunk size is given, the\n      groupby dims will inherit chunk sizes from the input array. If at\n      least one chunk size is given, the number of chunk sizes must be\n      equal to the number of groupby dimensions, and the groupby\n      dimensions will use the specified chunk sizes.\n\nExamples\n--------\n\n    - Given array A <quantity: uint64, sales:double> [year, item] =\n       year, item, quantity, sales\n       2011, 2, 7, 31.64\n       2011, 3, 6, 19.98\n       2012, 1, 5, 41.65\n       2012, 2, 9, 40.68\n       2012, 3, 8, 26.64\n    - aggregate(A, count(*), max(quantity), sum(sales), year) <count:\n      uint64, quantity_max: uint64, sales_sum: double> [year] =\n       year, count, quantity_max, sales_sum\n       2011, 2, 7, 51.62\n       2012, 3, 9, 108.97\n\nNotes\n-----\n\n    - All the aggregate functions ignore null values, except count(*).", 
    "name": "aggregate", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "cumulate ( inputArray {, AGGREGATE_ALL}+ [, aggrDim] )\n            AGGREGATE_CALL := AGGREGATE_FUNC ( inputAttribute ) [ AS aliasName\n           ]\n            AGGREGATE_FUNC := approxdc | avg | count | max | min | sum | stdev\n           | var | some_use_defined_aggregate_function\n\nCalculates a running aggregate over some aggregate along some fluxVector (a single dimension of the inputArray).\n\nParameters\n----------\n\n       - inputArray: an input array\n       - 1 or more aggregate calls.\n       - aggrDim: the name of a dimension along with aggregates are computed.\n         Default is the first dimension.\n\nExamples\n--------\n\n      input:         cumulate(input, sum(v) as sum_v, count(*) as cnt, I)\n     +-I->\n    J|     00   01   02   03       00       01       02       03\n     V   +----+----+----+----+        +--------+--------+--------+--------+\n     00  | 01 |    | 02 |    |   00   | (1, 1) |        | (3, 2) |        |\n         +----+----+----+----+        +--------+--------+--------+--------+\n     01  |    | 03 |    | 04 |   01   |        | (3, 1) |        | (7, 2) |\n         +----+----+----+----+        +--------+--------+--------+--------+\n     02  | 05 |    | 06 |    |   02   | (5, 1) |        | (11, 2)|        |\n         +----+----+----+----+        +--------+--------+--------+--------+\n     03  |    | 07 |    | 08 |   03   |        | (7, 1) |        | (15, 2)|\n         +----+----+----+----+        +--------+--------+--------+--------+\n\nNotes\n-----\n\n    - For now, cumulate does NOT handle input array that have overlaps.", 
    "name": "cumulate", 
    "signature": [
      "array", 
      "aggregate", 
      "args"
    ]
  }, 
  {
    "doc": "uniq (input_array [,'chunk_size=CHUNK_SIZE'] )\n\nThe input array must have a single attribute of any type and a single dimension. The data in the input array must be sorted and dense. The operator is built to accept the output produced by sort() with a single attribute. The output array shall have the same attribute with the dimension i starting at 0 and chunk size of 1 million. An optional chunk_size parameter may be used to set a different output chunk size. Data is compared using a simple bitwise comparison of underlying memory. Null values are discarded from the output.\n\nParameters\n----------\n\n     array <single_attribute: INPUT_ATTRIBUTE_TYPE> [single_dimension=\n    *]\n\nExamples\n--------\n\n     uniq (sorted_array)\n     store ( uniq ( sort ( project (big_array, string_attribute) ),\n    'chuk_size=100000'), string_attribute_index )", 
    "name": "uniq", 
    "signature": [
      "array", 
      "args"
    ]
  }, 
  {
    "doc": "materialize( srcArray, format )\n\nProduces a materialized version of an source array.\n\nParameters\n----------\n\n    - srcArray: the sourcce array with srcDims and srcAttrs.\n    - format: uint32, the materialize format.", 
    "name": "_materialize", 
    "signature": [
      "array", 
      "constant"
    ]
  }
]
