INCLUDE(GET_ARCH)

MACRO( ADD_BT_COMPILER_CXXFLAGS  SBTF_BT )
  IF("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${ARGN}"  )
  ELSE("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_CXX_FLAGS_${SBTF_BT} "${CMAKE_CXX_FLAGS_${SBTF_BT}} ${ARGN}"  )
  ENDIF("${SBTF_BT}" STREQUAL "BASE")
ENDMACRO (ADD_BT_COMPILER_CXXFLAGS)

MACRO( ADD_BT_COMPILER_CFLAGS  SBTF_BT )
  IF("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${ARGN}"  )
  ELSE("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_C_FLAGS_${SBTF_BT} "${CMAKE_C_FLAGS_${SBTF_BT}} ${ARGN}"  )    
  ENDIF("${SBTF_BT}" STREQUAL "BASE")
ENDMACRO (ADD_BT_COMPILER_CFLAGS)

MACRO( ADD_BT_COMPILER_FLAGS  SBTF_BT )
  ADD_BT_COMPILER_CFLAGS( ${SBTF_BT}  ${ARGN} )
  ADD_BT_COMPILER_CXXFLAGS( ${SBTF_BT}  ${ARGN} )
ENDMACRO (ADD_BT_COMPILER_FLAGS)

MACRO( ADD_COMPILER_FLAGS  )
  IF(DEBUG)
    MESSAGE(STATUS "ADD_COMPILER_FLAGS : ${ARGN}")
  ENDIF(DEBUG)
  ADD_BT_COMPILER_FLAGS(BASE ${ARGN})
ENDMACRO (ADD_COMPILER_FLAGS)

MACRO(ADD_BT_LINK_FLAGS TARGET_TYPE SBTF_BT )
  IF("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_${TARGET_TYPE}_LINKER_FLAGS "${CMAKE_${TARGET_TYPE}_LINKER_FLAGS} ${ARGN}"  )
  ELSE("${SBTF_BT}" STREQUAL "BASE")
    STRING(REPLACE ";" " " CMAKE_${TARGET_TYPE}_LINKER_FLAGS_${SBTF_BT} "${CMAKE_${TARGET_TYPE}_LINKER_FLAGS_${SBTF_BT}} ${ARGN}"  )
  ENDIF("${SBTF_BT}" STREQUAL "BASE")
  IF(DEBUG)
    MESSAGE(STATUS "CMAKE_${TARGET_TYPE}_LINKER_FLAGS -> ${SBTF_BT} : ${CMAKE_${TARGET_TYPE}_LINKER_FLAGS_${SBTF_BT}} += ${ARGN}")
  ENDIF(DEBUG)
ENDMACRO (ADD_BT_LINK_FLAGS TARGET_TYPE SBTF_BT)

MACRO( ADD_BT_LINK_FLAGS_ALLTARGETS  SBTF_BT )
  ADD_BT_LINK_FLAGS(EXE ${SBTF_BT}  ${ARGN})
  ADD_BT_LINK_FLAGS(SHARED ${SBTF_BT} ${ARGN})
ENDMACRO (ADD_BT_LINK_FLAGS_ALLTARGETS SBTF_BT)

MACRO(ADD_LINK_FLAGS TARGET_TYPE )
  IF(${ARGC} EQUAL 1)
    MESSAGE(FATAL_ERROR "ADD_LINK_FLAGS called with empty argument list")
  ENDIF(${ARGC} EQUAL 1)
  IF(DEBUG)
    MESSAGE(STATUS "ADD_LINK_FLAGS ${TARGET_TYPE} : ${ARGN}")
  ENDIF(DEBUG)
  ADD_BT_LINK_FLAGS(${TARGET_TYPE} BASE ${ARGN})
ENDMACRO (ADD_LINK_FLAGS TARGET_TYPE)

MACRO(ADD_LINK_FLAGS_ALL_TARGETS )
  IF(DEBUG)
    MESSAGE(STATUS "ADD_LINK_FLAGS_ALL_TARGETS  : ${ARGN}")
  ENDIF(DEBUG)
  ADD_LINK_FLAGS(EXE ${ARGN})
  ADD_LINK_FLAGS(SHARED ${ARGN})
ENDMACRO (ADD_LINK_FLAGS_ALL_TARGETS)


MACRO( ADD_ARCH_FLAGS ST_AR_FL_LARCH )
  IF ("${ARCH}" MATCHES "^${ST_AR_FL_LARCH}$" )
    ADD_BT_COMPILER_FLAGS(DEBUG ${ARGN})
    ADD_BT_COMPILER_FLAGS(RELEASE ${ARGN})
    ADD_BT_COMPILER_FLAGS(PROFILE ${ARGN})
    ADD_BT_COMPILER_FLAGS(RELWITHDEBINFO ${ARGN})
  ENDIF ("${ARCH}" MATCHES "^${ST_AR_FL_LARCH}$" )
ENDMACRO (ADD_ARCH_FLAGS)

MACRO(SET_SSE_FLAGS_VAR)
  SET(SSE_FLAGS ${ARGN})
ENDMACRO(SET_SSE_FLAGS_VAR)

MACRO(PRINT_COMPILER_FLAGS)
  MESSAGE(STATUS "COMPILER_FLAGS_INIT : ${COMPILER_FLAGS_INIT}")
  MESSAGE(STATUS " -- CMAKE_CXX_FLAGS         : ${CMAKE_CXX_FLAGS}"  )
  MESSAGE(STATUS " --   _RELEASE              : ${CMAKE_CXX_FLAGS_RELEASE}"  )
  MESSAGE(STATUS " --   _DEBUG                : ${CMAKE_CXX_FLAGS_DEBUG}"  )
  MESSAGE(STATUS " --   _RELDEB               : ${CMAKE_CXX_FLAGS_RELWITHDEBINFO}"  )
  MESSAGE(STATUS " --   _PROFILE              : ${CMAKE_CXX_FLAGS_PROFILE}"  )
  MESSAGE(STATUS " -- CMAKE_C_FLAGS           : ${CMAKE_C_FLAGS}"  )
  MESSAGE(STATUS " --   _RELEASE              : ${CMAKE_C_FLAGS_RELEASE}"  )
  MESSAGE(STATUS " --   _DEBUG                : ${CMAKE_C_FLAGS_DEBUG}"  )
  MESSAGE(STATUS " --   _RELDEB               : ${CMAKE_C_FLAGS_RELWITHDEBINFO}"  )
  MESSAGE(STATUS " --   _PROFILE              : ${CMAKE_C_FLAGS_PROFILE}"  )
  MESSAGE(STATUS " -- CMAKE_EXE_LINKER_FLAGS  : ${CMAKE_EXE_LINKER_FLAGS}"  )
  MESSAGE(STATUS " --   _RELEASE              : ${CMAKE_EXE_LINKER_FLAGS_RELEASE}"  )
  MESSAGE(STATUS " --   _RELDEB               : ${CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO}"  )
  MESSAGE(STATUS " --   _DEBUG                : ${CMAKE_EXE_LINKER_FLAGS_DEBUG}"  )
  MESSAGE(STATUS " --   _PROFILE              : ${CMAKE_EXE_LINKER_FLAGS_PROFILE}"  )
  MESSAGE(STATUS " -- CMAKE_SHARED_LINKER_FLAGS: ${CMAKE_SHARED_LINKER_FLAGS}"  )
  MESSAGE(STATUS " --   _RELEASE              : ${CMAKE_SHARED_LINKER_FLAGS_RELEASE}"  )
  MESSAGE(STATUS " --   _RELDEB               : ${CMAKE_SHARED_LINKER_FLAGS_RELWITHDEBINFO}"  )
  MESSAGE(STATUS " --   _DEBUG                : ${CMAKE_SHARED_LINKER_FLAGS_DEBUG}"  )
  MESSAGE(STATUS " --   _PROFILE              : ${CMAKE_SHARED_LINKER_FLAGS_PROFILE}"  )
ENDMACRO(PRINT_COMPILER_FLAGS)